import { Component, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/controller.service";
import * as i3 from "../services/helper.service";
import * as i4 from "../forms/form.service";
export class AboutPanelComponent {
    constructor(model, controller, helper, formService) {
        this.model = model;
        this.controller = controller;
        this.helper = helper;
        this.formService = formService;
        this.year = new Date().getFullYear();
        this.top = 0;
        this.left = 0;
        this.opacity = 0;
        controller.getActionMessage().subscribe((message) => {
            if (message.action === 'About') {
                this.formService.form = { name: 'about', left: 0, top: 0, isMooving: false, level: 2 };
                this.opacity = 0;
                setTimeout(() => {
                    this.top = this.model.viewerSize.height / 2 - this.element.nativeElement.offsetHeight / 2;
                    this.left = this.model.viewerSize.width / 2 - this.element.nativeElement.offsetWidth / 2;
                    this.opacity = 1;
                });
            }
        });
    }
    ngOnInit() { }
    close() {
        this.formService.closeForm('about');
    }
    click(event) {
        if (event) {
            event.stopPropagation();
            event.preventDefault();
        }
        this.helper.openNewWindow('https://www.stimulsoft.com');
    }
    isLicensed() {
        return !this.model.options.cloudMode && !this.model.options.serverMode && !this.model.options.standaloneJsMode &&
            !this.model.options.reportDesignerMode && !this.model.options.licenseIsValid;
    }
    get userLabel() {
        let userName = this.model.options.licenseUserName || '';
        if (this.isLicensed()) {
            if (userName) {
                userName += ', ';
            }
            return userName + this.helper.getBackText(true) + ' Version';
        }
        else {
            return userName;
        }
    }
}
AboutPanelComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: AboutPanelComponent, deps: [{ token: i1.ModelService }, { token: i2.ControllerService }, { token: i3.HelperService }, { token: i4.FormService }], target: i0.ɵɵFactoryTarget.Component });
AboutPanelComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: AboutPanelComponent, selector: "sti-about-panel", viewQueries: [{ propertyName: "element", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div #element class="stiJsViewerAboutPanel" style="background-size: contain;"
      [style.display]="formService.form?.name == 'about' ? '' : 'none'"
      [style.left.px]="left"
      [style.top.px]="top"
      [style.opacity]="opacity"
      (click)="close()" >
      <div class="stiJsViewerAboutPanelHeader">
        Stimulsoft Reports
      </div>
      <img src="{{model.img('About.png')}}" style="margin-top: 30px; height: 94px; width: 94px;">
      <div class="stiJsViewerAboutPanelCopyright">
        {{'Copyright 2003-' + year + ' Stimulsoft'}}
      </div>
      <div class="stiJsViewerAboutPanelVersion">
        {{model.options.productVersion?.trim()}}, {{model.options?.frameworkType}}, Angular
      </div>
      <div class="stiJsViewerAboutPanelVersion">
        All rights reserved
      </div>
      <div class="stiJsViewerAboutPanelVersion" style="margin-top: 20px;font-weight: bold; "
        [style.color]="isLicensed() ? 'red' : '#444444'"
        [style.display]="isLicensed() || userLabel ? '' : 'none'">
        {{userLabel}}
      </div>
      <div class="stiJsViewerFormSeparator" style="margin-top: 20px;">
      </div>
      <div class="stiJsViewerAboutPanelStiLink" (click)='click($event)'>
        www.stimulsoft.com
      </div>
    </div>
  `, isInline: true });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: AboutPanelComponent, decorators: [{
            type: Component,
            args: [{
                    selector: 'sti-about-panel',
                    template: `
    <div #element class="stiJsViewerAboutPanel" style="background-size: contain;"
      [style.display]="formService.form?.name == 'about' ? '' : 'none'"
      [style.left.px]="left"
      [style.top.px]="top"
      [style.opacity]="opacity"
      (click)="close()" >
      <div class="stiJsViewerAboutPanelHeader">
        Stimulsoft Reports
      </div>
      <img src="{{model.img('About.png')}}" style="margin-top: 30px; height: 94px; width: 94px;">
      <div class="stiJsViewerAboutPanelCopyright">
        {{'Copyright 2003-' + year + ' Stimulsoft'}}
      </div>
      <div class="stiJsViewerAboutPanelVersion">
        {{model.options.productVersion?.trim()}}, {{model.options?.frameworkType}}, Angular
      </div>
      <div class="stiJsViewerAboutPanelVersion">
        All rights reserved
      </div>
      <div class="stiJsViewerAboutPanelVersion" style="margin-top: 20px;font-weight: bold; "
        [style.color]="isLicensed() ? 'red' : '#444444'"
        [style.display]="isLicensed() || userLabel ? '' : 'none'">
        {{userLabel}}
      </div>
      <div class="stiJsViewerFormSeparator" style="margin-top: 20px;">
      </div>
      <div class="stiJsViewerAboutPanelStiLink" (click)='click($event)'>
        www.stimulsoft.com
      </div>
    </div>
  `
                }]
        }], ctorParameters: function () { return [{ type: i1.ModelService }, { type: i2.ControllerService }, { type: i3.HelperService }, { type: i4.FormService }]; }, propDecorators: { element: [{
                type: ViewChild,
                args: ['element']
            }] } });
//# sourceMappingURL=data:application/json;base64,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