import { ElementRef, EventEmitter, Type } from "@angular/core";
import { StiFormSaveMode } from "../system/enums";
export declare class StiToolboxElement {
    caption: String;
    image: String;
    component: Type<any>;
    element: Type<any>;
    constructor(caption: String, image: String, component: Type<any>, element: Type<any>);
}
export declare class StiEvent {
    name: String;
    value?: any;
    constructor(name: String, value?: any);
}
export declare class StiEditorProperty {
    type: string;
    property: string;
    label: string;
    constructor(type: string, property: string, label: string);
}
export declare class Item {
    name?: string;
    caption?: string;
    imageName?: string;
    key?: any;
    haveSubMenu?: boolean;
    imageSizes?: any;
    selected?: boolean;
    type?: string;
    constructor(name?: string, caption?: string, imageName?: string, key?: any, haveSubMenu?: boolean, imageSizes?: any, selected?: boolean, type?: string);
}
export declare class MenuItem {
    name?: string;
    caption?: string;
    img?: string;
    type?: string;
    selected?: boolean;
    imageSize?: string;
    value?: any;
    constructor(name?: string, caption?: string, img?: string, type?: string, selected?: boolean, imageSize?: string, value?: any);
}
export declare class Menu {
    name: string;
    items: MenuItem[];
    parent: ElementRef;
    type: string;
    state?: string;
    menuEl?: ElementRef;
    top?: number;
    left?: number;
    innerContent?: ElementRef;
    width?: number;
    height?: number;
    menuStyleName?: string;
    verticalItems?: Item[];
    action?: EventEmitter<any>;
    itemStyleName?: string;
    value?: any;
    sizeStyle?: string;
    constructor(name: string, items: MenuItem[], parent: ElementRef, type: string, state?: string, menuEl?: ElementRef, top?: number, left?: number, innerContent?: ElementRef, width?: number, height?: number, menuStyleName?: string, verticalItems?: Item[], action?: EventEmitter<any>, itemStyleName?: string, value?: any, sizeStyle?: string);
}
export declare class StiWebFormOptions {
    localization: string;
    saveMode: StiFormSaveMode;
    form: string;
    fontFamilies: string[];
    imagesArray: any[];
    assemblyInfo: any;
    accountUserProperties: any;
    localizationList: StiLocalizationObject[];
    licenseProducts: any;
    version: string;
    creationDate: string;
    userName: string;
}
export declare class StiLocalizationObject {
    description: string;
    language: string;
    fileName: string;
    cultureName: string;
}
export declare class FormEvent {
    name: string;
    value?: any;
    constructor(name: string, value?: any);
}
export declare class UsedFont {
    fontFamily: string;
    fontStyle: string;
    fontSize: number;
    constructor(fontFamily: string, fontStyle: string, fontSize: number);
}
export declare class StiUsedFontsList {
    fonts: UsedFont[];
    add(fontFamily: string, fontStyle: string, fontSize: number): void;
}
export declare class StiInterfaceEvent {
    name: string;
    data?: any;
    constructor(name: string, data?: any);
}
