import { TieredMenu } from "primeng/tieredmenu";
import { Subject } from "rxjs";
import type { StiComponent } from "../components/sti-component";
import { StiFormElement } from "../elements/base/StiFormElement";
import { StiForm } from "../elements/StiForm";
import { StiFormPageElement } from "../elements/StiFormPageElement";
import { StiNumberBoxElement } from "../elements/StiNumberBoxElement";
import { StiPanelElement } from "../elements/StiPanelElement";
import { StiTableElement } from "../elements/StiTableElement";
import StiPadding from "../properties/StiPadding";
import type { StimulsoftFormsComponent } from "../stimulsoft-forms.component";
import { StiThousandSeparator, StiUnitAlignment } from "../system/enums";
import { StiFormattedElement } from "../system/interfaces";
import { FormEvent, StiInterfaceEvent, StiWebFormOptions } from "./objects";
import * as i0 from "@angular/core";
export declare class StiModelService {
    static PAGE_CLASS: string;
    static PANEL_CLASS: string;
    static THEMES: string[];
    private _showTrialBar;
    private _showTrialModalWindow;
    private _showTrialTitle;
    private _canCloseTrialWindow;
    get showTrialBar(): boolean;
    set showTrialBar(value: boolean);
    get showTrialModalWindow(): boolean;
    set showTrialModalWindow(value: boolean);
    get showTrialTitle(): boolean;
    set showTrialTitle(value: boolean);
    get canCloseTrialWindow(): boolean;
    set canCloseTrialWindow(value: boolean);
    component: StimulsoftFormsComponent;
    fontFamilies: any[];
    assemblyInfo: any[];
    imagesArray: any;
    lastFormState: any;
    currentRibbonValue: string;
    userName: string;
    currentEditor: any;
    currentPropertyGridMode: string;
    showFormElementsList: boolean;
    sortFormElementsList: boolean;
    showComponentsTab: boolean;
    rootFormElement: any;
    hideActiveDropdown: Subject<boolean>;
    showSignatureEditor: boolean;
    showDraggableModalWindow: boolean;
    hideActiveAutocompleteList: Subject<boolean>;
    needToSelectedComponent: Subject<StiFormElement>;
    showButtonMessageWindow: boolean;
    showTieredMenu: boolean;
    showTrialTimerWindow: boolean;
    isInitialized: boolean;
    showFileMenu: boolean;
    showFileMenuNavigation: boolean;
    showContextMenu: boolean;
    showHelpWindow: boolean;
    showSaveDialog: boolean;
    showErrorWindow: boolean;
    basePlanIsTrial: boolean;
    viewerMode: boolean;
    isCloudMode: boolean;
    disableCloseButton: boolean;
    pdfPreviewMode: boolean;
    showCornerRadius: boolean;
    showAboutWindow: boolean;
    showGroupPreview: boolean;
    showToolboxSetup: boolean;
    showModalWindow: boolean;
    showProgressAfterUpdatePage: boolean;
    canDrag: boolean;
    tieredMenuX: number;
    tieredMenuY: number;
    currentExpressionInfo: number;
    buildVersion: string;
    buildDate: string;
    errorWindowMessage: string;
    firstFormState: any;
    propertyGridWidth: number;
    pageWithGrid: StiFormPageElement;
    needToRefresh: Subject<boolean>;
    needToUpdateHelper: Subject<boolean>;
    startPdfExportEvent: Subject<boolean>;
    needToRefreshInnerProperties: Subject<boolean>;
    currentContentEditableItem: Subject<any>;
    currentContentEditableItemIndex: number;
    currentTablePropertyHeader: Subject<string>;
    retryButtonRequest: Subject<any>;
    currentUsedButtonElement: any;
    currentTableHeader: string;
    formEvents: Subject<FormEvent>;
    interfaceEvent: Subject<StiInterfaceEvent>;
    isMobileViewer: Subject<boolean>;
    lastSavedFormState: any;
    currentFormState: any;
    saveDialogFromNew: boolean;
    saveDialogFromOpen: boolean;
    addTotalMenu: TieredMenu;
    contextMenuX: number;
    contextMenuY: number;
    sendedFromButton: boolean;
    attachedFiles: any[];
    loadingFromCloud: boolean;
    showColorDialog: boolean;
    showMoreColorDialog: boolean;
    userIsAuthorized: boolean;
    userWasChecked: boolean;
    showSaveDialogFromCloud: boolean;
    settings: any;
    hasEmptyReuiredFields: boolean;
    options: StiWebFormOptions;
    showExpressionEditor: boolean;
    properties: any;
    previousPadding: StiPadding;
    previousContentAreaWidth: number;
    showProgress: boolean;
    draggingElement: StiFormElement;
    previousSelectedComponent: StiComponent;
    isWebView: boolean;
    currentSelectedFileOption: string;
    _embeddedMode: boolean;
    embeddedEvent: (data: any) => void;
    login: any;
    fileName: string;
    enteredUrls: any[];
    toggleTieredMenu(element: any): void;
    private _elementToUpdate;
    private _selectedComponent;
    private _selectedPage;
    private _lastUsedPage;
    private _zoom;
    private _form;
    private _cursor;
    private _requestUrl;
    private _isPreviewMode;
    set isPreviewMode(value: boolean);
    get isPreviewMode(): boolean;
    canDelete(): boolean;
    get showSaveToPdfButton(): boolean;
    get showEditButton(): boolean;
    set embeddedMode(value: boolean);
    get embeddedMode(): boolean;
    get cursor(): string;
    get zoom(): number;
    set requestUrl(value: string);
    get requestUrl(): string;
    set zoom(value: number);
    set cursor(value: string);
    formattingDate(dateFormat: any): any;
    setZoomFromString(zoomString: string): void;
    getPositionRelativeToForm(element: any): any;
    getBooleanSetting(settingName: string): boolean;
    isBoolean(value: any): boolean;
    isNotEmpty(value: any): boolean;
    saveLastFormState(): void;
    toCamelCase(obj: any): any;
    changeFileMenuState(): void;
    showColumnPreview(index: any, type?: string): void;
    showError(message: any, sendedFromButton?: boolean, buttonElement?: any): void;
    getImage(fileName: any): any;
    removeUnusedCells(element: StiTableElement): void;
    startPdfExport(form: string): void;
    setFormFromString(str: string, loadSavedSetings?: boolean): void;
    get form(): StiForm;
    set form(form: StiForm);
    arrayOfStylesToString(array: string[]): string;
    checkOnUniqueNames(): void;
    setUniqueName(element: any): void;
    checkNumberRange(element: StiNumberBoxElement): void;
    showTrialLog(): void;
    loadSavedSettings(): void;
    saveSettings(): void;
    isMobile(): boolean;
    getBrowserType(): any;
    getScaleWithTranslate(): string;
    getScale(): string;
    updateForm(form: StiForm): void;
    set elementToUpdate(value: StiFormElement);
    get elementToUpdate(): StiFormElement;
    get selectedComponent(): StiComponent;
    set selectedComponent(value: StiComponent);
    get selectedPage(): StiFormPageElement;
    set selectedPage(value: StiFormPageElement);
    get lastUsedPage(): StiFormPageElement;
    set lastUsedPage(value: StiFormPageElement);
    getSelectedComponentPage(): StiFormPageElement;
    getElementPage(element: StiFormElement): StiFormPageElement;
    getElementPageForScroll(element: StiFormElement): StiFormPageElement;
    overToolbar(x: number, y: number): boolean;
    getElementPanel(element: StiFormElement): StiPanelElement;
    formatNumber(value: number, format: StiThousandSeparator, decimalDigits: number, unitAlignment: StiUnitAlignment, unit: string): string;
    getFormattedValue(element: StiFormattedElement, inValue: any): any;
    formatNumberWithThousandSeparator(value: number, format: StiThousandSeparator, decimalDigits: number): string;
    getWindowScaling(): number;
    getScaling(): "" | "_x1_25" | "_x1_5" | "_x1_75" | "_x2" | "_x3" | "_x4";
    getPageFromPoint(x: number, y: number): StiFormPageElement;
    getPanelFromPoint(x: number, y: number, excludeId?: string): StiPanelElement;
    getMouseOverPagePosition(event: MouseEvent): any;
    getMouseOverPanelPosition(event: MouseEvent, excludeId?: string): any;
    loadAttachedFile(): void;
    downloadFiles(data: any, file_name: string): void;
    constructor();
    static ɵfac: i0.ɵɵFactoryDeclaration<StiModelService, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<StiModelService>;
}
