import StiPadding from "../../properties/StiPadding";
import StiRectangleGeometry from "../../properties/StiRectangleGeometry";
import StiJson from "../../system/StiJson";
import { StiChangesInterceptor, StiContainer, StiEditableContent, StiSetProperty } from "../../system/interfaces";
import StiFormObject from "./StiFormObject";
import { StiLabelItem } from "../text/StiLabelItem";
import { StiUsedFontsList } from "../../services/objects";
import { StiForm } from "../StiForm";
export declare abstract class StiFormElement extends StiFormObject implements StiChangesInterceptor, StiSetProperty {
    private _visible;
    private _geometry;
    private _padding;
    private _label;
    private _name;
    private _readOnly;
    protected _isChanged: boolean;
    render: boolean;
    position: string;
    hasGeometry: boolean;
    isAdded: boolean;
    get maxWidth(): number;
    needToSelectComponent: any;
    setDefaultValues(): void;
    isChanged(): boolean;
    getDefaultEditableContent(): StiEditableContent;
    canUpdateProperty(propName: string): boolean;
    isLabelTopAlignment(): boolean;
    getVerticalAlignment(): string;
    resetChanged(): void;
    get visible(): boolean;
    set visible(value: boolean);
    get label(): StiLabelItem;
    set label(value: StiLabelItem);
    get geometry(): StiRectangleGeometry;
    set geometry(value: StiRectangleGeometry);
    get padding(): StiPadding;
    set padding(value: StiPadding);
    get name(): string;
    set name(value: string);
    get readOnly(): boolean;
    set readOnly(value: boolean);
    get computedHeight(): number;
    get computedWidth(): number;
    get height(): number;
    set height(value: number);
    get width(): number;
    set width(value: number);
    get x(): number;
    set x(value: number);
    get y(): number;
    set y(value: number);
    hasText(): boolean;
    propertyChanged(propName: string): void;
    showLabelPlaceholder(isSelected: boolean): boolean;
    getContentAlign(): "end" | "start";
    getLabelWidth(): string;
    getTopMargin(): "0" | "8";
    setProperty(propName: string, value: any, oldObject: any): void;
    arrayOfStylesToString(array: string[]): string;
    getUsedFonts(usedFonts: StiUsedFontsList): void;
    getParent(form: StiForm): StiContainer;
    getOverPageGeometry(form: StiForm): StiRectangleGeometry;
    saveToJsonObject(options: any): StiJson;
    loadFromJsonObject(json: StiJson): void;
}
