import StiInnerBorder from "../properties/StiInnerBorder";
import { StiBorder } from "../properties/StiBorder";
import { StiUsedFontsList } from "../services/objects";
import Color from "../system/Color";
import { StiHorizontalAlignment, StiVerticalAlignment } from "../system/enums";
import { Font } from "../system/Font";
import { StiEditableContent, StiTabIndex } from "../system/interfaces";
import StiJson from "../system/StiJson";
import { StiFormElement } from "./base/StiFormElement";
import { StiColumnItem } from "./table/StiColumnItem";
import { StiRowLabel } from "./table/StiRowLabel";
import { StiTotalsFieldItem } from "./table/StiTotalsFieldItem";
import { StiTotalsRowHeaderEditableContent } from "./table/StiTotalsRowHeaderEditableContent";
import { StiTextItem } from "./text/StiTextItem";
export declare class StiTableElement extends StiFormElement implements StiEditableContent, StiTabIndex {
    type: string;
    description: StiTextItem;
    font: Font;
    border: StiBorder;
    gridLines: StiInnerBorder;
    backgroundColor: Color;
    alternateRowColors: boolean;
    evenRowsStyle: Color;
    evenRowsTextColor: Color;
    oddRowsStyle: Color;
    oddRowsTextColor: Color;
    tableHeaderText: string;
    tableHeaderAlignment: StiHorizontalAlignment;
    tableHeaderColor: Color;
    tableHeaderHeight: number;
    tableHeaderBackgroundColor: Color;
    rowLabelsWidth: number;
    private _showRowLabels;
    dynamicRows: boolean;
    useWordWrap: boolean;
    private _rowLabels;
    nativeRowLabels: string[];
    rowLabelsContentEditable: StiRowLabel[];
    rowLabelsHorizontalAlignment: StiHorizontalAlignment;
    rowHeadersBackground: Color;
    rowHeadersColor: Color;
    rowHeadersBorder: StiBorder;
    columnHeadersBorder: StiBorder;
    private _columns;
    useTotals: boolean;
    totalsRowHeader: string;
    totalsRowHeaderHorizontalAlignment: StiHorizontalAlignment;
    totalsRowHeaderVerticalAlignment: StiVerticalAlignment;
    totalsRowHeaderColor: Color;
    private _totalsValuesWidth;
    private _totalsHeadersWidth;
    totalsFields: StiTotalsFieldItem[];
    showBorderEditor: boolean;
    showGridLinesEditor: boolean;
    private _showHeaderEditor;
    private _showColumnsEditor;
    private _showRowsEditor;
    private _showTotalsEditor;
    private stopFit;
    showColumnsBorderEditor: boolean;
    showRowsBorderEditor: boolean;
    minColumnWidth: number;
    totalsRowHeaderEditableContent: StiTotalsRowHeaderEditableContent;
    tabIndex: number;
    get showRowLabels(): boolean;
    set showRowLabels(value: boolean);
    get showHeaderEditor(): boolean;
    set showHeaderEditor(value: boolean);
    get totalsValuesWidth(): number;
    set totalsValuesWidth(value: number);
    get totalsHeadersWidth(): number;
    set totalsHeadersWidth(value: number);
    get showColumnsEditor(): boolean;
    set showColumnsEditor(value: boolean);
    get showRowsEditor(): boolean;
    set showRowsEditor(value: boolean);
    get showTotalsEditor(): boolean;
    set showTotalsEditor(value: boolean);
    getDefaultEditableContent(): StiEditableContent;
    constructor();
    setTabIndex(value: number): number;
    get maxTableWidth(): number;
    set rowLabels(value: string[]);
    get rowLabels(): string[];
    setDefaultValues(): void;
    set columns(value: StiColumnItem[]);
    fitTable(): void;
    deleteLastRow(): void;
    deleteLastColumn(): void;
    addColumn(): void;
    setColumnProperty(lastColumn: any, newColumn: any): void;
    addRow(): void;
    setProperty(propName: string, value: any, oldValue: any): void;
    getUsedFonts(usedFonts: StiUsedFontsList): void;
    propertyChanged(propName: string): void;
    get columns(): StiColumnItem[];
    get eValue(): string;
    set eValue(value: string);
    get eFont(): Font;
    set eFont(value: Font);
    get eColor(): Color;
    set eColor(value: Color);
    get eBackgroundColor(): Color;
    set eBackgroundColor(value: Color);
    haveBackgoundColor(): boolean;
    get eContentAlignment(): StiHorizontalAlignment;
    set eContentAlignment(value: StiHorizontalAlignment);
    haveContentAlignment(): boolean;
    haveVerticalAlignment(): boolean;
    htmlStyle(): string;
    updateRowLabelsContentEditable(): void;
    set width(value: number);
    get width(): number;
    saveToJsonObject(options: any): StiJson;
    loadFromJsonObject(json: StiJson): void;
}
