import { StiUsedFontsList } from "../services/objects";
import Color from "../system/Color";
import { Font } from "../system/Font";
import { StiLabel, StiDescription, StiOptionsElement, StiHtmlStyle, StiValueElement, StiEditableContent, StiTabIndex } from "../system/interfaces";
import StiJson from "../system/StiJson";
import { StiFormElement } from "./base/StiFormElement";
import { StiOptionItem } from "./text/StiOptionItem";
import { StiTextItem } from "./text/StiTextItem";
export declare class StiSingleSelectionElement extends StiFormElement implements StiLabel, StiDescription, StiOptionsElement, StiHtmlStyle, StiValueElement, StiTabIndex {
    type: string;
    tooltip: string;
    required: boolean;
    description: StiTextItem;
    font: Font;
    private _columns;
    backgroundColor: Color;
    textColor: Color;
    checkColor: Color;
    borderColor: Color;
    prefix: string;
    suffix: string;
    private _options;
    nativeOptions: string[];
    optionsContentEditable: StiOptionItem[];
    useCustomOption: boolean;
    customOptionText: string;
    selectedOption: string;
    tabIndex: number;
    constructor();
    setDefaultValues(): void;
    setTabIndex(value: number): number;
    get columns(): number;
    set columns(value: number);
    set options(value: string[]);
    getUsedFonts(usedFonts: StiUsedFontsList): void;
    updateOptionsContentEditable(): void;
    getDefaultEditableContent(): StiEditableContent;
    get value(): string;
    get options(): string[];
    htmlStyle(): string;
    saveToJsonObject(options: any): StiJson;
    loadFromJsonObject(json: StiJson): void;
}
