import { Subject } from "rxjs";
import { FormEvent } from "../services/objects";
import StiJson from "../system/StiJson";
import { StiFormElement } from "./base/StiFormElement";
import { StiFormSettings } from "./settings/StiFormSettings";
import { StiFormPageElement } from "./StiFormPageElement";
import { StiAdditionalField } from "./StiAdditionalFieldItem";
export declare class StiForm {
    pages: StiFormPageElement[];
    formEvents: Subject<FormEvent>;
    private _guid;
    get guid(): string;
    private _settings;
    get settings(): StiFormSettings;
    set settings(value: StiFormSettings);
    private _reportVersion;
    private _reportName;
    private _reportGuid;
    private _reportAlias;
    private _reportCreated;
    private _reportChanged;
    private _reportImage;
    private _versionKey;
    private _userId;
    private _formName;
    private _additionalFormFields;
    addField(name: string, value: string): void;
    clearAdditionalFields(): void;
    get additionalFormFields(): StiAdditionalField[];
    get allElements(): any[];
    get formName(): string;
    set formName(value: string);
    get reportVersion(): string;
    set reportVersion(value: string);
    get reportName(): string;
    set reportName(value: string);
    get reportGuid(): string;
    set reportGuid(value: string);
    get reportAlias(): string;
    set reportAlias(value: string);
    get reportCreated(): string;
    set reportCreated(value: string);
    get reportChanged(): string;
    set reportChanged(value: string);
    get reportImage(): string;
    set reportImage(value: string);
    get versionKey(): string;
    set versionKey(value: string);
    get userId(): string;
    set userId(value: string);
    constructor();
    createTestValues(): StiJson;
    setFormValues(json: StiJson): void;
    fillElement(element: any): void;
    setValue(element: any, value: any): void;
    setTableValue(element: any, cellPath: any, value: any): void;
    getElementByName(elementName: string): StiFormElement;
    saveToJsonObject(options?: any): StiJson;
    saveToReportJsonObject(options?: any): StiJson;
    loadFormJsonString(text: string): void;
    loadFromJson(jObject: StiJson): void;
    deserializePages(jObject: StiJson): any[];
    deserializeFields(jObject: StiJson): any[];
}
