import { StiUsedFontsList } from "../services/objects";
import Color from "../system/Color";
import { StiHorizontalAlignment, StiLineWeight, StiDateTimeBoxType, StiDateTimeBoxValueChoise } from "../system/enums";
import { Font } from "../system/Font";
import { StiLabel, StiDescription, StiValueElement, StiEditableContent, StiTabIndex } from "../system/interfaces";
import StiJson from "../system/StiJson";
import { StiFormElement } from "./base/StiFormElement";
import { StiTextItem } from "./text/StiTextItem";
export declare class StiDateTimeBoxElement extends StiFormElement implements StiLabel, StiDescription, StiValueElement, StiTabIndex {
    private _dateTimeFormat;
    private _dateFomat;
    private _timeFormat;
    type: string;
    tooltip: string;
    required: boolean;
    description: StiTextItem;
    font: Font;
    contentAlignment: StiHorizontalAlignment;
    backgroundColor: Color;
    textColor: Color;
    borderColor: Color;
    borderWeight: StiLineWeight;
    valueType: StiDateTimeBoxType;
    initialState: StiDateTimeBoxValueChoise;
    allowNull: boolean;
    dateTimeValueIsNotNull: boolean;
    currentDate: Date;
    customDate: Date;
    dateValue: string;
    format: string;
    tabIndex: number;
    setDefaultValues(): void;
    get value(): string;
    get dateTimeFormat(): string;
    set dateTimeFormat(value: string);
    get dateFormat(): string;
    set dateFormat(value: string);
    get timeFormat(): string;
    set timeFormat(value: string);
    constructor();
    setTabIndex(value: number): number;
    getUsedFonts(usedFonts: StiUsedFontsList): void;
    getDefaultEditableContent(): StiEditableContent;
    htmlStyle(): string;
    saveToJsonObject(options: any): StiJson;
    loadFromJsonObject(json: StiJson): void;
}
