import { StiUsedFontsList } from "../services/objects";
import Color from "../system/Color";
import { StiHorizontalAlignment, StiLineWeight, StiVerticalAlignment } from "../system/enums";
import { Font } from "../system/Font";
import { StiLabel, StiDescription, StiEditableContent, StiOptionsElement, StiValueElement, StiTabIndex } from "../system/interfaces";
import StiJson from "../system/StiJson";
import { StiFormElement } from "./base/StiFormElement";
import { StiTextItem } from "./text/StiTextItem";
export declare class StiComboBoxElement extends StiFormElement implements StiLabel, StiDescription, StiEditableContent, StiOptionsElement, StiValueElement, StiTabIndex {
    type: string;
    tooltip: string;
    required: boolean;
    description: StiTextItem;
    font: Font;
    backgroundColor: Color;
    textColor: Color;
    borderColor: Color;
    borderWeight: StiLineWeight;
    editable: boolean;
    options: string[];
    selectedOption: string;
    tabIndex: number;
    constructor();
    setDefaultValues(): void;
    setTabIndex(value: number): number;
    eContentAlignment?: StiHorizontalAlignment;
    eVerticalAlignment?: StiVerticalAlignment;
    eParent?: any;
    getUsedFonts(usedFonts: StiUsedFontsList): void;
    getDefaultEditableContent(): StiEditableContent;
    get eFont(): Font;
    set eFont(value: Font);
    get eBackgroundColor(): Color;
    set eBackgroundColor(value: Color);
    eValue: string;
    get eColor(): Color;
    set eColor(value: Color);
    get value(): string;
    haveBackgoundColor(): boolean;
    haveContentAlignment(): boolean;
    haveVerticalAlignment(): boolean;
    htmlStyle(): string;
    saveToJsonObject(options: any): StiJson;
    loadFromJsonObject(json: StiJson): void;
}
