import { AfterViewInit, ChangeDetectorRef, ElementRef, OnDestroy, OnInit } from "@angular/core";
import { Subscription } from "rxjs";
import { StiModelService } from "../../services/model.service";
import { StiMouseService } from "../../services/mouse.service";
import { StiEditableContentService } from "../../services/sti-editable-content.service";
import { StiExpressionService } from "../../services/sti-expression.service";
import { StiLocalizationService } from "../../services/sti-localization.service";
import { StiDraggableExpressionObject, StiExpressionSample } from "../../system/interfaces";
import * as i0 from "@angular/core";
export declare class StiExpressionEditorComponent implements OnInit, OnDestroy, AfterViewInit {
    model: StiModelService;
    expressionService: StiExpressionService;
    loc: StiLocalizationService;
    mouseService: StiMouseService;
    editableService: StiEditableContentService;
    private cdr;
    elementRef: ElementRef;
    expressionString: string;
    currentSelectedMode: string;
    currentSelectedFunction: string;
    startX: number;
    startY: number;
    startComponentX: number;
    startComponentY: number;
    isDragging: boolean;
    lastCaretPosition: number;
    canDragExpression: boolean;
    dragObject: any;
    mouseUpSubscription: Subscription;
    mouseMoveSubscription: Subscription;
    expressionUpdatingSubscription: Subscription;
    arrayOfSamples: StiExpressionSample[];
    arrayOfStates: any[];
    constructor(model: StiModelService, expressionService: StiExpressionService, loc: StiLocalizationService, mouseService: StiMouseService, editableService: StiEditableContentService, cdr: ChangeDetectorRef);
    ngAfterViewInit(): void;
    ngOnDestroy(): void;
    startExpressionDragging(dragObject: any): void;
    setContent(innerText: any): void;
    checkBrackets(): boolean;
    showInfo(): void;
    addValue(element: any): void;
    changeMode(mode: any): void;
    changeCurrentFuction(func: any): void;
    startDrag(event: any): void;
    get samples(): string[];
    get title(): string;
    nestedFieldClick(field: any): void;
    get fields(): any[];
    isTable(element: any): boolean;
    haveExpression(element: any): boolean;
    addOperator(operator: string): void;
    addFunction(func: string, name?: string, filled?: boolean): void;
    insertInExpression(position: number, string: string, isOperator?: boolean, isFunction?: boolean): void;
    setCaret(insertedExpression: string, isFunction?: boolean): void;
    save(): void;
    ngOnInit(): void;
    addExpressionByDrag(expressionObject: StiDraggableExpressionObject): void;
    onMouseMove(event: any): void;
    getState(element: any): any;
    changeState(element: any): void;
    focus(): void;
    blur(): void;
    getCaret(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<StiExpressionEditorComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<StiExpressionEditorComponent, "sti-expression-editor", never, {}, {}, never, never, false>;
}
