import { OnDestroy, OnInit } from "@angular/core";
import { Observable, Subscription } from "rxjs";
import { StiFormElement } from "../elements/base/StiFormElement";
import { StiBorderArea } from "../properties/StiBorderArea";
import { StiModelService } from "../services/model.service";
import { StiMouseService } from "../services/mouse.service";
import { StiComponentResizerService } from "../services/sti-component-resizer.service";
import { StiDraggableService } from "../services/sti-draggable.service";
import { StiHelperService } from "../services/sti-helper.service";
import { StiNameService } from "../services/sti-name.service";
import { SignatureService } from "../services/sti-signature.service";
import * as i0 from "@angular/core";
export declare class StiComponent implements OnInit, OnDestroy {
    model?: StiModelService;
    draggableService?: StiDraggableService;
    mouseService?: StiMouseService;
    helper?: StiHelperService;
    nameService?: StiNameService;
    resizer?: StiComponentResizerService;
    signatureService?: SignatureService;
    mouseUpSubscription: Subscription;
    mouseMoveSubscription: Subscription;
    needToSelectedSubscription: Subscription;
    element: StiFormElement;
    class: string;
    isClone: boolean;
    borderArea?: StiBorderArea;
    private subject;
    private elementPage;
    hover: boolean;
    canDrag: boolean;
    mouseDownX: number;
    mouseDownY: number;
    layerX: number;
    layerY: number;
    constructor(model?: StiModelService, draggableService?: StiDraggableService, mouseService?: StiMouseService, helper?: StiHelperService, nameService?: StiNameService, resizer?: StiComponentResizerService, signatureService?: SignatureService);
    ngOnDestroy(): void;
    get borderInnerWidth(): Number;
    get borderInnerHeight(): Number;
    haveAreaContainer(): boolean;
    get overflow(): "" | "hidden";
    get className(): string;
    get direction(): "column" | "row";
    get computedX(): number;
    get cursor(): string;
    get computedY(): number;
    get width(): string;
    get height(): string;
    get position(): string;
    get align(): "center" | "normal";
    getMessage(): Observable<any>;
    withoutBorder(): boolean;
    onMouseMove(event: MouseEvent): void;
    onMouseDown(event: MouseEvent): void;
    ngOnInit(): void;
    static ɵfac: i0.ɵɵFactoryDeclaration<StiComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<StiComponent, "sti-component", never, { "element": "element"; "class": "class"; "isClone": "isClone"; "borderArea": "borderArea"; }, {}, never, ["*"], false>;
}
