import * as i0 from '@angular/core';
import { Injectable, Component, Input, ViewChild, Directive, EventEmitter, Output, TemplateRef, ContentChild, HostListener, NgModule } from '@angular/core';
import { camelCase, indexOf } from 'lodash';
import { Subject, Observable, throwError } from 'rxjs';
import { first, timeout, catchError } from 'rxjs/operators';
import * as i1 from '@angular/common/http';
import { HttpClientModule } from '@angular/common/http';
import * as i5 from '@angular/common';
import { DatePipe, CommonModule } from '@angular/common';
import * as i4 from '@angular/forms';
import { FormsModule } from '@angular/forms';
import { trigger, state, style, transition, animate, group } from '@angular/animations';
import ResizeObserver from 'resize-observer-polyfill';
import * as i2 from '@angular/platform-browser';
import { BrowserModule } from '@angular/platform-browser';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';

/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
class Color {
    constructor() {
        this.propertyName = "color";
        this.name = Color.customName;
    }
    static aliceBlue() {
        let color = Color.fromArgb(0xf0, 0xf8, 0xff);
        color.name = "Alice Blue";
        return color;
    }
    static antiqueWhite() {
        let color = Color.fromArgb(0xfa, 0xeb, 0xd7);
        color.name = "Antique White";
        return color;
    }
    static aqua() {
        let color = Color.fromArgb(0x00, 0xff, 0xff);
        color.name = "Aqua";
        return color;
    }
    static aquamarine() {
        let color = Color.fromArgb(0x7f, 0xff, 0xd4);
        color.name = "Aquamarine";
        return color;
    }
    static azure() {
        let color = Color.fromArgb(0xf0, 0xff, 0xff);
        color.name = "Azure";
        return color;
    }
    static beige() {
        let color = Color.fromArgb(0xf5, 0xf5, 0xdc);
        color.name = "Beige";
        return color;
    }
    static bisque() {
        let color = Color.fromArgb(0xff, 0xe4, 0xc4);
        color.name = "Bisque";
        return color;
    }
    static black() {
        let color = Color.fromArgb(0x00, 0x00, 0x00);
        color.name = "Black";
        return color;
    }
    static blanchedAlmond() {
        let color = Color.fromArgb(0xff, 0xeb, 0xcd);
        color.name = "Blanched Almond";
        return color;
    }
    static blue() {
        let color = Color.fromArgb(0x00, 0x00, 0xff);
        color.name = "Blue";
        return color;
    }
    static blueViolet() {
        let color = Color.fromArgb(0x8a, 0x2b, 0xe2);
        color.name = "Blue Violet";
        return color;
    }
    static brown() {
        let color = Color.fromArgb(0xa5, 0x2a, 0x2a);
        color.name = "Brown";
        return color;
    }
    static burlyWood() {
        let color = Color.fromArgb(0xde, 0xb8, 0x87);
        color.name = "Burly Wood";
        return color;
    }
    static cadetBlue() {
        let color = Color.fromArgb(0x5f, 0x9e, 0xa0);
        color.name = "Cadet Blue";
        return color;
    }
    static chartreuse() {
        let color = Color.fromArgb(0x7f, 0xff, 0x00);
        color.name = "Chartreuse";
        return color;
    }
    static chocolate() {
        let color = Color.fromArgb(0xd2, 0x69, 0x1e);
        color.name = "Chocolate";
        return color;
    }
    static coral() {
        let color = Color.fromArgb(0xff, 0x7f, 0x50);
        color.name = "Coral";
        return color;
    }
    static cornflowerBlue() {
        let color = Color.fromArgb(0x64, 0x95, 0xed);
        color.name = "Cornflower Blue";
        return color;
    }
    static cornsilk() {
        let color = Color.fromArgb(0xff, 0xf8, 0xdc);
        color.name = "Cornsilk";
        return color;
    }
    static crimson() {
        let color = Color.fromArgb(0xdc, 0x14, 0x3c);
        color.name = "Crimson";
        return color;
    }
    static cyan() {
        let color = Color.fromArgb(0x00, 0xff, 0xff);
        color.name = "Cyan";
        return color;
    }
    static darkBlue() {
        let color = Color.fromArgb(0x00, 0x00, 0x8b);
        color.name = "Dark Blue";
        return color;
    }
    static darkCyan() {
        let color = Color.fromArgb(0x00, 0x8b, 0x8b);
        color.name = "Dark Cyan";
        return color;
    }
    static darkGoldenrod() {
        let color = Color.fromArgb(0xb8, 0x86, 0x0b);
        color.name = "Dark Goldenrod";
        return color;
    }
    static darkGray() {
        let color = Color.fromArgb(0xa9, 0xa9, 0xa9);
        color.name = "Dark Gray";
        return color;
    }
    static darkGreen() {
        let color = Color.fromArgb(0x00, 0x64, 0x00);
        color.name = "Dark Green";
        return color;
    }
    static darkKhaki() {
        let color = Color.fromArgb(0xbd, 0xb7, 0x6b);
        color.name = "Dark Khaki";
        return color;
    }
    static darkMagenta() {
        let color = Color.fromArgb(0x8b, 0x00, 0x8b);
        color.name = "Dark Magenta";
        return color;
    }
    static darkOliveGreen() {
        let color = Color.fromArgb(0x55, 0x6b, 0x2f);
        color.name = "Dark Olive Green";
        return color;
    }
    static darkOrange() {
        let color = Color.fromArgb(0xff, 0x8c, 0x00);
        color.name = "Dark Orange";
        return color;
    }
    static darkOrchid() {
        let color = Color.fromArgb(0x99, 0x32, 0xcc);
        color.name = "Dark Orchid";
        return color;
    }
    static darkRed() {
        let color = Color.fromArgb(0x8b, 0x00, 0x00);
        color.name = "Dark Red";
        return color;
    }
    static darkSalmon() {
        let color = Color.fromArgb(0xe9, 0x96, 0x7a);
        color.name = "Dark Salmon";
        return color;
    }
    static darkSeaGreen() {
        let color = Color.fromArgb(0x8f, 0xbc, 0x8f);
        color.name = "Dark Sea Green";
        return color;
    }
    static darkSlateBlue() {
        let color = Color.fromArgb(0x48, 0x3d, 0x8b);
        color.name = "Dark Slate Blue";
        return color;
    }
    static darkSlateGray() {
        let color = Color.fromArgb(0x2f, 0x4f, 0x4f);
        color.name = "Dark Slate Gray";
        return color;
    }
    static darkTurquoise() {
        let color = Color.fromArgb(0x00, 0xce, 0xd1);
        color.name = "Dark Turquoise";
        return color;
    }
    static darkViolet() {
        let color = Color.fromArgb(0x94, 0x00, 0xd3);
        color.name = "Dark Violet";
        return color;
    }
    static deepPink() {
        let color = Color.fromArgb(0xff, 0x14, 0x93);
        color.name = "Deep Pink";
        return color;
    }
    static deepSkyBlue() {
        let color = Color.fromArgb(0x00, 0xbf, 0xff);
        color.name = "Deep Sky Blue";
        return color;
    }
    static dimGray() {
        let color = Color.fromArgb(0x69, 0x69, 0x69);
        color.name = "Dim Gray";
        return color;
    }
    static dodgerBlue() {
        let color = Color.fromArgb(0x1e, 0x90, 0xff);
        color.name = "Dodger Blue";
        return color;
    }
    static firebrick() {
        let color = Color.fromArgb(0xb2, 0x22, 0x22);
        color.name = "Firebrick";
        return color;
    }
    static floralWhite() {
        let color = Color.fromArgb(0xff, 0xfa, 0xf0);
        color.name = "Floral White";
        return color;
    }
    static forestGreen() {
        let color = Color.fromArgb(0x22, 0x8b, 0x22);
        color.name = "Forest Green";
        return color;
    }
    static fuchsia() {
        let color = Color.fromArgb(0xff, 0x00, 0xff);
        color.name = "Fuchsia";
        return color;
    }
    static gainsboro() {
        let color = Color.fromArgb(0xdc, 0xdc, 0xdc);
        color.name = "Gainsboro";
        return color;
    }
    static ghostWhite() {
        let color = Color.fromArgb(0xf8, 0xf8, 0xff);
        color.name = "Ghost White";
        return color;
    }
    static gold() {
        let color = Color.fromArgb(0xff, 0xd7, 0x00);
        color.name = "Gold";
        return color;
    }
    static goldenrod() {
        let color = Color.fromArgb(0xda, 0xa5, 0x20);
        color.name = "Goldenrod";
        return color;
    }
    static gray() {
        let color = Color.fromArgb(0x80, 0x80, 0x80);
        color.name = "Gray";
        return color;
    }
    static green() {
        let color = Color.fromArgb(0x00, 0x80, 0x00);
        color.name = "Green";
        return color;
    }
    static greenYellow() {
        let color = Color.fromArgb(0xad, 0xff, 0x2f);
        color.name = "Green Yellow";
        return color;
    }
    static honeydew() {
        let color = Color.fromArgb(0xf0, 0xff, 0xf0);
        color.name = "Honeydew";
        return color;
    }
    static hotPink() {
        let color = Color.fromArgb(0xff, 0x69, 0xb4);
        color.name = "Hot Pink";
        return color;
    }
    static indianRed() {
        let color = Color.fromArgb(0xcd, 0x5c, 0x5c);
        color.name = "Indian Red";
        return color;
    }
    static indigo() {
        let color = Color.fromArgb(0x4b, 0x00, 0x82);
        color.name = "Indigo";
        return color;
    }
    static ivory() {
        let color = Color.fromArgb(0xff, 0xff, 0xf0);
        color.name = "Ivory";
        return color;
    }
    static khaki() {
        let color = Color.fromArgb(0xf0, 0xe6, 0x8c);
        color.name = "Khaki";
        return color;
    }
    static lavender() {
        let color = Color.fromArgb(0xe6, 0xe6, 0xfa);
        color.name = "Lavender";
        return color;
    }
    static lavenderBlush() {
        let color = Color.fromArgb(0xff, 0xf0, 0xf5);
        color.name = "Lavender Blush";
        return color;
    }
    static lawnGreen() {
        let color = Color.fromArgb(0x7c, 0xfc, 0x00);
        color.name = "Lawn Green";
        return color;
    }
    static lemonChiffon() {
        let color = Color.fromArgb(0xff, 0xfa, 0xcd);
        color.name = "Lemon Chiffon";
        return color;
    }
    static lightBlue() {
        let color = Color.fromArgb(0xad, 0xd8, 0xe6);
        color.name = "Light Blue";
        return color;
    }
    static lightCoral() {
        let color = Color.fromArgb(0xf0, 0x80, 0x80);
        color.name = "Light Coral";
        return color;
    }
    static lightCyan() {
        let color = Color.fromArgb(0xe0, 0xff, 0xff);
        color.name = "Light Cyan";
        return color;
    }
    static lightGoldenrodYellow() {
        let color = Color.fromArgb(0xfa, 0xfa, 0xd2);
        color.name = "Light Goldenrod Yellow";
        return color;
    }
    static lightGray() {
        let color = Color.fromArgb(0xd3, 0xd3, 0xd3);
        color.name = "Light Gray";
        return color;
    }
    static lightGreen() {
        let color = Color.fromArgb(0x90, 0xee, 0x90);
        color.name = "Light Green";
        return color;
    }
    static lightPink() {
        let color = Color.fromArgb(0xff, 0xb6, 0xc1);
        color.name = "Light Pink";
        return color;
    }
    static lightSalmon() {
        let color = Color.fromArgb(0xff, 0xa0, 0x7a);
        color.name = "Light Salmon";
        return color;
    }
    static lightSeaGreen() {
        let color = Color.fromArgb(0x20, 0xb2, 0xaa);
        color.name = "Light Sea Green";
        return color;
    }
    static lightSkyBlue() {
        let color = Color.fromArgb(0x87, 0xce, 0xfa);
        color.name = "Light Sky Blue";
        return color;
    }
    static lightSlateGray() {
        let color = Color.fromArgb(0x77, 0x88, 0x99);
        color.name = "Light Slate Gray";
        return color;
    }
    static lightSteelBlue() {
        let color = Color.fromArgb(0xb0, 0xc4, 0xde);
        color.name = "Light Steel Blue";
        return color;
    }
    static lightYellow() {
        let color = Color.fromArgb(0xff, 0xff, 0xe0);
        color.name = "Light Yellow";
        return color;
    }
    static lime() {
        let color = Color.fromArgb(0x00, 0xff, 0x00);
        color.name = "Lime";
        return color;
    }
    static limeGreen() {
        let color = Color.fromArgb(0x32, 0xcd, 0x32);
        color.name = "Lime Green";
        return color;
    }
    static linen() {
        let color = Color.fromArgb(0xfa, 0xf0, 0xe6);
        color.name = "Linen";
        return color;
    }
    static magenta() {
        let color = Color.fromArgb(0xff, 0x00, 0xff);
        color.name = "Magenta";
        return color;
    }
    static maroon() {
        let color = Color.fromArgb(0x80, 0x00, 0x00);
        color.name = "Maroon";
        return color;
    }
    static mediumAquamarine() {
        let color = Color.fromArgb(0x66, 0xcd, 0xaa);
        color.name = "Medium Aquamarine";
        return color;
    }
    static mediumBlue() {
        let color = Color.fromArgb(0x00, 0x00, 0xcd);
        color.name = "Medium Blue";
        return color;
    }
    static mediumOrchid() {
        let color = Color.fromArgb(0xba, 0x55, 0xd3);
        color.name = "Medium Orchid";
        return color;
    }
    static mediumPurple() {
        let color = Color.fromArgb(0x93, 0x70, 0xdb);
        color.name = "Medium Purple";
        return color;
    }
    static mediumSeaGreen() {
        let color = Color.fromArgb(0x3c, 0xb3, 0x71);
        color.name = "Medium Sea Green";
        return color;
    }
    static mediumSlateBlue() {
        let color = Color.fromArgb(0x7b, 0x68, 0xee);
        color.name = "Medium Slate Blue";
        return color;
    }
    static mediumSpringGreen() {
        let color = Color.fromArgb(0x00, 0xfa, 0x9a);
        color.name = "Medium Spring Green";
        return color;
    }
    static mediumTurquoise() {
        let color = Color.fromArgb(0x48, 0xd1, 0xcc);
        color.name = "Medium Turquoise";
        return color;
    }
    static mediumVioletRed() {
        let color = Color.fromArgb(0xc7, 0x15, 0x85);
        color.name = "Medium Violet Red";
        return color;
    }
    static midnightBlue() {
        let color = Color.fromArgb(0x19, 0x19, 0x70);
        color.name = "Midnight Blue";
        return color;
    }
    static mintCream() {
        let color = Color.fromArgb(0xf5, 0xff, 0xfa);
        color.name = "Mint Cream";
        return color;
    }
    static mistyRose() {
        let color = Color.fromArgb(0xff, 0xe4, 0xe1);
        color.name = "Misty Rose";
        return color;
    }
    static moccasin() {
        let color = Color.fromArgb(0xff, 0xe4, 0xb5);
        color.name = "Moccasin";
        return color;
    }
    static navajoWhite() {
        let color = Color.fromArgb(0xff, 0xde, 0xad);
        color.name = "Navajo White";
        return color;
    }
    static navy() {
        let color = Color.fromArgb(0x00, 0x00, 0x80);
        color.name = "Navy";
        return color;
    }
    static oldLace() {
        let color = Color.fromArgb(0xfd, 0xf5, 0xe6);
        color.name = "Old Lace";
        return color;
    }
    static olive() {
        let color = Color.fromArgb(0x80, 0x80, 0x00);
        color.name = "Olive";
        return color;
    }
    static oliveDrab() {
        let color = Color.fromArgb(0x6b, 0x8e, 0x23);
        color.name = "Olive Drab";
        return color;
    }
    static orange() {
        let color = Color.fromArgb(0xff, 0xa5, 0x00);
        color.name = "Orange";
        return color;
    }
    static orangeRed() {
        let color = Color.fromArgb(0xff, 0x45, 0x00);
        color.name = "Orange Red";
        return color;
    }
    static orchid() {
        let color = Color.fromArgb(0xda, 0x70, 0xd6);
        color.name = "Orchid";
        return color;
    }
    static paleGoldenrod() {
        let color = Color.fromArgb(0xee, 0xe8, 0xaa);
        color.name = "Pale Goldenrod";
        return color;
    }
    static paleGreen() {
        let color = Color.fromArgb(0x98, 0xfb, 0x98);
        color.name = "Pale Green";
        return color;
    }
    static paleTurquoise() {
        let color = Color.fromArgb(0xaf, 0xee, 0xee);
        color.name = "Pale Turquoise";
        return color;
    }
    static paleVioletRed() {
        let color = Color.fromArgb(0xdb, 0x70, 0x93);
        color.name = "Pale Violet Red";
        return color;
    }
    static papayaWhip() {
        let color = Color.fromArgb(0xff, 0xef, 0xd5);
        color.name = "Papaya Whip";
        return color;
    }
    static peachPuff() {
        let color = Color.fromArgb(0xff, 0xda, 0xb9);
        color.name = "Peach Puff";
        return color;
    }
    static peru() {
        let color = Color.fromArgb(0xcd, 0x85, 0x3f);
        color.name = "Peru";
        return color;
    }
    static pink() {
        let color = Color.fromArgb(0xff, 0xc0, 0xcb);
        color.name = "Pink";
        return color;
    }
    static plum() {
        let color = Color.fromArgb(0xdd, 0xa0, 0xdd);
        color.name = "Plum";
        return color;
    }
    static powderBlue() {
        let color = Color.fromArgb(0xb0, 0xe0, 0xe6);
        color.name = "Powder Blue";
        return color;
    }
    static purple() {
        let color = Color.fromArgb(0x80, 0x00, 0x80);
        color.name = "Purple";
        return color;
    }
    static red() {
        let color = Color.fromArgb(0xff, 0x00, 0x00);
        color.name = "Red";
        return color;
    }
    static rosyBrown() {
        let color = Color.fromArgb(0xbc, 0x8f, 0x8f);
        color.name = "Rosy Brown";
        return color;
    }
    static royalBlue() {
        let color = Color.fromArgb(0x41, 0x69, 0xe1);
        color.name = "Royal Blue";
        return color;
    }
    static saddleBrown() {
        let color = Color.fromArgb(0x8b, 0x45, 0x13);
        color.name = "Saddle Brown";
        return color;
    }
    static salmon() {
        let color = Color.fromArgb(0xfa, 0x80, 0x72);
        color.name = "Salmon";
        return color;
    }
    static sandyBrown() {
        let color = Color.fromArgb(0xf4, 0xa4, 0x60);
        color.name = "Sandy Brown";
        return color;
    }
    static seaGreen() {
        let color = Color.fromArgb(0x2e, 0x8b, 0x57);
        color.name = "Sea Green";
        return color;
    }
    static seaShell() {
        let color = Color.fromArgb(0xff, 0xf5, 0xee);
        color.name = "Sea Shell";
        return color;
    }
    static sienna() {
        let color = Color.fromArgb(0xa0, 0x52, 0x2d);
        color.name = "Sienna";
        return color;
    }
    static silver() {
        let color = Color.fromArgb(0xc0, 0xc0, 0xc0);
        color.name = "Silver";
        return color;
    }
    static skyBlue() {
        let color = Color.fromArgb(0x87, 0xce, 0xeb);
        color.name = "Sky Blue";
        return color;
    }
    static slateBlue() {
        let color = Color.fromArgb(0x6a, 0x5a, 0xcd);
        color.name = "Slate Blue";
        return color;
    }
    static slateGray() {
        let color = Color.fromArgb(0x70, 0x80, 0x90);
        color.name = "Slate Gray";
        return color;
    }
    static snow() {
        let color = Color.fromArgb(0xff, 0xfa, 0xfa);
        color.name = "Snow";
        return color;
    }
    static springGreen() {
        let color = Color.fromArgb(0x00, 0xff, 0x7f);
        color.name = "Spring Green";
        return color;
    }
    static steelBlue() {
        let color = Color.fromArgb(0x46, 0x82, 0xb4);
        color.name = "Steel Blue";
        return color;
    }
    static tan() {
        let color = Color.fromArgb(0xd2, 0xb4, 0x8c);
        color.name = "Tan";
        return color;
    }
    static teal() {
        let color = Color.fromArgb(0x00, 0x80, 0x80);
        color.name = "Teal";
        return color;
    }
    static thistle() {
        let color = Color.fromArgb(0xd8, 0xbf, 0xd8);
        color.name = "Thistle";
        return color;
    }
    static tomato() {
        let color = Color.fromArgb(0xff, 0x63, 0x47);
        color.name = "Tomato";
        return color;
    }
    static turquoise() {
        let color = Color.fromArgb(0x40, 0xe0, 0xd0);
        color.name = "Turquoise";
        return color;
    }
    static violet() {
        let color = Color.fromArgb(0xee, 0x82, 0xee);
        color.name = "Violet";
        return color;
    }
    static wheat() {
        let color = Color.fromArgb(0xf5, 0xde, 0xb3);
        color.name = "Wheat";
        return color;
    }
    static white() {
        let color = Color.fromArgb(0xff, 0xff, 0xff);
        color.name = "White";
        return color;
    }
    static whiteSmoke() {
        let color = Color.fromArgb(0xf5, 0xf5, 0xf5);
        color.name = "White Smoke";
        return color;
    }
    static yellow() {
        let color = Color.fromArgb(0xff, 0xff, 0x00);
        color.name = "Yellow";
        return color;
    }
    static yellowGreen() {
        let color = Color.fromArgb(0x9a, 0xcd, 0x32);
        color.name = "Yellow Green";
        return color;
    }
    static transparent() {
        let color = Color.fromArgb(0x00, 0xff, 0xff, 0xff);
        color.name = "Transparent";
        return color;
    }
    static empty() {
        let color = Color.fromArgb(0x00, 0xff, 0xff, 0xff);
        color.name = "Empty";
        return color;
    }
    static fromName(name) {
        name = name.replace(/ /gi, "");
        if (this.isNullOrEmpty(name)) {
            return null; // Color.empty;
        }
        name = name.charAt(0).toLowerCase() + name.substr(1);
        let color = Color[name];
        if (color && typeof color == "function") {
            return color();
        }
        return null; //Color.empty;
    }
    static isNullOrEmpty(value) {
        return value == null || value === "" || value === undefined;
    }
    clone() {
        let color = new Color();
        color.r = this.r;
        color.g = this.g;
        color.b = this.b;
        color.a = this._a;
        color.name = this.name;
        return color;
    }
    isChanged() {
        return this.savedColor == null || !this.savedColor.equals(this);
    }
    resetChanged() {
        this.savedColor = this.clone();
    }
    get a() {
        return this._a;
    }
    set a(value) {
        this._a = value;
        this.name = Color.customName;
    }
    get r() {
        return this._r;
    }
    set r(value) {
        this._r = value;
        this.name = Color.customName;
    }
    get g() {
        return this._g;
    }
    set g(value) {
        this._g = value;
        this.name = Color.customName;
    }
    get b() {
        return this._b;
    }
    set b(value) {
        this._b = value;
        this.name = Color.customName;
    }
    get isNamedColor() {
        return this.name != Color.customName;
    }
    equals(color) {
        if (color != null) {
            if ((color._a == 0x00 && color._r == 0xff && color._g == 0xff && color._b == 0xff) ||
                (this._a == 0x00 && this._r == 0xff && this._g == 0xff && this._b == 0xff))
                return this._a == color._a;
            else
                return this._a == color._a && this._r == color._r && this._g == color._g && this._b == color._b;
        }
        return false;
    }
    static fromArgb(alpha, red, green, blue) {
        if (typeof red == "undefined") {
            blue = alpha & 0xff;
            green = (alpha >> 8) & 0xff;
            red = (alpha >> 16) & 0xff;
            alpha = (alpha >> 24) & 0xff;
        }
        else if (typeof green == "undefined") {
            blue = red._b;
            green = red._g;
            red = red._r;
        }
        else if (typeof blue == "undefined") {
            blue = green;
            green = red;
            red = alpha;
            alpha = 255;
        }
        let color = new Color();
        color._a = alpha;
        color._r = red;
        color._g = green;
        color._b = blue;
        color.name = Color.customName;
        return color;
    }
    toArgb() {
        let argb = this._a << 24;
        argb += this._r << 16;
        argb += this._g << 8;
        argb += this._b;
        return argb;
    }
    componentToHex(c) {
        let hex = c.toString(16);
        return hex.length == 1 ? "0" + hex : hex;
    }
    getHashCode() {
        return this.toArgb();
    }
    toHtmlColor() {
        return `rgba(${this.r}, ${this.g}, ${this.b}, ${Math.round((100 * this.a) / 255) / 100})`;
    }
    toHexColor() {
        return "#" + this.componentToHex(this.r) + this.componentToHex(this.g) + this.componentToHex(this.b);
    }
    get hexColor() {
        return this.toHtmlColor();
    }
    getStringName() {
        if (this.a == 0) {
            return "Transparent";
        }
        else {
            return `${this.a != 255 ? this.a + "," : ""}${this.r + ","}${this.g + ","}${this.b}`;
        }
    }
    set hexColor(value) {
        let oldColor = this.changesInterceptor ? this.clone() : null;
        let num = parseInt(value.substring(1), 16);
        if (num || num == 0) {
            this.b = num & 0xff;
            this.g = (num >> 8) & 0xff;
            this.r = (num >> 16) & 0xff;
            this.a = 255;
        }
        else {
            let num = value.replace("rgba(", "").replace(")", "");
            let array = num.split(",");
            this.r = isNaN(Number(array[0])) ? 0 : Number(array[0]);
            this.g = isNaN(Number(array[1])) ? 0 : Number(array[1]);
            this.b = isNaN(Number(array[2])) ? 0 : Number(array[2]);
            this.a = isNaN(Math.round(255 * Number(array[3]))) ? 255 : Math.round(255 * Number(array[3]));
        }
        this.name = Color.customName;
        if (this.changesInterceptor) {
            this.changesInterceptor.propertyChanged(this.propertyName, this.clone(), oldColor);
        }
    }
    toString() {
        return this.name != Color.customName ? this.name : this.hexColor;
    }
    deserializeFromString(value) {
        let result;
        if (value.indexOf(",") != -1) {
            let strs = value.split(",");
            if (strs.length == 4) {
                result = Color.fromArgb(parseFloat(strs[0].trim()), parseFloat(strs[1].trim()), parseFloat(strs[2].trim()), parseFloat(strs[3].trim()));
            }
            else {
                result = Color.fromArgb(parseFloat(strs[0].trim()), parseFloat(strs[1].trim()), parseFloat(strs[2].trim()));
            }
        }
        else if (value.indexOf("[") == 0 && value.indexOf("]") == value.length - 1 && value.indexOf(":") != -1) {
            let strs = value.substring(1, value.length - 1).split(":");
            if (strs.length == 4) {
                result = Color.fromArgb(parseFloat(strs[0].trim()), parseFloat(strs[1].trim()), parseFloat(strs[2].trim()), parseFloat(strs[3].trim()));
            }
            else {
                result = Color.fromArgb(parseFloat(strs[0].trim()), parseFloat(strs[1].trim()), parseFloat(strs[2].trim()));
            }
        }
        else {
            result = Color.fromName(value);
        }
        this._r = result._r;
        this._b = result._b;
        this._g = result._g;
        this._a = result._a;
        this.name = result.name;
    }
}
Color.customName = "Custom";

/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
var UnicodeCategory;
(function (UnicodeCategory) {
    /**
     * Uppercase letter. Signified by the Unicode designation "Lu" (letter, uppercase).
     * The value is 0.
     */
    UnicodeCategory[UnicodeCategory["UppercaseLetter"] = 0] = "UppercaseLetter";
    /**
     * Lowercase letter. Signified by the Unicode designation "Ll" (letter, lowercase).
     * The value is 1.
     */
    UnicodeCategory[UnicodeCategory["LowercaseLetter"] = 1] = "LowercaseLetter";
    /**
     * Titlecase letter. Signified by the Unicode designation "Lt" (letter, titlecase).
     * The value is 2.
     */
    UnicodeCategory[UnicodeCategory["TitlecaseLetter"] = 2] = "TitlecaseLetter";
    /**
     * Modifier letter character, which is free-standing spacing character that
     * indicates modifications of a preceding letter. Signified by the Unicode designation
     * "Lm" (letter, modifier). The value is 3.
     */
    UnicodeCategory[UnicodeCategory["ModifierLetter"] = 3] = "ModifierLetter";
    /**
     * Letter that is not an uppercase letter, a lowercase letter, a titlecase letter,
     * or a modifier letter. Signified by the Unicode designation "Lo" (letter,
     * other). The value is 4.
     */
    UnicodeCategory[UnicodeCategory["OtherLetter"] = 4] = "OtherLetter";
    /**
     * Nonspacing character that indicates modifications of a base character. Signified
     * by the Unicode designation "Mn" (mark, nonspacing). The value is 5.
     */
    UnicodeCategory[UnicodeCategory["NonSpacingMark"] = 5] = "NonSpacingMark";
    /**
     * Spacing character that indicates modifications of a base character and affects
     * the width of the glyph for that base character. Signified by the Unicode
     * designation "Mc" (mark, spacing combining). The value is 6.
     */
    UnicodeCategory[UnicodeCategory["SpacingCombiningMark"] = 6] = "SpacingCombiningMark";
    /**
     * Enclosing mark character, which is a nonspacing combining character that
     * surrounds all previous characters up to and including a base character. Signified
     * by the Unicode designation "Me" (mark, enclosing). The value is 7.
     */
    UnicodeCategory[UnicodeCategory["EnclosingMark"] = 7] = "EnclosingMark";
    /**
     * Decimal digit character, that is, a character in the range 0 through 9. Signified
     * by the Unicode designation "Nd" (number, decimal digit). The value is 8.
     */
    UnicodeCategory[UnicodeCategory["DecimalDigitNumber"] = 8] = "DecimalDigitNumber";
    /**
     * Number represented by a letter, instead of a decimal digit, for example,
     * the Roman numeral for five, which is "V". The indicator is signified by the
     * Unicode designation "Nl" (number, letter). The value is 9.
     */
    UnicodeCategory[UnicodeCategory["LetterNumber"] = 9] = "LetterNumber";
    /**
     * Number that is neither a decimal digit nor a letter number, for example,
     * the fraction 1/2. The indicator is signified by the Unicode designation "No"
     * (number, other). The value is 10.
     */
    UnicodeCategory[UnicodeCategory["OtherNumber"] = 10] = "OtherNumber";
    /**
     * Space character, which has no glyph but is not a control or format character.
     * Signified by the Unicode designation "Zs" (separator, space). The value is 11.
     */
    UnicodeCategory[UnicodeCategory["SpaceSeparator"] = 11] = "SpaceSeparator";
    /**
     * Character that is used to separate lines of text. Signified by the Unicode
     * designation "Zl" (separator, line). The value is 12.
     */
    UnicodeCategory[UnicodeCategory["LineSeparator"] = 12] = "LineSeparator";
    /**
     * Character used to separate paragraphs. Signified by the Unicode designation
     * "Zp" (separator, paragraph). The value is 13.
     */
    UnicodeCategory[UnicodeCategory["ParagraphSeparator"] = 13] = "ParagraphSeparator";
    /**
     * Control code character, with a Unicode value of U+007F or in the range U+0000
     * through U+001F or U+0080 through U+009F. Signified by the Unicode designation
     * "Cc" (other, control). The value is 14.
     */
    UnicodeCategory[UnicodeCategory["Control"] = 14] = "Control";
    /**
     * Format character that affects the layout of text or the operation of text
     * processes, but is not normally rendered. Signified by the Unicode designation
     * "Cf" (other, format). The value is 15.
     */
    UnicodeCategory[UnicodeCategory["Format"] = 15] = "Format";
    /**
     * High surrogate or a low surrogate character. Surrogate code values are in
     * the range U+D800 through U+DFFF. Signified by the Unicode designation "Cs"
     * (other, surrogate). The value is 16.
     */
    UnicodeCategory[UnicodeCategory["Surrogate"] = 16] = "Surrogate";
    /**
     * Private-use character, with a Unicode value in the range U+E000 through U+F8FF.
     * Signified by the Unicode designation "Co" (other, private use). The value is 17.
     */
    UnicodeCategory[UnicodeCategory["PrivateUse"] = 17] = "PrivateUse";
    /**
     * Connector punctuation character that connects two characters. Signified by
     * the Unicode designation "Pc" (punctuation, connector). The value is 18.
     */
    UnicodeCategory[UnicodeCategory["ConnectorPunctuation"] = 18] = "ConnectorPunctuation";
    /**
     * Dash or hyphen character. Signified by the Unicode designation "Pd" (punctuation,
     * dash). The value is 19.
     */
    UnicodeCategory[UnicodeCategory["DashPunctuation"] = 19] = "DashPunctuation";
    /**
     * Opening character of one of the paired punctuation marks, such as parentheses,
     * square brackets, and braces. Signified by the Unicode designation "Ps" (punctuation,
     * open). The value is 20.
     */
    UnicodeCategory[UnicodeCategory["OpenPunctuation"] = 20] = "OpenPunctuation";
    /**
     * Closing character of one of the paired punctuation marks, such as parentheses,
     * square brackets, and braces. Signified by the Unicode designation "Pe" (punctuation,
     * close). The value is 21.
     */
    UnicodeCategory[UnicodeCategory["ClosePunctuation"] = 21] = "ClosePunctuation";
    /**
     * Opening or initial quotation mark character. Signified by the Unicode designation
     * "Pi" (punctuation, initial quote). The value is 22.
     */
    UnicodeCategory[UnicodeCategory["InitialQuotePunctuation"] = 22] = "InitialQuotePunctuation";
    /**
     * Closing or final quotation mark character. Signified by the Unicode designation
     * "Pf" (punctuation, final quote). The value is 23.
     */
    UnicodeCategory[UnicodeCategory["FinalQuotePunctuation"] = 23] = "FinalQuotePunctuation";
    /**
     * Punctuation character that is not a connector, a dash, open punctuation,
     * close punctuation, an initial quote, or a final quote. Signified by the Unicode
     * designation "Po" (punctuation, other). The value is 24.
     */
    UnicodeCategory[UnicodeCategory["OtherPunctuation"] = 24] = "OtherPunctuation";
    /**
     * Mathematical symbol character, such as "+" or "= ". Signified by the Unicode
     * designation "Sm" (symbol, math). The value is 25.
     */
    UnicodeCategory[UnicodeCategory["MathSymbol"] = 25] = "MathSymbol";
    /**
     * Currency symbol character. Signified by the Unicode designation "Sc" (symbol,
     * currency). The value is 26.
     */
    UnicodeCategory[UnicodeCategory["CurrencySymbol"] = 26] = "CurrencySymbol";
    /**
     * Modifier symbol character, which indicates modifications of surrounding characters.
     * For example, the fraction slash indicates that the number to the left is
     * the numerator and the number to the right is the denominator. The indicator
     * is signified by the Unicode designation "Sk" (symbol, modifier). The value is 27.
     */
    UnicodeCategory[UnicodeCategory["ModifierSymbol"] = 27] = "ModifierSymbol";
    /**
     * Symbol character that is not a mathematical symbol, a currency symbol or
     * a modifier symbol. Signified by the Unicode designation "So" (symbol, other).
     * The value is 28.
     */
    UnicodeCategory[UnicodeCategory["OtherSymbol"] = 28] = "OtherSymbol";
    /**
     * Character that is not assigned to any Unicode category. Signified by the
     * Unicode designation "Cn" (other, not assigned). The value is 29.
     */
    UnicodeCategory[UnicodeCategory["OtherNotAssigned"] = 29] = "OtherNotAssigned";
})(UnicodeCategory || (UnicodeCategory = {}));

/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
class Chars {
    static getUnicodeCategory(char) {
        if (char < 0x3400)
            return this._table_0[char];
        if (char < 0x4db6)
            return UnicodeCategory.OtherLetter;
        if (char < 0x4dc0)
            return UnicodeCategory.OtherNotAssigned;
        if (char < 0x4e00)
            return UnicodeCategory.OtherSymbol;
        if (char < 0x9fc0)
            return UnicodeCategory.OtherLetter;
        if (char < 0xac00)
            return this._table_9fc0[char - 0x9fc0];
        if (char < 0xd780)
            return UnicodeCategory.OtherLetter;
        if (char < 0xd800)
            return this._table_d780[char - 0xd780];
        if (char < 0xe000)
            return UnicodeCategory.Surrogate;
        if (char < 0xf900)
            return UnicodeCategory.PrivateUse;
        if (char < 0xfa40)
            return UnicodeCategory.OtherLetter;
        if (char < 0x10000)
            return this._table_fa40[char - 0xfa40];
        return UnicodeCategory.OtherNotAssigned;
    }
}
Chars._table_0 = [
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 11, 24, 24, 24, 26, 24, 24, 24, 20, 21, 24, 25, 24, 19, 24, 24, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 24, 24, 25, 25, 25, 24,
    24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 24, 21, 27, 18, 27, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, 25, 21, 25, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 11, 24, 26, 26, 26, 26, 28, 28, 27, 28, 1, 22, 25, 19, 28, 27, 28, 25, 10, 10, 27, 1, 28, 24, 27, 10, 1, 23, 10, 10, 10, 24,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 25, 1, 1, 1, 1, 1, 1, 1, 1,
    0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0,
    1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1,
    1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 4, 0, 1, 1, 1,
    4, 4, 4, 4, 0, 2, 1, 0, 2, 1, 0, 2, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 2, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1,
    0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1,
    1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 27, 27, 27, 27, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 3, 3, 3, 3, 3, 27, 27, 27, 27, 27, 27, 27, 3, 27, 3, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 0, 1, 0, 1, 3, 27, 0, 1, 29, 29, 3, 1, 1, 1, 24, 0,
    29, 29, 29, 29, 27, 27, 0, 24, 0, 0, 0, 29, 0, 29, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 25, 0, 1, 0, 0, 1, 1, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
    0, 1, 28, 5, 5, 5, 5, 5, 7, 7, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
    0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
    0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 29, 3, 24, 24, 24, 24, 24, 24, 29, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 29, 24, 19, 29, 29, 28, 28, 26, 29, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 19, 5,
    24, 5, 5, 24, 5, 5, 24, 5, 29, 29, 29, 29, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 29, 4, 4, 4, 24, 24, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    15, 15, 15, 15, 15, 15, 25, 25, 25, 24, 24, 26, 24, 24, 28, 28, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 24, 15, 29, 24, 24, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 24, 24, 24, 24, 4, 4, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 24, 4, 5, 5, 5, 5, 5, 5, 5, 15, 28, 5, 5, 5, 5, 5, 5, 3, 3, 5, 5, 28, 5, 5, 5, 5, 4, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 4, 28, 28, 4,
    24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 29, 15, 4, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 3, 28, 24, 24, 24, 3, 29, 29, 29, 29, 29,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 3, 5, 5, 5, 5, 5, 5, 5, 5, 5, 3, 5, 5, 5, 3, 5, 5, 5, 5, 5, 29, 29, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 29,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 29, 29, 24, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    5, 5, 5, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 6, 5, 4, 6, 6,
    6, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 5, 6, 6, 4, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 24, 24, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 24, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 5, 6, 6, 29, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 4, 4, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 29, 4, 29, 29, 29, 4, 4, 4, 4, 29, 29, 5, 4, 6, 6,
    6, 5, 5, 5, 5, 29, 29, 6, 6, 29, 29, 6, 6, 5, 4, 29, 29, 29, 29, 29, 29, 29, 29, 6, 29, 29, 29, 29, 4, 4, 29, 4, 4, 4, 5, 5, 29, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 26, 26, 10, 10, 10, 10, 10, 10, 28, 26, 29, 29, 29, 29,
    29, 5, 5, 6, 29, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 4, 4, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 29, 4, 4, 29, 4, 4, 29, 29, 5, 29, 6, 6,
    6, 5, 5, 29, 29, 29, 29, 5, 5, 29, 29, 5, 5, 5, 29, 29, 29, 5, 29, 29, 29, 29, 29, 29, 29, 4, 4, 4, 4, 29, 4, 29, 29, 29, 29, 29, 29, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 5, 5, 4, 4, 4, 5, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    29, 5, 5, 6, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 29, 4, 4, 4, 4, 4, 29, 29, 5, 4, 6, 6,
    6, 5, 5, 5, 5, 5, 29, 5, 5, 6, 29, 6, 6, 5, 29, 29, 4, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 4, 4, 5, 5, 29, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 24, 26, 29, 29, 29, 29, 29, 29, 29, 4, 29, 29, 29, 29, 29, 29,
    29, 5, 6, 6, 29, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 4, 4, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 29, 4, 4, 4, 4, 4, 29, 29, 5, 4, 6, 5,
    6, 5, 5, 5, 5, 29, 29, 6, 6, 29, 29, 6, 6, 5, 29, 29, 29, 29, 29, 29, 29, 29, 5, 6, 29, 29, 29, 29, 4, 4, 29, 4, 4, 4, 5, 5, 29, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 28, 4, 10, 10, 10, 10, 10, 10, 29, 29, 29, 29, 29, 29, 29, 29,
    29, 29, 5, 4, 29, 4, 4, 4, 4, 4, 4, 29, 29, 29, 4, 4, 4, 29, 4, 4, 4, 4, 29, 29, 29, 4, 4, 29, 4, 29, 4, 4, 29, 29, 29, 4, 4, 29, 29, 29, 4, 4, 4, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 6, 6,
    5, 6, 6, 29, 29, 29, 6, 6, 6, 29, 6, 6, 6, 5, 29, 29, 4, 29, 29, 29, 29, 29, 29, 6, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 10, 10, 10, 28, 28, 28, 28, 28, 28, 26, 28, 29, 29, 29, 29, 29,
    5, 6, 6, 6, 29, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 4, 5, 5,
    5, 6, 6, 6, 6, 29, 5, 5, 5, 29, 5, 5, 5, 5, 29, 29, 29, 29, 29, 29, 29, 5, 5, 29, 4, 4, 4, 29, 29, 29, 29, 29, 4, 4, 5, 5, 29, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 29, 29, 29, 29, 29, 29, 29, 29, 10, 10, 10, 10, 10, 10, 10, 28,
    29, 5, 6, 6, 29, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 29, 29, 5, 4, 6, 5,
    6, 6, 6, 6, 6, 29, 5, 6, 6, 29, 6, 6, 5, 5, 29, 29, 29, 29, 29, 29, 29, 6, 6, 29, 29, 29, 29, 29, 29, 29, 4, 29, 4, 4, 5, 5, 29, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 29, 4, 4, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    29, 5, 6, 6, 29, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 4, 6, 6,
    6, 5, 5, 5, 5, 29, 6, 6, 6, 29, 6, 6, 6, 5, 4, 29, 29, 29, 29, 29, 29, 29, 29, 6, 29, 29, 29, 29, 29, 29, 29, 4, 4, 4, 5, 5, 29, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 29, 29, 29, 28, 4, 4, 4, 4, 4, 4,
    29, 29, 6, 6, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 29, 29,
    4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 5, 29, 29, 29, 29, 6, 6, 6, 5, 5, 5, 29, 5, 29, 6, 6, 6, 6, 6, 6, 6, 6, 29, 29, 29, 29, 29, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 29, 29, 6, 6, 24, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 4, 4, 5, 5, 5, 5, 5, 5, 5, 29, 29, 29, 29, 26,
    4, 4, 4, 4, 4, 4, 3, 5, 5, 5, 5, 5, 5, 5, 5, 24, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 24, 24, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    29, 4, 4, 29, 4, 29, 29, 4, 4, 29, 4, 29, 29, 4, 29, 29, 29, 29, 29, 29, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 29, 4, 29, 4, 29, 29, 4, 4, 29, 4, 4, 4, 4, 5, 4, 4, 5, 5, 5, 5, 5, 5, 29, 5, 5, 4, 29, 29,
    4, 4, 4, 4, 4, 29, 3, 29, 5, 5, 5, 5, 5, 5, 29, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 29, 29, 4, 4, 4, 4, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    4, 28, 28, 28, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 28, 24, 28, 28, 28, 5, 5, 28, 28, 28, 28, 28, 28, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 28, 5, 28, 5, 28, 5, 20, 21, 20, 21, 6, 6,
    4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6,
    5, 5, 5, 5, 5, 24, 5, 5, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 29, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 29, 28, 28,
    28, 28, 28, 28, 28, 28, 5, 28, 28, 28, 28, 28, 28, 29, 28, 28, 24, 24, 24, 24, 24, 28, 28, 28, 28, 24, 24, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 6, 6, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 6, 5, 5, 6, 6, 5, 5, 4,
    8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 24, 24, 24, 24, 24, 24, 4, 4, 4, 4, 4, 4, 6, 6, 5, 5, 4, 4, 4, 4, 5, 5, 5, 4, 6, 6, 6, 4, 4, 6, 6, 6, 6, 6, 6, 6, 4, 4, 4, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 5, 6, 6, 5, 5, 6, 6, 6, 6, 6, 6, 5, 4, 6, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 6, 6, 6, 5, 28, 28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 29, 0, 29, 29, 29, 29, 29, 0, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 24, 3, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 29, 29, 4, 4, 4, 4, 4, 4, 4, 29, 4, 29, 4, 4, 4, 4, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 29, 29, 4, 4, 4, 4, 4, 4, 4, 29,
    4, 29, 4, 4, 4, 4, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 5, 5, 5, 24, 24, 24, 24, 24, 24, 24, 24, 24, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 29, 29, 29,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 29, 1, 1, 1, 1, 1, 1, 29, 29,
    19, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 24, 24, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    11, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 20, 21, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 24, 24, 24, 9, 9, 9, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 29, 29, 29,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 5, 5, 5, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 24, 24, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 29, 5, 5, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 6,
    6, 6, 6, 6, 6, 6, 5, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 24, 24, 24, 3, 24, 24, 24, 26, 4, 5, 29, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 29, 29, 29, 29, 29, 29, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 29, 29, 29, 29, 29, 29,
    24, 24, 24, 24, 24, 24, 19, 24, 24, 24, 24, 5, 5, 5, 15, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 29, 29, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 29, 29, 29, 29,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 4, 29, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 5, 5, 5, 6, 6, 6, 6, 5, 5, 6, 6, 6, 29, 29, 29, 29, 6, 6, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5, 29, 29, 29, 29,
    28, 29, 29, 29, 24, 24, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 4, 4, 4, 4, 4, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 29, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 10, 29, 29, 29, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 6, 6, 5, 29, 29, 24, 24, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 6, 5, 6, 5, 5, 5, 5, 5, 5, 5, 29, 5, 6, 5, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 29, 29, 5,
    8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 29, 29, 29, 29, 29, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 29, 29, 29, 29, 29, 29, 24, 24, 24, 24, 24, 24, 24, 3, 24, 24, 24, 24, 24, 24, 29, 29, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 7, 29,
    29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    5, 5, 5, 5, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 6, 5, 5, 5, 5, 5, 6, 5, 6, 6, 6,
    6, 6, 5, 6, 6, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 24, 24, 24, 24, 24, 24, 24, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 5, 5, 5, 5, 5, 5, 5, 5, 5, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29,
    5, 5, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 6, 5, 5, 5, 5, 6, 6, 5, 5, 6, 5, 5, 5, 4, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 6, 5, 5, 6, 6, 6, 5, 6, 5, 5, 5, 6, 6, 29, 29, 29, 29, 29, 29, 29, 29, 24, 24, 24, 24,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 6, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 5, 5, 29, 29, 29, 24, 24, 24, 24, 24,
    8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 29, 29, 29, 4, 4, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 24, 24,
    29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    24, 24, 24, 24, 24, 24, 24, 24, 29, 29, 29, 29, 29, 29, 29, 29, 5, 5, 5, 24, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 5, 4, 4, 4, 4, 6, 6, 5, 4, 4, 29, 5, 5, 29, 29, 29, 29, 29, 29,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 29, 29, 29, 29, 29, 29, 5, 5, 5, 5,
    0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
    0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
    0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
    0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 29, 29, 0, 0, 0, 0, 0, 0, 29, 29, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    1, 1, 1, 1, 1, 1, 29, 29, 0, 0, 0, 0, 0, 0, 29, 29, 1, 1, 1, 1, 1, 1, 1, 1, 29, 0, 29, 0, 29, 0, 29, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 29, 29,
    1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 29, 1, 1, 0, 0, 0, 0, 2, 27, 1, 27,
    27, 27, 1, 1, 1, 29, 1, 1, 0, 0, 0, 0, 2, 27, 27, 27, 1, 1, 1, 1, 29, 29, 1, 1, 0, 0, 0, 0, 29, 27, 27, 27, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 27, 27, 27, 29, 29, 1, 1, 1, 29, 1, 1, 0, 0, 0, 0, 2, 27, 27, 29,
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 15, 15, 15, 15, 15, 19, 19, 19, 19, 19, 19, 24, 24, 22, 23, 20, 22, 22, 23, 20, 22, 24, 24, 24, 24, 24, 24, 24, 24, 12, 13, 15, 15, 15, 15, 15, 11, 24, 24, 24, 24, 24, 24, 24, 24, 24, 22, 23, 24, 24, 24, 24, 18,
    18, 24, 24, 24, 25, 20, 21, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 25, 24, 18, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 11, 15, 15, 15, 15, 15, 29, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 10, 3, 29, 29, 10, 10, 10, 10, 10, 10, 25, 25, 25, 20, 21, 3,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 25, 25, 25, 20, 21, 29, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 29, 29, 29, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 29,
    29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 7, 7, 7, 7, 5, 7, 7, 7, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    28, 28, 0, 28, 28, 28, 28, 0, 28, 28, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 28, 0, 28, 28, 25, 0, 0, 0, 0, 0, 28, 28, 28, 28, 28, 28, 0, 28, 0, 28, 0, 28, 0, 0, 0, 0, 28, 1, 0, 0, 0, 0, 1, 4, 4, 4, 4, 1, 28, 28, 1, 1, 0, 0,
    25, 25, 25, 25, 25, 0, 1, 1, 1, 1, 28, 25, 28, 28, 1, 28, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
    9, 9, 9, 0, 1, 9, 9, 9, 9, 10, 28, 28, 29, 29, 29, 29, 25, 25, 25, 25, 25, 28, 28, 28, 28, 28, 25, 25, 28, 28, 28, 28, 25, 28, 28, 25, 28, 28, 25, 28, 28, 28, 28, 28, 28, 28, 25, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 25, 25, 28, 28, 25, 28, 25, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    28, 28, 28, 28, 28, 28, 28, 28, 20, 21, 20, 21, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 25, 25, 28, 28, 28, 28, 28, 28, 28, 20, 21, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 25, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 25, 25, 25, 25, 25, 25, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 25, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 25, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 25, 25, 25, 25, 25, 25, 25, 25,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 25, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 20, 21, 20, 21, 20, 21, 20, 21, 20, 21, 20, 21, 20, 21, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    25, 25, 25, 25, 25, 20, 21, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 21, 20, 21, 20, 21, 20, 21, 20, 21, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 20, 21, 20, 21, 20, 21, 20, 21, 20, 21, 20, 21, 20, 21, 20, 21, 20, 21, 20, 21, 20, 21, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 21, 20, 21, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 20, 21, 25, 25,
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
    25, 25, 25, 25, 25, 28, 28, 25, 25, 25, 25, 25, 25, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 29, 0, 1, 0, 0, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 3, 3, 0, 0,
    0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
    0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 28, 28, 28, 28, 28, 28, 0, 1, 0, 1, 5, 5, 5, 0, 1, 29, 29, 29, 29, 29, 24, 24, 24, 24, 10, 24, 24,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 29, 1, 29, 29, 29, 29, 29, 1, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 29, 29, 29, 3, 24, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 5,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 29, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 29,
    4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 29, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
    24, 24, 22, 23, 22, 23, 24, 24, 24, 22, 23, 24, 22, 23, 24, 24, 24, 24, 24, 24, 24, 24, 24, 19, 24, 24, 19, 24, 22, 23, 24, 24, 22, 23, 20, 21, 20, 21, 20, 21, 20, 21, 24, 24, 24, 24, 24, 3, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 19, 19, 24, 24, 24, 24,
    19, 24, 20, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29,
    11, 24, 24, 24, 28, 3, 4, 9, 20, 21, 20, 21, 20, 21, 20, 21, 20, 21, 28, 28, 20, 21, 20, 21, 20, 21, 20, 21, 19, 20, 21, 21, 28, 9, 9, 9, 9, 9, 9, 9, 9, 9, 5, 5, 5, 5, 6, 6, 19, 3, 3, 3, 3, 3, 28, 28, 9, 9, 9, 3, 4, 24, 28, 28,
    29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 5, 5, 27, 27, 3, 3, 4, 19, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 24, 3, 3, 3, 4,
    29, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 28, 28, 10, 10, 10, 10, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 29,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 10, 10, 10, 10, 10, 10, 10, 10, 28, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 29,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28
];
Chars._table_9fc0 = [
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28, 28,
    28, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 24, 24,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 24, 24, 24, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 4, 5, 7, 7, 7, 24, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 24, 3,
    0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 3, 3, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 5, 5, 24, 24, 24, 24, 24, 24, 29, 29, 29, 29, 29, 29, 29, 29,
    27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 3, 3, 3, 3, 3, 3, 3, 3, 3, 27, 27, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
    0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1,
    0, 1, 0, 1, 0, 1, 0, 1, 3, 27, 27, 0, 1, 0, 1, 4, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 29, 29, 0, 0, 0, 0, 0, 1, 0, 1, 29, 29, 29, 29, 29, 29, 29, 29,
    29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 4, 3, 3, 1, 4, 4, 4, 4, 4,
    4, 4, 5, 4, 4, 4, 5, 4, 4, 4, 4, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 6, 6, 5, 5, 6, 28, 28, 28, 28, 29, 29, 29, 29, 10, 10, 10, 10, 10, 10, 28, 28, 26, 28, 29, 29, 29, 29, 29, 29,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 24, 24, 24, 24, 29, 29, 29, 29, 29, 29, 29, 29,
    6, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
    6, 6, 6, 6, 5, 29, 29, 29, 29, 29, 29, 29, 29, 29, 24, 24, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 29, 29, 29, 29, 29, 29, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 24, 24, 24, 4, 24, 4, 29, 29,
    8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 24, 24, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 24, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29,
    5, 5, 5, 6, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 6, 6, 5, 5, 5, 5, 6, 6, 5, 6, 6, 6,
    6, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 29, 3, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 29, 29, 29, 29, 24, 24, 4, 4, 4, 4, 4, 5, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 4, 4, 4, 4, 4, 29,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 6, 6, 5, 5, 6, 6, 5, 5, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    4, 4, 4, 5, 4, 4, 4, 4, 4, 4, 4, 4, 5, 6, 29, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 29, 29, 24, 24, 24, 24, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 28, 28, 28, 4, 6, 5, 6, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 4, 5, 5, 5, 4, 4, 5, 5, 4, 4, 4, 4, 4, 5, 5,
    4, 5, 4, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 4, 4, 3, 24, 24, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 6, 5, 5, 6, 6, 24, 24, 4, 3, 3, 6, 5, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    29, 4, 4, 4, 4, 4, 4, 29, 29, 4, 4, 4, 4, 4, 4, 29, 29, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 29, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 29, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 27, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 6, 6, 5, 6, 6, 5, 6, 6, 24, 6, 5, 29, 29, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 29, 29, 29, 29, 29, 29
];
Chars._table_d780 = [
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29
];
Chars._table_fa40 = [
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29,
    1, 1, 1, 1, 1, 1, 1, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 1, 1, 1, 1, 1, 29, 29, 29, 29, 29, 4, 5, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 25, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 29, 4, 29,
    4, 4, 29, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27, 27,
    27, 27, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 21, 20,
    29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 26, 28, 29, 29,
    5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 24, 24, 24, 24, 24, 24, 24, 20, 21, 24, 29, 29, 29, 29, 29, 29, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 24, 19, 19, 18, 18, 20, 21, 20, 21, 20, 21, 20, 21, 20, 21, 20,
    21, 20, 21, 20, 21, 24, 24, 20, 21, 24, 24, 24, 24, 18, 18, 18, 24, 24, 24, 29, 24, 24, 24, 24, 19, 20, 21, 20, 21, 20, 21, 24, 24, 24, 25, 19, 25, 25, 25, 29, 24, 26, 24, 24, 29, 29, 29, 29, 4, 4, 4, 4, 4, 29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29, 29, 15,
    29, 24, 24, 24, 26, 24, 24, 24, 20, 21, 24, 25, 24, 19, 24, 24, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 24, 24, 25, 25, 25, 24, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 24, 21, 27, 18,
    27, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 20, 25, 21, 25, 20, 21, 24, 20, 21, 24, 24, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
    4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 29,
    29, 29, 4, 4, 4, 4, 4, 4, 29, 29, 4, 4, 4, 4, 4, 4, 29, 29, 4, 4, 4, 4, 4, 4, 29, 29, 4, 4, 4, 29, 29, 29, 26, 26, 25, 27, 28, 26, 26, 29, 28, 25, 25, 25, 25, 28, 28, 29, 29, 29, 29, 29, 29, 29, 29, 29, 29, 15, 15, 15, 28, 28, 29, 29
];

/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
class Char {
    static isUpper(char, index = 0) {
        let cat = this.getUnicodeCategory(char, index);
        return (cat == UnicodeCategory.UppercaseLetter);
    }
    static isLower(char, index = 0) {
        let cat = this.getUnicodeCategory(char, index);
        return (cat == UnicodeCategory.LowercaseLetter);
    }
    static isLetter(char, index = 0) {
        let cat = this.getUnicodeCategory(char, index);
        return this.checkLetter(cat);
    }
    static isDigit(char, index = 0) {
        if (char != null && typeof char == "number") {
            let cat = Chars.getUnicodeCategory(char);
            return (cat == UnicodeCategory.DecimalDigitNumber);
        }
        let cat = this.getUnicodeCategory(char, index);
        return (cat == UnicodeCategory.DecimalDigitNumber);
    }
    static isLetterOrDigit(char, index = 0) {
        let cat = this.getUnicodeCategory(char, index);
        return this.checkLetter(cat) || cat == UnicodeCategory.DecimalDigitNumber;
    }
    static toLower(char) {
        return char.toLocaleLowerCase();
    }
    static toUpper(char) {
        return char.toLocaleUpperCase();
    }
    static isWhitespace(char, index = 0, allowNbsp = true) {
        if (char == null || char.length < index + 1)
            return false;
        let code = char.charCodeAt(index);
        if ((code == 0x20) || (code >= 0x09 && code <= 0x0d) || (code == 0xa0 && allowNbsp) || code == 0x85)
            return true;
        let cat = Chars.getUnicodeCategory(code);
        return cat == UnicodeCategory.SpaceSeparator ||
            cat == UnicodeCategory.LineSeparator ||
            cat == UnicodeCategory.ParagraphSeparator;
    }
    static checkLetter(uc) {
        return uc == UnicodeCategory.UppercaseLetter ||
            uc == UnicodeCategory.LowercaseLetter ||
            uc == UnicodeCategory.TitlecaseLetter ||
            uc == UnicodeCategory.ModifierLetter ||
            uc == UnicodeCategory.OtherLetter;
    }
    static getUnicodeCategory(char, index = 0) {
        if (char == null || char.length < index + 1)
            return UnicodeCategory.OtherNotAssigned;
        let code = char.charCodeAt(index);
        return Chars.getUnicodeCategory(code);
    }
    static isControl(char, index = 0) {
        return Char.getUnicodeCategory(char, index) == UnicodeCategory.Control;
    }
}

/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
class Enum {
    /*compareTo(value: Enum): number {
      if (this.value != null)
        return this.value.compareTo(value.value);
  
      return this.name.compareTo(value.name);
    }*/
    constructor(name, value = null) {
        this.name = name;
        this.value = value;
    }
    static getName(enumType, value) {
        let values = "";
        if (enumType[value] == undefined) {
            // eslint-disable-next-line @typescript-eslint/no-for-in-array
            for (let enumValue in enumType) {
                let enumValueNumber = +enumValue;
                if (enumValueNumber != 0 && (value & enumValueNumber) == enumValueNumber) {
                    value -= enumValueNumber;
                    // eslint-disable-next-line @typescript-eslint/restrict-plus-operands
                    values += (values.length > 0 ? ", " : "") + enumType[enumValueNumber];
                }
            }
            if (values.length == 0)
                values = enumType[0];
            return values;
        }
        return enumType[value];
    }
    static parse(enumType, value, upperFirstChar = true) {
        if (value == null)
            return null;
        if (typeof value == "number" || Char.isDigit(value))
            value = Enum.getName(enumType, +value);
        let values = value.toString().split(",");
        let enumValue;
        // tslint:disable-next-line: prefer-for-of
        for (let index = 0; index < values.length; index++) {
            let strValue = upperFirstChar ? this.upperFirstChar(values[index]) : values[index];
            if (typeof enumValue == "undefined")
                enumValue = enumType[strValue];
            else
                enumValue += enumType[strValue];
        }
        return enumValue;
    }
    static upperFirstChar(str) {
        str = str.trim();
        return str.length > 0 ? str.charAt(0).toUpperCase() + str.slice(1) : str;
    }
    static getNames(enumType) {
        let names = [];
        for (let enumValue in enumType) {
            if (typeof enumType[enumValue] != "number")
                names.push(enumType[enumValue]);
        }
        return names;
    }
    static getValues(enumType) {
        let values = [];
        for (let enumValue in enumType) {
            if (typeof enumType[enumValue] != "number")
                values.push(+enumValue);
        }
        return values;
    }
    toString() {
        return this.name;
    }
}

var StiElements;
(function (StiElements) {
    StiElements["StiTextBox"] = "app-sti-text-box";
    StiElements["StiCheckBox"] = "sti-checkbox-component";
    StiElements["StiComboBox"] = "app-sti-combo-box";
    StiElements["StiListBox"] = "app-sti-list-box";
    StiElements["StiNumberBox"] = "app-sti-number-box";
    StiElements["StiDateTimeBox"] = "app-sti-date-time-box";
    StiElements["StiDescription"] = "app-sti-description";
    StiElements["StiMultipleSelection"] = "app-sti-multiple-selection";
    StiElements["StiPanel"] = "app-sti-panel";
    StiElements["StiSignature"] = "app-sti-signature";
    StiElements["StiSingleSelection"] = "app-sti-single-selection";
    StiElements["StiTable"] = "app-sti-table";
})(StiElements || (StiElements = {}));
var StiLabelAlignment;
(function (StiLabelAlignment) {
    StiLabelAlignment[StiLabelAlignment["Left"] = 1] = "Left";
    StiLabelAlignment[StiLabelAlignment["Right"] = 2] = "Right";
    StiLabelAlignment[StiLabelAlignment["Top"] = 3] = "Top";
})(StiLabelAlignment || (StiLabelAlignment = {}));
var StiLineWeight;
(function (StiLineWeight) {
    StiLineWeight[StiLineWeight["Thin"] = 1] = "Thin";
    StiLineWeight[StiLineWeight["Normal"] = 2] = "Normal";
    StiLineWeight[StiLineWeight["Thick"] = 3] = "Thick";
})(StiLineWeight || (StiLineWeight = {}));
var StiTextHorAlignment;
(function (StiTextHorAlignment) {
    StiTextHorAlignment[StiTextHorAlignment["Left"] = 0] = "Left";
    StiTextHorAlignment[StiTextHorAlignment["Center"] = 1] = "Center";
    StiTextHorAlignment[StiTextHorAlignment["Right"] = 2] = "Right";
    StiTextHorAlignment[StiTextHorAlignment["Width"] = 3] = "Width";
})(StiTextHorAlignment || (StiTextHorAlignment = {}));
var StiTextRangeFormat;
(function (StiTextRangeFormat) {
    StiTextRangeFormat[StiTextRangeFormat["Characters"] = 0] = "Characters";
})(StiTextRangeFormat || (StiTextRangeFormat = {}));
var StiNumberRangeFormat;
(function (StiNumberRangeFormat) {
    StiNumberRangeFormat[StiNumberRangeFormat["Digits"] = 0] = "Digits";
    StiNumberRangeFormat[StiNumberRangeFormat["Values"] = 1] = "Values";
})(StiNumberRangeFormat || (StiNumberRangeFormat = {}));
var StiDisplayCurrencyAs;
(function (StiDisplayCurrencyAs) {
    StiDisplayCurrencyAs[StiDisplayCurrencyAs["Symbol"] = 1] = "Symbol";
    StiDisplayCurrencyAs[StiDisplayCurrencyAs["Code"] = 2] = "Code";
})(StiDisplayCurrencyAs || (StiDisplayCurrencyAs = {}));
var StiBarcodeType;
(function (StiBarcodeType) {
    StiBarcodeType[StiBarcodeType["AustraliaPost4State"] = 0] = "AustraliaPost4State";
    StiBarcodeType[StiBarcodeType["Aztec"] = 1] = "Aztec";
    StiBarcodeType[StiBarcodeType["Codabar"] = 2] = "Codabar";
    StiBarcodeType[StiBarcodeType["Code11"] = 3] = "Code11";
    StiBarcodeType[StiBarcodeType["Code128a"] = 4] = "Code128a";
    StiBarcodeType[StiBarcodeType["Code128Auto"] = 5] = "Code128Auto";
    StiBarcodeType[StiBarcodeType["Code128b"] = 6] = "Code128b";
    StiBarcodeType[StiBarcodeType["Code128c"] = 7] = "Code128c";
    StiBarcodeType[StiBarcodeType["Code39"] = 8] = "Code39";
    StiBarcodeType[StiBarcodeType["Code39Ext"] = 9] = "Code39Ext";
    StiBarcodeType[StiBarcodeType["Code93"] = 10] = "Code93";
    StiBarcodeType[StiBarcodeType["Code93Ext"] = 11] = "Code93Ext";
    StiBarcodeType[StiBarcodeType["DataMatrix"] = 12] = "DataMatrix";
    StiBarcodeType[StiBarcodeType["DutchKIX"] = 13] = "DutchKIX";
    StiBarcodeType[StiBarcodeType["EAN128a"] = 14] = "EAN128a";
    StiBarcodeType[StiBarcodeType["EAN128Auto"] = 15] = "EAN128Auto";
    StiBarcodeType[StiBarcodeType["EAN128b"] = 16] = "EAN128b";
    StiBarcodeType[StiBarcodeType["EAN128c"] = 17] = "EAN128c";
    StiBarcodeType[StiBarcodeType["EAN13"] = 18] = "EAN13";
    StiBarcodeType[StiBarcodeType["EAN8"] = 19] = "EAN8";
    StiBarcodeType[StiBarcodeType["FIM"] = 20] = "FIM";
    StiBarcodeType[StiBarcodeType["GS1_128"] = 21] = "GS1_128";
    StiBarcodeType[StiBarcodeType["IntelligentMail4State"] = 22] = "IntelligentMail4State";
    StiBarcodeType[StiBarcodeType["Interleaved2of5"] = 23] = "Interleaved2of5";
    StiBarcodeType[StiBarcodeType["Isbn10"] = 24] = "Isbn10";
    StiBarcodeType[StiBarcodeType["Isbn13"] = 25] = "Isbn13";
    StiBarcodeType[StiBarcodeType["ITF14"] = 26] = "ITF14";
    StiBarcodeType[StiBarcodeType["Jan13"] = 27] = "Jan13";
    StiBarcodeType[StiBarcodeType["Jan8"] = 28] = "Jan8";
    StiBarcodeType[StiBarcodeType["Maxicode"] = 29] = "Maxicode";
    StiBarcodeType[StiBarcodeType["Msi"] = 30] = "Msi";
    StiBarcodeType[StiBarcodeType["Pdf417"] = 31] = "Pdf417";
    StiBarcodeType[StiBarcodeType["Pharmacode"] = 32] = "Pharmacode";
    StiBarcodeType[StiBarcodeType["Plessey"] = 33] = "Plessey";
    StiBarcodeType[StiBarcodeType["Postnet"] = 34] = "Postnet";
    StiBarcodeType[StiBarcodeType["QRCode"] = 35] = "QRCode";
    StiBarcodeType[StiBarcodeType["RoyalMail4State"] = 36] = "RoyalMail4State";
    StiBarcodeType[StiBarcodeType["SSCC18"] = 37] = "SSCC18";
    StiBarcodeType[StiBarcodeType["Standard2of5"] = 38] = "Standard2of5";
    StiBarcodeType[StiBarcodeType["UpcA"] = 39] = "UpcA";
    StiBarcodeType[StiBarcodeType["UpcE"] = 40] = "UpcE";
    StiBarcodeType[StiBarcodeType["UpcSup2"] = 41] = "UpcSup2";
    StiBarcodeType[StiBarcodeType["UpcSup5"] = 42] = "UpcSup5";
})(StiBarcodeType || (StiBarcodeType = {}));
var StiThousandSeparator;
(function (StiThousandSeparator) {
    StiThousandSeparator[StiThousandSeparator["None"] = 0] = "None";
    StiThousandSeparator[StiThousandSeparator["Comma"] = 1] = "Comma";
    StiThousandSeparator[StiThousandSeparator["Dot"] = 2] = "Dot";
    StiThousandSeparator[StiThousandSeparator["NoneComma"] = 3] = "NoneComma";
    StiThousandSeparator[StiThousandSeparator["Apostrophe"] = 4] = "Apostrophe";
})(StiThousandSeparator || (StiThousandSeparator = {}));
var StiNumberType;
(function (StiNumberType) {
    StiNumberType[StiNumberType["Decimal"] = 0] = "Decimal";
    StiNumberType[StiNumberType["Currency"] = 1] = "Currency";
})(StiNumberType || (StiNumberType = {}));
var StiButtonType;
(function (StiButtonType) {
    StiButtonType[StiButtonType["ClearForm"] = 0] = "ClearForm";
    StiButtonType[StiButtonType["SendForm"] = 1] = "SendForm";
    StiButtonType[StiButtonType["AttachFiles"] = 2] = "AttachFiles";
})(StiButtonType || (StiButtonType = {}));
var StiAngle;
(function (StiAngle) {
    StiAngle[StiAngle["Angle0"] = 0] = "Angle0";
    StiAngle[StiAngle["Angle90"] = 90] = "Angle90";
    StiAngle[StiAngle["Angle180"] = 180] = "Angle180";
    StiAngle[StiAngle["Angle270"] = 270] = "Angle270";
})(StiAngle || (StiAngle = {}));
var StiQRCodeErrorCorrectionLevel;
(function (StiQRCodeErrorCorrectionLevel) {
    StiQRCodeErrorCorrectionLevel[StiQRCodeErrorCorrectionLevel["Level1"] = 0] = "Level1";
    StiQRCodeErrorCorrectionLevel[StiQRCodeErrorCorrectionLevel["Level2"] = 1] = "Level2";
    StiQRCodeErrorCorrectionLevel[StiQRCodeErrorCorrectionLevel["Level3"] = 2] = "Level3";
    StiQRCodeErrorCorrectionLevel[StiQRCodeErrorCorrectionLevel["Level4"] = 3] = "Level4";
})(StiQRCodeErrorCorrectionLevel || (StiQRCodeErrorCorrectionLevel = {}));
var HatchStyle;
(function (HatchStyle) {
    HatchStyle[HatchStyle["Horizontal"] = 0] = "Horizontal";
    HatchStyle[HatchStyle["Vertical"] = 1] = "Vertical";
    HatchStyle[HatchStyle["ForwardDiagonal"] = 2] = "ForwardDiagonal";
    HatchStyle[HatchStyle["BackwardDiagonal"] = 3] = "BackwardDiagonal";
    HatchStyle[HatchStyle["Cross"] = 4] = "Cross";
    HatchStyle[HatchStyle["DiagonalCross"] = 5] = "DiagonalCross";
    HatchStyle[HatchStyle["Percent05"] = 6] = "Percent05";
    HatchStyle[HatchStyle["Percent10"] = 7] = "Percent10";
    HatchStyle[HatchStyle["Percent20"] = 8] = "Percent20";
    HatchStyle[HatchStyle["Percent25"] = 9] = "Percent25";
    HatchStyle[HatchStyle["Percent30"] = 10] = "Percent30";
    HatchStyle[HatchStyle["Percent40"] = 11] = "Percent40";
    HatchStyle[HatchStyle["Percent50"] = 12] = "Percent50";
    HatchStyle[HatchStyle["Percent60"] = 13] = "Percent60";
    HatchStyle[HatchStyle["Percent70"] = 14] = "Percent70";
    HatchStyle[HatchStyle["Percent75"] = 15] = "Percent75";
    HatchStyle[HatchStyle["Percent80"] = 16] = "Percent80";
    HatchStyle[HatchStyle["Percent90"] = 17] = "Percent90";
    HatchStyle[HatchStyle["LightDownwardDiagonal"] = 18] = "LightDownwardDiagonal";
    HatchStyle[HatchStyle["LightUpwardDiagonal"] = 19] = "LightUpwardDiagonal";
    HatchStyle[HatchStyle["DarkDownwardDiagonal"] = 20] = "DarkDownwardDiagonal";
    HatchStyle[HatchStyle["DarkUpwardDiagonal"] = 21] = "DarkUpwardDiagonal";
    HatchStyle[HatchStyle["WideDownwardDiagonal"] = 22] = "WideDownwardDiagonal";
    HatchStyle[HatchStyle["WideUpwardDiagonal"] = 23] = "WideUpwardDiagonal";
    HatchStyle[HatchStyle["LightVertical"] = 24] = "LightVertical";
    HatchStyle[HatchStyle["LightHorizontal"] = 25] = "LightHorizontal";
    HatchStyle[HatchStyle["NarrowVertical"] = 26] = "NarrowVertical";
    HatchStyle[HatchStyle["NarrowHorizontal"] = 27] = "NarrowHorizontal";
    HatchStyle[HatchStyle["DarkVertical"] = 28] = "DarkVertical";
    HatchStyle[HatchStyle["DarkHorizontal"] = 29] = "DarkHorizontal";
    HatchStyle[HatchStyle["DashedDownwardDiagonal"] = 30] = "DashedDownwardDiagonal";
    HatchStyle[HatchStyle["DashedUpwardDiagonal"] = 31] = "DashedUpwardDiagonal";
    HatchStyle[HatchStyle["DashedHorizontal"] = 32] = "DashedHorizontal";
    HatchStyle[HatchStyle["DashedVertical"] = 33] = "DashedVertical";
    HatchStyle[HatchStyle["SmallConfetti"] = 34] = "SmallConfetti";
    HatchStyle[HatchStyle["LargeConfetti"] = 35] = "LargeConfetti";
    HatchStyle[HatchStyle["ZigZag"] = 36] = "ZigZag";
    HatchStyle[HatchStyle["Wave"] = 37] = "Wave";
    HatchStyle[HatchStyle["DiagonalBrick"] = 38] = "DiagonalBrick";
    HatchStyle[HatchStyle["HorizontalBrick"] = 39] = "HorizontalBrick";
    HatchStyle[HatchStyle["Weave"] = 40] = "Weave";
    HatchStyle[HatchStyle["Plaid"] = 41] = "Plaid";
    HatchStyle[HatchStyle["Divot"] = 42] = "Divot";
    HatchStyle[HatchStyle["DottedGrid"] = 43] = "DottedGrid";
    HatchStyle[HatchStyle["DottedDiamond"] = 44] = "DottedDiamond";
    HatchStyle[HatchStyle["Shingle"] = 45] = "Shingle";
    HatchStyle[HatchStyle["Trellis"] = 46] = "Trellis";
    HatchStyle[HatchStyle["Sphere"] = 47] = "Sphere";
    HatchStyle[HatchStyle["SmallGrid"] = 48] = "SmallGrid";
    HatchStyle[HatchStyle["SmallCheckerBoard"] = 49] = "SmallCheckerBoard";
    HatchStyle[HatchStyle["LargeCheckerBoard"] = 50] = "LargeCheckerBoard";
    HatchStyle[HatchStyle["OutlinedDiamond"] = 51] = "OutlinedDiamond";
    HatchStyle[HatchStyle["SolidDiamond"] = 52] = "SolidDiamond";
    HatchStyle[HatchStyle["LargeGrid"] = 4] = "LargeGrid";
    HatchStyle[HatchStyle["Min"] = 0] = "Min";
    HatchStyle[HatchStyle["Max"] = 4] = "Max";
})(HatchStyle || (HatchStyle = {}));
var StiQRCodeSize;
(function (StiQRCodeSize) {
    StiQRCodeSize[StiQRCodeSize["Automatic"] = 0] = "Automatic";
    StiQRCodeSize[StiQRCodeSize["v1"] = 1] = "v1";
    StiQRCodeSize[StiQRCodeSize["v2"] = 2] = "v2";
    StiQRCodeSize[StiQRCodeSize["v3"] = 3] = "v3";
    StiQRCodeSize[StiQRCodeSize["v4"] = 4] = "v4";
    StiQRCodeSize[StiQRCodeSize["v5"] = 5] = "v5";
    StiQRCodeSize[StiQRCodeSize["v6"] = 6] = "v6";
    StiQRCodeSize[StiQRCodeSize["v7"] = 7] = "v7";
    StiQRCodeSize[StiQRCodeSize["v8"] = 8] = "v8";
    StiQRCodeSize[StiQRCodeSize["v9"] = 9] = "v9";
    StiQRCodeSize[StiQRCodeSize["v10"] = 10] = "v10";
    StiQRCodeSize[StiQRCodeSize["v11"] = 11] = "v11";
    StiQRCodeSize[StiQRCodeSize["v12"] = 12] = "v12";
    StiQRCodeSize[StiQRCodeSize["v13"] = 13] = "v13";
    StiQRCodeSize[StiQRCodeSize["v14"] = 14] = "v14";
    StiQRCodeSize[StiQRCodeSize["v15"] = 15] = "v15";
    StiQRCodeSize[StiQRCodeSize["v16"] = 16] = "v16";
    StiQRCodeSize[StiQRCodeSize["v17"] = 17] = "v17";
    StiQRCodeSize[StiQRCodeSize["v18"] = 18] = "v18";
    StiQRCodeSize[StiQRCodeSize["v19"] = 19] = "v19";
    StiQRCodeSize[StiQRCodeSize["v20"] = 20] = "v20";
    StiQRCodeSize[StiQRCodeSize["v21"] = 21] = "v21";
    StiQRCodeSize[StiQRCodeSize["v22"] = 22] = "v22";
    StiQRCodeSize[StiQRCodeSize["v23"] = 23] = "v23";
    StiQRCodeSize[StiQRCodeSize["v24"] = 24] = "v24";
    StiQRCodeSize[StiQRCodeSize["v25"] = 25] = "v25";
    StiQRCodeSize[StiQRCodeSize["v26"] = 26] = "v26";
    StiQRCodeSize[StiQRCodeSize["v27"] = 27] = "v27";
    StiQRCodeSize[StiQRCodeSize["v28"] = 28] = "v28";
    StiQRCodeSize[StiQRCodeSize["v29"] = 29] = "v29";
    StiQRCodeSize[StiQRCodeSize["v30"] = 30] = "v30";
    StiQRCodeSize[StiQRCodeSize["v31"] = 31] = "v31";
    StiQRCodeSize[StiQRCodeSize["v32"] = 32] = "v32";
    StiQRCodeSize[StiQRCodeSize["v33"] = 33] = "v33";
    StiQRCodeSize[StiQRCodeSize["v34"] = 34] = "v34";
    StiQRCodeSize[StiQRCodeSize["v35"] = 35] = "v35";
    StiQRCodeSize[StiQRCodeSize["v36"] = 36] = "v36";
    StiQRCodeSize[StiQRCodeSize["v37"] = 37] = "v37";
    StiQRCodeSize[StiQRCodeSize["v38"] = 38] = "v38";
    StiQRCodeSize[StiQRCodeSize["v39"] = 39] = "v39";
    StiQRCodeSize[StiQRCodeSize["v40"] = 40] = "v40";
})(StiQRCodeSize || (StiQRCodeSize = {}));
var StiQRCodeBodyShapeType;
(function (StiQRCodeBodyShapeType) {
    StiQRCodeBodyShapeType[StiQRCodeBodyShapeType["Square"] = 0] = "Square";
    StiQRCodeBodyShapeType[StiQRCodeBodyShapeType["RoundedSquare"] = 1] = "RoundedSquare";
    StiQRCodeBodyShapeType[StiQRCodeBodyShapeType["Dot"] = 2] = "Dot";
    StiQRCodeBodyShapeType[StiQRCodeBodyShapeType["Circle"] = 3] = "Circle";
    StiQRCodeBodyShapeType[StiQRCodeBodyShapeType["Diamond"] = 4] = "Diamond";
    StiQRCodeBodyShapeType[StiQRCodeBodyShapeType["Star"] = 5] = "Star";
    StiQRCodeBodyShapeType[StiQRCodeBodyShapeType["ZebraHorizontal"] = 6] = "ZebraHorizontal";
    StiQRCodeBodyShapeType[StiQRCodeBodyShapeType["ZebraVertical"] = 7] = "ZebraVertical";
    StiQRCodeBodyShapeType[StiQRCodeBodyShapeType["ZebraCross1"] = 8] = "ZebraCross1";
    StiQRCodeBodyShapeType[StiQRCodeBodyShapeType["ZebraCross2"] = 9] = "ZebraCross2";
    StiQRCodeBodyShapeType[StiQRCodeBodyShapeType["Circular"] = 10] = "Circular";
    StiQRCodeBodyShapeType[StiQRCodeBodyShapeType["DockedDiamonds"] = 11] = "DockedDiamonds";
})(StiQRCodeBodyShapeType || (StiQRCodeBodyShapeType = {}));
var StiQRCodeEyeFrameShapeType;
(function (StiQRCodeEyeFrameShapeType) {
    StiQRCodeEyeFrameShapeType[StiQRCodeEyeFrameShapeType["Square"] = 0] = "Square";
    StiQRCodeEyeFrameShapeType[StiQRCodeEyeFrameShapeType["Dots"] = 1] = "Dots";
    StiQRCodeEyeFrameShapeType[StiQRCodeEyeFrameShapeType["Circle"] = 2] = "Circle";
    StiQRCodeEyeFrameShapeType[StiQRCodeEyeFrameShapeType["Round"] = 3] = "Round";
    StiQRCodeEyeFrameShapeType[StiQRCodeEyeFrameShapeType["Round1"] = 4] = "Round1";
    StiQRCodeEyeFrameShapeType[StiQRCodeEyeFrameShapeType["Round3"] = 5] = "Round3";
})(StiQRCodeEyeFrameShapeType || (StiQRCodeEyeFrameShapeType = {}));
var StiQRCodeEyeBallShapeType;
(function (StiQRCodeEyeBallShapeType) {
    StiQRCodeEyeBallShapeType[StiQRCodeEyeBallShapeType["Square"] = 0] = "Square";
    StiQRCodeEyeBallShapeType[StiQRCodeEyeBallShapeType["Dots"] = 1] = "Dots";
    StiQRCodeEyeBallShapeType[StiQRCodeEyeBallShapeType["Circle"] = 2] = "Circle";
    StiQRCodeEyeBallShapeType[StiQRCodeEyeBallShapeType["Round"] = 3] = "Round";
    StiQRCodeEyeBallShapeType[StiQRCodeEyeBallShapeType["Round1"] = 4] = "Round1";
    StiQRCodeEyeBallShapeType[StiQRCodeEyeBallShapeType["Round3"] = 5] = "Round3";
    StiQRCodeEyeBallShapeType[StiQRCodeEyeBallShapeType["Star"] = 6] = "Star";
    StiQRCodeEyeBallShapeType[StiQRCodeEyeBallShapeType["ZebraHorizontal"] = 7] = "ZebraHorizontal";
    StiQRCodeEyeBallShapeType[StiQRCodeEyeBallShapeType["ZebraVertical"] = 8] = "ZebraVertical";
})(StiQRCodeEyeBallShapeType || (StiQRCodeEyeBallShapeType = {}));
var StiBrushIdent;
(function (StiBrushIdent) {
    StiBrushIdent[StiBrushIdent["Empty"] = 1] = "Empty";
    StiBrushIdent[StiBrushIdent["Solid"] = 2] = "Solid";
    StiBrushIdent[StiBrushIdent["Gradient"] = 3] = "Gradient";
    StiBrushIdent[StiBrushIdent["Glare"] = 4] = "Glare";
    StiBrushIdent[StiBrushIdent["Glass"] = 5] = "Glass";
    StiBrushIdent[StiBrushIdent["Hatch"] = 6] = "Hatch";
    StiBrushIdent[StiBrushIdent["Default"] = 7] = "Default";
    StiBrushIdent[StiBrushIdent["Style"] = 8] = "Style";
})(StiBrushIdent || (StiBrushIdent = {}));
var StiBodyBrush;
(function (StiBodyBrush) {
    StiBodyBrush[StiBodyBrush["Empty"] = 1] = "Empty";
    StiBodyBrush[StiBodyBrush["Solid"] = 2] = "Solid";
    StiBodyBrush[StiBodyBrush["Hatch"] = 3] = "Hatch";
    StiBodyBrush[StiBodyBrush["Gradient"] = 4] = "Gradient";
    StiBodyBrush[StiBodyBrush["Glare"] = 5] = "Glare";
    StiBodyBrush[StiBodyBrush["Glass"] = 6] = "Glass";
})(StiBodyBrush || (StiBodyBrush = {}));
var StiButtonSendType;
(function (StiButtonSendType) {
    StiButtonSendType[StiButtonSendType["FDF"] = 0] = "FDF";
    StiButtonSendType[StiButtonSendType["HTML"] = 1] = "HTML";
    StiButtonSendType[StiButtonSendType["XFDF"] = 2] = "XFDF";
    StiButtonSendType[StiButtonSendType["PDF"] = 3] = "PDF";
})(StiButtonSendType || (StiButtonSendType = {}));
var StiUnitAlignment;
(function (StiUnitAlignment) {
    StiUnitAlignment[StiUnitAlignment["Prefix"] = 1] = "Prefix";
    StiUnitAlignment[StiUnitAlignment["Suffix"] = 2] = "Suffix";
    StiUnitAlignment[StiUnitAlignment["PrefixInside"] = 3] = "PrefixInside";
    StiUnitAlignment[StiUnitAlignment["PrefixInsideSpace"] = 4] = "PrefixInsideSpace";
    StiUnitAlignment[StiUnitAlignment["SuffixInside"] = 5] = "SuffixInside";
    StiUnitAlignment[StiUnitAlignment["SuffixInsideSpace"] = 6] = "SuffixInsideSpace";
})(StiUnitAlignment || (StiUnitAlignment = {}));
var StiSignatureType;
(function (StiSignatureType) {
    StiSignatureType[StiSignatureType["Signature"] = 1] = "Signature";
    StiSignatureType[StiSignatureType["DigitalSignature"] = 2] = "DigitalSignature";
})(StiSignatureType || (StiSignatureType = {}));
var ImageType;
(function (ImageType) {
    ImageType[ImageType["png"] = 0] = "png";
    ImageType[ImageType["jpg"] = 1] = "jpg";
})(ImageType || (ImageType = {}));
var StiPageOrientation;
(function (StiPageOrientation) {
    StiPageOrientation[StiPageOrientation["Portrait"] = 1] = "Portrait";
    StiPageOrientation[StiPageOrientation["Landscape"] = 2] = "Landscape";
})(StiPageOrientation || (StiPageOrientation = {}));
var StiDateBoxAlignment;
(function (StiDateBoxAlignment) {
    StiDateBoxAlignment[StiDateBoxAlignment["Left"] = 1] = "Left";
    StiDateBoxAlignment[StiDateBoxAlignment["Right"] = 2] = "Right";
    StiDateBoxAlignment[StiDateBoxAlignment["Inside"] = 3] = "Inside";
})(StiDateBoxAlignment || (StiDateBoxAlignment = {}));
var StiDateTimeBoxType;
(function (StiDateTimeBoxType) {
    StiDateTimeBoxType[StiDateTimeBoxType["Date"] = 1] = "Date";
    StiDateTimeBoxType[StiDateTimeBoxType["Time"] = 2] = "Time";
    StiDateTimeBoxType[StiDateTimeBoxType["DateTime"] = 3] = "DateTime";
})(StiDateTimeBoxType || (StiDateTimeBoxType = {}));
var StiDateTimeBoxValueChoise;
(function (StiDateTimeBoxValueChoise) {
    StiDateTimeBoxValueChoise[StiDateTimeBoxValueChoise["Current"] = 1] = "Current";
    StiDateTimeBoxValueChoise[StiDateTimeBoxValueChoise["Custom"] = 2] = "Custom";
    StiDateTimeBoxValueChoise[StiDateTimeBoxValueChoise["Null"] = 3] = "Null";
})(StiDateTimeBoxValueChoise || (StiDateTimeBoxValueChoise = {}));
var StiImageSize;
(function (StiImageSize) {
    StiImageSize[StiImageSize["Normal"] = 0] = "Normal";
    StiImageSize[StiImageSize["OneHalf"] = 1] = "OneHalf";
    StiImageSize[StiImageSize["Double"] = 2] = "Double";
})(StiImageSize || (StiImageSize = {}));
var SystemScaleID;
(function (SystemScaleID) {
    SystemScaleID[SystemScaleID["x1"] = 0] = "x1";
    SystemScaleID[SystemScaleID["x2"] = 1] = "x2";
    SystemScaleID[SystemScaleID["x3"] = 2] = "x3";
    SystemScaleID[SystemScaleID["x4"] = 3] = "x4";
})(SystemScaleID || (SystemScaleID = {}));
var SystemScaleIconID;
(function (SystemScaleIconID) {
    SystemScaleIconID[SystemScaleIconID["x100"] = 0] = "x100";
    SystemScaleIconID[SystemScaleIconID["x125"] = 1] = "x125";
    SystemScaleIconID[SystemScaleIconID["x150"] = 2] = "x150";
    SystemScaleIconID[SystemScaleIconID["x175"] = 3] = "x175";
    SystemScaleIconID[SystemScaleIconID["x200"] = 4] = "x200";
    SystemScaleIconID[SystemScaleIconID["x225"] = 5] = "x225";
    SystemScaleIconID[SystemScaleIconID["x250"] = 6] = "x250";
    SystemScaleIconID[SystemScaleIconID["x275"] = 7] = "x275";
    SystemScaleIconID[SystemScaleIconID["x300"] = 8] = "x300";
    SystemScaleIconID[SystemScaleIconID["x325"] = 9] = "x325";
    SystemScaleIconID[SystemScaleIconID["x350"] = 10] = "x350";
    SystemScaleIconID[SystemScaleIconID["x375"] = 11] = "x375";
    SystemScaleIconID[SystemScaleIconID["x400"] = 12] = "x400";
})(SystemScaleIconID || (SystemScaleIconID = {}));
var StiColumnType;
(function (StiColumnType) {
    StiColumnType[StiColumnType["CheckBox"] = 0] = "CheckBox";
    StiColumnType[StiColumnType["ComboBox"] = 1] = "ComboBox";
    StiColumnType[StiColumnType["RadioButton"] = 2] = "RadioButton";
    StiColumnType[StiColumnType["TextBox"] = 3] = "TextBox";
    StiColumnType[StiColumnType["NumberBox"] = 4] = "NumberBox";
})(StiColumnType || (StiColumnType = {}));
var StiVerticalAlignment;
(function (StiVerticalAlignment) {
    StiVerticalAlignment[StiVerticalAlignment["Top"] = 1] = "Top";
    StiVerticalAlignment[StiVerticalAlignment["Center"] = 2] = "Center";
    StiVerticalAlignment[StiVerticalAlignment["Bottom"] = 3] = "Bottom";
})(StiVerticalAlignment || (StiVerticalAlignment = {}));
var StiHorizontalAlignment;
(function (StiHorizontalAlignment) {
    StiHorizontalAlignment[StiHorizontalAlignment["Left"] = 1] = "Left";
    StiHorizontalAlignment[StiHorizontalAlignment["Center"] = 2] = "Center";
    StiHorizontalAlignment[StiHorizontalAlignment["Right"] = 3] = "Right";
})(StiHorizontalAlignment || (StiHorizontalAlignment = {}));
var StiPenStyle;
(function (StiPenStyle) {
    StiPenStyle[StiPenStyle["Solid"] = 0] = "Solid";
    StiPenStyle[StiPenStyle["Dash"] = 1] = "Dash";
    StiPenStyle[StiPenStyle["Dot"] = 2] = "Dot";
})(StiPenStyle || (StiPenStyle = {}));
var StiCategories;
(function (StiCategories) {
    StiCategories[StiCategories["General"] = 0] = "General";
    StiCategories[StiCategories["options"] = 1] = "options";
    StiCategories[StiCategories["Validation"] = 2] = "Validation";
    StiCategories[StiCategories["Visibility"] = 3] = "Visibility";
    StiCategories[StiCategories["Appearance"] = 4] = "Appearance";
})(StiCategories || (StiCategories = {}));
var StiAlgorithmExpression;
(function (StiAlgorithmExpression) {
    StiAlgorithmExpression[StiAlgorithmExpression["NumberCellValue"] = 0] = "NumberCellValue";
    StiAlgorithmExpression[StiAlgorithmExpression["NumberColumnMax"] = 1] = "NumberColumnMax";
    StiAlgorithmExpression[StiAlgorithmExpression["NumberColumnSum"] = 2] = "NumberColumnSum";
    StiAlgorithmExpression[StiAlgorithmExpression["Constant"] = 3] = "Constant";
})(StiAlgorithmExpression || (StiAlgorithmExpression = {}));
var PaperKind;
(function (PaperKind) {
    PaperKind[PaperKind["Custom"] = 0] = "Custom";
    PaperKind[PaperKind["Letter"] = 1] = "Letter";
    PaperKind[PaperKind["LetterSmall"] = 2] = "LetterSmall";
    PaperKind[PaperKind["Tabloid"] = 3] = "Tabloid";
    PaperKind[PaperKind["Ledger"] = 4] = "Ledger";
    PaperKind[PaperKind["Legal"] = 5] = "Legal";
    PaperKind[PaperKind["Statement"] = 6] = "Statement";
    PaperKind[PaperKind["Executive"] = 7] = "Executive";
    PaperKind[PaperKind["A3"] = 8] = "A3";
    PaperKind[PaperKind["A4"] = 9] = "A4";
    PaperKind[PaperKind["A4Small"] = 10] = "A4Small";
    PaperKind[PaperKind["A5"] = 11] = "A5";
    PaperKind[PaperKind["B4"] = 12] = "B4";
    PaperKind[PaperKind["B5"] = 13] = "B5";
    PaperKind[PaperKind["Folio"] = 14] = "Folio";
    PaperKind[PaperKind["Quarto"] = 15] = "Quarto";
    PaperKind[PaperKind["Standard10x14"] = 16] = "Standard10x14";
    PaperKind[PaperKind["Standard11x17"] = 17] = "Standard11x17";
    PaperKind[PaperKind["Note"] = 18] = "Note";
    PaperKind[PaperKind["Number9Envelope"] = 19] = "Number9Envelope";
    PaperKind[PaperKind["Number10Envelope"] = 20] = "Number10Envelope";
    PaperKind[PaperKind["Number11Envelope"] = 21] = "Number11Envelope";
    PaperKind[PaperKind["Number12Envelope"] = 22] = "Number12Envelope";
    PaperKind[PaperKind["Number14Envelope"] = 23] = "Number14Envelope";
    PaperKind[PaperKind["CSheet"] = 24] = "CSheet";
    PaperKind[PaperKind["DSheet"] = 25] = "DSheet";
    PaperKind[PaperKind["ESheet"] = 26] = "ESheet";
    PaperKind[PaperKind["DLEnvelope"] = 27] = "DLEnvelope";
    PaperKind[PaperKind["C5Envelope"] = 28] = "C5Envelope";
    PaperKind[PaperKind["C3Envelope"] = 29] = "C3Envelope";
    PaperKind[PaperKind["C4Envelope"] = 30] = "C4Envelope";
    PaperKind[PaperKind["C6Envelope"] = 31] = "C6Envelope";
    PaperKind[PaperKind["C65Envelope"] = 32] = "C65Envelope";
    PaperKind[PaperKind["B4Envelope"] = 33] = "B4Envelope";
    PaperKind[PaperKind["B5Envelope"] = 34] = "B5Envelope";
    PaperKind[PaperKind["B6Envelope"] = 35] = "B6Envelope";
    PaperKind[PaperKind["ItalyEnvelope"] = 36] = "ItalyEnvelope";
    PaperKind[PaperKind["MonarchEnvelope"] = 37] = "MonarchEnvelope";
    PaperKind[PaperKind["PersonalEnvelope"] = 38] = "PersonalEnvelope";
    PaperKind[PaperKind["USStandardFanfold"] = 39] = "USStandardFanfold";
    PaperKind[PaperKind["GermanStandardFanfold"] = 40] = "GermanStandardFanfold";
    PaperKind[PaperKind["GermanLegalFanfold"] = 41] = "GermanLegalFanfold";
    PaperKind[PaperKind["IsoB4"] = 42] = "IsoB4";
    PaperKind[PaperKind["JapanesePostcard"] = 43] = "JapanesePostcard";
    PaperKind[PaperKind["Standard9x11"] = 44] = "Standard9x11";
    PaperKind[PaperKind["Standard10x11"] = 45] = "Standard10x11";
    PaperKind[PaperKind["Standard15x11"] = 46] = "Standard15x11";
    PaperKind[PaperKind["InviteEnvelope"] = 47] = "InviteEnvelope";
    PaperKind[PaperKind["LetterExtra"] = 50] = "LetterExtra";
    PaperKind[PaperKind["LegalExtra"] = 51] = "LegalExtra";
    PaperKind[PaperKind["TabloidExtra"] = 52] = "TabloidExtra";
    PaperKind[PaperKind["A4Extra"] = 53] = "A4Extra";
    PaperKind[PaperKind["LetterTransverse"] = 54] = "LetterTransverse";
    PaperKind[PaperKind["A4Transverse"] = 55] = "A4Transverse";
    PaperKind[PaperKind["LetterExtraTransverse"] = 56] = "LetterExtraTransverse";
    PaperKind[PaperKind["APlus"] = 57] = "APlus";
    PaperKind[PaperKind["BPlus"] = 58] = "BPlus";
    PaperKind[PaperKind["LetterPlus"] = 59] = "LetterPlus";
    PaperKind[PaperKind["A4Plus"] = 60] = "A4Plus";
    PaperKind[PaperKind["A5Transverse"] = 61] = "A5Transverse";
    PaperKind[PaperKind["B5Transverse"] = 62] = "B5Transverse";
    PaperKind[PaperKind["A3Extra"] = 63] = "A3Extra";
    PaperKind[PaperKind["A5Extra"] = 64] = "A5Extra";
    PaperKind[PaperKind["B5Extra"] = 65] = "B5Extra";
    PaperKind[PaperKind["A2"] = 66] = "A2";
    PaperKind[PaperKind["A3Transverse"] = 67] = "A3Transverse";
    PaperKind[PaperKind["A3ExtraTransverse"] = 68] = "A3ExtraTransverse";
    PaperKind[PaperKind["JapaneseDoublePostcard"] = 69] = "JapaneseDoublePostcard";
    PaperKind[PaperKind["A6"] = 70] = "A6";
    PaperKind[PaperKind["JapaneseEnvelopeKakuNumber2"] = 71] = "JapaneseEnvelopeKakuNumber2";
    PaperKind[PaperKind["JapaneseEnvelopeKakuNumber3"] = 72] = "JapaneseEnvelopeKakuNumber3";
    PaperKind[PaperKind["JapaneseEnvelopeChouNumber3"] = 73] = "JapaneseEnvelopeChouNumber3";
    PaperKind[PaperKind["JapaneseEnvelopeChouNumber4"] = 74] = "JapaneseEnvelopeChouNumber4";
    PaperKind[PaperKind["LetterRotated"] = 75] = "LetterRotated";
    PaperKind[PaperKind["A3Rotated"] = 76] = "A3Rotated";
    PaperKind[PaperKind["A4Rotated"] = 77] = "A4Rotated";
    PaperKind[PaperKind["A5Rotated"] = 78] = "A5Rotated";
    PaperKind[PaperKind["B4JisRotated"] = 79] = "B4JisRotated";
    PaperKind[PaperKind["B5JisRotated"] = 80] = "B5JisRotated";
    PaperKind[PaperKind["JapanesePostcardRotated"] = 81] = "JapanesePostcardRotated";
    PaperKind[PaperKind["JapaneseDoublePostcardRotated"] = 82] = "JapaneseDoublePostcardRotated";
    PaperKind[PaperKind["A6Rotated"] = 83] = "A6Rotated";
    PaperKind[PaperKind["JapaneseEnvelopeKakuNumber2Rotated"] = 84] = "JapaneseEnvelopeKakuNumber2Rotated";
    PaperKind[PaperKind["JapaneseEnvelopeKakuNumber3Rotated"] = 85] = "JapaneseEnvelopeKakuNumber3Rotated";
    PaperKind[PaperKind["JapaneseEnvelopeChouNumber3Rotated"] = 86] = "JapaneseEnvelopeChouNumber3Rotated";
    PaperKind[PaperKind["JapaneseEnvelopeChouNumber4Rotated"] = 87] = "JapaneseEnvelopeChouNumber4Rotated";
    PaperKind[PaperKind["B6Jis"] = 88] = "B6Jis";
    PaperKind[PaperKind["B6JisRotated"] = 89] = "B6JisRotated";
    PaperKind[PaperKind["Standard12x11"] = 90] = "Standard12x11";
    PaperKind[PaperKind["JapaneseEnvelopeYouNumber4"] = 91] = "JapaneseEnvelopeYouNumber4";
    PaperKind[PaperKind["JapaneseEnvelopeYouNumber4Rotated"] = 92] = "JapaneseEnvelopeYouNumber4Rotated";
    PaperKind[PaperKind["Prc16K"] = 93] = "Prc16K";
    PaperKind[PaperKind["Prc32K"] = 94] = "Prc32K";
    PaperKind[PaperKind["Prc32KBig"] = 95] = "Prc32KBig";
    PaperKind[PaperKind["PrcEnvelopeNumber1"] = 96] = "PrcEnvelopeNumber1";
    PaperKind[PaperKind["PrcEnvelopeNumber2"] = 97] = "PrcEnvelopeNumber2";
    PaperKind[PaperKind["PrcEnvelopeNumber3"] = 98] = "PrcEnvelopeNumber3";
    PaperKind[PaperKind["PrcEnvelopeNumber4"] = 99] = "PrcEnvelopeNumber4";
    PaperKind[PaperKind["PrcEnvelopeNumber5"] = 100] = "PrcEnvelopeNumber5";
    PaperKind[PaperKind["PrcEnvelopeNumber6"] = 101] = "PrcEnvelopeNumber6";
    PaperKind[PaperKind["PrcEnvelopeNumber7"] = 102] = "PrcEnvelopeNumber7";
    PaperKind[PaperKind["PrcEnvelopeNumber8"] = 103] = "PrcEnvelopeNumber8";
    PaperKind[PaperKind["PrcEnvelopeNumber9"] = 104] = "PrcEnvelopeNumber9";
    PaperKind[PaperKind["PrcEnvelopeNumber10"] = 105] = "PrcEnvelopeNumber10";
    PaperKind[PaperKind["Prc16KRotated"] = 106] = "Prc16KRotated";
    PaperKind[PaperKind["Prc32KRotated"] = 107] = "Prc32KRotated";
    PaperKind[PaperKind["Prc32KBigRotated"] = 108] = "Prc32KBigRotated";
    PaperKind[PaperKind["PrcEnvelopeNumber1Rotated"] = 109] = "PrcEnvelopeNumber1Rotated";
    PaperKind[PaperKind["PrcEnvelopeNumber2Rotated"] = 110] = "PrcEnvelopeNumber2Rotated";
    PaperKind[PaperKind["PrcEnvelopeNumber3Rotated"] = 111] = "PrcEnvelopeNumber3Rotated";
    PaperKind[PaperKind["PrcEnvelopeNumber4Rotated"] = 112] = "PrcEnvelopeNumber4Rotated";
    PaperKind[PaperKind["PrcEnvelopeNumber5Rotated"] = 113] = "PrcEnvelopeNumber5Rotated";
    PaperKind[PaperKind["PrcEnvelopeNumber6Rotated"] = 114] = "PrcEnvelopeNumber6Rotated";
    PaperKind[PaperKind["PrcEnvelopeNumber7Rotated"] = 115] = "PrcEnvelopeNumber7Rotated";
    PaperKind[PaperKind["PrcEnvelopeNumber8Rotated"] = 116] = "PrcEnvelopeNumber8Rotated";
    PaperKind[PaperKind["PrcEnvelopeNumber9Rotated"] = 117] = "PrcEnvelopeNumber9Rotated";
    PaperKind[PaperKind["PrcEnvelopeNumber10Rotated"] = 118] = "PrcEnvelopeNumber10Rotated";
})(PaperKind || (PaperKind = {}));
var DayOfWeek;
(function (DayOfWeek) {
    DayOfWeek[DayOfWeek["Sunday"] = 0] = "Sunday";
    DayOfWeek[DayOfWeek["Monday"] = 1] = "Monday";
    DayOfWeek[DayOfWeek["Tuesday"] = 2] = "Tuesday";
    DayOfWeek[DayOfWeek["Wednesday"] = 3] = "Wednesday";
    DayOfWeek[DayOfWeek["Thursday"] = 4] = "Thursday";
    DayOfWeek[DayOfWeek["Friday"] = 5] = "Friday";
    DayOfWeek[DayOfWeek["Saturday"] = 6] = "Saturday";
})(DayOfWeek || (DayOfWeek = {}));
var StiFormSaveMode;
(function (StiFormSaveMode) {
    StiFormSaveMode[StiFormSaveMode["Automatic"] = 0] = "Automatic";
    StiFormSaveMode[StiFormSaveMode["Manual"] = 1] = "Manual";
})(StiFormSaveMode || (StiFormSaveMode = {}));

class TimeSpan {
    constructor(param1 = 0, minutes = null, seconds = null, milliseconds = null) {
        this._minus = false;
        if (minutes == null) {
            this.ticks = param1;
        }
        else {
            let hours1 = param1;
            if (milliseconds == null)
                milliseconds = 0;
            this.ticks = TimeSpan.timeToTicks(0, hours1, minutes, seconds, milliseconds);
        }
    }
    get zero() {
        return new TimeSpan();
    }
    static getNetTypeName() {
        return "System.TimeSpan";
    }
    static minValue() {
        if (this._minValue == null)
            this._minValue = new TimeSpan(0, 0, Number.MIN_VALUE);
        return this._minValue;
    }
    static maxValue() {
        if (this._maxValue == null)
            this._maxValue = new TimeSpan(0, 0, Number.MAX_VALUE);
        return this._maxValue;
    }
    get days() {
        return Math.floor(this.ticks / TimeSpan.ticksPerDay);
    }
    get hours() {
        return Math.floor(this.ticks / TimeSpan.ticksPerHour) % 24;
    }
    get milliseconds() {
        return Math.floor(this.ticks / TimeSpan.ticksPerMillisecond) % 1000;
    }
    get minutes() {
        return Math.floor(this.ticks / TimeSpan.ticksPerMinute) % 60;
    }
    get seconds() {
        return Math.floor(this.ticks / TimeSpan.ticksPerSecond) % 60;
    }
    get totalDays() {
        return this.ticks * TimeSpan.daysPerTick;
    }
    get totalHours() {
        return this.ticks * TimeSpan.hoursPerTick;
    }
    get totalMilliseconds() {
        let temp = this.ticks * TimeSpan.millisecondsPerTick;
        if (temp > TimeSpan.maxMilliSeconds)
            return TimeSpan.maxMilliSeconds;
        if (temp < TimeSpan.minMilliSeconds)
            return TimeSpan.minMilliSeconds;
        return temp;
    }
    get totalMinutes() {
        return this.ticks * TimeSpan.minutesPerTick;
    }
    get totalSeconds() {
        return this.ticks * TimeSpan.secondsPerTick;
    }
    static fromString(value, format = null) {
        if (value == null)
            return null;
        let isDefaultFormat = false;
        if (format == null || format.length == 0) {
            format = "hh:mm:ss";
            isDefaultFormat = true;
        }
        let days = 0;
        let hours = 0;
        let minutes = 0;
        let seconds = 0;
        let milliseconds = 0;
        let char;
        let pos = 0;
        let values = [];
        let stringValues = [];
        let minus = false;
        // Parse time into separate numeric values
        while (pos < value.length) {
            char = value.charAt(pos);
            if (Char.isDigit(char)) {
                stringValues.push(char);
                pos++;
                while (pos < value.length && Char.isDigit(char = value.charAt(pos))) {
                    stringValues[stringValues.length - 1] += value.charAt(pos);
                    pos++;
                }
                values.push(+(stringValues[stringValues.length - 1]));
            }
            else if (char == "-")
                minus = true;
            if (isDefaultFormat && char === ".") {
                if (values.length === 1)
                    format = "d.hh:mm:ss";
                else
                    format += ".f";
            }
            pos++;
        }
        pos = 0;
        let index = -1;
        // Parsing format and replacement of appropriate values of time
        while (pos < format.length && index + 1 < values.length) {
            char = format.charAt(pos);
            if (char === "d" || char === "h" || char === "H" || char === "m" || char === "s" || char === "f" || char === "F") {
                index++;
                while (pos < format.length && format.charAt(pos) === char)
                    pos++;
            }
            switch (char) {
                case "d": // days
                    days = values[index];
                    break;
                case "h":
                case "H": // hours
                    hours = values[index];
                    break;
                case "m": // minutes
                    minutes = values[index];
                    break;
                case "s": // seconds
                    seconds = values[index];
                    break;
                case "f":
                case "F": // seconds fraction
                    milliseconds = values[index];
                    break;
                default:
                    pos++;
                    break;
            }
        }
        let timeSpan = TimeSpan.create(days, hours, minutes, seconds, milliseconds);
        timeSpan._minus = minus;
        return timeSpan;
    }
    static interval(value, scale) {
        let tmp = value * scale;
        let millis = tmp + (value >= 0 ? 0.5 : -0.5);
        return new TimeSpan(millis * TimeSpan.ticksPerMillisecond);
    }
    /* static fromTicks(value: number): TimeSpan {
       return new TimeSpan(value);
     }
  
     static fromSeconds(value: number): TimeSpan {
       return this.interval(value, this.millisPerSecond);
     }
  
     static fromMilliseconds(value: number): TimeSpan {
       return this.interval(value, 1);
     }
  
     add(value: number): TimeSpan {
       return new TimeSpan(this.ticks + value);
     }
  
     add2(value: TimeSpan): TimeSpan {
       return new TimeSpan(this.ticks + value.ticks);
     }*/
    toString(format) {
        if (format == null || format.length == 0) {
            format = "hh:mm:ss";
            if (this.days != 0) {
                format = "d.hh:mm:ss";
            }
        }
        /*switch (format) {
          case "t":
            format = CultureInfo.currentCulture.dateTimeFormat.shortTimePattern;
            break;
          case "T":
            format = CultureInfo.currentCulture.dateTimeFormat.longTimePattern;
            break;
        }
    
        format = format.replace(/H/gm, "h");
    */
        let result = "";
        let pos = 0;
        let isDays = false;
        /*  while (pos < format.length) {
            let f = format.charAt(pos);
    
            if (!Char.isLetter(f)) {
              result += f;
              pos++;
              continue;
            }
    
            while (pos + 1 < format.length && Char.isLetter(format.charAt(pos + 1))) {
              pos++;
              f += format.charAt(pos);
            }
    
            switch (f[0]) {
              case "d":
                isDays = true;
                result += Math.abs(this.days).toString().ss.padLeft(f.length, "0");
                break;
              case "h":
                result += Math.abs(isDays ? this.hours : StiMath.trunc(StiMath.round2(this.totalHours, 2))).toString().ss.padLeft(f.length, "0");
                break;
              case "m":
                result += Math.abs(this.minutes).toString().ss.padLeft(f.length, "0");
                break;
              case "s":
                result += Math.abs(this.seconds).toString().ss.padLeft(f.length, "0");
                break;
              case "f":
                result += Math.abs(this.milliseconds).toString().ss.padLeft(f.length, "0");
                break
              case "F":
                if (this.milliseconds != 0)
                  result += Math.abs(this.milliseconds).toString().ss.padLeft(f.length, "0");
                break;
            }
            pos++;
          }
    
          if (this._minus) return "-" + result;*/
        return result;
    }
    negate() {
        if (this.ticks == TimeSpan.minValue().ticks)
            throw new Error("Overflow_NegateTwosCompNum");
        return new TimeSpan(-this.ticks);
    }
    static timeToTicks(day, hour, minute, second, milliseconds) {
        let totalSeconds = day * 86400 + hour * 3600 + minute * 60 + second;
        return totalSeconds * TimeSpan.ticksPerSecond;
    }
    static create(days = 0, hours = 0, minutes = 0, seconds = 0, milliseconds = 0) {
        return null; // new TimeSpan(TimeSpan.timeToTicks(days, hours, minutes, seconds, milliseconds));
    }
}
TimeSpan.ticksPerMillisecond = 1;
TimeSpan.millisecondsPerTick = 1 / TimeSpan.ticksPerMillisecond;
TimeSpan.ticksPerSecond = TimeSpan.ticksPerMillisecond * 1000;
TimeSpan.secondsPerTick = 1 / TimeSpan.ticksPerSecond;
TimeSpan.ticksPerMinute = TimeSpan.ticksPerSecond * 60;
TimeSpan.minutesPerTick = 1 / TimeSpan.ticksPerMinute;
TimeSpan.ticksPerHour = TimeSpan.ticksPerMinute * 60;
TimeSpan.hoursPerTick = 1 / TimeSpan.ticksPerHour;
TimeSpan.ticksPerDay = TimeSpan.ticksPerHour * 24;
TimeSpan.daysPerTick = 1 / TimeSpan.ticksPerDay;
TimeSpan.millisPerSecond = 1000;
TimeSpan.millisPerMinute = TimeSpan.millisPerSecond * 60;
TimeSpan.millisPerHour = TimeSpan.millisPerMinute * 60;
TimeSpan.millisPerDay = TimeSpan.millisPerHour * 24;
TimeSpan.maxSeconds = Number.MAX_VALUE / TimeSpan.ticksPerSecond;
TimeSpan.minSeconds = Number.MIN_VALUE / TimeSpan.ticksPerSecond;
TimeSpan.maxMilliSeconds = Number.MAX_VALUE / TimeSpan.ticksPerMillisecond;
TimeSpan.minMilliSeconds = Number.MIN_VALUE / TimeSpan.ticksPerMillisecond;
TimeSpan.ticksPerTenthSecond = TimeSpan.ticksPerMillisecond * 100;
TimeSpan._minValue = null;
TimeSpan._maxValue = null;

class DateTime {
    constructor(param1, month, day, hour, minute, second, millisecond) {
        this.DateTimeOffset = "";
        if (typeof param1 == "undefined") {
            this.innerDate = new Date();
        }
        else if (typeof param1 != "number" && param1 instanceof Date) {
            this.innerDate = param1; // set date
        }
        else {
            if (!month) {
                this.innerDate = new Date();
                this.innerDate.setTime(param1); // set ticks
            }
            else {
                this.innerDate = new Date();
                this.innerDate.setFullYear(param1);
                this.innerDate.setMonth(month - 1);
                this.innerDate.setDate(day || 1);
                this.innerDate.setHours(hour || 0);
                this.innerDate.setMinutes(minute || 0);
                this.innerDate.setSeconds(second || 0);
                this.innerDate.setMilliseconds(millisecond || 0);
            }
        }
    }
    static getNetTypeName() {
        return "System.DateTime";
    }
    get year() {
        return this.innerDate.getFullYear();
    }
    get month() {
        return this.innerDate.getMonth() + 1;
    }
    /*get monthName(): string {
      return CultureInfo.currentCulture.dateTimeFormat.monthNames[this.month - 1];
    }
  
    get monthGenitiveName(): string {
      return CultureInfo.currentCulture.dateTimeFormat.monthGenitiveNames[this.month - 1];
    }
  
    get monthShortName(): string {
      return CultureInfo.currentCulture.dateTimeFormat.abbreviatedMonthNames[this.month - 1];
    }*/
    get day() {
        return this.innerDate.getDate();
    }
    /** 0 – Sunday, 1 – Monday etc */
    get dayOfWeek() {
        return this.innerDate.getDay();
    }
    /*get dayName(): string {
      return CultureInfo.currentCulture.dateTimeFormat.dayNames[this.dayOfWeek];
    }
  
    get dayShortName(): string {
      return CultureInfo.currentCulture.dateTimeFormat.shortestDayNames[this.dayOfWeek];
    }*/
    get hour() {
        return this.innerDate.getHours();
    }
    get minute() {
        return this.innerDate.getMinutes();
    }
    get second() {
        return this.innerDate.getSeconds();
    }
    get millisecond() {
        return this.innerDate.getMilliseconds();
    }
    get ticks() {
        return this.innerDate.getTime();
    }
    get dayOfYear() {
        let oneJan = new Date(this.innerDate.getFullYear(), 0, 1);
        let diff = this.innerDate.getTime() - oneJan.getTime();
        return Math.ceil(diff / 86400000) + 1;
    }
    /*firstDayOfWeek(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.startOf("week").toDate());
    }
  
    lastDayOfWeek(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.endOf("week").toDate());
    }
  
    firstDayOfMonth(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.startOf("month").toDate());
    }
  
    lastDayOfMonth(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.endOf("month").toDate());
    }
  
    firstDayOfQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.startOf("quarter").toDate());
    }
  
    lastDayOfQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.endOf("quarter").toDate());
    }
  
    firstDayOfFirthQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs().month(0);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.startOf("quarter").toDate());
    }
  
    lastDayOfFirthQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs().month(0);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.endOf("quarter").toDate());
    }
  
    firstDayOfSecondQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs().month(3);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.startOf("quarter").toDate());
    }
  
    lastDayOfSecondQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs().month(3);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.endOf("quarter").toDate());
    }
  
    firstDayOfThirdQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs().month(6);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.startOf("quarter").toDate());
    }
  
    lastDayOfThirdQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs().month(6);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.endOf("quarter").toDate());
    }
  
    firstDayOfFourthQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs().month(9);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.startOf("quarter").toDate());
    }
  
    lastDayOfFourthQuarter(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs().month(9);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.endOf("quarter").toDate());
    }
  
    firstDayOfYear(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.startOf("year").toDate());
    }
  
    lastDayOfYear(): DateTime {
      let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
      dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
      return new DateTime(dayjsDate.endOf("year").toDate());
    }
  
    toShortDateString(): string {
      return this.toString(CultureInfo.currentCulture.dateTimeFormat.shortDatePattern);
    }
  
    toShortTimeString(): string {
      return this.toString(CultureInfo.currentCulture.dateTimeFormat.shortTimePattern);
    }*/
    static now() {
        return new DateTime(new Date());
    }
    static today() {
        let today = new DateTime(new Date());
        return new DateTime(today.year, today.month, today.day, 0, 0, 0, 0);
    }
    static isLeapYear(year) {
        return ((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0);
    }
    /** The month number ranging from 1 to 12. JS calculate month from 0. This will even work for December. */
    static daysInMonth(year, month) {
        return 33 - new Date(year, month - 1, 33).getDate();
    }
    static compare(t1, t2) {
        if (t1.ticks < t2.ticks)
            return -1;
        if (t1.ticks > t2.ticks)
            return 1;
        return 0;
    }
    static doubleDateToTicks(value) {
        if (value >= this.oADateMaxAsDouble || value <= this.oADateMinAsDouble)
            return null;
        let millis = (value * this.millisPerDay + (value >= 0 ? 0.5 : -0.5));
        // The interesting thing here is when you have a value like 12.5 it all positive 12 days and 12 hours from 01/01/1899
        // However if you a value of -12.25 it is minus 12 days but still positive 6 hours, almost as though you meant -11.75 all negative
        // This line below fixes up the millis in the negative case
        if (millis < 0) {
            millis -= (millis % this.millisPerDay) * 2;
        }
        millis += this.doubleDateOffset / this.ticksPerMillisecond;
        if (millis < 0 || millis >= this.maxMillis)
            return null;
        return millis * this.ticksPerMillisecond;
    }
    // private static ticksToOADate(value: number): number {
    //     //The time value for the date 1899-12-30 is -2209197600000 milliseconds
    //     let millis: number = (value + 2209197600000) / this.ticksPerMillisecond;
    //     if (millis < 0) {
    //         let frac: number = millis % this.millisPerDay;
    //         if (frac != 0) millis -= (this.millisPerDay + frac) * 2;
    //     }
    //     return millis / this.millisPerDay * 1000;
    // }
    toString(format = "G") {
        /*let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(this.innerDate);
        if (!dayjsDate.isValid()) return "";
        dayjsDate = dayjsDate.locale(`sti_${CultureInfo.currentCulture.name}`);
    
    
        LT: culture.dateTimeFormat.shortTimePattern,
        LTS: culture.dateTimeFormat.longTimePattern,
        L: culture.dateTimeFormat.shortDatePattern,
        LLL: culture.dateTimeFormat.longDatePattern,
        LLLL: culture.dateTimeFormat.fullDateTimePattern
    
        t	ShortTimePattern	h:mm tt       LT: "h:mm A",
        T	LongTimePattern	    h:mm:ss tt    LTS: "h:mm:ss A",
    
        d	ShortDatePattern	M/d/yyyy                L: "M/D/YYYY",
        D	LongDatePattern	    dddd, MMMM dd, yyyy     LLL: "MMMM Do YYYY",
    
        f	(combination of D and t)	dddd, MMMM dd, yyyy h:mm tt
        F	FullDateTimePattern	        dddd, MMMM dd, yyyy h:mm:ss tt LLLL: "dddd, MMMM Do YYYY LT",
    
        g	(combination of d and t)	M/d/yyyy h:mm tt
        G	(combination of d and T)	M/d/yyyy h:mm:ss tt
        */
        /*switch (format) {
          case "t":
            format = CultureInfo.currentCulture.dateTimeFormat.shortTimePattern;
            break;
          case "T":
            format = CultureInfo.currentCulture.dateTimeFormat.longTimePattern;
            break;
          case "d":
            format = CultureInfo.currentCulture.dateTimeFormat.shortDatePattern;
            break;
          case "D":
            format = CultureInfo.currentCulture.dateTimeFormat.longDatePattern;
            break;
          case "f":
            format = CultureInfo.currentCulture.dateTimeFormat.longDatePattern + " " + CultureInfo.currentCulture.dateTimeFormat.shortTimePattern;
            break;
          case "F":
            format = CultureInfo.currentCulture.dateTimeFormat.fullDateTimePattern;
            break;
          case "g":
            format = CultureInfo.currentCulture.dateTimeFormat.shortDatePattern + " " + CultureInfo.currentCulture.dateTimeFormat.shortTimePattern;
            break;
          case "G":
            format = CultureInfo.currentCulture.dateTimeFormat.shortDatePattern + " " + CultureInfo.currentCulture.dateTimeFormat.longTimePattern;
            break;
          case "y":
          case "Y":
            format = CultureInfo.currentCulture.dateTimeFormat.yearMonthPattern;
            break;
          case "s":
            format = "yyyy-MM-dd\\THH:mm:ss";
            break;// ISO
          case "u":
            format = "yyyy-MM-dd HH:mm:ss\\Z";
            break;// ISO
          case "m":
          case "M":   // MonthDayPattern;
            format = CultureInfo.currentCulture.name.ss.contains("en") || CultureInfo.currentCulture.name.ss.contains("us") ? "MMMM d" : "d MMMM";
            break;
          case "r":
          case "R":   // The RFC1123 Format Specifier
            format = "ddd, dd MMM yyyy HH\\:mm\\:ss \\G\\M\\T";
            break;
        }*/
        format = format.replace(/d/gm, "D").replace(/DDDD/gm, "dddd").replace(/DDD/gm, "ddd");
        format = format.replace(/y/gm, "Y");
        format = format.replace(/f/gm, "S").replace(/F/gm, "S");
        format = format.replace(/tt/gm, "A").replace(/t/gm, "A");
        format = format.replace(/zzz/gm, "Z").replace(/zz/gm, "Z").replace(/z/gm, "Z");
        return format + this.DateTimeOffset;
    }
    static ticksNetToTicksJs(ticks) {
        // ticks are in nanotime; convert to microtime
        let ticksToMicrotime = ticks / 10000;
        // ticks are recorded from 1/1/1; get microtime difference from 1/1/1/ to 1/1/1970
        let epochMicrotimeDiff = 62135607600000; // Math.abs(new Date(0, 0, 1).setFullYear(1))
        return ticksToMicrotime - epochMicrotimeDiff;
    }
    negate() {
        if (this.ticks == TimeSpan.minValue().ticks)
            throw new Error("Overflow_NegateTwosCompNum");
        return new DateTime(-this.ticks);
    }
    addYears(value) {
        return new DateTime(this.year + value, this.month, this.day, this.hour, this.minute, this.second, this.millisecond);
    }
    addMonths(value) {
        let newMonth = this.month + value;
        let newYear = this.year;
        if (newMonth < 1) {
            newYear--;
            newMonth = 12 + newMonth;
        }
        return new DateTime(newYear, newMonth, this.day, this.hour, this.minute, this.second, this.millisecond);
    }
    /*addDays(value: number): DateTime {
      let newDate: DateTime = new DateTime(this.innerDate.getTime());
      let newDay = newDate.day + value;
      if (newDay < 1) {
        newDate = newDate.addMonths(-1);
        newDay = newDate.lastDayOfMonth().day + newDay;
      }
      return new DateTime(newDate.year, newDate.month, newDay, newDate.hour, newDate.minute, newDate.second, newDate.millisecond);
    }*/
    addHours(value) {
        return new DateTime(this.year, this.month, this.day, this.hour + value, this.minute, this.second, this.millisecond);
    }
    addMinutes(value) {
        return new DateTime(this.year, this.month, this.day, this.hour, this.minute + value, this.second, this.millisecond);
    }
    addSeconds(value) {
        return new DateTime(this.year, this.month, this.day, this.hour, this.minute, this.second + value, this.millisecond);
    }
    addMilliseconds(value) {
        return new DateTime(this.year, this.month, this.day, this.hour, this.minute, this.second, this.millisecond + value);
    }
    addTicks(value) {
        return new DateTime(this.ticks + value);
    }
    compareTo(value) {
        if (this.ticks < value.ticks)
            return -1;
        if (this.ticks > value.ticks)
            return 1;
        return 0;
    }
    subtract(value) {
        return new TimeSpan(this.ticks - value.ticks);
    }
    get date() {
        return this.innerDate;
    }
    static oaDateToTicks0(oaDate) {
        let ticks = ((oaDate - 25569) * 86400000);
        if (oaDate < 0) {
            const frac = (oaDate - Math.trunc(oaDate)) * 86400000;
            if (frac !== 0) {
                ticks -= frac * 2;
            }
        }
        return ticks;
    }
    static ticksToOADate0(ticks) {
        let oad = (ticks / 86400000) + 25569;
        if (oad < 0) {
            const frac = oad - Math.trunc(oad);
            if (frac !== 0) {
                oad = Math.ceil(oad) - frac - 2;
            }
        }
        return oad;
    }
    toOADate() {
        //return (this.ticks / 86400000) + 25569;
        return DateTime.ticksToOADate0(this.ticks);
    }
    toOADate2(round) {
        let ticks = DateTime.ticksToOADate0(this.ticks);
        //let ticks = DateTime.ticksToOADate(this.ticks);
        if (round)
            return Math.round(ticks);
        return ticks;
    }
    toNetJsonString() {
        return "\\/Date(" + this.ticks.toString() + ")\\/";
    }
    static fromNetJsonString(jsonDate) {
        let m = /-?\d+/.exec(jsonDate);
        let date = new Date(parseInt(m[0]));
        return new DateTime(date);
    }
    static fromOADate(oadate) {
        return new DateTime(DateTime.oaDateToTicks0(oadate));
        //return new DateTime(((oadate - 25569) * 86400000));
        // return new DateTime(this.doubleDateToTicks(d));
    }
    static fromString(d = "2015-12-31", logError = true) {
        try {
            d = d.trim();
            let date = d.split(".").join("-").split("\\").join("-").split(" ").join("-");
            return new DateTime(new Date());
            let dayjsDate;
            /*if (date.indexOf("/") >= 0) {
              // Date
              dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "M/D/YYYY", true);
              if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
              dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "M/D/YY", true);
              if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
              // DateTime
              dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "M/D/YYYY-H:m", true);
              if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
              dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "M/D/YYYY-H:m:s", true);
              if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
              dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "M/D/YYYY-h:m:s-a", true);
              if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
              dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "M/D/YY-H:m", true);
              if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
              dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "M/D/YY-H:m:s", true);
              if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
              dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "M/D/YY-h:m:s-a", true);
              if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
              date = d.split("/").join("-");
            }
      
            // Date
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-M-D", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "D-M-YYYY", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "D-M-YY", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            // DateTime
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-M-D-H:m", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-M-D-H:m:s", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-M-D-H:m:s-SSS", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-M-D-H:m:s-SSSSSSS", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-M-D-h:m:s-a", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "D-M-YYYY-H:m", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "D-M-YYYY-H:m:s", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "D-M-YYYY-h:m:s-a", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "D-M-YY-H:m", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "D-M-YY-H:m:s", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "D-M-YY-h:m:s-a", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            // Time
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "H:m", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "H:m:s", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "h:m:s-a", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            // ISO
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-MM-DD", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-MM-DDTHH:m:sZ", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-MM-DDTHH:m:s-SSSZ", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-MM-DDTHH:m:s-SSSSSSSZ", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-MM-DDTHH:m:s", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-MM-DDTHH:m:s-SSS", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(date, "YYYY-MM-DDTHH:m:s-SSSSSSS", true);
            if (dayjsDate.isValid()) return new DateTime(dayjsDate.toDate());
      
            if (logError) StiError.showError("Parse DateTime Error (" + d + ")", false);*/
            return null;
        }
        catch (e) {
            return null;
        }
    }
    /*
        static fromString2(format = "2015-12-31", value: string, logError = true): DateTime {
          try {
            let dayjsDate = Stimulsoft.ExternalLibrary.dayjs(value, [format], true);
            if (dayjsDate.isValid() == false) {
              if (logError) StiError.showError("Parse DateTime Error (" + value + ")", false);
              return null;
            }
  
            return new DateTime(dayjsDate.toDate());
          }
          catch (e) {
          }
          return null;
        }
  
        static isISO8601String(d: string): boolean {
          try {
            d = d.trim();
  
            let dayjsDate;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DD", true);
            if (dayjsDate.isValid()) return true;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DDTHH:mm", true);
            if (dayjsDate.isValid()) return true;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DDTHH:mmZ", true);
            if (dayjsDate.isValid()) return true;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DDTHH:mm:ss", true);
            if (dayjsDate.isValid()) return true;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DDTHH:mm:ss.SSS", true);
            if (dayjsDate.isValid()) return true;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DDTHH:mm:ss.SSSSSS", true);
            if (dayjsDate.isValid()) return true;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DDTHH:mm:ssZ", true);
            if (dayjsDate.isValid()) return true;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DDTHH:mm:ss.SSSZ", true);
            if (dayjsDate.isValid()) return true;
  
            dayjsDate = Stimulsoft.ExternalLibrary.dayjs(d, "YYYY-MM-DDTHH:mm:ss.SSSSSSZ", true);
            if (dayjsDate.isValid()) return true;
          }
          catch (e) {
          }
  
          return false;
        }*/
    get timeOfDay() {
        return new TimeSpan(this.ticks - new DateTime(this.year, this.month, this.day, 0, 0, 0, 0).ticks);
    }
    get date2() {
        return new DateTime(this.year, this.month, this.day, 0, 0, 0, 0);
    }
}
// Number of 100ns ticks per time unit
DateTime.ticksPerMillisecond = 1000;
DateTime.ticksPerSecond = DateTime.ticksPerMillisecond * 1000;
DateTime.ticksPerMinute = DateTime.ticksPerSecond * 60;
DateTime.ticksPerHour = DateTime.ticksPerMinute * 60;
DateTime.ticksPerDay = DateTime.ticksPerHour * 24;
// Number of milliseconds per time unit
DateTime.millisPerSecond = 1000;
DateTime.millisPerMinute = DateTime.millisPerSecond * 60;
DateTime.millisPerHour = DateTime.millisPerMinute * 60;
DateTime.millisPerDay = DateTime.millisPerHour * 24;
// Number of days in a non-leap year
DateTime.daysPerYear = 365;
// Number of days in 4 years
DateTime.daysPer4Years = DateTime.daysPerYear * 4 + 1;
// Number of days in 100 years
DateTime.daysPer100Years = DateTime.daysPer4Years * 25 - 1;
// Number of days in 400 years
DateTime.daysPer400Years = DateTime.daysPer100Years * 4 + 1;
// Number of days from 1/1/0001 to 12/31/1600
DateTime.daysTo1601 = DateTime.daysPer400Years * 4;
// Number of days from 1/1/0001 to 12/30/1899
DateTime.daysTo1899 = DateTime.daysPer400Years * 4 + DateTime.daysPer100Years * 3 - 367;
// Number of days from 1/1/0001 to 12/31/9999
DateTime.daysTo10000 = DateTime.daysPer400Years * 25 - 366;
DateTime.minTicks = 0;
DateTime.maxTicks = DateTime.daysTo10000 * DateTime.ticksPerDay - 1;
DateTime.maxMillis = DateTime.daysTo10000 * DateTime.millisPerDay;
DateTime.fileTimeOffset = DateTime.daysTo1601 * DateTime.ticksPerDay;
DateTime.doubleDateOffset = DateTime.daysTo1899 * DateTime.ticksPerDay;
// The minimum OA date is 0100/01/01 (Note it's year 100).
// The maximum OA date is 9999/12/31
DateTime.oADateMinAsTicks = (DateTime.daysPer100Years - DateTime.daysPerYear) * DateTime.ticksPerDay;
// All OA dates must be greater than (not >=) OADateMinAsDouble
DateTime.oADateMinAsDouble = -657435;
// All OA dates must be less than (not <=) OADateMaxAsDouble
DateTime.oADateMaxAsDouble = 2958466;
DateTime.datePartYear = 0;
DateTime.datePartDayOfYear = 1;
DateTime.datePartMonth = 2;
DateTime.DatePartDay = 3;
DateTime.daysToMonth365 = [
    0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365
];
DateTime.daysToMonth366 = [
    0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366
];
DateTime.minValue = new DateTime(DateTime.minTicks);
DateTime.maxValue = new DateTime(DateTime.maxTicks);

/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
class StiObject {
    static keys(obj) {
        // if (Object.keys) return Object.keys(obj);
        let keys = [];
        // eslint-disable-next-line @typescript-eslint/no-for-in-array
        for (let i in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, i)) {
                keys.push(i);
            }
        }
        // eslint-disable-next-line @typescript-eslint/no-for-in-array
        for (let i in obj.__proto__) {
            if (Object.prototype.hasOwnProperty.call(obj, i)) {
                keys.push(i);
            }
        }
        return keys;
    }
    static disableAllEnumerable(prototype, obj) {
        // eslint-disable-next-line @typescript-eslint/no-for-in-array
        for (let name in obj) {
            Object.defineProperty(prototype, name, { enumerable: false });
        }
    }
}
class StiString extends StiObject {
    static isNullOrEmpty(value) {
        return value == null || value === "" || value === undefined;
    }
}

/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
class Hashtable {
    constructor(options = { ignoreCase: false }) {
        this.ignoreCase = false;
        this.isSimpleKeys = false;
        this.keys = new List();
        this.values = new List();
        this.indexObject = {};
        this.ignoreCase = options.ignoreCase;
        if (this.ignoreCase)
            this.isSimpleKeys = true;
    }
    get(key) {
        if (this.isSimpleKeys) {
            if (this.ignoreCase)
                key = key.toLowerCase();
            return this.values[this.indexObject[key]];
        }
        return this.values[this.keys.indexOf(key)];
    }
    set(key, value) {
        if (this.isSimpleKeys) {
            let type = typeof key;
            if (type != "string" && type != "number") {
                this.isSimpleKeys = false;
                this.indexObject = {};
            }
        }
        else if (this.keys.length == 0) {
            let type = typeof key;
            if (type == "string" || type == "number")
                this.isSimpleKeys = true;
        }
        let index = -1;
        if (this.isSimpleKeys) {
            if (this.ignoreCase)
                key = key.toLowerCase();
            index = this.indexObject[key];
        }
        else
            index = this.keys.indexOf(key);
        if (index >= 0)
            this.values[index] = value;
        else {
            if (this.isSimpleKeys) {
                if (this.ignoreCase)
                    key = key.toLowerCase();
                this.indexObject[key] = this.keys.length;
            }
            this.keys.push(key);
            this.values.push(value);
        }
    }
    /** Adds an element with the specified key and value into the Hashtable. */
    add(key, value) {
        this.set(key, value);
    }
    /** Determines whether the Hashtable contains a specific key. */
    contains(key) {
        if (this.isSimpleKeys) {
            if (this.ignoreCase)
                key = key.toLowerCase();
            return this.indexObject[key] != undefined;
        }
        return this.keys.contains(key);
    }
    /** Determines whether the Hashtable contains a specific key. */
    containsKey(key) {
        if (this.isSimpleKeys) {
            if (this.ignoreCase)
                key = key.toLowerCase();
            return this.indexObject[key] != undefined;
        }
        return this.keys.contains(key);
    }
    /** Determines whether the Hashtable contains a specific value. */
    containsValue(value) {
        return this.values.contains(value);
    }
    /** Removes the element with the specified key from the Hashtable. */
    remove(key) {
        let index;
        if (this.isSimpleKeys) {
            if (this.ignoreCase)
                key = key.toLowerCase();
            index = this.indexObject[key];
        }
        else
            index = this.keys.indexOf(key);
        if (index >= 0) {
            this.keys.removeAt(index);
            this.values.removeAt(index);
            if (this.isSimpleKeys) {
                this.indexObject = {};
                for (let index = 0; index < this.keys.length; index++) {
                    this.indexObject[this.ignoreCase ? this.keys[index].toLowerCase() : this.keys[index]] = index;
                }
            }
        }
    }
    /** Removes all elements from the Hashtable. */
    clear() {
        this.keys = new List();
        this.values = new List();
        this.indexObject = {};
        this.isSimpleKeys = false;
    }
    /** Copies the Hashtable elements to a one-dimensional Array instance at the specified index. */
    copyTo(array, arrayIndex) {
        while (array.length < arrayIndex) {
            array.push(null);
        }
        for (let value of this.values) {
            if (array.length > arrayIndex)
                array[arrayIndex] = value;
            else
                array.push(value);
            arrayIndex++;
        }
    }
    /** Gets the number of key/value pairs contained in the Hashtable. */
    get count() {
        return this.keys.length;
    }
    clone() {
        let newHashtable = new Hashtable();
        this.keys.copyTo(newHashtable.keys);
        this.values.copyTo(newHashtable.values);
        if (this.isSimpleKeys)
            for (let key of StiObject.keys(this.indexObject)) {
                newHashtable.indexObject[key] = this.indexObject[key];
            }
        newHashtable.ignoreCase = this.ignoreCase;
        newHashtable.isSimpleKeys = this.isSimpleKeys;
        return newHashtable;
    }
}

/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
class Dictionary extends Hashtable {
    get pairs() {
        return this.keys.map((value, index) => ({ key: value, value: this.values[index] }));
    }
    tryGetValue(key, out) {
        let index = this.keys.indexOf(key);
        if (index >= 0)
            out.ref = this.values[index];
        else
            out.ref = null;
        return index >= 0;
    }
}

/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
class List extends Array {
    constructor(items) {
        super();
        if (typeof items == "number") {
        }
        else if (items)
            items.forEach(item => this.push(item));
        try {
            this.__proto__ = List.prototype;
            Object.defineProperty(this, "__proto__", { enumerable: false });
        }
        catch (e) {
            Object.defineProperty(this, "__proto__", { enumerable: false, writable: true });
            this.__proto__ = List.prototype;
        }
    }
    /*static create<T>(t: Type, ...values: any[]): List<T> {
        let isStructure = false;
        if (typeof values[values.length - 1] == "boolean") isStructure = !!values.pop();

        if (values.length == 0) {
            if (t == Number) return <any>0;
            if (t == Boolean) return <any>false;
            if (isStructure) return new (<any>t);
            else return null;
        }

        let newList = new List<T>();
        let count: number = values.shift();
        for (let i = 0; i < count; i++) {
            let value: any = List.create.apply(this, (<any[]>[t]).concat(values, [isStructure]));
            newList.push(value);
        }

        return newList;
    }*/
    get countItems() {
        let properties = StiObject.keys(this);
        return properties.length;
    }
    //#region Range
    addRange(items) {
        for (let item of items)
            this.push(item);
    }
    removeRange(index, count) {
        this.splice(index, count);
    }
    getRange(index, count) {
        if (index == null || index < 0)
            index = 0;
        if (index + count > this.length)
            count = this.length - index;
        return new List(this.slice(index, index + count));
    }
    //#endregion
    add(item) {
        this.push(item);
    }
    insert(index, item) {
        this.splice(index, 0, item);
    }
    getKeys() {
        return StiObject.keys(this).sort((a, b) => {
            if (a < b)
                return -1;
            else if (a > b)
                return 1;
            else
                return 0;
        });
    }
    getByIndex(index, keys = null) {
        if (keys == null)
            keys = this.getKeys();
        return this[keys[index]];
    }
    setByIndex(index, item) {
        let properties = StiObject.keys(this);
        this[properties[index]] = item;
    }
    removeByIndex(index) {
        let removeIndex = this.indexOf(this.getByIndex(index, null));
        delete this[removeIndex];
        return this;
    }
    copyTo(array, index = 0) {
        let destIndex = index;
        for (let sourceIndex = 0; sourceIndex < this.length; sourceIndex++) {
            array[destIndex] = this[sourceIndex];
            destIndex++;
        }
    }
    /** Removes all elements from the List. */
    clear() {
        this.splice(0, this.length);
    }
    peek() {
        return this[this.length - 1];
    }
    remove(item) {
        let index = this.indexOf(item);
        if (index >= 0)
            this.removeAt(index);
    }
    /** Removes the element at the specified index of the Lis.
     * @param index The zero-based index of the element to remove.
     * @throw index is less than 0. -or- index is equal to or greater than Count.
     */
    removeAt(index) {
        this.splice(index, 1);
    }
    exists(predicate) {
        for (let value of this) {
            if (predicate(value))
                return true;
        }
        return false;
    }
    fullOuterJoin(inner, outerKeySelector, innerKeySelector, resultSelector, __this) {
        let innerLookup = inner.toLookup(innerKeySelector, __this);
        let outerLookup = this.toLookup(outerKeySelector, __this);
        let innerJoinItems = inner
            .where(innerItem => !outerLookup.contains(innerKeySelector.apply(__this, [innerItem])))
            .select(innerItem => resultSelector.apply(__this, [null, innerItem]));
        return this
            .selectMany2(outerItem => {
            let innerItems = innerLookup.get(outerKeySelector.apply(__this, [outerItem]));
            return innerItems.any() ? innerItems : new List();
        }, resultSelector, __this)
            .concat(innerJoinItems);
    }
    toList() {
        return new List(this);
    }
    findIndex2(match) {
        for (let index = 0; index < this.length; index++) {
            if (match(this[index]))
                return index;
        }
        return -1;
    }
    findLastIndex2(match) {
        let lastIndex = -1;
        for (let index = 0; index < this.length; index++) {
            if (match(this[index]))
                lastIndex = index;
        }
        return lastIndex;
    }
    zip(second, resultSelector) {
        let result = new List();
        for (let index = 0; index < this.length; index++) {
            result.add(resultSelector(this[index], second[index]));
        }
        return result;
    }
    static repeat(element, count) {
        let list = new List();
        for (let i = 0; i < count; i++) {
            list.push(element);
        }
        return list;
    }
    //#region Filtering
    /** Filters a sequence of values based on a predicate.
     * @param predicate A function to test each element for a condition.
     * @returns An List that contains elements from the input sequence that satisfy the condition.
     */
    where(predicate, __this) {
        let filter = new List();
        for (let index = 0; index < this.length; index++) {
            let value = this[index];
            predicate.apply(__this, [value, index]) ? filter.push(value) : null;
        }
        return filter;
    }
    //#endregion
    //#region Join
    /** Correlates the elements of two sequences based on matching keys. The default
     * equality comparer is used to compare keys.
     * @param inner The sequence to join to the first sequence.
     * @param outerKeySelector A function to extract the join key from each element of the first sequence.
     * @param innerKeySelector A function to extract the join key from each element of the second sequence.
     * @param resultSelector A function to create a result element from two matching elements.
     * @returns An List that has elements of type V
     * that are obtained by performing an inner join on two sequences.
     */
    join2(inner, outerKeySelector, innerKeySelector, resultSelector, __this) {
        let result = new List();
        let innerKeys = new Hashtable();
        for (let i of inner) {
            let innerKey = innerKeySelector.apply(__this, [i]);
            innerKeys.set(innerKey, i);
        }
        for (let o of this) {
            let outerKey = outerKeySelector.apply(__this, [o]);
            let i = innerKeys.get(outerKey);
            if (i != null)
                result.push(resultSelector.apply(__this, [o, i]));
        }
        return result;
    }
    /** Correlates the elements of two sequences based on equality of keys and groups
     * the results. The default equality comparer is used to compare keys.
     * @param inner The sequence to join to the first sequence.
     * @param outerKeySelector A function to extract the join key from each element of the first sequence.
     * @param innerKeySelector A function to extract the join key from each element of the second sequence.
     * @param resultSelector A function to create a result element from an element from the first sequence
     * and a collection of matching elements from the second sequence.
     * @returns An List that contains elements of type V
     * that are obtained by performing a grouped join on two sequences.
     */
    groupJoin(inner, outerKeySelector, innerKeySelector, resultSelector, __this) {
        let result = new List();
        let innerKeys = new Hashtable();
        for (let i of inner) {
            let key = innerKeySelector.apply(__this, [i]);
            let innerResult = innerKeys.get(key);
            if (innerResult == null) {
                innerResult = new List();
                innerKeys.set(key, innerResult);
            }
            innerResult.push(i);
        }
        for (let o of this) {
            let key = outerKeySelector.apply(__this, [o]);
            let innerResult = innerKeys.get(key);
            if (innerResult == null)
                innerResult = new List();
            result.push(resultSelector.apply(__this, [o, innerResult]));
        }
        return result;
    }
    //#endregion
    //#region Projection
    /**
     * Projects each element of a sequence into a new form.
     * @param selector A transform function to apply to each element.
     * @returns An List whose elements are the result of invoking the transform function on each element of source.
     */
    select(selector, __this) {
        let filter = new List();
        this.forEach(value => filter.push(selector.apply(__this, [value])));
        return filter;
    }
    selectMany(selector, __this) {
        let filter = new List();
        this.forEach(value => {
            let result = selector.apply(__this, [value]);
            if (result != null)
                result.forEach(item => filter.push(item));
        });
        return filter;
    }
    selectMany2(collectionSelector, resultSelector, __this) {
        let filter = new List();
        this.forEach(value => {
            let result = collectionSelector.apply(__this, [value]);
            if (result != null)
                result.forEach(item => filter.push(resultSelector.apply(__this, [value, item])));
        });
        return filter;
    }
    //#endregion
    //#region Sorting
    /** Sorts the elements of a sequence in ascending order according to a key or by using a specified comparer.
     * @param keySelector A function to extract a key from an element.
     * @param comparer An System.Collections.Generic.IComparer`1 to compare keys.
     * @returns An System.Linq.IOrderedEnumerable`1 whose elements are sorted according to a key.
     */
    /*orderBy<K>(keySelector: (value: T) => K, comparer?: IComparer<K>): List<T> {
         let sort: T[] = this.ss.toArray();
         if (comparer == null) comparer = {
             compare: (x: K, y: K) => {
                 if (x != null && y == null) return 1;
                 if (x == null && y != null) return -1;
                 if (x == null && y == null) return 0;
 
                 return x.ss.compareTo(y);
             }
         };
 
         sort.sort((a: T, b: T) => comparer.compare(keySelector(a), keySelector(b)));
 
         return new List<T>(sort);
     }
 
     orderByDescending<K>(keySelector: (value: T) => K, comparer?: IComparer<K>): List<T> {
         let sort: T[] = this.ss.toArray();
         if (comparer == null) comparer = {
             compare: (x: K, y: K) => {
                 if (x != null && y == null) return -1;
                 if (x == null && y != null) return 1;
                 if (x == null && y == null) return 0;
 
                 return y.ss.compareTo(x);
             }
         };
 
         sort.sort((a: T, b: T) => comparer.compare(keySelector(a), keySelector(b)));
 
         return new List<T>(sort);
     }*/
    //#endregion
    //#region Grouping
    /** Groups the elements of a sequence according to a specified key selector function
     * and compares the keys by using a specified comparer.
     * @param keySelector A function to extract the key for each element.
     * @param comparer An System.Collections.Generic.IEqualityComparer`1 to compare keys.
     * @returns An IEnumerable<IGrouping<TKey, TSource>> in C# or IEnumerable(Of IGrouping(Of
     * TKey, TSource)) in Visual Basic where each System.Linq.IGrouping`2 object contains
     * a collection of objects and a key.
     */
    /*-groupBy<K>(keySelector: (value: T) => K, comparer?: IEqualityComparer<K>, __this?: any): List<Grouping<K, T>> {
        let result = new List<Grouping<K, T>>();
        if (comparer == null) comparer = {
            equals: (x: K, y: K) => {
                if (x == y) return true;
                return false;
            },
            getHashCode: () => 0
        };

        for (let item of this) {
            let key = keySelector.apply(__this, [item]);
            let group = result.firstOrDefault(g => comparer.equals(g.key, key));
            if (group == null) {
                group = new Grouping(new List<T>([]));
                group.key = key;
                result.push(group);
            }
            group.push(item);
        }

        return result;
    }*/
    //#endregion
    //#region Conversions
    /** Converts the elements of an List to the specified type.
     * @returns An List that contains each element of the source sequence converted to the specified type.
     */
    cast() {
        let cast = new List();
        let castFunction;
        /*if (typeof <S>{} == "string") castFunction = (value: T) => value.s.toString();
        else if (typeof <S>{} == "number") castFunction = (value: T) => value.s.ss.toNumber();
        else if (typeof <S>{} == "boolean") castFunction = (value: T) => value.s.ss.toBoolean();
        else*/ castFunction = (value) => value;
        this.forEach(value => cast.push(castFunction(value)));
        return cast;
    }
    toDictionary(keySelector, elementSelector) {
        let dictionary = new Dictionary();
        for (let index = 0; index < this.length; index++) {
            dictionary.add(keySelector(this[index]), elementSelector(this[index]));
        }
        return dictionary;
    }
    /** Creates a Lookup from an List
     * according to a specified key selector function.
     * @param keySelector A function to extract a key from each element.
     * @returns A Lookup that contains keys and values.
     */
    toLookup(keySelector, __this) {
        let hashtable = new Hashtable();
        for (let item of this) {
            let key = keySelector.apply(__this, [item]);
            let lookup = hashtable.get(key);
            if (lookup == null) {
                lookup = new List();
                hashtable.set(key, lookup);
            }
            lookup.push(item);
        }
        return hashtable;
    }
    //#endregion
    //#region Concatenation
    /** Concatenates two sequences.
     * @param second The sequence to concatenate to the first sequence.
     * @returns An List that contains the concatenated elements
     * of the two input sequences.
     */
    concat(second) {
        let concatedList = new List();
        for (let item of this)
            concatedList.push(item);
        for (let item of second)
            concatedList.push(item);
        return concatedList;
    }
    //#endregion
    //#region Aggregation
    /**
     * Applies an accumulator function over a sequence.
     * @param func An accumulator function to be invoked on each element.
     * @returns The final accumulator value.
     */
    aggregate(func) {
        let seed = this[0];
        for (let index = 1; index < this.length; index++) {
            seed = func(seed, this[index]);
        }
        return seed;
    }
    aggregate2(seed, func) {
        for (let index = 0; index < this.length; index++) {
            seed = func(seed, this[index]);
        }
        return seed;
    }
    count2(selector, __this) {
        if (selector == null)
            selector = (value) => true;
        let count = 0;
        this.forEach(item => selector.apply(__this, [item]) ? count++ : null);
        return count;
    }
    /** Invokes a transform function on each element of a sequence and returns the maximum value.
     * @param selector A transform function to apply to each element.
     * @returns The maximum value in the sequence.
     */
    /*max<S>(selector?: (value: T) => S): S {
        if (selector == null) selector = (value: T) => <S><any>value;
        if (this.length == 0) return null;
        let max = selector(this[0]);
        let maxFunc: Function;
        if (typeof max == "string") maxFunc = function (strA: string, strB: string): string { return strA.ss.compareTo(strB) >= 0 ? strA : strB; };
        if (typeof max == "number") maxFunc = Math.max;
        if (max instanceof DateTime) maxFunc = function (dateA: DateTime, dateB: DateTime): DateTime { return DateTime.compare(dateA, dateB) >= 0 ? dateA : dateB; };

        for (let index = 1; index < this.length; index++) {
            max = maxFunc(selector(this[index]), max);
        }

        return max;
    }*/
    /** Invokes a transform function on each element of a sequence and returns the minimum value.
     * @parm selector A transform function to apply to each element.
     * @returns The minimum value in the sequence.
     */
    /*min<S>(selector?: (value: T) => S): S {
        if (selector == null) selector = (value: T) => <S><any>value;
        if (this.length == 0) return null;
        let min = selector(this[0]);
        let minFunc: Function;
        if (typeof min == "string") minFunc = function (strA: string, strB: string): string { return strA.ss.compareTo(strB) <= 0 ? strA : strB; };
        if (typeof min == "number") minFunc = Math.min;
        if (min instanceof DateTime) minFunc = function (dateA: DateTime, dateB: DateTime): DateTime { return DateTime.compare(dateA, dateB) <= 0 ? dateA : dateB; };

        for (let index = 1; index < this.length; index++) {
            min = minFunc(selector(this[index]), min);
        }

        return min;
    }*/
    /** Computes the sum of the sequence of System.Decimal values that are obtained by
     * invoking a transform function on each element of the input sequence.
     * @param selector A transform function to apply to each element.
     * @returns The sum of the projected values.
     */
    /*sum(selector?: (value: T) => number): number {
        if (selector == null) selector = (value: T) => value.ss.toNumber();
        let sum = 0;
        this.forEach(value => sum += selector(value));
        return sum;
    }*/
    //#endregion
    //#region Quantifier Operations
    all(predicate, __this) {
        if (predicate == null)
            predicate = (value) => true;
        for (let value of this)
            if (!predicate.apply(__this, [value]))
                return false;
        return true;
    }
    /** Determines whether any element of a sequence satisfies a condition.
     * @param predicate A function to test each element for a condition.
     * @returns true if any elements in the source sequence pass the test in the specified predicate; otherwise, false.
     */
    any(predicate, __this) {
        if (predicate == null)
            predicate = (value) => true;
        for (let value of this)
            if (predicate.apply(__this, [value]))
                return true;
        return false;
    }
    /** Determines whether an element is in the List.
     * @param item The object to locate in the List. The value can be null for reference types.
     * @returns true if item is found in the List otherwise, false.
     */
    contains(item) {
        return this.indexOf(item) >= 0;
    }
    //#endregion
    //#region Partition Operations
    skip(count) {
        let result = new List();
        for (let index = count; index < this.length; index++) {
            result.add(this[index]);
        }
        return result;
    }
    take(count) {
        let result = new List();
        if (count > this.length)
            count = this.length;
        for (let index = 0; index < count; index++) {
            result.add(this[index]);
        }
        return result;
    }
    //#endregion
    //#region Generation Operations
    defaultIfEmpty() {
        if (this.length > 0)
            return this;
        return new List([null]);
    }
    //#endregion
    //#region Set Operations
    /** Returns distinct elements from a sequence by using the default equality comparer to compare values.
     * @returns An List that contains distinct elements from the source sequence.
     */
    distinct() {
        let filter = new List();
        this.forEach(value => filter.indexOf(value) < 0 ? filter.push(value) : null);
        return filter;
    }
    except(second) {
        let result = new List();
        for (let item of this) {
            if (second.indexOf(item) == -1)
                result.add(item);
        }
        return result;
    }
    union(second) {
        let union = new List();
        this.forEach(element => union.add(element));
        second.forEach(element => union.add(element));
        return union.distinct();
    }
    //#endregion
    //#region Equality
    sequenceEqual(second) {
        if (this.length != second.length)
            return false;
        for (let index = 0; index < this.length; index++) {
            if (this[index] != second[index])
                return false;
        }
        return true;
    }
    //#endregion
    //#region Element
    first(selector, __this) {
        if (selector == null)
            selector = (value) => true;
        for (let item of this) {
            if (selector.apply(__this, [item]))
                return item;
        }
        return null;
    }
    /** Returns the first element of the sequence that satisfies a condition or a default value if no such element is found.
     * @param predicate A function to test each element for a condition.
     * @returns if source is empty or if no element passes the test specified by predicate;
     * otherwise, the first element in source that passes the test specified by predicate.
     */
    firstOrDefault(predicate) {
        for (let value of this) {
            if (predicate == null)
                return value;
            if (predicate(value))
                return value;
        }
        return null;
    }
    lastOrDefault() {
        let item;
        for (let value of this) {
            item = value;
        }
        return item;
    }
}
StiObject.disableAllEnumerable(List.prototype, new List());

class StiJson {
    constructor(name = null, value = null, isProperty = false, options = {}) {
        this.isProperty = false;
        this.isArray = false;
        this.name = name;
        if (value != null && typeof value == "string")
            value = value.replace(/#!rn#/gi, "\r\n").replace(/#!q#/gi, '"').replace(/#!t#/gi, "\t").replace(/#!!#/gi, "\\");
        this.value = value;
        this.isProperty = isProperty;
        this.options = options;
    }
    static dateToJsonDate(date) {
        let offset = date.date.getTimezoneOffset() * -1;
        let hoursOffset = Math.abs(Math.floor(offset / 60)).toString();
        let minutesOffset = Math.abs(offset % 60).toString();
        if (hoursOffset.length == 1)
            hoursOffset = "0" + hoursOffset;
        if (minutesOffset.length == 1)
            minutesOffset = "0" + minutesOffset;
        return (
        /* "/Date(" +*/ Date.parse(date.date.toString()).toString() +
            (offset >= 0 ? "+" : "-") +
            hoursOffset +
            minutesOffset /*+ ")/"*/);
    }
    static jsonDateFormatToDate(jsonDate) {
        let dateStr = jsonDate.split("/Date(").join("").split(")/").join("");
        let date = new DateTime(new Date(parseInt(dateStr)));
        let startOffsetIndex = dateStr.indexOf("+");
        if (startOffsetIndex == -1)
            startOffsetIndex = dateStr.indexOf("-");
        let localOffset = date.date.getTimezoneOffset();
        if (startOffsetIndex != -1)
            localOffset = 0;
        let localHoursOffset = Math.floor(localOffset / 60);
        let localMinutesOffset = localOffset % 60;
        let localHoursOffsetString = (Math.abs(localHoursOffset) < 10 ? "0" : "") + Math.abs(localHoursOffset).toString();
        let localMinutesOffsetString = (Math.abs(localMinutesOffset) < 10 ? "0" : "") + Math.abs(localMinutesOffset).toString();
        let offset = (localOffset >= 0 ? "+" : "-") + localHoursOffsetString + localMinutesOffsetString;
        let multiple = 1;
        if (startOffsetIndex != -1)
            offset = dateStr.substring(startOffsetIndex);
        if (offset.substr(0, 1) == "-")
            multiple = -1;
        date.addHours(localHoursOffset + parseInt(offset.substr(1, 2)) * multiple);
        date.addMinutes(localMinutesOffset + parseInt(offset.substr(3, 2)) * multiple);
        return date;
    }
    properties() {
        if (!this.isProperty) {
            if (this.value instanceof List)
                return this.value;
            else
                return this.value.value;
        }
        return new List();
    }
    removeProperty(propertyName) {
        if (propertyName != null || propertyName != "") {
            let elements = this.value.value.filter((x) => x.name == propertyName);
            if (elements.length > 0) {
                this.value.value.remove(elements[0]);
            }
        }
    }
    addPropertyNumber(propertyName, value) {
        if (this.value == null)
            this.value = new StiJson("", new List());
        this.removeProperty(propertyName);
        this.value.value.push(new StiJson(propertyName, value, true));
    }
    addPropertyNumberNotNull(propertyName, value) {
        if (value) {
            this.addPropertyNumber(propertyName, value);
        }
    }
    addPropertyNumberNoDefaultValue(propertyName, value) {
        if (this.value == null)
            this.value = new StiJson("", new List());
        this.removeProperty(propertyName);
        this.value.value.push(new StiJson(propertyName, value, true));
    }
    addPropertyJObject(propertyName, value) {
        if (this.value == null)
            this.value = new StiJson("", new List());
        this.removeProperty(propertyName);
        if (value == null || value.count == 0)
            return;
        this.value.value.push(new StiJson(propertyName, value));
    }
    addPropertyArray(propertyName, elements) {
        if (this.value == null)
            this.value = new StiJson("", new List());
        this.removeProperty(propertyName);
        if (elements == null)
            return;
        let values = [];
        elements.forEach((e) => values.push((e === null || e === void 0 ? void 0 : e.saveToJsonObject) != null
            ? e.saveToJsonObject(this.options)
            : typeof e == "string"
                ? `"${e
                    .replace(/[\\]/g, "\\\\")
                    .replace(/[\"]/g, '\\"')
                    // .replace(/[\/]/g, '\\/')
                    .replace(/[\b]/g, "\\b")
                    .replace(/[\f]/g, "\\f")
                    .replace(/\r\n/g, "\n")
                    .replace(/[\r]/g, "\n")
                    .replace(/[\r\n]/g, "\\r\\n")
                    .replace(/[\t]/g, "\\t")
                    // eslint-disable-next-line no-control-regex
                    .replace(/[\u0001-\u001F]/g, (chr) => "\\u" + ("0000" + chr.charCodeAt(0).toString(16)).substr(-4))}"`
                : e));
        let json = new StiJson(propertyName, values);
        json.isArray = true;
        this.value.value.push(json);
    }
    addPropertyIdent(propertyName, value) {
        if (this.value == null)
            this.value = new StiJson("", new List());
        this.value.value.push(new StiJson(propertyName, value, true));
    }
    addPropertyBool(propertyName, value) {
        if (this.value == null)
            this.value = new StiJson("", new List());
        this.removeProperty(propertyName);
        this.value.value.push(new StiJson(propertyName, value, true));
    }
    /*addPropertyDateTime(propertyName: string, value: DateTime) {
        if (this.value == null) this.value = new StiJson("", new List());
        this.removeProperty(propertyName);
  
        this.value.value.push(new StiJson(propertyName, StiJson.dateToJsonDate(value), true));
    }*/
    addPropertyEnum(propertyName, enumType, value, defaultValue = null) {
        if (this.value == null)
            this.value = new StiJson("", new List());
        this.removeProperty(propertyName);
        if (typeof defaultValue != "undefined" && value == defaultValue)
            return;
        this.value.value.push(new StiJson(propertyName, Enum.getName(enumType, value), true));
    }
    addPropertyColor(propertyName, color, defColor = null) {
        if (color == null || color.equals(defColor))
            return;
        let value = color.isNamedColor ? color.name.replace(" ", "") : `${color.a},${color.r},${color.g},${color.b}`;
        this.addPropertyString(propertyName, value);
    }
    addPropertyString(propertyName, value, defaultValue) {
        if (this.value == null)
            this.value = new StiJson("", new List());
        this.removeProperty(propertyName);
        if (value == defaultValue)
            return;
        this.value.value.push(new StiJson(propertyName, value, true));
    }
    addPropertyStringNullOrEmpty(propertyName, value) {
        if (this.value == null)
            this.value = new StiJson("", new List());
        this.removeProperty(propertyName);
        if (StiString.isNullOrEmpty(value))
            return;
        this.value.value.push(new StiJson(propertyName, value, true));
    }
    get count() {
        let count = 0;
        if (!this.isProperty && this.value != null) {
            // eslint-disable-next-line @typescript-eslint/no-unused-vars
            for (let propertyName of this.value.value) {
                count++;
            }
        }
        return count;
    }
    getArray() {
        let result = [];
        this.value.forEach((e) => result.push(e.value));
        return result;
    }
    serialize(indent = 0) {
        let jsonString = "";
        let tabs = StiJson.prettyPrint ? Array(indent + 1).join(" ") : "";
        for (let property of this.value.properties()) {
            let valueString = "";
            if (property.isProperty) {
                if (property.value != null && typeof property.value == "string")
                    valueString =
                        '"' +
                            property.value
                                .replace(/[\\]/g, "\\\\")
                                .replace(/[\"]/g, '\\"')
                                // .replace(/[\/]/g, '\\/')
                                .replace(/[\b]/g, "\\b")
                                .replace(/[\f]/g, "\\f")
                                .replace(/\r\n/g, "\n")
                                .replace(/[\r]/g, "\n")
                                .replace(/[\r\n]/g, "\\r\\n")
                                .replace(/[\t]/g, "\\t")
                                // eslint-disable-next-line no-control-regex
                                .replace(/[\u0001-\u001F]/g, (chr) => "\\u" + ("0000" + chr.charCodeAt(0).toString(16)).substr(-4)) +
                            '"';
                // "\"" + property.value.replace(/\"/gi, "\\\"").replace(/\r\n/gi, "\n").replace(/\r/gi, "\n").replace(/\n/gi, "\\r\\n").replace(/\\/gi, "\\\\") + "\"";
                else
                    valueString = property.value;
            }
            else if (property.isArray) {
                if (property.value.length == 0) {
                    valueString += "[";
                }
                for (let element of property.value) {
                    if (valueString)
                        valueString += ",";
                    else
                        valueString += "[";
                    valueString += (element === null || element === void 0 ? void 0 : element.serialize) != null ? element.serialize(indent + 4) : element;
                }
                valueString += "]";
            }
            else {
                valueString = property.value.serialize(indent + 2);
            }
            if (jsonString)
                jsonString += ",";
            if (StiJson.prettyPrint)
                jsonString += "\n" + tabs + "  ";
            jsonString += '"' + property.name + '":';
            if (StiJson.prettyPrint)
                jsonString += " ";
            jsonString += valueString;
        }
        if (!jsonString)
            return "";
        if (StiJson.prettyPrint)
            return "{" + jsonString + "\n" + tabs + "}";
        return "{" + jsonString + "}";
    }
    deserialize(text) {
        if (typeof text == "string") {
            let pos = 0;
            let start = -1;
            while (pos < text.length) {
                if (text[pos] == '"' &&
                    (pos > 0 && text[pos - 1] != "\\"
                        ? true
                        : pos > 1 && text[pos - 2] == "\\" && pos > 2 && text[pos - 3] != "\\")) {
                    if (start > -1) {
                        let subText = text.substring(start, pos);
                        let modText = subText
                            .replace(/\\\\/gi, "#!!#")
                            .replace(/\\t/gi, "#!t#")
                            .replace(/\\\"/gi, "#!q#")
                            .replace(/\\r\\n/gi, "#!rn#")
                            .replace(/\\r/gi, "#!rn#")
                            .replace(/\\n/gi, "#!rn#");
                        if (modText.length != subText.length) {
                            // eslint-disable-next-line @typescript-eslint/restrict-plus-operands
                            text = text.substring(0, start) + modText + text.substring(pos);
                            pos += modText.length - subText.length;
                        }
                        start = -1;
                    }
                    else
                        start = pos + 1;
                }
                pos++;
            }
        }
        let reportObject = typeof text == "object" ? text : JSON.parse(text);
        this.deserializeFromObject(reportObject);
        this.value = this.value.value;
    }
    deserializeFromObject(child) {
        for (let propertyName in child) {
            if (typeof child[propertyName] == "object") {
                let jObject = new StiJson(propertyName);
                if (this.value == null)
                    this.value = new StiJson(null, new List());
                this.value.value.push(jObject);
                jObject.deserializeFromObject(child[propertyName]);
            }
            else if (typeof child[propertyName] != "function") {
                let jObject = new StiJson(propertyName, child[propertyName], true);
                if (this.value == null)
                    this.value = new StiJson(null, new List());
                this.value.value.push(jObject);
            }
        }
        if (child && Array.isArray(child) && child.length == 0) {
            this.value = new StiJson(null, new List());
        }
    }
    toString() {
        return this.name;
    }
}
StiJson.prettyPrint = true;

class Font {
    constructor(family, size, style = [], changesInterceptor) {
        this.changesInterceptor = changesInterceptor;
        this.fontSizeScale = 0.75;
        this.isChanged = true;
        this._family = family;
        this._size = size;
        this._style = style;
    }
    setProperty(propName, value) {
        switch (propName) {
            case "family":
                this.family = value;
                break;
            case "style":
                this.style = value;
                break;
            case "size":
                this.size = value;
                break;
        }
    }
    set style(value) {
        let this_ = this;
        let font = this.changesInterceptor ? this_.clone() : null;
        this._style = new Proxy(value, {
            deleteProperty: function (target, property) {
                let font = this.changesInterceptor ? this_.clone() : null;
                setTimeout(() => {
                    if (this.changesInterceptor) {
                        this.changesInterceptor.propertyChanged("font.style", this_.cloneStyle, font);
                    }
                    this_.isChanged = true;
                }, 0);
                return true;
            },
            set: function (target, property, value, receiver) {
                let font = this.changesInterceptor ? this_.clone() : null;
                target[property] = value;
                if (this.changesInterceptor) {
                    this.changesInterceptor.propertyChanged("font.style", this_.cloneStyle, font);
                }
                this_.isChanged = true;
                return true;
            },
        });
        if (this.changesInterceptor) {
            this.changesInterceptor.propertyChanged("font.style", this_.cloneStyle, font);
        }
        this_.isChanged = true;
    }
    get cloneStyle() {
        return this.style.map((s) => s);
    }
    get style() {
        return this._style;
    }
    resetChanged() {
        this.isChanged = false;
    }
    get family() {
        return this._family;
    }
    set family(value) {
        let font = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._family;
        this._family = value;
        this.isChanged = true;
        if (this.changesInterceptor && oldValue != this._family) {
            this.changesInterceptor.propertyChanged("font.family", value, font);
        }
    }
    get size() {
        return this._size;
    }
    set size(value) {
        let font = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._size;
        this._size = value;
        this.isChanged = true;
        if (this.changesInterceptor && oldValue != this._size) {
            this.changesInterceptor.propertyChanged("font.size", value, font);
        }
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyStringNullOrEmpty("Family", this.family);
        json.addPropertyNumber("Size", this.size);
        let style = this.style.filter((s) => s && s != "").join(",");
        json.addPropertyString("Style", style.length != 0 ? style : "Regular");
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Family":
                    this._family = property.value;
                    break;
                case "Size":
                    this._size = property.value;
                    break;
                case "Style":
                    this._style = property.value.replace("Regular", "").split(",");
                    break;
            }
        }
    }
    isBold() {
        return this.style.indexOf("Bold") >= 0;
    }
    isItalic() {
        return this.style.indexOf("Italic") >= 0;
    }
    isUnderline() {
        return this.style.indexOf("Underline") >= 0;
    }
    htmlStyle() {
        return `font-weight:${this.isBold() ? "bold" : "normal"};font-style:${this.isItalic() ? "italic" : "normal"}; text-decoration:${this.isUnderline() ? "underline" : ""};font-family:"${this.family}";font-size:${this.size}pt`;
    }
    equals(font) {
        return this.htmlStyle() == (font === null || font === void 0 ? void 0 : font.htmlStyle());
    }
    clone() {
        return new Font(this._family, this.size, this.cloneStyle);
    }
}

class StiTextItem {
    constructor(value = "", font = new Font("Segoe UI", 9), color = Color.black(), backgroundColor, horizontalAlignment) {
        this.font = font;
        this.color = color;
        this.backgroundColor = backgroundColor;
        this.horizontalAlignment = horizontalAlignment;
        this._isChanged = true;
        this._value = value;
    }
    get eValue() {
        return this.value;
    }
    set eValue(value) {
        this.value = value;
    }
    get eFont() {
        return this.font;
    }
    set eFont(value) {
        this.font = value;
    }
    get eColor() {
        return this.color;
    }
    set eColor(value) {
        this.color = value;
    }
    get eBackgroundColor() {
        return this.backgroundColor;
    }
    set eBackgroundColor(value) {
        this.backgroundColor = value;
    }
    get value() {
        return this._value;
    }
    set value(value) {
        this._value = value;
        this._isChanged = true;
    }
    isChanged() {
        var _a, _b, _c;
        return this._isChanged || ((_a = this.font) === null || _a === void 0 ? void 0 : _a.isChanged) || ((_b = this.color) === null || _b === void 0 ? void 0 : _b.isChanged()) || ((_c = this.backgroundColor) === null || _c === void 0 ? void 0 : _c.isChanged());
    }
    setProperty(propName, value, oldObject) {
        if (propName.startsWith("font") && (oldObject === null || this.font.equals(oldObject))) {
            this.font.setProperty(propName.replace("font.", ""), value);
        }
        else if (propName == "color" && (oldObject === null || this.color.equals(oldObject))) {
            this.color = value.clone();
        }
    }
    resetChanged() {
        var _a, _b, _c;
        this._isChanged = false;
        (_a = this.font) === null || _a === void 0 ? void 0 : _a.resetChanged();
        (_b = this.color) === null || _b === void 0 ? void 0 : _b.resetChanged();
        (_c = this.backgroundColor) === null || _c === void 0 ? void 0 : _c.resetChanged();
    }
    haveBackgoundColor() {
        return this.backgroundColor ? true : false;
    }
    haveVerticalAlignment() {
        return false;
    }
    get eContentAlignment() {
        return this.horizontalAlignment;
    }
    set eContentAlignment(value) {
        this.horizontalAlignment = value;
    }
    haveContentAlignment() {
        return this.horizontalAlignment ? true : false;
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyStringNullOrEmpty("Value", this.value);
        json.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        json.addPropertyColor("Color", this.color);
        if (this.horizontalAlignment) {
            json.addPropertyEnum("HorizontalAlignment", StiHorizontalAlignment, this.horizontalAlignment);
        }
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Value":
                    this.value = property.value;
                    break;
                case "Font":
                    this.font = new Font();
                    this.font.loadFromJsonObject(property.value);
                    break;
                case "Color":
                    this.color = new Color();
                    this.color.deserializeFromString(property.value);
                    break;
                case "HorizontalAlignment":
                    this.horizontalAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
            }
        }
    }
    htmlStyle() {
        return `${this.font.htmlStyle()};color:${this.color.toHtmlColor()}`;
    }
}

class StiInputTextItem extends StiTextItem {
    get eContentAlignment() {
        return this.element.contentAlignment;
    }
    set eContentAlignment(value) {
        this.element.contentAlignment = value;
    }
}

class StiRectangleGeometry {
    constructor(width = 0, height = 0, changesInterceptor) {
        this._x = 0;
        this._y = 0;
        this._minWidth = 0;
        this._minHeight = 0;
        this._maxWidth = 10000000;
        this._maxHeight = 10000000;
        this.width = width;
        this.height = height;
        this._minWidth = 5;
        this._minHeight = height;
        this.changesInterceptor = changesInterceptor;
    }
    isChanged() {
        return this.savedGeometry == null || !this.savedGeometry.equals(this);
    }
    resetChanged() {
        this.savedGeometry = this.clone();
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyNumber("X", this.x);
        json.addPropertyNumber("Y", this.y);
        json.addPropertyNumber("Width", this.width);
        json.addPropertyNumber("Height", this.height);
        json.addPropertyNumber("MinWidth", this.minWidth);
        json.addPropertyNumber("MinHeight", this.minHeight);
        json.addPropertyNumber("MaxWidth", this.width);
        json.addPropertyNumber("MaxHeight", this.height);
        return json;
    }
    equals(geometry) {
        return (this.x == geometry.x &&
            this.y == geometry.y &&
            this.width == geometry.width &&
            this.height == geometry.height &&
            this.minHeight == geometry.minHeight &&
            this.minWidth == geometry.minWidth);
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "X":
                    this._x = property.value;
                    break;
                case "Y":
                    this._y = property.value;
                    break;
                case "Width":
                    this._width = property.value;
                    break;
                case "Height":
                    this._height = property.value;
                    break;
                case "MinWidth":
                    this._minWidth = property.value;
                    break;
                case "MinHeight":
                    this._minHeight = property.value;
                    break;
                case "MaxWidth":
                    this._maxWidth = property.value;
                    break;
                case "MaxHeight":
                    //this._minHeight = property.value;
                    break;
            }
        }
    }
    clone() {
        let result = new StiRectangleGeometry(this.width, this.height);
        result._x = this.x;
        result._y = this.y;
        result._minWidth = this.minWidth;
        result._minHeight = this.minHeight;
        return result;
    }
    get x() {
        return this._x;
    }
    set x(value) {
        this._x = value;
    }
    get y() {
        return this._y;
    }
    set y(value) {
        this._y = value;
    }
    get width() {
        return this._width;
    }
    set width(value) {
        let oldGeometry = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._width;
        this._width = Math.max(value, this._minWidth);
        if (this.changesInterceptor && oldValue != this._width) {
            this.changesInterceptor.propertyChanged("geometry.width", value, oldGeometry);
        }
    }
    get height() {
        return this._height;
    }
    set height(value) {
        let oldGeometry = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._height;
        this._height = Math.max(value, this.minHeight);
        if (this.changesInterceptor && oldValue != this._height) {
            this.changesInterceptor.propertyChanged("geometry.height", value, oldGeometry);
        }
    }
    get minWidth() {
        return this._minWidth;
    }
    set minWidth(value) {
        let oldGeometry = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._minWidth;
        this._minWidth = Math.min(value, this._maxWidth);
        this._width = Math.max(this._minWidth, this._width);
        if (this.changesInterceptor && oldValue != this._minWidth) {
            this.changesInterceptor.propertyChanged("geometry.minWidth", value, oldGeometry);
        }
    }
    get minHeight() {
        return this._minHeight;
    }
    set minHeight(value) {
        let oldValue = this._minHeight;
        let oldGeometry = this.changesInterceptor ? this.clone() : null;
        this._minHeight = Math.min(value, this._maxHeight);
        this._height = Math.max(this._minHeight, this._height);
        if (this.changesInterceptor && oldValue != this._minHeight) {
            this.changesInterceptor.propertyChanged("geometry.minHeight", value, oldGeometry);
        }
    }
    /*public get maxWidth(): number {
      return this._maxWidth;
    }
  
    public set maxWidth(value: number) {
      let oldValue = this._maxWidth;
      this._maxWidth = Math.max(value, this._minWidth);
      this._width = Math.min(this._maxWidth, this.width);
      if (this.changesInterceptor && oldValue != this._maxWidth) {
        this.changesInterceptor.propertyChanged("geometry.maxWidth", value);
      }
    }
  
    public get maxHeight(): number {
      return this._maxHeight;
    }
  
    public set maxHeight(value: number) {
      let oldValue = this._maxHeight;
      this._maxHeight = Math.max(value, this._minHeight);
      this._height = Math.min(this._maxHeight, this.height);
      if (this.changesInterceptor && oldValue != this._maxHeight) {
        this.changesInterceptor.propertyChanged("geometry.maxHeight", value);
      }
    }*/
    get right() {
        return this._x + this._width;
    }
    get bottom() {
        return this._y + this._height;
    }
    get centerX() {
        return this._x + this._width / 2;
    }
    get centerY() {
        return this._y + this._height / 2;
    }
    withY(newY) {
        let copy = this.clone();
        copy.y = newY;
        return copy;
    }
    xProjectionIntersectsWith(other) {
        return (this.x < other.right &&
            this.right > other.x &&
            Math.abs(this.right - other.x) > StiRectangleGeometry.DELTA &&
            Math.abs(this.x - other.right) > StiRectangleGeometry.DELTA);
    }
    intersectWith(geometry) {
        let aLeftOfB = geometry.right - StiRectangleGeometry.DELTA < this.x;
        let aRightOfB = geometry.x > this.right - StiRectangleGeometry.DELTA;
        let aAboveB = geometry.y > this.bottom - StiRectangleGeometry.DELTA;
        let aBelowB = geometry.bottom - StiRectangleGeometry.DELTA < this.y;
        return !(aLeftOfB || aRightOfB || aAboveB || aBelowB);
    }
}
StiRectangleGeometry.DELTA = 1;

class StiLocalizationService {
    constructor() {
        this._localizationList = [];
        StiLocalizationService.setDeflocalization();
    }
    get localizationList() {
        return this._localizationList;
    }
    set localizationList(array) {
        let locList = this.toCamelCase(array);
        this._localizationList = locList;
    }
    static setDeflocalization() {
        this.localization = JSON.parse(JSON.stringify(this.deflocalization));
    }
    toCamelCase(obj) {
        if (Array.isArray(obj)) {
            return obj.map((v) => this.toCamelCase(v));
        }
        else if (obj != null && obj.constructor === Object) {
            return Object.keys(obj).reduce((result, key) => (Object.assign(Object.assign({}, result), { [camelCase(key)]: this.toCamelCase(obj[key]) })), {});
        }
        return obj;
    }
    static updateLocalization(from, to) {
        for (let promName in from) {
            if (typeof from[promName] === "string") {
                to[promName] = from[promName];
            }
            else {
                if (to[promName] == undefined) {
                    to[promName] = from[promName];
                }
                else {
                    this.updateLocalization(from[promName], to[promName]);
                }
            }
        }
    }
    loadLocalization(str) {
        StiLocalizationService.setLocalization(str);
        StiLocalizationService.needToRefresh.next(true);
    }
    changeCurrentLocalization(locName) {
        this.currentLocalization = this.localizationList.find((loc) => loc.cultureName == locName);
    }
    static setLocalization(str) {
        if (str) {
            this.setDeflocalization();
            let jsonLoc = str;
            if (str && str.indexOf("<?xml") == 0) {
                let xml = new DOMParser().parseFromString(str, "text/xml");
                jsonLoc = this.xml2json(xml);
            }
            this.updateLocalization(jsonLoc, this.localization);
        }
    }
    static get(category, key) {
        var _a;
        let loc = (_a = this.localization) === null || _a === void 0 ? void 0 : _a.Localization;
        return loc && loc[category][key] ? loc[category][key] : key;
    }
    getP(key) {
        return StiLocalizationService.get("PropertyMain", key);
    }
    get2(category, key) {
        return StiLocalizationService.get(category, key);
    }
    static xml2json(xml, tab = "") {
        let X = {
            toObj: function (xml) {
                let o = {};
                if (xml.nodeType == 1) {
                    // element node ..
                    if (xml.attributes.length)
                        // element with attributes  ..
                        for (let i = 0; i < xml.attributes.length; i++)
                            o["@" + xml.attributes[i].nodeName] = (xml.attributes[i].nodeValue || "").toString();
                    if (xml.firstChild) {
                        // element has child nodes ..
                        let textChild = 0, cdataChild = 0, hasElementChild = false;
                        for (let n = xml.firstChild; n; n = n.nextSibling) {
                            if (n.nodeType == 1)
                                hasElementChild = true;
                            else if (n.nodeType == 3 && n.nodeValue.match(/[^ \f\n\r\t\v]/))
                                textChild++; // non-whitespace text
                            else if (n.nodeType == 4)
                                cdataChild++; // cdata section node
                        }
                        if (hasElementChild) {
                            if (textChild < 2 && cdataChild < 2) {
                                // structured element with evtl. a single text or/and cdata node ..
                                X.removeWhite(xml);
                                for (let n = xml.firstChild; n; n = n.nextSibling) {
                                    if (n.nodeType == 3)
                                        // text node
                                        o["#text"] = X.escape(n.nodeValue);
                                    else if (n.nodeType == 4)
                                        // cdata node
                                        o["#cdata"] = X.escape(n.nodeValue);
                                    else if (o[n.nodeName]) {
                                        // multiple occurence of element ..
                                        if (o[n.nodeName] instanceof Array)
                                            o[n.nodeName][o[n.nodeName].length] = X.toObj(n);
                                        else
                                            o[n.nodeName] = [o[n.nodeName], X.toObj(n)];
                                    } // first occurence of element..
                                    else
                                        o[n.nodeName] = X.toObj(n);
                                }
                            }
                            else {
                                // mixed content
                                if (!xml.attributes.length)
                                    o = X.escape(X.innerXml(xml));
                                else
                                    o["#text"] = X.escape(X.innerXml(xml));
                            }
                        }
                        else if (textChild) {
                            // pure text
                            if (!xml.attributes.length)
                                o = X.escape(X.innerXml(xml));
                            else
                                o["#text"] = X.escape(X.innerXml(xml));
                        }
                        else if (cdataChild) {
                            // cdata
                            if (cdataChild > 1)
                                o = X.escape(X.innerXml(xml));
                            else
                                for (let n = xml.firstChild; n; n = n.nextSibling)
                                    o["#cdata"] = X.escape(n.nodeValue);
                        }
                    }
                    if (!xml.attributes.length && !xml.firstChild)
                        o = null;
                }
                else if (xml.nodeType == 9) {
                    // document.node
                    o = X.toObj(xml.documentElement);
                }
                else
                    alert("unhandled node type: " + xml.nodeType);
                return o;
            },
            toJson: function (o, name, ind) {
                let json = name ? '"' + name + '"' : "";
                if (o instanceof Array) {
                    for (let i = 0, n = o.length; i < n; i++)
                        o[i] = X.toJson(o[i], "", ind + "\t");
                    json +=
                        (name ? ":[" : "[") +
                            (o.length > 1 ? "\n" + ind + "\t" + o.join(",\n" + ind + "\t") + "\n" + ind : o.join("")) +
                            "]";
                }
                else if (o == null)
                    json += (name && ":") + "null";
                else if (typeof o == "object") {
                    let arr = [];
                    for (let m in o)
                        arr[arr.length] = X.toJson(o[m], m, ind + "\t");
                    json +=
                        (name ? ":{" : "{") +
                            (arr.length > 1 ? "\n" + ind + "\t" + arr.join(",\n" + ind + "\t") + "\n" + ind : arr.join("")) +
                            "}";
                }
                else if (typeof o == "string")
                    json += (name && ":") + '"' + o.toString() + '"';
                else
                    json += (name && ":") + o.toString();
                return json;
            },
            innerXml: function (node) {
                let s = "";
                if ("innerHTML" in node)
                    s = node.innerHTML;
                else {
                    let asXml = function (n) {
                        let s = "";
                        if (n.nodeType == 1) {
                            s += "<" + n.nodeName;
                            for (let i = 0; i < n.attributes.length; i++)
                                s += " " + n.attributes[i].nodeName + '="' + (n.attributes[i].nodeValue || "").toString() + '"';
                            if (n.firstChild) {
                                s += ">";
                                for (let c = n.firstChild; c; c = c.nextSibling)
                                    s += asXml(c);
                                s += "</" + n.nodeName + ">";
                            }
                            else
                                s += "/>";
                        }
                        else if (n.nodeType == 3)
                            s += n.nodeValue;
                        else if (n.nodeType == 4)
                            s += "<![CDATA[" + n.nodeValue + "]]>";
                        return s;
                    };
                    for (let c = node.firstChild; c; c = c.nextSibling)
                        s += asXml(c);
                }
                return s;
            },
            escape: function (txt) {
                return txt.replace(/[\\]/g, "\\\\").replace(/[\"]/g, '\\"').replace(/[\n]/g, "\\n").replace(/[\r]/g, "\\r");
            },
            removeWhite: function (e) {
                e.normalize();
                for (let n = e.firstChild; n;) {
                    if (n.nodeType == 3) {
                        // text node
                        if (!n.nodeValue.match(/[^ \f\n\r\t\v]/)) {
                            // pure whitespace text node
                            let nxt = n.nextSibling;
                            e.removeChild(n);
                            n = nxt;
                        }
                        else
                            n = n.nextSibling;
                    }
                    else if (n.nodeType == 1) {
                        // element node
                        X.removeWhite(n);
                        n = n.nextSibling;
                    } // any other node
                    else
                        n = n.nextSibling;
                }
                return e;
            },
        };
        if (xml.nodeType == 9)
            // document node
            xml = xml.documentElement;
        let json = X.toJson(X.toObj(X.removeWhite(xml)), xml.nodeName, "\t");
        return JSON.parse("{\n" + tab + (tab ? json.replace(/\t/g, tab) : json.replace(/\t|\n/g, "")) + "\n}");
    }
}
StiLocalizationService.localization = {};
StiLocalizationService.deflocalization = JSON.parse('{"Localization":{"@language":"English","@description":"English","@cultureName":"en","A_WebViewer":{"AbbreviatedDayFriday":"Fr","AbbreviatedDayMonday":"Mo","AbbreviatedDaySaturday":"Sa","AbbreviatedDaySunday":"Su","AbbreviatedDayThursday":"Th","AbbreviatedDayTuesday":"Tu","AbbreviatedDayWednesday":"We","Attachment":"Attachment:","ButtonNext":"Next","ButtonPrev":"Previous","ButtonSend":"Send","CategoryAlreadyExists":"The category with that name already exists!","DayFriday":"Friday","DayMonday":"Monday","Days":"Days","DaySaturday":"Saturday","DaySunday":"Sunday","DayThursday":"Thursday","DayTuesday":"Tuesday","DayWednesday":"Wednesday","Email":"Email:","EmailOptions":"Email Options","FirstPage":"First Page","Hours":"Hours","LabelFrom":"From:","LabelSelectExportFormat":"Select the format to which you want to save the report:","LabelTo":"To:","LastPage":"Last Page","Loading":"Loading...","Message":"Message:","Minutes":"Minutes","MonthApril":"April","MonthAugust":"August","MonthDecember":"December","MonthFebruary":"February","MonthJanuary":"January","MonthJuly":"July","MonthJune":"June","MonthMarch":"March","MonthMay":"May","MonthNovember":"November","MonthOctober":"October","MonthSeptember":"September","NextPage":"Next Page","OnePage":"One Page","Page":"Page","PageOf":"of","PreviousPage":"Previous Page","PrintContinue":"Click Print to continue","PrintReport":"Print","PrintToPdf":"PDF","PrintToXps":"Microsoft XPS","PrintWithoutPreview":"Print","PrintWithPreview":"Preview","SaveReport":"Save","Subject":"Subject:","TabItemContacts":"Contacts","TextComputer":"Computer","TextItemsRoot":"Root","TodayDate":"Today","WholeReport":"Whole Report"},"Adapters":{"AdapterBusinessObjects":"Data from Business Objects","AdapterConnection":"Data from {0}","AdapterCrossTabDataSource":"Data from Cross-Tab","AdapterCsvFiles":"Data from CSV Files","AdapterDataTables":"Data from DataSet, DataTables","AdapterDataViews":"Data from DataViews","AdapterDB2Connection":"Data from IBM DB2 Connection","AdapterDBaseFiles":"Data from dBase Files","AdapterFirebirdConnection":"Data from Firebird Connection","AdapterInformixConnection":"Data from Informix Connection","AdapterMySQLConnection":"Data from MySQL Connection","AdapterOdbcConnection":"Data from ODBC Connection","AdapterOleDbConnection":"Data from OLE DB Connection","AdapterOracleConnection":"Data from Oracle Connection","AdapterOracleODPConnection":"Data from Oracle ODP.NET Connection","AdapterPostgreSQLConnection":"Data from PostgreSQL Connection","AdapterSqlCeConnection":"Data from SQL CE Connection","AdapterSqlConnection":"Data from SQL Connection","AdapterSQLiteConnection":"Data from SQLite Connection","AdapterTeradataConnection":"Data from Teradata Connection","AdapterUniDirectConnection":"Data from Uni Direct Connection","AdapterUserSources":"Data from User Sources","AdapterVirtualSource":"Data from other Data Source","AdapterVistaDBConnection":"Data from VistaDB Connection"},"BarCode":{"Post":"Post","TwoDimensional":"Two-Dimensional"},"Buttons":{"Add":"Add","AddAllColumns":"Add All Columns","Attach":"Attach","Build":"Build...","Buttons":"Buttons","Cancel":"&amp;Cancel","Check":"Check","Close":"Close","Delete":"Delete","Design":"Design","Down":"Down","Duplicate":"Duplicate","Export":"Export","ForceDelete":"Force Delete","Help":"Help","Install":"Install","LessOptions":"Less Options","LoadDataSet":"Load DataSet (*.data)","More":"More","MoreApps":"More Apps","MoreOptions":"More Options","MoveLeft":"Move Left","MoveRight":"Move Right","MoveToResource":"Move to Resource","No":"&amp;No","Ok":"&amp;OK","Open":"Open","OpenContainingFolder":"Open Containing Folder","Print":"Print","Publish":"Publish","QuickPrint":"Quick Print","Remove":"Remove","RemoveAll":"Remove All","Rename":"Rename","RestoreDefaults":"Restore Defaults","Reverse":"Reverse","Save":"Save","SaveCopy":"Save a Copy","SetAll":"Set All","ShowLess":"Show Less","ShowMore":"Show More","ShowSpecific":"Show \'{0}\'","Sign":"Sign","Submit":"Submit","SwitchTo":"Switch to {0}","Test":"Test","Up":"Up","Upgrade":"Upgrade","UpgradeNow":"Upgrade Now","Upload":"Upload","Waiting":"Waiting","Yes":"&amp;Yes"},"Chart":{"AddCondition":"&amp;Add Condition","AddConstantLine":"Add Constant Line","AddFilter":"&amp;Add Filter","AddSeries":"&amp;Add Series","AddStrip":"Add Strip","AddTrendLine":"Add Trend Line","Area":"Area","Axes":"Axes","AxisReverse":"Reverse","AxisX":"Axis X","AxisY":"Axis Y","BoxAndWhisker":"Box and Whisker","Bubble":"Bubble","Candlestick":"Candlestick","ChartConditionsCollectionForm":"Conditions","ChartEditorForm":"Chart Editor","ChartFiltersCollectionForm":"Filters","ChartType":"Chart Type","CheckBoxAutoRotation":"Auto Rotation","ClusteredBar":"Clustered Bar","ClusteredColumn":"Clustered Column","Common":"Common","ConstantLine":"Constant Line","ConstantLinesEditorForm":"Constant Lines Editor","DataColumns":"Data Columns","Doughnut":"Doughnut","Financial":"Financial","FullStackedArea":"Full-Stacked Area","FullStackedBar":"Full-Stacked Bar","FullStackedColumn":"Full-Stacked Column","FullStackedLine":"Full-Stacked Line","FullStackedSpline":"Full-Stacked Spline","FullStackedSplineArea":"Full-Stacked Spline Area","Funnel":"Funnel","FunnelWeightedSlices":"Funnel Weighted Slices","Gantt":"Gantt","GridInterlaced":"Interlaced","GridLines":"Grid Lines","Histogram":"Histogram","LabelAlignment":"Alignment:","LabelAlignmentHorizontal":"Horizontal:","LabelAlignmentVertical":"Vertical:","LabelAngle":"Angle:","LabelArgumentDataColumn":"Argument Data Column:","LabelAutoRotation":"Auto Rotation:","LabelCloseValueDataColumn":"Close Value Data Column:","LabelEndValueDataColumn":"End Value Data Column:","LabelHighValueDataColumn":"High Value Data Column:","LabelHorizontal":"Horizontal:","LabelLowValueDataColumn":"Low Value Data Column:","LabelMinorCount":"Minor Count:","LabelOpenValueDataColumn":"Open Value Data Column:","Labels":"Labels","LabelsCenter":"Center","LabelSeriesName":"Series Name:","LabelsInside":"Inside","LabelsInsideBase":"Inside Base","LabelsInsideEnd":"Inside End","LabelsNone":"None","LabelsOutside":"Outside","LabelsOutsideBase":"Outside Base","LabelsOutsideEnd":"Outside End","LabelsOverlay":"Overlay","LabelsStyleCategory":"Category","LabelsStyleCategoryPercentOfTotal":"Category - Percent Of Total","LabelsStyleCategoryValue":"Category - Value","LabelsStylePercentOfTotal":"Percent Of Total","LabelsStyleValue":"Value","LabelsTwoColumns":"Two Columns","LabelTextAfter":"Text After:","LabelTextBefore":"Text Before:","LabelTitleAlignment":"Alignment:","LabelValueDataColumn":"Value Data Column:","LabelValueType":"Value Type:","LabelVertical":"Vertical:","LabelVisible":"Visible:","Legend":"Legend","LegendSpacing":"Spacing","Line":"Line","ListOfValues":"List of Values","Marker":"Marker","MoveConstantLineDown":"Move Constant Line Down","MoveConstantLineUp":"Move Constant Line Up","MoveSeriesDown":"Move Series Down","MoveSeriesUp":"Move Series Up","MoveStripDown":"Move Strip Down","MoveStripUp":"Move Strip Up","NoConditions":"No Conditions","NoFilters":"No Filters","Pareto":"Pareto","Pictorial":"Pictorial","PictorialStacked":"Pictorial Stacked","Pie":"Pie","Radar":"Radar","RadarArea":"Radar Area","RadarColumn":"Radar Column","RadarLine":"Radar Line","RadarPoint":"Radar Point","Range":"Range","RangeBar":"Range Bar","RemoveCondition":"&amp;Remove Condition","RemoveConstantLine":"Remove Constant Line","RemoveFilter":"&amp;Remove Filter","RemoveSeries":"&amp;Remove Series","RemoveStrip":"Remove Strip","Ribbon":"Ribbon","RunChartWizard":"Run Chart &amp;Wizard","Scatter":"Scatter","ScatterLine":"Scatter Line","ScatterSpline":"Scatter Spline","Series":"Series","SeriesColorsCollectionForm":"Series Colors","SeriesEditorForm":"Series Editor","Serieses":"Series","SparklinesArea":"Area","SparklinesColumn":"Column","SparklinesLine":"Line","SparklinesWinLoss":"Win / Loss","Spline":"Spline","SplineArea":"Spline Area","SplineRange":"Spline Range","StackedArea":"Stacked Area","StackedBar":"Stacked Bar","StackedColumn":"Stacked Column","StackedLine":"Stacked Line","StackedSpline":"Stacked Spline","StackedSplineArea":"Stacked Spline Area","SteppedArea":"Stepped Area","SteppedLine":"Stepped Line","SteppedRange":"Stepped Range","Stock":"Stock","Strip":"Strip","StripsEditorForm":"Strips Editor Form","Style":"Style","Sunburst":"Sunburst","Treemap":"Treemap","TrendLinesEditorForm":"Trend Lines Editor","Waterfall":"Waterfall"},"CharterMapEditor":{"Characters":"Characters"},"ChartRibbon":{"Axes":"Axes","AxesArrowStyle":"Arrow Style","AxesArrowStyleLines":"Lines","AxesArrowStyleNone":"None","AxesArrowStyleTriangle":"Triangle","AxesLabel":"Label Placement","AxesLabelsNone":"None","AxesLabelsOneLine":"One Line","AxesLabelsTwoLines":"Two Lines","AxesReverseHorizontal":"Reverse Horizontal","AxesReverseVertical":"Reverse Vertical","AxesTicks":"Ticks","AxesTicksMajor":"Major","AxesTicksMinor":"Minor","AxesTicksNone":"None","AxesVisible":"Visible","AxesXAxis":"X Axis","AxesXTopAxis":"X Top Axis","AxesYAxis":"Y Axis","AxesYRightAxis":"Y Right Axis","CenterLabels":"Center","ChangeType":"Change Type","GridLines":"Grid Lines","GridLinesHorizontal":"Grid Lines Horizontal","GridLinesVertical":"Grid Lines Vertical","HorAlCenter":"&lt;b&gt;Overlay Legend at Center&lt;/b&gt;&lt;br&gt;Show Legend at center of the chart&lt;/br&gt;&lt;br&gt;without resizing&lt;/br&gt;","HorAlLeft":"&lt;b&gt;Overlay Legend at Left&lt;/b&gt;&lt;br&gt;Show Legend at left of the chart&lt;/br&gt;&lt;br&gt;without resizing&lt;/br&gt;","HorAlLeftOutside":"&lt;b&gt;Show Legend at Left&lt;/b&gt;&lt;br&gt;Show Legend and align left&lt;/br&gt;","HorAlRight":"&lt;b&gt;Overlay Legend at Right&lt;/b&gt;&lt;br&gt;Show Legend at right of the chart&lt;/br&gt;&lt;br&gt;without resizing&lt;/br&gt;","HorAlRightOutside":"&lt;b&gt;Show Legend at Right&lt;/b&gt;&lt;br&gt;Show Legend and align right&lt;/br&gt;","HorizontalMajor":"&lt;b&gt;Major&lt;/b&gt;&lt;br&gt;Display Horizontal Gridlines for Major units&lt;/br&gt;","HorizontalMajorMinor":"&lt;b&gt;Major &amp;&amp; Minor Gridlines&lt;/b&gt;&lt;br&gt;Display Horizontal Gridlines for Major and Minor units&lt;/br&gt;","HorizontalMinor":"&lt;b&gt;Minor&lt;/b&gt;&lt;br&gt;Display Horizontal Gridlines for Minor units&lt;/br&gt;","HorizontalNone":"&lt;b&gt;None&lt;/b&gt;&lt;br&gt;Do not display Horizontal Grirdlines&lt;/br&gt;","InsideBaseLabels":"Inside Base","InsideEndLabels":"Inside End","Labels":"Series Labels","Legend":"Legend","LegendHorizontalAlignment":"Horizontal Alignment","LegendMarker":"Marker","LegendMarkerAlignmentLeft":"Left","LegendMarkerAlignmentRight":"Right","LegendMarkerVisible":"Visible","LegendVerticalAlignment":"Vertical Alignment","LegendVisible":"Visible","NoneLabels":"None","OutsideBaseLabels":"Outside Base","OutsideEndLabels":"Outside End","OutsideLabels":"Outside","ribbonBarAxis":"Axes","ribbonBarChartStyles":"Chart Styles","ribbonBarChartType":"Chart Type","ribbonBarLabels":"Labels","ribbonBarLegend":"Legend","Style":"Change Style","TwoColumnsPieLabels":"Two Columns","VertAlBottom":"&lt;b&gt;Overlay Legend at Bottom&lt;/b&gt;&lt;br&gt;Show Legend at bottom of the chart&lt;/br&gt;&lt;br&gt;without resizing&lt;/br&gt;","VertAlBottomOutside":"&lt;b&gt;Show Legend at Bottom&lt;/b&gt;&lt;br&gt;Show Legend and align bottom&lt;/br&gt;","VertAlCenter":"&lt;b&gt;Overlay Legend at Center&lt;/b&gt;&lt;br&gt;Show Legend at center of the chart&lt;/br&gt;&lt;br&gt;without resizing&lt;/br&gt;","VertAlTop":"&lt;b&gt;Overlay Legend at Top&lt;/b&gt;&lt;br&gt;Show Legend at top of the chart&lt;/br&gt;&lt;br&gt;without resizing&lt;/br&gt;","VertAlTopOutside":"&lt;b&gt;Show Legend at Top&lt;/b&gt;&lt;br&gt;Show Legend and align top&lt;/br&gt;","VerticalMajor":"&lt;b&gt;Major&lt;/b&gt;&lt;br&gt;Display Vertical Gridlines for Major units&lt;/br&gt;","VerticalMajorMinor":"&lt;b&gt;Major &amp;&amp; Minor Gridlines&lt;/b&gt;&lt;br&gt;Display Vertical Gridlines for Major and Minor units&lt;/br&gt;","VerticalMinor":"&lt;b&gt;Minor&lt;/b&gt;&lt;br&gt;Display Vertical Gridlines for Minor units&lt;/br&gt;","VerticalNone":"&lt;b&gt;None&lt;/b&gt;&lt;br&gt;Do not display Vertical Gridlines&lt;/br&gt;"},"Cloud":{"AcceptTermsAndPrivacyPolicy":"I read and accept the {0} and {1}","Account":"Account","AccountSettings":"Account Settings","AddAPlace":"Add a Place","AreYouSureYouWantDeleteReport":"Are you sure you want to delete \\"{0}\\" report from disk?","Authorize":"Authorize","AuthorizeWithLicenseKey":"Authorize with License Key","ButtonChangePassword":"Change Password","ButtonDeleteAll":"Delete All","ButtonDesign":"Design Report","ButtonLater":"Later","ButtonLogInWith":"Log In with {0}","ButtonLogout":"Logout","ButtonPublish":"Publish","ButtonPurchase":"Purchase","ButtonRecover":"Recover","ButtonRenew":"Renew","ButtonResendEmail":"Resend Email","ButtonResetPassword":"Reset Password","ButtonRun":"Run","ButtonScheduler":"Scheduler","ButtonShare":"Share","ButtonSignUp":"Sign Up","ButtonSignUpWith":"Sign Up with {0}","ButtonSkip":"Skip","ButtonView":"View","ButtonWhereUsed":"Where is it used?","Cancel":"Cancel","CheckBoxMoveToRecycleBin":"Move to Recycle Bin","CheckBoxRememberMe":"Remember Me","CheckForUpdate":"Check for Update","Cloud":"Cloud","Collection":"Collection","Create":"Create","CreateError":"Error while creating report!","CreateNewCollection":"Create New Collection","CreateYourTeam":"Create your team","CreatingReport":"Creating report...","DashboardWindowTitleNew":"New Dashboard","DeleteFile":"Delete File","DoNotAskMe":"Do not ask me again","EnterUserNameToLogin":"Enter User Name (email) to log in.","ExecutionError":"Execution error","ExpiredDate":"Expired Date","FileStorageWindowTitleEdit":"Edit File Storage","FileStorageWindowTitleNew":"New File Storage","FolderWindowTitleEdit":"Edit Folder","FolderWindowTitleNew":"New Folder","ForExample":"For example","GroupBoxAttachedItems":"Attached Items","HyperlinkAgreeToTerms":"By registering you agree to Terms.","HyperlinkAlreadyHaveAccount":"Already have account","HyperlinkForgotPassword":"Forgot password","HyperlinkHavePassword":"Have password","HyperlinkRegisterAccount":"Register FREE account","InstallSamples":"Install Samples","Invitations":"Invitations","Invite":"Invite","LabelAddCloudFolder":"Connect your Stimulsoft Cloud folder with reports and dashboards.","LabelAddFolder":"Add your local folder with reports and dashboards.","labelCollectionName":"Collection Name:","LabelCreated":"Created:","LabelCreateFolder":"Create a new category in which you can place other items.","LabelCreateNewDashboard":"Create new dashboard.","LabelCreateReportTemplate":"Create report template.","LabelCurrentPassword":"Current Password:","LabelDataFile":"Data File:","LabelDataUrl":"Data URL:","LabelEndDate":"End Date:","labelFileName":"File Name:","LabelForeground":"Foreground:","LabelFromReport":"From Report","LabelFromReportCode":"From Report (define in code)","LabelInviteUser":"Invite new users to your team. Send invitations to their emails.","LabelLastLogin":"Last Log In:","LabelLastTime":"Last Time:","LabelModified":"Modified:","LabelNewPassword":"New Password:","LabelNextTime":"Next Time:","labelPassword":"Password:","LabelPermission":"Permission:","LabelPicture":"Picture:","LabelRenderedReport":"Rendered report","LabelResponseAsFile":"Response as File","LabelResultType":"Result Type:","LabelSeparateReport":"Separate report (and scripts) file","LabelShowReport":"Show report:","LabelStartDate":"Start Date:","labelUserName":"User Name:","License":"License","LicenseInformation":"License Information","LicenseKey":"License Key","Login":"Log In","MyTeam":"My Team","NofM":"{0}: {1} of {2}","Open":"Open","OpenFile":"Open File","OperationCreate":"Create \'{0}\'","OperationDelete":"Delete \'{0}\' from Server","OperationDownload":"Download from Server","OperationGetList":"Get List of Files from Server","OperationLogin":"Log In to Server","OperationRename":"Rename \'{0}\' to \'{1}\'","OperationUpload":"Upload \'{0}\' to Server","page":"page","Platforms":"Platforms","Port":"Port","PrivacyPolicy":"Privacy","Products":"Products","Proxy":"Proxy","PublishMessage":"In order to publish this report you should submit it to our service publish.stimulsoft.com","questionOpenThisFile":"Are you sure want to open \'{0}\' item?","questionOverrideItem":"Do you really want to override \'{0}\' item?","questionRemoveItem":"Do you really want to remove \'{0}\' item?","RefreshList":"Refresh List","ReportDocumentFormatNotRecognized":"Format of \'{0}\' item is not recognized as rendered report format!","ReportTemplateFormatNotRecognized":"Format of \'{0}\' item is not recognized as report template format!","RequestChangesWhenSavingToCloud":"Request Changes when Saving to Stimulsoft Cloud","RibbonButtonAddRole":"Add Role","RibbonButtonAddUser":"Add User","RibbonButtonAddWorkspace":"Add Workspace","RibbonButtonFolder":"Folder","RibbonTabUsers":"Users","Root":"Root","RootFolder":"Root Folder","Save":"Save","SaveAccountSettings":"Save Account Settings","SaveAsType":"Save as type","SaveFile":"Save File","SavingToStimulsoftCloudPleaseWait":"Saving the report to Stimulsoft Cloud. Please wait!","SearchForOnlineTemplates":"Search Stimulsoft templates online","ShareWindowTitleNew":"Share","ShowAllFiles":"Show All Files","ShowNotificationMessages":"Show Notification Messages","Subscriptions":"Subscriptions","TabItemEmbedCode":"Embed Code","TabItemQRCode":"QR Code","TabItemShare":"Link to Share","Team":"Team","TermsOfUse":"Terms","TextActivated":"Activated","TextActivationDate":"Activation Date","TextDelete":"Delete","TextDeletingItems":"Deleting items...","TextDescriptionChanges":"Please, type a description of the changes:","TextFirstName":"First Name","TextFromTo":"From {0} to {1} (Total - {2})","TextItemsWorkspace":"Workspace","TextLastName":"Last Name","TextModify":"Modify","TextNewsLetters":"News Letters","TextNoFavoriteFiles":"No favorite files","TextNoFiles":"No files","TextNoNotifications":"No Notifications","TextNoRecentFiles":"No recent files","TextOwner":"Owner","TextProfile":"Profile","TextReports":"Reports","TextRestoringItems":"Restoring items...","TextRole":"Role","TextRun":"Run","TextUser":"User","TextUserName":"User Name (Email)","TimeHoursAgoFive":"Five hours ago, {0:t}","TimeHoursAgoFour":"Four hours ago, {0:t}","TimeHoursAgoOne":"One hour ago, {0:t}","TimeHoursAgoThree":"Three hours ago, {0:t}","TimeHoursAgoTwo":"Two hours ago, {0:t}","TimeMinutesAgoFive":"Five minutes ago, {0:t}","TimeMinutesAgoFour":"Four minutes ago, {0:t}","TimeMinutesAgoLessOne":"Less than a minute ago","TimeMinutesAgoN":"{0} minutes ago, {1:t}","TimeMinutesAgoOne":"One minute ago, {0:t}","TimeMinutesAgoThree":"Three minutes ago, {0:t}","TimeMinutesAgoTwo":"Two minutes ago, {0:t}","TimeToday":"Today, {0:t}","TimeYesterday":"Yesterday, {0:t}","ToolTipAddRole":"Creating a new role in the workspace.","ToolTipAddUser":"Creating a new user in the selected role.","ToolTipAspNet":"Publish the selected report to the ASP.NET application.","ToolTipAspNetMvc":"Publish the selected report to the ASP.NET MVC application.","ToolTipAttach":"Attach items to the selected report.","ToolTipCreate":"Create a new item.","ToolTipDelete":"Delete the selected items.","ToolTipDeleted":"Show deleted items","ToolTipDownload":"Download the selected item.","ToolTipEdit":"Edit the selected item.","ToolTipGridMode":"List view","ToolTipInfo":"View details","ToolTipJs":"Publish the selected report as the HTML page","ToolTipPublish":"Prepare the selected report to be deployed in your application.","ToolTipRecover":"Recover the selected items.","ToolTipRunWithoutPreview":"Render the selected report without preview","ToolTipShare":"Share the selected file.","ToolTipSort":"Sort options","ToolTipThumbnailMode":"Thumbnail View","ToolTipViewFile":"Show the selected file.","ToolTipViewReport":"Show the selected report in the viewer.","WeDidntFindAnything":"We didn\'t find anything to show here.","WindowDescriptionDelete":"Are you sure you want to delete the selected items?","WindowDescriptionRecover":"Selected items will be recovered from the Recycle Bin.","WindowTitleDelete":"Delete Items","WindowTitleForgotPassword":"Forgot Password","WindowTitleLogin":"Log In","WindowTitleRecover":"Recover Items","WindowTitleRoleEdit":"Edit Role","WindowTitleRoleNew":"New Role","WindowTitleSignUp":"Sign Up","WindowTitleUserEdit":"Edit User","WindowTitleUserNew":"New User","WindowTitleWorkspaceEdit":"Edit Workspace","WindowTitleWorkspaceNew":"New Workspace","WizardBlankReportDescription":"Create a blank report","WizardExcelDescription":"Create a report with Excel data.","WizardJsonDescription":"Create a report with JSON data.","WizardPrivateShare":"No Access","WizardPrivateShareDescription":"External access to the item is restricted.","WizardPublicShare":"Public Access","WizardPublicShareDescription":"External access for any unauthorized user.","WizardRegisteredShare":"Authorized Access","WizardRegisteredShareDescription":"External access only for registered users from any workspace.","WizardTeamShare":"Team Access","WizardTeamShareDescription":"External access for users of one workspace only.","WizardXmlDescription":"Create a report with XML data."},"Components":{"StiBarCode":"Bar Code","StiButton":"Button","StiCards":"Cards","StiChart":"Chart","StiCheckBox":"Check Box","StiChildBand":"Child","StiClone":"Clone","StiColumnFooterBand":"Column Footer","StiColumnHeaderBand":"Column Header","StiComboBox":"Combo Box","StiComponent":"Component","StiContainer":"Container","StiContourText":"Contour Text","StiCrossColumn":"Cross-Column","StiCrossColumnTotal":"Cross-Column Total","StiCrossDataBand":"Cross-Data","StiCrossFooterBand":"Cross-Footer","StiCrossGroupFooterBand":"Cross-Group Footer","StiCrossGroupHeaderBand":"Cross-Group Header","StiCrossHeaderBand":"Cross-Header","StiCrossRow":"Cross-Row","StiCrossRowTotal":"Cross-Row Total","StiCrossSummary":"Cross-Summary","StiCrossSummaryHeader":"Cross-Summary Header","StiCrossTab":"Cross-Tab","StiCrossTitle":"Cross-Title","StiDashboard":"Dashboard","StiDataBand":"Data","StiDatePicker":"Date Picker","StiElectronicSignature":"Electronic Signature","StiEmptyBand":"Empty Data","StiFooterBand":"Footer","StiGauge":"Gauge","StiGroupFooterBand":"Group Footer","StiGroupHeaderBand":"Group Header","StiHeaderBand":"Header","StiHierarchicalBand":"Hierarchical Data","StiHorizontalLinePrimitive":"Horizontal Line","StiImage":"Image","StiIndicator":"Indicator","StiListBox":"List Box","StiMap":"Map","StiMathFormula":"Math Formula","StiMultipleSelection":"Multiple Selection","StiNumberBox":"Number Box","StiOnlineMap":"Online Map","StiOverlayBand":"Overlay","StiPage":"Page","StiPageFooterBand":"Page Footer","StiPageHeaderBand":"Page Header","StiPanel":"Panel","StiPdfDigitalSignature":"PDF Digital Signature","StiPivotColumn":"Pivot Column","StiPivotRow":"Pivot Row","StiPivotSummary":"Pivot Summary","StiPivotTable":"Pivot Table","StiProgress":"Progress","StiRectanglePrimitive":"Rectangle","StiRegionMap":"Region Map","StiReport":"Report","StiReportSummaryBand":"Report Summary","StiReportTitleBand":"Report Title","StiRichText":"Rich Text","StiRoundedRectanglePrimitive":"Rounded Rectangle","StiScreen":"Screen","StiShape":"Shape","StiSignature":"Signature","StiSingleSelection":"Single Selection","StiSparkline":"Sparkline","StiSubReport":"Sub-Report","StiSystemText":"System Text","StiTable":"Table","StiTableOfContents":"Table of Contents","StiText":"Text","StiTextInCells":"Text in Cells","StiTreeView":"Tree View","StiTreeViewBox":"Tree View Box","StiVerticalLinePrimitive":"Vertical Line","StiWinControl":"Win Control","StiZipCode":"ZIP Code"},"CustomMapWindow":{"CheckedAll":"Checked All","HideText":"Hide Text","KeysChangePosition":"Keys (Left, Top, Right, Bottom) change the position of the text","KeysChangeSize":"Shift + keys (Left, Top, Right, Bottom) change the size of the text area","UncheckedAll":"Unchecked All"},"Dashboard":{"AddRange":"Add Range","AfterGroupingData":"Apply after grouping data","AfterSortingData":"Apply after grouping and sorting data","AllowUserColumnSelection":"Allow User Column Selection","AllowUserDrillDown":"Allow User Drill-Down","AllowUserFiltering":"Allow User Filtering","AllowUserSorting":"Allow User Sorting","BeforeTransformation":"Apply before data transformation","Blank":"(Blank)","Blanks":"(Blanks)","BooleanFilters":"Boolean Filters","CannotLoadDashboard":"You cannot load a report with dashboards.","ChangeChartType":"Change Chart Type","ChangeMapType":"Change Map Type","ClearAllFormatting":"Clear All Formatting","ClearFilterFrom":"Clear Filter from \'{0}\'","ColorScale":"Color Scale","ColumnInteractions":"Column Interactions","CustomFilter":"Custom &amp;Filter...","DashboardsNotSupportedIntheWPFDesigner":"Dashboards are not supported in the WPF Designer.","DataBars":"Data Bars","DataFilterGrouping":"This operation is used for grouping different columns only.","DataNotDefined":"Data is not defined","DateFilters":"Date Filters","Dimension":"Dimension","Dimensions":"Dimensions","DragDropBlocks":"Drag &amp; drop blocks from panel","DragDropData":"Drag &amp; drop data","DragDropDataFromDictionary":"Drag &amp; drop data from Dictionary","DrillDown":"Drill-Down","DrillDownFiltered":"Drill-Down Filtered","DrillDownSelected":"Drill-Down Selected","DrillUp":"Drill Up","DuplicateField":"Duplicate Field","EditExpression":"Edit Expression","EditField":"Edit Field","EmptyDashboardFooter":"Drag &amp; drop component from ToolBox or data from Dictionary","EmptyDashboardHeader":"Dashboard is empty","FieldInteractions":"Field Interactions","FieldTypeRestrictionHint":"Only \'{0}\' type field can be used!","FirstLastPoints":"First / Last Points","FirstRowIndex":"First Row Index","FullRowSelect":"Full Row Select","HighLowPoints":"High / Low Points","ImageNotSpecified":"Image not specified","Indicator":"Indicator","InitialValue":"Initial Value","LimitRows":"Skip and Limit Rows","Measure":"Measure","Measures":"Measures","Metrics":"Metrics","NewDimension":"New Dimension","NewField":"New Field","NewMeasure":"New Measure","NoRanges":"No Ranges","NoResult":"No Result","NSelected":"{0} selected","Nulls":"(Nulls)","NumberFilters":"Number Filters","ParentElement":"Parent Element","Priority":"Priority","RangeMode":"Range Mode","RangeType":"Range Type","RemoveActions":"R&amp;emove Actions","RemoveAllFields":"Remove All Fields","RemoveField":"Remove Field","RemoveMobileSurface":"Remove Mobile Surface","ReplaceValues":"Replace Values","ReportSnapshot":"Report Snapshot","RowsCount":"Rows Count","RunFieldsEditor":"Run Fields Editor","RunFieldsEditorInfo":"Run the Fields Editor to change interaction of each table column.","SelectAll":"(Select &amp;All)","ShowAllValue":"Show (All) Value","ShowAsPercentages":"Show as Percentages","ShowBlanks":"Show Blanks","SkipFirstRows":"Skip First Rows","SortAZ":"Sort A to Z","SortLargestToSmallest":"Sort Largest to Smallest","SortNewestToOldest":"Sort Newest to Oldest","SortOldestToNewest":"Sort Oldest to Newest","SortSmallestToLargest":"Sort Smallest to Largest","SortZA":"Sort Z to A","Sparklines":"Sparklines","StringFilters":"String Filters","TransformationHint":"Click on the table header to apply sorting, filtering or change data. This transformation will be applied only to the data of this item.","Trend":"Trend","ViewEditCompilationNotice":"You can\'t edit the report which has the \'Report.CalculationMode\' property equals to \'Compilation\' value. Please set that property to an \'Interpretation\' value.","ViewModeDesktop":"Desktop","ViewModeMobile":"Mobile"},"Database":{"Connection":"Connection","Database":"{0} Connection","DatabaseDB2":"IBM DB2 Connection","DatabaseFirebird":"Firebird Connection","DatabaseInformix":"Informix Connection","DatabaseJson":"JSON Data","DatabaseMySQL":"MySQL Connection","DatabaseOdbc":"ODBC Connection","DatabaseOleDb":"OLE DB Connection","DatabaseOracle":"Oracle Connection","DatabaseOracleODP":"Oracle ODP.NET Connection","DatabasePostgreSQL":"PostgreSQL Connection","DatabaseSql":"SQL Connection","DatabaseSqlCe":"SQLServerCE Connection","DatabaseSQLite":"SQLite Connection","DatabaseTeradata":"Teradata Connection","DatabaseUniDirect":"Uni Direct Connection","DatabaseVistaDB":"VistaDB Connection","DatabaseXml":"XML Data"},"DatePickerRanges":{"CurrentMonth":"Current Month","CurrentQuarter":"Current Quarter","CurrentWeek":"Current Week","CurrentYear":"Current Year","DaysAgo":"{0} Days Ago","FirstQuarter":"First Quarter","FourthQuarter":"Fourth Quarter","Index":"Index","Last14Days":"Last 14 Days","Last30Days":"Last 30 Days","Last7Days":"Last 7 Days","MonthToDate":"Month To Date","NextMonth":"Next Month","NextQuarter":"Next Quarter","NextWeek":"Next Week","NextYear":"Next Year","PreviousMonth":"Previous Month","PreviousQuarter":"Previous Quarter","PreviousWeek":"Previous Week","PreviousYear":"Previous Year","Quarter":"Quarter","QuarterToDate":"Quarter To Date","SecondQuarter":"Second Quarter","ThirdQuarter":"Third Quarter","Today":"Today","Tomorrow":"Tomorrow","WeekToDate":"Week To Date","Year":"Year","YearToDate":"Year To Date","Yesterday":"Yesterday"},"DesignerFx":{"AlreadyExists":"\'{0}\' already exists.","CanNotLoadThisReportTemplate":"Can\'t load this report template.","CloseDataSourceEditor":"Do you want to close data source editor?","CloseEditor":"Do you want to close editor?","CompilingReport":"Compiling Report","Connecting":"Connecting to Server","ConnectionError":"Connection error","ConnectionSuccessfull":"Connection was successful","Continue":"Continue","DecryptionError":"Decryption error: Wrong password or corrupted file.","EmailSuccessfullySent":"The Email has been successfully sent.","ErrorAtSaving":"Error at saving","ErrorCode":"Error at saving. Error code: {0}","ErrorServer":"Error at saving. Server doesn\'t respond.","ExportingReport":"Exporting Report","LoadingCode":"Loading Code","LoadingConfiguration":"Loading Configuration","LoadingData":"Loading Data","LoadingDocument":"Loading Document","LoadingImages":"Loading Images","LoadingLanguage":"Loading Language","LoadingReport":"Loading Report","PreviewAs":"Preview as {0}","RenderingReport":"Rendering Report","ReportSuccessfullySaved":"Report is successfully saved.","RetrieveError":"Retrieve columns error","RetrievingColumns":"Retrieving Columns","Saving":"Saving","SavingConfiguration":"Saving Configuration","SavingReport":"Saving Report","TestConnection":"Test Connection","TextNotFound":"The specified text was not found. Text : {0}"},"Desktop":{"Beginner":"Beginner","ButtonAddCloud":"Add Cloud Folder","ButtonAddFolder":"Add Folder","ButtonCreateDashboard":"Create Dashboard","ButtonCreateReport":"Create Report","ChooseYourSkillLevel":"Choose your skill level","Creator":"Creator","Developer":"Developer","DoYouWantToInstallReports":"Do you want to install templates of reports and dashboards?","InstallSamplesDesc":"Let\'s install our sample projects. They will help you learn the basics of working with our software.","PleaseAnswerWhoAreYou":"Please, answer who you are?","SkillLevel":"Skill Level","WhoAreYou":"Who Are you?","WhoAreYouBeginnerDescription":"Perfect fit if you are doing the first run of the designer.","WhoAreYouCreatorDescription":"Perfect fit for creating reports. The necessary functionality for design is available.","WhoAreYouDeveloperDescription":"Perfect fit for creating applications. Complete functionality for the report design and embedding components included."},"Dialogs":{"StiButtonControl":"Button","StiCheckBoxControl":"Check Box","StiCheckedListBoxControl":"Checked List Box","StiComboBoxControl":"Combo Box","StiDateTimePickerControl":"Date Time Picker","StiForm":"Form","StiGridControl":"Grid","StiGroupBoxControl":"Group Box","StiLabelControl":"Label","StiListBoxControl":"List Box","StiListViewControl":"List View","StiLookUpBoxControl":"LookUp Box","StiNumericUpDownControl":"Numeric Up Down","StiPanelControl":"Panel","StiPictureBoxControl":"Picture Box","StiRadioButtonControl":"Radio Button","StiReportControl":"Report Control","StiRichTextBoxControl":"Rich Text Box","StiTextBoxControl":"Text Box","StiTreeViewControl":"Tree View"},"Editor":{"AllowSQLFormatting":"Allow SQL Formatting","BetweenMetrics":"Between 1 and 10 metrics can be selected.","CantFind":"Cannot find the data you\'re searching for.","CollapseToDefinitions":"C&amp;ollapse to Definitions","Column":"Column: {0}","EntireScope":"&amp;Entire Scope","Find":"&amp;Find","FindNext":"&amp;Find Next","FindWhat":"Find What:","FromCursor":"From Cursor","GotoLine":"Go To &amp;Line","InsertLink":"Insert Link","InsertSymbol":"Insert Symbol","Line":"Line: {0}","LineNumber":"Line Number:","LineNumberIndex":"Line Number ({0} - {1})","MarkAll":"&amp;Mark All","MatchCase":"Match &amp;Case","MatchWholeWord":"Match &amp;Whole Word","MaximumDimensions":"Maximum 7 dimensions can be selected.","Outlining":"Out&amp;lining","PromptOnReplace":"Prompt on Replace","Replace":"&amp;Replace","ReplaceAll":"Replace &amp;All","ReplaceWith":"Replace With:","Search":"Search","SearchHiddenText":"Hidden Text","SearchUp":"Search &amp;Up","SelectionOnly":"Selection &amp;Only","ShowAutoGeneratedCode":"Show Auto Generated Code","ShowLineNumbers":"Show Line Numbers","StopOutlining":"Sto&amp;p Outlining","titleFind":"Find","titleGotoLine":"Go To Line","titleReplace":"Replace","ToggleAllOutlining":"Toggle A&amp;ll Outlining","ToggleOutliningExpansion":"&amp;Toggle Outlining Expansion","TypeToSearch":"Type to search","UseRegularExpressions":"Use &amp;Regular Expressions"},"Errors":{"ComponentIsNotRelease":"Component is not release \\"{0}\\".","ContainerIsNotValidForComponent":"Container {0} is not valid for component {1}.","DataNotFound":"Data not found.","DataNotLoaded":"No data loaded.","Error":"Error!","ErrorsList":"Errors List","FieldRequire":"Field \\"{0}\\" required filling.","FileNotFound":"File \\"{0}\\" not found.","IdentifierIsNotValid":"Identifier \'{0}\' is not valid.","ImpossibleFindDataSource":"Impossible to Find Data Source.","NameExists":"There is already an object named \'{0}\'. Objects must have unique names.","NoServices":"Services are not found in \'{0}\'","NotAssign":"Data Source is not specified.","NotCorrectFormat":"Input string was not in a correct format.","OneTableOfContentsAllowed":"Only one \'Table of Contents\' component can be used in a report at the same time!","PrimaryColumnAction":"Unable to apply this action to the primary column of the \'{0}\'.","RelationsNotFound":"Relations not found.","ReportCannotBeSaveDueToErrors":"Report cannot be saved due to errors!","ServiceNotFound":"\'{0}\' Service not found."},"ExceptionProvider":{"Assemblies":"Assemblies","ClickIgnore":"Click \'Ignore\' to delete all auto-saved files.","Exception":"Exception","ExceptionReport":"Exception Report","Framework":"Framework","General":"General","Message":"Message","Number":"Number","PleaseEnterDetailedInformation":"Please enter detailed information about events which cause this exception.","SaveToFile":"Save to File","SendErrorFailed":"Failed to deliver the error message.","SendErrorSuccess":"The error message delivered successfully.","Source":"Source","StackTrace":"Stack Trace","YouCanRestore":"You can restore unsaved changes from a backup file.","YourPreviousWorkSession":"In your previous work session, the designer terminated unexpectedly."},"Export":{"AddPageBreaks":"Add Page Breaks","AllBands":"All bands","AllowAddOrModifyTextAnnotations":"Allow Add or Modify Text Annotations","AllowCopyTextAndGraphics":"Allow Copy Text and Graphics","AllowEditable":"Allow Editable:","AllowModifyContents":"Allow Modify Contents","AllowPrintDocument":"Allow Print Document","Auto":"Auto","BandsFilter":"Bands Filter:","CancelExport":"Cancel Export","Color":"Color","Compressed":"Compressed","CompressToArchive":"Compress to Archive","ContinuousPages":"Continuous Pages","DataAndHeaders":"Data and Headers","DataAndHeadersFooters":"Data and Headers/Footers","DataOnly":"Data only","DigitalSignature":"Digital Signature","DigitalSignatureCertificateNotSelected":"Certificate is not selected","DigitalSignatureError":"Digital Signature error at step","DocumentSecurity":"Document Security","DotMatrixMode":"Dot-Matrix Mode","EmbeddedFonts":"Embedded Fonts","EmbeddedImageData":"Embedded Image Data","EnableAnimation":"Enable Animation","Encoding":"Encoding:","EncryptionError":"Encryption error at step","EscapeCodes":"Escape Codes","Exactly":"Exactly","ExceptEditableFields":"Except Editable Fields","ExportDataOnly":"Export Data Only","ExportEachPageToSheet":"Export Each Page to Sheet","Exporting":"Exporting","ExportingCalculatingCoordinates":"Calculating Coordinates","ExportingCreatingDocument":"Creating Document","ExportingFormatingObjects":"Formatting Objects","ExportingReport":"Exporting Report","ExportMode":"Export Mode:","ExportModeFrame":"Frame","ExportModeTable":"Table","ExportObjectFormatting":"Export Object Formatting","ExportPageBreaks":"Export Page Breaks","ExportRtfTextAsImage":"Export Rich Text as Image","ExportTypeBmpFile":"BMP Image...","ExportTypeCalcFile":"OpenDocument Calc File...","ExportTypeCsvFile":"CSV File...","ExportTypeDataFile":"Data File...","ExportTypeDbfFile":"dBase DBF File...","ExportTypeDifFile":"Data Interchange Format (DIF) File...","ExportTypeExcel2007File":"Microsoft Excel 2007 File...","ExportTypeExcelFile":"Microsoft Excel File...","ExportTypeExcelXmlFile":"Microsoft Excel XML File...","ExportTypeGifFile":"GIF Image...","ExportTypeHtml5File":"HTML5 File...","ExportTypeHtmlFile":"HTML File...","ExportTypeImageFile":"Image File...","ExportTypeJpegFile":"JPEG Image...","ExportTypeJsonFile":"JSON File...","ExportTypeMetafile":"Windows Metafile...","ExportTypeMhtFile":"MHT Web Archive...","ExportTypePcxFile":"PCX Image...","ExportTypePdfFile":"Adobe PDF File...","ExportTypePngFile":"PNG Image...","ExportTypePpt2007File":"Microsoft PowerPoint File...","ExportTypeRtfFile":"Rich Text File...","ExportTypeSvgFile":"Scalable Vector Graphics (SVG) File...","ExportTypeSvgzFile":"Compressed SVG (SVGZ) File...","ExportTypeSylkFile":"Symbolic Link (SYLK) File...","ExportTypeTiffFile":"TIFF Image...","ExportTypeTxtFile":"Text File...","ExportTypeWord2007File":"Microsoft Word File...","ExportTypeWriterFile":"OpenDocument Writer File...","ExportTypeXmlFile":"XML File...","ExportTypeXpsFile":"Microsoft XPS File...","GetCertificateFromCryptoUI":"Get Certificate from Crypto UI","ImageCompressionMethod":"Image Compression Method:","ImageCutEdges":"Cut Edges","ImageFormat":"Image Format:","ImageGrayscale":"Grayscale","ImageMonochrome":"Monochrome","ImageQuality":"Image Quality:","ImageResolution":"Image Resolution:","ImageResolutionMode":"Image Resolution Mode:","ImageType":"Image Type","labelEncryptionKeyLength":"Encryption Key Length:","labelOwnerPassword":"Owner Password:","labelSubjectNameString":"Subject Name String:","labelUserPassword":"User Password:","MonochromeDitheringType":"Monochrome Dithering Type:","MoreSettings":"More Settings","MultipleFiles":"Multiple Files","NoMoreThan":"No More Than","OpenAfterExport":"Open After Export","PdfACompliance":"PDF/A Compliance","PrintingReport":"Printing Report","RemoveEmptySpaceAtBottom":"Remove Empty Space at Bottom of Page","RestrictEditing":"Restrict Editing:","Scale":"Scale:","Separator":"Separator:","Settings":"Settings","SkipColumnHeaders":"Skip Column Headers","StandardPDFFonts":"Standard PDF Fonts","TiffCompressionScheme":"TIFF Compression Scheme:","title":"Export Settings","TxtBorderType":"Border Type","TxtBorderTypeDouble":"Unicode-Double","TxtBorderTypeSimple":"Simple","TxtBorderTypeSingle":"Unicode-Single","TxtCutLongLines":"Cut Long Lines","TxtDrawBorder":"Draw Border","TxtKillSpaceGraphLines":"Kill Space Graph Lines","TxtKillSpaceLines":"Kill Space Lines","TxtPutFeedPageCode":"Put Feed Page Code","Type":"Type:","UseDefaultSystemEncoding":"Use Default System Encoding","UseDigitalSignature":"Use Digital Signature","UseEscapeCodes":"Use Escape Codes","UseOnePageHeaderAndFooter":"Use One Page Header and Footer","UsePageHeadersAndFooters":"Use Page Headers and Footers","UseUnicode":"Use Unicode","X":"X:","Y":"Y:","Zoom":"Zoom:"},"FileFilters":{"AllFiles":"All Files","AllImageFiles":"All Image Files","BitmapFiles":"Bitmap Files","BmpFiles":"BMP Images (*.bmp)|*.bmp","CalcFiles":"OpenDocument Calc Files (*.ods)|*.ods","CsvFiles":"CSV Files (*.csv)|*.csv","DashboardTemplates":"Dashboard Templates (*.sbi)|*.sbi","DataSetXmlData":"DataSet XML Data (*.xml)|*.xml","DataSetXmlSchema":"DataSet XML Schema (*.xsd)|*.xsd","DbfFiles":"DBF Files (*.dbf)|*.dbf","DictionaryFiles":"Report Dictionaries (*.dct)|*.dct","DifFiles":"DIF Files (*.dif)|*.dif","DllFiles":"DLL Files (*.dll)|*.dll","DocumentFiles":"Report Documents (*.mdc)|*.mdc","EmfFiles":"Metafiles (*.emf)|*.emf","EncryptedDocumentFiles":"Encrypted Report Documents (*.mdx)|*.mdx","EncryptedReportFiles":"Encrypted Report Templates (*.mrx)|*.mrx","Excel2007Files":"Microsoft Excel files (*.xlsx)|*.xlsx","ExcelAllFiles":"Microsoft Excel files (*.xlsx;*.xls)|*.xlsx;*.xls","ExcelFiles":"Microsoft Excel 97-2003 files (*.xls)|*.xls","ExcelXmlFiles":"Microsoft Excel XML files (*.xml)|*.xml","ExeFiles":"EXE Files (*.exe)|*.exe","GifFiles":"GIF Image (*.gif)|*.gif","HtmlFiles":"HTML Files (*.html)|*.html","InheritedLanguageFiles":"{0} Classes for Inherited Reports (*.{1})|*.{2}","JpegFiles":"JPEG image (*.jpg;*.jpeg)|*.jpg;*.jpeg","JsonDocumentFiles":"JSON Report Documents (*.mdc)|*.mdc","JsonFiles":"JSON Files (*.json)|*.json","JsonReportFiles":"JSON Report Templates (*.mrt)|*.mrt","LanguageFiles":"{0} Classes (*.{1})|*.{2}","LanguageForSilverlightFiles":"{0} Classes for Silverlight Reports (*.{1})|*.{2}","MetaFiles":"Metafiles","MhtFiles":"MHT Web Archives (*.mht)|*.mht","PackedDocumentFiles":"Packed Report Documents (*.mdz)|*.mdz","PackedReportFiles":"Packed Report Templates (*.mrz)|*.mrz","PageFiles":"Report Pages (*.pg)|*.pg","PcxFiles":"PCX Images (*.pcx)|*.pcx","PdfFiles":"Adobe PDF Files (*.pdf)|*.pdf","PngFiles":"PNG Images (*.png)|*.png","Ppt2007Files":"Microsoft PowerPoint 2007/2013 Files (*.pptx)|*.pptx","ReportEmbededDataFiles":"Report Templates with Embedded Data (*.mrt)|*.mrt","ReportFiles":"Report Templates (*.mrt)|*.mrt","RtfFiles":"Rich Text (*.rtf)|*.rtf","StandaloneReportFiles":"Standalone Reports (*.exe)|*.exe","StylesFiles":"Report Styles (*.sts)|*.sts","SvgFiles":"SVG Images (*.svg)|*.svg","SvgzFiles":"Compressed SVG Images (*.svgz)|*.svgz","SylkFiles":"SYLK Files (*.slk)|*.slk","TiffFiles":"TIFF Images (*.tiff)|*.tiff","TxtFiles":"Plain Text Files (*.txt)|*.txt","Word2007Files":"Microsoft Word 2007-2016 Files (*.docx)|*.docx","WordFiles":"Microsoft Word 97-2003 Files (*.doc)|*.doc","WriterFiles":"OpenDocument Writer Files (*.odt)|*.odt","XmlFiles":"XML Files (*.xml)|*.xml","XpsFiles":"Microsoft XPS Files (*.xps)|*.xps","ZipArchives":"ZIP Archives (*.zip)|*.zip"},"Formats":{"custom01":"d","custom02":"D","custom03":"f","custom04":"F","custom05":"yy/MM/dd","custom06":"yyyy/MM/dd","custom07":"G","custom08":"$0.00","custom09":"$0","custom10":"c","custom11":"c1","custom12":"c2","custom13":"#.00","custom14":"#.#","custom15":"n","custom16":"n1","custom17":"n2","custom18":"(###) ### - ####","date01":"*d","date02":"*D","date03":"M.dd","date04":"yy.M.dd","date05":"yy.MM.dd","date06":"MMM.dd","date07":"yy.MMM.dd","date08":"yyyy, MMMM","date09":"*f","date10":"*F","date11":"MM.dd.yyyy","date12":"dd/MM/yyyy","date13":"*g","date14":"*G","date15":"*y","date16":"*m","date17":"s","date18":"u","date19":"*Q","date20":"*YQ","date21":"QI","date22":"YQI","time01":"*t","time02":"*T","time03":"HH:mm","time04":"H:mm","time06":"HH:mm:ss"},"FormBand":{"AddFilter":"&amp;Add Filter","AddGroup":"&amp;Add Group","AddResult":"&amp;Add Result","AddSort":"&amp;Add Sort","And":"and","Ascending":"Ascending","Descending":"Descending","NoFilters":"No Filters","NoSort":"No Sorting","RemoveFilter":"&amp;Remove Filter","RemoveGroup":"&amp;Remove Group","RemoveResult":"&amp;Remove Result","RemoveSort":"&amp;Remove Sort","SortBy":"Sort by","ThenBy":"Then by","title":"Data Setup"},"FormColorBoxPopup":{"Color":"Color","Custom":"Custom","NoColor":"No Color","Others":"Others...","System":"System","Web":"Web"},"FormConditions":{"AaBbCcYyZz":"AaBbCcYyZz","AddCondition":"&amp;Add Condition","AddLevel":"Add Level","AssignExpression":"Assign Expression","BreakIfTrue":"Break if True","BreakIfTrueToolTip":"Breaks condition processing if current one is fulfilled","ChangeBorder":"Change Border...","ChangeFont":"Change Font...","ComponentIsEnabled":"Component is Enabled","NoConditions":"No Conditions","RemoveCondition":"&amp;Remove Condition","SelectStyle":"Select Style","title":"Conditions"},"FormCrossTabDesigner":{"Columns":"Columns:","DataSource":"Data Source:","Properties":"Properties:","Rows":"Rows:","Summary":"Summary:","Swap":"Swap Rows / Columns","title":"Cross-Tab Designer"},"FormDatabaseEdit":{"AccessToken":"Access token","AccountKey":"Account Key","AccountName":"Account Name","AuthorizationCode":"Authorization Code","BlobContentType":"Blob Content Type","BlobName":"Blob Name","ClientId":"Client Id","ClientSecret":"Client Secret","ConnectionString":"Connection String:","ContainerName":"Container Name","DashboardConnections":"Dashboard Connections","DatabaseSecret":"Database Secret","DatasetId":"Dataset Id","DB2Edit":"Edit IBM DB2 Connection","DB2New":"New IBM DB2 Connection","EditConnection":"Edit {0} Connection","Favorites":"Favorites","FirebirdEdit":"Edit Firebird Connection","FirebirdNew":"New Firebird Connection","FirstRowIsHeader":"First Row is Header","GetAuthorizationCode":"Get authorization code","GetTokens":"Get tokens","GisEdit":"Edit GIS Data","GisNew":"New GIS Data","ImportData":"Import Data","InformixEdit":"Edit Informix Connection","InformixNew":"New Informix Connection","InitialCatalog":"Initial Catalog:","JsonEdit":"Edit JSON Data","JsonNew":"New JSON Data","MySQLEdit":"Edit MySQL Connection","MySQLNew":"New MySQL Connection","NewConnection":"New {0} Connection","OdbcEdit":"Edit ODBC Connection","OdbcNew":"New ODBC Connection","OleDbEdit":"Edit OLE DB Connection","OleDbNew":"New OLE DB Connection","OracleEdit":"Edit Oracle Connection","OracleNew":"New Oracle Connection","OracleODPEdit":"Edit Oracle ODP.NET Connection","OracleODPNew":"New Oracle ODP.NET Connection","PathData":"Path to XML Data:","PathGisData":"Path to Gis Data:","PathJsonData":"Path to JSON Data:","PathSchema":"Path to XSD Schema:","PathToData":"Path to Data:","Pin":"Pin","PostgreSQLEdit":"Edit PostgreSQL Connection","PostgreSQLNew":"New PostgreSQL Connection","ProjectId":"Project Id","PromptUserNameAndPassword":"Prompt User Name and Password","RecentConnections":"Recent","RedirectUrl":"Redirect URL","RefreshAccessToken":"Refresh access token","RefreshToken":"Refresh token","RelationDirection":"Relation Direction:","ReportConnections":"Report Connections","SelectData":"Select Data","ServiceAccountKeyFile":"Service Account Key File","SpreadsheetId":"Spreadsheet Id","SqlCeEdit":"Edit SQLServerCE Connection","SqlCeNew":"New SQLServerCE Connection","SqlEdit":"Edit SQL Connection","SQLiteEdit":"Edit SQLite Connection","SQLiteNew":"New SQLite Connection","SqlNew":"New SQL Connection","TeradataEdit":"Edit Teradata Connection","TeradataNew":"New Teradata Connection","Token":"Token","UniDirectEdit":"Edit Uni Direct Connection","UniDirectNew":"New Uni Direct Connection","Unpin":"Unpin","UseBearerAuthentication":"Use Bearer Authentication","UseOwnClientID":"Use own \\"Client ID\\" and \\"Client Secret\\"","UseToken":"Use Token","VistaDBEdit":"Edit VistaDB Connection","VistaDBNew":"New VistaDB Connection","XmlEdit":"Edit XML Data","XmlNew":"New XML Data","XmlType":"XML Type:"},"FormDesigner":{"Code":"Code","ColumnsOne":"One","ColumnsThree":"Three","ColumnsTwo":"Two","CompilingReport":"Compiling Report","CopyPropertyName":"Copy Property Name","DockingPanels":"Panels","HtmlPreview":"HTML Preview","JsPreview":"JS Preview","labelPleaseSelectTypeOfInterface":"Please, select type of interface","LoadImage":"Load Image...","LocalizePropertyGrid":"Localize Property Grid","MarginsNarrow":"Narrow","MarginsNormal":"Normal","MarginsWide":"Wide","OrderToolbars":"Order Toolbars","Others":"Others","Pages":"Pages","Preview":"Preview","PropertyChange":"Change of property \'{0}\'","RTPreview":"WinRT Preview","SetupToolbox":"Setup Toolbox","ShowDescription":"Show Description","SLPreview":"Silverlight Preview","title":"Designer","WebPreview":"Flash Preview"},"FormDictionaryDesigner":{"Actions":"Actions","AutoSort":"Auto Sort","BusinessObjectEdit":"Edit Business Object","CalcColumnEdit":"Edit Calculated Column","CalcColumnNew":"New Calculated Column","CategoryEdit":"Edit Category","CategoryNew":"New Category","Child":"Child","ChildOfBusinessObject":"Child of Business Object","ChildSource":"Child Data Source:","ClickHere":"Click here","ColumnEdit":"Edit Column","ColumnNew":"New Column","CreateNewDataSource":"to create the new data source","CreateNewReport":"to create the new report","CsvSeparatorComma":"Comma","CsvSeparatorOther":"Other","CsvSeparatorSemicolon":"Semicolon","CsvSeparatorSpace":"Space","CsvSeparatorSystem":"System","CsvSeparatorTab":"Tab","DatabaseEdit":"Edit Database","DatabaseNew":"New Database","DataMonitor":"Data Monitor","DataParameterEdit":"Edit Parameter","DataParameterNew":"New Parameter","DataSetToBusinessObjects":"DataSet To Business Objects","DataSourceEdit":"Edit Data Source","DataSourceNew":"New Data Source","DataSourcesNew":"New Data Sources","DataTransformationEdit":"Edit Data Transformation","DataTransformationNew":"New Data Transformation","Delete":"Delete","DesignTimeQueryText":"Design-Time Query Text","DictionaryMerge":"Merge Dictionary...","DictionaryNew":"New Dictionary...","DictionaryOpen":"Open Dictionary...","DictionarySaveAs":"Save Dictionary As...","DragNewDataSource":"drag your data directly to this panel","DragNewReport":"drag your report directly to this panel","EditQuery":"Edit Query","EnableDataMonitor":"Enable Data Monitor","ExecutedSQLStatementSuccessfully":"SQL statement executed successfully","ExpressionNew":"New Expression","GetColumnsFromAssembly":"Get Columns from Assembly","HideUnsupportedDatabases":"Hide Unsupported Data Sources","ImportRelations":"Import Relations","LabelSeparator":"Separator:","MarkUsedItems":"Mark Used Items","NewBusinessObject":"New Business Object","NewItem":"New Item","OpenAssembly":"Open Assembly","Parent":"Parent","ParentSource":"Parent Source:","Queries":"Queries","QueryNew":"New Query","QueryText":"Query Text","QueryTimeout":"Query Timeout","RelationEdit":"Edit Relation","RelationNew":"New Relation","ResourceEdit":"Edit Resource","ResourceNew":"New Resource","RetrieveColumns":"Retrieve Columns","RetrieveColumnsAllowRun":"Allow Run StoredProc","RetrieveColumnsAndParameters":"Retrieve Columns and Parameters","RetrieveParameters":"Retrieve Parameters","RetrievingDatabaseInformation":"Retrieving database information...","Run":"Run","SelectTypeOfBusinessObject":"Select Type of Business Object","SkipSchemaWizard":"Skip Schema Wizard","SortItems":"Sort Items","Synchronize":"Synchronize","SynchronizeHint":"Synchronizes contents of the Data Store and contents of the Dictionary","TextDropDataFileHere":"Drop Data File Here","TextDropFileHere":"Drop File Here","TextDropImageHere":"Drop Image File Here","title":"Dictionary Designer","ValueNew":"New Value","VariableEdit":"Edit Variable","VariableNew":"New Variable","ViewData":"View Data","ViewQuery":"View Query"},"FormFormatEditor":{"Boolean":"Boolean","BooleanDisplay":"Display:","BooleanValue":"Value:","Currency":"Currency","CurrencySymbol":"Currency Symbol:","Custom":"Custom","Date":"Date","DateTimeFormat":"Date Time Format","DecimalDigits":"Decimal Digits:","DecimalSeparator":"Decimal Separator:","FormatMask":"Format Mask:","Formats":"Formats","General":"General","GroupSeparator":"Group Separator:","GroupSize":"Group Size:","nameFalse":"False","nameNo":"No","nameOff":"Off","nameOn":"On","nameTrue":"True","nameYes":"Yes","NegativeInRed":"Negative in Red","NegativePattern":"Negative Pattern:","Number":"Number","Percentage":"Percentage","PercentageSymbol":"Percentage Symbol:","PositivePattern":"Positive Pattern:","Properties":"Properties","Sample":"Sample","SampleText":"Sample Text","TextFormat":"Text Format","Time":"Time","title":"Format","UseAbbreviation":"Use Abbreviation","UseGroupSeparator":"Use Group Separator","UseLocalSetting":"Use Local Setting"},"FormGlobalizationEditor":{"AddCulture":"&amp;Add Culture","AutoLocalizeReportOnRun":"Auto Localize Report on Run","CreateNewCulture":"to create the new culture","GetCulture":"Get Culture Settings from Report","qnGetCulture":"Do you really want to get culture settings from report and override current culture settings?","qnSetCulture":"Do you really want to set culture settings to report components?","RemoveCulture":"&amp;Remove Culture","SetCulture":"Set Culture Settings to Report","title":"Globalization Editor"},"FormInteraction":{"HyperlinkExternalDocuments":"Hyperlink to External Document","HyperlinkUsingInteractionBookmark":"Hyperlink using Bookmark","HyperlinkUsingInteractionTag":"Hyperlink using Tag"},"FormOptions":{"AutoSave":"Auto Save","AutoSaveReportToReportClass":"Auto Save Report to C# or VB.NET File","BlankDashboard":"Blank Dashboard","BlankForm":"Blank Form","BlankReport":"Blank Report","BlankScreen":"Blank Screen","Default":"Default","DefaultScriptMode":"Default Script Mode","Drawing":"Drawing","DrawMarkersWhenMoving":"Draw Markers When Moving","EditAfterInsert":"Edit After Insert","EnableAutoSaveMode":"Enable Auto Save Mode","FillBands":"Fill Bands","FillComponents":"Fill Components","FillContainers":"Fill Containers","FillCrossBands":"Fill Cross Bands","GenerateLocalizedName":"Generate Localized Name","Grid":"Grid","GridDots":"Dots","GridLines":"Lines","GridMode":"Grid Mode","GridSize":"Grid Size","groupAutoSaveOptions":"Auto save options","groupColorScheme":"Please select color scheme of GUI","groupGridDrawingOptions":"Grid drawing options","groupGridOptions":"Grid options","groupGridSize":"Grid size","groupMainOptions":"Main options for working with designer","groupMarkersStyle":"Marker style","groupOptionsOfQuickInfo":"Options of Quick Info","groupPleaseSelectTypeOfGui":"Please, select the type of GUI","groupReportDisplayOptions":"Report display options","labelColorScheme":"Color Scheme:","labelInfoAutoSave":"Change parameters of reports autosaving","labelInfoDrawing":"Setting parameters of report drawing","labelInfoGrid":"How Grid is shown and used in a report","labelInfoGui":"Select the mode of using GUI in the report designer","labelInfoMain":"Setting basic parameters of the report designer","labelInfoQuickInfo":"Components Quick Info on a page","Main":"Main","MarkersStyle":"Markers Style","MarkersStyleCorners":"Corners","MarkersStyleDashedRectangle":"Dashed Rectangle","MarkersStyleNone":"None","MessageLeftRightNotValid":"Left and Right value is not a valid.","MessageTopBottomNotValid":"Top and Bottom value is not a valid.","Minutes":"{0} minutes","SaveReportEvery":"Save Report Every:","ScaleMode":"Scale Mode","SelectUILanguage":"Select UI Language","ShowDialogForms":"Show Dialog Forms","ShowDimensionLines":"Show Dimension Lines","ShowOldGaugeEditor":"Show Old Gauge Editor","StartScreen":"Start Screen","title":"Options","UseComponentColor":"Use Component Color for Filling","UseLastFormat":"Use Last Format","Welcome":"Welcome"},"FormPageSetup":{"ApplyTo":"Apply to","Bottom":"Bottom:","Columns":"Columns","groupColumns":"Page columns","groupImage":"Watermark image","groupMargins":"Page margins","groupOrientation":"Paper orientation","groupPaper":"Paper size","groupPaperSource":"Paper source","groupText":"Watermark text","Height":"Height:","labelAngle":"Angle:","labelColumnGaps":"Column Gaps:","labelColumnWidth":"Column Width:","labelImageAlignment":"Image Alignment:","labelImageTransparency":"Image Transparency:","labelInfoColumns":"Setting page columns","labelInfoPaper":"Setting size and orientation for the current page","labelInfoUnit":"Page margins are specified in the current units","labelInfoWatermark":"Setting parameters for showing watermark","labelMultipleFactor":"Multiple Factor:","labelPaperSourceOfFirstPage":"Paper Source of First Page:","labelPaperSourceOfOtherPages":"Paper Source of Other Pages:","labelSelectBrush":"Select Brush:","labelSelectColor":"Select Color:","labelSelectFont":"Select Font:","labelSelectImage":"Select Image:","labelText":"Text:","Left":"Left:","Margins":"Margins","NumberOfColumns":"Number of Columns:","Orientation":"Orientation","PageOrientationLandscape":"Landscape","PageOrientationPortrait":"Portrait","Paper":"Paper:","RebuildReport":"Rebuild Report","Right":"Right:","ScaleContent":"Scale Content","Size":"Size:","title":"Page Setup","Top":"Top:","Width":"Width:"},"FormReportSetup":{"groupDates":"A date of report creation and a date of the last report change","groupDescription":"Report description","groupMainParameters":"Parameters which effect on report rendering","groupNames":"Report name, report alias, and report author","groupScript":"Script language of your report","groupUnits":"Size and coordinates in a report will be in specified units","labelInfoDescription":"Indicate the information of a report","labelInfoMain":"Change of basic report parameters","labelNumberOfPass":"Number of Pass:","labelReportCacheMode":"Report Cache Mode:","ReportChanged":"Report Changed:","ReportCreated":"Report Created:","title":"Report Options"},"FormRichTextEditor":{"Bullets":"Bullets","FontName":"Font Name","FontSize":"Font Size","Insert":"Insert Expression","title":"Rich Text Editor"},"FormStyleDesigner":{"Add":"Add Style","AddCollectionName":"Add Collection Name","ApplyStyleCollectionToReportComponents":"Apply Style Collection to Report Components","ApplyStyles":"Apply Styles","ColorCollectionEditor":"Color Collection Editor","CreateNewComponentStyle":"to create the new component style","CreateStyleCollection":"Create Style Collection","CreateStyleOnBase":"Create a style based on another style","Duplicate":"Duplicate Style","EditColors":"Edit Colors","FromStyle":"From Style","GetStyle":"Get Style from Selected Components","MoreStyles":"More Styles","NotSpecified":"Not Specified","Open":"Open Style","Predefined":"Predefined","qnApplyStyleCollection":"Do you want to apply style collection to report components?","Remove":"Remove Style","RemoveExistingStyles":"Remove Existing Styles","Save":"Save Style","Style":"Style","StyleCollectionsNotFound":"Style Collections Not Found!","title":"Style Designer"},"FormSystemTextEditor":{"Condition":"Condition","LabelDataBand":"Data Band:","LabelDataColumn":"Data Column:","LabelShowInsteadNullValues":"Show Instead Null Values:","LabelSummaryFunction":"Summary Function:","pageExpression":"Expression","pageSummary":"Summary","pageSystemVariable":"System Variable","RunningTotal":"Running Total","SummaryRunning":"Summary Running","SummaryRunningByColumn":"Column","SummaryRunningByPage":"Page","SummaryRunningByReport":"Report"},"FormTitles":{"ChartWizardForm":"Chart Wizard","ConditionEditorForm":"Condition","ConnectionSelectForm":"Select Type of Connection","ContainerSelectForm":"Select Container","DataAdapterServiceSelectForm":"Select Type of Data","DataRelationSelectForm":"Select Data Relation","DataSetName":"Enter DataSet Name","DataSourceSelectForm":"Select Data Source","DataSourcesNewForm":"New Data Sources","DataStoreViewerForm":"Data Store Viewer","DesignerApplication":"Report Designer","EventEditorForm":"Event Editor","ExpressionEditorForm":"Expression Editor","GroupConditionForm":"Group","InteractionDrillDownPageSelectForm":"Select Drill-Down Page","MasterComponentSelectForm":"Select Master Component","PageAddForm":"Add Page","PageSizeForm":"Page Size","PagesManagerForm":"Pages Manager","PromptForm":"Enter information to logon on to the database","ReportWizard":"Report Wizard","ServiceSelectForm":"Select Service","SqlExpressionsForm":"SQL Expressions","SubReportPageSelectForm":"Select Sub-Report Page","TextEditorForm":"Text Editor","ViewDataForm":"View Data","ViewerApplication":"Report Viewer"},"FormViewer":{"Bookmarks":"Bookmarks","Close":"Close","CollapseAll":"Collapse All","CompressedDocumentFile":"Compressed Document File","ContextMenu":"Context Menu","DocumentFile":"Document File...","Editor":"Editor","EncryptedDocumentFile":"Encrypted Document File","ExpandAll":"Expand All","Export":"Export...","Find":"Find","FirstPage":"First Page","FullScreen":"Full Screen","GoToPage":"Go To Page","HorScrollBar":"Horizontal Scroll Bar","LabelPageN":"Page:","LastPage":"Last Page","NextPage":"Next Page","Open":"Open...","PageControl":"Page Control","PageDelete":"Delete Page","PageDesign":"Edit Page...","PageNew":"New Page","PageNofM":"Page {0} of {1}","PageofM":"of {0}","PageSize":"Page Size...","PageViewModeContinuous":"Continuous","PageViewModeMultiplePages":"Multiple Pages","PageViewModeSinglePage":"Single Page","Parameters":"Parameters","PrevPage":"Previous Page","Print":"Print...","qnPageDelete":"Do you want to delete page?","Save":"Save...","SendEMail":"Send Email...","StatusBar":"Status Bar","Thumbnails":"Thumbnails","title":"Viewer","titlePageSettings":"Page Settings","Toolbar":"Tool bar","VerScrollBar":"Vertical Scroll Bar","ViewMode":"View Mode","Zoom":"Zoom","ZoomMultiplePages":"Multiple Pages","ZoomOnePage":"One Page","ZoomPageWidth":"Page Width","ZoomTwoPages":"Two Pages","ZoomXXPages":"{0} X {1} Pages","ZoomXXPagesCancel":"Cancel"},"FormViewerFind":{"Close":"Close","FindNext":"Find Next","FindPrevious":"Find Previous","FindWhat":"Find What:"},"Gauge":{"AddNewItem":"Add New Item","BarRangeList":"Bar Range List","GaugeEditorForm":"Gauge Editor","Kind":"Kind","LinearBar":"Linear Bar","LinearMarker":"Linear Marker","LinearRange":"Linear Range","LinearRangeList":"Linear Range List","LinearScale":"Linear Scale","LinearTickLabelCustom":"Linear Tick Label Custom","LinearTickLabelMajor":"Linear Tick Label Major","LinearTickLabelMinor":"Linear Tick Label Minor","LinearTickMarkCustom":"Linear Tick Mark Custom","LinearTickMarkMajor":"Linear Tick Mark Major","LinearTickMarkMinor":"Linear Tick Mark Minor","Needle":"Needle","RadialBar":"Radial Bar","RadialMarker":"Radial Marker","RadialRange":"Radial Range","RadialRangeList":"Radial Range List","RadialScale":"Radial Scale","RadialTickLabelCustom":"Radial Tick Label Custom","RadialTickLabelMajor":"Radial Tick Label Major","RadialTickLabelMinor":"Radial Tick Label Minor","RadialTickMarkCustom":"Radial Tick Mark Custom","RadialTickMarkMajor":"Radial Tick Mark Major","RadialTickMarkMinor":"Radial Tick Mark Minor","StateIndicator":"State Indicator","StateIndicatorFilter":"State Indicator Filter","TickCustomValue":"Tick Custom Value"},"Gui":{"barname_cancel":"Cancel","barname_caption":"New Toolbar","barname_msginvalidname":"Toolbar name cannot be empty.","barname_name":"&amp;Toolbar Name:","barname_ok":"OK","barrename_caption":"Rename Toolbar","barsys_autohide_tooltip":"Auto-Hide","barsys_close_tooltip":"Close","barsys_customize_tooltip":"Customize","ClickAndDragPickColor":"Click and Drag to pick color","colorpicker_morecolors":"&amp;More Colors...","colorpicker_nofill":"&amp;No Fill","colorpicker_standardcolorslabel":"Standard Colors","colorpicker_themecolorslabel":"Theme Colors","colorpickerdialog_alphalabel":"&amp;Alpha:","colorpickerdialog_bluelabel":"&amp;Blue:","colorpickerdialog_cancelbutton":"Cancel","colorpickerdialog_caption":"Colors","colorpickerdialog_colormodellabel":"Color Model:","colorpickerdialog_currentcolorlabel":"Current","colorpickerdialog_customcolorslabel":"Colors:","colorpickerdialog_greenlabel":"&amp;Green:","colorpickerdialog_newcolorlabel":"New","colorpickerdialog_okbutton":"OK","colorpickerdialog_redlabel":"&amp;Red:","colorpickerdialog_rgblabel":"RGB","colorpickerdialog_standardcolorslabel":"Colors:","colorpickerdialog_tabcustom":"Custom","colorpickerdialog_tabstandard":"Standard","cust_btn_close":"Close","cust_btn_delete":"Delete","cust_btn_keyboard":"&amp;Keyboard...","cust_btn_new":"&amp;New...","cust_btn_rename":"&amp;Rename...","cust_btn_reset":"&amp;Reset...","cust_btn_resetusage":"&amp;Reset my usage data","cust_caption":"Customize","cust_cbo_fade":"Fade","cust_cbo_none":"(None)","cust_cbo_random":"Random","cust_cbo_slide":"Slide","cust_cbo_system":"System Default","cust_cbo_unfold":"Unfold","cust_chk_delay":"Show full menus after a short delay","cust_chk_fullmenus":"Always show full menus","cust_chk_showsk":"Show &amp;Shortcut Keys in ScreenTips","cust_chk_showst":"Show Screen&amp;Tips on Toolbars","cust_lbl_cats":"Cate&amp;gories:","cust_lbl_cmds":"Comman&amp;ds:","cust_lbl_cmdsins":"To add a command to Bar select the category and drag the command out of this box to a Bar.","cust_lbl_menuan":"Menu Animation:","cust_lbl_other":"Other:","cust_lbl_pmt":"Personalized Menus and Toolbars","cust_lbl_tlbs":"Toolb&amp;ars:","cust_mnu_addremove":"&amp;Add or Remove Buttons","cust_mnu_cust":"Customize...","cust_mnu_reset":"Reset Bar","cust_mnu_tooltip":"Bar Options","cust_msg_delete":"Are you sure you want to delete the &lt;barname&gt; toolbar?","cust_pm_begingroup":"Begin Group","cust_pm_delete":"Delete","cust_pm_name":"Name:","cust_pm_reset":"Reset","cust_pm_stydef":"Default Style","cust_pm_styimagetext":"Image and Text (Always)","cust_pm_stytextonly":"Text Only (Always)","cust_tab_commands":"Commands","cust_tab_options":"Options","cust_tab_toolbar_alignment":"Toolbar Alignment","cust_tab_toolbars":"Toolbars","mdisysmenu_close":"Close","mdisysmenu_maximize":"Maximize","mdisysmenu_minimize":"Minimize","mdisysmenu_move":"Move","mdisysmenu_next":"Next","mdisysmenu_restore":"Restore","mdisysmenu_size":"Size","mdisystt_close":"Close","mdisystt_minimize":"Minimize","mdisystt_restore":"Restore","monthcalendar_clearbutton":"Clear","monthcalendar_todaybutton":"Today","navbar_navpaneoptions":"Na&amp;vigation Pane Options...","navbar_showfewerbuttons":"Show &amp;Fewer Buttons","navbar_showmorebuttons":"Show &amp;More Buttons","navPaneCollapseTooltip":"Collapse the Navigation Pane","navPaneExpandTooltip":"Expand the Navigation Pane","sys_custombar":"Custom Bar","sys_morebuttons":"More Buttons"},"HelpComponents":{"StiBarCode":"This component allows showing bar codes in a report. Bar code data are sent to an object as a string. The string may contain any symbols but only allowed symbols for the selected chart can be displayed.","StiButtonElement":"This component is used to execute an event script when a user is interacting.","StiCardsElement":"This component is used to display grouped data as cards.","StiChart":"This component allows showing charts in a report. Different types of charts are available. Among them are bar, line, pie, doughnut, lines, areas, Gantt, scatter charts etc. ","StiChartElement":"This element allows showing charts in a dashboard. Different types of charts are available.","StiCheckBox":"This component allows showing a checkbox in a report. It can display two modes: \\"enable\\" or \\"disable\\".","StiChildBand":"The Child band can be used to output two bands on one data row.","StiClone":"This component is used to clone parts of a report into a required part of a report. Cloning can be applied only to the panel contents.","StiColumnFooterBand":"This band is used to output footers of columns on the Data band. The Column Footer band is output once under each column. All components which are placed on this band will also be output under each column.","StiColumnHeaderBand":"This band is used to output column headers. The Column Header band is used to output only once. All components which are placed on the band can be output above each column.","StiComboBoxElement":"Represents the ComboBox that is used to either type a value directly into the control or choose from the list of existing options.","StiContainer":"This is the rectangular region where other components, including bands, can be placed. When moving the container the components in it will be moved too. The container can be placed both on a band and on a page.","StiCrossDataBand":"This band is connected to the data source. It is output as many times as there are rows in the data source. A Cross band is output from left to right.","StiCrossFooterBand":"This band is used to output footers of the Cross-Data band. The band is output once after all rows of the Data band. A Cross band is output from left to right.","StiCrossGroupFooterBand":"This band is used to output footers of a group. It is placed under the Cross-Data band. Each Cross-Footer belongs to the specified Cross-Header band. A Cross band is output from left to right.","StiCrossGroupHeaderBand":"This band is the basic one for the report rendering with grouping, when Cross-Data are used. It is impossible to create grouping without this band. The components for showing information by the group are placed on the group header. The information can be group name, date, condition of grouping etc. The band is output in the beginning of each group. A Cross band is output from left to right.","StiCrossHeaderBand":"This band is used to output headers. It is used in association with the Cross band. A Cross band is output from left to right.","StiCrossTab":"The cross-tab component is used for the structured data representation as a table.","StiDataBand":"The Data band is connected to the data source and is output as many times as there are rows in the data source.","StiDatePickerElement":"The element is used to select the date and time.","StiEmptyBand":"This band is used to fill free space on the bottom of a page. This band fills free space on each page of a report.","StiFilterCategory":"A group of elements used for selecting and filtering values.","StiFooterBand":"This band is used to output summary by the Data band. It is placed under the Data band and is output once after all data rows which Data band outputs.","StiGauge":"The component allows you to display a value within a predefined range. It can have different graphical representation.","StiGaugeElement":"The element allows you to display a value within a predefined range. It can have different graphical representation.","StiGroupFooterBand":"The Group Footer band is used to output the group footer. This band is placed after the Data band. And this is the Data band with what the Group Header band is bound. Each Group Footer band belongs to the specified Group Header band. The Group Footer band will not be output without the Group Header band.","StiGroupHeaderBand":"This band is the basic band for rendering reports with grouping. The components for showing information by this group are placed on the group header. It can be group name, date, condition of grouping etc. This band is output once in the beginning of each group.","StiHeaderBand":"This band is used to output headers. It is used together with the data band.","StiHierarchicalBand":"This band is connected to the data source and output as many times as there are rows in the data source. Data are output as a tree.","StiHorizontalLinePrimitive":"This component is used to output a line.","StiImage":"This component is used to output images.","StiImageElement":"This element is used to output images. It supports the following graphic formats, such as BMP, JPG, JPEG, GIF, TIFF, PNG, ICO, WMF, EMF.","StiIndicatorElement":"The element displays the difference in values between the input data.","StiListBoxElement":"The element allows selecting items from a list.","StiMap":"This component is used to display data that is geographically targeted.","StiMapCategory":"Group of elements for working with maps and data.","StiMapElement":"This element is used to display data that is geographically targeted.","StiMathFormula":"This component is used to display math formulas in a report.","StiOnlineMapElement":"This element is used to display geographic markers on the online map.","StiOverlayBand":"This band is used to output watermarks on a page.","StiPageFooterBand":"This band is used to output the information on the bottom of each page such as page numbers, dates, and other additional information.","StiPageHeaderBand":"This band is used to output the page header such as page numbers, dates, and other additional information. It is output on the top of each page.","StiPanel":"A rectangular region that can contain other components, including bands. When the panel is moved the components in it are moved too. A panel can be placed either on a band or on a page.","StiPanelElement":"A rectangular region that can contain other elements. When the panel is moved the elements in it are moved too.","StiPivotTableElement":"The pivot table element is used for the structured data representation as a table.","StiProgressElement":"The element displays the ratio of the input data. It can be presented in different modes - a pie, donut, bars.","StiRectanglePrimitive":"This component is used to output rectangles.","StiRegionMapElement":"This element is used to display data that is geographically targeted.","StiReportSummaryBand":"This band is used to output summaries through the entire report. It is output once in the end of a report.","StiReportTitleBand":"This band is used to output the report title. It is output in the beginning of a report.","StiRichText":"This component is used to output and edit the RTF text. It also supports loading and saving files in the RTF format.","StiRoundedRectanglePrimitive":"This component is used to output rounded rectangles.","StiShape":"This component is used to insert ready-made shapes, such as arrows, diagonal line down, diagonal line up, horizontal line, left and right lines, oval, rectangle, rounded rectangle, top and bottom lines, triangle, vertical line.","StiShapeElement":"This element is used to insert ready-made shapes, such as arrows, diagonal line down, diagonal line up, horizontal line, left and right lines, oval, rectangle, rounded rectangle, top and bottom lines, triangle, vertical line.","StiSignature":"This component is used to add an electronic or digital signature to a report.","StiSparkline":"This component is used to create micrographics in a report. It allows you to track dynamically changing data as bars, lines, areas.","StiSubReport":"This component is used to output additional data in different places of a report.","StiTable":"This component is a set of data elements that is organized using a model of vertical columns and horizontal rows.","StiTableElement":"This element is a set of data elements that is organized using a model of vertical columns and horizontal rows.","StiTableOfContents":"This component is used to create a table of contents in a report.","StiText":"This component is a basic object to output data as a text.","StiTextElement":"This element is a basic object to output data as a text.","StiTextInCells":"The component is used to output a text in cells. It is frequently used for creating forms.","StiTreeViewBoxElement":"The element is used to select values with a drop-down list as a tree.","StiTreeViewElement":"Represents the element that is used to show the hierarchical data as a tree.","StiVerticalLinePrimitive":"This component is used to output vertical lines.","StiWinControl":"The component allows showing visual controls from .NET Framework.","StiZipCode":"This component is used to output the ZIP code."},"HelpDesigner":{"ActiveRelation":"Sets the priority Relation to bind two tables. It is used in Data Transformation and Dashboards. Only one Relation in each Data Source can be active.","Align":"Change the location of selected components.","AlignBottom":"Align the contents of a component to bottom.","AlignCenter":"Align the contents of a component to center.","AlignComponentBottom":"Allows you to align objects horizontally along the bottom edge of selected components.","AlignComponentCenter":"Allows you to align objects horizontally along the center edge of selected components.","AlignComponentLeft":"Allows you to align objects vertically along the left edge of selected components.","AlignComponentMiddle":"Allows you to align objects vertically along the center edge of selected components.","AlignComponentRight":"Allows you to align objects vertically along the right edge of selected components.","AlignComponentTop":"Allows you to align objects horizontally along the top edge of selected components.","AlignLeft":"Align the contents of a component to left.","AlignMiddle":"Center the contents by the top and bottom borders of a component.","AlignRight":"Align contents of a component to right.","AlignToGrid":"Align the selected components to grid nodes.","AlignTop":"Align the contents of a component to top.","AlignWidth":"Justify the contents of a component.","Angle":"Rotate the contents of the component.","AngleWatermark":"The watermark text rotation angle.","Background":"Change the background of the selected components.","biConditions":"Control list of conditions of the selected components.","BorderColor":"Select the border color of the selected component.","BorderSidesAll":"Switch on all borders sides of the selected components.","BorderSidesBottom":"Switch on bottom border side of the selected components.","BorderSidesLeft":"Switch on left border side of the selected components.","BorderSidesNone":"Switch off all borders sides of the selected components.","BorderSidesRight":"Switch on right border side of the selected components.","BorderSidesTop":"Switch on top border side of the selected components.","BorderStyle":"Select the border style of the selected components.","BringToFront":"Bring the selected component to front.","CenterHorizontally":"Allows you to align a component horizontally relative to container edges in what it is placed.","CenterVertically":"Allows you to align a component vertically relative to container edges in what it is placed.","Close":"Close the Report Designer.","Columns":"Split a page into columns.","ComponentSize":"Change the size of the selected components.","CopyStyle":"Copy Style","CopyToClipboard":"Copy to Clipboard","CurrencySymbol":"Select the currency symbol.","DashboardNew":"Create a new dashboard.","DataStore":"Show data, registered in a report.","DateTimeFormat":"Select the date and time format for the selected components.","DockingPanels":"Panel settings.","DockStyleBottom":"Dock selected components to the bottom side.","DockStyleFill":"Dock selected components to all sides.","DockStyleLeft":"Dock selected components to the left side.","DockStyleNone":"Undock selected components.","DockStyleRight":"Dock selected components to the right side.","DockStyleTop":"Dock selected components to the top side.","FontGrow":"Make the text size larger.","FontName":"The text font.","FontNameWatermark":"The watermark text font.","FontShrink":"Make the text size smaller.","FontSize":"Font size.","FontSizeWatermark":"Change the font size.","FontStyleBold":"Make the text bold.","FontStyleBoldWatermark":"Make the text of the watermark bold.","FontStyleItalic":"Make the text Italic.","FontStyleItalicWatermark":"Make the watermark text Italic.","FontStyleStrikeout":"Make the text strikeout.","FontStyleUnderline":"Make the text underlined.","FontStyleUnderlineWatermark":"Make the watermark text underlined.","FormatBoolean":"This format is used to format values of the boolean type.","FormatCurrency":"Display a value as currency. It allows you to display a number with the default currency symbol.","FormatCustom":"This type is used to show values according to custom requirements. This type allows data formatting in the Format Mask.","FormatDate":"Display a value as date. The date format is based on the regional date settings.","FormatGeneral":"Display a value without specific format.","FormatNumber":"It is used for general display of numbers.","FormatPercentage":"Display a value as percentage. Numbers are multiplied by 100 to convert them to percentages.","FormatTime":"Display a value as time. The time format is based on the regional time settings.","FormNew":"Create a new dialog form.","GridMode":"Show grid in lines or dots.","ImageAlignment":"Put a watermark image on a page.","ImageTransparency":"Change the transparency of the watermark image.","Interaction":"Control an interaction of the selected components.","LineSpacing":"Choose how much space appears between lines of text or between paragraphs.","Link":"Link the component to the current container.","LoadImage":"Load watermark images from the file.","Lock":"Lock the component. The component cannot be moved and resized.","MainMenu":"Click here to see the list of possible operations with a report, including opening, closing, and previewing.","MakeHorizontalSpacingEqual":"Allows you to set equal horizontal spacing between selected components.","MakeVerticalSpacingEqual":"Allows you to set equal vertical spacing between selected components.","Margins":"Select the margins of the current page.","menuCheckIssues":"Check to find errors, warnings and get recommendations.","menuDesignerOptions":"Setup report designer options.","menuEditClearContents":"Clear the contents.","menuEditCopy":"Copy the selected components and put them on the Clipboard.","menuEditCut":"Cut the selected components from a report and put them on the Clipboard.","menuEditDelete":"Delete selected components.","menuEditPaste":"Paste the contents of the Clipboard into report.","menuFAQPage":"Go to the web page with frequently asked questions.","menuGlobalizationStrings":"Call the Globalization Strings editor of the current report.","menuHelpAboutProgramm":"Get information about the version of report generator and the version of .NET Framework.","menuHomePage":"Go to the Home page of the product.","menuPageOptions":"Setup the basic parameters of the current page. All page options can be changed using the Property panel.","menuPagesManager":"Run the Pages Manager. It allows moving pages, deleting pages, and creating new pages.","menuPreviewSettings":"Call the Preview Settings editor of the current report. Settings will be applied only when viewing the current report.","menuPrint":"Select a printer, number of copies, and other printing options before printing.","menuPrintPreview":"Preview a report before printing.","menuPrintQuick":"Print a report directly to the default printer. The printing dialog is not displayed.","menuReportOptions":"Setup the basic report options. All options can be changed using the Property panel.","menuStyleDesigner":"Call the Style Designer of the current report.","menuSupport":"Go to the support page to ask a question.","menuViewAlignToGrid":"Align components to grid.","menuViewNormal":"Normal view of a page.","menuViewPageBreakPreview":"The mode of showing a page with borders of segments.","menuViewQuickInfo":"Show quick information of components: component name, alias, contents, events etc.","menuViewShowGrid":"Turn on grid lines to which you can align objects in a report.","menuViewShowHeaders":"Show headers of bands.","menuViewShowOrder":"Show order of components on a page.","menuViewShowRulers":"View the rulers, used to measure and line up objects on a page.","MoveBackward":"Move a component to one level higher in order of placing components on a page.","MoveForward":"Move a component to one level lower in order of placing components on a page.","Orientation":"Switch the pages between portrait and landscape layouts.","PageDelete":"Delete current page from a report.","PageNew":"Create a new page.","PageSetup":"Show the Page Setup dialog box.","PageSize":"Choose the paper size for the current page of a report.","PagesManager":"Run the Pages Manager.","PressF1":"Press F1 for More Details","Redo":"Redo the previously canceled change in a report.","ReportNew":"Create a new report.","ReportOpen":"Open a report in the designer.","ReportPreview":"Preview an edited report in the viewer.","ReportSave":"Save currently edited report.","SelectAll":"Select all components on the current page.","SelectUILanguage":"Select the UI language.","SendToBack":"Move the selected component to back relative to other components.","ServicesConfigurator":"Run the Services Configurator.","Shadow":"Show the shadow of a component.","ShowBehind":"Show the watermark text behind the components.","ShowImageBehind":"Put the watermark image behind all components on a page.","ShowToolbox":"Show the toolbox.","StimulsoftHelp":"Stimulsoft Help","StyleDesigner":"Run Style Designer.","TellMeMore":"Tell me more","Text":"Watermark text.","TextBrush":"Change the text color.","TextBrushWatermark":"Change the text color of the watermark.","TextColor":"Change the text color.","TextFormat":"Select the format of values.","ToolbarStyle":"Set selected style to all selected components.","Undo":"Undo the latest change in a report.","WordWrap":"Wrap the text of a component.","Zoom":"Specify the zoom level of the report."},"HelpDialogs":{"StiButtonControl":"Represents the Button control.","StiCheckBoxControl":"Represents the Flag control.","StiCheckedListBoxControl":"Shows the List object, in what a flag on the left is shown for each elements.","StiComboBoxControl":"Represents the ComboBox that is used to either type a value directly into the control or choose from the list of existing options.","StiDateTimePickerControl":"Represents the control that allows selecting the date and time. It also allows you to output the date and time in specified format.","StiGridControl":"Represents the Grid control that consist of rows and columns.","StiGroupBoxControl":"Represents the control that creates a container with borders and a header for the UI content.","StiLabelControl":"A label is an user interface control which displays text on a form. It is usually a static control having no interactivity.","StiListBoxControl":"Contains the list of elements for selection.","StiListViewControl":"Represents the ListView control that shows the list of data elements.","StiLookUpBoxControl":"Contains the list of elements for selection.","StiNumericUpDownControl":"Represents the control that shows numeric values.","StiPanelControl":"The Panel elements are used for placing and arrangement objects.","StiPictureBoxControl":"Represents the control for showing an image.","StiRadioButtonControl":"Represents the Radio button control that allows the user to choose only one of a predefined set of options. ","StiRichTextBoxControl":"Represents the RichText control with widen editing.","StiTextBoxControl":"Represents the Text control that is used for showing or editing a text.","StiTreeViewControl":"Represents the control that is used to show the hierachical data as a tree."},"HelpViewer":{"AddPageBreaks":"Visual separator of report pages.","AllowAddOrModifyTextAnnotations":"Limited access to work with annotations in the document.","AllowCopyTextAndGraphics":"Limited access to copying information.","AllowEditable":"Allows changing components with the Editable property enabled.","AllowModifyContents":"Limited access to the text editing.","AllowPrintDocument":"Limited access to the print operation.","Bookmarks":"Show the bookmark panel that is used for quick navigation to jump directly to a bookmarked location.","BorderType":"The border type of components: simple - drawing borders of components with characters +, -, |; Unicode single - drawing the borders with single box-drawing characters, Unicode double - drawing the borders with double box-drawing characters.","Close":"Close the Report Preview.","CloseDotMatrix":"Close the Dot Matrix Viewer.","Compressed":"Compression of the ready document. It is recommended to always include file compression.","CompressToArchive":"Pack all files and folders in the zip archive.","ContinuousPages":"The mode of placing report pages as a vertical strip.","CurrentPage":"Processing the current page. If this option is selected, then a selected report page will be processed.","CutEdges":"Trim the borders of report pages.","CutLongLines":"Trim the long lines (text lines) by the borders of components.","DigitalSignature":"The digital signature of the file.","DitheringType":"Dithering type: None - no dithering, Ordered, FloydSt. - with dithering.","DotMatrixMode":"This mode allows you to see how will a report look like if to print it on a dot matrix printer.","DrawBorder":"Drawing the borders of components with graphic characters.","Edit":"Edit components.","EmbeddedFonts":"Embed the font files into a PDF file.","EmbeddedImageData":"Embed images directly into the HTML file.","Encoding":"Encoding the report text after export.","EncodingData":"Encoding data file.","EncryptionKeyLength":"The length of the encryption key. The longer the length is, the more difficult it is to decrypt the document, and, accordingly, the document security is on higher priority.","ExportDataOnly":"Export only Data bands (the Table component, Hierachical band).","ExportEachPageToSheet":"Export each report page in a separate Excel sheet.","ExportMode":"Apply a filter condition when exporting. Data Only - only data bands (Table component, Hierarchical Band) will be exported. Data and Headers/Footers - data bands (Table component, Hierarchical Band) and their headers/footers will be exported. All Bands - All the report bands will be exported.","ExportModeHtml":"The way of the HTML page markup.","ExportModeRtf":"Presentation of the report data after export. The Table - the report will look like a table, where each report component is a table cell. Frame - each component will look like a single frame, but without any relationship between them.","ExportObjectFormatting":"Apply formatting to export data from Data bands (Table component, Hierachical band).","ExportPageBreaks":"Show the borders of the report pages on the Excel sheet.","ExportRtfTextAsImage":"Convert the RTF text into the image. If the option is enabled, then, when exporting, RichText decomposes into simpler primitives supported by the PDF format. RichText with complex formatting (embedded images, tables) cannot always be converted correctly. In this case it is recommended to enable this option.","Find":"Find a text in the report.","FullScreen":"Full screen reading.","GetCertificateFromCryptoUI":"Using the interface of the system cryptography library.","ImageCompressionMethod":"The compression method: JPEG - this may cause loss of quality, Flate – no quality loss, Simple, Ordered, FloydSt. - images are output in monochrome.","ImageFormat":"The image format in the finished file.","ImageQuality":"Allows you to choose the ratio of the image quality/size of the file. The higher the quality is, the larger is the size of the finished file.","ImageQualityPdf":"The option is available only in JPEG compression, and allows you to select the ratio of the image quality/size of the file. The higher the quality is, the larger is the size of the finished file.","ImageResolution":"The number of pixels per inch. The higher the number of pixels is, the better is the quality of the image. The size of the finished file is much larger.","ImageType":"The color scheme of the image: color - image after exporting will fully match the image in the viewer; gray – an image after exporting will be of the gray shade; monochrome - the images will be strictly black and white. At the same time, it should be considered that the monochrome has three modes None, Ordered, FloydSt.","KillSpaceLines":"Remove blank lines (rows) in the document.","MultipleFiles":"Each report page can be a separate file.","Open":"Open the previously saved report in the window of preview.","OpenAfterExport":"Automatic opening of the created document (after export) by the program set for these file types.","OwnerPassword":"The password to access operations with files.","PageAll":"Processing of all report pages.","PageDelete":"Delete the selected report page.","PageDesign":"Edit the selected page in the report designer.","PageFirst":"Go to the first report page.","PageGoTo":"Go to the specified report page.","PageLast":"Go to the last report page.","PageNew":"Add a new page to a report.","PageNext":"Go to the next report page.","PagePrevious":"Go to the previous report page.","PageSize":"Change the page parameters in a report.","Parameters":"Showing parameters panel which is used when report rendering.","PdfACompliance":"Support for the standard of the long-term archiving and storing of electronic documents.","Print":"Print a report.","PutFeedPageCode":"Feed pages in the final document with a special character.","RangePages":"The page numbers to be processed. You can specify a single page, a list of pages (using a comma as the separator), as well as specify the range by setting the start page of the range separated by \\"-\\" and the end page of the range. For example: 1,3,5-12.","RemoveEmptySpaceAtBottom":"Minimize the empty space at the bottom of the page.","Resources":"Showing resources panel","RestrictEditing":"Limits on changes in a Word document.","Save":"Save a report for further using.","ScaleHtml":"The size (scale) of report pages and items after the export.","ScaleImage":"The size (scale) of the report after exporting. The lower scale is, the greater is the number of pixels per inch, and vice versa.","SendEMail":"Send a report via Email.","Separator":"Separator between the data in the CSV file.","SkipColumnHeaders":"Enable/disable the column headers.","StandardPdfFonts":"14 standard Adobe fonts. If this option is enabled, then only standard 14 fonts will be used in the PDF file. All report fonts are converted into them.","SubjectNameString":"Certificate identifier. The identifier is the name of the certificate owner (full line) or a part of the name (substring).","Thumbnails":"Show the thumbnails that can be used for quick navigation to find the section of the report that you want to jump to.","TiffCompressionScheme":"Compression scheme for TIFF files.","ToolEditor":"This tool allows you to edit contents of text components directly in the report viewer.","TypeExport":"The file the report will be converted into.","UseDefaultSystemEncoding":"Use system coding by default or specify the encoding by standard.","UseOnePageHeaderAndFooter":"Define the page bands Header and Footer as the header and footer of the Microsoft Word document.","UsePageHeadersAndFooters":"Define the bands Page Header and Footer as the header and footer of the document in Microsoft Word.","UserPassword":"The password required to open the document.","UseUnicode":"Extended support for encoding characters. It affects on the internal character encoding within the PDF file, and improves the copying of the text from the PDF file.","ViewModeContinuous":"Show all report pages as a vertical ribbon.","ViewModeMultiplePages":"Zoom the report so that as many pages as can be fit in window are displayed.","ViewModeSinglePage":"Show a single page in the window of preview.","ZoomMultiplePages":"Zoom the report so that the selected pages fit in the window.","ZoomOnePage":"Zoom the report so that an entire page fits in the window.","ZoomPageWidth":"Zoom the report so that the width of the page matches the width of the window.","ZoomTwoPages":"Zoom the report so that two pages fit in the window.","ZoomTxt":"The report size (scale): X - change the horizontal scale, Y - to change the vertical scale."},"Interface":{"Mouse":"Mouse","MouseDescription":"Optimized for used with mouse","Touch":"Touch","TouchDescription":"Optimized for used with touch"},"MainMenu":{"menuCheckIssues":"Check for Issues","menuContextClone":"Clone...","menuContextDesign":"Design...","menuContextTextFormat":"Text Format...","menuConvertToCheckBox":"Convert to CheckBox","menuConvertToImage":"Convert to Image","MenuConvertToRichText":"Convert to RichText","menuConvertToText":"Convert to Text","menuDeleteColumn":"Delete Column","menuDeleteRow":"Delete Row","menuEdit":"&amp;Edit","menuEditBusinessObjectFromDataSetNew":"New Business Object From DataSet...","menuEditBusinessObjectNew":"New Business Object...","menuEditCalcColumnNew":"New Calculated Column...","menuEditCantRedo":"Can\'t Redo","menuEditCantUndo":"Can\'t Undo","menuEditCategoryNew":"New Category...","menuEditClearContents":"Clear Contents","menuEditColumnNew":"New Column...","menuEditConnectionNew":"New Connection...","menuEditCopy":"&amp;Copy","menuEditCut":"Cu&amp;t","menuEditDataParameterNew":"New Parameter...","menuEditDataSourceNew":"New Data Source...","menuEditDataSourcesNew":"New Data Sources...","menuEditDataTransformationNew":"New Data Transformation...","menuEditDelete":"&amp;Delete","menuEditEdit":"Edit","menuEditImportRelations":"Import Relations...","menuEditPaste":"&amp;Paste","menuEditRedo":"&amp;Redo","menuEditRedoText":"&amp;Redo {0}","menuEditRelationNew":"New Relation...","menuEditRemoveUnused":"Remove Unused Items","menuEditResourceNew":"New Resource...","menuEditSelectAll":"Select &amp;All","menuEditSynchronize":"Synchronize","menuEditUndo":"&amp;Undo","menuEditUndoText":"&amp;Undo {0}","menuEditVariableNew":"New Variable...","menuEditViewData":"View Data...","menuEmbedAllDataToResources":"Embed all data to resources","menuFile":"&amp;File","menuFileClose":"&amp;Close","menuFileDashboardDelete":"Delete Dashboard","menuFileDashboardNew":"New Dashboard","menuFileDashboardOpen":"&amp;Open Dashboard...","menuFileDashboardSaveAs":"Save Dashboard &amp;As...","menuFileExit":"E&amp;xit","menuFileExportXMLSchema":"Export XML Schema...","menuFileFormNew":"New Form","menuFileFormOpen":"Open Form","menuFileImportXMLSchema":"Import XML Schema...","menuFileMerge":"Merge...","menuFileMergeXMLSchema":"Merge XML Schema...","menuFileNew":"&amp;New","menuFileOpen":"&amp;Open...","menuFilePageDelete":"Delete Page","menuFilePageNew":"New Page","menuFilePageOpen":"Open Page...","menuFilePageSaveAs":"Save Page As...","menuFilePageSetup":"Page Setup...","menuFileRecentDocuments":"Recent Documents","menuFileRecentLocations":"Recent Locations","menuFileReportNew":"&amp;New Report...","menuFileReportOpen":"&amp;Open Report...","menuFileReportOpenFromGoogleDocs":"Open Report from Google Docs...","menuFileReportPreview":"&amp;Preview","menuFileReportSave":"&amp;Save Report","menuFileReportSaveAs":"Save Report &amp;As...","menuFileReportSaveAsToGoogleDocs":"Save Report As to Google Docs...","menuFileReportSetup":"Report &amp;Setup...","menuFileReportWizardNew":"New Report with &amp;Wizard...","menuFileSave":"&amp;Save","menuFileSaveAs":"Save As...","menuFileScreenNew":"New Screen","menuHelp":"&amp;Help","menuHelpAboutProgramm":"&amp;About...","menuHelpContents":"&amp;Contents","menuHelpDemos":"Demos","menuHelpDocumentation":"Documentation","menuHelpFAQPage":"FAQ Page","menuHelpForum":"Forum","menuHelpHowToRegister":"How to Register","menuHelpProductHomePage":"Product Home Page","menuHelpSamples":"Samples","menuHelpSupport":"&amp;Support","menuHelpTrainingCourses":"Training Courses","menuHelpVideos":"Videos","menuInsertColumnToLeft":"Insert Column To Left","menuInsertColumnToRight":"Insert Column To Right","menuInsertRowAbove":"Insert Row Above","menuInsertRowBelow":"Insert Row Below","menuJoinCells":"Join Cells","menuMakeThisRelationActive":"Make This Relation Active","menuSelectColumn":"Select Column","menuSelectRow":"Select Row","menuTable":"Table","menuTools":"&amp;Tools","menuToolsDataStore":"Data &amp;Store...","menuToolsDictionary":"&amp;Dictionary...","menuToolsOptions":"&amp;Options...","menuToolsPagesManager":"&amp;Pages Manager...","menuToolsServicesConfigurator":"Services &amp;Configurator...","menuToolsStyleDesigner":"Style &amp;Designer...","menuView":"&amp;View","menuViewAlignToGrid":"Align to Grid","menuViewNormal":"&amp;Normal","menuViewOptions":"Options","menuViewPageBreakPreview":"Page &amp;Break Preview","menuViewQuickInfo":"Quick Info","menuViewQuickInfoNone":"None","menuViewQuickInfoOverlay":"Display Over Components","menuViewQuickInfoShowAliases":"Show Aliases","menuViewQuickInfoShowComponentsNames":"Show Components Names","menuViewQuickInfoShowContent":"Show Content","menuViewQuickInfoShowEvents":"Show Events","menuViewQuickInfoShowFields":"Show Fields","menuViewQuickInfoShowFieldsOnly":"Show Fields Only","menuViewShowGrid":"Show Grid","menuViewShowHeaders":"Show Headers","menuViewShowInsertTab":"Show \'Insert\' Tab","menuViewShowOrder":"Show Order","menuViewShowRulers":"Show Rulers","menuViewShowToolbox":"Show Toolbox","menuViewToolbars":"Toolbars"},"Map":{"LinkDataForm":"Link Data","MapEditorForm":"Map Editor"},"MathFormula":{"Alphabets":"Alphabets","Arrows":"Arrows","Formulas":"Formulas","Maths":"Maths","Operators":"Operators"},"Messages":{"ChangeRequestTimeout":"The request timeout for SQL queries exceeds the request timeout of the report designer. Set the request timeout for the designer component in no less than {0} seconds.","DoNotShowAgain":"Do not show again","LatexFormat":"The LaTeX format is used to display mathematical formulas.","MessageTimeOutExpired":"Command timeout has expired!","RenderingWillOccurInTheInterpretationMode":"When viewing the shared report, the rendering will occur in the interpretation mode!","ResourceCannotBeDeleted":"The resource \\"{0}\\" cannot be deleted, because it is used in the report!","ShareURLOfTheItemHasBeenUpdated":"The share URL of the item has been updated!","ShareYourReportYouShouldSave":"To share your report you should save the report to Stimulsoft Cloud!","SwitchingBetweenModes":"Switching between modes will cause the loss of changes. Do you want to proceed?","SwitchParametersOrientation":"Please change the value of the \'ParametersOrientation\' report property to \'{0}\' to show this category on the parameters panel.","TextRegistrationSuccessfully":"\\nRegistration completed successfully!\\n\\nThe Email was sent to \\"{0}\\".\\nIt contains a link to confirm your registration. To complete the registration please follow the link from the Email you received.\\n","ThisFieldIsNotSpecified":"This Field is Not Specified!","ThisFunctionEmbedsAllReportDataToTheReport":"This function embeds all report data to the report resources and makes your report standalone. Be careful! All your data settings will be changed and can\'t be restored. Please, make a backup copy of your report firstly.{0}Are you sure?","YouNeedToLoginFirstToStartUsingTheSoftware":"You need to login first to start using the software. The application will close if you quit the login form."},"Notices":{"AccessDenied":"Access Denied!","AccountLocked":"Your account is locked! In order to resolve it, please send your request to sales@stimulsoft.com!","ActivationContact1":"Please contact our sales department at ","ActivationContact2":" to resolve this.","ActivationExpiriedBeforeFirstRelease":"Your Subscription of Stimulsoft Reports.Ultimate expired earlier than the first version of our Stimulsoft Server was released!","ActivationLicenseIsNotCorrect":"License file is not correct! Please contact our sales department at sales@stimulsoft.com!","ActivationLockedAccount":"Your account is locked. Please contact our sales department at sales@stimulsoft.com!","ActivationLockedAccountExt":"Your account is locked.","ActivationMaxActivationsReached":"You reached the maximum number of activations. Please contact our sales department at sales@stimulsoft.com!","ActivationMaxActivationsReached1":"You can manage the registered computers from your ","ActivationMaxActivationsReached2":"Stimulsoft Account.","ActivationMaxComputersReached":"You’ve already registered the maximum number of computers available for your subscription.","ActivationServerIsNotAvailableNow":"Stimulsoft Activation Server is not available now! Please try again later.","ActivationServerVersionNotAllowed":"You cannot activate this version of Stimulsoft Server because your Subscription Program expired! Please log in to your account and check which version of the Stimulsoft Server you can install and activate.","ActivationSomeTroublesOccurred":"An error occurred during activation. Please try again later.","ActivationTrialExpired":"You can continue to use Stimulsoft Designer by purchasing the software.","ActivationTrialExtend1":"If you are interested in extending your trial, please ","ActivationTrialExtend2":"tell us why.","ActivationUserNameOrPasswordIsWrong":"Your user name (Email) or password is wrong!","ActivationWrongAccountType":"Your account type does not allow to activate Stimulsoft Server!","Alert":"Alert","AuthAccountAlreadyExists":"The account with this User Name (email) already exists. To associate it with your {0} account, please use your Stimulsoft account password.","AuthAccountCantBeUsedNow":"The account cannot be used now!","AuthAccountIsNotActivated":"The account is not activated yet! Please follow the instructions sent to the Email during registration.","AuthCantChangeRoleBecauseLastAdministratorUser":"The user role cannot be changed because this is the last administrator user in this workspace!","AuthCantChangeRoleBecauseLastSupervisorUser":"The user role cannot be changed because this is the last supervisor user at this server!","AuthCantChangeSystemRole":"The system role cannot be changed!","AuthCantDeleteHimselfUser":"The user cannot delete himself!","AuthCantDeleteLastAdministratorUser":"The user cannot be deleted because this is the last administrator user in this workspace!","AuthCantDeleteLastSupervisorUser":"The user cannot be deleted because this is the last supervisor user at this server!","AuthCantDeleteSystemRole":"Cannot delete this role, because it is a system role!","AuthCantDisableUserBecauseLastAdministratorUser":"The user cannot be disabled because this is the last administrator user in this workspace!","AuthCantDisableUserBecauseLastSupervisorUser":"The user cannot be disabled because this is the last supervisor user at this server!","AuthFirstNameIsNotSpecified":"The first name is not specified!","AuthLastNameIsNotSpecified":"The last name is not specified!","AuthOAuthIdNotSpecified":"The OAuth identificator is not specified!","AuthPasswordIsNotCorrect":"The password is not correct!","AuthPasswordIsNotSpecified":"The password is not specified!","AuthPasswordIsTooShort":"The password is too short (a minimum length is 6 chars)!","AuthRoleCantBeDeletedBecauseUsedByUsers":"You cannot delete the role because it is used by other users.","AuthRoleNameAlreadyExists":"The role with the specified name \\"{0}\\" already exists!","AuthRoleNameIsSystemRole":"The role with the specified name \\"{0}\\" is a system role!","AuthSendMessageWithInstructions":"A message with further instructions is sent to \\"{0}\\"!","AuthTokenIsNotCorrect":"Token is not correct!","AuthUserHasLoggedOut":"You have logged out!","AuthUserNameAlreadyExists":"The username (Email) is already in use!","AuthUserNameEmailIsBlocked":"This Email address cannot be used!","AuthUserNameIsNotSpecified":"The username (Email) is not specified!","AuthUserNameNotAssociatedWithYourAccount":"Username (Email) {0} is not associated with your {1} account!","AuthUserNameOrPasswordIsNotCorrect":"The username (Email) or password is incorrect!","AuthUserNameShouldLookLikeAnEmailAddress":"The username should be similar to the Email address!","AuthWorkspaceNameAlreadyInUse":"The workspace name is already in use!","CommandTimeOut":"Waiting time of processing the command is elapsed!","Congratulations":"Congratulations!","DeveloperInformation":"Developer Information","EndDateShouldBeGreaterThanCurrentDate":"The end date should be greater than the current date!","EndDateShouldBeGreaterThanStartDate":"The end date should be greater than start date!","ExecutionError":"Execution error","IsIdentical":"\\"{0}\\" and \\"{1}\\" are identical.\\"","IsNotAuthorized":"No access to \\"{0}\\"!","IsNotCorrect":"\\"{0}\\" is incorrect!","IsNotDeleted":"\\"{0}\\" is not deleted!","IsNotEqual":"\\"{0}\\" is not equal!","IsNotFound":"\\"{0}\\" is not found!","IsNotRecognized":"\\"{0}\\" is not recognized!","IsNotSpecified":"\\"{0}\\" is not specified!","IsRequiredFile":"You should add at least one file!","ItemCantBeAttachedToItself":"The item cannot be attached to itself!","ItemCantBeDeletedBecauseItemIsAttachedToOtherItems":"The elements \\"{0}\\" cannot be deleted because they are attached to other elements!","ItemCantBeMovedToSpecifiedPlace":"The item cannot be moved to a specified place!","ItemDoesNotSupport":"The item does not support \\"{0}\\"!","KeyAndToKeyAreEqual":"A Key and ToKey are equal!","MaximumComputers":"Maximum of Computers","MessageMaximumFileSizeExceeded":"Attention! The size of the file that you are trying to add exceeds the maximum-allowed size. Do you want to add this file anyway (report processing may slow down significantly)?","NewDesignerAvailable":"Stimulsoft Designer {0} is available.","NewProduct":"The new product is added to your subscription!","NewVersionsAvailable":"New version","NotificationConnectPackage":"Connect the \\"{0}\\" package for the correct work.","NotificationFailed":"Failed result!","NotificationFailedAddFollowingFiles":"Failed to add the following files. Exceeded the size {0} MB.","NotificationFilesUploadingComplete":"The files uploaded successfully.","NotificationFileUploading":"The file \\"{0}\\" is uploading.","NotificationItemDelete":"The items are deleting.","NotificationItemDeleteComplete":"The items are deleted successfully.","NotificationItemExtraComponentRequired":"Extra component required","NotificationItemInstallWebView":"Please install the WebView2 Runtime to work with the Blockly editor correctly.","NotificationItemRestore":"The items are restoring.","NotificationItemRestoreComplete":"The items are restored successfully.","NotificationItemTransfer":"The items are transferring.","NotificationItemTransferComplete":"The items are transferred successfully.","NotificationItemWaitingProcessing":"The items are waiting processing.","NotificationMailing":"Sending","NotificationMailingComplete":"The mailing \\"{0}\\" is complete.","NotificationMailingWaitingProcessing":"The mailing \\"{0}\\" is waiting processing.","NotificationOperationAborted":"Operation aborted!","NotificationPackageRequiredToDisplay":"To display this content, please download the \\"{0}\\" package from NuGet.","NotificationRecycleBinCleaning":"The Recycle Bin is cleaning.","NotificationRecycleBinCleaningComplete":"The Recycle Bin is cleaned successfully.","NotificationRecycleBinWaitingProcessing":"The Recycle Bin cleaning is waiting processing.","NotificationReportExporting":"The report \\"{0}\\" is exporting","NotificationReportExportingComplete":"The report \\"{0}\\" is exported successfully.","NotificationReportRendering":"The report \\"{0}\\" is rendering","NotificationReportRenderingComplete":"The report \\"{0}\\" is rendered.","NotificationReportWaitingProcessing":"The report \\"{0}\\" is waiting processing.","NotificationReturnToDesigner":"Return to the Stimulsoft Designer to continue.","NotificationSchedulerRunning":"The scheduler \\"{0}\\" is running.","NotificationSchedulerRunningComplete":"The scheduler \\"{0}\\" running complete.","NotificationSchedulerWaitingProcessing":"The scheduler \\"{0}\\" is waiting processing.","NotificationTitleFilesUploading":"Uploading files","NotificationTitleItemRefreshing":"Refreshing item \\"{0}\\"","NotificationTitleItemTransferring":"Transferring item \\"{0}\\"","NotificationTitleMailing":"Mailing \\"{0}\\"","NotificationTitleReportExporting":"Exporting report \\"{0}\\"","NotificationTitleReportRendering":"Rendering report \\"{0}\\"","NotificationTitleSchedulerRunning":"Running scheduler \\"{0}\\"","NotificationTransferring":"The \\"{0}\\" is tranferring to \\"{1}\\".","NotificationTransferringComplete":"The \\"{0}\\" is succesfully transffered to \\"{1}\\".","NotificationValueIsNotCorrect":"This value is not correct for the type {0}","OutOfRange":"Out of range (\\"{0}\\")!","ParsingCommandException":"An exception of processing the command in the specified xml: {0}","PleaseLogin":"Please login using your Stimulsoft account credentials or register a new account before publishing report.","QuotaMaximumComputingCyclesCountExceeded":"Maximum computing cycles exceeded.","QuotaMaximumDataRowsCountExceeded":"Maximum data rows in one data source exceeded.","QuotaMaximumFileSizeExceeded":"Maximum file size exceeded.","QuotaMaximumItemsCountExceeded":"Maximum items exceeded.","QuotaMaximumRefreshCountExceeded":"Maximum refresh count exceeded","QuotaMaximumReportPagesCountExceeded":"Maximum report pages exceeded.","QuotaMaximumResourcesCountExceeded":"Maximum resources exceeded.","QuotaMaximumResourceSizeExceeded":"Maximum resource size exceeded.","QuotaMaximumUsersCountExceeded":"Maximum users exceeded.","QuotaMaximumWorkspacesCountExceeded":"Maximum workspaces exceeded.","SchedulerCantRunItSelf":"The scheduler cannot run itself!","SessionTimeOut":"Session timeout","SnapshotAlreadyProcessed":"The report snapshot is already processed!","SpecifiedItemIsNot":"The specified item is not \\"{0}\\"!","SubscriptionExpired":"Your subscription has expired!","SubscriptionExpiredDate":"Your subscription will expire on {0}","SubscriptionExpiredDays":"Expires in {0} days","SubscriptionExpiredExt":"Your subscription has expired. Update your subscription to get the last version.","SubscriptionExpiredShort":"Subscription expired","SubscriptionsOut10":"10 days left when the subscription expires!","SubscriptionsOut20":"The subscription period will expire in 20 days!","SuccessfullyRenewed":"Your subscription has been successfully updated!","TrialToLicense":"We would like to thank you for choosing our software!","VersionCopyFromItem":"Copy from item \\"{0}\\".","VersionCreatedFromFile":"Created from file \\"{0}\\".","VersionCreatedFromItem":"Created from item \\"{0}\\".","VersionLoadedFromFile":"Loaded from file \\"{0}\\".","VersionNewItemCreation":"New item creation.","Warning":"Warning","WindowClosePreventWhileUploading":"Some files are uploading now, if you close page they will lost. Are you sure you want to close page?","WithSpecifiedKeyIsNotFound":"\\"{0}\\" with the specified key is not found!","WouldYouLikeToUpdateNow":"Would you like to update now?","YourTimeSessionHasExpired":"Your time session has expired!","YourTrialHasExpired":"Your trial has expired","YourTrialWillExpire":"Your trial will expire in {0} days.","YouUsingTrialVersion":"You are using a trial version!"},"NuGet":{"AlreadyDownloaded":"Already Downloaded","AssemblyLoadedSuccessfully":"The assembly is loaded successfully.","AssemblyNotFound":"It is impossible to find {0} assembly to use the {1} connection!","Author":"Author","Dependencies":"Dependencies:","Download":"Download","DownloadAll":"Download All","DownloadAndInstall":"Download and Install","DownloadDataAdapter":"Download Data Adapter","Downloads":"Downloads:","IAccept":"I Accept","IDecline":"I Decline","LicenceFormDesc":"The following package require that you accept their license terms before installing.","LicenceFormDesc1":"By clicking \\"I Accept\\" you agree to the license terms for the package listed above. If you do not agree to the license terms, click \\"I Decline\\".","LicenceFormTitle":"Licence Acceptance","License":"License:","ProjectUrl":"Project URL:","ReportAbuse":"Report Abuse:","RetrievingInformation":"Retrieving information...","Tags":"Tags:","Title":"Data Adapter from NuGet","ViewLicense":"View License"},"Panels":{"Dictionary":"Dictionary","Messages":"Messages","Properties":"Properties","ReportTree":"Report Tree"},"Password":{"gbPassword":"Encrypting of the file","lbPasswordLoad":"Enter the password to open the file","lbPasswordSave":"Password:","PasswordNotEntered":"The password is not entered","StiLoadPasswordForm":"Document encrypting","StiSavePasswordForm":"Password"},"Permissions":{"AdminAPI":"API","AdminBackgroundTasks":"Background Tasks","AdminPermissions":"Permissions","AdminRecycleBin":"Recycle Bin","AdminShare":"Share","AdminTransfers":"Transfers","ItemCalendars":"Calendars","ItemCloudStorages":"Cloud Storages","ItemContactLists":"Contact Lists","ItemDashboards":"Dashboards","ItemDataSources":"Data Sources","ItemFiles":"Files","ItemFolders":"Folders","ItemForms":"Forms","ItemReportSnapshots":"Report Snapshots","ItemReportTemplates":"Report Templates","ItemSchedulers":"Schedulers","ReportDesignerBusinessObjects":"Business Objects","ReportDesignerDataColumns":"Data Columns","ReportDesignerDataConnections":"Data Connections","ReportDesignerDataRelations":"Data Relations","ReportDesignerDataSources":"Data Sources","ReportDesignerDictionaryActions":"Dictionary Actions","ReportDesignerRestrictions":"Restrictions","ReportDesignerVariables":"Variables","SystemBackupRestore":"Backup &amp; Restore","SystemEmailTemplates":"Email Templates","SystemLicensing":"Licensing","SystemMonitoring":"Monitoring","SystemUpdate":"Update","SystemWorkspaces":"Workspaces","TextAdministration":"Administration","TextItems":"Items","TextReportDesigner":"Report Designer","TextSystem":"System","TextUsers":"Users","UserHimself":"Himself","UserRoles":"Roles","Users":"Users","UserWorkspace":"Workspace"},"PlacementComponent":{"MoveLeftFreeSpace":"Moves a component to the left side of a free space, increasing the height of the component to the height of free space.","MoveRightFreeSpace":"Moves a component to the right side of a free space, increasing the height of the component to the height of free space."},"PromptForm":{"CacheLoginData":"Cache login data for current session"},"PropertyCategory":{"AppearanceCategory":"Appearance","AreaCategory":"Area","ArgumentCategory":"Argument","AxisCategory":"Axis","BarCodeAdditionalCategory":"Bar Code Additional","BarCodeCategory":"Bar Code","BehaviorCategory":"Behavior","ButtonCategory":"Button","CapNeedle":"Cap Needle","CardsCategory":"Cards","CellCategory":"Cell","ChartAdditionalCategory":"Chart Additional","ChartCategory":"Chart","ChartMap":"Map","CheckCategory":"Check","ColorsCategory":"Colors","ColumnsCategory":"Columns","ComboBoxCategory":"Combo Box","CommonCategory":"Common","ControlCategory":"Control","ControlsEventsCategory":"Controls Events","CrossTabCategory":"Cross-Tab","DashboardCategory":"Dashboard","DataCategory":"Data","DataCells":"Data Cells","DatePickerCategory":"Date Picker","DescriptionCategory":"Description","DesignCategory":"Design","DisplayCategory":"Display","EngineCategory":"Engine","ExportCategory":"Export","ExportEventsCategory":"Export Events","FooterTableCategory":"Footer Table","GaugeCategory":"Gauge","GlobalizationCategory":"Globalization","GridLinesCategory":"Grid Lines","HeaderTableCategory":"Header Table","HierarchicalCategory":"Hierarchical","ImageAdditionalCategory":"Image Additional","ImageCategory":"Image","IndicatorCategory":"Indicator","InterlacingCategory":"Interlacing","LabelsCategory":"Labels","LegendCategory":"Legend","LinearScaleBarCategory":"Linear Scale Bar","LinearScaleCategory":"Linear Scale","ListBoxCategory":"List Box","MainCategory":"Main","MarkerCategory":"Marker","MathFormulaCategory":"Math Formula","MiscCategory":"Misc","MouseEventsCategory":"Mouse Events","NavigationCategory":"Navigation","NavigationEventsCategory":"Navigation Events","Needle":"Needle","NeedleCategory":"Needle","OnlineMapCategory":"Online Map","OptionsCategory":"Options","PageAdditionalCategory":"Page Additional","PageCategory":"Page","PageColumnBreakCategory":"Page and Column Break","ParametersCategory":"Parameters","PivotTableCategory":"Pivot Table","PositionCategory":"Position","PrimitiveCategory":"Primitive","PrintEventsCategory":"Print Events","ProgressCategory":"Progress","RadialScaleBarCategory":"Radial Scale Bar","RegionMapCategory":"Region Map","RenderEventsCategory":"Render Events","SeriesCategory":"Series","SeriesLabelsCategory":"Series Labels","ShapeCategory":"Shape","Size":"Size","SubReportCategory":"Sub-Report","TableCategory":"Table","TableOfContents":"Table of Contents","TextAdditionalCategory":"Text Additional","TextCategory":"Text","TickLabelMajorCategory":"Tick Label Major","TickLabelMinorCategory":"Tick Label Minor","TickMarkMajorCategory":"Tick Mark Major","TickMarkMinorCategory":"Tick Mark Minor","TitleCategory":"Title","TreeViewBoxCategory":"Tree View Box","TreeViewCategory":"Tree View","TrendLineCategory":"Trend Line","ValueCategory":"Value","ValueCloseCategory":"Value Close","ValueEndCategory":"Value End","ValueEventsCategory":"Value Events","ValueHighCategory":"Value High","ValueLowCategory":"Value Low","ValueOpenCategory":"Value Open","ViewCategory":"View","WeightCategory":"Weight","WinControlCategory":"Win Control","ZipCodeCategory":"ZIP Code"},"PropertyColor":{"AliceBlue":"Alice Blue","AntiqueWhite":"Antique White","Aqua":"Aqua","Aquamarine":"Aquamarine","Azure":"Azure","Beige":"Beige","Bisque":"Bisque","Black":"Black","BlanchedAlmond":"Blanched Almond","Blue":"Blue","BlueViolet":"Blue Violet","Brown":"Brown","BurlyWood":"Burly Wood","CadetBlue":"Cadet Blue","Carmine":"Carmine","Chartreuse":"Chartreuse","Chocolate":"Chocolate","Coral":"Coral","CornflowerBlue":"Cornflower Blue","Cornsilk":"Cornsilk","Crimson":"Crimson","Cyan":"Cyan","DarkBlue":"Dark Blue","DarkCyan":"Dark Cyan","DarkGoldenrod":"Dark Goldenrod","DarkGray":"Dark Gray","DarkGreen":"Dark Green","DarkKhaki":"Dark Khaki","DarkMagenta":"Dark Magenta","DarkOliveGreen":"Dark Olive Green","DarkOrange":"Dark Orange","DarkOrchid":"Dark Orchid","DarkRed":"Dark Red","DarkSalmon":"Dark Salmon","DarkSeaGreen":"Dark Sea Green","DarkSlateBlue":"Dark Slate Blue","DarkSlateGray":"Dark Slate Gray","DarkTurquoise":"Dark Turquoise","DarkViolet":"Dark Violet","DeepPink":"Deep Pink","DeepSkyBlue":"Deep Sky Blue","DimGray":"Dim Gray","DodgerBlue":"Dodger Blue","Firebrick":"Firebrick","FloralWhite":"Floral White","ForestGreen":"Forest Green","Fuchsia":"Fuchsia","Gainsboro":"Gainsboro","GhostWhite":"Ghost White","Gold":"Gold","Goldenrod":"Goldenrod","Gray":"Gray","Green":"Green","GreenYellow":"Green Yellow","Honeydew":"Honeydew","HotPink":"Hot Pink","IndianRed":"Indian Red","Indigo":"Indigo","Ivory":"Ivory","Khaki":"Khaki","Lavender":"Lavender","LavenderBlush":"Lavender Blush","LawnGreen":"Lawn Green","LemonChiffon":"Lemon Chiffon","LightBlue":"Light Blue","LightCoral":"Light Coral","LightCyan":"Light Cyan","LightGoldenrodYellow":"Light Goldenrod Yellow","LightGray":"Light Gray","LightGreen":"Light Green","LightPink":"Light Pink","LightSalmon":"Light Salmon","LightSeaGreen":"Light Sea Green","LightSkyBlue":"Light Sky Blue","LightSlateGray":"Light Slate Gray","LightSteelBlue":"Light Steel Blue","LightYellow":"Light Yellow","Lime":"Lime","LimeGreen":"Lime Green","Linen":"Linen","Magenta":"Magenta","Maroon":"Maroon","MediumAquamarine":"Medium Aquamarine","MediumBlue":"Medium Blue","MediumOrchid":"Medium Orchid","MediumPurple":"Medium Purple","MediumSeaGreen":"Medium Sea Green","MediumSlateBlue":"Medium Slate Blue","MediumSpringGreen":"Medium Spring Green","MediumTurquoise":"Medium Turquoise","MediumVioletRed":"Medium Violet Red","MidnightBlue":"Midnight Blue","MintCream":"Mint Cream","MistyRose":"Misty Rose","Moccasin":"Moccasin","NavajoWhite":"Navajo White","Navy":"Navy","OldLace":"Old Lace","Olive":"Olive","OliveDrab":"Olive Drab","Orange":"Orange","OrangeRed":"Orange Red","Orchid":"Orchid","PaleGoldenrod":"Pale Goldenrod","PaleGreen":"Pale Green","PaleTurquoise":"Pale Turquoise","PaleVioletRed":"Pale Violet Red","PapayaWhip":"Papaya Whip","PeachPuff":"Peach Puff","Peru":"Peru","Pink":"Pink","Plum":"Plum","PowderBlue":"Powder Blue","Purple":"Purple","Red":"Red","RosyBrown":"Rosy Brown","RoyalBlue":"Royal Blue","SaddleBrown":"Saddle Brown","Salmon":"Salmon","SandyBrown":"Sandy Brown","SeaGreen":"Sea Green","SeaShell":"Sea Shell","Sienna":"Sienna","Silver":"Silver","SkyBlue":"Sky Blue","SlateBlue":"Slate Blue","SlateGray":"Slate Gray","Snow":"Snow","SpringGreen":"Spring Green","SteelBlue":"Steel Blue","Tan":"Tan","Teal":"Teal","Thistle":"Thistle","Tomato":"Tomato","Transparent":"Transparent","Turquoise":"Turquoise","VeryDarkGray":"Very Dark Gray","Violet":"Violet","Wheat":"Wheat","White":"White","WhiteSmoke":"White Smoke","Yellow":"Yellow","YellowGreen":"Yellow Green"},"PropertyEnum":{"boolFalse":"False","boolTrue":"True","BorderStyleFixed3D":"Fixed 3D","BorderStyleFixedSingle":"Fixed Single","BorderStyleNone":"None","ChartAxesTicksAll":"All","ChartAxesTicksMajor":"Major","ChartAxesTicksNone":"None","ChartGridLinesAll":"All","ChartGridLinesMajor":"Major","ChartGridLinesNone":"None","ComboBoxStyleDropDown":"Drop Down","ComboBoxStyleDropDownList":"Drop Down List","ComboBoxStyleSimple":"Simple","ContentAlignmentBottomCenter":"Bottom Center","ContentAlignmentBottomLeft":"Bottom Left","ContentAlignmentBottomRight":"Bottom Right","ContentAlignmentMiddleCenter":"Middle Center","ContentAlignmentMiddleLeft":"Middle Left","ContentAlignmentMiddleRight":"Middle Right","ContentAlignmentTopCenter":"Top Center","ContentAlignmentTopLeft":"Top Left","ContentAlignmentTopRight":"Top Right","DataGridLineStyleNone":"None","DataGridLineStyleSolid":"Solid","DateTimePickerFormatCustom":"Custom","DateTimePickerFormatLong":"Long","DateTimePickerFormatShort":"Short","DateTimePickerFormatTime":"Time","DialogResultAbort":"Abort","DialogResultCancel":"Cancel","DialogResultIgnore":"Ignore","DialogResultNo":"No","DialogResultNone":"None","DialogResultOK":"OK","DialogResultRetry":"Retry","DialogResultYes":"Yes","DuplexDefault":"Default","DuplexHorizontal":"Horizontal","DuplexSimplex":"Simplex","DuplexVertical":"Vertical","FormStartPositionCenterParent":"Center Parent","FormStartPositionCenterScreen":"Center Screen","FormStartPositionManual":"Manual","FormStartPositionWindowsDefaultBounds":"Windows Default Bounds","FormStartPositionWindowsDefaultLocation":"Windows Default Location","FormWindowStateMaximized":"Maximized","FormWindowStateMinimized":"Minimized","FormWindowStateNormal":"Normal","HorizontalAlignmentCenter":"Center","HorizontalAlignmentLeft":"Left","HorizontalAlignmentRight":"Right","HotkeyPrefixHide":"Hide","HotkeyPrefixNone":"None","HotkeyPrefixShow":"Show","LeftRightAlignmentLeft":"Left","LeftRightAlignmentRight":"Right","PictureBoxSizeModeAutoSize":"Auto Size","PictureBoxSizeModeCenterImage":"Center Image","PictureBoxSizeModeNormal":"Normal","PictureBoxSizeModeStretchImage":"Stretch Image","RelationDirectionChildToParent":"Child-To-Parent","RelationDirectionParentToChild":"Parent-To-Child","RightToLeftInherit":"Inherit","RightToLeftNo":"No","RightToLeftYes":"Yes","SelectionModeMultiExtended":"Multi Extended","SelectionModeMultiSimple":"Multi Simple","SelectionModeNone":"None","SelectionModeOne":"One","StiAnchorModeBottom":"Bottom","StiAnchorModeLeft":"Left","StiAnchorModeRight":"Right","StiAnchorModeTop":"Top","StiAngleAngle0":"0 Degrees","StiAngleAngle180":"180 Degrees","StiAngleAngle270":"270 Degrees","StiAngleAngle45":"45 Degrees","StiAngleAngle90":"90 Degrees","StiArrowStyleArc":"Arc","StiArrowStyleArcAndCircle":"Arc and Circle","StiArrowStyleCircle":"Circle","StiArrowStyleLines":"Lines","StiArrowStyleNone":"None","StiArrowStyleTriangle":"Triangle","StiBorderSidesAll":"All","StiBorderSidesBottom":"Bottom","StiBorderSidesLeft":"Left","StiBorderSidesNone":"None","StiBorderSidesRight":"Right","StiBorderSidesTop":"Top","StiBorderStyleBump":"Bump","StiBorderStyleEtched":"Etched","StiBorderStyleFlat":"Flat","StiBorderStyleNone":"None","StiBorderStyleRaised":"Raised","StiBorderStyleRaisedInner":"Raised Inner","StiBorderStyleRaisedOuter":"Raised Outer","StiBorderStyleSunken":"Sunken","StiBorderStyleSunkenInner":"Sunken Inner","StiBorderStyleSunkenOuter":"Sunken Outer","StiBrushTypeGlare":"Glare Brush","StiBrushTypeGradient0":"Gradient Brush, Angle 0","StiBrushTypeGradient180":"Gradient Brush, Angle 180","StiBrushTypeGradient270":"Gradient Brush, Angle 270","StiBrushTypeGradient45":"Gradient Brush, Angle 45","StiBrushTypeGradient90":"Gradient Brush, Angle 90","StiBrushTypeSolid":"Solid Brush","StiButtonSendTypeFDF":"FDF","StiButtonSendTypeHTML":"HTML","StiButtonSendTypePDF":"PDF","StiButtonSendTypeXFDF":"XFDF","StiCalculationModeCompilation":"Compilation","StiCalculationModeInterpretation":"Interpretation","StiCapStyleArrow":"Arrow","StiCapStyleDiamond":"Diamond","StiCapStyleNone":"None","StiCapStyleOpen":"Open","StiCapStyleOval":"Oval","StiCapStyleSquare":"Square","StiCapStyleStealth":"Stealth","StiChartLabelsStyleCategory":"Category","StiChartLabelsStyleCategoryPercentOfTotal":"Category - Percent Of Total","StiChartLabelsStyleCategoryValue":"Category - Value","StiChartLabelsStylePercentOfTotal":"Percent Of Total","StiChartLabelsStyleValue":"Value","StiChartTitleDockBottom":"Bottom","StiChartTitleDockLeft":"Left","StiChartTitleDockRight":"Right","StiChartTitleDockTop":"Top","StiChartTrendLineTypeExponential":"Exponential","StiChartTrendLineTypeLinear":"Linear","StiChartTrendLineTypeLogarithmic":"Logarithmic","StiChartTrendLineTypeNone":"None","StiCheckStateChecked":"Checked","StiCheckStateIndeterminate":"Indeterminate","StiCheckStateUnchecked":"Unchecked","StiCheckStyleCheck":"Check","StiCheckStyleCheckRectangle":"Check Rectangle","StiCheckStyleCross":"Cross","StiCheckStyleCrossCircle":"Cross Circle","StiCheckStyleCrossRectangle":"Cross Rectangle","StiCheckStyleDotCircle":"Dot Circle","StiCheckStyleDotRectangle":"Dot Rectangle","StiCheckStyleNone":"None","StiCheckStyleNoneCircle":"None Circle","StiCheckStyleNoneRectangle":"None Rectangle","StiCheckSumNo":"No","StiCheckSumYes":"Yes","StiCode11CheckSumAuto":"Auto","StiCode11CheckSumNone":"None","StiCode11CheckSumOneDigit":"One Digit","StiCode11CheckSumTwoDigits":"Two Digits","StiColorScaleTypeColor2":"2-Color Scale","StiColorScaleTypeColor3":"3-Color Scale","StiColumnDirectionAcrossThenDown":"Across Then Down","StiColumnDirectionDownThenAcross":"Down Then Across","StiColumnShape3DBox":"Box","StiColumnShape3DPartialPyramid":"Partial Pyramid","StiColumnShape3DPyramid":"Pyramid","StiCrossHorAlignmentCenter":"Center","StiCrossHorAlignmentLeft":"Left","StiCrossHorAlignmentNone":"None","StiCrossHorAlignmentRight":"Right","StiDashboardContentAlignmentCenter":"Center","StiDashboardContentAlignmentLeft":"Left","StiDashboardContentAlignmentRight":"Right","StiDashboardContentAlignmentStretchX":"Stretch X","StiDashboardContentAlignmentStretchXY":"Stretch XY","StiDateSelectionModeAutoRange":"Auto Range","StiDateSelectionModeRange":"Range","StiDateSelectionModeSingle":"Single","StiDateTimeTypeDate":"Date","StiDateTimeTypeDateAndTime":"Date and Time","StiDateTimeTypeTime":"Time","StiDesignerScaleModeAutomaticScaling":"Automatic Scaling","StiDesignerScaleModeScaling100":"100% Scaling","StiDesignerSpecificationAuto":"Determine Automatically","StiDesignerSpecificationBeginner":"I\'m Beginner","StiDesignerSpecificationBICreator":"I\'m Creator","StiDesignerSpecificationDeveloper":"I\'m Developer","StiDirectionBottomToTop":"Bottom to Top","StiDirectionLeftToRight":"Left to Right","StiDirectionRightToLeft":"Right to Left","StiDirectionTopToBottom":"Top to Bottom","StiDisplayNameTypeFull":"Full","StiDisplayNameTypeNone":"None","StiDisplayNameTypeShort":"Short","StiDockStyleBottom":"Bottom","StiDockStyleFill":"Fill","StiDockStyleLeft":"Left","StiDockStyleNone":"None","StiDockStyleRight":"Right","StiDockStyleTop":"Top","StiDrillDownModeMultiPage":"Multi Page","StiDrillDownModeSinglePage":"Single Page","StiEanSupplementTypeFiveDigit":"FiveDigit","StiEanSupplementTypeNone":"None","StiEanSupplementTypeTwoDigit":"TwoDigit","StiEmptyCellsAsConnectPointsWithLine":"Connect Points with Line","StiEmptyCellsAsGap":"Gap","StiEmptyCellsAsZero":"Zero","StiEmptySizeModeAlignFooterToBottom":"Align Footer to Bottom","StiEmptySizeModeAlignFooterToTop":"Align Footer to Top","StiEmptySizeModeDecreaseLastRow":"Decrease Last Row","StiEmptySizeModeIncreaseLastRow":"Increase Last Row","StiEnumeratorTypeABC":"ABC","StiEnumeratorTypeArabic":"Arabic","StiEnumeratorTypeNone":"None","StiEnumeratorTypeRoman":"Roman","StiExtendedStyleBoolFalse":"False","StiExtendedStyleBoolFromStyle":"From Style","StiExtendedStyleBoolTrue":"True","StiFilterConditionBeginningWith":"beginning with","StiFilterConditionBetween":"between","StiFilterConditionContaining":"containing","StiFilterConditionEndingWith":"ending with","StiFilterConditionEqualTo":"equal to","StiFilterConditionGreaterThan":"greater than","StiFilterConditionGreaterThanOrEqualTo":"greater than or equal to","StiFilterConditionIsBlank":"is blank","StiFilterConditionIsNotBlank":"is not blank","StiFilterConditionIsNotNull":"is not null","StiFilterConditionIsNull":"is null","StiFilterConditionLessThan":"less than","StiFilterConditionLessThanOrEqualTo":"less than or equal to","StiFilterConditionNotBetween":"not between","StiFilterConditionNotContaining":"not containing","StiFilterConditionNotEqualTo":"not equal to","StiFilterDataTypeBoolean":"Boolean","StiFilterDataTypeDateTime":"DateTime","StiFilterDataTypeExpression":"Expression","StiFilterDataTypeNumeric":"Numeric","StiFilterDataTypeString":"String","StiFilterEngineReportEngine":"Report Engine","StiFilterEngineSQLQuery":"SQL Query","StiFilterItemArgument":"Argument","StiFilterItemExpression":"Expression","StiFilterItemValue":"Value","StiFilterItemValueClose":"Value Close","StiFilterItemValueEnd":"Value End","StiFilterItemValueHigh":"Value High","StiFilterItemValueLow":"Value Low","StiFilterItemValueOpen":"Value Open","StiFilterModeAnd":"And","StiFilterModeOr":"Or","StiFontIconGroupAccessibilityIcons":"Accessibility","StiFontIconGroupBrandIcons":"Brand","StiFontIconGroupDirectionalIcons":"Directional","StiFontIconGroupGenderIcons":"Gender","StiFontIconGroupMedicalIcons":"Medical","StiFontIconGroupPaymentIcons":"Payment","StiFontIconGroupSpinnerIcons":"Spinner","StiFontIconGroupTransportationIcons":"Transportation","StiFontIconGroupVideoPlayerIcons":"Video","StiFontIconGroupWebApplicationIcons":"Application","StiFontSizeModeAuto":"Auto","StiFontSizeModeTarget":"Target","StiFontSizeModeValue":"Value","StiFormStartModeOnEnd":"On End","StiFormStartModeOnPreview":"On Preview","StiFormStartModeOnStart":"On Start","StiGaugeCalculationModeAuto":"Auto","StiGaugeCalculationModeCustom":"Custom","StiGaugeRangeModePercentage":"Percentage","StiGaugeRangeModeValue":"Value","StiGaugeRangeTypeColor":"Color","StiGaugeRangeTypeNone":"None","StiGaugeTypeBullet":"Bullet","StiGaugeTypeFullCircular":"Full Circular","StiGaugeTypeHalfCircular":"Half-Circular","StiGaugeTypeHorizontalLinear":"Horizontal Linear","StiGaugeTypeLinear":"Vertical Linear","StiGroupSortDirectionAscending":"Ascending","StiGroupSortDirectionDescending":"Descending","StiGroupSortDirectionNone":"None","StiHorAlignmentCenter":"Center","StiHorAlignmentLeft":"Left","StiHorAlignmentRight":"Right","StiIconAlignmentBottom":"Bottom","StiIconAlignmentLeft":"Left","StiIconAlignmentNone":"None","StiIconAlignmentRight":"Right","StiIconAlignmentTop":"Top","StiImageProcessingDuplicatesTypeGlobalHide":"Global Hide","StiImageProcessingDuplicatesTypeGlobalMerge":"Global Merge","StiImageProcessingDuplicatesTypeGlobalRemoveImage":"Global Remove Image","StiImageProcessingDuplicatesTypeHide":"Hide","StiImageProcessingDuplicatesTypeMerge":"Merge","StiImageProcessingDuplicatesTypeNone":"None","StiImageProcessingDuplicatesTypeRemoveImage":"Remove Image","StiImageRotationFlipHorizontal":"Flip Horizontal","StiImageRotationFlipVertical":"Flip Vertical","StiImageRotationNone":"None","StiImageRotationRotate180":"Rotate 180°","StiImageRotationRotate90CCW":"Rotate 90° CCW","StiImageRotationRotate90CW":"Rotate 90° CW","StiInteractionOnClick":"None","StiInteractionOnClickApplyFilter":"Apply Filter","StiInteractionOnClickDrillDown":"Drill-Down","StiInteractionOnClickOpenHyperlink":"Open Hyperlink","StiInteractionOnClickShowDashboard":"Show Dashboard","StiInteractionOnHoverNone":"None","StiInteractionOnHoverShowHyperlink":"Show Hyperlink","StiInteractionOnHoverShowToolTip":"Show Tool Tip","StiInteractionOpenHyperlinkDestinationCurrentTab":"Current Tab","StiInteractionOpenHyperlinkDestinationNewTab":"New Tab","StiItemOrientationHorizontal":"Horizontal","StiItemOrientationVertical":"Vertical","StiItemSelectionModeMulti":"Multi","StiItemSelectionModeOne":"One","StiKeepDetailsKeepDetailsTogether":"Keep Details Together","StiKeepDetailsKeepFirstDetailTogether":"Keep First Detail Together","StiKeepDetailsKeepFirstRowTogether":"Keep First Row Together","StiKeepDetailsNone":"None","StiLabelPlacementInside":"Inside","StiLabelPlacementOutside":"Outside","StiLabelsPlacementAutoRotation":"Auto Rotation","StiLabelsPlacementNone":"None","StiLabelsPlacementOneLine":"One Line","StiLabelsPlacementTwoLines":"Two Lines","StiLegendDirectionBottomToTop":"Bottom to Top","StiLegendDirectionLeftToRight":"Left to Right","StiLegendDirectionRightToLeft":"Right to Left","StiLegendDirectionTopToBottom":"Top to Bottom","StiLegendHorAlignmentCenter":"Center","StiLegendHorAlignmentLeft":"Left","StiLegendHorAlignmentLeftOutside":"Left Outside","StiLegendHorAlignmentRight":"Right","StiLegendHorAlignmentRightOutside":"Right Outside","StiLegendVertAlignmentBottom":"Bottom","StiLegendVertAlignmentBottomOutside":"Bottom Outside","StiLegendVertAlignmentCenter":"Center","StiLegendVertAlignmentTop":"Top","StiLegendVertAlignmentTopOutside":"Top Outside","StiLineWeightNormal":"Normal","StiLineWeightThick":"Thick","StiLineWeightThin":"Thin","StiMapModeChoropleth":"Choropleth","StiMapModeOnline":"Online","StiMapTypeGroup":"Group","StiMapTypeHeatmap":"Heatmap","StiMapTypeHeatmapWithGroup":"Heatmap With Group","StiMapTypeIndividual":"Individual","StiMapTypeNone":"None","StiMapTypePoints":"Points","StiMarkerAlignmentCenter":"Center","StiMarkerAlignmentLeft":"Left","StiMarkerAlignmentRight":"Right","StiMarkerTypeCircle":"Circle","StiMarkerTypeHalfCircle":"Half Circle","StiMarkerTypeHexagon":"Hexagon","StiMarkerTypeRectangle":"Rectangle","StiMarkerTypeStar5":"Star 5","StiMarkerTypeStar6":"Star 6","StiMarkerTypeStar7":"Star 7","StiMarkerTypeStar8":"Star 8","StiMarkerTypeTriangle":"Triangle","StiNestedFactorHigh":"High","StiNestedFactorLow":"Low","StiNestedFactorNormal":"Normal","StiNumberOfPassDoublePass":"Double Pass","StiNumberOfPassSinglePass":"Single Pass","StiOnlineMapHeatmapColorGradientTypeAddRange":"Add Range","StiOnlineMapHeatmapColorGradientTypeBlackAquaWhite":"Black Aqua White","StiOnlineMapHeatmapColorGradientTypeBlueRed":"Blue Red","StiOnlineMapHeatmapColorGradientTypeColorSpectrum":"Color Spectrum","StiOnlineMapHeatmapColorGradientTypeDeepSea":"Deep Sea","StiOnlineMapHeatmapColorGradientTypeHeatedMetal":"Heated Metal","StiOnlineMapHeatmapColorGradientTypeIncandescent":"Incandescent","StiOnlineMapHeatmapColorGradientTypeSteppedColors":"Stepped Colors","StiOnlineMapHeatmapColorGradientTypeSunrise":"Sunrise","StiOnlineMapHeatmapColorGradientTypeVisibleSpectrum":"Visible Spectrum","StiOnlineMapLocationTypeAdminDivision1":"AdminDivision1","StiOnlineMapLocationTypeAdminDivision2":"AdminDivision2","StiOnlineMapLocationTypeAuto":"Auto","StiOnlineMapLocationTypeCountryRegion":"CountryRegion","StiOnlineMapLocationTypeNeighborhood":"Neighborhood","StiOnlineMapLocationTypePopulatedPlace":"PopulatedPlace","StiOnlineMapLocationTypePostcode1":"Postcode1","StiOnlineMapLocationTypePostcode2":"Postcode2","StiOnlineMapLocationTypePostcode3":"Postcode3","StiOnlineMapLocationTypePostcode4":"Postcode4","StiOrientationHorizontal":"Horizontal","StiOrientationHorizontalRight":"Horizontal Right","StiOrientationVertical":"Vertical","StiPageOrientationLandscape":"Landscape","StiPageOrientationPortrait":"Portrait","StiPenStyleDash":"Dash","StiPenStyleDashDot":"Dash Dot","StiPenStyleDashDotDot":"Dash Dot Dot","StiPenStyleDot":"Dot","StiPenStyleDouble":"Double","StiPenStyleNone":"None","StiPenStyleSolid":"Solid","StiPlacementInside":"Inside","StiPlacementOutside":"Outside","StiPlacementOverlay":"Overlay","StiPlesseyCheckSumModulo10":"Modulo10","StiPlesseyCheckSumModulo11":"Modulo11","StiPlesseyCheckSumNone":"None","StiPreviewModeDotMatrix":"Dot-Matrix","StiPreviewModeStandard":"Standard","StiPreviewModeStandardAndDotMatrix":"Standard and Dot-Matrix","StiPrintOnEvenOddPagesTypeIgnore":"Ignore","StiPrintOnEvenOddPagesTypePrintOnEvenPages":"Print on Even Pages","StiPrintOnEvenOddPagesTypePrintOnOddPages":"Print on Odd Pages","StiPrintOnTypeAllPages":"All Pages","StiPrintOnTypeExceptFirstAndLastPage":"Except First and Last Page","StiPrintOnTypeExceptFirstPage":"Except First Page","StiPrintOnTypeExceptLastPage":"Except Last Page","StiPrintOnTypeOnlyFirstAndLastPage":"Only First and Last Page","StiPrintOnTypeOnlyFirstPage":"Only First Page","StiPrintOnTypeOnlyLastPage":"Only Last Page","StiProcessAtEndOfPage":"End of Page","StiProcessAtEndOfReport":"End of Report","StiProcessAtNone":"None","StiProcessingDuplicatesTypeBasedOnTagHide":"Hide based on Tag","StiProcessingDuplicatesTypeBasedOnTagMerge":"Merge based on Tag","StiProcessingDuplicatesTypeBasedOnTagRemoveText":"Remove Text based on Tag","StiProcessingDuplicatesTypeBasedOnValueAndTagHide":"Hide based on Value and Tag","StiProcessingDuplicatesTypeBasedOnValueAndTagMerge":"Merge based on Value and Tag","StiProcessingDuplicatesTypeBasedOnValueRemoveText":"Remove based on Value Text","StiProcessingDuplicatesTypeGlobalBasedOnValueAndTagHide":"Global Hide based on Value and Tag","StiProcessingDuplicatesTypeGlobalBasedOnValueAndTagMerge":"Global Merge based on Value and Tag","StiProcessingDuplicatesTypeGlobalBasedOnValueRemoveText":"Global Remove based on Value Text","StiProcessingDuplicatesTypeGlobalHide":"Global Hide","StiProcessingDuplicatesTypeGlobalMerge":"Global Merge","StiProcessingDuplicatesTypeGlobalRemoveText":"Global Remove Text","StiProcessingDuplicatesTypeHide":"Hide","StiProcessingDuplicatesTypeMerge":"Merge","StiProcessingDuplicatesTypeNone":"None","StiProcessingDuplicatesTypeRemoveText":"Remove Text","StiProgressElementModeCircle":"Circle","StiProgressElementModeDataBars":"DataBars","StiProgressElementModePie":"Pie","StiQRCodeBodyShapeTypeCircle":"Circle","StiQRCodeBodyShapeTypeCircular":"Circular","StiQRCodeBodyShapeTypeDiamond":"Diamond","StiQRCodeBodyShapeTypeDockedDiamonds":"Docked Diamonds","StiQRCodeBodyShapeTypeDot":"Dot","StiQRCodeBodyShapeTypeRoundedSquare":"Rounded Square","StiQRCodeBodyShapeTypeSquare":"Square","StiQRCodeBodyShapeTypeStar":"Star","StiQRCodeBodyShapeTypeZebraCross":"Zebra Cross","StiQRCodeBodyShapeTypeZebraHorizontal":"Zebra Horizontal","StiQRCodeBodyShapeTypeZebraVertical":"Zebra Vertical","StiQRCodeEyeBallShapeTypeCircle":"Circle","StiQRCodeEyeBallShapeTypeDots":"Dots","StiQRCodeEyeBallShapeTypeRound":"Round","StiQRCodeEyeBallShapeTypeSquare":"Square","StiQRCodeEyeBallShapeTypeStar":"Star","StiQRCodeEyeBallShapeTypeZebraHorizontal":"Zebra Horizontal","StiQRCodeEyeBallShapeTypeZebraVertical":"Zebra Vertical","StiRadarStyleXFCircle":"Circle","StiRadarStyleXFPolygon":"Polygon","StiReportCacheModeAuto":"Auto","StiReportCacheModeOff":"Off","StiReportCacheModeOn":"On","StiReportUnitTypeCentimeters":"Centimeters","StiReportUnitTypeHundredthsOfInch":"Hundredths of Inch","StiReportUnitTypeInches":"Inches","StiReportUnitTypeMillimeters":"Millimeters","StiReportUnitTypePixels":"Pixels","StiRestrictionsAll":"All","StiRestrictionsAllowChange":"Allow Change","StiRestrictionsAllowDelete":"Allow Delete","StiRestrictionsAllowMove":"Allow Move","StiRestrictionsAllowResize":"Allow Resize","StiRestrictionsAllowSelect":"Allow Select","StiRestrictionsNone":"None","StiSelectionModeFirst":"First","StiSelectionModeFromVariable":"From Variable","StiSelectionModeNothing":"Nothing","StiSeriesLabelsValueTypeArgument":"Argument","StiSeriesLabelsValueTypeArgumentValue":"Argument - Value","StiSeriesLabelsValueTypeSeriesTitle":"Series Title","StiSeriesLabelsValueTypeSeriesTitleArgument":"Series Title - Argument","StiSeriesLabelsValueTypeSeriesTitleValue":"Series Title - Value","StiSeriesLabelsValueTypeTag":"Tag","StiSeriesLabelsValueTypeValue":"Value","StiSeriesLabelsValueTypeValueArgument":"Value - Argument","StiSeriesLabelsValueTypeWeight":"Weight","StiSeriesSortDirectionAscending":"Ascending","StiSeriesSortDirectionDescending":"Descending","StiSeriesSortTypeArgument":"Argument","StiSeriesSortTypeNone":"None","StiSeriesSortTypeValue":"Value","StiSeriesXAxisBottomXAxis":"Bottom X Axis","StiSeriesXAxisTopXAxis":"Top X Axis","StiSeriesYAxisLeftYAxis":"Left Y Axis","StiSeriesYAxisRightYAxis":"Right Y Axis","StiShapeDirectionDown":"Down","StiShapeDirectionLeft":"Left","StiShapeDirectionRight":"Right","StiShapeDirectionUp":"Up","StiShiftModeDecreasingSize":"Decreasing Size","StiShiftModeIncreasingSize":"Increasing Size","StiShiftModeNone":"None","StiShiftModeOnlyInWidthOfComponent":"Only in Width of Component","StiShowSeriesLabelsFromChart":"From Chart","StiShowSeriesLabelsFromSeries":"From Series","StiShowSeriesLabelsNone":"None","StiShowXAxisBoth":"Both","StiShowXAxisBottom":"Bottom","StiShowXAxisCenter":"Center","StiShowYAxisBoth":"Both","StiShowYAxisCenter":"Center","StiShowYAxisLeft":"Left","StiSignatureTypeDigitalSignature":"Digital Signature","StiSignatureTypeDraw":"Draw","StiSignatureTypeType":"Type","StiSizeModeAutoSize":"Auto Size","StiSizeModeFit":"Fit","StiSortDirectionAsc":"Ascending","StiSortDirectionDesc":"Descending","StiSortDirectionNone":"None","StiSortTypeByDisplayValue":"by Display Value","StiSortTypeByValue":"by Value","StiSqlSourceTypeStoredProcedure":"Stored Procedure","StiSqlSourceTypeTable":"Query","StiStyleComponentTypeChart":"Chart","StiStyleComponentTypeCheckBox":"Check Box","StiStyleComponentTypeCrossTab":"Cross-Tab","StiStyleComponentTypeImage":"Image","StiStyleComponentTypePrimitive":"Primitive","StiStyleComponentTypeText":"Text","StiStyleConditionTypeComponentName":"Component Name","StiStyleConditionTypeComponentType":"Component Type","StiStyleConditionTypeLocation":"Location","StiStyleConditionTypePlacement":"Placement","StiSummaryValuesAllValues":"All Values","StiSummaryValuesSkipNulls":"Skip Nulls","StiSummaryValuesSkipZerosAndNulls":"Skip Zeros and Nulls","StiTablceCellTypeCheckBox":"CheckBox","StiTablceCellTypeImage":"Image","StiTablceCellTypeRichText":"RichText","StiTablceCellTypeText":"Text","StiTableAutoWidthNone":"None","StiTableAutoWidthPage":"Page","StiTableAutoWidthTable":"Table","StiTableAutoWidthTypeFullTable":"Full Table","StiTableAutoWidthTypeLastColumns":"Last Columns","StiTableAutoWidthTypeNone":"None","StiTargetModePercentage":"Percentage","StiTargetModeVariation":"Variation","StiTextHorAlignmentCenter":"Center","StiTextHorAlignmentLeft":"Left","StiTextHorAlignmentRight":"Right","StiTextHorAlignmentWidth":"Width","StiTextPositionCenterBottom":"Center Bottom","StiTextPositionCenterTop":"Center Top","StiTextPositionLeftBottom":"Left Bottom","StiTextPositionLeftTop":"Left Top","StiTextPositionRightBottom":"Right Bottom","StiTextPositionRightTop":"Right Top","StiTextQualityStandard":"Standard","StiTextQualityTypographic":"Typographic","StiTextQualityWysiwyg":"Wysiwyg","StiTextSizeModeFit":"Fit","StiTextSizeModeTrimming":"Trimming","StiTextSizeModeWordWrap":"Word Wrap","StiTimeDateStepDay":"Day","StiTimeDateStepHour":"Hour","StiTimeDateStepMinute":"Minute","StiTimeDateStepMonth":"Month","StiTimeDateStepNone":"None","StiTimeDateStepSecond":"Second","StiTimeDateStepYear":"Year","StiTitlePositionInside":"Inside","StiTitlePositionOutside":"Outside","StiTopNModeBottom":"Bottom","StiTopNModeNone":"None","StiTopNModeTop":"Top","StiTypeModeList":"List","StiTypeModeNullableValue":"Nullable Value","StiTypeModeRange":"Range","StiTypeModeValue":"Value","StiUnitAlignmentPrefix":"Prefix","StiUnitAlignmentPrefixInside":"Prefix Inside","StiUnitAlignmentPrefixInsideWithSpace":"Prefix Inside with Space","StiUnitAlignmentSuffix":"Suffix","StiUnitAlignmentSuffixInside":"Suffix Inside","StiUnitAlignmentSuffixInsideWithSpace":"Suffix Inside with Space","StiVertAlignmentBottom":"Bottom","StiVertAlignmentCenter":"Center","StiVertAlignmentTop":"Top","StiViewModeNormal":"Normal","StiViewModePageBreakPreview":"Page Break Preview","StiXmlTypeAdoNetXml":"ADO.NET XML","StiXmlTypeXml":"XML","StringAlignmentCenter":"Center","StringAlignmentFar":"Far","StringAlignmentNear":"Near","StringTrimmingCharacter":"Character","StringTrimmingEllipsisCharacter":"Ellipsis Character","StringTrimmingEllipsisPath":"Ellipsis Path","StringTrimmingEllipsisWord":"Ellipsis Word","StringTrimmingNone":"None","StringTrimmingWord":"Word"},"PropertyEvents":{"AfterPrintEvent":"After Print","AfterSelectEvent":"After Select","BeforePrintEvent":"Before Print","BeginRenderEvent":"Begin Render","CheckedChangedEvent":"Checked Changed","ClickEvent":"Click","ClosedFormEvent":"Closed Form","ClosingFormEvent":"Closing Form","ColumnBeginRenderEvent":"Column Begin Render","ColumnEndRenderEvent":"Column End Render","ConnectedEvent":"ConnectedEvent","ConnectingEvent":"ConnectingEvent","DisconnectedEvent":"Disconnected","DisconnectingEvent":"Disconnecting","DoubleClickEvent":"Double Click","EndRenderEvent":"End Render","EnterEvent":"Enter","ExportedEvent":"Exported","ExportingEvent":"Exporting","FillParametersEvent":"Fill Parameters","GetArgumentEvent":"Get Argument","GetBarCodeEvent":"Get BarCode","GetBookmarkEvent":"Get Bookmark","GetCheckedEvent":"Get Checked","GetCollapsedEvent":"Get Collapsed","GetCrossValueEvent":"Get Cross Value","GetCutPieListEvent":"Get Cut Pie List","GetDataUrlEvent":"Get DataUrl","GetDisplayCrossValueEvent":"Get Display Cross Value","GetDrillDownReportEvent":"Get Drill-Down Report","GetExcelSheetEvent":"Get Excel Sheet","GetExcelValueEvent":"Get Excel Value","GetHyperlinkEvent":"Get Hyperlink","GetImageDataEvent":"Get Image Data","GetImageURLEvent":"Get Image URL","GetListOfArgumentsEvent":"Get List of Arguments","GetListOfHyperlinksEvent":"Get List of Hyperlinks","GetListOfTagsEvent":"Get List of Tags","GetListOfToolTipsEvent":"Get List of Tool Tips","GetListOfValuesEndEvent":"Get List of Values End","GetListOfValuesEvent":"Get List of Values","GetListOfWeights":"Get List of Weights","GetListOfWeightsEvent":"Get List of Weights","GetPointerEvent":"Get Pointer","GetSummaryExpressionEvent":"Get Summary Expression","GetTagEvent":"Get Tag","GetTitleEvent":"Get Title","GetToolTipEvent":"Get Tool Tip","GetValueEndEvent":"Get Value End","GetValueEvent":"Get Value","GetWeightEvent":"Get Weight","LeaveEvent":"Leave","LoadFormEvent":"Load Form","MouseDownEvent":"Mouse Down","MouseEnterEvent":"Mouse Enter","MouseLeaveEvent":"Mouse Leave","MouseMoveEvent":"Mouse Move","MouseUpEvent":"Mouse Up","NewAutoSeriesEvent":"New Auto Series","PositionChangedEvent":"Position Changed","PrintedEvent":"Printed","PrintingEvent":"Printing","ProcessCellEvent":"Process Cell","ProcessChartEvent":"Process Chart","RenderingEvent":"Rendering","ReportCacheProcessingEvent":"Report Cache Processing","SelectedIndexChangedEvent":"Selected Index Changed","StateRestoreEvent":"State Restore","StateSaveEvent":"State Save","ValueChangedEvent":"Value Changed"},"PropertyHatchStyle":{"BackwardDiagonal":"Backward Diagonal","Cross":"Cross","DarkDownwardDiagonal":"Dark Downward Diagonal","DarkHorizontal":"Dark Horizontal","DarkUpwardDiagonal":"Dark Upward Diagonal","DarkVertical":"Dark Vertical","DashedDownwardDiagonal":"Dashed Downward Diagonal","DashedHorizontal":"Dashed Horizontal","DashedUpwardDiagonal":"Dashed Upward Diagonal","DashedVertical":"Dashed Vertical","DiagonalBrick":"Diagonal Brick","DiagonalCross":"Diagonal Cross","Divot":"Divot","DottedDiamond":"Dotted Diamond","DottedGrid":"Dotted Grid","ForwardDiagonal":"Forward Diagonal","Horizontal":"Horizontal","HorizontalBrick":"Horizontal Brick","LargeCheckerBoard":"Large Checker Board","LargeConfetti":"Large Confetti","LargeGrid":"Large Grid","LightDownwardDiagonal":"Light Downward Diagonal","LightHorizontal":"Light Horizontal","LightUpwardDiagonal":"Light Upward Diagonal","LightVertical":"Light Vertical","NarrowHorizontal":"Narrow Horizontal","NarrowVertical":"Narrow Vertical","OutlinedDiamond":"Outlined Diamond","Percent05":"Percent05","Percent10":"Percent10","Percent20":"Percent20","Percent25":"Percent25","Percent30":"Percent30","Percent40":"Percent40","Percent50":"Percent50","Percent60":"Percent60","Percent70":"Percent70","Percent75":"Percent75","Percent80":"Percent80","Percent90":"Percent90","Plaid":"Plaid","Shingle":"Shingle","SmallCheckerBoard":"Small Checker Board","SmallConfetti":"Small Confetti","SmallGrid":"Small Grid","SolidDiamond":"Solid Diamond","Sphere":"Sphere","Trellis":"Trellis","Vertical":"Vertical","Wave":"Wave","Weave":"Weave","WideDownwardDiagonal":"Wide Downward Diagonal","WideUpwardDiagonal":"Wide Upward Diagonal","ZigZag":"Zig Zag"},"PropertyMain":{"AcceptsReturn":"Accepts Return","AcceptsTab":"Accepts Tab","Actual":"Actual","AddClearZone":"Add Clear Zone","Advanced":"Advanced","AggregateFunction":"Aggregate Function","AggregateFunctions":"Aggregate Functions","Alias":"Alias","Alignment":"Alignment","AllowApplyBorderColor":"Allow Apply Border Color","AllowApplyBrush":"Allow Apply Brush","AllowApplyBrushNegative":"Allow Apply Brush Negative","AllowApplyColorNegative":"Allow Apply Color Negative","AllowApplyLineColor":"Allow Apply Line Color","AllowApplyStyle":"Allow Apply Style","AllowExpressions":"Allow Expressions","AllowHtmlTags":"Allow HTML Tags","AllowNull":"Allow Null","AllowSeries":"Allow Series","AllowSeriesElements":"Allow Series Elements","AllowSorting":"Allow Sorting","AllowUseBackColor":"Allow Use Back Color","AllowUseBorder":"Allow Use Border","AllowUseBorderFormatting":"Allow Use Border Formatting","AllowUseBorderSides":"Allow Use Border Sides","AllowUseBorderSidesFromLocation":"Allow Use Border Sides from Location","AllowUseBrush":"Allow Use Brush","AllowUseFont":"Allow Use Font","AllowUseForeColor":"Allow Use Fore Color","AllowUseHorAlignment":"Allow Use Hor Alignment","AllowUseImage":"Allow Use Image","AllowUseNegativeTextBrush":"Allow Use Negative Text Brush","AllowUserValues":"Allow User Values","AllowUseTextBrush":"Allow Use Text Brush","AllowUseTextFormat":"Allow Use Text Format","AllowUseTextOptions":"Allow Use Text Options","AllowUseVertAlignment":"Allow Use Vert Alignment","AllowUsingAsSqlParameter":"Allow using as SQL parameter","AlternatingBackColor":"Alternating Back Color","AlternatingCellBackColor":"Alternating Cell Back Color","AlternatingCellForeColor":"Alternating Cell Fore Color","AlternatingDataColor":"Alternating Data Color","AlternatingDataForeground":"Alternating Data Foreground","Always":"Always","Anchor":"Anchor","Angle":"Angle","Antialiasing":"Antialiasing","Apply":"Apply","Area":"Area","Argument":"Argument","ArgumentDataColumn":"Argument Data Column","ArgumentFormat":"Argument Format","Arguments":"Arguments","ArrowHeight":"Arrow Height","ArrowStyle":"Arrow Style","ArrowWidth":"Arrow Width","AspectRatio":"Aspect Ratio","Author":"Author","Auto":"Auto","AutoCalculateCenterPoint":"Auto Calculate Center Point","AutoDataColumns":"Auto Data Columns","AutoDataRows":"Auto Data Rows","AutoLocalizeReportOnRun":"Auto Localize Report on Run","AutoRefresh":"Auto Refresh","AutoRotate":"Auto Rotate","AutoScale":"Auto Scale","AutoSeriesColorDataColumn":"Auto Series Color Data Column","AutoSeriesKeyDataColumn":"Auto Series Key Data Column","AutoSeriesTitleDataColumn":"Auto Series Title Data Column","AutoWidth":"Auto Width","AutoWidthType":"Auto Width Type","AvailableInTheViewer":"Available in the Viewer","AxisLabelsColor":"Axis Labels Color","AxisLineColor":"Axis Line Color","AxisTitleColor":"Axis Title Color","AxisValue":"Axis Value","BackColor":"Back Color","Background":"Background","BackgroundColor":"Background Color","BandColor":"Band Color","BarCodeType":"Bar Code Type","BasicStyleColor":"Basic Style Color","Blend":"Blend","Blocks":"Blocks","BodyBrush":"Body Brush","BodyShape":"Body Shape","Bold":"Bold","Bookmark":"Bookmark","Border":"Border","BorderBrush":"Border Brush","BorderColor":"Border Color","BorderColorNegative":"Border Color Negative","Borders":"Borders","BorderSize":"Border Size","BorderStyle":"Border Style","BorderThickness":"Border Thickness","BorderWidth":"Border Width","Bottom":"Bottom","BottomLeft":"Bottom-Left","BottomRight":"Bottom-Right","BottomSide":"Bottom Side","BreakIfLessThan":"Break if Less Than","Brush":"Brush","BrushNegative":"Brush Negative","BrushType":"Brush Type","BubbleBackColor":"Bubble Back Color","BubbleBorderColor":"Bubble Border Color","BusinessObject":"Business Object","CacheAllData":"Cache All Data","CacheTotals":"Cache Totals","CalcInvisible":"Calc Invisible","CalculatedDataColumn":"Calculated Data Column","CalculationMode":"Calculation Mode","CanBreak":"Can Break","Cancel":"Cancel","CanGrow":"Can Grow","CanShrink":"Can Shrink","Categories":"Categories","Category":"Category","CategoryConnections":"Connections","CellAlignment":"Cell Alignment","CellBackColor":"Cell Back Color","CellDockStyle":"Cell Dock Style","CellForeColor":"Cell Fore Color","CellHeight":"Cell Height","CellType":"Cell Type","CellWidth":"Cell Width","Center":"Center","CenterPoint":"Center Point","ChartAreaBorderColor":"Chart Area Border Color","ChartAreaBrush":"Chart Area Brush","ChartAreaShowShadow":"Chart Area Show Shadow","ChartType":"Chart Type","CheckAlignment":"Check Alignment","CheckColor":"Check Color","Checked":"Checked","CheckedIcon":"Checked Icon","CheckOnClick":"Check on Click","CheckStyle":"Check Style","CheckStyleForFalse":"Check Style for False","CheckStyleForTrue":"Check Style for True","Checksum":"Checksum","CheckSum":"CheckSum","CheckSum1":"CheckSum1","CheckSum2":"CheckSum2","Child":"Child","ChildColumns":"Child Columns","ChildSource":"Child Source","City":"City","ClearFormat":"Clear Format","CloneContainer":"Clone Container","CloseValues":"Close Values","Code":"Code","CodePage":"Code Page","Collapsed":"Collapsed","CollapseGroupFooter":"Collapse Group Footer","CollapsingEnabled":"Collapsing Enabled","Collate":"Collate","CollectionName":"Collection Name","Color":"Color","ColorDataColumn":"Color Data Column","ColorEach":"Color Each","ColorMeter":"Color Meter","Colors":"Colors","ColorScaleCondition":"Color Scale Condition","ColorScaleType":"Color Scale Type","Column":"Column","ColumnCount":"Column Count","ColumnDirection":"Column Direction","ColumnGaps":"Column Gaps","ColumnHeaderBackColor":"Column Header Back Color","ColumnHeaderForeColor":"Column Header Fore Color","ColumnHeadersVisible":"Column Headers Visible","Columns":"Columns","ColumnShape":"Column Shape","ColumnWidth":"Column Width","CommandTimeout":"Command Timeout","CompanyPrefix":"Company Prefix","ComponentStyle":"Component Style","Condition":"Condition","ConditionOptions":"Condition Options","Conditions":"Conditions","ConnectionString":"Connection String","ConnectOnStart":"Connect on Start","ConstantLines":"Constant Lines","Container":"Container","ContentAlignment":"Content Alignment","ContinuousText":"Continuous Text","ContourColor":"Contour Color","Converting":"Converting","ConvertNulls":"Convert Nulls","Copies":"Copies","CornerRadius":"Corner Radius","Count":"Count","CountData":"Count Data","Country":"Country","Create":"Create","CreateFieldOnDoubleClick":"Create Field on Double Click","CreateLabel":"Create Label","CrossFiltering":"Cross-Filtering","Culture":"Culture","CustomFonts":"Custom Fonts","CustomFormat":"Custom Format","CutPieList":"Cut Pie List","Data":"Data","DataAdapter":"Data Adapter","DataAdapters":"Data Adapters","DataBarCondition":"Data Bar Condition","DataBindings":"Data Bindings","DataCells":"Data Cells","DataColor":"Data Color","DataColumn":"Data Column","DataColumns":"Data Columns","DataField":"Data Field","DataForeground":"Data Foreground","DataRelation":"Data Relation","DataRows":"Data Rows","DataSource":"Data Source","DataSources":"Data Sources","DataTextField":"Data Text Field","DataTransformation":"Data Transformation","DataType":"Data Type","DataUrl":"Data URL","DateInfo":"Date Info","DateTimeMode":"DateTime Mode","DateTimeStep":"Date Time Step","Default":"Default","DefaultColor":"Default Color","DefaultHeightCell":"Default Height of Cell","DefaultNamespace":"Default Namespace","DependentColumn":"Dependent Column","DependentValue":"Dependent Value","Description":"Description","Destination":"Destination","DetectUrls":"Detect URLs","DeviceWidth":"Device Width","DialogResult":"Dialog Result","Diameter":"Diameter","Direction":"Direction","Disabled":"Disabled","DisplayNameType":"Display Name Type","DisplayValue":"Display Value","Distance":"Distance","DistanceBetweenTabs":"Distance Between Tabs","Dock":"Dock","DockableTable":"Dockable Table","DockStyle":"Dock Style","DrawBorder":"Draw Border","DrawHatch":"Draw Hatch","DrawLine":"Draw Line","DrillDown":"Drill-Down","DrillDownEnabled":"Drill-Down Enabled","DrillDownMode":"Drill-Down Mode","DrillDownPage":"Drill-Down Page","DrillDownParameter1":"Drill-Down Parameter 1","DrillDownParameter2":"Drill-Down Parameter 2","DrillDownParameter3":"Drill-Down Parameter 3","DrillDownParameter4":"Drill-Down Parameter 4","DrillDownParameter5":"Drill-Down Parameter 5","DrillDownParameters":"Drill-Down Parameters","DrillDownReport":"Drill-Down Report","DropDownAlign":"Drop Down Align","DropDownStyle":"Drop Down Style","DropDownWidth":"Drop Down Width","DropShadow":"Drop Shadow","Duplex":"Duplex","Editable":"Editable","Effects":"Effects","EmptyBorderBrush":"Empty Border Brush","EmptyBorderWidth":"Empty Border Width","EmptyBrush":"Empty Brush","EmptyValue":"Empty Value","Enabled":"Enabled","EnableLog":"Enabled Log","EncodingMode":"Encoding Mode","EncodingType":"Encoding Type","EndCap":"End Cap","EndColor":"End Color","EndValue":"End Value","EndValues":"End Values","EndWidth":"End Width","EngineVersion":"Engine Version","EnumeratorSeparator":"Enumerator Separator","EnumeratorType":"Enumerator Type","ErrorCorrectionLevel":"Error Correction Level","ErrorsCorrectionLevel":"Errors Correction Level","EvenStyle":"Even Style","ExceedMargins":"Exceed Margins","ExcelSheet":"Excel Sheet","ExcelValue":"Excel Value","Expand":"Expand","Exponential":"Exponential","ExportAsImage":"Export as Image","Expression":"Expression","ExtensionDigit":"Extension Digit","EyeBallBrush":"Eye Ball Brush","EyeBallShape":"Eye Ball Shape","EyeFrameBrush":"Eye Frame Brush","EyeFrameShape":"Eye Frame Shape","FaqPage":"FAQ Page","Field":"Field","FieldIs":"Field Is","Fifth":"Fifth","File":"File","Fill":"Fill","FillColor":"Fill Color","Filter":"Filter","FilterElements":"Filter Elements","FilterEngine":"Filter Engine","FilterMode":"Filter Mode","FilterOn":"Filter On","Filters":"Filters","First":"First","FirstTabOffset":"First Tab Offset","FixedWidth":"Fixed Width","Flat":"Flat","FlatMode":"Flat Mode","Focus":"Focus","Font":"Font","FontBold":"Font Bold","FontItalic":"Font Italic","FontName":"Font Name","FontSize":"Font Size","FontSizeMode":"Font Size Mode","FontStrikeout":"Font Strikeout","FontSubscript":"Subscript","FontSuperscript":"Superscript","FontUnderline":"Font Underline","FontUnit":"Font Unit","FooterCanBreak":"Footer Can Break","FooterCanGrow":"Footer Can Grow","FooterCanShrink":"Footer Can Shrink","FooterColor":"Footer Color","FooterFont":"Footer Font","FooterForeColor":"Footer Fore Color","FooterForeground":"Footer Foreground","FooterPrintAtBottom":"Footer Print At Bottom","FooterPrintIfEmpty":"Footer Print If Empty","FooterPrintOn":"Footer Print On","FooterPrintOnAllPages":"Footer Print On All Pages","FooterPrintOnEvenOddPages":"Footer Print On Even Odd Pages","FooterRowsCount":"Footer Rows Count","Footers":"Footers","ForeColor":"Fore Color","Format":"Format","FormSettings":"Form Settings","Fourth":"Fourth","From":"From","FrozenColumns":"Frozen Columns","FullConvertExpression":"Full Convert Expression","FullName":"Full Name","Function":"Function","Functions":"Functions","GisSettings":"Gis Settings","GlobalizationStrings":"Globalization Strings","GlobalizedName":"Globalized Name","GlyphColor":"Glyph Color","GridColor":"Grid Color","GridColumns":"Grid Columns","GridLineColor":"Grid Line Color","GridLinesHor":"Grid Lines Horizontal","GridLinesHorColor":"Grid Lines Horizontal Color","GridLinesHorRight":"Grid Lines Horizontal Right","GridLineStyle":"Grid Line Style","GridLinesVert":"Grid Lines Vertical","GridLinesVertColor":"Grid Lines Vertical Color","GridOutline":"Grid Outline","GridVerticalStep":"Grid Vertical Step","Group":"Group","GroupDataColumn":"Group Data Column","GroupMeter":"Group Meter","GrowToHeight":"Grow to Height","Header":"Header","HeaderAlignment":"Header Alignment","HeaderBackColor":"Header Back Color","HeaderCanBreak":"Header Can Break","HeaderCanGrow":"Header Can Grow","HeaderCanShrink":"Header Can Shrink","HeaderColor":"Header Color","HeaderFont":"Header Font","HeaderForeColor":"Header Fore Color","HeaderForeground":"Header Foreground","HeaderPrintAtBottom":"Header Print At Bottom","HeaderPrintIfEmpty":"Header Print If Empty","HeaderPrintOn":"Header Print On","HeaderPrintOnAllPages":"Header Print On All Pages","HeaderPrintOnEvenOddPages":"Header Print On Even Odd Pages","HeaderRowsCount":"Header Rows Count","Headers":"Headers","HeaderText":"Header Text","Heading":"Heading","Heatmap":"Heatmap","HeatmapColors":"Heatmap Colors","HeatmapWithGroup":"Heatmap With Group","Height":"Height","HideSeriesWithEmptyTitle":"Hide Series with Empty Title","HideZeros":"Hide Zeros","High":"High","HighlightCondition":"Highlight Condition","HighValues":"High Values","HorAlignment":"Horizontal Alignment","HorSpacing":"Horizontal Spacing","HotBackColor":"Hot Back Color","HotColumnHeaderBackColor":"Hot Column Header Back Color","HotForeColor":"Hot Fore Color","HotGlyphColor":"Hot Glyph Color","HotHeaderColor":"Hot Header Color","HotkeyPrefix":"Hotkey Prefix","HotRowHeaderBackColor":"Hot Row Header Back Color","HotSelectedBackColor":"Hot Selected Back Color","HotSelectedForeColor":"Hot Selected Fore Color","HotSelectedGlyphColor":"Hot Selected Glyph Color","HtmlPreviewMode":"HTML Preview Mode","HtmlTags":"HTML Tags","Hyperlink":"Hyperlink","HyperlinkDataColumn":"Hyperlink Data Column","HyperlinkPattern":"Hyperlink Pattern","Icon":"Icon","IconAlignment":"Icon Alignment","IconBrush":"Icon Brush","IconColor":"Icon Color","IconSet":"Icon Set","IconSetCondition":"Icon Set Condition","Idents":"Indents","Image":"Image","ImageAlign":"Image Align","ImageAlignment":"Image Alignment","ImageData":"Image Data","ImageHorAlignment":"Image Horizontal Alignment","ImageMultipleFactor":"Image Multiple Factor","ImageRotation":"Image Rotation","ImageStretch":"Image Stretch","ImageTiling":"Image Tiling","ImageTransparency":"Image Transparency","ImageURL":"Image URL","ImageVertAlignment":"Image Vertical Alignment","ImportRelations":"Import Relations","Increment":"Increment","Indent":"Indent","IndividualColor":"Individual Color","InitBy":"Init by","Initials":"Initials","InitialSelection":"Initial Selection","InitialSelectionSource":"Initial Selection Source","InnerText":"Inner Text","Insert":"Insert","Interaction":"Interaction","InterlacedBrush":"Interlaced Brush","InterlacingHor":"Interlacing Horizontal","InterlacingHorBrush":"Interlacing Horizontal Brush","InterlacingVert":"Interlacing Vertical","InterlacingVertBrush":"Interlacing Vertical Brush","Interpolation":"Interpolation","IsReversed":"Is Reversed","Italic":"Italic","Item":"Item","ItemHeight":"Item Height","Items":"Items","KeepChildTogether":"Keep Child Together","KeepCrossTabTogether":"Keep Cross-Tab Together","KeepDetails":"Keep Details","KeepDetailsTogether":"Keep Details Together","KeepFooterTogether":"Keep Footer Together","KeepGroupFooterTogether":"Keep Group Footer Together","KeepGroupHeaderTogether":"Keep Group Header Together","KeepGroupTogether":"Keep Group Together","KeepHeaderTogether":"Keep Header Together","KeepMergedCellsTogether":"Keep Merged Cells Together","KeepReportSummaryTogether":"Keep Report Summary Together","KeepSubReportTogether":"Keep Sub-Report Together","Key":"Key","KeyDataColumn":"Key Data Column","KeyMeter":"Key Meter","KeyMeters":"Key Meters","Keys":"Keys","Label":"Label","LabelColor":"Label Color","LabelForeground":"Label Foreground","LabelRotationMode":"Label Rotation Mode","Labels":"Labels","LabelsColor":"Labels Color","LabelShadowForeground":"Label Shadow Foreground","LabelsOffset":"Labels Offset","Language":"Language","LargeHeight":"Large Height","LargeHeightFactor":"Large Height Factor","LaTexExpression":"LaTex Expression","Latitude":"Latitude","Layout":"Layout","Left":"Left","LeftSide":"Left Side","Legend":"Legend","LegendBorderColor":"Legend Border Color","LegendBrush":"Legend Brush","LegendLabelsColor":"Legend Labels Color","LegendTitleColor":"Legend Title Color","LegendValueType":"Legend Value Type","Length":"Length","LengthUnderLabels":"Length under Labels","Lighting":"Lighting","LimitRows":"Limit Rows","Linear":"Linear","LinearBarBorderBrush":"Linear Bar Border Brush","LinearBarBrush":"Linear Bar Brush","LinearBarEmptyBorderBrush":"Linear Bar Empty Border Brush","LinearBarEmptyBrush":"Linear Bar Empty Brush","LinearScaleBrush":"Linear Scale Brush","LineColor":"Line Color","LineColorNegative":"Line Color Negative","LineLength":"Line Length","LineLimit":"Line Limit","LineMarker":"Line Marker","LinesOfUnderline":"Lines of Underline","LineSpacing":"Line Spacing","LineStyle":"Line Style","LineWidth":"Line Width","Linked":"Linked","ListOfArguments":"List of Arguments","ListOfHyperlinks":"List of Hyperlinks","ListOfTags":"List of Tags","ListOfToolTips":"List of Tooltips","ListOfValues":"List of Values","ListOfValuesClose":"List of Values Close","ListOfValuesEnd":"List of Values End","ListOfValuesHigh":"List of Values High","ListOfValuesLow":"List of Values Low","ListOfValuesOpen":"List of Values Open","ListOfWeights":"List of Weights","Localizable":"Localizable","Location":"Location","Locked":"Locked","Logarithmic":"Logarithmic","LogarithmicScale":"Logarithmic Scale","Longitude":"Longitude","Low":"Low","LowValues":"Low Values","MajorInterval":"Major Interval","MapAfrica":"Africa","MapAsia":"Asia","MapCustom":"Custom","MapEurope":"Europe","MapID":"Map ID","MapNorthAmerica":"North America","MapOceania":"Oceania","MapPopularMaps":"Popular maps","Maps":"Maps","MapSouthAmerica":"South America","MapStyle":"Map Style","MapType":"Map Type","Margin":"Margin","Margins":"Margins","Marker":"Marker","MarkerAlignment":"Marker Alignment","MarkerAngle":"Marker Angle","MarkerBorder":"Marker Border","MarkerBrush":"Marker Brush","MarkerColor":"Marker Color","MarkerSize":"Marker Size","MarkerType":"Marker Type","MarkerVisible":"Marker Visible","MasterComponent":"Master Component","MasterKeyDataColumn":"Master Key Data Column","MatrixSize":"Matrix Size","MaxDate":"Max Date","MaxDropDownItems":"Max Drop Down Items","MaxHeight":"Max Height","Maximum":"Maximum","MaximumValue":"Maximum Value","MaxLength":"Max Length","MaxNumberOfLines":"Max Number of Lines","MaxSize":"Max Size","MaxValue":"Max Value","MaxWidth":"Max Width","MergeDuplicates":"Merge Duplicates","MergeHeaders":"Merge Headers","Mid":"Mid","MinDate":"Min Date","MinHeight":"Min Height","Minimum":"Minimum","MinimumFontSize":"Minimum Font Size","MinimumValue":"Minimum Value","MinorColor":"Minor Color","MinorCount":"Minor Count","MinorInterval":"Minor Interval","MinorLength":"Minor Length","MinorStyle":"Minor Style","MinorVisible":"Minor Visible","MinRowsInColumn":"Min Rows in Column","MinSize":"Min Size","MinValue":"Min Value","MinWidth":"Min Width","MirrorMargins":"Mirror Margins","Mode":"Mode","Module":"Module","Move":"Move","Multiline":"Multiline","MultipleFactor":"Multiple Factor","MultipleInitialization":"Multiple Initialization","Name":"Name","NameDataColumn":"Name Data Column","NameInSource":"Name in Source","NameMeter":"Name Meter","NameParent":"Parent Name","Namespaces":"Namespaces","NeedleBorderBrush":"Needle Border Brush","NeedleBorderWidth":"Needle Border Width","NeedleBrush":"Needle Brush","NeedleCapBorderBrush":"Needle Cap Border Brush","NeedleCapBrush":"Needle Cap Brush","Negative":"Negative","NegativeColor":"Negative Color","NegativeSeriesColors":"Negative Series Colors","NegativeTextBrush":"Negative Text Brush","NestedLevel":"Nested Level","NewColumnAfter":"New Column After","NewColumnBefore":"New Column Before","NewPageAfter":"New Page After","NewPageBefore":"New Page Before","NextPage":"Next Page","NoElements":"No Elements","NoIcon":"No Icon","NullText":"Null Text","NumberOfColumns":"Number of Columns","NumberOfCopies":"Number of Copies","NumberOfPass":"Number of Pass","NumberOfValues":"Number of Values","OddStyle":"Odd Style","Offset":"Offset","OffsetAngle":"Offset Angle","OnClick":"On Click","OnDataManipulation":"On Data Manipulation","OnHover":"On Hover","OnlyText":"Only Text","Opacity":"Opacity","OpenValues":"Open Values","Operation":"Operation","Options":"Options","Options3D":"Options 3D","Orientation":"Orientation","OthersText":"Others Text","Padding":"Padding","PageHeight":"Page Height","PageNumbers":"Page Numbers","PageWidth":"Page Width","Paper":"Paper","PaperSize":"Paper Size","PaperSourceOfFirstPage":"Paper Source of First Page","PaperSourceOfOtherPages":"Paper Source of Other Pages","Parameter":"Parameter","Parameters":"Parameters","ParametersDateFormat":"Parameters Date Format","ParametersOrientation":"Parameters Orientation","ParameterWidth":"Parameter Width","ParentColumns":"Parent Columns","ParentSource":"Parent Data Source","ParentValue":"Parent Value","ParetoSeriesColors":"Pareto Series Colors","PasswordChar":"Password Char","Path":"Path","PathData":"Path Data","PathSchema":"Path Schema","Pattern":"Pattern","PDFPreview":"PDF Preview","PenColor":"Pen Color","Placeholder":"Placeholder","Placement":"Placement","PlaceOnToolbox":"Place on Toolbox","PointAtCenter":"Point at Center","Position":"Position","Positive":"Positive","PositiveColor":"Positive Color","PreferredColumnWidth":"Preferred Column Width","PreferredRowHeight":"Preferred Row Height","PreventIntersection":"Prevent Intersection","PreviewMode":"Preview Mode","PreviewSettings":"Preview Settings","Printable":"Printable","PrintAtBottom":"Print at Bottom","PrinterName":"Printer Name","PrinterSettings":"Printer Settings","PrintHeadersFootersFromPreviousPage":"Print Headers and Footers from Previous Page","PrintIfDetailEmpty":"Print if Detail Empty","PrintIfEmpty":"Print if Empty","PrintIfParentDisabled":"Print if Parent Disabled","PrintOn":"Print on","PrintOnAllPages":"Print on All Pages","PrintOnEvenOddPages":"Print on Even Odd Pages","PrintOnPreviousPage":"Print on Previous Page","PrintTitleOnAllPages":"Print Title On All Pages","PrintVerticalBars":"Print Vertical Bars","ProcessAt":"Process at","ProcessAtEnd":"Process at End","ProcessingDuplicates":"Processing Duplicates","ProcessTilde":"Process Tilde","ProductHomePage":"Product Home Page","Property":"Property","Provider":"Provider","RadarStyle":"Radar Style","RadialBarBorderBrush":"Radial Bar Border Brush","RadialBarBrush":"Radial Bar Brush","RadialBarEmptyBorderBrush":"Radial Bar Empty Border Brush","RadialBarEmptyBrush":"Radial Bar Empty Brush","Radius":"Radius","RadiusMode":"Radius Mode","Range":"Range","RangeColorMode":"Range Color Mode","RangeFrom":"From","RangeMode":"Range Mode","RangeScrollEnabled":"Range Scroll Enabled","RangeTo":"To","RangeType":"Range Type","Ratio":"Ratio","RatioY":"Ratio Y","ReadOnly":"Read Only","RecentFonts":"Recent Fonts","ReconnectOnEachRow":"Reconnect on Each Row","ReferencedAssemblies":"Referenced Assemblies","Refresh":"Refresh","RefreshTime":"Refresh Time","Regular":"Regular","Relation":"Relation","RelationName":"Relation Name","Relations":"Relations","RelativeHeight":"Relative Height","RelativeWidth":"Relative Width","RemoveUnusedDataBeforeStart":"Remove Unused Data Before Start","RenderTo":"Render to","ReportAlias":"Report Alias","ReportAuthor":"Report Author","ReportCacheMode":"Report Cache Mode","ReportDescription":"Report Description","ReportIcon":"Report Icon","ReportImage":"Report Image","ReportName":"Report Name","ReportUnit":"Report Unit","RequestFromUser":"Request from User","RequestParameters":"Request Parameters","Required":"Required","ResetAllFilters":"Reset All Filters","ResetDataSource":"Reset Data Source","ResetPageNumber":"Reset Page Number","Resize":"Resize","Resource":"Resource","Resources":"Resources","Restrictions":"Restrictions","RetrieveOnlyUsedData":"Retrieve Only Used Data","ReturnValue":"Return Value","ReverseHor":"Reverse Horizontal","ReverseVert":"Reverse Vertical","Right":"Right","RightSide":"Right Side","RightToLeft":"Right to Left","Rotation":"Rotation","RotationLabels":"Rotation Labels","RotationMode":"Rotation Mode","Round":"Round","RoundValues":"Round Values","RowCount":"Row Count","RowHeaderBackColor":"Row Header Back Color","RowHeaderForeColor":"Row Header Fore Color","RowHeadersVisible":"Row Headers Visible","RowHeaderWidth":"Row Header Width","Rows":"Rows","Scale":"Scale","ScaleHor":"Scale Hor","ScriptLanguage":"Script Language","Second":"Second","SegmentPerHeight":"Segment per Height","SegmentPerWidth":"Segment per Width","SelectedBackColor":"Selected Back Color","SelectedCellBackColor":"Selected Cell Back Color","SelectedCellForeColor":"Selected Cell Fore Color","SelectedDataColor":"Selected Data Color","SelectedDataForeground":"Selected Data Foreground","SelectedForeColor":"Selected Fore Color","SelectedGlyphColor":"Selected Glyph Color","SelectedIndex":"Selected Index","SelectedItem":"Selected Item","SelectedKey":"Selected Key","SelectedValue":"Selected Value","Selection":"Selection","SelectionBackColor":"Selection Back Color","SelectionEnabled":"Selection Enabled","SelectionForeColor":"Selection Fore Color","SelectionMode":"Selection Mode","SelectStyle":"Select Style","SendType":"Send Type","SeparatorColor":"Separator Color","SerialNumber":"Serial Number","Series":"Series","SeriesBorderThickness":"Series Border Thickness","SeriesColors":"Series Colors","SeriesCornerRadius":"Series Corner Radius","SeriesLabels":"Series Labels","SeriesLabelsBorderColor":"Series Labels Border Color","SeriesLabelsBrush":"Series Labels Brush","SeriesLabelsColor":"Series Labels Color","SeriesLabelsLineColor":"Series Labels Line Color","SeriesLighting":"Series Lighting","SeriesShowBorder":"Series Show Border","SeriesShowShadow":"Series Show Shadow","SeriesTitle":"Series Title","Shadow":"Shadow","ShadowBrush":"Shadow Brush","ShadowColor":"Shadow Color","ShadowSize":"Shadow Size","ShapeType":"Shape Type","Shift":"Shift","ShiftMode":"Shift Mode","ShortName":"Short Name","ShortValue":"Short Value","ShowAllValue":"Show All Value","ShowBehind":"Show Behind","ShowBubble":"Show Bubble","ShowDialog":"Show Dialog","ShowEdgeValues":"Show Edge Values","ShowHyperlink":"Show Hyperlink","ShowImageBehind":"Show Image Behind","ShowInLegend":"Show in Legend","ShowInnerPoints":"Show Inner Points","ShowInPercent":"Show in Percent","ShowLabel":"Show Label","ShowLabels":"Show Labels","ShowLabelText":"Show Label Text","ShowLegend":"Show Legend","ShowMarker":"Show Marker","ShowMeanMarkers":"Show Mean Markers","ShowNulls":"Show Nulls","ShowOthers":"Show Others","ShowPercents":"Show Percents","ShowPlacemark":"Show Placemark","ShowQuietZoneIndicator":"Show Quiet Zone Indicator","ShowQuietZones":"Show Quiet Zones","ShowScrollBar":"Show Scroll Bar","ShowSelectAll":"Show Select All","ShowSeriesLabels":"Show Series Labels","ShowShadow":"Show Shadow","ShowTotal":"Show Total","ShowTotalSummary":"Show Total Summary","ShowUpDown":"Show Up Down","ShowValue":"Show Value","ShowXAxis":"Show X Axis","ShowYAxis":"Show Y Axis","ShowZeros":"Show Zeros","ShrinkFontToFit":"Shrink Font to Fit","ShrinkFontToFitMinimumSize":"Shrink Font to Fit Minimum Size","Side":"Side","SideBySide":"Side-by-Side","Sides":"Sides","SignatureType":"Type","Simple":"Simple","Size":"Size","SizeMode":"Size Mode","Skin":"Skin","SkipFirst":"Skip First","SkipIndices":"Skip Indices","SkipIndicesObj":"Skip Indices","SkipMajorValues":"Skip Major Values","SkipValues":"Skip Values","SkipValuesObj":"Skip Values","Smoothing":"Smoothing","Sort":"Sort","SortBy":"Sort by","SortDirection":"Sort Direction","Sorted":"Sorted","SortingColumn":"Sorting Column","SortingEnabled":"Sorting Enabled","SortLetters":"A-Z","SortType":"Sort Type","Space":"Space","SpaceRatio":"Space Ratio","Spacing":"Spacing","SqlCommand":"Sql Command","StartAngle":"Start Angle","StartCap":"Start Cap","StartColor":"Start Color","StartFromZero":"Start From Zero","StartMode":"Start Mode","StartNewPage":"Start New Page","StartNewPageIfLessThan":"Start New Page if Less Than","StartPosition":"Start Position","StartValue":"Start Value","StartWidth":"Start Width","State":"State","Step":"Step","Stop":"Stop","StopBeforePage":"Stop Before Page","StopBeforePrint":"Stop Before Print","StoreImagesInResources":"Store Images in Resources","StreetAddress":"Street Address","Stretch":"Stretch","StretchToPrintArea":"Stretch to Print Area","Strikeout":"Strikeout","StripBrush":"Strip Brush","Strips":"Strips","Stroke":"Stroke","StructuredAppendPosition":"Structured Append Position","StructuredAppendTotal":"Structured Append Total","Style":"Style","StyleColors":"Style Colors","Styles":"Styles","SubmissionMessage":"Submission Message","SubReportPage":"Sub Report","Summaries":"Summaries","Summary":"Summary","SummaryAlignment":"Summary Alignment","SummaryExpression":"Summary Expression","SummarySortDirection":"Summary Sort Direction","SummaryType":"Summary Type","SummaryValues":"Summary Values","SupplementCode":"Supplement Code","SupplementType":"Supplement Type","SweepAngle":"Sweep Angle","SystemFonts":"System Fonts","SystemVariable":"System Variable","SystemVariables":"System Variables","Table":"Table","Tag":"Tag","TagDataColumn":"Tag Data Column","TagValue":"Tag Value","Target":"Target","TargetColor":"Target Color","TargetIcon":"Target Icon","TargetMode":"Target Mode","TargetSettings":"Target","Tension":"Tension","Text":"Text","TextAfter":"Text After","TextAlign":"Text Align","TextAlignment":"Text Alignment","TextBefore":"Text Before","TextBrush":"Text Brush","TextColor":"Text Color","TextFormat":"Text Format","TextOnly":"Text Only","TextOptions":"Text Options","TextQuality":"Text Quality","Third":"Third","TickLabelMajorFont":"Tick Label Major Font","TickLabelMajorTextBrush":"Tick Label Major Text Brush","TickLabelMinorFont":"Tick Label Minor Font","TickLabelMinorTextBrush":"Tick Label Minor Text Brush","TickMarkMajorBorder":"Tick Mark Major Border","TickMarkMajorBorderWidth":"Tick Mark Major Border Width","TickMarkMajorBrush":"Tick Mark Major Brush","TickMarkMinorBorder":"Tick Mark Minor Border","TickMarkMinorBorderWidth":"Tick Mark Minor Border Width","TickMarkMinorBrush":"Tick Mark Minor Brush","Ticks":"Ticks","Title":"Title","TitleBeforeHeader":"Title Before Header","TitleColor":"Title Color","TitleDirection":"TitleDirection","TitleFont":"Title Font","TitleVisible":"Title Visible","To":"To","Today":"Today","ToolTip":"Tool Tip","ToolTipBorder":"Tool Tip Border","ToolTipBrush":"Tool Tip Brush","ToolTipCornerRadius":"Tool Tip Corner Radius","ToolTipDataColumn":"Tool Tip Data Column","ToolTipTextBrush":"Tool Tip Text Brush","Top":"Top","TopLeft":"Top-Left","Topmost":"Topmost","TopmostLine":"Topmost Line","TopN":"Top N","TopRight":"Top-Right","TopSide":"Top Side","Total":"Total","TotalCellColumnBackColor":"Total Cell Column Back Color","TotalCellColumnForeColor":"Total Cell Column Fore Color","TotalCellRowBackColor":"Total Cell Row Back Color","TotalCellRowForeColor":"Total Cell Row Fore Color","TotalLabel":"Total Label","Totals":"Totals","TrackColor":"Track Color","TransparentColor":"Transparent Color","TrendLine":"Trend Line","TrendLineColor":"Trend Line Color","TrendLines":"Trend Lines","TrendLineShowShadow":"Trend Line Show Shadow","TrimExcessData":"Trim Excess Data","Trimming":"Trimming","Type":"Type","TypeName":"Type Name","Types":"Types","UncheckedIcon":"Unchecked Icon","Underline":"Underline","UndoLimit":"Undo Limit","Unit":"Unit","UnitAlignment":"Unit Alignment","UnlimitedBreakable":"Unlimited Breakable","UnlimitedHeight":"Unlimited Height","UnlimitedWidth":"Unlimited Width","UpperMarks":"Upper Marks","URL":"URL","UseAliases":"Use Aliases","UseExternalReport":"Use External Report","UseParentStyles":"Use Parent Styles","UseRangeColor":"Use Range Color","UseRectangularSymbols":"Use Rectangular Symbols","UseSeriesColor":"Use Series Color","UseStyleOfSummaryInColumnTotal":"Use Style of Summary in Column Total","UseStyleOfSummaryInRowTotal":"Use Style of Summary in Row Total","UseValuesFromTheSpecifiedRange":"Use Values From The Specified Range","Value":"Value","ValueClose":"Value Close","ValueDataColumn":"Value Data Column","ValueDataColumnClose":"Value Data Column Close","ValueDataColumnEnd":"Value Data Column End","ValueDataColumnHigh":"Value Data Column High","ValueDataColumnLow":"Value Data Column Low","ValueDataColumnOpen":"Value Data Column Open","ValueEnd":"Value End","ValueFormat":"Value Format","ValueHigh":"Value High","ValueLow":"Value Low","ValueMeter":"Value Meter","ValueOpen":"Value Open","Values":"Values","ValueType":"Value Type","ValueTypeSeparator":"Value Type Separator","Variable":"Variable","Variables":"Variables","Variation":"Variation","Version":"Version","VertAlignment":"Vertical Alignment","VertSpacing":"Vertical Spacing","ViewMode":"View Mode","Visible":"Visible","VisualStates":"Visual States","Watermark":"Watermark","Weight":"Weight","WeightDataColumn":"Weight Data Column","Weights":"Weights","Width":"Width","WindowState":"Window State","WordWrap":"Word Wrap","Wrap":"Wrap","WrapGap":"WrapGap","WrapLine":"Wrap Line","XAxis":"X Axis","XTopAxis":"X Top Axis","YAxis":"Y Axis","YRightAxis":"Y Right Axis","ZeroColor":"Zero Color","Zoom":"Zoom"},"PropertySystemColors":{"ActiveBorder":"Active Border","ActiveCaption":"Active Caption","ActiveCaptionText":"Active Caption Text","AppWorkspace":"App Workspace","Control":"Control","ControlDark":"Control Dark","ControlDarkDark":"Control Dark Dark","ControlLight":"Control Light","ControlLightLight":"Control Light Light","ControlText":"Control Text","Desktop":"Desktop","GrayText":"Gray Text","Highlight":"Highlight","HighlightText":"Highlight Text","HotTrack":"Hot Track","InactiveBorder":"Inactive Border","InactiveCaption":"Inactive Caption","InactiveCaptionText":"Inactive Caption Text","Info":"Info","InfoText":"Info Text","Menu":"Menu","MenuText":"Menu Text","ScrollBar":"Scroll Bar","Window":"Window","WindowFrame":"Window Frame","WindowText":"Window Text"},"QueryBuilder":{"AddObject":"Add Object","AddSubQuery":"Add Derived Table","AllObjects":"(All objects)","BadFromObjectExpression":"Invalid FROM object expression!","BadObjectName":"Invalid object name!","BadSelectStatement":"Invalid SELECT statement!","Collections":"Collections","CreateLinksFromForeignKeys":"Create Links from Foreign Keys","CriteriaAlias":"Alias","CriteriaCriteria":"Criteria","CriteriaExpression":"Expression","CriteriaGroupBy":"Group By","CriteriaOr":"Or...","CriteriaOutput":"Output","CriteriaSortOrder":"Sort Order","CriteriaSortType":"Sort Type","Database":"Database","DataSourceProperties":"Data Source Properties","DialectDontSupportDatabases":"The server does not support queries with objects from different databases.","DialectDontSupportSchemas":"The server does not support schemas.","DialectDontSupportUnions":"This server does not support unions.","DialectDontSupportUnionsBrackets":"This server does not support brackets in unions.","DialectDontSupportUnionsBracketsInSubQuery":"This server doesn\'t support brackets in unions in subqueries.","DialectDontSupportUnionsInSubQueries":"This server does not support unions in subqueries.","Edit":"Edit","EncloseWithBrackets":"Enclose with brackets","Expressions":"Expressions","InsertEmptyItem":"Insert Empty Item","JoinExpression":"Join Expression","LabelAlias":"Alias:","LabelFilterObjectsBySchemaName":"Filter Objects by Schema Name:","LabelJoinExpression":"Join Expression:","LabelLeftColumn":"Left Column:","LabelLeftObject":"Left Object:","LabelObject":"Object:","LabelRightColumn":"Right Column:","LabelRightObject":"Right Object:","LinkProperties":"Link Properties","MetadataProviderCantExecSQL":"Used metadata provider cannot execute SQL queries.","MetaProviderCantLoadMetadata":"Used metadata provider cannot automatically load metadata.","MetaProviderCantLoadMetadataForDatabase":"Used metadata provider cannot automatically load metadata for database: {0}","MoveDown":"Move Down","MoveUp":"Move Up","NewUnionSubQuery":"New union sub-query","NoConnectionObject":"No connection object (property {0} not assigned).","NoTransactionObject":"No transaction object (property {0} not assigned).","Objects":"Objects","ProcedureParameters":"Procedure Parameters","Procedures":"Procedures","qnSaveChanges":"Do you want to save changes of query?","Query":"Query","QueryBuilder":"Query Builder","QueryParameters":"Query Parameters","QueryProperties":"Query Properties","Remove":"Remove","RemoveBrackets":"Remove brackets","RunQueryBuilder":"Run Query Builder","SelectAllFromLeft":"Select All from Left","SelectAllFromRight":"Select All from Right","SwitchToDerivedTable":"Switch to Derived Table","Tables":"Tables","UnexpectedTokenAt":"Unexpected token \\"{0}\\" at line {1}, pos {2}!","Unions":"Unions","UnionSubMenu":"Union","ViewQuery":"View Query","Views":"Views"},"Questions":{"qnConfiguration":"Please choose the type of configuration for the properties panel. The type of the selected configuration depends on the number of visible properties and their complexity for the developer of reports. You can always change the configuration type from the context menu of the properties panel.","qnCopyCategory":"Do you want to copy all variables of this category?","qnDictionaryNew":"Do you want to create new Dictionary?","qnLanguageNew":"You have changed the language of the report. This will lead to the new report code generation. Are you certain you want to save the new language?","qnPageDelete":"Do you want to delete page?","qnRemove":"Do you want to remove?","qnRemoveService":"Do you want to remove Service?","qnRemoveServiceCategory":"Do you want to remove Category?","qnRemoveUnused":"Do you want to remove Unused?","qnReplace":"Do you want to replace the existing item {0}?","qnRestoreDefault":"Restore defaults?","qnSaveChanges":"Save changes in {0}?","qnSaveChangesToPreviewPage":"Do you want to save page changes?","qnSynchronize":"Synchronized contents of the Data Store and contents of the Dictionary?","qnSynchronizeServices":"Synchronized services?"},"RecentFiles":{"AddAPlace":"Add a Place","AddAPlaceDesc":"You can add locations to make it easier to save Reports to the cloud.","ChangeFileType":"Change file type","ChooseALocation":"Choose a Location","ClearUnpinnedItems":"Clear unpinned items","CopyPathToClipboard":"Copy path to clipboard","DateModified":"Date modified","Documents":"Documents","DoYouWantTo":"Do you want to:","LastWeek":"Last Week","LocalDisk":"Local Disk ({0})","MessageInvalidFolderName":"Invalid folder name.","MessageThatNameAlreadyExists":"That name already exists. Please use a different name.","MoreLocations":"More Locations →","Older":"Older","OtherLocations":"Other locations","Personal":"Personal","Pinned":"Pinned","PinToList":"Pin to list","PinToRecentList":"Pin to Recent list","RemoveFromList":"Remove from list","ReplaceExistingFile":"Replace existing file.","SaveChangesWithADifferentName":"Save changes with a different name.","SaveThisFile":"Save this file","SelectToNavigateUpOneLevel":"Select to navigate up one level","SetAsDefaultLocation":"Set as Default Location","ThisPC":"This PC","UnpinFromList":"Unpin from list"},"Report":{"ActiveRelation":"Active Relation","Address":"Address","Alphabetical":"Alphabetical","Bands":"Bands","Basic":"Basic","BasicConfiguration":"Minimal number of object properties, which are necessary for rendering the basic report types.","BusinessObjects":"Business Objects","Categorized":"Categorized","Charts":"Charts","Checking":"Checking...","ClickForMoreDetails":"Click for More Details","CollapseAll":"Collapse All","Collection":"Collection","CompilingReport":"Compiling Report","Complete":"Complete","Components":"Components","ConnectingToData":"Connecting to Data","CopyOf":"Copy","CreateNewReportPageForm":"Create a new report, add a page, add a form","CreatingReport":"Creating Report","CrossBands":"Cross","Dialogs":"Dialogs","EditStyles":"Edit Styles","Enhancements":"Enhancements","EnterDataManually":"Enter data manually","Errors":"Errors","EventsTab":"Events Tab","ExpandAll":"Expand All","FilterAnd":"And","FilterOr":"Or","FinishingReport":"Finishing Report","FirstPass":"First Pass","FixedBugs":"Fixed Bugs","FromCurrentState":"From Current State","FromDefaultState":"From Default State","Gallery":"Gallery","GenerateNewCode":"Generate New Code","History":"History","Infographics":"Infographics","InfoMessage":"{0} - {1} found.","InformationMessages":"Information Messages","LabelAlias":"Alias:","LabelAuthor":"Author:","LabelBackground":"Background:","LabelCategory":"Category:","LabelCentimeters":"Centimeters:","LabelCollectionName":"Collection Name:","LabelColor":"Color:","LabelCountData":"Count Data:","LabelDataBand":"DataBand:","LabelDataColumn":"Data Column:","LabelDefaultValue":"Default Value:","LabelExpression":"Expression:","LabelFactorLevel":"Nested Factor:","LabelFontName":"Font Name:","LabelFunction":"Function:","LabelHundredthsOfInch":"Hundredths of Inch:","LabelInches":"Inches:","LabelMillimeters":"Millimeters:","LabelName":"Name:","LabelNameInSource":"Name in Source:","LabelNestedLevel":"Nested Level:","LabelPassword":"Password:","LabelPixels":"Pixels:","LabelQueryTimeout":"Query Timeout:","LabelSystemVariable":"System Variable:","LabelTableOfContentsHint":"Please, check the components which should form the table of contents. One component is equal to one heading level.","LabelTotals":"Totals","LabelType":"Type:","LabelUserName":"User Name:","LabelValue":"Value:","LoadingReport":"Loading Report","nameAssembly":"Assembly","NewFeatures":"New Features","No":"No","NoFixes":"There are no fixes or updates for this version!","NoIssues":"No Issues","NoNewVersions":"There are no new versions available!","NotAssigned":"Not Assigned","Null":"Null","Obsoleted":"Obsoleted","Office2010Back":"Back","PageNofM":"Page {0} of {1}","PreparingReport":"Preparing Report","Professional":"Professional","ProfessionalConfiguration":"All object properties.","PropertiesTab":"Properties Tab","RangeAll":"All","RangeCurrentPage":"Current Page","RangeInfo":"Enter page number and/or pages ranges separated by commas. For example: 1, 3, 5-12","RangePage":"Page Range","RangePages":"Pages:","ReportChecker":"Checker","ReportRenderingMessages":"Report Rendering Messages","RestartDesigner":"You need to restart the report designer","SaveReportPagesOrFormsFromReport":"Save the report, pages or forms","SavingReport":"Saving Report","SecondPass":"Second Pass","Shapes":"Shapes","ShowOnParametersPanel":"Show on Parameters Panel","Standard":"Standard","StandardConfiguration":"Main object properties except rarely used ones.","StiEmptyBrush":"Empty","StiGlareBrush":"Glare","StiGlassBrush":"Glass","StiGradientBrush":"Gradient","StiHatchBrush":"Hatch","StiSolidBrush":"Solid","StyleBad":"Bad","StyleGood":"Good","StyleNeutral":"Neutral","StyleNormal":"Normal","StyleNote":"Note","StyleWarning":"Warning","UseDataFields":"Use Data Fields","VisualChecked":"Checked","VisualDefault":"Default","VisualDisabled":"Disabled","VisualHover":"Hover","VisualPressed":"Pressed","Warnings":"Warnings","WhatsNewInVersion":"What\'s New in {0}","When":"when {0} {1}","WhenAnd":"when {0} {1} and","WhenValueIs":"when value is"},"ReportInfo":{"CheckIssuesAdditionalDescription":"Check for errors and find inaccuracies.","EncryptWithPassword":"Encrypt with Password","EncryptWithPasswordAdditionalDescription":"Set the password to prevent unauthorized working with the report.","EncryptWithPasswordDescription":"Protect Report","Info":"Info","ReportOptions":"Report Options","ReportOptionsAdditionalDescription":"Setup the basic information and parameters in the report."},"ReportOpen":{"Browse":"Browse","Import":"Import"},"Scheduler":{"ActionRunReport":"Run Report","AdvancedSettings":"Advanced Settings","CheckBoxOverwriteIfExists":"Overwrite If Exists","DayAll":"All","DayDayX":"Day {0}","DayLast":"Last","DayNone":"None","DaysOfWeekAll":"All","DaysOfWeekNone":"None","DelayTaskForUpToRandomDelay":"Delay task for up to (random delay)","EditScheduler":"Edit Scheduler","EnableSSL":"Enable SSL","Expire":"Expire","ForADurationOf":"for a duration of","GetFolder":"Get Folder","GroupBoxFiles":"Files","Host":"Host","Info":"Windows Task Scheduler is used to run schedulers.","LabelDaysOfWeek":"Days of Week","LabelMessage":"Message","LabelResultName":"Result Name","LabelRunAtDay":"Run at Day","LabelRunAtMonth":"Run at Month","LabelRunAtTime":"Run at Time","LabelRunEvery":"Run Every","LabelSubject":"Subject","LabelTo":"To","Logs":"Logs","MessageInvalidName":"Task names may not include any characters which are invalid for file names.","MessageInvalidTaskName":"Task names ending with a period followed by three or fewer characters cannot be retrieved due to a bug in the native library.","MessagePropertyNotSet":"\'{0}\' not set!","MonthAll":"All","MonthNone":"None","NewAction":"New Action","NewScheduler":"New Scheduler","NoLogs":"No Logs","NoSchedulers":"No Schedulers","NumberOfDayAll":"All","NumberOfDayFirst":"First","NumberOfDayFourth":"Fourth","NumberOfDayLast":"Last","NumberOfDayNone":"None","NumberOfDaySecond":"Second","NumberOfDayThird":"Third","OpenWindowsTaskScheduler":"Open Windows Task Scheduler","PleaseSelectSchedulerType":"Please select a scheduler type","RadioButtonDay":"Day","RadioButtonOn":"On","RepeatTaskEvery":"Repeat task every","Schedule":"Schedule","Scheduler":"Scheduler","Schedulers":"Schedulers","SenderEmail":"Sender Email","SmtpSettings":"Smtp Settings","StopAllRunningTasksAtEndOfRepetitionDuration":"Stop all running tasks at end of repetition duration","StopTasksIfItRunsLongerThan":"Stop tasks if it runs longer than","TextDragDropDestinationHere":"Drag &amp; Drop the Destination Folder Here","TextDragDropReportHere":"Drag &amp; Drop the Report Here","TextPressPlusIconAddNewAction":"Click the icon plus to add a new action!","ToolTipSetParameters":"Defining Report Parameters","WizardDaily":"Daily","WizardDailyDescription":"Once a day, at a specified time.","WizardHourly":"Hourly","WizardHourlyDescription":"Once an hour.","WizardMonthly":"Monthly","WizardMonthlyDescription":"Monthly, on selected days of the week or days of the month, at a specified time.","WizardOnce":"Once","WizardOnceDescription":"Run the scheduler once at any time.","WizardWeekly":"Weekly","WizardWeeklyDescription":"On the selected days of the week, at a specified time."},"Services":{"categoryContextTools":"Context Tools","categoryDesigner":"Designer","categoryDictionary":"Dictionary","categoryExport":"Exports","categoryLanguages":"Languages","categoryPanels":"Panels","categoryRender":"Render","categoryShapes":"Shapes","categorySL":"Save / Load","categorySystem":"System","categoryTextFormat":"Text Format"},"Shapes":{"Arrow":"Arrow","BasicShapes":"Basic Shapes","BentArrow":"Bent Arrow","BlockArrows":"Block Arrows","Chevron":"Chevron","ComplexArrow":"Complex Arrow","DiagonalDownLine":"Diagonal Line Down","DiagonalUpLine":"Diagonal Line Up","Division":"Division","Equal":"Equal","EquationShapes":"Equation Shapes","Flowchart":"Flowchart","FlowchartCard":"Flowchart: Card","FlowchartCollate":"Flowchart: Collate","FlowchartDecision":"Flowchart: Decision","FlowchartManualInput":"Flowchart: Manual Input","FlowchartOffPageConnector":"Flowchart: Off Page Connector","FlowchartPreparation":"Flowchart: Preparation","FlowchartSort":"Flowchart: Sort","Frame":"Frame","HorizontalLine":"Horizontal Line","InsertShapes":"Insert Shapes","LeftAndRightLine":"Left and Right Line","Lines":"Lines","Minus":"Minus","Multiply":"Multiply","Octagon":"Octagon","Oval":"Oval","Parallelogram":"Parallelogram","Plus":"Plus","Rectangle":"Rectangle","Rectangles":"Rectangles","RegularPentagon":"Regular: Pentagon","RoundedRectangle":"Rounded Rectangle","ServiceCategory":"Shapes","ShapeStyles":"Shape Styles","SnipDiagonalSideCornerRectangle":"Snip Diagonal Side Corner Rectangle","SnipSameSideCornerRectangle":"Snip Same Side Corner Rectangle","TopAndBottomLine":"Top and Bottom Line","Trapezoid":"Trapezoid","Triangle":"Triangle","VerticalLine":"Vertical Line"},"Signature":{"DigitalSignatureEmptyWatermark":"Place for digital signature in PDF Viewer","InsertImage":"Insert Image","InsertText":"Insert Text","LoadSignature":"Load signature","NoSavedItems":"No saved items","SaveSignature":"Save signature","SignatureSavedSuccessfully":"Signature saved successfully.","UseBrush":"Use Brush"},"SystemVariables":{"Column":"Returns the current column number (starts from 1).","GroupLine":"Returns the current group line number (starts from 1).","IsFirstPage":"Returns true, if, in the current moment, the first page of a report is printed.","IsFirstPageThrough":"Returns true, if, in the current moment, the first report page is printed. When calculating the IsFirstPageThrough, all ResetPageNumber properties are ignored and numbering starts from the beginning of report. For correct calculation of a variable it is required to execute two passes.","IsLastPage":"Returns true, if, in the current moment, the last page of a report is printed. For correct calculation of a variable it is required to execute two passes.","IsLastPageThrough":"Returns true, if, in the current moment, the last page of a report is printed. When calculating the IsLastPageThrough, all properties ResetPageNumber are ignored and numbering starts from the beginning of report. For correct calculation of a variable it is required to execute two passes.","Line":"Returns the current line number (starts from 1).","LineABC":"Returns the alphabetical analogue of the current line number.","LineRoman":"Returns the current line number in Roman numerals.","LineThrough":"Returns the current line number (starts from 1). When calculating the number, all groupings are ignored and numbering starts from the beginning of printing.","PageCopyNumber":"Return a number of a current copy of a page (starts from 1).","PageNofM":"Returns a localized string, showing \\"Page N of M\\" where N is the current page number and M is the TotalPageCount of a report.","PageNofMThrough":"Returns a localized string, showing \\"Page N of M\\" where N is the current page number and M is the TotalPageCount of a report. When calculating the PageNofMThrough, all properties ResetPageNumber are ignored and numbering starts from the beginning of a report.","PageNumber":"Returns the current page number (starts from 1).","PageNumberThrough":"Returns the current page number (starts from 1). When calculating the PageNumberThrough, all properties ResetPageNumber are ignored and numbering starts from the beginning of a report.","ReportAlias":"Returns the report alias. You can change the ReportAlias with help of the ReportAlias property of a report.","ReportAuthor":"Returns the report author. You can change ReportAuthor with help of the ReportAuthor property of a report.","ReportChanged":"The Date when a report was changed.","ReportCreated":"The Date when a report was created.","ReportDescription":"Returns the report description. You can change the ReportName with help of the ReportDescription property of a report.","ReportName":"Returns the report name. You can change the ReportName with help of the ReportName property of a report.","Time":"Returns the current time.","Today":"Returns the current date.","TotalPageCount":"Returns the number of pages in a report.","TotalPageCountThrough":"Returns the number of pages in a report. When calculating the TotalPageCountThrough, all properties ResetPageNumber are ignored and numbering starts from the beginning of report."},"TableRibbon":{"BuiltIn":"Built-In","Delete":"Delete","DeleteColumns":"Delete Columns","DeleteRows":"Delete Rows","DeleteTable":"Delete Table","DistributeColumns":"Distribute Columns","DistributeRows":"Distribute Rows","InsertAbove":"Insert Above","InsertBelow":"Insert Below","InsertLeft":"Insert Left","InsertRight":"Insert Right","PlainTables":"Plain Tables","ribbonBarRowsColumns":"Rows and Columns","ribbonBarTable":"Table","ribbonBarTableStyles":"Table Styles","Select":"Select","SelectColumn":"Select Column","SelectRow":"Select Row","SelectTable":"Select Table"},"Toolbars":{"Align":"Align","AlignBottom":"Align Bottom","AlignCenter":"Align Center","AlignLeft":"Align Left","AlignMiddle":"Align Middle","AlignRight":"Align Right","AlignToGrid":"Align to Grid","AlignTop":"Align Top","AlignWidth":"Justify","BringToFront":"Bring to Front","CenterHorizontally":"Center Horizontally","CenterVertically":"Center Vertically","Conditions":"Conditions","FontGrow":"Grow Font","FontName":"Font Name","FontShrink":"Shrink Font","FontSize":"Font Size","FontStyleBold":"Font Style Bold","FontStyleItalic":"Font Style Italic","FontStyleUnderline":"Font Style Underline","Link":"Link","Lock":"Lock","MakeHorizontalSpacingEqual":"Make Horizontal Spacing Equal","MakeSameHeight":"Make Same Height as {0}","MakeSameSize":"Make Same Size as {0}","MakeSameWidth":"Make Same Width as {0}","MakeVerticalSpacingEqual":"Make Vertical Spacing Equal","MoveBackward":"Move Backward","MoveForward":"Move Forward","Order":"Order","SendToBack":"Send to Back","Size":"Size","StyleDesigner":"Style Designer","Styles":"List of the styles","TabHome":"Home","TabLayout":"Layout","TabPage":"Page","TabView":"View","TextBrush":"Text Brush","ToolbarAlignment":"Alignment","ToolbarArrange":"Arrange","ToolbarBorders":"Borders","ToolbarClipboard":"Clipboard","ToolbarDockStyle":"Dock Style","ToolbarFont":"Font","ToolbarFormatting":"Formatting","ToolbarLayout":"Layout","ToolbarPageSetup":"Page Setup","ToolbarStandard":"Standard","ToolbarStyle":"Style","ToolbarTextFormat":"Text Format","ToolbarTools":"Tools","ToolbarViewOptions":"View Options","ToolbarWatermarkImage":"Watermark Image","ToolbarWatermarkText":"Watermark Text"},"Toolbox":{"Create":"Creation components","Hand":"Hand","Select":"Select","Style":"Copy Style","TextEditor":"Text Editor","title":"Toolbox"},"WelcomeScreen":{"AllDownloadsWillCanceled":"Are you sure you want to close this window? All downloads will be canceled.","Description":"We have selected for you reports that we think are the best for a quick start.","GetStarted":"Get Started","GetStartedWithDashboards":"Get Started with Dashboards","GetStartedWithReports":"Get Started with Reports","MoreReports":"More Reports","ShowNextTime":"Show \'{0}\' next time","Title":"Welcome to Stimulsoft Demo"},"Wizards":{"BlankDashboard":"Blank Dashboard","BlankForm":"Blank Form","BlankReport":"Blank Report","BlankScreen":"Blank Screen","ButtonBack":"&lt; &amp;Back","ButtonCancel":"Cancel","ButtonFinish":"&amp;Finish","ButtonNext":"&amp;Next &gt;","ColumnsOrder":"Columns Order","Company":"Company","Custom":"Custom","DataRelation":"Relation","DataSource":"Data Source","DataSources":"Data Sources","DefaultThemes":"Default Themes","Filters":"Filters","FromReportTemplate":"From Report Template","GetData":"Get Data","groupCreateNewDashboard":"Create a New Dashboard","groupCreateNewPageOrForm":"Create a New Page or Form","groupCreateNewReport":"Create a New Report","Groups":"Groups","groupTemplates":"Templates","groupWizards":"Wizards","infoColumnsOrder":"Arrange columns in the necessary order.","infoCompanyInfo":"Enter your company information.","infoDataSource":"Select one Data Source from available.","infoDataSources":"Select Data Sources from available. The first selected one will be the Master data source.","infoFilters":"Filter Data for your report","infoGroups":"Select columns on which necessary to group.","infoLabelSettings":"Set the settings of labels.","infoLanguages":"Select the report culture.","infoLayout":"Specify layout of report.","infoRelation":"Select one Data Relation from available.","infoSelectColumns":"Select columns from which the information will be displayed.","infoSelectTemplate":"Choose the appropriate template for your needs.","infoSort":"Set the sorting of data. You can sort immediately on multiple columns.","infoThemes":"Select theme for your report.","infoTotals":"Add summary information to your report.","LabelDirection":"Direction:","LabelHeight":"Height:","LabelHorizontalGap":"Horizontal Gap:","LabelLabelType":"Label Type:","LabelLeftMargin":"Left Margin:","LabelNumberOfColumns":"Number of Columns:","LabelNumberOfRows":"Number of Rows:","LabelPageHeight":"Page Height:","LabelPageWidth":"Page Width:","LabelReport":"Label Report","LabelSettings":"Label Settings","LabelSize":"Size:","LabelTopMargin":"Top Margin:","LabelVerticalGap":"Vertical Gap:","LabelWidth":"Width:","Layout":"Layout","Mapping":"Mapping","MarkAll":"Mark &amp;All","MasterDetailReport":"Master-Detail Report","NoFunction":"[None]","OpenExistingReport":"Open Existing File","OpenFrom":"Open from {0}","Preview":"Preview","Reset":"&amp;Reset","Results":"Results","RunWizard":"Run Wizard","SelectColumns":"Select Columns","SelectTemplate":"Template","Sort":"Sort","StandardReport":"Standard Report","Themes":"Themes","title":"New Report","Totals":"Totals","UseDemoData":"Use Demo Data","UsingReportWizard":"Using Report Wizard","YouHaveNotOpenedAnyReportRecently":"You haven\'t opened any report recently. To browse for a report, start by clicking on Open Existing File."},"Zoom":{"EmptyValue":"Empty Value","MultiplePages":"Multiple Pages","OnePage":"One Page","PageHeight":"Page Height","PageWidth":"Page Width","TwoPages":"Two Pages","ZoomTo100":"Zoom to 100%"}}}');
StiLocalizationService.needToRefresh = new Subject();
StiLocalizationService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiLocalizationService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
StiLocalizationService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiLocalizationService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiLocalizationService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });

class StiPadding {
    constructor(left = 0, top = 0, right = 0, bottom = 0, changesInterceptor) {
        this._left = 0;
        this._right = 0;
        this._top = 0;
        this._bottom = 0;
        this._left = left;
        this._right = right;
        this._top = top;
        this._bottom = bottom;
        this.changesInterceptor = changesInterceptor;
    }
    get left() {
        return this._left;
    }
    set left(value) {
        let oldPadding = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._left;
        this._left = value;
        if (this.changesInterceptor && oldValue != value) {
            this.changesInterceptor.propertyChanged("padding.left", value, oldPadding);
        }
    }
    get right() {
        return this._right;
    }
    set right(value) {
        let oldPadding = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._right;
        this._right = value;
        if (this.changesInterceptor && oldValue != value) {
            this.changesInterceptor.propertyChanged("padding.right", value, oldPadding);
        }
    }
    get top() {
        return this._top;
    }
    set top(value) {
        let oldPadding = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._top;
        this._top = value;
        if (this.changesInterceptor && oldValue != value) {
            this.changesInterceptor.propertyChanged("padding.top", value, oldPadding);
        }
    }
    get bottom() {
        return this._bottom;
    }
    set bottom(value) {
        let oldPadding = this.changesInterceptor ? this.clone() : null;
        let oldValue = this._bottom;
        this._bottom = value;
        if (this.changesInterceptor && oldValue != value) {
            this.changesInterceptor.propertyChanged("padding.bottom", value, oldPadding);
        }
    }
    isChanged() {
        return this.savedPadding == null || !this.savedPadding.equals(this);
    }
    resetChanged() {
        this.savedPadding = this.clone();
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyNumber("Left", this.left);
        json.addPropertyNumber("Top", this.top);
        json.addPropertyNumber("Right", this.right);
        json.addPropertyNumber("Bottom", this.bottom);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Left":
                    this.left = property.value;
                    break;
                case "Top":
                    this.top = property.value;
                    break;
                case "Right":
                    this.right = property.value;
                    break;
                case "Bottom":
                    this.bottom = property.value;
                    break;
            }
        }
    }
    clone() {
        return new StiPadding(this.left, this.top, this.right, this.bottom);
    }
    equals(padding) {
        return (this.left == padding.left &&
            this.top == padding.top &&
            this.right == padding.right &&
            this.bottom == padding.bottom);
    }
}

/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
class Guid {
    constructor(id) {
        this.id = id.toLowerCase();
    }
    static newGuid() {
        return new Guid(Guid.s4() + Guid.s4() + "-" + Guid.s4() + "-" + Guid.s4() + "-" +
            Guid.s4() + "-" + Guid.s4() + Guid.s4() + Guid.s4());
    }
    static newGuidString() {
        return Guid.s4() + Guid.s4() + Guid.s4() + Guid.s4() +
            Guid.s4() + Guid.s4() + Guid.s4() + Guid.s4();
    }
    static s4() {
        return Math
            .floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
    }
    toString() {
        return this.id;
    }
    static empty() {
        return new Guid("00000000-0000-0000-0000-000000000000");
    }
    static compareTo(value) {
        let x = this.toString();
        let y = value.toString();
        return (x < y ? -1 : (x > y ? 1 : 0));
    }
}

class StiFormObject {
    constructor() {
        this.guid = Guid.newGuid().toString();
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        if (this.type) {
            json.addPropertyString(StiFormObject.TYPE_PROPERTY_NAME, this.type.replace("_", ""));
        }
        json.addPropertyString("Guid", this.guid);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Guid":
                    this.guid = property.value;
                    break;
            }
        }
    }
    deserializeCollection(jObject) {
        let result = [];
        for (let property of jObject.properties()) {
            let typeJson = property.value.value.filter((x) => x.name == StiFormObject.TYPE_PROPERTY_NAME);
            if (typeJson.length == 1) {
                let inst = this.createElementClass(typeJson[0].value);
                inst.loadFromJsonObject(property.value);
                result.push(inst);
            }
        }
        return result;
    }
    createElementClass(type) {
        return {};
    }
}
StiFormObject.TYPE_PROPERTY_NAME = "Type";

class StiLabelItem extends StiTextItem {
    constructor(parent, value = "", font = new Font("Segoe UI", 10), color = Color.black(), alignment = StiLabelAlignment.Left, verticalAlignment = StiVerticalAlignment.Top, width = 150) {
        super(value, font, color, null);
        this.font = font;
        this.color = color;
        this.alignment = alignment;
        this.eVerticalAlignment = verticalAlignment;
        this.width = width;
        this.eParent = parent;
    }
    get alignment() {
        return this._alignment;
    }
    set alignment(value) {
        var _a, _b;
        this._alignment = value;
        this._isChanged = true;
        if ((_a = this.eParent) === null || _a === void 0 ? void 0 : _a.fitTable) {
            (_b = this.eParent) === null || _b === void 0 ? void 0 : _b.fitTable();
        }
    }
    get eVerticalAlignment() {
        return this._verticalAlignment;
    }
    set eVerticalAlignment(value) {
        this._verticalAlignment = value;
        this._isChanged = true;
    }
    get verticalAlignment() {
        return this.isUnchangedVAlign() ? StiVerticalAlignment.Center : this.eVerticalAlignment;
    }
    set verticalAlignment(value) {
        this.eVerticalAlignment = value;
    }
    get width() {
        return this._width;
    }
    set width(value) {
        if (value <= 0) {
            this._width = 0;
        }
        else {
            this._width = value;
        }
        this._isChanged = true;
    }
    haveContentAlignment() {
        return false;
    }
    haveVerticalAlignment() {
        return true;
    }
    setProperty(propName, value, oldObject) {
        super.setProperty(propName, value, oldObject);
        if (this[propName] && (oldObject === null || this[propName] == oldObject)) {
            this[propName] = value.clone ? value.clone() : value;
        }
    }
    saveToJsonObject(options) {
        let json = super.saveToJsonObject(options);
        json.addPropertyEnum("Alignment", StiLabelAlignment, this.alignment);
        json.addPropertyEnum("VerticalAlignment", StiVerticalAlignment, this.isUnchangedVAlign() ? StiVerticalAlignment.Center : this.eVerticalAlignment);
        if (this.width != null) {
            json.addPropertyNumber("Width", this.width);
        }
        return json;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Alignment":
                    this.alignment = Enum.parse(StiLabelAlignment, property.value);
                    break;
                case "Width":
                    this.width = property.value;
                    break;
                case "VerticalAlignment":
                    this._verticalAlignment = Enum.parse(StiVerticalAlignment, property.value);
                    break;
            }
        }
    }
    htmlStyle() {
        return `${super.htmlStyle()};text-align:${this.alignment == StiLabelAlignment.Top ? "Center" : Enum.getName(StiLabelAlignment, this.alignment)}`;
    }
    isUnchangedVAlign() {
        return (this.eParent.type == "Text_BoxElement" ||
            this.eParent.type == "Number_BoxElement" ||
            this.eParent.type == "Combo_BoxElement" ||
            this.eParent.type == "Check_BoxElement" ||
            this.eParent.type == "DateTime_BoxElement");
    }
}

class StiFormElement extends StiFormObject {
    constructor() {
        super(...arguments);
        this._visible = true;
        this._geometry = new StiRectangleGeometry(0, 0, this);
        this._padding = new StiPadding(8, 8, 8, 8, this);
        this._label = new StiLabelItem(this, "");
        this._readOnly = false;
        this._isChanged = true;
        this.render = true;
        this.position = "absolute";
        // public label: StiLabelItem = new StiLabelItem(this, "");
        this.hasGeometry = false;
        this.isAdded = false;
    }
    get maxWidth() {
        if (this.label.alignment == StiLabelAlignment.Top || this.label.eValue.length == 0) {
            return this.geometry.width - this.padding.left - this.padding.right;
        }
        else {
            return this.geometry.width - this.label.width - this.padding.left - this.padding.right;
        }
    }
    setDefaultValues() { }
    isChanged() {
        return this._isChanged || this._geometry.isChanged() || this._padding.isChanged();
    }
    getDefaultEditableContent() {
        return null;
    }
    canUpdateProperty(propName) {
        return true;
    }
    isLabelTopAlignment() {
        return this.label.alignment == StiLabelAlignment.Top ? true : false;
    }
    getVerticalAlignment() {
        if (this.label.verticalAlignment == StiVerticalAlignment.Top) {
            return "start";
        }
        else if (this.label.verticalAlignment == StiVerticalAlignment.Center) {
            return "center";
        }
        else {
            return "flex-end";
        }
    }
    resetChanged() {
        this._isChanged = false;
        this._geometry.resetChanged();
        this._padding.resetChanged();
    }
    get visible() {
        return this._visible;
    }
    set visible(value) {
        this._visible = value;
        this._isChanged = true;
    }
    get label() {
        return this._label;
    }
    set label(value) {
        let oldValue = this._label;
        if (oldValue != value) {
            this._label = value;
            this._isChanged = true;
        }
    }
    get geometry() {
        return this._geometry;
    }
    set geometry(value) {
        if (!this.geometry || !value || !this.geometry.equals(value)) {
            this._isChanged = true;
        }
        else {
            value.resetChanged();
        }
        this._geometry = value;
        this._geometry.changesInterceptor = this;
    }
    get padding() {
        return this._padding;
    }
    set padding(value) {
        let oldValue = this._padding;
        if (oldValue != value) {
            this._padding = value;
            this._padding.changesInterceptor = this;
            this._isChanged = true;
            this.propertyChanged("padding");
        }
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
        this._isChanged = true;
    }
    get readOnly() {
        return this._readOnly;
    }
    set readOnly(value) {
        this._readOnly = value;
        this._isChanged = true;
    }
    get computedHeight() {
        return Number(this.height) + Number(this.padding.top) + Number(this.padding.bottom);
    }
    get computedWidth() {
        return Number(this.width) - Number(this.padding.left) - Number(this.padding.right);
    }
    get height() {
        return this.geometry.height;
    }
    set height(value) {
        this.geometry.height = value;
    }
    get width() {
        return this.geometry.width;
    }
    set width(value) {
        this.geometry.width = value;
    }
    get x() {
        return this.geometry.x;
    }
    set x(value) {
        this.geometry.x = value;
    }
    get y() {
        return this.geometry.y;
    }
    set y(value) {
        this.geometry.y = value;
    }
    hasText() {
        return false;
    }
    propertyChanged(propName) { }
    showLabelPlaceholder(isSelected) {
        return this.label.alignment == StiLabelAlignment.Top || this.label.width < 15 || !isSelected ? true : false;
    }
    getContentAlign() {
        return this.label.alignment == StiLabelAlignment.Right ? "end" : "start";
    }
    getLabelWidth() {
        return this.label.alignment == StiLabelAlignment.Top ? "100%" : this.label.width + "px";
    }
    getTopMargin() {
        return this.label.alignment == StiLabelAlignment.Top && this.label.value ? "8" : "0";
    }
    setProperty(propName, value, oldObject) {
        if (!this.canUpdateProperty(propName)) {
            return;
        }
        if (propName.startsWith("label") && "label" in this) {
            this.label.setProperty(propName.replace("label.", ""), value.clone ? value.clone() : value, oldObject);
        }
        else if (propName.startsWith("description") && "description" in this) {
            this.description.setProperty(propName.replace("description.", ""), value.clone ? value.clone() : value, oldObject);
        }
        else if (this[propName] &&
            (oldObject === null ||
                (propName == "padding" && this[propName].equals(oldObject)) ||
                this[propName] == oldObject)) {
            this[propName] = value.clone ? value.clone() : value;
        }
        else if (propName == "innerText.color" &&
            this["textColor"] &&
            (oldObject === null || oldObject.equals(this["textColor"]))) {
            this["textColor"] = value.clone();
        }
        else if (propName == "innerText.backgroundColor" &&
            this["backgroundColor"] &&
            (oldObject === null || oldObject.equals(this["backgroundColor"]))) {
            this["backgroundColor"] = value.clone();
        }
        else if (propName == "innerText.borderColor" &&
            this["borderColor"] &&
            (oldObject === null || oldObject.equals(this["borderColor"]))) {
            this["borderColor"] = value.clone();
        }
        else if (propName == "innerText.checkColor" &&
            this["checkColor"] &&
            (oldObject === null || oldObject.equals(this["checkColor"]))) {
            this["checkColor"] = value.clone();
        }
        else if (propName == "innerText.borderWeight" &&
            this["borderWeight"] &&
            (oldObject === null || this["borderWeight"] == oldObject)) {
            this["borderWeight"] = value;
        }
        else if (propName == "innerText.contentAlignment" &&
            this["contentAlignment"] &&
            (oldObject === null || this["contentAlignment"] == oldObject)) {
            this["contentAlignment"] = value;
        }
        else if (propName.startsWith("innerText.font") &&
            this["font"] &&
            (oldObject === null || oldObject.equals(this["font"]))) {
            this["font"].setProperty(propName.replace("innerText.font.", ""), value);
        }
        else if (propName.startsWith("padding.") &&
            this["padding"] &&
            (oldObject === null || oldObject.equals(this["padding"]))) {
            let opt = propName.replace("padding.", "");
            this["padding"][opt] = value;
        }
    }
    arrayOfStylesToString(array) {
        let styles = [];
        if (array.length > 0) {
            array.forEach((item) => {
                if (item != "Underline") {
                    styles.push(item);
                }
            });
        }
        return styles.length > 0 ? styles.join(" ").toLocaleLowerCase() : "";
    }
    getUsedFonts(usedFonts) {
        usedFonts.add(this._label.font.family, this.arrayOfStylesToString(this._label.font.style), this._label.font.size);
    }
    getParent(form) {
        let container;
        form.pages.forEach((page) => {
            if (page.elements.indexOf(this) >= 0) {
                container = page;
            }
            else {
                page.allElements.forEach((e) => {
                    let elements = e.elements;
                    if (elements && elements.indexOf(this) >= 0) {
                        container = e;
                    }
                });
            }
        });
        return container;
    }
    getOverPageGeometry(form) {
        let geometry = this.geometry.clone();
        form.pages.forEach((page) => {
            let allElements = page.allElements;
            let child = this;
            let find = true;
            while (find) {
                find = false;
                allElements.forEach((e) => {
                    let elements = e.elements;
                    if (elements && elements.indexOf(child) >= 0) {
                        geometry.x += e.geometry.x + e.padding.left;
                        geometry.y += e.geometry.y + e.padding.top;
                        child = e;
                        find = true;
                    }
                });
            }
        });
        return geometry;
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyBool("Visible", this.visible);
        jObject.addPropertyBool("ReadOnly", this.readOnly);
        jObject.addPropertyJObject("Padding", this.padding.saveToJsonObject(options));
        jObject.addPropertyJObject("Geometry", this.geometry.saveToJsonObject(options));
        jObject.addPropertyStringNullOrEmpty("Name", this.name);
        return jObject;
    }
    loadFromJsonObject(json) {
        this.isAdded = true;
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Visible":
                    this.visible = property.value;
                    break;
                case "Enabled":
                case "ReadOnly":
                    if (property.name == "Enabled") {
                        this.readOnly = !property.value;
                    }
                    else {
                        this.readOnly = property.value;
                    }
                    break;
                case "Padding":
                    this.padding = new StiPadding();
                    this.padding.loadFromJsonObject(property.value);
                    break;
                case "Geometry":
                    this.geometry = new StiRectangleGeometry();
                    this.geometry.loadFromJsonObject(property.value);
                    break;
                case "Name":
                    this.name = property.value;
                    break;
            }
        }
    }
}

class StiComboBoxElement extends StiFormElement {
    constructor() {
        super();
        this.type = "Combo_BoxElement";
        this.tooltip = "";
        this.required = false;
        this.description = new StiTextItem();
        this.font = new Font("Segoe UI", 10);
        this.backgroundColor = Color.white();
        this.textColor = Color.black();
        this.borderColor = Color.lightGray();
        this.borderWeight = StiLineWeight.Thin;
        this.editable = false;
        this.options = [];
        this.selectedOption = "";
        this.geometry = new StiRectangleGeometry(150, 40);
        this.label = new StiLabelItem(this, StiLocalizationService.get("Components", "StiComboBox"));
        this.options.push(StiLocalizationService.get("PropertyMain", "First"));
        this.options.push(StiLocalizationService.get("PropertyMain", "Second"));
        this.options.push(StiLocalizationService.get("PropertyMain", "Third"));
    }
    setDefaultValues() {
        this.selectedOption = "";
    }
    setTabIndex(value) {
        this.tabIndex = value++;
        return value;
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.font.family, this.arrayOfStylesToString(this.font.style), this.font.size);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    getDefaultEditableContent() {
        let textItem = new StiInputTextItem(this.selectedOption, this.font, this.textColor, this.backgroundColor);
        textItem.element = this;
        return textItem;
    }
    get eFont() {
        return this.font;
    }
    set eFont(value) {
        this.font = value;
    }
    get eBackgroundColor() {
        return this.backgroundColor;
    }
    set eBackgroundColor(value) {
        this.backgroundColor = value;
    }
    get eColor() {
        return this.textColor;
    }
    set eColor(value) {
        this.textColor = value;
    }
    get value() {
        return this.selectedOption;
    }
    haveBackgoundColor() {
        return true;
    }
    haveContentAlignment() {
        return false;
    }
    haveVerticalAlignment() {
        return false;
    }
    htmlStyle() {
        return `${this.font.htmlStyle()};color:${this.eColor.toHtmlColor()}}`;
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyColor("TextColor", this.textColor);
        jObject.addPropertyString("Tooltip", this.tooltip);
        jObject.addPropertyBool("Required", this.required);
        jObject.addPropertyColor("BorderColor", this.borderColor);
        jObject.addPropertyEnum("BorderWeight", StiLineWeight, this.borderWeight);
        jObject.addPropertyBool("Editable", this.editable);
        jObject.addPropertyString("SelectedOption", this.selectedOption);
        jObject.addPropertyArray("Options", this.options);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "TextColor":
                    this.textColor = new Color();
                    this.textColor.deserializeFromString(property.value);
                    break;
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Font":
                    this.font = new Font();
                    this.font.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "Tooltip":
                    this.tooltip = property.value;
                    break;
                case "Required":
                    this.required = property.value;
                    break;
                case "BorderColor":
                    this.borderColor = new Color();
                    this.borderColor.deserializeFromString(property.value);
                    break;
                case "BorderWeight":
                    this.borderWeight = Enum.parse(StiLineWeight, property.value);
                    break;
                case "Editable":
                    this.editable = property.value;
                    break;
                case "SelectedOption":
                    this.selectedOption = property.value;
                    break;
                case "Options":
                    this.options = [];
                    property.value.properties().forEach((p) => this.options.push(p.value));
                    break;
            }
        }
    }
}

class StiAddressLabelItem {
    constructor(value, parent) {
        this.parent = parent;
        this.property = value;
    }
    get eFont() {
        return this.parent.descriptionFont;
    }
    set eFont(value) {
        this.parent.descriptionFont = value;
    }
    get eColor() {
        return this.parent.descriptionColor;
    }
    set eColor(value) {
        this.parent.descriptionColor = value;
    }
    haveBackgoundColor() {
        return false;
    }
    get eContentAlignment() {
        return this.parent.contentAlignment;
    }
    set eContentAlignment(value) {
        this.parent.contentAlignment = value;
    }
    haveContentAlignment() {
        return true;
    }
    htmlStyle() {
        return this.parent ? `${this.eFont.htmlStyle()};color:${this.eColor.toHtmlColor()}` : "";
    }
    set eValue(value) {
        this.parent[this.property] = value;
    }
    get eValue() {
        return this.parent[this.property];
    }
    haveVerticalAlignment() {
        return false;
    }
}

class StiAddressElement extends StiFormElement {
    constructor() {
        super();
        this.type = "AddressElement";
        this.font = new Font("Segoe UI", 10);
        this.descriptionFont = new Font("Segoe UI", 9);
        this.descriptionColor = Color.black();
        this.backgroundColor = Color.white();
        this.textColor = Color.black();
        this.borderColor = Color.lightGray();
        this.borderWeight = StiLineWeight.Thin;
        this.contentAlignment = StiHorizontalAlignment.Left;
        this.streetAddress = "";
        this.streetAddress2 = "";
        this.city = "";
        this.state = "";
        this.zipCode = "";
        this.country = "";
        this.streetAddressLabel = StiLocalizationService.get("PropertyMain", "StreetAddress");
        this.streetAddress2Label = StiLocalizationService.get("PropertyMain", "StreetAddress") + " 2";
        this.cityLabel = StiLocalizationService.get("PropertyMain", "City");
        this.stateLabel = StiLocalizationService.get("PropertyMain", "State");
        this.zipCodeLabel = StiLocalizationService.get("Components", "StiZipCode");
        this.countryLabel = StiLocalizationService.get("PropertyMain", "Country");
        this.streetAddressLabelItem = new StiAddressLabelItem("streetAddressLabel", this);
        this.streetAddress2LabelItem = new StiAddressLabelItem("streetAddress2Label", this);
        this.cityLabelItem = new StiAddressLabelItem("cityLabel", this);
        this.stateLabelItem = new StiAddressLabelItem("stateLabel", this);
        this.zipCodeLabelItem = new StiAddressLabelItem("zipCodeLabel", this);
        this.countryLabelItem = new StiAddressLabelItem("countryLabel", this);
        this.useStreetAddress = true;
        this.useStreetAddress2 = true;
        this.useCity = true;
        this.useState = true;
        this.useZipCode = true;
        this.useCountry = true;
        this.maximum = 255;
        this.geometry = new StiRectangleGeometry(150, 200);
        this.label = new StiLabelItem(this, StiLocalizationService.get("Report", "Address"));
        this.geometry.minWidth = 150;
        this.geometry.minHeight = 50;
    }
    setDefaultValues() {
        this.streetAddress = "";
        this.streetAddress2 = "";
        this.city = "";
        this.state = "";
        this.zipCode = "";
        this.country = "";
    }
    setTabIndex(value) {
        this.tabIndex = value;
        return value + 6;
    }
    get contentAreaWidth() {
        let margin = this.padding;
        return this.width - margin.left - margin.right;
    }
    get contentAreaHeight() {
        let margin = this.padding;
        return this.height - margin.top - margin.bottom - 35;
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.font.family, this.arrayOfStylesToString(this.font.style), this.font.size);
        usedFonts.add(this.descriptionFont.family, this.arrayOfStylesToString(this.descriptionFont.style), this.descriptionFont.size);
    }
    getDefaultEditableContent() {
        let textItem = new StiInputTextItem("", this.font, this.textColor, this.backgroundColor, this.contentAlignment);
        textItem.element = this;
        return textItem;
    }
    setProperty(propName, value, oldObject) {
        super.setProperty(propName, value, oldObject);
        if (propName.startsWith("description.font") &&
            (oldObject === null || oldObject.equals(this.descriptionFont))) {
            this.descriptionFont.setProperty(propName.replace("description.font.", ""), value);
        }
        else if (propName == "description.color" &&
            (oldObject === null || oldObject.equals(this.descriptionColor))) {
            this.descriptionColor = value.clone();
        }
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyColor("TextColor", this.textColor);
        jObject.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        jObject.addPropertyJObject("DescriptionFont", this.descriptionFont.saveToJsonObject(options));
        jObject.addPropertyColor("DescriptionColor", this.descriptionColor);
        jObject.addPropertyColor("BorderColor", this.borderColor);
        jObject.addPropertyString("StreetAddress", this.streetAddress);
        jObject.addPropertyString("StreetAddress2", this.streetAddress2);
        jObject.addPropertyString("City", this.city);
        jObject.addPropertyString("State", this.state);
        jObject.addPropertyString("ZipCode", this.zipCode);
        jObject.addPropertyString("Country", this.country);
        jObject.addPropertyString("StreetAddressLabel", this.streetAddressLabel);
        jObject.addPropertyString("StreetAddress2Label", this.streetAddress2Label);
        jObject.addPropertyString("CityLabel", this.cityLabel);
        jObject.addPropertyString("StateLabel", this.stateLabel);
        jObject.addPropertyString("ZipCodeLabel", this.zipCodeLabel);
        jObject.addPropertyString("CountryLabel", this.countryLabel);
        jObject.addPropertyEnum("BorderWeight", StiLineWeight, this.borderWeight);
        jObject.addPropertyEnum("ContentAlignment", StiHorizontalAlignment, this.contentAlignment);
        jObject.addPropertyBool("UseCity", this.useCity);
        jObject.addPropertyBool("UseCountry", this.useCountry);
        jObject.addPropertyBool("UseState", this.useState);
        jObject.addPropertyBool("UseStreetAddress", this.useStreetAddress);
        jObject.addPropertyBool("UseStreetAddress2", this.useStreetAddress2);
        jObject.addPropertyBool("UseZipCode", this.useZipCode);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "DescriptionColor":
                    this.descriptionColor = new Color();
                    this.descriptionColor.deserializeFromString(property.value);
                    break;
                case "TextColor":
                    this.textColor = new Color();
                    this.textColor.deserializeFromString(property.value);
                    break;
                case "BorderColor":
                    this.borderColor = new Color();
                    this.borderColor.deserializeFromString(property.value);
                    break;
                case "Font":
                    this.font = new Font();
                    this.font.loadFromJsonObject(property.value);
                    break;
                case "DescriptionFont":
                    this.descriptionFont = new Font();
                    this.descriptionFont.loadFromJsonObject(property.value);
                    break;
                case "StreetAddress":
                    this.streetAddress = property.value;
                    break;
                case "StreetAddress2":
                    this.streetAddress2 = property.value;
                    break;
                case "City":
                    this.city = property.value;
                    break;
                case "State":
                    this.state = property.value;
                    break;
                case "ZipCode":
                    this.zipCode = property.value;
                    break;
                case "Country":
                    this.country = property.value;
                    break;
                case "StreetAddressLabel":
                    this.streetAddressLabel = property.value;
                    break;
                case "StreetAddress2Label":
                    this.streetAddress2Label = property.value;
                    break;
                case "CityLabel":
                    this.cityLabel = property.value;
                    break;
                case "StateLabel":
                    this.stateLabel = property.value;
                    break;
                case "ZipCodeLabel":
                    this.zipCodeLabel = property.value;
                    break;
                case "CountryLabel":
                    this.countryLabel = property.value;
                    break;
                case "BorderWeight":
                    this.borderWeight = Enum.parse(StiLineWeight, property.value);
                    break;
                case "ContentAlignment":
                    this.contentAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "UseCity":
                    this.useCity = property.value;
                    break;
                case "UseCountry":
                    this.useCountry = property.value;
                    break;
                case "UseState":
                    this.useState = property.value;
                    break;
                case "UseStreetAddress":
                    this.useStreetAddress = property.value;
                    break;
                case "UseStreetAddress2":
                    this.useStreetAddress2 = property.value;
                    break;
                case "UseZipCode":
                    this.useZipCode = property.value;
                    break;
            }
        }
    }
    htmlStyle() {
        return `${this.font.htmlStyle()};color:${this.textColor.toHtmlColor()};text-align:${Enum.getName(StiHorizontalAlignment, this.contentAlignment)}`;
    }
    comboBoxHtmlStyle() {
        return `${this.font.htmlStyle()};color:${this.textColor.toHtmlColor()}}`;
    }
}

class StiBarcodeElement extends StiFormElement {
    constructor() {
        super();
        this.type = "BarCodeElement";
        this.tooltip = "";
        this._description = new StiTextItem();
        this._barcodeType = StiBarcodeType.QRCode;
        this._matrixSize = StiQRCodeSize.Automatic;
        this._errorCorrectionLevel = StiQRCodeErrorCorrectionLevel.Level1;
        this._bodyBrushType = StiBodyBrush.Solid;
        this._bodyBrushColor = Color.black();
        this._startBodyBrushColor = Color.black();
        this._endBodyBrushColor = Color.black();
        this._bodyBrushBackColor = Color.transparent();
        this._bodyBrushForeColor = Color.black();
        this._bodyShapeType = StiQRCodeBodyShapeType.Square;
        this._bodyBrushAngle = 0;
        this._bodyBrushHatchStyle = HatchStyle.Horizontal;
        this._bodyBrushFocus = 0.5;
        this._bodyBrushBlend = 0.2;
        this._bodyBrushDrawHatch = false;
        this._eyeBallBrushType = StiBodyBrush.Solid;
        this._eyeBallBrushColor = Color.black();
        this._startEyeBallBrushColor = Color.black();
        this._endEyeBallBrushColor = Color.black();
        this._eyeBallBrushBackColor = Color.transparent();
        this._eyeBallBrushForeColor = Color.black();
        this._eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
        this._eyeBallBrushAngle = 0;
        this._eyeBallBrushHatchStyle = HatchStyle.Horizontal;
        this._eyeBallBrushFocus = 0.5;
        this._eyeBallBrushBlend = 0.2;
        this._eyeBallBrushDrawHatch = false;
        this._eyeFrameBrushType = StiBodyBrush.Solid;
        this._eyeFrameBrushColor = Color.black();
        this._startEyeFrameBrushColor = Color.black();
        this._endEyeFrameBrushColor = Color.black();
        this._eyeFrameBrushBackColor = Color.transparent();
        this._eyeFrameBrushForeColor = Color.black();
        this._eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
        this._eyeFrameBrushAngle = 0;
        this._eyeFrameBrushHatchStyle = HatchStyle.Horizontal;
        this._eyeFrameBrushFocus = 0.5;
        this._eyeFrameBrushBlend = 0.2;
        this._eyeFrameBrushDrawHatch = false;
        this._codeString = StiLocalizationService.get("Components", "StiBarCode");
        this._width = 90;
        this._height = 90;
        this._style = 1;
        this._backColor = Color.transparent();
        this._foreColor = Color.black();
        this.showProgress = false;
        this.showBodyBrushEditor = false;
        this.showEyeBallBrushEditor = false;
        this.showEyeFrameBrushEditor = false;
        this.geometry = new StiRectangleGeometry(170, 110);
        this.label = new StiLabelItem(this, StiLocalizationService.get("Components", "StiBarCode"));
        this.backColor = Color.transparent();
        this.foreColor = Color.black();
        this.bodyBrushColor = Color.black();
        this.startBodyBrushColor = Color.black();
        this.endBodyBrushColor = Color.black();
        this.bodyBrushBackColor = Color.transparent();
        this.bodyBrushForeColor = Color.black();
        this.eyeBallBrushColor = Color.black();
        this.startEyeBallBrushColor = Color.black();
        this.endEyeBallBrushColor = Color.black();
        this.eyeBallBrushBackColor = Color.transparent();
        this.eyeBallBrushForeColor = Color.black();
        this.eyeFrameBrushColor = Color.black();
        this.startEyeFrameBrushColor = Color.black();
        this.endEyeFrameBrushColor = Color.black();
        this.eyeFrameBrushBackColor = Color.transparent();
        this.eyeFrameBrushForeColor = Color.black();
    }
    propertyChanged(propName) {
        this._isChanged = true;
    }
    get backColor() {
        return this._backColor;
    }
    set backColor(value) {
        let oldValue = this._backColor;
        if (oldValue != value) {
            this._backColor = value;
            this._backColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get foreColor() {
        return this._foreColor;
    }
    set foreColor(value) {
        let oldValue = this._foreColor;
        if (oldValue != value) {
            this._foreColor = value;
            value.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get style() {
        return this._style;
    }
    set style(value) {
        let oldValue = this._style;
        if (oldValue != value) {
            this._style = value;
            this.setStyle(value);
            this._isChanged = true;
        }
    }
    get Width() {
        return this._width;
    }
    set Width(value) {
        let oldValue = this._width;
        if (oldValue != value) {
            this._width = value;
            this._isChanged = true;
        }
    }
    get Height() {
        return this._height;
    }
    set Height(value) {
        let oldValue = this._height;
        if (oldValue != value) {
            this._height = value;
            this._isChanged = true;
        }
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    isChanged() {
        var _a, _b;
        return super.isChanged() || ((_a = this.label) === null || _a === void 0 ? void 0 : _a.isChanged()) || ((_b = this.description) === null || _b === void 0 ? void 0 : _b.isChanged());
    }
    setStyle(value) {
        switch (value) {
            case 1:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Solid;
                this.bodyBrushColor = Color.black();
                this.bodyShapeType = StiQRCodeBodyShapeType.Square;
                this.eyeBallBrushType = StiBodyBrush.Solid;
                this.eyeBallBrushColor = Color.black();
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Solid;
                this.eyeFrameBrushColor = Color.black();
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 2:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Solid;
                this.bodyBrushColor = Color.fromArgb(96, 75, 117);
                this.bodyShapeType = StiQRCodeBodyShapeType.Diamond;
                this.eyeBallBrushType = StiBodyBrush.Gradient;
                this.startEyeBallBrushColor = Color.fromArgb(3, 152, 152);
                this.endEyeBallBrushColor = Color.fromArgb(44, 110, 154);
                this.eyeBallBrushAngle = 30;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Round1;
                this.eyeFrameBrushType = StiBodyBrush.Glass;
                this.eyeFrameBrushColor = Color.fromArgb(118, 202, 226);
                this.eyeFrameBrushDrawHatch = false;
                this.eyeFrameBrushBlend = 0.2;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Round1;
                break;
            case 3:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Solid;
                this.bodyBrushColor = Color.fromArgb(85, 85, 85);
                this.bodyShapeType = StiQRCodeBodyShapeType.Circle;
                this.eyeBallBrushType = StiBodyBrush.Glare;
                this.startEyeBallBrushColor = Color.fromArgb(100, 115, 53);
                this.endEyeBallBrushColor = Color.fromArgb(137, 73, 106);
                this.eyeBallBrushAngle = 5;
                this.eyeBallBrushFocus = 0.5;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Circle;
                this.eyeFrameBrushType = StiBodyBrush.Glass;
                this.eyeFrameBrushColor = Color.fromArgb(57, 94, 133);
                this.eyeFrameBrushDrawHatch = false;
                this.eyeFrameBrushBlend = 0.2;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Circle;
                break;
            case 4:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Glare;
                this.startBodyBrushColor = Color.fromArgb(116, 46, 44);
                this.endBodyBrushColor = Color.fromArgb(33, 77, 132);
                this.bodyBrushAngle = 7;
                this.bodyBrushFocus = 0.9;
                this.bodyShapeType = StiQRCodeBodyShapeType.RoundedSquare;
                this.eyeBallBrushType = StiBodyBrush.Hatch;
                this.eyeBallBrushHatchStyle = HatchStyle.LargeCheckerBoard;
                this.eyeBallBrushForeColor = Color.fromArgb(120, 57, 72);
                this.eyeBallBrushBackColor = Color.fromArgb(105, 82, 137);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Round;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(90, 1, 179);
                this.endEyeFrameBrushColor = Color.fromArgb(59, 73, 144);
                this.eyeFrameBrushAngle = 30;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Round;
                break;
            case 5:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Glare;
                this.startBodyBrushColor = Color.fromArgb(184, 5, 8);
                this.endBodyBrushColor = Color.fromArgb(48, 117, 132);
                this.bodyBrushAngle = 3;
                this.bodyBrushFocus = 0.5;
                this.bodyShapeType = StiQRCodeBodyShapeType.ZebraCross1;
                this.eyeBallBrushType = StiBodyBrush.Solid;
                this.eyeBallBrushColor = Color.fromArgb(12, 172, 172);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Circle;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(191, 0, 178);
                this.endEyeFrameBrushColor = Color.fromArgb(193, 0, 64);
                this.eyeFrameBrushAngle = 10;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Round1;
                break;
            case 6:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Glare;
                this.startBodyBrushColor = Color.fromArgb(73, 57, 99);
                this.endBodyBrushColor = Color.fromArgb(1, 123, 46);
                this.bodyBrushAngle = 3;
                this.bodyBrushFocus = 0.5;
                this.bodyShapeType = StiQRCodeBodyShapeType.Dot;
                this.eyeBallBrushType = StiBodyBrush.Solid;
                this.eyeBallBrushColor = Color.fromArgb(36, 82, 143);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Dots;
                this.eyeFrameBrushType = StiBodyBrush.Glare;
                this.startEyeFrameBrushColor = Color.fromArgb(179, 1, 166);
                this.endEyeFrameBrushColor = Color.fromArgb(49, 53, 28);
                this.eyeFrameBrushAngle = 10;
                this.eyeFrameBrushFocus = 0.8;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Dots;
                break;
            case 7:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Hatch;
                this.bodyBrushHatchStyle = HatchStyle.DashedHorizontal;
                this.bodyBrushForeColor = Color.fromArgb(216, 238, 243);
                this.bodyBrushBackColor = Color.fromArgb(229, 185, 183);
                this.bodyShapeType = StiQRCodeBodyShapeType.Square;
                this.eyeBallBrushType = StiBodyBrush.Gradient;
                this.startEyeBallBrushColor = Color.fromArgb(242, 242, 242);
                this.endEyeBallBrushColor = Color.fromArgb(255, 147, 147);
                this.eyeBallBrushAngle = 4;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Glare;
                this.startEyeFrameBrushColor = Color.fromArgb(178, 161, 199);
                this.endEyeFrameBrushColor = Color.fromArgb(253, 234, 218);
                this.eyeFrameBrushAngle = 4;
                this.eyeFrameBrushFocus = 0.5;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 8:
                this.backColor = Color.fromArgb(87, 118, 157);
                this.bodyBrushType = StiBodyBrush.Gradient;
                this.startBodyBrushColor = Color.fromArgb(219, 238, 243);
                this.endBodyBrushColor = Color.fromArgb(203, 184, 168);
                this.bodyBrushAngle = 5;
                this.bodyShapeType = StiQRCodeBodyShapeType.Dot;
                this.eyeBallBrushType = StiBodyBrush.Gradient;
                this.startEyeBallBrushColor = Color.fromArgb(219, 238, 243);
                this.endEyeBallBrushColor = Color.fromArgb(203, 184, 168);
                this.eyeBallBrushAngle = 5;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(219, 238, 243);
                this.endEyeFrameBrushColor = Color.fromArgb(203, 184, 168);
                this.eyeFrameBrushAngle = 5;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 9:
                this.backColor = Color.fromArgb(144, 60, 57);
                this.bodyBrushType = StiBodyBrush.Gradient;
                this.startBodyBrushColor = Color.fromArgb(219, 238, 243);
                this.endBodyBrushColor = Color.fromArgb(251, 213, 181);
                this.bodyBrushAngle = 3;
                this.bodyShapeType = StiQRCodeBodyShapeType.Square;
                this.eyeBallBrushType = StiBodyBrush.Gradient;
                this.startEyeBallBrushColor = Color.fromArgb(219, 238, 243);
                this.endEyeBallBrushColor = Color.fromArgb(251, 213, 181);
                this.eyeBallBrushAngle = 3;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(219, 238, 243);
                this.endEyeFrameBrushColor = Color.fromArgb(251, 213, 181);
                this.eyeFrameBrushAngle = 3;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 10:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Hatch;
                this.bodyBrushHatchStyle = HatchStyle.DashedHorizontal;
                this.bodyBrushForeColor = Color.fromArgb(219, 238, 243);
                this.bodyBrushBackColor = Color.fromArgb(229, 185, 183);
                this.bodyShapeType = StiQRCodeBodyShapeType.Square;
                this.eyeBallBrushType = StiBodyBrush.Hatch;
                this.eyeBallBrushHatchStyle = HatchStyle.DashedHorizontal;
                this.eyeBallBrushForeColor = Color.fromArgb(219, 238, 243);
                this.eyeBallBrushBackColor = Color.fromArgb(229, 185, 183);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Hatch;
                this.eyeFrameBrushHatchStyle = HatchStyle.DashedHorizontal;
                this.eyeFrameBrushForeColor = Color.fromArgb(219, 238, 243);
                this.eyeFrameBrushBackColor = Color.fromArgb(229, 185, 183);
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 11:
                this.foreColor = Color.fromArgb(191, 178, 205);
                this.backColor = Color.fromArgb(38, 38, 38);
                this.bodyBrushType = StiBodyBrush.Gradient;
                this.startBodyBrushColor = Color.fromArgb(254, 243, 255);
                this.endBodyBrushColor = Color.fromArgb(154, 143, 167);
                this.bodyBrushAngle = 1;
                this.bodyShapeType = StiQRCodeBodyShapeType.Diamond;
                this.eyeBallBrushType = StiBodyBrush.Empty;
                this.startEyeBallBrushColor = Color.fromArgb(254, 243, 255);
                this.endEyeBallBrushColor = Color.fromArgb(154, 143, 167);
                this.eyeBallBrushAngle = 3;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Empty;
                this.startEyeFrameBrushColor = Color.fromArgb(254, 243, 255);
                this.endEyeFrameBrushColor = Color.fromArgb(154, 143, 16);
                this.eyeFrameBrushAngle = 1;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 12:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Glare;
                this.startBodyBrushColor = Color.fromArgb(178, 161, 199);
                this.endBodyBrushColor = Color.fromArgb(0, 255, 120);
                this.bodyBrushAngle = 3;
                this.bodyBrushFocus = 0.5;
                this.bodyShapeType = StiQRCodeBodyShapeType.Dot;
                this.eyeBallBrushType = StiBodyBrush.Solid;
                this.eyeBallBrushColor = Color.fromArgb(141, 179, 226);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Dots;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(255, 147, 251);
                this.endEyeFrameBrushColor = Color.fromArgb(146, 208, 80);
                this.eyeFrameBrushAngle = 4;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Dots;
                break;
            case 13:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Solid;
                this.bodyBrushColor = Color.fromArgb(28, 125, 138);
                this.bodyShapeType = StiQRCodeBodyShapeType.ZebraVertical;
                this.eyeBallBrushType = StiBodyBrush.Solid;
                this.eyeBallBrushColor = Color.fromArgb(211, 136, 84);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.ZebraHorizontal;
                this.eyeFrameBrushType = StiBodyBrush.Solid;
                this.eyeFrameBrushColor = Color.fromArgb(88, 66, 111);
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Round;
                break;
            case 14:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Solid;
                this.bodyBrushColor = Color.fromArgb(34, 82, 94);
                this.bodyShapeType = StiQRCodeBodyShapeType.RoundedSquare;
                this.eyeBallBrushType = StiBodyBrush.Solid;
                this.eyeBallBrushColor = Color.fromArgb(34, 82, 94);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Solid;
                this.eyeFrameBrushColor = Color.fromArgb(34, 82, 94);
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 15:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Hatch;
                this.bodyBrushHatchStyle = HatchStyle.DarkHorizontal;
                this.bodyBrushForeColor = Color.fromArgb(176, 71, 67);
                this.bodyBrushBackColor = Color.fromArgb(91, 139, 150);
                this.bodyShapeType = StiQRCodeBodyShapeType.Square;
                this.eyeBallBrushType = StiBodyBrush.Glare;
                this.startEyeBallBrushColor = Color.fromArgb(191, 183, 184);
                this.endEyeBallBrushColor = Color.fromArgb(199, 29, 28);
                this.eyeBallBrushAngle = 30;
                this.eyeBallBrushFocus = 0.5;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Glare;
                this.startEyeFrameBrushColor = Color.fromArgb(102, 79, 128);
                this.endEyeFrameBrushColor = Color.fromArgb(189, 95, 32);
                this.eyeFrameBrushAngle = 0;
                this.eyeFrameBrushFocus = 0;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 16:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Gradient;
                this.startBodyBrushColor = Color.fromArgb(147, 60, 53);
                this.endBodyBrushColor = Color.fromArgb(122, 106, 66);
                this.bodyBrushAngle = 3;
                this.bodyShapeType = StiQRCodeBodyShapeType.ZebraCross2;
                this.eyeBallBrushType = StiBodyBrush.Gradient;
                this.startEyeBallBrushColor = Color.fromArgb(147, 60, 53);
                this.endEyeBallBrushColor = Color.fromArgb(122, 106, 66);
                this.eyeBallBrushAngle = 3;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(147, 60, 53);
                this.endEyeFrameBrushColor = Color.fromArgb(122, 106, 66);
                this.eyeFrameBrushAngle = 3;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 17:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Gradient;
                this.startBodyBrushColor = Color.fromArgb(203, 7, 203);
                this.endBodyBrushColor = Color.fromArgb(18, 158, 177);
                this.bodyBrushAngle = 5;
                this.bodyShapeType = StiQRCodeBodyShapeType.Square;
                this.eyeBallBrushType = StiBodyBrush.Gradient;
                this.startEyeBallBrushColor = Color.fromArgb(203, 7, 203);
                this.endEyeBallBrushColor = Color.fromArgb(18, 158, 177);
                this.eyeBallBrushAngle = 5;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Square;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(203, 7, 203);
                this.endEyeFrameBrushColor = Color.fromArgb(18, 158, 177);
                this.eyeFrameBrushAngle = 5;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Square;
                break;
            case 18:
                this.backColor = Color.transparent();
                this.bodyBrushType = StiBodyBrush.Gradient;
                this.startBodyBrushColor = Color.fromArgb(138, 57, 0);
                this.endBodyBrushColor = Color.fromArgb(137, 3, 15);
                this.bodyBrushAngle = 3;
                this.bodyShapeType = StiQRCodeBodyShapeType.Star;
                this.eyeBallBrushType = StiBodyBrush.Hatch;
                this.eyeBallBrushHatchStyle = HatchStyle.Plaid;
                this.eyeBallBrushForeColor = Color.fromArgb(81, 68, 115);
                this.eyeBallBrushBackColor = Color.fromArgb(125, 42, 35);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Round3;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(131, 50, 49);
                this.endEyeFrameBrushColor = Color.fromArgb(42, 82, 92);
                this.eyeFrameBrushAngle = 8;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Round3;
                break;
            case 19:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Glare;
                this.startBodyBrushColor = Color.fromArgb(0, 226, 120);
                this.endBodyBrushColor = Color.yellow();
                this.bodyBrushAngle = 3;
                this.bodyBrushFocus = 0.5;
                this.bodyShapeType = StiQRCodeBodyShapeType.ZebraCross1;
                this.eyeBallBrushType = StiBodyBrush.Gradient;
                this.startEyeBallBrushColor = Color.fromArgb(178, 161, 199);
                this.endEyeBallBrushColor = Color.white();
                this.eyeBallBrushAngle = 4;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.ZebraVertical;
                this.eyeFrameBrushType = StiBodyBrush.Hatch;
                this.eyeFrameBrushHatchStyle = HatchStyle.DarkVertical;
                this.eyeFrameBrushForeColor = Color.fromArgb(253, 234, 218);
                this.eyeFrameBrushBackColor = Color.fromArgb(198, 217, 240);
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Dots;
                break;
            case 20:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Glare;
                this.startBodyBrushColor = Color.fromArgb(255, 147, 147);
                this.endBodyBrushColor = Color.fromArgb(219, 238, 243);
                this.bodyBrushAngle = 0;
                this.bodyBrushFocus = 0.5;
                this.bodyShapeType = StiQRCodeBodyShapeType.ZebraCross2;
                this.eyeBallBrushType = StiBodyBrush.Glass;
                this.eyeBallBrushColor = Color.fromArgb(147, 255, 255);
                this.eyeBallBrushDrawHatch = false;
                this.eyeBallBrushBlend = 0.2;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Circle;
                this.eyeFrameBrushType = StiBodyBrush.Gradient;
                this.startEyeFrameBrushColor = Color.fromArgb(255, 147, 251);
                this.endEyeFrameBrushColor = Color.fromArgb(255, 147, 14);
                this.eyeFrameBrushAngle = 5;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Round1;
                break;
            case 21:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Gradient;
                this.startBodyBrushColor = Color.white();
                this.endBodyBrushColor = Color.fromArgb(165, 165, 165);
                this.bodyBrushAngle = 3;
                this.bodyShapeType = StiQRCodeBodyShapeType.Circle;
                this.eyeBallBrushType = StiBodyBrush.Glare;
                this.startEyeBallBrushColor = Color.fromArgb(215, 227, 188);
                this.endEyeBallBrushColor = Color.fromArgb(255, 147, 251);
                this.eyeBallBrushAngle = 5;
                this.eyeBallBrushFocus = 0.5;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Circle;
                this.eyeFrameBrushType = StiBodyBrush.Glass;
                this.eyeFrameBrushColor = Color.fromArgb(219, 229, 241);
                this.eyeFrameBrushDrawHatch = false;
                this.eyeFrameBrushBlend = 0.2;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Circle;
                break;
            case 22:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Glare;
                this.startBodyBrushColor = Color.fromArgb(229, 182, 183);
                this.endBodyBrushColor = Color.fromArgb(141, 179, 226);
                this.bodyBrushAngle = 7;
                this.bodyBrushFocus = 0.9;
                this.bodyShapeType = StiQRCodeBodyShapeType.RoundedSquare;
                this.eyeBallBrushType = StiBodyBrush.Hatch;
                this.eyeBallBrushHatchStyle = HatchStyle.LargeCheckerBoard;
                this.eyeBallBrushForeColor = Color.fromArgb(204, 193, 217);
                this.eyeBallBrushBackColor = Color.fromArgb(242, 220, 219);
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Round;
                this.eyeFrameBrushType = StiBodyBrush.Glare;
                this.startEyeFrameBrushColor = Color.fromArgb(201, 147, 255);
                this.endEyeFrameBrushColor = Color.fromArgb(219, 229, 241);
                this.eyeFrameBrushAngle = 5;
                this.eyeFrameBrushFocus = 0.5;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Round;
                break;
            case 23:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Gradient;
                this.startBodyBrushColor = Color.fromArgb(165, 165, 165);
                this.endBodyBrushColor = Color.white();
                this.bodyBrushAngle = 3;
                this.bodyShapeType = StiQRCodeBodyShapeType.Diamond;
                this.eyeBallBrushType = StiBodyBrush.Glare;
                this.startEyeBallBrushColor = Color.fromArgb(147, 255, 255);
                this.endEyeBallBrushColor = Color.fromArgb(112, 48, 160);
                this.eyeBallBrushAngle = 5;
                this.eyeBallBrushFocus = 0.5;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Round1;
                this.eyeFrameBrushType = StiBodyBrush.Glass;
                this.eyeFrameBrushColor = Color.fromArgb(216, 238, 243);
                this.eyeFrameBrushDrawHatch = false;
                this.eyeFrameBrushBlend = 0.2;
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Round1;
                break;
            case 24:
                this.backColor = Color.fromArgb(37, 86, 99);
                this.bodyBrushType = StiBodyBrush.Glare;
                this.startBodyBrushColor = Color.fromArgb(255, 40, 100);
                this.endBodyBrushColor = Color.fromArgb(146, 215, 80);
                this.bodyBrushAngle = 3;
                this.bodyBrushFocus = 0.5;
                this.bodyShapeType = StiQRCodeBodyShapeType.ZebraHorizontal;
                this.eyeBallBrushType = StiBodyBrush.Gradient;
                this.startEyeBallBrushColor = Color.fromArgb(0, 176, 240);
                this.endEyeBallBrushColor = Color.fromArgb(229, 224, 236);
                this.eyeBallBrushAngle = 0;
                this.eyeBallShapeType = StiQRCodeEyeBallShapeType.Star;
                this.eyeFrameBrushType = StiBodyBrush.Hatch;
                this.eyeFrameBrushHatchStyle = HatchStyle.DashedUpwardDiagonal;
                this.eyeFrameBrushForeColor = Color.fromArgb(184, 204, 228);
                this.eyeFrameBrushBackColor = Color.fromArgb(178, 161, 199);
                this.eyeFrameShapeType = StiQRCodeEyeFrameShapeType.Circle;
                break;
        }
    }
    resetChanged() {
        super.resetChanged();
        if (this.label != null) {
            this.label.resetChanged();
        }
        if (this.description != null) {
            this.description.resetChanged();
        }
    }
    get description() {
        return this._description;
    }
    set description(value) {
        let oldValue = this._description;
        if (oldValue != value) {
            this._description = value;
            this._isChanged = true;
        }
    }
    get barcodeType() {
        return this._barcodeType;
    }
    set barcodeType(value) {
        let oldValue = this._barcodeType;
        if (oldValue != value) {
            this._barcodeType = value;
            this._isChanged = true;
        }
    }
    get matrixSize() {
        return this._matrixSize;
    }
    set matrixSize(value) {
        let oldValue = this._matrixSize;
        if (oldValue != value) {
            this._matrixSize = value;
            this._isChanged = true;
        }
    }
    get errorCorrectionLevel() {
        return this._errorCorrectionLevel;
    }
    set errorCorrectionLevel(value) {
        let oldValue = this._errorCorrectionLevel;
        if (oldValue != value) {
            this._errorCorrectionLevel = value;
            this._isChanged = true;
        }
    }
    get codeString() {
        return this._codeString;
    }
    set codeString(value) {
        let oldValue = this._codeString;
        if (oldValue != value) {
            this._codeString = value;
            this._isChanged = true;
        }
    }
    get eyeBallBrushType() {
        return this._eyeBallBrushType;
    }
    set eyeBallBrushType(value) {
        let oldValue = this._eyeBallBrushType;
        if (oldValue != value) {
            this._eyeBallBrushType = value;
            this._isChanged = true;
        }
    }
    get eyeBallBrushColor() {
        return this._eyeBallBrushColor;
    }
    set eyeBallBrushColor(value) {
        let oldValue = this._eyeBallBrushColor;
        if (oldValue != value) {
            this._eyeBallBrushColor = value;
            this._eyeBallBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get startEyeBallBrushColor() {
        return this._startEyeBallBrushColor;
    }
    set startEyeBallBrushColor(value) {
        let oldValue = this._startEyeBallBrushColor;
        if (oldValue != value) {
            this._startEyeBallBrushColor = value;
            this._startEyeBallBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get endEyeBallBrushColor() {
        return this._endEyeBallBrushColor;
    }
    set endEyeBallBrushColor(value) {
        let oldValue = this._endEyeBallBrushColor;
        if (oldValue != value) {
            this._endEyeBallBrushColor = value;
            this._endEyeBallBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get eyeBallBrushBackColor() {
        return this._eyeBallBrushBackColor;
    }
    set eyeBallBrushBackColor(value) {
        let oldValue = this._eyeBallBrushBackColor;
        if (oldValue != value) {
            this._eyeBallBrushBackColor = value;
            this._eyeBallBrushBackColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get eyeBallBrushForeColor() {
        return this._eyeBallBrushForeColor;
    }
    set eyeBallBrushForeColor(value) {
        let oldValue = this._eyeBallBrushForeColor;
        if (oldValue != value) {
            this._eyeBallBrushForeColor = value;
            this._eyeBallBrushForeColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get eyeBallShapeType() {
        return this._eyeBallShapeType;
    }
    set eyeBallShapeType(value) {
        let oldValue = this._eyeBallShapeType;
        if (oldValue != value) {
            this._eyeBallShapeType = value;
            this._isChanged = true;
        }
    }
    get eyeBallBrushAngle() {
        return this._eyeBallBrushAngle;
    }
    set eyeBallBrushAngle(value) {
        let oldValue = this._eyeBallBrushAngle;
        if (oldValue != value) {
            if (value <= 0) {
                this._eyeBallBrushAngle = 0;
            }
            else {
                this._eyeBallBrushAngle = value;
            }
            this._isChanged = true;
        }
    }
    get eyeBallBrushHatchStyle() {
        return this._eyeBallBrushHatchStyle;
    }
    set eyeBallBrushHatchStyle(value) {
        let oldValue = this._eyeBallBrushHatchStyle;
        if (oldValue != value) {
            this._eyeBallBrushHatchStyle = value;
            this._isChanged = true;
        }
    }
    get eyeBallBrushFocus() {
        return this._eyeBallBrushFocus;
    }
    set eyeBallBrushFocus(value) {
        let oldValue = this._eyeBallBrushFocus;
        if (oldValue != value) {
            if (value <= 0) {
                this._eyeBallBrushFocus = 0;
            }
            else {
                this._eyeBallBrushFocus = value;
            }
            this._isChanged = true;
        }
    }
    get eyeBallBrushBlend() {
        return this._eyeBallBrushBlend;
    }
    set eyeBallBrushBlend(value) {
        let oldValue = this._eyeBallBrushBlend;
        if (oldValue != value) {
            if (value <= 0) {
                this._eyeBallBrushBlend = 0;
            }
            else {
                this._eyeBallBrushBlend = value;
            }
            this._isChanged = true;
        }
    }
    get eyeBallBrushDrawHatch() {
        return this._eyeBallBrushDrawHatch;
    }
    set eyeBallBrushDrawHatch(value) {
        let oldValue = this._eyeBallBrushDrawHatch;
        if (oldValue != value) {
            this._eyeBallBrushDrawHatch = value;
            this._isChanged = true;
        }
    }
    get bodyBrushType() {
        return this._bodyBrushType;
    }
    set bodyBrushType(value) {
        let oldValue = this._bodyBrushType;
        if (oldValue != value) {
            this._bodyBrushType = value;
            this._isChanged = true;
        }
    }
    get bodyBrushColor() {
        return this._bodyBrushColor;
    }
    set bodyBrushColor(value) {
        let oldValue = this._bodyBrushColor;
        if (oldValue != value) {
            this._bodyBrushColor = value;
            this._bodyBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get startBodyBrushColor() {
        return this._startBodyBrushColor;
    }
    set startBodyBrushColor(value) {
        let oldValue = this._startBodyBrushColor;
        if (oldValue != value) {
            this._startBodyBrushColor = value;
            this._startBodyBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get endBodyBrushColor() {
        return this._endBodyBrushColor;
    }
    set endBodyBrushColor(value) {
        let oldValue = this._endBodyBrushColor;
        if (oldValue != value) {
            this._endBodyBrushColor = value;
            this._endBodyBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get bodyBrushBackColor() {
        return this._bodyBrushBackColor;
    }
    set bodyBrushBackColor(value) {
        let oldValue = this._bodyBrushBackColor;
        if (oldValue != value) {
            this._bodyBrushBackColor = value;
            this._bodyBrushBackColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get bodyBrushForeColor() {
        return this._bodyBrushForeColor;
    }
    set bodyBrushForeColor(value) {
        let oldValue = this._bodyBrushForeColor;
        if (oldValue != value) {
            this._bodyBrushForeColor = value;
            this._bodyBrushForeColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get bodyShapeType() {
        return this._bodyShapeType;
    }
    set bodyShapeType(value) {
        let oldValue = this._bodyShapeType;
        if (oldValue != value) {
            this._bodyShapeType = value;
            this._isChanged = true;
        }
    }
    get bodyBrushAngle() {
        return this._bodyBrushAngle;
    }
    set bodyBrushAngle(value) {
        let oldValue = this._bodyBrushAngle;
        if (oldValue != value) {
            if (value <= 0) {
                this._bodyBrushAngle = 0;
            }
            else {
                this._bodyBrushAngle = value;
            }
            this._isChanged = true;
        }
    }
    get bodyBrushHatchStyle() {
        return this._bodyBrushHatchStyle;
    }
    set bodyBrushHatchStyle(value) {
        let oldValue = this._bodyBrushHatchStyle;
        if (oldValue != value) {
            this._bodyBrushHatchStyle = value;
            this._isChanged = true;
        }
    }
    get bodyBrushFocus() {
        return this._bodyBrushFocus;
    }
    set bodyBrushFocus(value) {
        let oldValue = this._bodyBrushFocus;
        if (oldValue != value) {
            if (value <= 0) {
                this._bodyBrushFocus = 0;
            }
            else {
                this._bodyBrushFocus = value;
            }
            this._isChanged = true;
        }
    }
    get bodyBrushBlend() {
        return this._bodyBrushBlend;
    }
    set bodyBrushBlend(value) {
        let oldValue = this._bodyBrushBlend;
        if (oldValue != value) {
            if (value <= 0) {
                this._bodyBrushBlend = 0;
            }
            else {
                this._bodyBrushBlend = value;
            }
            this._isChanged = true;
        }
    }
    get bodyBrushDrawHatch() {
        return this._bodyBrushDrawHatch;
    }
    set bodyBrushDrawHatch(value) {
        let oldValue = this._bodyBrushDrawHatch;
        if (oldValue != value) {
            this._bodyBrushDrawHatch = value;
            this._isChanged = true;
        }
    }
    get eyeFrameBrushType() {
        return this._eyeFrameBrushType;
    }
    set eyeFrameBrushType(value) {
        let oldValue = this._eyeFrameBrushType;
        if (oldValue != value) {
            this._eyeFrameBrushType = value;
            this._isChanged = true;
        }
    }
    get eyeFrameBrushColor() {
        return this._eyeFrameBrushColor;
    }
    set eyeFrameBrushColor(value) {
        let oldValue = this._eyeFrameBrushColor;
        if (oldValue != value) {
            this._eyeFrameBrushColor = value;
            this._eyeFrameBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get startEyeFrameBrushColor() {
        return this._startEyeFrameBrushColor;
    }
    set startEyeFrameBrushColor(value) {
        let oldValue = this._startEyeFrameBrushColor;
        if (oldValue != value) {
            this._startEyeFrameBrushColor = value;
            this._startEyeFrameBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get endEyeFrameBrushColor() {
        return this._endEyeFrameBrushColor;
    }
    set endEyeFrameBrushColor(value) {
        let oldValue = this._endEyeFrameBrushColor;
        if (oldValue != value) {
            this._endEyeFrameBrushColor = value;
            this._endEyeFrameBrushColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get eyeFrameBrushBackColor() {
        return this._eyeFrameBrushBackColor;
    }
    set eyeFrameBrushBackColor(value) {
        let oldValue = this._eyeFrameBrushBackColor;
        if (oldValue != value) {
            this._eyeFrameBrushBackColor = value;
            this._eyeFrameBrushBackColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get eyeFrameBrushForeColor() {
        return this._eyeFrameBrushForeColor;
    }
    set eyeFrameBrushForeColor(value) {
        let oldValue = this._eyeFrameBrushForeColor;
        if (oldValue != value) {
            this._eyeFrameBrushForeColor = value;
            this._eyeFrameBrushForeColor.changesInterceptor = this;
            this._isChanged = true;
        }
    }
    get eyeFrameShapeType() {
        return this._eyeFrameShapeType;
    }
    set eyeFrameShapeType(value) {
        let oldValue = this._eyeFrameShapeType;
        if (oldValue != value) {
            this._eyeFrameShapeType = value;
            this._isChanged = true;
        }
    }
    get eyeFrameBrushAngle() {
        return this._eyeFrameBrushAngle;
    }
    set eyeFrameBrushAngle(value) {
        let oldValue = this._eyeFrameBrushAngle;
        if (oldValue != value) {
            if (value <= 0) {
                this._eyeFrameBrushAngle = 0;
            }
            else {
                this._eyeFrameBrushAngle = value;
            }
            this._isChanged = true;
        }
    }
    get eyeFrameBrushHatchStyle() {
        return this._eyeFrameBrushHatchStyle;
    }
    set eyeFrameBrushHatchStyle(value) {
        let oldValue = this._eyeFrameBrushHatchStyle;
        if (oldValue != value) {
            this._eyeFrameBrushHatchStyle = value;
            this._isChanged = true;
        }
    }
    get eyeFrameBrushFocus() {
        return this._eyeFrameBrushFocus;
    }
    set eyeFrameBrushFocus(value) {
        let oldValue = this._eyeFrameBrushFocus;
        if (oldValue != value) {
            if (value <= 0) {
                this._eyeFrameBrushFocus = 0;
            }
            else {
                this._eyeFrameBrushFocus = value;
            }
            this._isChanged = true;
        }
    }
    get eyeFrameBrushBlend() {
        return this._eyeFrameBrushBlend;
    }
    set eyeFrameBrushBlend(value) {
        let oldValue = this._eyeFrameBrushBlend;
        if (oldValue != value) {
            if (value <= 0) {
                this._eyeFrameBrushBlend = 0;
            }
            else {
                this._eyeFrameBrushBlend = value;
            }
            this._isChanged = true;
        }
    }
    get eyeFrameBrushDrawHatch() {
        return this._eyeFrameBrushDrawHatch;
    }
    set eyeFrameBrushDrawHatch(value) {
        let oldValue = this._eyeFrameBrushDrawHatch;
        if (oldValue != value) {
            this._eyeFrameBrushDrawHatch = value;
            this._isChanged = true;
        }
    }
    saveToJsonObject(options) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
        if (this.element && this.element.nativeElement) {
            if (((_a = this.element.nativeElement) === null || _a === void 0 ? void 0 : _a.offsetWidth) > 0 &&
                ((_b = this.element.nativeElement) === null || _b === void 0 ? void 0 : _b.offsetHeight) > 0 &&
                (this.barcodeType == StiBarcodeType.Aztec ||
                    this.barcodeType == StiBarcodeType.QRCode ||
                    this.barcodeType == StiBarcodeType.DataMatrix ||
                    this.barcodeType == StiBarcodeType.Maxicode)) {
                if (((_c = this.element.nativeElement) === null || _c === void 0 ? void 0 : _c.offsetWidth) < ((_d = this.element.nativeElement) === null || _d === void 0 ? void 0 : _d.offsetHeight)) {
                    this.Width = (_e = this.element.nativeElement) === null || _e === void 0 ? void 0 : _e.offsetWidth;
                    this.Height = (_f = this.element.nativeElement) === null || _f === void 0 ? void 0 : _f.offsetWidth;
                }
                else {
                    this.Width = (_g = this.element.nativeElement) === null || _g === void 0 ? void 0 : _g.offsetHeight;
                    this.Height = (_h = this.element.nativeElement) === null || _h === void 0 ? void 0 : _h.offsetHeight;
                }
            }
            else {
                this.Width = (_j = this.element.nativeElement) === null || _j === void 0 ? void 0 : _j.offsetWidth;
                this.Height = (_k = this.element.nativeElement) === null || _k === void 0 ? void 0 : _k.offsetHeight;
            }
        }
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyEnum("BarcodeType", StiBarcodeType, this.barcodeType);
        jObject.addPropertyString("CodeString", this.codeString);
        // jObject.addPropertyString("Tooltip", this.tooltip);
        jObject.addPropertyNumber("Width", this.Width);
        jObject.addPropertyNumber("Height", this.Height);
        jObject.addPropertyNumber("Style", this.style);
        jObject.addPropertyColor("BackColor", this.backColor);
        jObject.addPropertyColor("ForeColor", this.foreColor);
        jObject.addPropertyEnum("MatrixSize", StiQRCodeSize, this.matrixSize);
        jObject.addPropertyEnum("ErrorCorrectionLevel", StiQRCodeErrorCorrectionLevel, this.errorCorrectionLevel);
        jObject.addPropertyEnum("BodyBrushType", StiBodyBrush, this.bodyBrushType);
        jObject.addPropertyEnum("EyeBallBrushType", StiBodyBrush, this.eyeBallBrushType);
        jObject.addPropertyEnum("EyeFrameBrushType", StiBodyBrush, this.eyeFrameBrushType);
        jObject.addPropertyEnum("BodyShapeType", StiQRCodeBodyShapeType, this.bodyShapeType);
        jObject.addPropertyColor("BodyBrushColor", this.bodyBrushColor);
        jObject.addPropertyColor("StartBodyBrushColor", this.startBodyBrushColor);
        jObject.addPropertyColor("EndBodyBrushColor", this.endBodyBrushColor);
        jObject.addPropertyColor("BodyBrushForeColor", this.bodyBrushForeColor);
        jObject.addPropertyColor("BodyBrushBackColor", this.bodyBrushBackColor);
        jObject.addPropertyNumber("BodyBrushAngle", this.bodyBrushAngle);
        jObject.addPropertyEnum("BodyBrushHatchStyle", HatchStyle, this.bodyBrushHatchStyle);
        jObject.addPropertyNumber("BodyBrushFocus", this.bodyBrushFocus);
        jObject.addPropertyNumber("BodyBrushBlend", this.bodyBrushBlend);
        jObject.addPropertyBool("BodyBrushDrawHatch", this.bodyBrushDrawHatch);
        jObject.addPropertyColor("EyeBallBrushColor", this.eyeBallBrushColor);
        jObject.addPropertyColor("StartEyeBallBrushColor", this.startEyeBallBrushColor);
        jObject.addPropertyColor("EndEyeBallBrushColor", this.endEyeBallBrushColor);
        jObject.addPropertyEnum("EyeBallShapeType", StiQRCodeEyeBallShapeType, this.eyeBallShapeType);
        jObject.addPropertyColor("EyeBallBrushForeColor", this.eyeBallBrushForeColor);
        jObject.addPropertyColor("EyeBallBrushBackColor", this.eyeBallBrushBackColor);
        jObject.addPropertyNumber("EyeBallBrushAngle", this.eyeBallBrushAngle);
        jObject.addPropertyNumber("EyeBallBrushBlend", this.eyeBallBrushBlend);
        jObject.addPropertyEnum("EyeBallBrushHatchStyle", HatchStyle, this.eyeBallBrushHatchStyle);
        jObject.addPropertyNumber("EyeBallBrushFocus", this.eyeBallBrushFocus);
        jObject.addPropertyBool("EyeBallBrushDrawHatch", this.eyeBallBrushDrawHatch);
        jObject.addPropertyColor("EyeFrameBrushColor", this.eyeFrameBrushColor);
        jObject.addPropertyColor("StartEyeFrameBrushColor", this.startEyeFrameBrushColor);
        jObject.addPropertyColor("EndEyeFrameBrushColor", this.endEyeFrameBrushColor);
        jObject.addPropertyEnum("EyeFrameShapeType", StiQRCodeEyeFrameShapeType, this.eyeFrameShapeType);
        jObject.addPropertyColor("EyeFrameBrushForeColor", this.eyeFrameBrushForeColor);
        jObject.addPropertyColor("EyeFrameBrushBackColor", this.eyeFrameBrushBackColor);
        jObject.addPropertyNumber("EyeFrameBrushAngle", this.eyeFrameBrushAngle);
        jObject.addPropertyNumber("EyeFrameBrushBlend", this.eyeFrameBrushBlend);
        jObject.addPropertyEnum("EyeFrameBrushHatchStyle", HatchStyle, this.eyeFrameBrushHatchStyle);
        jObject.addPropertyNumber("EyeFrameBrushFocus", this.eyeFrameBrushFocus);
        jObject.addPropertyBool("EyeFrameBrushDrawHatch", this.eyeFrameBrushDrawHatch);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "BarcodeType":
                    this.barcodeType = Enum.parse(StiBarcodeType, property.value);
                    break;
                case "CodeString":
                    this.codeString = property.value;
                    break;
                /*  case "Tooltip":
                  this.tooltip = property.value;
                  break; */
                case "Width":
                    this.Width = property.value;
                    break;
                case "Height":
                    this.Height = property.value;
                    break;
                case "Style":
                    this.style = property.value;
                    break;
                case "BackColor":
                    this.backColor = new Color();
                    this.backColor.deserializeFromString(property.value);
                    break;
                case "ForeColor":
                    this.foreColor = new Color();
                    this.foreColor.deserializeFromString(property.value);
                    break;
                case "MatrixSize":
                    this.matrixSize = Enum.parse(StiQRCodeSize, property.value, false);
                    break;
                case "ErrorCorrectionLevel":
                    this.errorCorrectionLevel = Enum.parse(StiQRCodeErrorCorrectionLevel, property.value);
                    break;
                case "BodyBrushType":
                    this.bodyBrushType = Enum.parse(StiBodyBrush, property.value);
                    break;
                case "EyeBallBrushType":
                    this.eyeBallBrushType = Enum.parse(StiBodyBrush, property.value);
                    break;
                case "EyeFrameBrushType":
                    this.eyeFrameBrushType = Enum.parse(StiBodyBrush, property.value);
                    break;
                case "BodyShapeType":
                    this.bodyShapeType = Enum.parse(StiQRCodeBodyShapeType, property.value);
                    break;
                case "BodyBrushColor":
                    this.bodyBrushColor = new Color();
                    this.bodyBrushColor.deserializeFromString(property.value);
                    break;
                case "StartBodyBrushColor":
                    this.startBodyBrushColor = new Color();
                    this.startBodyBrushColor.deserializeFromString(property.value);
                    break;
                case "EndBodyBrushColor":
                    this.endBodyBrushColor = new Color();
                    this.endBodyBrushColor.deserializeFromString(property.value);
                    break;
                case "BodyBrushForeColor":
                    this.bodyBrushForeColor = new Color();
                    this.bodyBrushForeColor.deserializeFromString(property.value);
                    break;
                case "BodyBrushBackColor":
                    this.bodyBrushBackColor = new Color();
                    this.bodyBrushBackColor.deserializeFromString(property.value);
                    break;
                case "BodyBrushAngle":
                    this.bodyBrushAngle = property.value;
                    break;
                case "BodyBrushBlend":
                    this.bodyBrushBlend = property.value;
                    break;
                case "EyeBallBrushBlend":
                    this.eyeBallBrushBlend = property.value;
                    break;
                case "EyeFrameBrushBlend":
                    this.eyeFrameBrushBlend = property.value;
                    break;
                case "BodyBrushHatchStyle":
                    this.bodyBrushHatchStyle = Enum.parse(HatchStyle, property.value);
                    break;
                case "BodyBrushFocus":
                    this.bodyBrushFocus = property.value;
                    break;
                case "BodyBrushDrawHatch":
                    this.bodyBrushDrawHatch = property.value;
                    break;
                case "EyeBallBrushColor":
                    this.eyeBallBrushColor = new Color();
                    this.eyeBallBrushColor.deserializeFromString(property.value);
                    break;
                case "StartEyeBallBrushColor":
                    this.startEyeBallBrushColor = new Color();
                    this.startEyeBallBrushColor.deserializeFromString(property.value);
                    break;
                case "EndEyeBallBrushColor":
                    this.endEyeBallBrushColor = new Color();
                    this.endEyeBallBrushColor.deserializeFromString(property.value);
                    break;
                case "EyeBallShapeType":
                    this.eyeBallShapeType = Enum.parse(StiQRCodeEyeBallShapeType, property.value);
                    break;
                case "EyeBallBrushForeColor":
                    this.eyeBallBrushForeColor = new Color();
                    this.eyeBallBrushForeColor.deserializeFromString(property.value);
                    break;
                case "EyeBallBrushBackColor":
                    this.eyeBallBrushBackColor = new Color();
                    this.eyeBallBrushBackColor.deserializeFromString(property.value);
                    break;
                case "EyeBallBrushAngle":
                    this.eyeBallBrushAngle = property.value;
                    break;
                case "EyeBallBrushHatchStyle":
                    this.eyeBallBrushHatchStyle = Enum.parse(HatchStyle, property.value);
                    break;
                case "EyeBallBrushFocus":
                    this.eyeBallBrushFocus = property.value;
                    break;
                case "EyeBallBrushDrawHatch":
                    this.eyeBallBrushDrawHatch = property.value;
                    break;
                case "EyeFrameBrushColor":
                    this.eyeFrameBrushColor = new Color();
                    this.eyeFrameBrushColor.deserializeFromString(property.value);
                    break;
                case "StartEyeFrameBrushColor":
                    this.startEyeFrameBrushColor = new Color();
                    this.startEyeFrameBrushColor.deserializeFromString(property.value);
                    break;
                case "EndEyeFrameBrushColor":
                    this.endEyeFrameBrushColor = new Color();
                    this.endEyeFrameBrushColor.deserializeFromString(property.value);
                    break;
                case "EyeFrameShapeType":
                    this.eyeFrameShapeType = Enum.parse(StiQRCodeEyeFrameShapeType, property.value);
                    break;
                case "EyeFrameBrushForeColor":
                    this.eyeFrameBrushForeColor = new Color();
                    this.eyeFrameBrushForeColor.deserializeFromString(property.value);
                    break;
                case "EyeFrameBrushBackColor":
                    this.eyeFrameBrushBackColor = new Color();
                    this.eyeFrameBrushBackColor.deserializeFromString(property.value);
                    break;
                case "EyeFrameBrushAngle":
                    this.eyeFrameBrushAngle = property.value;
                    break;
                case "EyeFrameBrushHatchStyle":
                    this.eyeFrameBrushHatchStyle = Enum.parse(HatchStyle, property.value);
                    break;
                case "EyeFrameBrushFocus":
                    this.eyeFrameBrushFocus = property.value;
                    break;
                case "EyeFrameBrushDrawHatch":
                    this.eyeFrameBrushDrawHatch = property.value;
                    break;
            }
        }
    }
}

class StiBackgroundedTextItem extends StiTextItem {
    constructor(value = "", font = new Font("Segoe UI", 9), color = Color.black(), backgroundColor = Color.white()) {
        super(value, font, color, backgroundColor);
        this.font = font;
        this.color = color;
        this.backgroundColor = backgroundColor;
    }
    saveToJsonObject(options) {
        let json = super.saveToJsonObject(options);
        json.addPropertyColor("BackgroundColor", this.backgroundColor);
        return json;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
            }
        }
    }
    getBackgroundColor() {
        return this.backgroundColor;
    }
    haveContentAlignment() {
        return false;
    }
    haveBackgoundColor() {
        return true;
    }
}

class StiButtonElement extends StiFormElement {
    constructor() {
        super();
        this.type = "ButtonElement";
        this.tooltip = "";
        this.submissionMessage = "Thank you! Your submission has been sent.";
        this.text = new StiBackgroundedTextItem(StiLocalizationService.get("Buttons", "Submit"), new Font("Segoe UI", 14), Color.black(), Color.lightGray());
        this.buttonType = StiButtonType.SendForm;
        this.formSendURL = "";
        this.buttonSendType = StiButtonSendType.XFDF;
        this.geometry = new StiRectangleGeometry(100, 40);
        this.padding = new StiPadding(4, 0, 4, 0, this);
    }
    canUpdateProperty(propName) {
        return !(propName.indexOf("padding") >= 0);
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.text.font.family, this.arrayOfStylesToString(this.text.font.style), this.text.font.size);
    }
    getDefaultEditableContent() {
        return this.text;
    }
    setProperty(propName, value, oldObject) {
        super.setProperty(propName, value, oldObject);
        if (propName.startsWith("label.font") || propName == "label.color") {
            this.text.setProperty(propName.replace("label.", ""), value.clone ? value.clone() : value, oldObject);
        }
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyString("Tooltip", this.tooltip);
        jObject.addPropertyJObject("Text", this.text.saveToJsonObject(options));
        jObject.addPropertyEnum("ButtonType", StiButtonType, this.buttonType);
        jObject.addPropertyString("FormSendURL", this.formSendURL);
        jObject.addPropertyEnum("ButtonSendType", StiButtonSendType, this.buttonSendType);
        jObject.addPropertyString("SubmissionMessage", this.submissionMessage);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Text":
                    this.text = new StiBackgroundedTextItem();
                    this.text.loadFromJsonObject(property.value);
                    break;
                case "Tooltip":
                    this.tooltip = property.value;
                    break;
                case "ButtonType":
                    this.buttonType = Enum.parse(StiButtonType, property.value);
                    break;
                case "FormSendURL":
                    this.formSendURL = property.value;
                    break;
                case "ButtonSendType":
                    this.buttonSendType = Enum.parse(StiButtonSendType, property.value);
                    break;
                case "SubmissionMessage":
                    this.submissionMessage = property.value;
                    break;
            }
        }
    }
    htmlStyle() {
        return `${this.text.htmlStyle()};
    )}`;
    }
}

class StiCheckBoxElement extends StiFormElement {
    constructor() {
        super();
        this.type = "Check_BoxElement";
        this.tooltip = "";
        this.required = false;
        this.description = new StiTextItem();
        this.text = new StiTextItem(StiLocalizationService.get("Components", "StiCheckBox"), new Font("Segoe UI", 9));
        this.isChecked = false;
        this.backgroundColor = Color.white();
        this.checkColor = Color.black();
        this.borderColor = Color.lightGray();
        this.initialState = false;
        this.geometry = new StiRectangleGeometry(100, 40);
        this.label = new StiLabelItem(this, StiLocalizationService.get("Components", "StiCheckBox"));
    }
    setDefaultValues() {
        this.isChecked = false;
    }
    setTabIndex(value) {
        this.tabIndex = value++;
        return value;
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.text.font.family, this.arrayOfStylesToString(this.text.font.style), this.text.font.size);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    get value() {
        return this.isChecked;
    }
    getDefaultEditableContent() {
        let textItem = new StiInputTextItem("", this.text.font, this.text.color);
        textItem.element = this;
        return textItem;
    }
    setProperty(propName, value, oldObject) {
        super.setProperty(propName, value, oldObject);
        if (propName == "innerText.backgroundColor" &&
            (oldObject === null || this.text.backgroundColor.equals(oldObject))) {
            this.text.backgroundColor = value.clone();
        }
        else if (propName == "innerText.borderColor" && (oldObject === null || this.borderColor.equals(oldObject))) {
            this.borderColor = value.clone();
        }
        else if (propName.startsWith("innerText.font") || propName == "innerText.color") {
            this.text.setProperty(propName.replace("innerText.", ""), value.clone ? value.clone() : value, oldObject);
        }
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyString("Tooltip", this.tooltip);
        jObject.addPropertyBool("Required", this.required);
        jObject.addPropertyJObject("Text", this.text.saveToJsonObject(options));
        jObject.addPropertyBool("IsChecked", this.isChecked);
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyColor("CheckColor", this.checkColor);
        jObject.addPropertyColor("BorderColor", this.borderColor);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Text":
                    this.text = new StiTextItem();
                    this.text.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "Tooltip":
                    this.tooltip = property.value;
                    break;
                case "Required":
                    this.required = property.value;
                    break;
                case "IsChecked":
                    this.isChecked = property.value;
                    break;
                case "BorderColor":
                    this.borderColor = new Color();
                    this.borderColor.deserializeFromString(property.value);
                    break;
                case "CheckColor":
                    this.checkColor = new Color();
                    this.checkColor.deserializeFromString(property.value);
                    break;
            }
        }
    }
    htmlStyle() {
        return `${this.text.htmlStyle()};
    )}`;
    }
}

class StiDateTimeBoxElement extends StiFormElement {
    constructor() {
        super();
        this._dateTimeFormat = "m/d/yy h:MM tt";
        this._dateFomat = "dd.mm.yyyy";
        this._timeFormat = "HH:MM:ss";
        this.type = "DateTime_BoxElement";
        this.tooltip = "";
        this.required = false;
        this.description = new StiTextItem();
        this.font = new Font("Segoe UI", 10);
        this.contentAlignment = StiHorizontalAlignment.Left;
        this.backgroundColor = Color.white();
        this.textColor = Color.black();
        this.borderColor = Color.lightGray();
        this.borderWeight = StiLineWeight.Thin;
        this.valueType = StiDateTimeBoxType.Date;
        this.initialState = StiDateTimeBoxValueChoise.Custom;
        this.allowNull = false;
        this.dateTimeValueIsNotNull = true;
        this.dateValue = "";
        this.geometry = new StiRectangleGeometry(150, 40);
        this.label = new StiLabelItem(this, StiLocalizationService.get("Dialogs", "StiDateTimePickerControl"));
    }
    setDefaultValues() {
        this.initialState = StiDateTimeBoxValueChoise.Current;
    }
    get value() {
        return this.dateValue;
    }
    get dateTimeFormat() {
        return this._dateTimeFormat;
    }
    set dateTimeFormat(value) {
        this._dateTimeFormat = value;
    }
    get dateFormat() {
        return this._dateFomat;
    }
    set dateFormat(value) {
        this._dateFomat = value;
    }
    get timeFormat() {
        return this._timeFormat;
    }
    set timeFormat(value) {
        this._timeFormat = value;
    }
    setTabIndex(value) {
        this.tabIndex = value++;
        return value;
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.font.family, this.arrayOfStylesToString(this.font.style), this.font.size);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    getDefaultEditableContent() {
        let textItem = new StiInputTextItem("", this.font, this.textColor, this.backgroundColor, this.contentAlignment);
        textItem.element = this;
        return textItem;
    }
    htmlStyle() {
        return `${this.font.htmlStyle()};color:${this.textColor.toHtmlColor()};text-align:${Enum.getName(StiHorizontalAlignment, this.contentAlignment)}`;
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyColor("TextColor", this.textColor);
        jObject.addPropertyString("Tooltip", this.tooltip);
        jObject.addPropertyString("DateTimeFormat", this.dateTimeFormat);
        jObject.addPropertyString("DateFormat", this.dateFormat);
        jObject.addPropertyString("TimeFormat", this.timeFormat);
        jObject.addPropertyBool("Required", this.required);
        jObject.addPropertyColor("BorderColor", this.borderColor);
        jObject.addPropertyEnum("BorderWeight", StiLineWeight, this.borderWeight);
        jObject.addPropertyEnum("HorizontalAlignment", StiHorizontalAlignment, this.contentAlignment);
        jObject.addPropertyEnum("ValueType", StiDateTimeBoxType, this.valueType);
        jObject.addPropertyEnum("InitialState", StiDateTimeBoxValueChoise, this.initialState);
        jObject.addPropertyBool("AllowNull", this.allowNull);
        jObject.addPropertyBool("DateTimeValueIsNotNull", this.dateTimeValueIsNotNull);
        if (this.allowNull && !this.dateTimeValueIsNotNull) {
            jObject.addPropertyString("DateValue", null, "");
            jObject.addPropertyString("DateValueString", null, "");
        }
        else {
            jObject.addPropertyString("DateValue", new Date(this.customDate).toJSON());
            jObject.addPropertyString("DateValueString", this.dateValue);
        }
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "TextColor":
                    this.textColor = new Color();
                    this.textColor.deserializeFromString(property.value);
                    break;
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Font":
                    this.font = new Font();
                    this.font.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "Tooltip":
                    this.tooltip = property.value;
                    break;
                case "DateTimeFormat":
                    this.dateTimeFormat = property.value;
                    break;
                case "DateFormat":
                    this.dateFormat = property.value;
                    break;
                case "TimeFormat":
                    this.timeFormat = property.value;
                    break;
                case "Required":
                    this.required = property.value;
                    break;
                case "BorderColor":
                    this.borderColor = new Color();
                    this.borderColor.deserializeFromString(property.value);
                    break;
                case "HorizontalAlignment":
                    this.contentAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "BorderWeight":
                    this.borderWeight = Enum.parse(StiLineWeight, property.value);
                    break;
                case "ValueType":
                    this.valueType = Enum.parse(StiDateTimeBoxType, property.value);
                    break;
                case "InitialState":
                    this.initialState = Enum.parse(StiDateTimeBoxValueChoise, property.value);
                    break;
                case "AllowNull":
                    this.allowNull = property.value;
                    break;
                case "DateTimeValueIsNotNull":
                    this.dateTimeValueIsNotNull = property.value;
                    break;
                case "DateValue":
                    if (property.value.length > 0) {
                        this.customDate = property.value;
                    }
                    else {
                        this.customDate = new Date();
                    }
                    break;
            }
        }
    }
}

class StiStaticHelperService {
    constructor() { }
    static dateToJsonDate(date) {
        let offset = date.getTimezoneOffset() * -1;
        let hoursOffset = Math.abs(Math.floor(offset / 60)).toString();
        let minutesOffset = Math.abs(offset % 60).toString();
        if (hoursOffset.length == 1)
            hoursOffset = "0" + hoursOffset;
        if (minutesOffset.length == 1)
            minutesOffset = "0" + minutesOffset;
        return ("/Date(" + Date.parse(date.toString()).toString() + (offset >= 0 ? "+" : "-") + hoursOffset + minutesOffset + ")/");
    }
    static jsonDateFormatToDate(dateJSONFormat, format) {
        if (dateJSONFormat.substring(0, 6) == "/Date(") {
            var dateStr = dateJSONFormat.replace("/Date(", "").replace(")/", "");
            return typeof format == "boolean"
                ? this.formatDate(new Date(parseInt(dateStr)), "m/d/yy h:MM tt")
                : format
                    ? this.formatDate(new Date(parseInt(dateStr)), format)
                    : new Date(parseInt(dateStr));
        }
        else {
            return dateJSONFormat;
        }
    }
    static formatDate(formatDate, formatString) {
        let yyyy = formatDate.getFullYear();
        let yy = yyyy.toString().substring(2);
        let m = formatDate.getMonth() + 1;
        let mm = m < 10 ? "0" + m : m;
        let d = formatDate.getDate();
        let dd = d < 10 ? "0" + d : d;
        let h = formatDate.getHours();
        let hh = h < 10 ? "0" + h : h;
        let n = formatDate.getMinutes();
        let nn = n < 10 ? "0" + n : n;
        let s = formatDate.getSeconds();
        let ss = s < 10 ? "0" + s : s;
        formatString = formatString.replace(/yyyy/i, yyyy);
        formatString = formatString.replace(/yy/i, yy);
        formatString = formatString.replace(/mm/i, mm);
        formatString = formatString.replace(/m/i, m);
        formatString = formatString.replace(/dd/i, dd);
        formatString = formatString.replace(/d/i, d);
        formatString = formatString.replace(/hh/i, hh);
        formatString = formatString.replace(/h/i, h);
        formatString = formatString.replace(/nn/i, nn);
        formatString = formatString.replace(/n/i, n);
        formatString = formatString.replace(/ss/i, ss);
        formatString = formatString.replace(/s/i, s);
        return formatString;
    }
}
StiStaticHelperService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiStaticHelperService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
StiStaticHelperService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiStaticHelperService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiStaticHelperService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });

class StiDescriptionSettings {
    constructor(changesInterceptor) {
        this.changesInterceptor = changesInterceptor;
        this._font = new Font("Segoe UI", 9, [], this);
        this._color = Color.gray();
        this._color.changesInterceptor = this;
    }
    propertyChanged(propName, value, oldObject) {
        this.changesInterceptor.propertyChanged(`description.${propName}`, value, oldObject);
    }
    get color() {
        return this._color;
    }
    set color(value) {
        let oldValue = this._color.clone();
        this._color = value;
        value.changesInterceptor = this;
        if (oldValue && !oldValue.equals(value)) {
            this.propertyChanged("color", value, oldValue);
        }
    }
    get font() {
        return this._font;
    }
    set font(value) {
        let oldValue = this._font;
        this._font = value;
        if (oldValue && oldValue.equals(oldValue)) {
            this._font.changesInterceptor = this;
        }
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        json.addPropertyColor("Color", this.color);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Font":
                    this._font = new Font("Segoe UI", 9, [], this);
                    this._font.loadFromJsonObject(property.value);
                    break;
                case "Color":
                    this._color = new Color();
                    this._color.changesInterceptor = this;
                    this._color.deserializeFromString(property.value);
                    break;
            }
        }
    }
}

class StiInnerTextSettings extends StiDescriptionSettings {
    constructor(changesInterceptor) {
        super(changesInterceptor);
        this.changesInterceptor = changesInterceptor;
        this._borderWeight = StiLineWeight.Thin;
        this._contentAlignment = StiHorizontalAlignment.Left;
        this._backgroundColor = Color.white();
        this._backgroundColor.changesInterceptor = this;
        this._backgroundColor.propertyName = "backgroundColor";
        this._borderColor = Color.lightGray();
        this._borderColor.changesInterceptor = this;
        this._borderColor.propertyName = "borderColor";
        this._checkColor = Color.black();
        this._checkColor.changesInterceptor = this;
        this._checkColor.propertyName = "checkColor";
        this._color = Color.black();
        this._color.changesInterceptor = this;
        this._font._size = 10;
    }
    propertyChanged(propName, value, oldObject) {
        this.changesInterceptor.propertyChanged(`innerText.${propName}`, value, oldObject);
    }
    get backgroundColor() {
        return this._backgroundColor;
    }
    set backgroundColor(value) {
        let oldValue = this._backgroundColor.clone();
        this._backgroundColor = value;
        this._backgroundColor.changesInterceptor = this;
        if (oldValue && !oldValue.equals(value)) {
            this.propertyChanged("backgroundColor", value, oldValue);
        }
    }
    get borderColor() {
        return this._borderColor;
    }
    set borderColor(value) {
        let oldValue = this._borderColor.clone();
        this._borderColor = value;
        this._borderColor.changesInterceptor = this;
        if (oldValue && !oldValue.equals(value)) {
            this.propertyChanged("borderColor", value, oldValue);
        }
    }
    get checkColor() {
        return this._checkColor;
    }
    set checkColor(value) {
        let oldValue = this._checkColor.clone();
        this._checkColor = value;
        this._checkColor.changesInterceptor = this;
        if (oldValue && !oldValue.equals(value)) {
            this.propertyChanged("checkColor", value, oldValue);
        }
    }
    get borderWeight() {
        return this._borderWeight;
    }
    set borderWeight(value) {
        let oldValue = this._borderWeight;
        this._borderWeight = value;
        if (oldValue != value) {
            this.propertyChanged("borderWeight", value, oldValue);
        }
    }
    get contentAlignment() {
        return this._contentAlignment;
    }
    set contentAlignment(value) {
        let oldValue = this._contentAlignment;
        this._contentAlignment = value;
        if (oldValue != value) {
            this.propertyChanged("contentAlignment", value, oldValue);
        }
    }
    saveToJsonObject(options) {
        let json = super.saveToJsonObject(options);
        json.addPropertyColor("BackgroundColor", this.backgroundColor);
        json.addPropertyColor("BorderColor", this.borderColor);
        json.addPropertyColor("CheckColor", this.checkColor);
        json.addPropertyEnum("BorderWeight", StiLineWeight, this.borderWeight);
        json.addPropertyEnum("ContentAlignment", StiHorizontalAlignment, this.contentAlignment);
        return json;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "BackgroundColor":
                case "BackColor":
                    this._backgroundColor = new Color();
                    this._backgroundColor.changesInterceptor = this;
                    this._backgroundColor.propertyName = "backgroundColor";
                    this._backgroundColor.deserializeFromString(property.value);
                    break;
                case "BorderColor":
                    this._borderColor = new Color();
                    this._borderColor.changesInterceptor = this;
                    this._borderColor.propertyName = "borderColor";
                    this._borderColor.deserializeFromString(property.value);
                    break;
                case "CheckColor":
                    this._checkColor = new Color();
                    this._checkColor.changesInterceptor = this;
                    this._checkColor.propertyName = "checkColor";
                    this._checkColor.deserializeFromString(property.value);
                    break;
                case "BorderWeight":
                    this._borderWeight = Enum.parse(StiLineWeight, property.value);
                    break;
                case "contentAlignment":
                case "ContentAlignment":
                    this._contentAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
            }
        }
    }
}

class StiLabelSettings extends StiDescriptionSettings {
    constructor(changesInterceptor) {
        super(changesInterceptor);
        this.changesInterceptor = changesInterceptor;
        this._alignment = StiLabelAlignment.Left;
        this._verticalAlignment = StiVerticalAlignment.Center;
        this._width = 150;
        this._font = new Font("Segoe UI", 10, [], this);
        this._color = Color.black();
        this._color.changesInterceptor = this;
    }
    propertyChanged(propName, value, oldObject) {
        this.changesInterceptor.propertyChanged(`label.${propName}`, value, oldObject);
    }
    get alignment() {
        return this._alignment;
    }
    set alignment(value) {
        let oldValue = this._alignment;
        this._alignment = value;
        if (oldValue != value) {
            this.propertyChanged("alignment", value, oldValue);
        }
    }
    get verticalAlignment() {
        return this._verticalAlignment;
    }
    set verticalAlignment(value) {
        let oldValue = this._verticalAlignment;
        this._verticalAlignment = value;
        if (oldValue != value) {
            this.propertyChanged("verticalAlignment", value, oldValue);
        }
    }
    get width() {
        return this._width;
    }
    set width(value) {
        let oldValue = this._width;
        this._width = value;
        if (oldValue != value) {
            this.propertyChanged("width", value, oldValue);
        }
    }
    saveToJsonObject(options) {
        let json = super.saveToJsonObject(options);
        json.addPropertyEnum("Alignment", StiLabelAlignment, this.alignment);
        json.addPropertyEnum("VerticalAlignment", StiVerticalAlignment, this.verticalAlignment);
        json.addPropertyNumber("Width", this.width);
        return json;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Alignment":
                    this._alignment = Enum.parse(StiLabelAlignment, property.value);
                    break;
                case "VerticalAlignment":
                    this._verticalAlignment = Enum.parse(StiVerticalAlignment, property.value);
                    break;
                case "Width":
                    this._width = property.value;
                    break;
            }
        }
    }
}

class StiFormSettings {
    constructor(form) {
        this.form = form;
        this._label = new StiLabelSettings(this);
        this._description = new StiDescriptionSettings(this);
        this._innerText = new StiInnerTextSettings(this);
        this._dateTimeFormat = "m/d/yy h:MM tt";
        this._dateFomat = "dd.mm.yyyy";
        this._timeFormat = "HH:MM:ss";
        this._currency = "USD";
        this._currencyFormat = StiDisplayCurrencyAs.Code;
        this._unitAlignment = StiUnitAlignment.Prefix;
        this._thousandSeparator = StiThousandSeparator.Comma;
        this._decimalDigits = 2;
        this._padding = new StiPadding(8, 8, 8, 8, this);
        this._gridColumns = 12;
        this._gridVerticalStep = 5;
    }
    get reportImage() {
        return this.form.reportImage;
    }
    set reportImage(value) {
        let oldValue = this.reportImage;
        this.form.reportImage = value;
        if (oldValue != value) {
            this.propertyChanged("reportImage", value, {});
        }
    }
    get formName() {
        return this.form.formName;
    }
    set formName(value) {
        let oldValue = this.form.formName;
        this.form.formName = value;
        if (oldValue != value) {
            this.propertyChanged("formName", value, {});
        }
    }
    get gridColumns() {
        return this._gridColumns;
    }
    set gridColumns(value) {
        let oldValue = this._gridColumns;
        if (typeof value != "number" ? Number(value) < 12 : value < 12) {
            this._gridColumns = 12;
        }
        else {
            this._gridColumns = value;
        }
        if (oldValue != value) {
            this.propertyChanged("gridColumns", value, {});
        }
    }
    get gridVerticalStep() {
        return this._gridVerticalStep;
    }
    set gridVerticalStep(value) {
        let oldValue = this._gridVerticalStep;
        if (value <= 1) {
            this._gridVerticalStep = 1;
        }
        else if (value > this.form.pages[this.form.pages.length - 1].contentAreaHeight) {
            this._gridVerticalStep = this.form.pages[this.form.pages.length - 1].contentAreaHeight;
        }
        else {
            this._gridVerticalStep = value;
        }
        if (oldValue != value) {
            this.propertyChanged("gridVerticalStep", value, {});
        }
    }
    get padding() {
        return this._padding;
    }
    set padding(value) {
        let oldObject = this._padding.clone();
        this._padding = value;
        this._padding.changesInterceptor = this;
        this.propertyChanged("padding", value, oldObject);
    }
    get label() {
        return this._label;
    }
    set label(value) {
        this._label = value;
    }
    get description() {
        return this._description;
    }
    set description(value) {
        this._description = value;
    }
    get innerText() {
        return this._innerText;
    }
    set innerText(value) {
        this._innerText = value;
    }
    get dateTimeFormat() {
        return this._dateTimeFormat;
    }
    set dateTimeFormat(value) {
        let oldValue = this._dateTimeFormat;
        this._dateTimeFormat = value;
        if (oldValue != value) {
            this.propertyChanged("dateTimeFormat", value, oldValue);
        }
    }
    get dateFormat() {
        return this._dateFomat;
    }
    set dateFormat(value) {
        let oldValue = this._dateFomat;
        this._dateFomat = value;
        if (oldValue != value) {
            this.propertyChanged("dateFormat", value, oldValue);
        }
    }
    get timeFormat() {
        return this._timeFormat;
    }
    set timeFormat(value) {
        let oldValue = this._timeFormat;
        this._timeFormat = value;
        if (oldValue != value) {
            this.propertyChanged("timeFormat", value, oldValue);
        }
    }
    get currency() {
        return this._currency;
    }
    set currency(value) {
        let oldValue = this._currency;
        this._currency = value;
        if (oldValue != value) {
            this.propertyChanged("currency", value, oldValue);
        }
    }
    get currencyFormat() {
        return this._currencyFormat;
    }
    set currencyFormat(value) {
        let oldValue = this._currencyFormat;
        this._currencyFormat = value;
        if (oldValue != value) {
            this.propertyChanged("currencyFormat", value, oldValue);
        }
    }
    get unitAlignment() {
        return this._unitAlignment;
    }
    set unitAlignment(value) {
        let oldValue = this._unitAlignment;
        this._unitAlignment = value;
        if (oldValue != value) {
            this.propertyChanged("unitAlignment", value, oldValue);
        }
    }
    get thousandSeparator() {
        return this._thousandSeparator;
    }
    set thousandSeparator(value) {
        let oldValue = this._thousandSeparator;
        this._thousandSeparator = value;
        if (oldValue != value) {
            this.propertyChanged("thousandSeparator", value, oldValue);
        }
    }
    get decimalDigits() {
        return this._decimalDigits;
    }
    set decimalDigits(value) {
        let oldValue = this._decimalDigits;
        if (value <= 0) {
            this._decimalDigits = 0;
        }
        else {
            this._decimalDigits = value;
        }
        if (oldValue != value) {
            this.propertyChanged("decimalDigits", value, oldValue);
        }
    }
    propertyChanged(propName, value, oldObject) {
        this.form.pages.forEach((p) => p.allElements.forEach((el) => {
            el.setProperty(propName, value["clone"] ? value.clone() : value, oldObject);
        }));
        if (propName.toLowerCase().indexOf("color") == -1) {
            this.form.formEvents.next({ name: "UpdateAllSizes" });
        }
        if (propName == "thousandSeparator" || propName == "decimalDigits") {
            this.form.formEvents.next({ name: "UpdateForm" });
        }
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        json.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        json.addPropertyJObject("InnerText", this.innerText.saveToJsonObject(options));
        json.addPropertyString("TimeFormat", this.timeFormat);
        json.addPropertyString("DateFormat", this.dateFormat);
        json.addPropertyString("DateTimeFormat", this.dateTimeFormat);
        json.addPropertyNumber("DecimalDigits", this.decimalDigits);
        json.addPropertyNumber("GridColumns", this.gridColumns);
        json.addPropertyNumber("GridVerticalStep", this.gridVerticalStep);
        json.addPropertyString("Currency", this.currency);
        json.addPropertyEnum("CurrencyFormat", StiDisplayCurrencyAs, this.currencyFormat);
        json.addPropertyEnum("UnitAlignment", StiUnitAlignment, this.unitAlignment);
        json.addPropertyEnum("ThousandSeparator", StiThousandSeparator, this.thousandSeparator);
        json.addPropertyJObject("Padding", this.padding.saveToJsonObject(options));
        return json;
    }
    loadFormJsonString(text) {
        let jObject = new StiJson();
        jObject.deserialize(text);
        this.loadFromJsonObject(jObject);
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this._label = new StiLabelSettings(this);
                    this._label.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this._description = new StiDescriptionSettings(this);
                    this._description.loadFromJsonObject(property.value);
                    break;
                case "InnerText":
                    this._innerText = new StiInnerTextSettings(this);
                    this._innerText.loadFromJsonObject(property.value);
                    break;
                case "TimeFormat":
                    this.timeFormat = property.value;
                    break;
                case "DateFormat":
                    this.dateFormat = property.value;
                    break;
                case "DateTimeFormat":
                    this.dateTimeFormat = property.value;
                    break;
                case "DecimalDigits":
                    this.decimalDigits = property.value;
                    break;
                case "GridColumns":
                    this.gridColumns = property.value < 12 ? 12 : property.value;
                    break;
                case "GridVerticalStep":
                    this.gridVerticalStep = property.value;
                    break;
                case "Currency":
                    this._currency = property.value;
                    break;
                case "CurrencyFormat":
                    this._currencyFormat = Enum.parse(StiDisplayCurrencyAs, property.value);
                    break;
                case "UnitAlignment":
                    this._unitAlignment = Enum.parse(StiUnitAlignment, property.value);
                    break;
                case "Separator":
                case "ThousandSeparator":
                    this._thousandSeparator = Enum.parse(StiThousandSeparator, property.value);
                    break;
                case "Padding":
                    this._padding = new StiPadding();
                    this._padding.loadFromJsonObject(property.value);
                    break;
            }
        }
    }
    applySettings(element) {
        element.setProperty("label.font.family", this.label.font.family, null);
        element.setProperty("label.font.style", this.label.font.cloneStyle, null);
        element.setProperty("label.font.size", this.label.font.size, null);
        element.setProperty("label.color", this.label.color, null);
        element.setProperty("label.alignment", this.label.alignment, null);
        element.setProperty("label.width", this.label.width, null);
        element.setProperty("padding", this.padding, null);
        element.setProperty("description.font.family", this.description.font.family, null);
        element.setProperty("description.font.style", this.description.font.cloneStyle, null);
        element.setProperty("description.font.size", this.description.font.size, null);
        element.setProperty("description.color", this.description.color.clone(), null);
        element.setProperty("innerText.font.family", this.innerText.font.family, null);
        element.setProperty("innerText.font.style", this.innerText.font.cloneStyle, null);
        element.setProperty("innerText.font.size", this.innerText.font.size, null);
        element.setProperty("innerText.color", this.innerText.color.clone(), null);
        element.setProperty("innerText.backgroundColor", this.innerText.backgroundColor.clone(), null);
        element.setProperty("innerText.borderColor", this.innerText.borderColor.clone(), null);
        element.setProperty("innerText.borderWeight", this.innerText.borderWeight, null);
        element.setProperty("innerText.checkColor", this.innerText.checkColor.clone(), null);
        element.setProperty("innerText.contentAlignment", this.innerText.contentAlignment, null);
        element.setProperty("timeFormat", this.timeFormat, null);
        element.setProperty("dateFormat", this.dateFormat, null);
        element.setProperty("dateTimeFormat", this.dateTimeFormat, null);
        element.setProperty("currency", this.currency, null);
        element.setProperty("currencyFormat", this.currencyFormat, null);
        element.setProperty("unitAlignment", this.unitAlignment, null);
        element.setProperty("thousandSeparator", this.thousandSeparator, null);
        element.setProperty("decimalDigits", this.decimalDigits, null);
    }
}

class StiPagePaperKind extends StiFormObject {
    constructor(name, kind, width, height) {
        super();
        this.name = name;
        this.kind = kind;
        this._width = width;
        this._height = height;
    }
    get width() {
        return this._width;
    }
    set width(value) {
        this._width = value;
        this.updatePaperKind();
    }
    get height() {
        return this._height;
    }
    set height(value) {
        this._height = value;
        this.updatePaperKind();
    }
    updatePaperKind() {
        var _a, _b;
        this.kind =
            (_b = (_a = StiPagePaperKind.availableStandardKinds().find((k) => k.height == this.height && k.width == this.width)) === null || _a === void 0 ? void 0 : _a.kind) !== null && _b !== void 0 ? _b : PaperKind.Custom;
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyEnum("Kind", PaperKind, this.kind);
        if (this.kind == PaperKind.Custom) {
            jObject.addPropertyNumber("Width", this.width);
            jObject.addPropertyNumber("Height", this.height);
        }
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Kind":
                    this.kind = Enum.parse(PaperKind, property.value);
                    break;
                case "Width":
                    this.width = property.value;
                    break;
                case "Height":
                    this.height = property.value;
                    break;
            }
        }
    }
    clone() {
        return new StiPagePaperKind(this.name, this.kind, this.width, this.height);
    }
    static availableStandardKinds() {
        if (this._availableStandardKinds.length == 0) {
            this._availableStandardKinds.push(new StiPagePaperKind("Custom", PaperKind.Custom, 794, 1123));
            this._availableStandardKinds.push(new StiPagePaperKind("Letter", PaperKind.Letter, 816, 1056));
            this._availableStandardKinds.push(new StiPagePaperKind("Tabloid", PaperKind.Tabloid, 1056, 1632));
            this._availableStandardKinds.push(new StiPagePaperKind("Legal", PaperKind.Legal, 816, 1344));
            this._availableStandardKinds.push(new StiPagePaperKind("Statement", PaperKind.Statement, 528, 816));
            this._availableStandardKinds.push(new StiPagePaperKind("Executive", PaperKind.Executive, 696, 1008));
            this._availableStandardKinds.push(new StiPagePaperKind("A3", PaperKind.A3, 1123, 1587));
            this._availableStandardKinds.push(new StiPagePaperKind("A4", PaperKind.A4, 794, 1123));
            this._availableStandardKinds.push(new StiPagePaperKind("A5", PaperKind.A5, 559, 794));
            this._availableStandardKinds.push(new StiPagePaperKind("B4", PaperKind.B4, 971, 1376));
            this._availableStandardKinds.push(new StiPagePaperKind("B5", PaperKind.B5, 688, 971));
        }
        return this._availableStandardKinds;
    }
    static fromStandardPaperKind(standardPaperKind) {
        if (standardPaperKind == PaperKind.Custom) {
            return null;
        }
        return this.availableStandardKinds().filter((k) => k.kind === standardPaperKind)[0].clone();
    }
}
StiPagePaperKind._availableStandardKinds = [];

class StiPen {
    constructor(color, style = StiPenStyle.Solid, width = 1) {
        this.color = color;
        this.style = style;
        this.width = width;
    }
    static dimGraySolid() {
        return new StiPen(Color.dimGray(), StiPenStyle.Solid, 1);
    }
    get width() {
        return this._width;
    }
    set width(value) {
        if (value <= 0) {
            this._width = 0;
        }
        else if (value >= 395) {
            this._width = 395;
        }
        else {
            this._width = value;
        }
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyColor("Color", this.color);
        json.addPropertyEnum("Style", StiPenStyle, this.style);
        json.addPropertyNumber("Width", this.width);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Color":
                    this.color = new Color();
                    this.color.deserializeFromString(property.value);
                    break;
                case "Style":
                    this.style = Enum.parse(StiPenStyle, property.value);
                    break;
                case "Width":
                    this.width = property.value;
                    break;
            }
        }
    }
    toHtmlBorder() {
        return `${this.width}px ${this.getHtmlStyle()} ${this.color.toHtmlColor()}`;
    }
    getHtmlStyle() {
        switch (this.style) {
            case StiPenStyle.Solid:
                return "solid";
            case StiPenStyle.Dash:
                return "dashed";
            case StiPenStyle.Dot:
                return "dotted";
        }
    }
}

class StiBorder {
    constructor(pen, drawLeft, drawTop, drawRight, drawBottom) {
        this.pen = pen;
        this.drawLeft = drawLeft;
        this.drawTop = drawTop;
        this.drawRight = drawRight;
        this.drawBottom = drawBottom;
    }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyJObject("Pen", this.pen.saveToJsonObject(options));
        json.addPropertyBool("DrawLeft", this.drawLeft);
        json.addPropertyBool("DrawTop", this.drawTop);
        json.addPropertyBool("DrawRight", this.drawRight);
        json.addPropertyBool("DrawBottom", this.drawBottom);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Pen":
                    this.pen = new StiPen();
                    this.pen.loadFromJsonObject(property.value);
                    break;
                case "DrawLeft":
                    this.drawLeft = property.value;
                    break;
                case "DrawTop":
                    this.drawTop = property.value;
                    break;
                case "DrawBottom":
                    this.drawBottom = property.value;
                    break;
                case "DrawRight":
                    this.drawRight = property.value;
                    break;
            }
        }
    }
}

class StiImageElement extends StiFormElement {
    constructor() {
        super();
        this.type = "ImageElement";
        this.tooltip = "";
        this.font = new Font("Segoe UI", 10);
        this.description = new StiTextItem();
        this.canvasHeight = 195;
        this.border = new StiBorder(StiPen.dimGraySolid(), false, false, false, false);
        this.showBorderEditor = true;
        this.preserveAspectRatio = true;
        this.hyperlink = "";
        this.geometry = new StiRectangleGeometry(170, 195);
        this.label = new StiLabelItem(this, "");
        this.label.alignment = StiLabelAlignment.Top;
        this.padding = new StiPadding(0, 0, 0, 0, this);
    }
    canUpdateProperty(propName) {
        return !(propName.indexOf("padding") >= 0 || propName == "label.alignment");
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.font.family, this.arrayOfStylesToString(this.font.style), this.font.size);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    saveToJsonObject(options) {
        var _a;
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyString("Tooltip", this.tooltip);
        jObject.addPropertyStringNullOrEmpty("Hyperlink", this.hyperlink);
        jObject.addPropertyJObject("Border", this.border.saveToJsonObject(options));
        if (!(options && options["notSerializeImages"])) {
            jObject.addPropertyStringNullOrEmpty("Image", (_a = this.image) === null || _a === void 0 ? void 0 : _a.substring(this.image.indexOf("base64,") + 7));
        }
        jObject.addPropertyBool("PreserveAspectRatio", this.preserveAspectRatio);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "Tooltip":
                    this.tooltip = property.value;
                    break;
                case "Image":
                case "BackgroundImage":
                    this.image = `data:image/png;base64,${property.value}`;
                    break;
                case "PreserveAspectRatio":
                    this.preserveAspectRatio = property.value;
                    break;
                case "Border":
                    this.border = new StiBorder();
                    this.border.loadFromJsonObject(property.value);
                    break;
                case "Hyperlink":
                    this.hyperlink = property.value;
                    break;
            }
        }
    }
}

class StiExceedMargins {
    constructor(drawLeft, drawTop, drawRight, drawBottom) {
        this.drawLeft = drawLeft;
        this.drawTop = drawTop;
        this.drawRight = drawRight;
        this.drawBottom = drawBottom;
    }
}

class StiBackgroundedAlignedTextItem extends StiBackgroundedTextItem {
    constructor(value = "", font = new Font("Segoe UI", 15), color = Color.black(), backgroundColor = Color.white(), horizontalAlignment = StiHorizontalAlignment.Center, verticalAlignment = StiVerticalAlignment.Center) {
        super(value, font, color, backgroundColor);
        this.font = font;
        this.color = color;
        this.backgroundColor = backgroundColor;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
    }
    get eContentAlignment() {
        return this.horizontalAlignment;
    }
    set eContentAlignment(value) {
        this.horizontalAlignment = value;
    }
    get eVerticalAlignment() {
        return this.verticalAlignment;
    }
    set eVerticalAlignment(value) {
        this.verticalAlignment = value;
    }
    haveVerticalAlignment() {
        return true;
    }
    haveContentAlignment() {
        return true;
    }
    saveToJsonObject(options) {
        let json = super.saveToJsonObject(options);
        json.addPropertyEnum("HorizontalAlignment", StiHorizontalAlignment, this.horizontalAlignment);
        json.addPropertyEnum("VerticalAlignment", StiVerticalAlignment, this.verticalAlignment);
        return json;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "HorizontalAlignment":
                    this.horizontalAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "VerticalAlignment":
                    this.verticalAlignment = Enum.parse(StiVerticalAlignment, property.value);
                    break;
            }
        }
    }
}

class StiLabelElement extends StiFormElement {
    constructor() {
        super();
        this.type = "LabelElement";
        this.exceedMargins = new StiExceedMargins(false, false, false, false);
        this.text = new StiBackgroundedAlignedTextItem("", new Font("Segoe UI", 9), Color.black(), Color.transparent());
        this.border = new StiBorder(StiPen.dimGraySolid(), false, false, false, false);
        this.showBorderEditor = true;
        this.hyperlink = "";
        this.geometry = new StiRectangleGeometry(100, 40);
        this.padding = new StiPadding(0, 0, 0, 0, this);
    }
    get expression() {
        var _a;
        return (_a = this.text) === null || _a === void 0 ? void 0 : _a.value;
    }
    canUpdateProperty(propName) {
        return !(propName.indexOf("padding") >= 0);
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.text.font.family, this.arrayOfStylesToString(this.text.font.style), this.text.font.size);
    }
    setProperty(propName, value, oldObject) {
        super.setProperty(propName, value, oldObject);
        if (propName == "innerText.backgroundColor") {
            //this.text.backgroundColor = value.clone();
        }
        else if (propName == "innerText.contentAlignment") {
            //this.text.horizontalAlignment = value;
        }
        else if (propName.startsWith("label.font") || propName == "label.color") {
            this.text.setProperty(propName.replace("label.", ""), value.clone ? value.clone() : value, oldObject);
        }
    }
    getDefaultEditableContent() {
        return this.text;
    }
    htmlStyle() {
        return `${this.text.font.htmlStyle()};color:${this.text.color.toHtmlColor()};justify-content:${Enum.getName(StiHorizontalAlignment, this.text.horizontalAlignment)};align-items:${Enum.getName(StiVerticalAlignment, this.text.verticalAlignment)}`;
    }
    saveToJsonObject(options) {
        let states = [];
        if (this.exceedMargins.drawTop &&
            this.exceedMargins.drawBottom &&
            this.exceedMargins.drawLeft &&
            this.exceedMargins.drawRight) {
            states.push("All");
        }
        else if (!this.exceedMargins.drawTop &&
            !this.exceedMargins.drawBottom &&
            !this.exceedMargins.drawLeft &&
            !this.exceedMargins.drawRight) {
            states.push("None");
        }
        else {
            if (this.exceedMargins.drawTop) {
                states.push("Top");
            }
            if (this.exceedMargins.drawLeft) {
                states.push("Left");
            }
            if (this.exceedMargins.drawRight) {
                states.push("Right");
            }
            if (this.exceedMargins.drawBottom) {
                states.push("Bottom");
            }
        }
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Text", this.text.saveToJsonObject(options));
        jObject.addPropertyJObject("Border", this.border.saveToJsonObject(options));
        jObject.addPropertyString("ExceededMargins", states.join());
        jObject.addPropertyStringNullOrEmpty("Hyperlink", this.hyperlink);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Hyperlink":
                    this.hyperlink = property.value;
                    break;
                case "Text":
                    this.text = new StiBackgroundedAlignedTextItem();
                    this.text.loadFromJsonObject(property.value);
                    break;
                case "Border":
                    this.border = new StiBorder();
                    this.border.loadFromJsonObject(property.value);
                    break;
                case "ExceededMargins":
                    let string = property.value;
                    this.exceedMargins.drawBottom = false;
                    this.exceedMargins.drawLeft = false;
                    this.exceedMargins.drawRight = false;
                    this.exceedMargins.drawTop = false;
                    if (string.indexOf("All") >= 0) {
                        this.exceedMargins.drawBottom = true;
                        this.exceedMargins.drawLeft = true;
                        this.exceedMargins.drawRight = true;
                        this.exceedMargins.drawTop = true;
                    }
                    else {
                        if (string.indexOf("Top") >= 0) {
                            this.exceedMargins.drawTop = true;
                        }
                        if (string.indexOf("Left") >= 0) {
                            this.exceedMargins.drawLeft = true;
                        }
                        if (string.indexOf("Right") >= 0) {
                            this.exceedMargins.drawRight = true;
                        }
                        if (string.indexOf("Bottom") >= 0) {
                            this.exceedMargins.drawBottom = true;
                        }
                    }
                    break;
            }
        }
    }
}

class StiLineElement extends StiFormElement {
    constructor() {
        super();
        this.type = "LineElement";
        this.description = new StiTextItem();
        this.lineColor = Color.fromArgb(255, 192, 191, 192);
        this.verticalAlignment = StiVerticalAlignment.Center;
        this.style = StiPenStyle.Solid;
        this.lineThickness = 1;
        this.geometry = new StiRectangleGeometry(100, 20);
        this.padding = new StiPadding(0, 0, 0, 0);
    }
    canUpdateProperty(propName) {
        return !propName.startsWith("padding");
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyColor("LineColor", this.lineColor);
        jObject.addPropertyNumber("LineThickness", this.lineThickness);
        jObject.addPropertyEnum("VerticalAlignment", StiVerticalAlignment, this.verticalAlignment);
        jObject.addPropertyEnum("Style", StiPenStyle, this.style);
        return jObject;
    }
    toHtmlBorder() {
        return `${this.lineThickness}px ${this.getHtmlStyle()} ${this.lineColor.toHtmlColor()}`;
    }
    getHtmlStyle() {
        switch (this.style) {
            case StiPenStyle.Solid:
                return "solid";
            case StiPenStyle.Dash:
                return "dashed";
            case StiPenStyle.Dot:
                return "dotted";
        }
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "LineColor":
                    this.lineColor = new Color();
                    this.lineColor.deserializeFromString(property.value);
                    break;
                case "LineThickness":
                    this.lineThickness = property.value;
                    break;
                case "VerticalAlignment":
                    this.verticalAlignment = Enum.parse(StiVerticalAlignment, property.value);
                    break;
                case "Style":
                    this.style = Enum.parse(StiPenStyle, property.value);
                    break;
            }
        }
    }
}

class StiListBoxElement extends StiFormElement {
    constructor() {
        super();
        this.type = "List_BoxElement";
        this.tooltip = "";
        this.required = false;
        this.description = new StiTextItem();
        this.font = new Font("Segoe UI", 10);
        this.backgroundColor = Color.white();
        this.textColor = Color.black();
        this.borderColor = Color.lightGray();
        this.borderWeight = StiLineWeight.Thin;
        this.allowMultiselection = false;
        this.options = [];
        this.selectedOptions = [];
        this.geometry = new StiRectangleGeometry(150, 90);
        this.label = new StiLabelItem(this, StiLocalizationService.get("Components", "StiListBox"));
        this.options.push(StiLocalizationService.get("PropertyMain", "First"));
        this.options.push(StiLocalizationService.get("PropertyMain", "Second"));
        this.options.push(StiLocalizationService.get("PropertyMain", "Third"));
    }
    setDefaultValues() {
        this.selectedOptions = [];
    }
    setTabIndex(value) {
        this.tabIndex = value++;
        return value;
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.font.family, this.arrayOfStylesToString(this.font.style), this.font.size);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    htmlStyle() {
        return `${this.font.htmlStyle()};color:${this.textColor.toHtmlColor()};`;
    }
    getDefaultEditableContent() {
        let textItem = new StiInputTextItem("", this.font, this.textColor, this.backgroundColor);
        textItem.element = this;
        return textItem;
    }
    get value() {
        if (this.selectedOptions) {
            return this.selectedOptions.length == 1 ? this.selectedOptions[0] : this.selectedOptions;
        }
        return null;
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyColor("TextColor", this.textColor);
        jObject.addPropertyString("Tooltip", this.tooltip);
        jObject.addPropertyBool("Required", this.required);
        jObject.addPropertyColor("BorderColor", this.borderColor);
        jObject.addPropertyEnum("BorderWeight", StiLineWeight, this.borderWeight);
        jObject.addPropertyBool("AllowMultiselection", this.allowMultiselection);
        jObject.addPropertyArray("SelectedOptions", this.selectedOptions);
        jObject.addPropertyArray("Options", this.options);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "TextColor":
                    this.textColor = new Color();
                    this.textColor.deserializeFromString(property.value);
                    break;
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Font":
                    this.font = new Font();
                    this.font.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "Tooltip":
                    this.tooltip = property.value;
                    break;
                case "Required":
                    this.required = property.value;
                    break;
                case "BorderColor":
                    this.borderColor = new Color();
                    this.borderColor.deserializeFromString(property.value);
                    break;
                case "BorderWeight":
                    this.borderWeight = Enum.parse(StiLineWeight, property.value);
                    break;
                case "AllowMultiselection":
                    this.allowMultiselection = property.value;
                    break;
                case "SelectedOptions":
                    this.selectedOptions = [];
                    property.value.properties().forEach((p) => this.selectedOptions.push(p.value));
                    break;
                case "Options":
                    this.options = [];
                    property.value.properties().forEach((p) => this.options.push(p.value));
                    break;
            }
        }
    }
}

class StiOptionItem {
    constructor(value, element, index) {
        this.element = element;
        this.index = index;
        this.value = value;
    }
    get eFont() {
        return this.element.font;
    }
    set eFont(value) {
        this.element.font = value;
    }
    get eColor() {
        return this.element.textColor;
    }
    set eColor(value) {
        this.element.textColor = value;
    }
    haveBackgoundColor() {
        return false;
    }
    haveContentAlignment() {
        return false;
    }
    haveVerticalAlignment() {
        return false;
    }
    htmlStyle() {
        return this.element ? `${this.eFont.htmlStyle()};color:${this.eColor.toHtmlColor()}` : "";
    }
    set eValue(value) {
        this.value = value;
        this.element.nativeOptions[this.index] = value;
    }
    get eValue() {
        return this.value;
    }
}

class StiMultipleSelectionElement extends StiFormElement {
    constructor() {
        super();
        this.type = "Multiple_SelectionElement";
        this.tooltip = "";
        this.required = false;
        this.description = new StiTextItem();
        this.font = new Font("Segoe UI", 10);
        this._columns = 1;
        this.backgroundColor = Color.white();
        this.textColor = Color.black();
        this.checkColor = Color.black();
        this.borderColor = Color.lightGray();
        this.prefix = "";
        this.suffix = "";
        this.optionsContentEditable = [];
        this.useCustomOption = false;
        this.customOptionText = "";
        this.selectedOptions = [];
        this.geometry = new StiRectangleGeometry(150, 80);
        this.label = new StiLabelItem(this, StiLocalizationService.get("Components", "StiMultipleSelection"));
        this.options = [];
        this.options.push(StiLocalizationService.get("PropertyMain", "First"));
        this.options.push(StiLocalizationService.get("PropertyMain", "Second"));
        this.options.push(StiLocalizationService.get("PropertyMain", "Third"));
    }
    setDefaultValues() {
        this.selectedOptions = [];
    }
    setTabIndex(value) {
        this.tabIndex = value++;
        return value;
    }
    set options(value) {
        this.nativeOptions = value;
        let this_ = this;
        this._options = new Proxy(value, {
            deleteProperty: function (target, property) {
                setTimeout(() => {
                    this_.updateOptionsContentEditable();
                }, 0);
                return true;
            },
            set: function (target, property, value, receiver) {
                target[property] = value;
                this_.updateOptionsContentEditable();
                return true;
            },
        });
        this.updateOptionsContentEditable();
    }
    updateOptionsContentEditable() {
        this.optionsContentEditable = [];
        this.options.forEach((l, index) => this.optionsContentEditable.push(new StiOptionItem(l, this, index)));
    }
    getDefaultEditableContent() {
        let textItem = new StiInputTextItem("", this.font, this.textColor);
        textItem.element = this;
        return textItem;
    }
    get options() {
        return this._options;
    }
    get value() {
        if (this.selectedOptions) {
            return this.selectedOptions.length == 1 ? this.selectedOptions[0] : this.selectedOptions;
        }
        return null;
    }
    get columns() {
        return this._columns;
    }
    set columns(value) {
        if (value <= 1) {
            this._columns = 1;
        }
        else {
            this._columns = value;
        }
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.font.family, this.arrayOfStylesToString(this.font.style), this.font.size);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    htmlStyle() {
        return `${this.font.htmlStyle()};color:${this.textColor.toHtmlColor()};`;
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyString("Tooltip", this.tooltip);
        jObject.addPropertyBool("Required", this.required);
        jObject.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        jObject.addPropertyNumber("Columns", this.columns);
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyColor("TextColor", this.textColor);
        jObject.addPropertyColor("CheckColor", this.checkColor);
        jObject.addPropertyColor("BorderColor", this.borderColor);
        jObject.addPropertyArray("Options", this.options);
        jObject.addPropertyBool("UseCustomOption", this.useCustomOption);
        jObject.addPropertyString("CustomOptionText", this.customOptionText);
        jObject.addPropertyArray("SelectedOptions", this.selectedOptions);
        jObject.addPropertyString("Prefix", this.prefix);
        jObject.addPropertyString("Suffix", this.suffix);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "TextColor":
                    this.textColor = new Color();
                    this.textColor.deserializeFromString(property.value);
                    break;
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Font":
                    this.font = new Font();
                    this.font.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "Tooltip":
                    this.tooltip = property.value;
                    break;
                case "Required":
                    this.required = property.value;
                    break;
                case "Columns":
                    this.columns = property.value;
                    break;
                case "BorderColor":
                    this.borderColor = new Color();
                    this.borderColor.deserializeFromString(property.value);
                    break;
                case "CheckColor":
                    this.checkColor = new Color();
                    this.checkColor.deserializeFromString(property.value);
                    break;
                case "CustomOptionText":
                    this.customOptionText = property.value;
                    break;
                case "UseCustomOption":
                    this.useCustomOption = property.value;
                    break;
                case "Prefix":
                    this.prefix = property.value;
                    break;
                case "Suffix":
                    this.suffix = property.value;
                    break;
                case "SelectedOptions":
                    this.selectedOptions = [];
                    property.value.properties().forEach((p) => this.selectedOptions.push(p.value));
                    break;
                case "Options":
                    this.options = [];
                    property.value.properties().forEach((p) => this.options.push(p.value));
                    break;
            }
        }
    }
}

class StiNumberBoxElement extends StiFormElement {
    constructor() {
        super();
        this._decimalDigits = 2;
        this._maximum = 15;
        this.type = "Number_BoxElement";
        this.tooltip = "";
        this.required = false;
        this.description = new StiTextItem();
        this.font = new Font("Segoe UI", 10);
        this.contentAlignment = StiHorizontalAlignment.Right;
        this.backgroundColor = Color.white();
        this.textColor = Color.black();
        this.value = 0;
        this.allowNegative = true;
        this.numberType = StiNumberType.Decimal;
        this.thousandSeparator = StiThousandSeparator.None;
        this.useRange = false;
        this._minimum = 0;
        this.rangeFormat = StiNumberRangeFormat.Digits;
        this.unitLabel = "";
        this.unitAlignment = StiUnitAlignment.Suffix;
        this.unitForeground = Color.black();
        this.currencyLabelFormat = StiDisplayCurrencyAs.Code;
        this.currency = "USD";
        this.borderColor = Color.lightGray();
        this.borderWeight = StiLineWeight.Thin;
        this.geometry = new StiRectangleGeometry(150, 40);
        this.label = new StiLabelItem(this, StiLocalizationService.get("Components", "StiNumberBox"));
    }
    setDefaultValues() {
        this.value = 0;
    }
    setTabIndex(value) {
        this.tabIndex = value++;
        return value;
    }
    getDefaultEditableContent() {
        var _a;
        let textItem = new StiInputTextItem((_a = this.value) === null || _a === void 0 ? void 0 : _a.toString(), this.font, this.textColor, this.backgroundColor, this.contentAlignment);
        textItem.element = this;
        return textItem;
    }
    get isCurrency() {
        return this.numberType == StiNumberType.Currency ? true : false;
    }
    get eValue() {
        return this.value.toString();
    }
    get decimalDigits() {
        return this._decimalDigits;
    }
    set decimalDigits(value) {
        this._decimalDigits = Math.max(0, Math.min(10, value));
    }
    get maximum() {
        return this._maximum;
    }
    set maximum(value) {
        this._maximum = value <= this.minimum ? this.minimum : value;
    }
    get minimum() {
        return this._minimum;
    }
    set minimum(value) {
        this._minimum = value >= this.maximum ? this.maximum : value;
    }
    set eValue(value) {
        try {
            this.value = parseFloat(value);
        }
        catch (_a) {
            this.value = 0;
        }
    }
    get eFont() {
        return this.font;
    }
    set eFont(value) {
        this.font = value;
    }
    get eBackgroundColor() {
        return this.backgroundColor;
    }
    set eBackgroundColor(value) {
        this.backgroundColor = value;
    }
    get eContentAlignment() {
        return this.contentAlignment;
    }
    set eContentAlignment(value) {
        this.contentAlignment = value;
    }
    haveContentAlignment() {
        return true;
    }
    haveVerticalAlignment() {
        return false;
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.font.family, this.arrayOfStylesToString(this.font.style), this.font.size);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    haveBackgoundColor() {
        return true;
    }
    get eColor() {
        return this.textColor;
    }
    set eColor(value) {
        this.textColor = value;
    }
    htmlStyle() {
        return `${this.font.htmlStyle()};color:${this.textColor.toHtmlColor()};text-align:${Enum.getName(StiHorizontalAlignment, this.contentAlignment)}`;
    }
    setProperty(propName, value, oldObject) {
        super.setProperty(propName, value, oldObject);
        if (propName == "thousandSeparator" && (oldObject === null || oldObject == this.thousandSeparator)) {
            this.thousandSeparator = value;
        }
        else if (propName == "currencyFormat" && (oldObject === null || oldObject == this.currencyLabelFormat)) {
            this.currencyLabelFormat = value;
        }
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyString("Tooltip", this.tooltip);
        jObject.addPropertyBool("Required", this.required);
        jObject.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        jObject.addPropertyNumber("Value", this.value);
        jObject.addPropertyBool("AllowNegative", this.allowNegative);
        jObject.addPropertyEnum("NumberType", StiNumberType, this.numberType);
        jObject.addPropertyEnum("ThousandSeparator", StiThousandSeparator, this.thousandSeparator);
        jObject.addPropertyNumber("DecimalDigits", this.decimalDigits);
        jObject.addPropertyEnum("ContentAlignment", StiHorizontalAlignment, this.contentAlignment);
        jObject.addPropertyBool("UseRange", this.useRange);
        jObject.addPropertyNumber("Minimum", this.minimum);
        jObject.addPropertyNumber("Maximum", this.maximum);
        jObject.addPropertyEnum("RangeFormat", StiNumberRangeFormat, this.rangeFormat);
        jObject.addPropertyString("UnitLabel", this.unitLabel);
        jObject.addPropertyEnum("UnitAlignment", StiUnitAlignment, this.unitAlignment);
        jObject.addPropertyColor("UnitForeground", this.unitForeground);
        jObject.addPropertyEnum("CurrencyLabelFormat", StiDisplayCurrencyAs, this.currencyLabelFormat);
        jObject.addPropertyString("Currency", this.currency);
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyColor("TextColor", this.textColor);
        jObject.addPropertyColor("BorderColor", this.borderColor);
        jObject.addPropertyEnum("BorderWeight", StiLineWeight, this.borderWeight);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "Tooltip":
                    this.tooltip = property.value;
                    break;
                case "Required":
                    this.required = property.value;
                    break;
                case "Font":
                    this.font = new Font();
                    this.font.loadFromJsonObject(property.value);
                    break;
                case "Value":
                    this.value = property.value;
                    break;
                case "AllowNegative":
                    this.allowNegative = property.value;
                    break;
                case "NumberType":
                    this.numberType = Enum.parse(StiNumberType, property.value);
                    break;
                case "ThousandSeparator":
                    this.thousandSeparator = Enum.parse(StiThousandSeparator, property.value);
                    break;
                case "DecimalDigits":
                    this.decimalDigits = property.value;
                    break;
                case "ContentAlignment":
                    this.contentAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "UseRange":
                    this.useRange = property.value;
                    break;
                case "Minimum":
                    this.minimum = property.value;
                    break;
                case "Maximum":
                    this.maximum = property.value;
                    break;
                case "RangeFormat":
                    this.rangeFormat = Enum.parse(StiNumberRangeFormat, property.value);
                    break;
                case "UnitLabel":
                    this.unitLabel = property.value;
                    break;
                case "UnitAlignment":
                    this.unitAlignment = Enum.parse(StiUnitAlignment, property.value);
                    break;
                case "UnitForeground":
                    this.unitForeground = new Color();
                    this.unitForeground.deserializeFromString(property.value);
                    break;
                case "CurrencyLabelFormat":
                    this.currencyLabelFormat = Enum.parse(StiDisplayCurrencyAs, property.value);
                    break;
                case "Currency":
                    this.currency = property.value;
                    break;
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "TextColor":
                    this.textColor = new Color();
                    this.textColor.deserializeFromString(property.value);
                    break;
                case "BorderColor":
                    this.borderColor = new Color();
                    this.borderColor.deserializeFromString(property.value);
                    break;
                case "BorderWeight":
                    this.borderWeight = Enum.parse(StiLineWeight, property.value);
                    break;
            }
        }
    }
}

class StiPDFSignatureElement extends StiFormElement {
    constructor() {
        super();
        this.type = "PDFSignatureElement";
        this.required = false;
        this.description = new StiTextItem();
        this.signaturePanelWidth = 185;
        this.signaturePanelHeight = 100;
        this.placeholder = "Place for Digital Signature";
        this.placeholderBackColor = Color.transparent();
        this.canvasHeight = 120;
        this.loadWithAspectRatio = false;
        this.geometry = new StiRectangleGeometry(180, 145);
        this.label = new StiLabelItem(this, StiLocalizationService.get("Components", "StiPdfDigitalSignature"));
    }
    saveToJsonObject(options) {
        var _a, _b, _c, _d;
        if (this.element) {
            if (((_a = this.element.nativeElement) === null || _a === void 0 ? void 0 : _a.offsetWidth) > 0 && ((_b = this.element.nativeElement) === null || _b === void 0 ? void 0 : _b.offsetHeight) > 0) {
                this.signaturePanelWidth = (_c = this.element.nativeElement) === null || _c === void 0 ? void 0 : _c.offsetWidth;
                this.signaturePanelHeight = (_d = this.element.nativeElement) === null || _d === void 0 ? void 0 : _d.offsetHeight;
            }
        }
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyBool("Required", this.required);
        jObject.addPropertyStringNullOrEmpty("Placeholder", this.placeholder);
        jObject.addPropertyColor("PlaceholderBackColor", this.placeholderBackColor);
        jObject.addPropertyNumber("SignaturePanelWidth", this.signaturePanelWidth);
        jObject.addPropertyNumber("SignaturePanelHeight", this.signaturePanelHeight);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "Required":
                    this.required = property.value;
                    break;
                case "SignaturePanelWidth":
                    this.signaturePanelWidth = property.value;
                    break;
                case "SignaturePanelHeight":
                    this.signaturePanelHeight = property.value;
                    break;
                case "Placeholder":
                    this.placeholder = property.value;
                    break;
                case "PlaceholderBackColor":
                    this.placeholderBackColor = new Color();
                    this.placeholderBackColor.deserializeFromString(property.value);
                    break;
            }
        }
    }
}

class StiImageEditorResult {
    constructor() {
        this.loadedImage = "";
        this.verticalAlignment = StiVerticalAlignment.Center;
        this.horizontalAlignment = StiHorizontalAlignment.Center;
        this.aspectRatio = false;
        this.stretch = false;
        this.naturalWidth = 0;
        this.naturalHeight = 0;
    }
    saveToJsonObject(options) {
        var _a;
        let json = new StiJson();
        json.addPropertyBool("AspectRatio", this.aspectRatio);
        json.addPropertyBool("Stretch", this.stretch);
        if (!(options && options["notSerializeImages"])) {
            json.addPropertyStringNullOrEmpty("LoadedImage", (_a = this.loadedImage) === null || _a === void 0 ? void 0 : _a.substring(this.loadedImage.indexOf("base64,") + 7));
        }
        json.addPropertyNumber("NaturalWidth", this.naturalWidth);
        json.addPropertyNumber("NaturalHeight", this.naturalHeight);
        json.addPropertyEnum("HorizontalAlignment", StiHorizontalAlignment, this.horizontalAlignment);
        json.addPropertyEnum("VerticalAlignment", StiVerticalAlignment, this.verticalAlignment);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "AspectRatio":
                    this.aspectRatio = property.value;
                    break;
                case "Stretch":
                    this.stretch = property.value;
                    break;
                case "LoadedImage":
                    this.loadedImage = `data:image/png;base64,${property.value}`;
                    break;
                case "NaturalWidth":
                    this.naturalWidth = property.value;
                    break;
                case "NaturalHeight":
                    this.naturalHeight = property.value;
                    break;
                case "HorizontalAlignment":
                    this.horizontalAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "VerticalAlignment":
                    this.verticalAlignment = Enum.parse(StiVerticalAlignment, property.value);
                    break;
            }
        }
    }
}

class StiSignatureElement extends StiFormElement {
    constructor() {
        super();
        this.type = "SignatureElement";
        this.required = false;
        this.description = new StiTextItem();
        this.signaturePanelWidth = 185;
        this.signaturePanelHeight = 100;
        this.insertedImage = new StiImageEditorResult();
        this.insertedText = new StiTextItem();
        this.penColor = Color.black();
        this.fullName = "";
        this.initials = "";
        this.specialFont = "Teddy Bear";
        this.currentSignatureMode = "Type";
        this.canvasHeight = 120;
        this.isSigned = false;
        this.geometry = new StiRectangleGeometry(180, 145);
        this.label = new StiLabelItem(this, StiLocalizationService.get("Components", "StiElectronicSignature"));
        this.description.value = "Signature";
        this.insertedText.font.size = 20;
        this.insertedText.horizontalAlignment = StiHorizontalAlignment.Center;
    }
    get value() {
        return this.backgroundImage;
    }
    saveToJsonObject(options) {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        if (this.element) {
            if (((_a = this.element.nativeElement) === null || _a === void 0 ? void 0 : _a.offsetWidth) > 0 && ((_b = this.element.nativeElement) === null || _b === void 0 ? void 0 : _b.offsetHeight) > 0) {
                this.signaturePanelWidth = (_c = this.element.nativeElement) === null || _c === void 0 ? void 0 : _c.offsetWidth;
                this.signaturePanelHeight = (_d = this.element.nativeElement) === null || _d === void 0 ? void 0 : _d.offsetHeight;
            }
        }
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyNumber("SignaturePanelWidth", this.signaturePanelWidth);
        jObject.addPropertyNumber("SignaturePanelHeight", this.signaturePanelHeight);
        jObject.addPropertyColor("PenColor", this.penColor);
        jObject.addPropertyJObject("InsertedImage", (_e = this.insertedImage) === null || _e === void 0 ? void 0 : _e.saveToJsonObject(options));
        jObject.addPropertyJObject("InsertedText", (_f = this.insertedText) === null || _f === void 0 ? void 0 : _f.saveToJsonObject(options));
        if (!(options && options["notSerializeImages"])) {
            jObject.addPropertyStringNullOrEmpty("DrawedImage", (_g = this.drawedImage) === null || _g === void 0 ? void 0 : _g.substring(this.drawedImage.indexOf("base64,") + 7));
        }
        jObject.addPropertyStringNullOrEmpty("FullName", this.fullName);
        jObject.addPropertyStringNullOrEmpty("Initials", this.initials);
        jObject.addPropertyStringNullOrEmpty("SpecialFont", this.specialFont);
        jObject.addPropertyStringNullOrEmpty("CurrentSignatureMode", this.currentSignatureMode);
        if (!(options && options["notSerializeImages"])) {
            jObject.addPropertyStringNullOrEmpty("BackgroundImage", (_h = this.backgroundImage) === null || _h === void 0 ? void 0 : _h.substring(this.backgroundImage.indexOf("base64,") + 7));
        }
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "SignaturePanelWidth":
                    this.signaturePanelWidth = property.value;
                    break;
                case "PenColor":
                    this.penColor = new Color();
                    this.penColor.deserializeFromString(property.value);
                    break;
                case "SignaturePanelHeight":
                    this.signaturePanelHeight = property.value;
                    break;
                case "InsertedImage":
                    this.insertedImage = new StiImageEditorResult();
                    this.insertedImage.loadFromJsonObject(property.value);
                    break;
                case "InsertedText":
                    this.insertedText = new StiTextItem();
                    this.insertedText.loadFromJsonObject(property.value);
                    break;
                case "DrawedImage":
                    this.drawedImage = `data:image/png;base64,${property.value}`;
                    break;
                case "FullName":
                    this.fullName = property.value;
                    break;
                case "Initials":
                    this.initials = property.value;
                    break;
                case "SpecialFont":
                    this.specialFont = property.value;
                    break;
                case "CurrentSignatureMode":
                    this.currentSignatureMode = property.value;
                    break;
                case "BackgroundImage":
                    this.backgroundImage = `data:image/png;base64,${property.value}`;
                    break;
            }
        }
    }
}

class StiSingleSelectionElement extends StiFormElement {
    constructor() {
        super();
        this.type = "Single_SelectionElement";
        this.tooltip = "";
        this.required = false;
        this.description = new StiTextItem();
        this.font = new Font("Segoe UI", 10);
        this._columns = 1;
        this.backgroundColor = Color.white();
        this.textColor = Color.black();
        this.checkColor = Color.black();
        this.borderColor = Color.lightGray();
        this.prefix = "";
        this.suffix = "";
        this.optionsContentEditable = [];
        this.useCustomOption = false;
        this.customOptionText = "";
        this.selectedOption = "";
        this.geometry = new StiRectangleGeometry(150, 80);
        this.label = new StiLabelItem(this, StiLocalizationService.get("Components", "StiSingleSelection"));
        this.options = [];
        this.options.push(StiLocalizationService.get("PropertyMain", "First"));
        this.options.push(StiLocalizationService.get("PropertyMain", "Second"));
        this.options.push(StiLocalizationService.get("PropertyMain", "Third"));
    }
    setDefaultValues() {
        this.selectedOption = "";
    }
    setTabIndex(value) {
        var _a, _b;
        this.tabIndex = value;
        return value + ((_b = (_a = this.options) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0);
    }
    get columns() {
        return this._columns;
    }
    set columns(value) {
        if (value <= 1) {
            this._columns = 1;
        }
        else {
            this._columns = value;
        }
    }
    set options(value) {
        this.nativeOptions = value;
        let this_ = this;
        this._options = new Proxy(value, {
            deleteProperty: function (target, property) {
                setTimeout(() => {
                    this_.updateOptionsContentEditable();
                }, 0);
                return true;
            },
            set: function (target, property, value, receiver) {
                target[property] = value;
                this_.updateOptionsContentEditable();
                return true;
            },
        });
        this.updateOptionsContentEditable();
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.font.family, this.arrayOfStylesToString(this.font.style), this.font.size);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    updateOptionsContentEditable() {
        this.optionsContentEditable = [];
        this.options.forEach((l, index) => this.optionsContentEditable.push(new StiOptionItem(l, this, index)));
    }
    getDefaultEditableContent() {
        let textItem = new StiInputTextItem("", this.font, this.textColor);
        textItem.element = this;
        return textItem;
    }
    get value() {
        return this.selectedOption;
    }
    get options() {
        return this._options;
    }
    htmlStyle() {
        return `${this.font.htmlStyle()};color:${this.textColor.toHtmlColor()};`;
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyString("Tooltip", this.tooltip);
        jObject.addPropertyBool("Required", this.required);
        jObject.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        jObject.addPropertyNumber("Columns", this.columns);
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyColor("TextColor", this.textColor);
        jObject.addPropertyColor("CheckColor", this.checkColor);
        jObject.addPropertyColor("BorderColor", this.borderColor);
        jObject.addPropertyArray("Options", this.options);
        jObject.addPropertyBool("UseCustomOption", this.useCustomOption);
        jObject.addPropertyString("CustomOptionText", this.customOptionText);
        jObject.addPropertyString("SelectedOption", this.selectedOption);
        jObject.addPropertyString("Prefix", this.prefix);
        jObject.addPropertyString("Suffix", this.suffix);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "TextColor":
                    this.textColor = new Color();
                    this.textColor.deserializeFromString(property.value);
                    break;
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Font":
                    this.font = new Font();
                    this.font.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "Tooltip":
                    this.tooltip = property.value;
                    break;
                case "Required":
                    this.required = property.value;
                    break;
                case "Columns":
                    this.columns = property.value;
                    break;
                case "BorderColor":
                    this.borderColor = new Color();
                    this.borderColor.deserializeFromString(property.value);
                    break;
                case "CheckColor":
                    this.checkColor = new Color();
                    this.checkColor.deserializeFromString(property.value);
                    break;
                case "CustomOptionText":
                    this.customOptionText = property.value;
                    break;
                case "UseCustomOption":
                    this.useCustomOption = property.value;
                    break;
                case "SelectedOption":
                    this.selectedOption = property.value;
                    break;
                case "Prefix":
                    this.prefix = property.value;
                    break;
                case "Suffix":
                    this.suffix = property.value;
                    break;
                case "Options":
                    this.options = [];
                    property.value.properties().forEach((p) => this.options.push(p.value));
                    break;
            }
        }
    }
}

class StiInnerBorder {
    constructor(pen, drawHorizontal, drawVertical) {
        this.pen = pen;
        this.drawHorizontal = drawHorizontal;
        this.drawVertical = drawVertical;
    }
    saveToJsonObject(options) {
        var _a;
        let json = new StiJson();
        json.addPropertyJObject("Pen", (_a = this.pen) === null || _a === void 0 ? void 0 : _a.saveToJsonObject(options));
        json.addPropertyBool("DrawHorizontal", this.drawHorizontal);
        json.addPropertyBool("DrawVertical", this.drawVertical);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Pen":
                    this.pen = new StiPen();
                    this.pen.loadFromJsonObject(property.value);
                    break;
                case "DrawHorizontal":
                    this.drawHorizontal = property.value;
                    break;
                case "DrawVertical":
                    this.drawVertical = property.value;
                    break;
            }
        }
    }
}

class StiCheckBoxCellItem {
    constructor(name, isChecked) {
        this.name = name;
        this.isChecked = isChecked;
    }
    saveToJsonObject(options) {
        let jObject = new StiJson();
        jObject.addPropertyString("Name", this.name);
        jObject.addPropertyBool("IsChecked", this.isChecked);
        return jObject;
    }
    get value() {
        return this.isChecked;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Name":
                    this.name = property.value;
                    break;
                case "IsChecked":
                    this.isChecked = property.value;
                    break;
            }
        }
    }
}

class StiComboBoxCellItem {
    constructor(name, selectedIndex) {
        this.name = name;
        this.selectedIndex = selectedIndex;
    }
    saveToJsonObject(options) {
        let jObject = new StiJson();
        jObject.addPropertyString("Name", this.name);
        jObject.addPropertyNumber("SelectedIndex", this.selectedIndex);
        return jObject;
    }
    get value() {
        return this.selectedIndex ? this.selectedIndex : 0;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Name":
                    this.name = property.value;
                    break;
                case "SelectedIndex":
                    this.selectedIndex = property.value;
                    break;
            }
        }
    }
}

class StiNumberBoxCellItem {
    constructor(name, number = 0) {
        this.name = name;
        this.number = number;
    }
    saveToJsonObject(options) {
        let jObject = new StiJson();
        jObject.addPropertyString("Name", this.name);
        jObject.addPropertyNumber("Number", this.number);
        return jObject;
    }
    get value() {
        return this.number ? this.number : 0;
    }
    set value(value) {
        this.number = value;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Name":
                    this.name = property.value;
                    break;
                case "Number":
                    this.number = property.value;
                    break;
            }
        }
    }
}

class StiRadioButtonCellItem {
    constructor(name, isChecked) {
        this.name = name;
        this.isChecked = isChecked;
    }
    saveToJsonObject(options) {
        let jObject = new StiJson();
        jObject.addPropertyString("Name", this.name);
        jObject.addPropertyBool("IsChecked", this.isChecked);
        return jObject;
    }
    get value() {
        return this.isChecked;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Name":
                    this.name = property.value;
                    break;
                case "IsChecked":
                    this.isChecked = property.value;
                    break;
            }
        }
    }
}

class StiTextBoxCellItem {
    constructor(name, text) {
        this.name = name;
        this.text = text;
    }
    saveToJsonObject(options) {
        let jObject = new StiJson();
        jObject.addPropertyString("Name", this.name);
        jObject.addPropertyString("Text", this.text);
        return jObject;
    }
    get value() {
        return this.text ? this.text : "";
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Name":
                    this.name = property.value;
                    break;
                case "Text":
                    this.text = property.value;
                    break;
            }
        }
    }
}

class StiColumnItem extends StiFormObject {
    constructor(label) {
        super();
        this.label = label;
        this.headerAlignment = StiHorizontalAlignment.Left;
        this.cellAlignment = StiHorizontalAlignment.Left;
        this.headerForeColor = Color.black();
        this.headerBackColor = Color.transparent();
        this.backgroundColor = Color.transparent();
        this.cellBackColor = Color.white();
        this.cellForeColor = Color.black();
        this.cellBorderColor = Color.lightGray();
        this.font = new Font("Segoe UI", 10);
        this.useWordWrap = false;
    }
    setDefaultValues() { }
    get eValue() {
        return this.label;
    }
    set eValue(value) {
        this.label = value;
    }
    get eFont() {
        return this.font;
    }
    set eFont(value) {
        this.font = value;
    }
    get eColor() {
        return this.headerForeColor;
    }
    set eColor(value) {
        this.headerForeColor = value;
    }
    get eBackgroundColor() {
        return this.headerBackColor;
    }
    set eBackgroundColor(value) {
        this.headerBackColor = value;
    }
    get eContentAlignment() {
        return this.headerAlignment;
    }
    set eContentAlignment(value) {
        this.headerAlignment = value;
    }
    haveContentAlignment() {
        return true;
    }
    haveVerticalAlignment() {
        return false;
    }
    haveBackgoundColor() {
        return true;
    }
    htmlStyle() {
        return this.eParent
            ? `${this.eFont.htmlStyle()};color:${this.eColor.toHtmlColor()};text-align:${Enum.getName(StiHorizontalAlignment, this.cellAlignment)}`
            : "";
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyString("Label", this.label);
        jObject.addPropertyEnum("HeaderAlignment", StiHorizontalAlignment, this.headerAlignment);
        jObject.addPropertyEnum("CellAlignment", StiHorizontalAlignment, this.cellAlignment);
        jObject.addPropertyColor("HeaderBackColor", this.headerBackColor);
        jObject.addPropertyColor("HeaderForeColor", this.headerForeColor);
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyColor("CellBackColor", this.cellBackColor);
        jObject.addPropertyColor("CellForeColor", this.cellForeColor);
        jObject.addPropertyColor("CellBorderColor", this.cellBorderColor);
        jObject.addPropertyBool("UseWordWrap", this.useWordWrap);
        jObject.addPropertyNumber("Width", this.width);
        jObject.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this.label = property.value;
                    break;
                case "Width":
                    this.width = property.value;
                    break;
                case "UseWordWrap":
                    this.useWordWrap = property.value;
                    break;
                case "HeaderAlignment":
                    this.headerAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "CellAlignment":
                    this.cellAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "HeaderBackColor":
                    this.headerBackColor = new Color();
                    this.headerBackColor.deserializeFromString(property.value);
                    break;
                case "HeaderForeColor":
                    this.headerForeColor = new Color();
                    this.headerForeColor.deserializeFromString(property.value);
                    break;
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "CellBackColor":
                    this.cellBackColor = new Color();
                    this.cellBackColor.deserializeFromString(property.value);
                    break;
                case "CellForeColor":
                    this.cellForeColor = new Color();
                    this.cellForeColor.deserializeFromString(property.value);
                    break;
                case "CellBorderColor":
                    this.cellBorderColor = new Color();
                    this.cellBorderColor.deserializeFromString(property.value);
                    break;
                case "Font":
                    this.font = new Font();
                    this.font.loadFromJsonObject(property.value);
                    break;
            }
        }
        if (!json.properties().find((property) => property.name == "Font")) {
            this.font = this.eParent.font.clone();
        }
    }
}

class StiCheckBoxColumnItem extends StiColumnItem {
    constructor() {
        super(...arguments);
        this.type = "CheckBoxColumn";
        this.cells = [];
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyArray("Cells", this.cells);
        return jObject;
    }
    setDefaultValues() {
        this.cells.forEach((cell) => {
            cell.isChecked = false;
        });
    }
    get value() {
        let result = [];
        this.cells.forEach((c) => result.push(c.isChecked));
        return result;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Cells":
                    this.cells = [];
                    for (let cellJson of property.value.value) {
                        let cell = new StiCheckBoxCellItem();
                        cell.loadFromJsonObject(cellJson);
                        this.cells.push(cell);
                    }
                    break;
            }
        }
    }
}

class StiComboBoxColumnItem extends StiColumnItem {
    constructor() {
        super(...arguments);
        this.type = "ComboBoxColumn";
        this.cells = [];
        this.comboBoxOptions = [];
    }
    get value() {
        let result = [];
        this.cells.forEach((c) => result.push(c.selectedIndex > 0 && this.comboBoxOptions.length < c.selectedIndex
            ? this.comboBoxOptions[c.selectedIndex]
            : null));
        return result;
    }
    setDefaultValues() {
        this.cells.forEach((cell) => {
            cell.selectedIndex = 0;
        });
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyArray("Cells", this.cells);
        jObject.addPropertyArray("ComboBoxOptions", this.comboBoxOptions);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Cells":
                    this.cells = [];
                    for (let cellJson of property.value.value) {
                        let cell = new StiComboBoxCellItem();
                        cell.loadFromJsonObject(cellJson);
                        this.cells.push(cell);
                    }
                    break;
                case "ComboBoxOptions":
                    this.comboBoxOptions = [];
                    property.value.properties().forEach((p) => this.comboBoxOptions.push(p.value));
                    break;
            }
        }
    }
}

class StiLabelColumnItem extends StiColumnItem {
    constructor() {
        super(...arguments);
        this._decimalDigits = 2;
        this.type = "LabelColumn";
        this.expression = "";
        this.prefix = "";
        this.suffix = "";
        this.cells = [];
        this.thousandSeparator = StiThousandSeparator.None;
    }
    setDefaultValues() {
        this.cells.forEach((cell) => {
            cell = "";
        });
    }
    get value() {
        let result = [];
        this.cells.forEach((c) => result.push(c));
        return result;
    }
    set value(value) { }
    get decimalDigits() {
        return this._decimalDigits;
    }
    set decimalDigits(value) {
        this._decimalDigits = Math.max(0, Math.min(value, 10));
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyArray("Cells", this.cells);
        jObject.addPropertyString("Expression", this.expression);
        jObject.addPropertyString("Prefix", this.prefix);
        jObject.addPropertyString("Suffix", this.suffix);
        jObject.addPropertyNumber("DecimalDigits", this.decimalDigits);
        jObject.addPropertyEnum("ThousandSeparator", StiThousandSeparator, this.thousandSeparator);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Expression":
                    this.expression = property.value;
                    break;
                case "Cells":
                    this.cells = [];
                    property.value.properties().forEach((p) => this.cells.push(p.value));
                    break;
                case "ThousandSeparator":
                    this.thousandSeparator = Enum.parse(StiThousandSeparator, property.value);
                    break;
                case "DecimalDigits":
                    this.decimalDigits = property.value;
                    break;
                case "Prefix":
                    this.prefix = property.value;
                    break;
                case "Suffix":
                    this.suffix = property.value;
                    break;
            }
        }
    }
}

class StiNumberBoxColumnItem extends StiColumnItem {
    constructor() {
        super(...arguments);
        this._decimalDigits = 2;
        this.type = "NumberBoxColumn";
        this.unitLabel = "";
        this.cells = [];
        this.thousandSeparator = StiThousandSeparator.None;
        this.numberType = StiNumberType.Decimal;
        this.unitAlignment = StiUnitAlignment.Suffix;
        this.currencyLabelFormat = StiDisplayCurrencyAs.Code;
        this.currency = "USD";
    }
    setDefaultValues() {
        this.cells.forEach((cell) => {
            cell.number = 0;
        });
    }
    get decimalDigits() {
        return this._decimalDigits;
    }
    set decimalDigits(value) {
        if (value <= 0) {
            this._decimalDigits = 0;
        }
        else {
            this._decimalDigits = value;
        }
    }
    get value() {
        let result = [];
        this.cells.forEach((c) => result.push(c.number));
        return result;
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyArray("Cells", this.cells);
        jObject.addPropertyEnum("CurrencyLabelFormat", StiDisplayCurrencyAs, this.currencyLabelFormat);
        jObject.addPropertyString("Currency", this.currency);
        jObject.addPropertyString("UnitLabel", this.unitLabel);
        jObject.addPropertyEnum("UnitAlignment", StiUnitAlignment, this.unitAlignment);
        jObject.addPropertyEnum("NumberType", StiNumberType, this.numberType);
        jObject.addPropertyEnum("ThousandSeparator", StiThousandSeparator, this.thousandSeparator);
        jObject.addPropertyNumber("DecimalDigits", this.decimalDigits);
        return jObject;
    }
    htmlStyle() {
        var _a;
        if (this.eParent) {
            return super.htmlStyle();
        }
        else
            return `${this.eParent ? super.htmlStyle() + ";" : ""}color:${(_a = this.cellForeColor) === null || _a === void 0 ? void 0 : _a.toHtmlColor()};text-align:${Enum.getName(StiHorizontalAlignment, this.cellAlignment)}`;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Cells":
                    this.cells = [];
                    for (let cellJson of property.value.value) {
                        let cell = new StiNumberBoxCellItem("", 0);
                        cell.loadFromJsonObject(cellJson);
                        this.cells.push(cell);
                    }
                    break;
                case "NumberType":
                    this.numberType = Enum.parse(StiNumberType, property.value);
                    break;
                case "ThousandSeparator":
                    this.thousandSeparator = Enum.parse(StiThousandSeparator, property.value);
                    break;
                case "DecimalDigits":
                    this.decimalDigits = property.value;
                    break;
                case "UnitLabel":
                    this.unitLabel = property.value;
                    break;
                case "UnitAlignment":
                    this.unitAlignment = Enum.parse(StiUnitAlignment, property.value);
                    break;
                case "CurrencyLabelFormat":
                    this.currencyLabelFormat = Enum.parse(StiDisplayCurrencyAs, property.value);
                    break;
                case "Currency":
                    this.currency = property.value;
                    break;
            }
        }
    }
}

class StiRadioButtonColumnItem extends StiColumnItem {
    constructor() {
        super(...arguments);
        this.type = "RadioButtonColumn";
        this.cells = [];
    }
    get value() {
        let result = [];
        this.cells.forEach((c) => result.push(c.isChecked));
        return result;
    }
    setDefaultValues() {
        this.cells.forEach((cell) => {
            cell.isChecked = false;
        });
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyArray("Cells", this.cells);
        jObject.addPropertyString("Name", this.name);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Cells":
                    this.cells = [];
                    for (let cellJson of property.value.value) {
                        let cell = new StiRadioButtonCellItem();
                        cell.loadFromJsonObject(cellJson);
                        this.cells.push(cell);
                    }
                    break;
                case "Name":
                    this.name = property.value;
                    break;
            }
        }
    }
}

class StiTextBoxColumnItem extends StiColumnItem {
    constructor() {
        super(...arguments);
        this.type = "TextBoxColumn";
        this.cells = [];
    }
    get value() {
        let result = [];
        this.cells.forEach((c) => result.push(c.text));
        return result;
    }
    setDefaultValues() {
        this.cells.forEach((cell) => {
            cell.text = "";
        });
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyArray("Cells", this.cells);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Cells":
                    this.cells = [];
                    for (let cellJson of property.value.value) {
                        let cell = new StiTextBoxCellItem();
                        cell.loadFromJsonObject(cellJson);
                        this.cells.push(cell);
                    }
                    break;
            }
        }
    }
}

class StiRowLabel {
    constructor(value, table, index) {
        this.table = table;
        this.index = index;
        this._value = value;
    }
    get eFont() {
        return this.table.font;
    }
    set eFont(value) {
        this.table.font = value;
    }
    get eColor() {
        return this.table.rowHeadersColor;
    }
    set eColor(value) {
        this.table.rowHeadersColor = value;
    }
    get eBackgroundColor() {
        return this.table.rowHeadersBackground;
    }
    set eBackgroundColor(value) {
        this.table.rowHeadersBackground = value;
    }
    get expression() {
        return this.value;
    }
    haveBackgoundColor() {
        return true;
    }
    get eContentAlignment() {
        return this.table.rowLabelsHorizontalAlignment;
    }
    set eContentAlignment(value) {
        this.table.rowLabelsHorizontalAlignment = value;
    }
    haveContentAlignment() {
        return true;
    }
    haveVerticalAlignment() {
        return false;
    }
    getDefaultEditableContent() {
        return this;
    }
    htmlStyle() {
        return this.table ? `${this.eFont.htmlStyle()};color: inherit` : "";
    }
    set value(value) {
        this._value = value;
        this.table.nativeRowLabels[this.index] = value;
    }
    get value() {
        return this._value;
    }
    set eValue(value) {
        this.value = value;
    }
    get eValue() {
        return this.value;
    }
}

class StiTotalsFieldItem extends StiFormObject {
    constructor(header, expression, headerAlignment = StiHorizontalAlignment.Right, headerColor = Color.black(), valueAlignment = StiHorizontalAlignment.Right) {
        super();
        this.header = header;
        this.expression = expression;
        this.headerAlignment = headerAlignment;
        this.headerColor = headerColor;
        this.valueAlignment = valueAlignment;
        this._decimalDigits = 2;
        this.prefix = "";
        this.suffix = "";
        this.thousandSeparator = StiThousandSeparator.None;
        this.name = "";
    }
    setDefaultValues() {
        this.value = 0;
    }
    get value() {
        return this._value !== undefined ? this._value : this.expression;
    }
    set value(value) {
        this._value = value;
    }
    get decimalDigits() {
        return this._decimalDigits;
    }
    set decimalDigits(value) {
        if (value <= 0) {
            this._decimalDigits = 0;
        }
        else {
            this._decimalDigits = value;
        }
    }
    get eValue() {
        return this.header;
    }
    set eValue(value) {
        this.header = value;
    }
    get eFont() {
        return this.eParent.font;
    }
    set eFont(value) {
        this.eParent.font = value;
    }
    get eColor() {
        return this.headerColor;
    }
    set eColor(value) {
        this.headerColor = value;
    }
    haveBackgoundColor() {
        return false;
    }
    get eContentAlignment() {
        return this.headerAlignment;
    }
    set eContentAlignment(value) {
        this.headerAlignment = value;
    }
    haveContentAlignment() {
        return true;
    }
    haveVerticalAlignment() {
        return false;
    }
    htmlStyle() {
        return this.eParent ? `${this.eFont.htmlStyle()};color:${this.eColor.toHtmlColor()}` : "";
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyString("Header", this.header);
        jObject.addPropertyString("Name", this.name);
        jObject.addPropertyEnum("HeaderAlignment", StiHorizontalAlignment, this.headerAlignment);
        jObject.addPropertyEnum("ValueAlignment", StiHorizontalAlignment, this.valueAlignment);
        jObject.addPropertyColor("HeaderColor", this.headerColor);
        jObject.addPropertyString("Expression", this.expression);
        jObject.addPropertyString("Prefix", this.prefix);
        jObject.addPropertyString("Suffix", this.suffix);
        jObject.addPropertyNumber("DecimalDigits", this.decimalDigits);
        jObject.addPropertyEnum("ThousandSeparator", StiThousandSeparator, this.thousandSeparator);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Header":
                    this.header = property.value;
                    break;
                case "HeaderAlignment":
                    this.headerAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "ValueAlignment":
                    this.valueAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "HeaderColor":
                    this.headerColor = new Color();
                    this.headerColor.deserializeFromString(property.value);
                    break;
                case "Expression":
                    this.expression = property.value;
                    break;
                case "ThousandSeparator":
                    this.thousandSeparator = Enum.parse(StiThousandSeparator, property.value);
                    break;
                case "DecimalDigits":
                    this.decimalDigits = property.value;
                    break;
                case "Prefix":
                    this.prefix = property.value;
                    break;
                case "Suffix":
                    this.suffix = property.value;
                    break;
                case "Name":
                    this.name = property.value;
                    break;
            }
        }
    }
}

class StiTotalsRowHeaderEditableContent {
    constructor(table) {
        this.table = table;
    }
    get eValue() {
        return this.table.totalsRowHeader;
    }
    set eValue(value) {
        this.table.totalsRowHeader = value;
    }
    get eFont() {
        return this.table.font;
    }
    set eFont(value) {
        this.table.font = value;
    }
    get eColor() {
        return this.table.totalsRowHeaderColor;
    }
    set eColor(value) {
        this.table.totalsRowHeaderColor = value;
    }
    haveBackgoundColor() {
        return false;
    }
    get eContentAlignment() {
        return this.table.totalsRowHeaderHorizontalAlignment;
    }
    set eContentAlignment(value) {
        this.table.totalsRowHeaderHorizontalAlignment = value;
    }
    haveContentAlignment() {
        return true;
    }
    get eVerticalAlignment() {
        return this.table.totalsRowHeaderVerticalAlignment;
    }
    set eVerticalAlignment(value) {
        this.table.totalsRowHeaderVerticalAlignment = value;
    }
    haveVerticalAlignment() {
        return true;
    }
    htmlStyle() {
        return `${this.eFont.htmlStyle()};color:${this.eColor.toHtmlColor()}`;
    }
}

class StiTableElement extends StiFormElement {
    constructor() {
        super();
        this.type = "TableElement";
        this.description = new StiTextItem();
        this.font = new Font("Segoe UI", 10);
        this.border = new StiBorder(StiPen.dimGraySolid(), true, true, true, true);
        this.gridLines = new StiInnerBorder(StiPen.dimGraySolid(), true, true);
        this.backgroundColor = Color.transparent();
        this.alternateRowColors = false;
        this.evenRowsStyle = Color.fromArgb(0xff, 0xf9, 0xf9, 0xf9);
        this.evenRowsTextColor = Color.black();
        this.oddRowsStyle = Color.fromArgb(0xff, 0xf3, 0xf3, 0xf3);
        this.oddRowsTextColor = Color.black();
        this.tableHeaderText = "";
        this.tableHeaderAlignment = StiHorizontalAlignment.Left;
        this.tableHeaderColor = Color.black();
        this.tableHeaderHeight = 0;
        this.tableHeaderBackgroundColor = Color.transparent();
        this.rowLabelsWidth = 100;
        this._showRowLabels = true;
        this.dynamicRows = false;
        this.useWordWrap = false;
        this.rowLabelsContentEditable = [];
        this.rowLabelsHorizontalAlignment = StiHorizontalAlignment.Left;
        this.rowHeadersBackground = Color.transparent();
        this.rowHeadersColor = Color.black();
        this.rowHeadersBorder = new StiBorder(StiPen.dimGraySolid(), true, true, true, true);
        this.columnHeadersBorder = new StiBorder(StiPen.dimGraySolid(), true, true, true, true);
        this._columns = [];
        this.useTotals = true;
        this.totalsRowHeader = StiLocalizationService.get("PropertyMain", "Totals");
        this.totalsRowHeaderHorizontalAlignment = StiHorizontalAlignment.Left;
        this.totalsRowHeaderVerticalAlignment = StiVerticalAlignment.Top;
        this.totalsRowHeaderColor = Color.black();
        this._totalsValuesWidth = 100;
        this._totalsHeadersWidth = 100;
        this.totalsFields = [];
        this.showBorderEditor = false;
        this.showGridLinesEditor = false;
        this._showHeaderEditor = true;
        this._showColumnsEditor = false;
        this._showRowsEditor = false;
        this._showTotalsEditor = false;
        this.stopFit = false;
        this.showColumnsBorderEditor = true;
        this.showRowsBorderEditor = false;
        this.minColumnWidth = 40;
        this.totalsRowHeaderEditableContent = new StiTotalsRowHeaderEditableContent(this);
        this.geometry = new StiRectangleGeometry(320, 245);
        this.label = new StiLabelItem(this, StiLocalizationService.get("Components", "StiTable"));
        this.columns = [];
        this.columns.push(new StiCheckBoxColumnItem(StiLocalizationService.get("PropertyMain", "First")));
        this.columns.push(new StiComboBoxColumnItem(StiLocalizationService.get("PropertyMain", "Second")));
        this.columns.push(new StiRadioButtonColumnItem(StiLocalizationService.get("PropertyMain", "Third")));
        this.columns.push(new StiTextBoxColumnItem(StiLocalizationService.get("PropertyMain", "Fourth")));
        this.columns.push(new StiNumberBoxColumnItem(StiLocalizationService.get("PropertyMain", "Fifth")));
        this.columns.push(new StiLabelColumnItem(StiLocalizationService.get("PropertyMain", "Labels")));
        this.rowLabels = [];
        this.rowLabels.push(StiLocalizationService.get("PropertyMain", "First"));
        this.rowLabels.push(StiLocalizationService.get("PropertyMain", "Second"));
        this.rowLabels.push(StiLocalizationService.get("PropertyMain", "Third"));
        this.totalsFields.push(new StiTotalsFieldItem(StiLocalizationService.get("PropertyMain", "First"), "{Cell(5,1)}"));
        this.totalsFields.push(new StiTotalsFieldItem(StiLocalizationService.get("PropertyMain", "Maximum"), "{Max(Col(5))}"));
        this.totalsFields.push(new StiTotalsFieldItem(StiLocalizationService.get("PropertyMain", "Summary"), "{Sum(Col(5))}"));
        this.totalsFields.push(new StiTotalsFieldItem(StiLocalizationService.get("PropertyMain", "Count"), "{Count(Col(5))}"));
        this.columns.forEach((column) => {
            if (column.type == "CheckBoxColumn" && column instanceof StiCheckBoxColumnItem) {
                this.rowLabels.forEach((row) => {
                    column.cells.push(new StiCheckBoxCellItem("", false));
                });
            }
            else if (column.type == "ComboBoxColumn" && column instanceof StiComboBoxColumnItem) {
                column.comboBoxOptions.push("yes");
                column.comboBoxOptions.push("no");
                this.rowLabels.forEach((row) => {
                    column.cells.push(new StiComboBoxCellItem("", 0));
                });
            }
            else if (column.type == "RadioButtonColumn" && column instanceof StiRadioButtonColumnItem) {
                this.rowLabels.forEach((row) => {
                    column.cells.push(new StiRadioButtonCellItem("", false));
                });
            }
            else if (column.type == "TextBoxColumn" && column instanceof StiTextBoxColumnItem) {
                this.rowLabels.forEach((row) => {
                    column.cells.push(new StiTextBoxCellItem("", ""));
                });
            }
            else if (column.type == "NumberBoxColumn" && column instanceof StiNumberBoxColumnItem) {
                this.rowLabels.forEach((row) => {
                    column.cells.push(new StiNumberBoxCellItem("", 0));
                });
            }
            else if (column.type == "LabelColumn" && column instanceof StiLabelColumnItem) {
                this.rowLabels.forEach((row) => {
                    column.cells.push("");
                });
            }
        });
    }
    get showRowLabels() {
        return this._showRowLabels;
    }
    set showRowLabels(value) {
        let previousValue = this._showRowLabels;
        if (previousValue != value) {
            this._showRowLabels = value;
            this.fitTable();
        }
    }
    get showHeaderEditor() {
        return this._showHeaderEditor;
    }
    set showHeaderEditor(value) {
        this._showHeaderEditor = value;
        if (value == true) {
            this._showColumnsEditor = false;
            this._showRowsEditor = false;
            this._showTotalsEditor = false;
        }
    }
    get totalsValuesWidth() {
        return this._totalsValuesWidth;
    }
    set totalsValuesWidth(value) {
        if (value > 0) {
            this._totalsValuesWidth = value;
        }
        else {
            this._totalsValuesWidth = 0;
        }
    }
    get totalsHeadersWidth() {
        return this._totalsHeadersWidth;
    }
    set totalsHeadersWidth(value) {
        if (value > 0) {
            this._totalsHeadersWidth = value;
        }
        else {
            this._totalsHeadersWidth = 0;
        }
    }
    get showColumnsEditor() {
        return this._showColumnsEditor;
    }
    set showColumnsEditor(value) {
        this._showColumnsEditor = value;
        if (value == true) {
            this._showHeaderEditor = false;
            this._showRowsEditor = false;
            this._showTotalsEditor = false;
        }
    }
    get showRowsEditor() {
        return this._showRowsEditor;
    }
    set showRowsEditor(value) {
        this._showRowsEditor = value;
        if (value == true) {
            this._showHeaderEditor = false;
            this._showColumnsEditor = false;
            this._showTotalsEditor = false;
        }
    }
    get showTotalsEditor() {
        return this._showTotalsEditor;
    }
    set showTotalsEditor(value) {
        this._showTotalsEditor = value;
        if (value == true) {
            this._showHeaderEditor = false;
            this._showColumnsEditor = false;
            this._showRowsEditor = false;
        }
    }
    getDefaultEditableContent() {
        let textItem = new StiInputTextItem("", this.font);
        textItem.element = this;
        return textItem;
    }
    setTabIndex(value) {
        var _a, _b, _c;
        this.tabIndex = value;
        return value + ((_c = ((_a = this.columns) === null || _a === void 0 ? void 0 : _a.length) * ((_b = this._rowLabels) === null || _b === void 0 ? void 0 : _b.length)) !== null && _c !== void 0 ? _c : 0);
    }
    get maxTableWidth() {
        return (this.width -
            this.padding.left -
            this.padding.right -
            (this.label.alignment != StiLabelAlignment.Top && this.label.value.length > 0 ? this.label.width : 0));
    }
    set rowLabels(value) {
        this.nativeRowLabels = value;
        let this_ = this;
        this._rowLabels = new Proxy(value, {
            deleteProperty: function (target, property) {
                setTimeout(() => {
                    this_.updateRowLabelsContentEditable();
                }, 0);
                return true;
            },
            set: function (target, property, value, receiver) {
                target[property] = value;
                this_.updateRowLabelsContentEditable();
                return true;
            },
        });
        this.updateRowLabelsContentEditable();
    }
    get rowLabels() {
        return this._rowLabels;
    }
    setDefaultValues() {
        this.columns.forEach((column) => {
            column.setDefaultValues();
        });
        this.totalsFields.forEach((total) => {
            total.setDefaultValues();
        });
    }
    set columns(value) {
        let this_ = this;
        this._columns = new Proxy(value, {
            deleteProperty: function (target, property) {
                setTimeout(() => {
                    this_.fitTable();
                }, 0);
                return true;
            },
            set: function (target, property, value, receiver) {
                target[property] = value;
                let column = value;
                if (column instanceof StiColumnItem && !column.width) {
                    column.width = this_.maxTableWidth / (this_.columns.length + (this_.showRowLabels ? 1 : 0));
                }
                if (!target.stopFit) {
                    this_.fitTable();
                }
                return true;
            },
        });
        this_.fitTable();
    }
    fitTable() {
        if (this.stopFit) {
            return;
        }
        let currentWidth = this.showRowLabels ? this.rowLabelsWidth : 0;
        this.columns.forEach((c) => (currentWidth += c.width));
        let pc = this.maxTableWidth / currentWidth;
        if (currentWidth != 0 && currentWidth && pc) {
            if (this.showRowLabels) {
                this.rowLabelsWidth *= pc;
            }
            this.columns.forEach((c) => (c.width *= pc));
        }
        pc = this.maxTableWidth / (this.totalsHeadersWidth + this.totalsValuesWidth);
        if (pc < 1) {
            this.totalsHeadersWidth *= pc;
            this.totalsValuesWidth *= pc;
        }
    }
    deleteLastRow() {
        this.rowLabels.splice(this.rowLabels.length - 1, 1);
    }
    deleteLastColumn() {
        this.columns.splice(this.columns.length - 1, 1);
    }
    addColumn() {
        let newColumnWidth = (this.maxTableWidth - this.rowLabelsWidth) / (this.columns.length + 1);
        let maxChangeableWidth = 0;
        if (this.columns.length > 0) {
            this.columns.forEach((column) => {
                if (column.width > this.minColumnWidth) {
                    maxChangeableWidth += column.width - this.minColumnWidth;
                }
            });
        }
        else {
            maxChangeableWidth = this.maxTableWidth - this.rowLabelsWidth;
        }
        if (newColumnWidth <= maxChangeableWidth) {
            let lastColumn = this.columns[this.columns.length - 1];
            if (lastColumn) {
                if (lastColumn.type == "CheckBoxColumn") {
                    this.columns.push(new StiCheckBoxColumnItem(""));
                }
                else if (lastColumn.type == "ComboBoxColumn") {
                    this.columns.push(new StiComboBoxColumnItem(""));
                }
                else if (lastColumn.type == "NumberBoxColumn") {
                    this.columns.push(new StiNumberBoxColumnItem(""));
                }
                else if (lastColumn.type == "RadioButtonColumn") {
                    this.columns.push(new StiRadioButtonColumnItem(""));
                }
                else if (lastColumn.type == "TextBoxColumn") {
                    this.columns.push(new StiTextBoxColumnItem(""));
                }
                else if (lastColumn.type == "LabelColumn") {
                    this.columns.push(new StiLabelColumnItem(""));
                }
            }
            else {
                this.columns.push(new StiCheckBoxColumnItem(""));
            }
            let newColumn = this.columns[this.columns.length - 1];
            this.rowLabels.forEach(() => {
                if (newColumn.type == "CheckBoxColumn" && newColumn instanceof StiCheckBoxColumnItem) {
                    newColumn.cells.push(new StiCheckBoxCellItem("", false));
                }
                else if (newColumn.type == "ComboBoxColumn" && newColumn instanceof StiComboBoxColumnItem) {
                    newColumn.cells.push(new StiComboBoxCellItem("", 0));
                }
                else if (newColumn.type == "RadioButtonColumn" && newColumn instanceof StiRadioButtonColumnItem) {
                    newColumn.cells.push(new StiRadioButtonCellItem("", false));
                }
                else if (newColumn.type == "TextBoxColumn" && newColumn instanceof StiTextBoxColumnItem) {
                    newColumn.cells.push(new StiTextBoxCellItem("", ""));
                }
                else if (newColumn.type == "NumberBoxColumn" && newColumn instanceof StiNumberBoxColumnItem) {
                    newColumn.cells.push(new StiNumberBoxCellItem("", 0));
                }
                else if (newColumn.type == "LabelColumn" && newColumn instanceof StiLabelColumnItem) {
                    newColumn.cells.push("");
                }
            });
            if (lastColumn) {
                this.setColumnProperty(lastColumn, newColumn);
            }
        }
    }
    setColumnProperty(lastColumn, newColumn) {
        newColumn.horizontalAlignment = Enum.parse(StiHorizontalAlignment, lastColumn.horizontalAlignment);
        newColumn.backgroundColor = lastColumn.backgroundColor.clone();
        newColumn.cellBackColor = lastColumn.cellBackColor.clone();
        newColumn.cellForeColor = lastColumn.cellForeColor.clone();
        newColumn.cellBorderColor = lastColumn.cellBorderColor.clone();
    }
    addRow() {
        this.rowLabels.push(StiLocalizationService.get("PropertyMain", ""));
        this.columns.forEach((column) => {
            if (column.type == "CheckBoxColumn" && column instanceof StiCheckBoxColumnItem) {
                column.cells.push(new StiCheckBoxCellItem("", false));
            }
            else if (column.type == "ComboBoxColumn" && column instanceof StiComboBoxColumnItem) {
                column.cells.push(new StiComboBoxCellItem("", 0));
            }
            else if (column.type == "RadioButtonColumn" && column instanceof StiRadioButtonColumnItem) {
                column.cells.push(new StiRadioButtonCellItem("", false));
            }
            else if (column.type == "TextBoxColumn" && column instanceof StiTextBoxColumnItem) {
                column.cells.push(new StiTextBoxCellItem("", ""));
            }
            else if (column.type == "NumberBoxColumn" && column instanceof StiNumberBoxColumnItem) {
                column.cells.push(new StiNumberBoxCellItem("", 0));
            }
            else if (column.type == "LabelColumn" && column instanceof StiLabelColumnItem) {
                column.cells.push("");
            }
        });
    }
    setProperty(propName, value, oldValue) {
        super.setProperty(propName, value, oldValue);
        if (propName == "thousandSeparator") {
            this.columns.forEach((column) => {
                if ((column instanceof StiNumberBoxColumnItem || column instanceof StiLabelColumnItem) &&
                    (oldValue === null || column.thousandSeparator == oldValue)) {
                    column.thousandSeparator = value;
                }
            });
            this.totalsFields.forEach((field) => {
                if (oldValue === null || oldValue == field.thousandSeparator) {
                    field.thousandSeparator = value;
                }
            });
        }
        else if (propName == "decimalDigits") {
            this.columns.forEach((column) => {
                if ((column instanceof StiNumberBoxColumnItem || column instanceof StiLabelColumnItem) &&
                    (oldValue === null || column.decimalDigits == oldValue)) {
                    column.decimalDigits = value;
                }
            });
            this.totalsFields.forEach((field) => {
                if (oldValue === null || oldValue == field.decimalDigits) {
                    field.decimalDigits = value;
                }
            });
        }
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.font.family, this.arrayOfStylesToString(this.font.style), this.font.size);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    propertyChanged(propName) {
        this.fitTable();
    }
    get columns() {
        return this._columns;
    }
    get eValue() {
        return this.tableHeaderText;
    }
    set eValue(value) {
        this.tableHeaderText = value;
    }
    get eFont() {
        return this.font;
    }
    set eFont(value) {
        this.font = value;
    }
    get eColor() {
        return this.tableHeaderColor;
    }
    set eColor(value) {
        this.tableHeaderColor = value;
    }
    get eBackgroundColor() {
        return this.tableHeaderBackgroundColor;
    }
    set eBackgroundColor(value) {
        this.tableHeaderBackgroundColor = value;
    }
    haveBackgoundColor() {
        return true;
    }
    get eContentAlignment() {
        return this.tableHeaderAlignment;
    }
    set eContentAlignment(value) {
        this.tableHeaderAlignment = value;
    }
    haveContentAlignment() {
        return true;
    }
    haveVerticalAlignment() {
        return false;
    }
    htmlStyle() {
        return `${this.eFont.htmlStyle()};color:${this.eColor.toHtmlColor()};`;
    }
    updateRowLabelsContentEditable() {
        this.rowLabelsContentEditable = [];
        this.rowLabels.forEach((l, index) => this.rowLabelsContentEditable.push(new StiRowLabel(l, this, index)));
    }
    set width(value) {
        let needToFit = this.geometry.width != value;
        this.geometry.width = value;
        if (needToFit) {
            this.fitTable();
        }
    }
    get width() {
        return this.geometry.width;
    }
    saveToJsonObject(options) {
        var _a, _b, _c;
        this.tableHeaderHeight = (_b = (_a = this.element) === null || _a === void 0 ? void 0 : _a.nativeElement) === null || _b === void 0 ? void 0 : _b.offsetHeight;
        (_c = this.columns) === null || _c === void 0 ? void 0 : _c.forEach((column) => {
            if (column["cells"] && column["cells"].length != this.rowLabels.length) {
                column["cells"].splice(this.rowLabels.length, column["cells"].length);
            }
        });
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        jObject.addPropertyJObject("Border", this.border.saveToJsonObject(options));
        jObject.addPropertyJObject("GridLines", this.gridLines.saveToJsonObject(options));
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyBool("AlternateRowColors", this.alternateRowColors);
        jObject.addPropertyColor("EvenRowsStyle", this.evenRowsStyle);
        jObject.addPropertyColor("EvenRowsTextColor", this.evenRowsTextColor);
        jObject.addPropertyColor("OddRowsStyle", this.oddRowsStyle);
        jObject.addPropertyColor("OddRowsTextColor", this.oddRowsTextColor);
        jObject.addPropertyNumber("TableHeaderHeight", this.tableHeaderHeight);
        jObject.addPropertyString("TableHeaderText", this.tableHeaderText);
        jObject.addPropertyEnum("TableHeaderAlignment", StiHorizontalAlignment, this.tableHeaderAlignment);
        jObject.addPropertyColor("TableHeaderColor", this.tableHeaderColor);
        jObject.addPropertyColor("TableHeaderBackgroundColor", this.tableHeaderBackgroundColor);
        jObject.addPropertyBool("ShowRowLabels", this.showRowLabels);
        jObject.addPropertyArray("RowLabels", this.rowLabels);
        jObject.addPropertyEnum("RowLabelsHorizontalAlignment", StiHorizontalAlignment, this.rowLabelsHorizontalAlignment);
        jObject.addPropertyColor("RowHeadersBackground", this.rowHeadersBackground);
        jObject.addPropertyColor("RowHeadersColor", this.rowHeadersColor);
        jObject.addPropertyJObject("RowHeadersBorder", this.rowHeadersBorder.saveToJsonObject(options));
        jObject.addPropertyJObject("ColumnHeadersBorder", this.columnHeadersBorder.saveToJsonObject(options));
        jObject.addPropertyArray("Columns", this.columns);
        jObject.addPropertyBool("UseTotals", this.useTotals);
        // jObject.addPropertyBool("DynamicRows", this.dynamicRows);
        jObject.addPropertyBool("UseWordWrap", this.useWordWrap);
        jObject.addPropertyString("TotalsRowHeader", this.totalsRowHeader);
        jObject.addPropertyNumber("RowLabelsWidth", this.rowLabelsWidth);
        jObject.addPropertyEnum("TotalsRowHeaderHorizontalAlignment", StiHorizontalAlignment, this.totalsRowHeaderHorizontalAlignment);
        jObject.addPropertyEnum("TotalsRowHeaderVerticalAlignment", StiVerticalAlignment, this.totalsRowHeaderVerticalAlignment);
        jObject.addPropertyColor("TotalsRowHeaderColor", this.totalsRowHeaderColor);
        jObject.addPropertyNumber("TotalsValuesWidth", this.totalsValuesWidth);
        jObject.addPropertyNumber("TotalsHeadersWidth", this.totalsHeadersWidth);
        jObject.addPropertyArray("TotalsFields", this.totalsFields);
        return jObject;
    }
    loadFromJsonObject(json) {
        this.stopFit = true;
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "Font":
                    this.font = new Font();
                    this.font.loadFromJsonObject(property.value);
                    break;
                case "Border":
                    this.border = new StiBorder();
                    this.border.loadFromJsonObject(property.value);
                    break;
                case "GridLines":
                    this.gridLines = new StiInnerBorder();
                    this.gridLines.loadFromJsonObject(property.value);
                    break;
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "AlternateRowColors":
                    this.alternateRowColors = property.value;
                    break;
                case "EvenRowsStyle":
                    this.evenRowsStyle = new Color();
                    this.evenRowsStyle.deserializeFromString(property.value);
                    break;
                case "EvenRowsTextColor":
                    this.evenRowsTextColor = new Color();
                    this.evenRowsTextColor.deserializeFromString(property.value);
                    break;
                case "OddRowsStyle":
                    this.oddRowsStyle = new Color();
                    this.oddRowsStyle.deserializeFromString(property.value);
                    break;
                case "OddRowsTextColor":
                    this.oddRowsTextColor = new Color();
                    this.oddRowsTextColor.deserializeFromString(property.value);
                    break;
                case "TableHeaderText":
                    this.tableHeaderText = property.value;
                    break;
                case "TableHeaderAlignment":
                    this.tableHeaderAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "TableHeaderColor":
                    this.tableHeaderColor = new Color();
                    this.tableHeaderColor.deserializeFromString(property.value);
                    break;
                case "TableHeaderBackgroundColor":
                    this.tableHeaderBackgroundColor = new Color();
                    this.tableHeaderBackgroundColor.deserializeFromString(property.value);
                    break;
                case "ShowRowLabels":
                    this.showRowLabels = property.value;
                    break;
                /* case "DynamicRows":
                  this.dynamicRows = property.value;
                  break; */
                case "RowLabels":
                    this.rowLabels = [];
                    property.value.properties().forEach((p) => this.rowLabels.push(p.value));
                    break;
                case "RowLabelsHorizontalAlignment":
                    this.rowLabelsHorizontalAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "RowLabelsWidth":
                    this.rowLabelsWidth = property.value;
                    break;
                case "RowHeadersBackground":
                    this.rowHeadersBackground = new Color();
                    this.rowHeadersBackground.deserializeFromString(property.value);
                    break;
                case "RowHeadersColor":
                    this.rowHeadersColor = new Color();
                    this.rowHeadersColor.deserializeFromString(property.value);
                    break;
                case "RowHeadersBorder":
                    this.rowHeadersBorder = new StiBorder();
                    this.rowHeadersBorder.loadFromJsonObject(property.value);
                    break;
                case "ColumnHeadersBorder":
                    this.columnHeadersBorder = new StiBorder();
                    this.columnHeadersBorder.loadFromJsonObject(property.value);
                    break;
                case "Columns":
                case "ColumnCollection":
                    this.columns = [];
                    for (let colJson of property.value.value) {
                        let column;
                        let type = colJson.properties().find((p) => p.name == "Type").value;
                        switch (type) {
                            case "NumberBoxColumn":
                                column = new StiNumberBoxColumnItem();
                                column.eParent = this;
                                break;
                            case "CheckBoxColumn":
                                column = new StiCheckBoxColumnItem();
                                column.eParent = this;
                                break;
                            case "ComboBoxColumn":
                                column = new StiComboBoxColumnItem();
                                column.eParent = this;
                                break;
                            case "RadioButtonColumn":
                                column = new StiRadioButtonColumnItem();
                                column.eParent = this;
                                break;
                            case "TextBoxColumn":
                                column = new StiTextBoxColumnItem();
                                column.eParent = this;
                                break;
                            case "LabelColumn":
                                column = new StiLabelColumnItem();
                                column.eParent = this;
                                break;
                        }
                        column.loadFromJsonObject(colJson);
                        this.columns.push(column);
                    }
                    break;
                case "UseTotals":
                    this.useTotals = property.value;
                    break;
                case "UseWordWrap":
                    this.useWordWrap = property.value;
                    break;
                case "TotalsRowHeader":
                    this.totalsRowHeader = property.value;
                    break;
                case "TotalsRowHeaderHorizontalAlignment":
                    this.totalsRowHeaderHorizontalAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "TotalsRowHeaderVerticalAlignment":
                    this.totalsRowHeaderVerticalAlignment = Enum.parse(StiVerticalAlignment, property.value);
                    break;
                case "TotalsRowHeaderColor":
                    this.totalsRowHeaderColor = new Color();
                    this.totalsRowHeaderColor.deserializeFromString(property.value);
                    break;
                case "TotalsValuesWidth":
                    this.totalsValuesWidth = property.value;
                    break;
                case "TotalsHeadersWidth":
                    this.totalsHeadersWidth = property.value;
                    break;
                case "TotalsFields":
                    this.totalsFields = [];
                    for (let totalJson of property.value.value) {
                        let total = new StiTotalsFieldItem();
                        total.loadFromJsonObject(totalJson);
                        this.totalsFields.push(total);
                    }
                    break;
            }
        }
        this.stopFit = false;
        this.fitTable();
    }
}

class StiTextBoxElement extends StiFormElement {
    constructor() {
        super();
        this._linesCount = 1;
        this._maximum = 255;
        this.type = "Text_BoxElement";
        this.tooltip = "";
        this.required = false;
        this.description = new StiTextItem();
        this.font = new Font("Segoe UI", 10);
        this.text = "";
        this.backgroundColor = Color.white();
        this.textColor = Color.black();
        this.borderColor = Color.lightGray();
        this.contentAlignment = StiHorizontalAlignment.Left;
        this.isMultiline = false;
        this.password = "";
        this.isPassword = false;
        this.useRange = false;
        this.minimum = 0;
        this.rangeFormat = StiTextRangeFormat.Characters;
        this.borderWeight = StiLineWeight.Thin;
        this.geometry = new StiRectangleGeometry(150, 40);
        this.label = new StiLabelItem(this, StiLocalizationService.get("Dialogs", "StiTextBoxControl"));
    }
    setDefaultValues() {
        this.value = "";
    }
    setTabIndex(value) {
        this.tabIndex = value++;
        return value;
    }
    getDefaultEditableContent() {
        let textItem = new StiInputTextItem(this.text, this.font, this.textColor, this.backgroundColor, this.contentAlignment);
        textItem.element = this;
        return textItem;
    }
    get maximum() {
        return this._maximum;
    }
    set maximum(value) {
        this._maximum = Math.max(1, value);
    }
    get linesCount() {
        return this._linesCount;
    }
    set linesCount(value) {
        if (value <= 1) {
            this._linesCount = 1;
        }
        else if (value >= 10) {
            this._linesCount = 10;
        }
        else {
            this._linesCount = value;
        }
    }
    get value() {
        return this.text;
    }
    set value(value) {
        this.text = value;
    }
    get eValue() {
        return this.value;
    }
    set eValue(value) {
        this.value = value;
    }
    get eFont() {
        return this.font;
    }
    set eFont(value) {
        this.font = value;
    }
    get eColor() {
        return this.textColor;
    }
    set eColor(value) {
        this.textColor = value;
    }
    get eBackgroundColor() {
        return this.backgroundColor;
    }
    set eBackgroundColor(value) {
        this.backgroundColor = value;
    }
    get eContentAlignment() {
        return this.contentAlignment;
    }
    set eContentAlignment(value) {
        this.contentAlignment = value;
    }
    haveContentAlignment() {
        return true;
    }
    haveVerticalAlignment() {
        return false;
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.font.family, this.arrayOfStylesToString(this.font.style), this.font.size);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    haveBackgoundColor() {
        return true;
    }
    htmlStyle() {
        return `${this.font.htmlStyle()};color:${this.eColor.toHtmlColor()};text-align:${Enum.getName(StiHorizontalAlignment, this.contentAlignment)}`;
    }
    saveToJsonObject(options) {
        var _a, _b;
        if ((_a = this.element) === null || _a === void 0 ? void 0 : _a.nativeElement) {
            this.heightForExport = this.element.nativeElement.offsetHeight;
        }
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyJObject("Font", this.font.saveToJsonObject(options));
        jObject.addPropertyString("Text", this.text);
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyColor("TextColor", this.textColor);
        jObject.addPropertyEnum("ContentAlignment", StiHorizontalAlignment, this.contentAlignment);
        jObject.addPropertyString("Tooltip", this.tooltip);
        jObject.addPropertyBool("Required", this.required);
        jObject.addPropertyBool("IsPassword", this.isPassword);
        jObject.addPropertyBool("IsMultiline", this.isMultiline);
        jObject.addPropertyNumber("LinesCount", this.linesCount);
        jObject.addPropertyBool("UseRange", this.useRange);
        jObject.addPropertyNumber("Minimum", this.minimum);
        jObject.addPropertyNumber("Maximum", this.maximum);
        jObject.addPropertyEnum("RangeFormat", StiTextRangeFormat, this.rangeFormat);
        jObject.addPropertyColor("BorderColor", this.borderColor);
        jObject.addPropertyEnum("BorderWeight", StiLineWeight, this.borderWeight);
        if ((_b = this.element) === null || _b === void 0 ? void 0 : _b.nativeElement) {
            jObject.addPropertyNumber("HeightForExport", this.heightForExport);
        }
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "ContentAlignment":
                    this.contentAlignment = Enum.parse(StiHorizontalAlignment, property.value);
                    break;
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "TextColor":
                    this.textColor = new Color();
                    this.textColor.deserializeFromString(property.value);
                    break;
                case "Text":
                    this.text = property.value;
                    break;
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Font":
                    this.font = new Font();
                    this.font.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "Tooltip":
                    this.tooltip = property.value;
                    break;
                case "Required":
                    this.required = property.value;
                    break;
                case "IsPassword":
                    this.isPassword = property.value;
                    break;
                case "IsMultiline":
                    this.isMultiline = property.value;
                    break;
                case "LinesCount":
                    this.linesCount = property.value;
                    break;
                case "UseRange":
                    this.useRange = property.value;
                    break;
                case "Minimum":
                    this.minimum = property.value;
                    break;
                case "Maximum":
                    this.maximum = property.value;
                    break;
                case "RangeFormat":
                    this.rangeFormat = Enum.parse(StiTextRangeFormat, property.value);
                    break;
                case "BorderColor":
                    this.borderColor = new Color();
                    this.borderColor.deserializeFromString(property.value);
                    break;
                case "BorderWeight":
                    this.borderWeight = Enum.parse(StiLineWeight, property.value);
                    break;
            }
        }
    }
}

class StiTextElement extends StiFormElement {
    constructor() {
        super();
        this.type = "TextElement";
        this.htmlTextString = "";
        this.textColor = Color.black();
        this.textHorizontalAlignment = StiTextHorAlignment.Left;
        this.border = new StiBorder(StiPen.dimGraySolid(), false, false, false, false);
        this.showBorderEditor = true;
        this.geometry = new StiRectangleGeometry(100, 35);
    }
    saveToJsonObject(options) {
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyString("HtmlTextString", this.htmlTextString);
        jObject.addPropertyEnum("TextHorizontalAlignment", StiTextHorAlignment, this.textHorizontalAlignment);
        jObject.addPropertyJObject("Border", this.border.saveToJsonObject(options));
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "HtmlTextString":
                    this.htmlTextString = property.value;
                    break;
                case "TextHorizontalAlignment":
                    this.textHorizontalAlignment = Enum.parse(StiTextHorAlignment, property.value);
                    break;
                case "Border":
                    this.border = new StiBorder();
                    this.border.loadFromJsonObject(property.value);
                    break;
            }
        }
        this.isAdded = true;
    }
    htmlStyle() {
        return `color:${this.textColor.toHtmlColor()};text-align:${Enum.getName(StiHorizontalAlignment, this.textHorizontalAlignment)}`;
    }
}

class StiPanelElement extends StiFormElement {
    constructor() {
        super();
        this.type = "PanelElement";
        this.description = new StiTextItem();
        this.Width = 0; //TODO
        this.Height = 0; //TODO
        this.backgroundColor = Color.transparent();
        this.border = new StiBorder(StiPen.dimGraySolid(), true, true, true, true);
        this.showBorderEditor = true;
        this.elements = new Array();
        this.geometry = new StiRectangleGeometry(150, 120);
        this.label = new StiLabelItem(this, "");
        this.padding = new StiPadding(0, 0, 0, 0, this);
        this.label.alignment = StiLabelAlignment.Top;
        this.geometry.minWidth = 150;
        this.geometry.minHeight = 90;
    }
    canUpdateProperty(propName) {
        return !(propName.indexOf("padding") >= 0 || propName == "label.alignment");
    }
    get contentAreaWidth() {
        if (this.label.alignment != StiLabelAlignment.Top) {
            return this.width - (this.label.value.length > 0 ? this.label.width : 0) - this.padding.right - this.padding.left;
        }
        else {
            return this.width - this.padding.right - this.padding.left;
        }
    }
    get contentAreaHeight() {
        var _a;
        if (this.label.alignment != StiLabelAlignment.Top) {
            return this.height - this.padding.top - this.padding.bottom;
        }
        else {
            if ((_a = this.element) === null || _a === void 0 ? void 0 : _a.nativeElement) {
                if (this.element.nativeElement.offsetHeight > 0) {
                    return this.element.nativeElement.offsetHeight + this.padding.bottom;
                }
            }
            else {
                return this.height - this.padding.top - this.padding.bottom - 35;
            }
        }
    }
    getColumnWidth(columnsCount) {
        return Number((this.contentAreaWidth / columnsCount).toFixed(2));
    }
    getUsedFonts(usedFonts) {
        super.getUsedFonts(usedFonts);
        usedFonts.add(this.description.font.family, this.arrayOfStylesToString(this.description.font.style), this.description.font.size);
    }
    get allElements() {
        let elements = [];
        this.getAllElements(elements);
        return elements;
    }
    getAllElements(elements) {
        this.elements.forEach((element) => {
            if (element instanceof StiPanelElement) {
                element.getAllElements(elements);
            }
            elements.push(element);
        });
    }
    saveToJsonObject(options) {
        var _a;
        if ((_a = this.element) === null || _a === void 0 ? void 0 : _a.nativeElement) {
            if (this.label.alignment != StiLabelAlignment.Top) {
                this.Width = this.width - (this.label.value.length > 0 ? this.label.width + this.padding.left : 0);
                this.Height = this.height;
            }
            else {
                this.Width = this.width;
                if (this.element.nativeElement.offsetHeight > 0) {
                    this.Height = this.element.nativeElement.offsetHeight + this.padding.bottom;
                }
            }
        }
        let jObject = super.saveToJsonObject(options);
        jObject.addPropertyJObject("Label", this.label.saveToJsonObject(options));
        jObject.addPropertyJObject("Description", this.description.saveToJsonObject(options));
        jObject.addPropertyNumber("Width", this.Width);
        jObject.addPropertyNumber("Height", this.Height);
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyArray("Elements", this.elements);
        jObject.addPropertyJObject("Border", this.border.saveToJsonObject(options));
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Label":
                    this.label = new StiLabelItem(this);
                    this.label.loadFromJsonObject(property.value);
                    break;
                case "Description":
                    this.description = new StiTextItem();
                    this.description.loadFromJsonObject(property.value);
                    break;
                case "Width":
                    this.Width = property.value;
                    break;
                case "Height":
                    this.Height = property.value;
                    break;
                case "BackgroundColor":
                    this.backgroundColor = new Color();
                    this.backgroundColor.deserializeFromString(property.value);
                    break;
                case "Elements":
                    this.elements = this.deserializeCollection(property.value);
                    break;
                case "Border":
                    this.border = new StiBorder();
                    this.border.loadFromJsonObject(property.value);
                    break;
            }
        }
    }
    createElementClass(type) {
        type = type.toLowerCase();
        if (type == "textelement" || type == "textelement") {
            return new StiTextElement();
        }
        else if (type == "text_boxelement" || type == "textboxelement") {
            return new StiTextBoxElement();
        }
        else if (type == "tableelement" || type == "tableelement") {
            return new StiTableElement();
        }
        else if (type == "single_selectionelement" || type == "singleselectionelement") {
            return new StiSingleSelectionElement();
        }
        else if (type == "signatureelement" || type == "signatureelement") {
            return new StiSignatureElement();
        }
        else if (type == "pdfsignatureelement" || type == "pdfsignatureelement") {
            return new StiPDFSignatureElement();
        }
        else if (type == "panelelement" || type == "panelelement") {
            return new StiPanelElement();
        }
        else if (type == "number_boxelement" || type == "numberboxelement") {
            return new StiNumberBoxElement();
        }
        else if (type == "multiple_selectionelement" || type == "multipleselectionelement") {
            return new StiMultipleSelectionElement();
        }
        else if (type == "list_boxelement" || type == "listboxelement") {
            return new StiListBoxElement();
        }
        else if (type == "lineelement" || type == "lineelement") {
            return new StiLineElement();
        }
        else if (type == "labelelement" || type == "labelelement") {
            return new StiLabelElement();
        }
        else if (type == "imageelement" || type == "imageelement") {
            return new StiImageElement();
        }
        else if (type == "datetime_boxelement" || type == "datetimeboxelement") {
            return new StiDateTimeBoxElement();
        }
        else if (type == "combo_boxelement" || type == "comboboxelement") {
            return new StiComboBoxElement();
        }
        else if (type == "check_boxelement" || type == "checkboxelement") {
            return new StiCheckBoxElement();
        }
        else if (type == "buttonelement" || type == "buttonelement") {
            return new StiButtonElement();
        }
        else if (type == "barcodeelement" || type == "barcodeelement") {
            return new StiBarcodeElement();
        }
        else if (type == "addresselement" || type == "addresselement") {
            return new StiAddressElement();
        }
    }
}

class StiFormPageElement extends StiFormObject {
    constructor() {
        super();
        this.type = "StiPageElement";
        this.elements = new Array();
        this.visible = true;
        this.padding = new StiPadding(39, 39, 39, 39);
        this.paperKind = StiPagePaperKind.fromStandardPaperKind(PaperKind.A4);
        this.backgroundColor = Color.white();
    }
    get width() {
        return this.paperKind.width;
    }
    get height() {
        return this.paperKind.height;
    }
    set width(value) {
        this.paperKind.width = Number(value);
    }
    set height(value) {
        this.paperKind.height = Number(value);
    }
    get contentAreaWidth() {
        let padding = this.padding;
        return this.width - padding.left - padding.right;
    }
    get contentAreaHeight() {
        let padding = this.padding;
        return this.height - padding.top - padding.bottom;
    }
    get allElements() {
        let elements = [];
        this.elements.forEach((element) => {
            if (element instanceof StiPanelElement) {
                element.getAllElements(elements);
            }
            elements.push(element);
        });
        return elements;
    }
    getColumnWidth(columnsCount) {
        return Number((this.contentAreaWidth / columnsCount).toFixed(2));
    }
    saveToJsonObject(options) {
        var _a;
        let jObject = super.saveToJsonObject(options);
        jObject.removeProperty(StiFormObject.TYPE_PROPERTY_NAME);
        jObject.addPropertyJObject("Margins", this.padding.saveToJsonObject(options));
        jObject.addPropertyJObject("PaperKind", this.paperKind.saveToJsonObject(options));
        jObject.addPropertyColor("BackgroundColor", this.backgroundColor);
        jObject.addPropertyBool("Visible", this.visible);
        if (!(options && options["notSerializeImages"])) {
            jObject.addPropertyString("BackgroundImage", (_a = this.backgroundImage) === null || _a === void 0 ? void 0 : _a.substring(this.backgroundImage.indexOf(",") + 1));
        }
        jObject.addPropertyArray("Elements", this.elements);
        return jObject;
    }
    loadFromJsonObject(json) {
        super.loadFromJsonObject(json);
        for (let property of json.properties()) {
            switch (property.name) {
                case "Visible":
                    this.visible = property.value;
                    break;
                case "Margins":
                    this.padding.loadFromJsonObject(property.value);
                    break;
                case "PaperKind":
                    this.paperKind.loadFromJsonObject(property.value);
                    break;
                case "BackgroundColor":
                    this.backgroundColor.deserializeFromString(property.value);
                    this.backgroundColor.a = 255;
                    break;
                case "BackgroundImage":
                    if (property.value) {
                        this.backgroundImage = "data:image/png;base64," + property.value;
                    }
                    break;
                case "Elements":
                    this.elements = this.deserializeCollection(property.value);
                    break;
            }
        }
    }
    createElementClass(type) {
        type = type.toLowerCase();
        if (type == "textelement" || type == "textelement") {
            return new StiTextElement();
        }
        else if (type == "text_boxelement" || type == "textboxelement") {
            return new StiTextBoxElement();
        }
        else if (type == "tableelement" || type == "tableelement") {
            return new StiTableElement();
        }
        else if (type == "single_selectionelement" || type == "singleselectionelement") {
            return new StiSingleSelectionElement();
        }
        else if (type == "signatureelement" || type == "signatureelement") {
            return new StiSignatureElement();
        }
        else if (type == "pdfsignatureelement" || type == "pdfsignatureelement") {
            return new StiPDFSignatureElement();
        }
        else if (type == "panelelement" || type == "panelelement") {
            return new StiPanelElement();
        }
        else if (type == "number_boxelement" || type == "numberboxelement") {
            return new StiNumberBoxElement();
        }
        else if (type == "multiple_selectionelement" || type == "multipleselectionelement") {
            return new StiMultipleSelectionElement();
        }
        else if (type == "list_boxelement" || type == "listboxelement") {
            return new StiListBoxElement();
        }
        else if (type == "lineelement" || type == "lineelement") {
            return new StiLineElement();
        }
        else if (type == "labelelement" || type == "labelelement") {
            return new StiLabelElement();
        }
        else if (type == "imageelement" || type == "imageelement") {
            return new StiImageElement();
        }
        else if (type == "datetime_boxelement" || type == "datetimeboxelement") {
            return new StiDateTimeBoxElement();
        }
        else if (type == "combo_boxelement" || type == "comboboxelement") {
            return new StiComboBoxElement();
        }
        else if (type == "check_boxelement" || type == "checkboxelement") {
            return new StiCheckBoxElement();
        }
        else if (type == "buttonelement" || type == "buttonelement") {
            return new StiButtonElement();
        }
        else if (type == "barcodeelement" || type == "barcodeelement") {
            return new StiBarcodeElement();
        }
        else if (type == "addresselement" || type == "addresselement") {
            return new StiAddressElement();
        }
    }
}
StiFormPageElement.PAGE_ELEMENTS = [
    StiBarcodeElement,
    StiButtonElement,
    StiCheckBoxElement,
    StiComboBoxElement,
    StiDateTimeBoxElement,
    StiImageElement,
    StiLabelElement,
    StiLineElement,
    StiListBoxElement,
    StiMultipleSelectionElement,
    StiSignatureElement,
    StiPDFSignatureElement,
    StiSingleSelectionElement,
    StiTableElement,
    StiTextBoxElement,
    StiTextElement,
    StiNumberBoxElement,
    StiPanelElement,
    StiAddressElement,
];

class StiAdditionalField {
    constructor() { }
    saveToJsonObject(options) {
        let json = new StiJson();
        json.addPropertyString("Key", this.key);
        json.addPropertyString("Value", this.value);
        return json;
    }
    loadFromJsonObject(json) {
        for (let property of json.properties()) {
            switch (property.name) {
                case "Key":
                    this.key = property.value;
                    break;
                case "Value":
                    this.value = property.value;
                    break;
            }
        }
    }
}

class StiForm {
    constructor() {
        this.pages = [];
        this.formEvents = new Subject();
        this._guid = Guid.newGuid().toString();
        this._settings = new StiFormSettings(this);
        this._reportVersion = "";
        this._reportName = "";
        this._reportGuid = "";
        this._reportAlias = "";
        this._reportCreated = "";
        this._reportChanged = "";
        this._reportImage = "";
        this._versionKey = "";
        this._userId = "";
        this._formName = "Form";
        this._additionalFormFields = new Array();
        this.pages.push(new StiFormPageElement());
        this.reportCreated = StiStaticHelperService.dateToJsonDate(new Date());
    }
    get guid() {
        return this._guid;
    }
    get settings() {
        return this._settings;
    }
    set settings(value) {
        this._settings = value;
    }
    addField(name, value) {
        let field = new StiAdditionalField();
        field.key = name;
        field.value = value;
        this._additionalFormFields.push(field);
    }
    clearAdditionalFields() {
        this._additionalFormFields = [];
    }
    get additionalFormFields() {
        return this._additionalFormFields;
    }
    get allElements() {
        let elements = [];
        this.pages.forEach((page) => {
            elements.push(page.allElements);
        });
        elements = elements.reduce((a, b) => a.concat(b), []);
        return elements;
    }
    get formName() {
        return this._formName;
    }
    set formName(value) {
        this._formName = value;
    }
    get reportVersion() {
        return this._reportVersion;
    }
    set reportVersion(value) {
        this._reportVersion = value;
    }
    get reportName() {
        return this._reportName;
    }
    set reportName(value) {
        this._reportName = value;
    }
    get reportGuid() {
        return this._reportGuid;
    }
    set reportGuid(value) {
        this._reportGuid = value;
    }
    get reportAlias() {
        return this._reportAlias;
    }
    set reportAlias(value) {
        this._reportAlias = value;
    }
    get reportCreated() {
        return this._reportCreated;
    }
    set reportCreated(value) {
        this._reportCreated = value;
    }
    get reportChanged() {
        return this._reportChanged;
    }
    set reportChanged(value) {
        this._reportChanged = value;
    }
    get reportImage() {
        return this._reportImage;
    }
    set reportImage(value) {
        this._reportImage = value;
    }
    get versionKey() {
        return this._versionKey;
    }
    set versionKey(value) {
        this._versionKey = value;
    }
    get userId() {
        return this._userId;
    }
    set userId(value) {
        this._userId = value;
    }
    createTestValues() {
        let jObject = new StiJson();
        jObject.addPropertyString("TextBox", "Hello");
        jObject.addPropertyNumberNotNull("NumberBox", 1);
        jObject.addPropertyBool("Table.Cell-0-0", false);
        jObject.addPropertyBool("Table.Cell-0-1", true);
        return jObject;
    }
    setFormValues(json) {
        let element;
        for (let property of json.properties()) {
            element = { name: property.name, value: property.value };
            this.fillElement(element);
        }
    }
    fillElement(element) {
        let elem;
        let name;
        let isTable = false;
        if (element.name.indexOf(".") != -1) {
            name = element.name.slice(0, element.name.indexOf("."));
            isTable = true;
        }
        else {
            name = element.name;
        }
        this.pages.forEach((page) => {
            elem = page.allElements.find((elem) => elem.name == name);
        });
        if (elem) {
            if (isTable) {
                let cell = element.name.slice(element.name.indexOf(".") + 1, element.name.length);
                this.setTableValue(elem, cell, element.value);
            }
            else {
                this.setValue(elem, element.value);
            }
        }
    }
    setValue(element, value) {
        if (element instanceof StiTextBoxElement) {
            element.text = value;
        }
        else if (element instanceof StiNumberBoxElement) {
            element.value = value;
        }
        else if (element instanceof StiComboBoxElement) {
            element.selectedOption = value;
        }
        else if (element instanceof StiListBoxElement) {
            element.selectedOptions = value;
        }
        else if (element instanceof StiSingleSelectionElement) {
            element.selectedOption = value;
        }
        else if (element instanceof StiMultipleSelectionElement) {
            element.selectedOptions = value;
        }
        else if (element instanceof StiCheckBoxElement) {
            element.isChecked = value;
        } /* else if (element instanceof StiSignatureElement) {
          return { name: element.name ?? element.guid, value: element.contentImage };
        }  */
        else if (element instanceof StiDateTimeBoxElement) {
            element.dateValue = value;
        }
        else if (element instanceof StiImageElement) {
            element.image = value;
        }
        else if (element instanceof StiBarcodeElement) {
            element.img = value;
        }
        else if (element instanceof StiLabelElement) {
            element.text.value = value;
        }
    }
    setTableValue(element, cellPath, value) {
        let column = cellPath.split("-")[1];
        let cell = cellPath.split("-")[2];
        let tableColumn = element.columns[column];
        if (tableColumn instanceof StiTextBoxColumnItem) {
            tableColumn.cells[cell].text = value;
        }
        else if (tableColumn instanceof StiNumberBoxColumnItem) {
            tableColumn.cells[cell].value = value;
        }
        else if (tableColumn instanceof StiComboBoxColumnItem) {
            tableColumn.cells[cell].selectedIndex = value;
        }
        else if (tableColumn instanceof StiCheckBoxColumnItem) {
            tableColumn.cells[cell].isChecked = value;
        }
        else if (tableColumn instanceof StiLabelColumnItem) {
            tableColumn.cells[cell] = value;
        }
        else if (tableColumn instanceof StiRadioButtonColumnItem) {
            tableColumn.cells[cell].isChecked = value;
        }
    }
    getElementByName(elementName) {
        let finded;
        this.pages.forEach((page) => {
            if (!finded) {
                finded = page.allElements.find((e) => e.name == elementName);
            }
        });
        return finded;
    }
    saveToJsonObject(options = {}) {
        let rootJsonObject = new StiJson("", null, false, options);
        rootJsonObject.addPropertyArray("Pages", this.pages);
        rootJsonObject.addPropertyJObject("Settings", this.settings.saveToJsonObject(options));
        rootJsonObject.addPropertyString("Guid", this.guid);
        rootJsonObject.addPropertyString("FormName", this.formName);
        rootJsonObject.addPropertyString("VersionKey", this.versionKey);
        rootJsonObject.addPropertyString("UserId", this.userId);
        rootJsonObject.addPropertyArray("AdditionalFields", this.additionalFormFields);
        return rootJsonObject;
    }
    saveToReportJsonObject(options = {}) {
        let formJson = this.saveToJsonObject(options);
        let root = new StiJson();
        let pages = new StiJson();
        let formContainer = new StiJson();
        formContainer.addPropertyString("Ident", "StiFormContainer");
        formContainer.addPropertyJObject("Content", formJson);
        pages.addPropertyJObject("0", formContainer);
        root.addPropertyString("ReportVersion", this.reportVersion);
        root.addPropertyString("ReportGuid", this.reportGuid);
        root.addPropertyString("ReportName", this.reportName);
        root.addPropertyString("ReportAlias", this.reportAlias);
        root.addPropertyString("ReportCreated", this.reportCreated);
        root.addPropertyString("ReportChanged", this.reportChanged);
        root.addPropertyString("ReportImage", this.reportImage);
        root.addPropertyJObject("Pages", pages);
        return root;
    }
    loadFormJsonString(text) {
        let jObject = new StiJson();
        jObject.deserialize(text);
        this.loadFromJson(jObject);
    }
    loadFromJson(jObject) {
        var key;
        for (let property of jObject.properties()) {
            if (property.name == "ReportVersion") {
                this.reportVersion = property.value;
            }
            else if (property.name == "ReportGuid") {
                this.reportGuid = property.value;
            }
            else if (property.name == "ReportName") {
                this.reportName = property.value;
            }
            else if (property.name == "ReportAlias") {
                this.reportAlias = property.value;
            }
            else if (property.name == "ReportCreated") {
                this.reportCreated = property.value;
            }
            else if (property.name == "ReportChanged") {
                this.reportChanged = property.value;
            }
            else if (property.name == "ReportImage") {
                this.reportImage = property.value;
            }
            else if (property.name == "Script" && property.value && property.value.length < 40) {
                key = property.value;
            }
        }
        try {
            let formContainer = jObject
                .properties()
                .find((p) => p.name == "Pages")
                .properties()[0]
                .properties();
            if (formContainer.find((p) => p.name == "Ident").value == "StiFormContainer") {
                jObject = formContainer.find((p) => p.name == "Content").value;
            }
        }
        catch (_a) { }
        for (let property of jObject.properties()) {
            if (property.name == "Pages") {
                this.pages = this.deserializePages(property.value);
            }
            else if (property.name == "Settings" || property.name == "FormSettings") {
                this._settings = new StiFormSettings(this);
                this._settings.loadFromJsonObject(property.value);
            }
            else if (property.name == "Guid") {
                this._guid = property.value;
            }
            else if (property.name == "FormName") {
                this._formName = property.value;
            }
            else if (property.name == "VersionKey") {
                this._versionKey = property.value;
            }
            else if (property.name == "UserId") {
                this._userId = property.value;
            }
            else if (property.name == "AdditionalFields") {
                this._additionalFormFields = this.deserializeFields(property.value);
            }
        }
        if (key && key.length > 0) {
            this._versionKey = key;
        }
    }
    deserializePages(jObject) {
        let result = [];
        for (let property of jObject.properties()) {
            let page = new StiFormPageElement();
            page.loadFromJsonObject(property.value);
            result.push(page);
        }
        return result;
    }
    deserializeFields(jObject) {
        let result = [];
        for (let property of jObject.properties()) {
            let field = new StiAdditionalField();
            field.loadFromJsonObject(property.value);
            result.push(field);
        }
        return result;
    }
}

class StimulsoftFormsService {
    constructor() {
        this.serviceEvents = new Subject();
        this.serviceEventsCallbacks = new Subject();
    }
    /**
     * Post custom data to controller
     * @param data to send to controller
     * @param func callback function
     * @param options to send to controller
     */
    postData(data, func, options) {
        this.serviceEvents.next({ action: "postData", data: data, func: func, options: options });
    }
    /**
     * Add Element to Form
     * @param elementType
     * Text
     * TextBox
     * Table
     * SingleSelection
     * Signature
     * Panel
     * NumberBox
     * MultipleSelection
     * ListBox
     * Line
     * Label
     * Image
     * DateTimeBox
     * CheckBox
     * ComboBox
     * Button
     * BarCode
     * Address
     */
    addElementToForm(elementType) {
        if (!(this.createElement(elementType) instanceof StiFormPageElement) &&
            !(this.createElement(elementType) instanceof StiForm)) {
            this.serviceEvents.next({
                action: "addElementToForm",
                element: this.createElement(elementType),
            });
        }
    }
    /**
     * Show form tab
     * @param tabName
     * Home
     * Insert
     * Preview
     * PdfPreview
     */
    showTab(tabName) {
        switch (tabName.toLowerCase()) {
            case "home":
                this.serviceEvents.next({ action: "showTab", tabName: "Home" });
                break;
            case "insert":
                this.serviceEvents.next({ action: "showTab", tabName: "Insert" });
                break;
            case "preview":
                this.serviceEvents.next({ action: "showTab", tabName: "Preview" });
                break;
            case "pdfpreview":
                this.serviceEvents.next({ action: "showTab", tabName: "PDFPreview" });
                break;
            default:
                this.serviceEvents.next({ action: "showTab", tabName: "Home" });
                break;
        }
    }
    // Showing form file menu
    showFileMenu() {
        this.serviceEvents.next({ action: "showFileMenu" });
    }
    // Showing form save menu
    showSaveMenu() {
        this.serviceEvents.next({ action: "showSaveMenu" });
    }
    // Download pdf file of current form
    exportToPdf(readOnly = false, pdfACompliance = false) {
        this.serviceEvents.next({ action: "exportToPdf", readOnly: readOnly, pdfACompliance: pdfACompliance });
    }
    // Return pdf bytes of current form
    getPdfBytes(readOnly = false, pdfACompliance = false) {
        this.serviceEvents.next({ action: "getPdfBytes", readOnly: readOnly, pdfACompliance: pdfACompliance });
        return this.serviceEventsCallbacks
            .pipe(first())
            .toPromise()
            .then((data) => {
            if (data.action == "pdfBytesCallback") {
                return data.value;
            }
        });
    }
    /**
     * Set form zoom
     * @param zoom
     * PageWidth
     * OnePage
     * from 10%
     * to 400%
     */
    setZoom(zoom) {
        this.serviceEvents.next({ action: "setZoom", zoom: zoom });
    }
    /**
     * Create form element
     * @param elementType
     * Text
     * TextBox
     * Table
     * SingleSelection
     * Signature
     * Panel
     * NumberBox
     * MultipleSelection
     * ListBox
     * Line
     * Label
     * Image
     * DateTimeBox
     * CheckBox
     * ComboBox
     * Button
     * BarCode
     * Address
     * Page
     * Form
     * @returns Element object
     */
    createElement(elementType) {
        return new (this.getElementClass(elementType))();
    }
    /**
     * Get class of form element
     * @param type
     * Text
     * TextBox
     * Table
     * SingleSelection
     * Signature
     * Panel
     * NumberBox
     * MultipleSelection
     * ListBox
     * Line
     * Label
     * Image
     * DateTimeBox
     * CheckBox
     * ComboBox
     * Button
     * BarCode
     * Address
     * Page
     * Form
     * @returns element Class
     */
    getElementClass(type) {
        if (type == "TextElement" || type == "Text") {
            return StiTextElement;
        }
        else if (type == "Text_BoxElement" || type == "TextBox") {
            return StiTextBoxElement;
        }
        else if (type == "TableElement" || type == "Table") {
            return StiTableElement;
        }
        else if (type == "Single_SelectionElement" || type == "SingleSelection") {
            return StiSingleSelectionElement;
        }
        else if (type == "SignatureElement" || type == "Signature") {
            return StiSignatureElement;
        }
        else if (type == "PanelElement" || type == "Panel") {
            return StiPanelElement;
        }
        else if (type == "Number_BoxElement" || type == "NumberBox") {
            return StiNumberBoxElement;
        }
        else if (type == "Multiple_SelectionElement" || type == "MultipleSelection") {
            return StiMultipleSelectionElement;
        }
        else if (type == "List_BoxElement" || type == "ListBox") {
            return StiListBoxElement;
        }
        else if (type == "LineElement" || type == "Line") {
            return StiLineElement;
        }
        else if (type == "LabelElement" || type == "Label") {
            return StiLabelElement;
        }
        else if (type == "ImageElement" || type == "Image") {
            return StiImageElement;
        }
        else if (type == "DateTime_BoxElement" || type == "DateTimeBox") {
            return StiDateTimeBoxElement;
        }
        else if (type == "Combo_BoxElement" || type == "ComboBox") {
            return StiComboBoxElement;
        }
        else if (type == "Check_BoxElement" || type == "CheckBox") {
            return StiCheckBoxElement;
        }
        else if (type == "ButtonElement" || type == "Button") {
            return StiButtonElement;
        }
        else if (type == "BarCodeElement" || type == "BarCode") {
            return StiBarcodeElement;
        }
        else if (type == "AddressElement" || type == "Address") {
            return StiAddressElement;
        }
        else if (type == "Page") {
            return StiFormPageElement;
        }
        else if (type == "Form") {
            return StiForm;
        }
        // return this.pageElement.getElementTypes()[type] ?? StiPanelElement;
    }
    base64Encode(input) {
        if (input == null)
            return "";
        // Decode from UTF-8 text
        if (typeof unescape != "undefined") {
            input = unescape(encodeURIComponent(input));
        }
        else {
            input = input.replace(/\r\n/g, "\n");
            var utftext = "";
            for (var n = 0; n < input.length; n++) {
                var c = input.charCodeAt(n);
                if (c < 128) {
                    utftext += String.fromCharCode(c);
                }
                else if (c > 127 && c < 2048) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
                else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
            }
            input = utftext;
        }
        // Encode to Base64 string
        if (typeof window.btoa != "undefined")
            return window.btoa(input);
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;
        while (i < input.length) {
            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);
            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;
            if (isNaN(chr2))
                enc3 = enc4 = 64;
            else if (isNaN(chr3))
                enc4 = 64;
            output =
                output +
                    this._keyStr.charAt(enc1) +
                    this._keyStr.charAt(enc2) +
                    this._keyStr.charAt(enc3) +
                    this._keyStr.charAt(enc4);
        }
        return output;
    }
    base64Decode(input) {
        if (input == null)
            return "";
        var output = "";
        // Decode from Base64 string
        if (typeof window.atob != "undefined") {
            output = window.atob(input);
        }
        else {
            var chr1, chr2, chr3;
            var enc1, enc2, enc3, enc4;
            var i = 0;
            input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            while (i < input.length) {
                enc1 = this._keyStr.indexOf(input.charAt(i++));
                enc2 = this._keyStr.indexOf(input.charAt(i++));
                enc3 = this._keyStr.indexOf(input.charAt(i++));
                enc4 = this._keyStr.indexOf(input.charAt(i++));
                chr1 = (enc1 << 2) | (enc2 >> 4);
                chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                chr3 = ((enc3 & 3) << 6) | enc4;
                output = output + String.fromCharCode(chr1);
                if (enc3 != 64) {
                    output = output + String.fromCharCode(chr2);
                }
                if (enc4 != 64) {
                    output = output + String.fromCharCode(chr3);
                }
            }
        }
        // Encode to UTF-8 string
        if (typeof escape != "undefined")
            return decodeURIComponent(escape(output));
        var string = "";
        var i = 0;
        var c = 0;
        var c1 = 0;
        var c2 = 0;
        var c3 = 0;
        while (i < output.length) {
            c = output.charCodeAt(i);
            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if (c > 191 && c < 224) {
                c2 = output.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = output.charCodeAt(i + 1);
                c3 = output.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }
        return string;
    }
}
StimulsoftFormsService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftFormsService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
StimulsoftFormsService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftFormsService, providedIn: "root" });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftFormsService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: "root",
                }]
        }], ctorParameters: function () { return []; } });

class StiModelService {
    constructor() {
        this._showTrialBar = false;
        this._showTrialModalWindow = false;
        this._showTrialTitle = false;
        this._canCloseTrialWindow = true;
        this.fontFamilies = [];
        this.assemblyInfo = [];
        this.currentRibbonValue = "Home";
        this.userName = "";
        this.currentPropertyGridMode = "Properties";
        this.showFormElementsList = false;
        this.sortFormElementsList = false;
        this.showComponentsTab = true;
        this.hideActiveDropdown = new Subject();
        this.showSignatureEditor = false;
        this.showDraggableModalWindow = false;
        this.hideActiveAutocompleteList = new Subject();
        this.needToSelectedComponent = new Subject();
        this.showButtonMessageWindow = false;
        this.showTieredMenu = false;
        this.showTrialTimerWindow = false;
        this.isInitialized = false;
        this.showFileMenu = false;
        this.showFileMenuNavigation = false;
        this.showContextMenu = false;
        this.showHelpWindow = false;
        this.showSaveDialog = false;
        this.showErrorWindow = false;
        this.basePlanIsTrial = false;
        this.viewerMode = false;
        this.isCloudMode = false;
        this.disableCloseButton = false;
        this.pdfPreviewMode = false;
        this.showCornerRadius = true;
        this.showAboutWindow = false;
        this.showGroupPreview = false;
        this.showToolboxSetup = false;
        this.showModalWindow = false;
        this.showProgressAfterUpdatePage = false;
        this.canDrag = true;
        this.tieredMenuX = 0;
        this.tieredMenuY = 0;
        this.currentExpressionInfo = 0; //0-none,1-label column,2-totals,3-label component.
        this.buildVersion = "";
        this.buildDate = "";
        this.errorWindowMessage = "";
        this.propertyGridWidth = 395;
        this.needToRefresh = new Subject();
        this.needToUpdateHelper = new Subject();
        this.startPdfExportEvent = new Subject();
        this.needToRefreshInnerProperties = new Subject();
        this.currentContentEditableItem = new Subject();
        this.currentTablePropertyHeader = new Subject();
        this.retryButtonRequest = new Subject();
        this.currentTableHeader = "Main";
        this.formEvents = new Subject();
        this.interfaceEvent = new Subject();
        this.isMobileViewer = new Subject();
        this.saveDialogFromNew = false;
        this.saveDialogFromOpen = false;
        this.sendedFromButton = false;
        this.attachedFiles = [];
        this.loadingFromCloud = false;
        this.showColorDialog = false;
        this.showMoreColorDialog = false;
        this.userIsAuthorized = false;
        this.userWasChecked = false;
        this.showSaveDialogFromCloud = false;
        this.hasEmptyReuiredFields = false;
        this.showExpressionEditor = false;
        this.showProgress = false;
        this.isWebView = false;
        this.currentSelectedFileOption = "Open";
        this._embeddedMode = false;
        this.embeddedEvent = function (data) { };
        this.fileName = "Form.mrt";
        this.enteredUrls = [];
        this._zoom = 1;
        this._cursor = "default";
        this._isPreviewMode = false;
    }
    get showTrialBar() {
        return this._showTrialBar;
    }
    set showTrialBar(value) {
        let lastState = this._showTrialBar;
        if (value != lastState) {
            this._showTrialBar = value;
        }
    }
    get showTrialModalWindow() {
        return this._showTrialModalWindow;
    }
    set showTrialModalWindow(value) {
        let lastState = this._showTrialModalWindow;
        if (value != lastState) {
            this._showTrialModalWindow = value;
        }
    }
    get showTrialTitle() {
        return this._showTrialTitle;
    }
    set showTrialTitle(value) {
        let lastState = this._showTrialTitle;
        if (value != lastState) {
            this._showTrialTitle = value;
        }
    }
    get canCloseTrialWindow() {
        return this._canCloseTrialWindow;
    }
    set canCloseTrialWindow(value) {
        let lastState = this._canCloseTrialWindow;
        if (value != lastState) {
            this._canCloseTrialWindow = value;
        }
    }
    toggleTieredMenu(element) {
        let elementRect = this.getPositionRelativeToForm(element);
        let menuWidth = 104;
        let menuHeight = 165;
        this.tieredMenuY =
            window.innerHeight - elementRect.bottom >= menuHeight ? elementRect.bottom : elementRect.top - menuHeight;
        this.tieredMenuX =
            window.innerWidth - elementRect.left > menuWidth ? elementRect.left : elementRect.right - menuWidth;
        this.showTieredMenu = true;
    }
    set isPreviewMode(value) {
        this._isPreviewMode = value;
        if (value) {
            this.interfaceEvent.next({ name: "SetPreviewMode", data: true });
        }
        else {
            this.interfaceEvent.next({ name: "UnsetPreviewMode" });
        }
    }
    get isPreviewMode() {
        return this._isPreviewMode;
    }
    canDelete() {
        return (window.getSelection().toString().length == 0 &&
            document.activeElement.tagName.toLocaleLowerCase() == "body" &&
            !this.draggingElement &&
            !this.showSignatureEditor);
    }
    get showSaveToPdfButton() {
        var _a, _b;
        return (_b = (_a = this.settings) === null || _a === void 0 ? void 0 : _a.showSaveToPdfButton) !== null && _b !== void 0 ? _b : true;
    }
    get showEditButton() {
        var _a, _b;
        return (_b = (_a = this.settings) === null || _a === void 0 ? void 0 : _a.showEditButton) !== null && _b !== void 0 ? _b : false;
    }
    set embeddedMode(value) {
        this._embeddedMode = value;
    }
    get embeddedMode() {
        var _a;
        return this._embeddedMode || ((_a = this.properties) === null || _a === void 0 ? void 0 : _a.embeddedMode) === true;
    }
    get cursor() {
        return this._cursor;
    }
    get zoom() {
        return this._zoom;
    }
    set requestUrl(value) {
        this._requestUrl = value;
        this.isWebView = value == "WebView";
    }
    get requestUrl() {
        return this._requestUrl;
    }
    set zoom(value) {
        if (value <= 0.1) {
            this._zoom = 0.1;
        }
        else if (value >= 4) {
            this._zoom = 4;
        }
        else {
            this._zoom = value;
        }
    }
    set cursor(value) {
        var _a;
        if (value == "default" && ((_a = this.selectedComponent) === null || _a === void 0 ? void 0 : _a.hover)) {
            this._cursor = "move";
        }
        else {
            this._cursor = value;
        }
    }
    formattingDate(dateFormat) {
        let result = dateFormat
            .replace(/M/g, "k")
            .replace(/m/g, "r")
            .replace(/tt/g, "a")
            .replace(/k/g, "m")
            .replace(/r/g, "M");
        return result;
    }
    setZoomFromString(zoomString) {
        if (typeof zoomString != "string") {
            return;
        }
        if (zoomString.includes("%")) {
            let zoom = Number(zoomString.slice(0, zoomString.indexOf("%"))) / 100;
            if (zoom <= 0.1) {
                this.zoom = 0.1;
            }
            else if (zoom >= 4) {
                this.zoom = 4;
            }
            else {
                this.zoom = zoom;
            }
        }
        else {
            switch (zoomString.toLowerCase()) {
                case "pagewidth":
                    this.formEvents.next({ name: "SetZoomByPageWidth" });
                    break;
                case "onepage":
                    this.formEvents.next({ name: "SetZoomByOnePage" });
                    break;
                default:
                    this.formEvents.next({ name: "SetDefaultZoom" });
                    break;
            }
        }
    }
    getPositionRelativeToForm(element) {
        var _a;
        let elementRect = element === null || element === void 0 ? void 0 : element.getBoundingClientRect();
        let formRect = (_a = this.rootFormElement) === null || _a === void 0 ? void 0 : _a.getBoundingClientRect();
        if (formRect) {
            return new DOMRect((elementRect === null || elementRect === void 0 ? void 0 : elementRect.x) - (formRect === null || formRect === void 0 ? void 0 : formRect.x), (elementRect === null || elementRect === void 0 ? void 0 : elementRect.y) - (formRect === null || formRect === void 0 ? void 0 : formRect.y), elementRect === null || elementRect === void 0 ? void 0 : elementRect.width, elementRect === null || elementRect === void 0 ? void 0 : elementRect.height);
        }
        else {
            return elementRect;
        }
    }
    getBooleanSetting(settingName) {
        return this.settings && this.isNotEmpty(this.settings[settingName]) && this.isBoolean(this.settings[settingName])
            ? this.settings[settingName]
            : true;
    }
    isBoolean(value) {
        return typeof value === "boolean";
    }
    isNotEmpty(value) {
        var _a;
        return ((_a = value === null || value === void 0 ? void 0 : value.toString()) === null || _a === void 0 ? void 0 : _a.length) > 0;
    }
    saveLastFormState() {
        this.form.reportVersion = this.buildVersion;
        this.form.reportChanged = StiStaticHelperService.dateToJsonDate(new Date());
        this.lastSavedFormState = this.form.saveToReportJsonObject().serialize();
    }
    toCamelCase(obj) {
        if (Array.isArray(obj)) {
            return obj.map((v) => this.toCamelCase(v));
        }
        else if (obj != null && obj.constructor === Object) {
            return Object.keys(obj).reduce((result, key) => (Object.assign(Object.assign({}, result), { [camelCase(key)]: this.toCamelCase(obj[key]) })), {});
        }
        return obj;
    }
    changeFileMenuState() {
        this.showFileMenuNavigation = !this.showFileMenuNavigation;
        setTimeout(() => {
            this.showFileMenu = !this.showFileMenu;
        }, 90);
    }
    showColumnPreview(index, type) {
        var _a, _b, _c, _d;
        if (!type &&
            ((_a = this.selectedComponent) === null || _a === void 0 ? void 0 : _a.element) instanceof StiTableElement &&
            !((_b = this.selectedComponent) === null || _b === void 0 ? void 0 : _b.element.showColumnsEditor)) {
            this.selectedComponent.element.showColumnsEditor = true;
            this.needToRefresh.next(true);
        }
        else if (type == "totals" &&
            ((_c = this.selectedComponent) === null || _c === void 0 ? void 0 : _c.element) instanceof StiTableElement &&
            !((_d = this.selectedComponent) === null || _d === void 0 ? void 0 : _d.element.showTotalsEditor)) {
            this.selectedComponent.element.showTotalsEditor = true;
            this.needToRefresh.next(true);
        }
        setTimeout(() => {
            if (this.currentContentEditableItemIndex != index || this.previousSelectedComponent != this.selectedComponent)
                this.currentContentEditableItem.next(index);
            this.currentContentEditableItemIndex = index;
        });
    }
    showError(message, sendedFromButton = false, buttonElement) {
        if (message instanceof ArrayBuffer) {
            var enc = new TextDecoder("utf-8");
            message = enc.decode(message);
        }
        else if (message instanceof Event) {
            message = message.type;
        }
        else if (message === null || message === void 0 ? void 0 : message.text) {
            message = message.text;
        }
        if (buttonElement) {
            this.currentUsedButtonElement = buttonElement;
        }
        this.sendedFromButton = sendedFromButton;
        this.errorWindowMessage = message;
        if (this.errorWindowMessage != "abort") {
            this.showErrorWindow = true;
        }
    }
    getImage(fileName) {
        return this.imagesArray && this.imagesArray[fileName] ? this.imagesArray[fileName] : "";
    }
    removeUnusedCells(element) {
        element.columns.forEach((column) => {
            if (column["cells"].length != element.rowLabels.length) {
                column["cells"].splice(element.rowLabels.length, column["cells"].length - 1);
            }
        });
    }
    startPdfExport(form) {
        if (form) {
            this.setFormFromString(JSON.stringify(form));
        }
        this.startPdfExportEvent.next(true);
    }
    setFormFromString(str, loadSavedSetings = false) {
        let form = new StiForm();
        form.loadFormJsonString(str);
        if (loadSavedSetings) {
            this.loadSavedSettings();
        }
        this.form = form;
    }
    get form() {
        return this._form;
    }
    set form(form) {
        this.updateForm(form);
        this.checkOnUniqueNames();
        form.formEvents.next({ name: "SetForm" });
        this.firstFormState = this.form.saveToReportJsonObject().serialize();
        if (this.viewerMode && this.isMobile()) {
            setTimeout(() => {
                this.isMobileViewer.next(true);
            });
        }
    }
    arrayOfStylesToString(array) {
        if (!array)
            return;
        let styles = [];
        if (array.length > 0) {
            array.forEach((item) => {
                if (item != "Underline") {
                    styles.push(item);
                }
            });
        }
        return styles.length > 0 ? styles.join(" ").toLocaleLowerCase() : "";
    }
    checkOnUniqueNames() {
        this.form.allElements.forEach((element) => {
            let currentName = element.name;
            let uniqueElements = this.form.allElements.filter((elem) => elem.name == currentName);
            if (uniqueElements.length > 1) {
                this.setUniqueName(element);
            }
        });
    }
    setUniqueName(element) {
        var _a, _b, _c;
        let regex = /\d+$/;
        let currentName = (_a = element.name) !== null && _a !== void 0 ? _a : element.type.replace("_", "").replace("Element", "");
        let index = 0;
        let currentPosition = ((_b = element.name) === null || _b === void 0 ? void 0 : _b.match(regex)) ? (_c = element.name) === null || _c === void 0 ? void 0 : _c.match(regex)[0] : null;
        if (currentPosition) {
            currentName = currentName.slice(0, currentName.length - currentPosition.length);
        }
        while (this.form.allElements.find((element) => element.name == `${currentName + (index != 0 ? index + 1 : "")}`)) {
            index++;
        }
        element.name = currentName + (index != 0 ? index + 1 : "");
    }
    checkNumberRange(element) {
        if (element.rangeFormat == StiNumberRangeFormat.Digits) {
            let maximumValueString = "";
            for (let index = element.maximum; index > 0; index--) {
                maximumValueString += "9";
            }
            let maximumValue = Number(maximumValueString);
            let minimumValue = -Number(maximumValueString);
            if (element.value > maximumValue) {
                element.value = maximumValue;
            }
            else if (element.value < minimumValue) {
                element.value = minimumValue;
            }
        }
        else {
            if (element.value > element.maximum) {
                element.value = Number(element.maximum);
            }
            else if (element.value < element.minimum) {
                element.value = Number(element.minimum);
            }
        }
    }
    showTrialLog() {
        if (this.showTrialBar || this.showTrialTitle || this.showTrialModalWindow) {
            console.warn("You are using a trial version of the Stimulsoft Forms!");
        }
    }
    loadSavedSettings() {
        var _a, _b, _c;
        if (localStorage.getItem("StiFormSettings") &&
            (this.isWebView || this.isCloudMode || ((_a = this.properties) === null || _a === void 0 ? void 0 : _a.cloudPlanIdent))) {
            (_c = (_b = this.form) === null || _b === void 0 ? void 0 : _b.settings) === null || _c === void 0 ? void 0 : _c.loadFormJsonString(localStorage.getItem("StiFormSettings"));
        }
    }
    saveSettings() {
        localStorage.removeItem("StiFormSettings");
        localStorage.setItem("StiFormSettings", this.form.settings.saveToJsonObject({}).serialize());
    }
    isMobile() {
        const toMatch = [/Android/i, /webOS/i, /iPhone/i, /iPad/i, /iPod/i, /BlackBerry/i, /Windows Phone/i];
        return toMatch.some((toMatchItem) => {
            return navigator.userAgent.match(toMatchItem);
        });
    }
    getBrowserType() {
        let userAgent = navigator.userAgent;
        let browserName;
        if (userAgent.match(/chrome|chromium|crios/i)) {
            browserName = "chrome";
        }
        else if (userAgent.match(/firefox|fxios/i)) {
            browserName = "firefox";
        }
        else if (userAgent.match(/safari/i)) {
            browserName = "safari";
        }
        else if (userAgent.match(/opr\//i)) {
            browserName = "opera";
        }
        else if (userAgent.match(/edg/i)) {
            browserName = "edge";
        }
        else {
            browserName = "No browser detection";
        }
        return browserName;
    }
    getScaleWithTranslate() {
        return `translate(${this.zoom <= 1 ? 0 : ((this.zoom - 1) / 2) * 100}%) scale(${this.zoom})`;
    }
    getScale() {
        return `scale(${this.zoom})`;
    }
    updateForm(form) {
        var _a;
        this._form = form;
        this.selectedComponent = null;
        this.lastUsedPage = null;
        form.formEvents.subscribe((e) => this.formEvents.next(e));
        if (((_a = form.pages) === null || _a === void 0 ? void 0 : _a.length) > 0) {
            this.previousPadding = form.pages[0].padding.clone();
            this.previousContentAreaWidth = form.pages[0].contentAreaWidth;
            setTimeout(() => {
                this.needToRefresh.next(true);
            }, 0);
        }
        form.formEvents.next({ name: "UpdateForm" });
    }
    set elementToUpdate(value) {
        let oldValue = this._elementToUpdate;
        this._elementToUpdate = value;
        if (oldValue != value) {
            this.formEvents.next({ name: "ElementToUpdateChanged", value: value });
        }
    }
    get elementToUpdate() {
        return this._elementToUpdate;
    }
    get selectedComponent() {
        return this._selectedComponent;
    }
    set selectedComponent(value) {
        let oldValue = this._selectedComponent;
        this._selectedPage = null;
        this._selectedComponent = value;
        this.needToRefresh.next(true);
        if (oldValue != value) {
            this.formEvents.next({ name: "SelectedComponentChanged", value: value });
        }
    }
    get selectedPage() {
        return this._selectedPage;
    }
    set selectedPage(value) {
        let oldValue = this._selectedPage;
        this._selectedComponent = null;
        this._selectedPage = value;
        this.needToRefresh.next(true);
        if (oldValue != value) {
            this.formEvents.next({ name: "SelectedPageChanged", value: value });
        }
    }
    get lastUsedPage() {
        var _a, _b, _c;
        return (_b = (_a = this._lastUsedPage) !== null && _a !== void 0 ? _a : this.selectedPage) !== null && _b !== void 0 ? _b : (_c = this.form) === null || _c === void 0 ? void 0 : _c.pages[0];
    }
    set lastUsedPage(value) {
        this._lastUsedPage = value;
    }
    getSelectedComponentPage() {
        var _a;
        return this.getElementPage((_a = this._selectedComponent) === null || _a === void 0 ? void 0 : _a.element);
    }
    getElementPage(element) {
        var _a;
        return (_a = this.form) === null || _a === void 0 ? void 0 : _a.pages.find((p) => p.elements.find((e) => e == element) != null);
    }
    getElementPageForScroll(element) {
        var _a;
        return (_a = this.form) === null || _a === void 0 ? void 0 : _a.pages.find((p) => p.elements.find((e) => e == element) != null
            ? p.elements.find((e) => e == element)
            : this.getElementPanel(element));
    }
    overToolbar(x, y) {
        let elementsDiv = document.elementsFromPoint(x, y).find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("elements"));
        return elementsDiv ? true : false;
    }
    getElementPanel(element) {
        let result;
        this.form.pages.forEach((page) => {
            page.allElements.forEach((panel) => {
                if (panel instanceof StiPanelElement && panel.elements.indexOf(element) >= 0) {
                    result = panel;
                }
            });
        });
        return result;
    }
    formatNumber(value, format, decimalDigits, unitAlignment, unit) {
        let formatedValue = this.formatNumberWithThousandSeparator(value, format, decimalDigits);
        switch (unitAlignment) {
            case StiUnitAlignment.PrefixInside:
                return `${unit}${formatedValue}`;
            case StiUnitAlignment.PrefixInsideSpace:
                return `${unit} ${formatedValue}`;
            case StiUnitAlignment.SuffixInside:
                return `${formatedValue}${unit}`;
            case StiUnitAlignment.SuffixInsideSpace:
                return `${formatedValue} ${unit}`;
        }
        return formatedValue;
    }
    getFormattedValue(element, inValue) {
        let value = inValue;
        try {
            if (typeof value === "number" && !isNaN(value)) {
                value = this.formatNumberWithThousandSeparator(parseFloat(value.toFixed(element.decimalDigits)), element.thousandSeparator, element.decimalDigits);
            }
        }
        catch (_a) {
            value = "";
        }
        return value;
    }
    formatNumberWithThousandSeparator(value, format, decimalDigits) {
        let isNegative = false;
        if (value == undefined) {
            return "";
        }
        let result;
        if (decimalDigits > 0) {
            result = value.toFixed(decimalDigits);
        }
        else {
            result = value.toString();
        }
        if (result.indexOf("-") != -1) {
            isNegative = true;
        }
        if (isNegative) {
            result = result.slice(1, result.length);
        }
        if (format == StiThousandSeparator.None) {
            return (isNegative ? "-" : "") + result;
        }
        else if (format == StiThousandSeparator.NoneComma) {
            return (isNegative ? "-" : "") + result.replace(".", ",");
        }
        else if (format == StiThousandSeparator.Comma) {
            var chars = (decimalDigits > 0 ? result.slice(0, indexOf(result, ".")) : result).split("").reverse();
            var withCommas = [];
            for (var i = 1; i <= chars.length; i++) {
                withCommas.push(chars[i - 1]);
                if (i % 3 == 0 && i != chars.length) {
                    withCommas.push(",");
                }
            }
            result =
                decimalDigits > 0
                    ? withCommas.reverse().join("") + result.slice(indexOf(result, "."), result.length)
                    : withCommas.reverse().join("");
            return (isNegative ? "-" : "") + result;
        }
        else if (format == StiThousandSeparator.Dot) {
            var chars = (decimalDigits > 0 ? result.slice(0, indexOf(result, ".")) : result).split("").reverse();
            var withDotts = [];
            for (var i = 1; i <= chars.length; i++) {
                withDotts.push(chars[i - 1]);
                if (i % 3 == 0 && i != chars.length) {
                    withDotts.push(".");
                }
            }
            result =
                decimalDigits > 0
                    ? withDotts.reverse().join("") + "," + result.slice(indexOf(result, ".") + 1, result.length)
                    : withDotts.reverse().join("");
            return (isNegative ? "-" : "") + result;
        }
        else if (format == StiThousandSeparator.Apostrophe) {
            var chars = (decimalDigits > 0 ? result.slice(0, indexOf(result, ".")) : result).split("").reverse();
            var withSpaces = [];
            for (var i = 1; i <= chars.length; i++) {
                withSpaces.push(chars[i - 1]);
                if (i % 3 == 0 && i != chars.length) {
                    withSpaces.push("`");
                }
            }
            result =
                decimalDigits > 0
                    ? withSpaces.reverse().join("") + "." + result.slice(indexOf(result, ".") + 1, result.length)
                    : withSpaces.reverse().join("");
            return (isNegative ? "-" : "") + result;
        }
    }
    getWindowScaling() {
        return window.devicePixelRatio * 100;
    }
    getScaling() {
        if (this.getWindowScaling() < 125) {
            return "";
        }
        else if (125 <= this.getWindowScaling() && this.getWindowScaling() < 150) {
            return "_x1_25";
        }
        else if (150 <= this.getWindowScaling() && this.getWindowScaling() < 175) {
            return "_x1_5";
        }
        else if (175 <= this.getWindowScaling() && this.getWindowScaling() < 200) {
            return "_x1_75";
        }
        else if (200 <= this.getWindowScaling() && this.getWindowScaling() < 300) {
            return "_x2";
        }
        else if (300 <= this.getWindowScaling() && this.getWindowScaling() < 400) {
            return "_x3";
        }
        else if (this.getWindowScaling() > 400) {
            return "_x4";
        }
    }
    getPageFromPoint(x, y) {
        var _a;
        let pageDiv;
        for (let elem of document.elementsFromPoint(x, y)) {
            if (elem === null || elem === void 0 ? void 0 : elem.classList.contains(StiModelService.PAGE_CLASS)) {
                pageDiv = elem;
                break;
            }
        }
        if (pageDiv) {
            for (let page of this.form.pages) {
                if (((_a = page.element) === null || _a === void 0 ? void 0 : _a.nativeElement) == pageDiv) {
                    pageDiv = page;
                    break;
                }
            }
        }
        // let pageDiv = document.elementsFromPoint(x, y).find((elem) => elem?.classList.contains(StiModelService.PAGE_CLASS));
        return pageDiv ? pageDiv : null;
    }
    getPanelFromPoint(x, y, excludeId) {
        let page = this.getPageFromPoint(x, y);
        let panelDivs = document
            .elementsFromPoint(x, y)
            .filter((elem) => (elem === null || elem === void 0 ? void 0 : elem.classList.contains(StiModelService.PANEL_CLASS)) && elem.id != excludeId);
        return panelDivs && page
            ? page.allElements.find((e) => panelDivs.find((p) => e.guid == p.id))
            : null;
    }
    getMouseOverPagePosition(event) {
        let page = this.getPageFromPoint(event.clientX, event.clientY);
        if (page) {
            let rect = this.getPositionRelativeToForm(page.element.nativeElement);
            return {
                x: event.clientX - (rect.left + page.padding.left * this.zoom),
                y: event.clientY - (rect.top + page.padding.top * this.zoom),
            };
        }
        return null;
    }
    getMouseOverPanelPosition(event, excludeId) {
        let panel = this.getPanelFromPoint(event.clientX, event.clientY, excludeId);
        if (panel) {
            let rect = this.getPositionRelativeToForm(panel.element.nativeElement);
            return { x: event.clientX - rect.left, y: event.clientY - rect.top };
        }
        return null;
    }
    loadAttachedFile() {
        let input = document.createElement("input");
        input.type = "file";
        let this_ = this;
        input.onchange = (_) => {
            let file = Array.from(input.files)[0];
            var reader = new FileReader();
            reader.readAsDataURL(file);
            reader.onload = function () {
                this_.attachedFiles.push(reader.result);
            };
        };
        input.click();
    }
    downloadFiles(data, file_name) {
        let file = new Blob([data]);
        let a = document.createElement("a"), url = URL.createObjectURL(file);
        a.href = url;
        a.download = file_name;
        document.body.appendChild(a);
        a.click();
        setTimeout(function () {
            document.body.removeChild(a);
            window.URL.revokeObjectURL(url);
        }, 0);
    }
}
StiModelService.PAGE_CLASS = "sti-page";
StiModelService.PANEL_CLASS = "sti-panel";
StiModelService.THEMES = ["Light", "Dark"];
StiModelService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiModelService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
StiModelService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiModelService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiModelService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });

class StiRectangleGeometryLayout {
    constructor(model) {
        this.model = model;
    }
    insertElement(newElement, contentAreaWidth = 0) {
        var _a;
        // let fixedGeometry = this.fixForInsert(newElement.geometry);
        let parentElement = (_a = this.model.getElementPage(newElement)) !== null && _a !== void 0 ? _a : this.model.getElementPanel(newElement);
        let otherElements = Array.from(parentElement.elements);
        otherElements.splice(otherElements.indexOf(newElement), 1);
        if (newElement) {
            let fixedGeometry = newElement.geometry;
            this.insertFixed(fixedGeometry, newElement, otherElements, contentAreaWidth);
        }
    }
    isHigherThan(left, right) {
        return left.bottom <= right.y;
    }
    isHigherThan2(left, right) {
        return left.bottom - left.height / 2 <= right.y;
    }
    removeElement(elementToRemove, otherElements) {
        let elementsAbove = [];
        let elementsBelow = [];
        for (let element of otherElements) {
            if (this.isHigherThan(element.geometry, elementToRemove.geometry)) {
                elementsAbove.push(element);
            }
            else {
                elementsBelow.push(element);
            }
        }
        this.snapBelowsToAboves(elementsBelow, elementsAbove);
    }
    changeElementGeometry(elementToChange, otherElements, contentAreaWidth = 0) {
        let fixedGeometry = elementToChange.geometry;
        this.insertFixed(fixedGeometry, elementToChange, otherElements, contentAreaWidth);
    }
    fitWidth(fixedGeometry, otherElements, contentAreaWidth) {
        if (contentAreaWidth > 0) {
            let right = contentAreaWidth;
            let rect = new StiRectangleGeometry(fixedGeometry.width - fixedGeometry.minWidth, fixedGeometry.height / 2);
            rect.x = fixedGeometry.x + fixedGeometry.minWidth;
            rect.y = fixedGeometry.y;
            otherElements.forEach((element) => {
                if (element.geometry.intersectWith(rect)) {
                    right = Math.min(right, element.geometry.x);
                }
            });
            let newWidth = fixedGeometry.width - (fixedGeometry.right - right);
            if (newWidth + StiRectangleGeometry.DELTA > fixedGeometry.minWidth &&
                newWidth <= fixedGeometry.width + StiRectangleGeometry.DELTA) {
                fixedGeometry.width = newWidth;
            }
        }
    }
    insertFixed(fixedGeometry, elementToInsert, otherElements, contentAreaWidth) {
        let elementsAbove = [];
        let elementsBelow = [];
        for (let element of otherElements) {
            if (this.isHigherThan2(element.geometry, fixedGeometry)) {
                elementsAbove.push(element);
            }
            else {
                elementsBelow.push(element);
            }
        }
        this.fitWidth(fixedGeometry, otherElements, contentAreaWidth);
        let snappedNewGeometry = this.snapOneToAboves(fixedGeometry, elementsAbove, true);
        elementToInsert.geometry = snappedNewGeometry;
        elementsAbove.push(elementToInsert);
        this.moveDown(elementsBelow, 2 * snappedNewGeometry.height);
        this.snapBelowsToAboves(elementsBelow, elementsAbove);
        this.fitWidth(snappedNewGeometry, otherElements, contentAreaWidth);
    }
    snapOneToAboves(geometry, elementsAboveToSnap, canShrink = false) {
        let elementsExcatlyAbove = elementsAboveToSnap.filter((element) => element.geometry.xProjectionIntersectsWith(geometry));
        if (elementsExcatlyAbove.length > 0) {
            let max = elementsExcatlyAbove.reduce((acc, curr) => (acc.geometry.bottom > curr.geometry.bottom ? acc : curr));
            return geometry.withY(max.geometry.bottom);
        }
        else
            return geometry.withY(0);
    }
    moveDown(elementsToMoveDown, distance) {
        for (let element of elementsToMoveDown) {
            element.geometry = element.geometry.withY(element.geometry.y + distance);
        }
    }
    snapBelowsToAboves(belows, aboves) {
        belows.sort(function (left, right) {
            let difference = left.geometry.y - right.geometry.y;
            if (difference < StiRectangleGeometry.DELTA) {
                return -1;
            }
            else if (difference > StiRectangleGeometry.DELTA) {
                return 1;
            }
            else {
                return 0;
            }
        });
        for (let element of belows) {
            let snappedFromBelow = this.snapOneToAboves(element.geometry, aboves);
            element.geometry = snappedFromBelow;
            aboves.push(element);
        }
    }
    getFreeToBottomResizeArea(currentResizeElement, otherElements) {
        var _a;
        let currentContainer = (_a = this.model.getElementPage(currentResizeElement)) !== null && _a !== void 0 ? _a : this.model.getElementPanel(currentResizeElement);
        let geometry = currentResizeElement.geometry;
        let bottomElements = otherElements === null || otherElements === void 0 ? void 0 : otherElements.filter((element) => element.y >= geometry.bottom);
        let elementsExcatlyBelow = bottomElements === null || bottomElements === void 0 ? void 0 : bottomElements.filter((element) => element.geometry.xProjectionIntersectsWith(geometry));
        let bottomPoints = elementsExcatlyBelow === null || elementsExcatlyBelow === void 0 ? void 0 : elementsExcatlyBelow.map((element) => {
            return element.geometry.bottom;
        });
        let topPoints = elementsExcatlyBelow === null || elementsExcatlyBelow === void 0 ? void 0 : elementsExcatlyBelow.map((element) => {
            return element.geometry.y;
        });
        let maxBottomPoint = Math.max(...bottomPoints);
        let minTopPoint = Math.min(...topPoints);
        let bottomElementsHeight = maxBottomPoint - minTopPoint;
        return (currentContainer.contentAreaHeight -
            geometry.bottom -
            (elementsExcatlyBelow.length > 0 ? bottomElementsHeight : 0));
    }
    checkOutputs(usedPage) {
        let outputElements = [];
        let summaryHeight = 0;
        usedPage === null || usedPage === void 0 ? void 0 : usedPage.elements.forEach((element) => {
            if (element.geometry.bottom > usedPage.contentAreaHeight) {
                outputElements.push(element);
            }
        });
        if (outputElements.length > 0) {
            outputElements.forEach((element) => {
                summaryHeight += element.height;
                usedPage.elements.splice(usedPage.elements.indexOf(element), 1);
                this.removeElement(element, usedPage.elements);
            });
            if (this.model.form.pages[this.model.form.pages.indexOf(usedPage) + 1]) {
                let nextPage = this.model.form.pages[this.model.form.pages.indexOf(usedPage) + 1];
                if (nextPage.contentAreaHeight - Math.max(...nextPage.elements.map((element) => element.geometry.bottom)) >
                    summaryHeight) {
                    let currentBottomPoint = 0;
                    outputElements.forEach((element, index) => {
                        nextPage.elements.splice(index, 0, element);
                        element.y = currentBottomPoint;
                        this.insertElement(element);
                        currentBottomPoint += element.height;
                    });
                }
                else {
                    let page1 = new StiFormPageElement();
                    this.model.form.pages.splice(this.model.form.pages.indexOf(nextPage), 0, page1);
                    let currentBottomPoint = 0;
                    outputElements.forEach((element, index) => {
                        page1.elements.splice(index, 0, element);
                        element.y = currentBottomPoint;
                        this.insertElement(element);
                        currentBottomPoint += element.height;
                    });
                }
            }
            else {
                let page1 = new StiFormPageElement();
                this.model.form.pages.push(page1);
                let currentBottomPoint = 0;
                outputElements.forEach((element, index) => {
                    page1.elements.splice(index, 0, element);
                    element.y = currentBottomPoint;
                    this.insertElement(element);
                    currentBottomPoint += element.geometry.bottom;
                });
            }
        }
    }
}
StiRectangleGeometryLayout.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiRectangleGeometryLayout, deps: [{ token: StiModelService }], target: i0.ɵɵFactoryTarget.Injectable });
StiRectangleGeometryLayout.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiRectangleGeometryLayout });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiRectangleGeometryLayout, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: StiModelService }]; } });

class StiEditableContentService {
    constructor(model) {
        this.model = model;
        this.activeControl = false;
    }
    getIntEditableContent() {
        return this._editableContent;
    }
    get editableContent() {
        var _a, _b;
        return this._editableContent || ((_b = (_a = this.model.selectedComponent) === null || _a === void 0 ? void 0 : _a.element) === null || _b === void 0 ? void 0 : _b.getDefaultEditableContent());
    }
    set editableContent(value) {
        this._editableContent = value;
    }
    startEdit(editableElementRef = null) {
        var _a;
        editableElementRef = editableElementRef !== null && editableElementRef !== void 0 ? editableElementRef : this.editableElementRef;
        if (editableElementRef) {
            let caretOffset = this.getCaretOffset((_a = editableElementRef.nativeElement) !== null && _a !== void 0 ? _a : editableElementRef);
            this.activeControl = true;
            setTimeout(() => {
                var _a, _b;
                this.activeControl = false;
                let el = (_a = editableElementRef.nativeElement) !== null && _a !== void 0 ? _a : editableElementRef;
                el.focus();
                if (el.tagName.toLowerCase() != "label" && ((_b = el === null || el === void 0 ? void 0 : el.innerText) === null || _b === void 0 ? void 0 : _b.length) > 0) {
                    this.setCaret(el, caretOffset);
                }
            }, 0);
        }
    }
    getCaretOffset(element) {
        let caretOffset = 0;
        let doc = element.ownerDocument || element.document;
        let win = doc.defaultView || doc.parentWindow;
        let sel;
        if (typeof win.getSelection != "undefined") {
            sel = win.getSelection();
            if (sel.rangeCount > 0) {
                let range = win.getSelection().getRangeAt(0);
                let preCaretRange = range.cloneRange();
                preCaretRange.selectNodeContents(element);
                preCaretRange.setEnd(range.endContainer, range.endOffset);
                caretOffset = preCaretRange.toString().length;
            }
        }
        else if ((sel = doc.selection) && sel.type != "Control") {
            let textRange = sel.createRange();
            let preCaretTextRange = doc.body.createTextRange();
            preCaretTextRange.moveToElementText(element);
            preCaretTextRange.setEndPoint("EndToEnd", textRange);
            caretOffset = preCaretTextRange.text.length;
        }
        return caretOffset;
    }
    setCaret(el, caretOffset) {
        var range = document.createRange();
        var sel = window.getSelection();
        range.setStart(el.childNodes[0], caretOffset);
        range.collapse(true);
        sel.removeAllRanges();
        sel.addRange(range);
    }
}
StiEditableContentService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiEditableContentService, deps: [{ token: StiModelService }], target: i0.ɵɵFactoryTarget.Injectable });
StiEditableContentService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiEditableContentService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiEditableContentService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: StiModelService }]; } });

class StiUserService {
    constructor(model) {
        this.model = model;
        this.showLocalizationPreview = false;
        this.showUserInfo = false;
        this.buildDate = new Date(2022, 8, 27);
        this.trialMessage = "";
    }
    get currentUser() {
        return this._currentUser;
    }
    set currentUser(value) {
        if (value) {
            if (value == "empty") {
                this._currentUser = null;
            }
            else {
                let user = this.model.toCamelCase(value);
                this._currentUser = user;
                if ((user === null || user === void 0 ? void 0 : user.created) && !this.model.isWebView && (!this.licenseProducts || this.licenseProducts.length == 0)) {
                    this.buildDate = StiJson.jsonDateFormatToDate(user.created).date;
                }
            }
            this.checkLicense();
        }
    }
    getBackground(user) {
        var _a;
        let key = (user === null || user === void 0 ? void 0 : user.userKey) ? user === null || user === void 0 ? void 0 : user.userKey : (_a = user === null || user === void 0 ? void 0 : user.key) !== null && _a !== void 0 ? _a : "key";
        var r = 0;
        var g = 0;
        var b = 0;
        for (var i = 0; i < key.length / 3; i += 3) {
            r += key.charCodeAt(i);
            g += key.charCodeAt(i + 1);
            b += key.charCodeAt(i + 2);
        }
        r = (r % 100) + 100;
        g = (g % 100) + 100;
        b = (b % 100) + 100;
        return `rgb(${r},${g}, ${b})`;
    }
    checkLicense() {
        var _a, _b;
        this.model.userWasChecked = true;
        if (((_a = this.licenseProducts) === null || _a === void 0 ? void 0 : _a.length) > 0 || this.currentUser) {
            let expirationDate = 0;
            if (((_b = this.licenseProducts) === null || _b === void 0 ? void 0 : _b.length) > 0) {
                this.licenseProducts.forEach((product) => {
                    if (product.ident == "Ultimate" ||
                        product.ident == "FormsWeb" ||
                        product.ident == 1 ||
                        product.ident == 4 ||
                        product.ident == "BICloud" ||
                        product.ident == 18) {
                        expirationDate = Math.max(expirationDate, new Date(product.expirationDate).getTime());
                    }
                });
            }
            if (this.currentUser) {
                this.model.userIsAuthorized = true;
            }
            if (expirationDate != 0 && expirationDate > this.buildDate.getTime()) {
                this.model.showTrialBar = false;
                this.model.showTrialModalWindow = false;
                this.model.showTrialTitle = false;
                this.model.userIsAuthorized = true;
            }
            else {
                this.showTrial();
            }
        }
        else {
            this.showTrial();
        }
    }
    resetTrial() {
        this.model.showTrialBar = true;
        this.model.showTrialTitle = true;
        this.model.canCloseTrialWindow = true;
        this.model.disableCloseButton = false;
        this.model.showTrialModalWindow = false;
    }
    showTrial() {
        let currentDate = new Date();
        let trDays = Math.floor((currentDate.getTime() - this.buildDate.getTime()) / 1000 / 60 / 60 / 24);
        this.trialMessage = StiLocalizationService.get("Notices", "YouUsingTrialVersion");
        this.resetTrial();
        if (trDays > 30) {
            this.model.disableCloseButton = true;
        }
        if (!this.model.buildDate) {
            return;
        }
        if (trDays > 45) {
            this.model.showTrialTitle = true;
            setTimeout(() => {
                if (this.currentUser) {
                    this.model.showTrialModalWindow = true;
                }
            }, 3000);
        }
        if (trDays > 60) {
            if (this.currentUser) {
                this.model.canCloseTrialWindow = false;
            }
            this.trialMessage = StiLocalizationService.get("Notices", "YourTrialHasExpired");
            setTimeout(() => {
                if (this.currentUser) {
                    this.model.showTrialModalWindow = true;
                }
            }, 3000);
        }
    }
}
StiUserService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiUserService, deps: [{ token: StiModelService }], target: i0.ɵɵFactoryTarget.Injectable });
StiUserService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiUserService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiUserService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: StiModelService }]; } });

class SignatureService {
    constructor(model) {
        this.model = model;
        this._editorComponentX = 0;
        this._editorComponentY = 0;
        this.textMode = false;
        this.selectedMode = "Draw";
        this.previewFonts = ["Teddy Bear", "MADE Likes Script", "Denistina"];
        this.currentPreviewFont = "Teddy Bear";
        this.drawingMode = false;
        this.showFontsPreview = false;
        this.loadedImage = new Subject();
        this.clearButtonClick = new Subject();
        this.updateSignature = new Subject();
        this.getInsertedInformation = new Subject();
        this.currentEditableText = new StiTextItem();
        this.editorComponentHeight = 350;
        this.editorComponentWidth = 365;
        this.fontsPreviewX = 0;
        this.fontsPreviewY = 0;
        this.templatesPreviewX = 0;
        this.templatesPreviewY = 0;
        this.showSavedTemplates = false;
        this.savedTemplates = [];
        this.currentActiveLoadingImages = 0;
        this.completedLoadingImages = 0;
        this.completedLoading = new Subject();
    }
    checkLoading() {
        if (this.completedLoadingImages === this.currentActiveLoadingImages) {
            this.completedLoading.next(true);
            this.completedLoadingImages = 0;
            this.currentActiveLoadingImages = 0;
        }
        else {
            setTimeout(() => {
                this.checkLoading();
            });
        }
    }
    getVerticalPosition(verticalAlignment) {
        switch (verticalAlignment) {
            case StiVerticalAlignment.Top:
                return "top";
            case StiVerticalAlignment.Bottom:
                return "bottom";
            case StiVerticalAlignment.Center:
                return "center";
        }
    }
    getHorizontalPosition(horizontalAlignment) {
        switch (horizontalAlignment) {
            case StiHorizontalAlignment.Left:
                return "left";
            case StiHorizontalAlignment.Right:
                return "right";
            case StiHorizontalAlignment.Center:
                return "center";
        }
    }
    getClass(item) {
        if (item == "Text") {
            return StiTextItem;
        }
        else if (item == "Image") {
            return StiImageEditorResult;
        }
    }
    setTemplate(template) {
        if (template.type == "Image") {
            this.currentEditableImage = template.image;
            this.currentEditableText = template.text;
            this.currentCanvasContent = template.drawedImage;
            this.selectedMode = "Draw";
        }
        else {
            this.currentPreviewFont = template.specialFont;
            this.currentEditableFullName = template.fullName;
            this.currentEditableInitials = template.initials;
            this.selectedMode = "Type";
        }
        this.showSavedTemplates = false;
    }
    getTemplateImage(template) {
        var _a;
        return "url(" + ((_a = template === null || template === void 0 ? void 0 : template.image) === null || _a === void 0 ? void 0 : _a.loadedImage) + ")";
    }
    getTemplateDrawedImage(template) {
        var _a;
        return "url(" + ((_a = template === null || template === void 0 ? void 0 : template.image) === null || _a === void 0 ? void 0 : _a.drawedImage) + ")";
    }
    deleteTemplate(index) {
        this.savedTemplates.splice(index, 1);
    }
    getTemplateHorizontalAlignment(template) {
        if (template.image.horizontalAlignment == StiHorizontalAlignment.Center) {
            return "center";
        }
        else if (template.image.horizontalAlignment == StiHorizontalAlignment.Left) {
            return "start";
        }
        else {
            return "end";
        }
    }
    getTemplateBackgroundSize(template, container) {
        var _a, _b, _c, _d, _e;
        if (!((_a = template === null || template === void 0 ? void 0 : template.image) === null || _a === void 0 ? void 0 : _a.loadedImage)) {
            return;
        }
        if ((_b = template === null || template === void 0 ? void 0 : template.image) === null || _b === void 0 ? void 0 : _b.aspectRatio) {
            return "contain";
        }
        if ((_c = template === null || template === void 0 ? void 0 : template.image) === null || _c === void 0 ? void 0 : _c.stretch) {
            return `${container.offsetWidth}px ${container.offsetHeight}px`;
        }
        else {
            return `${(_d = template === null || template === void 0 ? void 0 : template.image) === null || _d === void 0 ? void 0 : _d.naturalWidth}px ${(_e = template === null || template === void 0 ? void 0 : template.image) === null || _e === void 0 ? void 0 : _e.naturalHeight}px`;
        }
    }
    getTemplateBackgroundPosition(template) {
        var _a, _b, _c, _d;
        if (!((_a = template === null || template === void 0 ? void 0 : template.image) === null || _a === void 0 ? void 0 : _a.aspectRatio) && !((_b = template === null || template === void 0 ? void 0 : template.image) === null || _b === void 0 ? void 0 : _b.stretch)) {
            if (((_c = template === null || template === void 0 ? void 0 : template.image) === null || _c === void 0 ? void 0 : _c.verticalAlignment) == StiVerticalAlignment.Center) {
                return "center center";
            }
            else if (((_d = template === null || template === void 0 ? void 0 : template.image) === null || _d === void 0 ? void 0 : _d.verticalAlignment) == StiVerticalAlignment.Top) {
                return "top center";
            }
            else {
                return "bottom center";
            }
        }
        else {
            return "center";
        }
    }
    cloneProperty(property, propertyClass) {
        let result = new propertyClass();
        let jObject = new StiJson();
        jObject.deserialize(property.saveToJsonObject({}).serialize());
        result.loadFromJsonObject(jObject);
        return result;
    }
    get editorComponentX() {
        return this._editorComponentX;
    }
    set editorComponentX(value) {
        value <= 0 ? (this._editorComponentX = 0) : (this._editorComponentX = value);
    }
    get editorComponentY() {
        return this._editorComponentY;
    }
    set editorComponentY(value) {
        value <= 0 ? (this._editorComponentY = 0) : (this._editorComponentY = value);
    }
    get y() {
        var _a;
        if (this.isSignature) {
            let container = document.getElementById((_a = this.model.selectedComponent) === null || _a === void 0 ? void 0 : _a.element.guid);
            let geom = this.model.getPositionRelativeToForm(container);
            return geom.y;
        }
        else {
            return 0;
        }
    }
    get x() {
        var _a;
        if (this.isSignature) {
            let container = document.getElementById((_a = this.model.selectedComponent) === null || _a === void 0 ? void 0 : _a.element.guid);
            let geom = this.model.getPositionRelativeToForm(container);
            return geom.x + geom.width + 5;
        }
        else {
            return 0;
        }
    }
    changeDrawingMode() {
        this.textMode = false;
        this.drawingMode = !this.drawingMode;
    }
    changeTextMode() {
        this.drawingMode = false;
        this.textMode = !this.textMode;
    }
    clear() {
        this.clearButtonClick.next(true);
    }
    onFileSelected() {
        let input = document.createElement("input");
        input.type = "file";
        input.accept = ".png, .jpg, .jpeg";
        let this_ = this;
        input.onchange = (_) => {
            this_.clear();
            let file = Array.from(input.files)[0];
            var reader = new FileReader();
            reader.readAsDataURL(file);
            reader.onload = function (e) {
                this_.loadedImage.next(e.target.result);
            };
        };
        input.click();
    }
    get isSignature() {
        var _a;
        return ((_a = this.model.selectedComponent) === null || _a === void 0 ? void 0 : _a.element) instanceof StiSignatureElement ? true : false;
    }
}
SignatureService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: SignatureService, deps: [{ token: StiModelService }], target: i0.ɵɵFactoryTarget.Injectable });
SignatureService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: SignatureService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: SignatureService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: StiModelService }]; } });

class StiDropdownService {
    constructor() {
        this.currentOptionList = [];
        this.showDropdownList = false;
        this.valueChanged = new Subject();
    }
}
StiDropdownService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDropdownService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
StiDropdownService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDropdownService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDropdownService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });

class StiMouseService {
    constructor(model, editableSevice, userService, signatureService, dropdownService) {
        this.model = model;
        this.editableSevice = editableSevice;
        this.userService = userService;
        this.signatureService = signatureService;
        this.dropdownService = dropdownService;
        this.documetMouseDown = new Subject();
        this.documetMouseMove = new Subject();
        this.documetMouseUp = new Subject();
        this.captureMouseUp = new Subject();
        this.captureMouseDown = new Subject();
        this.documentTouchStart = new Subject();
        this.documentTouchMove = new Subject();
        this.documentTouchEnd = new Subject();
        this.leftButtonDown = false;
        this.rightButtonDown = false;
        document.addEventListener("mouseup", (event) => {
            this.documetMouseUp.next(event);
        });
        document.addEventListener("touchstart", (event) => {
            this.documentTouchStart.next(event);
        }, { passive: false });
        document.addEventListener("touchmove", (event) => {
            this.documentTouchMove.next(event);
        }, { passive: false });
        document.addEventListener("touchend", (event) => {
            this.documentTouchEnd.next(event);
        }, { passive: false });
        document.addEventListener("mouseup", (event) => {
            let form = document.querySelector("stimulsoft-forms");
            if (form) {
                (form === null || form === void 0 ? void 0 : form.classList.contains("unselectable")) ? form === null || form === void 0 ? void 0 : form.classList.remove("unselectable") : "";
            }
            let elements = document.elementsFromPoint(event.clientX, event.clientY);
            if (!elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("parent-group-container"))) {
                this.model.showGroupPreview = false;
            }
            if (!elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("form-elements-list-item")) &&
                !elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("form-elements-dropdown"))) {
                this.model.showFormElementsList = false;
            }
            if (!elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("localization"))) {
                this.userService.showLocalizationPreview = false;
            }
            if (!elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("user-info"))) {
                this.userService.showUserInfo = false;
            }
            if (!elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("sti-dropdown-list"))) {
                this.dropdownService.showDropdownList = false;
            }
            if (!elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("tiered-menu-container"))) {
                this.model.showTieredMenu = false;
            }
            if (!elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("sti-dropdown-editor")) &&
                !elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("sti-dropdown-items"))) {
                this.model.hideActiveDropdown.next(true);
            }
            if (event.button == 0) {
                this.leftButtonDown = false;
            }
            if (!elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("autoComplete-list-container")) &&
                !elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("autoComplete-select-button"))) {
                this.model.hideActiveAutocompleteList.next(true);
            }
            if (!elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("home")) &&
                !elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("sti-dropdown-list"))) {
                let iframes = document.getElementsByTagName("iframe");
                if (iframes.length > 0) {
                    for (let index = 0; index < iframes.length; index++) {
                        const element = iframes[index].contentDocument || iframes[index].contentWindow.document;
                        if (element.getSelection().toString().length > 0) {
                            element.getSelection().removeAllRanges();
                        }
                    }
                }
            }
            this.model.lastFormState = null;
            this.captureMouseUp.next(event);
        }, true);
        /* document.addEventListener(
          "mousemove",
          (event) => {
            this.captureMouseUp.next(event);
          },
          true
        ); */
        document.addEventListener("mousemove", (event) => {
            this.documetMouseMove.next(event);
        });
        window.addEventListener("mousedown", (event) => {
            this.documetMouseDown.next(event);
        });
        window.addEventListener("mousedown", (event) => {
            if (this.editableSevice.usedElement &&
                this.model.selectedComponent &&
                this.model.selectedComponent.element != this.editableSevice.usedElement) {
                this.editableSevice.editableContent = null;
                this.editableSevice.usedElement = null;
            }
            if (event.button == 0) {
                this.leftButtonDown = true;
            }
            let elements = document.elementsFromPoint(event.clientX, event.clientY);
            if (this.model.showColorDialog && !this.model.showMoreColorDialog) {
                if (!elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("color-dialog"))) {
                    this.model.showColorDialog = false;
                }
            }
            if (this.model.showContextMenu) {
                let underContextMenu = false;
                for (let elem of document.elementsFromPoint(event.clientX, event.clientY)) {
                    if (elem === null || elem === void 0 ? void 0 : elem.classList.contains("context-menu")) {
                        underContextMenu = true;
                        break;
                    }
                }
                if (!underContextMenu) {
                    this.model.showContextMenu = false;
                }
            }
            if (this.signatureService.drawingMode) {
                let underCanvas = false;
                for (let elem of document.elementsFromPoint(event.clientX, event.clientY)) {
                    if (elem === null || elem === void 0 ? void 0 : elem.classList.contains("canvas")) {
                        underCanvas = true;
                        break;
                    }
                }
                if (!underCanvas) {
                    setTimeout(() => {
                        this.signatureService.drawingMode = false;
                    });
                }
            }
            if (this.signatureService.showFontsPreview) {
                if (!elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("fonts-preview-container"))) {
                    this.signatureService.showFontsPreview = false;
                }
            }
            if (this.signatureService.showSavedTemplates) {
                if (!elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("saved-templates-container")) &&
                    !elements.find((elem) => elem === null || elem === void 0 ? void 0 : elem.classList.contains("show-button"))) {
                    this.signatureService.showSavedTemplates = false;
                }
            }
            this.captureMouseDown.next(event);
        }, true);
    }
    getDocumentMouseUp() {
        return this.documetMouseUp.asObservable();
    }
    getDocumentMouseMove() {
        return this.documetMouseMove.asObservable();
    }
    getDocumentMouseDown() {
        return this.documetMouseDown.asObservable();
    }
    getCaptureMouseUp() {
        return this.captureMouseUp.asObservable();
    }
    getCaptureMouseDown() {
        return this.captureMouseDown.asObservable();
    }
    getDocumentTouchStart() {
        return this.documentTouchStart.asObservable();
    }
    getDocumentTouchMove() {
        return this.documentTouchMove.asObservable();
    }
    getDocumentTouchEnd() {
        return this.documentTouchEnd.asObservable();
    }
}
StiMouseService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiMouseService, deps: [{ token: StiModelService }, { token: StiEditableContentService }, { token: StiUserService }, { token: SignatureService }, { token: StiDropdownService }], target: i0.ɵɵFactoryTarget.Injectable });
StiMouseService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiMouseService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiMouseService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: StiModelService }, { type: StiEditableContentService }, { type: StiUserService }, { type: SignatureService }, { type: StiDropdownService }]; } });

class StiHelperService {
    constructor(model, render, loc, zone) {
        this.model = model;
        this.render = render;
        this.loc = loc;
        this.zone = zone;
        this._fonts = [];
        this._numberTypes = [];
        this._rangeFormats = [];
        this._signatureTypes = [];
        this._dateTimeTypes = [];
        this._buttonTypes = [];
        this._columnTypes = [];
        this._buttonSendTypes = [];
        this._thousandSeparators = [];
        this._barcodeTypes = [];
        this._dateTimeValues = [];
        this._themes = [];
        this._borderWeights = [];
        this._unitAlignment = [];
        this._minUnitAlignment = [];
        this._labelFormat = [];
        this._penStyles = [];
        this._algorithmExpressions = [];
        this._dateTimeFormats = [];
        this._dateFormats = [];
        this._timeFormats = [];
        this._signatureEditorModes = [];
        this._signatureSpecialFonts = [];
        this._fontSizes = [5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 18, 20, 22, 24, 26, 28, 36, 44, 58, 72];
        this._richTextFontSizes = [];
        this._errorCorrectionLevel = ["Level1", "Level2", "Level3", "Level4"];
        this._fileMenuItems = [];
        this._dataMatrixSize = [
            "Automatic",
            "v1",
            "v2",
            "v3",
            "v4",
            "v5",
            "v6",
            "v7",
            "v8",
            "v9",
            "v10",
            "v11",
            "v12",
            "v13",
            "v14",
            "v15",
            "v16",
            "v17",
            "v18",
            "v19",
            "v20",
            "v21",
            "v22",
            "v23",
            "v24",
            "v25",
            "v26",
            "v27",
            "v28",
            "v29",
            "v30",
            "v31",
            "v32",
            "v33",
            "v34",
            "v35",
            "v36",
            "v37",
            "v38",
            "v39",
            "v40",
        ];
        this._bodyShapeType = [
            "Square",
            "RoundedSquare",
            "Dot",
            "Circle",
            "Diamond",
            "Star",
            "ZebraHorizontal",
            "ZebraVertical",
            "ZebraCross1",
            "ZebraCross2",
            "Circular",
            "DockedDiamonds",
        ];
        this._eyeFrameShapeType = ["Square", "Dots", "Circle", "Round", "Round1", "Round3"];
        this._eyeBallShapeType = [
            "Square",
            "Dots",
            "Circle",
            "Round",
            "Round1",
            "Round3",
            "Star",
            "ZebraHorizontal",
            "ZebraVertical",
        ];
        this._brushIdent = ["Empty", "Solid", "Gradient", "Glare", "Glass", "Hatch", "Default", "Style"];
        this._bodyBrush = ["Empty", "Solid", "Hatch", "Gradient", "Glare", "Glass"];
        this.hatchStyle = [
            { name: "Horizontal", value: 0 },
            { name: "Vertical", value: 1 },
            { name: "ForwardDiagonal", value: 2 },
            { name: "BackwardDiagonal", value: 3 },
            { name: "Cross", value: 4 },
            { name: "DiagonalCross", value: 5 },
            { name: "Percent05", value: 6 },
            { name: "Percent10", value: 7 },
            { name: "Percent20", value: 8 },
            { name: "Percent25", value: 9 },
            { name: "Percent30", value: 10 },
            { name: "Percent40", value: 11 },
            { name: "Percent50", value: 12 },
            { name: "Percent60", value: 13 },
            { name: "Percent70", value: 14 },
            { name: "Percent75", value: 0xf },
            { name: "Percent80", value: 0x10 },
            { name: "Percent90", value: 17 },
            { name: "LightDownwardDiagonal", value: 18 },
            { name: "LightUpwardDiagonal", value: 19 },
            { name: "DarkDownwardDiagonal", value: 20 },
            { name: "DarkUpwardDiagonal", value: 21 },
            { name: "WideDownwardDiagonal", value: 22 },
            { name: "WideUpwardDiagonal", value: 23 },
            { name: "LightVertical", value: 24 },
            { name: "LightHorizontal", value: 25 },
            { name: "NarrowVertical", value: 26 },
            { name: "NarrowHorizontal", value: 27 },
            { name: "DarkVertical", value: 28 },
            { name: "DarkHorizontal", value: 29 },
            { name: "DashedDownwardDiagonal", value: 30 },
            { name: "DashedUpwardDiagonal", value: 0x1f },
            { name: "DashedHorizontal", value: 0x20 },
            { name: "DashedVertical", value: 33 },
            { name: "SmallConfetti", value: 34 },
            { name: "LargeConfetti", value: 35 },
            { name: "ZigZag", value: 36 },
            { name: "Wave", value: 37 },
            { name: "DiagonalBrick", value: 38 },
            { name: "HorizontalBrick", value: 39 },
            { name: "Weave", value: 40 },
            { name: "Plaid", value: 41 },
            { name: "Divot", value: 42 },
            { name: "DottedGrid", value: 43 },
            { name: "DottedDiamond", value: 44 },
            { name: "Shingle", value: 45 },
            { name: "Trellis", value: 46 },
            { name: "Sphere", value: 47 },
            { name: "SmallGrid", value: 48 },
            { name: "SmallCheckerBoard", value: 49 },
            { name: "LargeCheckerBoard", value: 50 },
            { name: "OutlinedDiamond", value: 51 },
            { name: "SolidDiamond", value: 52 },
            { name: "LargeGrid", value: 4 },
            { name: "Min", value: 0 },
            { name: "Max", value: 4 },
        ];
        this.pageElement = new StiFormPageElement();
        this.justifyOptions = [
            {
                image: "images.Properties.AlignLeft.png",
                value: 1,
                name: "Left",
            },
            {
                image: "images.Properties.AlignCenter.png",
                value: 2,
                name: "Center",
            },
            {
                image: "images.Properties.AlignRight.png",
                value: 3,
                name: "Right",
            },
        ];
        this.labelAlignment = [
            {
                image: "images.Properties.Left.png",
                value: 1,
                name: "Left",
            },
            {
                image: "images.Properties.Right.png",
                value: 2,
                name: "Right",
            },
            {
                image: "images.Properties.Top.png",
                value: 3,
                name: "Top",
            },
        ];
        this.verticalAlignment = [
            {
                image: "images.Properties.AlignTop.png",
                value: 1,
                name: "Top",
            },
            {
                image: "images.Properties.AlignMiddle.png",
                value: 2,
                name: "Center",
            },
            {
                image: "images.Properties.AlignBottom.png",
                value: 3,
                name: "Bottom",
            },
        ];
        this.styleOptions = [
            {
                name: "B",
                value: "Bold",
                image: "images.Properties.FontStyleBold.png",
            },
            {
                name: "I",
                value: "Italic",
                image: "images.Properties.FontStyleItalic.png",
            },
            {
                name: "U",
                value: "Underline",
                image: "images.Properties.FontStyleUnderline.png",
            },
        ];
        this.countries = [
            { name: "Afghanistan", code: "AF" },
            { name: "Åland Islands", code: "AX" },
            { name: "Albania", code: "AL" },
            { name: "Algeria", code: "DZ" },
            { name: "American Samoa", code: "AS" },
            { name: "AndorrA", code: "AD" },
            { name: "Angola", code: "AO" },
            { name: "Anguilla", code: "AI" },
            { name: "Antarctica", code: "AQ" },
            { name: "Antigua and Barbuda", code: "AG" },
            { name: "Argentina", code: "AR" },
            { name: "Armenia", code: "AM" },
            { name: "Aruba", code: "AW" },
            { name: "Australia", code: "AU" },
            { name: "Austria", code: "AT" },
            { name: "Azerbaijan", code: "AZ" },
            { name: "Bahamas", code: "BS" },
            { name: "Bahrain", code: "BH" },
            { name: "Bangladesh", code: "BD" },
            { name: "Barbados", code: "BB" },
            { name: "Belarus", code: "BY" },
            { name: "Belgium", code: "BE" },
            { name: "Belize", code: "BZ" },
            { name: "Benin", code: "BJ" },
            { name: "Bermuda", code: "BM" },
            { name: "Bhutan", code: "BT" },
            { name: "Bolivia", code: "BO" },
            { name: "Bosnia and Herzegovina", code: "BA" },
            { name: "Botswana", code: "BW" },
            { name: "Bouvet Island", code: "BV" },
            { name: "Brazil", code: "BR" },
            { name: "British Indian Ocean Territory", code: "IO" },
            { name: "Brunei Darussalam", code: "BN" },
            { name: "Bulgaria", code: "BG" },
            { name: "Burkina Faso", code: "BF" },
            { name: "Burundi", code: "BI" },
            { name: "Cambodia", code: "KH" },
            { name: "Cameroon", code: "CM" },
            { name: "Canada", code: "CA" },
            { name: "Cape Verde", code: "CV" },
            { name: "Cayman Islands", code: "KY" },
            { name: "Central African Republic", code: "CF" },
            { name: "Chad", code: "TD" },
            { name: "Chile", code: "CL" },
            { name: "China", code: "CN" },
            { name: "Christmas Island", code: "CX" },
            { name: "Cocos (Keeling) Islands", code: "CC" },
            { name: "Colombia", code: "CO" },
            { name: "Comoros", code: "KM" },
            { name: "Congo", code: "CG" },
            { name: "Congo, The Democratic Republic of the", code: "CD" },
            { name: "Cook Islands", code: "CK" },
            { name: "Costa Rica", code: "CR" },
            { name: "Cote D'Ivoire", code: "CI" },
            { name: "Croatia", code: "HR" },
            { name: "Cuba", code: "CU" },
            { name: "Cyprus", code: "CY" },
            { name: "Czech Republic", code: "CZ" },
            { name: "Denmark", code: "DK" },
            { name: "Djibouti", code: "DJ" },
            { name: "Dominica", code: "DM" },
            { name: "Dominican Republic", code: "DO" },
            { name: "Ecuador", code: "EC" },
            { name: "Egypt", code: "EG" },
            { name: "El Salvador", code: "SV" },
            { name: "Equatorial Guinea", code: "GQ" },
            { name: "Eritrea", code: "ER" },
            { name: "Estonia", code: "EE" },
            { name: "Ethiopia", code: "ET" },
            { name: "Falkland Islands (Malvinas)", code: "FK" },
            { name: "Faroe Islands", code: "FO" },
            { name: "Fiji", code: "FJ" },
            { name: "Finland", code: "FI" },
            { name: "France", code: "FR" },
            { name: "French Guiana", code: "GF" },
            { name: "French Polynesia", code: "PF" },
            { name: "French Southern Territories", code: "TF" },
            { name: "Gabon", code: "GA" },
            { name: "Gambia", code: "GM" },
            { name: "Georgia", code: "GE" },
            { name: "Germany", code: "DE" },
            { name: "Ghana", code: "GH" },
            { name: "Gibraltar", code: "GI" },
            { name: "Greece", code: "GR" },
            { name: "Greenland", code: "GL" },
            { name: "Grenada", code: "GD" },
            { name: "Guadeloupe", code: "GP" },
            { name: "Guam", code: "GU" },
            { name: "Guatemala", code: "GT" },
            { name: "Guernsey", code: "GG" },
            { name: "Guinea", code: "GN" },
            { name: "Guinea-Bissau", code: "GW" },
            { name: "Guyana", code: "GY" },
            { name: "Haiti", code: "HT" },
            { name: "Heard Island and Mcdonald Islands", code: "HM" },
            { name: "Holy See (Vatican City State)", code: "VA" },
            { name: "Honduras", code: "HN" },
            { name: "Hong Kong", code: "HK" },
            { name: "Hungary", code: "HU" },
            { name: "Iceland", code: "IS" },
            { name: "India", code: "IN" },
            { name: "Indonesia", code: "ID" },
            { name: "Iran, Islamic Republic Of", code: "IR" },
            { name: "Iraq", code: "IQ" },
            { name: "Ireland", code: "IE" },
            { name: "Isle of Man", code: "IM" },
            { name: "Israel", code: "IL" },
            { name: "Italy", code: "IT" },
            { name: "Jamaica", code: "JM" },
            { name: "Japan", code: "JP" },
            { name: "Jersey", code: "JE" },
            { name: "Jordan", code: "JO" },
            { name: "Kazakhstan", code: "KZ" },
            { name: "Kenya", code: "KE" },
            { name: "Kiribati", code: "KI" },
            { name: "Korea, Democratic People'S Republic of", code: "KP" },
            { name: "Korea, Republic of", code: "KR" },
            { name: "Kuwait", code: "KW" },
            { name: "Kyrgyzstan", code: "KG" },
            { name: "Lao People'S Democratic Republic", code: "LA" },
            { name: "Latvia", code: "LV" },
            { name: "Lebanon", code: "LB" },
            { name: "Lesotho", code: "LS" },
            { name: "Liberia", code: "LR" },
            { name: "Libyan Arab Jamahiriya", code: "LY" },
            { name: "Liechtenstein", code: "LI" },
            { name: "Lithuania", code: "LT" },
            { name: "Luxembourg", code: "LU" },
            { name: "Macao", code: "MO" },
            { name: "Macedonia, The Former Yugoslav Republic of", code: "MK" },
            { name: "Madagascar", code: "MG" },
            { name: "Malawi", code: "MW" },
            { name: "Malaysia", code: "MY" },
            { name: "Maldives", code: "MV" },
            { name: "Mali", code: "ML" },
            { name: "Malta", code: "MT" },
            { name: "Marshall Islands", code: "MH" },
            { name: "Martinique", code: "MQ" },
            { name: "Mauritania", code: "MR" },
            { name: "Mauritius", code: "MU" },
            { name: "Mayotte", code: "YT" },
            { name: "Mexico", code: "MX" },
            { name: "Micronesia, Federated States of", code: "FM" },
            { name: "Moldova, Republic of", code: "MD" },
            { name: "Monaco", code: "MC" },
            { name: "Mongolia", code: "MN" },
            { name: "Montserrat", code: "MS" },
            { name: "Morocco", code: "MA" },
            { name: "Mozambique", code: "MZ" },
            { name: "Myanmar", code: "MM" },
            { name: "Namibia", code: "NA" },
            { name: "Nauru", code: "NR" },
            { name: "Nepal", code: "NP" },
            { name: "Netherlands", code: "NL" },
            { name: "Netherlands Antilles", code: "AN" },
            { name: "New Caledonia", code: "NC" },
            { name: "New Zealand", code: "NZ" },
            { name: "Nicaragua", code: "NI" },
            { name: "Niger", code: "NE" },
            { name: "Nigeria", code: "NG" },
            { name: "Niue", code: "NU" },
            { name: "Norfolk Island", code: "NF" },
            { name: "Northern Mariana Islands", code: "MP" },
            { name: "Norway", code: "NO" },
            { name: "Oman", code: "OM" },
            { name: "Pakistan", code: "PK" },
            { name: "Palau", code: "PW" },
            { name: "Palestinian Territory, Occupied", code: "PS" },
            { name: "Panama", code: "PA" },
            { name: "Papua New Guinea", code: "PG" },
            { name: "Paraguay", code: "PY" },
            { name: "Peru", code: "PE" },
            { name: "Philippines", code: "PH" },
            { name: "Pitcairn", code: "PN" },
            { name: "Poland", code: "PL" },
            { name: "Portugal", code: "PT" },
            { name: "Puerto Rico", code: "PR" },
            { name: "Qatar", code: "QA" },
            { name: "Reunion", code: "RE" },
            { name: "Romania", code: "RO" },
            { name: "Russian Federation", code: "RU" },
            { name: "RWANDA", code: "RW" },
            { name: "Saint Helena", code: "SH" },
            { name: "Saint Kitts and Nevis", code: "KN" },
            { name: "Saint Lucia", code: "LC" },
            { name: "Saint Pierre and Miquelon", code: "PM" },
            { name: "Saint Vincent and the Grenadines", code: "VC" },
            { name: "Samoa", code: "WS" },
            { name: "San Marino", code: "SM" },
            { name: "Sao Tome and Principe", code: "ST" },
            { name: "Saudi Arabia", code: "SA" },
            { name: "Senegal", code: "SN" },
            { name: "Serbia and Montenegro", code: "CS" },
            { name: "Seychelles", code: "SC" },
            { name: "Sierra Leone", code: "SL" },
            { name: "Singapore", code: "SG" },
            { name: "Slovakia", code: "SK" },
            { name: "Slovenia", code: "SI" },
            { name: "Solomon Islands", code: "SB" },
            { name: "Somalia", code: "SO" },
            { name: "South Africa", code: "ZA" },
            { name: "South Georgia and the South Sandwich Islands", code: "GS" },
            { name: "Spain", code: "ES" },
            { name: "Sri Lanka", code: "LK" },
            { name: "Sudan", code: "SD" },
            { name: "Suriname", code: "SR" },
            { name: "Svalbard and Jan Mayen", code: "SJ" },
            { name: "Swaziland", code: "SZ" },
            { name: "Sweden", code: "SE" },
            { name: "Switzerland", code: "CH" },
            { name: "Syrian Arab Republic", code: "SY" },
            { name: "Taiwan, Province of China", code: "TW" },
            { name: "Tajikistan", code: "TJ" },
            { name: "Tanzania, United Republic of", code: "TZ" },
            { name: "Thailand", code: "TH" },
            { name: "Timor-Leste", code: "TL" },
            { name: "Togo", code: "TG" },
            { name: "Tokelau", code: "TK" },
            { name: "Tonga", code: "TO" },
            { name: "Trinidad and Tobago", code: "TT" },
            { name: "Tunisia", code: "TN" },
            { name: "Turkey", code: "TR" },
            { name: "Turkmenistan", code: "TM" },
            { name: "Turks and Caicos Islands", code: "TC" },
            { name: "Tuvalu", code: "TV" },
            { name: "Uganda", code: "UG" },
            { name: "Ukraine", code: "UA" },
            { name: "United Arab Emirates", code: "AE" },
            { name: "United Kingdom", code: "GB" },
            { name: "United States", code: "US" },
            { name: "United States Minor Outlying Islands", code: "UM" },
            { name: "Uruguay", code: "UY" },
            { name: "Uzbekistan", code: "UZ" },
            { name: "Vanuatu", code: "VU" },
            { name: "Venezuela", code: "VE" },
            { name: "Viet Nam", code: "VN" },
            { name: "Virgin Islands, British", code: "VG" },
            { name: "Virgin Islands, U.S.", code: "VI" },
            { name: "Wallis and Futuna", code: "WF" },
            { name: "Western Sahara", code: "EH" },
            { name: "Yemen", code: "YE" },
            { name: "Zambia", code: "ZM" },
            { name: "Zimbabwe", code: "ZW" },
        ];
        this.currencyInfo = [
            {
                englishName: "Afghan Afghani (\u060B)",
                nativeName: "\u0627\u0641\u063A\u0627\u0646\u06CC \u0627\u0641\u063A\u0627\u0646\u0633\u062A\u0627\u0646",
                code: "AFN",
                symbol: "\u060B",
            },
            {
                englishName: "Albanian Lek (Lek\u00EB)",
                nativeName: "Leku shqiptar",
                code: "ALL",
                symbol: "Lek\u00EB",
            },
            {
                englishName: "Algerian Dinar (\u062F.\u062C.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u062C\u0632\u0627\u0626\u0631\u064A",
                code: "DZD",
                symbol: "\u062F.\u062C.\u200F",
            },
            {
                englishName: "Angolan Kwanza (Kz)",
                nativeName: "Kwanza ya Ang\u00F3la",
                code: "AOA",
                symbol: "Kz",
            },
            {
                englishName: "Argentine Peso ($)",
                nativeName: "peso argentino",
                code: "ARS",
                symbol: "$",
            },
            {
                englishName: "Armenian Dram (\u058F)",
                nativeName: "\u0570\u0561\u0575\u056F\u0561\u056F\u0561\u0576 \u0564\u0580\u0561\u0574",
                code: "AMD",
                symbol: "\u058F",
            },
            {
                englishName: "Aruban Florin (Afl.)",
                nativeName: "Arubaanse gulden",
                code: "AWG",
                symbol: "Afl.",
            },
            {
                englishName: "Australian Dollar ($)",
                nativeName: "Australian Dollar",
                code: "AUD",
                symbol: "$",
            },
            {
                englishName: "Azerbaijani Manat (\u20BC)",
                nativeName: "AZN",
                code: "AZN",
                symbol: "\u20BC",
            },
            {
                englishName: "Bahamian Dollar ($)",
                nativeName: "Bahamian Dollar",
                code: "BSD",
                symbol: "$",
            },
            {
                englishName: "Bahraini Dinar (\u062F.\u0628.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0628\u062D\u0631\u064A\u0646\u064A",
                code: "BHD",
                symbol: "\u062F.\u0628.\u200F",
            },
            {
                englishName: "Bangladeshi Taka (\u09F3)",
                nativeName: "\u09AC\u09BE\u0982\u09B2\u09BE\u09A6\u09C7\u09B6\u09C0 \u099F\u09BE\u0995\u09BE",
                code: "BDT",
                symbol: "\u09F3",
            },
            {
                englishName: "Barbadian Dollar ($)",
                nativeName: "Barbadian Dollar",
                code: "BBD",
                symbol: "$",
            },
            {
                englishName: "Belarusian Ruble (Br)",
                nativeName: "\u0431\u0435\u043B\u0430\u0440\u0443\u0441\u043A\u0456 \u0440\u0443\u0431\u0435\u043B\u044C",
                code: "BYN",
                symbol: "Br",
            },
            {
                englishName: "Belize Dollar ($)",
                nativeName: "Belize Dollar",
                code: "BZD",
                symbol: "$",
            },
            {
                englishName: "Bermudan Dollar ($)",
                nativeName: "Bermudan Dollar",
                code: "BMD",
                symbol: "$",
            },
            {
                englishName: "Bhutanese Ngultrum (Nu.)",
                nativeName: "\u0F51\u0F44\u0F74\u0F63\u0F0B\u0F40\u0FB2\u0F58",
                code: "BTN",
                symbol: "Nu.",
            },
            {
                englishName: "Bolivian Boliviano (Bs)",
                nativeName: "boliviano",
                code: "BOB",
                symbol: "Bs",
            },
            {
                englishName: "Bosnia-Herzegovina Convertible Mark (\u041A\u041C)",
                nativeName: "\u041A\u043E\u043D\u0432\u0435\u0440\u0442\u0438\u0431\u0438\u043B\u043D\u0430 \u043C\u0430\u0440\u043A\u0430",
                code: "BAM",
                symbol: "\u041A\u041C",
            },
            {
                englishName: "Botswanan Pula (P)",
                nativeName: "Botswanan Pula",
                code: "BWP",
                symbol: "P",
            },
            {
                englishName: "Brazilian Real (R$)",
                nativeName: "real brasile\u00F1o",
                code: "BRL",
                symbol: "R$",
            },
            {
                englishName: "British Pound (\u00A3)",
                nativeName: "Punt Prydain",
                code: "GBP",
                symbol: "\u00A3",
            },
            {
                englishName: "Brunei Dollar ($)",
                nativeName: "Dolar Brunei",
                code: "BND",
                symbol: "$",
            },
            {
                englishName: "Bulgarian Lev (\u043B\u0432.)",
                nativeName: "\u0411\u044A\u043B\u0433\u0430\u0440\u0441\u043A\u0438 \u043B\u0435\u0432",
                code: "BGN",
                symbol: "\u043B\u0432.",
            },
            {
                englishName: "Burundian Franc (FBu)",
                nativeName: "Burundian Franc",
                code: "BIF",
                symbol: "FBu",
            },
            {
                englishName: "Cambodian Riel (\u17DB)",
                nativeName: "\u179A\u17C0\u179B\u200B\u1780\u1798\u17D2\u1796\u17BB\u1787\u17B6",
                code: "KHR",
                symbol: "\u17DB",
            },
            {
                englishName: "Canadian Dollar ($)",
                nativeName: "Canadian Dollar",
                code: "CAD",
                symbol: "$",
            },
            {
                englishName: "Cape Verdean Escudo (\u200B)",
                nativeName: "Skudu Kabuverdianu",
                code: "CVE",
                symbol: "\u200B",
            },
            {
                englishName: "Cayman Islands Dollar ($)",
                nativeName: "Cayman Islands Dollar",
                code: "KYD",
                symbol: "$",
            },
            {
                englishName: "Central African CFA Franc (FCFA)",
                nativeName: "CFA F\u00E0l\u00E2\u014B BEAC",
                code: "XAF",
                symbol: "FCFA",
            },
            {
                englishName: "CFP Franc (FCFP)",
                nativeName: "franc CFP",
                code: "XPF",
                symbol: "FCFP",
            },
            {
                englishName: "Chilean Peso (CLP)",
                nativeName: "CLP",
                code: "CLP",
                symbol: "CLP",
            },
            {
                englishName: "Chinese Yuan (\u00A5)",
                nativeName: "\u0F61\u0F74\u0F0B\u0F68\u0F53\u0F0B",
                code: "CNY",
                symbol: "\u00A5",
            },
            {
                englishName: "Colombian Peso ($)",
                nativeName: "peso colombiano",
                code: "COP",
                symbol: "$",
            },
            {
                englishName: "Comorian Franc (CF)",
                nativeName: "\u0641\u0631\u0646\u0643 \u062C\u0632\u0631 \u0627\u0644\u0642\u0645\u0631",
                code: "KMF",
                symbol: "CF",
            },
            {
                englishName: "Congolese Franc (FC)",
                nativeName: "franc congolais",
                code: "CDF",
                symbol: "FC",
            },
            {
                englishName: "Costa Rican Col\u00F3n (\u20A1)",
                nativeName: "col\u00F3n costarricense",
                code: "CRC",
                symbol: "\u20A1",
            },
            {
                englishName: "Croatian Kuna (HRK)",
                nativeName: "hrvatska kuna",
                code: "HRK",
                symbol: "HRK",
            },
            {
                englishName: "Cuban Peso ($)",
                nativeName: "peso cubano",
                code: "CUP",
                symbol: "$",
            },
            {
                englishName: "Czech Koruna (K\u010D)",
                nativeName: "\u010Desk\u00E1 koruna",
                code: "CZK",
                symbol: "K\u010D",
            },
            {
                englishName: "Danish Krone (kr.)",
                nativeName: "dansk krone",
                code: "DKK",
                symbol: "kr.",
            },
            {
                englishName: "Djiboutian Franc (Fdj)",
                nativeName: "DJF",
                code: "DJF",
                symbol: "Fdj",
            },
            {
                englishName: "Dominican Peso (RD$)",
                nativeName: "peso dominicano",
                code: "DOP",
                symbol: "RD$",
            },
            {
                englishName: "East Caribbean Dollar ($)",
                nativeName: "East Caribbean Dollar",
                code: "XCD",
                symbol: "$",
            },
            {
                englishName: "Egyptian Pound (\u062C.\u0645.\u200F)",
                nativeName: "\u062C\u0646\u064A\u0647 \u0645\u0635\u0631\u064A",
                code: "EGP",
                symbol: "\u062C.\u0645.\u200F",
            },
            {
                englishName: "Eritrean Nakfa (Nfk)",
                nativeName: "ERN",
                code: "ERN",
                symbol: "Nfk",
            },
            {
                englishName: "Ethiopian Birr (Br)",
                nativeName: "ETB",
                code: "ETB",
                symbol: "Br",
            },
            {
                englishName: "Euro (\u20AC)",
                nativeName: "euro",
                code: "EUR",
                symbol: "\u20AC",
            },
            {
                englishName: "Falkland Islands Pound (\u00A3)",
                nativeName: "Falkland Islands Pound",
                code: "FKP",
                symbol: "\u00A3",
            },
            {
                englishName: "Fijian Dollar ($)",
                nativeName: "Fijian Dollar",
                code: "FJD",
                symbol: "$",
            },
            {
                englishName: "Gambian Dalasi (D)",
                nativeName: "Gambian Dalasi",
                code: "GMD",
                symbol: "D",
            },
            {
                englishName: "Georgian Lari (\u20BE)",
                nativeName: "\u10E5\u10D0\u10E0\u10D7\u10E3\u10DA\u10D8 \u10DA\u10D0\u10E0\u10D8",
                code: "GEL",
                symbol: "\u20BE",
            },
            {
                englishName: "Ghanaian Cedi (GH\u20B5)",
                nativeName: "Ghana Sidi",
                code: "GHS",
                symbol: "GH\u20B5",
            },
            {
                englishName: "Gibraltar Pound (\u00A3)",
                nativeName: "Gibraltar Pound",
                code: "GIP",
                symbol: "\u00A3",
            },
            {
                englishName: "Guatemalan Quetzal (Q)",
                nativeName: "quetzal",
                code: "GTQ",
                symbol: "Q",
            },
            {
                englishName: "Guinean Franc (FG)",
                nativeName: "GNF",
                code: "GNF",
                symbol: "FG",
            },
            {
                englishName: "Guyanaese Dollar ($)",
                nativeName: "Guyanaese Dollar",
                code: "GYD",
                symbol: "$",
            },
            {
                englishName: "Haitian Gourde (G)",
                nativeName: "gourde ha\u00EFtienne",
                code: "HTG",
                symbol: "G",
            },
            {
                englishName: "Honduran Lempira (L)",
                nativeName: "lempira hondure\u00F1o",
                code: "HNL",
                symbol: "L",
            },
            {
                englishName: "Hong Kong Dollar (HK$)",
                nativeName: "Hong Kong Dollar",
                code: "HKD",
                symbol: "HK$",
            },
            {
                englishName: "Hungarian Forint (Ft)",
                nativeName: "magyar forint",
                code: "HUF",
                symbol: "Ft",
            },
            {
                englishName: "Icelandic Kr\u00F3na (ISK)",
                nativeName: "\u00EDslensk kr\u00F3na",
                code: "ISK",
                symbol: "ISK",
            },
            {
                englishName: "Indian Rupee (\u20B9)",
                nativeName: "\u09AD\u09BE\u09F0\u09A4\u09C0\u09AF\u09BC \u09F0\u09C1\u09AA\u09C0",
                code: "INR",
                symbol: "\u20B9",
            },
            {
                englishName: "Indonesian Rupiah (Rp)",
                nativeName: "Rupiah Indonesia",
                code: "IDR",
                symbol: "Rp",
            },
            {
                englishName: "Iranian Rial (IRR)",
                nativeName: "IRR",
                code: "IRR",
                symbol: "IRR",
            },
            {
                englishName: "Iraqi Dinar (\u062F.\u0639.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0639\u0631\u0627\u0642\u064A",
                code: "IQD",
                symbol: "\u062F.\u0639.\u200F",
            },
            {
                englishName: "Israeli New Shekel (\u20AA)",
                nativeName: "\u0634\u064A\u0643\u0644 \u0625\u0633\u0631\u0627\u0626\u064A\u0644\u064A \u062C\u062F\u064A\u062F",
                code: "ILS",
                symbol: "\u20AA",
            },
            {
                englishName: "Jamaican Dollar ($)",
                nativeName: "Jamaican Dollar",
                code: "JMD",
                symbol: "$",
            },
            {
                englishName: "Japanese Yen (\uFFE5)",
                nativeName: "\u65E5\u672C\u5186",
                code: "JPY",
                symbol: "\uFFE5",
            },
            {
                englishName: "Jordanian Dinar (\u062F.\u0623.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0623\u0631\u062F\u0646\u064A",
                code: "JOD",
                symbol: "\u062F.\u0623.\u200F",
            },
            {
                englishName: "Kazakhstani Tenge (\u20B8)",
                nativeName: "\u049A\u0430\u0437\u0430\u049B\u0441\u0442\u0430\u043D \u0442\u0435\u04A3\u0433\u0435\u0441\u0456",
                code: "KZT",
                symbol: "\u20B8",
            },
            {
                englishName: "Kenyan Shilling (Ksh)",
                nativeName: "Shilingi ya Kenya",
                code: "KES",
                symbol: "Ksh",
            },
            {
                englishName: "Kuwaiti Dinar (\u062F.\u0643.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0643\u0648\u064A\u062A\u064A",
                code: "KWD",
                symbol: "\u062F.\u0643.\u200F",
            },
            {
                englishName: "Kyrgystani Som (\u0441\u043E\u043C)",
                nativeName: "\u041A\u044B\u0440\u0433\u044B\u0437\u0441\u0442\u0430\u043D \u0441\u043E\u043C\u0443",
                code: "KGS",
                symbol: "\u0441\u043E\u043C",
            },
            {
                englishName: "Laotian Kip (\u20AD)",
                nativeName: "\u0EA5\u0EB2\u0EA7 \u0E81\u0EB5\u0E9A",
                code: "LAK",
                symbol: "\u20AD",
            },
            {
                englishName: "Lebanese Pound (\u0644.\u0644.\u200F)",
                nativeName: "\u062C\u0646\u064A\u0647 \u0644\u0628\u0646\u0627\u0646\u064A",
                code: "LBP",
                symbol: "\u0644.\u0644.\u200F",
            },
            {
                englishName: "Liberian Dollar ($)",
                nativeName: "Liberian Dollar",
                code: "LRD",
                symbol: "$",
            },
            {
                englishName: "Libyan Dinar (\u062F.\u0644.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0644\u064A\u0628\u064A",
                code: "LYD",
                symbol: "\u062F.\u0644.\u200F",
            },
            {
                englishName: "Macanese Pataca (MOP$)",
                nativeName: "Macanese Pataca",
                code: "MOP",
                symbol: "MOP$",
            },
            {
                englishName: "Macedonian Denar (\u0434\u0435\u043D)",
                nativeName: "\u041C\u0430\u043A\u0435\u0434\u043E\u043D\u0441\u043A\u0438 \u0434\u0435\u043D\u0430\u0440",
                code: "MKD",
                symbol: "\u0434\u0435\u043D",
            },
            {
                englishName: "Malagasy Ariary (Ar)",
                nativeName: "Malagasy Ariary",
                code: "MGA",
                symbol: "Ar",
            },
            {
                englishName: "Malawian Kwacha (MK)",
                nativeName: "Malawian Kwacha",
                code: "MWK",
                symbol: "MK",
            },
            {
                englishName: "Malaysian Ringgit (RM)",
                nativeName: "Malaysian Ringgit",
                code: "MYR",
                symbol: "RM",
            },
            {
                englishName: "Maldivian Rufiyaa (\u0783.)",
                nativeName: "MVR",
                code: "MVR",
                symbol: "\u0783.",
            },
            {
                englishName: "Mauritanian Ouguiya (\u0623.\u0645.)",
                nativeName: "\u0623\u0648\u0642\u064A\u0629 \u0645\u0648\u0631\u064A\u062A\u0627\u0646\u064A\u0629",
                code: "MRU",
                symbol: "\u0623.\u0645.",
            },
            {
                englishName: "Mauritian Rupee (Rs)",
                nativeName: "Mauritian Rupee",
                code: "MUR",
                symbol: "Rs",
            },
            {
                englishName: "Mexican Peso ($)",
                nativeName: "peso mexicano",
                code: "MXN",
                symbol: "$",
            },
            {
                englishName: "Moldovan Leu (L)",
                nativeName: "leu moldovenesc",
                code: "MDL",
                symbol: "L",
            },
            {
                englishName: "Mongolian Tugrik (\u20AE)",
                nativeName: "\u0442\u04E9\u0433\u0440\u04E9\u0433",
                code: "MNT",
                symbol: "\u20AE",
            },
            {
                englishName: "Moroccan Dirham (\u062F.\u0645.\u200F)",
                nativeName: "\u062F\u0631\u0647\u0645 \u0645\u063A\u0631\u0628\u064A",
                code: "MAD",
                symbol: "\u062F.\u0645.\u200F",
            },
            {
                englishName: "Mozambican Metical (MTn)",
                nativeName: "MZN",
                code: "MZN",
                symbol: "MTn",
            },
            {
                englishName: "Myanmar Kyat (K)",
                nativeName: "\u1019\u103C\u1014\u103A\u1019\u102C \u1000\u103B\u1015\u103A",
                code: "MMK",
                symbol: "K",
            },
            {
                englishName: "Namibian Dollar ($)",
                nativeName: "Namibiese dollar",
                code: "NAD",
                symbol: "$",
            },
            {
                englishName: "Nepalese Rupee (\u0928\u0947\u0930\u0942)",
                nativeName: "\u0928\u0947\u092A\u093E\u0932\u0940 \u0930\u0942\u092A\u0948\u092F\u093E\u0901",
                code: "NPR",
                symbol: "\u0928\u0947\u0930\u0942",
            },
            {
                englishName: "Netherlands Antillean Guilder (NAf.)",
                nativeName: "Netherlands Antillean Guilder",
                code: "ANG",
                symbol: "NAf.",
            },
            {
                englishName: "New Taiwan Dollar ($)",
                nativeName: "\u65B0\u53F0\u5E63",
                code: "TWD",
                symbol: "$",
            },
            {
                englishName: "New Zealand Dollar ($)",
                nativeName: "New Zealand Dollar",
                code: "NZD",
                symbol: "$",
            },
            {
                englishName: "Nicaraguan C\u00F3rdoba (C$)",
                nativeName: "c\u00F3rdoba nicarag\u00FCense",
                code: "NIO",
                symbol: "C$",
            },
            {
                englishName: "Nigerian Naira (\u20A6)",
                nativeName: "Nigerian Naira",
                code: "NGN",
                symbol: "\u20A6",
            },
            {
                englishName: "North Korean Won (KPW)",
                nativeName: "\uC870\uC120 \uBBFC\uC8FC\uC8FC\uC758 \uC778\uBBFC \uACF5\uD654\uAD6D \uC6D0",
                code: "KPW",
                symbol: "KPW",
            },
            {
                englishName: "Norwegian Krone (kr)",
                nativeName: "norske kroner",
                code: "NOK",
                symbol: "kr",
            },
            {
                englishName: "Omani Rial (\u0631.\u0639.\u200F)",
                nativeName: "\u0631\u064A\u0627\u0644 \u0639\u0645\u0627\u0646\u064A",
                code: "OMR",
                symbol: "\u0631.\u0639.\u200F",
            },
            {
                englishName: "Pakistani Rupee (Rs)",
                nativeName: "Pakistani Rupee",
                code: "PKR",
                symbol: "Rs",
            },
            {
                englishName: "Panamanian Balboa (B/.)",
                nativeName: "balboa paname\u00F1o",
                code: "PAB",
                symbol: "B/.",
            },
            {
                englishName: "Papua New Guinean Kina (K)",
                nativeName: "Papua New Guinean Kina",
                code: "PGK",
                symbol: "K",
            },
            {
                englishName: "Paraguayan Guarani (Gs.)",
                nativeName: "guaran\u00ED paraguayo",
                code: "PYG",
                symbol: "Gs.",
            },
            {
                englishName: "Peruvian Sol (S/)",
                nativeName: "sol peruano",
                code: "PEN",
                symbol: "S/",
            },
            {
                englishName: "Philippine Piso (\u20B1)",
                nativeName: "PHP",
                code: "PHP",
                symbol: "\u20B1",
            },
            {
                englishName: "Polish Zloty (z\u0142)",
                nativeName: "z\u0142oty polski",
                code: "PLN",
                symbol: "z\u0142",
            },
            {
                englishName: "Qatari Rial (\u0631.\u0642.\u200F)",
                nativeName: "\u0631\u064A\u0627\u0644 \u0642\u0637\u0631\u064A",
                code: "QAR",
                symbol: "\u0631.\u0642.\u200F",
            },
            {
                englishName: "Romanian Leu (RON)",
                nativeName: "leu rom\u00E2nesc",
                code: "RON",
                symbol: "RON",
            },
            {
                englishName: "Russian Ruble (RUB)",
                nativeName: "RUB",
                code: "RUB",
                symbol: "RUB",
            },
            {
                englishName: "Rwandan Franc (RF)",
                nativeName: "Rwandan Franc",
                code: "RWF",
                symbol: "RF",
            },
            {
                englishName: "Samoan Tala (WS$)",
                nativeName: "Samoan Tala",
                code: "WST",
                symbol: "WS$",
            },
            {
                englishName: "S\u00E3o Tom\u00E9 \u0026 Pr\u00EDncipe Dobra (Db)",
                nativeName: "dobra de S\u00E3o Tom\u00E9 e Pr\u00EDncipe",
                code: "STN",
                symbol: "Db",
            },
            {
                englishName: "Saudi Riyal (\u0631.\u0633.\u200F)",
                nativeName: "\u0631\u064A\u0627\u0644 \u0633\u0639\u0648\u062F\u064A",
                code: "SAR",
                symbol: "\u0631.\u0633.\u200F",
            },
            {
                englishName: "Serbian Dinar (RSD)",
                nativeName: "\u0421\u0440\u043F\u0441\u043A\u0438 \u0434\u0438\u043D\u0430\u0440",
                code: "RSD",
                symbol: "RSD",
            },
            {
                englishName: "Seychellois Rupee (SR)",
                nativeName: "Seychellois Rupee",
                code: "SCR",
                symbol: "SR",
            },
            {
                englishName: "Sierra Leonean Leone (Le)",
                nativeName: "Sierra Leonean Leone",
                code: "SLL",
                symbol: "Le",
            },
            {
                englishName: "Singapore Dollar ($)",
                nativeName: "Singapore Dollar",
                code: "SGD",
                symbol: "$",
            },
            {
                englishName: "Solomon Islands Dollar ($)",
                nativeName: "Solomon Islands Dollar",
                code: "SBD",
                symbol: "$",
            },
            {
                englishName: "Somali Shilling (S)",
                nativeName: "\u0634\u0644\u0646 \u0635\u0648\u0645\u0627\u0644\u064A",
                code: "SOS",
                symbol: "S",
            },
            {
                englishName: "South African Rand (R)",
                nativeName: "Suid-Afrikaanse rand",
                code: "ZAR",
                symbol: "R",
            },
            {
                englishName: "South Korean Won (\u20A9)",
                nativeName: "\uB300\uD55C\uBBFC\uAD6D \uC6D0",
                code: "KRW",
                symbol: "\u20A9",
            },
            {
                englishName: "South Sudanese Pound (\u00A3)",
                nativeName: "\u062C\u0646\u064A\u0647 \u062C\u0646\u0648\u0628 \u0627\u0644\u0633\u0648\u062F\u0627\u0646",
                code: "SSP",
                symbol: "\u00A3",
            },
            {
                englishName: "Sri Lankan Rupee (\u0DBB\u0DD4.)",
                nativeName: "\u0DC1\u0DCA\u200D\u0DBB\u0DD3 \u0DBD\u0D82\u0D9A\u0DCF \u0DBB\u0DD4\u0DB4\u0DD2\u0DBA\u0DBD",
                code: "LKR",
                symbol: "\u0DBB\u0DD4.",
            },
            {
                englishName: "St. Helena Pound (\u00A3)",
                nativeName: "St. Helena Pound",
                code: "SHP",
                symbol: "\u00A3",
            },
            {
                englishName: "Sudanese Pound (\u062C.\u0633.)",
                nativeName: "\u062C\u0646\u064A\u0647 \u0633\u0648\u062F\u0627\u0646\u064A",
                code: "SDG",
                symbol: "\u062C.\u0633.",
            },
            {
                englishName: "Surinamese Dollar ($)",
                nativeName: "Surinaamse dollar",
                code: "SRD",
                symbol: "$",
            },
            {
                englishName: "Swazi Lilangeni (E)",
                nativeName: "Swazi Lilangeni",
                code: "SZL",
                symbol: "E",
            },
            {
                englishName: "Swedish Krona (kr)",
                nativeName: "Swedish Krona",
                code: "SEK",
                symbol: "kr",
            },
            {
                englishName: "Swiss Franc (CHF)",
                nativeName: "Schweizer Franken",
                code: "CHF",
                symbol: "CHF",
            },
            {
                englishName: "Syrian Pound (\u0644.\u0633.\u200F)",
                nativeName: "\u0644\u064A\u0631\u0629 \u0633\u0648\u0631\u064A\u0629",
                code: "SYP",
                symbol: "\u0644.\u0633.\u200F",
            },
            {
                englishName: "Tajikistani Somoni (\u0441\u043E\u043C.)",
                nativeName: "\u0421\u043E\u043C\u043E\u043D\u04E3",
                code: "TJS",
                symbol: "\u0441\u043E\u043C.",
            },
            {
                englishName: "Tanzanian Shilling (TSh)",
                nativeName: "shilingi ya Tandhania",
                code: "TZS",
                symbol: "TSh",
            },
            {
                englishName: "Thai Baht (\u0E3F)",
                nativeName: "\u0E1A\u0E32\u0E17",
                code: "THB",
                symbol: "\u0E3F",
            },
            {
                englishName: "Tongan Pa\u02BBanga (T$)",
                nativeName: "Tongan Pa\u02BBanga",
                code: "TOP",
                symbol: "T$",
            },
            {
                englishName: "Trinidad \u0026 Tobago Dollar ($)",
                nativeName: "Trinidad \u0026 Tobago Dollar",
                code: "TTD",
                symbol: "$",
            },
            {
                englishName: "Tunisian Dinar (\u062F.\u062A.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u062A\u0648\u0646\u0633\u064A",
                code: "TND",
                symbol: "\u062F.\u062A.\u200F",
            },
            {
                englishName: "Turkish Lira (\u20BA)",
                nativeName: "T\u00FCrk Liras\u0131",
                code: "TRY",
                symbol: "\u20BA",
            },
            {
                englishName: "Turkmenistani Manat (TMT)",
                nativeName: "T\u00FCrkmen manady",
                code: "TMT",
                symbol: "TMT",
            },
            {
                englishName: "Ugandan Shilling (USh)",
                nativeName: "Eshiringi ya Uganda",
                code: "UGX",
                symbol: "USh",
            },
            {
                englishName: "Ukrainian Hryvnia (\u20B4)",
                nativeName: "\u0443\u043A\u0440\u0430\u0438\u043D\u0441\u043A\u0430\u044F \u0433\u0440\u0438\u0432\u043D\u0430",
                code: "UAH",
                symbol: "\u20B4",
            },
            {
                englishName: "United Arab Emirates Dirham (\u062F.\u0625.\u200F)",
                nativeName: "\u062F\u0631\u0647\u0645 \u0625\u0645\u0627\u0631\u0627\u062A\u064A",
                code: "AED",
                symbol: "\u062F.\u0625.\u200F",
            },
            {
                englishName: "Uruguayan Peso ($)",
                nativeName: "peso uruguayo",
                code: "UYU",
                symbol: "$",
            },
            {
                englishName: "US Dollar ($)",
                nativeName: "US \u13A0\u13D5\u13B3",
                code: "USD",
                symbol: "$",
            },
            {
                englishName: "Uzbekistani Som (\u0441\u045E\u043C)",
                nativeName: "\u040E\u0437\u0431\u0435\u043A\u0438\u0441\u0442\u043E\u043D \u0441\u045E\u043C",
                code: "UZS",
                symbol: "\u0441\u045E\u043C",
            },
            {
                englishName: "Vanuatu Vatu (VT)",
                nativeName: "Vanuatu Vatu",
                code: "VUV",
                symbol: "VT",
            },
            {
                englishName: "Venezuelan Bol\u00EDvar (Bs.S)",
                nativeName: "bol\u00EDvar soberano",
                code: "VES",
                symbol: "Bs.S",
            },
            {
                englishName: "Vietnamese Dong (\u20AB)",
                nativeName: "\u0110\u1ED3ng Vi\u1EC7t Nam",
                code: "VND",
                symbol: "\u20AB",
            },
            {
                englishName: "West African CFA Franc (CFA)",
                nativeName: "sefa Fra\u014B (BCEAO)",
                code: "XOF",
                symbol: "CFA",
            },
            {
                englishName: "Yemeni Rial (\u0631.\u064A.\u200F)",
                nativeName: "\u0631\u064A\u0627\u0644 \u064A\u0645\u0646\u064A",
                code: "YER",
                symbol: "\u0631.\u064A.\u200F",
            },
            {
                englishName: "Zambian Kwacha (K)",
                nativeName: "ZMW",
                code: "ZMW",
                symbol: "K",
            },
        ];
        this.elementTypes = {
            AddressElement: "Address",
            Text_BoxElement: "StiTextBoxControl",
            TextElement: "StiText",
            TableElement: "StiTable",
            Single_SelectionElement: "StiSingleSelection",
            SignatureElement: "StiElectronicSignature",
            PDFSignatureElement: "StiPdfDigitalSignature",
            PanelElement: "StiPanel",
            Number_BoxElement: "StiNumberBox",
            Multiple_SelectionElement: "StiMultipleSelection",
            List_BoxElement: "StiListBox",
            LabelElement: "StiLabelControl",
            ImageElement: "StiImage",
            LineElement: "Line",
            DateTime_BoxElement: "StiDateTimePickerControl",
            Combo_BoxElement: "StiComboBox",
            Check_BoxElement: "StiCheckBox",
            ButtonElement: "StiButton",
            BarCodeElement: "StiBarCode",
            StiPageElement: "StiPage",
        };
        this.elementCategories = {
            AddressElement: "Report",
            Text_BoxElement: "Dialogs",
            LineElement: "Chart",
            DateTime_BoxElement: "Dialogs",
            LabelElement: "Dialogs",
        };
        StiLocalizationService.needToRefresh.subscribe(() => {
            this.updateHelper();
        });
    }
    getProperty(element, prop) {
        let props = prop.split(".");
        return prop.indexOf(".") == -1
            ? element[prop]
            : this.getProperty(element[props[0]], props.splice(1, props.length).join("."));
    }
    setProperty(element, prop, value) {
        {
            let props = prop.split(".");
            if (prop.indexOf(".") == -1) {
                element[prop] = value;
            }
            else {
                element[props[0]][props[1]] = value;
            }
        }
    }
    get richTextFontSizes() {
        if (this._richTextFontSizes.length === 0) {
            this._richTextFontSizes.push({ name: "8", value: 1 });
            this._richTextFontSizes.push({ name: "10", value: 2 });
            this._richTextFontSizes.push({ name: "12", value: 3 });
            this._richTextFontSizes.push({ name: "14", value: 4 });
            this._richTextFontSizes.push({ name: "18", value: 5 });
            this._richTextFontSizes.push({ name: "24", value: 6 });
            this._richTextFontSizes.push({ name: "36", value: 7 });
        }
        return this._richTextFontSizes;
    }
    get fontSizes() {
        return this._fontSizes;
    }
    getLocalizationKey(type) {
        return this.elementTypes[type];
    }
    getLocalizationCategory(type) {
        return this.elementCategories[type] ? this.elementCategories[type] : "Components";
    }
    get errorCorrectionLevel() {
        return this._errorCorrectionLevel;
    }
    get bodyShapeType() {
        return this._bodyShapeType;
    }
    get eyeFrameShapeType() {
        return this._eyeFrameShapeType;
    }
    get eyeBallShapeType() {
        return this._eyeBallShapeType;
    }
    get brushIdent() {
        return this._brushIdent;
    }
    get bodyBrush() {
        return this._bodyBrush;
    }
    get dataMatrixSize() {
        return this._dataMatrixSize;
    }
    get numberTypes() {
        if (this._numberTypes.length === 0) {
            this._numberTypes.push({
                name: StiLocalizationService.get("FormFormatEditor", "Number"),
                value: "Decimal",
            });
            this._numberTypes.push({
                name: StiLocalizationService.get("FormFormatEditor", "Currency"),
                value: "Currency",
            });
        }
        return this._numberTypes;
    }
    get rangeFormats() {
        if (this._rangeFormats.length === 0) {
            this._rangeFormats.push({
                name: StiLocalizationService.get("PropertyEnum", "Digits"),
                value: "Digits",
            });
            this._rangeFormats.push({
                name: StiLocalizationService.get("PropertyEnum", "Values"),
                value: "Values",
            });
        }
        return this._rangeFormats;
    }
    get signatureTypes() {
        if (this._signatureTypes.length === 0) {
            this._signatureTypes.push({
                name: StiLocalizationService.get("Components", "StiElectronicSignature"),
                value: "Signature",
            });
            this._signatureTypes.push({
                name: StiLocalizationService.get("Components", "StiPdfDigitalSignature"),
                value: "DigitalSignature",
            });
        }
        return this._signatureTypes;
    }
    get columnTypes() {
        if (this._columnTypes.length === 0) {
            this._columnTypes.push({ name: StiLocalizationService.get("Components", "StiCheckBox"), value: "CheckBox" });
            this._columnTypes.push({ name: StiLocalizationService.get("Components", "StiComboBox"), value: "ComboBox" });
            this._columnTypes.push({ name: StiLocalizationService.get("Dialogs", "StiLabelControl"), value: "Label" });
            this._columnTypes.push({
                name: StiLocalizationService.get("Components", "StiSingleSelection"),
                value: "RadioButton",
            });
            this._columnTypes.push({ name: StiLocalizationService.get("Dialogs", "StiTextBoxControl"), value: "TextBox" });
            this._columnTypes.push({ name: StiLocalizationService.get("Components", "StiNumberBox"), value: "NumberBox" });
        }
        return this._columnTypes;
    }
    get buttonTypes() {
        if (this._buttonTypes.length === 0) {
            this._buttonTypes.push({
                name: StiLocalizationService.get("Gui", "monthcalendar_clearbutton"),
                value: "ClearForm",
            });
            this._buttonTypes.push({
                name: StiLocalizationService.get("A_WebViewer", "ButtonSend"),
                value: "SendForm",
            });
            this._buttonTypes.push({
                name: StiLocalizationService.get("Buttons", "Attach"),
                value: "AttachFiles",
            });
        }
        return this._buttonTypes;
    }
    get algorithmExpressions() {
        if (this._algorithmExpressions.length === 0) {
            this._algorithmExpressions.push({ name: "Constant", value: "Constant" });
            this._algorithmExpressions.push({ name: "Number cell value", value: "NumberCellValue" });
            this._algorithmExpressions.push({ name: "Number column max", value: "NumberColumnMax" });
            this._algorithmExpressions.push({ name: "Number column sum", value: "NumberColumnSum" });
        }
        return this._algorithmExpressions;
    }
    get buttonSendTypes() {
        if (this._buttonSendTypes.length === 0) {
            this._buttonSendTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiButtonSendTypeFDF"),
                value: "FDF",
            });
            this._buttonSendTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiButtonSendTypeHTML"),
                value: "HTML",
            });
            this._buttonSendTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiButtonSendTypeXFDF"),
                value: "XFDF",
            });
            this._buttonSendTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiButtonSendTypePDF"),
                value: "PDF",
            });
        }
        return this._buttonSendTypes;
    }
    get barcodeTypes() {
        if (this._barcodeTypes.length === 0) {
            Enum.getValues(StiBarcodeType).forEach((t) => {
                let name = Enum.getName(StiBarcodeType, t);
                this._barcodeTypes.push({ name: name, value: name });
            });
        }
        return this._barcodeTypes;
    }
    get dateTimeTypes() {
        if (this._dateTimeTypes.length === 0) {
            this._dateTimeTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiDateTimeTypeDateAndTime"),
                value: "DateTime",
            });
            this._dateTimeTypes.push({ name: StiLocalizationService.get("FormFormatEditor", "Date"), value: "Date" });
            this._dateTimeTypes.push({ name: StiLocalizationService.get("FormFormatEditor", "Time"), value: "Time" });
        }
        return this._dateTimeTypes;
    }
    get penStyles() {
        if (this._penStyles.length === 0) {
            this._penStyles.push({ name: StiLocalizationService.get("PropertyEnum", "StiPenStyleSolid"), value: "Solid" });
            this._penStyles.push({ name: StiLocalizationService.get("PropertyEnum", "StiPenStyleDash"), value: "Dash" });
            this._penStyles.push({ name: StiLocalizationService.get("PropertyEnum", "StiPenStyleDot"), value: "Dot" });
        }
        return this._penStyles;
    }
    get dateTimeFormats() {
        if (this._dateTimeFormats.length === 0) {
            this._dateTimeFormats.push({ name: "m/d/yy h:MM tt", value: "m/d/yy h:MM tt" });
            this._dateTimeFormats.push({ name: "m/d/yyyy h:MM tt", value: "m/d/yyyy h:MM tt" });
            this._dateTimeFormats.push({ name: "m/d/yy HH:MM", value: "m/d/yy HH:MM" });
            this._dateTimeFormats.push({ name: "m/d/yyyy HH:MM", value: "m/d/yyyy HH:MM" });
            this._dateTimeFormats.push({ name: "m/d", value: "m/d" });
            this._dateTimeFormats.push({ name: "m/d/yy", value: "m/d/yy" });
            this._dateTimeFormats.push({ name: "m/d/yyyy", value: "m/d/yyyy" });
            this._dateTimeFormats.push({ name: "mm/dd/yy", value: "mm/dd/yy" });
            this._dateTimeFormats.push({ name: "mm/dd/yyyy", value: "mm/dd/yyyy" });
            this._dateTimeFormats.push({ name: "mm/yy", value: "mm/yy" });
            this._dateTimeFormats.push({ name: "mm/yyyy", value: "mm/yyyy" });
            this._dateTimeFormats.push({ name: "mmm-yy", value: "mmm-yy" });
            this._dateTimeFormats.push({ name: "mmm-yyyy", value: "mmm-yyyy" });
            this._dateTimeFormats.push({ name: "mmmm-yy", value: "mmmm-yy" });
            this._dateTimeFormats.push({ name: "mmmm-yyyy", value: "mmmm-yyyy" });
            this._dateTimeFormats.push({ name: "mmm d, yyyy", value: "mmm d, yyyy" });
            this._dateTimeFormats.push({ name: "mmmm d, yyyy", value: "mmmm d, yyyy" });
            this._dateTimeFormats.push({ name: "dd.mm.yyyy HH:MM", value: "dd.mm.yyyy HH:MM" });
            this._dateTimeFormats.push({ name: "d-mmm", value: "d-mmm" });
            this._dateTimeFormats.push({ name: "d-mmm-yy", value: "d-mmm-yy" });
            this._dateTimeFormats.push({ name: "d-mmm-yyyy", value: "d-mmm-yyyy" });
            this._dateTimeFormats.push({ name: "dd-mmm-yy", value: "dd-mmm-yy" });
            this._dateTimeFormats.push({ name: "dd-mmm-yyyy", value: "dd-mmm-yyyy" });
            this._dateTimeFormats.push({ name: "dd.mm.yyyy", value: "dd.mm.yyyy" });
            this._dateTimeFormats.push({ name: "yy-mm-dd", value: "yy-mm-dd" });
            this._dateTimeFormats.push({ name: "yyyy-mm-dd", value: "yyyy-mm-dd" });
            this._dateTimeFormats.push({ name: "HH:MM", value: "HH:MM" });
            this._dateTimeFormats.push({ name: "h:MM tt", value: "h:MM tt" });
            this._dateTimeFormats.push({ name: "HH:MM:ss", value: "HH:MM:ss" });
            this._dateTimeFormats.push({ name: "h:MM:ss tt", value: "h:MM:ss tt" });
        }
        return this._dateTimeFormats;
    }
    get dateFormats() {
        if (this._dateFormats.length === 0) {
            this._dateFormats.push({ name: "m/d", value: "m/d" });
            this._dateFormats.push({ name: "m/d/yy", value: "m/d/yy" });
            this._dateFormats.push({ name: "m/d/yyyy", value: "m/d/yyyy" });
            this._dateFormats.push({ name: "mm/dd/yy", value: "mm/dd/yy" });
            this._dateFormats.push({ name: "mm/dd/yyyy", value: "mm/dd/yyyy" });
            this._dateFormats.push({ name: "mm/yy", value: "mm/yy" });
            this._dateFormats.push({ name: "mm/yyyy", value: "mm/yyyy" });
            this._dateFormats.push({ name: "mmm-yy", value: "mmm-yy" });
            this._dateFormats.push({ name: "mmm-yyyy", value: "mmm-yyyy" });
            this._dateFormats.push({ name: "mmmm-yy", value: "mmmm-yy" });
            this._dateFormats.push({ name: "mmmm-yyyy", value: "mmmm-yyyy" });
            this._dateFormats.push({ name: "mmm d, yyyy", value: "mmm d, yyyy" });
            this._dateFormats.push({ name: "mmmm d, yyyy", value: "mmmm d, yyyy" });
            this._dateFormats.push({ name: "d-mmm", value: "d-mmm" });
            this._dateFormats.push({ name: "d-mmm-yy", value: "d-mmm-yy" });
            this._dateFormats.push({ name: "d-mmm-yyyy", value: "d-mmm-yyyy" });
            this._dateFormats.push({ name: "dd-mmm-yy", value: "dd-mmm-yy" });
            this._dateFormats.push({ name: "dd-mmm-yyyy", value: "dd-mmm-yyyy" });
            this._dateFormats.push({ name: "dd.mm.yyyy", value: "dd.mm.yyyy" });
            this._dateFormats.push({ name: "yy-mm-dd", value: "yy-mm-dd" });
            this._dateFormats.push({ name: "yyyy-mm-dd", value: "yyyy-mm-dd" });
        }
        return this._dateFormats;
    }
    get timeFormats() {
        if (this._timeFormats.length === 0) {
            this._timeFormats.push({ name: "HH:MM", value: "HH:MM" });
            this._timeFormats.push({ name: "h:MM tt", value: "h:MM tt" });
            this._timeFormats.push({ name: "HH:MM:ss", value: "HH:MM:ss" });
            this._timeFormats.push({ name: "h:MM:ss tt", value: "h:MM:ss tt" });
        }
        return this._timeFormats;
    }
    get signatureEditorModes() {
        if (this._signatureEditorModes.length === 0) {
            this._signatureEditorModes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiSignatureTypeType"),
                value: "Type",
            });
            this._signatureEditorModes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiSignatureTypeDraw"),
                value: "Draw",
            });
        }
        return this._signatureEditorModes;
    }
    get signatureSpecialFonts() {
        if (this._signatureSpecialFonts.length === 0) {
            this._signatureSpecialFonts.push({
                name: `${StiLocalizationService.get("PropertyMain", "Style")}${1}`,
                value: "Teddy Bear",
            });
            this._signatureSpecialFonts.push({
                name: `${StiLocalizationService.get("PropertyMain", "Style")}${2}`,
                value: "MADE Likes Script",
            });
            this._signatureSpecialFonts.push({
                name: `${StiLocalizationService.get("PropertyMain", "Style")}${3}`,
                value: "Denistina",
            });
        }
        return this._signatureSpecialFonts;
    }
    get dateTimeValues() {
        if (this._dateTimeValues.length === 0) {
            this._dateTimeValues.push({
                name: StiLocalizationService.get("Gui", "colorpickerdialog_currentcolorlabel"),
                value: "Current",
            });
            this._dateTimeValues.push({
                name: StiLocalizationService.get("PropertyEnum", "DateTimePickerFormatCustom"),
                value: "Custom",
            });
        }
        return this._dateTimeValues;
    }
    get themes() {
        if (this._themes.length === 0) {
            this._themes.push({ name: "Light" });
            this._themes.push({ name: "Dark" });
        }
        return this._themes;
    }
    get borderWeights() {
        if (this._borderWeights.length === 0) {
            this._borderWeights.push({
                name: StiLocalizationService.get("PropertyEnum", "StiLineWeightThin"),
                value: "Thin",
            });
            this._borderWeights.push({
                name: StiLocalizationService.get("PropertyEnum", "StiLineWeightNormal"),
                value: "Normal",
            });
            this._borderWeights.push({
                name: StiLocalizationService.get("PropertyEnum", "StiLineWeightThick"),
                value: "Thick",
            });
        }
        return this._borderWeights;
    }
    get unitAlignment() {
        if (this._unitAlignment.length === 0) {
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentPrefix"),
                value: 1,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentSuffix"),
                value: 2,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentPrefixInside"),
                value: 3,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentPrefixInsideWithSpace"),
                value: 4,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentSuffixInside"),
                value: 5,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentSuffixInsideWithSpace"),
                value: 6,
            });
        }
        return this._unitAlignment;
    }
    get minUnitAlignment() {
        if (this._minUnitAlignment.length === 0) {
            this._minUnitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentPrefix"),
                value: 1,
            });
            this._minUnitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentSuffix"),
                value: 2,
            });
        }
        return this._minUnitAlignment;
    }
    get labelFormat() {
        if (this._labelFormat.length === 0) {
            this._labelFormat.push({ name: "Symbol", value: 1 });
            this._labelFormat.push({ name: "Code", value: 2 });
        }
        return this._labelFormat;
    }
    get thousandSeparators() {
        if (this._thousandSeparators.length === 0) {
            this._thousandSeparators.push({ name: "1234567.89", value: "None" });
            this._thousandSeparators.push({ name: "1234567,89", value: "NoneComma" });
            this._thousandSeparators.push({ name: "1,234,567.89", value: "Comma" });
            this._thousandSeparators.push({ name: "1.234.567,89", value: "Dot" });
            this._thousandSeparators.push({ name: "1`234`567.89", value: "Apostrophe" });
        }
        return this._thousandSeparators;
    }
    updateHelper() {
        this._minUnitAlignment = [];
        this._unitAlignment = [];
        this._borderWeights = [];
        this._dateTimeValues = [];
        this._penStyles = [];
        this._dateTimeTypes = [];
        this._buttonSendTypes = [];
        this._buttonTypes = [];
        this._signatureTypes = [];
        this._numberTypes = [];
    }
    deleteSelectedComponent() {
        var _a;
        let fromPanel = true;
        if (this.model.selectedComponent) {
            let container = (_a = this.model.getElementPage(this.model.selectedComponent.element)) !== null && _a !== void 0 ? _a : this.model.getElementPanel(this.model.selectedComponent.element);
            container.elements.splice(container.elements.indexOf(this.model.selectedComponent.element), 1);
            this.render.removeElement(this.model.selectedComponent.element, container.elements);
            this.model.selectedComponent = null;
            this.model.formEvents.next({ name: "ComponentDeleted" });
            this.model.cursor = "default";
        }
    }
    getElementClass(type) {
        if (type == "TextElement" || type == "Text") {
            return StiTextElement;
        }
        else if (type == "Text_BoxElement" || type == "TextBox") {
            return StiTextBoxElement;
        }
        else if (type == "TableElement" || type == "Table") {
            return StiTableElement;
        }
        else if (type == "Single_SelectionElement" || type == "SingleSelection") {
            return StiSingleSelectionElement;
        }
        else if (type == "SignatureElement" || type == "Signature") {
            return StiSignatureElement;
        }
        else if (type == "PDFSignatureElement" || type == "PDFSignature") {
            return StiPDFSignatureElement;
        }
        else if (type == "PanelElement" || type == "Panel") {
            return StiPanelElement;
        }
        else if (type == "Number_BoxElement" || type == "NumberBox") {
            return StiNumberBoxElement;
        }
        else if (type == "Multiple_SelectionElement" || type == "MultipleSelection") {
            return StiMultipleSelectionElement;
        }
        else if (type == "List_BoxElement" || type == "ListBox") {
            return StiListBoxElement;
        }
        else if (type == "LineElement" || type == "Line") {
            return StiLineElement;
        }
        else if (type == "LabelElement" || type == "Label") {
            return StiLabelElement;
        }
        else if (type == "ImageElement" || type == "Image") {
            return StiImageElement;
        }
        else if (type == "DateTime_BoxElement" || type == "DateTimeBox") {
            return StiDateTimeBoxElement;
        }
        else if (type == "Combo_BoxElement" || type == "ComboBox") {
            return StiComboBoxElement;
        }
        else if (type == "Check_BoxElement" || type == "CheckBox") {
            return StiCheckBoxElement;
        }
        else if (type == "ButtonElement" || type == "Button") {
            return StiButtonElement;
        }
        else if (type == "BarCodeElement" || type == "BarCode") {
            return StiBarcodeElement;
        }
        else if (type == "AddressElement" || type == "Address") {
            return StiAddressElement;
        }
        else if (type == "Page") {
            return StiFormPageElement;
        }
        else if (type == "Form") {
            return StiForm;
        }
        // return this.pageElement.getElementTypes()[type] ?? StiPanelElement;
    }
    clone(element) {
        let clazz = this.getElementClass(element.type);
        let result = new clazz();
        let jObject = new StiJson();
        jObject.deserialize(element.saveToJsonObject({}).serialize());
        result.loadFromJsonObject(jObject);
        result.guid = Guid.newGuid().toString();
        if ("displayValue" in element) {
            result["displayValue"] = element["displayValue"];
        }
        return result;
    }
    clonePage(page) {
        let result = new StiFormPageElement();
        let jObject = new StiJson();
        jObject.deserialize(page.saveToJsonObject({}).serialize());
        result.loadFromJsonObject(jObject);
        result.guid = Guid.newGuid().toString();
        return result;
    }
    get fileMenuItems() {
        if (this._fileMenuItems.length == 0) {
            this._fileMenuItems = [
                // { caption: StiLocalizationService.get("PropertyMain", "Info"), image: "assets/Images/Other/FileMenu/Home.png" },
                {
                    caption: StiLocalizationService.get("MainMenu", "menuFileNew").replace("&amp", "").replace(";", ""),
                    image: "images.Other.FileMenu.Report.png",
                    name: "New",
                },
                {
                    caption: StiLocalizationService.get("MainMenu", "menuFileOpen")
                        .replace("&amp", "")
                        .replace(";", "")
                        .replace("...", ""),
                    image: "images.Other.FileMenu.Folder.png",
                    name: "Open",
                },
                { name: "Divider" },
                {
                    caption: StiLocalizationService.get("MainMenu", "menuFileSave").replace("&amp", "").replace(";", ""),
                    name: "Save",
                },
                { caption: StiLocalizationService.get("MainMenu", "menuFileSaveAs").replace("...", ""), name: "SaveAs" },
                /*  { caption: StiLocalizationService.get("PropertyMain", "Share") },
                { caption: StiLocalizationService.get("PropertyMain", "Help") },
                { caption: StiLocalizationService.get("PropertyMain", "Close") }, */
                { name: "Divider" },
                /*  { caption: StiLocalizationService.get("PropertyMain", "Account") },
                { caption: StiLocalizationService.get("PropertyMain", "Options") }, */
                {
                    caption: StiLocalizationService.get("MainMenu", "menuHelpAboutProgramm")
                        .replace("&amp", "")
                        .replace(";", "")
                        .replace("...", ""),
                    name: "About",
                },
            ];
        }
        return this._fileMenuItems;
    }
    getAddTotalMenuItems() {
        var _a, _b;
        let table = (_a = this.model.selectedComponent) === null || _a === void 0 ? void 0 : _a.element;
        let this_ = this;
        if (!this.addTotalMenuItems && ((_b = table === null || table === void 0 ? void 0 : table.columns) === null || _b === void 0 ? void 0 : _b.length) > 0) {
            this.addTotalMenuItems = [];
            let commands = [
                { name: this.loc.getP("Summary"), type: "Sum" },
                { name: this.loc.getP("Minimum"), type: "Min" },
                { name: this.loc.getP("Maximum"), type: "Max" },
                { name: this.loc.getP("Count"), type: "Count" },
            ];
            commands.forEach((command) => {
                let items = [];
                table.columns.forEach((column, index) => {
                    if (column instanceof StiNumberBoxColumnItem || column instanceof StiLabelColumnItem) {
                        items.push({
                            label: column.label,
                            command: () => {
                                this_.zone.run(() => {
                                    table.totalsFields.push(new StiTotalsFieldItem(command.type, `{${command.type}(Col(${index + 1}))}`));
                                    this.model.showColumnPreview(table.totalsFields.length - 1, "totals");
                                });
                            },
                        });
                    }
                });
                if (items.length > 0) {
                    this.addTotalMenuItems.push({ label: command.name, items: items });
                }
            });
            let items = [];
            table.columns.forEach((column, index) => {
                let rowItems = [];
                table.rowLabels.forEach((rowLabel, rowIndex) => {
                    rowItems.push({
                        label: rowLabel,
                        command: () => {
                            this_.zone.run(() => {
                                table.totalsFields.push(new StiTotalsFieldItem("Cell", `{Cell(${index + 1}, ${rowIndex + 1})}`));
                                this.model.showColumnPreview(table.totalsFields.length - 1, "totals");
                            });
                        },
                    });
                });
                items.push({
                    label: column.label,
                    items: rowItems,
                });
            });
            this.addTotalMenuItems.push({ label: this.loc.get2("PropertyCategory", "CellCategory"), items: items });
        }
        return this.addTotalMenuItems;
    }
    base64Encode(input) {
        if (input == null)
            return "";
        // Decode from UTF-8 text
        if (typeof unescape != "undefined") {
            input = unescape(encodeURIComponent(input));
        }
        else {
            input = input.replace(/\r\n/g, "\n");
            var utftext = "";
            for (var n = 0; n < input.length; n++) {
                var c = input.charCodeAt(n);
                if (c < 128) {
                    utftext += String.fromCharCode(c);
                }
                else if (c > 127 && c < 2048) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
                else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
            }
            input = utftext;
        }
        // Encode to Base64 string
        if (typeof window.btoa != "undefined")
            return window.btoa(input);
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;
        while (i < input.length) {
            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);
            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;
            if (isNaN(chr2))
                enc3 = enc4 = 64;
            else if (isNaN(chr3))
                enc4 = 64;
            output =
                output +
                    this._keyStr.charAt(enc1) +
                    this._keyStr.charAt(enc2) +
                    this._keyStr.charAt(enc3) +
                    this._keyStr.charAt(enc4);
        }
        return output;
    }
    base64Decode(input) {
        if (input == null)
            return "";
        var output = "";
        // Decode from Base64 string
        if (typeof window.atob != "undefined") {
            output = window.atob(input);
        }
        else {
            var chr1, chr2, chr3;
            var enc1, enc2, enc3, enc4;
            var i = 0;
            input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            while (i < input.length) {
                enc1 = this._keyStr.indexOf(input.charAt(i++));
                enc2 = this._keyStr.indexOf(input.charAt(i++));
                enc3 = this._keyStr.indexOf(input.charAt(i++));
                enc4 = this._keyStr.indexOf(input.charAt(i++));
                chr1 = (enc1 << 2) | (enc2 >> 4);
                chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                chr3 = ((enc3 & 3) << 6) | enc4;
                output = output + String.fromCharCode(chr1);
                if (enc3 != 64) {
                    output = output + String.fromCharCode(chr2);
                }
                if (enc4 != 64) {
                    output = output + String.fromCharCode(chr3);
                }
            }
        }
        // Encode to UTF-8 string
        if (typeof escape != "undefined")
            return decodeURIComponent(escape(output));
        var string = "";
        var i = 0;
        var c = 0;
        var c1 = 0;
        var c2 = 0;
        var c3 = 0;
        while (i < output.length) {
            c = output.charCodeAt(i);
            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if (c > 191 && c < 224) {
                c2 = output.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = output.charCodeAt(i + 1);
                c3 = output.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }
        return string;
    }
}
StiHelperService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHelperService, deps: [{ token: StiModelService }, { token: StiRectangleGeometryLayout }, { token: StiLocalizationService }, { token: i0.NgZone }], target: i0.ɵɵFactoryTarget.Injectable });
StiHelperService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHelperService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHelperService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: StiModelService }, { type: StiRectangleGeometryLayout }, { type: StiLocalizationService }, { type: i0.NgZone }]; } });

class StiHttpClientService {
    constructor(httpClient, model, helper, loc) {
        this.httpClient = httpClient;
        this.model = model;
        this.helper = helper;
        this.loc = loc;
    }
    post(url, data, responseType = "json", options) {
        if (this.model.isWebView) {
            return this.postWebView(data, options);
        }
        else if (this.model.embeddedMode && (data === null || data === void 0 ? void 0 : data.action) == "InterfaceEvent") {
            this.model.embeddedEvent(data);
            return new Observable((observer) => {
                observer.next({});
            });
        }
        else {
            return this.postHttp(url, data, responseType, options);
        }
    }
    loadLocalization(cultureName) {
        this.loc.currentLocalization = this.loc.localizationList.find((item) => item.cultureName == cultureName);
        this.post(this.model.requestUrl, { action: "GetLocalization", localization: cultureName }).subscribe((data) => {
            StiLocalizationService.setLocalization(data.localization);
            this.model.needToRefresh.next(true);
            this.helper.updateHelper();
        });
    }
    postWebView(data, options) {
        let webView = window.chrome.webview.hostObjects.sync.webView;
        let model = this.model;
        model.showProgress = options && options.showProgress === false ? false : true;
        let observer = new Observable((observer) => {
            setTimeout(() => {
                let result = webView.Action(this.getData(data));
                let jsonResult = JSON.parse(result);
                let jsonData = jsonResult.data;
                if (jsonResult.contentType == "application/pdf") {
                    jsonData = atob(jsonData);
                    var len = jsonData.length;
                    var bytes = new Uint8Array(len);
                    for (var i = 0; i < len; i++) {
                        bytes[i] = jsonData.charCodeAt(i);
                    }
                    jsonData = bytes.buffer;
                }
                model.showProgress = false;
                observer.next(jsonData);
            }, 0);
        });
        return observer;
    }
    postHttp(url, data, responseType = "json", options) {
        const reqTimeout = 1000 * 1000;
        const model = this.model;
        model.showProgress = options && options.showProgress === false ? false : true;
        if (responseType === "json") {
            return this.httpClient.post(url, this.getFormData(data)).pipe(
            // retry(3),
            timeout(reqTimeout), catchError((error) => {
                //model.httpError = error;
                model.showProgress = false;
                model.showError(error.error);
                return throwError("Something bad happened; please try again later.");
            }));
        }
        else {
            return this.httpClient.post(url, this.getFormData(data), { responseType: "arraybuffer" }).pipe(
            // retry(3),
            timeout(reqTimeout), catchError((error) => {
                //model.httpError = error;
                model.showProgress = false;
                model.showError(error.error);
                return throwError("Something bad happened; please try again later.");
            }));
        }
    }
    getData(data) {
        if (this.model.properties) {
            data["properties"] = this.model.properties;
        }
        return JSON.stringify(data);
    }
    getFormData(data) {
        const formData = new FormData();
        if (this.model.properties) {
            data["properties"] = this.model.properties;
        }
        formData.append("data", JSON.stringify(data));
        return formData;
    }
    postForm(url, data, doc, postOnlyData = false) {
        if (!doc) {
            doc = document;
        }
        const form = doc.createElement("FORM");
        form.setAttribute("method", "POST");
        form.setAttribute("action", url);
        const params = data;
        Object.keys(params).forEach((key) => {
            const paramsField = doc.createElement("INPUT");
            paramsField.setAttribute("type", "hidden");
            paramsField.setAttribute("name", key);
            paramsField.setAttribute("value", params[key]);
            form.appendChild(paramsField);
        });
        doc.body.appendChild(form);
        form.submit();
        doc.body.removeChild(form);
    }
}
StiHttpClientService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHttpClientService, deps: [{ token: i1.HttpClient }, { token: StiModelService }, { token: StiHelperService }, { token: StiLocalizationService }], target: i0.ɵɵFactoryTarget.Injectable });
StiHttpClientService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHttpClientService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHttpClientService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.HttpClient }, { type: StiModelService }, { type: StiHelperService }, { type: StiLocalizationService }]; } });

class StiUndoService {
    constructor(model) {
        this.model = model;
        this.undos = [];
        this.redos = [];
        model.formEvents.subscribe((e) => {
            if (e.name == "FormChanged") {
                this.addToUndo();
            }
            else if (e.name == "SetForm") {
                this.undos = [];
                this.addToUndo();
            }
        });
    }
    undoRedo(from, to) {
        to.push(from.splice(from.length - 1, 1)[0]);
        if (to.length > StiUndoService.UNDO_SIZE) {
            to.splice(0, 1);
        }
        let fromObj = this.undos[this.undos.length - 1];
        let form = new StiForm();
        form.loadFormJsonString(fromObj.form);
        this.model.selectedComponent = null;
        if (fromObj.guid) {
            form.pages.forEach((p) => {
                if (p.guid == fromObj.guid) {
                    this.model.selectedPage = p;
                }
            });
            form.pages.forEach((p) => p.allElements.forEach((e) => {
                if (e.guid == fromObj.guid) {
                    e.needToSelectComponent = true;
                }
            }));
        }
        this.model.updateForm(form);
        this.model.showTrialLog();
    }
    addToUndo() {
        var _a, _b, _c;
        this.model.showTrialLog();
        let formStr = this.model.form.saveToJsonObject().serialize();
        this.undos.push({
            form: formStr,
            guid: (_b = (_a = this.model.selectedComponent) === null || _a === void 0 ? void 0 : _a.element.guid) !== null && _b !== void 0 ? _b : (_c = this.model.selectedPage) === null || _c === void 0 ? void 0 : _c.guid,
            num: this.undos.length,
        });
        if (this.undos.length > StiUndoService.UNDO_SIZE) {
            this.undos.splice(0, 1);
        }
        this.redos = [];
    }
    undo() {
        if (this.undos.length > 0) {
            this.undoRedo(this.undos, this.redos);
        }
    }
    redo() {
        if (this.redos.length > 0) {
            this.undoRedo(this.redos, this.undos);
        }
    }
    markCurrentFormAsUnmodified() {
        this.undos.forEach((u) => (u.unmodified = false));
        this.redos.forEach((u) => (u.unmodified = false));
        this.undos[this.undos.length - 1].unmodified = true;
    }
}
StiUndoService.UNDO_SIZE = 30;
StiUndoService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiUndoService, deps: [{ token: StiModelService }], target: i0.ɵɵFactoryTarget.Injectable });
StiUndoService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiUndoService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiUndoService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: StiModelService }]; } });

class StiBarcodeService {
    constructor(model, mouseService, httpService, undoService) {
        this.model = model;
        this.mouseService = mouseService;
        this.httpService = httpService;
        this.undoService = undoService;
        this.timerSarted = false;
        this.initialized = false;
        this.previewWidth = 192;
        this.showBarcodePreview = false;
        this.barcodeStyles = [
            {
                value: 1,
                innerHtml: `
        <rect
          x="0"
          y="0"
          width="165.3543"
          height="165.3543"
          fill="red"
          style="fill:rgba(255,255,255,0);"
          shape-rendering="crispEdges"
        />
        <polygon
          points="13.23,13.23 59.53,13.23 59.53,59.53 13.23,59.53 13.23,19.78 19.84,19.78 19.84,52.91 52.91,52.91 52.91,19.84 13.23,19.84 "
          style="fill:rgba(0,0,0,1);"
        />
        <polygon
          points="13.23,105.83 59.53,105.83 59.53,152.13 13.23,152.13 13.23,112.37 19.84,112.37 19.84,145.51 52.91,145.51 52.91,112.44 13.23,112.44 "
          style="fill:rgba(0,0,0,1);"
        />
        <polygon
          points="105.83,13.23 152.13,13.23 152.13,59.53 105.83,59.53 105.83,19.78 112.44,19.78 112.44,52.91 145.51,52.91 145.51,19.84 105.83,19.84 "
          style="fill:rgba(0,0,0,1);"
        />
        <polygon points="26.46,26.46 46.3,26.46 46.3,46.3 26.46,46.3 " style="fill:rgba(0,0,0,1);" />
        <polygon points="26.46,119.06 46.3,119.06 46.3,138.9 26.46,138.9 " style="fill:rgba(0,0,0,1);" />
        <polygon points="119.06,26.46 138.9,26.46 138.9,46.3 119.06,46.3 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.37,13.23 86.05,13.23 85.98,19.91 79.37,19.91 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.92,13.23 92.66,13.23 92.53,19.84 85.92,19.84 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.53,13.23 99.21,13.23 99.15,19.91 92.53,19.91 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,19.84 72.82,19.84 72.76,26.46 66.14,26.46 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.69,19.84 79.44,19.84 79.3,26.46 72.69,26.46 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.3,19.78 85.98,19.78 85.92,26.52 79.3,26.52 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,19.78 99.21,19.78 99.21,26.52 92.6,26.52 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.37,26.39 86.05,26.39 85.98,33.07 79.37,33.07 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.92,26.46 92.66,26.46 92.53,33.07 85.92,33.07 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.53,26.39 99.21,26.39 99.15,33.14 92.53,33.14 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,33.07 72.82,33.07 72.76,39.69 66.14,39.69 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.69,33.07 79.37,33.07 79.3,39.75 72.69,39.75 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,33 99.21,33 99.21,39.75 92.6,39.75 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.76,39.62 79.37,39.62 79.37,46.3 72.76,46.3 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,39.62 99.21,39.62 99.21,46.3 92.6,46.3 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,46.3 72.76,46.3 72.76,52.98 66.14,52.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.98,46.3 92.6,46.3 92.6,52.91 85.98,52.91 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,52.85 72.76,52.85 72.76,59.53 66.14,59.53 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.37,52.91 85.98,52.91 85.98,59.53 79.37,59.53 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,52.91 99.21,52.91 99.21,59.53 92.6,59.53 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.76,59.53 79.37,59.53 79.37,66.14 72.76,66.14 " style="fill:rgba(0,0,0,1);" />
        <polygon points="13.23,66.14 19.91,66.14 19.84,72.82 13.23,72.82 " style="fill:rgba(0,0,0,1);" />
        <polygon points="19.78,66.14 26.52,66.14 26.39,72.82 19.78,72.82 " style="fill:rgba(0,0,0,1);" />
        <polygon points="26.39,66.14 33.14,66.14 33,72.82 26.39,72.82 " style="fill:rgba(0,0,0,1);" />
        <polygon points="33,66.14 39.75,66.14 39.62,72.76 33,72.76 " style="fill:rgba(0,0,0,1);" />
        <polygon points="39.62,66.14 46.3,66.14 46.23,72.76 39.62,72.76 " style="fill:rgba(0,0,0,1);" />
        <polygon points="52.91,66.14 59.59,66.14 59.53,72.76 52.91,72.76 " style="fill:rgba(0,0,0,1);" />
        <polygon points="59.46,66.14 66.21,66.14 66.08,72.82 59.46,72.82 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.08,66.14 72.76,66.14 72.69,72.76 66.08,72.76 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.98,66.14 92.6,66.14 92.6,72.82 85.98,72.82 " style="fill:rgba(0,0,0,1);" />
        <polygon points="99.21,66.14 105.83,66.14 105.83,72.82 99.21,72.82 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.44,66.14 119.06,66.14 119.06,72.76 112.44,72.76 " style="fill:rgba(0,0,0,1);" />
        <polygon points="125.67,66.14 132.28,66.14 132.28,72.82 125.67,72.82 " style="fill:rgba(0,0,0,1);" />
        <polygon points="138.9,66.14 145.51,66.14 145.51,72.82 138.9,72.82 " style="fill:rgba(0,0,0,1);" />
        <polygon points="13.23,72.69 19.91,72.69 19.84,79.37 13.23,79.37 " style="fill:rgba(0,0,0,1);" />
        <polygon points="19.78,72.69 26.52,72.69 26.39,79.37 19.78,79.37 " style="fill:rgba(0,0,0,1);" />
        <polygon points="26.39,72.69 33.07,72.69 33,79.44 26.39,79.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="46.3,72.76 52.91,72.76 52.91,79.44 46.3,79.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="59.53,72.69 66.14,72.69 66.14,79.37 59.53,79.37 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.76,72.76 79.37,72.76 79.37,79.44 72.76,79.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.98,72.69 92.66,72.69 92.6,79.37 85.98,79.37 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.53,72.76 99.28,72.76 99.15,79.44 92.53,79.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="99.15,72.69 105.89,72.69 105.76,79.37 99.15,79.37 " style="fill:rgba(0,0,0,1);" />
        <polygon points="105.76,72.76 112.44,72.76 112.37,79.44 105.76,79.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="125.67,72.69 132.35,72.69 132.28,79.44 125.67,79.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.22,72.76 138.96,72.76 138.83,79.37 132.22,79.37 " style="fill:rgba(0,0,0,1);" />
        <polygon points="138.83,72.69 145.58,72.69 145.45,79.37 138.83,79.37 " style="fill:rgba(0,0,0,1);" />
        <polygon points="145.45,72.76 152.13,72.76 152.06,79.44 145.45,79.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="26.46,79.3 33.07,79.3 33.07,85.98 26.46,85.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="39.69,79.37 46.37,79.37 46.3,85.98 39.69,85.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="46.23,79.3 52.98,79.3 52.85,85.98 46.23,85.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="52.85,79.37 59.53,79.37 59.46,85.98 52.85,85.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,79.37 72.82,79.37 72.76,85.98 66.14,85.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.69,79.3 79.37,79.3 79.3,85.98 72.69,85.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,79.3 99.21,79.3 99.21,86.05 92.6,86.05 " style="fill:rgba(0,0,0,1);" />
        <polygon points="105.83,79.3 112.51,79.3 112.44,86.05 105.83,86.05 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.37,79.37 119.06,79.37 118.99,85.98 112.37,85.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="125.67,79.3 132.28,79.3 132.28,85.98 125.67,85.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="145.51,79.3 152.13,79.3 152.13,86.05 145.51,86.05 " style="fill:rgba(0,0,0,1);" />
        <polygon points="13.23,85.98 19.84,85.98 19.84,92.6 13.23,92.6 " style="fill:rgba(0,0,0,1);" />
        <polygon points="33.07,85.98 39.69,85.98 39.69,92.66 33.07,92.66 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.98,85.98 92.66,85.98 92.6,92.6 85.98,92.6 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.53,85.92 99.28,85.92 99.15,92.66 92.53,92.66 " style="fill:rgba(0,0,0,1);" />
        <polygon points="99.15,85.98 105.89,85.98 105.76,92.6 99.15,92.6 " style="fill:rgba(0,0,0,1);" />
        <polygon points="105.76,85.92 112.44,85.92 112.37,92.6 105.76,92.6 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.28,85.98 138.96,85.98 138.9,92.6 132.28,92.6 " style="fill:rgba(0,0,0,1);" />
        <polygon points="138.83,85.98 145.58,85.98 145.45,92.66 138.83,92.66 " style="fill:rgba(0,0,0,1);" />
        <polygon points="145.45,85.92 152.13,85.92 152.06,92.6 145.45,92.6 " style="fill:rgba(0,0,0,1);" />
        <polygon points="19.84,92.6 26.46,92.6 26.46,99.21 19.84,99.21 " style="fill:rgba(0,0,0,1);" />
        <polygon points="33.07,92.53 39.75,92.53 39.69,99.21 33.07,99.21 " style="fill:rgba(0,0,0,1);" />
        <polygon points="39.62,92.6 46.3,92.6 46.23,99.21 39.62,99.21 " style="fill:rgba(0,0,0,1);" />
        <polygon points="52.91,92.6 59.53,92.6 59.53,99.21 52.91,99.21 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,92.6 72.82,92.6 72.76,99.28 66.14,99.28 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.69,92.6 79.37,92.6 79.3,99.21 72.69,99.21 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,92.53 99.21,92.53 99.21,99.28 92.6,99.28 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.44,92.6 119.06,92.6 119.06,99.28 112.44,99.28 " style="fill:rgba(0,0,0,1);" />
        <polygon points="138.9,92.53 145.51,92.53 145.51,99.21 138.9,99.21 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,99.15 72.76,99.15 72.76,105.89 66.14,105.89 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.37,99.21 85.98,99.21 85.98,105.83 79.37,105.83 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,99.15 99.21,99.15 99.21,105.83 92.6,105.83 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.44,99.15 119.06,99.15 119.06,105.83 112.44,105.83 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.28,99.21 138.9,99.21 138.9,105.83 132.28,105.83 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,105.76 72.76,105.76 72.76,112.44 66.14,112.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.98,105.83 92.6,105.83 92.6,112.44 85.98,112.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="99.21,105.83 105.83,105.83 105.83,112.44 99.21,112.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="119.06,105.83 125.74,105.83 125.67,112.51 119.06,112.51 " style="fill:rgba(0,0,0,1);" />
        <polygon points="125.6,105.83 132.28,105.83 132.22,112.44 125.6,112.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="138.9,105.83 145.58,105.83 145.51,112.44 138.9,112.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="145.45,105.83 152.13,105.83 152.06,112.51 145.45,112.51 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.76,112.44 79.44,112.44 79.37,119.12 72.76,119.12 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.3,112.44 85.98,112.44 85.92,119.12 79.3,119.12 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.44,112.44 119.12,112.44 119.06,119.06 112.44,119.06 " style="fill:rgba(0,0,0,1);" />
        <polygon points="118.99,112.37 125.67,112.37 125.6,119.12 118.99,119.12 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.28,112.44 138.9,112.44 138.9,119.12 132.28,119.12 " style="fill:rgba(0,0,0,1);" />
        <polygon points="145.51,112.37 152.13,112.37 152.13,119.06 145.51,119.06 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,119.06 72.82,119.06 72.76,125.74 66.14,125.74 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.69,118.99 79.44,118.99 79.3,125.74 72.69,125.74 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.3,118.99 86.05,118.99 85.92,125.67 79.3,125.67 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.92,119.06 92.6,119.06 92.53,125.74 85.92,125.74 " style="fill:rgba(0,0,0,1);" />
        <polygon points="99.21,119.06 105.83,119.06 105.83,125.74 99.21,125.74 " style="fill:rgba(0,0,0,1);" />
        <polygon points="119.06,118.99 125.74,118.99 125.67,125.67 119.06,125.67 " style="fill:rgba(0,0,0,1);" />
        <polygon points="125.6,119.06 132.35,119.06 132.22,125.74 125.6,125.74 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.22,118.99 138.9,118.99 138.83,125.74 132.22,125.74 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,125.6 72.82,125.6 72.76,132.35 66.14,132.35 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.69,125.6 79.37,125.6 79.3,132.35 72.69,132.35 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.98,125.6 92.66,125.6 92.6,132.28 85.98,132.28 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.53,125.67 99.28,125.67 99.15,132.35 92.53,132.35 " style="fill:rgba(0,0,0,1);" />
        <polygon points="99.15,125.6 105.89,125.6 105.76,132.28 99.15,132.28 " style="fill:rgba(0,0,0,1);" />
        <polygon points="105.76,125.67 112.51,125.67 112.37,132.35 105.76,132.35 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.37,125.67 119.06,125.67 118.99,132.35 112.37,132.35 " style="fill:rgba(0,0,0,1);" />
        <polygon points="125.67,125.6 132.35,125.6 132.28,132.35 125.67,132.35 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.22,125.6 138.9,125.6 138.83,132.35 132.22,132.35 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,132.22 72.82,132.22 72.76,138.96 66.14,138.96 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.69,132.22 79.37,132.22 79.3,138.9 72.69,138.9 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,132.22 99.21,132.22 99.21,138.96 92.6,138.96 " style="fill:rgba(0,0,0,1);" />
        <polygon points="105.83,132.22 112.51,132.22 112.44,138.96 105.83,138.96 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.37,132.22 119.06,132.22 118.99,138.96 112.37,138.96 " style="fill:rgba(0,0,0,1);" />
        <polygon points="125.67,132.22 132.35,132.22 132.28,138.9 125.67,138.9 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.22,132.22 138.9,132.22 138.83,138.96 132.22,138.96 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,138.83 72.76,138.83 72.76,145.58 66.14,145.58 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.37,138.9 86.05,138.9 85.98,145.58 79.37,145.58 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.92,138.9 92.66,138.9 92.53,145.51 85.92,145.51 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.53,138.83 99.28,138.83 99.15,145.58 92.53,145.58 " style="fill:rgba(0,0,0,1);" />
        <polygon points="99.15,138.9 105.89,138.9 105.76,145.51 99.15,145.51 " style="fill:rgba(0,0,0,1);" />
        <polygon points="105.76,138.83 112.51,138.83 112.37,145.51 105.76,145.51 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.37,138.83 119.12,138.83 118.99,145.58 112.37,145.58 " style="fill:rgba(0,0,0,1);" />
        <polygon points="118.99,138.9 125.67,138.9 125.6,145.51 118.99,145.51 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.28,138.83 138.96,138.83 138.9,145.58 132.28,145.58 " style="fill:rgba(0,0,0,1);" />
        <polygon points="138.83,138.9 145.51,138.9 145.45,145.51 138.83,145.51 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,145.45 72.82,145.45 72.76,152.13 66.14,152.13 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.69,145.51 79.44,145.51 79.3,152.13 72.69,152.13 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.3,145.45 85.98,145.45 85.92,152.13 79.3,152.13 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,145.45 99.21,145.45 99.21,152.13 92.6,152.13 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.44,145.45 119.06,145.45 119.06,152.13 112.44,152.13 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.28,145.45 138.9,145.45 138.9,152.13 132.28,152.13 " style="fill:rgba(0,0,0,1);" />
        `,
            },
            {
                value: 2,
                innerHtml: `<rect
      x="0"
      y="0"
      width="165.3543"
      height="165.3543"
      fill="red"
      style="fill:rgba(255,255,255,0);"
      shape-rendering="crispEdges"
    />
    <pattern
      id="glassc90e5498faaa405c98d9f9ff330814e1"
      x="13.22835"
      y="13.22835"
      width="138.8976"
      height="138.8976"
      patternUnits="userSpaceOnUse"
    >
      <rect x="0" y="0" width="138.8976" height="138.8976" style="fill:rgb(68,152,176);fill-opacity:1;" />
      <rect x="0" y="0" width="138.8976" height="69.44881" style="fill:rgb(80,164,188);fill-opacity:1;" />
    </pattern>
    <polygon
      points="13.23,29.76 13.55,26.54 14.49,23.44 16.02,20.58 18.07,18.07 20.58,16.02 23.44,14.49 26.54,13.55 29.76,13.23 59.53,13.23 59.53,59.53 13.23,59.53 13.23,29.76 19.84,29.76 19.84,52.91 52.91,52.91 52.91,19.84 29.76,19.84 27.2,20.18 24.8,21.17 22.75,22.75 21.17,24.8 20.18,27.2 19.84,29.76 "
      style="fill:url(#glassc90e5498faaa405c98d9f9ff330814e1);"
    />
    <polygon
      points="13.23,122.36 13.23,105.83 59.53,105.83 59.53,152.13 29.76,152.13 26.54,151.81 23.44,150.87 20.58,149.34 18.07,147.28 16.02,144.78 14.49,141.92 13.55,138.82 13.23,135.59 13.23,122.36 19.84,122.36 19.84,135.59 20.18,138.16 21.17,140.55 22.75,142.61 24.8,144.18 27.2,145.17 29.76,145.51 52.91,145.51 52.91,112.44 19.84,112.44 19.84,122.36 "
      style="fill:url(#glassc90e5498faaa405c98d9f9ff330814e1);"
    />
    <polygon
      points="105.83,29.76 105.83,13.23 135.59,13.23 138.82,13.55 141.92,14.49 144.78,16.02 147.28,18.07 149.34,20.58 150.87,23.44 151.81,26.54 152.13,29.76 152.13,59.53 105.83,59.53 105.83,29.76 112.44,29.76 112.44,52.91 145.51,52.91 145.51,29.76 145.17,27.2 144.18,24.8 142.61,22.75 140.55,21.17 138.16,20.18 135.59,19.84 112.44,19.84 112.44,29.76 "
      style="fill:url(#glassc90e5498faaa405c98d9f9ff330814e1);"
    />
    <linearGradient
      id="gradient9942a6e9fa9d459eb5f1f9ab88391ebf"
      gradientUnits="userSpaceOnUse"
      x1="16.1676322453161"
      y1="44.2778655522009"
      x2="149.18668446611"
      y2="121.076451159225"
    >
      <stop offset="0%" stop-color="#039898" />
      <stop offset="100%" stop-color="#2C6E9A" />
    </linearGradient>
    <polygon
      points="26.46,31.09 26.61,29.89 27.08,28.77 27.81,27.81 28.77,27.08 29.89,26.61 31.09,26.46 46.3,26.46 46.3,46.3 26.46,46.3 "
      style="fill:url(#gradient9942a6e9fa9d459eb5f1f9ab88391ebf);"
    />
    <polygon
      points="26.46,119.06 46.3,119.06 46.3,138.9 31.09,138.9 29.89,138.74 28.77,138.28 27.81,137.54 27.08,136.58 26.61,135.47 26.46,134.27 "
      style="fill:url(#gradient9942a6e9fa9d459eb5f1f9ab88391ebf);"
    />
    <polygon
      points="119.06,26.46 134.27,26.46 135.47,26.61 136.58,27.08 137.54,27.81 138.28,28.77 138.74,29.89 138.9,31.09 138.9,46.3 119.06,46.3 "
      style="fill:url(#gradient9942a6e9fa9d459eb5f1f9ab88391ebf);"
    />
    <polygon points="79.37,16.54 82.68,13.23 85.98,16.54 82.68,19.84 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,16.54 89.29,13.23 92.6,16.54 89.29,19.84 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,16.54 95.91,13.23 99.21,16.54 95.91,19.84 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,23.15 69.45,19.84 72.76,23.15 69.45,26.46 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,23.15 76.06,19.84 79.37,23.15 76.06,26.46 " style="fill:rgba(96,75,117,1);" />
    <polygon points="79.37,23.15 82.68,19.84 85.98,23.15 82.68,26.46 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,23.15 95.91,19.84 99.21,23.15 95.91,26.46 " style="fill:rgba(96,75,117,1);" />
    <polygon points="79.37,29.76 82.68,26.46 85.98,29.76 82.68,33.07 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,29.76 89.29,26.46 92.6,29.76 89.29,33.07 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,29.76 95.91,26.46 99.21,29.76 95.91,33.07 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,36.38 69.45,33.07 72.76,36.38 69.45,39.69 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,36.38 76.06,33.07 79.37,36.38 76.06,39.69 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,36.38 95.91,33.07 99.21,36.38 95.91,39.69 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,42.99 76.06,39.69 79.37,42.99 76.06,46.3 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,42.99 95.91,39.69 99.21,42.99 95.91,46.3 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,49.61 69.45,46.3 72.76,49.61 69.45,52.91 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,49.61 89.29,46.3 92.6,49.61 89.29,52.91 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,56.22 69.45,52.91 72.76,56.22 69.45,59.53 " style="fill:rgba(96,75,117,1);" />
    <polygon points="79.37,56.22 82.68,52.91 85.98,56.22 82.68,59.53 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,56.22 95.91,52.91 99.21,56.22 95.91,59.53 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,62.83 76.06,59.53 79.37,62.83 76.06,66.14 " style="fill:rgba(96,75,117,1);" />
    <polygon points="13.23,69.45 16.54,66.14 19.84,69.45 16.54,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="19.84,69.45 23.15,66.14 26.46,69.45 23.15,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="26.46,69.45 29.76,66.14 33.07,69.45 29.76,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="33.07,69.45 36.38,66.14 39.69,69.45 36.38,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="39.69,69.45 42.99,66.14 46.3,69.45 42.99,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="52.91,69.45 56.22,66.14 59.53,69.45 56.22,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="59.53,69.45 62.83,66.14 66.14,69.45 62.83,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,69.45 69.45,66.14 72.76,69.45 69.45,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,69.45 89.29,66.14 92.6,69.45 89.29,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="99.21,69.45 102.52,66.14 105.83,69.45 102.52,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,69.45 115.75,66.14 119.06,69.45 115.75,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="125.67,69.45 128.98,66.14 132.28,69.45 128.98,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="138.9,69.45 142.2,66.14 145.51,69.45 142.2,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="13.23,76.06 16.54,72.76 19.84,76.06 16.54,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="19.84,76.06 23.15,72.76 26.46,76.06 23.15,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="26.46,76.06 29.76,72.76 33.07,76.06 29.76,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="46.3,76.06 49.61,72.76 52.91,76.06 49.61,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="59.53,76.06 62.83,72.76 66.14,76.06 62.83,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,76.06 76.06,72.76 79.37,76.06 76.06,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,76.06 89.29,72.76 92.6,76.06 89.29,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,76.06 95.91,72.76 99.21,76.06 95.91,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="99.21,76.06 102.52,72.76 105.83,76.06 102.52,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="105.83,76.06 109.13,72.76 112.44,76.06 109.13,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="125.67,76.06 128.98,72.76 132.28,76.06 128.98,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,76.06 135.59,72.76 138.9,76.06 135.59,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="138.9,76.06 142.2,72.76 145.51,76.06 142.2,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="145.51,76.06 148.82,72.76 152.13,76.06 148.82,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="26.46,82.68 29.76,79.37 33.07,82.68 29.76,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="39.69,82.68 42.99,79.37 46.3,82.68 42.99,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="46.3,82.68 49.61,79.37 52.91,82.68 49.61,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="52.91,82.68 56.22,79.37 59.53,82.68 56.22,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,82.68 69.45,79.37 72.76,82.68 69.45,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,82.68 76.06,79.37 79.37,82.68 76.06,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,82.68 95.91,79.37 99.21,82.68 95.91,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="105.83,82.68 109.13,79.37 112.44,82.68 109.13,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,82.68 115.75,79.37 119.06,82.68 115.75,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="125.67,82.68 128.98,79.37 132.28,82.68 128.98,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="145.51,82.68 148.82,79.37 152.13,82.68 148.82,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="13.23,89.29 16.54,85.98 19.84,89.29 16.54,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="33.07,89.29 36.38,85.98 39.69,89.29 36.38,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,89.29 89.29,85.98 92.6,89.29 89.29,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,89.29 95.91,85.98 99.21,89.29 95.91,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="99.21,89.29 102.52,85.98 105.83,89.29 102.52,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="105.83,89.29 109.13,85.98 112.44,89.29 109.13,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,89.29 135.59,85.98 138.9,89.29 135.59,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="138.9,89.29 142.2,85.98 145.51,89.29 142.2,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="145.51,89.29 148.82,85.98 152.13,89.29 148.82,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="19.84,95.91 23.15,92.6 26.46,95.91 23.15,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="33.07,95.91 36.38,92.6 39.69,95.91 36.38,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="39.69,95.91 42.99,92.6 46.3,95.91 42.99,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="52.91,95.91 56.22,92.6 59.53,95.91 56.22,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,95.91 69.45,92.6 72.76,95.91 69.45,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,95.91 76.06,92.6 79.37,95.91 76.06,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,95.91 95.91,92.6 99.21,95.91 95.91,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,95.91 115.75,92.6 119.06,95.91 115.75,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="138.9,95.91 142.2,92.6 145.51,95.91 142.2,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,102.52 69.45,99.21 72.76,102.52 69.45,105.83 " style="fill:rgba(96,75,117,1);" />
    <polygon points="79.37,102.52 82.68,99.21 85.98,102.52 82.68,105.83 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,102.52 95.91,99.21 99.21,102.52 95.91,105.83 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,102.52 115.75,99.21 119.06,102.52 115.75,105.83 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,102.52 135.59,99.21 138.9,102.52 135.59,105.83 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,109.13 69.45,105.83 72.76,109.13 69.45,112.44 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,109.13 89.29,105.83 92.6,109.13 89.29,112.44 " style="fill:rgba(96,75,117,1);" />
    <polygon points="99.21,109.13 102.52,105.83 105.83,109.13 102.52,112.44 " style="fill:rgba(96,75,117,1);" />
    <polygon points="119.06,109.13 122.36,105.83 125.67,109.13 122.36,112.44 " style="fill:rgba(96,75,117,1);" />
    <polygon points="125.67,109.13 128.98,105.83 132.28,109.13 128.98,112.44 " style="fill:rgba(96,75,117,1);" />
    <polygon points="138.9,109.13 142.2,105.83 145.51,109.13 142.2,112.44 " style="fill:rgba(96,75,117,1);" />
    <polygon points="145.51,109.13 148.82,105.83 152.13,109.13 148.82,112.44 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,115.75 76.06,112.44 79.37,115.75 76.06,119.06 " style="fill:rgba(96,75,117,1);" />
    <polygon points="79.37,115.75 82.68,112.44 85.98,115.75 82.68,119.06 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,115.75 115.75,112.44 119.06,115.75 115.75,119.06 " style="fill:rgba(96,75,117,1);" />
    <polygon points="119.06,115.75 122.36,112.44 125.67,115.75 122.36,119.06 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,115.75 135.59,112.44 138.9,115.75 135.59,119.06 " style="fill:rgba(96,75,117,1);" />
    <polygon points="145.51,115.75 148.82,112.44 152.13,115.75 148.82,119.06 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,122.36 69.45,119.06 72.76,122.36 69.45,125.67 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,122.36 76.06,119.06 79.37,122.36 76.06,125.67 " style="fill:rgba(96,75,117,1);" />
    <polygon points="79.37,122.36 82.68,119.06 85.98,122.36 82.68,125.67 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,122.36 89.29,119.06 92.6,122.36 89.29,125.67 " style="fill:rgba(96,75,117,1);" />
    <polygon points="99.21,122.36 102.52,119.06 105.83,122.36 102.52,125.67 " style="fill:rgba(96,75,117,1);" />
    <polygon points="119.06,122.36 122.36,119.06 125.67,122.36 122.36,125.67 " style="fill:rgba(96,75,117,1);" />
    <polygon points="125.67,122.36 128.98,119.06 132.28,122.36 128.98,125.67 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,122.36 135.59,119.06 138.9,122.36 135.59,125.67 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,128.98 69.45,125.67 72.76,128.98 69.45,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,128.98 76.06,125.67 79.37,128.98 76.06,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,128.98 89.29,125.67 92.6,128.98 89.29,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,128.98 95.91,125.67 99.21,128.98 95.91,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="99.21,128.98 102.52,125.67 105.83,128.98 102.52,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="105.83,128.98 109.13,125.67 112.44,128.98 109.13,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,128.98 115.75,125.67 119.06,128.98 115.75,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="125.67,128.98 128.98,125.67 132.28,128.98 128.98,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,128.98 135.59,125.67 138.9,128.98 135.59,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,135.59 69.45,132.28 72.76,135.59 69.45,138.9 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,135.59 76.06,132.28 79.37,135.59 76.06,138.9 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,135.59 95.91,132.28 99.21,135.59 95.91,138.9 " style="fill:rgba(96,75,117,1);" />
    <polygon points="105.83,135.59 109.13,132.28 112.44,135.59 109.13,138.9 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,135.59 115.75,132.28 119.06,135.59 115.75,138.9 " style="fill:rgba(96,75,117,1);" />
    <polygon points="125.67,135.59 128.98,132.28 132.28,135.59 128.98,138.9 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,135.59 135.59,132.28 138.9,135.59 135.59,138.9 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,142.2 69.45,138.9 72.76,142.2 69.45,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="79.37,142.2 82.68,138.9 85.98,142.2 82.68,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,142.2 89.29,138.9 92.6,142.2 89.29,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,142.2 95.91,138.9 99.21,142.2 95.91,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="99.21,142.2 102.52,138.9 105.83,142.2 102.52,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="105.83,142.2 109.13,138.9 112.44,142.2 109.13,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,142.2 115.75,138.9 119.06,142.2 115.75,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="119.06,142.2 122.36,138.9 125.67,142.2 122.36,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,142.2 135.59,138.9 138.9,142.2 135.59,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="138.9,142.2 142.2,138.9 145.51,142.2 142.2,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,148.82 69.45,145.51 72.76,148.82 69.45,152.13 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,148.82 76.06,145.51 79.37,148.82 76.06,152.13 " style="fill:rgba(96,75,117,1);" />
    <polygon points="79.37,148.82 82.68,145.51 85.98,148.82 82.68,152.13 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,148.82 95.91,145.51 99.21,148.82 95.91,152.13 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,148.82 115.75,145.51 119.06,148.82 115.75,152.13 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,148.82 135.59,145.51 138.9,148.82 135.59,152.13 " style="fill:rgba(96,75,117,1);" />
      `,
            },
            {
                value: 3,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(255,255,255,0);"
            shape-rendering="crispEdges"
          />
          <pattern
            id="glass24c3381e8d144e708cc01571cde7c032"
            x="13.22835"
            y="13.22835"
            width="138.8976"
            height="138.8976"
            patternUnits="userSpaceOnUse"
          >
            <rect x="0" y="0" width="138.8976" height="138.8976" style="fill:rgb(57,94,133);fill-opacity:1;" />
            <rect x="0" y="0" width="138.8976" height="69.44881" style="fill:rgb(69,106,145);fill-opacity:1;" />
          </pattern>
          <polygon
            points="59.53,36.38 59.08,40.89 57.77,45.24 55.63,49.24 52.75,52.75 49.24,55.63 45.24,57.77 40.89,59.08 36.38,59.53 31.86,59.08 27.52,57.77 23.52,55.63 20.01,52.75 17.13,49.24 14.99,45.24 13.67,40.89 13.23,36.38 13.67,31.86 14.99,27.52 17.13,23.52 20.01,20.01 23.52,17.13 27.52,14.99 31.86,13.67 36.38,13.23 40.89,13.67 45.24,14.99 49.24,17.13 52.75,20.01 55.63,23.52 57.77,27.52 59.08,31.86 59.53,36.38 52.91,36.38 52.6,33.15 51.65,30.05 50.13,27.19 48.07,24.69 45.56,22.63 42.71,21.1 39.6,20.16 36.38,19.84 33.15,20.16 30.05,21.1 27.19,22.63 24.69,24.69 22.63,27.19 21.1,30.05 20.16,33.15 19.84,36.38 20.16,39.6 21.1,42.71 22.63,45.56 24.69,48.07 27.19,50.13 30.05,51.65 33.15,52.6 36.38,52.91 39.6,52.6 42.71,51.65 45.56,50.13 48.07,48.07 50.13,45.56 51.65,42.71 52.6,39.6 52.91,36.38 "
            style="fill:url(#glass24c3381e8d144e708cc01571cde7c032);"
          />
          <polygon
            points="59.53,128.98 59.08,133.49 57.77,137.84 55.63,141.84 52.75,145.35 49.24,148.22 45.24,150.36 40.89,151.68 36.38,152.13 31.86,151.68 27.52,150.36 23.52,148.22 20.01,145.35 17.13,141.84 14.99,137.84 13.67,133.49 13.23,128.98 13.67,124.46 14.99,120.12 17.13,116.12 20.01,112.61 23.52,109.73 27.52,107.59 31.86,106.27 36.38,105.83 40.89,106.27 45.24,107.59 49.24,109.73 52.75,112.61 55.63,116.12 57.77,120.12 59.08,124.46 59.53,128.98 52.91,128.98 52.6,125.75 51.65,122.65 50.13,119.79 48.07,117.28 45.56,115.23 42.71,113.7 39.6,112.76 36.38,112.44 33.15,112.76 30.05,113.7 27.19,115.23 24.69,117.28 22.63,119.79 21.1,122.65 20.16,125.75 19.84,128.98 20.16,132.2 21.1,135.3 22.63,138.16 24.69,140.67 27.19,142.73 30.05,144.25 33.15,145.19 36.38,145.51 39.6,145.19 42.71,144.25 45.56,142.73 48.07,140.67 50.13,138.16 51.65,135.3 52.6,132.2 52.91,128.98 "
            style="fill:url(#glass24c3381e8d144e708cc01571cde7c032);"
          />
          <polygon
            points="152.13,36.38 151.68,40.89 150.36,45.24 148.22,49.24 145.35,52.75 141.84,55.63 137.84,57.77 133.49,59.08 128.98,59.53 124.46,59.08 120.12,57.77 116.12,55.63 112.61,52.75 109.73,49.24 107.59,45.24 106.27,40.89 105.83,36.38 106.27,31.86 107.59,27.52 109.73,23.52 112.61,20.01 116.12,17.13 120.12,14.99 124.46,13.67 128.98,13.23 133.49,13.67 137.84,14.99 141.84,17.13 145.35,20.01 148.22,23.52 150.36,27.52 151.68,31.86 152.13,36.38 145.51,36.38 145.19,33.15 144.25,30.05 142.73,27.19 140.67,24.69 138.16,22.63 135.3,21.1 132.2,20.16 128.98,19.84 125.75,20.16 122.65,21.1 119.79,22.63 117.28,24.69 115.23,27.19 113.7,30.05 112.76,33.15 112.44,36.38 112.76,39.6 113.7,42.71 115.23,45.56 117.28,48.07 119.79,50.13 122.65,51.65 125.75,52.6 128.98,52.91 132.2,52.6 135.3,51.65 138.16,50.13 140.67,48.07 142.73,45.56 144.25,42.71 145.19,39.6 145.51,36.38 "
            style="fill:url(#glass24c3381e8d144e708cc01571cde7c032);"
          />
          <linearGradient
            id="gradientace97d5e2e9b44daa7466b1acf42cbdc"
            gradientUnits="userSpaceOnUse"
            x1="22.0024585616932"
            y1="77.3688099608975"
            x2="143.351858149733"
            y2="87.9855067505283"
          >
            <stop offset="0%" stop-color="#647335" />
            <stop offset="50%" stop-color="#89496A" />
            <stop offset="100%" stop-color="#647335" />
          </linearGradient>
          <polygon
            points="46.3,36.38 46.11,38.31 45.54,40.17 44.63,41.89 43.39,43.39 41.89,44.63 40.17,45.54 38.31,46.11 36.38,46.3 34.44,46.11 32.58,45.54 30.87,44.63 29.36,43.39 28.13,41.89 27.21,40.17 26.65,38.31 26.46,36.38 26.65,34.44 27.21,32.58 28.13,30.87 29.36,29.36 30.87,28.13 32.58,27.21 34.44,26.65 36.38,26.46 38.31,26.65 40.17,27.21 41.89,28.13 43.39,29.36 44.63,30.87 45.54,32.58 46.11,34.44 46.3,36.38 "
            style="fill:url(#gradientace97d5e2e9b44daa7466b1acf42cbdc);"
          />
          <polygon
            points="46.3,128.98 46.11,130.91 45.54,132.77 44.63,134.49 43.39,135.99 41.89,137.23 40.17,138.14 38.31,138.71 36.38,138.9 34.44,138.71 32.58,138.14 30.87,137.23 29.36,135.99 28.13,134.49 27.21,132.77 26.65,130.91 26.46,128.98 26.65,127.04 27.21,125.18 28.13,123.46 29.36,121.96 30.87,120.73 32.58,119.81 34.44,119.25 36.38,119.06 38.31,119.25 40.17,119.81 41.89,120.73 43.39,121.96 44.63,123.46 45.54,125.18 46.11,127.04 46.3,128.98 "
            style="fill:url(#gradientace97d5e2e9b44daa7466b1acf42cbdc);"
          />
          <polygon
            points="138.9,36.38 138.71,38.31 138.14,40.17 137.23,41.89 135.99,43.39 134.49,44.63 132.77,45.54 130.91,46.11 128.98,46.3 127.04,46.11 125.18,45.54 123.46,44.63 121.96,43.39 120.73,41.89 119.81,40.17 119.25,38.31 119.06,36.38 119.25,34.44 119.81,32.58 120.73,30.87 121.96,29.36 123.46,28.13 125.18,27.21 127.04,26.65 128.98,26.46 130.91,26.65 132.77,27.21 134.49,28.13 135.99,29.36 137.23,30.87 138.14,32.58 138.71,34.44 138.9,36.38 "
            style="fill:url(#gradientace97d5e2e9b44daa7466b1acf42cbdc);"
          />
          <polygon
            points="85.98,16.54 85.73,17.8 85.02,18.87 83.94,19.59 82.68,19.84 81.41,19.59 80.34,18.87 79.62,17.8 79.37,16.54 79.62,15.27 80.34,14.2 81.41,13.48 82.68,13.23 83.94,13.48 85.02,14.2 85.73,15.27 85.98,16.54 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,16.54 92.35,17.8 91.63,18.87 90.56,19.59 89.29,19.84 88.03,19.59 86.95,18.87 86.24,17.8 85.98,16.54 86.24,15.27 86.95,14.2 88.03,13.48 89.29,13.23 90.56,13.48 91.63,14.2 92.35,15.27 92.6,16.54 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,16.54 98.96,17.8 98.24,18.87 97.17,19.59 95.91,19.84 94.64,19.59 93.57,18.87 92.85,17.8 92.6,16.54 92.85,15.27 93.57,14.2 94.64,13.48 95.91,13.23 97.17,13.48 98.24,14.2 98.96,15.27 99.21,16.54 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,23.15 72.5,24.42 71.79,25.49 70.71,26.2 69.45,26.46 68.18,26.2 67.11,25.49 66.39,24.42 66.14,23.15 66.39,21.88 67.11,20.81 68.18,20.09 69.45,19.84 70.71,20.09 71.79,20.81 72.5,21.88 72.76,23.15 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,23.15 79.12,24.42 78.4,25.49 77.33,26.2 76.06,26.46 74.8,26.2 73.72,25.49 73.01,24.42 72.76,23.15 73.01,21.88 73.72,20.81 74.8,20.09 76.06,19.84 77.33,20.09 78.4,20.81 79.12,21.88 79.37,23.15 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="85.98,23.15 85.73,24.42 85.02,25.49 83.94,26.2 82.68,26.46 81.41,26.2 80.34,25.49 79.62,24.42 79.37,23.15 79.62,21.88 80.34,20.81 81.41,20.09 82.68,19.84 83.94,20.09 85.02,20.81 85.73,21.88 85.98,23.15 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,23.15 98.96,24.42 98.24,25.49 97.17,26.2 95.91,26.46 94.64,26.2 93.57,25.49 92.85,24.42 92.6,23.15 92.85,21.88 93.57,20.81 94.64,20.09 95.91,19.84 97.17,20.09 98.24,20.81 98.96,21.88 99.21,23.15 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="85.98,29.76 85.73,31.03 85.02,32.1 83.94,32.82 82.68,33.07 81.41,32.82 80.34,32.1 79.62,31.03 79.37,29.76 79.62,28.5 80.34,27.43 81.41,26.71 82.68,26.46 83.94,26.71 85.02,27.43 85.73,28.5 85.98,29.76 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,29.76 92.35,31.03 91.63,32.1 90.56,32.82 89.29,33.07 88.03,32.82 86.95,32.1 86.24,31.03 85.98,29.76 86.24,28.5 86.95,27.43 88.03,26.71 89.29,26.46 90.56,26.71 91.63,27.43 92.35,28.5 92.6,29.76 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,29.76 98.96,31.03 98.24,32.1 97.17,32.82 95.91,33.07 94.64,32.82 93.57,32.1 92.85,31.03 92.6,29.76 92.85,28.5 93.57,27.43 94.64,26.71 95.91,26.46 97.17,26.71 98.24,27.43 98.96,28.5 99.21,29.76 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,36.38 72.5,37.64 71.79,38.72 70.71,39.43 69.45,39.69 68.18,39.43 67.11,38.72 66.39,37.64 66.14,36.38 66.39,35.11 67.11,34.04 68.18,33.32 69.45,33.07 70.71,33.32 71.79,34.04 72.5,35.11 72.76,36.38 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,36.38 79.12,37.64 78.4,38.72 77.33,39.43 76.06,39.69 74.8,39.43 73.72,38.72 73.01,37.64 72.76,36.38 73.01,35.11 73.72,34.04 74.8,33.32 76.06,33.07 77.33,33.32 78.4,34.04 79.12,35.11 79.37,36.38 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,36.38 98.96,37.64 98.24,38.72 97.17,39.43 95.91,39.69 94.64,39.43 93.57,38.72 92.85,37.64 92.6,36.38 92.85,35.11 93.57,34.04 94.64,33.32 95.91,33.07 97.17,33.32 98.24,34.04 98.96,35.11 99.21,36.38 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,42.99 79.12,44.26 78.4,45.33 77.33,46.05 76.06,46.3 74.8,46.05 73.72,45.33 73.01,44.26 72.76,42.99 73.01,41.73 73.72,40.65 74.8,39.94 76.06,39.69 77.33,39.94 78.4,40.65 79.12,41.73 79.37,42.99 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,42.99 98.96,44.26 98.24,45.33 97.17,46.05 95.91,46.3 94.64,46.05 93.57,45.33 92.85,44.26 92.6,42.99 92.85,41.73 93.57,40.65 94.64,39.94 95.91,39.69 97.17,39.94 98.24,40.65 98.96,41.73 99.21,42.99 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,49.61 72.5,50.87 71.79,51.94 70.71,52.66 69.45,52.91 68.18,52.66 67.11,51.94 66.39,50.87 66.14,49.61 66.39,48.34 67.11,47.27 68.18,46.55 69.45,46.3 70.71,46.55 71.79,47.27 72.5,48.34 72.76,49.61 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,49.61 92.35,50.87 91.63,51.94 90.56,52.66 89.29,52.91 88.03,52.66 86.95,51.94 86.24,50.87 85.98,49.61 86.24,48.34 86.95,47.27 88.03,46.55 89.29,46.3 90.56,46.55 91.63,47.27 92.35,48.34 92.6,49.61 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,56.22 72.5,57.49 71.79,58.56 70.71,59.28 69.45,59.53 68.18,59.28 67.11,58.56 66.39,57.49 66.14,56.22 66.39,54.95 67.11,53.88 68.18,53.17 69.45,52.91 70.71,53.17 71.79,53.88 72.5,54.95 72.76,56.22 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="85.98,56.22 85.73,57.49 85.02,58.56 83.94,59.28 82.68,59.53 81.41,59.28 80.34,58.56 79.62,57.49 79.37,56.22 79.62,54.95 80.34,53.88 81.41,53.17 82.68,52.91 83.94,53.17 85.02,53.88 85.73,54.95 85.98,56.22 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,56.22 98.96,57.49 98.24,58.56 97.17,59.28 95.91,59.53 94.64,59.28 93.57,58.56 92.85,57.49 92.6,56.22 92.85,54.95 93.57,53.88 94.64,53.17 95.91,52.91 97.17,53.17 98.24,53.88 98.96,54.95 99.21,56.22 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,62.83 79.12,64.1 78.4,65.17 77.33,65.89 76.06,66.14 74.8,65.89 73.72,65.17 73.01,64.1 72.76,62.83 73.01,61.57 73.72,60.5 74.8,59.78 76.06,59.53 77.33,59.78 78.4,60.5 79.12,61.57 79.37,62.83 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="19.84,69.45 19.59,70.71 18.87,71.79 17.8,72.5 16.54,72.76 15.27,72.5 14.2,71.79 13.48,70.71 13.23,69.45 13.48,68.18 14.2,67.11 15.27,66.39 16.54,66.14 17.8,66.39 18.87,67.11 19.59,68.18 19.84,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="26.46,69.45 26.2,70.71 25.49,71.79 24.42,72.5 23.15,72.76 21.88,72.5 20.81,71.79 20.09,70.71 19.84,69.45 20.09,68.18 20.81,67.11 21.88,66.39 23.15,66.14 24.42,66.39 25.49,67.11 26.2,68.18 26.46,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="33.07,69.45 32.82,70.71 32.1,71.79 31.03,72.5 29.76,72.76 28.5,72.5 27.43,71.79 26.71,70.71 26.46,69.45 26.71,68.18 27.43,67.11 28.5,66.39 29.76,66.14 31.03,66.39 32.1,67.11 32.82,68.18 33.07,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="39.69,69.45 39.43,70.71 38.72,71.79 37.64,72.5 36.38,72.76 35.11,72.5 34.04,71.79 33.32,70.71 33.07,69.45 33.32,68.18 34.04,67.11 35.11,66.39 36.38,66.14 37.64,66.39 38.72,67.11 39.43,68.18 39.69,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="46.3,69.45 46.05,70.71 45.33,71.79 44.26,72.5 42.99,72.76 41.73,72.5 40.65,71.79 39.94,70.71 39.69,69.45 39.94,68.18 40.65,67.11 41.73,66.39 42.99,66.14 44.26,66.39 45.33,67.11 46.05,68.18 46.3,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="59.53,69.45 59.28,70.71 58.56,71.79 57.49,72.5 56.22,72.76 54.95,72.5 53.88,71.79 53.17,70.71 52.91,69.45 53.17,68.18 53.88,67.11 54.95,66.39 56.22,66.14 57.49,66.39 58.56,67.11 59.28,68.18 59.53,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="66.14,69.45 65.89,70.71 65.17,71.79 64.1,72.5 62.83,72.76 61.57,72.5 60.5,71.79 59.78,70.71 59.53,69.45 59.78,68.18 60.5,67.11 61.57,66.39 62.83,66.14 64.1,66.39 65.17,67.11 65.89,68.18 66.14,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,69.45 72.5,70.71 71.79,71.79 70.71,72.5 69.45,72.76 68.18,72.5 67.11,71.79 66.39,70.71 66.14,69.45 66.39,68.18 67.11,67.11 68.18,66.39 69.45,66.14 70.71,66.39 71.79,67.11 72.5,68.18 72.76,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,69.45 92.35,70.71 91.63,71.79 90.56,72.5 89.29,72.76 88.03,72.5 86.95,71.79 86.24,70.71 85.98,69.45 86.24,68.18 86.95,67.11 88.03,66.39 89.29,66.14 90.56,66.39 91.63,67.11 92.35,68.18 92.6,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="105.83,69.45 105.58,70.71 104.86,71.79 103.79,72.5 102.52,72.76 101.25,72.5 100.18,71.79 99.46,70.71 99.21,69.45 99.46,68.18 100.18,67.11 101.25,66.39 102.52,66.14 103.79,66.39 104.86,67.11 105.58,68.18 105.83,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="119.06,69.45 118.8,70.71 118.09,71.79 117.01,72.5 115.75,72.76 114.48,72.5 113.41,71.79 112.69,70.71 112.44,69.45 112.69,68.18 113.41,67.11 114.48,66.39 115.75,66.14 117.01,66.39 118.09,67.11 118.8,68.18 119.06,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="132.28,69.45 132.03,70.71 131.31,71.79 130.24,72.5 128.98,72.76 127.71,72.5 126.64,71.79 125.92,70.71 125.67,69.45 125.92,68.18 126.64,67.11 127.71,66.39 128.98,66.14 130.24,66.39 131.31,67.11 132.03,68.18 132.28,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="145.51,69.45 145.26,70.71 144.54,71.79 143.47,72.5 142.2,72.76 140.94,72.5 139.87,71.79 139.15,70.71 138.9,69.45 139.15,68.18 139.87,67.11 140.94,66.39 142.2,66.14 143.47,66.39 144.54,67.11 145.26,68.18 145.51,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="19.84,76.06 19.59,77.33 18.87,78.4 17.8,79.12 16.54,79.37 15.27,79.12 14.2,78.4 13.48,77.33 13.23,76.06 13.48,74.8 14.2,73.72 15.27,73.01 16.54,72.76 17.8,73.01 18.87,73.72 19.59,74.8 19.84,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="26.46,76.06 26.2,77.33 25.49,78.4 24.42,79.12 23.15,79.37 21.88,79.12 20.81,78.4 20.09,77.33 19.84,76.06 20.09,74.8 20.81,73.72 21.88,73.01 23.15,72.76 24.42,73.01 25.49,73.72 26.2,74.8 26.46,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="33.07,76.06 32.82,77.33 32.1,78.4 31.03,79.12 29.76,79.37 28.5,79.12 27.43,78.4 26.71,77.33 26.46,76.06 26.71,74.8 27.43,73.72 28.5,73.01 29.76,72.76 31.03,73.01 32.1,73.72 32.82,74.8 33.07,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="52.91,76.06 52.66,77.33 51.94,78.4 50.87,79.12 49.61,79.37 48.34,79.12 47.27,78.4 46.55,77.33 46.3,76.06 46.55,74.8 47.27,73.72 48.34,73.01 49.61,72.76 50.87,73.01 51.94,73.72 52.66,74.8 52.91,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="66.14,76.06 65.89,77.33 65.17,78.4 64.1,79.12 62.83,79.37 61.57,79.12 60.5,78.4 59.78,77.33 59.53,76.06 59.78,74.8 60.5,73.72 61.57,73.01 62.83,72.76 64.1,73.01 65.17,73.72 65.89,74.8 66.14,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,76.06 79.12,77.33 78.4,78.4 77.33,79.12 76.06,79.37 74.8,79.12 73.72,78.4 73.01,77.33 72.76,76.06 73.01,74.8 73.72,73.72 74.8,73.01 76.06,72.76 77.33,73.01 78.4,73.72 79.12,74.8 79.37,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,76.06 92.35,77.33 91.63,78.4 90.56,79.12 89.29,79.37 88.03,79.12 86.95,78.4 86.24,77.33 85.98,76.06 86.24,74.8 86.95,73.72 88.03,73.01 89.29,72.76 90.56,73.01 91.63,73.72 92.35,74.8 92.6,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,76.06 98.96,77.33 98.24,78.4 97.17,79.12 95.91,79.37 94.64,79.12 93.57,78.4 92.85,77.33 92.6,76.06 92.85,74.8 93.57,73.72 94.64,73.01 95.91,72.76 97.17,73.01 98.24,73.72 98.96,74.8 99.21,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="105.83,76.06 105.58,77.33 104.86,78.4 103.79,79.12 102.52,79.37 101.25,79.12 100.18,78.4 99.46,77.33 99.21,76.06 99.46,74.8 100.18,73.72 101.25,73.01 102.52,72.76 103.79,73.01 104.86,73.72 105.58,74.8 105.83,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="112.44,76.06 112.19,77.33 111.47,78.4 110.4,79.12 109.13,79.37 107.87,79.12 106.8,78.4 106.08,77.33 105.83,76.06 106.08,74.8 106.8,73.72 107.87,73.01 109.13,72.76 110.4,73.01 111.47,73.72 112.19,74.8 112.44,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="132.28,76.06 132.03,77.33 131.31,78.4 130.24,79.12 128.98,79.37 127.71,79.12 126.64,78.4 125.92,77.33 125.67,76.06 125.92,74.8 126.64,73.72 127.71,73.01 128.98,72.76 130.24,73.01 131.31,73.72 132.03,74.8 132.28,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="138.9,76.06 138.65,77.33 137.93,78.4 136.86,79.12 135.59,79.37 134.32,79.12 133.25,78.4 132.54,77.33 132.28,76.06 132.54,74.8 133.25,73.72 134.32,73.01 135.59,72.76 136.86,73.01 137.93,73.72 138.65,74.8 138.9,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="145.51,76.06 145.26,77.33 144.54,78.4 143.47,79.12 142.2,79.37 140.94,79.12 139.87,78.4 139.15,77.33 138.9,76.06 139.15,74.8 139.87,73.72 140.94,73.01 142.2,72.76 143.47,73.01 144.54,73.72 145.26,74.8 145.51,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="152.13,76.06 151.87,77.33 151.16,78.4 150.08,79.12 148.82,79.37 147.55,79.12 146.48,78.4 145.76,77.33 145.51,76.06 145.76,74.8 146.48,73.72 147.55,73.01 148.82,72.76 150.08,73.01 151.16,73.72 151.87,74.8 152.13,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="33.07,82.68 32.82,83.94 32.1,85.02 31.03,85.73 29.76,85.98 28.5,85.73 27.43,85.02 26.71,83.94 26.46,82.68 26.71,81.41 27.43,80.34 28.5,79.62 29.76,79.37 31.03,79.62 32.1,80.34 32.82,81.41 33.07,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="46.3,82.68 46.05,83.94 45.33,85.02 44.26,85.73 42.99,85.98 41.73,85.73 40.65,85.02 39.94,83.94 39.69,82.68 39.94,81.41 40.65,80.34 41.73,79.62 42.99,79.37 44.26,79.62 45.33,80.34 46.05,81.41 46.3,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="52.91,82.68 52.66,83.94 51.94,85.02 50.87,85.73 49.61,85.98 48.34,85.73 47.27,85.02 46.55,83.94 46.3,82.68 46.55,81.41 47.27,80.34 48.34,79.62 49.61,79.37 50.87,79.62 51.94,80.34 52.66,81.41 52.91,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="59.53,82.68 59.28,83.94 58.56,85.02 57.49,85.73 56.22,85.98 54.95,85.73 53.88,85.02 53.17,83.94 52.91,82.68 53.17,81.41 53.88,80.34 54.95,79.62 56.22,79.37 57.49,79.62 58.56,80.34 59.28,81.41 59.53,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,82.68 72.5,83.94 71.79,85.02 70.71,85.73 69.45,85.98 68.18,85.73 67.11,85.02 66.39,83.94 66.14,82.68 66.39,81.41 67.11,80.34 68.18,79.62 69.45,79.37 70.71,79.62 71.79,80.34 72.5,81.41 72.76,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,82.68 79.12,83.94 78.4,85.02 77.33,85.73 76.06,85.98 74.8,85.73 73.72,85.02 73.01,83.94 72.76,82.68 73.01,81.41 73.72,80.34 74.8,79.62 76.06,79.37 77.33,79.62 78.4,80.34 79.12,81.41 79.37,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,82.68 98.96,83.94 98.24,85.02 97.17,85.73 95.91,85.98 94.64,85.73 93.57,85.02 92.85,83.94 92.6,82.68 92.85,81.41 93.57,80.34 94.64,79.62 95.91,79.37 97.17,79.62 98.24,80.34 98.96,81.41 99.21,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="112.44,82.68 112.19,83.94 111.47,85.02 110.4,85.73 109.13,85.98 107.87,85.73 106.8,85.02 106.08,83.94 105.83,82.68 106.08,81.41 106.8,80.34 107.87,79.62 109.13,79.37 110.4,79.62 111.47,80.34 112.19,81.41 112.44,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="119.06,82.68 118.8,83.94 118.09,85.02 117.01,85.73 115.75,85.98 114.48,85.73 113.41,85.02 112.69,83.94 112.44,82.68 112.69,81.41 113.41,80.34 114.48,79.62 115.75,79.37 117.01,79.62 118.09,80.34 118.8,81.41 119.06,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="132.28,82.68 132.03,83.94 131.31,85.02 130.24,85.73 128.98,85.98 127.71,85.73 126.64,85.02 125.92,83.94 125.67,82.68 125.92,81.41 126.64,80.34 127.71,79.62 128.98,79.37 130.24,79.62 131.31,80.34 132.03,81.41 132.28,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="152.13,82.68 151.87,83.94 151.16,85.02 150.08,85.73 148.82,85.98 147.55,85.73 146.48,85.02 145.76,83.94 145.51,82.68 145.76,81.41 146.48,80.34 147.55,79.62 148.82,79.37 150.08,79.62 151.16,80.34 151.87,81.41 152.13,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="19.84,89.29 19.59,90.56 18.87,91.63 17.8,92.35 16.54,92.6 15.27,92.35 14.2,91.63 13.48,90.56 13.23,89.29 13.48,88.03 14.2,86.95 15.27,86.24 16.54,85.98 17.8,86.24 18.87,86.95 19.59,88.03 19.84,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="39.69,89.29 39.43,90.56 38.72,91.63 37.64,92.35 36.38,92.6 35.11,92.35 34.04,91.63 33.32,90.56 33.07,89.29 33.32,88.03 34.04,86.95 35.11,86.24 36.38,85.98 37.64,86.24 38.72,86.95 39.43,88.03 39.69,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,89.29 92.35,90.56 91.63,91.63 90.56,92.35 89.29,92.6 88.03,92.35 86.95,91.63 86.24,90.56 85.98,89.29 86.24,88.03 86.95,86.95 88.03,86.24 89.29,85.98 90.56,86.24 91.63,86.95 92.35,88.03 92.6,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,89.29 98.96,90.56 98.24,91.63 97.17,92.35 95.91,92.6 94.64,92.35 93.57,91.63 92.85,90.56 92.6,89.29 92.85,88.03 93.57,86.95 94.64,86.24 95.91,85.98 97.17,86.24 98.24,86.95 98.96,88.03 99.21,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="105.83,89.29 105.58,90.56 104.86,91.63 103.79,92.35 102.52,92.6 101.25,92.35 100.18,91.63 99.46,90.56 99.21,89.29 99.46,88.03 100.18,86.95 101.25,86.24 102.52,85.98 103.79,86.24 104.86,86.95 105.58,88.03 105.83,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="112.44,89.29 112.19,90.56 111.47,91.63 110.4,92.35 109.13,92.6 107.87,92.35 106.8,91.63 106.08,90.56 105.83,89.29 106.08,88.03 106.8,86.95 107.87,86.24 109.13,85.98 110.4,86.24 111.47,86.95 112.19,88.03 112.44,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="138.9,89.29 138.65,90.56 137.93,91.63 136.86,92.35 135.59,92.6 134.32,92.35 133.25,91.63 132.54,90.56 132.28,89.29 132.54,88.03 133.25,86.95 134.32,86.24 135.59,85.98 136.86,86.24 137.93,86.95 138.65,88.03 138.9,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="145.51,89.29 145.26,90.56 144.54,91.63 143.47,92.35 142.2,92.6 140.94,92.35 139.87,91.63 139.15,90.56 138.9,89.29 139.15,88.03 139.87,86.95 140.94,86.24 142.2,85.98 143.47,86.24 144.54,86.95 145.26,88.03 145.51,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="152.13,89.29 151.87,90.56 151.16,91.63 150.08,92.35 148.82,92.6 147.55,92.35 146.48,91.63 145.76,90.56 145.51,89.29 145.76,88.03 146.48,86.95 147.55,86.24 148.82,85.98 150.08,86.24 151.16,86.95 151.87,88.03 152.13,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="26.46,95.91 26.2,97.17 25.49,98.24 24.42,98.96 23.15,99.21 21.88,98.96 20.81,98.24 20.09,97.17 19.84,95.91 20.09,94.64 20.81,93.57 21.88,92.85 23.15,92.6 24.42,92.85 25.49,93.57 26.2,94.64 26.46,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="39.69,95.91 39.43,97.17 38.72,98.24 37.64,98.96 36.38,99.21 35.11,98.96 34.04,98.24 33.32,97.17 33.07,95.91 33.32,94.64 34.04,93.57 35.11,92.85 36.38,92.6 37.64,92.85 38.72,93.57 39.43,94.64 39.69,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="46.3,95.91 46.05,97.17 45.33,98.24 44.26,98.96 42.99,99.21 41.73,98.96 40.65,98.24 39.94,97.17 39.69,95.91 39.94,94.64 40.65,93.57 41.73,92.85 42.99,92.6 44.26,92.85 45.33,93.57 46.05,94.64 46.3,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="59.53,95.91 59.28,97.17 58.56,98.24 57.49,98.96 56.22,99.21 54.95,98.96 53.88,98.24 53.17,97.17 52.91,95.91 53.17,94.64 53.88,93.57 54.95,92.85 56.22,92.6 57.49,92.85 58.56,93.57 59.28,94.64 59.53,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,95.91 72.5,97.17 71.79,98.24 70.71,98.96 69.45,99.21 68.18,98.96 67.11,98.24 66.39,97.17 66.14,95.91 66.39,94.64 67.11,93.57 68.18,92.85 69.45,92.6 70.71,92.85 71.79,93.57 72.5,94.64 72.76,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,95.91 79.12,97.17 78.4,98.24 77.33,98.96 76.06,99.21 74.8,98.96 73.72,98.24 73.01,97.17 72.76,95.91 73.01,94.64 73.72,93.57 74.8,92.85 76.06,92.6 77.33,92.85 78.4,93.57 79.12,94.64 79.37,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,95.91 98.96,97.17 98.24,98.24 97.17,98.96 95.91,99.21 94.64,98.96 93.57,98.24 92.85,97.17 92.6,95.91 92.85,94.64 93.57,93.57 94.64,92.85 95.91,92.6 97.17,92.85 98.24,93.57 98.96,94.64 99.21,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="119.06,95.91 118.8,97.17 118.09,98.24 117.01,98.96 115.75,99.21 114.48,98.96 113.41,98.24 112.69,97.17 112.44,95.91 112.69,94.64 113.41,93.57 114.48,92.85 115.75,92.6 117.01,92.85 118.09,93.57 118.8,94.64 119.06,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="145.51,95.91 145.26,97.17 144.54,98.24 143.47,98.96 142.2,99.21 140.94,98.96 139.87,98.24 139.15,97.17 138.9,95.91 139.15,94.64 139.87,93.57 140.94,92.85 142.2,92.6 143.47,92.85 144.54,93.57 145.26,94.64 145.51,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,102.52 72.5,103.79 71.79,104.86 70.71,105.58 69.45,105.83 68.18,105.58 67.11,104.86 66.39,103.79 66.14,102.52 66.39,101.25 67.11,100.18 68.18,99.46 69.45,99.21 70.71,99.46 71.79,100.18 72.5,101.25 72.76,102.52 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="85.98,102.52 85.73,103.79 85.02,104.86 83.94,105.58 82.68,105.83 81.41,105.58 80.34,104.86 79.62,103.79 79.37,102.52 79.62,101.25 80.34,100.18 81.41,99.46 82.68,99.21 83.94,99.46 85.02,100.18 85.73,101.25 85.98,102.52 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,102.52 98.96,103.79 98.24,104.86 97.17,105.58 95.91,105.83 94.64,105.58 93.57,104.86 92.85,103.79 92.6,102.52 92.85,101.25 93.57,100.18 94.64,99.46 95.91,99.21 97.17,99.46 98.24,100.18 98.96,101.25 99.21,102.52 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="119.06,102.52 118.8,103.79 118.09,104.86 117.01,105.58 115.75,105.83 114.48,105.58 113.41,104.86 112.69,103.79 112.44,102.52 112.69,101.25 113.41,100.18 114.48,99.46 115.75,99.21 117.01,99.46 118.09,100.18 118.8,101.25 119.06,102.52 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="138.9,102.52 138.65,103.79 137.93,104.86 136.86,105.58 135.59,105.83 134.32,105.58 133.25,104.86 132.54,103.79 132.28,102.52 132.54,101.25 133.25,100.18 134.32,99.46 135.59,99.21 136.86,99.46 137.93,100.18 138.65,101.25 138.9,102.52 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,109.13 72.5,110.4 71.79,111.47 70.71,112.19 69.45,112.44 68.18,112.19 67.11,111.47 66.39,110.4 66.14,109.13 66.39,107.87 67.11,106.8 68.18,106.08 69.45,105.83 70.71,106.08 71.79,106.8 72.5,107.87 72.76,109.13 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,109.13 92.35,110.4 91.63,111.47 90.56,112.19 89.29,112.44 88.03,112.19 86.95,111.47 86.24,110.4 85.98,109.13 86.24,107.87 86.95,106.8 88.03,106.08 89.29,105.83 90.56,106.08 91.63,106.8 92.35,107.87 92.6,109.13 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="105.83,109.13 105.58,110.4 104.86,111.47 103.79,112.19 102.52,112.44 101.25,112.19 100.18,111.47 99.46,110.4 99.21,109.13 99.46,107.87 100.18,106.8 101.25,106.08 102.52,105.83 103.79,106.08 104.86,106.8 105.58,107.87 105.83,109.13 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="125.67,109.13 125.42,110.4 124.7,111.47 123.63,112.19 122.36,112.44 121.1,112.19 120.02,111.47 119.31,110.4 119.06,109.13 119.31,107.87 120.02,106.8 121.1,106.08 122.36,105.83 123.63,106.08 124.7,106.8 125.42,107.87 125.67,109.13 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="132.28,109.13 132.03,110.4 131.31,111.47 130.24,112.19 128.98,112.44 127.71,112.19 126.64,111.47 125.92,110.4 125.67,109.13 125.92,107.87 126.64,106.8 127.71,106.08 128.98,105.83 130.24,106.08 131.31,106.8 132.03,107.87 132.28,109.13 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="145.51,109.13 145.26,110.4 144.54,111.47 143.47,112.19 142.2,112.44 140.94,112.19 139.87,111.47 139.15,110.4 138.9,109.13 139.15,107.87 139.87,106.8 140.94,106.08 142.2,105.83 143.47,106.08 144.54,106.8 145.26,107.87 145.51,109.13 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="152.13,109.13 151.87,110.4 151.16,111.47 150.08,112.19 148.82,112.44 147.55,112.19 146.48,111.47 145.76,110.4 145.51,109.13 145.76,107.87 146.48,106.8 147.55,106.08 148.82,105.83 150.08,106.08 151.16,106.8 151.87,107.87 152.13,109.13 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,115.75 79.12,117.01 78.4,118.09 77.33,118.8 76.06,119.06 74.8,118.8 73.72,118.09 73.01,117.01 72.76,115.75 73.01,114.48 73.72,113.41 74.8,112.69 76.06,112.44 77.33,112.69 78.4,113.41 79.12,114.48 79.37,115.75 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="85.98,115.75 85.73,117.01 85.02,118.09 83.94,118.8 82.68,119.06 81.41,118.8 80.34,118.09 79.62,117.01 79.37,115.75 79.62,114.48 80.34,113.41 81.41,112.69 82.68,112.44 83.94,112.69 85.02,113.41 85.73,114.48 85.98,115.75 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="119.06,115.75 118.8,117.01 118.09,118.09 117.01,118.8 115.75,119.06 114.48,118.8 113.41,118.09 112.69,117.01 112.44,115.75 112.69,114.48 113.41,113.41 114.48,112.69 115.75,112.44 117.01,112.69 118.09,113.41 118.8,114.48 119.06,115.75 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="125.67,115.75 125.42,117.01 124.7,118.09 123.63,118.8 122.36,119.06 121.1,118.8 120.02,118.09 119.31,117.01 119.06,115.75 119.31,114.48 120.02,113.41 121.1,112.69 122.36,112.44 123.63,112.69 124.7,113.41 125.42,114.48 125.67,115.75 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="138.9,115.75 138.65,117.01 137.93,118.09 136.86,118.8 135.59,119.06 134.32,118.8 133.25,118.09 132.54,117.01 132.28,115.75 132.54,114.48 133.25,113.41 134.32,112.69 135.59,112.44 136.86,112.69 137.93,113.41 138.65,114.48 138.9,115.75 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="152.13,115.75 151.87,117.01 151.16,118.09 150.08,118.8 148.82,119.06 147.55,118.8 146.48,118.09 145.76,117.01 145.51,115.75 145.76,114.48 146.48,113.41 147.55,112.69 148.82,112.44 150.08,112.69 151.16,113.41 151.87,114.48 152.13,115.75 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,122.36 72.5,123.63 71.79,124.7 70.71,125.42 69.45,125.67 68.18,125.42 67.11,124.7 66.39,123.63 66.14,122.36 66.39,121.1 67.11,120.02 68.18,119.31 69.45,119.06 70.71,119.31 71.79,120.02 72.5,121.1 72.76,122.36 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,122.36 79.12,123.63 78.4,124.7 77.33,125.42 76.06,125.67 74.8,125.42 73.72,124.7 73.01,123.63 72.76,122.36 73.01,121.1 73.72,120.02 74.8,119.31 76.06,119.06 77.33,119.31 78.4,120.02 79.12,121.1 79.37,122.36 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="85.98,122.36 85.73,123.63 85.02,124.7 83.94,125.42 82.68,125.67 81.41,125.42 80.34,124.7 79.62,123.63 79.37,122.36 79.62,121.1 80.34,120.02 81.41,119.31 82.68,119.06 83.94,119.31 85.02,120.02 85.73,121.1 85.98,122.36 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,122.36 92.35,123.63 91.63,124.7 90.56,125.42 89.29,125.67 88.03,125.42 86.95,124.7 86.24,123.63 85.98,122.36 86.24,121.1 86.95,120.02 88.03,119.31 89.29,119.06 90.56,119.31 91.63,120.02 92.35,121.1 92.6,122.36 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="105.83,122.36 105.58,123.63 104.86,124.7 103.79,125.42 102.52,125.67 101.25,125.42 100.18,124.7 99.46,123.63 99.21,122.36 99.46,121.1 100.18,120.02 101.25,119.31 102.52,119.06 103.79,119.31 104.86,120.02 105.58,121.1 105.83,122.36 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="125.67,122.36 125.42,123.63 124.7,124.7 123.63,125.42 122.36,125.67 121.1,125.42 120.02,124.7 119.31,123.63 119.06,122.36 119.31,121.1 120.02,120.02 121.1,119.31 122.36,119.06 123.63,119.31 124.7,120.02 125.42,121.1 125.67,122.36 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="132.28,122.36 132.03,123.63 131.31,124.7 130.24,125.42 128.98,125.67 127.71,125.42 126.64,124.7 125.92,123.63 125.67,122.36 125.92,121.1 126.64,120.02 127.71,119.31 128.98,119.06 130.24,119.31 131.31,120.02 132.03,121.1 132.28,122.36 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="138.9,122.36 138.65,123.63 137.93,124.7 136.86,125.42 135.59,125.67 134.32,125.42 133.25,124.7 132.54,123.63 132.28,122.36 132.54,121.1 133.25,120.02 134.32,119.31 135.59,119.06 136.86,119.31 137.93,120.02 138.65,121.1 138.9,122.36 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,128.98 72.5,130.24 71.79,131.31 70.71,132.03 69.45,132.28 68.18,132.03 67.11,131.31 66.39,130.24 66.14,128.98 66.39,127.71 67.11,126.64 68.18,125.92 69.45,125.67 70.71,125.92 71.79,126.64 72.5,127.71 72.76,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,128.98 79.12,130.24 78.4,131.31 77.33,132.03 76.06,132.28 74.8,132.03 73.72,131.31 73.01,130.24 72.76,128.98 73.01,127.71 73.72,126.64 74.8,125.92 76.06,125.67 77.33,125.92 78.4,126.64 79.12,127.71 79.37,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,128.98 92.35,130.24 91.63,131.31 90.56,132.03 89.29,132.28 88.03,132.03 86.95,131.31 86.24,130.24 85.98,128.98 86.24,127.71 86.95,126.64 88.03,125.92 89.29,125.67 90.56,125.92 91.63,126.64 92.35,127.71 92.6,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,128.98 98.96,130.24 98.24,131.31 97.17,132.03 95.91,132.28 94.64,132.03 93.57,131.31 92.85,130.24 92.6,128.98 92.85,127.71 93.57,126.64 94.64,125.92 95.91,125.67 97.17,125.92 98.24,126.64 98.96,127.71 99.21,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="105.83,128.98 105.58,130.24 104.86,131.31 103.79,132.03 102.52,132.28 101.25,132.03 100.18,131.31 99.46,130.24 99.21,128.98 99.46,127.71 100.18,126.64 101.25,125.92 102.52,125.67 103.79,125.92 104.86,126.64 105.58,127.71 105.83,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="112.44,128.98 112.19,130.24 111.47,131.31 110.4,132.03 109.13,132.28 107.87,132.03 106.8,131.31 106.08,130.24 105.83,128.98 106.08,127.71 106.8,126.64 107.87,125.92 109.13,125.67 110.4,125.92 111.47,126.64 112.19,127.71 112.44,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="119.06,128.98 118.8,130.24 118.09,131.31 117.01,132.03 115.75,132.28 114.48,132.03 113.41,131.31 112.69,130.24 112.44,128.98 112.69,127.71 113.41,126.64 114.48,125.92 115.75,125.67 117.01,125.92 118.09,126.64 118.8,127.71 119.06,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="132.28,128.98 132.03,130.24 131.31,131.31 130.24,132.03 128.98,132.28 127.71,132.03 126.64,131.31 125.92,130.24 125.67,128.98 125.92,127.71 126.64,126.64 127.71,125.92 128.98,125.67 130.24,125.92 131.31,126.64 132.03,127.71 132.28,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="138.9,128.98 138.65,130.24 137.93,131.31 136.86,132.03 135.59,132.28 134.32,132.03 133.25,131.31 132.54,130.24 132.28,128.98 132.54,127.71 133.25,126.64 134.32,125.92 135.59,125.67 136.86,125.92 137.93,126.64 138.65,127.71 138.9,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,135.59 72.5,136.86 71.79,137.93 70.71,138.65 69.45,138.9 68.18,138.65 67.11,137.93 66.39,136.86 66.14,135.59 66.39,134.32 67.11,133.25 68.18,132.54 69.45,132.28 70.71,132.54 71.79,133.25 72.5,134.32 72.76,135.59 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,135.59 79.12,136.86 78.4,137.93 77.33,138.65 76.06,138.9 74.8,138.65 73.72,137.93 73.01,136.86 72.76,135.59 73.01,134.32 73.72,133.25 74.8,132.54 76.06,132.28 77.33,132.54 78.4,133.25 79.12,134.32 79.37,135.59 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,135.59 98.96,136.86 98.24,137.93 97.17,138.65 95.91,138.9 94.64,138.65 93.57,137.93 92.85,136.86 92.6,135.59 92.85,134.32 93.57,133.25 94.64,132.54 95.91,132.28 97.17,132.54 98.24,133.25 98.96,134.32 99.21,135.59 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="112.44,135.59 112.19,136.86 111.47,137.93 110.4,138.65 109.13,138.9 107.87,138.65 106.8,137.93 106.08,136.86 105.83,135.59 106.08,134.32 106.8,133.25 107.87,132.54 109.13,132.28 110.4,132.54 111.47,133.25 112.19,134.32 112.44,135.59 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="119.06,135.59 118.8,136.86 118.09,137.93 117.01,138.65 115.75,138.9 114.48,138.65 113.41,137.93 112.69,136.86 112.44,135.59 112.69,134.32 113.41,133.25 114.48,132.54 115.75,132.28 117.01,132.54 118.09,133.25 118.8,134.32 119.06,135.59 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="132.28,135.59 132.03,136.86 131.31,137.93 130.24,13