import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/sti-toolbox.service";
import * as i3 from "../services/sti-toolbar-resizer.service";
import * as i4 from "../services/sti-localization.service";
import * as i5 from "@angular/common";
import * as i6 from "./sti-toolbox-element.component";
import * as i7 from "../components/sti-tooltip/sti-tooltip.directive";
export class StiToolboxComponent {
    constructor(resolver, model, toolboxService, toolbarResizerService, loc) {
        this.resolver = resolver;
        this.model = model;
        this.toolboxService = toolboxService;
        this.toolbarResizerService = toolbarResizerService;
        this.loc = loc;
    }
    get isMaximize() {
        return this.toolbarResizerService.isMaximizeMode;
    }
    ngOnInit() { }
}
StiToolboxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiToolboxComponent, deps: [{ token: i0.ComponentFactoryResolver }, { token: i1.StiModelService }, { token: i2.StiToolboxService }, { token: i3.StiToolbarResizerService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
StiToolboxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiToolboxComponent, selector: "sti-toolbox", ngImport: i0, template: `
    <div class="elements" id="Elements" hidden="false">
      <p *ngIf="this.isMaximize">Elements</p>
      <sti-toolbox-element *ngFor="let element of toolboxService.elements" [element]="element"></sti-toolbox-element>
      <!-- <sti-draggable-element-container></sti-draggable-element-container> -->
      <div
        *ngIf="toolboxService.isToolboxOutlineElementsDividerEnabled() && model.getBooleanSetting('showSetupToolbox')"
        class="divider"
        [style.height.px]="4"
        [style.width.px]="28"
      >
        <div [style.height.px]="1" [style.width.px]="22" [style.border-bottom]="'1px solid rgb(170,170,170)'"></div>
      </div>
      <div
        class="element"
        *ngIf="model.getBooleanSetting('showSetupToolbox')"
        (click)="model.showToolboxSetup = true"
        [stiTooltip]="loc.get2('FormDesigner', 'SetupToolbox')"
        tooltipPosition="right"
        showDelay="500"
      >
        <img [src]="model.getImage('images.Other.SmallSetupToolbox.png')" style="pointer-events: none" />
      </div>
    </div>
    <!-- <sti-toolbar-resizer [style.visibility]="this.model.isPreviewMode ? 'hidden' : ''"></sti-toolbar-resizer> -->
  `, isInline: true, styles: [".elements{width:100%;display:flex;flex-direction:column;font-size:18px;justify-content:flex-start;-webkit-touch-callout:none;-webkit-user-select:none}.divider{display:flex;align-items:center;justify-content:center}p{margin-top:1px;margin-bottom:3px;margin-left:5px;font-weight:500;color:var(--text-color)}.element{width:28px;height:28px;background-color:inherit;color:var(--text-color);border-radius:3px;display:flex;flex-wrap:nowrap;font-size:13px;font-weight:500;-webkit-touch-callout:none;-webkit-user-select:none;align-items:center;justify-content:center}.element:hover{background-color:var(--hover-color)}.element.active{background-color:var(--active-color)}img{vertical-align:sub;width:16px;height:16px}\n"], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiToolboxElementComponent, selector: "sti-toolbox-element", inputs: ["element", "forRibbon", "forGroup"] }, { kind: "directive", type: i7.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiToolboxComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-toolbox", template: `
    <div class="elements" id="Elements" hidden="false">
      <p *ngIf="this.isMaximize">Elements</p>
      <sti-toolbox-element *ngFor="let element of toolboxService.elements" [element]="element"></sti-toolbox-element>
      <!-- <sti-draggable-element-container></sti-draggable-element-container> -->
      <div
        *ngIf="toolboxService.isToolboxOutlineElementsDividerEnabled() && model.getBooleanSetting('showSetupToolbox')"
        class="divider"
        [style.height.px]="4"
        [style.width.px]="28"
      >
        <div [style.height.px]="1" [style.width.px]="22" [style.border-bottom]="'1px solid rgb(170,170,170)'"></div>
      </div>
      <div
        class="element"
        *ngIf="model.getBooleanSetting('showSetupToolbox')"
        (click)="model.showToolboxSetup = true"
        [stiTooltip]="loc.get2('FormDesigner', 'SetupToolbox')"
        tooltipPosition="right"
        showDelay="500"
      >
        <img [src]="model.getImage('images.Other.SmallSetupToolbox.png')" style="pointer-events: none" />
      </div>
    </div>
    <!-- <sti-toolbar-resizer [style.visibility]="this.model.isPreviewMode ? 'hidden' : ''"></sti-toolbar-resizer> -->
  `, styles: [".elements{width:100%;display:flex;flex-direction:column;font-size:18px;justify-content:flex-start;-webkit-touch-callout:none;-webkit-user-select:none}.divider{display:flex;align-items:center;justify-content:center}p{margin-top:1px;margin-bottom:3px;margin-left:5px;font-weight:500;color:var(--text-color)}.element{width:28px;height:28px;background-color:inherit;color:var(--text-color);border-radius:3px;display:flex;flex-wrap:nowrap;font-size:13px;font-weight:500;-webkit-touch-callout:none;-webkit-user-select:none;align-items:center;justify-content:center}.element:hover{background-color:var(--hover-color)}.element.active{background-color:var(--active-color)}img{vertical-align:sub;width:16px;height:16px}\n"] }]
        }], ctorParameters: function () { return [{ type: i0.ComponentFactoryResolver }, { type: i1.StiModelService }, { type: i2.StiToolboxService }, { type: i3.StiToolbarResizerService }, { type: i4.StiLocalizationService }]; } });
//# sourceMappingURL=data:application/json;base64,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