import { Component, Input } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../services/sti-toolbox.service";
import * as i2 from "../services/sti-toolbar-resizer.service";
import * as i3 from "../services/theme.service";
import * as i4 from "../services/model.service";
import * as i5 from "../services/sti-localization.service";
import * as i6 from "@angular/common";
import * as i7 from "../components/sti-tooltip/sti-tooltip.directive";
export class StiToolboxElementComponent {
    constructor(toolboxService, toolbarResizerService, theme, model, loc) {
        this.toolboxService = toolboxService;
        this.toolbarResizerService = toolbarResizerService;
        this.theme = theme;
        this.model = model;
        this.loc = loc;
        this.forRibbon = false;
        this.forGroup = false;
    }
    showPreview(event, caption) {
        let elements = document.elementsFromPoint(event.clientX, event.clientY);
        let element = elements?.find((element) => element?.classList.contains("current-group"));
        let elementRect = this.model.getPositionRelativeToForm(element);
        this.toolboxService.previewY = elementRect?.bottom;
        this.toolboxService.previewX = elementRect?.left;
        this.toolboxService.currentGroup = caption;
        if (caption == "Input" &&
            (!this.toolboxService.unusedElements?.find((item) => item == "textbox") ||
                !this.toolboxService.unusedElements?.find((item) => item == "numberbox") ||
                !this.toolboxService.unusedElements?.find((item) => item == "combobox") ||
                !this.toolboxService.unusedElements?.find((item) => item == "dateTime"))) {
            this.model.showGroupPreview = true;
        }
        else if (caption == "Selection" &&
            (!this.toolboxService.unusedElements?.find((item) => item == "singleSelection") ||
                !this.toolboxService.unusedElements?.find((item) => item == "multipleSelection") ||
                !this.toolboxService.unusedElements?.find((item) => item == "listbox") ||
                !this.toolboxService.unusedElements?.find((item) => item == "checkbox"))) {
            this.model.showGroupPreview = true;
        }
        else if (caption == "Others" &&
            (!this.toolboxService.unusedElements?.find((item) => item == "signature") ||
                !this.toolboxService.unusedElements?.find((item) => item == "barcode") ||
                !this.toolboxService.unusedElements?.find((item) => item == "address") ||
                !this.toolboxService.unusedElements?.find((item) => item == "line"))) {
            this.model.showGroupPreview = true;
        }
    }
    onMouseDown(event) {
        let form = document.querySelector("stimulsoft-forms");
        form?.classList.add("unselectable");
        this.toolboxService.elementMouseDown(this, event);
    }
    onDoubleClick() {
        this.toolboxService.elementDoubleClick(this);
    }
    get isMaximize() {
        return this.toolbarResizerService.isMaximizeMode;
    }
    get className() {
        return "element " + (this.toolboxService.mouseDownComponent?.element == this.element ? "active" : "hover");
    }
    get image() {
        return this.model.getImage(this.element.image);
    }
    ngOnInit() { }
}
StiToolboxElementComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiToolboxElementComponent, deps: [{ token: i1.StiToolboxService }, { token: i2.StiToolbarResizerService }, { token: i3.StiThemeService }, { token: i4.StiModelService }, { token: i5.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Component });
StiToolboxElementComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiToolboxElementComponent, selector: "sti-toolbox-element", inputs: { element: "element", forRibbon: "forRibbon", forGroup: "forGroup" }, ngImport: i0, template: `
    <div
      *ngIf="
        !forGroup && toolboxService.isEnabled(element) && !this.isMaximize && element.caption != 'Divider' && !forRibbon
      "
      [class]="className"
      (mousedown)="onMouseDown($event)"
      (dblclick)="onDoubleClick()"
      [stiTooltip]="loc.get2(element.category ? element.category : 'Components', element.caption)"
      tooltipPosition="right"
      showDelay="500"
    >
      <img [src]="image" style="pointer-events: none" />
    </div>
    <div
      class="divider"
      *ngIf="
        !forGroup &&
        !this.isMaximize &&
        element.caption == 'Divider' &&
        !forRibbon &&
        toolboxService.isToolboxInlineElementsDividerEnabled(element)
      "
      [style.height.px]="4"
      [style.width.px]="28"
    >
      <div [style.height.px]="1" [style.width.px]="22" [style.border-bottom]="'1px solid rgb(170,170,170)'"></div>
    </div>
    <div
      *ngIf="!forGroup && toolboxService.isEnabled(element) && this.isMaximize && !forRibbon"
      [class]="className"
      (mousedown)="onMouseDown($event)"
      (dblclick)="onDoubleClick()"
    >
      <img [src]="image" style="pointer-events: none" />
      <label style="width: 110px;">{{
        loc.get2(element.category ? element.category : "Components", element.caption)
      }}</label>
    </div>
    <div
      *ngIf="
        !forGroup &&
        toolboxService.isEnabled(element) &&
        toolboxService.isGroupEnabled(element) &&
        forRibbon &&
        (element.caption == 'Input' || element.caption == 'Others' || element.caption == 'Selection')
      "
      class="container current-group"
      [stiTooltip]="loc.getP(element.caption)"
      tooltipPosition="bottom"
      showDelay="500"
      (click)="showPreview($event, element.caption)"
    >
      <div class="button">
        <img class="img" [src]="image" alt="" />
        <span>{{
          element.caption == "Others"
            ? loc.get2("FormColorBoxPopup", element.caption).replace("...", "")
            : loc.getP(element.caption)
        }}</span>
        <span class="select-button"><i class="pi pi-chevron-down"></i></span>
      </div>
    </div>
    <div
      *ngIf="
        !forGroup &&
        toolboxService.isEnabled(element) &&
        forRibbon &&
        element.caption != 'Divider' &&
        element.caption != 'Input' &&
        element.caption != 'Selection' &&
        element.caption != 'Others'
      "
      class="container"
      [stiTooltip]="loc.get2(element.category ? element.category : 'Components', element.caption)"
      tooltipPosition="bottom"
      showDelay="500"
      (mousedown)="onMouseDown($event)"
      (dblclick)="onDoubleClick()"
    >
      <div class="button">
        <img class="img" [src]="image" alt="" />
        <span>{{ loc.get2(element.category ? element.category : "Components", element.caption) }}</span>
      </div>
    </div>
    <div
      *ngIf="forGroup && toolboxService.isEnabled(element)"
      class="container-group"
      [stiTooltip]="loc.get2(element.category ? element.category : 'Components', element.caption)"
      tooltipPosition="bottom"
      showDelay="500"
      (mousedown)="onMouseDown($event)"
      (dblclick)="onDoubleClick()"
      [style.width]="'100%'"
    >
      <div class="button-group">
        <img class="img" [src]="image" alt="" />
        <span>{{ loc.get2(element.category ? element.category : "Components", element.caption) }}</span>
      </div>
    </div>
    <div
      class="vertical-line"
      *ngIf="
        !forGroup &&
        forRibbon &&
        element.caption == 'Divider' &&
        toolboxService.isInsertInlineElementsDividerEnabled(element)
      "
    ></div>
  `, isInline: true, styles: [".container{width:max-content;display:flex;align-items:center;justify-content:center;-webkit-touch-callout:none;-webkit-user-select:none;margin-top:2px}.button{height:50px;width:max-content;background-color:var(--back-color);border-radius:3px;display:flex;align-items:center;justify-content:center;padding-left:5px;padding-right:5px}.button:hover{background-color:var(--hover-color)!important}.button:active{background-color:var(--columnDeleteHover-color)!important}.container-group{width:max-content;height:max-content;display:flex;align-items:center;-webkit-touch-callout:none;-webkit-user-select:none;margin-top:1px}.button-group{height:max-content;width:100%;background-color:var(--back-color);border-radius:3px;display:flex;align-items:center;padding:4px}.button-group:hover{background-color:var(--hover-color)!important}.button-group:active{background-color:var(--columnDeleteHover-color)!important}.divider{display:flex;align-items:center;justify-content:center}.element{width:28px;height:28px;background-color:inherit;color:var(--text-color);border-radius:3px;display:flex;flex-wrap:nowrap;font-size:13px;font-weight:500;-webkit-touch-callout:none;-webkit-user-select:none;align-items:center;justify-content:center}.element.hover:hover{background-color:var(--hover-color)}.element.active{background-color:var(--active-color)}img{vertical-align:sub;width:16px;height:16px}.img{max-width:18px;pointer-events:none}.vertical-line{margin-top:10px;width:0px;height:32px;border-right:1px solid rgb(195,195,195);margin-right:5px}label{margin-left:3px;word-wrap:normal;white-space:nowrap;width:110px}span{font-size:13px;white-space:nowrap;margin-left:9px}\n"], dependencies: [{ kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i7.StiTooltipDirective, selector: "[stiTooltip]", inputs: ["tooltipPosition", "stiTooltip", "showDelay"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiToolboxElementComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-toolbox-element", template: `
    <div
      *ngIf="
        !forGroup && toolboxService.isEnabled(element) && !this.isMaximize && element.caption != 'Divider' && !forRibbon
      "
      [class]="className"
      (mousedown)="onMouseDown($event)"
      (dblclick)="onDoubleClick()"
      [stiTooltip]="loc.get2(element.category ? element.category : 'Components', element.caption)"
      tooltipPosition="right"
      showDelay="500"
    >
      <img [src]="image" style="pointer-events: none" />
    </div>
    <div
      class="divider"
      *ngIf="
        !forGroup &&
        !this.isMaximize &&
        element.caption == 'Divider' &&
        !forRibbon &&
        toolboxService.isToolboxInlineElementsDividerEnabled(element)
      "
      [style.height.px]="4"
      [style.width.px]="28"
    >
      <div [style.height.px]="1" [style.width.px]="22" [style.border-bottom]="'1px solid rgb(170,170,170)'"></div>
    </div>
    <div
      *ngIf="!forGroup && toolboxService.isEnabled(element) && this.isMaximize && !forRibbon"
      [class]="className"
      (mousedown)="onMouseDown($event)"
      (dblclick)="onDoubleClick()"
    >
      <img [src]="image" style="pointer-events: none" />
      <label style="width: 110px;">{{
        loc.get2(element.category ? element.category : "Components", element.caption)
      }}</label>
    </div>
    <div
      *ngIf="
        !forGroup &&
        toolboxService.isEnabled(element) &&
        toolboxService.isGroupEnabled(element) &&
        forRibbon &&
        (element.caption == 'Input' || element.caption == 'Others' || element.caption == 'Selection')
      "
      class="container current-group"
      [stiTooltip]="loc.getP(element.caption)"
      tooltipPosition="bottom"
      showDelay="500"
      (click)="showPreview($event, element.caption)"
    >
      <div class="button">
        <img class="img" [src]="image" alt="" />
        <span>{{
          element.caption == "Others"
            ? loc.get2("FormColorBoxPopup", element.caption).replace("...", "")
            : loc.getP(element.caption)
        }}</span>
        <span class="select-button"><i class="pi pi-chevron-down"></i></span>
      </div>
    </div>
    <div
      *ngIf="
        !forGroup &&
        toolboxService.isEnabled(element) &&
        forRibbon &&
        element.caption != 'Divider' &&
        element.caption != 'Input' &&
        element.caption != 'Selection' &&
        element.caption != 'Others'
      "
      class="container"
      [stiTooltip]="loc.get2(element.category ? element.category : 'Components', element.caption)"
      tooltipPosition="bottom"
      showDelay="500"
      (mousedown)="onMouseDown($event)"
      (dblclick)="onDoubleClick()"
    >
      <div class="button">
        <img class="img" [src]="image" alt="" />
        <span>{{ loc.get2(element.category ? element.category : "Components", element.caption) }}</span>
      </div>
    </div>
    <div
      *ngIf="forGroup && toolboxService.isEnabled(element)"
      class="container-group"
      [stiTooltip]="loc.get2(element.category ? element.category : 'Components', element.caption)"
      tooltipPosition="bottom"
      showDelay="500"
      (mousedown)="onMouseDown($event)"
      (dblclick)="onDoubleClick()"
      [style.width]="'100%'"
    >
      <div class="button-group">
        <img class="img" [src]="image" alt="" />
        <span>{{ loc.get2(element.category ? element.category : "Components", element.caption) }}</span>
      </div>
    </div>
    <div
      class="vertical-line"
      *ngIf="
        !forGroup &&
        forRibbon &&
        element.caption == 'Divider' &&
        toolboxService.isInsertInlineElementsDividerEnabled(element)
      "
    ></div>
  `, styles: [".container{width:max-content;display:flex;align-items:center;justify-content:center;-webkit-touch-callout:none;-webkit-user-select:none;margin-top:2px}.button{height:50px;width:max-content;background-color:var(--back-color);border-radius:3px;display:flex;align-items:center;justify-content:center;padding-left:5px;padding-right:5px}.button:hover{background-color:var(--hover-color)!important}.button:active{background-color:var(--columnDeleteHover-color)!important}.container-group{width:max-content;height:max-content;display:flex;align-items:center;-webkit-touch-callout:none;-webkit-user-select:none;margin-top:1px}.button-group{height:max-content;width:100%;background-color:var(--back-color);border-radius:3px;display:flex;align-items:center;padding:4px}.button-group:hover{background-color:var(--hover-color)!important}.button-group:active{background-color:var(--columnDeleteHover-color)!important}.divider{display:flex;align-items:center;justify-content:center}.element{width:28px;height:28px;background-color:inherit;color:var(--text-color);border-radius:3px;display:flex;flex-wrap:nowrap;font-size:13px;font-weight:500;-webkit-touch-callout:none;-webkit-user-select:none;align-items:center;justify-content:center}.element.hover:hover{background-color:var(--hover-color)}.element.active{background-color:var(--active-color)}img{vertical-align:sub;width:16px;height:16px}.img{max-width:18px;pointer-events:none}.vertical-line{margin-top:10px;width:0px;height:32px;border-right:1px solid rgb(195,195,195);margin-right:5px}label{margin-left:3px;word-wrap:normal;white-space:nowrap;width:110px}span{font-size:13px;white-space:nowrap;margin-left:9px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiToolboxService }, { type: i2.StiToolbarResizerService }, { type: i3.StiThemeService }, { type: i4.StiModelService }, { type: i5.StiLocalizationService }]; }, propDecorators: { element: [{
                type: Input
            }], forRibbon: [{
                type: Input
            }], forGroup: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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