import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../services/sti-localization.service";
import * as i3 from "../services/sti-toolbox.service";
import * as i4 from "../services/sti-local-storage.service";
import * as i5 from "@angular/common";
import * as i6 from "../components/sti-universal-checkbox/sti-universal-checkbox.component";
export class StiSetupToolboxComponent {
    constructor(model, loc, toolboxService, stiLocalStorage) {
        this.model = model;
        this.loc = loc;
        this.toolboxService = toolboxService;
        this.stiLocalStorage = stiLocalStorage;
    }
    get showToolbox() {
        return this._showToolbox;
    }
    set showToolbox(value) {
        if (value == false && !this.showInsertTab) {
            this._showInsertTab = true;
            this._showToolbox = value;
        }
        else {
            this._showToolbox = value;
        }
    }
    get showInsertTab() {
        return this._showInsertTab;
    }
    set showInsertTab(value) {
        if (value == false && !this.showToolbox) {
            this._showToolbox = true;
            this._showInsertTab = value;
        }
        else {
            this._showInsertTab = value;
        }
    }
    acceptChanges() {
        this.toolboxService.unusedElements = [];
        this.toolboxService.elements.forEach((element) => {
            if (!element.enabled && element.caption != "Divider") {
                this.toolboxService.unusedElements.push(element.id);
            }
        });
        this.stiLocalStorage.setItem("StiToolboxSetup", JSON.stringify(this.toolboxService.unusedElements));
        this.stiLocalStorage.setItem("StiShowInsertTab", JSON.stringify(this.showInsertTab));
        this.stiLocalStorage.setItem("StiShowToolbox", JSON.stringify(this.showToolbox));
        // document.cookie = "StiToolboxSetup=" + this.toolboxService.unusedElements.join();
        this.toolboxService.showInsertTab = this.showInsertTab;
        this.toolboxService.showToolbox = this.showToolbox;
        this.model.showToolboxSetup = false;
    }
    ngOnInit() {
        this._showInsertTab = this.toolboxService.showInsertTab;
        this._showToolbox = this.toolboxService.showToolbox;
    }
}
StiSetupToolboxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiSetupToolboxComponent, deps: [{ token: i1.StiModelService }, { token: i2.StiLocalizationService }, { token: i3.StiToolboxService }, { token: i4.StiLocalStorageService }], target: i0.ɵɵFactoryTarget.Component });
StiSetupToolboxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiSetupToolboxComponent, selector: "sti-setup-toolbox-component", ngImport: i0, template: `
    <div class="modal-window">
      <div class="modal-window-navbar">
        <span [style.flex]="1">{{ loc.get2("FormDesigner", "SetupToolbox") }}</span>
        <div class="close-button" (click)="model.showToolboxSetup = false">
          <img [src]="model.getImage('images.Other.CloseForm.png')" />
        </div>
      </div>
      <div class="toolbox-elements-preview">
        <ul>
          <li
            *ngFor="let element of toolboxService.elements"
            [style.display]="element.caption == 'Divider' ? 'none' : ''"
            [style.padding.px]="toolboxService.isEnabledFromSettings(element) ? 3 : 0"
          >
            <div class="setup-toolbox-item" *ngIf="toolboxService.isEnabledFromSettings(element)">
              <sti-checkbox [(value)]="element.enabled" [label]=""></sti-checkbox>
              <img [src]="model.getImage(element.image)" alt="" />
              <span>{{
                element.caption != "Input" || element.caption != "Other" || element.caption != "Selection"
                  ? loc.get2(element.category ? element.category : "Components", element.caption)
                  : loc.getP(element.caption)
              }}</span>
            </div>
          </li>
        </ul>
      </div>
      <div class="setup-options">
        <sti-checkbox
          [(value)]="showToolbox"
          [label]="loc.get2('MainMenu', 'menuViewShowToolbox').replace('.', '')"
          [style.margin-bottom.px]="15"
          [style.color]="'var(--text-color)'"
        ></sti-checkbox>
        <sti-checkbox
          [(value)]="showInsertTab"
          [label]="loc.get2('MainMenu', 'menuViewShowInsertTab').replace('.', '')"
          [style.color]="'var(--text-color)'"
        ></sti-checkbox>
      </div>
      <div class="setup-accept">
        <div class="accept button" (click)="acceptChanges()">
          <span [style.margin-left.px]="0">{{ loc.get2("Buttons", "Ok").replace("&amp", "").replace(";", "") }}</span>
        </div>
        <div class="cancel button" (click)="model.showToolboxSetup = false">
          <span [style.margin-left.px]="0">{{ loc.getP("Cancel") }}</span>
        </div>
      </div>
    </div>
  `, isInline: true, styles: [".setup-toolbox-item{display:flex;position:relative;align-items:center}.pi{font-size:.825rem;color:var(--text-color)}.modal-window-navbar{display:flex;height:30px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;-webkit-user-select:none;color:#fff;align-items:center}.modal-window-navbar span{font-size:13px}.close-button{height:30px;width:30px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#dadada}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.modal-window{background-color:var(--back-color);position:absolute;left:calc(50% - 150px);top:calc(50% - 222px);z-index:999;width:300px;height:444px;overflow:hidden;box-shadow:0 0 7px #0000004d;border:1px solid rgb(25,71,138);color:var(--text-color);font-size:13px;border-radius:5px;font-family:Arial;-webkit-user-select:none}ul{list-style:none;margin:0;padding-left:6px;padding-top:3px}li{display:flex;position:relative;padding:3px;align-items:center}.toolbox-elements-preview{margin:10px;border:1px solid lightgray;border-radius:3px;height:300px;overflow-y:scroll}.setup-options{padding-left:10px;display:flex;flex-direction:column}img{margin-left:3px;height:16px;width:15px}span{margin-left:5px;font-size:12px}.button{height:24px;width:80px;border-radius:3px;margin:3px 5px;display:flex;align-items:center;justify-content:center;border:1px solid transparent}.accept:active{background-color:#355da0;border-color:#264c7d}.cancel:active{background-color:#e2e2e2;border-color:#838383}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}.setup-accept{padding:8px;display:flex;align-items:flex-end;justify-content:flex-end}\n"], dependencies: [{ kind: "directive", type: i5.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6.StiUniversalCheckboxComponent, selector: "sti-checkbox", inputs: ["value", "disabled", "label"], outputs: ["valueChange"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiSetupToolboxComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-setup-toolbox-component", template: `
    <div class="modal-window">
      <div class="modal-window-navbar">
        <span [style.flex]="1">{{ loc.get2("FormDesigner", "SetupToolbox") }}</span>
        <div class="close-button" (click)="model.showToolboxSetup = false">
          <img [src]="model.getImage('images.Other.CloseForm.png')" />
        </div>
      </div>
      <div class="toolbox-elements-preview">
        <ul>
          <li
            *ngFor="let element of toolboxService.elements"
            [style.display]="element.caption == 'Divider' ? 'none' : ''"
            [style.padding.px]="toolboxService.isEnabledFromSettings(element) ? 3 : 0"
          >
            <div class="setup-toolbox-item" *ngIf="toolboxService.isEnabledFromSettings(element)">
              <sti-checkbox [(value)]="element.enabled" [label]=""></sti-checkbox>
              <img [src]="model.getImage(element.image)" alt="" />
              <span>{{
                element.caption != "Input" || element.caption != "Other" || element.caption != "Selection"
                  ? loc.get2(element.category ? element.category : "Components", element.caption)
                  : loc.getP(element.caption)
              }}</span>
            </div>
          </li>
        </ul>
      </div>
      <div class="setup-options">
        <sti-checkbox
          [(value)]="showToolbox"
          [label]="loc.get2('MainMenu', 'menuViewShowToolbox').replace('.', '')"
          [style.margin-bottom.px]="15"
          [style.color]="'var(--text-color)'"
        ></sti-checkbox>
        <sti-checkbox
          [(value)]="showInsertTab"
          [label]="loc.get2('MainMenu', 'menuViewShowInsertTab').replace('.', '')"
          [style.color]="'var(--text-color)'"
        ></sti-checkbox>
      </div>
      <div class="setup-accept">
        <div class="accept button" (click)="acceptChanges()">
          <span [style.margin-left.px]="0">{{ loc.get2("Buttons", "Ok").replace("&amp", "").replace(";", "") }}</span>
        </div>
        <div class="cancel button" (click)="model.showToolboxSetup = false">
          <span [style.margin-left.px]="0">{{ loc.getP("Cancel") }}</span>
        </div>
      </div>
    </div>
  `, styles: [".setup-toolbox-item{display:flex;position:relative;align-items:center}.pi{font-size:.825rem;color:var(--text-color)}.modal-window-navbar{display:flex;height:30px;border-top-left-radius:3px;border-top-right-radius:3px;background-color:#515c6a;-webkit-user-select:none;color:#fff;align-items:center}.modal-window-navbar span{font-size:13px}.close-button{height:30px;width:30px;border-radius:3px;display:flex;align-items:center;justify-content:center}.close-button:hover{background-color:#dadada}.close-button img{height:16px;width:16px;filter:brightness(0) invert(1)}.modal-window{background-color:var(--back-color);position:absolute;left:calc(50% - 150px);top:calc(50% - 222px);z-index:999;width:300px;height:444px;overflow:hidden;box-shadow:0 0 7px #0000004d;border:1px solid rgb(25,71,138);color:var(--text-color);font-size:13px;border-radius:5px;font-family:Arial;-webkit-user-select:none}ul{list-style:none;margin:0;padding-left:6px;padding-top:3px}li{display:flex;position:relative;padding:3px;align-items:center}.toolbox-elements-preview{margin:10px;border:1px solid lightgray;border-radius:3px;height:300px;overflow-y:scroll}.setup-options{padding-left:10px;display:flex;flex-direction:column}img{margin-left:3px;height:16px;width:15px}span{margin-left:5px;font-size:12px}.button{height:24px;width:80px;border-radius:3px;margin:3px 5px;display:flex;align-items:center;justify-content:center;border:1px solid transparent}.accept:active{background-color:#355da0;border-color:#264c7d}.cancel:active{background-color:#e2e2e2;border-color:#838383}.accept{background-color:#19478a;color:#fff}.accept:hover{background-color:#3d6298}.cancel{background-color:#ddd;color:#444}.cancel:hover{background-color:#d5d5d5}.setup-accept{padding:8px;display:flex;align-items:flex-end;justify-content:flex-end}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiLocalizationService }, { type: i3.StiToolboxService }, { type: i4.StiLocalStorageService }]; } });
//# sourceMappingURL=data:application/json;base64,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