import { Component, ViewChild } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../services/sti-draggable.service";
import * as i2 from "../services/model.service";
import * as i3 from "../components/sti-components-holder.component";
export class StiDraggableElementContainerComponent {
    constructor(draggableService, model) {
        this.draggableService = draggableService;
        this.model = model;
    }
    ngOnInit() { }
    ngAfterViewChecked() { }
    ngAfterViewInit() { }
}
StiDraggableElementContainerComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDraggableElementContainerComponent, deps: [{ token: i1.StiDraggableService }, { token: i2.StiModelService }], target: i0.ɵɵFactoryTarget.Component });
StiDraggableElementContainerComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiDraggableElementContainerComponent, selector: "sti-draggable-element-container", viewQueries: [{ propertyName: "container", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div
      #element
      style="position: absolute; z-index: 999; background-color:rgb(226,226,226); opacity:0.7; userSelect:none;"
      [style.visibility]="model.draggingElement ? 'visible' : 'hidden'"
      [style.left.px]="draggableService.left"
      [style.top.px]="draggableService.top"
      [style.width.px]="model.draggingElement?.width"
      [style.height.px]="model.draggingElement?.height"
      [style.transform]="model.getScale()"
      [style.transform-origin]="'left top'"
    >
      <sti-component-holder [element]="model.draggingElement"></sti-component-holder>
    </div>
  `, isInline: true, dependencies: [{ kind: "component", type: i3.StiComponentHolderComponent, selector: "sti-component-holder", inputs: ["element", "isClone"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDraggableElementContainerComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-draggable-element-container",
                    template: `
    <div
      #element
      style="position: absolute; z-index: 999; background-color:rgb(226,226,226); opacity:0.7; userSelect:none;"
      [style.visibility]="model.draggingElement ? 'visible' : 'hidden'"
      [style.left.px]="draggableService.left"
      [style.top.px]="draggableService.top"
      [style.width.px]="model.draggingElement?.width"
      [style.height.px]="model.draggingElement?.height"
      [style.transform]="model.getScale()"
      [style.transform-origin]="'left top'"
    >
      <sti-component-holder [element]="model.draggingElement"></sti-component-holder>
    </div>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiDraggableService }, { type: i2.StiModelService }]; }, propDecorators: { container: [{
                type: ViewChild,
                args: ["element"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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