import { Component, ViewChild, } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../services/sti-column-draggable.service";
import * as i2 from "../services/model.service";
import * as i3 from "@angular/common";
import * as i4 from "../components/sti-table/sti-table-column/sti-table-column.component";
export class StiDraggableColumnContainerComponent {
    constructor(draggableService, model, cdref) {
        this.draggableService = draggableService;
        this.model = model;
        this.cdref = cdref;
    }
    ngOnInit() { }
    getBorder(pen) {
        return pen.toHtmlBorder();
    }
    get columnWidth() {
        let booleanButton = document.querySelector(".boolean-button");
        return booleanButton ? booleanButton.clientWidth : "max-content";
    }
    getColumnHeight(type) {
        if (this.draggableService?.fromTable) {
            if (type == "td") {
                let parentElement = document.getElementById(this.draggableService.parentElement.guid);
                let tdElements = parentElement.getElementsByClassName("sti-table-td");
                return tdElements[0].clientHeight;
            }
            else {
                let parentElement = document.getElementById(this.draggableService.parentElement.guid);
                let thElements = parentElement.getElementsByClassName("sti-table-th");
                return thElements[0].clientHeight;
            }
        }
        else {
            return;
        }
    }
    ngAfterViewChecked() {
        // setTimeout(() => {
        this.draggableService.containerHeight = this.container?.nativeElement.offsetHeight;
        this.draggableService.containerWidth = this.container?.nativeElement.offsetWidth;
        this.cdref.detectChanges();
        // }, 0);
    }
    ngAfterViewInit() { }
}
StiDraggableColumnContainerComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDraggableColumnContainerComponent, deps: [{ token: i1.StiColumnDraggableService }, { token: i2.StiModelService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component });
StiDraggableColumnContainerComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiDraggableColumnContainerComponent, selector: "sti-draggable-column-container", viewQueries: [{ propertyName: "container", first: true, predicate: ["element"], descendants: true }], ngImport: i0, template: `
    <div
      #element
      style="position: absolute; z-index: 999; background-color:rgb(226,226,226); opacity:0.7; userSelect:none;"
      *ngIf="draggableService.isDragging"
      [style.visibility]="draggableService.isDragging ? 'visible' : 'hidden'"
      [style.transform]="model.getScale()"
      [style.transform-origin]="'left top'"
      [style.left]="draggableService.left"
      [style.top]="draggableService.top"
      [style.width.px]="draggableService.fromTable ? draggableService?.item?.width : columnWidth"
      [style.height]="draggableService.fromTable ? 'auto' : '22px'"
      [style.pointer-events]="'none'"
    >
      <div *ngIf="draggableService.fromTable">
        <table [style.border]="getBorder(draggableService?.parentElement?.gridLines?.pen)">
          <tr>
            <th
              [style.border]="getBorder(draggableService?.parentElement?.gridLines?.pen)"
              [style]="draggableService.parentElement.font.htmlStyle()"
              [style.height.px]="getColumnHeight('th')"
            >
              {{ draggableService.itemLabel }}
            </th>
          </tr>
          <tr *ngFor="let row of draggableService.parentElement.rowLabelsContentEditable; index as i">
            <td
              [style]="draggableService.parentElement.font.htmlStyle()"
              [style.border]="getBorder(draggableService?.parentElement?.gridLines?.pen)"
              [style.height.px]="getColumnHeight('td')"
            >
              <sti-table-column-component
                [column]="draggableService.item"
                [index]="i"
                [element]="draggableService.parentElement"
              ></sti-table-column-component>
            </td>
          </tr>
        </table>
      </div>
      <div *ngIf="!draggableService.fromTable" class="boolean-button">
        <div class="arrow">></div>
        <div class="content">
          {{ draggableService.itemLabel }}
        </div>
      </div>
    </div>
  `, isInline: true, styles: ["table{width:100%;border-collapse:collapse}th{padding:5px}td{padding:4px}.arrow{width:30px;text-align:center;cursor:default;-webkit-touch-callout:none;-webkit-user-select:none}.content{cursor:default;-webkit-touch-callout:none;-webkit-user-select:none;flex:1}.boolean-button{width:100%;font-size:12px;height:100%;font-weight:600;display:flex;padding-top:2px;flex-direction:row;color:var(--text-color);background-color:var(--hover-color)}\n"], dependencies: [{ kind: "directive", type: i3.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i4.StiTableColumnComponent, selector: "sti-table-column-component", inputs: ["column", "index", "element"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDraggableColumnContainerComponent, decorators: [{
            type: Component,
            args: [{ selector: "sti-draggable-column-container", template: `
    <div
      #element
      style="position: absolute; z-index: 999; background-color:rgb(226,226,226); opacity:0.7; userSelect:none;"
      *ngIf="draggableService.isDragging"
      [style.visibility]="draggableService.isDragging ? 'visible' : 'hidden'"
      [style.transform]="model.getScale()"
      [style.transform-origin]="'left top'"
      [style.left]="draggableService.left"
      [style.top]="draggableService.top"
      [style.width.px]="draggableService.fromTable ? draggableService?.item?.width : columnWidth"
      [style.height]="draggableService.fromTable ? 'auto' : '22px'"
      [style.pointer-events]="'none'"
    >
      <div *ngIf="draggableService.fromTable">
        <table [style.border]="getBorder(draggableService?.parentElement?.gridLines?.pen)">
          <tr>
            <th
              [style.border]="getBorder(draggableService?.parentElement?.gridLines?.pen)"
              [style]="draggableService.parentElement.font.htmlStyle()"
              [style.height.px]="getColumnHeight('th')"
            >
              {{ draggableService.itemLabel }}
            </th>
          </tr>
          <tr *ngFor="let row of draggableService.parentElement.rowLabelsContentEditable; index as i">
            <td
              [style]="draggableService.parentElement.font.htmlStyle()"
              [style.border]="getBorder(draggableService?.parentElement?.gridLines?.pen)"
              [style.height.px]="getColumnHeight('td')"
            >
              <sti-table-column-component
                [column]="draggableService.item"
                [index]="i"
                [element]="draggableService.parentElement"
              ></sti-table-column-component>
            </td>
          </tr>
        </table>
      </div>
      <div *ngIf="!draggableService.fromTable" class="boolean-button">
        <div class="arrow">></div>
        <div class="content">
          {{ draggableService.itemLabel }}
        </div>
      </div>
    </div>
  `, styles: ["table{width:100%;border-collapse:collapse}th{padding:5px}td{padding:4px}.arrow{width:30px;text-align:center;cursor:default;-webkit-touch-callout:none;-webkit-user-select:none}.content{cursor:default;-webkit-touch-callout:none;-webkit-user-select:none;flex:1}.boolean-button{width:100%;font-size:12px;height:100%;font-weight:600;display:flex;padding-top:2px;flex-direction:row;color:var(--text-color);background-color:var(--hover-color)}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiColumnDraggableService }, { type: i2.StiModelService }, { type: i0.ChangeDetectorRef }]; }, propDecorators: { container: [{
                type: ViewChild,
                args: ["element"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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