import { Component, ViewChild } from "@angular/core";
import ResizeObserver from "resize-observer-polyfill";
import StiRectangleGeometryLayout from "../computed/StiRectangleGeometryLayout";
import * as i0 from "@angular/core";
import * as i1 from "../services/model.service";
import * as i2 from "../components/sti-components-holder.component";
export class StiCloneElementContainerComponent {
    constructor(model, zone, render) {
        this.model = model;
        this.zone = zone;
        this.render = render;
        this.isClone = true;
        model.formEvents.subscribe((e) => {
            if (e.name == "ElementToUpdateChanged" || e.name == "SelectedComponentChanged") {
                this.updateObservable();
            }
        });
    }
    ngOnInit() { }
    ngAfterViewInit() {
        this.observer = new ResizeObserver((entries) => {
            for (let entry of entries) {
                const cr = entry.contentRect;
                let element;
                if (this.model.draggingElement && this.model.draggingElement != this.lastUpdatedElement) {
                    element = this.model.draggingElement;
                }
                else if (this.model.elementToUpdate != null) {
                    element = this.model.elementToUpdate;
                }
                else {
                    this.model.form?.pages.forEach((page) => {
                        page.allElements.forEach((component) => {
                            if (component === this.element) {
                                element = component;
                            }
                        });
                    });
                }
                this.zone.run(() => {
                    this.updateElement(element, cr);
                });
            }
        });
        this.observer?.observe(this.clone?.nativeElement);
    }
    updateElement(component, cr) {
        if (!component || component.type == "TextElement") {
            return;
        }
        if (this.model.draggingElement && this.model.draggingElement == this.lastUpdatedElement) {
            return;
        }
        if (this.lastUpdatedElement != component) {
            this.lastUpdatedElement = component;
        }
        if (this.model.elementToUpdate == null) {
            let bottomElements = [];
            let freeAreaHeight;
            let currentPage = this.model.getElementPage(this.model.selectedComponent?.element);
            let currentPanel = this.model.getElementPanel(this.model.selectedComponent?.element);
            currentPage?.elements?.forEach((elem) => {
                if (elem.y >= this.model.selectedComponent.element.geometry.bottom) {
                    bottomElements.push(elem);
                }
            });
            if (bottomElements.length > 0) {
                let maxBottomPoint = Math.max(...bottomElements.map((elem) => elem.geometry.bottom));
                freeAreaHeight = (currentPage?.contentAreaHeight || currentPanel?.height) - maxBottomPoint;
            }
            else {
                freeAreaHeight =
                    (currentPage?.contentAreaHeight || currentPanel?.height) -
                        this.model.selectedComponent?.element.geometry.bottom;
            }
        }
        let parentContainer = component.getParent(this.model.form) ?? this.model.form.pages[0];
        let sizeChanged = false;
        let minHeight = Number(((Math.round(cr.height) / this.currentVerticalStep) % 1).toFixed(2)) <= 0.5 &&
            Math.round(cr.height) != parentContainer["contentAreaHeight"]
            ? Math.floor(cr.height / this.currentVerticalStep) * this.currentVerticalStep
            : Math.ceil(cr.height / this.currentVerticalStep) * this.currentVerticalStep;
        if (component.geometry.minHeight != minHeight &&
            minHeight <= parentContainer["contentAreaHeight"] &&
            minHeight != 0 &&
            Math.abs(component.geometry.minHeight - minHeight) > 1) {
            component.geometry.minHeight = minHeight;
            sizeChanged = true;
        }
        else if (minHeight >= parentContainer["contentAreaHeight"] - component.geometry.y) {
            component.geometry.minHeight = parentContainer["contentAreaHeight"] - component.geometry.y;
            sizeChanged = true;
        }
        if (parentContainer) {
            let columnWidth = parentContainer.getColumnWidth(this.model.form.settings.gridColumns);
            let minWidth = Math.max(Math.min(Math.ceil(Number(cr.width.toFixed(2)) / columnWidth) * columnWidth, this.maxWidth), columnWidth);
            if (minWidth != component.geometry.minWidth) {
                component.geometry.minWidth = minWidth;
                sizeChanged = true;
            }
            if (sizeChanged && this.model.draggingElement != component) {
                this.render.insertElement(component);
                this.render.checkOutputs(this.model.getElementPage(component));
            }
        }
        else {
            component.geometry.minWidth = Math.max(cr.width, 2);
        }
        this.model.elementToUpdate = null;
    }
    updateObservable() {
        this.observer?.unobserve(this.clone?.nativeElement);
        this.observer?.observe(this.clone?.nativeElement);
    }
    ngOnDestroy() {
        this.observer?.unobserve(this.clone?.nativeElement);
    }
    get element() {
        return this.model.draggingElement
            ? this.model.draggingElement
            : this.model.elementToUpdate ?? this.model.selectedComponent?.element;
    }
    get maxWidth() {
        return this.model?.draggingElement
            ? this.model?.form?.pages[0].contentAreaWidth - this.element?.x
            : this.element?.getParent(this.model.form)?.contentAreaWidth - this.element?.x;
    }
    get currentVerticalStep() {
        return this.model.form?.settings?.gridVerticalStep != 1 ? this.model.form?.settings?.gridVerticalStep : 5;
    }
}
StiCloneElementContainerComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiCloneElementContainerComponent, deps: [{ token: i1.StiModelService }, { token: i0.NgZone }, { token: StiRectangleGeometryLayout }], target: i0.ɵɵFactoryTarget.Component });
StiCloneElementContainerComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StiCloneElementContainerComponent, selector: "sti-clone-element-container", viewQueries: [{ propertyName: "clone", first: true, predicate: ["clone"], descendants: true }], ngImport: i0, template: `
    <div
      #clone
      style="position: absolute; top:-9999px; left:-9999px; z-index: -1; opacity:0;white-space:nowrap; userSelect:none;"
      [style.width]="'min-content'"
      [style.height]="'auto'"
      [style.max-width.px]="maxWidth"
    >
      <sti-component-holder [element]="element" [isClone]="this.isClone"></sti-component-holder>
    </div>
  `, isInline: true, dependencies: [{ kind: "component", type: i2.StiComponentHolderComponent, selector: "sti-component-holder", inputs: ["element", "isClone"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiCloneElementContainerComponent, decorators: [{
            type: Component,
            args: [{
                    selector: "sti-clone-element-container",
                    template: `
    <div
      #clone
      style="position: absolute; top:-9999px; left:-9999px; z-index: -1; opacity:0;white-space:nowrap; userSelect:none;"
      [style.width]="'min-content'"
      [style.height]="'auto'"
      [style.max-width.px]="maxWidth"
    >
      <sti-component-holder [element]="element" [isClone]="this.isClone"></sti-component-holder>
    </div>
  `,
                }]
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i0.NgZone }, { type: StiRectangleGeometryLayout }]; }, propDecorators: { clone: [{
                type: ViewChild,
                args: ["clone"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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