/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
export var UnicodeCategory;
(function (UnicodeCategory) {
    /**
     * Uppercase letter. Signified by the Unicode designation "Lu" (letter, uppercase).
     * The value is 0.
     */
    UnicodeCategory[UnicodeCategory["UppercaseLetter"] = 0] = "UppercaseLetter";
    /**
     * Lowercase letter. Signified by the Unicode designation "Ll" (letter, lowercase).
     * The value is 1.
     */
    UnicodeCategory[UnicodeCategory["LowercaseLetter"] = 1] = "LowercaseLetter";
    /**
     * Titlecase letter. Signified by the Unicode designation "Lt" (letter, titlecase).
     * The value is 2.
     */
    UnicodeCategory[UnicodeCategory["TitlecaseLetter"] = 2] = "TitlecaseLetter";
    /**
     * Modifier letter character, which is free-standing spacing character that
     * indicates modifications of a preceding letter. Signified by the Unicode designation
     * "Lm" (letter, modifier). The value is 3.
     */
    UnicodeCategory[UnicodeCategory["ModifierLetter"] = 3] = "ModifierLetter";
    /**
     * Letter that is not an uppercase letter, a lowercase letter, a titlecase letter,
     * or a modifier letter. Signified by the Unicode designation "Lo" (letter,
     * other). The value is 4.
     */
    UnicodeCategory[UnicodeCategory["OtherLetter"] = 4] = "OtherLetter";
    /**
     * Nonspacing character that indicates modifications of a base character. Signified
     * by the Unicode designation "Mn" (mark, nonspacing). The value is 5.
     */
    UnicodeCategory[UnicodeCategory["NonSpacingMark"] = 5] = "NonSpacingMark";
    /**
     * Spacing character that indicates modifications of a base character and affects
     * the width of the glyph for that base character. Signified by the Unicode
     * designation "Mc" (mark, spacing combining). The value is 6.
     */
    UnicodeCategory[UnicodeCategory["SpacingCombiningMark"] = 6] = "SpacingCombiningMark";
    /**
     * Enclosing mark character, which is a nonspacing combining character that
     * surrounds all previous characters up to and including a base character. Signified
     * by the Unicode designation "Me" (mark, enclosing). The value is 7.
     */
    UnicodeCategory[UnicodeCategory["EnclosingMark"] = 7] = "EnclosingMark";
    /**
     * Decimal digit character, that is, a character in the range 0 through 9. Signified
     * by the Unicode designation "Nd" (number, decimal digit). The value is 8.
     */
    UnicodeCategory[UnicodeCategory["DecimalDigitNumber"] = 8] = "DecimalDigitNumber";
    /**
     * Number represented by a letter, instead of a decimal digit, for example,
     * the Roman numeral for five, which is "V". The indicator is signified by the
     * Unicode designation "Nl" (number, letter). The value is 9.
     */
    UnicodeCategory[UnicodeCategory["LetterNumber"] = 9] = "LetterNumber";
    /**
     * Number that is neither a decimal digit nor a letter number, for example,
     * the fraction 1/2. The indicator is signified by the Unicode designation "No"
     * (number, other). The value is 10.
     */
    UnicodeCategory[UnicodeCategory["OtherNumber"] = 10] = "OtherNumber";
    /**
     * Space character, which has no glyph but is not a control or format character.
     * Signified by the Unicode designation "Zs" (separator, space). The value is 11.
     */
    UnicodeCategory[UnicodeCategory["SpaceSeparator"] = 11] = "SpaceSeparator";
    /**
     * Character that is used to separate lines of text. Signified by the Unicode
     * designation "Zl" (separator, line). The value is 12.
     */
    UnicodeCategory[UnicodeCategory["LineSeparator"] = 12] = "LineSeparator";
    /**
     * Character used to separate paragraphs. Signified by the Unicode designation
     * "Zp" (separator, paragraph). The value is 13.
     */
    UnicodeCategory[UnicodeCategory["ParagraphSeparator"] = 13] = "ParagraphSeparator";
    /**
     * Control code character, with a Unicode value of U+007F or in the range U+0000
     * through U+001F or U+0080 through U+009F. Signified by the Unicode designation
     * "Cc" (other, control). The value is 14.
     */
    UnicodeCategory[UnicodeCategory["Control"] = 14] = "Control";
    /**
     * Format character that affects the layout of text or the operation of text
     * processes, but is not normally rendered. Signified by the Unicode designation
     * "Cf" (other, format). The value is 15.
     */
    UnicodeCategory[UnicodeCategory["Format"] = 15] = "Format";
    /**
     * High surrogate or a low surrogate character. Surrogate code values are in
     * the range U+D800 through U+DFFF. Signified by the Unicode designation "Cs"
     * (other, surrogate). The value is 16.
     */
    UnicodeCategory[UnicodeCategory["Surrogate"] = 16] = "Surrogate";
    /**
     * Private-use character, with a Unicode value in the range U+E000 through U+F8FF.
     * Signified by the Unicode designation "Co" (other, private use). The value is 17.
     */
    UnicodeCategory[UnicodeCategory["PrivateUse"] = 17] = "PrivateUse";
    /**
     * Connector punctuation character that connects two characters. Signified by
     * the Unicode designation "Pc" (punctuation, connector). The value is 18.
     */
    UnicodeCategory[UnicodeCategory["ConnectorPunctuation"] = 18] = "ConnectorPunctuation";
    /**
     * Dash or hyphen character. Signified by the Unicode designation "Pd" (punctuation,
     * dash). The value is 19.
     */
    UnicodeCategory[UnicodeCategory["DashPunctuation"] = 19] = "DashPunctuation";
    /**
     * Opening character of one of the paired punctuation marks, such as parentheses,
     * square brackets, and braces. Signified by the Unicode designation "Ps" (punctuation,
     * open). The value is 20.
     */
    UnicodeCategory[UnicodeCategory["OpenPunctuation"] = 20] = "OpenPunctuation";
    /**
     * Closing character of one of the paired punctuation marks, such as parentheses,
     * square brackets, and braces. Signified by the Unicode designation "Pe" (punctuation,
     * close). The value is 21.
     */
    UnicodeCategory[UnicodeCategory["ClosePunctuation"] = 21] = "ClosePunctuation";
    /**
     * Opening or initial quotation mark character. Signified by the Unicode designation
     * "Pi" (punctuation, initial quote). The value is 22.
     */
    UnicodeCategory[UnicodeCategory["InitialQuotePunctuation"] = 22] = "InitialQuotePunctuation";
    /**
     * Closing or final quotation mark character. Signified by the Unicode designation
     * "Pf" (punctuation, final quote). The value is 23.
     */
    UnicodeCategory[UnicodeCategory["FinalQuotePunctuation"] = 23] = "FinalQuotePunctuation";
    /**
     * Punctuation character that is not a connector, a dash, open punctuation,
     * close punctuation, an initial quote, or a final quote. Signified by the Unicode
     * designation "Po" (punctuation, other). The value is 24.
     */
    UnicodeCategory[UnicodeCategory["OtherPunctuation"] = 24] = "OtherPunctuation";
    /**
     * Mathematical symbol character, such as "+" or "= ". Signified by the Unicode
     * designation "Sm" (symbol, math). The value is 25.
     */
    UnicodeCategory[UnicodeCategory["MathSymbol"] = 25] = "MathSymbol";
    /**
     * Currency symbol character. Signified by the Unicode designation "Sc" (symbol,
     * currency). The value is 26.
     */
    UnicodeCategory[UnicodeCategory["CurrencySymbol"] = 26] = "CurrencySymbol";
    /**
     * Modifier symbol character, which indicates modifications of surrounding characters.
     * For example, the fraction slash indicates that the number to the left is
     * the numerator and the number to the right is the denominator. The indicator
     * is signified by the Unicode designation "Sk" (symbol, modifier). The value is 27.
     */
    UnicodeCategory[UnicodeCategory["ModifierSymbol"] = 27] = "ModifierSymbol";
    /**
     * Symbol character that is not a mathematical symbol, a currency symbol or
     * a modifier symbol. Signified by the Unicode designation "So" (symbol, other).
     * The value is 28.
     */
    UnicodeCategory[UnicodeCategory["OtherSymbol"] = 28] = "OtherSymbol";
    /**
     * Character that is not assigned to any Unicode category. Signified by the
     * Unicode designation "Cn" (other, not assigned). The value is 29.
     */
    UnicodeCategory[UnicodeCategory["OtherNotAssigned"] = 29] = "OtherNotAssigned";
})(UnicodeCategory || (UnicodeCategory = {}));
//# sourceMappingURL=data:application/json;base64,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