/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
export class StiObject {
    static keys(obj) {
        // if (Object.keys) return Object.keys(obj);
        let keys = [];
        // eslint-disable-next-line @typescript-eslint/no-for-in-array
        for (let i in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, i)) {
                keys.push(i);
            }
        }
        // eslint-disable-next-line @typescript-eslint/no-for-in-array
        for (let i in obj.__proto__) {
            if (Object.prototype.hasOwnProperty.call(obj, i)) {
                keys.push(i);
            }
        }
        return keys;
    }
    static disableAllEnumerable(prototype, obj) {
        // eslint-disable-next-line @typescript-eslint/no-for-in-array
        for (let name in obj) {
            Object.defineProperty(prototype, name, { enumerable: false });
        }
    }
}
export class StiString extends StiObject {
    static isNullOrEmpty(value) {
        return value == null || value === "" || value === undefined;
    }
}
//# sourceMappingURL=data:application/json;base64,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