/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
import Hashtable from './Hashtable';
import Dictionary from './Dictionary';
import { StiObject } from './StiObject';
export default class List extends Array {
    constructor(items) {
        super();
        if (typeof items == "number") {
        }
        else if (items)
            items.forEach(item => this.push(item));
        try {
            this.__proto__ = List.prototype;
            Object.defineProperty(this, "__proto__", { enumerable: false });
        }
        catch (e) {
            Object.defineProperty(this, "__proto__", { enumerable: false, writable: true });
            this.__proto__ = List.prototype;
        }
    }
    /*static create<T>(t: Type, ...values: any[]): List<T> {
        let isStructure = false;
        if (typeof values[values.length - 1] == "boolean") isStructure = !!values.pop();

        if (values.length == 0) {
            if (t == Number) return <any>0;
            if (t == Boolean) return <any>false;
            if (isStructure) return new (<any>t);
            else return null;
        }

        let newList = new List<T>();
        let count: number = values.shift();
        for (let i = 0; i < count; i++) {
            let value: any = List.create.apply(this, (<any[]>[t]).concat(values, [isStructure]));
            newList.push(value);
        }

        return newList;
    }*/
    get countItems() {
        let properties = StiObject.keys(this);
        return properties.length;
    }
    //#region Range
    addRange(items) {
        for (let item of items)
            this.push(item);
    }
    removeRange(index, count) {
        this.splice(index, count);
    }
    getRange(index, count) {
        if (index == null || index < 0)
            index = 0;
        if (index + count > this.length)
            count = this.length - index;
        return new List(this.slice(index, index + count));
    }
    //#endregion
    add(item) {
        this.push(item);
    }
    insert(index, item) {
        this.splice(index, 0, item);
    }
    getKeys() {
        return StiObject.keys(this).sort((a, b) => {
            if (a < b)
                return -1;
            else if (a > b)
                return 1;
            else
                return 0;
        });
    }
    getByIndex(index, keys = null) {
        if (keys == null)
            keys = this.getKeys();
        return this[keys[index]];
    }
    setByIndex(index, item) {
        let properties = StiObject.keys(this);
        this[properties[index]] = item;
    }
    removeByIndex(index) {
        let removeIndex = this.indexOf(this.getByIndex(index, null));
        delete this[removeIndex];
        return this;
    }
    copyTo(array, index = 0) {
        let destIndex = index;
        for (let sourceIndex = 0; sourceIndex < this.length; sourceIndex++) {
            array[destIndex] = this[sourceIndex];
            destIndex++;
        }
    }
    /** Removes all elements from the List. */
    clear() {
        this.splice(0, this.length);
    }
    peek() {
        return this[this.length - 1];
    }
    remove(item) {
        let index = this.indexOf(item);
        if (index >= 0)
            this.removeAt(index);
    }
    /** Removes the element at the specified index of the Lis.
     * @param index The zero-based index of the element to remove.
     * @throw index is less than 0. -or- index is equal to or greater than Count.
     */
    removeAt(index) {
        this.splice(index, 1);
    }
    exists(predicate) {
        for (let value of this) {
            if (predicate(value))
                return true;
        }
        return false;
    }
    fullOuterJoin(inner, outerKeySelector, innerKeySelector, resultSelector, __this) {
        let innerLookup = inner.toLookup(innerKeySelector, __this);
        let outerLookup = this.toLookup(outerKeySelector, __this);
        let innerJoinItems = inner
            .where(innerItem => !outerLookup.contains(innerKeySelector.apply(__this, [innerItem])))
            .select(innerItem => resultSelector.apply(__this, [null, innerItem]));
        return this
            .selectMany2(outerItem => {
            let innerItems = innerLookup.get(outerKeySelector.apply(__this, [outerItem]));
            return innerItems.any() ? innerItems : new List();
        }, resultSelector, __this)
            .concat(innerJoinItems);
    }
    toList() {
        return new List(this);
    }
    findIndex2(match) {
        for (let index = 0; index < this.length; index++) {
            if (match(this[index]))
                return index;
        }
        return -1;
    }
    findLastIndex2(match) {
        let lastIndex = -1;
        for (let index = 0; index < this.length; index++) {
            if (match(this[index]))
                lastIndex = index;
        }
        return lastIndex;
    }
    zip(second, resultSelector) {
        let result = new List();
        for (let index = 0; index < this.length; index++) {
            result.add(resultSelector(this[index], second[index]));
        }
        return result;
    }
    static repeat(element, count) {
        let list = new List();
        for (let i = 0; i < count; i++) {
            list.push(element);
        }
        return list;
    }
    //#region Filtering
    /** Filters a sequence of values based on a predicate.
     * @param predicate A function to test each element for a condition.
     * @returns An List that contains elements from the input sequence that satisfy the condition.
     */
    where(predicate, __this) {
        let filter = new List();
        for (let index = 0; index < this.length; index++) {
            let value = this[index];
            predicate.apply(__this, [value, index]) ? filter.push(value) : null;
        }
        return filter;
    }
    //#endregion
    //#region Join
    /** Correlates the elements of two sequences based on matching keys. The default
     * equality comparer is used to compare keys.
     * @param inner The sequence to join to the first sequence.
     * @param outerKeySelector A function to extract the join key from each element of the first sequence.
     * @param innerKeySelector A function to extract the join key from each element of the second sequence.
     * @param resultSelector A function to create a result element from two matching elements.
     * @returns An List that has elements of type V
     * that are obtained by performing an inner join on two sequences.
     */
    join2(inner, outerKeySelector, innerKeySelector, resultSelector, __this) {
        let result = new List();
        let innerKeys = new Hashtable();
        for (let i of inner) {
            let innerKey = innerKeySelector.apply(__this, [i]);
            innerKeys.set(innerKey, i);
        }
        for (let o of this) {
            let outerKey = outerKeySelector.apply(__this, [o]);
            let i = innerKeys.get(outerKey);
            if (i != null)
                result.push(resultSelector.apply(__this, [o, i]));
        }
        return result;
    }
    /** Correlates the elements of two sequences based on equality of keys and groups
     * the results. The default equality comparer is used to compare keys.
     * @param inner The sequence to join to the first sequence.
     * @param outerKeySelector A function to extract the join key from each element of the first sequence.
     * @param innerKeySelector A function to extract the join key from each element of the second sequence.
     * @param resultSelector A function to create a result element from an element from the first sequence
     * and a collection of matching elements from the second sequence.
     * @returns An List that contains elements of type V
     * that are obtained by performing a grouped join on two sequences.
     */
    groupJoin(inner, outerKeySelector, innerKeySelector, resultSelector, __this) {
        let result = new List();
        let innerKeys = new Hashtable();
        for (let i of inner) {
            let key = innerKeySelector.apply(__this, [i]);
            let innerResult = innerKeys.get(key);
            if (innerResult == null) {
                innerResult = new List();
                innerKeys.set(key, innerResult);
            }
            innerResult.push(i);
        }
        for (let o of this) {
            let key = outerKeySelector.apply(__this, [o]);
            let innerResult = innerKeys.get(key);
            if (innerResult == null)
                innerResult = new List();
            result.push(resultSelector.apply(__this, [o, innerResult]));
        }
        return result;
    }
    //#endregion
    //#region Projection
    /**
     * Projects each element of a sequence into a new form.
     * @param selector A transform function to apply to each element.
     * @returns An List whose elements are the result of invoking the transform function on each element of source.
     */
    select(selector, __this) {
        let filter = new List();
        this.forEach(value => filter.push(selector.apply(__this, [value])));
        return filter;
    }
    selectMany(selector, __this) {
        let filter = new List();
        this.forEach(value => {
            let result = selector.apply(__this, [value]);
            if (result != null)
                result.forEach(item => filter.push(item));
        });
        return filter;
    }
    selectMany2(collectionSelector, resultSelector, __this) {
        let filter = new List();
        this.forEach(value => {
            let result = collectionSelector.apply(__this, [value]);
            if (result != null)
                result.forEach(item => filter.push(resultSelector.apply(__this, [value, item])));
        });
        return filter;
    }
    //#endregion
    //#region Sorting
    /** Sorts the elements of a sequence in ascending order according to a key or by using a specified comparer.
     * @param keySelector A function to extract a key from an element.
     * @param comparer An System.Collections.Generic.IComparer`1 to compare keys.
     * @returns An System.Linq.IOrderedEnumerable`1 whose elements are sorted according to a key.
     */
    /*orderBy<K>(keySelector: (value: T) => K, comparer?: IComparer<K>): List<T> {
         let sort: T[] = this.ss.toArray();
         if (comparer == null) comparer = {
             compare: (x: K, y: K) => {
                 if (x != null && y == null) return 1;
                 if (x == null && y != null) return -1;
                 if (x == null && y == null) return 0;
 
                 return x.ss.compareTo(y);
             }
         };
 
         sort.sort((a: T, b: T) => comparer.compare(keySelector(a), keySelector(b)));
 
         return new List<T>(sort);
     }
 
     orderByDescending<K>(keySelector: (value: T) => K, comparer?: IComparer<K>): List<T> {
         let sort: T[] = this.ss.toArray();
         if (comparer == null) comparer = {
             compare: (x: K, y: K) => {
                 if (x != null && y == null) return -1;
                 if (x == null && y != null) return 1;
                 if (x == null && y == null) return 0;
 
                 return y.ss.compareTo(x);
             }
         };
 
         sort.sort((a: T, b: T) => comparer.compare(keySelector(a), keySelector(b)));
 
         return new List<T>(sort);
     }*/
    //#endregion
    //#region Grouping
    /** Groups the elements of a sequence according to a specified key selector function
     * and compares the keys by using a specified comparer.
     * @param keySelector A function to extract the key for each element.
     * @param comparer An System.Collections.Generic.IEqualityComparer`1 to compare keys.
     * @returns An IEnumerable<IGrouping<TKey, TSource>> in C# or IEnumerable(Of IGrouping(Of
     * TKey, TSource)) in Visual Basic where each System.Linq.IGrouping`2 object contains
     * a collection of objects and a key.
     */
    /*-groupBy<K>(keySelector: (value: T) => K, comparer?: IEqualityComparer<K>, __this?: any): List<Grouping<K, T>> {
        let result = new List<Grouping<K, T>>();
        if (comparer == null) comparer = {
            equals: (x: K, y: K) => {
                if (x == y) return true;
                return false;
            },
            getHashCode: () => 0
        };

        for (let item of this) {
            let key = keySelector.apply(__this, [item]);
            let group = result.firstOrDefault(g => comparer.equals(g.key, key));
            if (group == null) {
                group = new Grouping(new List<T>([]));
                group.key = key;
                result.push(group);
            }
            group.push(item);
        }

        return result;
    }*/
    //#endregion
    //#region Conversions
    /** Converts the elements of an List to the specified type.
     * @returns An List that contains each element of the source sequence converted to the specified type.
     */
    cast() {
        let cast = new List();
        let castFunction;
        /*if (typeof <S>{} == "string") castFunction = (value: T) => value.s.toString();
        else if (typeof <S>{} == "number") castFunction = (value: T) => value.s.ss.toNumber();
        else if (typeof <S>{} == "boolean") castFunction = (value: T) => value.s.ss.toBoolean();
        else*/ castFunction = (value) => value;
        this.forEach(value => cast.push(castFunction(value)));
        return cast;
    }
    toDictionary(keySelector, elementSelector) {
        let dictionary = new Dictionary();
        for (let index = 0; index < this.length; index++) {
            dictionary.add(keySelector(this[index]), elementSelector(this[index]));
        }
        return dictionary;
    }
    /** Creates a Lookup from an List
     * according to a specified key selector function.
     * @param keySelector A function to extract a key from each element.
     * @returns A Lookup that contains keys and values.
     */
    toLookup(keySelector, __this) {
        let hashtable = new Hashtable();
        for (let item of this) {
            let key = keySelector.apply(__this, [item]);
            let lookup = hashtable.get(key);
            if (lookup == null) {
                lookup = new List();
                hashtable.set(key, lookup);
            }
            lookup.push(item);
        }
        return hashtable;
    }
    //#endregion
    //#region Concatenation
    /** Concatenates two sequences.
     * @param second The sequence to concatenate to the first sequence.
     * @returns An List that contains the concatenated elements
     * of the two input sequences.
     */
    concat(second) {
        let concatedList = new List();
        for (let item of this)
            concatedList.push(item);
        for (let item of second)
            concatedList.push(item);
        return concatedList;
    }
    //#endregion
    //#region Aggregation
    /**
     * Applies an accumulator function over a sequence.
     * @param func An accumulator function to be invoked on each element.
     * @returns The final accumulator value.
     */
    aggregate(func) {
        let seed = this[0];
        for (let index = 1; index < this.length; index++) {
            seed = func(seed, this[index]);
        }
        return seed;
    }
    aggregate2(seed, func) {
        for (let index = 0; index < this.length; index++) {
            seed = func(seed, this[index]);
        }
        return seed;
    }
    count2(selector, __this) {
        if (selector == null)
            selector = (value) => true;
        let count = 0;
        this.forEach(item => selector.apply(__this, [item]) ? count++ : null);
        return count;
    }
    /** Invokes a transform function on each element of a sequence and returns the maximum value.
     * @param selector A transform function to apply to each element.
     * @returns The maximum value in the sequence.
     */
    /*max<S>(selector?: (value: T) => S): S {
        if (selector == null) selector = (value: T) => <S><any>value;
        if (this.length == 0) return null;
        let max = selector(this[0]);
        let maxFunc: Function;
        if (typeof max == "string") maxFunc = function (strA: string, strB: string): string { return strA.ss.compareTo(strB) >= 0 ? strA : strB; };
        if (typeof max == "number") maxFunc = Math.max;
        if (max instanceof DateTime) maxFunc = function (dateA: DateTime, dateB: DateTime): DateTime { return DateTime.compare(dateA, dateB) >= 0 ? dateA : dateB; };

        for (let index = 1; index < this.length; index++) {
            max = maxFunc(selector(this[index]), max);
        }

        return max;
    }*/
    /** Invokes a transform function on each element of a sequence and returns the minimum value.
     * @parm selector A transform function to apply to each element.
     * @returns The minimum value in the sequence.
     */
    /*min<S>(selector?: (value: T) => S): S {
        if (selector == null) selector = (value: T) => <S><any>value;
        if (this.length == 0) return null;
        let min = selector(this[0]);
        let minFunc: Function;
        if (typeof min == "string") minFunc = function (strA: string, strB: string): string { return strA.ss.compareTo(strB) <= 0 ? strA : strB; };
        if (typeof min == "number") minFunc = Math.min;
        if (min instanceof DateTime) minFunc = function (dateA: DateTime, dateB: DateTime): DateTime { return DateTime.compare(dateA, dateB) <= 0 ? dateA : dateB; };

        for (let index = 1; index < this.length; index++) {
            min = minFunc(selector(this[index]), min);
        }

        return min;
    }*/
    /** Computes the sum of the sequence of System.Decimal values that are obtained by
     * invoking a transform function on each element of the input sequence.
     * @param selector A transform function to apply to each element.
     * @returns The sum of the projected values.
     */
    /*sum(selector?: (value: T) => number): number {
        if (selector == null) selector = (value: T) => value.ss.toNumber();
        let sum = 0;
        this.forEach(value => sum += selector(value));
        return sum;
    }*/
    //#endregion
    //#region Quantifier Operations
    all(predicate, __this) {
        if (predicate == null)
            predicate = (value) => true;
        for (let value of this)
            if (!predicate.apply(__this, [value]))
                return false;
        return true;
    }
    /** Determines whether any element of a sequence satisfies a condition.
     * @param predicate A function to test each element for a condition.
     * @returns true if any elements in the source sequence pass the test in the specified predicate; otherwise, false.
     */
    any(predicate, __this) {
        if (predicate == null)
            predicate = (value) => true;
        for (let value of this)
            if (predicate.apply(__this, [value]))
                return true;
        return false;
    }
    /** Determines whether an element is in the List.
     * @param item The object to locate in the List. The value can be null for reference types.
     * @returns true if item is found in the List otherwise, false.
     */
    contains(item) {
        return this.indexOf(item) >= 0;
    }
    //#endregion
    //#region Partition Operations
    skip(count) {
        let result = new List();
        for (let index = count; index < this.length; index++) {
            result.add(this[index]);
        }
        return result;
    }
    take(count) {
        let result = new List();
        if (count > this.length)
            count = this.length;
        for (let index = 0; index < count; index++) {
            result.add(this[index]);
        }
        return result;
    }
    //#endregion
    //#region Generation Operations
    defaultIfEmpty() {
        if (this.length > 0)
            return this;
        return new List([null]);
    }
    //#endregion
    //#region Set Operations
    /** Returns distinct elements from a sequence by using the default equality comparer to compare values.
     * @returns An List that contains distinct elements from the source sequence.
     */
    distinct() {
        let filter = new List();
        this.forEach(value => filter.indexOf(value) < 0 ? filter.push(value) : null);
        return filter;
    }
    except(second) {
        let result = new List();
        for (let item of this) {
            if (second.indexOf(item) == -1)
                result.add(item);
        }
        return result;
    }
    union(second) {
        let union = new List();
        this.forEach(element => union.add(element));
        second.forEach(element => union.add(element));
        return union.distinct();
    }
    //#endregion
    //#region Equality
    sequenceEqual(second) {
        if (this.length != second.length)
            return false;
        for (let index = 0; index < this.length; index++) {
            if (this[index] != second[index])
                return false;
        }
        return true;
    }
    //#endregion
    //#region Element
    first(selector, __this) {
        if (selector == null)
            selector = (value) => true;
        for (let item of this) {
            if (selector.apply(__this, [item]))
                return item;
        }
        return null;
    }
    /** Returns the first element of the sequence that satisfies a condition or a default value if no such element is found.
     * @param predicate A function to test each element for a condition.
     * @returns if source is empty or if no element passes the test specified by predicate;
     * otherwise, the first element in source that passes the test specified by predicate.
     */
    firstOrDefault(predicate) {
        for (let value of this) {
            if (predicate == null)
                return value;
            if (predicate(value))
                return value;
        }
        return null;
    }
    lastOrDefault() {
        let item;
        for (let value of this) {
            item = value;
        }
        return item;
    }
}
StiObject.disableAllEnumerable(List.prototype, new List());
//# sourceMappingURL=data:application/json;base64,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