/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
import List from "./List";
import { StiObject } from "./StiObject";
export default class Hashtable {
    constructor(options = { ignoreCase: false }) {
        this.ignoreCase = false;
        this.isSimpleKeys = false;
        this.keys = new List();
        this.values = new List();
        this.indexObject = {};
        this.ignoreCase = options.ignoreCase;
        if (this.ignoreCase)
            this.isSimpleKeys = true;
    }
    get(key) {
        if (this.isSimpleKeys) {
            if (this.ignoreCase)
                key = key.toLowerCase();
            return this.values[this.indexObject[key]];
        }
        return this.values[this.keys.indexOf(key)];
    }
    set(key, value) {
        if (this.isSimpleKeys) {
            let type = typeof key;
            if (type != "string" && type != "number") {
                this.isSimpleKeys = false;
                this.indexObject = {};
            }
        }
        else if (this.keys.length == 0) {
            let type = typeof key;
            if (type == "string" || type == "number")
                this.isSimpleKeys = true;
        }
        let index = -1;
        if (this.isSimpleKeys) {
            if (this.ignoreCase)
                key = key.toLowerCase();
            index = this.indexObject[key];
        }
        else
            index = this.keys.indexOf(key);
        if (index >= 0)
            this.values[index] = value;
        else {
            if (this.isSimpleKeys) {
                if (this.ignoreCase)
                    key = key.toLowerCase();
                this.indexObject[key] = this.keys.length;
            }
            this.keys.push(key);
            this.values.push(value);
        }
    }
    /** Adds an element with the specified key and value into the Hashtable. */
    add(key, value) {
        this.set(key, value);
    }
    /** Determines whether the Hashtable contains a specific key. */
    contains(key) {
        if (this.isSimpleKeys) {
            if (this.ignoreCase)
                key = key.toLowerCase();
            return this.indexObject[key] != undefined;
        }
        return this.keys.contains(key);
    }
    /** Determines whether the Hashtable contains a specific key. */
    containsKey(key) {
        if (this.isSimpleKeys) {
            if (this.ignoreCase)
                key = key.toLowerCase();
            return this.indexObject[key] != undefined;
        }
        return this.keys.contains(key);
    }
    /** Determines whether the Hashtable contains a specific value. */
    containsValue(value) {
        return this.values.contains(value);
    }
    /** Removes the element with the specified key from the Hashtable. */
    remove(key) {
        let index;
        if (this.isSimpleKeys) {
            if (this.ignoreCase)
                key = key.toLowerCase();
            index = this.indexObject[key];
        }
        else
            index = this.keys.indexOf(key);
        if (index >= 0) {
            this.keys.removeAt(index);
            this.values.removeAt(index);
            if (this.isSimpleKeys) {
                this.indexObject = {};
                for (let index = 0; index < this.keys.length; index++) {
                    this.indexObject[this.ignoreCase ? this.keys[index].toLowerCase() : this.keys[index]] = index;
                }
            }
        }
    }
    /** Removes all elements from the Hashtable. */
    clear() {
        this.keys = new List();
        this.values = new List();
        this.indexObject = {};
        this.isSimpleKeys = false;
    }
    /** Copies the Hashtable elements to a one-dimensional Array instance at the specified index. */
    copyTo(array, arrayIndex) {
        while (array.length < arrayIndex) {
            array.push(null);
        }
        for (let value of this.values) {
            if (array.length > arrayIndex)
                array[arrayIndex] = value;
            else
                array.push(value);
            arrayIndex++;
        }
    }
    /** Gets the number of key/value pairs contained in the Hashtable. */
    get count() {
        return this.keys.length;
    }
    clone() {
        let newHashtable = new Hashtable();
        this.keys.copyTo(newHashtable.keys);
        this.values.copyTo(newHashtable.values);
        if (this.isSimpleKeys)
            for (let key of StiObject.keys(this.indexObject)) {
                newHashtable.indexObject[key] = this.indexObject[key];
            }
        newHashtable.ignoreCase = this.ignoreCase;
        newHashtable.isSimpleKeys = this.isSimpleKeys;
        return newHashtable;
    }
}
//# sourceMappingURL=data:application/json;base64,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