/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
export default class Guid {
    constructor(id) {
        this.id = id.toLowerCase();
    }
    static newGuid() {
        return new Guid(Guid.s4() + Guid.s4() + "-" + Guid.s4() + "-" + Guid.s4() + "-" +
            Guid.s4() + "-" + Guid.s4() + Guid.s4() + Guid.s4());
    }
    static newGuidString() {
        return Guid.s4() + Guid.s4() + Guid.s4() + Guid.s4() +
            Guid.s4() + Guid.s4() + Guid.s4() + Guid.s4();
    }
    static s4() {
        return Math
            .floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
    }
    toString() {
        return this.id;
    }
    static empty() {
        return new Guid("00000000-0000-0000-0000-000000000000");
    }
    static compareTo(value) {
        let x = this.toString();
        let y = value.toString();
        return (x < y ? -1 : (x > y ? 1 : 0));
    }
}
//# sourceMappingURL=data:application/json;base64,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