/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
import { Char } from "./Char";
export class Enum {
    /*compareTo(value: Enum): number {
      if (this.value != null)
        return this.value.compareTo(value.value);
  
      return this.name.compareTo(value.name);
    }*/
    constructor(name, value = null) {
        this.name = name;
        this.value = value;
    }
    static getName(enumType, value) {
        let values = "";
        if (enumType[value] == undefined) {
            // eslint-disable-next-line @typescript-eslint/no-for-in-array
            for (let enumValue in enumType) {
                let enumValueNumber = +enumValue;
                if (enumValueNumber != 0 && (value & enumValueNumber) == enumValueNumber) {
                    value -= enumValueNumber;
                    // eslint-disable-next-line @typescript-eslint/restrict-plus-operands
                    values += (values.length > 0 ? ", " : "") + enumType[enumValueNumber];
                }
            }
            if (values.length == 0)
                values = enumType[0];
            return values;
        }
        return enumType[value];
    }
    static parse(enumType, value, upperFirstChar = true) {
        if (value == null)
            return null;
        if (typeof value == "number" || Char.isDigit(value))
            value = Enum.getName(enumType, +value);
        let values = value.toString().split(",");
        let enumValue;
        // tslint:disable-next-line: prefer-for-of
        for (let index = 0; index < values.length; index++) {
            let strValue = upperFirstChar ? this.upperFirstChar(values[index]) : values[index];
            if (typeof enumValue == "undefined")
                enumValue = enumType[strValue];
            else
                enumValue += enumType[strValue];
        }
        return enumValue;
    }
    static upperFirstChar(str) {
        str = str.trim();
        return str.length > 0 ? str.charAt(0).toUpperCase() + str.slice(1) : str;
    }
    static getNames(enumType) {
        let names = [];
        for (let enumValue in enumType) {
            if (typeof enumType[enumValue] != "number")
                names.push(enumType[enumValue]);
        }
        return names;
    }
    static getValues(enumType) {
        let values = [];
        for (let enumValue in enumType) {
            if (typeof enumType[enumValue] != "number")
                values.push(+enumValue);
        }
        return values;
    }
    toString() {
        return this.name;
    }
}
//# sourceMappingURL=data:application/json;base64,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