/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
export default class Color {
    constructor() {
        this.propertyName = "color";
        this.name = Color.customName;
    }
    static aliceBlue() {
        let color = Color.fromArgb(0xf0, 0xf8, 0xff);
        color.name = "Alice Blue";
        return color;
    }
    static antiqueWhite() {
        let color = Color.fromArgb(0xfa, 0xeb, 0xd7);
        color.name = "Antique White";
        return color;
    }
    static aqua() {
        let color = Color.fromArgb(0x00, 0xff, 0xff);
        color.name = "Aqua";
        return color;
    }
    static aquamarine() {
        let color = Color.fromArgb(0x7f, 0xff, 0xd4);
        color.name = "Aquamarine";
        return color;
    }
    static azure() {
        let color = Color.fromArgb(0xf0, 0xff, 0xff);
        color.name = "Azure";
        return color;
    }
    static beige() {
        let color = Color.fromArgb(0xf5, 0xf5, 0xdc);
        color.name = "Beige";
        return color;
    }
    static bisque() {
        let color = Color.fromArgb(0xff, 0xe4, 0xc4);
        color.name = "Bisque";
        return color;
    }
    static black() {
        let color = Color.fromArgb(0x00, 0x00, 0x00);
        color.name = "Black";
        return color;
    }
    static blanchedAlmond() {
        let color = Color.fromArgb(0xff, 0xeb, 0xcd);
        color.name = "Blanched Almond";
        return color;
    }
    static blue() {
        let color = Color.fromArgb(0x00, 0x00, 0xff);
        color.name = "Blue";
        return color;
    }
    static blueViolet() {
        let color = Color.fromArgb(0x8a, 0x2b, 0xe2);
        color.name = "Blue Violet";
        return color;
    }
    static brown() {
        let color = Color.fromArgb(0xa5, 0x2a, 0x2a);
        color.name = "Brown";
        return color;
    }
    static burlyWood() {
        let color = Color.fromArgb(0xde, 0xb8, 0x87);
        color.name = "Burly Wood";
        return color;
    }
    static cadetBlue() {
        let color = Color.fromArgb(0x5f, 0x9e, 0xa0);
        color.name = "Cadet Blue";
        return color;
    }
    static chartreuse() {
        let color = Color.fromArgb(0x7f, 0xff, 0x00);
        color.name = "Chartreuse";
        return color;
    }
    static chocolate() {
        let color = Color.fromArgb(0xd2, 0x69, 0x1e);
        color.name = "Chocolate";
        return color;
    }
    static coral() {
        let color = Color.fromArgb(0xff, 0x7f, 0x50);
        color.name = "Coral";
        return color;
    }
    static cornflowerBlue() {
        let color = Color.fromArgb(0x64, 0x95, 0xed);
        color.name = "Cornflower Blue";
        return color;
    }
    static cornsilk() {
        let color = Color.fromArgb(0xff, 0xf8, 0xdc);
        color.name = "Cornsilk";
        return color;
    }
    static crimson() {
        let color = Color.fromArgb(0xdc, 0x14, 0x3c);
        color.name = "Crimson";
        return color;
    }
    static cyan() {
        let color = Color.fromArgb(0x00, 0xff, 0xff);
        color.name = "Cyan";
        return color;
    }
    static darkBlue() {
        let color = Color.fromArgb(0x00, 0x00, 0x8b);
        color.name = "Dark Blue";
        return color;
    }
    static darkCyan() {
        let color = Color.fromArgb(0x00, 0x8b, 0x8b);
        color.name = "Dark Cyan";
        return color;
    }
    static darkGoldenrod() {
        let color = Color.fromArgb(0xb8, 0x86, 0x0b);
        color.name = "Dark Goldenrod";
        return color;
    }
    static darkGray() {
        let color = Color.fromArgb(0xa9, 0xa9, 0xa9);
        color.name = "Dark Gray";
        return color;
    }
    static darkGreen() {
        let color = Color.fromArgb(0x00, 0x64, 0x00);
        color.name = "Dark Green";
        return color;
    }
    static darkKhaki() {
        let color = Color.fromArgb(0xbd, 0xb7, 0x6b);
        color.name = "Dark Khaki";
        return color;
    }
    static darkMagenta() {
        let color = Color.fromArgb(0x8b, 0x00, 0x8b);
        color.name = "Dark Magenta";
        return color;
    }
    static darkOliveGreen() {
        let color = Color.fromArgb(0x55, 0x6b, 0x2f);
        color.name = "Dark Olive Green";
        return color;
    }
    static darkOrange() {
        let color = Color.fromArgb(0xff, 0x8c, 0x00);
        color.name = "Dark Orange";
        return color;
    }
    static darkOrchid() {
        let color = Color.fromArgb(0x99, 0x32, 0xcc);
        color.name = "Dark Orchid";
        return color;
    }
    static darkRed() {
        let color = Color.fromArgb(0x8b, 0x00, 0x00);
        color.name = "Dark Red";
        return color;
    }
    static darkSalmon() {
        let color = Color.fromArgb(0xe9, 0x96, 0x7a);
        color.name = "Dark Salmon";
        return color;
    }
    static darkSeaGreen() {
        let color = Color.fromArgb(0x8f, 0xbc, 0x8f);
        color.name = "Dark Sea Green";
        return color;
    }
    static darkSlateBlue() {
        let color = Color.fromArgb(0x48, 0x3d, 0x8b);
        color.name = "Dark Slate Blue";
        return color;
    }
    static darkSlateGray() {
        let color = Color.fromArgb(0x2f, 0x4f, 0x4f);
        color.name = "Dark Slate Gray";
        return color;
    }
    static darkTurquoise() {
        let color = Color.fromArgb(0x00, 0xce, 0xd1);
        color.name = "Dark Turquoise";
        return color;
    }
    static darkViolet() {
        let color = Color.fromArgb(0x94, 0x00, 0xd3);
        color.name = "Dark Violet";
        return color;
    }
    static deepPink() {
        let color = Color.fromArgb(0xff, 0x14, 0x93);
        color.name = "Deep Pink";
        return color;
    }
    static deepSkyBlue() {
        let color = Color.fromArgb(0x00, 0xbf, 0xff);
        color.name = "Deep Sky Blue";
        return color;
    }
    static dimGray() {
        let color = Color.fromArgb(0x69, 0x69, 0x69);
        color.name = "Dim Gray";
        return color;
    }
    static dodgerBlue() {
        let color = Color.fromArgb(0x1e, 0x90, 0xff);
        color.name = "Dodger Blue";
        return color;
    }
    static firebrick() {
        let color = Color.fromArgb(0xb2, 0x22, 0x22);
        color.name = "Firebrick";
        return color;
    }
    static floralWhite() {
        let color = Color.fromArgb(0xff, 0xfa, 0xf0);
        color.name = "Floral White";
        return color;
    }
    static forestGreen() {
        let color = Color.fromArgb(0x22, 0x8b, 0x22);
        color.name = "Forest Green";
        return color;
    }
    static fuchsia() {
        let color = Color.fromArgb(0xff, 0x00, 0xff);
        color.name = "Fuchsia";
        return color;
    }
    static gainsboro() {
        let color = Color.fromArgb(0xdc, 0xdc, 0xdc);
        color.name = "Gainsboro";
        return color;
    }
    static ghostWhite() {
        let color = Color.fromArgb(0xf8, 0xf8, 0xff);
        color.name = "Ghost White";
        return color;
    }
    static gold() {
        let color = Color.fromArgb(0xff, 0xd7, 0x00);
        color.name = "Gold";
        return color;
    }
    static goldenrod() {
        let color = Color.fromArgb(0xda, 0xa5, 0x20);
        color.name = "Goldenrod";
        return color;
    }
    static gray() {
        let color = Color.fromArgb(0x80, 0x80, 0x80);
        color.name = "Gray";
        return color;
    }
    static green() {
        let color = Color.fromArgb(0x00, 0x80, 0x00);
        color.name = "Green";
        return color;
    }
    static greenYellow() {
        let color = Color.fromArgb(0xad, 0xff, 0x2f);
        color.name = "Green Yellow";
        return color;
    }
    static honeydew() {
        let color = Color.fromArgb(0xf0, 0xff, 0xf0);
        color.name = "Honeydew";
        return color;
    }
    static hotPink() {
        let color = Color.fromArgb(0xff, 0x69, 0xb4);
        color.name = "Hot Pink";
        return color;
    }
    static indianRed() {
        let color = Color.fromArgb(0xcd, 0x5c, 0x5c);
        color.name = "Indian Red";
        return color;
    }
    static indigo() {
        let color = Color.fromArgb(0x4b, 0x00, 0x82);
        color.name = "Indigo";
        return color;
    }
    static ivory() {
        let color = Color.fromArgb(0xff, 0xff, 0xf0);
        color.name = "Ivory";
        return color;
    }
    static khaki() {
        let color = Color.fromArgb(0xf0, 0xe6, 0x8c);
        color.name = "Khaki";
        return color;
    }
    static lavender() {
        let color = Color.fromArgb(0xe6, 0xe6, 0xfa);
        color.name = "Lavender";
        return color;
    }
    static lavenderBlush() {
        let color = Color.fromArgb(0xff, 0xf0, 0xf5);
        color.name = "Lavender Blush";
        return color;
    }
    static lawnGreen() {
        let color = Color.fromArgb(0x7c, 0xfc, 0x00);
        color.name = "Lawn Green";
        return color;
    }
    static lemonChiffon() {
        let color = Color.fromArgb(0xff, 0xfa, 0xcd);
        color.name = "Lemon Chiffon";
        return color;
    }
    static lightBlue() {
        let color = Color.fromArgb(0xad, 0xd8, 0xe6);
        color.name = "Light Blue";
        return color;
    }
    static lightCoral() {
        let color = Color.fromArgb(0xf0, 0x80, 0x80);
        color.name = "Light Coral";
        return color;
    }
    static lightCyan() {
        let color = Color.fromArgb(0xe0, 0xff, 0xff);
        color.name = "Light Cyan";
        return color;
    }
    static lightGoldenrodYellow() {
        let color = Color.fromArgb(0xfa, 0xfa, 0xd2);
        color.name = "Light Goldenrod Yellow";
        return color;
    }
    static lightGray() {
        let color = Color.fromArgb(0xd3, 0xd3, 0xd3);
        color.name = "Light Gray";
        return color;
    }
    static lightGreen() {
        let color = Color.fromArgb(0x90, 0xee, 0x90);
        color.name = "Light Green";
        return color;
    }
    static lightPink() {
        let color = Color.fromArgb(0xff, 0xb6, 0xc1);
        color.name = "Light Pink";
        return color;
    }
    static lightSalmon() {
        let color = Color.fromArgb(0xff, 0xa0, 0x7a);
        color.name = "Light Salmon";
        return color;
    }
    static lightSeaGreen() {
        let color = Color.fromArgb(0x20, 0xb2, 0xaa);
        color.name = "Light Sea Green";
        return color;
    }
    static lightSkyBlue() {
        let color = Color.fromArgb(0x87, 0xce, 0xfa);
        color.name = "Light Sky Blue";
        return color;
    }
    static lightSlateGray() {
        let color = Color.fromArgb(0x77, 0x88, 0x99);
        color.name = "Light Slate Gray";
        return color;
    }
    static lightSteelBlue() {
        let color = Color.fromArgb(0xb0, 0xc4, 0xde);
        color.name = "Light Steel Blue";
        return color;
    }
    static lightYellow() {
        let color = Color.fromArgb(0xff, 0xff, 0xe0);
        color.name = "Light Yellow";
        return color;
    }
    static lime() {
        let color = Color.fromArgb(0x00, 0xff, 0x00);
        color.name = "Lime";
        return color;
    }
    static limeGreen() {
        let color = Color.fromArgb(0x32, 0xcd, 0x32);
        color.name = "Lime Green";
        return color;
    }
    static linen() {
        let color = Color.fromArgb(0xfa, 0xf0, 0xe6);
        color.name = "Linen";
        return color;
    }
    static magenta() {
        let color = Color.fromArgb(0xff, 0x00, 0xff);
        color.name = "Magenta";
        return color;
    }
    static maroon() {
        let color = Color.fromArgb(0x80, 0x00, 0x00);
        color.name = "Maroon";
        return color;
    }
    static mediumAquamarine() {
        let color = Color.fromArgb(0x66, 0xcd, 0xaa);
        color.name = "Medium Aquamarine";
        return color;
    }
    static mediumBlue() {
        let color = Color.fromArgb(0x00, 0x00, 0xcd);
        color.name = "Medium Blue";
        return color;
    }
    static mediumOrchid() {
        let color = Color.fromArgb(0xba, 0x55, 0xd3);
        color.name = "Medium Orchid";
        return color;
    }
    static mediumPurple() {
        let color = Color.fromArgb(0x93, 0x70, 0xdb);
        color.name = "Medium Purple";
        return color;
    }
    static mediumSeaGreen() {
        let color = Color.fromArgb(0x3c, 0xb3, 0x71);
        color.name = "Medium Sea Green";
        return color;
    }
    static mediumSlateBlue() {
        let color = Color.fromArgb(0x7b, 0x68, 0xee);
        color.name = "Medium Slate Blue";
        return color;
    }
    static mediumSpringGreen() {
        let color = Color.fromArgb(0x00, 0xfa, 0x9a);
        color.name = "Medium Spring Green";
        return color;
    }
    static mediumTurquoise() {
        let color = Color.fromArgb(0x48, 0xd1, 0xcc);
        color.name = "Medium Turquoise";
        return color;
    }
    static mediumVioletRed() {
        let color = Color.fromArgb(0xc7, 0x15, 0x85);
        color.name = "Medium Violet Red";
        return color;
    }
    static midnightBlue() {
        let color = Color.fromArgb(0x19, 0x19, 0x70);
        color.name = "Midnight Blue";
        return color;
    }
    static mintCream() {
        let color = Color.fromArgb(0xf5, 0xff, 0xfa);
        color.name = "Mint Cream";
        return color;
    }
    static mistyRose() {
        let color = Color.fromArgb(0xff, 0xe4, 0xe1);
        color.name = "Misty Rose";
        return color;
    }
    static moccasin() {
        let color = Color.fromArgb(0xff, 0xe4, 0xb5);
        color.name = "Moccasin";
        return color;
    }
    static navajoWhite() {
        let color = Color.fromArgb(0xff, 0xde, 0xad);
        color.name = "Navajo White";
        return color;
    }
    static navy() {
        let color = Color.fromArgb(0x00, 0x00, 0x80);
        color.name = "Navy";
        return color;
    }
    static oldLace() {
        let color = Color.fromArgb(0xfd, 0xf5, 0xe6);
        color.name = "Old Lace";
        return color;
    }
    static olive() {
        let color = Color.fromArgb(0x80, 0x80, 0x00);
        color.name = "Olive";
        return color;
    }
    static oliveDrab() {
        let color = Color.fromArgb(0x6b, 0x8e, 0x23);
        color.name = "Olive Drab";
        return color;
    }
    static orange() {
        let color = Color.fromArgb(0xff, 0xa5, 0x00);
        color.name = "Orange";
        return color;
    }
    static orangeRed() {
        let color = Color.fromArgb(0xff, 0x45, 0x00);
        color.name = "Orange Red";
        return color;
    }
    static orchid() {
        let color = Color.fromArgb(0xda, 0x70, 0xd6);
        color.name = "Orchid";
        return color;
    }
    static paleGoldenrod() {
        let color = Color.fromArgb(0xee, 0xe8, 0xaa);
        color.name = "Pale Goldenrod";
        return color;
    }
    static paleGreen() {
        let color = Color.fromArgb(0x98, 0xfb, 0x98);
        color.name = "Pale Green";
        return color;
    }
    static paleTurquoise() {
        let color = Color.fromArgb(0xaf, 0xee, 0xee);
        color.name = "Pale Turquoise";
        return color;
    }
    static paleVioletRed() {
        let color = Color.fromArgb(0xdb, 0x70, 0x93);
        color.name = "Pale Violet Red";
        return color;
    }
    static papayaWhip() {
        let color = Color.fromArgb(0xff, 0xef, 0xd5);
        color.name = "Papaya Whip";
        return color;
    }
    static peachPuff() {
        let color = Color.fromArgb(0xff, 0xda, 0xb9);
        color.name = "Peach Puff";
        return color;
    }
    static peru() {
        let color = Color.fromArgb(0xcd, 0x85, 0x3f);
        color.name = "Peru";
        return color;
    }
    static pink() {
        let color = Color.fromArgb(0xff, 0xc0, 0xcb);
        color.name = "Pink";
        return color;
    }
    static plum() {
        let color = Color.fromArgb(0xdd, 0xa0, 0xdd);
        color.name = "Plum";
        return color;
    }
    static powderBlue() {
        let color = Color.fromArgb(0xb0, 0xe0, 0xe6);
        color.name = "Powder Blue";
        return color;
    }
    static purple() {
        let color = Color.fromArgb(0x80, 0x00, 0x80);
        color.name = "Purple";
        return color;
    }
    static red() {
        let color = Color.fromArgb(0xff, 0x00, 0x00);
        color.name = "Red";
        return color;
    }
    static rosyBrown() {
        let color = Color.fromArgb(0xbc, 0x8f, 0x8f);
        color.name = "Rosy Brown";
        return color;
    }
    static royalBlue() {
        let color = Color.fromArgb(0x41, 0x69, 0xe1);
        color.name = "Royal Blue";
        return color;
    }
    static saddleBrown() {
        let color = Color.fromArgb(0x8b, 0x45, 0x13);
        color.name = "Saddle Brown";
        return color;
    }
    static salmon() {
        let color = Color.fromArgb(0xfa, 0x80, 0x72);
        color.name = "Salmon";
        return color;
    }
    static sandyBrown() {
        let color = Color.fromArgb(0xf4, 0xa4, 0x60);
        color.name = "Sandy Brown";
        return color;
    }
    static seaGreen() {
        let color = Color.fromArgb(0x2e, 0x8b, 0x57);
        color.name = "Sea Green";
        return color;
    }
    static seaShell() {
        let color = Color.fromArgb(0xff, 0xf5, 0xee);
        color.name = "Sea Shell";
        return color;
    }
    static sienna() {
        let color = Color.fromArgb(0xa0, 0x52, 0x2d);
        color.name = "Sienna";
        return color;
    }
    static silver() {
        let color = Color.fromArgb(0xc0, 0xc0, 0xc0);
        color.name = "Silver";
        return color;
    }
    static skyBlue() {
        let color = Color.fromArgb(0x87, 0xce, 0xeb);
        color.name = "Sky Blue";
        return color;
    }
    static slateBlue() {
        let color = Color.fromArgb(0x6a, 0x5a, 0xcd);
        color.name = "Slate Blue";
        return color;
    }
    static slateGray() {
        let color = Color.fromArgb(0x70, 0x80, 0x90);
        color.name = "Slate Gray";
        return color;
    }
    static snow() {
        let color = Color.fromArgb(0xff, 0xfa, 0xfa);
        color.name = "Snow";
        return color;
    }
    static springGreen() {
        let color = Color.fromArgb(0x00, 0xff, 0x7f);
        color.name = "Spring Green";
        return color;
    }
    static steelBlue() {
        let color = Color.fromArgb(0x46, 0x82, 0xb4);
        color.name = "Steel Blue";
        return color;
    }
    static tan() {
        let color = Color.fromArgb(0xd2, 0xb4, 0x8c);
        color.name = "Tan";
        return color;
    }
    static teal() {
        let color = Color.fromArgb(0x00, 0x80, 0x80);
        color.name = "Teal";
        return color;
    }
    static thistle() {
        let color = Color.fromArgb(0xd8, 0xbf, 0xd8);
        color.name = "Thistle";
        return color;
    }
    static tomato() {
        let color = Color.fromArgb(0xff, 0x63, 0x47);
        color.name = "Tomato";
        return color;
    }
    static turquoise() {
        let color = Color.fromArgb(0x40, 0xe0, 0xd0);
        color.name = "Turquoise";
        return color;
    }
    static violet() {
        let color = Color.fromArgb(0xee, 0x82, 0xee);
        color.name = "Violet";
        return color;
    }
    static wheat() {
        let color = Color.fromArgb(0xf5, 0xde, 0xb3);
        color.name = "Wheat";
        return color;
    }
    static white() {
        let color = Color.fromArgb(0xff, 0xff, 0xff);
        color.name = "White";
        return color;
    }
    static whiteSmoke() {
        let color = Color.fromArgb(0xf5, 0xf5, 0xf5);
        color.name = "White Smoke";
        return color;
    }
    static yellow() {
        let color = Color.fromArgb(0xff, 0xff, 0x00);
        color.name = "Yellow";
        return color;
    }
    static yellowGreen() {
        let color = Color.fromArgb(0x9a, 0xcd, 0x32);
        color.name = "Yellow Green";
        return color;
    }
    static transparent() {
        let color = Color.fromArgb(0x00, 0xff, 0xff, 0xff);
        color.name = "Transparent";
        return color;
    }
    static empty() {
        let color = Color.fromArgb(0x00, 0xff, 0xff, 0xff);
        color.name = "Empty";
        return color;
    }
    static fromName(name) {
        name = name.replace(/ /gi, "");
        if (this.isNullOrEmpty(name)) {
            return null; // Color.empty;
        }
        name = name.charAt(0).toLowerCase() + name.substr(1);
        let color = Color[name];
        if (color && typeof color == "function") {
            return color();
        }
        return null; //Color.empty;
    }
    static isNullOrEmpty(value) {
        return value == null || value === "" || value === undefined;
    }
    clone() {
        let color = new Color();
        color.r = this.r;
        color.g = this.g;
        color.b = this.b;
        color.a = this._a;
        color.name = this.name;
        return color;
    }
    isChanged() {
        return this.savedColor == null || !this.savedColor.equals(this);
    }
    resetChanged() {
        this.savedColor = this.clone();
    }
    get a() {
        return this._a;
    }
    set a(value) {
        this._a = value;
        this.name = Color.customName;
    }
    get r() {
        return this._r;
    }
    set r(value) {
        this._r = value;
        this.name = Color.customName;
    }
    get g() {
        return this._g;
    }
    set g(value) {
        this._g = value;
        this.name = Color.customName;
    }
    get b() {
        return this._b;
    }
    set b(value) {
        this._b = value;
        this.name = Color.customName;
    }
    get isNamedColor() {
        return this.name != Color.customName;
    }
    equals(color) {
        if (color != null) {
            if ((color._a == 0x00 && color._r == 0xff && color._g == 0xff && color._b == 0xff) ||
                (this._a == 0x00 && this._r == 0xff && this._g == 0xff && this._b == 0xff))
                return this._a == color._a;
            else
                return this._a == color._a && this._r == color._r && this._g == color._g && this._b == color._b;
        }
        return false;
    }
    static fromArgb(alpha, red, green, blue) {
        if (typeof red == "undefined") {
            blue = alpha & 0xff;
            green = (alpha >> 8) & 0xff;
            red = (alpha >> 16) & 0xff;
            alpha = (alpha >> 24) & 0xff;
        }
        else if (typeof green == "undefined") {
            blue = red._b;
            green = red._g;
            red = red._r;
        }
        else if (typeof blue == "undefined") {
            blue = green;
            green = red;
            red = alpha;
            alpha = 255;
        }
        let color = new Color();
        color._a = alpha;
        color._r = red;
        color._g = green;
        color._b = blue;
        color.name = Color.customName;
        return color;
    }
    toArgb() {
        let argb = this._a << 24;
        argb += this._r << 16;
        argb += this._g << 8;
        argb += this._b;
        return argb;
    }
    componentToHex(c) {
        let hex = c.toString(16);
        return hex.length == 1 ? "0" + hex : hex;
    }
    getHashCode() {
        return this.toArgb();
    }
    toHtmlColor() {
        return `rgba(${this.r}, ${this.g}, ${this.b}, ${Math.round((100 * this.a) / 255) / 100})`;
    }
    toHexColor() {
        return "#" + this.componentToHex(this.r) + this.componentToHex(this.g) + this.componentToHex(this.b);
    }
    get hexColor() {
        return this.toHtmlColor();
    }
    getStringName() {
        if (this.a == 0) {
            return "Transparent";
        }
        else {
            return `${this.a != 255 ? this.a + "," : ""}${this.r + ","}${this.g + ","}${this.b}`;
        }
    }
    set hexColor(value) {
        let oldColor = this.changesInterceptor ? this.clone() : null;
        let num = parseInt(value.substring(1), 16);
        if (num || num == 0) {
            this.b = num & 0xff;
            this.g = (num >> 8) & 0xff;
            this.r = (num >> 16) & 0xff;
            this.a = 255;
        }
        else {
            let num = value.replace("rgba(", "").replace(")", "");
            let array = num.split(",");
            this.r = isNaN(Number(array[0])) ? 0 : Number(array[0]);
            this.g = isNaN(Number(array[1])) ? 0 : Number(array[1]);
            this.b = isNaN(Number(array[2])) ? 0 : Number(array[2]);
            this.a = isNaN(Math.round(255 * Number(array[3]))) ? 255 : Math.round(255 * Number(array[3]));
        }
        this.name = Color.customName;
        if (this.changesInterceptor) {
            this.changesInterceptor.propertyChanged(this.propertyName, this.clone(), oldColor);
        }
    }
    toString() {
        return this.name != Color.customName ? this.name : this.hexColor;
    }
    deserializeFromString(value) {
        let result;
        if (value.indexOf(",") != -1) {
            let strs = value.split(",");
            if (strs.length == 4) {
                result = Color.fromArgb(parseFloat(strs[0].trim()), parseFloat(strs[1].trim()), parseFloat(strs[2].trim()), parseFloat(strs[3].trim()));
            }
            else {
                result = Color.fromArgb(parseFloat(strs[0].trim()), parseFloat(strs[1].trim()), parseFloat(strs[2].trim()));
            }
        }
        else if (value.indexOf("[") == 0 && value.indexOf("]") == value.length - 1 && value.indexOf(":") != -1) {
            let strs = value.substring(1, value.length - 1).split(":");
            if (strs.length == 4) {
                result = Color.fromArgb(parseFloat(strs[0].trim()), parseFloat(strs[1].trim()), parseFloat(strs[2].trim()), parseFloat(strs[3].trim()));
            }
            else {
                result = Color.fromArgb(parseFloat(strs[0].trim()), parseFloat(strs[1].trim()), parseFloat(strs[2].trim()));
            }
        }
        else {
            result = Color.fromName(value);
        }
        this._r = result._r;
        this._b = result._b;
        this._g = result._g;
        this._a = result._a;
        this.name = result.name;
    }
}
Color.customName = "Custom";
//# sourceMappingURL=data:application/json;base64,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