/*
{*******************************************************************}
{                                                                   }
{   Stimulsoft Reports.JS                                           }
{                                                                   }
{                                                                   }
{   Copyright (C) 2003-2021 Stimulsoft                              }
{   ALL RIGHTS RESERVED                                             }
{                                                                   }
{   The entire contents of this file is protected by U.S. and       }
{   International Copyright Laws. Unauthorized reproduction,        }
{   reverse-engineering, and distribution of all or any portion of  }
{   the code contained in this file is strictly prohibited and may  }
{   result in severe civil and criminal penalties and will be       }
{   prosecuted to the maximum extent possible under the law.        }
{                                                                   }
{   RESTRICTIONS                                                    }
{                                                                   }
{   THIS SOURCE CODE AND ALL RESULTING INTERMEDIATE FILES           }
{   ARE CONFIDENTIAL AND PROPRIETARY                                }
{   TRADE SECRETS OF Stimulsoft                                     }
{                                                                   }
{   CONSULT THE END USER LICENSE AGREEMENT FOR INFORMATION ON       }
{   ADDITIONAL RESTRICTIONS.                                        }
{                                                                   }
{*******************************************************************}
*/
import { Chars } from "./Chars";
import { UnicodeCategory } from "./UnicodeCategory";
export class Char {
    static isUpper(char, index = 0) {
        let cat = this.getUnicodeCategory(char, index);
        return (cat == UnicodeCategory.UppercaseLetter);
    }
    static isLower(char, index = 0) {
        let cat = this.getUnicodeCategory(char, index);
        return (cat == UnicodeCategory.LowercaseLetter);
    }
    static isLetter(char, index = 0) {
        let cat = this.getUnicodeCategory(char, index);
        return this.checkLetter(cat);
    }
    static isDigit(char, index = 0) {
        if (char != null && typeof char == "number") {
            let cat = Chars.getUnicodeCategory(char);
            return (cat == UnicodeCategory.DecimalDigitNumber);
        }
        let cat = this.getUnicodeCategory(char, index);
        return (cat == UnicodeCategory.DecimalDigitNumber);
    }
    static isLetterOrDigit(char, index = 0) {
        let cat = this.getUnicodeCategory(char, index);
        return this.checkLetter(cat) || cat == UnicodeCategory.DecimalDigitNumber;
    }
    static toLower(char) {
        return char.toLocaleLowerCase();
    }
    static toUpper(char) {
        return char.toLocaleUpperCase();
    }
    static isWhitespace(char, index = 0, allowNbsp = true) {
        if (char == null || char.length < index + 1)
            return false;
        let code = char.charCodeAt(index);
        if ((code == 0x20) || (code >= 0x09 && code <= 0x0d) || (code == 0xa0 && allowNbsp) || code == 0x85)
            return true;
        let cat = Chars.getUnicodeCategory(code);
        return cat == UnicodeCategory.SpaceSeparator ||
            cat == UnicodeCategory.LineSeparator ||
            cat == UnicodeCategory.ParagraphSeparator;
    }
    static checkLetter(uc) {
        return uc == UnicodeCategory.UppercaseLetter ||
            uc == UnicodeCategory.LowercaseLetter ||
            uc == UnicodeCategory.TitlecaseLetter ||
            uc == UnicodeCategory.ModifierLetter ||
            uc == UnicodeCategory.OtherLetter;
    }
    static getUnicodeCategory(char, index = 0) {
        if (char == null || char.length < index + 1)
            return UnicodeCategory.OtherNotAssigned;
        let code = char.charCodeAt(index);
        return Chars.getUnicodeCategory(code);
    }
    static isControl(char, index = 0) {
        return Char.getUnicodeCategory(char, index) == UnicodeCategory.Control;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQ2hhci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi9zeXN0ZW0vQ2hhci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7RUEwQkU7QUFHRixPQUFPLEVBQUUsS0FBSyxFQUFFLE1BQU0sU0FBUyxDQUFDO0FBQ2hDLE9BQU8sRUFBRSxlQUFlLEVBQUUsTUFBTSxtQkFBbUIsQ0FBQztBQUVwRCxNQUFNLE9BQU8sSUFBSTtJQUVmLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBWSxFQUFFLEtBQUssR0FBRyxDQUFDO1FBQ3BDLElBQUksR0FBRyxHQUFXLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDdkQsT0FBTyxDQUFDLEdBQUcsSUFBSSxlQUFlLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUVELE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBWSxFQUFFLEtBQUssR0FBRyxDQUFDO1FBQ3BDLElBQUksR0FBRyxHQUFXLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDdkQsT0FBTyxDQUFDLEdBQUcsSUFBSSxlQUFlLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDbEQsQ0FBQztJQUVELE1BQU0sQ0FBQyxRQUFRLENBQUMsSUFBWSxFQUFFLEtBQUssR0FBRyxDQUFDO1FBQ3JDLElBQUksR0FBRyxHQUFXLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDdkQsT0FBTyxJQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQy9CLENBQUM7SUFFRCxNQUFNLENBQUMsT0FBTyxDQUFDLElBQXFCLEVBQUUsS0FBSyxHQUFHLENBQUM7UUFDN0MsSUFBSSxJQUFJLElBQUksSUFBSSxJQUFJLE9BQU8sSUFBSSxJQUFJLFFBQVEsRUFBRTtZQUMzQyxJQUFJLEdBQUcsR0FBVyxLQUFLLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDakQsT0FBTyxDQUFDLEdBQUcsSUFBSSxlQUFlLENBQUMsa0JBQWtCLENBQUMsQ0FBQztTQUNwRDtRQUNELElBQUksR0FBRyxHQUFXLElBQUksQ0FBQyxrQkFBa0IsQ0FBUyxJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDL0QsT0FBTyxDQUFDLEdBQUcsSUFBSSxlQUFlLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUNyRCxDQUFDO0lBRUQsTUFBTSxDQUFDLGVBQWUsQ0FBQyxJQUFZLEVBQUUsS0FBSyxHQUFHLENBQUM7UUFDNUMsSUFBSSxHQUFHLEdBQVcsSUFBSSxDQUFDLGtCQUFrQixDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsQ0FBQztRQUN2RCxPQUFPLElBQUksQ0FBQyxXQUFXLENBQUMsR0FBRyxDQUFDLElBQUksR0FBRyxJQUFJLGVBQWUsQ0FBQyxrQkFBa0IsQ0FBQztJQUM1RSxDQUFDO0lBRUQsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFZO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDbEMsQ0FBQztJQUVELE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBWTtRQUN6QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQ2xDLENBQUM7SUFFRCxNQUFNLENBQUMsWUFBWSxDQUFDLElBQVksRUFBRSxLQUFLLEdBQUcsQ0FBQyxFQUFFLFNBQVMsR0FBRyxJQUFJO1FBQzNELElBQUksSUFBSSxJQUFJLElBQUksSUFBSSxJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssR0FBRyxDQUFDO1lBQUUsT0FBTyxLQUFLLENBQUM7UUFDMUQsSUFBSSxJQUFJLEdBQVcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUMxQyxJQUFJLENBQUMsSUFBSSxJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxJQUFJLElBQUksSUFBSSxJQUFJLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLElBQUksSUFBSSxJQUFJLFNBQVMsQ0FBQyxJQUFJLElBQUksSUFBSSxJQUFJO1lBQUUsT0FBTyxJQUFJLENBQUM7UUFDakgsSUFBSSxHQUFHLEdBQVcsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ2pELE9BQU8sR0FBRyxJQUFJLGVBQWUsQ0FBQyxjQUFjO1lBQzFDLEdBQUcsSUFBSSxlQUFlLENBQUMsYUFBYTtZQUNwQyxHQUFHLElBQUksZUFBZSxDQUFDLGtCQUFrQixDQUFDO0lBQzlDLENBQUM7SUFFTyxNQUFNLENBQUMsV0FBVyxDQUFDLEVBQW1CO1FBQzVDLE9BQU8sRUFBRSxJQUFJLGVBQWUsQ0FBQyxlQUFlO1lBQzFDLEVBQUUsSUFBSSxlQUFlLENBQUMsZUFBZTtZQUNyQyxFQUFFLElBQUksZUFBZSxDQUFDLGVBQWU7WUFDckMsRUFBRSxJQUFJLGVBQWUsQ0FBQyxjQUFjO1lBQ3BDLEVBQUUsSUFBSSxlQUFlLENBQUMsV0FBVyxDQUFDO0lBQ3RDLENBQUM7SUFFRCxNQUFNLENBQUMsa0JBQWtCLENBQUMsSUFBWSxFQUFFLEtBQUssR0FBRyxDQUFDO1FBQy9DLElBQUksSUFBSSxJQUFJLElBQUksSUFBSSxJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssR0FBRyxDQUFDO1lBQUUsT0FBTyxlQUFlLENBQUMsZ0JBQWdCLENBQUM7UUFDckYsSUFBSSxJQUFJLEdBQVcsSUFBSSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUMxQyxPQUFPLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN4QyxDQUFDO0lBRUQsTUFBTSxDQUFDLFNBQVMsQ0FBQyxJQUFZLEVBQUUsS0FBSyxHQUFHLENBQUM7UUFDdEMsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJLGVBQWUsQ0FBQyxPQUFPLENBQUM7SUFDekUsQ0FBQztDQU1GIiwic291cmNlc0NvbnRlbnQiOlsiLypcclxueyoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKip9XHJcbnsgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxyXG57ICAgU3RpbXVsc29mdCBSZXBvcnRzLkpTICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cclxueyAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XHJcbnsgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxyXG57ICAgQ29weXJpZ2h0IChDKSAyMDAzLTIwMjEgU3RpbXVsc29mdCAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cclxueyAgIEFMTCBSSUdIVFMgUkVTRVJWRUQgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XHJcbnsgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxyXG57ICAgVGhlIGVudGlyZSBjb250ZW50cyBvZiB0aGlzIGZpbGUgaXMgcHJvdGVjdGVkIGJ5IFUuUy4gYW5kICAgICAgIH1cclxueyAgIEludGVybmF0aW9uYWwgQ29weXJpZ2h0IExhd3MuIFVuYXV0aG9yaXplZCByZXByb2R1Y3Rpb24sICAgICAgICB9XHJcbnsgICByZXZlcnNlLWVuZ2luZWVyaW5nLCBhbmQgZGlzdHJpYnV0aW9uIG9mIGFsbCBvciBhbnkgcG9ydGlvbiBvZiAgfVxyXG57ICAgdGhlIGNvZGUgY29udGFpbmVkIGluIHRoaXMgZmlsZSBpcyBzdHJpY3RseSBwcm9oaWJpdGVkIGFuZCBtYXkgIH1cclxueyAgIHJlc3VsdCBpbiBzZXZlcmUgY2l2aWwgYW5kIGNyaW1pbmFsIHBlbmFsdGllcyBhbmQgd2lsbCBiZSAgICAgICB9XHJcbnsgICBwcm9zZWN1dGVkIHRvIHRoZSBtYXhpbXVtIGV4dGVudCBwb3NzaWJsZSB1bmRlciB0aGUgbGF3LiAgICAgICAgfVxyXG57ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cclxueyAgIFJFU1RSSUNUSU9OUyAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XHJcbnsgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxyXG57ICAgVEhJUyBTT1VSQ0UgQ09ERSBBTkQgQUxMIFJFU1VMVElORyBJTlRFUk1FRElBVEUgRklMRVMgICAgICAgICAgIH1cclxueyAgIEFSRSBDT05GSURFTlRJQUwgQU5EIFBST1BSSUVUQVJZICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB9XHJcbnsgICBUUkFERSBTRUNSRVRTIE9GIFN0aW11bHNvZnQgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxyXG57ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cclxueyAgIENPTlNVTFQgVEhFIEVORCBVU0VSIExJQ0VOU0UgQUdSRUVNRU5UIEZPUiBJTkZPUk1BVElPTiBPTiAgICAgICB9XHJcbnsgICBBRERJVElPTkFMIFJFU1RSSUNUSU9OUy4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgfVxyXG57ICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIH1cclxueyoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKip9XHJcbiovXHJcblxyXG5cclxuaW1wb3J0IHsgQ2hhcnMgfSBmcm9tIFwiLi9DaGFyc1wiO1xyXG5pbXBvcnQgeyBVbmljb2RlQ2F0ZWdvcnkgfSBmcm9tIFwiLi9Vbmljb2RlQ2F0ZWdvcnlcIjtcclxuXHJcbmV4cG9ydCBjbGFzcyBDaGFyIHtcclxuXHJcbiAgc3RhdGljIGlzVXBwZXIoY2hhcjogc3RyaW5nLCBpbmRleCA9IDApOiBib29sZWFuIHtcclxuICAgIGxldCBjYXQ6IG51bWJlciA9IHRoaXMuZ2V0VW5pY29kZUNhdGVnb3J5KGNoYXIsIGluZGV4KTtcclxuICAgIHJldHVybiAoY2F0ID09IFVuaWNvZGVDYXRlZ29yeS5VcHBlcmNhc2VMZXR0ZXIpO1xyXG4gIH1cclxuXHJcbiAgc3RhdGljIGlzTG93ZXIoY2hhcjogc3RyaW5nLCBpbmRleCA9IDApOiBib29sZWFuIHtcclxuICAgIGxldCBjYXQ6IG51bWJlciA9IHRoaXMuZ2V0VW5pY29kZUNhdGVnb3J5KGNoYXIsIGluZGV4KTtcclxuICAgIHJldHVybiAoY2F0ID09IFVuaWNvZGVDYXRlZ29yeS5Mb3dlcmNhc2VMZXR0ZXIpO1xyXG4gIH1cclxuXHJcbiAgc3RhdGljIGlzTGV0dGVyKGNoYXI6IHN0cmluZywgaW5kZXggPSAwKTogYm9vbGVhbiB7XHJcbiAgICBsZXQgY2F0OiBudW1iZXIgPSB0aGlzLmdldFVuaWNvZGVDYXRlZ29yeShjaGFyLCBpbmRleCk7XHJcbiAgICByZXR1cm4gdGhpcy5jaGVja0xldHRlcihjYXQpO1xyXG4gIH1cclxuXHJcbiAgc3RhdGljIGlzRGlnaXQoY2hhcjogc3RyaW5nIHwgbnVtYmVyLCBpbmRleCA9IDApOiBib29sZWFuIHtcclxuICAgIGlmIChjaGFyICE9IG51bGwgJiYgdHlwZW9mIGNoYXIgPT0gXCJudW1iZXJcIikge1xyXG4gICAgICBsZXQgY2F0OiBudW1iZXIgPSBDaGFycy5nZXRVbmljb2RlQ2F0ZWdvcnkoY2hhcik7XHJcbiAgICAgIHJldHVybiAoY2F0ID09IFVuaWNvZGVDYXRlZ29yeS5EZWNpbWFsRGlnaXROdW1iZXIpO1xyXG4gICAgfVxyXG4gICAgbGV0IGNhdDogbnVtYmVyID0gdGhpcy5nZXRVbmljb2RlQ2F0ZWdvcnkoPHN0cmluZz5jaGFyLCBpbmRleCk7XHJcbiAgICByZXR1cm4gKGNhdCA9PSBVbmljb2RlQ2F0ZWdvcnkuRGVjaW1hbERpZ2l0TnVtYmVyKTtcclxuICB9XHJcblxyXG4gIHN0YXRpYyBpc0xldHRlck9yRGlnaXQoY2hhcjogc3RyaW5nLCBpbmRleCA9IDApOiBib29sZWFuIHtcclxuICAgIGxldCBjYXQ6IG51bWJlciA9IHRoaXMuZ2V0VW5pY29kZUNhdGVnb3J5KGNoYXIsIGluZGV4KTtcclxuICAgIHJldHVybiB0aGlzLmNoZWNrTGV0dGVyKGNhdCkgfHwgY2F0ID09IFVuaWNvZGVDYXRlZ29yeS5EZWNpbWFsRGlnaXROdW1iZXI7XHJcbiAgfVxyXG5cclxuICBzdGF0aWMgdG9Mb3dlcihjaGFyOiBzdHJpbmcpOiBzdHJpbmcge1xyXG4gICAgcmV0dXJuIGNoYXIudG9Mb2NhbGVMb3dlckNhc2UoKTtcclxuICB9XHJcblxyXG4gIHN0YXRpYyB0b1VwcGVyKGNoYXI6IHN0cmluZyk6IHN0cmluZyB7XHJcbiAgICByZXR1cm4gY2hhci50b0xvY2FsZVVwcGVyQ2FzZSgpO1xyXG4gIH1cclxuXHJcbiAgc3RhdGljIGlzV2hpdGVzcGFjZShjaGFyOiBzdHJpbmcsIGluZGV4ID0gMCwgYWxsb3dOYnNwID0gdHJ1ZSk6IGJvb2xlYW4ge1xyXG4gICAgaWYgKGNoYXIgPT0gbnVsbCB8fCBjaGFyLmxlbmd0aCA8IGluZGV4ICsgMSkgcmV0dXJuIGZhbHNlO1xyXG4gICAgbGV0IGNvZGU6IG51bWJlciA9IGNoYXIuY2hhckNvZGVBdChpbmRleCk7XHJcbiAgICBpZiAoKGNvZGUgPT0gMHgyMCkgfHwgKGNvZGUgPj0gMHgwOSAmJiBjb2RlIDw9IDB4MGQpIHx8IChjb2RlID09IDB4YTAgJiYgYWxsb3dOYnNwKSB8fCBjb2RlID09IDB4ODUpIHJldHVybiB0cnVlO1xyXG4gICAgbGV0IGNhdDogbnVtYmVyID0gQ2hhcnMuZ2V0VW5pY29kZUNhdGVnb3J5KGNvZGUpO1xyXG4gICAgcmV0dXJuIGNhdCA9PSBVbmljb2RlQ2F0ZWdvcnkuU3BhY2VTZXBhcmF0b3IgfHxcclxuICAgICAgY2F0ID09IFVuaWNvZGVDYXRlZ29yeS5MaW5lU2VwYXJhdG9yIHx8XHJcbiAgICAgIGNhdCA9PSBVbmljb2RlQ2F0ZWdvcnkuUGFyYWdyYXBoU2VwYXJhdG9yO1xyXG4gIH1cclxuXHJcbiAgcHJpdmF0ZSBzdGF0aWMgY2hlY2tMZXR0ZXIodWM6IFVuaWNvZGVDYXRlZ29yeSkge1xyXG4gICAgcmV0dXJuIHVjID09IFVuaWNvZGVDYXRlZ29yeS5VcHBlcmNhc2VMZXR0ZXIgfHxcclxuICAgICAgdWMgPT0gVW5pY29kZUNhdGVnb3J5Lkxvd2VyY2FzZUxldHRlciB8fFxyXG4gICAgICB1YyA9PSBVbmljb2RlQ2F0ZWdvcnkuVGl0bGVjYXNlTGV0dGVyIHx8XHJcbiAgICAgIHVjID09IFVuaWNvZGVDYXRlZ29yeS5Nb2RpZmllckxldHRlciB8fFxyXG4gICAgICB1YyA9PSBVbmljb2RlQ2F0ZWdvcnkuT3RoZXJMZXR0ZXI7XHJcbiAgfVxyXG5cclxuICBzdGF0aWMgZ2V0VW5pY29kZUNhdGVnb3J5KGNoYXI6IHN0cmluZywgaW5kZXggPSAwKTogbnVtYmVyIHtcclxuICAgIGlmIChjaGFyID09IG51bGwgfHwgY2hhci5sZW5ndGggPCBpbmRleCArIDEpIHJldHVybiBVbmljb2RlQ2F0ZWdvcnkuT3RoZXJOb3RBc3NpZ25lZDtcclxuICAgIGxldCBjb2RlOiBudW1iZXIgPSBjaGFyLmNoYXJDb2RlQXQoaW5kZXgpO1xyXG4gICAgcmV0dXJuIENoYXJzLmdldFVuaWNvZGVDYXRlZ29yeShjb2RlKTtcclxuICB9XHJcblxyXG4gIHN0YXRpYyBpc0NvbnRyb2woY2hhcjogc3RyaW5nLCBpbmRleCA9IDApOiBib29sZWFuIHtcclxuICAgIHJldHVybiBDaGFyLmdldFVuaWNvZGVDYXRlZ29yeShjaGFyLCBpbmRleCkgPT0gVW5pY29kZUNhdGVnb3J5LkNvbnRyb2w7XHJcbiAgfVxyXG5cclxuICAvLyBwcml2YXRlIHN0YXRpYyBpc0xhdGluKGNoYXI6IG51bWJlcik6IGJvb2xlYW4ge1xyXG4gIC8vICAgIHJldHVybiBjaGFyIDw9IDB4MDBGRjtcclxuICAvLyB9XHJcblxyXG59XHJcblxyXG4iXX0=