import { Component, EventEmitter, Input, Output, ViewChild, } from "@angular/core";
import StiRectangleGeometryLayout from "./computed/StiRectangleGeometryLayout";
import { StiLocalizationService } from "./services/sti-localization.service";
import { StiModelService } from "./services/model.service";
import { StiMouseService } from "./services/mouse.service";
import { StiComponentResizerService } from "./services/sti-component-resizer.service";
import { StiEditableContentService } from "./services/sti-editable-content.service";
import { StiDraggableService } from "./services/sti-draggable.service";
import { StiHelperService } from "./services/sti-helper.service";
import { StiNameService } from "./services/sti-name.service";
import { StiToolbarResizerService } from "./services/sti-toolbar-resizer.service";
import { StiToolboxService } from "./services/sti-toolbox.service";
import { StiThemeService } from "./services/theme.service";
import { StiControllerService } from "./services/sti-controller.service";
import { StiHttpClientService } from "./services/http-client.service";
import { StiBarcodeService } from "./services/sti-barcode.service";
import { StiColumnDraggableService } from "./services/sti-column-draggable.service";
import { StiForm } from "./elements/StiForm";
import { DatePipe } from "@angular/common";
import { StiRichTextService } from "./services/sti-rich-text.service";
import { StiChangesService } from "./services/sti-changes-service";
import { StiUndoService } from "./services/sti-undo-service";
import { StiExportService } from "./services/sti-export.service";
import { StiFontService } from "./services/sti-font.service";
import { StiUserService } from "./services/sti-user-service";
import { StiExpressionService } from "./services/sti-expression.service";
import { StiButtonElement } from "./elements/StiButtonElement";
import { FormEventsService } from "./services/sti-form-events-service";
import { SignatureService } from "./services/sti-signature.service";
import { StiColorDialogService } from "./services/sti-color-dialog.service";
import { StiStaticHelperService } from "./services/sti-static-helper.service";
import { StiTabIndexService } from "./services/sti-tabindex.service";
import { StiDropdownService } from "./components/sti-dropdown-component/sti-dropdown-service";
import { StiFormCheckerService } from "./services/sti-form-checker.service";
import { StiLocalStorageService } from "./services/sti-local-storage.service";
import { StiDraggableModalWindowService } from "./services/sti-draggable-modal-window.service";
import { StiTooltipService } from "./components/sti-tooltip/sti-tooltip.service";
import * as i0 from "@angular/core";
import * as i1 from "./services/sti-toolbar-resizer.service";
import * as i2 from "./services/model.service";
import * as i3 from "./services/theme.service";
import * as i4 from "./services/sti-controller.service";
import * as i5 from "./services/sti-barcode.service";
import * as i6 from "./services/sti-editable-content.service";
import * as i7 from "./services/sti-changes-service";
import * as i8 from "./services/sti-export.service";
import * as i9 from "./services/sti-font.service";
import * as i10 from "./services/sti-toolbox.service";
import * as i11 from "./services/sti-undo-service";
import * as i12 from "./services/sti-user-service";
import * as i13 from "./services/sti-expression.service";
import * as i14 from "./services/sti-helper.service";
import * as i15 from "./services/sti-localization.service";
import * as i16 from "./services/http-client.service";
import * as i17 from "./services/sti-signature.service";
import * as i18 from "./services/sti-tabindex.service";
import * as i19 from "./services/mouse.service";
import * as i20 from "./services/sti-form-events-service";
import * as i21 from "./components/sti-dropdown-component/sti-dropdown-service";
import * as i22 from "./services/sti-form-checker.service";
import * as i23 from "./services/sti-local-storage.service";
import * as i24 from "./components/sti-tooltip/sti-tooltip.service";
import * as i25 from "@angular/common";
import * as i26 from "./components/navbar.component/navbar.component";
import * as i27 from "./components/workspace.component/sti-workspace.component";
import * as i28 from "./components/properties.component/properties.component";
import * as i29 from "./toolbox/sti-draggable-element-container.component";
import * as i30 from "./toolbox/sti-toolbox.component";
import * as i31 from "./components/footer.component/footer.component";
import * as i32 from "./toolbox/sti-clone-element-container.component";
import * as i33 from "./components/modal-agree-window/modal-agree-window.component";
import * as i34 from "./components/sti-progress.component";
import * as i35 from "./toolbox/sti-draggable-column-container.component";
import * as i36 from "./components/sti-about-window/sti-about-window.component";
import * as i37 from "./components/propertyGrid/editors/sti-barcode-style-editor/sti-barcodes-styles-preview.component";
import * as i38 from "./components/workspace.component/sti-pdf-preview.component";
import * as i39 from "./components/navbar.component/navbar.group-preview.component";
import * as i40 from "./toolbox/sti-setup-toolbox.component";
import * as i41 from "./components/sti-localization-preview.component";
import * as i42 from "./components/sti-user-info.component";
import * as i43 from "./components/sti-trial-alerts/sti-trial-bar.component";
import * as i44 from "./components/sti-trial-alerts/sti-trial-modal-window.component";
import * as i45 from "./components/sti-file-menu/sti-file-menu.component";
import * as i46 from "./components/sti-file-menu/sti-file-menu-navigation.component";
import * as i47 from "./components/sti-file-menu/sti-file-save-dialog.component";
import * as i48 from "./components/sti-button/sti-button-message-window.component";
import * as i49 from "./components/navbar.component/sti-cloud-navbar.component";
import * as i50 from "./components/context-menu.component/context-menu-window.component";
import * as i51 from "./components/sti-expression-editor/sti-expression-help-window.component";
import * as i52 from "./components/sti-login.component";
import * as i53 from "./components/sti-expression-editor/sti-expression-editor.component";
import * as i54 from "./components/sti-color-dialog/sti-color-dialog.component";
import * as i55 from "./components/sti-color-dialog/sti-color-options-dialog.component";
import * as i56 from "./components/sti-expression-editor/sti-expression-draggable-container.component";
import * as i57 from "./components/sti-dropdown-component/sti-dropdown-list.component";
import * as i58 from "./components/sti-form-checker/sti-form-checker.component";
import * as i59 from "./components/sti-signature/sti-electronic-signature-editor.component";
import * as i60 from "./components/sti-draggable-modal-window/sti-draggable-modal-window.component";
import * as i61 from "./components/sti-tooltip/sti-tooltip.component";
import * as i62 from "./components/sti-trial-alerts/sti-trial-timer-window.component";
import * as i63 from "./components/sti-tiered-menu/sti-tiered-menu.component";
export class StimulsoftFormsComponent {
    constructor(toolbarResizerService, model, theme, controller, barcodeService, render, editableContentService, changesService, exportService, font, toolboxService, undoService, userService, expressionService, helper, localizationService, httpService, signatureService, tabIndexService, mouseService, formEvents, dropdownService, formCheckerService, stiLocalStorage, tooltipService) {
        this.toolbarResizerService = toolbarResizerService;
        this.model = model;
        this.theme = theme;
        this.controller = controller;
        this.barcodeService = barcodeService;
        this.render = render;
        this.editableContentService = editableContentService;
        this.changesService = changesService;
        this.exportService = exportService;
        this.font = font;
        this.toolboxService = toolboxService;
        this.undoService = undoService;
        this.userService = userService;
        this.expressionService = expressionService;
        this.helper = helper;
        this.localizationService = localizationService;
        this.httpService = httpService;
        this.signatureService = signatureService;
        this.tabIndexService = tabIndexService;
        this.mouseService = mouseService;
        this.formEvents = formEvents;
        this.dropdownService = dropdownService;
        this.formCheckerService = formCheckerService;
        this.stiLocalStorage = stiLocalStorage;
        this.tooltipService = tooltipService;
        this.viewerMode = false;
        this.readonlyMode = false;
        this.form = new StiForm();
        this.interfaceEvent = new EventEmitter();
        this.init = false;
        this.distance = 0;
        this.isDoubleTouch = false;
        this.model.interfaceEvent.subscribe((e) => this.interfaceEvent.emit(e));
        this.model.component = this;
        barcodeService.init();
        changesService.start();
        expressionService.start();
    }
    get pointerEvents() {
        return this.model.showModalWindow ||
            this.model.showAboutWindow ||
            this.exportService.showModalWindow ||
            this.model.showTrialModalWindow ||
            this.model.showButtonMessageWindow ||
            this.model.showErrorWindow ||
            this.model.showHelpWindow ||
            this.model.showMoreColorDialog ||
            this.model.showProgress ||
            this.model.showExpressionEditor ||
            this.formCheckerService.showFormCheckerWindow ||
            this.model.showSignatureEditor ||
            this.model.showDraggableModalWindow ||
            this.model.showTrialTimerWindow
            ? "none"
            : "";
    }
    get cursor() {
        return this.model.cursor;
    }
    get toolbarWidth() {
        return this.toolbarResizerService.isMaximizeMode ? 200 : 45;
    }
    hasParentHeight() {
        let root = document.getElementsByClassName("sti-root-form");
        return root[0].parentElement.style.height ? true : false;
    }
    hasParentWidth() {
        let root = document.getElementsByClassName("sti-root-form");
        return root[0].parentElement.style.width ? true : false;
    }
    ngOnInit() {
        this.model.settings = this.settings;
        this.mouseService.getDocumentTouchStart().subscribe((event) => {
            this.startTouch(event);
        });
        this.mouseService.getDocumentTouchMove().subscribe((event) => {
            this.touchMove(event);
        });
        this.mouseService.getDocumentTouchEnd().subscribe((event) => {
            this.touchEnd(event);
        });
        this.toolboxService.unusedElements = JSON.parse(this.stiLocalStorage.getItem("StiToolboxSetup"));
        let showInsertTab = JSON.parse(this.stiLocalStorage.getItem("StiShowInsertTab"));
        let showToolbox = JSON.parse(this.stiLocalStorage.getItem("StiShowToolbox"));
        let buttonLinks = this.stiLocalStorage.getItem("StiButtonLinks");
        if (buttonLinks) {
            this.model.enteredUrls = buttonLinks.split(",");
        }
        this.toolboxService.showInsertTab = showInsertTab != null ? showInsertTab : true;
        this.toolboxService.showToolbox = showToolbox != null ? showToolbox : true;
        this.model.viewerMode = this.viewerMode;
        if (this.properties?.cloudPlanIdent?.length > 0 &&
            (this.properties.cloudPlanIdent == "Trial" ||
                this.properties.cloudPlanIdent == "Expiried" ||
                this.properties.cloudPlanIdent == "Developer" ||
                this.properties.cloudPlanIdent.indexOf("Base") > 0 ||
                this.properties.cloudPlanIdent.indexOf("Single") > 0 ||
                this.properties.cloudPlanIdent.indexOf("Team") > 0 ||
                this.properties.cloudPlanIdent.indexOf("Enterprise") > 0)) {
            if (this.properties?.cloudPlanIdent == "Trial" || this.properties?.cloudPlanIdent == "Expiried") {
                this.model.basePlanIsTrial = true;
                if (!this.viewerMode) {
                    this.model.showTrialBar = true;
                }
                else {
                    this.model.showTrialTitle = true;
                }
            }
            this.model.form.additionalFormFields;
            this.model.isCloudMode = true;
            if (this.model.enteredUrls.indexOf("cloud.stimulsoft.com") == -1) {
                this.model.enteredUrls.push("cloud.stimulsoft.com");
            }
        }
        if (this.viewerMode && this.readonlyMode) {
            this.setReadOnlyMode();
        }
        this.toolboxService.elements.forEach((element) => {
            if (this.toolboxService.unusedElements?.find((item) => item == element.id)) {
                element.enabled = false;
            }
        });
        this.theme.currentTheme = "Light";
        const zoomByWheel = (event) => {
            if (event.ctrlKey) {
                event.stopPropagation();
                event.preventDefault();
                if (event.deltaY < 0) {
                    if (this.model.zoom > 0.1 && this.model.zoom < 4.9) {
                        this.model.zoom += 0.1;
                    }
                }
                else {
                    if (this.model.zoom > 0.2 && this.model.zoom < 5) {
                        this.model.zoom -= 0.1;
                    }
                }
            }
            else {
                let workspace = document.getElementsByTagName("sti-workspace")[0];
                // workspace.scrollTop = 10;
                if (this.model.draggingElement) {
                    if (event.deltaY < 0) {
                        workspace.scrollTop -= 300;
                    }
                    else {
                        workspace.scrollTop += 300;
                    }
                }
            }
        };
        let this_ = this;
        window.oncontextmenu = function ($event) {
            if (this_.model.getPageFromPoint(event["clientX"], event["clientY"]) &&
                document.activeElement.tagName.toLocaleLowerCase() == "body") {
                event.preventDefault();
                this_.model.contextMenuX = event["clientX"];
                if (window.outerHeight - event["clientY"] <= 255) {
                    this_.model.contextMenuY = event["clientY"] - 150;
                }
                else {
                    this_.model.contextMenuY = event["clientY"];
                }
                this_.model.showContextMenu = true;
            }
        };
        window.onbeforeunload = function (event) {
            this_.model.currentFormState = this_.model.form.saveToReportJsonObject().serialize();
            if (this_.model?.currentFormState !== this_.model?.lastSavedFormState &&
                this_.undoService?.undos?.length > 1 &&
                !this_.model.viewerMode) {
                setTimeout(() => {
                    this_.model.showProgress = false;
                }, 3000);
                event.returnValue = "";
                return event.returnValue;
            }
        };
        const deletingComponents = (event) => {
            let selection = window.getSelection().toString();
            if (event.key === "Escape" && this.model.lastFormState != null) {
                let form = new StiForm();
                form.loadFormJsonString(this.model.lastFormState);
                this.model.form = form;
                this.model.draggingElement = null;
                this.model.lastFormState = null;
            }
            else if (event.key === "Delete" && this.model.canDelete()) {
                if (this.model.selectedComponent) {
                    this.helper.deleteSelectedComponent();
                }
                else if (this.model.selectedPage && this.model?.form?.pages?.length > 1) {
                    this.model.showModalWindow = true;
                }
            }
            else if (event.key === "PageDown" || event.key === "PageUp") {
                event.preventDefault();
            }
            else if (event.ctrlKey && event.code === "KeyC") {
                if (this.model.showExpressionEditor) {
                    return;
                }
                if (this.model.selectedComponent && document.activeElement.tagName.toLocaleLowerCase() == "body") {
                    this.formEvents.copyComponent();
                }
            }
            else if (event.ctrlKey && event.code === "KeyV") {
                if (this.model.showExpressionEditor) {
                    return;
                }
                if (this.formEvents.hasCopy && document.activeElement.tagName.toLocaleLowerCase() == "body") {
                    let mouseEvent = new MouseEvent("mousemove");
                    this.formEvents.pasteComponent(mouseEvent);
                }
            }
            else if (event.ctrlKey && event.code === "KeyZ") {
                if (this.model.showExpressionEditor) {
                    return;
                }
                event.preventDefault();
                if (this.undoService.undos.length >= 2) {
                    this.undoService.undo();
                }
            }
            else if (event.ctrlKey && event.code === "KeyX") {
                if (this.model.showExpressionEditor) {
                    return;
                }
                if (this.model.selectedComponent && document.activeElement.tagName.toLocaleLowerCase() == "body") {
                    this.formEvents.cutComponent();
                }
            }
        };
        const disableDeleting = (event) => {
            let isWorkspace = false;
            let isBarcodePreview = false;
            let elements = document.elementsFromPoint(event.clientX, event.clientY);
            elements.forEach((element) => {
                if (element?.classList.contains("sti-page") || element?.classList.contains("sti-component")) {
                    isWorkspace = true;
                }
                if (element?.classList.contains("container")) {
                    isBarcodePreview = true;
                }
            });
            if (!isBarcodePreview) {
                this.barcodeService.showBarcodePreview = false;
            }
        };
        document.querySelector(".sti-root-form")?.addEventListener("wheel", zoomByWheel);
        document.addEventListener("keydown", deletingComponents);
        document.addEventListener("mousedown", disableDeleting);
    }
    needToScroll() {
        let workspace = document.getElementsByTagName("sti-workspace")[0];
        let pageElem = document.querySelectorAll(".sti-page")[0];
        let rect = this.model.getPositionRelativeToForm(pageElem);
        return workspace?.clientWidth < rect?.width;
    }
    ngOnChanges(changes) {
        if (Object.keys(changes).length == 1) {
            if (changes["form"]) {
                this.model.form = changes["form"].currentValue;
                this.model.fileName = this.formName;
            }
            else if (changes["localization"]) {
                this.localizationService.loadLocalization(this.localization);
            }
        }
        else {
            this.initialize();
        }
    }
    startTouch(event) {
        if (this.isMobileViewer) {
            if (event.touches.length === 2) {
                this.startZoomValue = this.model.zoom;
                this.distance = Math.hypot(event.touches[0].pageX - event.touches[1].pageX, event.touches[0].pageY - event.touches[1].pageY);
                this.isDoubleTouch = true;
            }
        }
    }
    get isMobileViewer() {
        return this.model.viewerMode && this.model.isMobile();
    }
    touchMove(event) {
        if (this.isMobileViewer && this.isDoubleTouch) {
            event.preventDefault();
            let dist2 = Math.hypot(event.touches[0].pageX - event.touches[1].pageX, event.touches[0].pageY - event.touches[1].pageY);
            let delta = Math.abs(dist2 - this.distance);
            if (this.distance < dist2) {
                this.model.zoom = this.startZoomValue + Number((delta / 200).toFixed(2));
            }
            else if (this.distance > dist2) {
                this.model.zoom = this.startZoomValue - Number((delta / 200).toFixed(2));
            }
            if (this.model.zoom < this.minimalZoomValue()) {
                this.model.zoom = this.minimalZoomValue();
                let workspace = document.getElementsByTagName("sti-workspace")[0];
                let pageElem = document.querySelectorAll(".page-container")[0];
                setTimeout(() => {
                    let rect = this.model.getPositionRelativeToForm(pageElem);
                    if (workspace.scrollLeft != workspace.scrollWidth - rect.width - 6) {
                        workspace.scrollLeft = workspace.scrollWidth - rect.width - 6;
                    }
                });
            }
        }
    }
    touchEnd(event) {
        if (this.isMobileViewer && this.isDoubleTouch) {
            if (event.targetTouches.length < 2) {
                this.isDoubleTouch = false;
            }
        }
    }
    minimalZoomValue() {
        let workspace = document.getElementsByTagName("sti-workspace")[0];
        let width = workspace["offsetWidth"];
        let pagetWithMaxWidth = this.model.form.pages.reduce((acc, curr) => (acc.width > curr.width ? acc : curr));
        return width / (pagetWithMaxWidth.width + 30);
    }
    setReadOnlyMode() {
        this.model?.form?.pages.forEach((page) => {
            page.allElements.forEach((element) => {
                if (element["readOnly"]) {
                    element["readOnly"] = true;
                }
                else {
                    if (!(element instanceof StiButtonElement)) {
                        element.readOnly = false;
                    }
                }
            });
        });
    }
    ngAfterViewInit() {
        this.init = true;
        setTimeout(() => {
            this.initialize();
            this.rootFormElementRef.nativeElement.component = this;
            this.model.rootFormElement = this.rootFormElementRef.nativeElement;
            this.model.addTotalMenu = this.addTotalMenu;
        }, 0);
    }
    containerHeight() {
        let showfooter = this.model.getBooleanSetting("showFooter");
        let isModeWithPreview = this.model.isPreviewMode || this.model.pdfPreviewMode || this.viewerMode;
        if (isModeWithPreview) {
            if (this.viewerMode) {
                return "calc(100% - 32px)";
            }
            else {
                return this.model.pdfPreviewMode || !showfooter ? "calc(100% - 38px)" : "calc(100% - 70px)";
            }
        }
        else {
            if (showfooter) {
                return this.model.showTrialBar ? "calc(100% - 155px)" : "calc(100% - 125px)";
            }
            else {
                return this.model.showTrialBar ? "calc(100% - 123px)" : "calc(100% - 93px)";
            }
        }
    }
    initialize() {
        if (this.init) {
            this.model.requestUrl = this.requestUrl;
            this.model.properties = this.properties;
            this.model.fileName = this.formName;
            if (this.form) {
                this.model.form = this.form;
            }
            if (this.localization) {
                this.localizationService.loadLocalization(this.localization);
            }
            this.controller.initialize();
        }
    }
    cloudLogin(event) {
        delete this.model.properties.cloudLoginInfo;
        delete this.model.login;
        this.model.properties["cloudLogin"] = event.login;
        this.model.properties["cloudPassword"] = event.password;
        this.controller.initialize();
    }
}
StimulsoftFormsComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftFormsComponent, deps: [{ token: i1.StiToolbarResizerService }, { token: i2.StiModelService }, { token: i3.StiThemeService }, { token: i4.StiControllerService }, { token: i5.StiBarcodeService }, { token: StiRectangleGeometryLayout }, { token: i6.StiEditableContentService }, { token: i7.StiChangesService }, { token: i8.StiExportService }, { token: i9.StiFontService }, { token: i10.StiToolboxService }, { token: i11.StiUndoService }, { token: i12.StiUserService }, { token: i13.StiExpressionService }, { token: i14.StiHelperService }, { token: i15.StiLocalizationService }, { token: i16.StiHttpClientService }, { token: i17.SignatureService }, { token: i18.StiTabIndexService }, { token: i19.StiMouseService }, { token: i20.FormEventsService }, { token: i21.StiDropdownService }, { token: i22.StiFormCheckerService }, { token: i23.StiLocalStorageService }, { token: i24.StiTooltipService }], target: i0.ɵɵFactoryTarget.Component });
StimulsoftFormsComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.3.0", type: StimulsoftFormsComponent, selector: "stimulsoft-forms", inputs: { requestUrl: "requestUrl", style: "style", viewerMode: "viewerMode", readonlyMode: "readonlyMode", form: "form", localization: "localization", formName: "formName", settings: "settings", properties: "properties" }, outputs: { interfaceEvent: "interfaceEvent" }, providers: [
        StiModelService,
        StiToolboxService,
        StiMouseService,
        StiComponentResizerService,
        StiDraggableService,
        StiHelperService,
        StiLocalizationService,
        StiToolbarResizerService,
        StiNameService,
        StiRectangleGeometryLayout,
        StiThemeService,
        StiEditableContentService,
        StiControllerService,
        StiHttpClientService,
        StiBarcodeService,
        StiColumnDraggableService,
        DatePipe,
        StiRichTextService,
        StiChangesService,
        StiUndoService,
        StiExportService,
        StiFontService,
        StiUserService,
        StiExpressionService,
        FormEventsService,
        SignatureService,
        StiColorDialogService,
        StiStaticHelperService,
        StiTabIndexService,
        StiDropdownService,
        StiFormCheckerService,
        StiLocalStorageService,
        StiDraggableModalWindowService,
        StiTooltipService,
    ], viewQueries: [{ propertyName: "addTotalMenu", first: true, predicate: ["addTotalMenu"], descendants: true }, { propertyName: "rootFormElementRef", first: true, predicate: ["rootForm"], descendants: true }], usesOnChanges: true, ngImport: i0, template: `
    <div
      class="sti-root-form"
      [style.position]="'relative'"
      [style]="style"
      [style.cursor]="cursor"
      [style.width]="hasParentWidth() ? 'inherit' : '100%'"
      [style.height]="hasParentHeight() ? 'inherit' : '100%'"
      #rootForm
    >
      <sti-navbar [style.pointer-events]="pointerEvents" [style.opacity]="model.isInitialized ? 1 : 0"></sti-navbar>
      <sti-cloud-navbar
        [style.opacity]="model.isInitialized ? 1 : 0"
        *ngIf="model.isCloudMode && model.viewerMode && model.basePlanIsTrial"
      ></sti-cloud-navbar>
      <sti-trial-bar
        [style.opacity]="model.isInitialized ? 1 : 0"
        *ngIf="!viewerMode && !model.isPreviewMode && !model.pdfPreviewMode && model.showTrialBar"
      ></sti-trial-bar>
      <div
        class="flex-container"
        [style.opacity]="model.isInitialized ? 1 : 0"
        [style.height]="containerHeight()"
        [style.pointer-events]="pointerEvents"
      >
        <!-- elements -->

        <sti-toolbox
          *ngIf="
            !viewerMode &&
            !model.isPreviewMode &&
            !model.pdfPreviewMode &&
            toolboxService.showToolbox &&
            model.getBooleanSetting('showToolbox')
          "
          class="elements"
          [style.min-width.px]="toolbarWidth"
        ></sti-toolbox>

        <!-- workspace -->
        <sti-pdf-preview *ngIf="model.pdfPreviewMode" style="width:100%;height:100%"></sti-pdf-preview>
        <sti-workspace
          *ngIf="!model.pdfPreviewMode"
          class="workspace"
          [style.overflow-x]="model.viewerMode && model.isMobile() && !needToScroll() ? 'hidden' : 'auto'"
        ></sti-workspace>
        <!-- properties -->
        <app-properties
          class="properties"
          [style.min-width.px]="
            viewerMode || model.isPreviewMode || model.pdfPreviewMode || !model.getBooleanSetting('showProperties')
              ? '0'
              : model.propertyGridWidth
          "
          [style.max-width.px]="
            viewerMode || model.isPreviewMode || model.pdfPreviewMode || !model.getBooleanSetting('showProperties')
              ? '0'
              : model.propertyGridWidth
          "
          [style.visibility]="
            viewerMode || model.isPreviewMode || model.pdfPreviewMode || !model.getBooleanSetting('showProperties')
              ? 'hidden'
              : ''
          "
        ></app-properties>
        <sti-draggable-element-container></sti-draggable-element-container>
        <sti-clone-element-container></sti-clone-element-container>
        <sti-draggable-column-container></sti-draggable-column-container>
        <sti-barcode-styles-preview></sti-barcode-styles-preview>
        <sti-navbar-group-preview-component></sti-navbar-group-preview-component>
        <sti-user-info></sti-user-info>
        <sti-localization-preview></sti-localization-preview>
      </div>
      <sti-electronic-signature-editor *ngIf="model.showSignatureEditor"></sti-electronic-signature-editor>
      <sti-footer
        [style.opacity]="model.isInitialized ? 1 : 0"
        *ngIf="!model.pdfPreviewMode && model.getBooleanSetting('showFooter')"
        [style.pointer-events]="pointerEvents"
      ></sti-footer>
      <sti-file-menu *ngIf="model.showFileMenu && model.isInitialized"></sti-file-menu>
      <sti-file-menu-navigation *ngIf="model.showFileMenu && model.isInitialized"></sti-file-menu-navigation>
      <sti-about-window-component *ngIf="model.showAboutWindow"></sti-about-window-component>
      <sti-progress [display]="model.showProgress"></sti-progress>
      <expression-draggable-container></expression-draggable-container>
      <sti-color-options-dialog *ngIf="model.showMoreColorDialog"></sti-color-options-dialog>
      <sti-color-dialog *ngIf="model.showColorDialog"></sti-color-dialog>
      <sti-expression-editor *ngIf="model.showExpressionEditor"></sti-expression-editor>
      <sti-trial-modal-window *ngIf="model.showTrialModalWindow"></sti-trial-modal-window>
      <sti-file-save-dialog *ngIf="model.showSaveDialog || model.showSaveDialogFromCloud"></sti-file-save-dialog>
      <sti-setup-toolbox-component *ngIf="model.showToolboxSetup"></sti-setup-toolbox-component>
      <button-message-window *ngIf="model.showButtonMessageWindow || model.showErrorWindow"></button-message-window>
      <sti-modal-agree-window *ngIf="model.showModalWindow || exportService.showModalWindow"></sti-modal-agree-window>
      <expression-help-window *ngIf="model.showHelpWindow"></expression-help-window>
      <sti-context-menu-window
        *ngIf="model.showContextMenu && !viewerMode && !model.isPreviewMode"
      ></sti-context-menu-window>
      <sti-login *ngIf="model.login != null" [loginInfo]="model.login" (onLogin)="cloudLogin($event)"></sti-login>
      <sti-dropdown-list-component *ngIf="dropdownService.showDropdownList"></sti-dropdown-list-component>
      <sti-form-checker *ngIf="formCheckerService.showFormCheckerWindow"></sti-form-checker>
      <sti-draggable-modal-window *ngIf="model.showDraggableModalWindow"></sti-draggable-modal-window>
      <sti-tooltip *ngIf="tooltipService.showTooltip"></sti-tooltip>
      <sti-trial-timer-window *ngIf="model.showTrialTimerWindow"></sti-trial-timer-window>
      <sti-tiered-menu *ngIf="model.showTieredMenu" [menu]="helper.getAddTotalMenuItems()"></sti-tiered-menu>
    </div>
  `, isInline: true, styles: ["sti-file-menu{height:inherit;width:inherit}sti-file-menu-navigation{height:inherit}.flex-container{display:flex;justify-content:center;background:var(--back-color);height:calc(100% - 117px);width:100%;font-family:Segoe UI}.workspace{background-color:var(--workspace-color);display:block;justify-content:center;font-size:2.5rem;color:#000;overflow-y:auto;scroll-behavior:smooth;height:100%;flex-grow:1}*{scrollbar-width:thin;scrollbar-color:var(--thumb-color),var(--back-color)}*::-webkit-scrollbar{-webkit-appearance:none;background-color:var(--back-color);height:10px;width:10px;outline:none}*::-webkit-scrollbar-button{-webkit-appearance:none;height:3px;width:3px}*::-webkit-scrollbar-thumb{-webkit-appearance:none;background-color:var(--thumb-color);height:10px;min-width:25px;max-width:80%;border-radius:4px;border:2px solid var(--back-color)}*::-webkit-scrollbar-thumb:hover{background-color:var(--trackHover-color);height:10px}*::-webkit-scrollbar-track{-webkit-appearance:none;background-color:var(--back-color);border:1px solid var(--back-color)}*::-webkit-scrollbar-corner{background-color:var(--back-color)}.elements{background-color:var(--back-color);font-size:2.5rem;color:#000;visibility:visible;overflow-y:auto;scroll-behavior:smooth;border-right:1px solid var(--formBorder-color);padding:7px;transition:min-width .2s}.properties{background-color:var(--back-color);font-size:2.5rem;color:#000;scroll-behavior:smooth;display:flex;min-width:360px;max-width:360px;border-left:1px solid var(--formBorder-color);font-size:18px}.hovered{background-color:#d1d8e2}.sti-root-form{height:inherit;width:inherit}\n"], dependencies: [{ kind: "directive", type: i25.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i26.NavbarComponent, selector: "sti-navbar" }, { kind: "component", type: i27.WorkspaceComponent, selector: "sti-workspace" }, { kind: "component", type: i28.PropertiesComponent, selector: "app-properties" }, { kind: "component", type: i29.StiDraggableElementContainerComponent, selector: "sti-draggable-element-container" }, { kind: "component", type: i30.StiToolboxComponent, selector: "sti-toolbox" }, { kind: "component", type: i31.StiFooterComponent, selector: "sti-footer" }, { kind: "component", type: i32.StiCloneElementContainerComponent, selector: "sti-clone-element-container" }, { kind: "component", type: i33.StiModalAgreeWindowComponent, selector: "sti-modal-agree-window" }, { kind: "component", type: i34.StiProgressComponent, selector: "sti-progress", inputs: ["display"] }, { kind: "component", type: i35.StiDraggableColumnContainerComponent, selector: "sti-draggable-column-container" }, { kind: "component", type: i36.StiAboutWindowComponent, selector: "sti-about-window-component" }, { kind: "component", type: i37.StiBarcodeStylesPreviewComponent, selector: "sti-barcode-styles-preview" }, { kind: "component", type: i38.StiPdfPreviewComponent, selector: "sti-pdf-preview" }, { kind: "component", type: i39.NavbarGroupPreviewComponent, selector: "sti-navbar-group-preview-component" }, { kind: "component", type: i40.StiSetupToolboxComponent, selector: "sti-setup-toolbox-component" }, { kind: "component", type: i41.StiLocalizationPreviewComponent, selector: "sti-localization-preview" }, { kind: "component", type: i42.StiUserInfoComponent, selector: "sti-user-info" }, { kind: "component", type: i43.StiTrialBarComponent, selector: "sti-trial-bar" }, { kind: "component", type: i44.StiTrialModalWindowComponent, selector: "sti-trial-modal-window" }, { kind: "component", type: i45.StiFileMenuComponent, selector: "sti-file-menu" }, { kind: "component", type: i46.StiFileMenuNavigationComponent, selector: "sti-file-menu-navigation" }, { kind: "component", type: i47.StiFileSaveDialogComponent, selector: "sti-file-save-dialog" }, { kind: "component", type: i48.StiButtonMessageWindowComponent, selector: "button-message-window" }, { kind: "component", type: i49.StiCloudNavbarComponent, selector: "sti-cloud-navbar" }, { kind: "component", type: i50.ContextMenuWindowComponent, selector: "sti-context-menu-window" }, { kind: "component", type: i51.StiExpressionHelpWindowComponent, selector: "expression-help-window" }, { kind: "component", type: i52.StiLoginComponent, selector: "sti-login", inputs: ["loginInfo"], outputs: ["onLogin"] }, { kind: "component", type: i53.StiExpressionEditorComponent, selector: "sti-expression-editor" }, { kind: "component", type: i54.StiColorDialogComponent, selector: "sti-color-dialog" }, { kind: "component", type: i55.StiColorOptionsDialogComponent, selector: "sti-color-options-dialog" }, { kind: "component", type: i56.StiExpressionDraggableContainerComponent, selector: "expression-draggable-container" }, { kind: "component", type: i57.StiDropdownListComponent, selector: "sti-dropdown-list-component" }, { kind: "component", type: i58.StiFormCheckerComponent, selector: "sti-form-checker" }, { kind: "component", type: i59.StiElectronicSignatureEditorComponent, selector: "sti-electronic-signature-editor" }, { kind: "component", type: i60.StiDraggableModalWindowComponent, selector: "sti-draggable-modal-window" }, { kind: "component", type: i61.StiTooltipComponent, selector: "sti-tooltip" }, { kind: "component", type: i62.StiTrialTimerWindowComponent, selector: "sti-trial-timer-window" }, { kind: "component", type: i63.StiTieredMenuComponent, selector: "sti-tiered-menu", inputs: ["menu", "parentElement", "baseZIndex"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StimulsoftFormsComponent, decorators: [{
            type: Component,
            args: [{ selector: "stimulsoft-forms", template: `
    <div
      class="sti-root-form"
      [style.position]="'relative'"
      [style]="style"
      [style.cursor]="cursor"
      [style.width]="hasParentWidth() ? 'inherit' : '100%'"
      [style.height]="hasParentHeight() ? 'inherit' : '100%'"
      #rootForm
    >
      <sti-navbar [style.pointer-events]="pointerEvents" [style.opacity]="model.isInitialized ? 1 : 0"></sti-navbar>
      <sti-cloud-navbar
        [style.opacity]="model.isInitialized ? 1 : 0"
        *ngIf="model.isCloudMode && model.viewerMode && model.basePlanIsTrial"
      ></sti-cloud-navbar>
      <sti-trial-bar
        [style.opacity]="model.isInitialized ? 1 : 0"
        *ngIf="!viewerMode && !model.isPreviewMode && !model.pdfPreviewMode && model.showTrialBar"
      ></sti-trial-bar>
      <div
        class="flex-container"
        [style.opacity]="model.isInitialized ? 1 : 0"
        [style.height]="containerHeight()"
        [style.pointer-events]="pointerEvents"
      >
        <!-- elements -->

        <sti-toolbox
          *ngIf="
            !viewerMode &&
            !model.isPreviewMode &&
            !model.pdfPreviewMode &&
            toolboxService.showToolbox &&
            model.getBooleanSetting('showToolbox')
          "
          class="elements"
          [style.min-width.px]="toolbarWidth"
        ></sti-toolbox>

        <!-- workspace -->
        <sti-pdf-preview *ngIf="model.pdfPreviewMode" style="width:100%;height:100%"></sti-pdf-preview>
        <sti-workspace
          *ngIf="!model.pdfPreviewMode"
          class="workspace"
          [style.overflow-x]="model.viewerMode && model.isMobile() && !needToScroll() ? 'hidden' : 'auto'"
        ></sti-workspace>
        <!-- properties -->
        <app-properties
          class="properties"
          [style.min-width.px]="
            viewerMode || model.isPreviewMode || model.pdfPreviewMode || !model.getBooleanSetting('showProperties')
              ? '0'
              : model.propertyGridWidth
          "
          [style.max-width.px]="
            viewerMode || model.isPreviewMode || model.pdfPreviewMode || !model.getBooleanSetting('showProperties')
              ? '0'
              : model.propertyGridWidth
          "
          [style.visibility]="
            viewerMode || model.isPreviewMode || model.pdfPreviewMode || !model.getBooleanSetting('showProperties')
              ? 'hidden'
              : ''
          "
        ></app-properties>
        <sti-draggable-element-container></sti-draggable-element-container>
        <sti-clone-element-container></sti-clone-element-container>
        <sti-draggable-column-container></sti-draggable-column-container>
        <sti-barcode-styles-preview></sti-barcode-styles-preview>
        <sti-navbar-group-preview-component></sti-navbar-group-preview-component>
        <sti-user-info></sti-user-info>
        <sti-localization-preview></sti-localization-preview>
      </div>
      <sti-electronic-signature-editor *ngIf="model.showSignatureEditor"></sti-electronic-signature-editor>
      <sti-footer
        [style.opacity]="model.isInitialized ? 1 : 0"
        *ngIf="!model.pdfPreviewMode && model.getBooleanSetting('showFooter')"
        [style.pointer-events]="pointerEvents"
      ></sti-footer>
      <sti-file-menu *ngIf="model.showFileMenu && model.isInitialized"></sti-file-menu>
      <sti-file-menu-navigation *ngIf="model.showFileMenu && model.isInitialized"></sti-file-menu-navigation>
      <sti-about-window-component *ngIf="model.showAboutWindow"></sti-about-window-component>
      <sti-progress [display]="model.showProgress"></sti-progress>
      <expression-draggable-container></expression-draggable-container>
      <sti-color-options-dialog *ngIf="model.showMoreColorDialog"></sti-color-options-dialog>
      <sti-color-dialog *ngIf="model.showColorDialog"></sti-color-dialog>
      <sti-expression-editor *ngIf="model.showExpressionEditor"></sti-expression-editor>
      <sti-trial-modal-window *ngIf="model.showTrialModalWindow"></sti-trial-modal-window>
      <sti-file-save-dialog *ngIf="model.showSaveDialog || model.showSaveDialogFromCloud"></sti-file-save-dialog>
      <sti-setup-toolbox-component *ngIf="model.showToolboxSetup"></sti-setup-toolbox-component>
      <button-message-window *ngIf="model.showButtonMessageWindow || model.showErrorWindow"></button-message-window>
      <sti-modal-agree-window *ngIf="model.showModalWindow || exportService.showModalWindow"></sti-modal-agree-window>
      <expression-help-window *ngIf="model.showHelpWindow"></expression-help-window>
      <sti-context-menu-window
        *ngIf="model.showContextMenu && !viewerMode && !model.isPreviewMode"
      ></sti-context-menu-window>
      <sti-login *ngIf="model.login != null" [loginInfo]="model.login" (onLogin)="cloudLogin($event)"></sti-login>
      <sti-dropdown-list-component *ngIf="dropdownService.showDropdownList"></sti-dropdown-list-component>
      <sti-form-checker *ngIf="formCheckerService.showFormCheckerWindow"></sti-form-checker>
      <sti-draggable-modal-window *ngIf="model.showDraggableModalWindow"></sti-draggable-modal-window>
      <sti-tooltip *ngIf="tooltipService.showTooltip"></sti-tooltip>
      <sti-trial-timer-window *ngIf="model.showTrialTimerWindow"></sti-trial-timer-window>
      <sti-tiered-menu *ngIf="model.showTieredMenu" [menu]="helper.getAddTotalMenuItems()"></sti-tiered-menu>
    </div>
  `, providers: [
                        StiModelService,
                        StiToolboxService,
                        StiMouseService,
                        StiComponentResizerService,
                        StiDraggableService,
                        StiHelperService,
                        StiLocalizationService,
                        StiToolbarResizerService,
                        StiNameService,
                        StiRectangleGeometryLayout,
                        StiThemeService,
                        StiEditableContentService,
                        StiControllerService,
                        StiHttpClientService,
                        StiBarcodeService,
                        StiColumnDraggableService,
                        DatePipe,
                        StiRichTextService,
                        StiChangesService,
                        StiUndoService,
                        StiExportService,
                        StiFontService,
                        StiUserService,
                        StiExpressionService,
                        FormEventsService,
                        SignatureService,
                        StiColorDialogService,
                        StiStaticHelperService,
                        StiTabIndexService,
                        StiDropdownService,
                        StiFormCheckerService,
                        StiLocalStorageService,
                        StiDraggableModalWindowService,
                        StiTooltipService,
                    ], styles: ["sti-file-menu{height:inherit;width:inherit}sti-file-menu-navigation{height:inherit}.flex-container{display:flex;justify-content:center;background:var(--back-color);height:calc(100% - 117px);width:100%;font-family:Segoe UI}.workspace{background-color:var(--workspace-color);display:block;justify-content:center;font-size:2.5rem;color:#000;overflow-y:auto;scroll-behavior:smooth;height:100%;flex-grow:1}*{scrollbar-width:thin;scrollbar-color:var(--thumb-color),var(--back-color)}*::-webkit-scrollbar{-webkit-appearance:none;background-color:var(--back-color);height:10px;width:10px;outline:none}*::-webkit-scrollbar-button{-webkit-appearance:none;height:3px;width:3px}*::-webkit-scrollbar-thumb{-webkit-appearance:none;background-color:var(--thumb-color);height:10px;min-width:25px;max-width:80%;border-radius:4px;border:2px solid var(--back-color)}*::-webkit-scrollbar-thumb:hover{background-color:var(--trackHover-color);height:10px}*::-webkit-scrollbar-track{-webkit-appearance:none;background-color:var(--back-color);border:1px solid var(--back-color)}*::-webkit-scrollbar-corner{background-color:var(--back-color)}.elements{background-color:var(--back-color);font-size:2.5rem;color:#000;visibility:visible;overflow-y:auto;scroll-behavior:smooth;border-right:1px solid var(--formBorder-color);padding:7px;transition:min-width .2s}.properties{background-color:var(--back-color);font-size:2.5rem;color:#000;scroll-behavior:smooth;display:flex;min-width:360px;max-width:360px;border-left:1px solid var(--formBorder-color);font-size:18px}.hovered{background-color:#d1d8e2}.sti-root-form{height:inherit;width:inherit}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.StiToolbarResizerService }, { type: i2.StiModelService }, { type: i3.StiThemeService }, { type: i4.StiControllerService }, { type: i5.StiBarcodeService }, { type: StiRectangleGeometryLayout }, { type: i6.StiEditableContentService }, { type: i7.StiChangesService }, { type: i8.StiExportService }, { type: i9.StiFontService }, { type: i10.StiToolboxService }, { type: i11.StiUndoService }, { type: i12.StiUserService }, { type: i13.StiExpressionService }, { type: i14.StiHelperService }, { type: i15.StiLocalizationService }, { type: i16.StiHttpClientService }, { type: i17.SignatureService }, { type: i18.StiTabIndexService }, { type: i19.StiMouseService }, { type: i20.FormEventsService }, { type: i21.StiDropdownService }, { type: i22.StiFormCheckerService }, { type: i23.StiLocalStorageService }, { type: i24.StiTooltipService }]; }, propDecorators: { addTotalMenu: [{
                type: ViewChild,
                args: ["addTotalMenu"]
            }], requestUrl: [{
                type: Input
            }], style: [{
                type: Input
            }], viewerMode: [{
                type: Input
            }], readonlyMode: [{
                type: Input
            }], form: [{
                type: Input
            }], localization: [{
                type: Input
            }], formName: [{
                type: Input
            }], settings: [{
                type: Input
            }], interfaceEvent: [{
                type: Output
            }], properties: [{
                type: Input
            }], rootFormElementRef: [{
                type: ViewChild,
                args: ["rootForm"]
            }] } });
//# sourceMappingURL=data:application/json;base64,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