import { Injectable } from "@angular/core";
import { StiLocalizationService } from "./sti-localization.service";
import StiJson from "../system/StiJson";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class StiUserService {
    constructor(model) {
        this.model = model;
        this.showLocalizationPreview = false;
        this.showUserInfo = false;
        this.buildDate = new Date(2022, 8, 27);
        this.trialMessage = "";
    }
    get currentUser() {
        return this._currentUser;
    }
    set currentUser(value) {
        if (value) {
            if (value == "empty") {
                this._currentUser = null;
            }
            else {
                let user = this.model.toCamelCase(value);
                this._currentUser = user;
                if (user?.created && !this.model.isWebView && (!this.licenseProducts || this.licenseProducts.length == 0)) {
                    this.buildDate = StiJson.jsonDateFormatToDate(user.created).date;
                }
            }
            this.checkLicense();
        }
    }
    getBackground(user) {
        let key = user?.userKey ? user?.userKey : user?.key ?? "key";
        var r = 0;
        var g = 0;
        var b = 0;
        for (var i = 0; i < key.length / 3; i += 3) {
            r += key.charCodeAt(i);
            g += key.charCodeAt(i + 1);
            b += key.charCodeAt(i + 2);
        }
        r = (r % 100) + 100;
        g = (g % 100) + 100;
        b = (b % 100) + 100;
        return `rgb(${r},${g}, ${b})`;
    }
    checkLicense() {
        this.model.userWasChecked = true;
        if (this.licenseProducts?.length > 0 || this.currentUser) {
            let expirationDate = 0;
            if (this.licenseProducts?.length > 0) {
                this.licenseProducts.forEach((product) => {
                    if (product.ident == "Ultimate" ||
                        product.ident == "FormsWeb" ||
                        product.ident == 1 ||
                        product.ident == 4 ||
                        product.ident == "BICloud" ||
                        product.ident == 18) {
                        expirationDate = Math.max(expirationDate, new Date(product.expirationDate).getTime());
                    }
                });
            }
            if (this.currentUser) {
                this.model.userIsAuthorized = true;
            }
            if (expirationDate != 0 && expirationDate > this.buildDate.getTime()) {
                this.model.showTrialBar = false;
                this.model.showTrialModalWindow = false;
                this.model.showTrialTitle = false;
                this.model.userIsAuthorized = true;
            }
            else {
                this.showTrial();
            }
        }
        else {
            this.showTrial();
        }
    }
    resetTrial() {
        this.model.showTrialBar = true;
        this.model.showTrialTitle = true;
        this.model.canCloseTrialWindow = true;
        this.model.disableCloseButton = false;
        this.model.showTrialModalWindow = false;
    }
    showTrial() {
        let currentDate = new Date();
        let trDays = Math.floor((currentDate.getTime() - this.buildDate.getTime()) / 1000 / 60 / 60 / 24);
        this.trialMessage = StiLocalizationService.get("Notices", "YouUsingTrialVersion");
        this.resetTrial();
        if (trDays > 30) {
            this.model.disableCloseButton = true;
        }
        if (!this.model.buildDate) {
            return;
        }
        if (trDays > 45) {
            this.model.showTrialTitle = true;
            setTimeout(() => {
                if (this.currentUser) {
                    this.model.showTrialModalWindow = true;
                }
            }, 3000);
        }
        if (trDays > 60) {
            if (this.currentUser) {
                this.model.canCloseTrialWindow = false;
            }
            this.trialMessage = StiLocalizationService.get("Notices", "YourTrialHasExpired");
            setTimeout(() => {
                if (this.currentUser) {
                    this.model.showTrialModalWindow = true;
                }
            }, 3000);
        }
    }
}
StiUserService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiUserService, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable });
StiUserService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiUserService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiUserService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; } });
//# sourceMappingURL=data:application/json;base64,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