import { Injectable } from "@angular/core";
import { StiTextBoxComponent } from "../components/sti-text-box/sti-text-box.component";
import { StiNumberBoxComponent } from "../components/sti-number-box/sti-number-box.component";
import { StiComboBoxComponent } from "../components/sti-combo-box/sti-combo-box.component";
import { StiListBoxComponent } from "../components/sti-list-box/sti-list-box.component";
import { StiSingleSelectionComponent } from "../components/sti-single-selection/sti-single-selection.component";
import { StiMultipleSelectionComponent } from "../components/sti-multiple-selection/sti-multiple-selection.component";
import { StiCheckBoxComponent } from "../components/sti-check-box/sti-check-box.component";
import { StiLineComponent } from "../components/sti-line/sti-line.component";
import { StiSignatureComponent } from "../components/sti-signature/sti-signature.component";
import { StiDateTimeBoxComponent } from "../components/sti-date-time-box/sti-date-time-box.component";
import { StiTableComponent } from "../components/sti-table/sti-table.component";
import { StiImageComponent } from "../components/sti-image/sti-image.component";
import { StiButtonComponent } from "../components/sti-button/sti-button.component";
import { StiBarcodeComponent } from "../components/sti-barcode/sti-barcode.component";
import { StiTextComponent } from "../components/sti-text/sti-text.component";
import { StiLabelComponent } from "../components/sti-label/sti-label.component";
import { Subject } from "rxjs";
import { StiDraggableService } from "./sti-draggable.service";
import { StiBarcodeElement } from "../elements/StiBarcodeElement";
import { StiButtonElement } from "../elements/StiButtonElement";
import { StiCheckBoxElement } from "../elements/StiCheckBoxElement";
import { StiComboBoxElement } from "../elements/StiComboBoxElement";
import { StiDateTimeBoxElement } from "../elements/StiDateTimeBoxElement";
import { StiImageElement } from "../elements/StiImageElement";
import { StiLabelElement } from "../elements/StiLabelElement";
import StiLineElement from "../elements/StiLineElement";
import { StiListBoxElement } from "../elements/StiListBoxElement";
import { StiMultipleSelectionElement } from "../elements/StiMultipleSelectionElement";
import { StiNumberBoxElement } from "../elements/StiNumberBoxElement";
import { StiPanelElement } from "../elements/StiPanelElement";
import { StiSignatureElement } from "../elements/StiSignatureElement";
import { StiSingleSelectionElement } from "../elements/StiSingleSelectionElement";
import { StiTableElement } from "../elements/StiTableElement";
import { StiTextBoxElement } from "../elements/StiTextBoxElement";
import { StiTextElement } from "../elements/StiTextElement";
import { StiAddressComponent } from "../components/sti-address/sti-address.component";
import { StiAddressElement } from "../elements/StiAddressElement";
import { StiPDFSignatureComponent } from "../components/sti-pdf-signature/sti-pdf-signature.component";
import { StiPDFSignatureElement } from "../elements/StiPDFSignatureElement";
import { StiPanelComponent } from "../components/sti-components-holder.component";
import * as i0 from "@angular/core";
import * as i1 from "./mouse.service";
import * as i2 from "./sti-draggable.service";
import * as i3 from "./model.service";
import * as i4 from "./sti-localization.service";
export class StiToolboxService {
    constructor(mouseService, draggableService, model, loc) {
        this.mouseService = mouseService;
        this.draggableService = draggableService;
        this.model = model;
        this.loc = loc;
        this.showGroupPreview = false;
        this.elementsForRibbon = [
            {
                caption: "Input",
                image: "images.Toolbox.StiTextBoxElement.png",
                category: "PropertyMain",
            },
            {
                caption: "Selection",
                image: "images.Toolbox.StiSingleSelectionElement.png",
            },
            {
                caption: "Others",
                image: "images.Toolbox.StiSignatureElement.png",
                category: "FormDesigner",
            },
            { caption: "Divider" },
            {
                caption: "StiTable",
                image: "images.Toolbox.StiTableElement.png",
                id: "table",
                component: StiTableComponent,
                element: StiTableElement,
            },
            {
                caption: "StiButton",
                image: "images.Toolbox.StiButtonElement.png",
                id: "button",
                component: StiButtonComponent,
                element: StiButtonElement,
            },
            {
                caption: "StiLabelControl",
                image: "images.Toolbox.StiLabelElement.png",
                id: "label",
                component: StiLabelComponent,
                element: StiLabelElement,
                category: "Dialogs",
            },
            {
                caption: "StiText",
                image: "images.Toolbox.StiRichTextElement.png",
                id: "text",
                component: StiTextComponent,
                element: StiTextElement,
            },
            {
                caption: "StiImage",
                image: "images.Toolbox.StiImageElement.png",
                id: "image",
                component: StiImageComponent,
                element: StiImageElement,
            },
            {
                caption: "StiPanel",
                image: "images.Toolbox.StiPanelElement.png",
                id: "panel",
                component: StiPanelComponent,
                element: StiPanelElement,
            },
        ];
        this.inputGroup = [
            {
                caption: "StiTextBoxControl",
                image: "images.Toolbox.StiTextBoxElement.png",
                id: "textbox",
                component: StiTextBoxComponent,
                element: StiTextBoxElement,
                category: "Dialogs",
            },
            {
                caption: "StiNumberBox",
                image: "images.Toolbox.StiNumberBoxElement.png",
                id: "numberbox",
                component: StiNumberBoxComponent,
                element: StiNumberBoxElement,
            },
            {
                caption: "StiComboBox",
                image: "images.Toolbox.StiComboBoxElement.png",
                id: "combobox",
                component: StiComboBoxComponent,
                element: StiComboBoxElement,
            },
            {
                caption: "StiDateTimePickerControl",
                image: "images.Toolbox.StiDateTimeBoxElement.png",
                id: "dateTime",
                component: StiDateTimeBoxComponent,
                element: StiDateTimeBoxElement,
                category: "Dialogs",
            },
        ];
        this.selectionGroup = [
            {
                caption: "StiSingleSelection",
                image: "images.Toolbox.StiSingleSelectionElement.png",
                id: "singleSelection",
                component: StiSingleSelectionComponent,
                element: StiSingleSelectionElement,
            },
            {
                caption: "StiMultipleSelection",
                image: "images.Toolbox.StiMultipleSelectionElement.png",
                id: "multipleSelection",
                component: StiMultipleSelectionComponent,
                element: StiMultipleSelectionElement,
            },
            {
                caption: "StiListBox",
                image: "images.Toolbox.StiListBoxElement.png",
                id: "listbox",
                component: StiListBoxComponent,
                element: StiListBoxElement,
            },
            {
                caption: "StiCheckBox",
                image: "images.Toolbox.StiCheckBoxElement.png",
                id: "checkbox",
                component: StiCheckBoxComponent,
                element: StiCheckBoxElement,
            },
        ];
        this.otherGroup = [
            {
                caption: "StiElectronicSignature",
                image: "images.Toolbox.StiElectronicSignature.png",
                id: "signature",
                component: StiSignatureComponent,
                element: StiSignatureElement,
            },
            {
                caption: "StiPdfDigitalSignature",
                image: "images.Toolbox.StiPdfDigitalSignature.png",
                id: "PDFsignature",
                component: StiPDFSignatureComponent,
                element: StiPDFSignatureElement,
            },
            {
                caption: "StiBarCode",
                image: "images.Toolbox.StiBarCodeElement.png",
                id: "barcode",
                component: StiBarcodeComponent,
                element: StiBarcodeElement,
            },
            {
                caption: "Address",
                image: "images.Toolbox.Address.png",
                id: "address",
                component: StiAddressComponent,
                element: StiAddressElement,
                category: "Report",
            },
            {
                caption: "Line",
                image: "images.Toolbox.StiLineElement.png",
                id: "line",
                component: StiLineComponent,
                element: StiLineElement,
                category: "Chart",
            },
        ];
        this.elements = [
            {
                caption: "StiTextBoxControl",
                image: "images.Toolbox.StiTextBoxElement.png",
                id: "textbox",
                component: StiTextBoxComponent,
                element: StiTextBoxElement,
                enabled: true,
                category: "Dialogs",
            },
            {
                caption: "StiNumberBox",
                image: "images.Toolbox.StiNumberBoxElement.png",
                id: "numberbox",
                component: StiNumberBoxComponent,
                element: StiNumberBoxElement,
                enabled: true,
            },
            {
                caption: "StiComboBox",
                image: "images.Toolbox.StiComboBoxElement.png",
                id: "combobox",
                component: StiComboBoxComponent,
                element: StiComboBoxElement,
                enabled: true,
            },
            {
                caption: "StiListBox",
                image: "images.Toolbox.StiListBoxElement.png",
                id: "listbox",
                component: StiListBoxComponent,
                element: StiListBoxElement,
                enabled: true,
            },
            {
                caption: "StiSingleSelection",
                image: "images.Toolbox.StiSingleSelectionElement.png",
                id: "singleSelection",
                component: StiSingleSelectionComponent,
                element: StiSingleSelectionElement,
                enabled: true,
            },
            {
                caption: "StiMultipleSelection",
                image: "images.Toolbox.StiMultipleSelectionElement.png",
                id: "multipleSelection",
                component: StiMultipleSelectionComponent,
                element: StiMultipleSelectionElement,
                enabled: true,
            },
            {
                caption: "StiCheckBox",
                image: "images.Toolbox.StiCheckBoxElement.png",
                id: "checkbox",
                component: StiCheckBoxComponent,
                element: StiCheckBoxElement,
                enabled: true,
            },
            {
                caption: "StiElectronicSignature",
                image: "images.Toolbox.StiElectronicSignature.png",
                id: "signature",
                component: StiSignatureComponent,
                element: StiSignatureElement,
                enabled: true,
            },
            {
                caption: "StiPdfDigitalSignature",
                image: "images.Toolbox.StiPdfDigitalSignature.png",
                id: "PDFsignature",
                component: StiPDFSignatureComponent,
                element: StiPDFSignatureElement,
                enabled: true,
            },
            {
                caption: "StiDateTimePickerControl",
                image: "images.Toolbox.StiDateTimeBoxElement.png",
                id: "dateTime",
                component: StiDateTimeBoxComponent,
                element: StiDateTimeBoxElement,
                enabled: true,
                category: "Dialogs",
            },
            {
                caption: "StiTable",
                image: "images.Toolbox.StiTableElement.png",
                id: "table",
                component: StiTableComponent,
                element: StiTableElement,
                enabled: true,
            },
            {
                caption: "StiButton",
                image: "images.Toolbox.StiButtonElement.png",
                id: "button",
                component: StiButtonComponent,
                element: StiButtonElement,
                enabled: true,
            },
            {
                caption: "StiBarCode",
                image: "images.Toolbox.StiBarCodeElement.png",
                id: "barcode",
                component: StiBarcodeComponent,
                element: StiBarcodeElement,
                enabled: true,
            },
            {
                caption: "Address",
                image: "images.Toolbox.Address.png",
                id: "address",
                component: StiAddressComponent,
                element: StiAddressElement,
                enabled: true,
                category: "Report",
            },
            { caption: "Divider" },
            {
                caption: "StiLabelControl",
                image: "images.Toolbox.StiLabelElement.png",
                id: "label",
                component: StiLabelComponent,
                element: StiLabelElement,
                enabled: true,
                category: "Dialogs",
            },
            {
                caption: "StiText",
                image: "images.Toolbox.StiRichTextElement.png",
                id: "text",
                component: StiTextComponent,
                element: StiTextElement,
                enabled: true,
            },
            {
                caption: "StiImage",
                image: "images.Toolbox.StiImageElement.png",
                id: "image",
                component: StiImageComponent,
                element: StiImageElement,
                enabled: true,
            },
            {
                caption: "Line",
                image: "images.Toolbox.StiLineElement.png",
                id: "line",
                component: StiLineComponent,
                element: StiLineElement,
                enabled: true,
                category: "Chart",
            },
            {
                caption: "StiPanel",
                image: "images.Toolbox.StiPanelElement.png",
                id: "panel",
                component: StiPanelComponent,
                element: StiPanelElement,
                enabled: true,
            },
        ];
        this.unusedElements = [];
        this.subject = new Subject();
        this.showToolbox = true;
        this.showInsertTab = true;
        mouseService.getDocumentMouseMove().subscribe((event) => {
            this.onMouseMove(event);
        });
        mouseService.getDocumentMouseUp().subscribe(() => {
            // this.mouseDownComponent = null;
        });
    }
    isEnabled(element) {
        if (this.unusedElements?.find((item) => item == element.id) || !this.isEnabledFromSettings(element)) {
            return false;
        }
        else {
            return true;
        }
    }
    isEnabledFromSettings(element) {
        return this.model.getBooleanSetting(this.idToCamelCase(element?.id)) ?? true;
    }
    getToolboxId(type) {
        if (type == "TextElement" || type == "Text") {
            return "text";
        }
        else if (type == "Text_BoxElement" || type == "TextBox") {
            return "textbox";
        }
        else if (type == "TableElement" || type == "Table") {
            return "table";
        }
        else if (type == "Single_SelectionElement" || type == "SingleSelection") {
            return "singleSelection";
        }
        else if (type == "SignatureElement" || type == "Signature") {
            return "signature";
        }
        else if (type == "PDFSignatureElement" || type == "PDFSignature") {
            return "PDFsignature";
        }
        else if (type == "PanelElement" || type == "Panel") {
            return "panel";
        }
        else if (type == "Number_BoxElement" || type == "NumberBox") {
            return "numberbox";
        }
        else if (type == "Multiple_SelectionElement" || type == "MultipleSelection") {
            return "multipleSelection";
        }
        else if (type == "List_BoxElement" || type == "ListBox") {
            return "listbox";
        }
        else if (type == "LineElement" || type == "Line") {
            return "line";
        }
        else if (type == "LabelElement" || type == "Label") {
            return "label";
        }
        else if (type == "ImageElement" || type == "Image") {
            return "image";
        }
        else if (type == "DateTime_BoxElement" || type == "DateTimeBox") {
            return "dateTime";
        }
        else if (type == "Combo_BoxElement" || type == "ComboBox") {
            return "combobox";
        }
        else if (type == "Check_BoxElement" || type == "CheckBox") {
            return "checkbox";
        }
        else if (type == "ButtonElement" || type == "Button") {
            return "button";
        }
        else if (type == "BarCodeElement" || type == "BarCode") {
            return "barcode";
        }
        else if (type == "AddressElement" || type == "Address") {
            return "address";
        }
    }
    idToCamelCase(id) {
        switch (id) {
            case "textbox":
                return "showTextBox";
            case "numberbox":
                return "showNumberBox";
            case "combobox":
                return "showComboBox";
            case "listbox":
                return "showListBox";
            case "singleSelection":
                return "showSingleSelection";
            case "multipleSelection":
                return "showMultipleSelection";
            case "checkbox":
                return "showCheckBox";
            case "signature":
                return "showSignature";
            /*  case "PDFsignature":
              return "showPDFSignature"; */
            case "dateTime":
                return "showDateTimeBox";
            case "table":
                return "showTable";
            case "button":
                return "showButton";
            case "barcode":
                return "showBarCode";
            case "address":
                return "showAddress";
            case "label":
                return "showLabel";
            case "text":
                return "showText";
            case "image":
                return "showImage";
            case "line":
                return "showLine";
            case "panel":
                return "showPanel";
        }
    }
    isGroupEnabled(group) {
        if (group.caption == "Input" ||
            group.caption == "Selection" ||
            group.caption == "Other" ||
            group.caption == "Divider") {
            if (group.caption == "Input") {
                if (!this.unusedElements?.find((item) => item == "textbox") ||
                    !this.unusedElements?.find((item) => item == "numberbox") ||
                    !this.unusedElements?.find((item) => item == "combobox") ||
                    !this.unusedElements?.find((item) => item == "dateTime")) {
                    return true;
                }
                else {
                    return false;
                }
            }
            else if (group.caption == "Selection") {
                if (!this.unusedElements?.find((item) => item == "singleSelection") ||
                    !this.unusedElements?.find((item) => item == "multipleSelection") ||
                    !this.unusedElements?.find((item) => item == "listbox") ||
                    !this.unusedElements?.find((item) => item == "checkbox")) {
                    return true;
                }
                else {
                    return false;
                }
            }
            else if (group.caption == "Other") {
                if (!this.unusedElements?.find((item) => item == "signature") ||
                    !this.unusedElements?.find((item) => item == "PDFsignature") ||
                    !this.unusedElements?.find((item) => item == "barcode") ||
                    !this.unusedElements?.find((item) => item == "address") ||
                    !this.unusedElements?.find((item) => item == "line")) {
                    return true;
                }
                else {
                    return false;
                }
            }
        }
        else {
            return true;
        }
    }
    isInsertInlineElementsDividerEnabled(element) {
        if (element.caption == "Divider") {
            if (!this.unusedElements?.find((item) => item == "textbox") ||
                !this.unusedElements?.find((item) => item == "numberbox") ||
                !this.unusedElements?.find((item) => item == "combobox") ||
                !this.unusedElements?.find((item) => item == "dateTime") ||
                !this.unusedElements?.find((item) => item == "singleSelection") ||
                !this.unusedElements?.find((item) => item == "multipleSelection") ||
                !this.unusedElements?.find((item) => item == "listbox") ||
                !this.unusedElements?.find((item) => item == "checkbox") ||
                !this.unusedElements?.find((item) => item == "signature") ||
                !this.unusedElements?.find((item) => item == "PDFsignature") ||
                !this.unusedElements?.find((item) => item == "barcode") ||
                !this.unusedElements?.find((item) => item == "address") ||
                !this.unusedElements?.find((item) => item == "line")) {
                return true;
            }
            else {
                return false;
            }
        }
        else {
            return false;
        }
    }
    isToolboxInlineElementsDividerEnabled(element) {
        if (element.caption == "Divider") {
            if (!this.unusedElements?.find((item) => item == "textbox") ||
                !this.unusedElements?.find((item) => item == "numberbox") ||
                !this.unusedElements?.find((item) => item == "combobox") ||
                !this.unusedElements?.find((item) => item == "dateTime") ||
                !this.unusedElements?.find((item) => item == "singleSelection") ||
                !this.unusedElements?.find((item) => item == "multipleSelection") ||
                !this.unusedElements?.find((item) => item == "listbox") ||
                !this.unusedElements?.find((item) => item == "checkbox") ||
                !this.unusedElements?.find((item) => item == "signature") ||
                !this.unusedElements?.find((item) => item == "PDFsignature") ||
                !this.unusedElements?.find((item) => item == "barcode") ||
                !this.unusedElements?.find((item) => item == "address") ||
                !this.unusedElements?.find((item) => item == "table") ||
                !this.unusedElements?.find((item) => item == "button")) {
                return true;
            }
            else {
                return false;
            }
        }
        else {
            return false;
        }
    }
    isInsertOutlineElementsDividerEnabled() {
        if (!this.unusedElements?.find((item) => item == "table") ||
            !this.unusedElements?.find((item) => item == "button") ||
            !this.unusedElements?.find((item) => item == "label") ||
            !this.unusedElements?.find((item) => item == "text") ||
            !this.unusedElements?.find((item) => item == "image") ||
            !this.unusedElements?.find((item) => item == "panel")) {
            return true;
        }
        else {
            return false;
        }
    }
    isToolboxOutlineElementsDividerEnabled() {
        if (!this.unusedElements?.find((item) => item == "label") ||
            !this.unusedElements?.find((item) => item == "text") ||
            !this.unusedElements?.find((item) => item == "image") ||
            !this.unusedElements?.find((item) => item == "line") ||
            !this.unusedElements?.find((item) => item == "panel")) {
            return true;
        }
        else {
            return false;
        }
    }
    haveEnabledComponents() {
        let isEnabled = false;
        for (let element of this.elements) {
            if (element.enabled) {
                isEnabled = true;
                break;
            }
        }
        return isEnabled;
    }
    getMessage() {
        return this.subject.asObservable();
    }
    elementMouseDown(component, event) {
        this.mouseDownComponent = component;
        this.mouseDownX = event.clientX;
        this.mouseDownY = event.clientY;
    }
    elementDoubleClick(component) {
        this.mouseDownComponent = null;
        let element = new component.element.element();
        this.model.form.settings.applySettings(element);
        this.draggableService.addingByDoubleClick(element);
    }
    onMouseMove(event) {
        if (this.mouseDownComponent &&
            Math.max(Math.abs(this.mouseDownX - event.clientX), Math.abs(this.mouseDownY - event.clientY)) >
                StiDraggableService.MOUSE_DELTA) {
            let element = new this.mouseDownComponent.element.element();
            this.model.form.settings.applySettings(element);
            this.model.elementToUpdate = element;
            this.draggableService.startDrag(event, element);
            this.mouseDownComponent = null;
        }
    }
}
StiToolboxService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiToolboxService, deps: [{ token: i1.StiMouseService }, { token: i2.StiDraggableService }, { token: i3.StiModelService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Injectable });
StiToolboxService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiToolboxService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiToolboxService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiMouseService }, { type: i2.StiDraggableService }, { type: i3.StiModelService }, { type: i4.StiLocalizationService }]; } });
//# sourceMappingURL=data:application/json;base64,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