import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class StiTabIndexService {
    constructor(model) {
        this.model = model;
        model.interfaceEvent.subscribe((event) => {
            if (event?.name == "SetPreviewMode" && event?.data === true) {
                this.arrangeTabIndex();
            }
        });
        model.formEvents.subscribe((event) => {
            if (event.name == "SetForm" && model.viewerMode) {
                this.arrangeTabIndex();
            }
        });
    }
    arrangeTabIndex() {
        let elements = [];
        this.model.form?.pages.forEach((form, pageIndex) => {
            form.allElements.filter(e => e["setTabIndex"] != null).forEach(element => {
                elements.push({
                    element: element,
                    geometry: element.geometry,
                    pageIndex: pageIndex
                });
            });
        });
        elements.sort((e1, e2) => {
            if (e1.pageIndex != e2.pageIndex) {
                return e1.pageIndex > e2.pageIndex ? 1 : -1;
            }
            else if (e1.geometry.y != e2.geometry.y) {
                return e1.geometry.y > e2.geometry.y ? 1 : -1;
            }
            else {
                return e1.geometry.x > e2.geometry.x ? 1 : -1;
            }
        });
        let tabIndex = 100;
        elements.forEach(e => tabIndex = e.element.setTabIndex(tabIndex));
    }
}
StiTabIndexService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTabIndexService, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable });
StiTabIndexService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTabIndexService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiTabIndexService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; } });
//# sourceMappingURL=data:application/json;base64,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