import { Injectable } from "@angular/core";
import { Subject } from "rxjs";
import { StiSignatureElement } from "../elements/StiSignatureElement";
import { StiTextItem } from "../elements/text/StiTextItem";
import StiJson from "../system/StiJson";
import { StiImageEditorResult } from "../elements/signature/StiImageEditorResult";
import { StiHorizontalAlignment, StiVerticalAlignment } from "../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class SignatureService {
    constructor(model) {
        this.model = model;
        this._editorComponentX = 0;
        this._editorComponentY = 0;
        this.textMode = false;
        this.selectedMode = "Draw";
        this.previewFonts = ["Teddy Bear", "MADE Likes Script", "Denistina"];
        this.currentPreviewFont = "Teddy Bear";
        this.drawingMode = false;
        this.showFontsPreview = false;
        this.loadedImage = new Subject();
        this.clearButtonClick = new Subject();
        this.updateSignature = new Subject();
        this.getInsertedInformation = new Subject();
        this.currentEditableText = new StiTextItem();
        this.editorComponentHeight = 350;
        this.editorComponentWidth = 365;
        this.fontsPreviewX = 0;
        this.fontsPreviewY = 0;
        this.templatesPreviewX = 0;
        this.templatesPreviewY = 0;
        this.showSavedTemplates = false;
        this.savedTemplates = [];
        this.currentActiveLoadingImages = 0;
        this.completedLoadingImages = 0;
        this.completedLoading = new Subject();
    }
    checkLoading() {
        if (this.completedLoadingImages === this.currentActiveLoadingImages) {
            this.completedLoading.next(true);
            this.completedLoadingImages = 0;
            this.currentActiveLoadingImages = 0;
        }
        else {
            setTimeout(() => {
                this.checkLoading();
            });
        }
    }
    getVerticalPosition(verticalAlignment) {
        switch (verticalAlignment) {
            case StiVerticalAlignment.Top:
                return "top";
            case StiVerticalAlignment.Bottom:
                return "bottom";
            case StiVerticalAlignment.Center:
                return "center";
        }
    }
    getHorizontalPosition(horizontalAlignment) {
        switch (horizontalAlignment) {
            case StiHorizontalAlignment.Left:
                return "left";
            case StiHorizontalAlignment.Right:
                return "right";
            case StiHorizontalAlignment.Center:
                return "center";
        }
    }
    getClass(item) {
        if (item == "Text") {
            return StiTextItem;
        }
        else if (item == "Image") {
            return StiImageEditorResult;
        }
    }
    setTemplate(template) {
        if (template.type == "Image") {
            this.currentEditableImage = template.image;
            this.currentEditableText = template.text;
            this.currentCanvasContent = template.drawedImage;
            this.selectedMode = "Draw";
        }
        else {
            this.currentPreviewFont = template.specialFont;
            this.currentEditableFullName = template.fullName;
            this.currentEditableInitials = template.initials;
            this.selectedMode = "Type";
        }
        this.showSavedTemplates = false;
    }
    getTemplateImage(template) {
        return "url(" + template?.image?.loadedImage + ")";
    }
    getTemplateDrawedImage(template) {
        return "url(" + template?.image?.drawedImage + ")";
    }
    deleteTemplate(index) {
        this.savedTemplates.splice(index, 1);
    }
    getTemplateHorizontalAlignment(template) {
        if (template.image.horizontalAlignment == StiHorizontalAlignment.Center) {
            return "center";
        }
        else if (template.image.horizontalAlignment == StiHorizontalAlignment.Left) {
            return "start";
        }
        else {
            return "end";
        }
    }
    getTemplateBackgroundSize(template, container) {
        if (!template?.image?.loadedImage) {
            return;
        }
        if (template?.image?.aspectRatio) {
            return "contain";
        }
        if (template?.image?.stretch) {
            return `${container.offsetWidth}px ${container.offsetHeight}px`;
        }
        else {
            return `${template?.image?.naturalWidth}px ${template?.image?.naturalHeight}px`;
        }
    }
    getTemplateBackgroundPosition(template) {
        if (!template?.image?.aspectRatio && !template?.image?.stretch) {
            if (template?.image?.verticalAlignment == StiVerticalAlignment.Center) {
                return "center center";
            }
            else if (template?.image?.verticalAlignment == StiVerticalAlignment.Top) {
                return "top center";
            }
            else {
                return "bottom center";
            }
        }
        else {
            return "center";
        }
    }
    cloneProperty(property, propertyClass) {
        let result = new propertyClass();
        let jObject = new StiJson();
        jObject.deserialize(property.saveToJsonObject({}).serialize());
        result.loadFromJsonObject(jObject);
        return result;
    }
    get editorComponentX() {
        return this._editorComponentX;
    }
    set editorComponentX(value) {
        value <= 0 ? (this._editorComponentX = 0) : (this._editorComponentX = value);
    }
    get editorComponentY() {
        return this._editorComponentY;
    }
    set editorComponentY(value) {
        value <= 0 ? (this._editorComponentY = 0) : (this._editorComponentY = value);
    }
    get y() {
        if (this.isSignature) {
            let container = document.getElementById(this.model.selectedComponent?.element.guid);
            let geom = this.model.getPositionRelativeToForm(container);
            return geom.y;
        }
        else {
            return 0;
        }
    }
    get x() {
        if (this.isSignature) {
            let container = document.getElementById(this.model.selectedComponent?.element.guid);
            let geom = this.model.getPositionRelativeToForm(container);
            return geom.x + geom.width + 5;
        }
        else {
            return 0;
        }
    }
    changeDrawingMode() {
        this.textMode = false;
        this.drawingMode = !this.drawingMode;
    }
    changeTextMode() {
        this.drawingMode = false;
        this.textMode = !this.textMode;
    }
    clear() {
        this.clearButtonClick.next(true);
    }
    onFileSelected() {
        let input = document.createElement("input");
        input.type = "file";
        input.accept = ".png, .jpg, .jpeg";
        let this_ = this;
        input.onchange = (_) => {
            this_.clear();
            let file = Array.from(input.files)[0];
            var reader = new FileReader();
            reader.readAsDataURL(file);
            reader.onload = function (e) {
                this_.loadedImage.next(e.target.result);
            };
        };
        input.click();
    }
    get isSignature() {
        return this.model.selectedComponent?.element instanceof StiSignatureElement ? true : false;
    }
}
SignatureService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: SignatureService, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable });
SignatureService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: SignatureService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: SignatureService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; } });
//# sourceMappingURL=data:application/json;base64,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