import { Injectable } from "@angular/core";
import Color from "../system/Color";
import { StiHorizontalAlignment } from "../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class StiRichTextService {
    constructor(model) {
        this.model = model;
        this.sizes = { 1: 8, 2: 10, 3: 12, 4: 14, 5: 18, 6: 24, 7: 36 };
        this.xSizes = {
            "x-small": 8,
            small: 10,
            medium: 12,
            large: 14,
            "x-large	": 18,
            "xx-large": 24,
            "xxx-large": 36,
        };
        this.activeTextStyles = [];
        this.activeFontFamily = "Arial";
        this.activeFontSize = 3;
        this.activeColor = Color.red();
        this.currentSelectedTextIsBold = false;
        this.currentSelectedTextIsItalic = false;
        this.currentSelectedTextIsUnderline = false;
        this.currentSelectedTextHasCenterAlignment = false;
        this.currentSelectedTextHasLeftAlignment = false;
        this.currentSelectedTextHasRightAlignment = false;
    }
    showCurrentState() {
        this.currentSelectedTextIsBold = this.getIframe()?.queryCommandState("bold");
        this.currentSelectedTextIsItalic = this.getIframe()?.queryCommandState("italic");
        this.currentSelectedTextIsUnderline = this.getIframe()?.queryCommandState("underline");
        this.currentSelectedTextHasCenterAlignment = this.getIframe()?.queryCommandState("justifyCenter");
        this.currentSelectedTextHasLeftAlignment = this.getIframe()?.queryCommandState("justifyLeft");
        this.currentSelectedTextHasRightAlignment = this.getIframe()?.queryCommandState("justifyRight");
        this.activeFontFamily = this.getIframe()?.queryCommandValue("FontName").replace(/"/g, "");
        this.activeFontSize =
            Number(this.getIframe()?.queryCommandValue("FontSize")) > 7
                ? this.convertSizeMmToHtmlSize(Number(this.getIframe()?.queryCommandValue("FontSize")))
                : Number(this.getIframe()?.queryCommandValue("FontSize"));
        if (this.getIframe() != null) {
            let foreColor = this.getIframe()?.queryCommandValue("ForeColor");
            if (foreColor.length > 0) {
                let color = new Color();
                if (this.getIframe().queryCommandValue("ForeColor").includes("#")) {
                    color?.deserializeFromString(this.hexToRgb(this.getIframe()?.queryCommandValue("ForeColor")));
                }
                else {
                    color?.deserializeFromString(this.getIframe().queryCommandValue("ForeColor").replace("rgb(", "").replace(")", ""));
                }
                this.activeColor = color;
            }
        }
        this.activeTextStyles = [];
        if (this.currentSelectedTextIsBold) {
            this.activeTextStyles.push("Bold");
        }
        if (this.currentSelectedTextIsItalic) {
            this.activeTextStyles.push("Italic");
        }
        if (this.currentSelectedTextIsUnderline) {
            this.activeTextStyles.push("Underline");
        }
        if (this.currentSelectedTextHasLeftAlignment) {
            this.activeAlignment = StiHorizontalAlignment.Left;
        }
        if (this.currentSelectedTextHasCenterAlignment) {
            this.activeAlignment = StiHorizontalAlignment.Center;
        }
        if (this.currentSelectedTextHasRightAlignment) {
            this.activeAlignment = StiHorizontalAlignment.Right;
        }
    }
    execCommand(command, value) {
        this.getIframe().execCommand(command, false, value);
    }
    hexToRgb(hex) {
        const r = parseInt(hex.slice(1, 3), 16);
        const g = parseInt(hex.slice(3, 5), 16);
        const b = parseInt(hex.slice(5, 7), 16);
        return `${r}, ${g}, ${b}`;
    }
    getIframe() {
        let frameElement = document.getElementById("iframe" + this.model.selectedComponent?.element?.guid);
        let doc = frameElement?.contentWindow?.document;
        return doc ? doc : null;
    }
    insertBold() {
        this.execCommand("bold");
        this.currentSelectedTextIsBold = this.getIframe()?.queryCommandState("bold");
    }
    insertItalic() {
        this.execCommand("italic");
        this.currentSelectedTextIsItalic = this.getIframe()?.queryCommandState("italic");
    }
    insertUnderline() {
        this.execCommand("underline");
        this.currentSelectedTextIsUnderline = this.getIframe()?.queryCommandState("underline");
    }
    insertForeColor() {
        this.execCommand("foreColor", this.activeColor.toHexColor());
    }
    insertFontFamily(fontName) {
        this.execCommand("fontName", fontName);
    }
    /* useUndo() {
      this.execCommand("undo");
    }
    useRedo() {
      this.execCommand("redo");
    } */
    insertFontSize() {
        this.execCommand("fontSize", this.activeFontSize + "px");
    }
    setCenterAlignment() {
        this.execCommand("justifyCenter");
        this.currentSelectedTextHasCenterAlignment = this.getIframe()?.queryCommandState("justifyCenter");
    }
    setLeftAlignment() {
        this.execCommand("justifyLeft");
        this.currentSelectedTextHasLeftAlignment = this.getIframe()?.queryCommandState("justifyLeft");
    }
    setRightAlignment() {
        this.execCommand("justifyRight");
        this.currentSelectedTextHasRightAlignment = this.getIframe()?.queryCommandState("justifyRight");
    }
    convertSizeMmToHtmlSize(sizeMm) {
        if (sizeMm <= 8)
            return 1;
        else if (sizeMm > 8 && sizeMm <= 10)
            return 2;
        else if (sizeMm > 10 && sizeMm <= 12)
            return 3;
        else if (sizeMm > 12 && sizeMm <= 14)
            return 4;
        else if (sizeMm > 14 && sizeMm <= 18)
            return 5;
        else if (sizeMm > 18 && sizeMm <= 24)
            return 6;
        else if (sizeMm > 24)
            return 7;
        else
            return 3;
    }
    convertDocumentToForm(srcDoc) {
        let doc = document.implementation.createHTMLDocument();
        let newDocElement = doc.importNode(srcDoc.documentElement, true);
        doc.replaceChild(newDocElement, doc.documentElement);
        let tags = doc.getElementsByTagName("*");
        for (let i = 0; i < tags.length; i++) {
            let tag = tags[i];
            let size = tag.getAttribute("size");
            if (size) {
                tag.setAttribute("size", this.sizes[parseInt(size)]);
            }
            let fontSize = tag.style?.fontSize;
            if (fontSize && this.xSizes[fontSize]) {
                tag.style.fontSize = this.xSizes[fontSize] + "px";
            }
            let align = tag.getAttribute("align");
            if (align) {
                tag.style.textAlign = align;
                tag.removeAttribute("align");
            }
        }
        return doc.body.innerHTML.toString();
    }
    convertHtmlAttributesForWysiwyg(doc) {
        var tags = doc.getElementsByTagName("*");
        for (var i = 0; i < tags.length; i++) {
            var tag = tags[i];
            var size = tag.getAttribute("size");
            if (size) {
                var newSize = this.convertSizeMmToHtmlSize(parseInt(size));
                tag.setAttribute("size", newSize);
            }
        }
        for (var i = 0; i < tags.length; i++) {
            var tag = tags[i];
            if (tag.style) {
                if (this.getNavigatorName() == "MSIE" && tag.style.textAlign) {
                    tag.setAttribute("align", tag.style.textAlign.toLowerCase());
                    tag.style.textAlign = "";
                }
                if (tag.style.fontSize) {
                    var childs = [];
                    for (var k = 0; k < tag.childNodes.length; k++) {
                        childs.push(tag.childNodes[k]);
                    }
                    var font = document.createElement("font");
                    for (var k = 0; k < childs.length; k++) {
                        font.appendChild(childs[k]);
                    }
                    tag.appendChild(font);
                    font.setAttribute("size", this.convertSizeMmToHtmlSize(parseInt(tag.style.fontSize)).toString());
                    tag.style.fontSize = "";
                }
            }
        }
    }
    getNavigatorName() {
        var useragent = navigator.userAgent;
        var navigatorname = "Unknown";
        if (this.getIEVersion() > 0) {
            navigatorname = "MSIE";
        }
        else if (useragent.indexOf("Gecko") != -1) {
            if (useragent.indexOf("Chrome") != -1)
                navigatorname = "Google Chrome";
            else
                navigatorname = "Mozilla";
        }
        else if (useragent.indexOf("Mozilla") != -1) {
            navigatorname = "old Netscape or Mozilla";
        }
        else if (useragent.indexOf("Opera") != -1) {
            navigatorname = "Opera";
        }
        return navigatorname;
    }
    getIEVersion() {
        var sAgent = window.navigator.userAgent;
        var Idx = sAgent.indexOf("MSIE");
        // If IE, return version number.
        if (Idx > 0)
            return parseInt(sAgent.substring(Idx + 5, sAgent.indexOf(".", Idx)));
        // If IE 11 then look for Updated user agent string.
        // eslint-disable-next-line no-extra-boolean-cast
        else if (!!navigator.userAgent.match(/Trident\/7\./))
            return 11;
        else
            return 0; //It is not IE
    }
    initFont(htmlTextString) {
        if (htmlTextString?.length == 0) {
            setTimeout(() => {
                let label = this.model.form.settings.label;
                let font = label.font;
                this.activeFontFamily = font.family;
                this.activeFontSize = this.convertSizeMmToHtmlSize(font.size);
                this.activeColor = label.color.clone();
                //this.activeAlignment = label.alignment;
                this.insertFontFamily(font.family);
                this.insertFontSize();
                this.insertForeColor();
                font.style.forEach((style) => {
                    if (style == "Bold") {
                        this.insertBold();
                    }
                    else if (style == "Italic") {
                        this.insertItalic();
                    }
                    else if (style == "Underline") {
                        this.insertUnderline();
                    }
                });
            }, 0);
        }
    }
}
StiRichTextService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiRichTextService, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable });
StiRichTextService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiRichTextService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiRichTextService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLXJpY2gtdGV4dC5zZXJ2aWNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvc3RpbXVsc29mdC1mb3Jtcy9zcmMvbGliL3NlcnZpY2VzL3N0aS1yaWNoLXRleHQuc2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsVUFBVSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQzNDLE9BQU8sS0FBSyxNQUFNLGlCQUFpQixDQUFDO0FBQ3BDLE9BQU8sRUFBRSxzQkFBc0IsRUFBRSxNQUFNLGlCQUFpQixDQUFDOzs7QUFJekQsTUFBTSxPQUFPLGtCQUFrQjtJQXlCN0IsWUFBbUIsS0FBc0I7UUFBdEIsVUFBSyxHQUFMLEtBQUssQ0FBaUI7UUF4QmpDLFVBQUssR0FBRyxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsRUFBRSxDQUFDLEVBQUUsRUFBRSxFQUFFLENBQUMsRUFBRSxFQUFFLEVBQUUsQ0FBQyxFQUFFLEVBQUUsRUFBRSxDQUFDLEVBQUUsRUFBRSxFQUFFLENBQUMsRUFBRSxFQUFFLEVBQUUsQ0FBQztRQUMzRCxXQUFNLEdBQUc7WUFDZixTQUFTLEVBQUUsQ0FBQztZQUNaLEtBQUssRUFBRSxFQUFFO1lBQ1QsTUFBTSxFQUFFLEVBQUU7WUFDVixLQUFLLEVBQUUsRUFBRTtZQUNULFVBQVUsRUFBRSxFQUFFO1lBQ2QsVUFBVSxFQUFFLEVBQUU7WUFDZCxXQUFXLEVBQUUsRUFBRTtTQUNoQixDQUFDO1FBRUsscUJBQWdCLEdBQVUsRUFBRSxDQUFDO1FBRTdCLHFCQUFnQixHQUFHLE9BQU8sQ0FBQztRQUMzQixtQkFBYyxHQUFHLENBQUMsQ0FBQztRQUNuQixnQkFBVyxHQUFVLEtBQUssQ0FBQyxHQUFHLEVBQUUsQ0FBQztRQUVqQyw4QkFBeUIsR0FBWSxLQUFLLENBQUM7UUFDM0MsZ0NBQTJCLEdBQVksS0FBSyxDQUFDO1FBQzdDLG1DQUE4QixHQUFZLEtBQUssQ0FBQztRQUNoRCwwQ0FBcUMsR0FBWSxLQUFLLENBQUM7UUFDdkQsd0NBQW1DLEdBQVksS0FBSyxDQUFDO1FBQ3JELHlDQUFvQyxHQUFZLEtBQUssQ0FBQztJQUVqQixDQUFDO0lBRXRDLGdCQUFnQjtRQUNyQixJQUFJLENBQUMseUJBQXlCLEdBQUcsSUFBSSxDQUFDLFNBQVMsRUFBRSxFQUFFLGlCQUFpQixDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQzdFLElBQUksQ0FBQywyQkFBMkIsR0FBRyxJQUFJLENBQUMsU0FBUyxFQUFFLEVBQUUsaUJBQWlCLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDakYsSUFBSSxDQUFDLDhCQUE4QixHQUFHLElBQUksQ0FBQyxTQUFTLEVBQUUsRUFBRSxpQkFBaUIsQ0FBQyxXQUFXLENBQUMsQ0FBQztRQUN2RixJQUFJLENBQUMscUNBQXFDLEdBQUcsSUFBSSxDQUFDLFNBQVMsRUFBRSxFQUFFLGlCQUFpQixDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQ2xHLElBQUksQ0FBQyxtQ0FBbUMsR0FBRyxJQUFJLENBQUMsU0FBUyxFQUFFLEVBQUUsaUJBQWlCLENBQUMsYUFBYSxDQUFDLENBQUM7UUFDOUYsSUFBSSxDQUFDLG9DQUFvQyxHQUFHLElBQUksQ0FBQyxTQUFTLEVBQUUsRUFBRSxpQkFBaUIsQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUNoRyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLFNBQVMsRUFBRSxFQUFFLGlCQUFpQixDQUFDLFVBQVUsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDMUYsSUFBSSxDQUFDLGNBQWM7WUFDakIsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsRUFBRSxpQkFBaUIsQ0FBQyxVQUFVLENBQUMsQ0FBQyxHQUFHLENBQUM7Z0JBQ3pELENBQUMsQ0FBQyxJQUFJLENBQUMsdUJBQXVCLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsRUFBRSxpQkFBaUIsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO2dCQUN2RixDQUFDLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsRUFBRSxpQkFBaUIsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO1FBQzlELElBQUksSUFBSSxDQUFDLFNBQVMsRUFBRSxJQUFJLElBQUksRUFBRTtZQUM1QixJQUFJLFNBQVMsR0FBRyxJQUFJLENBQUMsU0FBUyxFQUFFLEVBQUUsaUJBQWlCLENBQUMsV0FBVyxDQUFDLENBQUM7WUFDakUsSUFBSSxTQUFTLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtnQkFDeEIsSUFBSSxLQUFLLEdBQUcsSUFBSSxLQUFLLEVBQUUsQ0FBQztnQkFDeEIsSUFBSSxJQUFJLENBQUMsU0FBUyxFQUFFLENBQUMsaUJBQWlCLENBQUMsV0FBVyxDQUFDLENBQUMsUUFBUSxDQUFDLEdBQUcsQ0FBQyxFQUFFO29CQUNqRSxLQUFLLEVBQUUscUJBQXFCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLEVBQUUsaUJBQWlCLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxDQUFDO2lCQUMvRjtxQkFBTTtvQkFDTCxLQUFLLEVBQUUscUJBQXFCLENBQzFCLElBQUksQ0FBQyxTQUFTLEVBQUUsQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLENBQUMsQ0FBQyxPQUFPLENBQUMsTUFBTSxFQUFFLEVBQUUsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUFDLENBQ3JGLENBQUM7aUJBQ0g7Z0JBQ0QsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUM7YUFDMUI7U0FDRjtRQUNELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxFQUFFLENBQUM7UUFDM0IsSUFBSSxJQUFJLENBQUMseUJBQXlCLEVBQUU7WUFDbEMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztTQUNwQztRQUNELElBQUksSUFBSSxDQUFDLDJCQUEyQixFQUFFO1lBQ3BDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7U0FDdEM7UUFFRCxJQUFJLElBQUksQ0FBQyw4QkFBOEIsRUFBRTtZQUN2QyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1NBQ3pDO1FBQ0QsSUFBSSxJQUFJLENBQUMsbUNBQW1DLEVBQUU7WUFDNUMsSUFBSSxDQUFDLGVBQWUsR0FBRyxzQkFBc0IsQ0FBQyxJQUFJLENBQUM7U0FDcEQ7UUFFRCxJQUFJLElBQUksQ0FBQyxxQ0FBcUMsRUFBRTtZQUM5QyxJQUFJLENBQUMsZUFBZSxHQUFHLHNCQUFzQixDQUFDLE1BQU0sQ0FBQztTQUN0RDtRQUVELElBQUksSUFBSSxDQUFDLG9DQUFvQyxFQUFFO1lBQzdDLElBQUksQ0FBQyxlQUFlLEdBQUcsc0JBQXNCLENBQUMsS0FBSyxDQUFDO1NBQ3JEO0lBQ0gsQ0FBQztJQUVELFdBQVcsQ0FBQyxPQUFlLEVBQUUsS0FBYztRQUN6QyxJQUFJLENBQUMsU0FBUyxFQUFFLENBQUMsV0FBVyxDQUFDLE9BQU8sRUFBRSxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUNELFFBQVEsQ0FBQyxHQUFHO1FBQ1YsTUFBTSxDQUFDLEdBQUcsUUFBUSxDQUFDLEdBQUcsQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ3hDLE1BQU0sQ0FBQyxHQUFHLFFBQVEsQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUN4QyxNQUFNLENBQUMsR0FBRyxRQUFRLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDeEMsT0FBTyxHQUFHLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUM7SUFDNUIsQ0FBQztJQUNELFNBQVM7UUFDUCxJQUFJLFlBQVksR0FBRyxRQUFRLENBQUMsY0FBYyxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixFQUFFLE9BQU8sRUFBRSxJQUFJLENBQVEsQ0FBQztRQUMxRyxJQUFJLEdBQUcsR0FBRyxZQUFZLEVBQUUsYUFBYSxFQUFFLFFBQVEsQ0FBQztRQUNoRCxPQUFPLEdBQUcsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUM7SUFDMUIsQ0FBQztJQUNELFVBQVU7UUFDUixJQUFJLENBQUMsV0FBVyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3pCLElBQUksQ0FBQyx5QkFBeUIsR0FBRyxJQUFJLENBQUMsU0FBUyxFQUFFLEVBQUUsaUJBQWlCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDL0UsQ0FBQztJQUNELFlBQVk7UUFDVixJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQzNCLElBQUksQ0FBQywyQkFBMkIsR0FBRyxJQUFJLENBQUMsU0FBUyxFQUFFLEVBQUUsaUJBQWlCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDbkYsQ0FBQztJQUNELGVBQWU7UUFDYixJQUFJLENBQUMsV0FBVyxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQzlCLElBQUksQ0FBQyw4QkFBOEIsR0FBRyxJQUFJLENBQUMsU0FBUyxFQUFFLEVBQUUsaUJBQWlCLENBQUMsV0FBVyxDQUFDLENBQUM7SUFDekYsQ0FBQztJQUNELGVBQWU7UUFDYixJQUFJLENBQUMsV0FBVyxDQUFDLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVyxDQUFDLFVBQVUsRUFBRSxDQUFDLENBQUM7SUFDL0QsQ0FBQztJQUNELGdCQUFnQixDQUFDLFFBQVE7UUFDdkIsSUFBSSxDQUFDLFdBQVcsQ0FBQyxVQUFVLEVBQUUsUUFBUSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUNEOzs7OztRQUtJO0lBQ0osY0FBYztRQUNaLElBQUksQ0FBQyxXQUFXLENBQUMsVUFBVSxFQUFFLElBQUksQ0FBQyxjQUFjLEdBQUcsSUFBSSxDQUFDLENBQUM7SUFDM0QsQ0FBQztJQUNELGtCQUFrQjtRQUNoQixJQUFJLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQ2xDLElBQUksQ0FBQyxxQ0FBcUMsR0FBRyxJQUFJLENBQUMsU0FBUyxFQUFFLEVBQUUsaUJBQWlCLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDcEcsQ0FBQztJQUNELGdCQUFnQjtRQUNkLElBQUksQ0FBQyxXQUFXLENBQUMsYUFBYSxDQUFDLENBQUM7UUFDaEMsSUFBSSxDQUFDLG1DQUFtQyxHQUFHLElBQUksQ0FBQyxTQUFTLEVBQUUsRUFBRSxpQkFBaUIsQ0FBQyxhQUFhLENBQUMsQ0FBQztJQUNoRyxDQUFDO0lBQ0QsaUJBQWlCO1FBQ2YsSUFBSSxDQUFDLFdBQVcsQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUNqQyxJQUFJLENBQUMsb0NBQW9DLEdBQUcsSUFBSSxDQUFDLFNBQVMsRUFBRSxFQUFFLGlCQUFpQixDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ2xHLENBQUM7SUFDRCx1QkFBdUIsQ0FBQyxNQUFjO1FBQ3BDLElBQUksTUFBTSxJQUFJLENBQUM7WUFBRSxPQUFPLENBQUMsQ0FBQzthQUNyQixJQUFJLE1BQU0sR0FBRyxDQUFDLElBQUksTUFBTSxJQUFJLEVBQUU7WUFBRSxPQUFPLENBQUMsQ0FBQzthQUN6QyxJQUFJLE1BQU0sR0FBRyxFQUFFLElBQUksTUFBTSxJQUFJLEVBQUU7WUFBRSxPQUFPLENBQUMsQ0FBQzthQUMxQyxJQUFJLE1BQU0sR0FBRyxFQUFFLElBQUksTUFBTSxJQUFJLEVBQUU7WUFBRSxPQUFPLENBQUMsQ0FBQzthQUMxQyxJQUFJLE1BQU0sR0FBRyxFQUFFLElBQUksTUFBTSxJQUFJLEVBQUU7WUFBRSxPQUFPLENBQUMsQ0FBQzthQUMxQyxJQUFJLE1BQU0sR0FBRyxFQUFFLElBQUksTUFBTSxJQUFJLEVBQUU7WUFBRSxPQUFPLENBQUMsQ0FBQzthQUMxQyxJQUFJLE1BQU0sR0FBRyxFQUFFO1lBQUUsT0FBTyxDQUFDLENBQUM7O1lBQzFCLE9BQU8sQ0FBQyxDQUFDO0lBQ2hCLENBQUM7SUFFRCxxQkFBcUIsQ0FBQyxNQUFXO1FBQy9CLElBQUksR0FBRyxHQUFHLFFBQVEsQ0FBQyxjQUFjLENBQUMsa0JBQWtCLEVBQUUsQ0FBQztRQUN2RCxJQUFJLGFBQWEsR0FBRyxHQUFHLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxlQUFlLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDakUsR0FBRyxDQUFDLFlBQVksQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBRXJELElBQUksSUFBSSxHQUFHLEdBQUcsQ0FBQyxvQkFBb0IsQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUN6QyxLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDLEVBQUUsRUFBRTtZQUNwQyxJQUFJLEdBQUcsR0FBRyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDbEIsSUFBSSxJQUFJLEdBQUcsR0FBRyxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsQ0FBQztZQUNwQyxJQUFJLElBQUksRUFBRTtnQkFDUixHQUFHLENBQUMsWUFBWSxDQUFDLE1BQU0sRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7YUFDdEQ7WUFDRCxJQUFJLFFBQVEsR0FBSSxHQUFXLENBQUMsS0FBSyxFQUFFLFFBQVEsQ0FBQztZQUM1QyxJQUFJLFFBQVEsSUFBSSxJQUFJLENBQUMsTUFBTSxDQUFDLFFBQVEsQ0FBQyxFQUFFO2dCQUNwQyxHQUFXLENBQUMsS0FBSyxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLFFBQVEsQ0FBQyxHQUFHLElBQUksQ0FBQzthQUM1RDtZQUVELElBQUksS0FBSyxHQUFHLEdBQUcsQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDLENBQUM7WUFDdEMsSUFBSSxLQUFLLEVBQUU7Z0JBQ1IsR0FBVyxDQUFDLEtBQUssQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDO2dCQUNyQyxHQUFHLENBQUMsZUFBZSxDQUFDLE9BQU8sQ0FBQyxDQUFDO2FBQzlCO1NBQ0Y7UUFFRCxPQUFPLEdBQUcsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLFFBQVEsRUFBRSxDQUFDO0lBQ3ZDLENBQUM7SUFFRCwrQkFBK0IsQ0FBQyxHQUFHO1FBQ2pDLElBQUksSUFBSSxHQUFHLEdBQUcsQ0FBQyxvQkFBb0IsQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUN6QyxLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDLEVBQUUsRUFBRTtZQUNwQyxJQUFJLEdBQUcsR0FBRyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDbEIsSUFBSSxJQUFJLEdBQUcsR0FBRyxDQUFDLFlBQVksQ0FBQyxNQUFNLENBQUMsQ0FBQztZQUNwQyxJQUFJLElBQUksRUFBRTtnQkFDUixJQUFJLE9BQU8sR0FBRyxJQUFJLENBQUMsdUJBQXVCLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7Z0JBQzNELEdBQUcsQ0FBQyxZQUFZLENBQUMsTUFBTSxFQUFFLE9BQU8sQ0FBQyxDQUFDO2FBQ25DO1NBQ0Y7UUFDRCxLQUFLLElBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEdBQUcsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDLEVBQUUsRUFBRTtZQUNwQyxJQUFJLEdBQUcsR0FBRyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDbEIsSUFBSSxHQUFHLENBQUMsS0FBSyxFQUFFO2dCQUNiLElBQUksSUFBSSxDQUFDLGdCQUFnQixFQUFFLElBQUksTUFBTSxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsU0FBUyxFQUFFO29CQUM1RCxHQUFHLENBQUMsWUFBWSxDQUFDLE9BQU8sRUFBRSxHQUFHLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxXQUFXLEVBQUUsQ0FBQyxDQUFDO29CQUM3RCxHQUFHLENBQUMsS0FBSyxDQUFDLFNBQVMsR0FBRyxFQUFFLENBQUM7aUJBQzFCO2dCQUNELElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUU7b0JBQ3RCLElBQUksTUFBTSxHQUFHLEVBQUUsQ0FBQztvQkFDaEIsS0FBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLEdBQUcsQ0FBQyxVQUFVLENBQUMsTUFBTSxFQUFFLENBQUMsRUFBRSxFQUFFO3dCQUM5QyxNQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztxQkFDaEM7b0JBQ0QsSUFBSSxJQUFJLEdBQUcsUUFBUSxDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUMsQ0FBQztvQkFDMUMsS0FBSyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLE1BQU0sQ0FBQyxNQUFNLEVBQUUsQ0FBQyxFQUFFLEVBQUU7d0JBQ3RDLElBQUksQ0FBQyxXQUFXLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7cUJBQzdCO29CQUNELEdBQUcsQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLENBQUM7b0JBQ3RCLElBQUksQ0FBQyxZQUFZLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLFFBQVEsRUFBRSxDQUFDLENBQUM7b0JBQ2pHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxHQUFHLEVBQUUsQ0FBQztpQkFDekI7YUFDRjtTQUNGO0lBQ0gsQ0FBQztJQUVELGdCQUFnQjtRQUNkLElBQUksU0FBUyxHQUFHLFNBQVMsQ0FBQyxTQUFTLENBQUM7UUFDcEMsSUFBSSxhQUFhLEdBQUcsU0FBUyxDQUFDO1FBQzlCLElBQUksSUFBSSxDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsRUFBRTtZQUMzQixhQUFhLEdBQUcsTUFBTSxDQUFDO1NBQ3hCO2FBQU0sSUFBSSxTQUFTLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQyxFQUFFO1lBQzNDLElBQUksU0FBUyxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7Z0JBQUUsYUFBYSxHQUFHLGVBQWUsQ0FBQzs7Z0JBQ2xFLGFBQWEsR0FBRyxTQUFTLENBQUM7U0FDaEM7YUFBTSxJQUFJLFNBQVMsQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxDQUFDLEVBQUU7WUFDN0MsYUFBYSxHQUFHLHlCQUF5QixDQUFDO1NBQzNDO2FBQU0sSUFBSSxTQUFTLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQyxFQUFFO1lBQzNDLGFBQWEsR0FBRyxPQUFPLENBQUM7U0FDekI7UUFFRCxPQUFPLGFBQWEsQ0FBQztJQUN2QixDQUFDO0lBRUQsWUFBWTtRQUNWLElBQUksTUFBTSxHQUFHLE1BQU0sQ0FBQyxTQUFTLENBQUMsU0FBUyxDQUFDO1FBQ3hDLElBQUksR0FBRyxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUM7UUFFakMsZ0NBQWdDO1FBQ2hDLElBQUksR0FBRyxHQUFHLENBQUM7WUFBRSxPQUFPLFFBQVEsQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLEdBQUcsR0FBRyxDQUFDLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDO1FBQ2xGLG9EQUFvRDtRQUNwRCxpREFBaUQ7YUFDNUMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsY0FBYyxDQUFDO1lBQUUsT0FBTyxFQUFFLENBQUM7O1lBQzNELE9BQU8sQ0FBQyxDQUFDLENBQUMsY0FBYztJQUMvQixDQUFDO0lBRUQsUUFBUSxDQUFDLGNBQXNCO1FBQzdCLElBQUksY0FBYyxFQUFFLE1BQU0sSUFBSSxDQUFDLEVBQUU7WUFDL0IsVUFBVSxDQUFDLEdBQUcsRUFBRTtnQkFDZCxJQUFJLEtBQUssR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDO2dCQUMzQyxJQUFJLElBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO2dCQUN0QixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQztnQkFDcEMsSUFBSSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsdUJBQXVCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO2dCQUM5RCxJQUFJLENBQUMsV0FBVyxHQUFHLEtBQUssQ0FBQyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBQ3ZDLHlDQUF5QztnQkFFekMsSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztnQkFDbkMsSUFBSSxDQUFDLGNBQWMsRUFBRSxDQUFDO2dCQUN0QixJQUFJLENBQUMsZUFBZSxFQUFFLENBQUM7Z0JBQ3ZCLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLENBQUMsS0FBSyxFQUFFLEVBQUU7b0JBQzNCLElBQUksS0FBSyxJQUFJLE1BQU0sRUFBRTt3QkFDbkIsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDO3FCQUNuQjt5QkFBTSxJQUFJLEtBQUssSUFBSSxRQUFRLEVBQUU7d0JBQzVCLElBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQztxQkFDckI7eUJBQU0sSUFBSSxLQUFLLElBQUksV0FBVyxFQUFFO3dCQUMvQixJQUFJLENBQUMsZUFBZSxFQUFFLENBQUM7cUJBQ3hCO2dCQUNILENBQUMsQ0FBQyxDQUFDO1lBQ0wsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO1NBQ1A7SUFDSCxDQUFDOzsrR0EvUFUsa0JBQWtCO21IQUFsQixrQkFBa0I7MkZBQWxCLGtCQUFrQjtrQkFEOUIsVUFBVSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEluamVjdGFibGUgfSBmcm9tIFwiQGFuZ3VsYXIvY29yZVwiO1xyXG5pbXBvcnQgQ29sb3IgZnJvbSBcIi4uL3N5c3RlbS9Db2xvclwiO1xyXG5pbXBvcnQgeyBTdGlIb3Jpem9udGFsQWxpZ25tZW50IH0gZnJvbSBcIi4uL3N5c3RlbS9lbnVtc1wiO1xyXG5pbXBvcnQgeyBTdGlNb2RlbFNlcnZpY2UgfSBmcm9tIFwiLi9tb2RlbC5zZXJ2aWNlXCI7XHJcblxyXG5ASW5qZWN0YWJsZSgpXHJcbmV4cG9ydCBjbGFzcyBTdGlSaWNoVGV4dFNlcnZpY2Uge1xyXG4gIHByaXZhdGUgc2l6ZXMgPSB7IDE6IDgsIDI6IDEwLCAzOiAxMiwgNDogMTQsIDU6IDE4LCA2OiAyNCwgNzogMzYgfTtcclxuICBwcml2YXRlIHhTaXplcyA9IHtcclxuICAgIFwieC1zbWFsbFwiOiA4LFxyXG4gICAgc21hbGw6IDEwLFxyXG4gICAgbWVkaXVtOiAxMixcclxuICAgIGxhcmdlOiAxNCxcclxuICAgIFwieC1sYXJnZVx0XCI6IDE4LFxyXG4gICAgXCJ4eC1sYXJnZVwiOiAyNCxcclxuICAgIFwieHh4LWxhcmdlXCI6IDM2LFxyXG4gIH07XHJcblxyXG4gIHB1YmxpYyBhY3RpdmVUZXh0U3R5bGVzOiBhbnlbXSA9IFtdO1xyXG4gIHB1YmxpYyBhY3RpdmVBbGlnbm1lbnQ6IFN0aUhvcml6b250YWxBbGlnbm1lbnQ7XHJcbiAgcHVibGljIGFjdGl2ZUZvbnRGYW1pbHkgPSBcIkFyaWFsXCI7XHJcbiAgcHVibGljIGFjdGl2ZUZvbnRTaXplID0gMztcclxuICBwdWJsaWMgYWN0aXZlQ29sb3I6IENvbG9yID0gQ29sb3IucmVkKCk7XHJcblxyXG4gIHB1YmxpYyBjdXJyZW50U2VsZWN0ZWRUZXh0SXNCb2xkOiBib29sZWFuID0gZmFsc2U7XHJcbiAgcHVibGljIGN1cnJlbnRTZWxlY3RlZFRleHRJc0l0YWxpYzogYm9vbGVhbiA9IGZhbHNlO1xyXG4gIHB1YmxpYyBjdXJyZW50U2VsZWN0ZWRUZXh0SXNVbmRlcmxpbmU6IGJvb2xlYW4gPSBmYWxzZTtcclxuICBwdWJsaWMgY3VycmVudFNlbGVjdGVkVGV4dEhhc0NlbnRlckFsaWdubWVudDogYm9vbGVhbiA9IGZhbHNlO1xyXG4gIHB1YmxpYyBjdXJyZW50U2VsZWN0ZWRUZXh0SGFzTGVmdEFsaWdubWVudDogYm9vbGVhbiA9IGZhbHNlO1xyXG4gIHB1YmxpYyBjdXJyZW50U2VsZWN0ZWRUZXh0SGFzUmlnaHRBbGlnbm1lbnQ6IGJvb2xlYW4gPSBmYWxzZTtcclxuXHJcbiAgY29uc3RydWN0b3IocHVibGljIG1vZGVsOiBTdGlNb2RlbFNlcnZpY2UpIHt9XHJcblxyXG4gIHB1YmxpYyBzaG93Q3VycmVudFN0YXRlKCkge1xyXG4gICAgdGhpcy5jdXJyZW50U2VsZWN0ZWRUZXh0SXNCb2xkID0gdGhpcy5nZXRJZnJhbWUoKT8ucXVlcnlDb21tYW5kU3RhdGUoXCJib2xkXCIpO1xyXG4gICAgdGhpcy5jdXJyZW50U2VsZWN0ZWRUZXh0SXNJdGFsaWMgPSB0aGlzLmdldElmcmFtZSgpPy5xdWVyeUNvbW1hbmRTdGF0ZShcIml0YWxpY1wiKTtcclxuICAgIHRoaXMuY3VycmVudFNlbGVjdGVkVGV4dElzVW5kZXJsaW5lID0gdGhpcy5nZXRJZnJhbWUoKT8ucXVlcnlDb21tYW5kU3RhdGUoXCJ1bmRlcmxpbmVcIik7XHJcbiAgICB0aGlzLmN1cnJlbnRTZWxlY3RlZFRleHRIYXNDZW50ZXJBbGlnbm1lbnQgPSB0aGlzLmdldElmcmFtZSgpPy5xdWVyeUNvbW1hbmRTdGF0ZShcImp1c3RpZnlDZW50ZXJcIik7XHJcbiAgICB0aGlzLmN1cnJlbnRTZWxlY3RlZFRleHRIYXNMZWZ0QWxpZ25tZW50ID0gdGhpcy5nZXRJZnJhbWUoKT8ucXVlcnlDb21tYW5kU3RhdGUoXCJqdXN0aWZ5TGVmdFwiKTtcclxuICAgIHRoaXMuY3VycmVudFNlbGVjdGVkVGV4dEhhc1JpZ2h0QWxpZ25tZW50ID0gdGhpcy5nZXRJZnJhbWUoKT8ucXVlcnlDb21tYW5kU3RhdGUoXCJqdXN0aWZ5UmlnaHRcIik7XHJcbiAgICB0aGlzLmFjdGl2ZUZvbnRGYW1pbHkgPSB0aGlzLmdldElmcmFtZSgpPy5xdWVyeUNvbW1hbmRWYWx1ZShcIkZvbnROYW1lXCIpLnJlcGxhY2UoL1wiL2csIFwiXCIpO1xyXG4gICAgdGhpcy5hY3RpdmVGb250U2l6ZSA9XHJcbiAgICAgIE51bWJlcih0aGlzLmdldElmcmFtZSgpPy5xdWVyeUNvbW1hbmRWYWx1ZShcIkZvbnRTaXplXCIpKSA+IDdcclxuICAgICAgICA/IHRoaXMuY29udmVydFNpemVNbVRvSHRtbFNpemUoTnVtYmVyKHRoaXMuZ2V0SWZyYW1lKCk/LnF1ZXJ5Q29tbWFuZFZhbHVlKFwiRm9udFNpemVcIikpKVxyXG4gICAgICAgIDogTnVtYmVyKHRoaXMuZ2V0SWZyYW1lKCk/LnF1ZXJ5Q29tbWFuZFZhbHVlKFwiRm9udFNpemVcIikpO1xyXG4gICAgaWYgKHRoaXMuZ2V0SWZyYW1lKCkgIT0gbnVsbCkge1xyXG4gICAgICBsZXQgZm9yZUNvbG9yID0gdGhpcy5nZXRJZnJhbWUoKT8ucXVlcnlDb21tYW5kVmFsdWUoXCJGb3JlQ29sb3JcIik7XHJcbiAgICAgIGlmIChmb3JlQ29sb3IubGVuZ3RoID4gMCkge1xyXG4gICAgICAgIGxldCBjb2xvciA9IG5ldyBDb2xvcigpO1xyXG4gICAgICAgIGlmICh0aGlzLmdldElmcmFtZSgpLnF1ZXJ5Q29tbWFuZFZhbHVlKFwiRm9yZUNvbG9yXCIpLmluY2x1ZGVzKFwiI1wiKSkge1xyXG4gICAgICAgICAgY29sb3I/LmRlc2VyaWFsaXplRnJvbVN0cmluZyh0aGlzLmhleFRvUmdiKHRoaXMuZ2V0SWZyYW1lKCk/LnF1ZXJ5Q29tbWFuZFZhbHVlKFwiRm9yZUNvbG9yXCIpKSk7XHJcbiAgICAgICAgfSBlbHNlIHtcclxuICAgICAgICAgIGNvbG9yPy5kZXNlcmlhbGl6ZUZyb21TdHJpbmcoXHJcbiAgICAgICAgICAgIHRoaXMuZ2V0SWZyYW1lKCkucXVlcnlDb21tYW5kVmFsdWUoXCJGb3JlQ29sb3JcIikucmVwbGFjZShcInJnYihcIiwgXCJcIikucmVwbGFjZShcIilcIiwgXCJcIilcclxuICAgICAgICAgICk7XHJcbiAgICAgICAgfVxyXG4gICAgICAgIHRoaXMuYWN0aXZlQ29sb3IgPSBjb2xvcjtcclxuICAgICAgfVxyXG4gICAgfVxyXG4gICAgdGhpcy5hY3RpdmVUZXh0U3R5bGVzID0gW107XHJcbiAgICBpZiAodGhpcy5jdXJyZW50U2VsZWN0ZWRUZXh0SXNCb2xkKSB7XHJcbiAgICAgIHRoaXMuYWN0aXZlVGV4dFN0eWxlcy5wdXNoKFwiQm9sZFwiKTtcclxuICAgIH1cclxuICAgIGlmICh0aGlzLmN1cnJlbnRTZWxlY3RlZFRleHRJc0l0YWxpYykge1xyXG4gICAgICB0aGlzLmFjdGl2ZVRleHRTdHlsZXMucHVzaChcIkl0YWxpY1wiKTtcclxuICAgIH1cclxuXHJcbiAgICBpZiAodGhpcy5jdXJyZW50U2VsZWN0ZWRUZXh0SXNVbmRlcmxpbmUpIHtcclxuICAgICAgdGhpcy5hY3RpdmVUZXh0U3R5bGVzLnB1c2goXCJVbmRlcmxpbmVcIik7XHJcbiAgICB9XHJcbiAgICBpZiAodGhpcy5jdXJyZW50U2VsZWN0ZWRUZXh0SGFzTGVmdEFsaWdubWVudCkge1xyXG4gICAgICB0aGlzLmFjdGl2ZUFsaWdubWVudCA9IFN0aUhvcml6b250YWxBbGlnbm1lbnQuTGVmdDtcclxuICAgIH1cclxuXHJcbiAgICBpZiAodGhpcy5jdXJyZW50U2VsZWN0ZWRUZXh0SGFzQ2VudGVyQWxpZ25tZW50KSB7XHJcbiAgICAgIHRoaXMuYWN0aXZlQWxpZ25tZW50ID0gU3RpSG9yaXpvbnRhbEFsaWdubWVudC5DZW50ZXI7XHJcbiAgICB9XHJcblxyXG4gICAgaWYgKHRoaXMuY3VycmVudFNlbGVjdGVkVGV4dEhhc1JpZ2h0QWxpZ25tZW50KSB7XHJcbiAgICAgIHRoaXMuYWN0aXZlQWxpZ25tZW50ID0gU3RpSG9yaXpvbnRhbEFsaWdubWVudC5SaWdodDtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIGV4ZWNDb21tYW5kKGNvbW1hbmQ6IHN0cmluZywgdmFsdWU/OiBzdHJpbmcpIHtcclxuICAgIHRoaXMuZ2V0SWZyYW1lKCkuZXhlY0NvbW1hbmQoY29tbWFuZCwgZmFsc2UsIHZhbHVlKTtcclxuICB9XHJcbiAgaGV4VG9SZ2IoaGV4KSB7XHJcbiAgICBjb25zdCByID0gcGFyc2VJbnQoaGV4LnNsaWNlKDEsIDMpLCAxNik7XHJcbiAgICBjb25zdCBnID0gcGFyc2VJbnQoaGV4LnNsaWNlKDMsIDUpLCAxNik7XHJcbiAgICBjb25zdCBiID0gcGFyc2VJbnQoaGV4LnNsaWNlKDUsIDcpLCAxNik7XHJcbiAgICByZXR1cm4gYCR7cn0sICR7Z30sICR7Yn1gO1xyXG4gIH1cclxuICBnZXRJZnJhbWUoKSB7XHJcbiAgICBsZXQgZnJhbWVFbGVtZW50ID0gZG9jdW1lbnQuZ2V0RWxlbWVudEJ5SWQoXCJpZnJhbWVcIiArIHRoaXMubW9kZWwuc2VsZWN0ZWRDb21wb25lbnQ/LmVsZW1lbnQ/Lmd1aWQpIGFzIGFueTtcclxuICAgIGxldCBkb2MgPSBmcmFtZUVsZW1lbnQ/LmNvbnRlbnRXaW5kb3c/LmRvY3VtZW50O1xyXG4gICAgcmV0dXJuIGRvYyA/IGRvYyA6IG51bGw7XHJcbiAgfVxyXG4gIGluc2VydEJvbGQoKSB7XHJcbiAgICB0aGlzLmV4ZWNDb21tYW5kKFwiYm9sZFwiKTtcclxuICAgIHRoaXMuY3VycmVudFNlbGVjdGVkVGV4dElzQm9sZCA9IHRoaXMuZ2V0SWZyYW1lKCk/LnF1ZXJ5Q29tbWFuZFN0YXRlKFwiYm9sZFwiKTtcclxuICB9XHJcbiAgaW5zZXJ0SXRhbGljKCkge1xyXG4gICAgdGhpcy5leGVjQ29tbWFuZChcIml0YWxpY1wiKTtcclxuICAgIHRoaXMuY3VycmVudFNlbGVjdGVkVGV4dElzSXRhbGljID0gdGhpcy5nZXRJZnJhbWUoKT8ucXVlcnlDb21tYW5kU3RhdGUoXCJpdGFsaWNcIik7XHJcbiAgfVxyXG4gIGluc2VydFVuZGVybGluZSgpIHtcclxuICAgIHRoaXMuZXhlY0NvbW1hbmQoXCJ1bmRlcmxpbmVcIik7XHJcbiAgICB0aGlzLmN1cnJlbnRTZWxlY3RlZFRleHRJc1VuZGVybGluZSA9IHRoaXMuZ2V0SWZyYW1lKCk/LnF1ZXJ5Q29tbWFuZFN0YXRlKFwidW5kZXJsaW5lXCIpO1xyXG4gIH1cclxuICBpbnNlcnRGb3JlQ29sb3IoKSB7XHJcbiAgICB0aGlzLmV4ZWNDb21tYW5kKFwiZm9yZUNvbG9yXCIsIHRoaXMuYWN0aXZlQ29sb3IudG9IZXhDb2xvcigpKTtcclxuICB9XHJcbiAgaW5zZXJ0Rm9udEZhbWlseShmb250TmFtZSkge1xyXG4gICAgdGhpcy5leGVjQ29tbWFuZChcImZvbnROYW1lXCIsIGZvbnROYW1lKTtcclxuICB9XHJcbiAgLyogdXNlVW5kbygpIHtcclxuICAgIHRoaXMuZXhlY0NvbW1hbmQoXCJ1bmRvXCIpO1xyXG4gIH1cclxuICB1c2VSZWRvKCkge1xyXG4gICAgdGhpcy5leGVjQ29tbWFuZChcInJlZG9cIik7XHJcbiAgfSAqL1xyXG4gIGluc2VydEZvbnRTaXplKCkge1xyXG4gICAgdGhpcy5leGVjQ29tbWFuZChcImZvbnRTaXplXCIsIHRoaXMuYWN0aXZlRm9udFNpemUgKyBcInB4XCIpO1xyXG4gIH1cclxuICBzZXRDZW50ZXJBbGlnbm1lbnQoKSB7XHJcbiAgICB0aGlzLmV4ZWNDb21tYW5kKFwianVzdGlmeUNlbnRlclwiKTtcclxuICAgIHRoaXMuY3VycmVudFNlbGVjdGVkVGV4dEhhc0NlbnRlckFsaWdubWVudCA9IHRoaXMuZ2V0SWZyYW1lKCk/LnF1ZXJ5Q29tbWFuZFN0YXRlKFwianVzdGlmeUNlbnRlclwiKTtcclxuICB9XHJcbiAgc2V0TGVmdEFsaWdubWVudCgpIHtcclxuICAgIHRoaXMuZXhlY0NvbW1hbmQoXCJqdXN0aWZ5TGVmdFwiKTtcclxuICAgIHRoaXMuY3VycmVudFNlbGVjdGVkVGV4dEhhc0xlZnRBbGlnbm1lbnQgPSB0aGlzLmdldElmcmFtZSgpPy5xdWVyeUNvbW1hbmRTdGF0ZShcImp1c3RpZnlMZWZ0XCIpO1xyXG4gIH1cclxuICBzZXRSaWdodEFsaWdubWVudCgpIHtcclxuICAgIHRoaXMuZXhlY0NvbW1hbmQoXCJqdXN0aWZ5UmlnaHRcIik7XHJcbiAgICB0aGlzLmN1cnJlbnRTZWxlY3RlZFRleHRIYXNSaWdodEFsaWdubWVudCA9IHRoaXMuZ2V0SWZyYW1lKCk/LnF1ZXJ5Q29tbWFuZFN0YXRlKFwianVzdGlmeVJpZ2h0XCIpO1xyXG4gIH1cclxuICBjb252ZXJ0U2l6ZU1tVG9IdG1sU2l6ZShzaXplTW06IG51bWJlcik6IG51bWJlciB7XHJcbiAgICBpZiAoc2l6ZU1tIDw9IDgpIHJldHVybiAxO1xyXG4gICAgZWxzZSBpZiAoc2l6ZU1tID4gOCAmJiBzaXplTW0gPD0gMTApIHJldHVybiAyO1xyXG4gICAgZWxzZSBpZiAoc2l6ZU1tID4gMTAgJiYgc2l6ZU1tIDw9IDEyKSByZXR1cm4gMztcclxuICAgIGVsc2UgaWYgKHNpemVNbSA+IDEyICYmIHNpemVNbSA8PSAxNCkgcmV0dXJuIDQ7XHJcbiAgICBlbHNlIGlmIChzaXplTW0gPiAxNCAmJiBzaXplTW0gPD0gMTgpIHJldHVybiA1O1xyXG4gICAgZWxzZSBpZiAoc2l6ZU1tID4gMTggJiYgc2l6ZU1tIDw9IDI0KSByZXR1cm4gNjtcclxuICAgIGVsc2UgaWYgKHNpemVNbSA+IDI0KSByZXR1cm4gNztcclxuICAgIGVsc2UgcmV0dXJuIDM7XHJcbiAgfVxyXG5cclxuICBjb252ZXJ0RG9jdW1lbnRUb0Zvcm0oc3JjRG9jOiBhbnkpOiBzdHJpbmcge1xyXG4gICAgbGV0IGRvYyA9IGRvY3VtZW50LmltcGxlbWVudGF0aW9uLmNyZWF0ZUhUTUxEb2N1bWVudCgpO1xyXG4gICAgbGV0IG5ld0RvY0VsZW1lbnQgPSBkb2MuaW1wb3J0Tm9kZShzcmNEb2MuZG9jdW1lbnRFbGVtZW50LCB0cnVlKTtcclxuICAgIGRvYy5yZXBsYWNlQ2hpbGQobmV3RG9jRWxlbWVudCwgZG9jLmRvY3VtZW50RWxlbWVudCk7XHJcblxyXG4gICAgbGV0IHRhZ3MgPSBkb2MuZ2V0RWxlbWVudHNCeVRhZ05hbWUoXCIqXCIpO1xyXG4gICAgZm9yIChsZXQgaSA9IDA7IGkgPCB0YWdzLmxlbmd0aDsgaSsrKSB7XHJcbiAgICAgIGxldCB0YWcgPSB0YWdzW2ldO1xyXG4gICAgICBsZXQgc2l6ZSA9IHRhZy5nZXRBdHRyaWJ1dGUoXCJzaXplXCIpO1xyXG4gICAgICBpZiAoc2l6ZSkge1xyXG4gICAgICAgIHRhZy5zZXRBdHRyaWJ1dGUoXCJzaXplXCIsIHRoaXMuc2l6ZXNbcGFyc2VJbnQoc2l6ZSldKTtcclxuICAgICAgfVxyXG4gICAgICBsZXQgZm9udFNpemUgPSAodGFnIGFzIGFueSkuc3R5bGU/LmZvbnRTaXplO1xyXG4gICAgICBpZiAoZm9udFNpemUgJiYgdGhpcy54U2l6ZXNbZm9udFNpemVdKSB7XHJcbiAgICAgICAgKHRhZyBhcyBhbnkpLnN0eWxlLmZvbnRTaXplID0gdGhpcy54U2l6ZXNbZm9udFNpemVdICsgXCJweFwiO1xyXG4gICAgICB9XHJcblxyXG4gICAgICBsZXQgYWxpZ24gPSB0YWcuZ2V0QXR0cmlidXRlKFwiYWxpZ25cIik7XHJcbiAgICAgIGlmIChhbGlnbikge1xyXG4gICAgICAgICh0YWcgYXMgYW55KS5zdHlsZS50ZXh0QWxpZ24gPSBhbGlnbjtcclxuICAgICAgICB0YWcucmVtb3ZlQXR0cmlidXRlKFwiYWxpZ25cIik7XHJcbiAgICAgIH1cclxuICAgIH1cclxuXHJcbiAgICByZXR1cm4gZG9jLmJvZHkuaW5uZXJIVE1MLnRvU3RyaW5nKCk7XHJcbiAgfVxyXG5cclxuICBjb252ZXJ0SHRtbEF0dHJpYnV0ZXNGb3JXeXNpd3lnKGRvYykge1xyXG4gICAgdmFyIHRhZ3MgPSBkb2MuZ2V0RWxlbWVudHNCeVRhZ05hbWUoXCIqXCIpO1xyXG4gICAgZm9yICh2YXIgaSA9IDA7IGkgPCB0YWdzLmxlbmd0aDsgaSsrKSB7XHJcbiAgICAgIHZhciB0YWcgPSB0YWdzW2ldO1xyXG4gICAgICB2YXIgc2l6ZSA9IHRhZy5nZXRBdHRyaWJ1dGUoXCJzaXplXCIpO1xyXG4gICAgICBpZiAoc2l6ZSkge1xyXG4gICAgICAgIHZhciBuZXdTaXplID0gdGhpcy5jb252ZXJ0U2l6ZU1tVG9IdG1sU2l6ZShwYXJzZUludChzaXplKSk7XHJcbiAgICAgICAgdGFnLnNldEF0dHJpYnV0ZShcInNpemVcIiwgbmV3U2l6ZSk7XHJcbiAgICAgIH1cclxuICAgIH1cclxuICAgIGZvciAodmFyIGkgPSAwOyBpIDwgdGFncy5sZW5ndGg7IGkrKykge1xyXG4gICAgICB2YXIgdGFnID0gdGFnc1tpXTtcclxuICAgICAgaWYgKHRhZy5zdHlsZSkge1xyXG4gICAgICAgIGlmICh0aGlzLmdldE5hdmlnYXRvck5hbWUoKSA9PSBcIk1TSUVcIiAmJiB0YWcuc3R5bGUudGV4dEFsaWduKSB7XHJcbiAgICAgICAgICB0YWcuc2V0QXR0cmlidXRlKFwiYWxpZ25cIiwgdGFnLnN0eWxlLnRleHRBbGlnbi50b0xvd2VyQ2FzZSgpKTtcclxuICAgICAgICAgIHRhZy5zdHlsZS50ZXh0QWxpZ24gPSBcIlwiO1xyXG4gICAgICAgIH1cclxuICAgICAgICBpZiAodGFnLnN0eWxlLmZvbnRTaXplKSB7XHJcbiAgICAgICAgICB2YXIgY2hpbGRzID0gW107XHJcbiAgICAgICAgICBmb3IgKHZhciBrID0gMDsgayA8IHRhZy5jaGlsZE5vZGVzLmxlbmd0aDsgaysrKSB7XHJcbiAgICAgICAgICAgIGNoaWxkcy5wdXNoKHRhZy5jaGlsZE5vZGVzW2tdKTtcclxuICAgICAgICAgIH1cclxuICAgICAgICAgIHZhciBmb250ID0gZG9jdW1lbnQuY3JlYXRlRWxlbWVudChcImZvbnRcIik7XHJcbiAgICAgICAgICBmb3IgKHZhciBrID0gMDsgayA8IGNoaWxkcy5sZW5ndGg7IGsrKykge1xyXG4gICAgICAgICAgICBmb250LmFwcGVuZENoaWxkKGNoaWxkc1trXSk7XHJcbiAgICAgICAgICB9XHJcbiAgICAgICAgICB0YWcuYXBwZW5kQ2hpbGQoZm9udCk7XHJcbiAgICAgICAgICBmb250LnNldEF0dHJpYnV0ZShcInNpemVcIiwgdGhpcy5jb252ZXJ0U2l6ZU1tVG9IdG1sU2l6ZShwYXJzZUludCh0YWcuc3R5bGUuZm9udFNpemUpKS50b1N0cmluZygpKTtcclxuICAgICAgICAgIHRhZy5zdHlsZS5mb250U2l6ZSA9IFwiXCI7XHJcbiAgICAgICAgfVxyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBnZXROYXZpZ2F0b3JOYW1lKCkge1xyXG4gICAgdmFyIHVzZXJhZ2VudCA9IG5hdmlnYXRvci51c2VyQWdlbnQ7XHJcbiAgICB2YXIgbmF2aWdhdG9ybmFtZSA9IFwiVW5rbm93blwiO1xyXG4gICAgaWYgKHRoaXMuZ2V0SUVWZXJzaW9uKCkgPiAwKSB7XHJcbiAgICAgIG5hdmlnYXRvcm5hbWUgPSBcIk1TSUVcIjtcclxuICAgIH0gZWxzZSBpZiAodXNlcmFnZW50LmluZGV4T2YoXCJHZWNrb1wiKSAhPSAtMSkge1xyXG4gICAgICBpZiAodXNlcmFnZW50LmluZGV4T2YoXCJDaHJvbWVcIikgIT0gLTEpIG5hdmlnYXRvcm5hbWUgPSBcIkdvb2dsZSBDaHJvbWVcIjtcclxuICAgICAgZWxzZSBuYXZpZ2F0b3JuYW1lID0gXCJNb3ppbGxhXCI7XHJcbiAgICB9IGVsc2UgaWYgKHVzZXJhZ2VudC5pbmRleE9mKFwiTW96aWxsYVwiKSAhPSAtMSkge1xyXG4gICAgICBuYXZpZ2F0b3JuYW1lID0gXCJvbGQgTmV0c2NhcGUgb3IgTW96aWxsYVwiO1xyXG4gICAgfSBlbHNlIGlmICh1c2VyYWdlbnQuaW5kZXhPZihcIk9wZXJhXCIpICE9IC0xKSB7XHJcbiAgICAgIG5hdmlnYXRvcm5hbWUgPSBcIk9wZXJhXCI7XHJcbiAgICB9XHJcblxyXG4gICAgcmV0dXJuIG5hdmlnYXRvcm5hbWU7XHJcbiAgfVxyXG5cclxuICBnZXRJRVZlcnNpb24oKSB7XHJcbiAgICB2YXIgc0FnZW50ID0gd2luZG93Lm5hdmlnYXRvci51c2VyQWdlbnQ7XHJcbiAgICB2YXIgSWR4ID0gc0FnZW50LmluZGV4T2YoXCJNU0lFXCIpO1xyXG5cclxuICAgIC8vIElmIElFLCByZXR1cm4gdmVyc2lvbiBudW1iZXIuXHJcbiAgICBpZiAoSWR4ID4gMCkgcmV0dXJuIHBhcnNlSW50KHNBZ2VudC5zdWJzdHJpbmcoSWR4ICsgNSwgc0FnZW50LmluZGV4T2YoXCIuXCIsIElkeCkpKTtcclxuICAgIC8vIElmIElFIDExIHRoZW4gbG9vayBmb3IgVXBkYXRlZCB1c2VyIGFnZW50IHN0cmluZy5cclxuICAgIC8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1leHRyYS1ib29sZWFuLWNhc3RcclxuICAgIGVsc2UgaWYgKCEhbmF2aWdhdG9yLnVzZXJBZ2VudC5tYXRjaCgvVHJpZGVudFxcLzdcXC4vKSkgcmV0dXJuIDExO1xyXG4gICAgZWxzZSByZXR1cm4gMDsgLy9JdCBpcyBub3QgSUVcclxuICB9XHJcblxyXG4gIGluaXRGb250KGh0bWxUZXh0U3RyaW5nOiBzdHJpbmcpIHtcclxuICAgIGlmIChodG1sVGV4dFN0cmluZz8ubGVuZ3RoID09IDApIHtcclxuICAgICAgc2V0VGltZW91dCgoKSA9PiB7XHJcbiAgICAgICAgbGV0IGxhYmVsID0gdGhpcy5tb2RlbC5mb3JtLnNldHRpbmdzLmxhYmVsO1xyXG4gICAgICAgIGxldCBmb250ID0gbGFiZWwuZm9udDtcclxuICAgICAgICB0aGlzLmFjdGl2ZUZvbnRGYW1pbHkgPSBmb250LmZhbWlseTtcclxuICAgICAgICB0aGlzLmFjdGl2ZUZvbnRTaXplID0gdGhpcy5jb252ZXJ0U2l6ZU1tVG9IdG1sU2l6ZShmb250LnNpemUpO1xyXG4gICAgICAgIHRoaXMuYWN0aXZlQ29sb3IgPSBsYWJlbC5jb2xvci5jbG9uZSgpO1xyXG4gICAgICAgIC8vdGhpcy5hY3RpdmVBbGlnbm1lbnQgPSBsYWJlbC5hbGlnbm1lbnQ7XHJcblxyXG4gICAgICAgIHRoaXMuaW5zZXJ0Rm9udEZhbWlseShmb250LmZhbWlseSk7XHJcbiAgICAgICAgdGhpcy5pbnNlcnRGb250U2l6ZSgpO1xyXG4gICAgICAgIHRoaXMuaW5zZXJ0Rm9yZUNvbG9yKCk7XHJcbiAgICAgICAgZm9udC5zdHlsZS5mb3JFYWNoKChzdHlsZSkgPT4ge1xyXG4gICAgICAgICAgaWYgKHN0eWxlID09IFwiQm9sZFwiKSB7XHJcbiAgICAgICAgICAgIHRoaXMuaW5zZXJ0Qm9sZCgpO1xyXG4gICAgICAgICAgfSBlbHNlIGlmIChzdHlsZSA9PSBcIkl0YWxpY1wiKSB7XHJcbiAgICAgICAgICAgIHRoaXMuaW5zZXJ0SXRhbGljKCk7XHJcbiAgICAgICAgICB9IGVsc2UgaWYgKHN0eWxlID09IFwiVW5kZXJsaW5lXCIpIHtcclxuICAgICAgICAgICAgdGhpcy5pbnNlcnRVbmRlcmxpbmUoKTtcclxuICAgICAgICAgIH1cclxuICAgICAgICB9KTtcclxuICAgICAgfSwgMCk7XHJcbiAgICB9XHJcbiAgfVxyXG59XHJcbiJdfQ==