import { Injectable } from "@angular/core";
import { camelCase } from "lodash";
import { Subject } from "rxjs";
import * as i0 from "@angular/core";
export class StiLocalizationService {
    constructor() {
        this._localizationList = [];
        StiLocalizationService.setDeflocalization();
    }
    get localizationList() {
        return this._localizationList;
    }
    set localizationList(array) {
        let locList = this.toCamelCase(array);
        this._localizationList = locList;
    }
    static setDeflocalization() {
        this.localization = JSON.parse(JSON.stringify(this.deflocalization));
    }
    toCamelCase(obj) {
        if (Array.isArray(obj)) {
            return obj.map((v) => this.toCamelCase(v));
        }
        else if (obj != null && obj.constructor === Object) {
            return Object.keys(obj).reduce((result, key) => ({
                ...result,
                [camelCase(key)]: this.toCamelCase(obj[key]),
            }), {});
        }
        return obj;
    }
    static updateLocalization(from, to) {
        for (let promName in from) {
            if (typeof from[promName] === "string") {
                to[promName] = from[promName];
            }
            else {
                if (to[promName] == undefined) {
                    to[promName] = from[promName];
                }
                else {
                    this.updateLocalization(from[promName], to[promName]);
                }
            }
        }
    }
    loadLocalization(str) {
        StiLocalizationService.setLocalization(str);
        StiLocalizationService.needToRefresh.next(true);
    }
    changeCurrentLocalization(locName) {
        this.currentLocalization = this.localizationList.find((loc) => loc.cultureName == locName);
    }
    static setLocalization(str) {
        if (str) {
            this.setDeflocalization();
            let jsonLoc = str;
            if (str && str.indexOf("<?xml") == 0) {
                let xml = new DOMParser().parseFromString(str, "text/xml");
                jsonLoc = this.xml2json(xml);
            }
            this.updateLocalization(jsonLoc, this.localization);
        }
    }
    static get(category, key) {
        let loc = this.localization?.Localization;
        return loc && loc[category][key] ? loc[category][key] : key;
    }
    getP(key) {
        return StiLocalizationService.get("PropertyMain", key);
    }
    get2(category, key) {
        return StiLocalizationService.get(category, key);
    }
    static xml2json(xml, tab = "") {
        let X = {
            toObj: function (xml) {
                let o = {};
                if (xml.nodeType == 1) {
                    // element node ..
                    if (xml.attributes.length)
                        // element with attributes  ..
                        for (let i = 0; i < xml.attributes.length; i++)
                            o["@" + xml.attributes[i].nodeName] = (xml.attributes[i].nodeValue || "").toString();
                    if (xml.firstChild) {
                        // element has child nodes ..
                        let textChild = 0, cdataChild = 0, hasElementChild = false;
                        for (let n = xml.firstChild; n; n = n.nextSibling) {
                            if (n.nodeType == 1)
                                hasElementChild = true;
                            else if (n.nodeType == 3 && n.nodeValue.match(/[^ \f\n\r\t\v]/))
                                textChild++; // non-whitespace text
                            else if (n.nodeType == 4)
                                cdataChild++; // cdata section node
                        }
                        if (hasElementChild) {
                            if (textChild < 2 && cdataChild < 2) {
                                // structured element with evtl. a single text or/and cdata node ..
                                X.removeWhite(xml);
                                for (let n = xml.firstChild; n; n = n.nextSibling) {
                                    if (n.nodeType == 3)
                                        // text node
                                        o["#text"] = X.escape(n.nodeValue);
                                    else if (n.nodeType == 4)
                                        // cdata node
                                        o["#cdata"] = X.escape(n.nodeValue);
                                    else if (o[n.nodeName]) {
                                        // multiple occurence of element ..
                                        if (o[n.nodeName] instanceof Array)
                                            o[n.nodeName][o[n.nodeName].length] = X.toObj(n);
                                        else
                                            o[n.nodeName] = [o[n.nodeName], X.toObj(n)];
                                    } // first occurence of element..
                                    else
                                        o[n.nodeName] = X.toObj(n);
                                }
                            }
                            else {
                                // mixed content
                                if (!xml.attributes.length)
                                    o = X.escape(X.innerXml(xml));
                                else
                                    o["#text"] = X.escape(X.innerXml(xml));
                            }
                        }
                        else if (textChild) {
                            // pure text
                            if (!xml.attributes.length)
                                o = X.escape(X.innerXml(xml));
                            else
                                o["#text"] = X.escape(X.innerXml(xml));
                        }
                        else if (cdataChild) {
                            // cdata
                            if (cdataChild > 1)
                                o = X.escape(X.innerXml(xml));
                            else
                                for (let n = xml.firstChild; n; n = n.nextSibling)
                                    o["#cdata"] = X.escape(n.nodeValue);
                        }
                    }
                    if (!xml.attributes.length && !xml.firstChild)
                        o = null;
                }
                else if (xml.nodeType == 9) {
                    // document.node
                    o = X.toObj(xml.documentElement);
                }
                else
                    alert("unhandled node type: " + xml.nodeType);
                return o;
            },
            toJson: function (o, name, ind) {
                let json = name ? '"' + name + '"' : "";
                if (o instanceof Array) {
                    for (let i = 0, n = o.length; i < n; i++)
                        o[i] = X.toJson(o[i], "", ind + "\t");
                    json +=
                        (name ? ":[" : "[") +
                            (o.length > 1 ? "\n" + ind + "\t" + o.join(",\n" + ind + "\t") + "\n" + ind : o.join("")) +
                            "]";
                }
                else if (o == null)
                    json += (name && ":") + "null";
                else if (typeof o == "object") {
                    let arr = [];
                    for (let m in o)
                        arr[arr.length] = X.toJson(o[m], m, ind + "\t");
                    json +=
                        (name ? ":{" : "{") +
                            (arr.length > 1 ? "\n" + ind + "\t" + arr.join(",\n" + ind + "\t") + "\n" + ind : arr.join("")) +
                            "}";
                }
                else if (typeof o == "string")
                    json += (name && ":") + '"' + o.toString() + '"';
                else
                    json += (name && ":") + o.toString();
                return json;
            },
            innerXml: function (node) {
                let s = "";
                if ("innerHTML" in node)
                    s = node.innerHTML;
                else {
                    let asXml = function (n) {
                        let s = "";
                        if (n.nodeType == 1) {
                            s += "<" + n.nodeName;
                            for (let i = 0; i < n.attributes.length; i++)
                                s += " " + n.attributes[i].nodeName + '="' + (n.attributes[i].nodeValue || "").toString() + '"';
                            if (n.firstChild) {
                                s += ">";
                                for (let c = n.firstChild; c; c = c.nextSibling)
                                    s += asXml(c);
                                s += "</" + n.nodeName + ">";
                            }
                            else
                                s += "/>";
                        }
                        else if (n.nodeType == 3)
                            s += n.nodeValue;
                        else if (n.nodeType == 4)
                            s += "<![CDATA[" + n.nodeValue + "]]>";
                        return s;
                    };
                    for (let c = node.firstChild; c; c = c.nextSibling)
                        s += asXml(c);
                }
                return s;
            },
            escape: function (txt) {
                return txt.replace(/[\\]/g, "\\\\").replace(/[\"]/g, '\\"').replace(/[\n]/g, "\\n").replace(/[\r]/g, "\\r");
            },
            removeWhite: function (e) {
                e.normalize();
                for (let n = e.firstChild; n;) {
                    if (n.nodeType == 3) {
                        // text node
                        if (!n.nodeValue.match(/[^ \f\n\r\t\v]/)) {
                            // pure whitespace text node
                            let nxt = n.nextSibling;
                            e.removeChild(n);
                            n = nxt;
                        }
                        else
                            n = n.nextSibling;
                    }
                    else if (n.nodeType == 1) {
                        // element node
                        X.removeWhite(n);
                        n = n.nextSibling;
                    } // any other node
                    else
                        n = n.nextSibling;
                }
                return e;
            },
        };
        if (xml.nodeType == 9)
            // document node
            xml = xml.documentElement;
        let json = X.toJson(X.toObj(X.removeWhite(xml)), xml.nodeName, "\t");
        return JSON.parse("{\n" + tab + (tab ? json.replace(/\t/g, tab) : json.replace(/\t|\n/g, "")) + "\n}");
    }
}
StiLocalizationService.localization = {};
StiLocalizationService.deflocalization = JSON.parse('{"Localization":{"@language":"English","@description":"English","@cultureName":"en","A_WebViewer":{"AbbreviatedDayFriday":"Fr","AbbreviatedDayMonday":"Mo","AbbreviatedDaySaturday":"Sa","AbbreviatedDaySunday":"Su","AbbreviatedDayThursday":"Th","AbbreviatedDayTuesday":"Tu","AbbreviatedDayWednesday":"We","Attachment":"Attachment:","ButtonNext":"Next","ButtonPrev":"Previous","ButtonSend":"Send","CategoryAlreadyExists":"The category with that name already exists!","DayFriday":"Friday","DayMonday":"Monday","Days":"Days","DaySaturday":"Saturday","DaySunday":"Sunday","DayThursday":"Thursday","DayTuesday":"Tuesday","DayWednesday":"Wednesday","Email":"Email:","EmailOptions":"Email Options","FirstPage":"First Page","Hours":"Hours","LabelFrom":"From:","LabelSelectExportFormat":"Select the format to which you want to save the report:","LabelTo":"To:","LastPage":"Last Page","Loading":"Loading...","Message":"Message:","Minutes":"Minutes","MonthApril":"April","MonthAugust":"August","MonthDecember":"December","MonthFebruary":"February","MonthJanuary":"January","MonthJuly":"July","MonthJune":"June","MonthMarch":"March","MonthMay":"May","MonthNovember":"November","MonthOctober":"October","MonthSeptember":"September","NextPage":"Next Page","OnePage":"One Page","Page":"Page","PageOf":"of","PreviousPage":"Previous Page","PrintContinue":"Click Print to continue","PrintReport":"Print","PrintToPdf":"PDF","PrintToXps":"Microsoft XPS","PrintWithoutPreview":"Print","PrintWithPreview":"Preview","SaveReport":"Save","Subject":"Subject:","TabItemContacts":"Contacts","TextComputer":"Computer","TextItemsRoot":"Root","TodayDate":"Today","WholeReport":"Whole Report"},"Adapters":{"AdapterBusinessObjects":"Data from Business Objects","AdapterConnection":"Data from {0}","AdapterCrossTabDataSource":"Data from Cross-Tab","AdapterCsvFiles":"Data from CSV Files","AdapterDataTables":"Data from DataSet, DataTables","AdapterDataViews":"Data from DataViews","AdapterDB2Connection":"Data from IBM DB2 Connection","AdapterDBaseFiles":"Data from dBase Files","AdapterFirebirdConnection":"Data from Firebird Connection","AdapterInformixConnection":"Data from Informix Connection","AdapterMySQLConnection":"Data from MySQL Connection","AdapterOdbcConnection":"Data from ODBC Connection","AdapterOleDbConnection":"Data from OLE DB Connection","AdapterOracleConnection":"Data from Oracle Connection","AdapterOracleODPConnection":"Data from Oracle ODP.NET Connection","AdapterPostgreSQLConnection":"Data from PostgreSQL Connection","AdapterSqlCeConnection":"Data from SQL CE Connection","AdapterSqlConnection":"Data from SQL Connection","AdapterSQLiteConnection":"Data from SQLite Connection","AdapterTeradataConnection":"Data from Teradata Connection","AdapterUniDirectConnection":"Data from Uni Direct Connection","AdapterUserSources":"Data from User Sources","AdapterVirtualSource":"Data from other Data Source","AdapterVistaDBConnection":"Data from VistaDB Connection"},"BarCode":{"Post":"Post","TwoDimensional":"Two-Dimensional"},"Buttons":{"Add":"Add","AddAllColumns":"Add All Columns","Attach":"Attach","Build":"Build...","Buttons":"Buttons","Cancel":"&amp;Cancel","Check":"Check","Close":"Close","Delete":"Delete","Design":"Design","Down":"Down","Duplicate":"Duplicate","Export":"Export","ForceDelete":"Force Delete","Help":"Help","Install":"Install","LessOptions":"Less Options","LoadDataSet":"Load DataSet (*.data)","More":"More","MoreApps":"More Apps","MoreOptions":"More Options","MoveLeft":"Move Left","MoveRight":"Move Right","MoveToResource":"Move to Resource","No":"&amp;No","Ok":"&amp;OK","Open":"Open","OpenContainingFolder":"Open Containing Folder","Print":"Print","Publish":"Publish","QuickPrint":"Quick Print","Remove":"Remove","RemoveAll":"Remove All","Rename":"Rename","RestoreDefaults":"Restore Defaults","Reverse":"Reverse","Save":"Save","SaveCopy":"Save a Copy","SetAll":"Set All","ShowLess":"Show Less","ShowMore":"Show More","ShowSpecific":"Show \'{0}\'","Sign":"Sign","Submit":"Submit","SwitchTo":"Switch to {0}","Test":"Test","Up":"Up","Upgrade":"Upgrade","UpgradeNow":"Upgrade Now","Upload":"Upload","Waiting":"Waiting","Yes":"&amp;Yes"},"Chart":{"AddCondition":"&amp;Add Condition","AddConstantLine":"Add Constant Line","AddFilter":"&amp;Add Filter","AddSeries":"&amp;Add Series","AddStrip":"Add Strip","AddTrendLine":"Add Trend Line","Area":"Area","Axes":"Axes","AxisReverse":"Reverse","AxisX":"Axis X","AxisY":"Axis Y","BoxAndWhisker":"Box and Whisker","Bubble":"Bubble","Candlestick":"Candlestick","ChartConditionsCollectionForm":"Conditions","ChartEditorForm":"Chart Editor","ChartFiltersCollectionForm":"Filters","ChartType":"Chart Type","CheckBoxAutoRotation":"Auto Rotation","ClusteredBar":"Clustered Bar","ClusteredColumn":"Clustered Column","Common":"Common","ConstantLine":"Constant Line","ConstantLinesEditorForm":"Constant Lines Editor","DataColumns":"Data Columns","Doughnut":"Doughnut","Financial":"Financial","FullStackedArea":"Full-Stacked Area","FullStackedBar":"Full-Stacked Bar","FullStackedColumn":"Full-Stacked Column","FullStackedLine":"Full-Stacked Line","FullStackedSpline":"Full-Stacked Spline","FullStackedSplineArea":"Full-Stacked Spline Area","Funnel":"Funnel","FunnelWeightedSlices":"Funnel Weighted Slices","Gantt":"Gantt","GridInterlaced":"Interlaced","GridLines":"Grid Lines","Histogram":"Histogram","LabelAlignment":"Alignment:","LabelAlignmentHorizontal":"Horizontal:","LabelAlignmentVertical":"Vertical:","LabelAngle":"Angle:","LabelArgumentDataColumn":"Argument Data Column:","LabelAutoRotation":"Auto Rotation:","LabelCloseValueDataColumn":"Close Value Data Column:","LabelEndValueDataColumn":"End Value Data Column:","LabelHighValueDataColumn":"High Value Data Column:","LabelHorizontal":"Horizontal:","LabelLowValueDataColumn":"Low Value Data Column:","LabelMinorCount":"Minor Count:","LabelOpenValueDataColumn":"Open Value Data Column:","Labels":"Labels","LabelsCenter":"Center","LabelSeriesName":"Series Name:","LabelsInside":"Inside","LabelsInsideBase":"Inside Base","LabelsInsideEnd":"Inside End","LabelsNone":"None","LabelsOutside":"Outside","LabelsOutsideBase":"Outside Base","LabelsOutsideEnd":"Outside End","LabelsOverlay":"Overlay","LabelsStyleCategory":"Category","LabelsStyleCategoryPercentOfTotal":"Category - Percent Of Total","LabelsStyleCategoryValue":"Category - Value","LabelsStylePercentOfTotal":"Percent Of Total","LabelsStyleValue":"Value","LabelsTwoColumns":"Two Columns","LabelTextAfter":"Text After:","LabelTextBefore":"Text Before:","LabelTitleAlignment":"Alignment:","LabelValueDataColumn":"Value Data Column:","LabelValueType":"Value Type:","LabelVertical":"Vertical:","LabelVisible":"Visible:","Legend":"Legend","LegendSpacing":"Spacing","Line":"Line","ListOfValues":"List of Values","Marker":"Marker","MoveConstantLineDown":"Move Constant Line Down","MoveConstantLineUp":"Move Constant Line Up","MoveSeriesDown":"Move Series Down","MoveSeriesUp":"Move Series Up","MoveStripDown":"Move Strip Down","MoveStripUp":"Move Strip Up","NoConditions":"No Conditions","NoFilters":"No Filters","Pareto":"Pareto","Pictorial":"Pictorial","PictorialStacked":"Pictorial Stacked","Pie":"Pie","Radar":"Radar","RadarArea":"Radar Area","RadarColumn":"Radar Column","RadarLine":"Radar Line","RadarPoint":"Radar Point","Range":"Range","RangeBar":"Range Bar","RemoveCondition":"&amp;Remove Condition","RemoveConstantLine":"Remove Constant Line","RemoveFilter":"&amp;Remove Filter","RemoveSeries":"&amp;Remove Series","RemoveStrip":"Remove Strip","Ribbon":"Ribbon","RunChartWizard":"Run Chart &amp;Wizard","Scatter":"Scatter","ScatterLine":"Scatter Line","ScatterSpline":"Scatter Spline","Series":"Series","SeriesColorsCollectionForm":"Series Colors","SeriesEditorForm":"Series Editor","Serieses":"Series","SparklinesArea":"Area","SparklinesColumn":"Column","SparklinesLine":"Line","SparklinesWinLoss":"Win / Loss","Spline":"Spline","SplineArea":"Spline Area","SplineRange":"Spline Range","StackedArea":"Stacked Area","StackedBar":"Stacked Bar","StackedColumn":"Stacked Column","StackedLine":"Stacked Line","StackedSpline":"Stacked Spline","StackedSplineArea":"Stacked Spline Area","SteppedArea":"Stepped Area","SteppedLine":"Stepped Line","SteppedRange":"Stepped Range","Stock":"Stock","Strip":"Strip","StripsEditorForm":"Strips Editor Form","Style":"Style","Sunburst":"Sunburst","Treemap":"Treemap","TrendLinesEditorForm":"Trend Lines Editor","Waterfall":"Waterfall"},"CharterMapEditor":{"Characters":"Characters"},"ChartRibbon":{"Axes":"Axes","AxesArrowStyle":"Arrow Style","AxesArrowStyleLines":"Lines","AxesArrowStyleNone":"None","AxesArrowStyleTriangle":"Triangle","AxesLabel":"Label Placement","AxesLabelsNone":"None","AxesLabelsOneLine":"One Line","AxesLabelsTwoLines":"Two Lines","AxesReverseHorizontal":"Reverse Horizontal","AxesReverseVertical":"Reverse Vertical","AxesTicks":"Ticks","AxesTicksMajor":"Major","AxesTicksMinor":"Minor","AxesTicksNone":"None","AxesVisible":"Visible","AxesXAxis":"X Axis","AxesXTopAxis":"X Top Axis","AxesYAxis":"Y Axis","AxesYRightAxis":"Y Right Axis","CenterLabels":"Center","ChangeType":"Change Type","GridLines":"Grid Lines","GridLinesHorizontal":"Grid Lines Horizontal","GridLinesVertical":"Grid Lines Vertical","HorAlCenter":"&lt;b&gt;Overlay Legend at Center&lt;/b&gt;&lt;br&gt;Show Legend at center of the chart&lt;/br&gt;&lt;br&gt;without resizing&lt;/br&gt;","HorAlLeft":"&lt;b&gt;Overlay Legend at Left&lt;/b&gt;&lt;br&gt;Show Legend at left of the chart&lt;/br&gt;&lt;br&gt;without resizing&lt;/br&gt;","HorAlLeftOutside":"&lt;b&gt;Show Legend at Left&lt;/b&gt;&lt;br&gt;Show Legend and align left&lt;/br&gt;","HorAlRight":"&lt;b&gt;Overlay Legend at Right&lt;/b&gt;&lt;br&gt;Show Legend at right of the chart&lt;/br&gt;&lt;br&gt;without resizing&lt;/br&gt;","HorAlRightOutside":"&lt;b&gt;Show Legend at Right&lt;/b&gt;&lt;br&gt;Show Legend and align right&lt;/br&gt;","HorizontalMajor":"&lt;b&gt;Major&lt;/b&gt;&lt;br&gt;Display Horizontal Gridlines for Major units&lt;/br&gt;","HorizontalMajorMinor":"&lt;b&gt;Major &amp;&amp; Minor Gridlines&lt;/b&gt;&lt;br&gt;Display Horizontal Gridlines for Major and Minor units&lt;/br&gt;","HorizontalMinor":"&lt;b&gt;Minor&lt;/b&gt;&lt;br&gt;Display Horizontal Gridlines for Minor units&lt;/br&gt;","HorizontalNone":"&lt;b&gt;None&lt;/b&gt;&lt;br&gt;Do not display Horizontal Grirdlines&lt;/br&gt;","InsideBaseLabels":"Inside Base","InsideEndLabels":"Inside End","Labels":"Series Labels","Legend":"Legend","LegendHorizontalAlignment":"Horizontal Alignment","LegendMarker":"Marker","LegendMarkerAlignmentLeft":"Left","LegendMarkerAlignmentRight":"Right","LegendMarkerVisible":"Visible","LegendVerticalAlignment":"Vertical Alignment","LegendVisible":"Visible","NoneLabels":"None","OutsideBaseLabels":"Outside Base","OutsideEndLabels":"Outside End","OutsideLabels":"Outside","ribbonBarAxis":"Axes","ribbonBarChartStyles":"Chart Styles","ribbonBarChartType":"Chart Type","ribbonBarLabels":"Labels","ribbonBarLegend":"Legend","Style":"Change Style","TwoColumnsPieLabels":"Two Columns","VertAlBottom":"&lt;b&gt;Overlay Legend at Bottom&lt;/b&gt;&lt;br&gt;Show Legend at bottom of the chart&lt;/br&gt;&lt;br&gt;without resizing&lt;/br&gt;","VertAlBottomOutside":"&lt;b&gt;Show Legend at Bottom&lt;/b&gt;&lt;br&gt;Show Legend and align bottom&lt;/br&gt;","VertAlCenter":"&lt;b&gt;Overlay Legend at Center&lt;/b&gt;&lt;br&gt;Show Legend at center of the chart&lt;/br&gt;&lt;br&gt;without resizing&lt;/br&gt;","VertAlTop":"&lt;b&gt;Overlay Legend at Top&lt;/b&gt;&lt;br&gt;Show Legend at top of the chart&lt;/br&gt;&lt;br&gt;without resizing&lt;/br&gt;","VertAlTopOutside":"&lt;b&gt;Show Legend at Top&lt;/b&gt;&lt;br&gt;Show Legend and align top&lt;/br&gt;","VerticalMajor":"&lt;b&gt;Major&lt;/b&gt;&lt;br&gt;Display Vertical Gridlines for Major units&lt;/br&gt;","VerticalMajorMinor":"&lt;b&gt;Major &amp;&amp; Minor Gridlines&lt;/b&gt;&lt;br&gt;Display Vertical Gridlines for Major and Minor units&lt;/br&gt;","VerticalMinor":"&lt;b&gt;Minor&lt;/b&gt;&lt;br&gt;Display Vertical Gridlines for Minor units&lt;/br&gt;","VerticalNone":"&lt;b&gt;None&lt;/b&gt;&lt;br&gt;Do not display Vertical Gridlines&lt;/br&gt;"},"Cloud":{"AcceptTermsAndPrivacyPolicy":"I read and accept the {0} and {1}","Account":"Account","AccountSettings":"Account Settings","AddAPlace":"Add a Place","AreYouSureYouWantDeleteReport":"Are you sure you want to delete \\"{0}\\" report from disk?","Authorize":"Authorize","AuthorizeWithLicenseKey":"Authorize with License Key","ButtonChangePassword":"Change Password","ButtonDeleteAll":"Delete All","ButtonDesign":"Design Report","ButtonLater":"Later","ButtonLogInWith":"Log In with {0}","ButtonLogout":"Logout","ButtonPublish":"Publish","ButtonPurchase":"Purchase","ButtonRecover":"Recover","ButtonRenew":"Renew","ButtonResendEmail":"Resend Email","ButtonResetPassword":"Reset Password","ButtonRun":"Run","ButtonScheduler":"Scheduler","ButtonShare":"Share","ButtonSignUp":"Sign Up","ButtonSignUpWith":"Sign Up with {0}","ButtonSkip":"Skip","ButtonView":"View","ButtonWhereUsed":"Where is it used?","Cancel":"Cancel","CheckBoxMoveToRecycleBin":"Move to Recycle Bin","CheckBoxRememberMe":"Remember Me","CheckForUpdate":"Check for Update","Cloud":"Cloud","Collection":"Collection","Create":"Create","CreateError":"Error while creating report!","CreateNewCollection":"Create New Collection","CreateYourTeam":"Create your team","CreatingReport":"Creating report...","DashboardWindowTitleNew":"New Dashboard","DeleteFile":"Delete File","DoNotAskMe":"Do not ask me again","EnterUserNameToLogin":"Enter User Name (email) to log in.","ExecutionError":"Execution error","ExpiredDate":"Expired Date","FileStorageWindowTitleEdit":"Edit File Storage","FileStorageWindowTitleNew":"New File Storage","FolderWindowTitleEdit":"Edit Folder","FolderWindowTitleNew":"New Folder","ForExample":"For example","GroupBoxAttachedItems":"Attached Items","HyperlinkAgreeToTerms":"By registering you agree to Terms.","HyperlinkAlreadyHaveAccount":"Already have account","HyperlinkForgotPassword":"Forgot password","HyperlinkHavePassword":"Have password","HyperlinkRegisterAccount":"Register FREE account","InstallSamples":"Install Samples","Invitations":"Invitations","Invite":"Invite","LabelAddCloudFolder":"Connect your Stimulsoft Cloud folder with reports and dashboards.","LabelAddFolder":"Add your local folder with reports and dashboards.","labelCollectionName":"Collection Name:","LabelCreated":"Created:","LabelCreateFolder":"Create a new category in which you can place other items.","LabelCreateNewDashboard":"Create new dashboard.","LabelCreateReportTemplate":"Create report template.","LabelCurrentPassword":"Current Password:","LabelDataFile":"Data File:","LabelDataUrl":"Data URL:","LabelEndDate":"End Date:","labelFileName":"File Name:","LabelForeground":"Foreground:","LabelFromReport":"From Report","LabelFromReportCode":"From Report (define in code)","LabelInviteUser":"Invite new users to your team. Send invitations to their emails.","LabelLastLogin":"Last Log In:","LabelLastTime":"Last Time:","LabelModified":"Modified:","LabelNewPassword":"New Password:","LabelNextTime":"Next Time:","labelPassword":"Password:","LabelPermission":"Permission:","LabelPicture":"Picture:","LabelRenderedReport":"Rendered report","LabelResponseAsFile":"Response as File","LabelResultType":"Result Type:","LabelSeparateReport":"Separate report (and scripts) file","LabelShowReport":"Show report:","LabelStartDate":"Start Date:","labelUserName":"User Name:","License":"License","LicenseInformation":"License Information","LicenseKey":"License Key","Login":"Log In","MyTeam":"My Team","NofM":"{0}: {1} of {2}","Open":"Open","OpenFile":"Open File","OperationCreate":"Create \'{0}\'","OperationDelete":"Delete \'{0}\' from Server","OperationDownload":"Download from Server","OperationGetList":"Get List of Files from Server","OperationLogin":"Log In to Server","OperationRename":"Rename \'{0}\' to \'{1}\'","OperationUpload":"Upload \'{0}\' to Server","page":"page","Platforms":"Platforms","Port":"Port","PrivacyPolicy":"Privacy","Products":"Products","Proxy":"Proxy","PublishMessage":"In order to publish this report you should submit it to our service publish.stimulsoft.com","questionOpenThisFile":"Are you sure want to open \'{0}\' item?","questionOverrideItem":"Do you really want to override \'{0}\' item?","questionRemoveItem":"Do you really want to remove \'{0}\' item?","RefreshList":"Refresh List","ReportDocumentFormatNotRecognized":"Format of \'{0}\' item is not recognized as rendered report format!","ReportTemplateFormatNotRecognized":"Format of \'{0}\' item is not recognized as report template format!","RequestChangesWhenSavingToCloud":"Request Changes when Saving to Stimulsoft Cloud","RibbonButtonAddRole":"Add Role","RibbonButtonAddUser":"Add User","RibbonButtonAddWorkspace":"Add Workspace","RibbonButtonFolder":"Folder","RibbonTabUsers":"Users","Root":"Root","RootFolder":"Root Folder","Save":"Save","SaveAccountSettings":"Save Account Settings","SaveAsType":"Save as type","SaveFile":"Save File","SavingToStimulsoftCloudPleaseWait":"Saving the report to Stimulsoft Cloud. Please wait!","SearchForOnlineTemplates":"Search Stimulsoft templates online","ShareWindowTitleNew":"Share","ShowAllFiles":"Show All Files","ShowNotificationMessages":"Show Notification Messages","Subscriptions":"Subscriptions","TabItemEmbedCode":"Embed Code","TabItemQRCode":"QR Code","TabItemShare":"Link to Share","Team":"Team","TermsOfUse":"Terms","TextActivated":"Activated","TextActivationDate":"Activation Date","TextDelete":"Delete","TextDeletingItems":"Deleting items...","TextDescriptionChanges":"Please, type a description of the changes:","TextFirstName":"First Name","TextFromTo":"From {0} to {1} (Total - {2})","TextItemsWorkspace":"Workspace","TextLastName":"Last Name","TextModify":"Modify","TextNewsLetters":"News Letters","TextNoFavoriteFiles":"No favorite files","TextNoFiles":"No files","TextNoNotifications":"No Notifications","TextNoRecentFiles":"No recent files","TextOwner":"Owner","TextProfile":"Profile","TextReports":"Reports","TextRestoringItems":"Restoring items...","TextRole":"Role","TextRun":"Run","TextUser":"User","TextUserName":"User Name (Email)","TimeHoursAgoFive":"Five hours ago, {0:t}","TimeHoursAgoFour":"Four hours ago, {0:t}","TimeHoursAgoOne":"One hour ago, {0:t}","TimeHoursAgoThree":"Three hours ago, {0:t}","TimeHoursAgoTwo":"Two hours ago, {0:t}","TimeMinutesAgoFive":"Five minutes ago, {0:t}","TimeMinutesAgoFour":"Four minutes ago, {0:t}","TimeMinutesAgoLessOne":"Less than a minute ago","TimeMinutesAgoN":"{0} minutes ago, {1:t}","TimeMinutesAgoOne":"One minute ago, {0:t}","TimeMinutesAgoThree":"Three minutes ago, {0:t}","TimeMinutesAgoTwo":"Two minutes ago, {0:t}","TimeToday":"Today, {0:t}","TimeYesterday":"Yesterday, {0:t}","ToolTipAddRole":"Creating a new role in the workspace.","ToolTipAddUser":"Creating a new user in the selected role.","ToolTipAspNet":"Publish the selected report to the ASP.NET application.","ToolTipAspNetMvc":"Publish the selected report to the ASP.NET MVC application.","ToolTipAttach":"Attach items to the selected report.","ToolTipCreate":"Create a new item.","ToolTipDelete":"Delete the selected items.","ToolTipDeleted":"Show deleted items","ToolTipDownload":"Download the selected item.","ToolTipEdit":"Edit the selected item.","ToolTipGridMode":"List view","ToolTipInfo":"View details","ToolTipJs":"Publish the selected report as the HTML page","ToolTipPublish":"Prepare the selected report to be deployed in your application.","ToolTipRecover":"Recover the selected items.","ToolTipRunWithoutPreview":"Render the selected report without preview","ToolTipShare":"Share the selected file.","ToolTipSort":"Sort options","ToolTipThumbnailMode":"Thumbnail View","ToolTipViewFile":"Show the selected file.","ToolTipViewReport":"Show the selected report in the viewer.","WeDidntFindAnything":"We didn\'t find anything to show here.","WindowDescriptionDelete":"Are you sure you want to delete the selected items?","WindowDescriptionRecover":"Selected items will be recovered from the Recycle Bin.","WindowTitleDelete":"Delete Items","WindowTitleForgotPassword":"Forgot Password","WindowTitleLogin":"Log In","WindowTitleRecover":"Recover Items","WindowTitleRoleEdit":"Edit Role","WindowTitleRoleNew":"New Role","WindowTitleSignUp":"Sign Up","WindowTitleUserEdit":"Edit User","WindowTitleUserNew":"New User","WindowTitleWorkspaceEdit":"Edit Workspace","WindowTitleWorkspaceNew":"New Workspace","WizardBlankReportDescription":"Create a blank report","WizardExcelDescription":"Create a report with Excel data.","WizardJsonDescription":"Create a report with JSON data.","WizardPrivateShare":"No Access","WizardPrivateShareDescription":"External access to the item is restricted.","WizardPublicShare":"Public Access","WizardPublicShareDescription":"External access for any unauthorized user.","WizardRegisteredShare":"Authorized Access","WizardRegisteredShareDescription":"External access only for registered users from any workspace.","WizardTeamShare":"Team Access","WizardTeamShareDescription":"External access for users of one workspace only.","WizardXmlDescription":"Create a report with XML data."},"Components":{"StiBarCode":"Bar Code","StiButton":"Button","StiCards":"Cards","StiChart":"Chart","StiCheckBox":"Check Box","StiChildBand":"Child","StiClone":"Clone","StiColumnFooterBand":"Column Footer","StiColumnHeaderBand":"Column Header","StiComboBox":"Combo Box","StiComponent":"Component","StiContainer":"Container","StiContourText":"Contour Text","StiCrossColumn":"Cross-Column","StiCrossColumnTotal":"Cross-Column Total","StiCrossDataBand":"Cross-Data","StiCrossFooterBand":"Cross-Footer","StiCrossGroupFooterBand":"Cross-Group Footer","StiCrossGroupHeaderBand":"Cross-Group Header","StiCrossHeaderBand":"Cross-Header","StiCrossRow":"Cross-Row","StiCrossRowTotal":"Cross-Row Total","StiCrossSummary":"Cross-Summary","StiCrossSummaryHeader":"Cross-Summary Header","StiCrossTab":"Cross-Tab","StiCrossTitle":"Cross-Title","StiDashboard":"Dashboard","StiDataBand":"Data","StiDatePicker":"Date Picker","StiElectronicSignature":"Electronic Signature","StiEmptyBand":"Empty Data","StiFooterBand":"Footer","StiGauge":"Gauge","StiGroupFooterBand":"Group Footer","StiGroupHeaderBand":"Group Header","StiHeaderBand":"Header","StiHierarchicalBand":"Hierarchical Data","StiHorizontalLinePrimitive":"Horizontal Line","StiImage":"Image","StiIndicator":"Indicator","StiListBox":"List Box","StiMap":"Map","StiMathFormula":"Math Formula","StiMultipleSelection":"Multiple Selection","StiNumberBox":"Number Box","StiOnlineMap":"Online Map","StiOverlayBand":"Overlay","StiPage":"Page","StiPageFooterBand":"Page Footer","StiPageHeaderBand":"Page Header","StiPanel":"Panel","StiPdfDigitalSignature":"PDF Digital Signature","StiPivotColumn":"Pivot Column","StiPivotRow":"Pivot Row","StiPivotSummary":"Pivot Summary","StiPivotTable":"Pivot Table","StiProgress":"Progress","StiRectanglePrimitive":"Rectangle","StiRegionMap":"Region Map","StiReport":"Report","StiReportSummaryBand":"Report Summary","StiReportTitleBand":"Report Title","StiRichText":"Rich Text","StiRoundedRectanglePrimitive":"Rounded Rectangle","StiScreen":"Screen","StiShape":"Shape","StiSignature":"Signature","StiSingleSelection":"Single Selection","StiSparkline":"Sparkline","StiSubReport":"Sub-Report","StiSystemText":"System Text","StiTable":"Table","StiTableOfContents":"Table of Contents","StiText":"Text","StiTextInCells":"Text in Cells","StiTreeView":"Tree View","StiTreeViewBox":"Tree View Box","StiVerticalLinePrimitive":"Vertical Line","StiWinControl":"Win Control","StiZipCode":"ZIP Code"},"CustomMapWindow":{"CheckedAll":"Checked All","HideText":"Hide Text","KeysChangePosition":"Keys (Left, Top, Right, Bottom) change the position of the text","KeysChangeSize":"Shift + keys (Left, Top, Right, Bottom) change the size of the text area","UncheckedAll":"Unchecked All"},"Dashboard":{"AddRange":"Add Range","AfterGroupingData":"Apply after grouping data","AfterSortingData":"Apply after grouping and sorting data","AllowUserColumnSelection":"Allow User Column Selection","AllowUserDrillDown":"Allow User Drill-Down","AllowUserFiltering":"Allow User Filtering","AllowUserSorting":"Allow User Sorting","BeforeTransformation":"Apply before data transformation","Blank":"(Blank)","Blanks":"(Blanks)","BooleanFilters":"Boolean Filters","CannotLoadDashboard":"You cannot load a report with dashboards.","ChangeChartType":"Change Chart Type","ChangeMapType":"Change Map Type","ClearAllFormatting":"Clear All Formatting","ClearFilterFrom":"Clear Filter from \'{0}\'","ColorScale":"Color Scale","ColumnInteractions":"Column Interactions","CustomFilter":"Custom &amp;Filter...","DashboardsNotSupportedIntheWPFDesigner":"Dashboards are not supported in the WPF Designer.","DataBars":"Data Bars","DataFilterGrouping":"This operation is used for grouping different columns only.","DataNotDefined":"Data is not defined","DateFilters":"Date Filters","Dimension":"Dimension","Dimensions":"Dimensions","DragDropBlocks":"Drag &amp; drop blocks from panel","DragDropData":"Drag &amp; drop data","DragDropDataFromDictionary":"Drag &amp; drop data from Dictionary","DrillDown":"Drill-Down","DrillDownFiltered":"Drill-Down Filtered","DrillDownSelected":"Drill-Down Selected","DrillUp":"Drill Up","DuplicateField":"Duplicate Field","EditExpression":"Edit Expression","EditField":"Edit Field","EmptyDashboardFooter":"Drag &amp; drop component from ToolBox or data from Dictionary","EmptyDashboardHeader":"Dashboard is empty","FieldInteractions":"Field Interactions","FieldTypeRestrictionHint":"Only \'{0}\' type field can be used!","FirstLastPoints":"First / Last Points","FirstRowIndex":"First Row Index","FullRowSelect":"Full Row Select","HighLowPoints":"High / Low Points","ImageNotSpecified":"Image not specified","Indicator":"Indicator","InitialValue":"Initial Value","LimitRows":"Skip and Limit Rows","Measure":"Measure","Measures":"Measures","Metrics":"Metrics","NewDimension":"New Dimension","NewField":"New Field","NewMeasure":"New Measure","NoRanges":"No Ranges","NoResult":"No Result","NSelected":"{0} selected","Nulls":"(Nulls)","NumberFilters":"Number Filters","ParentElement":"Parent Element","Priority":"Priority","RangeMode":"Range Mode","RangeType":"Range Type","RemoveActions":"R&amp;emove Actions","RemoveAllFields":"Remove All Fields","RemoveField":"Remove Field","RemoveMobileSurface":"Remove Mobile Surface","ReplaceValues":"Replace Values","ReportSnapshot":"Report Snapshot","RowsCount":"Rows Count","RunFieldsEditor":"Run Fields Editor","RunFieldsEditorInfo":"Run the Fields Editor to change interaction of each table column.","SelectAll":"(Select &amp;All)","ShowAllValue":"Show (All) Value","ShowAsPercentages":"Show as Percentages","ShowBlanks":"Show Blanks","SkipFirstRows":"Skip First Rows","SortAZ":"Sort A to Z","SortLargestToSmallest":"Sort Largest to Smallest","SortNewestToOldest":"Sort Newest to Oldest","SortOldestToNewest":"Sort Oldest to Newest","SortSmallestToLargest":"Sort Smallest to Largest","SortZA":"Sort Z to A","Sparklines":"Sparklines","StringFilters":"String Filters","TransformationHint":"Click on the table header to apply sorting, filtering or change data. This transformation will be applied only to the data of this item.","Trend":"Trend","ViewEditCompilationNotice":"You can\'t edit the report which has the \'Report.CalculationMode\' property equals to \'Compilation\' value. Please set that property to an \'Interpretation\' value.","ViewModeDesktop":"Desktop","ViewModeMobile":"Mobile"},"Database":{"Connection":"Connection","Database":"{0} Connection","DatabaseDB2":"IBM DB2 Connection","DatabaseFirebird":"Firebird Connection","DatabaseInformix":"Informix Connection","DatabaseJson":"JSON Data","DatabaseMySQL":"MySQL Connection","DatabaseOdbc":"ODBC Connection","DatabaseOleDb":"OLE DB Connection","DatabaseOracle":"Oracle Connection","DatabaseOracleODP":"Oracle ODP.NET Connection","DatabasePostgreSQL":"PostgreSQL Connection","DatabaseSql":"SQL Connection","DatabaseSqlCe":"SQLServerCE Connection","DatabaseSQLite":"SQLite Connection","DatabaseTeradata":"Teradata Connection","DatabaseUniDirect":"Uni Direct Connection","DatabaseVistaDB":"VistaDB Connection","DatabaseXml":"XML Data"},"DatePickerRanges":{"CurrentMonth":"Current Month","CurrentQuarter":"Current Quarter","CurrentWeek":"Current Week","CurrentYear":"Current Year","DaysAgo":"{0} Days Ago","FirstQuarter":"First Quarter","FourthQuarter":"Fourth Quarter","Index":"Index","Last14Days":"Last 14 Days","Last30Days":"Last 30 Days","Last7Days":"Last 7 Days","MonthToDate":"Month To Date","NextMonth":"Next Month","NextQuarter":"Next Quarter","NextWeek":"Next Week","NextYear":"Next Year","PreviousMonth":"Previous Month","PreviousQuarter":"Previous Quarter","PreviousWeek":"Previous Week","PreviousYear":"Previous Year","Quarter":"Quarter","QuarterToDate":"Quarter To Date","SecondQuarter":"Second Quarter","ThirdQuarter":"Third Quarter","Today":"Today","Tomorrow":"Tomorrow","WeekToDate":"Week To Date","Year":"Year","YearToDate":"Year To Date","Yesterday":"Yesterday"},"DesignerFx":{"AlreadyExists":"\'{0}\' already exists.","CanNotLoadThisReportTemplate":"Can\'t load this report template.","CloseDataSourceEditor":"Do you want to close data source editor?","CloseEditor":"Do you want to close editor?","CompilingReport":"Compiling Report","Connecting":"Connecting to Server","ConnectionError":"Connection error","ConnectionSuccessfull":"Connection was successful","Continue":"Continue","DecryptionError":"Decryption error: Wrong password or corrupted file.","EmailSuccessfullySent":"The Email has been successfully sent.","ErrorAtSaving":"Error at saving","ErrorCode":"Error at saving. Error code: {0}","ErrorServer":"Error at saving. Server doesn\'t respond.","ExportingReport":"Exporting Report","LoadingCode":"Loading Code","LoadingConfiguration":"Loading Configuration","LoadingData":"Loading Data","LoadingDocument":"Loading Document","LoadingImages":"Loading Images","LoadingLanguage":"Loading Language","LoadingReport":"Loading Report","PreviewAs":"Preview as {0}","RenderingReport":"Rendering Report","ReportSuccessfullySaved":"Report is successfully saved.","RetrieveError":"Retrieve columns error","RetrievingColumns":"Retrieving Columns","Saving":"Saving","SavingConfiguration":"Saving Configuration","SavingReport":"Saving Report","TestConnection":"Test Connection","TextNotFound":"The specified text was not found. Text : {0}"},"Desktop":{"Beginner":"Beginner","ButtonAddCloud":"Add Cloud Folder","ButtonAddFolder":"Add Folder","ButtonCreateDashboard":"Create Dashboard","ButtonCreateReport":"Create Report","ChooseYourSkillLevel":"Choose your skill level","Creator":"Creator","Developer":"Developer","DoYouWantToInstallReports":"Do you want to install templates of reports and dashboards?","InstallSamplesDesc":"Let\'s install our sample projects. They will help you learn the basics of working with our software.","PleaseAnswerWhoAreYou":"Please, answer who you are?","SkillLevel":"Skill Level","WhoAreYou":"Who Are you?","WhoAreYouBeginnerDescription":"Perfect fit if you are doing the first run of the designer.","WhoAreYouCreatorDescription":"Perfect fit for creating reports. The necessary functionality for design is available.","WhoAreYouDeveloperDescription":"Perfect fit for creating applications. Complete functionality for the report design and embedding components included."},"Dialogs":{"StiButtonControl":"Button","StiCheckBoxControl":"Check Box","StiCheckedListBoxControl":"Checked List Box","StiComboBoxControl":"Combo Box","StiDateTimePickerControl":"Date Time Picker","StiForm":"Form","StiGridControl":"Grid","StiGroupBoxControl":"Group Box","StiLabelControl":"Label","StiListBoxControl":"List Box","StiListViewControl":"List View","StiLookUpBoxControl":"LookUp Box","StiNumericUpDownControl":"Numeric Up Down","StiPanelControl":"Panel","StiPictureBoxControl":"Picture Box","StiRadioButtonControl":"Radio Button","StiReportControl":"Report Control","StiRichTextBoxControl":"Rich Text Box","StiTextBoxControl":"Text Box","StiTreeViewControl":"Tree View"},"Editor":{"AllowSQLFormatting":"Allow SQL Formatting","BetweenMetrics":"Between 1 and 10 metrics can be selected.","CantFind":"Cannot find the data you\'re searching for.","CollapseToDefinitions":"C&amp;ollapse to Definitions","Column":"Column: {0}","EntireScope":"&amp;Entire Scope","Find":"&amp;Find","FindNext":"&amp;Find Next","FindWhat":"Find What:","FromCursor":"From Cursor","GotoLine":"Go To &amp;Line","InsertLink":"Insert Link","InsertSymbol":"Insert Symbol","Line":"Line: {0}","LineNumber":"Line Number:","LineNumberIndex":"Line Number ({0} - {1})","MarkAll":"&amp;Mark All","MatchCase":"Match &amp;Case","MatchWholeWord":"Match &amp;Whole Word","MaximumDimensions":"Maximum 7 dimensions can be selected.","Outlining":"Out&amp;lining","PromptOnReplace":"Prompt on Replace","Replace":"&amp;Replace","ReplaceAll":"Replace &amp;All","ReplaceWith":"Replace With:","Search":"Search","SearchHiddenText":"Hidden Text","SearchUp":"Search &amp;Up","SelectionOnly":"Selection &amp;Only","ShowAutoGeneratedCode":"Show Auto Generated Code","ShowLineNumbers":"Show Line Numbers","StopOutlining":"Sto&amp;p Outlining","titleFind":"Find","titleGotoLine":"Go To Line","titleReplace":"Replace","ToggleAllOutlining":"Toggle A&amp;ll Outlining","ToggleOutliningExpansion":"&amp;Toggle Outlining Expansion","TypeToSearch":"Type to search","UseRegularExpressions":"Use &amp;Regular Expressions"},"Errors":{"ComponentIsNotRelease":"Component is not release \\"{0}\\".","ContainerIsNotValidForComponent":"Container {0} is not valid for component {1}.","DataNotFound":"Data not found.","DataNotLoaded":"No data loaded.","Error":"Error!","ErrorsList":"Errors List","FieldRequire":"Field \\"{0}\\" required filling.","FileNotFound":"File \\"{0}\\" not found.","IdentifierIsNotValid":"Identifier \'{0}\' is not valid.","ImpossibleFindDataSource":"Impossible to Find Data Source.","NameExists":"There is already an object named \'{0}\'. Objects must have unique names.","NoServices":"Services are not found in \'{0}\'","NotAssign":"Data Source is not specified.","NotCorrectFormat":"Input string was not in a correct format.","OneTableOfContentsAllowed":"Only one \'Table of Contents\' component can be used in a report at the same time!","PrimaryColumnAction":"Unable to apply this action to the primary column of the \'{0}\'.","RelationsNotFound":"Relations not found.","ReportCannotBeSaveDueToErrors":"Report cannot be saved due to errors!","ServiceNotFound":"\'{0}\' Service not found."},"ExceptionProvider":{"Assemblies":"Assemblies","ClickIgnore":"Click \'Ignore\' to delete all auto-saved files.","Exception":"Exception","ExceptionReport":"Exception Report","Framework":"Framework","General":"General","Message":"Message","Number":"Number","PleaseEnterDetailedInformation":"Please enter detailed information about events which cause this exception.","SaveToFile":"Save to File","SendErrorFailed":"Failed to deliver the error message.","SendErrorSuccess":"The error message delivered successfully.","Source":"Source","StackTrace":"Stack Trace","YouCanRestore":"You can restore unsaved changes from a backup file.","YourPreviousWorkSession":"In your previous work session, the designer terminated unexpectedly."},"Export":{"AddPageBreaks":"Add Page Breaks","AllBands":"All bands","AllowAddOrModifyTextAnnotations":"Allow Add or Modify Text Annotations","AllowCopyTextAndGraphics":"Allow Copy Text and Graphics","AllowEditable":"Allow Editable:","AllowModifyContents":"Allow Modify Contents","AllowPrintDocument":"Allow Print Document","Auto":"Auto","BandsFilter":"Bands Filter:","CancelExport":"Cancel Export","Color":"Color","Compressed":"Compressed","CompressToArchive":"Compress to Archive","ContinuousPages":"Continuous Pages","DataAndHeaders":"Data and Headers","DataAndHeadersFooters":"Data and Headers/Footers","DataOnly":"Data only","DigitalSignature":"Digital Signature","DigitalSignatureCertificateNotSelected":"Certificate is not selected","DigitalSignatureError":"Digital Signature error at step","DocumentSecurity":"Document Security","DotMatrixMode":"Dot-Matrix Mode","EmbeddedFonts":"Embedded Fonts","EmbeddedImageData":"Embedded Image Data","EnableAnimation":"Enable Animation","Encoding":"Encoding:","EncryptionError":"Encryption error at step","EscapeCodes":"Escape Codes","Exactly":"Exactly","ExceptEditableFields":"Except Editable Fields","ExportDataOnly":"Export Data Only","ExportEachPageToSheet":"Export Each Page to Sheet","Exporting":"Exporting","ExportingCalculatingCoordinates":"Calculating Coordinates","ExportingCreatingDocument":"Creating Document","ExportingFormatingObjects":"Formatting Objects","ExportingReport":"Exporting Report","ExportMode":"Export Mode:","ExportModeFrame":"Frame","ExportModeTable":"Table","ExportObjectFormatting":"Export Object Formatting","ExportPageBreaks":"Export Page Breaks","ExportRtfTextAsImage":"Export Rich Text as Image","ExportTypeBmpFile":"BMP Image...","ExportTypeCalcFile":"OpenDocument Calc File...","ExportTypeCsvFile":"CSV File...","ExportTypeDataFile":"Data File...","ExportTypeDbfFile":"dBase DBF File...","ExportTypeDifFile":"Data Interchange Format (DIF) File...","ExportTypeExcel2007File":"Microsoft Excel 2007 File...","ExportTypeExcelFile":"Microsoft Excel File...","ExportTypeExcelXmlFile":"Microsoft Excel XML File...","ExportTypeGifFile":"GIF Image...","ExportTypeHtml5File":"HTML5 File...","ExportTypeHtmlFile":"HTML File...","ExportTypeImageFile":"Image File...","ExportTypeJpegFile":"JPEG Image...","ExportTypeJsonFile":"JSON File...","ExportTypeMetafile":"Windows Metafile...","ExportTypeMhtFile":"MHT Web Archive...","ExportTypePcxFile":"PCX Image...","ExportTypePdfFile":"Adobe PDF File...","ExportTypePngFile":"PNG Image...","ExportTypePpt2007File":"Microsoft PowerPoint File...","ExportTypeRtfFile":"Rich Text File...","ExportTypeSvgFile":"Scalable Vector Graphics (SVG) File...","ExportTypeSvgzFile":"Compressed SVG (SVGZ) File...","ExportTypeSylkFile":"Symbolic Link (SYLK) File...","ExportTypeTiffFile":"TIFF Image...","ExportTypeTxtFile":"Text File...","ExportTypeWord2007File":"Microsoft Word File...","ExportTypeWriterFile":"OpenDocument Writer File...","ExportTypeXmlFile":"XML File...","ExportTypeXpsFile":"Microsoft XPS File...","GetCertificateFromCryptoUI":"Get Certificate from Crypto UI","ImageCompressionMethod":"Image Compression Method:","ImageCutEdges":"Cut Edges","ImageFormat":"Image Format:","ImageGrayscale":"Grayscale","ImageMonochrome":"Monochrome","ImageQuality":"Image Quality:","ImageResolution":"Image Resolution:","ImageResolutionMode":"Image Resolution Mode:","ImageType":"Image Type","labelEncryptionKeyLength":"Encryption Key Length:","labelOwnerPassword":"Owner Password:","labelSubjectNameString":"Subject Name String:","labelUserPassword":"User Password:","MonochromeDitheringType":"Monochrome Dithering Type:","MoreSettings":"More Settings","MultipleFiles":"Multiple Files","NoMoreThan":"No More Than","OpenAfterExport":"Open After Export","PdfACompliance":"PDF/A Compliance","PrintingReport":"Printing Report","RemoveEmptySpaceAtBottom":"Remove Empty Space at Bottom of Page","RestrictEditing":"Restrict Editing:","Scale":"Scale:","Separator":"Separator:","Settings":"Settings","SkipColumnHeaders":"Skip Column Headers","StandardPDFFonts":"Standard PDF Fonts","TiffCompressionScheme":"TIFF Compression Scheme:","title":"Export Settings","TxtBorderType":"Border Type","TxtBorderTypeDouble":"Unicode-Double","TxtBorderTypeSimple":"Simple","TxtBorderTypeSingle":"Unicode-Single","TxtCutLongLines":"Cut Long Lines","TxtDrawBorder":"Draw Border","TxtKillSpaceGraphLines":"Kill Space Graph Lines","TxtKillSpaceLines":"Kill Space Lines","TxtPutFeedPageCode":"Put Feed Page Code","Type":"Type:","UseDefaultSystemEncoding":"Use Default System Encoding","UseDigitalSignature":"Use Digital Signature","UseEscapeCodes":"Use Escape Codes","UseOnePageHeaderAndFooter":"Use One Page Header and Footer","UsePageHeadersAndFooters":"Use Page Headers and Footers","UseUnicode":"Use Unicode","X":"X:","Y":"Y:","Zoom":"Zoom:"},"FileFilters":{"AllFiles":"All Files","AllImageFiles":"All Image Files","BitmapFiles":"Bitmap Files","BmpFiles":"BMP Images (*.bmp)|*.bmp","CalcFiles":"OpenDocument Calc Files (*.ods)|*.ods","CsvFiles":"CSV Files (*.csv)|*.csv","DashboardTemplates":"Dashboard Templates (*.sbi)|*.sbi","DataSetXmlData":"DataSet XML Data (*.xml)|*.xml","DataSetXmlSchema":"DataSet XML Schema (*.xsd)|*.xsd","DbfFiles":"DBF Files (*.dbf)|*.dbf","DictionaryFiles":"Report Dictionaries (*.dct)|*.dct","DifFiles":"DIF Files (*.dif)|*.dif","DllFiles":"DLL Files (*.dll)|*.dll","DocumentFiles":"Report Documents (*.mdc)|*.mdc","EmfFiles":"Metafiles (*.emf)|*.emf","EncryptedDocumentFiles":"Encrypted Report Documents (*.mdx)|*.mdx","EncryptedReportFiles":"Encrypted Report Templates (*.mrx)|*.mrx","Excel2007Files":"Microsoft Excel files (*.xlsx)|*.xlsx","ExcelAllFiles":"Microsoft Excel files (*.xlsx;*.xls)|*.xlsx;*.xls","ExcelFiles":"Microsoft Excel 97-2003 files (*.xls)|*.xls","ExcelXmlFiles":"Microsoft Excel XML files (*.xml)|*.xml","ExeFiles":"EXE Files (*.exe)|*.exe","GifFiles":"GIF Image (*.gif)|*.gif","HtmlFiles":"HTML Files (*.html)|*.html","InheritedLanguageFiles":"{0} Classes for Inherited Reports (*.{1})|*.{2}","JpegFiles":"JPEG image (*.jpg;*.jpeg)|*.jpg;*.jpeg","JsonDocumentFiles":"JSON Report Documents (*.mdc)|*.mdc","JsonFiles":"JSON Files (*.json)|*.json","JsonReportFiles":"JSON Report Templates (*.mrt)|*.mrt","LanguageFiles":"{0} Classes (*.{1})|*.{2}","LanguageForSilverlightFiles":"{0} Classes for Silverlight Reports (*.{1})|*.{2}","MetaFiles":"Metafiles","MhtFiles":"MHT Web Archives (*.mht)|*.mht","PackedDocumentFiles":"Packed Report Documents (*.mdz)|*.mdz","PackedReportFiles":"Packed Report Templates (*.mrz)|*.mrz","PageFiles":"Report Pages (*.pg)|*.pg","PcxFiles":"PCX Images (*.pcx)|*.pcx","PdfFiles":"Adobe PDF Files (*.pdf)|*.pdf","PngFiles":"PNG Images (*.png)|*.png","Ppt2007Files":"Microsoft PowerPoint 2007/2013 Files (*.pptx)|*.pptx","ReportEmbededDataFiles":"Report Templates with Embedded Data (*.mrt)|*.mrt","ReportFiles":"Report Templates (*.mrt)|*.mrt","RtfFiles":"Rich Text (*.rtf)|*.rtf","StandaloneReportFiles":"Standalone Reports (*.exe)|*.exe","StylesFiles":"Report Styles (*.sts)|*.sts","SvgFiles":"SVG Images (*.svg)|*.svg","SvgzFiles":"Compressed SVG Images (*.svgz)|*.svgz","SylkFiles":"SYLK Files (*.slk)|*.slk","TiffFiles":"TIFF Images (*.tiff)|*.tiff","TxtFiles":"Plain Text Files (*.txt)|*.txt","Word2007Files":"Microsoft Word 2007-2016 Files (*.docx)|*.docx","WordFiles":"Microsoft Word 97-2003 Files (*.doc)|*.doc","WriterFiles":"OpenDocument Writer Files (*.odt)|*.odt","XmlFiles":"XML Files (*.xml)|*.xml","XpsFiles":"Microsoft XPS Files (*.xps)|*.xps","ZipArchives":"ZIP Archives (*.zip)|*.zip"},"Formats":{"custom01":"d","custom02":"D","custom03":"f","custom04":"F","custom05":"yy/MM/dd","custom06":"yyyy/MM/dd","custom07":"G","custom08":"$0.00","custom09":"$0","custom10":"c","custom11":"c1","custom12":"c2","custom13":"#.00","custom14":"#.#","custom15":"n","custom16":"n1","custom17":"n2","custom18":"(###) ### - ####","date01":"*d","date02":"*D","date03":"M.dd","date04":"yy.M.dd","date05":"yy.MM.dd","date06":"MMM.dd","date07":"yy.MMM.dd","date08":"yyyy, MMMM","date09":"*f","date10":"*F","date11":"MM.dd.yyyy","date12":"dd/MM/yyyy","date13":"*g","date14":"*G","date15":"*y","date16":"*m","date17":"s","date18":"u","date19":"*Q","date20":"*YQ","date21":"QI","date22":"YQI","time01":"*t","time02":"*T","time03":"HH:mm","time04":"H:mm","time06":"HH:mm:ss"},"FormBand":{"AddFilter":"&amp;Add Filter","AddGroup":"&amp;Add Group","AddResult":"&amp;Add Result","AddSort":"&amp;Add Sort","And":"and","Ascending":"Ascending","Descending":"Descending","NoFilters":"No Filters","NoSort":"No Sorting","RemoveFilter":"&amp;Remove Filter","RemoveGroup":"&amp;Remove Group","RemoveResult":"&amp;Remove Result","RemoveSort":"&amp;Remove Sort","SortBy":"Sort by","ThenBy":"Then by","title":"Data Setup"},"FormColorBoxPopup":{"Color":"Color","Custom":"Custom","NoColor":"No Color","Others":"Others...","System":"System","Web":"Web"},"FormConditions":{"AaBbCcYyZz":"AaBbCcYyZz","AddCondition":"&amp;Add Condition","AddLevel":"Add Level","AssignExpression":"Assign Expression","BreakIfTrue":"Break if True","BreakIfTrueToolTip":"Breaks condition processing if current one is fulfilled","ChangeBorder":"Change Border...","ChangeFont":"Change Font...","ComponentIsEnabled":"Component is Enabled","NoConditions":"No Conditions","RemoveCondition":"&amp;Remove Condition","SelectStyle":"Select Style","title":"Conditions"},"FormCrossTabDesigner":{"Columns":"Columns:","DataSource":"Data Source:","Properties":"Properties:","Rows":"Rows:","Summary":"Summary:","Swap":"Swap Rows / Columns","title":"Cross-Tab Designer"},"FormDatabaseEdit":{"AccessToken":"Access token","AccountKey":"Account Key","AccountName":"Account Name","AuthorizationCode":"Authorization Code","BlobContentType":"Blob Content Type","BlobName":"Blob Name","ClientId":"Client Id","ClientSecret":"Client Secret","ConnectionString":"Connection String:","ContainerName":"Container Name","DashboardConnections":"Dashboard Connections","DatabaseSecret":"Database Secret","DatasetId":"Dataset Id","DB2Edit":"Edit IBM DB2 Connection","DB2New":"New IBM DB2 Connection","EditConnection":"Edit {0} Connection","Favorites":"Favorites","FirebirdEdit":"Edit Firebird Connection","FirebirdNew":"New Firebird Connection","FirstRowIsHeader":"First Row is Header","GetAuthorizationCode":"Get authorization code","GetTokens":"Get tokens","GisEdit":"Edit GIS Data","GisNew":"New GIS Data","ImportData":"Import Data","InformixEdit":"Edit Informix Connection","InformixNew":"New Informix Connection","InitialCatalog":"Initial Catalog:","JsonEdit":"Edit JSON Data","JsonNew":"New JSON Data","MySQLEdit":"Edit MySQL Connection","MySQLNew":"New MySQL Connection","NewConnection":"New {0} Connection","OdbcEdit":"Edit ODBC Connection","OdbcNew":"New ODBC Connection","OleDbEdit":"Edit OLE DB Connection","OleDbNew":"New OLE DB Connection","OracleEdit":"Edit Oracle Connection","OracleNew":"New Oracle Connection","OracleODPEdit":"Edit Oracle ODP.NET Connection","OracleODPNew":"New Oracle ODP.NET Connection","PathData":"Path to XML Data:","PathGisData":"Path to Gis Data:","PathJsonData":"Path to JSON Data:","PathSchema":"Path to XSD Schema:","PathToData":"Path to Data:","Pin":"Pin","PostgreSQLEdit":"Edit PostgreSQL Connection","PostgreSQLNew":"New PostgreSQL Connection","ProjectId":"Project Id","PromptUserNameAndPassword":"Prompt User Name and Password","RecentConnections":"Recent","RedirectUrl":"Redirect URL","RefreshAccessToken":"Refresh access token","RefreshToken":"Refresh token","RelationDirection":"Relation Direction:","ReportConnections":"Report Connections","SelectData":"Select Data","ServiceAccountKeyFile":"Service Account Key File","SpreadsheetId":"Spreadsheet Id","SqlCeEdit":"Edit SQLServerCE Connection","SqlCeNew":"New SQLServerCE Connection","SqlEdit":"Edit SQL Connection","SQLiteEdit":"Edit SQLite Connection","SQLiteNew":"New SQLite Connection","SqlNew":"New SQL Connection","TeradataEdit":"Edit Teradata Connection","TeradataNew":"New Teradata Connection","Token":"Token","UniDirectEdit":"Edit Uni Direct Connection","UniDirectNew":"New Uni Direct Connection","Unpin":"Unpin","UseBearerAuthentication":"Use Bearer Authentication","UseOwnClientID":"Use own \\"Client ID\\" and \\"Client Secret\\"","UseToken":"Use Token","VistaDBEdit":"Edit VistaDB Connection","VistaDBNew":"New VistaDB Connection","XmlEdit":"Edit XML Data","XmlNew":"New XML Data","XmlType":"XML Type:"},"FormDesigner":{"Code":"Code","ColumnsOne":"One","ColumnsThree":"Three","ColumnsTwo":"Two","CompilingReport":"Compiling Report","CopyPropertyName":"Copy Property Name","DockingPanels":"Panels","HtmlPreview":"HTML Preview","JsPreview":"JS Preview","labelPleaseSelectTypeOfInterface":"Please, select type of interface","LoadImage":"Load Image...","LocalizePropertyGrid":"Localize Property Grid","MarginsNarrow":"Narrow","MarginsNormal":"Normal","MarginsWide":"Wide","OrderToolbars":"Order Toolbars","Others":"Others","Pages":"Pages","Preview":"Preview","PropertyChange":"Change of property \'{0}\'","RTPreview":"WinRT Preview","SetupToolbox":"Setup Toolbox","ShowDescription":"Show Description","SLPreview":"Silverlight Preview","title":"Designer","WebPreview":"Flash Preview"},"FormDictionaryDesigner":{"Actions":"Actions","AutoSort":"Auto Sort","BusinessObjectEdit":"Edit Business Object","CalcColumnEdit":"Edit Calculated Column","CalcColumnNew":"New Calculated Column","CategoryEdit":"Edit Category","CategoryNew":"New Category","Child":"Child","ChildOfBusinessObject":"Child of Business Object","ChildSource":"Child Data Source:","ClickHere":"Click here","ColumnEdit":"Edit Column","ColumnNew":"New Column","CreateNewDataSource":"to create the new data source","CreateNewReport":"to create the new report","CsvSeparatorComma":"Comma","CsvSeparatorOther":"Other","CsvSeparatorSemicolon":"Semicolon","CsvSeparatorSpace":"Space","CsvSeparatorSystem":"System","CsvSeparatorTab":"Tab","DatabaseEdit":"Edit Database","DatabaseNew":"New Database","DataMonitor":"Data Monitor","DataParameterEdit":"Edit Parameter","DataParameterNew":"New Parameter","DataSetToBusinessObjects":"DataSet To Business Objects","DataSourceEdit":"Edit Data Source","DataSourceNew":"New Data Source","DataSourcesNew":"New Data Sources","DataTransformationEdit":"Edit Data Transformation","DataTransformationNew":"New Data Transformation","Delete":"Delete","DesignTimeQueryText":"Design-Time Query Text","DictionaryMerge":"Merge Dictionary...","DictionaryNew":"New Dictionary...","DictionaryOpen":"Open Dictionary...","DictionarySaveAs":"Save Dictionary As...","DragNewDataSource":"drag your data directly to this panel","DragNewReport":"drag your report directly to this panel","EditQuery":"Edit Query","EnableDataMonitor":"Enable Data Monitor","ExecutedSQLStatementSuccessfully":"SQL statement executed successfully","ExpressionNew":"New Expression","GetColumnsFromAssembly":"Get Columns from Assembly","HideUnsupportedDatabases":"Hide Unsupported Data Sources","ImportRelations":"Import Relations","LabelSeparator":"Separator:","MarkUsedItems":"Mark Used Items","NewBusinessObject":"New Business Object","NewItem":"New Item","OpenAssembly":"Open Assembly","Parent":"Parent","ParentSource":"Parent Source:","Queries":"Queries","QueryNew":"New Query","QueryText":"Query Text","QueryTimeout":"Query Timeout","RelationEdit":"Edit Relation","RelationNew":"New Relation","ResourceEdit":"Edit Resource","ResourceNew":"New Resource","RetrieveColumns":"Retrieve Columns","RetrieveColumnsAllowRun":"Allow Run StoredProc","RetrieveColumnsAndParameters":"Retrieve Columns and Parameters","RetrieveParameters":"Retrieve Parameters","RetrievingDatabaseInformation":"Retrieving database information...","Run":"Run","SelectTypeOfBusinessObject":"Select Type of Business Object","SkipSchemaWizard":"Skip Schema Wizard","SortItems":"Sort Items","Synchronize":"Synchronize","SynchronizeHint":"Synchronizes contents of the Data Store and contents of the Dictionary","TextDropDataFileHere":"Drop Data File Here","TextDropFileHere":"Drop File Here","TextDropImageHere":"Drop Image File Here","title":"Dictionary Designer","ValueNew":"New Value","VariableEdit":"Edit Variable","VariableNew":"New Variable","ViewData":"View Data","ViewQuery":"View Query"},"FormFormatEditor":{"Boolean":"Boolean","BooleanDisplay":"Display:","BooleanValue":"Value:","Currency":"Currency","CurrencySymbol":"Currency Symbol:","Custom":"Custom","Date":"Date","DateTimeFormat":"Date Time Format","DecimalDigits":"Decimal Digits:","DecimalSeparator":"Decimal Separator:","FormatMask":"Format Mask:","Formats":"Formats","General":"General","GroupSeparator":"Group Separator:","GroupSize":"Group Size:","nameFalse":"False","nameNo":"No","nameOff":"Off","nameOn":"On","nameTrue":"True","nameYes":"Yes","NegativeInRed":"Negative in Red","NegativePattern":"Negative Pattern:","Number":"Number","Percentage":"Percentage","PercentageSymbol":"Percentage Symbol:","PositivePattern":"Positive Pattern:","Properties":"Properties","Sample":"Sample","SampleText":"Sample Text","TextFormat":"Text Format","Time":"Time","title":"Format","UseAbbreviation":"Use Abbreviation","UseGroupSeparator":"Use Group Separator","UseLocalSetting":"Use Local Setting"},"FormGlobalizationEditor":{"AddCulture":"&amp;Add Culture","AutoLocalizeReportOnRun":"Auto Localize Report on Run","CreateNewCulture":"to create the new culture","GetCulture":"Get Culture Settings from Report","qnGetCulture":"Do you really want to get culture settings from report and override current culture settings?","qnSetCulture":"Do you really want to set culture settings to report components?","RemoveCulture":"&amp;Remove Culture","SetCulture":"Set Culture Settings to Report","title":"Globalization Editor"},"FormInteraction":{"HyperlinkExternalDocuments":"Hyperlink to External Document","HyperlinkUsingInteractionBookmark":"Hyperlink using Bookmark","HyperlinkUsingInteractionTag":"Hyperlink using Tag"},"FormOptions":{"AutoSave":"Auto Save","AutoSaveReportToReportClass":"Auto Save Report to C# or VB.NET File","BlankDashboard":"Blank Dashboard","BlankForm":"Blank Form","BlankReport":"Blank Report","BlankScreen":"Blank Screen","Default":"Default","DefaultScriptMode":"Default Script Mode","Drawing":"Drawing","DrawMarkersWhenMoving":"Draw Markers When Moving","EditAfterInsert":"Edit After Insert","EnableAutoSaveMode":"Enable Auto Save Mode","FillBands":"Fill Bands","FillComponents":"Fill Components","FillContainers":"Fill Containers","FillCrossBands":"Fill Cross Bands","GenerateLocalizedName":"Generate Localized Name","Grid":"Grid","GridDots":"Dots","GridLines":"Lines","GridMode":"Grid Mode","GridSize":"Grid Size","groupAutoSaveOptions":"Auto save options","groupColorScheme":"Please select color scheme of GUI","groupGridDrawingOptions":"Grid drawing options","groupGridOptions":"Grid options","groupGridSize":"Grid size","groupMainOptions":"Main options for working with designer","groupMarkersStyle":"Marker style","groupOptionsOfQuickInfo":"Options of Quick Info","groupPleaseSelectTypeOfGui":"Please, select the type of GUI","groupReportDisplayOptions":"Report display options","labelColorScheme":"Color Scheme:","labelInfoAutoSave":"Change parameters of reports autosaving","labelInfoDrawing":"Setting parameters of report drawing","labelInfoGrid":"How Grid is shown and used in a report","labelInfoGui":"Select the mode of using GUI in the report designer","labelInfoMain":"Setting basic parameters of the report designer","labelInfoQuickInfo":"Components Quick Info on a page","Main":"Main","MarkersStyle":"Markers Style","MarkersStyleCorners":"Corners","MarkersStyleDashedRectangle":"Dashed Rectangle","MarkersStyleNone":"None","MessageLeftRightNotValid":"Left and Right value is not a valid.","MessageTopBottomNotValid":"Top and Bottom value is not a valid.","Minutes":"{0} minutes","SaveReportEvery":"Save Report Every:","ScaleMode":"Scale Mode","SelectUILanguage":"Select UI Language","ShowDialogForms":"Show Dialog Forms","ShowDimensionLines":"Show Dimension Lines","ShowOldGaugeEditor":"Show Old Gauge Editor","StartScreen":"Start Screen","title":"Options","UseComponentColor":"Use Component Color for Filling","UseLastFormat":"Use Last Format","Welcome":"Welcome"},"FormPageSetup":{"ApplyTo":"Apply to","Bottom":"Bottom:","Columns":"Columns","groupColumns":"Page columns","groupImage":"Watermark image","groupMargins":"Page margins","groupOrientation":"Paper orientation","groupPaper":"Paper size","groupPaperSource":"Paper source","groupText":"Watermark text","Height":"Height:","labelAngle":"Angle:","labelColumnGaps":"Column Gaps:","labelColumnWidth":"Column Width:","labelImageAlignment":"Image Alignment:","labelImageTransparency":"Image Transparency:","labelInfoColumns":"Setting page columns","labelInfoPaper":"Setting size and orientation for the current page","labelInfoUnit":"Page margins are specified in the current units","labelInfoWatermark":"Setting parameters for showing watermark","labelMultipleFactor":"Multiple Factor:","labelPaperSourceOfFirstPage":"Paper Source of First Page:","labelPaperSourceOfOtherPages":"Paper Source of Other Pages:","labelSelectBrush":"Select Brush:","labelSelectColor":"Select Color:","labelSelectFont":"Select Font:","labelSelectImage":"Select Image:","labelText":"Text:","Left":"Left:","Margins":"Margins","NumberOfColumns":"Number of Columns:","Orientation":"Orientation","PageOrientationLandscape":"Landscape","PageOrientationPortrait":"Portrait","Paper":"Paper:","RebuildReport":"Rebuild Report","Right":"Right:","ScaleContent":"Scale Content","Size":"Size:","title":"Page Setup","Top":"Top:","Width":"Width:"},"FormReportSetup":{"groupDates":"A date of report creation and a date of the last report change","groupDescription":"Report description","groupMainParameters":"Parameters which effect on report rendering","groupNames":"Report name, report alias, and report author","groupScript":"Script language of your report","groupUnits":"Size and coordinates in a report will be in specified units","labelInfoDescription":"Indicate the information of a report","labelInfoMain":"Change of basic report parameters","labelNumberOfPass":"Number of Pass:","labelReportCacheMode":"Report Cache Mode:","ReportChanged":"Report Changed:","ReportCreated":"Report Created:","title":"Report Options"},"FormRichTextEditor":{"Bullets":"Bullets","FontName":"Font Name","FontSize":"Font Size","Insert":"Insert Expression","title":"Rich Text Editor"},"FormStyleDesigner":{"Add":"Add Style","AddCollectionName":"Add Collection Name","ApplyStyleCollectionToReportComponents":"Apply Style Collection to Report Components","ApplyStyles":"Apply Styles","ColorCollectionEditor":"Color Collection Editor","CreateNewComponentStyle":"to create the new component style","CreateStyleCollection":"Create Style Collection","CreateStyleOnBase":"Create a style based on another style","Duplicate":"Duplicate Style","EditColors":"Edit Colors","FromStyle":"From Style","GetStyle":"Get Style from Selected Components","MoreStyles":"More Styles","NotSpecified":"Not Specified","Open":"Open Style","Predefined":"Predefined","qnApplyStyleCollection":"Do you want to apply style collection to report components?","Remove":"Remove Style","RemoveExistingStyles":"Remove Existing Styles","Save":"Save Style","Style":"Style","StyleCollectionsNotFound":"Style Collections Not Found!","title":"Style Designer"},"FormSystemTextEditor":{"Condition":"Condition","LabelDataBand":"Data Band:","LabelDataColumn":"Data Column:","LabelShowInsteadNullValues":"Show Instead Null Values:","LabelSummaryFunction":"Summary Function:","pageExpression":"Expression","pageSummary":"Summary","pageSystemVariable":"System Variable","RunningTotal":"Running Total","SummaryRunning":"Summary Running","SummaryRunningByColumn":"Column","SummaryRunningByPage":"Page","SummaryRunningByReport":"Report"},"FormTitles":{"ChartWizardForm":"Chart Wizard","ConditionEditorForm":"Condition","ConnectionSelectForm":"Select Type of Connection","ContainerSelectForm":"Select Container","DataAdapterServiceSelectForm":"Select Type of Data","DataRelationSelectForm":"Select Data Relation","DataSetName":"Enter DataSet Name","DataSourceSelectForm":"Select Data Source","DataSourcesNewForm":"New Data Sources","DataStoreViewerForm":"Data Store Viewer","DesignerApplication":"Report Designer","EventEditorForm":"Event Editor","ExpressionEditorForm":"Expression Editor","GroupConditionForm":"Group","InteractionDrillDownPageSelectForm":"Select Drill-Down Page","MasterComponentSelectForm":"Select Master Component","PageAddForm":"Add Page","PageSizeForm":"Page Size","PagesManagerForm":"Pages Manager","PromptForm":"Enter information to logon on to the database","ReportWizard":"Report Wizard","ServiceSelectForm":"Select Service","SqlExpressionsForm":"SQL Expressions","SubReportPageSelectForm":"Select Sub-Report Page","TextEditorForm":"Text Editor","ViewDataForm":"View Data","ViewerApplication":"Report Viewer"},"FormViewer":{"Bookmarks":"Bookmarks","Close":"Close","CollapseAll":"Collapse All","CompressedDocumentFile":"Compressed Document File","ContextMenu":"Context Menu","DocumentFile":"Document File...","Editor":"Editor","EncryptedDocumentFile":"Encrypted Document File","ExpandAll":"Expand All","Export":"Export...","Find":"Find","FirstPage":"First Page","FullScreen":"Full Screen","GoToPage":"Go To Page","HorScrollBar":"Horizontal Scroll Bar","LabelPageN":"Page:","LastPage":"Last Page","NextPage":"Next Page","Open":"Open...","PageControl":"Page Control","PageDelete":"Delete Page","PageDesign":"Edit Page...","PageNew":"New Page","PageNofM":"Page {0} of {1}","PageofM":"of {0}","PageSize":"Page Size...","PageViewModeContinuous":"Continuous","PageViewModeMultiplePages":"Multiple Pages","PageViewModeSinglePage":"Single Page","Parameters":"Parameters","PrevPage":"Previous Page","Print":"Print...","qnPageDelete":"Do you want to delete page?","Save":"Save...","SendEMail":"Send Email...","StatusBar":"Status Bar","Thumbnails":"Thumbnails","title":"Viewer","titlePageSettings":"Page Settings","Toolbar":"Tool bar","VerScrollBar":"Vertical Scroll Bar","ViewMode":"View Mode","Zoom":"Zoom","ZoomMultiplePages":"Multiple Pages","ZoomOnePage":"One Page","ZoomPageWidth":"Page Width","ZoomTwoPages":"Two Pages","ZoomXXPages":"{0} X {1} Pages","ZoomXXPagesCancel":"Cancel"},"FormViewerFind":{"Close":"Close","FindNext":"Find Next","FindPrevious":"Find Previous","FindWhat":"Find What:"},"Gauge":{"AddNewItem":"Add New Item","BarRangeList":"Bar Range List","GaugeEditorForm":"Gauge Editor","Kind":"Kind","LinearBar":"Linear Bar","LinearMarker":"Linear Marker","LinearRange":"Linear Range","LinearRangeList":"Linear Range List","LinearScale":"Linear Scale","LinearTickLabelCustom":"Linear Tick Label Custom","LinearTickLabelMajor":"Linear Tick Label Major","LinearTickLabelMinor":"Linear Tick Label Minor","LinearTickMarkCustom":"Linear Tick Mark Custom","LinearTickMarkMajor":"Linear Tick Mark Major","LinearTickMarkMinor":"Linear Tick Mark Minor","Needle":"Needle","RadialBar":"Radial Bar","RadialMarker":"Radial Marker","RadialRange":"Radial Range","RadialRangeList":"Radial Range List","RadialScale":"Radial Scale","RadialTickLabelCustom":"Radial Tick Label Custom","RadialTickLabelMajor":"Radial Tick Label Major","RadialTickLabelMinor":"Radial Tick Label Minor","RadialTickMarkCustom":"Radial Tick Mark Custom","RadialTickMarkMajor":"Radial Tick Mark Major","RadialTickMarkMinor":"Radial Tick Mark Minor","StateIndicator":"State Indicator","StateIndicatorFilter":"State Indicator Filter","TickCustomValue":"Tick Custom Value"},"Gui":{"barname_cancel":"Cancel","barname_caption":"New Toolbar","barname_msginvalidname":"Toolbar name cannot be empty.","barname_name":"&amp;Toolbar Name:","barname_ok":"OK","barrename_caption":"Rename Toolbar","barsys_autohide_tooltip":"Auto-Hide","barsys_close_tooltip":"Close","barsys_customize_tooltip":"Customize","ClickAndDragPickColor":"Click and Drag to pick color","colorpicker_morecolors":"&amp;More Colors...","colorpicker_nofill":"&amp;No Fill","colorpicker_standardcolorslabel":"Standard Colors","colorpicker_themecolorslabel":"Theme Colors","colorpickerdialog_alphalabel":"&amp;Alpha:","colorpickerdialog_bluelabel":"&amp;Blue:","colorpickerdialog_cancelbutton":"Cancel","colorpickerdialog_caption":"Colors","colorpickerdialog_colormodellabel":"Color Model:","colorpickerdialog_currentcolorlabel":"Current","colorpickerdialog_customcolorslabel":"Colors:","colorpickerdialog_greenlabel":"&amp;Green:","colorpickerdialog_newcolorlabel":"New","colorpickerdialog_okbutton":"OK","colorpickerdialog_redlabel":"&amp;Red:","colorpickerdialog_rgblabel":"RGB","colorpickerdialog_standardcolorslabel":"Colors:","colorpickerdialog_tabcustom":"Custom","colorpickerdialog_tabstandard":"Standard","cust_btn_close":"Close","cust_btn_delete":"Delete","cust_btn_keyboard":"&amp;Keyboard...","cust_btn_new":"&amp;New...","cust_btn_rename":"&amp;Rename...","cust_btn_reset":"&amp;Reset...","cust_btn_resetusage":"&amp;Reset my usage data","cust_caption":"Customize","cust_cbo_fade":"Fade","cust_cbo_none":"(None)","cust_cbo_random":"Random","cust_cbo_slide":"Slide","cust_cbo_system":"System Default","cust_cbo_unfold":"Unfold","cust_chk_delay":"Show full menus after a short delay","cust_chk_fullmenus":"Always show full menus","cust_chk_showsk":"Show &amp;Shortcut Keys in ScreenTips","cust_chk_showst":"Show Screen&amp;Tips on Toolbars","cust_lbl_cats":"Cate&amp;gories:","cust_lbl_cmds":"Comman&amp;ds:","cust_lbl_cmdsins":"To add a command to Bar select the category and drag the command out of this box to a Bar.","cust_lbl_menuan":"Menu Animation:","cust_lbl_other":"Other:","cust_lbl_pmt":"Personalized Menus and Toolbars","cust_lbl_tlbs":"Toolb&amp;ars:","cust_mnu_addremove":"&amp;Add or Remove Buttons","cust_mnu_cust":"Customize...","cust_mnu_reset":"Reset Bar","cust_mnu_tooltip":"Bar Options","cust_msg_delete":"Are you sure you want to delete the &lt;barname&gt; toolbar?","cust_pm_begingroup":"Begin Group","cust_pm_delete":"Delete","cust_pm_name":"Name:","cust_pm_reset":"Reset","cust_pm_stydef":"Default Style","cust_pm_styimagetext":"Image and Text (Always)","cust_pm_stytextonly":"Text Only (Always)","cust_tab_commands":"Commands","cust_tab_options":"Options","cust_tab_toolbar_alignment":"Toolbar Alignment","cust_tab_toolbars":"Toolbars","mdisysmenu_close":"Close","mdisysmenu_maximize":"Maximize","mdisysmenu_minimize":"Minimize","mdisysmenu_move":"Move","mdisysmenu_next":"Next","mdisysmenu_restore":"Restore","mdisysmenu_size":"Size","mdisystt_close":"Close","mdisystt_minimize":"Minimize","mdisystt_restore":"Restore","monthcalendar_clearbutton":"Clear","monthcalendar_todaybutton":"Today","navbar_navpaneoptions":"Na&amp;vigation Pane Options...","navbar_showfewerbuttons":"Show &amp;Fewer Buttons","navbar_showmorebuttons":"Show &amp;More Buttons","navPaneCollapseTooltip":"Collapse the Navigation Pane","navPaneExpandTooltip":"Expand the Navigation Pane","sys_custombar":"Custom Bar","sys_morebuttons":"More Buttons"},"HelpComponents":{"StiBarCode":"This component allows showing bar codes in a report. Bar code data are sent to an object as a string. The string may contain any symbols but only allowed symbols for the selected chart can be displayed.","StiButtonElement":"This component is used to execute an event script when a user is interacting.","StiCardsElement":"This component is used to display grouped data as cards.","StiChart":"This component allows showing charts in a report. Different types of charts are available. Among them are bar, line, pie, doughnut, lines, areas, Gantt, scatter charts etc. ","StiChartElement":"This element allows showing charts in a dashboard. Different types of charts are available.","StiCheckBox":"This component allows showing a checkbox in a report. It can display two modes: \\"enable\\" or \\"disable\\".","StiChildBand":"The Child band can be used to output two bands on one data row.","StiClone":"This component is used to clone parts of a report into a required part of a report. Cloning can be applied only to the panel contents.","StiColumnFooterBand":"This band is used to output footers of columns on the Data band. The Column Footer band is output once under each column. All components which are placed on this band will also be output under each column.","StiColumnHeaderBand":"This band is used to output column headers. The Column Header band is used to output only once. All components which are placed on the band can be output above each column.","StiComboBoxElement":"Represents the ComboBox that is used to either type a value directly into the control or choose from the list of existing options.","StiContainer":"This is the rectangular region where other components, including bands, can be placed. When moving the container the components in it will be moved too. The container can be placed both on a band and on a page.","StiCrossDataBand":"This band is connected to the data source. It is output as many times as there are rows in the data source. A Cross band is output from left to right.","StiCrossFooterBand":"This band is used to output footers of the Cross-Data band. The band is output once after all rows of the Data band. A Cross band is output from left to right.","StiCrossGroupFooterBand":"This band is used to output footers of a group. It is placed under the Cross-Data band. Each Cross-Footer belongs to the specified Cross-Header band. A Cross band is output from left to right.","StiCrossGroupHeaderBand":"This band is the basic one for the report rendering with grouping, when Cross-Data are used. It is impossible to create grouping without this band. The components for showing information by the group are placed on the group header. The information can be group name, date, condition of grouping etc. The band is output in the beginning of each group. A Cross band is output from left to right.","StiCrossHeaderBand":"This band is used to output headers. It is used in association with the Cross band. A Cross band is output from left to right.","StiCrossTab":"The cross-tab component is used for the structured data representation as a table.","StiDataBand":"The Data band is connected to the data source and is output as many times as there are rows in the data source.","StiDatePickerElement":"The element is used to select the date and time.","StiEmptyBand":"This band is used to fill free space on the bottom of a page. This band fills free space on each page of a report.","StiFilterCategory":"A group of elements used for selecting and filtering values.","StiFooterBand":"This band is used to output summary by the Data band. It is placed under the Data band and is output once after all data rows which Data band outputs.","StiGauge":"The component allows you to display a value within a predefined range. It can have different graphical representation.","StiGaugeElement":"The element allows you to display a value within a predefined range. It can have different graphical representation.","StiGroupFooterBand":"The Group Footer band is used to output the group footer. This band is placed after the Data band. And this is the Data band with what the Group Header band is bound. Each Group Footer band belongs to the specified Group Header band. The Group Footer band will not be output without the Group Header band.","StiGroupHeaderBand":"This band is the basic band for rendering reports with grouping. The components for showing information by this group are placed on the group header. It can be group name, date, condition of grouping etc. This band is output once in the beginning of each group.","StiHeaderBand":"This band is used to output headers. It is used together with the data band.","StiHierarchicalBand":"This band is connected to the data source and output as many times as there are rows in the data source. Data are output as a tree.","StiHorizontalLinePrimitive":"This component is used to output a line.","StiImage":"This component is used to output images.","StiImageElement":"This element is used to output images. It supports the following graphic formats, such as BMP, JPG, JPEG, GIF, TIFF, PNG, ICO, WMF, EMF.","StiIndicatorElement":"The element displays the difference in values between the input data.","StiListBoxElement":"The element allows selecting items from a list.","StiMap":"This component is used to display data that is geographically targeted.","StiMapCategory":"Group of elements for working with maps and data.","StiMapElement":"This element is used to display data that is geographically targeted.","StiMathFormula":"This component is used to display math formulas in a report.","StiOnlineMapElement":"This element is used to display geographic markers on the online map.","StiOverlayBand":"This band is used to output watermarks on a page.","StiPageFooterBand":"This band is used to output the information on the bottom of each page such as page numbers, dates, and other additional information.","StiPageHeaderBand":"This band is used to output the page header such as page numbers, dates, and other additional information. It is output on the top of each page.","StiPanel":"A rectangular region that can contain other components, including bands. When the panel is moved the components in it are moved too. A panel can be placed either on a band or on a page.","StiPanelElement":"A rectangular region that can contain other elements. When the panel is moved the elements in it are moved too.","StiPivotTableElement":"The pivot table element is used for the structured data representation as a table.","StiProgressElement":"The element displays the ratio of the input data. It can be presented in different modes - a pie, donut, bars.","StiRectanglePrimitive":"This component is used to output rectangles.","StiRegionMapElement":"This element is used to display data that is geographically targeted.","StiReportSummaryBand":"This band is used to output summaries through the entire report. It is output once in the end of a report.","StiReportTitleBand":"This band is used to output the report title. It is output in the beginning of a report.","StiRichText":"This component is used to output and edit the RTF text. It also supports loading and saving files in the RTF format.","StiRoundedRectanglePrimitive":"This component is used to output rounded rectangles.","StiShape":"This component is used to insert ready-made shapes, such as arrows, diagonal line down, diagonal line up, horizontal line, left and right lines, oval, rectangle, rounded rectangle, top and bottom lines, triangle, vertical line.","StiShapeElement":"This element is used to insert ready-made shapes, such as arrows, diagonal line down, diagonal line up, horizontal line, left and right lines, oval, rectangle, rounded rectangle, top and bottom lines, triangle, vertical line.","StiSignature":"This component is used to add an electronic or digital signature to a report.","StiSparkline":"This component is used to create micrographics in a report. It allows you to track dynamically changing data as bars, lines, areas.","StiSubReport":"This component is used to output additional data in different places of a report.","StiTable":"This component is a set of data elements that is organized using a model of vertical columns and horizontal rows.","StiTableElement":"This element is a set of data elements that is organized using a model of vertical columns and horizontal rows.","StiTableOfContents":"This component is used to create a table of contents in a report.","StiText":"This component is a basic object to output data as a text.","StiTextElement":"This element is a basic object to output data as a text.","StiTextInCells":"The component is used to output a text in cells. It is frequently used for creating forms.","StiTreeViewBoxElement":"The element is used to select values with a drop-down list as a tree.","StiTreeViewElement":"Represents the element that is used to show the hierarchical data as a tree.","StiVerticalLinePrimitive":"This component is used to output vertical lines.","StiWinControl":"The component allows showing visual controls from .NET Framework.","StiZipCode":"This component is used to output the ZIP code."},"HelpDesigner":{"ActiveRelation":"Sets the priority Relation to bind two tables. It is used in Data Transformation and Dashboards. Only one Relation in each Data Source can be active.","Align":"Change the location of selected components.","AlignBottom":"Align the contents of a component to bottom.","AlignCenter":"Align the contents of a component to center.","AlignComponentBottom":"Allows you to align objects horizontally along the bottom edge of selected components.","AlignComponentCenter":"Allows you to align objects horizontally along the center edge of selected components.","AlignComponentLeft":"Allows you to align objects vertically along the left edge of selected components.","AlignComponentMiddle":"Allows you to align objects vertically along the center edge of selected components.","AlignComponentRight":"Allows you to align objects vertically along the right edge of selected components.","AlignComponentTop":"Allows you to align objects horizontally along the top edge of selected components.","AlignLeft":"Align the contents of a component to left.","AlignMiddle":"Center the contents by the top and bottom borders of a component.","AlignRight":"Align contents of a component to right.","AlignToGrid":"Align the selected components to grid nodes.","AlignTop":"Align the contents of a component to top.","AlignWidth":"Justify the contents of a component.","Angle":"Rotate the contents of the component.","AngleWatermark":"The watermark text rotation angle.","Background":"Change the background of the selected components.","biConditions":"Control list of conditions of the selected components.","BorderColor":"Select the border color of the selected component.","BorderSidesAll":"Switch on all borders sides of the selected components.","BorderSidesBottom":"Switch on bottom border side of the selected components.","BorderSidesLeft":"Switch on left border side of the selected components.","BorderSidesNone":"Switch off all borders sides of the selected components.","BorderSidesRight":"Switch on right border side of the selected components.","BorderSidesTop":"Switch on top border side of the selected components.","BorderStyle":"Select the border style of the selected components.","BringToFront":"Bring the selected component to front.","CenterHorizontally":"Allows you to align a component horizontally relative to container edges in what it is placed.","CenterVertically":"Allows you to align a component vertically relative to container edges in what it is placed.","Close":"Close the Report Designer.","Columns":"Split a page into columns.","ComponentSize":"Change the size of the selected components.","CopyStyle":"Copy Style","CopyToClipboard":"Copy to Clipboard","CurrencySymbol":"Select the currency symbol.","DashboardNew":"Create a new dashboard.","DataStore":"Show data, registered in a report.","DateTimeFormat":"Select the date and time format for the selected components.","DockingPanels":"Panel settings.","DockStyleBottom":"Dock selected components to the bottom side.","DockStyleFill":"Dock selected components to all sides.","DockStyleLeft":"Dock selected components to the left side.","DockStyleNone":"Undock selected components.","DockStyleRight":"Dock selected components to the right side.","DockStyleTop":"Dock selected components to the top side.","FontGrow":"Make the text size larger.","FontName":"The text font.","FontNameWatermark":"The watermark text font.","FontShrink":"Make the text size smaller.","FontSize":"Font size.","FontSizeWatermark":"Change the font size.","FontStyleBold":"Make the text bold.","FontStyleBoldWatermark":"Make the text of the watermark bold.","FontStyleItalic":"Make the text Italic.","FontStyleItalicWatermark":"Make the watermark text Italic.","FontStyleStrikeout":"Make the text strikeout.","FontStyleUnderline":"Make the text underlined.","FontStyleUnderlineWatermark":"Make the watermark text underlined.","FormatBoolean":"This format is used to format values of the boolean type.","FormatCurrency":"Display a value as currency. It allows you to display a number with the default currency symbol.","FormatCustom":"This type is used to show values according to custom requirements. This type allows data formatting in the Format Mask.","FormatDate":"Display a value as date. The date format is based on the regional date settings.","FormatGeneral":"Display a value without specific format.","FormatNumber":"It is used for general display of numbers.","FormatPercentage":"Display a value as percentage. Numbers are multiplied by 100 to convert them to percentages.","FormatTime":"Display a value as time. The time format is based on the regional time settings.","FormNew":"Create a new dialog form.","GridMode":"Show grid in lines or dots.","ImageAlignment":"Put a watermark image on a page.","ImageTransparency":"Change the transparency of the watermark image.","Interaction":"Control an interaction of the selected components.","LineSpacing":"Choose how much space appears between lines of text or between paragraphs.","Link":"Link the component to the current container.","LoadImage":"Load watermark images from the file.","Lock":"Lock the component. The component cannot be moved and resized.","MainMenu":"Click here to see the list of possible operations with a report, including opening, closing, and previewing.","MakeHorizontalSpacingEqual":"Allows you to set equal horizontal spacing between selected components.","MakeVerticalSpacingEqual":"Allows you to set equal vertical spacing between selected components.","Margins":"Select the margins of the current page.","menuCheckIssues":"Check to find errors, warnings and get recommendations.","menuDesignerOptions":"Setup report designer options.","menuEditClearContents":"Clear the contents.","menuEditCopy":"Copy the selected components and put them on the Clipboard.","menuEditCut":"Cut the selected components from a report and put them on the Clipboard.","menuEditDelete":"Delete selected components.","menuEditPaste":"Paste the contents of the Clipboard into report.","menuFAQPage":"Go to the web page with frequently asked questions.","menuGlobalizationStrings":"Call the Globalization Strings editor of the current report.","menuHelpAboutProgramm":"Get information about the version of report generator and the version of .NET Framework.","menuHomePage":"Go to the Home page of the product.","menuPageOptions":"Setup the basic parameters of the current page. All page options can be changed using the Property panel.","menuPagesManager":"Run the Pages Manager. It allows moving pages, deleting pages, and creating new pages.","menuPreviewSettings":"Call the Preview Settings editor of the current report. Settings will be applied only when viewing the current report.","menuPrint":"Select a printer, number of copies, and other printing options before printing.","menuPrintPreview":"Preview a report before printing.","menuPrintQuick":"Print a report directly to the default printer. The printing dialog is not displayed.","menuReportOptions":"Setup the basic report options. All options can be changed using the Property panel.","menuStyleDesigner":"Call the Style Designer of the current report.","menuSupport":"Go to the support page to ask a question.","menuViewAlignToGrid":"Align components to grid.","menuViewNormal":"Normal view of a page.","menuViewPageBreakPreview":"The mode of showing a page with borders of segments.","menuViewQuickInfo":"Show quick information of components: component name, alias, contents, events etc.","menuViewShowGrid":"Turn on grid lines to which you can align objects in a report.","menuViewShowHeaders":"Show headers of bands.","menuViewShowOrder":"Show order of components on a page.","menuViewShowRulers":"View the rulers, used to measure and line up objects on a page.","MoveBackward":"Move a component to one level higher in order of placing components on a page.","MoveForward":"Move a component to one level lower in order of placing components on a page.","Orientation":"Switch the pages between portrait and landscape layouts.","PageDelete":"Delete current page from a report.","PageNew":"Create a new page.","PageSetup":"Show the Page Setup dialog box.","PageSize":"Choose the paper size for the current page of a report.","PagesManager":"Run the Pages Manager.","PressF1":"Press F1 for More Details","Redo":"Redo the previously canceled change in a report.","ReportNew":"Create a new report.","ReportOpen":"Open a report in the designer.","ReportPreview":"Preview an edited report in the viewer.","ReportSave":"Save currently edited report.","SelectAll":"Select all components on the current page.","SelectUILanguage":"Select the UI language.","SendToBack":"Move the selected component to back relative to other components.","ServicesConfigurator":"Run the Services Configurator.","Shadow":"Show the shadow of a component.","ShowBehind":"Show the watermark text behind the components.","ShowImageBehind":"Put the watermark image behind all components on a page.","ShowToolbox":"Show the toolbox.","StimulsoftHelp":"Stimulsoft Help","StyleDesigner":"Run Style Designer.","TellMeMore":"Tell me more","Text":"Watermark text.","TextBrush":"Change the text color.","TextBrushWatermark":"Change the text color of the watermark.","TextColor":"Change the text color.","TextFormat":"Select the format of values.","ToolbarStyle":"Set selected style to all selected components.","Undo":"Undo the latest change in a report.","WordWrap":"Wrap the text of a component.","Zoom":"Specify the zoom level of the report."},"HelpDialogs":{"StiButtonControl":"Represents the Button control.","StiCheckBoxControl":"Represents the Flag control.","StiCheckedListBoxControl":"Shows the List object, in what a flag on the left is shown for each elements.","StiComboBoxControl":"Represents the ComboBox that is used to either type a value directly into the control or choose from the list of existing options.","StiDateTimePickerControl":"Represents the control that allows selecting the date and time. It also allows you to output the date and time in specified format.","StiGridControl":"Represents the Grid control that consist of rows and columns.","StiGroupBoxControl":"Represents the control that creates a container with borders and a header for the UI content.","StiLabelControl":"A label is an user interface control which displays text on a form. It is usually a static control having no interactivity.","StiListBoxControl":"Contains the list of elements for selection.","StiListViewControl":"Represents the ListView control that shows the list of data elements.","StiLookUpBoxControl":"Contains the list of elements for selection.","StiNumericUpDownControl":"Represents the control that shows numeric values.","StiPanelControl":"The Panel elements are used for placing and arrangement objects.","StiPictureBoxControl":"Represents the control for showing an image.","StiRadioButtonControl":"Represents the Radio button control that allows the user to choose only one of a predefined set of options. ","StiRichTextBoxControl":"Represents the RichText control with widen editing.","StiTextBoxControl":"Represents the Text control that is used for showing or editing a text.","StiTreeViewControl":"Represents the control that is used to show the hierachical data as a tree."},"HelpViewer":{"AddPageBreaks":"Visual separator of report pages.","AllowAddOrModifyTextAnnotations":"Limited access to work with annotations in the document.","AllowCopyTextAndGraphics":"Limited access to copying information.","AllowEditable":"Allows changing components with the Editable property enabled.","AllowModifyContents":"Limited access to the text editing.","AllowPrintDocument":"Limited access to the print operation.","Bookmarks":"Show the bookmark panel that is used for quick navigation to jump directly to a bookmarked location.","BorderType":"The border type of components: simple - drawing borders of components with characters +, -, |; Unicode single - drawing the borders with single box-drawing characters, Unicode double - drawing the borders with double box-drawing characters.","Close":"Close the Report Preview.","CloseDotMatrix":"Close the Dot Matrix Viewer.","Compressed":"Compression of the ready document. It is recommended to always include file compression.","CompressToArchive":"Pack all files and folders in the zip archive.","ContinuousPages":"The mode of placing report pages as a vertical strip.","CurrentPage":"Processing the current page. If this option is selected, then a selected report page will be processed.","CutEdges":"Trim the borders of report pages.","CutLongLines":"Trim the long lines (text lines) by the borders of components.","DigitalSignature":"The digital signature of the file.","DitheringType":"Dithering type: None - no dithering, Ordered, FloydSt. - with dithering.","DotMatrixMode":"This mode allows you to see how will a report look like if to print it on a dot matrix printer.","DrawBorder":"Drawing the borders of components with graphic characters.","Edit":"Edit components.","EmbeddedFonts":"Embed the font files into a PDF file.","EmbeddedImageData":"Embed images directly into the HTML file.","Encoding":"Encoding the report text after export.","EncodingData":"Encoding data file.","EncryptionKeyLength":"The length of the encryption key. The longer the length is, the more difficult it is to decrypt the document, and, accordingly, the document security is on higher priority.","ExportDataOnly":"Export only Data bands (the Table component, Hierachical band).","ExportEachPageToSheet":"Export each report page in a separate Excel sheet.","ExportMode":"Apply a filter condition when exporting. Data Only - only data bands (Table component, Hierarchical Band) will be exported. Data and Headers/Footers - data bands (Table component, Hierarchical Band) and their headers/footers will be exported. All Bands - All the report bands will be exported.","ExportModeHtml":"The way of the HTML page markup.","ExportModeRtf":"Presentation of the report data after export. The Table - the report will look like a table, where each report component is a table cell. Frame - each component will look like a single frame, but without any relationship between them.","ExportObjectFormatting":"Apply formatting to export data from Data bands (Table component, Hierachical band).","ExportPageBreaks":"Show the borders of the report pages on the Excel sheet.","ExportRtfTextAsImage":"Convert the RTF text into the image. If the option is enabled, then, when exporting, RichText decomposes into simpler primitives supported by the PDF format. RichText with complex formatting (embedded images, tables) cannot always be converted correctly. In this case it is recommended to enable this option.","Find":"Find a text in the report.","FullScreen":"Full screen reading.","GetCertificateFromCryptoUI":"Using the interface of the system cryptography library.","ImageCompressionMethod":"The compression method: JPEG - this may cause loss of quality, Flate – no quality loss, Simple, Ordered, FloydSt. - images are output in monochrome.","ImageFormat":"The image format in the finished file.","ImageQuality":"Allows you to choose the ratio of the image quality/size of the file. The higher the quality is, the larger is the size of the finished file.","ImageQualityPdf":"The option is available only in JPEG compression, and allows you to select the ratio of the image quality/size of the file. The higher the quality is, the larger is the size of the finished file.","ImageResolution":"The number of pixels per inch. The higher the number of pixels is, the better is the quality of the image. The size of the finished file is much larger.","ImageType":"The color scheme of the image: color - image after exporting will fully match the image in the viewer; gray – an image after exporting will be of the gray shade; monochrome - the images will be strictly black and white. At the same time, it should be considered that the monochrome has three modes None, Ordered, FloydSt.","KillSpaceLines":"Remove blank lines (rows) in the document.","MultipleFiles":"Each report page can be a separate file.","Open":"Open the previously saved report in the window of preview.","OpenAfterExport":"Automatic opening of the created document (after export) by the program set for these file types.","OwnerPassword":"The password to access operations with files.","PageAll":"Processing of all report pages.","PageDelete":"Delete the selected report page.","PageDesign":"Edit the selected page in the report designer.","PageFirst":"Go to the first report page.","PageGoTo":"Go to the specified report page.","PageLast":"Go to the last report page.","PageNew":"Add a new page to a report.","PageNext":"Go to the next report page.","PagePrevious":"Go to the previous report page.","PageSize":"Change the page parameters in a report.","Parameters":"Showing parameters panel which is used when report rendering.","PdfACompliance":"Support for the standard of the long-term archiving and storing of electronic documents.","Print":"Print a report.","PutFeedPageCode":"Feed pages in the final document with a special character.","RangePages":"The page numbers to be processed. You can specify a single page, a list of pages (using a comma as the separator), as well as specify the range by setting the start page of the range separated by \\"-\\" and the end page of the range. For example: 1,3,5-12.","RemoveEmptySpaceAtBottom":"Minimize the empty space at the bottom of the page.","Resources":"Showing resources panel","RestrictEditing":"Limits on changes in a Word document.","Save":"Save a report for further using.","ScaleHtml":"The size (scale) of report pages and items after the export.","ScaleImage":"The size (scale) of the report after exporting. The lower scale is, the greater is the number of pixels per inch, and vice versa.","SendEMail":"Send a report via Email.","Separator":"Separator between the data in the CSV file.","SkipColumnHeaders":"Enable/disable the column headers.","StandardPdfFonts":"14 standard Adobe fonts. If this option is enabled, then only standard 14 fonts will be used in the PDF file. All report fonts are converted into them.","SubjectNameString":"Certificate identifier. The identifier is the name of the certificate owner (full line) or a part of the name (substring).","Thumbnails":"Show the thumbnails that can be used for quick navigation to find the section of the report that you want to jump to.","TiffCompressionScheme":"Compression scheme for TIFF files.","ToolEditor":"This tool allows you to edit contents of text components directly in the report viewer.","TypeExport":"The file the report will be converted into.","UseDefaultSystemEncoding":"Use system coding by default or specify the encoding by standard.","UseOnePageHeaderAndFooter":"Define the page bands Header and Footer as the header and footer of the Microsoft Word document.","UsePageHeadersAndFooters":"Define the bands Page Header and Footer as the header and footer of the document in Microsoft Word.","UserPassword":"The password required to open the document.","UseUnicode":"Extended support for encoding characters. It affects on the internal character encoding within the PDF file, and improves the copying of the text from the PDF file.","ViewModeContinuous":"Show all report pages as a vertical ribbon.","ViewModeMultiplePages":"Zoom the report so that as many pages as can be fit in window are displayed.","ViewModeSinglePage":"Show a single page in the window of preview.","ZoomMultiplePages":"Zoom the report so that the selected pages fit in the window.","ZoomOnePage":"Zoom the report so that an entire page fits in the window.","ZoomPageWidth":"Zoom the report so that the width of the page matches the width of the window.","ZoomTwoPages":"Zoom the report so that two pages fit in the window.","ZoomTxt":"The report size (scale): X - change the horizontal scale, Y - to change the vertical scale."},"Interface":{"Mouse":"Mouse","MouseDescription":"Optimized for used with mouse","Touch":"Touch","TouchDescription":"Optimized for used with touch"},"MainMenu":{"menuCheckIssues":"Check for Issues","menuContextClone":"Clone...","menuContextDesign":"Design...","menuContextTextFormat":"Text Format...","menuConvertToCheckBox":"Convert to CheckBox","menuConvertToImage":"Convert to Image","MenuConvertToRichText":"Convert to RichText","menuConvertToText":"Convert to Text","menuDeleteColumn":"Delete Column","menuDeleteRow":"Delete Row","menuEdit":"&amp;Edit","menuEditBusinessObjectFromDataSetNew":"New Business Object From DataSet...","menuEditBusinessObjectNew":"New Business Object...","menuEditCalcColumnNew":"New Calculated Column...","menuEditCantRedo":"Can\'t Redo","menuEditCantUndo":"Can\'t Undo","menuEditCategoryNew":"New Category...","menuEditClearContents":"Clear Contents","menuEditColumnNew":"New Column...","menuEditConnectionNew":"New Connection...","menuEditCopy":"&amp;Copy","menuEditCut":"Cu&amp;t","menuEditDataParameterNew":"New Parameter...","menuEditDataSourceNew":"New Data Source...","menuEditDataSourcesNew":"New Data Sources...","menuEditDataTransformationNew":"New Data Transformation...","menuEditDelete":"&amp;Delete","menuEditEdit":"Edit","menuEditImportRelations":"Import Relations...","menuEditPaste":"&amp;Paste","menuEditRedo":"&amp;Redo","menuEditRedoText":"&amp;Redo {0}","menuEditRelationNew":"New Relation...","menuEditRemoveUnused":"Remove Unused Items","menuEditResourceNew":"New Resource...","menuEditSelectAll":"Select &amp;All","menuEditSynchronize":"Synchronize","menuEditUndo":"&amp;Undo","menuEditUndoText":"&amp;Undo {0}","menuEditVariableNew":"New Variable...","menuEditViewData":"View Data...","menuEmbedAllDataToResources":"Embed all data to resources","menuFile":"&amp;File","menuFileClose":"&amp;Close","menuFileDashboardDelete":"Delete Dashboard","menuFileDashboardNew":"New Dashboard","menuFileDashboardOpen":"&amp;Open Dashboard...","menuFileDashboardSaveAs":"Save Dashboard &amp;As...","menuFileExit":"E&amp;xit","menuFileExportXMLSchema":"Export XML Schema...","menuFileFormNew":"New Form","menuFileFormOpen":"Open Form","menuFileImportXMLSchema":"Import XML Schema...","menuFileMerge":"Merge...","menuFileMergeXMLSchema":"Merge XML Schema...","menuFileNew":"&amp;New","menuFileOpen":"&amp;Open...","menuFilePageDelete":"Delete Page","menuFilePageNew":"New Page","menuFilePageOpen":"Open Page...","menuFilePageSaveAs":"Save Page As...","menuFilePageSetup":"Page Setup...","menuFileRecentDocuments":"Recent Documents","menuFileRecentLocations":"Recent Locations","menuFileReportNew":"&amp;New Report...","menuFileReportOpen":"&amp;Open Report...","menuFileReportOpenFromGoogleDocs":"Open Report from Google Docs...","menuFileReportPreview":"&amp;Preview","menuFileReportSave":"&amp;Save Report","menuFileReportSaveAs":"Save Report &amp;As...","menuFileReportSaveAsToGoogleDocs":"Save Report As to Google Docs...","menuFileReportSetup":"Report &amp;Setup...","menuFileReportWizardNew":"New Report with &amp;Wizard...","menuFileSave":"&amp;Save","menuFileSaveAs":"Save As...","menuFileScreenNew":"New Screen","menuHelp":"&amp;Help","menuHelpAboutProgramm":"&amp;About...","menuHelpContents":"&amp;Contents","menuHelpDemos":"Demos","menuHelpDocumentation":"Documentation","menuHelpFAQPage":"FAQ Page","menuHelpForum":"Forum","menuHelpHowToRegister":"How to Register","menuHelpProductHomePage":"Product Home Page","menuHelpSamples":"Samples","menuHelpSupport":"&amp;Support","menuHelpTrainingCourses":"Training Courses","menuHelpVideos":"Videos","menuInsertColumnToLeft":"Insert Column To Left","menuInsertColumnToRight":"Insert Column To Right","menuInsertRowAbove":"Insert Row Above","menuInsertRowBelow":"Insert Row Below","menuJoinCells":"Join Cells","menuMakeThisRelationActive":"Make This Relation Active","menuSelectColumn":"Select Column","menuSelectRow":"Select Row","menuTable":"Table","menuTools":"&amp;Tools","menuToolsDataStore":"Data &amp;Store...","menuToolsDictionary":"&amp;Dictionary...","menuToolsOptions":"&amp;Options...","menuToolsPagesManager":"&amp;Pages Manager...","menuToolsServicesConfigurator":"Services &amp;Configurator...","menuToolsStyleDesigner":"Style &amp;Designer...","menuView":"&amp;View","menuViewAlignToGrid":"Align to Grid","menuViewNormal":"&amp;Normal","menuViewOptions":"Options","menuViewPageBreakPreview":"Page &amp;Break Preview","menuViewQuickInfo":"Quick Info","menuViewQuickInfoNone":"None","menuViewQuickInfoOverlay":"Display Over Components","menuViewQuickInfoShowAliases":"Show Aliases","menuViewQuickInfoShowComponentsNames":"Show Components Names","menuViewQuickInfoShowContent":"Show Content","menuViewQuickInfoShowEvents":"Show Events","menuViewQuickInfoShowFields":"Show Fields","menuViewQuickInfoShowFieldsOnly":"Show Fields Only","menuViewShowGrid":"Show Grid","menuViewShowHeaders":"Show Headers","menuViewShowInsertTab":"Show \'Insert\' Tab","menuViewShowOrder":"Show Order","menuViewShowRulers":"Show Rulers","menuViewShowToolbox":"Show Toolbox","menuViewToolbars":"Toolbars"},"Map":{"LinkDataForm":"Link Data","MapEditorForm":"Map Editor"},"MathFormula":{"Alphabets":"Alphabets","Arrows":"Arrows","Formulas":"Formulas","Maths":"Maths","Operators":"Operators"},"Messages":{"ChangeRequestTimeout":"The request timeout for SQL queries exceeds the request timeout of the report designer. Set the request timeout for the designer component in no less than {0} seconds.","DoNotShowAgain":"Do not show again","LatexFormat":"The LaTeX format is used to display mathematical formulas.","MessageTimeOutExpired":"Command timeout has expired!","RenderingWillOccurInTheInterpretationMode":"When viewing the shared report, the rendering will occur in the interpretation mode!","ResourceCannotBeDeleted":"The resource \\"{0}\\" cannot be deleted, because it is used in the report!","ShareURLOfTheItemHasBeenUpdated":"The share URL of the item has been updated!","ShareYourReportYouShouldSave":"To share your report you should save the report to Stimulsoft Cloud!","SwitchingBetweenModes":"Switching between modes will cause the loss of changes. Do you want to proceed?","SwitchParametersOrientation":"Please change the value of the \'ParametersOrientation\' report property to \'{0}\' to show this category on the parameters panel.","TextRegistrationSuccessfully":"\\nRegistration completed successfully!\\n\\nThe Email was sent to \\"{0}\\".\\nIt contains a link to confirm your registration. To complete the registration please follow the link from the Email you received.\\n","ThisFieldIsNotSpecified":"This Field is Not Specified!","ThisFunctionEmbedsAllReportDataToTheReport":"This function embeds all report data to the report resources and makes your report standalone. Be careful! All your data settings will be changed and can\'t be restored. Please, make a backup copy of your report firstly.{0}Are you sure?","YouNeedToLoginFirstToStartUsingTheSoftware":"You need to login first to start using the software. The application will close if you quit the login form."},"Notices":{"AccessDenied":"Access Denied!","AccountLocked":"Your account is locked! In order to resolve it, please send your request to sales@stimulsoft.com!","ActivationContact1":"Please contact our sales department at ","ActivationContact2":" to resolve this.","ActivationExpiriedBeforeFirstRelease":"Your Subscription of Stimulsoft Reports.Ultimate expired earlier than the first version of our Stimulsoft Server was released!","ActivationLicenseIsNotCorrect":"License file is not correct! Please contact our sales department at sales@stimulsoft.com!","ActivationLockedAccount":"Your account is locked. Please contact our sales department at sales@stimulsoft.com!","ActivationLockedAccountExt":"Your account is locked.","ActivationMaxActivationsReached":"You reached the maximum number of activations. Please contact our sales department at sales@stimulsoft.com!","ActivationMaxActivationsReached1":"You can manage the registered computers from your ","ActivationMaxActivationsReached2":"Stimulsoft Account.","ActivationMaxComputersReached":"You’ve already registered the maximum number of computers available for your subscription.","ActivationServerIsNotAvailableNow":"Stimulsoft Activation Server is not available now! Please try again later.","ActivationServerVersionNotAllowed":"You cannot activate this version of Stimulsoft Server because your Subscription Program expired! Please log in to your account and check which version of the Stimulsoft Server you can install and activate.","ActivationSomeTroublesOccurred":"An error occurred during activation. Please try again later.","ActivationTrialExpired":"You can continue to use Stimulsoft Designer by purchasing the software.","ActivationTrialExtend1":"If you are interested in extending your trial, please ","ActivationTrialExtend2":"tell us why.","ActivationUserNameOrPasswordIsWrong":"Your user name (Email) or password is wrong!","ActivationWrongAccountType":"Your account type does not allow to activate Stimulsoft Server!","Alert":"Alert","AuthAccountAlreadyExists":"The account with this User Name (email) already exists. To associate it with your {0} account, please use your Stimulsoft account password.","AuthAccountCantBeUsedNow":"The account cannot be used now!","AuthAccountIsNotActivated":"The account is not activated yet! Please follow the instructions sent to the Email during registration.","AuthCantChangeRoleBecauseLastAdministratorUser":"The user role cannot be changed because this is the last administrator user in this workspace!","AuthCantChangeRoleBecauseLastSupervisorUser":"The user role cannot be changed because this is the last supervisor user at this server!","AuthCantChangeSystemRole":"The system role cannot be changed!","AuthCantDeleteHimselfUser":"The user cannot delete himself!","AuthCantDeleteLastAdministratorUser":"The user cannot be deleted because this is the last administrator user in this workspace!","AuthCantDeleteLastSupervisorUser":"The user cannot be deleted because this is the last supervisor user at this server!","AuthCantDeleteSystemRole":"Cannot delete this role, because it is a system role!","AuthCantDisableUserBecauseLastAdministratorUser":"The user cannot be disabled because this is the last administrator user in this workspace!","AuthCantDisableUserBecauseLastSupervisorUser":"The user cannot be disabled because this is the last supervisor user at this server!","AuthFirstNameIsNotSpecified":"The first name is not specified!","AuthLastNameIsNotSpecified":"The last name is not specified!","AuthOAuthIdNotSpecified":"The OAuth identificator is not specified!","AuthPasswordIsNotCorrect":"The password is not correct!","AuthPasswordIsNotSpecified":"The password is not specified!","AuthPasswordIsTooShort":"The password is too short (a minimum length is 6 chars)!","AuthRoleCantBeDeletedBecauseUsedByUsers":"You cannot delete the role because it is used by other users.","AuthRoleNameAlreadyExists":"The role with the specified name \\"{0}\\" already exists!","AuthRoleNameIsSystemRole":"The role with the specified name \\"{0}\\" is a system role!","AuthSendMessageWithInstructions":"A message with further instructions is sent to \\"{0}\\"!","AuthTokenIsNotCorrect":"Token is not correct!","AuthUserHasLoggedOut":"You have logged out!","AuthUserNameAlreadyExists":"The username (Email) is already in use!","AuthUserNameEmailIsBlocked":"This Email address cannot be used!","AuthUserNameIsNotSpecified":"The username (Email) is not specified!","AuthUserNameNotAssociatedWithYourAccount":"Username (Email) {0} is not associated with your {1} account!","AuthUserNameOrPasswordIsNotCorrect":"The username (Email) or password is incorrect!","AuthUserNameShouldLookLikeAnEmailAddress":"The username should be similar to the Email address!","AuthWorkspaceNameAlreadyInUse":"The workspace name is already in use!","CommandTimeOut":"Waiting time of processing the command is elapsed!","Congratulations":"Congratulations!","DeveloperInformation":"Developer Information","EndDateShouldBeGreaterThanCurrentDate":"The end date should be greater than the current date!","EndDateShouldBeGreaterThanStartDate":"The end date should be greater than start date!","ExecutionError":"Execution error","IsIdentical":"\\"{0}\\" and \\"{1}\\" are identical.\\"","IsNotAuthorized":"No access to \\"{0}\\"!","IsNotCorrect":"\\"{0}\\" is incorrect!","IsNotDeleted":"\\"{0}\\" is not deleted!","IsNotEqual":"\\"{0}\\" is not equal!","IsNotFound":"\\"{0}\\" is not found!","IsNotRecognized":"\\"{0}\\" is not recognized!","IsNotSpecified":"\\"{0}\\" is not specified!","IsRequiredFile":"You should add at least one file!","ItemCantBeAttachedToItself":"The item cannot be attached to itself!","ItemCantBeDeletedBecauseItemIsAttachedToOtherItems":"The elements \\"{0}\\" cannot be deleted because they are attached to other elements!","ItemCantBeMovedToSpecifiedPlace":"The item cannot be moved to a specified place!","ItemDoesNotSupport":"The item does not support \\"{0}\\"!","KeyAndToKeyAreEqual":"A Key and ToKey are equal!","MaximumComputers":"Maximum of Computers","MessageMaximumFileSizeExceeded":"Attention! The size of the file that you are trying to add exceeds the maximum-allowed size. Do you want to add this file anyway (report processing may slow down significantly)?","NewDesignerAvailable":"Stimulsoft Designer {0} is available.","NewProduct":"The new product is added to your subscription!","NewVersionsAvailable":"New version","NotificationConnectPackage":"Connect the \\"{0}\\" package for the correct work.","NotificationFailed":"Failed result!","NotificationFailedAddFollowingFiles":"Failed to add the following files. Exceeded the size {0} MB.","NotificationFilesUploadingComplete":"The files uploaded successfully.","NotificationFileUploading":"The file \\"{0}\\" is uploading.","NotificationItemDelete":"The items are deleting.","NotificationItemDeleteComplete":"The items are deleted successfully.","NotificationItemExtraComponentRequired":"Extra component required","NotificationItemInstallWebView":"Please install the WebView2 Runtime to work with the Blockly editor correctly.","NotificationItemRestore":"The items are restoring.","NotificationItemRestoreComplete":"The items are restored successfully.","NotificationItemTransfer":"The items are transferring.","NotificationItemTransferComplete":"The items are transferred successfully.","NotificationItemWaitingProcessing":"The items are waiting processing.","NotificationMailing":"Sending","NotificationMailingComplete":"The mailing \\"{0}\\" is complete.","NotificationMailingWaitingProcessing":"The mailing \\"{0}\\" is waiting processing.","NotificationOperationAborted":"Operation aborted!","NotificationPackageRequiredToDisplay":"To display this content, please download the \\"{0}\\" package from NuGet.","NotificationRecycleBinCleaning":"The Recycle Bin is cleaning.","NotificationRecycleBinCleaningComplete":"The Recycle Bin is cleaned successfully.","NotificationRecycleBinWaitingProcessing":"The Recycle Bin cleaning is waiting processing.","NotificationReportExporting":"The report \\"{0}\\" is exporting","NotificationReportExportingComplete":"The report \\"{0}\\" is exported successfully.","NotificationReportRendering":"The report \\"{0}\\" is rendering","NotificationReportRenderingComplete":"The report \\"{0}\\" is rendered.","NotificationReportWaitingProcessing":"The report \\"{0}\\" is waiting processing.","NotificationReturnToDesigner":"Return to the Stimulsoft Designer to continue.","NotificationSchedulerRunning":"The scheduler \\"{0}\\" is running.","NotificationSchedulerRunningComplete":"The scheduler \\"{0}\\" running complete.","NotificationSchedulerWaitingProcessing":"The scheduler \\"{0}\\" is waiting processing.","NotificationTitleFilesUploading":"Uploading files","NotificationTitleItemRefreshing":"Refreshing item \\"{0}\\"","NotificationTitleItemTransferring":"Transferring item \\"{0}\\"","NotificationTitleMailing":"Mailing \\"{0}\\"","NotificationTitleReportExporting":"Exporting report \\"{0}\\"","NotificationTitleReportRendering":"Rendering report \\"{0}\\"","NotificationTitleSchedulerRunning":"Running scheduler \\"{0}\\"","NotificationTransferring":"The \\"{0}\\" is tranferring to \\"{1}\\".","NotificationTransferringComplete":"The \\"{0}\\" is succesfully transffered to \\"{1}\\".","NotificationValueIsNotCorrect":"This value is not correct for the type {0}","OutOfRange":"Out of range (\\"{0}\\")!","ParsingCommandException":"An exception of processing the command in the specified xml: {0}","PleaseLogin":"Please login using your Stimulsoft account credentials or register a new account before publishing report.","QuotaMaximumComputingCyclesCountExceeded":"Maximum computing cycles exceeded.","QuotaMaximumDataRowsCountExceeded":"Maximum data rows in one data source exceeded.","QuotaMaximumFileSizeExceeded":"Maximum file size exceeded.","QuotaMaximumItemsCountExceeded":"Maximum items exceeded.","QuotaMaximumRefreshCountExceeded":"Maximum refresh count exceeded","QuotaMaximumReportPagesCountExceeded":"Maximum report pages exceeded.","QuotaMaximumResourcesCountExceeded":"Maximum resources exceeded.","QuotaMaximumResourceSizeExceeded":"Maximum resource size exceeded.","QuotaMaximumUsersCountExceeded":"Maximum users exceeded.","QuotaMaximumWorkspacesCountExceeded":"Maximum workspaces exceeded.","SchedulerCantRunItSelf":"The scheduler cannot run itself!","SessionTimeOut":"Session timeout","SnapshotAlreadyProcessed":"The report snapshot is already processed!","SpecifiedItemIsNot":"The specified item is not \\"{0}\\"!","SubscriptionExpired":"Your subscription has expired!","SubscriptionExpiredDate":"Your subscription will expire on {0}","SubscriptionExpiredDays":"Expires in {0} days","SubscriptionExpiredExt":"Your subscription has expired. Update your subscription to get the last version.","SubscriptionExpiredShort":"Subscription expired","SubscriptionsOut10":"10 days left when the subscription expires!","SubscriptionsOut20":"The subscription period will expire in 20 days!","SuccessfullyRenewed":"Your subscription has been successfully updated!","TrialToLicense":"We would like to thank you for choosing our software!","VersionCopyFromItem":"Copy from item \\"{0}\\".","VersionCreatedFromFile":"Created from file \\"{0}\\".","VersionCreatedFromItem":"Created from item \\"{0}\\".","VersionLoadedFromFile":"Loaded from file \\"{0}\\".","VersionNewItemCreation":"New item creation.","Warning":"Warning","WindowClosePreventWhileUploading":"Some files are uploading now, if you close page they will lost. Are you sure you want to close page?","WithSpecifiedKeyIsNotFound":"\\"{0}\\" with the specified key is not found!","WouldYouLikeToUpdateNow":"Would you like to update now?","YourTimeSessionHasExpired":"Your time session has expired!","YourTrialHasExpired":"Your trial has expired","YourTrialWillExpire":"Your trial will expire in {0} days.","YouUsingTrialVersion":"You are using a trial version!"},"NuGet":{"AlreadyDownloaded":"Already Downloaded","AssemblyLoadedSuccessfully":"The assembly is loaded successfully.","AssemblyNotFound":"It is impossible to find {0} assembly to use the {1} connection!","Author":"Author","Dependencies":"Dependencies:","Download":"Download","DownloadAll":"Download All","DownloadAndInstall":"Download and Install","DownloadDataAdapter":"Download Data Adapter","Downloads":"Downloads:","IAccept":"I Accept","IDecline":"I Decline","LicenceFormDesc":"The following package require that you accept their license terms before installing.","LicenceFormDesc1":"By clicking \\"I Accept\\" you agree to the license terms for the package listed above. If you do not agree to the license terms, click \\"I Decline\\".","LicenceFormTitle":"Licence Acceptance","License":"License:","ProjectUrl":"Project URL:","ReportAbuse":"Report Abuse:","RetrievingInformation":"Retrieving information...","Tags":"Tags:","Title":"Data Adapter from NuGet","ViewLicense":"View License"},"Panels":{"Dictionary":"Dictionary","Messages":"Messages","Properties":"Properties","ReportTree":"Report Tree"},"Password":{"gbPassword":"Encrypting of the file","lbPasswordLoad":"Enter the password to open the file","lbPasswordSave":"Password:","PasswordNotEntered":"The password is not entered","StiLoadPasswordForm":"Document encrypting","StiSavePasswordForm":"Password"},"Permissions":{"AdminAPI":"API","AdminBackgroundTasks":"Background Tasks","AdminPermissions":"Permissions","AdminRecycleBin":"Recycle Bin","AdminShare":"Share","AdminTransfers":"Transfers","ItemCalendars":"Calendars","ItemCloudStorages":"Cloud Storages","ItemContactLists":"Contact Lists","ItemDashboards":"Dashboards","ItemDataSources":"Data Sources","ItemFiles":"Files","ItemFolders":"Folders","ItemForms":"Forms","ItemReportSnapshots":"Report Snapshots","ItemReportTemplates":"Report Templates","ItemSchedulers":"Schedulers","ReportDesignerBusinessObjects":"Business Objects","ReportDesignerDataColumns":"Data Columns","ReportDesignerDataConnections":"Data Connections","ReportDesignerDataRelations":"Data Relations","ReportDesignerDataSources":"Data Sources","ReportDesignerDictionaryActions":"Dictionary Actions","ReportDesignerRestrictions":"Restrictions","ReportDesignerVariables":"Variables","SystemBackupRestore":"Backup &amp; Restore","SystemEmailTemplates":"Email Templates","SystemLicensing":"Licensing","SystemMonitoring":"Monitoring","SystemUpdate":"Update","SystemWorkspaces":"Workspaces","TextAdministration":"Administration","TextItems":"Items","TextReportDesigner":"Report Designer","TextSystem":"System","TextUsers":"Users","UserHimself":"Himself","UserRoles":"Roles","Users":"Users","UserWorkspace":"Workspace"},"PlacementComponent":{"MoveLeftFreeSpace":"Moves a component to the left side of a free space, increasing the height of the component to the height of free space.","MoveRightFreeSpace":"Moves a component to the right side of a free space, increasing the height of the component to the height of free space."},"PromptForm":{"CacheLoginData":"Cache login data for current session"},"PropertyCategory":{"AppearanceCategory":"Appearance","AreaCategory":"Area","ArgumentCategory":"Argument","AxisCategory":"Axis","BarCodeAdditionalCategory":"Bar Code Additional","BarCodeCategory":"Bar Code","BehaviorCategory":"Behavior","ButtonCategory":"Button","CapNeedle":"Cap Needle","CardsCategory":"Cards","CellCategory":"Cell","ChartAdditionalCategory":"Chart Additional","ChartCategory":"Chart","ChartMap":"Map","CheckCategory":"Check","ColorsCategory":"Colors","ColumnsCategory":"Columns","ComboBoxCategory":"Combo Box","CommonCategory":"Common","ControlCategory":"Control","ControlsEventsCategory":"Controls Events","CrossTabCategory":"Cross-Tab","DashboardCategory":"Dashboard","DataCategory":"Data","DataCells":"Data Cells","DatePickerCategory":"Date Picker","DescriptionCategory":"Description","DesignCategory":"Design","DisplayCategory":"Display","EngineCategory":"Engine","ExportCategory":"Export","ExportEventsCategory":"Export Events","FooterTableCategory":"Footer Table","GaugeCategory":"Gauge","GlobalizationCategory":"Globalization","GridLinesCategory":"Grid Lines","HeaderTableCategory":"Header Table","HierarchicalCategory":"Hierarchical","ImageAdditionalCategory":"Image Additional","ImageCategory":"Image","IndicatorCategory":"Indicator","InterlacingCategory":"Interlacing","LabelsCategory":"Labels","LegendCategory":"Legend","LinearScaleBarCategory":"Linear Scale Bar","LinearScaleCategory":"Linear Scale","ListBoxCategory":"List Box","MainCategory":"Main","MarkerCategory":"Marker","MathFormulaCategory":"Math Formula","MiscCategory":"Misc","MouseEventsCategory":"Mouse Events","NavigationCategory":"Navigation","NavigationEventsCategory":"Navigation Events","Needle":"Needle","NeedleCategory":"Needle","OnlineMapCategory":"Online Map","OptionsCategory":"Options","PageAdditionalCategory":"Page Additional","PageCategory":"Page","PageColumnBreakCategory":"Page and Column Break","ParametersCategory":"Parameters","PivotTableCategory":"Pivot Table","PositionCategory":"Position","PrimitiveCategory":"Primitive","PrintEventsCategory":"Print Events","ProgressCategory":"Progress","RadialScaleBarCategory":"Radial Scale Bar","RegionMapCategory":"Region Map","RenderEventsCategory":"Render Events","SeriesCategory":"Series","SeriesLabelsCategory":"Series Labels","ShapeCategory":"Shape","Size":"Size","SubReportCategory":"Sub-Report","TableCategory":"Table","TableOfContents":"Table of Contents","TextAdditionalCategory":"Text Additional","TextCategory":"Text","TickLabelMajorCategory":"Tick Label Major","TickLabelMinorCategory":"Tick Label Minor","TickMarkMajorCategory":"Tick Mark Major","TickMarkMinorCategory":"Tick Mark Minor","TitleCategory":"Title","TreeViewBoxCategory":"Tree View Box","TreeViewCategory":"Tree View","TrendLineCategory":"Trend Line","ValueCategory":"Value","ValueCloseCategory":"Value Close","ValueEndCategory":"Value End","ValueEventsCategory":"Value Events","ValueHighCategory":"Value High","ValueLowCategory":"Value Low","ValueOpenCategory":"Value Open","ViewCategory":"View","WeightCategory":"Weight","WinControlCategory":"Win Control","ZipCodeCategory":"ZIP Code"},"PropertyColor":{"AliceBlue":"Alice Blue","AntiqueWhite":"Antique White","Aqua":"Aqua","Aquamarine":"Aquamarine","Azure":"Azure","Beige":"Beige","Bisque":"Bisque","Black":"Black","BlanchedAlmond":"Blanched Almond","Blue":"Blue","BlueViolet":"Blue Violet","Brown":"Brown","BurlyWood":"Burly Wood","CadetBlue":"Cadet Blue","Carmine":"Carmine","Chartreuse":"Chartreuse","Chocolate":"Chocolate","Coral":"Coral","CornflowerBlue":"Cornflower Blue","Cornsilk":"Cornsilk","Crimson":"Crimson","Cyan":"Cyan","DarkBlue":"Dark Blue","DarkCyan":"Dark Cyan","DarkGoldenrod":"Dark Goldenrod","DarkGray":"Dark Gray","DarkGreen":"Dark Green","DarkKhaki":"Dark Khaki","DarkMagenta":"Dark Magenta","DarkOliveGreen":"Dark Olive Green","DarkOrange":"Dark Orange","DarkOrchid":"Dark Orchid","DarkRed":"Dark Red","DarkSalmon":"Dark Salmon","DarkSeaGreen":"Dark Sea Green","DarkSlateBlue":"Dark Slate Blue","DarkSlateGray":"Dark Slate Gray","DarkTurquoise":"Dark Turquoise","DarkViolet":"Dark Violet","DeepPink":"Deep Pink","DeepSkyBlue":"Deep Sky Blue","DimGray":"Dim Gray","DodgerBlue":"Dodger Blue","Firebrick":"Firebrick","FloralWhite":"Floral White","ForestGreen":"Forest Green","Fuchsia":"Fuchsia","Gainsboro":"Gainsboro","GhostWhite":"Ghost White","Gold":"Gold","Goldenrod":"Goldenrod","Gray":"Gray","Green":"Green","GreenYellow":"Green Yellow","Honeydew":"Honeydew","HotPink":"Hot Pink","IndianRed":"Indian Red","Indigo":"Indigo","Ivory":"Ivory","Khaki":"Khaki","Lavender":"Lavender","LavenderBlush":"Lavender Blush","LawnGreen":"Lawn Green","LemonChiffon":"Lemon Chiffon","LightBlue":"Light Blue","LightCoral":"Light Coral","LightCyan":"Light Cyan","LightGoldenrodYellow":"Light Goldenrod Yellow","LightGray":"Light Gray","LightGreen":"Light Green","LightPink":"Light Pink","LightSalmon":"Light Salmon","LightSeaGreen":"Light Sea Green","LightSkyBlue":"Light Sky Blue","LightSlateGray":"Light Slate Gray","LightSteelBlue":"Light Steel Blue","LightYellow":"Light Yellow","Lime":"Lime","LimeGreen":"Lime Green","Linen":"Linen","Magenta":"Magenta","Maroon":"Maroon","MediumAquamarine":"Medium Aquamarine","MediumBlue":"Medium Blue","MediumOrchid":"Medium Orchid","MediumPurple":"Medium Purple","MediumSeaGreen":"Medium Sea Green","MediumSlateBlue":"Medium Slate Blue","MediumSpringGreen":"Medium Spring Green","MediumTurquoise":"Medium Turquoise","MediumVioletRed":"Medium Violet Red","MidnightBlue":"Midnight Blue","MintCream":"Mint Cream","MistyRose":"Misty Rose","Moccasin":"Moccasin","NavajoWhite":"Navajo White","Navy":"Navy","OldLace":"Old Lace","Olive":"Olive","OliveDrab":"Olive Drab","Orange":"Orange","OrangeRed":"Orange Red","Orchid":"Orchid","PaleGoldenrod":"Pale Goldenrod","PaleGreen":"Pale Green","PaleTurquoise":"Pale Turquoise","PaleVioletRed":"Pale Violet Red","PapayaWhip":"Papaya Whip","PeachPuff":"Peach Puff","Peru":"Peru","Pink":"Pink","Plum":"Plum","PowderBlue":"Powder Blue","Purple":"Purple","Red":"Red","RosyBrown":"Rosy Brown","RoyalBlue":"Royal Blue","SaddleBrown":"Saddle Brown","Salmon":"Salmon","SandyBrown":"Sandy Brown","SeaGreen":"Sea Green","SeaShell":"Sea Shell","Sienna":"Sienna","Silver":"Silver","SkyBlue":"Sky Blue","SlateBlue":"Slate Blue","SlateGray":"Slate Gray","Snow":"Snow","SpringGreen":"Spring Green","SteelBlue":"Steel Blue","Tan":"Tan","Teal":"Teal","Thistle":"Thistle","Tomato":"Tomato","Transparent":"Transparent","Turquoise":"Turquoise","VeryDarkGray":"Very Dark Gray","Violet":"Violet","Wheat":"Wheat","White":"White","WhiteSmoke":"White Smoke","Yellow":"Yellow","YellowGreen":"Yellow Green"},"PropertyEnum":{"boolFalse":"False","boolTrue":"True","BorderStyleFixed3D":"Fixed 3D","BorderStyleFixedSingle":"Fixed Single","BorderStyleNone":"None","ChartAxesTicksAll":"All","ChartAxesTicksMajor":"Major","ChartAxesTicksNone":"None","ChartGridLinesAll":"All","ChartGridLinesMajor":"Major","ChartGridLinesNone":"None","ComboBoxStyleDropDown":"Drop Down","ComboBoxStyleDropDownList":"Drop Down List","ComboBoxStyleSimple":"Simple","ContentAlignmentBottomCenter":"Bottom Center","ContentAlignmentBottomLeft":"Bottom Left","ContentAlignmentBottomRight":"Bottom Right","ContentAlignmentMiddleCenter":"Middle Center","ContentAlignmentMiddleLeft":"Middle Left","ContentAlignmentMiddleRight":"Middle Right","ContentAlignmentTopCenter":"Top Center","ContentAlignmentTopLeft":"Top Left","ContentAlignmentTopRight":"Top Right","DataGridLineStyleNone":"None","DataGridLineStyleSolid":"Solid","DateTimePickerFormatCustom":"Custom","DateTimePickerFormatLong":"Long","DateTimePickerFormatShort":"Short","DateTimePickerFormatTime":"Time","DialogResultAbort":"Abort","DialogResultCancel":"Cancel","DialogResultIgnore":"Ignore","DialogResultNo":"No","DialogResultNone":"None","DialogResultOK":"OK","DialogResultRetry":"Retry","DialogResultYes":"Yes","DuplexDefault":"Default","DuplexHorizontal":"Horizontal","DuplexSimplex":"Simplex","DuplexVertical":"Vertical","FormStartPositionCenterParent":"Center Parent","FormStartPositionCenterScreen":"Center Screen","FormStartPositionManual":"Manual","FormStartPositionWindowsDefaultBounds":"Windows Default Bounds","FormStartPositionWindowsDefaultLocation":"Windows Default Location","FormWindowStateMaximized":"Maximized","FormWindowStateMinimized":"Minimized","FormWindowStateNormal":"Normal","HorizontalAlignmentCenter":"Center","HorizontalAlignmentLeft":"Left","HorizontalAlignmentRight":"Right","HotkeyPrefixHide":"Hide","HotkeyPrefixNone":"None","HotkeyPrefixShow":"Show","LeftRightAlignmentLeft":"Left","LeftRightAlignmentRight":"Right","PictureBoxSizeModeAutoSize":"Auto Size","PictureBoxSizeModeCenterImage":"Center Image","PictureBoxSizeModeNormal":"Normal","PictureBoxSizeModeStretchImage":"Stretch Image","RelationDirectionChildToParent":"Child-To-Parent","RelationDirectionParentToChild":"Parent-To-Child","RightToLeftInherit":"Inherit","RightToLeftNo":"No","RightToLeftYes":"Yes","SelectionModeMultiExtended":"Multi Extended","SelectionModeMultiSimple":"Multi Simple","SelectionModeNone":"None","SelectionModeOne":"One","StiAnchorModeBottom":"Bottom","StiAnchorModeLeft":"Left","StiAnchorModeRight":"Right","StiAnchorModeTop":"Top","StiAngleAngle0":"0 Degrees","StiAngleAngle180":"180 Degrees","StiAngleAngle270":"270 Degrees","StiAngleAngle45":"45 Degrees","StiAngleAngle90":"90 Degrees","StiArrowStyleArc":"Arc","StiArrowStyleArcAndCircle":"Arc and Circle","StiArrowStyleCircle":"Circle","StiArrowStyleLines":"Lines","StiArrowStyleNone":"None","StiArrowStyleTriangle":"Triangle","StiBorderSidesAll":"All","StiBorderSidesBottom":"Bottom","StiBorderSidesLeft":"Left","StiBorderSidesNone":"None","StiBorderSidesRight":"Right","StiBorderSidesTop":"Top","StiBorderStyleBump":"Bump","StiBorderStyleEtched":"Etched","StiBorderStyleFlat":"Flat","StiBorderStyleNone":"None","StiBorderStyleRaised":"Raised","StiBorderStyleRaisedInner":"Raised Inner","StiBorderStyleRaisedOuter":"Raised Outer","StiBorderStyleSunken":"Sunken","StiBorderStyleSunkenInner":"Sunken Inner","StiBorderStyleSunkenOuter":"Sunken Outer","StiBrushTypeGlare":"Glare Brush","StiBrushTypeGradient0":"Gradient Brush, Angle 0","StiBrushTypeGradient180":"Gradient Brush, Angle 180","StiBrushTypeGradient270":"Gradient Brush, Angle 270","StiBrushTypeGradient45":"Gradient Brush, Angle 45","StiBrushTypeGradient90":"Gradient Brush, Angle 90","StiBrushTypeSolid":"Solid Brush","StiButtonSendTypeFDF":"FDF","StiButtonSendTypeHTML":"HTML","StiButtonSendTypePDF":"PDF","StiButtonSendTypeXFDF":"XFDF","StiCalculationModeCompilation":"Compilation","StiCalculationModeInterpretation":"Interpretation","StiCapStyleArrow":"Arrow","StiCapStyleDiamond":"Diamond","StiCapStyleNone":"None","StiCapStyleOpen":"Open","StiCapStyleOval":"Oval","StiCapStyleSquare":"Square","StiCapStyleStealth":"Stealth","StiChartLabelsStyleCategory":"Category","StiChartLabelsStyleCategoryPercentOfTotal":"Category - Percent Of Total","StiChartLabelsStyleCategoryValue":"Category - Value","StiChartLabelsStylePercentOfTotal":"Percent Of Total","StiChartLabelsStyleValue":"Value","StiChartTitleDockBottom":"Bottom","StiChartTitleDockLeft":"Left","StiChartTitleDockRight":"Right","StiChartTitleDockTop":"Top","StiChartTrendLineTypeExponential":"Exponential","StiChartTrendLineTypeLinear":"Linear","StiChartTrendLineTypeLogarithmic":"Logarithmic","StiChartTrendLineTypeNone":"None","StiCheckStateChecked":"Checked","StiCheckStateIndeterminate":"Indeterminate","StiCheckStateUnchecked":"Unchecked","StiCheckStyleCheck":"Check","StiCheckStyleCheckRectangle":"Check Rectangle","StiCheckStyleCross":"Cross","StiCheckStyleCrossCircle":"Cross Circle","StiCheckStyleCrossRectangle":"Cross Rectangle","StiCheckStyleDotCircle":"Dot Circle","StiCheckStyleDotRectangle":"Dot Rectangle","StiCheckStyleNone":"None","StiCheckStyleNoneCircle":"None Circle","StiCheckStyleNoneRectangle":"None Rectangle","StiCheckSumNo":"No","StiCheckSumYes":"Yes","StiCode11CheckSumAuto":"Auto","StiCode11CheckSumNone":"None","StiCode11CheckSumOneDigit":"One Digit","StiCode11CheckSumTwoDigits":"Two Digits","StiColorScaleTypeColor2":"2-Color Scale","StiColorScaleTypeColor3":"3-Color Scale","StiColumnDirectionAcrossThenDown":"Across Then Down","StiColumnDirectionDownThenAcross":"Down Then Across","StiColumnShape3DBox":"Box","StiColumnShape3DPartialPyramid":"Partial Pyramid","StiColumnShape3DPyramid":"Pyramid","StiCrossHorAlignmentCenter":"Center","StiCrossHorAlignmentLeft":"Left","StiCrossHorAlignmentNone":"None","StiCrossHorAlignmentRight":"Right","StiDashboardContentAlignmentCenter":"Center","StiDashboardContentAlignmentLeft":"Left","StiDashboardContentAlignmentRight":"Right","StiDashboardContentAlignmentStretchX":"Stretch X","StiDashboardContentAlignmentStretchXY":"Stretch XY","StiDateSelectionModeAutoRange":"Auto Range","StiDateSelectionModeRange":"Range","StiDateSelectionModeSingle":"Single","StiDateTimeTypeDate":"Date","StiDateTimeTypeDateAndTime":"Date and Time","StiDateTimeTypeTime":"Time","StiDesignerScaleModeAutomaticScaling":"Automatic Scaling","StiDesignerScaleModeScaling100":"100% Scaling","StiDesignerSpecificationAuto":"Determine Automatically","StiDesignerSpecificationBeginner":"I\'m Beginner","StiDesignerSpecificationBICreator":"I\'m Creator","StiDesignerSpecificationDeveloper":"I\'m Developer","StiDirectionBottomToTop":"Bottom to Top","StiDirectionLeftToRight":"Left to Right","StiDirectionRightToLeft":"Right to Left","StiDirectionTopToBottom":"Top to Bottom","StiDisplayNameTypeFull":"Full","StiDisplayNameTypeNone":"None","StiDisplayNameTypeShort":"Short","StiDockStyleBottom":"Bottom","StiDockStyleFill":"Fill","StiDockStyleLeft":"Left","StiDockStyleNone":"None","StiDockStyleRight":"Right","StiDockStyleTop":"Top","StiDrillDownModeMultiPage":"Multi Page","StiDrillDownModeSinglePage":"Single Page","StiEanSupplementTypeFiveDigit":"FiveDigit","StiEanSupplementTypeNone":"None","StiEanSupplementTypeTwoDigit":"TwoDigit","StiEmptyCellsAsConnectPointsWithLine":"Connect Points with Line","StiEmptyCellsAsGap":"Gap","StiEmptyCellsAsZero":"Zero","StiEmptySizeModeAlignFooterToBottom":"Align Footer to Bottom","StiEmptySizeModeAlignFooterToTop":"Align Footer to Top","StiEmptySizeModeDecreaseLastRow":"Decrease Last Row","StiEmptySizeModeIncreaseLastRow":"Increase Last Row","StiEnumeratorTypeABC":"ABC","StiEnumeratorTypeArabic":"Arabic","StiEnumeratorTypeNone":"None","StiEnumeratorTypeRoman":"Roman","StiExtendedStyleBoolFalse":"False","StiExtendedStyleBoolFromStyle":"From Style","StiExtendedStyleBoolTrue":"True","StiFilterConditionBeginningWith":"beginning with","StiFilterConditionBetween":"between","StiFilterConditionContaining":"containing","StiFilterConditionEndingWith":"ending with","StiFilterConditionEqualTo":"equal to","StiFilterConditionGreaterThan":"greater than","StiFilterConditionGreaterThanOrEqualTo":"greater than or equal to","StiFilterConditionIsBlank":"is blank","StiFilterConditionIsNotBlank":"is not blank","StiFilterConditionIsNotNull":"is not null","StiFilterConditionIsNull":"is null","StiFilterConditionLessThan":"less than","StiFilterConditionLessThanOrEqualTo":"less than or equal to","StiFilterConditionNotBetween":"not between","StiFilterConditionNotContaining":"not containing","StiFilterConditionNotEqualTo":"not equal to","StiFilterDataTypeBoolean":"Boolean","StiFilterDataTypeDateTime":"DateTime","StiFilterDataTypeExpression":"Expression","StiFilterDataTypeNumeric":"Numeric","StiFilterDataTypeString":"String","StiFilterEngineReportEngine":"Report Engine","StiFilterEngineSQLQuery":"SQL Query","StiFilterItemArgument":"Argument","StiFilterItemExpression":"Expression","StiFilterItemValue":"Value","StiFilterItemValueClose":"Value Close","StiFilterItemValueEnd":"Value End","StiFilterItemValueHigh":"Value High","StiFilterItemValueLow":"Value Low","StiFilterItemValueOpen":"Value Open","StiFilterModeAnd":"And","StiFilterModeOr":"Or","StiFontIconGroupAccessibilityIcons":"Accessibility","StiFontIconGroupBrandIcons":"Brand","StiFontIconGroupDirectionalIcons":"Directional","StiFontIconGroupGenderIcons":"Gender","StiFontIconGroupMedicalIcons":"Medical","StiFontIconGroupPaymentIcons":"Payment","StiFontIconGroupSpinnerIcons":"Spinner","StiFontIconGroupTransportationIcons":"Transportation","StiFontIconGroupVideoPlayerIcons":"Video","StiFontIconGroupWebApplicationIcons":"Application","StiFontSizeModeAuto":"Auto","StiFontSizeModeTarget":"Target","StiFontSizeModeValue":"Value","StiFormStartModeOnEnd":"On End","StiFormStartModeOnPreview":"On Preview","StiFormStartModeOnStart":"On Start","StiGaugeCalculationModeAuto":"Auto","StiGaugeCalculationModeCustom":"Custom","StiGaugeRangeModePercentage":"Percentage","StiGaugeRangeModeValue":"Value","StiGaugeRangeTypeColor":"Color","StiGaugeRangeTypeNone":"None","StiGaugeTypeBullet":"Bullet","StiGaugeTypeFullCircular":"Full Circular","StiGaugeTypeHalfCircular":"Half-Circular","StiGaugeTypeHorizontalLinear":"Horizontal Linear","StiGaugeTypeLinear":"Vertical Linear","StiGroupSortDirectionAscending":"Ascending","StiGroupSortDirectionDescending":"Descending","StiGroupSortDirectionNone":"None","StiHorAlignmentCenter":"Center","StiHorAlignmentLeft":"Left","StiHorAlignmentRight":"Right","StiIconAlignmentBottom":"Bottom","StiIconAlignmentLeft":"Left","StiIconAlignmentNone":"None","StiIconAlignmentRight":"Right","StiIconAlignmentTop":"Top","StiImageProcessingDuplicatesTypeGlobalHide":"Global Hide","StiImageProcessingDuplicatesTypeGlobalMerge":"Global Merge","StiImageProcessingDuplicatesTypeGlobalRemoveImage":"Global Remove Image","StiImageProcessingDuplicatesTypeHide":"Hide","StiImageProcessingDuplicatesTypeMerge":"Merge","StiImageProcessingDuplicatesTypeNone":"None","StiImageProcessingDuplicatesTypeRemoveImage":"Remove Image","StiImageRotationFlipHorizontal":"Flip Horizontal","StiImageRotationFlipVertical":"Flip Vertical","StiImageRotationNone":"None","StiImageRotationRotate180":"Rotate 180°","StiImageRotationRotate90CCW":"Rotate 90° CCW","StiImageRotationRotate90CW":"Rotate 90° CW","StiInteractionOnClick":"None","StiInteractionOnClickApplyFilter":"Apply Filter","StiInteractionOnClickDrillDown":"Drill-Down","StiInteractionOnClickOpenHyperlink":"Open Hyperlink","StiInteractionOnClickShowDashboard":"Show Dashboard","StiInteractionOnHoverNone":"None","StiInteractionOnHoverShowHyperlink":"Show Hyperlink","StiInteractionOnHoverShowToolTip":"Show Tool Tip","StiInteractionOpenHyperlinkDestinationCurrentTab":"Current Tab","StiInteractionOpenHyperlinkDestinationNewTab":"New Tab","StiItemOrientationHorizontal":"Horizontal","StiItemOrientationVertical":"Vertical","StiItemSelectionModeMulti":"Multi","StiItemSelectionModeOne":"One","StiKeepDetailsKeepDetailsTogether":"Keep Details Together","StiKeepDetailsKeepFirstDetailTogether":"Keep First Detail Together","StiKeepDetailsKeepFirstRowTogether":"Keep First Row Together","StiKeepDetailsNone":"None","StiLabelPlacementInside":"Inside","StiLabelPlacementOutside":"Outside","StiLabelsPlacementAutoRotation":"Auto Rotation","StiLabelsPlacementNone":"None","StiLabelsPlacementOneLine":"One Line","StiLabelsPlacementTwoLines":"Two Lines","StiLegendDirectionBottomToTop":"Bottom to Top","StiLegendDirectionLeftToRight":"Left to Right","StiLegendDirectionRightToLeft":"Right to Left","StiLegendDirectionTopToBottom":"Top to Bottom","StiLegendHorAlignmentCenter":"Center","StiLegendHorAlignmentLeft":"Left","StiLegendHorAlignmentLeftOutside":"Left Outside","StiLegendHorAlignmentRight":"Right","StiLegendHorAlignmentRightOutside":"Right Outside","StiLegendVertAlignmentBottom":"Bottom","StiLegendVertAlignmentBottomOutside":"Bottom Outside","StiLegendVertAlignmentCenter":"Center","StiLegendVertAlignmentTop":"Top","StiLegendVertAlignmentTopOutside":"Top Outside","StiLineWeightNormal":"Normal","StiLineWeightThick":"Thick","StiLineWeightThin":"Thin","StiMapModeChoropleth":"Choropleth","StiMapModeOnline":"Online","StiMapTypeGroup":"Group","StiMapTypeHeatmap":"Heatmap","StiMapTypeHeatmapWithGroup":"Heatmap With Group","StiMapTypeIndividual":"Individual","StiMapTypeNone":"None","StiMapTypePoints":"Points","StiMarkerAlignmentCenter":"Center","StiMarkerAlignmentLeft":"Left","StiMarkerAlignmentRight":"Right","StiMarkerTypeCircle":"Circle","StiMarkerTypeHalfCircle":"Half Circle","StiMarkerTypeHexagon":"Hexagon","StiMarkerTypeRectangle":"Rectangle","StiMarkerTypeStar5":"Star 5","StiMarkerTypeStar6":"Star 6","StiMarkerTypeStar7":"Star 7","StiMarkerTypeStar8":"Star 8","StiMarkerTypeTriangle":"Triangle","StiNestedFactorHigh":"High","StiNestedFactorLow":"Low","StiNestedFactorNormal":"Normal","StiNumberOfPassDoublePass":"Double Pass","StiNumberOfPassSinglePass":"Single Pass","StiOnlineMapHeatmapColorGradientTypeAddRange":"Add Range","StiOnlineMapHeatmapColorGradientTypeBlackAquaWhite":"Black Aqua White","StiOnlineMapHeatmapColorGradientTypeBlueRed":"Blue Red","StiOnlineMapHeatmapColorGradientTypeColorSpectrum":"Color Spectrum","StiOnlineMapHeatmapColorGradientTypeDeepSea":"Deep Sea","StiOnlineMapHeatmapColorGradientTypeHeatedMetal":"Heated Metal","StiOnlineMapHeatmapColorGradientTypeIncandescent":"Incandescent","StiOnlineMapHeatmapColorGradientTypeSteppedColors":"Stepped Colors","StiOnlineMapHeatmapColorGradientTypeSunrise":"Sunrise","StiOnlineMapHeatmapColorGradientTypeVisibleSpectrum":"Visible Spectrum","StiOnlineMapLocationTypeAdminDivision1":"AdminDivision1","StiOnlineMapLocationTypeAdminDivision2":"AdminDivision2","StiOnlineMapLocationTypeAuto":"Auto","StiOnlineMapLocationTypeCountryRegion":"CountryRegion","StiOnlineMapLocationTypeNeighborhood":"Neighborhood","StiOnlineMapLocationTypePopulatedPlace":"PopulatedPlace","StiOnlineMapLocationTypePostcode1":"Postcode1","StiOnlineMapLocationTypePostcode2":"Postcode2","StiOnlineMapLocationTypePostcode3":"Postcode3","StiOnlineMapLocationTypePostcode4":"Postcode4","StiOrientationHorizontal":"Horizontal","StiOrientationHorizontalRight":"Horizontal Right","StiOrientationVertical":"Vertical","StiPageOrientationLandscape":"Landscape","StiPageOrientationPortrait":"Portrait","StiPenStyleDash":"Dash","StiPenStyleDashDot":"Dash Dot","StiPenStyleDashDotDot":"Dash Dot Dot","StiPenStyleDot":"Dot","StiPenStyleDouble":"Double","StiPenStyleNone":"None","StiPenStyleSolid":"Solid","StiPlacementInside":"Inside","StiPlacementOutside":"Outside","StiPlacementOverlay":"Overlay","StiPlesseyCheckSumModulo10":"Modulo10","StiPlesseyCheckSumModulo11":"Modulo11","StiPlesseyCheckSumNone":"None","StiPreviewModeDotMatrix":"Dot-Matrix","StiPreviewModeStandard":"Standard","StiPreviewModeStandardAndDotMatrix":"Standard and Dot-Matrix","StiPrintOnEvenOddPagesTypeIgnore":"Ignore","StiPrintOnEvenOddPagesTypePrintOnEvenPages":"Print on Even Pages","StiPrintOnEvenOddPagesTypePrintOnOddPages":"Print on Odd Pages","StiPrintOnTypeAllPages":"All Pages","StiPrintOnTypeExceptFirstAndLastPage":"Except First and Last Page","StiPrintOnTypeExceptFirstPage":"Except First Page","StiPrintOnTypeExceptLastPage":"Except Last Page","StiPrintOnTypeOnlyFirstAndLastPage":"Only First and Last Page","StiPrintOnTypeOnlyFirstPage":"Only First Page","StiPrintOnTypeOnlyLastPage":"Only Last Page","StiProcessAtEndOfPage":"End of Page","StiProcessAtEndOfReport":"End of Report","StiProcessAtNone":"None","StiProcessingDuplicatesTypeBasedOnTagHide":"Hide based on Tag","StiProcessingDuplicatesTypeBasedOnTagMerge":"Merge based on Tag","StiProcessingDuplicatesTypeBasedOnTagRemoveText":"Remove Text based on Tag","StiProcessingDuplicatesTypeBasedOnValueAndTagHide":"Hide based on Value and Tag","StiProcessingDuplicatesTypeBasedOnValueAndTagMerge":"Merge based on Value and Tag","StiProcessingDuplicatesTypeBasedOnValueRemoveText":"Remove based on Value Text","StiProcessingDuplicatesTypeGlobalBasedOnValueAndTagHide":"Global Hide based on Value and Tag","StiProcessingDuplicatesTypeGlobalBasedOnValueAndTagMerge":"Global Merge based on Value and Tag","StiProcessingDuplicatesTypeGlobalBasedOnValueRemoveText":"Global Remove based on Value Text","StiProcessingDuplicatesTypeGlobalHide":"Global Hide","StiProcessingDuplicatesTypeGlobalMerge":"Global Merge","StiProcessingDuplicatesTypeGlobalRemoveText":"Global Remove Text","StiProcessingDuplicatesTypeHide":"Hide","StiProcessingDuplicatesTypeMerge":"Merge","StiProcessingDuplicatesTypeNone":"None","StiProcessingDuplicatesTypeRemoveText":"Remove Text","StiProgressElementModeCircle":"Circle","StiProgressElementModeDataBars":"DataBars","StiProgressElementModePie":"Pie","StiQRCodeBodyShapeTypeCircle":"Circle","StiQRCodeBodyShapeTypeCircular":"Circular","StiQRCodeBodyShapeTypeDiamond":"Diamond","StiQRCodeBodyShapeTypeDockedDiamonds":"Docked Diamonds","StiQRCodeBodyShapeTypeDot":"Dot","StiQRCodeBodyShapeTypeRoundedSquare":"Rounded Square","StiQRCodeBodyShapeTypeSquare":"Square","StiQRCodeBodyShapeTypeStar":"Star","StiQRCodeBodyShapeTypeZebraCross":"Zebra Cross","StiQRCodeBodyShapeTypeZebraHorizontal":"Zebra Horizontal","StiQRCodeBodyShapeTypeZebraVertical":"Zebra Vertical","StiQRCodeEyeBallShapeTypeCircle":"Circle","StiQRCodeEyeBallShapeTypeDots":"Dots","StiQRCodeEyeBallShapeTypeRound":"Round","StiQRCodeEyeBallShapeTypeSquare":"Square","StiQRCodeEyeBallShapeTypeStar":"Star","StiQRCodeEyeBallShapeTypeZebraHorizontal":"Zebra Horizontal","StiQRCodeEyeBallShapeTypeZebraVertical":"Zebra Vertical","StiRadarStyleXFCircle":"Circle","StiRadarStyleXFPolygon":"Polygon","StiReportCacheModeAuto":"Auto","StiReportCacheModeOff":"Off","StiReportCacheModeOn":"On","StiReportUnitTypeCentimeters":"Centimeters","StiReportUnitTypeHundredthsOfInch":"Hundredths of Inch","StiReportUnitTypeInches":"Inches","StiReportUnitTypeMillimeters":"Millimeters","StiReportUnitTypePixels":"Pixels","StiRestrictionsAll":"All","StiRestrictionsAllowChange":"Allow Change","StiRestrictionsAllowDelete":"Allow Delete","StiRestrictionsAllowMove":"Allow Move","StiRestrictionsAllowResize":"Allow Resize","StiRestrictionsAllowSelect":"Allow Select","StiRestrictionsNone":"None","StiSelectionModeFirst":"First","StiSelectionModeFromVariable":"From Variable","StiSelectionModeNothing":"Nothing","StiSeriesLabelsValueTypeArgument":"Argument","StiSeriesLabelsValueTypeArgumentValue":"Argument - Value","StiSeriesLabelsValueTypeSeriesTitle":"Series Title","StiSeriesLabelsValueTypeSeriesTitleArgument":"Series Title - Argument","StiSeriesLabelsValueTypeSeriesTitleValue":"Series Title - Value","StiSeriesLabelsValueTypeTag":"Tag","StiSeriesLabelsValueTypeValue":"Value","StiSeriesLabelsValueTypeValueArgument":"Value - Argument","StiSeriesLabelsValueTypeWeight":"Weight","StiSeriesSortDirectionAscending":"Ascending","StiSeriesSortDirectionDescending":"Descending","StiSeriesSortTypeArgument":"Argument","StiSeriesSortTypeNone":"None","StiSeriesSortTypeValue":"Value","StiSeriesXAxisBottomXAxis":"Bottom X Axis","StiSeriesXAxisTopXAxis":"Top X Axis","StiSeriesYAxisLeftYAxis":"Left Y Axis","StiSeriesYAxisRightYAxis":"Right Y Axis","StiShapeDirectionDown":"Down","StiShapeDirectionLeft":"Left","StiShapeDirectionRight":"Right","StiShapeDirectionUp":"Up","StiShiftModeDecreasingSize":"Decreasing Size","StiShiftModeIncreasingSize":"Increasing Size","StiShiftModeNone":"None","StiShiftModeOnlyInWidthOfComponent":"Only in Width of Component","StiShowSeriesLabelsFromChart":"From Chart","StiShowSeriesLabelsFromSeries":"From Series","StiShowSeriesLabelsNone":"None","StiShowXAxisBoth":"Both","StiShowXAxisBottom":"Bottom","StiShowXAxisCenter":"Center","StiShowYAxisBoth":"Both","StiShowYAxisCenter":"Center","StiShowYAxisLeft":"Left","StiSignatureTypeDigitalSignature":"Digital Signature","StiSignatureTypeDraw":"Draw","StiSignatureTypeType":"Type","StiSizeModeAutoSize":"Auto Size","StiSizeModeFit":"Fit","StiSortDirectionAsc":"Ascending","StiSortDirectionDesc":"Descending","StiSortDirectionNone":"None","StiSortTypeByDisplayValue":"by Display Value","StiSortTypeByValue":"by Value","StiSqlSourceTypeStoredProcedure":"Stored Procedure","StiSqlSourceTypeTable":"Query","StiStyleComponentTypeChart":"Chart","StiStyleComponentTypeCheckBox":"Check Box","StiStyleComponentTypeCrossTab":"Cross-Tab","StiStyleComponentTypeImage":"Image","StiStyleComponentTypePrimitive":"Primitive","StiStyleComponentTypeText":"Text","StiStyleConditionTypeComponentName":"Component Name","StiStyleConditionTypeComponentType":"Component Type","StiStyleConditionTypeLocation":"Location","StiStyleConditionTypePlacement":"Placement","StiSummaryValuesAllValues":"All Values","StiSummaryValuesSkipNulls":"Skip Nulls","StiSummaryValuesSkipZerosAndNulls":"Skip Zeros and Nulls","StiTablceCellTypeCheckBox":"CheckBox","StiTablceCellTypeImage":"Image","StiTablceCellTypeRichText":"RichText","StiTablceCellTypeText":"Text","StiTableAutoWidthNone":"None","StiTableAutoWidthPage":"Page","StiTableAutoWidthTable":"Table","StiTableAutoWidthTypeFullTable":"Full Table","StiTableAutoWidthTypeLastColumns":"Last Columns","StiTableAutoWidthTypeNone":"None","StiTargetModePercentage":"Percentage","StiTargetModeVariation":"Variation","StiTextHorAlignmentCenter":"Center","StiTextHorAlignmentLeft":"Left","StiTextHorAlignmentRight":"Right","StiTextHorAlignmentWidth":"Width","StiTextPositionCenterBottom":"Center Bottom","StiTextPositionCenterTop":"Center Top","StiTextPositionLeftBottom":"Left Bottom","StiTextPositionLeftTop":"Left Top","StiTextPositionRightBottom":"Right Bottom","StiTextPositionRightTop":"Right Top","StiTextQualityStandard":"Standard","StiTextQualityTypographic":"Typographic","StiTextQualityWysiwyg":"Wysiwyg","StiTextSizeModeFit":"Fit","StiTextSizeModeTrimming":"Trimming","StiTextSizeModeWordWrap":"Word Wrap","StiTimeDateStepDay":"Day","StiTimeDateStepHour":"Hour","StiTimeDateStepMinute":"Minute","StiTimeDateStepMonth":"Month","StiTimeDateStepNone":"None","StiTimeDateStepSecond":"Second","StiTimeDateStepYear":"Year","StiTitlePositionInside":"Inside","StiTitlePositionOutside":"Outside","StiTopNModeBottom":"Bottom","StiTopNModeNone":"None","StiTopNModeTop":"Top","StiTypeModeList":"List","StiTypeModeNullableValue":"Nullable Value","StiTypeModeRange":"Range","StiTypeModeValue":"Value","StiUnitAlignmentPrefix":"Prefix","StiUnitAlignmentPrefixInside":"Prefix Inside","StiUnitAlignmentPrefixInsideWithSpace":"Prefix Inside with Space","StiUnitAlignmentSuffix":"Suffix","StiUnitAlignmentSuffixInside":"Suffix Inside","StiUnitAlignmentSuffixInsideWithSpace":"Suffix Inside with Space","StiVertAlignmentBottom":"Bottom","StiVertAlignmentCenter":"Center","StiVertAlignmentTop":"Top","StiViewModeNormal":"Normal","StiViewModePageBreakPreview":"Page Break Preview","StiXmlTypeAdoNetXml":"ADO.NET XML","StiXmlTypeXml":"XML","StringAlignmentCenter":"Center","StringAlignmentFar":"Far","StringAlignmentNear":"Near","StringTrimmingCharacter":"Character","StringTrimmingEllipsisCharacter":"Ellipsis Character","StringTrimmingEllipsisPath":"Ellipsis Path","StringTrimmingEllipsisWord":"Ellipsis Word","StringTrimmingNone":"None","StringTrimmingWord":"Word"},"PropertyEvents":{"AfterPrintEvent":"After Print","AfterSelectEvent":"After Select","BeforePrintEvent":"Before Print","BeginRenderEvent":"Begin Render","CheckedChangedEvent":"Checked Changed","ClickEvent":"Click","ClosedFormEvent":"Closed Form","ClosingFormEvent":"Closing Form","ColumnBeginRenderEvent":"Column Begin Render","ColumnEndRenderEvent":"Column End Render","ConnectedEvent":"ConnectedEvent","ConnectingEvent":"ConnectingEvent","DisconnectedEvent":"Disconnected","DisconnectingEvent":"Disconnecting","DoubleClickEvent":"Double Click","EndRenderEvent":"End Render","EnterEvent":"Enter","ExportedEvent":"Exported","ExportingEvent":"Exporting","FillParametersEvent":"Fill Parameters","GetArgumentEvent":"Get Argument","GetBarCodeEvent":"Get BarCode","GetBookmarkEvent":"Get Bookmark","GetCheckedEvent":"Get Checked","GetCollapsedEvent":"Get Collapsed","GetCrossValueEvent":"Get Cross Value","GetCutPieListEvent":"Get Cut Pie List","GetDataUrlEvent":"Get DataUrl","GetDisplayCrossValueEvent":"Get Display Cross Value","GetDrillDownReportEvent":"Get Drill-Down Report","GetExcelSheetEvent":"Get Excel Sheet","GetExcelValueEvent":"Get Excel Value","GetHyperlinkEvent":"Get Hyperlink","GetImageDataEvent":"Get Image Data","GetImageURLEvent":"Get Image URL","GetListOfArgumentsEvent":"Get List of Arguments","GetListOfHyperlinksEvent":"Get List of Hyperlinks","GetListOfTagsEvent":"Get List of Tags","GetListOfToolTipsEvent":"Get List of Tool Tips","GetListOfValuesEndEvent":"Get List of Values End","GetListOfValuesEvent":"Get List of Values","GetListOfWeights":"Get List of Weights","GetListOfWeightsEvent":"Get List of Weights","GetPointerEvent":"Get Pointer","GetSummaryExpressionEvent":"Get Summary Expression","GetTagEvent":"Get Tag","GetTitleEvent":"Get Title","GetToolTipEvent":"Get Tool Tip","GetValueEndEvent":"Get Value End","GetValueEvent":"Get Value","GetWeightEvent":"Get Weight","LeaveEvent":"Leave","LoadFormEvent":"Load Form","MouseDownEvent":"Mouse Down","MouseEnterEvent":"Mouse Enter","MouseLeaveEvent":"Mouse Leave","MouseMoveEvent":"Mouse Move","MouseUpEvent":"Mouse Up","NewAutoSeriesEvent":"New Auto Series","PositionChangedEvent":"Position Changed","PrintedEvent":"Printed","PrintingEvent":"Printing","ProcessCellEvent":"Process Cell","ProcessChartEvent":"Process Chart","RenderingEvent":"Rendering","ReportCacheProcessingEvent":"Report Cache Processing","SelectedIndexChangedEvent":"Selected Index Changed","StateRestoreEvent":"State Restore","StateSaveEvent":"State Save","ValueChangedEvent":"Value Changed"},"PropertyHatchStyle":{"BackwardDiagonal":"Backward Diagonal","Cross":"Cross","DarkDownwardDiagonal":"Dark Downward Diagonal","DarkHorizontal":"Dark Horizontal","DarkUpwardDiagonal":"Dark Upward Diagonal","DarkVertical":"Dark Vertical","DashedDownwardDiagonal":"Dashed Downward Diagonal","DashedHorizontal":"Dashed Horizontal","DashedUpwardDiagonal":"Dashed Upward Diagonal","DashedVertical":"Dashed Vertical","DiagonalBrick":"Diagonal Brick","DiagonalCross":"Diagonal Cross","Divot":"Divot","DottedDiamond":"Dotted Diamond","DottedGrid":"Dotted Grid","ForwardDiagonal":"Forward Diagonal","Horizontal":"Horizontal","HorizontalBrick":"Horizontal Brick","LargeCheckerBoard":"Large Checker Board","LargeConfetti":"Large Confetti","LargeGrid":"Large Grid","LightDownwardDiagonal":"Light Downward Diagonal","LightHorizontal":"Light Horizontal","LightUpwardDiagonal":"Light Upward Diagonal","LightVertical":"Light Vertical","NarrowHorizontal":"Narrow Horizontal","NarrowVertical":"Narrow Vertical","OutlinedDiamond":"Outlined Diamond","Percent05":"Percent05","Percent10":"Percent10","Percent20":"Percent20","Percent25":"Percent25","Percent30":"Percent30","Percent40":"Percent40","Percent50":"Percent50","Percent60":"Percent60","Percent70":"Percent70","Percent75":"Percent75","Percent80":"Percent80","Percent90":"Percent90","Plaid":"Plaid","Shingle":"Shingle","SmallCheckerBoard":"Small Checker Board","SmallConfetti":"Small Confetti","SmallGrid":"Small Grid","SolidDiamond":"Solid Diamond","Sphere":"Sphere","Trellis":"Trellis","Vertical":"Vertical","Wave":"Wave","Weave":"Weave","WideDownwardDiagonal":"Wide Downward Diagonal","WideUpwardDiagonal":"Wide Upward Diagonal","ZigZag":"Zig Zag"},"PropertyMain":{"AcceptsReturn":"Accepts Return","AcceptsTab":"Accepts Tab","Actual":"Actual","AddClearZone":"Add Clear Zone","Advanced":"Advanced","AggregateFunction":"Aggregate Function","AggregateFunctions":"Aggregate Functions","Alias":"Alias","Alignment":"Alignment","AllowApplyBorderColor":"Allow Apply Border Color","AllowApplyBrush":"Allow Apply Brush","AllowApplyBrushNegative":"Allow Apply Brush Negative","AllowApplyColorNegative":"Allow Apply Color Negative","AllowApplyLineColor":"Allow Apply Line Color","AllowApplyStyle":"Allow Apply Style","AllowExpressions":"Allow Expressions","AllowHtmlTags":"Allow HTML Tags","AllowNull":"Allow Null","AllowSeries":"Allow Series","AllowSeriesElements":"Allow Series Elements","AllowSorting":"Allow Sorting","AllowUseBackColor":"Allow Use Back Color","AllowUseBorder":"Allow Use Border","AllowUseBorderFormatting":"Allow Use Border Formatting","AllowUseBorderSides":"Allow Use Border Sides","AllowUseBorderSidesFromLocation":"Allow Use Border Sides from Location","AllowUseBrush":"Allow Use Brush","AllowUseFont":"Allow Use Font","AllowUseForeColor":"Allow Use Fore Color","AllowUseHorAlignment":"Allow Use Hor Alignment","AllowUseImage":"Allow Use Image","AllowUseNegativeTextBrush":"Allow Use Negative Text Brush","AllowUserValues":"Allow User Values","AllowUseTextBrush":"Allow Use Text Brush","AllowUseTextFormat":"Allow Use Text Format","AllowUseTextOptions":"Allow Use Text Options","AllowUseVertAlignment":"Allow Use Vert Alignment","AllowUsingAsSqlParameter":"Allow using as SQL parameter","AlternatingBackColor":"Alternating Back Color","AlternatingCellBackColor":"Alternating Cell Back Color","AlternatingCellForeColor":"Alternating Cell Fore Color","AlternatingDataColor":"Alternating Data Color","AlternatingDataForeground":"Alternating Data Foreground","Always":"Always","Anchor":"Anchor","Angle":"Angle","Antialiasing":"Antialiasing","Apply":"Apply","Area":"Area","Argument":"Argument","ArgumentDataColumn":"Argument Data Column","ArgumentFormat":"Argument Format","Arguments":"Arguments","ArrowHeight":"Arrow Height","ArrowStyle":"Arrow Style","ArrowWidth":"Arrow Width","AspectRatio":"Aspect Ratio","Author":"Author","Auto":"Auto","AutoCalculateCenterPoint":"Auto Calculate Center Point","AutoDataColumns":"Auto Data Columns","AutoDataRows":"Auto Data Rows","AutoLocalizeReportOnRun":"Auto Localize Report on Run","AutoRefresh":"Auto Refresh","AutoRotate":"Auto Rotate","AutoScale":"Auto Scale","AutoSeriesColorDataColumn":"Auto Series Color Data Column","AutoSeriesKeyDataColumn":"Auto Series Key Data Column","AutoSeriesTitleDataColumn":"Auto Series Title Data Column","AutoWidth":"Auto Width","AutoWidthType":"Auto Width Type","AvailableInTheViewer":"Available in the Viewer","AxisLabelsColor":"Axis Labels Color","AxisLineColor":"Axis Line Color","AxisTitleColor":"Axis Title Color","AxisValue":"Axis Value","BackColor":"Back Color","Background":"Background","BackgroundColor":"Background Color","BandColor":"Band Color","BarCodeType":"Bar Code Type","BasicStyleColor":"Basic Style Color","Blend":"Blend","Blocks":"Blocks","BodyBrush":"Body Brush","BodyShape":"Body Shape","Bold":"Bold","Bookmark":"Bookmark","Border":"Border","BorderBrush":"Border Brush","BorderColor":"Border Color","BorderColorNegative":"Border Color Negative","Borders":"Borders","BorderSize":"Border Size","BorderStyle":"Border Style","BorderThickness":"Border Thickness","BorderWidth":"Border Width","Bottom":"Bottom","BottomLeft":"Bottom-Left","BottomRight":"Bottom-Right","BottomSide":"Bottom Side","BreakIfLessThan":"Break if Less Than","Brush":"Brush","BrushNegative":"Brush Negative","BrushType":"Brush Type","BubbleBackColor":"Bubble Back Color","BubbleBorderColor":"Bubble Border Color","BusinessObject":"Business Object","CacheAllData":"Cache All Data","CacheTotals":"Cache Totals","CalcInvisible":"Calc Invisible","CalculatedDataColumn":"Calculated Data Column","CalculationMode":"Calculation Mode","CanBreak":"Can Break","Cancel":"Cancel","CanGrow":"Can Grow","CanShrink":"Can Shrink","Categories":"Categories","Category":"Category","CategoryConnections":"Connections","CellAlignment":"Cell Alignment","CellBackColor":"Cell Back Color","CellDockStyle":"Cell Dock Style","CellForeColor":"Cell Fore Color","CellHeight":"Cell Height","CellType":"Cell Type","CellWidth":"Cell Width","Center":"Center","CenterPoint":"Center Point","ChartAreaBorderColor":"Chart Area Border Color","ChartAreaBrush":"Chart Area Brush","ChartAreaShowShadow":"Chart Area Show Shadow","ChartType":"Chart Type","CheckAlignment":"Check Alignment","CheckColor":"Check Color","Checked":"Checked","CheckedIcon":"Checked Icon","CheckOnClick":"Check on Click","CheckStyle":"Check Style","CheckStyleForFalse":"Check Style for False","CheckStyleForTrue":"Check Style for True","Checksum":"Checksum","CheckSum":"CheckSum","CheckSum1":"CheckSum1","CheckSum2":"CheckSum2","Child":"Child","ChildColumns":"Child Columns","ChildSource":"Child Source","City":"City","ClearFormat":"Clear Format","CloneContainer":"Clone Container","CloseValues":"Close Values","Code":"Code","CodePage":"Code Page","Collapsed":"Collapsed","CollapseGroupFooter":"Collapse Group Footer","CollapsingEnabled":"Collapsing Enabled","Collate":"Collate","CollectionName":"Collection Name","Color":"Color","ColorDataColumn":"Color Data Column","ColorEach":"Color Each","ColorMeter":"Color Meter","Colors":"Colors","ColorScaleCondition":"Color Scale Condition","ColorScaleType":"Color Scale Type","Column":"Column","ColumnCount":"Column Count","ColumnDirection":"Column Direction","ColumnGaps":"Column Gaps","ColumnHeaderBackColor":"Column Header Back Color","ColumnHeaderForeColor":"Column Header Fore Color","ColumnHeadersVisible":"Column Headers Visible","Columns":"Columns","ColumnShape":"Column Shape","ColumnWidth":"Column Width","CommandTimeout":"Command Timeout","CompanyPrefix":"Company Prefix","ComponentStyle":"Component Style","Condition":"Condition","ConditionOptions":"Condition Options","Conditions":"Conditions","ConnectionString":"Connection String","ConnectOnStart":"Connect on Start","ConstantLines":"Constant Lines","Container":"Container","ContentAlignment":"Content Alignment","ContinuousText":"Continuous Text","ContourColor":"Contour Color","Converting":"Converting","ConvertNulls":"Convert Nulls","Copies":"Copies","CornerRadius":"Corner Radius","Count":"Count","CountData":"Count Data","Country":"Country","Create":"Create","CreateFieldOnDoubleClick":"Create Field on Double Click","CreateLabel":"Create Label","CrossFiltering":"Cross-Filtering","Culture":"Culture","CustomFonts":"Custom Fonts","CustomFormat":"Custom Format","CutPieList":"Cut Pie List","Data":"Data","DataAdapter":"Data Adapter","DataAdapters":"Data Adapters","DataBarCondition":"Data Bar Condition","DataBindings":"Data Bindings","DataCells":"Data Cells","DataColor":"Data Color","DataColumn":"Data Column","DataColumns":"Data Columns","DataField":"Data Field","DataForeground":"Data Foreground","DataRelation":"Data Relation","DataRows":"Data Rows","DataSource":"Data Source","DataSources":"Data Sources","DataTextField":"Data Text Field","DataTransformation":"Data Transformation","DataType":"Data Type","DataUrl":"Data URL","DateInfo":"Date Info","DateTimeMode":"DateTime Mode","DateTimeStep":"Date Time Step","Default":"Default","DefaultColor":"Default Color","DefaultHeightCell":"Default Height of Cell","DefaultNamespace":"Default Namespace","DependentColumn":"Dependent Column","DependentValue":"Dependent Value","Description":"Description","Destination":"Destination","DetectUrls":"Detect URLs","DeviceWidth":"Device Width","DialogResult":"Dialog Result","Diameter":"Diameter","Direction":"Direction","Disabled":"Disabled","DisplayNameType":"Display Name Type","DisplayValue":"Display Value","Distance":"Distance","DistanceBetweenTabs":"Distance Between Tabs","Dock":"Dock","DockableTable":"Dockable Table","DockStyle":"Dock Style","DrawBorder":"Draw Border","DrawHatch":"Draw Hatch","DrawLine":"Draw Line","DrillDown":"Drill-Down","DrillDownEnabled":"Drill-Down Enabled","DrillDownMode":"Drill-Down Mode","DrillDownPage":"Drill-Down Page","DrillDownParameter1":"Drill-Down Parameter 1","DrillDownParameter2":"Drill-Down Parameter 2","DrillDownParameter3":"Drill-Down Parameter 3","DrillDownParameter4":"Drill-Down Parameter 4","DrillDownParameter5":"Drill-Down Parameter 5","DrillDownParameters":"Drill-Down Parameters","DrillDownReport":"Drill-Down Report","DropDownAlign":"Drop Down Align","DropDownStyle":"Drop Down Style","DropDownWidth":"Drop Down Width","DropShadow":"Drop Shadow","Duplex":"Duplex","Editable":"Editable","Effects":"Effects","EmptyBorderBrush":"Empty Border Brush","EmptyBorderWidth":"Empty Border Width","EmptyBrush":"Empty Brush","EmptyValue":"Empty Value","Enabled":"Enabled","EnableLog":"Enabled Log","EncodingMode":"Encoding Mode","EncodingType":"Encoding Type","EndCap":"End Cap","EndColor":"End Color","EndValue":"End Value","EndValues":"End Values","EndWidth":"End Width","EngineVersion":"Engine Version","EnumeratorSeparator":"Enumerator Separator","EnumeratorType":"Enumerator Type","ErrorCorrectionLevel":"Error Correction Level","ErrorsCorrectionLevel":"Errors Correction Level","EvenStyle":"Even Style","ExceedMargins":"Exceed Margins","ExcelSheet":"Excel Sheet","ExcelValue":"Excel Value","Expand":"Expand","Exponential":"Exponential","ExportAsImage":"Export as Image","Expression":"Expression","ExtensionDigit":"Extension Digit","EyeBallBrush":"Eye Ball Brush","EyeBallShape":"Eye Ball Shape","EyeFrameBrush":"Eye Frame Brush","EyeFrameShape":"Eye Frame Shape","FaqPage":"FAQ Page","Field":"Field","FieldIs":"Field Is","Fifth":"Fifth","File":"File","Fill":"Fill","FillColor":"Fill Color","Filter":"Filter","FilterElements":"Filter Elements","FilterEngine":"Filter Engine","FilterMode":"Filter Mode","FilterOn":"Filter On","Filters":"Filters","First":"First","FirstTabOffset":"First Tab Offset","FixedWidth":"Fixed Width","Flat":"Flat","FlatMode":"Flat Mode","Focus":"Focus","Font":"Font","FontBold":"Font Bold","FontItalic":"Font Italic","FontName":"Font Name","FontSize":"Font Size","FontSizeMode":"Font Size Mode","FontStrikeout":"Font Strikeout","FontSubscript":"Subscript","FontSuperscript":"Superscript","FontUnderline":"Font Underline","FontUnit":"Font Unit","FooterCanBreak":"Footer Can Break","FooterCanGrow":"Footer Can Grow","FooterCanShrink":"Footer Can Shrink","FooterColor":"Footer Color","FooterFont":"Footer Font","FooterForeColor":"Footer Fore Color","FooterForeground":"Footer Foreground","FooterPrintAtBottom":"Footer Print At Bottom","FooterPrintIfEmpty":"Footer Print If Empty","FooterPrintOn":"Footer Print On","FooterPrintOnAllPages":"Footer Print On All Pages","FooterPrintOnEvenOddPages":"Footer Print On Even Odd Pages","FooterRowsCount":"Footer Rows Count","Footers":"Footers","ForeColor":"Fore Color","Format":"Format","FormSettings":"Form Settings","Fourth":"Fourth","From":"From","FrozenColumns":"Frozen Columns","FullConvertExpression":"Full Convert Expression","FullName":"Full Name","Function":"Function","Functions":"Functions","GisSettings":"Gis Settings","GlobalizationStrings":"Globalization Strings","GlobalizedName":"Globalized Name","GlyphColor":"Glyph Color","GridColor":"Grid Color","GridColumns":"Grid Columns","GridLineColor":"Grid Line Color","GridLinesHor":"Grid Lines Horizontal","GridLinesHorColor":"Grid Lines Horizontal Color","GridLinesHorRight":"Grid Lines Horizontal Right","GridLineStyle":"Grid Line Style","GridLinesVert":"Grid Lines Vertical","GridLinesVertColor":"Grid Lines Vertical Color","GridOutline":"Grid Outline","GridVerticalStep":"Grid Vertical Step","Group":"Group","GroupDataColumn":"Group Data Column","GroupMeter":"Group Meter","GrowToHeight":"Grow to Height","Header":"Header","HeaderAlignment":"Header Alignment","HeaderBackColor":"Header Back Color","HeaderCanBreak":"Header Can Break","HeaderCanGrow":"Header Can Grow","HeaderCanShrink":"Header Can Shrink","HeaderColor":"Header Color","HeaderFont":"Header Font","HeaderForeColor":"Header Fore Color","HeaderForeground":"Header Foreground","HeaderPrintAtBottom":"Header Print At Bottom","HeaderPrintIfEmpty":"Header Print If Empty","HeaderPrintOn":"Header Print On","HeaderPrintOnAllPages":"Header Print On All Pages","HeaderPrintOnEvenOddPages":"Header Print On Even Odd Pages","HeaderRowsCount":"Header Rows Count","Headers":"Headers","HeaderText":"Header Text","Heading":"Heading","Heatmap":"Heatmap","HeatmapColors":"Heatmap Colors","HeatmapWithGroup":"Heatmap With Group","Height":"Height","HideSeriesWithEmptyTitle":"Hide Series with Empty Title","HideZeros":"Hide Zeros","High":"High","HighlightCondition":"Highlight Condition","HighValues":"High Values","HorAlignment":"Horizontal Alignment","HorSpacing":"Horizontal Spacing","HotBackColor":"Hot Back Color","HotColumnHeaderBackColor":"Hot Column Header Back Color","HotForeColor":"Hot Fore Color","HotGlyphColor":"Hot Glyph Color","HotHeaderColor":"Hot Header Color","HotkeyPrefix":"Hotkey Prefix","HotRowHeaderBackColor":"Hot Row Header Back Color","HotSelectedBackColor":"Hot Selected Back Color","HotSelectedForeColor":"Hot Selected Fore Color","HotSelectedGlyphColor":"Hot Selected Glyph Color","HtmlPreviewMode":"HTML Preview Mode","HtmlTags":"HTML Tags","Hyperlink":"Hyperlink","HyperlinkDataColumn":"Hyperlink Data Column","HyperlinkPattern":"Hyperlink Pattern","Icon":"Icon","IconAlignment":"Icon Alignment","IconBrush":"Icon Brush","IconColor":"Icon Color","IconSet":"Icon Set","IconSetCondition":"Icon Set Condition","Idents":"Indents","Image":"Image","ImageAlign":"Image Align","ImageAlignment":"Image Alignment","ImageData":"Image Data","ImageHorAlignment":"Image Horizontal Alignment","ImageMultipleFactor":"Image Multiple Factor","ImageRotation":"Image Rotation","ImageStretch":"Image Stretch","ImageTiling":"Image Tiling","ImageTransparency":"Image Transparency","ImageURL":"Image URL","ImageVertAlignment":"Image Vertical Alignment","ImportRelations":"Import Relations","Increment":"Increment","Indent":"Indent","IndividualColor":"Individual Color","InitBy":"Init by","Initials":"Initials","InitialSelection":"Initial Selection","InitialSelectionSource":"Initial Selection Source","InnerText":"Inner Text","Insert":"Insert","Interaction":"Interaction","InterlacedBrush":"Interlaced Brush","InterlacingHor":"Interlacing Horizontal","InterlacingHorBrush":"Interlacing Horizontal Brush","InterlacingVert":"Interlacing Vertical","InterlacingVertBrush":"Interlacing Vertical Brush","Interpolation":"Interpolation","IsReversed":"Is Reversed","Italic":"Italic","Item":"Item","ItemHeight":"Item Height","Items":"Items","KeepChildTogether":"Keep Child Together","KeepCrossTabTogether":"Keep Cross-Tab Together","KeepDetails":"Keep Details","KeepDetailsTogether":"Keep Details Together","KeepFooterTogether":"Keep Footer Together","KeepGroupFooterTogether":"Keep Group Footer Together","KeepGroupHeaderTogether":"Keep Group Header Together","KeepGroupTogether":"Keep Group Together","KeepHeaderTogether":"Keep Header Together","KeepMergedCellsTogether":"Keep Merged Cells Together","KeepReportSummaryTogether":"Keep Report Summary Together","KeepSubReportTogether":"Keep Sub-Report Together","Key":"Key","KeyDataColumn":"Key Data Column","KeyMeter":"Key Meter","KeyMeters":"Key Meters","Keys":"Keys","Label":"Label","LabelColor":"Label Color","LabelForeground":"Label Foreground","LabelRotationMode":"Label Rotation Mode","Labels":"Labels","LabelsColor":"Labels Color","LabelShadowForeground":"Label Shadow Foreground","LabelsOffset":"Labels Offset","Language":"Language","LargeHeight":"Large Height","LargeHeightFactor":"Large Height Factor","LaTexExpression":"LaTex Expression","Latitude":"Latitude","Layout":"Layout","Left":"Left","LeftSide":"Left Side","Legend":"Legend","LegendBorderColor":"Legend Border Color","LegendBrush":"Legend Brush","LegendLabelsColor":"Legend Labels Color","LegendTitleColor":"Legend Title Color","LegendValueType":"Legend Value Type","Length":"Length","LengthUnderLabels":"Length under Labels","Lighting":"Lighting","LimitRows":"Limit Rows","Linear":"Linear","LinearBarBorderBrush":"Linear Bar Border Brush","LinearBarBrush":"Linear Bar Brush","LinearBarEmptyBorderBrush":"Linear Bar Empty Border Brush","LinearBarEmptyBrush":"Linear Bar Empty Brush","LinearScaleBrush":"Linear Scale Brush","LineColor":"Line Color","LineColorNegative":"Line Color Negative","LineLength":"Line Length","LineLimit":"Line Limit","LineMarker":"Line Marker","LinesOfUnderline":"Lines of Underline","LineSpacing":"Line Spacing","LineStyle":"Line Style","LineWidth":"Line Width","Linked":"Linked","ListOfArguments":"List of Arguments","ListOfHyperlinks":"List of Hyperlinks","ListOfTags":"List of Tags","ListOfToolTips":"List of Tooltips","ListOfValues":"List of Values","ListOfValuesClose":"List of Values Close","ListOfValuesEnd":"List of Values End","ListOfValuesHigh":"List of Values High","ListOfValuesLow":"List of Values Low","ListOfValuesOpen":"List of Values Open","ListOfWeights":"List of Weights","Localizable":"Localizable","Location":"Location","Locked":"Locked","Logarithmic":"Logarithmic","LogarithmicScale":"Logarithmic Scale","Longitude":"Longitude","Low":"Low","LowValues":"Low Values","MajorInterval":"Major Interval","MapAfrica":"Africa","MapAsia":"Asia","MapCustom":"Custom","MapEurope":"Europe","MapID":"Map ID","MapNorthAmerica":"North America","MapOceania":"Oceania","MapPopularMaps":"Popular maps","Maps":"Maps","MapSouthAmerica":"South America","MapStyle":"Map Style","MapType":"Map Type","Margin":"Margin","Margins":"Margins","Marker":"Marker","MarkerAlignment":"Marker Alignment","MarkerAngle":"Marker Angle","MarkerBorder":"Marker Border","MarkerBrush":"Marker Brush","MarkerColor":"Marker Color","MarkerSize":"Marker Size","MarkerType":"Marker Type","MarkerVisible":"Marker Visible","MasterComponent":"Master Component","MasterKeyDataColumn":"Master Key Data Column","MatrixSize":"Matrix Size","MaxDate":"Max Date","MaxDropDownItems":"Max Drop Down Items","MaxHeight":"Max Height","Maximum":"Maximum","MaximumValue":"Maximum Value","MaxLength":"Max Length","MaxNumberOfLines":"Max Number of Lines","MaxSize":"Max Size","MaxValue":"Max Value","MaxWidth":"Max Width","MergeDuplicates":"Merge Duplicates","MergeHeaders":"Merge Headers","Mid":"Mid","MinDate":"Min Date","MinHeight":"Min Height","Minimum":"Minimum","MinimumFontSize":"Minimum Font Size","MinimumValue":"Minimum Value","MinorColor":"Minor Color","MinorCount":"Minor Count","MinorInterval":"Minor Interval","MinorLength":"Minor Length","MinorStyle":"Minor Style","MinorVisible":"Minor Visible","MinRowsInColumn":"Min Rows in Column","MinSize":"Min Size","MinValue":"Min Value","MinWidth":"Min Width","MirrorMargins":"Mirror Margins","Mode":"Mode","Module":"Module","Move":"Move","Multiline":"Multiline","MultipleFactor":"Multiple Factor","MultipleInitialization":"Multiple Initialization","Name":"Name","NameDataColumn":"Name Data Column","NameInSource":"Name in Source","NameMeter":"Name Meter","NameParent":"Parent Name","Namespaces":"Namespaces","NeedleBorderBrush":"Needle Border Brush","NeedleBorderWidth":"Needle Border Width","NeedleBrush":"Needle Brush","NeedleCapBorderBrush":"Needle Cap Border Brush","NeedleCapBrush":"Needle Cap Brush","Negative":"Negative","NegativeColor":"Negative Color","NegativeSeriesColors":"Negative Series Colors","NegativeTextBrush":"Negative Text Brush","NestedLevel":"Nested Level","NewColumnAfter":"New Column After","NewColumnBefore":"New Column Before","NewPageAfter":"New Page After","NewPageBefore":"New Page Before","NextPage":"Next Page","NoElements":"No Elements","NoIcon":"No Icon","NullText":"Null Text","NumberOfColumns":"Number of Columns","NumberOfCopies":"Number of Copies","NumberOfPass":"Number of Pass","NumberOfValues":"Number of Values","OddStyle":"Odd Style","Offset":"Offset","OffsetAngle":"Offset Angle","OnClick":"On Click","OnDataManipulation":"On Data Manipulation","OnHover":"On Hover","OnlyText":"Only Text","Opacity":"Opacity","OpenValues":"Open Values","Operation":"Operation","Options":"Options","Options3D":"Options 3D","Orientation":"Orientation","OthersText":"Others Text","Padding":"Padding","PageHeight":"Page Height","PageNumbers":"Page Numbers","PageWidth":"Page Width","Paper":"Paper","PaperSize":"Paper Size","PaperSourceOfFirstPage":"Paper Source of First Page","PaperSourceOfOtherPages":"Paper Source of Other Pages","Parameter":"Parameter","Parameters":"Parameters","ParametersDateFormat":"Parameters Date Format","ParametersOrientation":"Parameters Orientation","ParameterWidth":"Parameter Width","ParentColumns":"Parent Columns","ParentSource":"Parent Data Source","ParentValue":"Parent Value","ParetoSeriesColors":"Pareto Series Colors","PasswordChar":"Password Char","Path":"Path","PathData":"Path Data","PathSchema":"Path Schema","Pattern":"Pattern","PDFPreview":"PDF Preview","PenColor":"Pen Color","Placeholder":"Placeholder","Placement":"Placement","PlaceOnToolbox":"Place on Toolbox","PointAtCenter":"Point at Center","Position":"Position","Positive":"Positive","PositiveColor":"Positive Color","PreferredColumnWidth":"Preferred Column Width","PreferredRowHeight":"Preferred Row Height","PreventIntersection":"Prevent Intersection","PreviewMode":"Preview Mode","PreviewSettings":"Preview Settings","Printable":"Printable","PrintAtBottom":"Print at Bottom","PrinterName":"Printer Name","PrinterSettings":"Printer Settings","PrintHeadersFootersFromPreviousPage":"Print Headers and Footers from Previous Page","PrintIfDetailEmpty":"Print if Detail Empty","PrintIfEmpty":"Print if Empty","PrintIfParentDisabled":"Print if Parent Disabled","PrintOn":"Print on","PrintOnAllPages":"Print on All Pages","PrintOnEvenOddPages":"Print on Even Odd Pages","PrintOnPreviousPage":"Print on Previous Page","PrintTitleOnAllPages":"Print Title On All Pages","PrintVerticalBars":"Print Vertical Bars","ProcessAt":"Process at","ProcessAtEnd":"Process at End","ProcessingDuplicates":"Processing Duplicates","ProcessTilde":"Process Tilde","ProductHomePage":"Product Home Page","Property":"Property","Provider":"Provider","RadarStyle":"Radar Style","RadialBarBorderBrush":"Radial Bar Border Brush","RadialBarBrush":"Radial Bar Brush","RadialBarEmptyBorderBrush":"Radial Bar Empty Border Brush","RadialBarEmptyBrush":"Radial Bar Empty Brush","Radius":"Radius","RadiusMode":"Radius Mode","Range":"Range","RangeColorMode":"Range Color Mode","RangeFrom":"From","RangeMode":"Range Mode","RangeScrollEnabled":"Range Scroll Enabled","RangeTo":"To","RangeType":"Range Type","Ratio":"Ratio","RatioY":"Ratio Y","ReadOnly":"Read Only","RecentFonts":"Recent Fonts","ReconnectOnEachRow":"Reconnect on Each Row","ReferencedAssemblies":"Referenced Assemblies","Refresh":"Refresh","RefreshTime":"Refresh Time","Regular":"Regular","Relation":"Relation","RelationName":"Relation Name","Relations":"Relations","RelativeHeight":"Relative Height","RelativeWidth":"Relative Width","RemoveUnusedDataBeforeStart":"Remove Unused Data Before Start","RenderTo":"Render to","ReportAlias":"Report Alias","ReportAuthor":"Report Author","ReportCacheMode":"Report Cache Mode","ReportDescription":"Report Description","ReportIcon":"Report Icon","ReportImage":"Report Image","ReportName":"Report Name","ReportUnit":"Report Unit","RequestFromUser":"Request from User","RequestParameters":"Request Parameters","Required":"Required","ResetAllFilters":"Reset All Filters","ResetDataSource":"Reset Data Source","ResetPageNumber":"Reset Page Number","Resize":"Resize","Resource":"Resource","Resources":"Resources","Restrictions":"Restrictions","RetrieveOnlyUsedData":"Retrieve Only Used Data","ReturnValue":"Return Value","ReverseHor":"Reverse Horizontal","ReverseVert":"Reverse Vertical","Right":"Right","RightSide":"Right Side","RightToLeft":"Right to Left","Rotation":"Rotation","RotationLabels":"Rotation Labels","RotationMode":"Rotation Mode","Round":"Round","RoundValues":"Round Values","RowCount":"Row Count","RowHeaderBackColor":"Row Header Back Color","RowHeaderForeColor":"Row Header Fore Color","RowHeadersVisible":"Row Headers Visible","RowHeaderWidth":"Row Header Width","Rows":"Rows","Scale":"Scale","ScaleHor":"Scale Hor","ScriptLanguage":"Script Language","Second":"Second","SegmentPerHeight":"Segment per Height","SegmentPerWidth":"Segment per Width","SelectedBackColor":"Selected Back Color","SelectedCellBackColor":"Selected Cell Back Color","SelectedCellForeColor":"Selected Cell Fore Color","SelectedDataColor":"Selected Data Color","SelectedDataForeground":"Selected Data Foreground","SelectedForeColor":"Selected Fore Color","SelectedGlyphColor":"Selected Glyph Color","SelectedIndex":"Selected Index","SelectedItem":"Selected Item","SelectedKey":"Selected Key","SelectedValue":"Selected Value","Selection":"Selection","SelectionBackColor":"Selection Back Color","SelectionEnabled":"Selection Enabled","SelectionForeColor":"Selection Fore Color","SelectionMode":"Selection Mode","SelectStyle":"Select Style","SendType":"Send Type","SeparatorColor":"Separator Color","SerialNumber":"Serial Number","Series":"Series","SeriesBorderThickness":"Series Border Thickness","SeriesColors":"Series Colors","SeriesCornerRadius":"Series Corner Radius","SeriesLabels":"Series Labels","SeriesLabelsBorderColor":"Series Labels Border Color","SeriesLabelsBrush":"Series Labels Brush","SeriesLabelsColor":"Series Labels Color","SeriesLabelsLineColor":"Series Labels Line Color","SeriesLighting":"Series Lighting","SeriesShowBorder":"Series Show Border","SeriesShowShadow":"Series Show Shadow","SeriesTitle":"Series Title","Shadow":"Shadow","ShadowBrush":"Shadow Brush","ShadowColor":"Shadow Color","ShadowSize":"Shadow Size","ShapeType":"Shape Type","Shift":"Shift","ShiftMode":"Shift Mode","ShortName":"Short Name","ShortValue":"Short Value","ShowAllValue":"Show All Value","ShowBehind":"Show Behind","ShowBubble":"Show Bubble","ShowDialog":"Show Dialog","ShowEdgeValues":"Show Edge Values","ShowHyperlink":"Show Hyperlink","ShowImageBehind":"Show Image Behind","ShowInLegend":"Show in Legend","ShowInnerPoints":"Show Inner Points","ShowInPercent":"Show in Percent","ShowLabel":"Show Label","ShowLabels":"Show Labels","ShowLabelText":"Show Label Text","ShowLegend":"Show Legend","ShowMarker":"Show Marker","ShowMeanMarkers":"Show Mean Markers","ShowNulls":"Show Nulls","ShowOthers":"Show Others","ShowPercents":"Show Percents","ShowPlacemark":"Show Placemark","ShowQuietZoneIndicator":"Show Quiet Zone Indicator","ShowQuietZones":"Show Quiet Zones","ShowScrollBar":"Show Scroll Bar","ShowSelectAll":"Show Select All","ShowSeriesLabels":"Show Series Labels","ShowShadow":"Show Shadow","ShowTotal":"Show Total","ShowTotalSummary":"Show Total Summary","ShowUpDown":"Show Up Down","ShowValue":"Show Value","ShowXAxis":"Show X Axis","ShowYAxis":"Show Y Axis","ShowZeros":"Show Zeros","ShrinkFontToFit":"Shrink Font to Fit","ShrinkFontToFitMinimumSize":"Shrink Font to Fit Minimum Size","Side":"Side","SideBySide":"Side-by-Side","Sides":"Sides","SignatureType":"Type","Simple":"Simple","Size":"Size","SizeMode":"Size Mode","Skin":"Skin","SkipFirst":"Skip First","SkipIndices":"Skip Indices","SkipIndicesObj":"Skip Indices","SkipMajorValues":"Skip Major Values","SkipValues":"Skip Values","SkipValuesObj":"Skip Values","Smoothing":"Smoothing","Sort":"Sort","SortBy":"Sort by","SortDirection":"Sort Direction","Sorted":"Sorted","SortingColumn":"Sorting Column","SortingEnabled":"Sorting Enabled","SortLetters":"A-Z","SortType":"Sort Type","Space":"Space","SpaceRatio":"Space Ratio","Spacing":"Spacing","SqlCommand":"Sql Command","StartAngle":"Start Angle","StartCap":"Start Cap","StartColor":"Start Color","StartFromZero":"Start From Zero","StartMode":"Start Mode","StartNewPage":"Start New Page","StartNewPageIfLessThan":"Start New Page if Less Than","StartPosition":"Start Position","StartValue":"Start Value","StartWidth":"Start Width","State":"State","Step":"Step","Stop":"Stop","StopBeforePage":"Stop Before Page","StopBeforePrint":"Stop Before Print","StoreImagesInResources":"Store Images in Resources","StreetAddress":"Street Address","Stretch":"Stretch","StretchToPrintArea":"Stretch to Print Area","Strikeout":"Strikeout","StripBrush":"Strip Brush","Strips":"Strips","Stroke":"Stroke","StructuredAppendPosition":"Structured Append Position","StructuredAppendTotal":"Structured Append Total","Style":"Style","StyleColors":"Style Colors","Styles":"Styles","SubmissionMessage":"Submission Message","SubReportPage":"Sub Report","Summaries":"Summaries","Summary":"Summary","SummaryAlignment":"Summary Alignment","SummaryExpression":"Summary Expression","SummarySortDirection":"Summary Sort Direction","SummaryType":"Summary Type","SummaryValues":"Summary Values","SupplementCode":"Supplement Code","SupplementType":"Supplement Type","SweepAngle":"Sweep Angle","SystemFonts":"System Fonts","SystemVariable":"System Variable","SystemVariables":"System Variables","Table":"Table","Tag":"Tag","TagDataColumn":"Tag Data Column","TagValue":"Tag Value","Target":"Target","TargetColor":"Target Color","TargetIcon":"Target Icon","TargetMode":"Target Mode","TargetSettings":"Target","Tension":"Tension","Text":"Text","TextAfter":"Text After","TextAlign":"Text Align","TextAlignment":"Text Alignment","TextBefore":"Text Before","TextBrush":"Text Brush","TextColor":"Text Color","TextFormat":"Text Format","TextOnly":"Text Only","TextOptions":"Text Options","TextQuality":"Text Quality","Third":"Third","TickLabelMajorFont":"Tick Label Major Font","TickLabelMajorTextBrush":"Tick Label Major Text Brush","TickLabelMinorFont":"Tick Label Minor Font","TickLabelMinorTextBrush":"Tick Label Minor Text Brush","TickMarkMajorBorder":"Tick Mark Major Border","TickMarkMajorBorderWidth":"Tick Mark Major Border Width","TickMarkMajorBrush":"Tick Mark Major Brush","TickMarkMinorBorder":"Tick Mark Minor Border","TickMarkMinorBorderWidth":"Tick Mark Minor Border Width","TickMarkMinorBrush":"Tick Mark Minor Brush","Ticks":"Ticks","Title":"Title","TitleBeforeHeader":"Title Before Header","TitleColor":"Title Color","TitleDirection":"TitleDirection","TitleFont":"Title Font","TitleVisible":"Title Visible","To":"To","Today":"Today","ToolTip":"Tool Tip","ToolTipBorder":"Tool Tip Border","ToolTipBrush":"Tool Tip Brush","ToolTipCornerRadius":"Tool Tip Corner Radius","ToolTipDataColumn":"Tool Tip Data Column","ToolTipTextBrush":"Tool Tip Text Brush","Top":"Top","TopLeft":"Top-Left","Topmost":"Topmost","TopmostLine":"Topmost Line","TopN":"Top N","TopRight":"Top-Right","TopSide":"Top Side","Total":"Total","TotalCellColumnBackColor":"Total Cell Column Back Color","TotalCellColumnForeColor":"Total Cell Column Fore Color","TotalCellRowBackColor":"Total Cell Row Back Color","TotalCellRowForeColor":"Total Cell Row Fore Color","TotalLabel":"Total Label","Totals":"Totals","TrackColor":"Track Color","TransparentColor":"Transparent Color","TrendLine":"Trend Line","TrendLineColor":"Trend Line Color","TrendLines":"Trend Lines","TrendLineShowShadow":"Trend Line Show Shadow","TrimExcessData":"Trim Excess Data","Trimming":"Trimming","Type":"Type","TypeName":"Type Name","Types":"Types","UncheckedIcon":"Unchecked Icon","Underline":"Underline","UndoLimit":"Undo Limit","Unit":"Unit","UnitAlignment":"Unit Alignment","UnlimitedBreakable":"Unlimited Breakable","UnlimitedHeight":"Unlimited Height","UnlimitedWidth":"Unlimited Width","UpperMarks":"Upper Marks","URL":"URL","UseAliases":"Use Aliases","UseExternalReport":"Use External Report","UseParentStyles":"Use Parent Styles","UseRangeColor":"Use Range Color","UseRectangularSymbols":"Use Rectangular Symbols","UseSeriesColor":"Use Series Color","UseStyleOfSummaryInColumnTotal":"Use Style of Summary in Column Total","UseStyleOfSummaryInRowTotal":"Use Style of Summary in Row Total","UseValuesFromTheSpecifiedRange":"Use Values From The Specified Range","Value":"Value","ValueClose":"Value Close","ValueDataColumn":"Value Data Column","ValueDataColumnClose":"Value Data Column Close","ValueDataColumnEnd":"Value Data Column End","ValueDataColumnHigh":"Value Data Column High","ValueDataColumnLow":"Value Data Column Low","ValueDataColumnOpen":"Value Data Column Open","ValueEnd":"Value End","ValueFormat":"Value Format","ValueHigh":"Value High","ValueLow":"Value Low","ValueMeter":"Value Meter","ValueOpen":"Value Open","Values":"Values","ValueType":"Value Type","ValueTypeSeparator":"Value Type Separator","Variable":"Variable","Variables":"Variables","Variation":"Variation","Version":"Version","VertAlignment":"Vertical Alignment","VertSpacing":"Vertical Spacing","ViewMode":"View Mode","Visible":"Visible","VisualStates":"Visual States","Watermark":"Watermark","Weight":"Weight","WeightDataColumn":"Weight Data Column","Weights":"Weights","Width":"Width","WindowState":"Window State","WordWrap":"Word Wrap","Wrap":"Wrap","WrapGap":"WrapGap","WrapLine":"Wrap Line","XAxis":"X Axis","XTopAxis":"X Top Axis","YAxis":"Y Axis","YRightAxis":"Y Right Axis","ZeroColor":"Zero Color","Zoom":"Zoom"},"PropertySystemColors":{"ActiveBorder":"Active Border","ActiveCaption":"Active Caption","ActiveCaptionText":"Active Caption Text","AppWorkspace":"App Workspace","Control":"Control","ControlDark":"Control Dark","ControlDarkDark":"Control Dark Dark","ControlLight":"Control Light","ControlLightLight":"Control Light Light","ControlText":"Control Text","Desktop":"Desktop","GrayText":"Gray Text","Highlight":"Highlight","HighlightText":"Highlight Text","HotTrack":"Hot Track","InactiveBorder":"Inactive Border","InactiveCaption":"Inactive Caption","InactiveCaptionText":"Inactive Caption Text","Info":"Info","InfoText":"Info Text","Menu":"Menu","MenuText":"Menu Text","ScrollBar":"Scroll Bar","Window":"Window","WindowFrame":"Window Frame","WindowText":"Window Text"},"QueryBuilder":{"AddObject":"Add Object","AddSubQuery":"Add Derived Table","AllObjects":"(All objects)","BadFromObjectExpression":"Invalid FROM object expression!","BadObjectName":"Invalid object name!","BadSelectStatement":"Invalid SELECT statement!","Collections":"Collections","CreateLinksFromForeignKeys":"Create Links from Foreign Keys","CriteriaAlias":"Alias","CriteriaCriteria":"Criteria","CriteriaExpression":"Expression","CriteriaGroupBy":"Group By","CriteriaOr":"Or...","CriteriaOutput":"Output","CriteriaSortOrder":"Sort Order","CriteriaSortType":"Sort Type","Database":"Database","DataSourceProperties":"Data Source Properties","DialectDontSupportDatabases":"The server does not support queries with objects from different databases.","DialectDontSupportSchemas":"The server does not support schemas.","DialectDontSupportUnions":"This server does not support unions.","DialectDontSupportUnionsBrackets":"This server does not support brackets in unions.","DialectDontSupportUnionsBracketsInSubQuery":"This server doesn\'t support brackets in unions in subqueries.","DialectDontSupportUnionsInSubQueries":"This server does not support unions in subqueries.","Edit":"Edit","EncloseWithBrackets":"Enclose with brackets","Expressions":"Expressions","InsertEmptyItem":"Insert Empty Item","JoinExpression":"Join Expression","LabelAlias":"Alias:","LabelFilterObjectsBySchemaName":"Filter Objects by Schema Name:","LabelJoinExpression":"Join Expression:","LabelLeftColumn":"Left Column:","LabelLeftObject":"Left Object:","LabelObject":"Object:","LabelRightColumn":"Right Column:","LabelRightObject":"Right Object:","LinkProperties":"Link Properties","MetadataProviderCantExecSQL":"Used metadata provider cannot execute SQL queries.","MetaProviderCantLoadMetadata":"Used metadata provider cannot automatically load metadata.","MetaProviderCantLoadMetadataForDatabase":"Used metadata provider cannot automatically load metadata for database: {0}","MoveDown":"Move Down","MoveUp":"Move Up","NewUnionSubQuery":"New union sub-query","NoConnectionObject":"No connection object (property {0} not assigned).","NoTransactionObject":"No transaction object (property {0} not assigned).","Objects":"Objects","ProcedureParameters":"Procedure Parameters","Procedures":"Procedures","qnSaveChanges":"Do you want to save changes of query?","Query":"Query","QueryBuilder":"Query Builder","QueryParameters":"Query Parameters","QueryProperties":"Query Properties","Remove":"Remove","RemoveBrackets":"Remove brackets","RunQueryBuilder":"Run Query Builder","SelectAllFromLeft":"Select All from Left","SelectAllFromRight":"Select All from Right","SwitchToDerivedTable":"Switch to Derived Table","Tables":"Tables","UnexpectedTokenAt":"Unexpected token \\"{0}\\" at line {1}, pos {2}!","Unions":"Unions","UnionSubMenu":"Union","ViewQuery":"View Query","Views":"Views"},"Questions":{"qnConfiguration":"Please choose the type of configuration for the properties panel. The type of the selected configuration depends on the number of visible properties and their complexity for the developer of reports. You can always change the configuration type from the context menu of the properties panel.","qnCopyCategory":"Do you want to copy all variables of this category?","qnDictionaryNew":"Do you want to create new Dictionary?","qnLanguageNew":"You have changed the language of the report. This will lead to the new report code generation. Are you certain you want to save the new language?","qnPageDelete":"Do you want to delete page?","qnRemove":"Do you want to remove?","qnRemoveService":"Do you want to remove Service?","qnRemoveServiceCategory":"Do you want to remove Category?","qnRemoveUnused":"Do you want to remove Unused?","qnReplace":"Do you want to replace the existing item {0}?","qnRestoreDefault":"Restore defaults?","qnSaveChanges":"Save changes in {0}?","qnSaveChangesToPreviewPage":"Do you want to save page changes?","qnSynchronize":"Synchronized contents of the Data Store and contents of the Dictionary?","qnSynchronizeServices":"Synchronized services?"},"RecentFiles":{"AddAPlace":"Add a Place","AddAPlaceDesc":"You can add locations to make it easier to save Reports to the cloud.","ChangeFileType":"Change file type","ChooseALocation":"Choose a Location","ClearUnpinnedItems":"Clear unpinned items","CopyPathToClipboard":"Copy path to clipboard","DateModified":"Date modified","Documents":"Documents","DoYouWantTo":"Do you want to:","LastWeek":"Last Week","LocalDisk":"Local Disk ({0})","MessageInvalidFolderName":"Invalid folder name.","MessageThatNameAlreadyExists":"That name already exists. Please use a different name.","MoreLocations":"More Locations →","Older":"Older","OtherLocations":"Other locations","Personal":"Personal","Pinned":"Pinned","PinToList":"Pin to list","PinToRecentList":"Pin to Recent list","RemoveFromList":"Remove from list","ReplaceExistingFile":"Replace existing file.","SaveChangesWithADifferentName":"Save changes with a different name.","SaveThisFile":"Save this file","SelectToNavigateUpOneLevel":"Select to navigate up one level","SetAsDefaultLocation":"Set as Default Location","ThisPC":"This PC","UnpinFromList":"Unpin from list"},"Report":{"ActiveRelation":"Active Relation","Address":"Address","Alphabetical":"Alphabetical","Bands":"Bands","Basic":"Basic","BasicConfiguration":"Minimal number of object properties, which are necessary for rendering the basic report types.","BusinessObjects":"Business Objects","Categorized":"Categorized","Charts":"Charts","Checking":"Checking...","ClickForMoreDetails":"Click for More Details","CollapseAll":"Collapse All","Collection":"Collection","CompilingReport":"Compiling Report","Complete":"Complete","Components":"Components","ConnectingToData":"Connecting to Data","CopyOf":"Copy","CreateNewReportPageForm":"Create a new report, add a page, add a form","CreatingReport":"Creating Report","CrossBands":"Cross","Dialogs":"Dialogs","EditStyles":"Edit Styles","Enhancements":"Enhancements","EnterDataManually":"Enter data manually","Errors":"Errors","EventsTab":"Events Tab","ExpandAll":"Expand All","FilterAnd":"And","FilterOr":"Or","FinishingReport":"Finishing Report","FirstPass":"First Pass","FixedBugs":"Fixed Bugs","FromCurrentState":"From Current State","FromDefaultState":"From Default State","Gallery":"Gallery","GenerateNewCode":"Generate New Code","History":"History","Infographics":"Infographics","InfoMessage":"{0} - {1} found.","InformationMessages":"Information Messages","LabelAlias":"Alias:","LabelAuthor":"Author:","LabelBackground":"Background:","LabelCategory":"Category:","LabelCentimeters":"Centimeters:","LabelCollectionName":"Collection Name:","LabelColor":"Color:","LabelCountData":"Count Data:","LabelDataBand":"DataBand:","LabelDataColumn":"Data Column:","LabelDefaultValue":"Default Value:","LabelExpression":"Expression:","LabelFactorLevel":"Nested Factor:","LabelFontName":"Font Name:","LabelFunction":"Function:","LabelHundredthsOfInch":"Hundredths of Inch:","LabelInches":"Inches:","LabelMillimeters":"Millimeters:","LabelName":"Name:","LabelNameInSource":"Name in Source:","LabelNestedLevel":"Nested Level:","LabelPassword":"Password:","LabelPixels":"Pixels:","LabelQueryTimeout":"Query Timeout:","LabelSystemVariable":"System Variable:","LabelTableOfContentsHint":"Please, check the components which should form the table of contents. One component is equal to one heading level.","LabelTotals":"Totals","LabelType":"Type:","LabelUserName":"User Name:","LabelValue":"Value:","LoadingReport":"Loading Report","nameAssembly":"Assembly","NewFeatures":"New Features","No":"No","NoFixes":"There are no fixes or updates for this version!","NoIssues":"No Issues","NoNewVersions":"There are no new versions available!","NotAssigned":"Not Assigned","Null":"Null","Obsoleted":"Obsoleted","Office2010Back":"Back","PageNofM":"Page {0} of {1}","PreparingReport":"Preparing Report","Professional":"Professional","ProfessionalConfiguration":"All object properties.","PropertiesTab":"Properties Tab","RangeAll":"All","RangeCurrentPage":"Current Page","RangeInfo":"Enter page number and/or pages ranges separated by commas. For example: 1, 3, 5-12","RangePage":"Page Range","RangePages":"Pages:","ReportChecker":"Checker","ReportRenderingMessages":"Report Rendering Messages","RestartDesigner":"You need to restart the report designer","SaveReportPagesOrFormsFromReport":"Save the report, pages or forms","SavingReport":"Saving Report","SecondPass":"Second Pass","Shapes":"Shapes","ShowOnParametersPanel":"Show on Parameters Panel","Standard":"Standard","StandardConfiguration":"Main object properties except rarely used ones.","StiEmptyBrush":"Empty","StiGlareBrush":"Glare","StiGlassBrush":"Glass","StiGradientBrush":"Gradient","StiHatchBrush":"Hatch","StiSolidBrush":"Solid","StyleBad":"Bad","StyleGood":"Good","StyleNeutral":"Neutral","StyleNormal":"Normal","StyleNote":"Note","StyleWarning":"Warning","UseDataFields":"Use Data Fields","VisualChecked":"Checked","VisualDefault":"Default","VisualDisabled":"Disabled","VisualHover":"Hover","VisualPressed":"Pressed","Warnings":"Warnings","WhatsNewInVersion":"What\'s New in {0}","When":"when {0} {1}","WhenAnd":"when {0} {1} and","WhenValueIs":"when value is"},"ReportInfo":{"CheckIssuesAdditionalDescription":"Check for errors and find inaccuracies.","EncryptWithPassword":"Encrypt with Password","EncryptWithPasswordAdditionalDescription":"Set the password to prevent unauthorized working with the report.","EncryptWithPasswordDescription":"Protect Report","Info":"Info","ReportOptions":"Report Options","ReportOptionsAdditionalDescription":"Setup the basic information and parameters in the report."},"ReportOpen":{"Browse":"Browse","Import":"Import"},"Scheduler":{"ActionRunReport":"Run Report","AdvancedSettings":"Advanced Settings","CheckBoxOverwriteIfExists":"Overwrite If Exists","DayAll":"All","DayDayX":"Day {0}","DayLast":"Last","DayNone":"None","DaysOfWeekAll":"All","DaysOfWeekNone":"None","DelayTaskForUpToRandomDelay":"Delay task for up to (random delay)","EditScheduler":"Edit Scheduler","EnableSSL":"Enable SSL","Expire":"Expire","ForADurationOf":"for a duration of","GetFolder":"Get Folder","GroupBoxFiles":"Files","Host":"Host","Info":"Windows Task Scheduler is used to run schedulers.","LabelDaysOfWeek":"Days of Week","LabelMessage":"Message","LabelResultName":"Result Name","LabelRunAtDay":"Run at Day","LabelRunAtMonth":"Run at Month","LabelRunAtTime":"Run at Time","LabelRunEvery":"Run Every","LabelSubject":"Subject","LabelTo":"To","Logs":"Logs","MessageInvalidName":"Task names may not include any characters which are invalid for file names.","MessageInvalidTaskName":"Task names ending with a period followed by three or fewer characters cannot be retrieved due to a bug in the native library.","MessagePropertyNotSet":"\'{0}\' not set!","MonthAll":"All","MonthNone":"None","NewAction":"New Action","NewScheduler":"New Scheduler","NoLogs":"No Logs","NoSchedulers":"No Schedulers","NumberOfDayAll":"All","NumberOfDayFirst":"First","NumberOfDayFourth":"Fourth","NumberOfDayLast":"Last","NumberOfDayNone":"None","NumberOfDaySecond":"Second","NumberOfDayThird":"Third","OpenWindowsTaskScheduler":"Open Windows Task Scheduler","PleaseSelectSchedulerType":"Please select a scheduler type","RadioButtonDay":"Day","RadioButtonOn":"On","RepeatTaskEvery":"Repeat task every","Schedule":"Schedule","Scheduler":"Scheduler","Schedulers":"Schedulers","SenderEmail":"Sender Email","SmtpSettings":"Smtp Settings","StopAllRunningTasksAtEndOfRepetitionDuration":"Stop all running tasks at end of repetition duration","StopTasksIfItRunsLongerThan":"Stop tasks if it runs longer than","TextDragDropDestinationHere":"Drag &amp; Drop the Destination Folder Here","TextDragDropReportHere":"Drag &amp; Drop the Report Here","TextPressPlusIconAddNewAction":"Click the icon plus to add a new action!","ToolTipSetParameters":"Defining Report Parameters","WizardDaily":"Daily","WizardDailyDescription":"Once a day, at a specified time.","WizardHourly":"Hourly","WizardHourlyDescription":"Once an hour.","WizardMonthly":"Monthly","WizardMonthlyDescription":"Monthly, on selected days of the week or days of the month, at a specified time.","WizardOnce":"Once","WizardOnceDescription":"Run the scheduler once at any time.","WizardWeekly":"Weekly","WizardWeeklyDescription":"On the selected days of the week, at a specified time."},"Services":{"categoryContextTools":"Context Tools","categoryDesigner":"Designer","categoryDictionary":"Dictionary","categoryExport":"Exports","categoryLanguages":"Languages","categoryPanels":"Panels","categoryRender":"Render","categoryShapes":"Shapes","categorySL":"Save / Load","categorySystem":"System","categoryTextFormat":"Text Format"},"Shapes":{"Arrow":"Arrow","BasicShapes":"Basic Shapes","BentArrow":"Bent Arrow","BlockArrows":"Block Arrows","Chevron":"Chevron","ComplexArrow":"Complex Arrow","DiagonalDownLine":"Diagonal Line Down","DiagonalUpLine":"Diagonal Line Up","Division":"Division","Equal":"Equal","EquationShapes":"Equation Shapes","Flowchart":"Flowchart","FlowchartCard":"Flowchart: Card","FlowchartCollate":"Flowchart: Collate","FlowchartDecision":"Flowchart: Decision","FlowchartManualInput":"Flowchart: Manual Input","FlowchartOffPageConnector":"Flowchart: Off Page Connector","FlowchartPreparation":"Flowchart: Preparation","FlowchartSort":"Flowchart: Sort","Frame":"Frame","HorizontalLine":"Horizontal Line","InsertShapes":"Insert Shapes","LeftAndRightLine":"Left and Right Line","Lines":"Lines","Minus":"Minus","Multiply":"Multiply","Octagon":"Octagon","Oval":"Oval","Parallelogram":"Parallelogram","Plus":"Plus","Rectangle":"Rectangle","Rectangles":"Rectangles","RegularPentagon":"Regular: Pentagon","RoundedRectangle":"Rounded Rectangle","ServiceCategory":"Shapes","ShapeStyles":"Shape Styles","SnipDiagonalSideCornerRectangle":"Snip Diagonal Side Corner Rectangle","SnipSameSideCornerRectangle":"Snip Same Side Corner Rectangle","TopAndBottomLine":"Top and Bottom Line","Trapezoid":"Trapezoid","Triangle":"Triangle","VerticalLine":"Vertical Line"},"Signature":{"DigitalSignatureEmptyWatermark":"Place for digital signature in PDF Viewer","InsertImage":"Insert Image","InsertText":"Insert Text","LoadSignature":"Load signature","NoSavedItems":"No saved items","SaveSignature":"Save signature","SignatureSavedSuccessfully":"Signature saved successfully.","UseBrush":"Use Brush"},"SystemVariables":{"Column":"Returns the current column number (starts from 1).","GroupLine":"Returns the current group line number (starts from 1).","IsFirstPage":"Returns true, if, in the current moment, the first page of a report is printed.","IsFirstPageThrough":"Returns true, if, in the current moment, the first report page is printed. When calculating the IsFirstPageThrough, all ResetPageNumber properties are ignored and numbering starts from the beginning of report. For correct calculation of a variable it is required to execute two passes.","IsLastPage":"Returns true, if, in the current moment, the last page of a report is printed. For correct calculation of a variable it is required to execute two passes.","IsLastPageThrough":"Returns true, if, in the current moment, the last page of a report is printed. When calculating the IsLastPageThrough, all properties ResetPageNumber are ignored and numbering starts from the beginning of report. For correct calculation of a variable it is required to execute two passes.","Line":"Returns the current line number (starts from 1).","LineABC":"Returns the alphabetical analogue of the current line number.","LineRoman":"Returns the current line number in Roman numerals.","LineThrough":"Returns the current line number (starts from 1). When calculating the number, all groupings are ignored and numbering starts from the beginning of printing.","PageCopyNumber":"Return a number of a current copy of a page (starts from 1).","PageNofM":"Returns a localized string, showing \\"Page N of M\\" where N is the current page number and M is the TotalPageCount of a report.","PageNofMThrough":"Returns a localized string, showing \\"Page N of M\\" where N is the current page number and M is the TotalPageCount of a report. When calculating the PageNofMThrough, all properties ResetPageNumber are ignored and numbering starts from the beginning of a report.","PageNumber":"Returns the current page number (starts from 1).","PageNumberThrough":"Returns the current page number (starts from 1). When calculating the PageNumberThrough, all properties ResetPageNumber are ignored and numbering starts from the beginning of a report.","ReportAlias":"Returns the report alias. You can change the ReportAlias with help of the ReportAlias property of a report.","ReportAuthor":"Returns the report author. You can change ReportAuthor with help of the ReportAuthor property of a report.","ReportChanged":"The Date when a report was changed.","ReportCreated":"The Date when a report was created.","ReportDescription":"Returns the report description. You can change the ReportName with help of the ReportDescription property of a report.","ReportName":"Returns the report name. You can change the ReportName with help of the ReportName property of a report.","Time":"Returns the current time.","Today":"Returns the current date.","TotalPageCount":"Returns the number of pages in a report.","TotalPageCountThrough":"Returns the number of pages in a report. When calculating the TotalPageCountThrough, all properties ResetPageNumber are ignored and numbering starts from the beginning of report."},"TableRibbon":{"BuiltIn":"Built-In","Delete":"Delete","DeleteColumns":"Delete Columns","DeleteRows":"Delete Rows","DeleteTable":"Delete Table","DistributeColumns":"Distribute Columns","DistributeRows":"Distribute Rows","InsertAbove":"Insert Above","InsertBelow":"Insert Below","InsertLeft":"Insert Left","InsertRight":"Insert Right","PlainTables":"Plain Tables","ribbonBarRowsColumns":"Rows and Columns","ribbonBarTable":"Table","ribbonBarTableStyles":"Table Styles","Select":"Select","SelectColumn":"Select Column","SelectRow":"Select Row","SelectTable":"Select Table"},"Toolbars":{"Align":"Align","AlignBottom":"Align Bottom","AlignCenter":"Align Center","AlignLeft":"Align Left","AlignMiddle":"Align Middle","AlignRight":"Align Right","AlignToGrid":"Align to Grid","AlignTop":"Align Top","AlignWidth":"Justify","BringToFront":"Bring to Front","CenterHorizontally":"Center Horizontally","CenterVertically":"Center Vertically","Conditions":"Conditions","FontGrow":"Grow Font","FontName":"Font Name","FontShrink":"Shrink Font","FontSize":"Font Size","FontStyleBold":"Font Style Bold","FontStyleItalic":"Font Style Italic","FontStyleUnderline":"Font Style Underline","Link":"Link","Lock":"Lock","MakeHorizontalSpacingEqual":"Make Horizontal Spacing Equal","MakeSameHeight":"Make Same Height as {0}","MakeSameSize":"Make Same Size as {0}","MakeSameWidth":"Make Same Width as {0}","MakeVerticalSpacingEqual":"Make Vertical Spacing Equal","MoveBackward":"Move Backward","MoveForward":"Move Forward","Order":"Order","SendToBack":"Send to Back","Size":"Size","StyleDesigner":"Style Designer","Styles":"List of the styles","TabHome":"Home","TabLayout":"Layout","TabPage":"Page","TabView":"View","TextBrush":"Text Brush","ToolbarAlignment":"Alignment","ToolbarArrange":"Arrange","ToolbarBorders":"Borders","ToolbarClipboard":"Clipboard","ToolbarDockStyle":"Dock Style","ToolbarFont":"Font","ToolbarFormatting":"Formatting","ToolbarLayout":"Layout","ToolbarPageSetup":"Page Setup","ToolbarStandard":"Standard","ToolbarStyle":"Style","ToolbarTextFormat":"Text Format","ToolbarTools":"Tools","ToolbarViewOptions":"View Options","ToolbarWatermarkImage":"Watermark Image","ToolbarWatermarkText":"Watermark Text"},"Toolbox":{"Create":"Creation components","Hand":"Hand","Select":"Select","Style":"Copy Style","TextEditor":"Text Editor","title":"Toolbox"},"WelcomeScreen":{"AllDownloadsWillCanceled":"Are you sure you want to close this window? All downloads will be canceled.","Description":"We have selected for you reports that we think are the best for a quick start.","GetStarted":"Get Started","GetStartedWithDashboards":"Get Started with Dashboards","GetStartedWithReports":"Get Started with Reports","MoreReports":"More Reports","ShowNextTime":"Show \'{0}\' next time","Title":"Welcome to Stimulsoft Demo"},"Wizards":{"BlankDashboard":"Blank Dashboard","BlankForm":"Blank Form","BlankReport":"Blank Report","BlankScreen":"Blank Screen","ButtonBack":"&lt; &amp;Back","ButtonCancel":"Cancel","ButtonFinish":"&amp;Finish","ButtonNext":"&amp;Next &gt;","ColumnsOrder":"Columns Order","Company":"Company","Custom":"Custom","DataRelation":"Relation","DataSource":"Data Source","DataSources":"Data Sources","DefaultThemes":"Default Themes","Filters":"Filters","FromReportTemplate":"From Report Template","GetData":"Get Data","groupCreateNewDashboard":"Create a New Dashboard","groupCreateNewPageOrForm":"Create a New Page or Form","groupCreateNewReport":"Create a New Report","Groups":"Groups","groupTemplates":"Templates","groupWizards":"Wizards","infoColumnsOrder":"Arrange columns in the necessary order.","infoCompanyInfo":"Enter your company information.","infoDataSource":"Select one Data Source from available.","infoDataSources":"Select Data Sources from available. The first selected one will be the Master data source.","infoFilters":"Filter Data for your report","infoGroups":"Select columns on which necessary to group.","infoLabelSettings":"Set the settings of labels.","infoLanguages":"Select the report culture.","infoLayout":"Specify layout of report.","infoRelation":"Select one Data Relation from available.","infoSelectColumns":"Select columns from which the information will be displayed.","infoSelectTemplate":"Choose the appropriate template for your needs.","infoSort":"Set the sorting of data. You can sort immediately on multiple columns.","infoThemes":"Select theme for your report.","infoTotals":"Add summary information to your report.","LabelDirection":"Direction:","LabelHeight":"Height:","LabelHorizontalGap":"Horizontal Gap:","LabelLabelType":"Label Type:","LabelLeftMargin":"Left Margin:","LabelNumberOfColumns":"Number of Columns:","LabelNumberOfRows":"Number of Rows:","LabelPageHeight":"Page Height:","LabelPageWidth":"Page Width:","LabelReport":"Label Report","LabelSettings":"Label Settings","LabelSize":"Size:","LabelTopMargin":"Top Margin:","LabelVerticalGap":"Vertical Gap:","LabelWidth":"Width:","Layout":"Layout","Mapping":"Mapping","MarkAll":"Mark &amp;All","MasterDetailReport":"Master-Detail Report","NoFunction":"[None]","OpenExistingReport":"Open Existing File","OpenFrom":"Open from {0}","Preview":"Preview","Reset":"&amp;Reset","Results":"Results","RunWizard":"Run Wizard","SelectColumns":"Select Columns","SelectTemplate":"Template","Sort":"Sort","StandardReport":"Standard Report","Themes":"Themes","title":"New Report","Totals":"Totals","UseDemoData":"Use Demo Data","UsingReportWizard":"Using Report Wizard","YouHaveNotOpenedAnyReportRecently":"You haven\'t opened any report recently. To browse for a report, start by clicking on Open Existing File."},"Zoom":{"EmptyValue":"Empty Value","MultiplePages":"Multiple Pages","OnePage":"One Page","PageHeight":"Page Height","PageWidth":"Page Width","TwoPages":"Two Pages","ZoomTo100":"Zoom to 100%"}}}');
StiLocalizationService.needToRefresh = new Subject();
StiLocalizationService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiLocalizationService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
StiLocalizationService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiLocalizationService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiLocalizationService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });
//# sourceMappingURL=data:application/json;base64,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