import { Injectable } from "@angular/core";
import StiRectangleGeometryLayout from "../computed/StiRectangleGeometryLayout";
import { StiAddressElement } from "../elements/StiAddressElement";
import { StiBarcodeElement } from "../elements/StiBarcodeElement";
import { StiButtonElement } from "../elements/StiButtonElement";
import { StiCheckBoxElement } from "../elements/StiCheckBoxElement";
import { StiComboBoxElement } from "../elements/StiComboBoxElement";
import { StiDateTimeBoxElement } from "../elements/StiDateTimeBoxElement";
import { StiForm } from "../elements/StiForm";
import { StiFormPageElement } from "../elements/StiFormPageElement";
import { StiImageElement } from "../elements/StiImageElement";
import { StiLabelElement } from "../elements/StiLabelElement";
import StiLineElement from "../elements/StiLineElement";
import { StiListBoxElement } from "../elements/StiListBoxElement";
import { StiMultipleSelectionElement } from "../elements/StiMultipleSelectionElement";
import { StiNumberBoxElement } from "../elements/StiNumberBoxElement";
import { StiPanelElement } from "../elements/StiPanelElement";
import { StiPDFSignatureElement } from "../elements/StiPDFSignatureElement";
import { StiSignatureElement } from "../elements/StiSignatureElement";
import { StiSingleSelectionElement } from "../elements/StiSingleSelectionElement";
import { StiTableElement } from "../elements/StiTableElement";
import { StiTextBoxElement } from "../elements/StiTextBoxElement";
import { StiTextElement } from "../elements/StiTextElement";
import { StiLabelColumnItem } from "../elements/table/columns/StiLabelColumnItem";
import { StiNumberBoxColumnItem } from "../elements/table/columns/StiNumberBoxColumnItem";
import { StiTotalsFieldItem } from "../elements/table/StiTotalsFieldItem";
import { Enum } from "../system/Enum";
import { StiBarcodeType } from "../system/enums";
import Guid from "../system/Guid";
import StiJson from "../system/StiJson";
import { StiLocalizationService } from "./sti-localization.service";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./sti-localization.service";
export class StiHelperService {
    constructor(model, render, loc, zone) {
        this.model = model;
        this.render = render;
        this.loc = loc;
        this.zone = zone;
        this._fonts = [];
        this._numberTypes = [];
        this._rangeFormats = [];
        this._signatureTypes = [];
        this._dateTimeTypes = [];
        this._buttonTypes = [];
        this._columnTypes = [];
        this._buttonSendTypes = [];
        this._thousandSeparators = [];
        this._barcodeTypes = [];
        this._dateTimeValues = [];
        this._themes = [];
        this._borderWeights = [];
        this._unitAlignment = [];
        this._minUnitAlignment = [];
        this._labelFormat = [];
        this._penStyles = [];
        this._algorithmExpressions = [];
        this._dateTimeFormats = [];
        this._dateFormats = [];
        this._timeFormats = [];
        this._signatureEditorModes = [];
        this._signatureSpecialFonts = [];
        this._fontSizes = [5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 18, 20, 22, 24, 26, 28, 36, 44, 58, 72];
        this._richTextFontSizes = [];
        this._errorCorrectionLevel = ["Level1", "Level2", "Level3", "Level4"];
        this._fileMenuItems = [];
        this._dataMatrixSize = [
            "Automatic",
            "v1",
            "v2",
            "v3",
            "v4",
            "v5",
            "v6",
            "v7",
            "v8",
            "v9",
            "v10",
            "v11",
            "v12",
            "v13",
            "v14",
            "v15",
            "v16",
            "v17",
            "v18",
            "v19",
            "v20",
            "v21",
            "v22",
            "v23",
            "v24",
            "v25",
            "v26",
            "v27",
            "v28",
            "v29",
            "v30",
            "v31",
            "v32",
            "v33",
            "v34",
            "v35",
            "v36",
            "v37",
            "v38",
            "v39",
            "v40",
        ];
        this._bodyShapeType = [
            "Square",
            "RoundedSquare",
            "Dot",
            "Circle",
            "Diamond",
            "Star",
            "ZebraHorizontal",
            "ZebraVertical",
            "ZebraCross1",
            "ZebraCross2",
            "Circular",
            "DockedDiamonds",
        ];
        this._eyeFrameShapeType = ["Square", "Dots", "Circle", "Round", "Round1", "Round3"];
        this._eyeBallShapeType = [
            "Square",
            "Dots",
            "Circle",
            "Round",
            "Round1",
            "Round3",
            "Star",
            "ZebraHorizontal",
            "ZebraVertical",
        ];
        this._brushIdent = ["Empty", "Solid", "Gradient", "Glare", "Glass", "Hatch", "Default", "Style"];
        this._bodyBrush = ["Empty", "Solid", "Hatch", "Gradient", "Glare", "Glass"];
        this.hatchStyle = [
            { name: "Horizontal", value: 0 },
            { name: "Vertical", value: 1 },
            { name: "ForwardDiagonal", value: 2 },
            { name: "BackwardDiagonal", value: 3 },
            { name: "Cross", value: 4 },
            { name: "DiagonalCross", value: 5 },
            { name: "Percent05", value: 6 },
            { name: "Percent10", value: 7 },
            { name: "Percent20", value: 8 },
            { name: "Percent25", value: 9 },
            { name: "Percent30", value: 10 },
            { name: "Percent40", value: 11 },
            { name: "Percent50", value: 12 },
            { name: "Percent60", value: 13 },
            { name: "Percent70", value: 14 },
            { name: "Percent75", value: 0xf },
            { name: "Percent80", value: 0x10 },
            { name: "Percent90", value: 17 },
            { name: "LightDownwardDiagonal", value: 18 },
            { name: "LightUpwardDiagonal", value: 19 },
            { name: "DarkDownwardDiagonal", value: 20 },
            { name: "DarkUpwardDiagonal", value: 21 },
            { name: "WideDownwardDiagonal", value: 22 },
            { name: "WideUpwardDiagonal", value: 23 },
            { name: "LightVertical", value: 24 },
            { name: "LightHorizontal", value: 25 },
            { name: "NarrowVertical", value: 26 },
            { name: "NarrowHorizontal", value: 27 },
            { name: "DarkVertical", value: 28 },
            { name: "DarkHorizontal", value: 29 },
            { name: "DashedDownwardDiagonal", value: 30 },
            { name: "DashedUpwardDiagonal", value: 0x1f },
            { name: "DashedHorizontal", value: 0x20 },
            { name: "DashedVertical", value: 33 },
            { name: "SmallConfetti", value: 34 },
            { name: "LargeConfetti", value: 35 },
            { name: "ZigZag", value: 36 },
            { name: "Wave", value: 37 },
            { name: "DiagonalBrick", value: 38 },
            { name: "HorizontalBrick", value: 39 },
            { name: "Weave", value: 40 },
            { name: "Plaid", value: 41 },
            { name: "Divot", value: 42 },
            { name: "DottedGrid", value: 43 },
            { name: "DottedDiamond", value: 44 },
            { name: "Shingle", value: 45 },
            { name: "Trellis", value: 46 },
            { name: "Sphere", value: 47 },
            { name: "SmallGrid", value: 48 },
            { name: "SmallCheckerBoard", value: 49 },
            { name: "LargeCheckerBoard", value: 50 },
            { name: "OutlinedDiamond", value: 51 },
            { name: "SolidDiamond", value: 52 },
            { name: "LargeGrid", value: 4 },
            { name: "Min", value: 0 },
            { name: "Max", value: 4 },
        ];
        this.pageElement = new StiFormPageElement();
        this.justifyOptions = [
            {
                image: "images.Properties.AlignLeft.png",
                value: 1,
                name: "Left",
            },
            {
                image: "images.Properties.AlignCenter.png",
                value: 2,
                name: "Center",
            },
            {
                image: "images.Properties.AlignRight.png",
                value: 3,
                name: "Right",
            },
        ];
        this.labelAlignment = [
            {
                image: "images.Properties.Left.png",
                value: 1,
                name: "Left",
            },
            {
                image: "images.Properties.Right.png",
                value: 2,
                name: "Right",
            },
            {
                image: "images.Properties.Top.png",
                value: 3,
                name: "Top",
            },
        ];
        this.verticalAlignment = [
            {
                image: "images.Properties.AlignTop.png",
                value: 1,
                name: "Top",
            },
            {
                image: "images.Properties.AlignMiddle.png",
                value: 2,
                name: "Center",
            },
            {
                image: "images.Properties.AlignBottom.png",
                value: 3,
                name: "Bottom",
            },
        ];
        this.styleOptions = [
            {
                name: "B",
                value: "Bold",
                image: "images.Properties.FontStyleBold.png",
            },
            {
                name: "I",
                value: "Italic",
                image: "images.Properties.FontStyleItalic.png",
            },
            {
                name: "U",
                value: "Underline",
                image: "images.Properties.FontStyleUnderline.png",
            },
        ];
        this.countries = [
            { name: "Afghanistan", code: "AF" },
            { name: "Åland Islands", code: "AX" },
            { name: "Albania", code: "AL" },
            { name: "Algeria", code: "DZ" },
            { name: "American Samoa", code: "AS" },
            { name: "AndorrA", code: "AD" },
            { name: "Angola", code: "AO" },
            { name: "Anguilla", code: "AI" },
            { name: "Antarctica", code: "AQ" },
            { name: "Antigua and Barbuda", code: "AG" },
            { name: "Argentina", code: "AR" },
            { name: "Armenia", code: "AM" },
            { name: "Aruba", code: "AW" },
            { name: "Australia", code: "AU" },
            { name: "Austria", code: "AT" },
            { name: "Azerbaijan", code: "AZ" },
            { name: "Bahamas", code: "BS" },
            { name: "Bahrain", code: "BH" },
            { name: "Bangladesh", code: "BD" },
            { name: "Barbados", code: "BB" },
            { name: "Belarus", code: "BY" },
            { name: "Belgium", code: "BE" },
            { name: "Belize", code: "BZ" },
            { name: "Benin", code: "BJ" },
            { name: "Bermuda", code: "BM" },
            { name: "Bhutan", code: "BT" },
            { name: "Bolivia", code: "BO" },
            { name: "Bosnia and Herzegovina", code: "BA" },
            { name: "Botswana", code: "BW" },
            { name: "Bouvet Island", code: "BV" },
            { name: "Brazil", code: "BR" },
            { name: "British Indian Ocean Territory", code: "IO" },
            { name: "Brunei Darussalam", code: "BN" },
            { name: "Bulgaria", code: "BG" },
            { name: "Burkina Faso", code: "BF" },
            { name: "Burundi", code: "BI" },
            { name: "Cambodia", code: "KH" },
            { name: "Cameroon", code: "CM" },
            { name: "Canada", code: "CA" },
            { name: "Cape Verde", code: "CV" },
            { name: "Cayman Islands", code: "KY" },
            { name: "Central African Republic", code: "CF" },
            { name: "Chad", code: "TD" },
            { name: "Chile", code: "CL" },
            { name: "China", code: "CN" },
            { name: "Christmas Island", code: "CX" },
            { name: "Cocos (Keeling) Islands", code: "CC" },
            { name: "Colombia", code: "CO" },
            { name: "Comoros", code: "KM" },
            { name: "Congo", code: "CG" },
            { name: "Congo, The Democratic Republic of the", code: "CD" },
            { name: "Cook Islands", code: "CK" },
            { name: "Costa Rica", code: "CR" },
            { name: "Cote D'Ivoire", code: "CI" },
            { name: "Croatia", code: "HR" },
            { name: "Cuba", code: "CU" },
            { name: "Cyprus", code: "CY" },
            { name: "Czech Republic", code: "CZ" },
            { name: "Denmark", code: "DK" },
            { name: "Djibouti", code: "DJ" },
            { name: "Dominica", code: "DM" },
            { name: "Dominican Republic", code: "DO" },
            { name: "Ecuador", code: "EC" },
            { name: "Egypt", code: "EG" },
            { name: "El Salvador", code: "SV" },
            { name: "Equatorial Guinea", code: "GQ" },
            { name: "Eritrea", code: "ER" },
            { name: "Estonia", code: "EE" },
            { name: "Ethiopia", code: "ET" },
            { name: "Falkland Islands (Malvinas)", code: "FK" },
            { name: "Faroe Islands", code: "FO" },
            { name: "Fiji", code: "FJ" },
            { name: "Finland", code: "FI" },
            { name: "France", code: "FR" },
            { name: "French Guiana", code: "GF" },
            { name: "French Polynesia", code: "PF" },
            { name: "French Southern Territories", code: "TF" },
            { name: "Gabon", code: "GA" },
            { name: "Gambia", code: "GM" },
            { name: "Georgia", code: "GE" },
            { name: "Germany", code: "DE" },
            { name: "Ghana", code: "GH" },
            { name: "Gibraltar", code: "GI" },
            { name: "Greece", code: "GR" },
            { name: "Greenland", code: "GL" },
            { name: "Grenada", code: "GD" },
            { name: "Guadeloupe", code: "GP" },
            { name: "Guam", code: "GU" },
            { name: "Guatemala", code: "GT" },
            { name: "Guernsey", code: "GG" },
            { name: "Guinea", code: "GN" },
            { name: "Guinea-Bissau", code: "GW" },
            { name: "Guyana", code: "GY" },
            { name: "Haiti", code: "HT" },
            { name: "Heard Island and Mcdonald Islands", code: "HM" },
            { name: "Holy See (Vatican City State)", code: "VA" },
            { name: "Honduras", code: "HN" },
            { name: "Hong Kong", code: "HK" },
            { name: "Hungary", code: "HU" },
            { name: "Iceland", code: "IS" },
            { name: "India", code: "IN" },
            { name: "Indonesia", code: "ID" },
            { name: "Iran, Islamic Republic Of", code: "IR" },
            { name: "Iraq", code: "IQ" },
            { name: "Ireland", code: "IE" },
            { name: "Isle of Man", code: "IM" },
            { name: "Israel", code: "IL" },
            { name: "Italy", code: "IT" },
            { name: "Jamaica", code: "JM" },
            { name: "Japan", code: "JP" },
            { name: "Jersey", code: "JE" },
            { name: "Jordan", code: "JO" },
            { name: "Kazakhstan", code: "KZ" },
            { name: "Kenya", code: "KE" },
            { name: "Kiribati", code: "KI" },
            { name: "Korea, Democratic People'S Republic of", code: "KP" },
            { name: "Korea, Republic of", code: "KR" },
            { name: "Kuwait", code: "KW" },
            { name: "Kyrgyzstan", code: "KG" },
            { name: "Lao People'S Democratic Republic", code: "LA" },
            { name: "Latvia", code: "LV" },
            { name: "Lebanon", code: "LB" },
            { name: "Lesotho", code: "LS" },
            { name: "Liberia", code: "LR" },
            { name: "Libyan Arab Jamahiriya", code: "LY" },
            { name: "Liechtenstein", code: "LI" },
            { name: "Lithuania", code: "LT" },
            { name: "Luxembourg", code: "LU" },
            { name: "Macao", code: "MO" },
            { name: "Macedonia, The Former Yugoslav Republic of", code: "MK" },
            { name: "Madagascar", code: "MG" },
            { name: "Malawi", code: "MW" },
            { name: "Malaysia", code: "MY" },
            { name: "Maldives", code: "MV" },
            { name: "Mali", code: "ML" },
            { name: "Malta", code: "MT" },
            { name: "Marshall Islands", code: "MH" },
            { name: "Martinique", code: "MQ" },
            { name: "Mauritania", code: "MR" },
            { name: "Mauritius", code: "MU" },
            { name: "Mayotte", code: "YT" },
            { name: "Mexico", code: "MX" },
            { name: "Micronesia, Federated States of", code: "FM" },
            { name: "Moldova, Republic of", code: "MD" },
            { name: "Monaco", code: "MC" },
            { name: "Mongolia", code: "MN" },
            { name: "Montserrat", code: "MS" },
            { name: "Morocco", code: "MA" },
            { name: "Mozambique", code: "MZ" },
            { name: "Myanmar", code: "MM" },
            { name: "Namibia", code: "NA" },
            { name: "Nauru", code: "NR" },
            { name: "Nepal", code: "NP" },
            { name: "Netherlands", code: "NL" },
            { name: "Netherlands Antilles", code: "AN" },
            { name: "New Caledonia", code: "NC" },
            { name: "New Zealand", code: "NZ" },
            { name: "Nicaragua", code: "NI" },
            { name: "Niger", code: "NE" },
            { name: "Nigeria", code: "NG" },
            { name: "Niue", code: "NU" },
            { name: "Norfolk Island", code: "NF" },
            { name: "Northern Mariana Islands", code: "MP" },
            { name: "Norway", code: "NO" },
            { name: "Oman", code: "OM" },
            { name: "Pakistan", code: "PK" },
            { name: "Palau", code: "PW" },
            { name: "Palestinian Territory, Occupied", code: "PS" },
            { name: "Panama", code: "PA" },
            { name: "Papua New Guinea", code: "PG" },
            { name: "Paraguay", code: "PY" },
            { name: "Peru", code: "PE" },
            { name: "Philippines", code: "PH" },
            { name: "Pitcairn", code: "PN" },
            { name: "Poland", code: "PL" },
            { name: "Portugal", code: "PT" },
            { name: "Puerto Rico", code: "PR" },
            { name: "Qatar", code: "QA" },
            { name: "Reunion", code: "RE" },
            { name: "Romania", code: "RO" },
            { name: "Russian Federation", code: "RU" },
            { name: "RWANDA", code: "RW" },
            { name: "Saint Helena", code: "SH" },
            { name: "Saint Kitts and Nevis", code: "KN" },
            { name: "Saint Lucia", code: "LC" },
            { name: "Saint Pierre and Miquelon", code: "PM" },
            { name: "Saint Vincent and the Grenadines", code: "VC" },
            { name: "Samoa", code: "WS" },
            { name: "San Marino", code: "SM" },
            { name: "Sao Tome and Principe", code: "ST" },
            { name: "Saudi Arabia", code: "SA" },
            { name: "Senegal", code: "SN" },
            { name: "Serbia and Montenegro", code: "CS" },
            { name: "Seychelles", code: "SC" },
            { name: "Sierra Leone", code: "SL" },
            { name: "Singapore", code: "SG" },
            { name: "Slovakia", code: "SK" },
            { name: "Slovenia", code: "SI" },
            { name: "Solomon Islands", code: "SB" },
            { name: "Somalia", code: "SO" },
            { name: "South Africa", code: "ZA" },
            { name: "South Georgia and the South Sandwich Islands", code: "GS" },
            { name: "Spain", code: "ES" },
            { name: "Sri Lanka", code: "LK" },
            { name: "Sudan", code: "SD" },
            { name: "Suriname", code: "SR" },
            { name: "Svalbard and Jan Mayen", code: "SJ" },
            { name: "Swaziland", code: "SZ" },
            { name: "Sweden", code: "SE" },
            { name: "Switzerland", code: "CH" },
            { name: "Syrian Arab Republic", code: "SY" },
            { name: "Taiwan, Province of China", code: "TW" },
            { name: "Tajikistan", code: "TJ" },
            { name: "Tanzania, United Republic of", code: "TZ" },
            { name: "Thailand", code: "TH" },
            { name: "Timor-Leste", code: "TL" },
            { name: "Togo", code: "TG" },
            { name: "Tokelau", code: "TK" },
            { name: "Tonga", code: "TO" },
            { name: "Trinidad and Tobago", code: "TT" },
            { name: "Tunisia", code: "TN" },
            { name: "Turkey", code: "TR" },
            { name: "Turkmenistan", code: "TM" },
            { name: "Turks and Caicos Islands", code: "TC" },
            { name: "Tuvalu", code: "TV" },
            { name: "Uganda", code: "UG" },
            { name: "Ukraine", code: "UA" },
            { name: "United Arab Emirates", code: "AE" },
            { name: "United Kingdom", code: "GB" },
            { name: "United States", code: "US" },
            { name: "United States Minor Outlying Islands", code: "UM" },
            { name: "Uruguay", code: "UY" },
            { name: "Uzbekistan", code: "UZ" },
            { name: "Vanuatu", code: "VU" },
            { name: "Venezuela", code: "VE" },
            { name: "Viet Nam", code: "VN" },
            { name: "Virgin Islands, British", code: "VG" },
            { name: "Virgin Islands, U.S.", code: "VI" },
            { name: "Wallis and Futuna", code: "WF" },
            { name: "Western Sahara", code: "EH" },
            { name: "Yemen", code: "YE" },
            { name: "Zambia", code: "ZM" },
            { name: "Zimbabwe", code: "ZW" },
        ];
        this.currencyInfo = [
            {
                englishName: "Afghan Afghani (\u060B)",
                nativeName: "\u0627\u0641\u063A\u0627\u0646\u06CC \u0627\u0641\u063A\u0627\u0646\u0633\u062A\u0627\u0646",
                code: "AFN",
                symbol: "\u060B",
            },
            {
                englishName: "Albanian Lek (Lek\u00EB)",
                nativeName: "Leku shqiptar",
                code: "ALL",
                symbol: "Lek\u00EB",
            },
            {
                englishName: "Algerian Dinar (\u062F.\u062C.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u062C\u0632\u0627\u0626\u0631\u064A",
                code: "DZD",
                symbol: "\u062F.\u062C.\u200F",
            },
            {
                englishName: "Angolan Kwanza (Kz)",
                nativeName: "Kwanza ya Ang\u00F3la",
                code: "AOA",
                symbol: "Kz",
            },
            {
                englishName: "Argentine Peso ($)",
                nativeName: "peso argentino",
                code: "ARS",
                symbol: "$",
            },
            {
                englishName: "Armenian Dram (\u058F)",
                nativeName: "\u0570\u0561\u0575\u056F\u0561\u056F\u0561\u0576 \u0564\u0580\u0561\u0574",
                code: "AMD",
                symbol: "\u058F",
            },
            {
                englishName: "Aruban Florin (Afl.)",
                nativeName: "Arubaanse gulden",
                code: "AWG",
                symbol: "Afl.",
            },
            {
                englishName: "Australian Dollar ($)",
                nativeName: "Australian Dollar",
                code: "AUD",
                symbol: "$",
            },
            {
                englishName: "Azerbaijani Manat (\u20BC)",
                nativeName: "AZN",
                code: "AZN",
                symbol: "\u20BC",
            },
            {
                englishName: "Bahamian Dollar ($)",
                nativeName: "Bahamian Dollar",
                code: "BSD",
                symbol: "$",
            },
            {
                englishName: "Bahraini Dinar (\u062F.\u0628.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0628\u062D\u0631\u064A\u0646\u064A",
                code: "BHD",
                symbol: "\u062F.\u0628.\u200F",
            },
            {
                englishName: "Bangladeshi Taka (\u09F3)",
                nativeName: "\u09AC\u09BE\u0982\u09B2\u09BE\u09A6\u09C7\u09B6\u09C0 \u099F\u09BE\u0995\u09BE",
                code: "BDT",
                symbol: "\u09F3",
            },
            {
                englishName: "Barbadian Dollar ($)",
                nativeName: "Barbadian Dollar",
                code: "BBD",
                symbol: "$",
            },
            {
                englishName: "Belarusian Ruble (Br)",
                nativeName: "\u0431\u0435\u043B\u0430\u0440\u0443\u0441\u043A\u0456 \u0440\u0443\u0431\u0435\u043B\u044C",
                code: "BYN",
                symbol: "Br",
            },
            {
                englishName: "Belize Dollar ($)",
                nativeName: "Belize Dollar",
                code: "BZD",
                symbol: "$",
            },
            {
                englishName: "Bermudan Dollar ($)",
                nativeName: "Bermudan Dollar",
                code: "BMD",
                symbol: "$",
            },
            {
                englishName: "Bhutanese Ngultrum (Nu.)",
                nativeName: "\u0F51\u0F44\u0F74\u0F63\u0F0B\u0F40\u0FB2\u0F58",
                code: "BTN",
                symbol: "Nu.",
            },
            {
                englishName: "Bolivian Boliviano (Bs)",
                nativeName: "boliviano",
                code: "BOB",
                symbol: "Bs",
            },
            {
                englishName: "Bosnia-Herzegovina Convertible Mark (\u041A\u041C)",
                nativeName: "\u041A\u043E\u043D\u0432\u0435\u0440\u0442\u0438\u0431\u0438\u043B\u043D\u0430 \u043C\u0430\u0440\u043A\u0430",
                code: "BAM",
                symbol: "\u041A\u041C",
            },
            {
                englishName: "Botswanan Pula (P)",
                nativeName: "Botswanan Pula",
                code: "BWP",
                symbol: "P",
            },
            {
                englishName: "Brazilian Real (R$)",
                nativeName: "real brasile\u00F1o",
                code: "BRL",
                symbol: "R$",
            },
            {
                englishName: "British Pound (\u00A3)",
                nativeName: "Punt Prydain",
                code: "GBP",
                symbol: "\u00A3",
            },
            {
                englishName: "Brunei Dollar ($)",
                nativeName: "Dolar Brunei",
                code: "BND",
                symbol: "$",
            },
            {
                englishName: "Bulgarian Lev (\u043B\u0432.)",
                nativeName: "\u0411\u044A\u043B\u0433\u0430\u0440\u0441\u043A\u0438 \u043B\u0435\u0432",
                code: "BGN",
                symbol: "\u043B\u0432.",
            },
            {
                englishName: "Burundian Franc (FBu)",
                nativeName: "Burundian Franc",
                code: "BIF",
                symbol: "FBu",
            },
            {
                englishName: "Cambodian Riel (\u17DB)",
                nativeName: "\u179A\u17C0\u179B\u200B\u1780\u1798\u17D2\u1796\u17BB\u1787\u17B6",
                code: "KHR",
                symbol: "\u17DB",
            },
            {
                englishName: "Canadian Dollar ($)",
                nativeName: "Canadian Dollar",
                code: "CAD",
                symbol: "$",
            },
            {
                englishName: "Cape Verdean Escudo (\u200B)",
                nativeName: "Skudu Kabuverdianu",
                code: "CVE",
                symbol: "\u200B",
            },
            {
                englishName: "Cayman Islands Dollar ($)",
                nativeName: "Cayman Islands Dollar",
                code: "KYD",
                symbol: "$",
            },
            {
                englishName: "Central African CFA Franc (FCFA)",
                nativeName: "CFA F\u00E0l\u00E2\u014B BEAC",
                code: "XAF",
                symbol: "FCFA",
            },
            {
                englishName: "CFP Franc (FCFP)",
                nativeName: "franc CFP",
                code: "XPF",
                symbol: "FCFP",
            },
            {
                englishName: "Chilean Peso (CLP)",
                nativeName: "CLP",
                code: "CLP",
                symbol: "CLP",
            },
            {
                englishName: "Chinese Yuan (\u00A5)",
                nativeName: "\u0F61\u0F74\u0F0B\u0F68\u0F53\u0F0B",
                code: "CNY",
                symbol: "\u00A5",
            },
            {
                englishName: "Colombian Peso ($)",
                nativeName: "peso colombiano",
                code: "COP",
                symbol: "$",
            },
            {
                englishName: "Comorian Franc (CF)",
                nativeName: "\u0641\u0631\u0646\u0643 \u062C\u0632\u0631 \u0627\u0644\u0642\u0645\u0631",
                code: "KMF",
                symbol: "CF",
            },
            {
                englishName: "Congolese Franc (FC)",
                nativeName: "franc congolais",
                code: "CDF",
                symbol: "FC",
            },
            {
                englishName: "Costa Rican Col\u00F3n (\u20A1)",
                nativeName: "col\u00F3n costarricense",
                code: "CRC",
                symbol: "\u20A1",
            },
            {
                englishName: "Croatian Kuna (HRK)",
                nativeName: "hrvatska kuna",
                code: "HRK",
                symbol: "HRK",
            },
            {
                englishName: "Cuban Peso ($)",
                nativeName: "peso cubano",
                code: "CUP",
                symbol: "$",
            },
            {
                englishName: "Czech Koruna (K\u010D)",
                nativeName: "\u010Desk\u00E1 koruna",
                code: "CZK",
                symbol: "K\u010D",
            },
            {
                englishName: "Danish Krone (kr.)",
                nativeName: "dansk krone",
                code: "DKK",
                symbol: "kr.",
            },
            {
                englishName: "Djiboutian Franc (Fdj)",
                nativeName: "DJF",
                code: "DJF",
                symbol: "Fdj",
            },
            {
                englishName: "Dominican Peso (RD$)",
                nativeName: "peso dominicano",
                code: "DOP",
                symbol: "RD$",
            },
            {
                englishName: "East Caribbean Dollar ($)",
                nativeName: "East Caribbean Dollar",
                code: "XCD",
                symbol: "$",
            },
            {
                englishName: "Egyptian Pound (\u062C.\u0645.\u200F)",
                nativeName: "\u062C\u0646\u064A\u0647 \u0645\u0635\u0631\u064A",
                code: "EGP",
                symbol: "\u062C.\u0645.\u200F",
            },
            {
                englishName: "Eritrean Nakfa (Nfk)",
                nativeName: "ERN",
                code: "ERN",
                symbol: "Nfk",
            },
            {
                englishName: "Ethiopian Birr (Br)",
                nativeName: "ETB",
                code: "ETB",
                symbol: "Br",
            },
            {
                englishName: "Euro (\u20AC)",
                nativeName: "euro",
                code: "EUR",
                symbol: "\u20AC",
            },
            {
                englishName: "Falkland Islands Pound (\u00A3)",
                nativeName: "Falkland Islands Pound",
                code: "FKP",
                symbol: "\u00A3",
            },
            {
                englishName: "Fijian Dollar ($)",
                nativeName: "Fijian Dollar",
                code: "FJD",
                symbol: "$",
            },
            {
                englishName: "Gambian Dalasi (D)",
                nativeName: "Gambian Dalasi",
                code: "GMD",
                symbol: "D",
            },
            {
                englishName: "Georgian Lari (\u20BE)",
                nativeName: "\u10E5\u10D0\u10E0\u10D7\u10E3\u10DA\u10D8 \u10DA\u10D0\u10E0\u10D8",
                code: "GEL",
                symbol: "\u20BE",
            },
            {
                englishName: "Ghanaian Cedi (GH\u20B5)",
                nativeName: "Ghana Sidi",
                code: "GHS",
                symbol: "GH\u20B5",
            },
            {
                englishName: "Gibraltar Pound (\u00A3)",
                nativeName: "Gibraltar Pound",
                code: "GIP",
                symbol: "\u00A3",
            },
            {
                englishName: "Guatemalan Quetzal (Q)",
                nativeName: "quetzal",
                code: "GTQ",
                symbol: "Q",
            },
            {
                englishName: "Guinean Franc (FG)",
                nativeName: "GNF",
                code: "GNF",
                symbol: "FG",
            },
            {
                englishName: "Guyanaese Dollar ($)",
                nativeName: "Guyanaese Dollar",
                code: "GYD",
                symbol: "$",
            },
            {
                englishName: "Haitian Gourde (G)",
                nativeName: "gourde ha\u00EFtienne",
                code: "HTG",
                symbol: "G",
            },
            {
                englishName: "Honduran Lempira (L)",
                nativeName: "lempira hondure\u00F1o",
                code: "HNL",
                symbol: "L",
            },
            {
                englishName: "Hong Kong Dollar (HK$)",
                nativeName: "Hong Kong Dollar",
                code: "HKD",
                symbol: "HK$",
            },
            {
                englishName: "Hungarian Forint (Ft)",
                nativeName: "magyar forint",
                code: "HUF",
                symbol: "Ft",
            },
            {
                englishName: "Icelandic Kr\u00F3na (ISK)",
                nativeName: "\u00EDslensk kr\u00F3na",
                code: "ISK",
                symbol: "ISK",
            },
            {
                englishName: "Indian Rupee (\u20B9)",
                nativeName: "\u09AD\u09BE\u09F0\u09A4\u09C0\u09AF\u09BC \u09F0\u09C1\u09AA\u09C0",
                code: "INR",
                symbol: "\u20B9",
            },
            {
                englishName: "Indonesian Rupiah (Rp)",
                nativeName: "Rupiah Indonesia",
                code: "IDR",
                symbol: "Rp",
            },
            {
                englishName: "Iranian Rial (IRR)",
                nativeName: "IRR",
                code: "IRR",
                symbol: "IRR",
            },
            {
                englishName: "Iraqi Dinar (\u062F.\u0639.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0639\u0631\u0627\u0642\u064A",
                code: "IQD",
                symbol: "\u062F.\u0639.\u200F",
            },
            {
                englishName: "Israeli New Shekel (\u20AA)",
                nativeName: "\u0634\u064A\u0643\u0644 \u0625\u0633\u0631\u0627\u0626\u064A\u0644\u064A \u062C\u062F\u064A\u062F",
                code: "ILS",
                symbol: "\u20AA",
            },
            {
                englishName: "Jamaican Dollar ($)",
                nativeName: "Jamaican Dollar",
                code: "JMD",
                symbol: "$",
            },
            {
                englishName: "Japanese Yen (\uFFE5)",
                nativeName: "\u65E5\u672C\u5186",
                code: "JPY",
                symbol: "\uFFE5",
            },
            {
                englishName: "Jordanian Dinar (\u062F.\u0623.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0623\u0631\u062F\u0646\u064A",
                code: "JOD",
                symbol: "\u062F.\u0623.\u200F",
            },
            {
                englishName: "Kazakhstani Tenge (\u20B8)",
                nativeName: "\u049A\u0430\u0437\u0430\u049B\u0441\u0442\u0430\u043D \u0442\u0435\u04A3\u0433\u0435\u0441\u0456",
                code: "KZT",
                symbol: "\u20B8",
            },
            {
                englishName: "Kenyan Shilling (Ksh)",
                nativeName: "Shilingi ya Kenya",
                code: "KES",
                symbol: "Ksh",
            },
            {
                englishName: "Kuwaiti Dinar (\u062F.\u0643.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0643\u0648\u064A\u062A\u064A",
                code: "KWD",
                symbol: "\u062F.\u0643.\u200F",
            },
            {
                englishName: "Kyrgystani Som (\u0441\u043E\u043C)",
                nativeName: "\u041A\u044B\u0440\u0433\u044B\u0437\u0441\u0442\u0430\u043D \u0441\u043E\u043C\u0443",
                code: "KGS",
                symbol: "\u0441\u043E\u043C",
            },
            {
                englishName: "Laotian Kip (\u20AD)",
                nativeName: "\u0EA5\u0EB2\u0EA7 \u0E81\u0EB5\u0E9A",
                code: "LAK",
                symbol: "\u20AD",
            },
            {
                englishName: "Lebanese Pound (\u0644.\u0644.\u200F)",
                nativeName: "\u062C\u0646\u064A\u0647 \u0644\u0628\u0646\u0627\u0646\u064A",
                code: "LBP",
                symbol: "\u0644.\u0644.\u200F",
            },
            {
                englishName: "Liberian Dollar ($)",
                nativeName: "Liberian Dollar",
                code: "LRD",
                symbol: "$",
            },
            {
                englishName: "Libyan Dinar (\u062F.\u0644.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u0644\u064A\u0628\u064A",
                code: "LYD",
                symbol: "\u062F.\u0644.\u200F",
            },
            {
                englishName: "Macanese Pataca (MOP$)",
                nativeName: "Macanese Pataca",
                code: "MOP",
                symbol: "MOP$",
            },
            {
                englishName: "Macedonian Denar (\u0434\u0435\u043D)",
                nativeName: "\u041C\u0430\u043A\u0435\u0434\u043E\u043D\u0441\u043A\u0438 \u0434\u0435\u043D\u0430\u0440",
                code: "MKD",
                symbol: "\u0434\u0435\u043D",
            },
            {
                englishName: "Malagasy Ariary (Ar)",
                nativeName: "Malagasy Ariary",
                code: "MGA",
                symbol: "Ar",
            },
            {
                englishName: "Malawian Kwacha (MK)",
                nativeName: "Malawian Kwacha",
                code: "MWK",
                symbol: "MK",
            },
            {
                englishName: "Malaysian Ringgit (RM)",
                nativeName: "Malaysian Ringgit",
                code: "MYR",
                symbol: "RM",
            },
            {
                englishName: "Maldivian Rufiyaa (\u0783.)",
                nativeName: "MVR",
                code: "MVR",
                symbol: "\u0783.",
            },
            {
                englishName: "Mauritanian Ouguiya (\u0623.\u0645.)",
                nativeName: "\u0623\u0648\u0642\u064A\u0629 \u0645\u0648\u0631\u064A\u062A\u0627\u0646\u064A\u0629",
                code: "MRU",
                symbol: "\u0623.\u0645.",
            },
            {
                englishName: "Mauritian Rupee (Rs)",
                nativeName: "Mauritian Rupee",
                code: "MUR",
                symbol: "Rs",
            },
            {
                englishName: "Mexican Peso ($)",
                nativeName: "peso mexicano",
                code: "MXN",
                symbol: "$",
            },
            {
                englishName: "Moldovan Leu (L)",
                nativeName: "leu moldovenesc",
                code: "MDL",
                symbol: "L",
            },
            {
                englishName: "Mongolian Tugrik (\u20AE)",
                nativeName: "\u0442\u04E9\u0433\u0440\u04E9\u0433",
                code: "MNT",
                symbol: "\u20AE",
            },
            {
                englishName: "Moroccan Dirham (\u062F.\u0645.\u200F)",
                nativeName: "\u062F\u0631\u0647\u0645 \u0645\u063A\u0631\u0628\u064A",
                code: "MAD",
                symbol: "\u062F.\u0645.\u200F",
            },
            {
                englishName: "Mozambican Metical (MTn)",
                nativeName: "MZN",
                code: "MZN",
                symbol: "MTn",
            },
            {
                englishName: "Myanmar Kyat (K)",
                nativeName: "\u1019\u103C\u1014\u103A\u1019\u102C \u1000\u103B\u1015\u103A",
                code: "MMK",
                symbol: "K",
            },
            {
                englishName: "Namibian Dollar ($)",
                nativeName: "Namibiese dollar",
                code: "NAD",
                symbol: "$",
            },
            {
                englishName: "Nepalese Rupee (\u0928\u0947\u0930\u0942)",
                nativeName: "\u0928\u0947\u092A\u093E\u0932\u0940 \u0930\u0942\u092A\u0948\u092F\u093E\u0901",
                code: "NPR",
                symbol: "\u0928\u0947\u0930\u0942",
            },
            {
                englishName: "Netherlands Antillean Guilder (NAf.)",
                nativeName: "Netherlands Antillean Guilder",
                code: "ANG",
                symbol: "NAf.",
            },
            {
                englishName: "New Taiwan Dollar ($)",
                nativeName: "\u65B0\u53F0\u5E63",
                code: "TWD",
                symbol: "$",
            },
            {
                englishName: "New Zealand Dollar ($)",
                nativeName: "New Zealand Dollar",
                code: "NZD",
                symbol: "$",
            },
            {
                englishName: "Nicaraguan C\u00F3rdoba (C$)",
                nativeName: "c\u00F3rdoba nicarag\u00FCense",
                code: "NIO",
                symbol: "C$",
            },
            {
                englishName: "Nigerian Naira (\u20A6)",
                nativeName: "Nigerian Naira",
                code: "NGN",
                symbol: "\u20A6",
            },
            {
                englishName: "North Korean Won (KPW)",
                nativeName: "\uC870\uC120 \uBBFC\uC8FC\uC8FC\uC758 \uC778\uBBFC \uACF5\uD654\uAD6D \uC6D0",
                code: "KPW",
                symbol: "KPW",
            },
            {
                englishName: "Norwegian Krone (kr)",
                nativeName: "norske kroner",
                code: "NOK",
                symbol: "kr",
            },
            {
                englishName: "Omani Rial (\u0631.\u0639.\u200F)",
                nativeName: "\u0631\u064A\u0627\u0644 \u0639\u0645\u0627\u0646\u064A",
                code: "OMR",
                symbol: "\u0631.\u0639.\u200F",
            },
            {
                englishName: "Pakistani Rupee (Rs)",
                nativeName: "Pakistani Rupee",
                code: "PKR",
                symbol: "Rs",
            },
            {
                englishName: "Panamanian Balboa (B/.)",
                nativeName: "balboa paname\u00F1o",
                code: "PAB",
                symbol: "B/.",
            },
            {
                englishName: "Papua New Guinean Kina (K)",
                nativeName: "Papua New Guinean Kina",
                code: "PGK",
                symbol: "K",
            },
            {
                englishName: "Paraguayan Guarani (Gs.)",
                nativeName: "guaran\u00ED paraguayo",
                code: "PYG",
                symbol: "Gs.",
            },
            {
                englishName: "Peruvian Sol (S/)",
                nativeName: "sol peruano",
                code: "PEN",
                symbol: "S/",
            },
            {
                englishName: "Philippine Piso (\u20B1)",
                nativeName: "PHP",
                code: "PHP",
                symbol: "\u20B1",
            },
            {
                englishName: "Polish Zloty (z\u0142)",
                nativeName: "z\u0142oty polski",
                code: "PLN",
                symbol: "z\u0142",
            },
            {
                englishName: "Qatari Rial (\u0631.\u0642.\u200F)",
                nativeName: "\u0631\u064A\u0627\u0644 \u0642\u0637\u0631\u064A",
                code: "QAR",
                symbol: "\u0631.\u0642.\u200F",
            },
            {
                englishName: "Romanian Leu (RON)",
                nativeName: "leu rom\u00E2nesc",
                code: "RON",
                symbol: "RON",
            },
            {
                englishName: "Russian Ruble (RUB)",
                nativeName: "RUB",
                code: "RUB",
                symbol: "RUB",
            },
            {
                englishName: "Rwandan Franc (RF)",
                nativeName: "Rwandan Franc",
                code: "RWF",
                symbol: "RF",
            },
            {
                englishName: "Samoan Tala (WS$)",
                nativeName: "Samoan Tala",
                code: "WST",
                symbol: "WS$",
            },
            {
                englishName: "S\u00E3o Tom\u00E9 \u0026 Pr\u00EDncipe Dobra (Db)",
                nativeName: "dobra de S\u00E3o Tom\u00E9 e Pr\u00EDncipe",
                code: "STN",
                symbol: "Db",
            },
            {
                englishName: "Saudi Riyal (\u0631.\u0633.\u200F)",
                nativeName: "\u0631\u064A\u0627\u0644 \u0633\u0639\u0648\u062F\u064A",
                code: "SAR",
                symbol: "\u0631.\u0633.\u200F",
            },
            {
                englishName: "Serbian Dinar (RSD)",
                nativeName: "\u0421\u0440\u043F\u0441\u043A\u0438 \u0434\u0438\u043D\u0430\u0440",
                code: "RSD",
                symbol: "RSD",
            },
            {
                englishName: "Seychellois Rupee (SR)",
                nativeName: "Seychellois Rupee",
                code: "SCR",
                symbol: "SR",
            },
            {
                englishName: "Sierra Leonean Leone (Le)",
                nativeName: "Sierra Leonean Leone",
                code: "SLL",
                symbol: "Le",
            },
            {
                englishName: "Singapore Dollar ($)",
                nativeName: "Singapore Dollar",
                code: "SGD",
                symbol: "$",
            },
            {
                englishName: "Solomon Islands Dollar ($)",
                nativeName: "Solomon Islands Dollar",
                code: "SBD",
                symbol: "$",
            },
            {
                englishName: "Somali Shilling (S)",
                nativeName: "\u0634\u0644\u0646 \u0635\u0648\u0645\u0627\u0644\u064A",
                code: "SOS",
                symbol: "S",
            },
            {
                englishName: "South African Rand (R)",
                nativeName: "Suid-Afrikaanse rand",
                code: "ZAR",
                symbol: "R",
            },
            {
                englishName: "South Korean Won (\u20A9)",
                nativeName: "\uB300\uD55C\uBBFC\uAD6D \uC6D0",
                code: "KRW",
                symbol: "\u20A9",
            },
            {
                englishName: "South Sudanese Pound (\u00A3)",
                nativeName: "\u062C\u0646\u064A\u0647 \u062C\u0646\u0648\u0628 \u0627\u0644\u0633\u0648\u062F\u0627\u0646",
                code: "SSP",
                symbol: "\u00A3",
            },
            {
                englishName: "Sri Lankan Rupee (\u0DBB\u0DD4.)",
                nativeName: "\u0DC1\u0DCA\u200D\u0DBB\u0DD3 \u0DBD\u0D82\u0D9A\u0DCF \u0DBB\u0DD4\u0DB4\u0DD2\u0DBA\u0DBD",
                code: "LKR",
                symbol: "\u0DBB\u0DD4.",
            },
            {
                englishName: "St. Helena Pound (\u00A3)",
                nativeName: "St. Helena Pound",
                code: "SHP",
                symbol: "\u00A3",
            },
            {
                englishName: "Sudanese Pound (\u062C.\u0633.)",
                nativeName: "\u062C\u0646\u064A\u0647 \u0633\u0648\u062F\u0627\u0646\u064A",
                code: "SDG",
                symbol: "\u062C.\u0633.",
            },
            {
                englishName: "Surinamese Dollar ($)",
                nativeName: "Surinaamse dollar",
                code: "SRD",
                symbol: "$",
            },
            {
                englishName: "Swazi Lilangeni (E)",
                nativeName: "Swazi Lilangeni",
                code: "SZL",
                symbol: "E",
            },
            {
                englishName: "Swedish Krona (kr)",
                nativeName: "Swedish Krona",
                code: "SEK",
                symbol: "kr",
            },
            {
                englishName: "Swiss Franc (CHF)",
                nativeName: "Schweizer Franken",
                code: "CHF",
                symbol: "CHF",
            },
            {
                englishName: "Syrian Pound (\u0644.\u0633.\u200F)",
                nativeName: "\u0644\u064A\u0631\u0629 \u0633\u0648\u0631\u064A\u0629",
                code: "SYP",
                symbol: "\u0644.\u0633.\u200F",
            },
            {
                englishName: "Tajikistani Somoni (\u0441\u043E\u043C.)",
                nativeName: "\u0421\u043E\u043C\u043E\u043D\u04E3",
                code: "TJS",
                symbol: "\u0441\u043E\u043C.",
            },
            {
                englishName: "Tanzanian Shilling (TSh)",
                nativeName: "shilingi ya Tandhania",
                code: "TZS",
                symbol: "TSh",
            },
            {
                englishName: "Thai Baht (\u0E3F)",
                nativeName: "\u0E1A\u0E32\u0E17",
                code: "THB",
                symbol: "\u0E3F",
            },
            {
                englishName: "Tongan Pa\u02BBanga (T$)",
                nativeName: "Tongan Pa\u02BBanga",
                code: "TOP",
                symbol: "T$",
            },
            {
                englishName: "Trinidad \u0026 Tobago Dollar ($)",
                nativeName: "Trinidad \u0026 Tobago Dollar",
                code: "TTD",
                symbol: "$",
            },
            {
                englishName: "Tunisian Dinar (\u062F.\u062A.\u200F)",
                nativeName: "\u062F\u064A\u0646\u0627\u0631 \u062A\u0648\u0646\u0633\u064A",
                code: "TND",
                symbol: "\u062F.\u062A.\u200F",
            },
            {
                englishName: "Turkish Lira (\u20BA)",
                nativeName: "T\u00FCrk Liras\u0131",
                code: "TRY",
                symbol: "\u20BA",
            },
            {
                englishName: "Turkmenistani Manat (TMT)",
                nativeName: "T\u00FCrkmen manady",
                code: "TMT",
                symbol: "TMT",
            },
            {
                englishName: "Ugandan Shilling (USh)",
                nativeName: "Eshiringi ya Uganda",
                code: "UGX",
                symbol: "USh",
            },
            {
                englishName: "Ukrainian Hryvnia (\u20B4)",
                nativeName: "\u0443\u043A\u0440\u0430\u0438\u043D\u0441\u043A\u0430\u044F \u0433\u0440\u0438\u0432\u043D\u0430",
                code: "UAH",
                symbol: "\u20B4",
            },
            {
                englishName: "United Arab Emirates Dirham (\u062F.\u0625.\u200F)",
                nativeName: "\u062F\u0631\u0647\u0645 \u0625\u0645\u0627\u0631\u0627\u062A\u064A",
                code: "AED",
                symbol: "\u062F.\u0625.\u200F",
            },
            {
                englishName: "Uruguayan Peso ($)",
                nativeName: "peso uruguayo",
                code: "UYU",
                symbol: "$",
            },
            {
                englishName: "US Dollar ($)",
                nativeName: "US \u13A0\u13D5\u13B3",
                code: "USD",
                symbol: "$",
            },
            {
                englishName: "Uzbekistani Som (\u0441\u045E\u043C)",
                nativeName: "\u040E\u0437\u0431\u0435\u043A\u0438\u0441\u0442\u043E\u043D \u0441\u045E\u043C",
                code: "UZS",
                symbol: "\u0441\u045E\u043C",
            },
            {
                englishName: "Vanuatu Vatu (VT)",
                nativeName: "Vanuatu Vatu",
                code: "VUV",
                symbol: "VT",
            },
            {
                englishName: "Venezuelan Bol\u00EDvar (Bs.S)",
                nativeName: "bol\u00EDvar soberano",
                code: "VES",
                symbol: "Bs.S",
            },
            {
                englishName: "Vietnamese Dong (\u20AB)",
                nativeName: "\u0110\u1ED3ng Vi\u1EC7t Nam",
                code: "VND",
                symbol: "\u20AB",
            },
            {
                englishName: "West African CFA Franc (CFA)",
                nativeName: "sefa Fra\u014B (BCEAO)",
                code: "XOF",
                symbol: "CFA",
            },
            {
                englishName: "Yemeni Rial (\u0631.\u064A.\u200F)",
                nativeName: "\u0631\u064A\u0627\u0644 \u064A\u0645\u0646\u064A",
                code: "YER",
                symbol: "\u0631.\u064A.\u200F",
            },
            {
                englishName: "Zambian Kwacha (K)",
                nativeName: "ZMW",
                code: "ZMW",
                symbol: "K",
            },
        ];
        this.elementTypes = {
            AddressElement: "Address",
            Text_BoxElement: "StiTextBoxControl",
            TextElement: "StiText",
            TableElement: "StiTable",
            Single_SelectionElement: "StiSingleSelection",
            SignatureElement: "StiElectronicSignature",
            PDFSignatureElement: "StiPdfDigitalSignature",
            PanelElement: "StiPanel",
            Number_BoxElement: "StiNumberBox",
            Multiple_SelectionElement: "StiMultipleSelection",
            List_BoxElement: "StiListBox",
            LabelElement: "StiLabelControl",
            ImageElement: "StiImage",
            LineElement: "Line",
            DateTime_BoxElement: "StiDateTimePickerControl",
            Combo_BoxElement: "StiComboBox",
            Check_BoxElement: "StiCheckBox",
            ButtonElement: "StiButton",
            BarCodeElement: "StiBarCode",
            StiPageElement: "StiPage",
        };
        this.elementCategories = {
            AddressElement: "Report",
            Text_BoxElement: "Dialogs",
            LineElement: "Chart",
            DateTime_BoxElement: "Dialogs",
            LabelElement: "Dialogs",
        };
        StiLocalizationService.needToRefresh.subscribe(() => {
            this.updateHelper();
        });
    }
    getProperty(element, prop) {
        let props = prop.split(".");
        return prop.indexOf(".") == -1
            ? element[prop]
            : this.getProperty(element[props[0]], props.splice(1, props.length).join("."));
    }
    setProperty(element, prop, value) {
        {
            let props = prop.split(".");
            if (prop.indexOf(".") == -1) {
                element[prop] = value;
            }
            else {
                element[props[0]][props[1]] = value;
            }
        }
    }
    get richTextFontSizes() {
        if (this._richTextFontSizes.length === 0) {
            this._richTextFontSizes.push({ name: "8", value: 1 });
            this._richTextFontSizes.push({ name: "10", value: 2 });
            this._richTextFontSizes.push({ name: "12", value: 3 });
            this._richTextFontSizes.push({ name: "14", value: 4 });
            this._richTextFontSizes.push({ name: "18", value: 5 });
            this._richTextFontSizes.push({ name: "24", value: 6 });
            this._richTextFontSizes.push({ name: "36", value: 7 });
        }
        return this._richTextFontSizes;
    }
    get fontSizes() {
        return this._fontSizes;
    }
    getLocalizationKey(type) {
        return this.elementTypes[type];
    }
    getLocalizationCategory(type) {
        return this.elementCategories[type] ? this.elementCategories[type] : "Components";
    }
    get errorCorrectionLevel() {
        return this._errorCorrectionLevel;
    }
    get bodyShapeType() {
        return this._bodyShapeType;
    }
    get eyeFrameShapeType() {
        return this._eyeFrameShapeType;
    }
    get eyeBallShapeType() {
        return this._eyeBallShapeType;
    }
    get brushIdent() {
        return this._brushIdent;
    }
    get bodyBrush() {
        return this._bodyBrush;
    }
    get dataMatrixSize() {
        return this._dataMatrixSize;
    }
    get numberTypes() {
        if (this._numberTypes.length === 0) {
            this._numberTypes.push({
                name: StiLocalizationService.get("FormFormatEditor", "Number"),
                value: "Decimal",
            });
            this._numberTypes.push({
                name: StiLocalizationService.get("FormFormatEditor", "Currency"),
                value: "Currency",
            });
        }
        return this._numberTypes;
    }
    get rangeFormats() {
        if (this._rangeFormats.length === 0) {
            this._rangeFormats.push({
                name: StiLocalizationService.get("PropertyEnum", "Digits"),
                value: "Digits",
            });
            this._rangeFormats.push({
                name: StiLocalizationService.get("PropertyEnum", "Values"),
                value: "Values",
            });
        }
        return this._rangeFormats;
    }
    get signatureTypes() {
        if (this._signatureTypes.length === 0) {
            this._signatureTypes.push({
                name: StiLocalizationService.get("Components", "StiElectronicSignature"),
                value: "Signature",
            });
            this._signatureTypes.push({
                name: StiLocalizationService.get("Components", "StiPdfDigitalSignature"),
                value: "DigitalSignature",
            });
        }
        return this._signatureTypes;
    }
    get columnTypes() {
        if (this._columnTypes.length === 0) {
            this._columnTypes.push({ name: StiLocalizationService.get("Components", "StiCheckBox"), value: "CheckBox" });
            this._columnTypes.push({ name: StiLocalizationService.get("Components", "StiComboBox"), value: "ComboBox" });
            this._columnTypes.push({ name: StiLocalizationService.get("Dialogs", "StiLabelControl"), value: "Label" });
            this._columnTypes.push({
                name: StiLocalizationService.get("Components", "StiSingleSelection"),
                value: "RadioButton",
            });
            this._columnTypes.push({ name: StiLocalizationService.get("Dialogs", "StiTextBoxControl"), value: "TextBox" });
            this._columnTypes.push({ name: StiLocalizationService.get("Components", "StiNumberBox"), value: "NumberBox" });
        }
        return this._columnTypes;
    }
    get buttonTypes() {
        if (this._buttonTypes.length === 0) {
            this._buttonTypes.push({
                name: StiLocalizationService.get("Gui", "monthcalendar_clearbutton"),
                value: "ClearForm",
            });
            this._buttonTypes.push({
                name: StiLocalizationService.get("A_WebViewer", "ButtonSend"),
                value: "SendForm",
            });
            this._buttonTypes.push({
                name: StiLocalizationService.get("Buttons", "Attach"),
                value: "AttachFiles",
            });
        }
        return this._buttonTypes;
    }
    get algorithmExpressions() {
        if (this._algorithmExpressions.length === 0) {
            this._algorithmExpressions.push({ name: "Constant", value: "Constant" });
            this._algorithmExpressions.push({ name: "Number cell value", value: "NumberCellValue" });
            this._algorithmExpressions.push({ name: "Number column max", value: "NumberColumnMax" });
            this._algorithmExpressions.push({ name: "Number column sum", value: "NumberColumnSum" });
        }
        return this._algorithmExpressions;
    }
    get buttonSendTypes() {
        if (this._buttonSendTypes.length === 0) {
            this._buttonSendTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiButtonSendTypeFDF"),
                value: "FDF",
            });
            this._buttonSendTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiButtonSendTypeHTML"),
                value: "HTML",
            });
            this._buttonSendTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiButtonSendTypeXFDF"),
                value: "XFDF",
            });
            this._buttonSendTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiButtonSendTypePDF"),
                value: "PDF",
            });
        }
        return this._buttonSendTypes;
    }
    get barcodeTypes() {
        if (this._barcodeTypes.length === 0) {
            Enum.getValues(StiBarcodeType).forEach((t) => {
                let name = Enum.getName(StiBarcodeType, t);
                this._barcodeTypes.push({ name: name, value: name });
            });
        }
        return this._barcodeTypes;
    }
    get dateTimeTypes() {
        if (this._dateTimeTypes.length === 0) {
            this._dateTimeTypes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiDateTimeTypeDateAndTime"),
                value: "DateTime",
            });
            this._dateTimeTypes.push({ name: StiLocalizationService.get("FormFormatEditor", "Date"), value: "Date" });
            this._dateTimeTypes.push({ name: StiLocalizationService.get("FormFormatEditor", "Time"), value: "Time" });
        }
        return this._dateTimeTypes;
    }
    get penStyles() {
        if (this._penStyles.length === 0) {
            this._penStyles.push({ name: StiLocalizationService.get("PropertyEnum", "StiPenStyleSolid"), value: "Solid" });
            this._penStyles.push({ name: StiLocalizationService.get("PropertyEnum", "StiPenStyleDash"), value: "Dash" });
            this._penStyles.push({ name: StiLocalizationService.get("PropertyEnum", "StiPenStyleDot"), value: "Dot" });
        }
        return this._penStyles;
    }
    get dateTimeFormats() {
        if (this._dateTimeFormats.length === 0) {
            this._dateTimeFormats.push({ name: "m/d/yy h:MM tt", value: "m/d/yy h:MM tt" });
            this._dateTimeFormats.push({ name: "m/d/yyyy h:MM tt", value: "m/d/yyyy h:MM tt" });
            this._dateTimeFormats.push({ name: "m/d/yy HH:MM", value: "m/d/yy HH:MM" });
            this._dateTimeFormats.push({ name: "m/d/yyyy HH:MM", value: "m/d/yyyy HH:MM" });
            this._dateTimeFormats.push({ name: "m/d", value: "m/d" });
            this._dateTimeFormats.push({ name: "m/d/yy", value: "m/d/yy" });
            this._dateTimeFormats.push({ name: "m/d/yyyy", value: "m/d/yyyy" });
            this._dateTimeFormats.push({ name: "mm/dd/yy", value: "mm/dd/yy" });
            this._dateTimeFormats.push({ name: "mm/dd/yyyy", value: "mm/dd/yyyy" });
            this._dateTimeFormats.push({ name: "mm/yy", value: "mm/yy" });
            this._dateTimeFormats.push({ name: "mm/yyyy", value: "mm/yyyy" });
            this._dateTimeFormats.push({ name: "mmm-yy", value: "mmm-yy" });
            this._dateTimeFormats.push({ name: "mmm-yyyy", value: "mmm-yyyy" });
            this._dateTimeFormats.push({ name: "mmmm-yy", value: "mmmm-yy" });
            this._dateTimeFormats.push({ name: "mmmm-yyyy", value: "mmmm-yyyy" });
            this._dateTimeFormats.push({ name: "mmm d, yyyy", value: "mmm d, yyyy" });
            this._dateTimeFormats.push({ name: "mmmm d, yyyy", value: "mmmm d, yyyy" });
            this._dateTimeFormats.push({ name: "dd.mm.yyyy HH:MM", value: "dd.mm.yyyy HH:MM" });
            this._dateTimeFormats.push({ name: "d-mmm", value: "d-mmm" });
            this._dateTimeFormats.push({ name: "d-mmm-yy", value: "d-mmm-yy" });
            this._dateTimeFormats.push({ name: "d-mmm-yyyy", value: "d-mmm-yyyy" });
            this._dateTimeFormats.push({ name: "dd-mmm-yy", value: "dd-mmm-yy" });
            this._dateTimeFormats.push({ name: "dd-mmm-yyyy", value: "dd-mmm-yyyy" });
            this._dateTimeFormats.push({ name: "dd.mm.yyyy", value: "dd.mm.yyyy" });
            this._dateTimeFormats.push({ name: "yy-mm-dd", value: "yy-mm-dd" });
            this._dateTimeFormats.push({ name: "yyyy-mm-dd", value: "yyyy-mm-dd" });
            this._dateTimeFormats.push({ name: "HH:MM", value: "HH:MM" });
            this._dateTimeFormats.push({ name: "h:MM tt", value: "h:MM tt" });
            this._dateTimeFormats.push({ name: "HH:MM:ss", value: "HH:MM:ss" });
            this._dateTimeFormats.push({ name: "h:MM:ss tt", value: "h:MM:ss tt" });
        }
        return this._dateTimeFormats;
    }
    get dateFormats() {
        if (this._dateFormats.length === 0) {
            this._dateFormats.push({ name: "m/d", value: "m/d" });
            this._dateFormats.push({ name: "m/d/yy", value: "m/d/yy" });
            this._dateFormats.push({ name: "m/d/yyyy", value: "m/d/yyyy" });
            this._dateFormats.push({ name: "mm/dd/yy", value: "mm/dd/yy" });
            this._dateFormats.push({ name: "mm/dd/yyyy", value: "mm/dd/yyyy" });
            this._dateFormats.push({ name: "mm/yy", value: "mm/yy" });
            this._dateFormats.push({ name: "mm/yyyy", value: "mm/yyyy" });
            this._dateFormats.push({ name: "mmm-yy", value: "mmm-yy" });
            this._dateFormats.push({ name: "mmm-yyyy", value: "mmm-yyyy" });
            this._dateFormats.push({ name: "mmmm-yy", value: "mmmm-yy" });
            this._dateFormats.push({ name: "mmmm-yyyy", value: "mmmm-yyyy" });
            this._dateFormats.push({ name: "mmm d, yyyy", value: "mmm d, yyyy" });
            this._dateFormats.push({ name: "mmmm d, yyyy", value: "mmmm d, yyyy" });
            this._dateFormats.push({ name: "d-mmm", value: "d-mmm" });
            this._dateFormats.push({ name: "d-mmm-yy", value: "d-mmm-yy" });
            this._dateFormats.push({ name: "d-mmm-yyyy", value: "d-mmm-yyyy" });
            this._dateFormats.push({ name: "dd-mmm-yy", value: "dd-mmm-yy" });
            this._dateFormats.push({ name: "dd-mmm-yyyy", value: "dd-mmm-yyyy" });
            this._dateFormats.push({ name: "dd.mm.yyyy", value: "dd.mm.yyyy" });
            this._dateFormats.push({ name: "yy-mm-dd", value: "yy-mm-dd" });
            this._dateFormats.push({ name: "yyyy-mm-dd", value: "yyyy-mm-dd" });
        }
        return this._dateFormats;
    }
    get timeFormats() {
        if (this._timeFormats.length === 0) {
            this._timeFormats.push({ name: "HH:MM", value: "HH:MM" });
            this._timeFormats.push({ name: "h:MM tt", value: "h:MM tt" });
            this._timeFormats.push({ name: "HH:MM:ss", value: "HH:MM:ss" });
            this._timeFormats.push({ name: "h:MM:ss tt", value: "h:MM:ss tt" });
        }
        return this._timeFormats;
    }
    get signatureEditorModes() {
        if (this._signatureEditorModes.length === 0) {
            this._signatureEditorModes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiSignatureTypeType"),
                value: "Type",
            });
            this._signatureEditorModes.push({
                name: StiLocalizationService.get("PropertyEnum", "StiSignatureTypeDraw"),
                value: "Draw",
            });
        }
        return this._signatureEditorModes;
    }
    get signatureSpecialFonts() {
        if (this._signatureSpecialFonts.length === 0) {
            this._signatureSpecialFonts.push({
                name: `${StiLocalizationService.get("PropertyMain", "Style")}${1}`,
                value: "Teddy Bear",
            });
            this._signatureSpecialFonts.push({
                name: `${StiLocalizationService.get("PropertyMain", "Style")}${2}`,
                value: "MADE Likes Script",
            });
            this._signatureSpecialFonts.push({
                name: `${StiLocalizationService.get("PropertyMain", "Style")}${3}`,
                value: "Denistina",
            });
        }
        return this._signatureSpecialFonts;
    }
    get dateTimeValues() {
        if (this._dateTimeValues.length === 0) {
            this._dateTimeValues.push({
                name: StiLocalizationService.get("Gui", "colorpickerdialog_currentcolorlabel"),
                value: "Current",
            });
            this._dateTimeValues.push({
                name: StiLocalizationService.get("PropertyEnum", "DateTimePickerFormatCustom"),
                value: "Custom",
            });
        }
        return this._dateTimeValues;
    }
    get themes() {
        if (this._themes.length === 0) {
            this._themes.push({ name: "Light" });
            this._themes.push({ name: "Dark" });
        }
        return this._themes;
    }
    get borderWeights() {
        if (this._borderWeights.length === 0) {
            this._borderWeights.push({
                name: StiLocalizationService.get("PropertyEnum", "StiLineWeightThin"),
                value: "Thin",
            });
            this._borderWeights.push({
                name: StiLocalizationService.get("PropertyEnum", "StiLineWeightNormal"),
                value: "Normal",
            });
            this._borderWeights.push({
                name: StiLocalizationService.get("PropertyEnum", "StiLineWeightThick"),
                value: "Thick",
            });
        }
        return this._borderWeights;
    }
    get unitAlignment() {
        if (this._unitAlignment.length === 0) {
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentPrefix"),
                value: 1,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentSuffix"),
                value: 2,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentPrefixInside"),
                value: 3,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentPrefixInsideWithSpace"),
                value: 4,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentSuffixInside"),
                value: 5,
            });
            this._unitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentSuffixInsideWithSpace"),
                value: 6,
            });
        }
        return this._unitAlignment;
    }
    get minUnitAlignment() {
        if (this._minUnitAlignment.length === 0) {
            this._minUnitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentPrefix"),
                value: 1,
            });
            this._minUnitAlignment.push({
                name: StiLocalizationService.get("PropertyEnum", "StiUnitAlignmentSuffix"),
                value: 2,
            });
        }
        return this._minUnitAlignment;
    }
    get labelFormat() {
        if (this._labelFormat.length === 0) {
            this._labelFormat.push({ name: "Symbol", value: 1 });
            this._labelFormat.push({ name: "Code", value: 2 });
        }
        return this._labelFormat;
    }
    get thousandSeparators() {
        if (this._thousandSeparators.length === 0) {
            this._thousandSeparators.push({ name: "1234567.89", value: "None" });
            this._thousandSeparators.push({ name: "1234567,89", value: "NoneComma" });
            this._thousandSeparators.push({ name: "1,234,567.89", value: "Comma" });
            this._thousandSeparators.push({ name: "1.234.567,89", value: "Dot" });
            this._thousandSeparators.push({ name: "1`234`567.89", value: "Apostrophe" });
        }
        return this._thousandSeparators;
    }
    updateHelper() {
        this._minUnitAlignment = [];
        this._unitAlignment = [];
        this._borderWeights = [];
        this._dateTimeValues = [];
        this._penStyles = [];
        this._dateTimeTypes = [];
        this._buttonSendTypes = [];
        this._buttonTypes = [];
        this._signatureTypes = [];
        this._numberTypes = [];
    }
    deleteSelectedComponent() {
        let fromPanel = true;
        if (this.model.selectedComponent) {
            let container = this.model.getElementPage(this.model.selectedComponent.element) ??
                this.model.getElementPanel(this.model.selectedComponent.element);
            container.elements.splice(container.elements.indexOf(this.model.selectedComponent.element), 1);
            this.render.removeElement(this.model.selectedComponent.element, container.elements);
            this.model.selectedComponent = null;
            this.model.formEvents.next({ name: "ComponentDeleted" });
            this.model.cursor = "default";
        }
    }
    getElementClass(type) {
        if (type == "TextElement" || type == "Text") {
            return StiTextElement;
        }
        else if (type == "Text_BoxElement" || type == "TextBox") {
            return StiTextBoxElement;
        }
        else if (type == "TableElement" || type == "Table") {
            return StiTableElement;
        }
        else if (type == "Single_SelectionElement" || type == "SingleSelection") {
            return StiSingleSelectionElement;
        }
        else if (type == "SignatureElement" || type == "Signature") {
            return StiSignatureElement;
        }
        else if (type == "PDFSignatureElement" || type == "PDFSignature") {
            return StiPDFSignatureElement;
        }
        else if (type == "PanelElement" || type == "Panel") {
            return StiPanelElement;
        }
        else if (type == "Number_BoxElement" || type == "NumberBox") {
            return StiNumberBoxElement;
        }
        else if (type == "Multiple_SelectionElement" || type == "MultipleSelection") {
            return StiMultipleSelectionElement;
        }
        else if (type == "List_BoxElement" || type == "ListBox") {
            return StiListBoxElement;
        }
        else if (type == "LineElement" || type == "Line") {
            return StiLineElement;
        }
        else if (type == "LabelElement" || type == "Label") {
            return StiLabelElement;
        }
        else if (type == "ImageElement" || type == "Image") {
            return StiImageElement;
        }
        else if (type == "DateTime_BoxElement" || type == "DateTimeBox") {
            return StiDateTimeBoxElement;
        }
        else if (type == "Combo_BoxElement" || type == "ComboBox") {
            return StiComboBoxElement;
        }
        else if (type == "Check_BoxElement" || type == "CheckBox") {
            return StiCheckBoxElement;
        }
        else if (type == "ButtonElement" || type == "Button") {
            return StiButtonElement;
        }
        else if (type == "BarCodeElement" || type == "BarCode") {
            return StiBarcodeElement;
        }
        else if (type == "AddressElement" || type == "Address") {
            return StiAddressElement;
        }
        else if (type == "Page") {
            return StiFormPageElement;
        }
        else if (type == "Form") {
            return StiForm;
        }
        // return this.pageElement.getElementTypes()[type] ?? StiPanelElement;
    }
    clone(element) {
        let clazz = this.getElementClass(element.type);
        let result = new clazz();
        let jObject = new StiJson();
        jObject.deserialize(element.saveToJsonObject({}).serialize());
        result.loadFromJsonObject(jObject);
        result.guid = Guid.newGuid().toString();
        if ("displayValue" in element) {
            result["displayValue"] = element["displayValue"];
        }
        return result;
    }
    clonePage(page) {
        let result = new StiFormPageElement();
        let jObject = new StiJson();
        jObject.deserialize(page.saveToJsonObject({}).serialize());
        result.loadFromJsonObject(jObject);
        result.guid = Guid.newGuid().toString();
        return result;
    }
    get fileMenuItems() {
        if (this._fileMenuItems.length == 0) {
            this._fileMenuItems = [
                // { caption: StiLocalizationService.get("PropertyMain", "Info"), image: "assets/Images/Other/FileMenu/Home.png" },
                {
                    caption: StiLocalizationService.get("MainMenu", "menuFileNew").replace("&amp", "").replace(";", ""),
                    image: "images.Other.FileMenu.Report.png",
                    name: "New",
                },
                {
                    caption: StiLocalizationService.get("MainMenu", "menuFileOpen")
                        .replace("&amp", "")
                        .replace(";", "")
                        .replace("...", ""),
                    image: "images.Other.FileMenu.Folder.png",
                    name: "Open",
                },
                { name: "Divider" },
                {
                    caption: StiLocalizationService.get("MainMenu", "menuFileSave").replace("&amp", "").replace(";", ""),
                    name: "Save",
                },
                { caption: StiLocalizationService.get("MainMenu", "menuFileSaveAs").replace("...", ""), name: "SaveAs" },
                /*  { caption: StiLocalizationService.get("PropertyMain", "Share") },
                { caption: StiLocalizationService.get("PropertyMain", "Help") },
                { caption: StiLocalizationService.get("PropertyMain", "Close") }, */
                { name: "Divider" },
                /*  { caption: StiLocalizationService.get("PropertyMain", "Account") },
                { caption: StiLocalizationService.get("PropertyMain", "Options") }, */
                {
                    caption: StiLocalizationService.get("MainMenu", "menuHelpAboutProgramm")
                        .replace("&amp", "")
                        .replace(";", "")
                        .replace("...", ""),
                    name: "About",
                },
            ];
        }
        return this._fileMenuItems;
    }
    getAddTotalMenuItems() {
        let table = this.model.selectedComponent?.element;
        let this_ = this;
        if (!this.addTotalMenuItems && table?.columns?.length > 0) {
            this.addTotalMenuItems = [];
            let commands = [
                { name: this.loc.getP("Summary"), type: "Sum" },
                { name: this.loc.getP("Minimum"), type: "Min" },
                { name: this.loc.getP("Maximum"), type: "Max" },
                { name: this.loc.getP("Count"), type: "Count" },
            ];
            commands.forEach((command) => {
                let items = [];
                table.columns.forEach((column, index) => {
                    if (column instanceof StiNumberBoxColumnItem || column instanceof StiLabelColumnItem) {
                        items.push({
                            label: column.label,
                            command: () => {
                                this_.zone.run(() => {
                                    table.totalsFields.push(new StiTotalsFieldItem(command.type, `{${command.type}(Col(${index + 1}))}`));
                                    this.model.showColumnPreview(table.totalsFields.length - 1, "totals");
                                });
                            },
                        });
                    }
                });
                if (items.length > 0) {
                    this.addTotalMenuItems.push({ label: command.name, items: items });
                }
            });
            let items = [];
            table.columns.forEach((column, index) => {
                let rowItems = [];
                table.rowLabels.forEach((rowLabel, rowIndex) => {
                    rowItems.push({
                        label: rowLabel,
                        command: () => {
                            this_.zone.run(() => {
                                table.totalsFields.push(new StiTotalsFieldItem("Cell", `{Cell(${index + 1}, ${rowIndex + 1})}`));
                                this.model.showColumnPreview(table.totalsFields.length - 1, "totals");
                            });
                        },
                    });
                });
                items.push({
                    label: column.label,
                    items: rowItems,
                });
            });
            this.addTotalMenuItems.push({ label: this.loc.get2("PropertyCategory", "CellCategory"), items: items });
        }
        return this.addTotalMenuItems;
    }
    base64Encode(input) {
        if (input == null)
            return "";
        // Decode from UTF-8 text
        if (typeof unescape != "undefined") {
            input = unescape(encodeURIComponent(input));
        }
        else {
            input = input.replace(/\r\n/g, "\n");
            var utftext = "";
            for (var n = 0; n < input.length; n++) {
                var c = input.charCodeAt(n);
                if (c < 128) {
                    utftext += String.fromCharCode(c);
                }
                else if (c > 127 && c < 2048) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
                else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }
            }
            input = utftext;
        }
        // Encode to Base64 string
        if (typeof window.btoa != "undefined")
            return window.btoa(input);
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;
        while (i < input.length) {
            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);
            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;
            if (isNaN(chr2))
                enc3 = enc4 = 64;
            else if (isNaN(chr3))
                enc4 = 64;
            output =
                output +
                    this._keyStr.charAt(enc1) +
                    this._keyStr.charAt(enc2) +
                    this._keyStr.charAt(enc3) +
                    this._keyStr.charAt(enc4);
        }
        return output;
    }
    base64Decode(input) {
        if (input == null)
            return "";
        var output = "";
        // Decode from Base64 string
        if (typeof window.atob != "undefined") {
            output = window.atob(input);
        }
        else {
            var chr1, chr2, chr3;
            var enc1, enc2, enc3, enc4;
            var i = 0;
            input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            while (i < input.length) {
                enc1 = this._keyStr.indexOf(input.charAt(i++));
                enc2 = this._keyStr.indexOf(input.charAt(i++));
                enc3 = this._keyStr.indexOf(input.charAt(i++));
                enc4 = this._keyStr.indexOf(input.charAt(i++));
                chr1 = (enc1 << 2) | (enc2 >> 4);
                chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                chr3 = ((enc3 & 3) << 6) | enc4;
                output = output + String.fromCharCode(chr1);
                if (enc3 != 64) {
                    output = output + String.fromCharCode(chr2);
                }
                if (enc4 != 64) {
                    output = output + String.fromCharCode(chr3);
                }
            }
        }
        // Encode to UTF-8 string
        if (typeof escape != "undefined")
            return decodeURIComponent(escape(output));
        var string = "";
        var i = 0;
        var c = 0;
        var c1 = 0;
        var c2 = 0;
        var c3 = 0;
        while (i < output.length) {
            c = output.charCodeAt(i);
            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if (c > 191 && c < 224) {
                c2 = output.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = output.charCodeAt(i + 1);
                c3 = output.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }
        return string;
    }
}
StiHelperService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHelperService, deps: [{ token: i1.StiModelService }, { token: StiRectangleGeometryLayout }, { token: i2.StiLocalizationService }, { token: i0.NgZone }], target: i0.ɵɵFactoryTarget.Injectable });
StiHelperService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHelperService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHelperService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: StiRectangleGeometryLayout }, { type: i2.StiLocalizationService }, { type: i0.NgZone }]; } });
//# sourceMappingURL=data:application/json;base64,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