import { Injectable } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./sti-helper.service";
import * as i3 from "./sti-draggable.service";
import * as i4 from "./sti-name.service";
export class FormEventsService {
    constructor(model, helper, draggableService, nameService) {
        this.model = model;
        this.helper = helper;
        this.draggableService = draggableService;
        this.nameService = nameService;
    }
    get hasCopy() {
        return this.copiedComponent ? true : false;
    }
    static dateToJsonDate(date) {
        let offset = date.getTimezoneOffset() * -1;
        let hoursOffset = Math.abs(Math.floor(offset / 60)).toString();
        let minutesOffset = Math.abs(offset % 60).toString();
        if (hoursOffset.length == 1)
            hoursOffset = "0" + hoursOffset;
        if (minutesOffset.length == 1)
            minutesOffset = "0" + minutesOffset;
        return ("/Date(" + Date.parse(date.toString()).toString() + (offset >= 0 ? "+" : "-") + hoursOffset + minutesOffset + ")/");
    }
    get canCopy() {
        return this.model.selectedComponent?.element ? false : true;
    }
    get canMoveUp() {
        let state = true;
        this.model.form.pages.forEach((page, index) => {
            if (page === this.currentPage && index == 0) {
                state = false;
            }
        });
        return state;
    }
    get currentPage() {
        return this.model.selectedPage ? this.model.selectedPage : null;
    }
    get canMoveDown() {
        let state = true;
        this.model.form.pages.forEach((page, index) => {
            if (page === this.currentPage && index == this.model.form.pages.length - 1) {
                state = false;
            }
        });
        return state;
    }
    get canDelete() {
        return this.model?.form?.pages?.length > 1 ? true : false;
    }
    get canClear() {
        return this.currentPage.allElements.length > 0 ? true : false;
    }
    pasteComponent(event) {
        let copy = this.helper.clone(this.copiedComponent);
        copy.name = this.nameService.getComponentName(copy);
        this.draggableService.startDrag(event, copy, false, true);
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
    copyComponent() {
        this.copiedComponent = this.helper.clone(this.model.selectedComponent?.element);
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
    cutComponent() {
        this.copiedComponent = this.helper.clone(this.model.selectedComponent?.element);
        this.helper.deleteSelectedComponent();
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
    deleteComponent() {
        this.helper.deleteSelectedComponent();
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
    moveUp() {
        let index = this.model.form.pages.indexOf(this.currentPage);
        this.model.form.pages.splice(index, 1);
        this.model.form.pages.splice(index - 1, 0, this.currentPage);
        setTimeout(() => {
            let workspace = document.getElementsByTagName("sti-workspace")[0];
            workspace.scrollTop = workspace.scrollTop - (this.currentPage?.height + 20) * this.model.zoom;
        }, 0);
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
    moveDown() {
        let index = this.model.form.pages.indexOf(this.currentPage);
        this.model.form.pages.splice(index, 1);
        this.model.form.pages.splice(index + 1, 0, this.currentPage);
        setTimeout(() => {
            let workspace = document.getElementsByTagName("sti-workspace")[0];
            workspace.scrollTop = workspace.scrollTop + (this.currentPage?.height + 20) * this.model.zoom;
        }, 0);
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
    insertAfter() {
        let newPage = this.helper.clonePage(this.currentPage);
        newPage.elements = [];
        this.model.form.pages.splice(this.model.form.pages.indexOf(this.currentPage) + 1, 0, newPage);
        this.model.selectedPage = newPage;
        setTimeout(() => {
            let workspace = document.getElementsByTagName("sti-workspace")[0];
            workspace.scrollTop = workspace.scrollTop + (newPage.height + 20) * this.model.zoom;
        }, 0);
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
    insertBefore() {
        let newPage = this.helper.clonePage(this.currentPage);
        newPage.elements = [];
        this.model.form.pages.splice(this.model.form.pages.indexOf(this.currentPage), 0, newPage);
        this.model.selectedPage = newPage;
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
    clear() {
        this.currentPage.elements = [];
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
    delete() {
        this.model.showModalWindow = true;
        if (this.model.showContextMenu) {
            this.model.showContextMenu = false;
        }
    }
}
FormEventsService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FormEventsService, deps: [{ token: i1.StiModelService }, { token: i2.StiHelperService }, { token: i3.StiDraggableService }, { token: i4.StiNameService }], target: i0.ɵɵFactoryTarget.Injectable });
FormEventsService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FormEventsService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: FormEventsService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHelperService }, { type: i3.StiDraggableService }, { type: i4.StiNameService }]; } });
//# sourceMappingURL=data:application/json;base64,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