import { Injectable } from "@angular/core";
import { StiButtonElement } from "../elements/StiButtonElement";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class StiFormCheckerService {
    constructor(model) {
        this.model = model;
        this.showFormCheckerWindow = false;
        this.formMessages = [];
        this.buttonNames = "";
        this.componentWidth = 700;
        this.componentHeight = 482;
        this.currentPressedButton = "";
        this.issuesCount = 1;
        let newItem = {
            type: "warning",
            label: "Form not saved in Stimulsoft Cloud",
            content: "To submit the form data to the Stimulsoft server, you can use the Submit button {0} on the form. Once the data is sent, you will be able to view all submissions for that particular form. To ensure that the data is processed correctly, it is important to save the form to the cloud. You can modify the URL of the Stimulsoft Cloud button.",
        };
        this.formMessages.push(newItem);
        window.onresize = (event) => {
            if (window.innerWidth > this.componentWidth) {
                if (window.innerWidth < this.componentX + this.componentWidth) {
                    this.componentX = (window.innerWidth - this.componentWidth) / 2;
                }
            }
            else {
                this.componentX = 0;
            }
            if (window.innerHeight > this.componentHeight) {
                if (window.innerHeight < this.componentY + this.componentHeight) {
                    this.componentY = (window.innerHeight - this.componentHeight) / 2;
                }
            }
            else {
                this.componentY = 0;
            }
        };
    }
    isRibbonWithPreview(ribbon) {
        return ribbon == "Preview" || ribbon == "PDFPreview";
    }
    haveStiCloudSubmitButton() {
        let state = false;
        this.model.form?.pages.forEach((page) => {
            page.allElements.forEach((element) => {
                if (element instanceof StiButtonElement &&
                    (element.formSendURL?.trim().toLocaleLowerCase() == "stimulsoft cloud" ||
                        element.formSendURL?.trim().toLocaleLowerCase() == "cloud.stimulsoft.com")) {
                    state = true;
                }
            });
        });
        return state;
    }
    needToDisplayFormsChecker() {
        return (this.haveStiCloudSubmitButton() && (this.model.form.versionKey == null || this.model.form.versionKey.length == 0));
    }
    check(ribbon) {
        let state = (this.model.isWebView || this.model.isCloudMode) && this.needToDisplayFormsChecker();
        if (state) {
            // this.hasIssue = true;
            // this.currentPressedButton = ribbon;
            // this.displayFormsChecker(ribbon);
        }
        return true;
    }
    get hasIssue() {
        return ((this.model.isWebView || this.model.isCloudMode) && this.needToDisplayFormsChecker() && !this.model.isPreviewMode);
    }
    displayFormsChecker() {
        this.showFormCheckerWindow = true;
    }
    updateFormAfterSaving(form) {
        if (form) {
            if (typeof form != "boolean") {
                this.model.setFormFromString(JSON.stringify(form));
            }
            this.showFormCheckerWindow = false;
            this.model.saveLastFormState();
            this.model.saveSettings();
            this.model.formEvents.next({ name: this.model.currentRibbonValue });
        }
    }
    getButtonNames() {
        let buttonElements = [];
        this.model.form?.pages.forEach((page) => {
            page.allElements.forEach((element) => {
                if (element.type == "ButtonElement" &&
                    element.formSendURL?.trim().toLocaleLowerCase() == "stimulsoft cloud") {
                    buttonElements.push(element.name);
                }
            });
        });
        this.buttonNames = buttonElements.join().length > 0 ? "(" + buttonElements.join() + ")" : "";
    }
}
StiFormCheckerService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFormCheckerService, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable });
StiFormCheckerService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFormCheckerService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFormCheckerService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; } });
//# sourceMappingURL=data:application/json;base64,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