import { Injectable } from "@angular/core";
import { StiUsedFontsList } from "./objects";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./http-client.service";
export class StiFontService {
    constructor(model, httpService) {
        this.model = model;
        this.httpService = httpService;
        this.checkedFonts = new StiUsedFontsList();
        model.formEvents.subscribe((e) => {
            if (this.model.getBrowserType() != "firefox") {
                if (e.name == "SetForm") {
                    this.checkFonts();
                }
                else if (e.name == "UpdateFonts") {
                    this.updateFonts(e.value);
                }
            }
        });
    }
    loadFont(fonts) {
        if (fonts.length > 0) {
            fonts.forEach((font) => {
                this.checkedFonts.add(font.fontFamily, font.fontStyle, font.fontSize);
            });
            this.httpService
                .post(this.model.requestUrl, { action: "GetFonts", fonts: fonts }, "json", { showProgress: false })
                .subscribe((data) => {
                if (typeof data != "string") {
                    data?.forEach((item) => {
                        let style = document.createElement("style");
                        let cssText = "@font-face {\r\n" +
                            "font-family: '" +
                            item.originalFontFamily +
                            "';\r\n" +
                            "font-weight: '" +
                            item.originalFontWeight +
                            "';\r\n" +
                            "font-style: '" +
                            item.originalFontStyle +
                            "';\r\n" +
                            "src: url(" +
                            item.contentForCss +
                            ");\r\n }";
                        style.innerHTML = cssText;
                        style.id = item.originalFontFamily;
                        let head = document.getElementsByTagName("head")[0];
                        head.appendChild(style);
                    });
                }
            });
        }
    }
    checkFonts() {
        let usedFonts = new StiUsedFontsList();
        this.model.form.pages.forEach((page) => {
            page.allElements.forEach((element) => {
                element.getUsedFonts(usedFonts);
            });
        });
        let forceLoad = document.fonts.check("12px Dummy font name");
        let fontsToLoad = usedFonts.fonts.filter((f) => this.checkedFonts.fonts.indexOf(f) == -1 &&
            (forceLoad || !document?.fonts.check(f.fontStyle + " " + f.fontSize + "px '" + f.fontFamily + "'")));
        this.loadFont(fontsToLoad);
    }
    updateFonts(font) {
        let isChecked = this.checkedFonts.fonts.find((f) => f.fontFamily == font.fontFamily && f.fontSize == font.fontSize && f.fontStyle == font.fontStyle);
        if (!isChecked &&
            !document?.fonts?.check((font?.fontStyle ? font?.fontStyle : "") +
                " " +
                (font?.fontSize ? font?.fontSize : 12) +
                "px '" +
                (font?.fontFamily ? font?.fontFamily : "Arial") +
                "'")) {
            let fontToLoad = [];
            fontToLoad.push(font);
            this.loadFont(fontToLoad);
        }
    }
}
StiFontService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFontService, deps: [{ token: i1.StiModelService }, { token: i2.StiHttpClientService }], target: i0.ɵɵFactoryTarget.Injectable });
StiFontService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFontService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiFontService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHttpClientService }]; } });
//# sourceMappingURL=data:application/json;base64,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