import { Injectable } from "@angular/core";
import { Subject } from "rxjs";
import { StiFormElement } from "../elements/base/StiFormElement";
import { StiLabelElement } from "../elements/StiLabelElement";
import { StiTableElement } from "../elements/StiTableElement";
import { StiLabelColumnItem } from "../elements/table/columns/StiLabelColumnItem";
import { StiColumnItem } from "../elements/table/StiColumnItem";
import { StiTotalsFieldItem } from "../elements/table/StiTotalsFieldItem";
import { StiRowLabel } from "../elements/table/StiRowLabel";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./mouse.service";
import * as i3 from "@angular/common";
export class StiExpressionService {
    constructor(model, mouseService, datePipe) {
        this.model = model;
        this.mouseService = mouseService;
        this.datePipe = datePipe;
        this.started = false;
        this.status = {};
        this.componentWidth = 700;
        this.componentHeight = 482;
        this.needToAddExpression = new Subject();
        this.expressionPreviewString = "";
        this.isDragging = false;
        window.onresize = (event) => {
            if (window.innerWidth > this.componentWidth) {
                if (window.innerWidth < this.componentX + this.componentWidth) {
                    this.componentX = (window.innerWidth - this.componentWidth) / 2;
                }
            }
            else {
                this.componentX = 0;
            }
            if (window.innerHeight > this.componentHeight) {
                if (window.innerHeight < this.componentY + this.componentHeight) {
                    this.componentY = (window.innerHeight - this.componentHeight) / 2;
                }
            }
            else {
                this.componentY = 0;
            }
        };
        this.mouseService.getDocumentMouseMove().subscribe((event) => {
            this.moveContainer(event);
        });
        this.mouseService.getDocumentMouseUp().subscribe((event) => {
            this.endContainerDrag(event);
        });
    }
    getExpressionString(startItem) {
        let expressionObject = { previewString: "", startObject: null, lastCaretOffset: 1 };
        expressionObject.startObject = startItem;
        if (typeof startItem.object == "string") {
            if (startItem.object.length == 1) {
                expressionObject.previewString = startItem.object;
            }
            else {
                let string = "";
                if (startItem.object.toLowerCase() == "value") {
                    string = startItem.object + `('')`;
                }
                else if (startItem.object.toLowerCase() == "line" ||
                    startItem.object.toLowerCase() == "today" ||
                    startItem.object.toLowerCase() == "time") {
                    string = startItem.object;
                }
                else if (startItem.object.toLowerCase() == "cell") {
                    string = startItem.object + "(,,'')";
                }
                else if (startItem.object.toLowerCase() == "total" ||
                    startItem.object.toLowerCase() == "col" ||
                    startItem.object.toLowerCase() == "row") {
                    string = startItem.object + "(,'')";
                }
                else {
                    string = startItem.object + "()";
                }
                expressionObject.previewString = string;
            }
        }
        else {
            if (startItem.object instanceof StiFormElement) {
                expressionObject.previewString = `Value('${startItem.object.name}')`;
            }
            else {
                if (startItem.object instanceof StiTotalsFieldItem) {
                    expressionObject.previewString = `Total(${startItem.object.eParent.totalsFields.indexOf(startItem.object) + 1},'${startItem.object.eParent.name}')`;
                }
                else if (startItem.object instanceof StiColumnItem && !startItem.isCell) {
                    expressionObject.previewString = `Col(${startItem.object.eParent.columns.indexOf(startItem.object) + 1},'${startItem.object.eParent.name}')`;
                }
                else {
                    expressionObject.previewString = `Cell(${startItem.object.eParent.columns.indexOf(startItem.object) + 1},${startItem.index},'${startItem.object.eParent.name}')`;
                }
            }
        }
        return expressionObject;
    }
    startContainerDrag(object) {
        this.startExpressionDraggingX = object.event.clientX;
        this.startExpressionDraggingY = object.event.clientY;
        this.draggableExpressionObject = this.getExpressionString(object);
        this.isDragging = true;
        let elem = this.elementRef.nativeElement;
        elem.focus();
    }
    moveContainer(event) {
        if (this.isDragging) {
            event.preventDefault();
            let elements = document.elementsFromPoint(event.clientX, event.clientY);
            if (elements.find((elem) => elem.classList.contains("expression-preview"))) {
                let currentRange;
                if (document.caretRangeFromPoint) {
                    currentRange = document.caretRangeFromPoint(event.clientX, event.clientY);
                }
                else {
                    let sel = window.getSelection();
                    sel.collapse(event.rangeParent, event.rangeOffset);
                    currentRange = sel.getRangeAt(0);
                }
                this.currentCarretOffset = currentRange.startOffset;
                setTimeout(() => {
                    var range = document.createRange();
                    var sel = window.getSelection();
                    if (this.elementRef.nativeElement.childNodes[0]) {
                        range?.setStart(this.elementRef.nativeElement.childNodes[0], this.currentCarretOffset);
                        range?.collapse(true);
                        sel.removeAllRanges();
                        sel.addRange(range);
                        this.draggableExpressionObject.lastCaretOffset = this.currentCarretOffset;
                    }
                });
            }
            let deltaX = event.clientX - this.startExpressionDraggingX;
            let deltaY = event.clientY - this.startExpressionDraggingY;
            if (this.startExpressionDraggingX - 10 + deltaX < 0) {
                this.expressionDraggableContainerX = 0;
            }
            else if (this.startExpressionDraggingX - 10 + deltaX >
                window.innerWidth - this.elementRef?.nativeElement.clientWidth) {
                this.expressionDraggableContainerX = window.innerWidth - this.elementRef?.nativeElement.clientWidth;
            }
            else {
                this.expressionDraggableContainerX = this.startExpressionDraggingX - 10 + deltaX;
            }
            if (this.startExpressionDraggingY - 10 + deltaY < 0) {
                this.expressionDraggableContainerY = 0;
            }
            else if (this.startExpressionDraggingY - 10 + deltaY >
                window.innerHeight - this.elementRef?.nativeElement.clientHeight) {
                this.expressionDraggableContainerY = window.innerHeight - this.elementRef?.nativeElement.clientHeight;
            }
            else {
                this.expressionDraggableContainerY = this.startExpressionDraggingY - 10 + deltaY;
            }
        }
    }
    endContainerDrag(event) {
        if (this.isDragging) {
            if (document
                .elementsFromPoint(event.clientX, event.clientY)
                .find((element) => element.classList.contains("expression-preview"))) {
                this.needToAddExpression.next(this.draggableExpressionObject);
            }
            this.isDragging = false;
            this.draggableExpressionObject = null;
        }
    }
    getCaretOffset(element) {
        let caretOffset = 0;
        let doc = element.ownerDocument || element.document;
        let win = doc.defaultView || doc.parentWindow;
        let sel;
        if (typeof win.getSelection != "undefined") {
            sel = win.getSelection();
            if (sel.rangeCount > 0) {
                let range = win.getSelection().getRangeAt(0);
                let preCaretRange = range.cloneRange();
                preCaretRange.selectNodeContents(element);
                preCaretRange.setEnd(range.endContainer, range.endOffset);
                caretOffset = preCaretRange.toString().length;
            }
        }
        else if ((sel = doc.selection) && sel.type != "Control") {
            let textRange = sel.createRange();
            let preCaretTextRange = doc.body.createTextRange();
            preCaretTextRange.moveToElementText(element);
            preCaretTextRange.setEndPoint("EndToEnd", textRange);
            caretOffset = preCaretTextRange.text.length;
        }
        return caretOffset;
    }
    start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.model.formEvents.subscribe((e) => {
            if (e.name == "ValueChanged" || e.name == "ComponentDeleted" || e.name == "SetForm" || e.name == "UpdateForm") {
                setTimeout(() => {
                    this.calculate();
                }, 0);
            }
        });
    }
    calculate() {
        let elements = {};
        this.model.form.pages.forEach((p) => p.allElements.forEach((e) => {
            if (e instanceof StiTableElement) {
                let table = e;
                table.columns.forEach((c, colIndex) => {
                    if (c instanceof StiLabelColumnItem) {
                        let label = c;
                        label.cells.forEach((c, rowIndex) => {
                            this.exec(label, elements, table, colIndex, rowIndex);
                        });
                    }
                });
                table.totalsFields.forEach((t, index) => {
                    let total = t;
                    this.exec(total, elements, table, null, null, index);
                });
                table.rowLabelsContentEditable.forEach((r, index) => {
                    let row = r;
                    this.exec(row, elements, table, null, index);
                });
            }
            else if (e instanceof StiLabelElement) {
                let label = e;
                this.exec(label, elements);
            }
        }));
    }
    getElementName(element, row) {
        if (element instanceof StiTotalsFieldItem ||
            element instanceof StiLabelColumnItem ||
            element instanceof StiRowLabel) {
            let tables = [];
            this.model.form.pages.forEach((p) => p.allElements.forEach((e) => {
                if (e instanceof StiTableElement) {
                    tables.push(e);
                }
            }));
            let table = tables.find((t) => t.totalsFields?.indexOf(element) >= 0 ||
                t.columns?.indexOf(element) >= 0 ||
                t.rowLabelsContentEditable?.indexOf(element) >= 0);
            if (element instanceof StiRowLabel) {
                return `${table.name}.Row.${row}`;
            }
            if (element instanceof StiTotalsFieldItem) {
                return `${table.name}.0.0.${table.totalsFields.indexOf(element)}`;
            }
            else {
                return `${table.name}.${table.columns?.indexOf(element)}.${row}`;
            }
        }
        else {
            return element.name;
        }
    }
    exec(element, elements, table, col, row, total) {
        let elName = this.getElementName(element, row);
        if (elements[elName] || !("expression" in element)) {
            return;
        }
        else if (this.haveExpression(element)) {
            try {
                elements[elName] = true;
                let this_ = this;
                let Value = function (elementName) {
                    let el = this_.findElement(elementName);
                    if (el) {
                        this_.exec(el, elements);
                        return el.value;
                    }
                    return null;
                };
                let Sum = function (elements) {
                    let sum = 0;
                    try {
                        elements.forEach((element) => {
                            if (this_.isNumber(element)) {
                                sum += element;
                            }
                        });
                    }
                    catch { }
                    return sum;
                };
                let Line = function () {
                    try {
                        return row + 1;
                    }
                    catch {
                        return 0;
                    }
                };
                let Today = function () {
                    try {
                        let value = this_.datePipe.transform(new Date(), this_.model.formattingDate(this_.model.form.settings.dateFormat));
                        return value;
                    }
                    catch {
                        return null;
                    }
                };
                let Time = function () {
                    try {
                        let value = this_.datePipe.transform(new Date(), this_.model.formattingDate(this_.model.form.settings.timeFormat));
                        return value;
                    }
                    catch {
                        return null;
                    }
                };
                let Max = function (elements) {
                    let res;
                    try {
                        elements.forEach((element) => {
                            if (this_.isNumber(element)) {
                                if (res == null) {
                                    res = element;
                                }
                                res = Math.max(element, res);
                            }
                        });
                    }
                    catch { }
                    return res;
                };
                let Min = function (elements) {
                    let res;
                    try {
                        elements.forEach((element) => {
                            if (this_.isNumber(element)) {
                                if (res == null) {
                                    res = element;
                                }
                                res = Math.min(element, res);
                            }
                        });
                    }
                    catch { }
                    return res;
                };
                let Total = function (index, tableName) {
                    try {
                        let curTable = tableName ? this_.model.form.getElementByName(tableName) : table;
                        let total = typeof index == "number"
                            ? curTable.totalsFields[index - 1]
                            : curTable.totalsFields.find((t) => t.header == index);
                        this_.exec(total, elements, curTable, null, null, index);
                        return total.value;
                    }
                    catch { }
                };
                let Count = function (elements) {
                    try {
                        return elements.length;
                    }
                    catch {
                        return 0;
                    }
                };
                let Col = function (name, tableName) {
                    try {
                        let curTable = tableName ? this_.model.form.getElementByName(tableName) : table;
                        let column = this_.isNumber(name)
                            ? curTable.columns[name - 1]
                            : curTable.columns.find((c) => c.label.toLowerCase() == name.toLowerCase());
                        let result = [];
                        column["cells"].forEach((cell, index) => {
                            try {
                                this_.exec(column, elements, curTable, curTable.columns.indexOf(column), index);
                                result.push(cell["value"] != undefined ? cell.value : cell);
                            }
                            catch {
                                result.push(undefined);
                            }
                        });
                        return row != null ? result[row] : result;
                    }
                    catch { }
                };
                let Row = function (name, tableName) {
                    try {
                        let curTable = tableName ? this_.model.form.getElementByName(tableName) : table;
                        let rowIndex = this_.isNumber(name)
                            ? name - 1
                            : curTable.rowLabels.findIndex((value) => value.toLowerCase() == name.toLowerCase());
                        let result = [];
                        curTable.columns.forEach((ccol, index) => {
                            try {
                                let cell = ccol["cells"][rowIndex];
                                if (typeof cell == "number") {
                                    result.push(cell);
                                }
                                else {
                                    this_.exec(cell, elements, curTable, index, rowIndex);
                                    result.push(cell["value"] != undefined ? cell.value : cell);
                                }
                            }
                            catch {
                                result.push(undefined);
                            }
                        });
                        return col != null ? result[col] : result;
                    }
                    catch { }
                };
                let Cell = function (colIndex, rowIndex, tableName) {
                    try {
                        let curTable = tableName ? this_.model.form.getElementByName(tableName) : table;
                        let ccol = this_.isNumber(colIndex)
                            ? curTable.columns[colIndex - 1]
                            : curTable.columns.find((c) => c.label == colIndex);
                        let curRowIndex = this_.isNumber(rowIndex)
                            ? rowIndex - 1
                            : curTable.rowLabels.findIndex((value) => value.toLowerCase() == rowIndex.toLowerCase());
                        let cell = ccol["cells"][curRowIndex];
                        this_.exec(cell["value"] != undefined ? cell : ccol, elements, curTable, colIndex, rowIndex);
                        return cell["value"] != undefined ? cell.value : cell;
                    }
                    catch { }
                };
                let regex = /(\{.+?\})/g;
                let exp = element["expression"];
                let exec;
                let displayValue = exp;
                while ((exec = regex.exec(exp)) !== null) {
                    let value = this.isSystemVariables(exec[0]) ? eval(this.replaceSystemVariables(exec[0])) : eval(exec[0]);
                    if (element instanceof StiRowLabel) {
                        value = value;
                    }
                    else {
                        value = typeof value == "function" ? "" : value;
                        value = Number.isNaN(value) || value === undefined ? exec[0] : value;
                    }
                    if (element instanceof StiLabelColumnItem) {
                        element.cells[row] = value;
                    }
                    else if (element instanceof StiRowLabel) {
                        element.value = exec.input;
                    }
                    else {
                        element.value = value;
                    }
                    if (this_.isNumber(value) && !this_.isSystemVariables(exec[0])) {
                        let formattedElement = element instanceof StiLabelElement ? this_.model.form.settings : element;
                        value = this_.model.getFormattedValue(formattedElement, value);
                    }
                    displayValue = displayValue.replace(exec[0], Number.isNaN(value) || value === undefined ? exec[0] : value);
                    if (exec.index > 1 &&
                        !(element instanceof StiLabelElement) &&
                        !(element instanceof StiRowLabel)) {
                        if (element instanceof StiLabelColumnItem) {
                            element.cells[row] = displayValue;
                        }
                        else {
                            element.value = displayValue;
                        }
                    }
                }
                if (element instanceof StiLabelElement || element instanceof StiRowLabel) {
                    element.displayValue = displayValue;
                }
            }
            catch {
                this.resetValue(element, row, element["expression"]);
            }
        }
        else {
            this.resetValue(element, row, element["expression"]);
        }
    }
    replaceSystemVariables(expressionString) {
        let value = expressionString.replace(/\s/g, "").toLowerCase();
        let startIndex;
        let slicedValue;
        if (value.indexOf("line") != -1) {
            startIndex = value.indexOf("line");
        }
        else if (value.indexOf("today") != -1) {
            startIndex = value.indexOf("today");
        }
        else {
            startIndex = value.indexOf("time");
        }
        if (value.slice(startIndex, startIndex + 5) == "today") {
            slicedValue = value.slice(startIndex, startIndex + 5);
        }
        else {
            slicedValue = value.slice(startIndex, startIndex + 4);
        }
        let valueForReplace = slicedValue.split();
        valueForReplace.push("(");
        valueForReplace.push(")");
        let resultString = valueForReplace.join().replace(/,/g, "");
        resultString = resultString[0].toUpperCase() + resultString.slice(1);
        return value.replace(slicedValue, resultString);
    }
    resetValue(element, row, expression) {
        if (element instanceof StiLabelElement) {
            element.displayValue = undefined;
            element.value = null;
        }
        else {
            let value = this.haveExpression(element) && expression?.toString() == parseFloat(expression).toString()
                ? parseFloat(expression)
                : expression?.toString() == parseFloat(expression).toString()
                    ? parseFloat(expression)
                    : expression;
            if (element instanceof StiLabelColumnItem) {
                element.cells[row] = value;
            }
            else {
                element.value = value;
            }
        }
    }
    isNumber(value) {
        return typeof value === "number" && !isNaN(value);
    }
    haveExpression(element) {
        let str = element["expression"];
        let regex = /(\{.+?\})/g;
        let regex2 = /^\{.+?\}$/g;
        return element instanceof StiLabelElement || element instanceof StiRowLabel
            ? regex.test(str)
            : (element instanceof StiTotalsFieldItem || element instanceof StiLabelColumnItem) && regex2.test(str);
    }
    isSystemVariables(string) {
        let value = string.replace(/\s/g, "");
        return (value.toLowerCase().indexOf("line") != -1 ||
            value.toLowerCase().indexOf("today") != -1 ||
            value.toLowerCase().indexOf("time") != -1);
    }
    findElement(name) {
        let el;
        this.model.form.pages.forEach((p) => p.allElements.forEach((e) => {
            if (e.name == name) {
                el = e;
            }
        }));
        return el;
    }
}
StiExpressionService.MOUSE_DELTA = 3;
StiExpressionService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiExpressionService, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }, { token: i3.DatePipe }], target: i0.ɵɵFactoryTarget.Injectable });
StiExpressionService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiExpressionService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiExpressionService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiMouseService }, { type: i3.DatePipe }]; } });
//# sourceMappingURL=data:application/json;base64,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