import { Injectable } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class StiEditableContentService {
    constructor(model) {
        this.model = model;
        this.activeControl = false;
    }
    getIntEditableContent() {
        return this._editableContent;
    }
    get editableContent() {
        return this._editableContent || this.model.selectedComponent?.element?.getDefaultEditableContent();
    }
    set editableContent(value) {
        this._editableContent = value;
    }
    startEdit(editableElementRef = null) {
        editableElementRef = editableElementRef ?? this.editableElementRef;
        if (editableElementRef) {
            let caretOffset = this.getCaretOffset(editableElementRef.nativeElement ?? editableElementRef);
            this.activeControl = true;
            setTimeout(() => {
                this.activeControl = false;
                let el = editableElementRef.nativeElement ?? editableElementRef;
                el.focus();
                if (el.tagName.toLowerCase() != "label" && el?.innerText?.length > 0) {
                    this.setCaret(el, caretOffset);
                }
            }, 0);
        }
    }
    getCaretOffset(element) {
        let caretOffset = 0;
        let doc = element.ownerDocument || element.document;
        let win = doc.defaultView || doc.parentWindow;
        let sel;
        if (typeof win.getSelection != "undefined") {
            sel = win.getSelection();
            if (sel.rangeCount > 0) {
                let range = win.getSelection().getRangeAt(0);
                let preCaretRange = range.cloneRange();
                preCaretRange.selectNodeContents(element);
                preCaretRange.setEnd(range.endContainer, range.endOffset);
                caretOffset = preCaretRange.toString().length;
            }
        }
        else if ((sel = doc.selection) && sel.type != "Control") {
            let textRange = sel.createRange();
            let preCaretTextRange = doc.body.createTextRange();
            preCaretTextRange.moveToElementText(element);
            preCaretTextRange.setEndPoint("EndToEnd", textRange);
            caretOffset = preCaretTextRange.text.length;
        }
        return caretOffset;
    }
    setCaret(el, caretOffset) {
        var range = document.createRange();
        var sel = window.getSelection();
        range.setStart(el.childNodes[0], caretOffset);
        range.collapse(true);
        sel.removeAllRanges();
        sel.addRange(range);
    }
}
StiEditableContentService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiEditableContentService, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable });
StiEditableContentService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiEditableContentService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiEditableContentService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; } });
//# sourceMappingURL=data:application/json;base64,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