import { Injectable } from "@angular/core";
import StiRectangleGeometryLayout from "../computed/StiRectangleGeometryLayout";
import { StiAddressElement } from "../elements/StiAddressElement";
import { StiButtonElement } from "../elements/StiButtonElement";
import { StiDragPreviewElement } from "../elements/StiDragPreviewElement";
import { StiLabelElement } from "../elements/StiLabelElement";
import StiLineElement from "../elements/StiLineElement";
import { StiPanelElement } from "../elements/StiPanelElement";
import { StiSignatureElement } from "../elements/StiSignatureElement";
import { StiTableElement } from "../elements/StiTableElement";
import Guid from "../system/Guid";
import * as i0 from "@angular/core";
import * as i1 from "./mouse.service";
import * as i2 from "./model.service";
import * as i3 from "./sti-name.service";
import * as i4 from "./sti-helper.service";
import * as i5 from "./sti-changes-service";
export class StiDraggableService {
    constructor(mouseService, resolver, model, nameService, helper, render, changesService) {
        this.mouseService = mouseService;
        this.resolver = resolver;
        this.model = model;
        this.nameService = nameService;
        this.helper = helper;
        this.render = render;
        this.changesService = changesService;
        this.newElement = true;
        this.dragPreview = new StiDragPreviewElement();
        mouseService.getDocumentMouseMove().subscribe((event) => {
            this.drag(event);
        });
        mouseService.getDocumentMouseUp().subscribe((event) => {
            this.endDrag(event);
        });
    }
    drag(event) {
        if (this.model.draggingElement) {
            let bottomPage = this.model.getPageFromPoint(event.clientX, event.clientY);
            if (this.model.lastUsedPage != bottomPage && bottomPage != null && bottomPage != undefined) {
                this.model.lastUsedPage = bottomPage;
            }
            this.model.cursor = bottomPage ? "move" : "not-allowed";
            this.left = event.clientX - this.startX;
            this.top = event.clientY - this.startY;
            if (this.newElement) {
                if (bottomPage) {
                    if (this.model.draggingElement instanceof StiTableElement ||
                        this.model.draggingElement instanceof StiLineElement ||
                        this.model.draggingElement instanceof StiPanelElement) {
                        this.model.draggingElement.width = this.model.lastUsedPage.contentAreaWidth;
                    }
                    else if (this.model.draggingElement instanceof StiButtonElement) {
                        this.model.draggingElement.width =
                            this.model.lastUsedPage.contentAreaWidth / this.model.form.settings.gridColumns > 1
                                ? Math.round(this.model.form.settings.gridColumns * 0.2)
                                : 1;
                    }
                    else {
                        this.model.draggingElement.width =
                            this.model.lastUsedPage.contentAreaWidth / this.model.form.settings.gridColumns > 1
                                ? Math.round(this.model.form.settings.gridColumns * 0.4)
                                : 1;
                    }
                }
                else {
                    //this.model.draggingElement.width = 0; ???
                }
            }
            this.moveDragPreview(event);
        }
    }
    endDrag(event) {
        if (this.model.draggingElement) {
            let page = this.model.getElementPage(this.dragPreview);
            let panel = this.model.getElementPanel(this.dragPreview);
            let elements = page ? page?.elements : panel?.elements;
            this.model.draggingElement.x = this.dragPreview.x;
            this.model.draggingElement.y = this.dragPreview.y;
            this.model.draggingElement.width = this.dragPreview.width;
            if (elements) {
                if (this.model.draggingElement instanceof StiLabelElement) {
                    elements.splice(elements.indexOf(this.dragPreview), 1);
                    elements.splice(0, 0, this.model.draggingElement);
                }
                else {
                    elements.splice(elements.indexOf(this.dragPreview), 1, this.model.draggingElement);
                }
                if (this.newElement) {
                    this.model.draggingElement.guid = Guid.newGuid().toString();
                    this.model.draggingElement.name = this.nameService.getComponentName(this.model.draggingElement);
                    this.model.draggingElement.hasGeometry = true;
                }
                this.model.draggingElement.position = "absolute";
                this.model.draggingElement.needToSelectComponent = true;
                this.model.draggingElement.isAdded = true;
                if (this.model.draggingElement instanceof StiTableElement) {
                    this.model.currentTablePropertyHeader.next("Table");
                }
            }
            else {
                if (!this.model.overToolbar(event.clientX, event.clientY) && !this.newElement) {
                    this.model.lastUsedPage.elements.push(this.currentUsableElement);
                    this.render.insertElement(this.currentUsableElement);
                }
                else {
                    this.render.removeElement(this.model.draggingElement, this.model.lastUsedPage.elements);
                    this.model.selectedComponent = null;
                }
            }
            this.render.checkOutputs(this.model.getElementPage(this.model.draggingElement));
            this.model.cursor = "default";
            this.model.draggingElement = null;
            this.model.pageWithGrid = null;
            this.newElement = false;
        }
    }
    addingByDoubleClick(element) {
        element.hasGeometry = false;
        element.position = "absolute";
        element.guid = Guid.newGuid().toString();
        let columnWidth = this.model.lastUsedPage.getColumnWidth(this.model.form.settings.gridColumns);
        if (element instanceof StiTableElement || element instanceof StiLineElement || element instanceof StiPanelElement) {
            element.width = this.model.lastUsedPage.contentAreaWidth;
        }
        else if (element instanceof StiButtonElement) {
            element.width = Number((columnWidth *
                (this.model.form.settings.gridColumns > 1 ? Math.round(this.model.form.settings.gridColumns * 0.2) : 1)).toFixed(2));
        }
        else {
            element.width = Number((columnWidth *
                (this.model.form.settings.gridColumns > 1 ? Math.round(this.model.form.settings.gridColumns * 0.4) : 1)).toFixed(2));
        }
        element.name = this.nameService.getComponentName(element);
        element.needToSelectComponent = true;
        element.isAdded = true;
        let lastPage = this.model.form.pages[this.model.form.pages.length - 1];
        element.x = 0;
        element.y = lastPage.contentAreaHeight - element.height;
        if (element instanceof StiLabelElement) {
            lastPage.elements.splice(0, 0, element);
        }
        else if (element instanceof StiSignatureElement) {
            lastPage.elements.splice(lastPage.elements.length, 0, element);
        }
        else {
            lastPage.elements.splice(lastPage.elements.length - 1, 0, element);
        }
        this.render.insertElement(element);
        this.model.lastUsedPage = lastPage;
        this.newElement = false;
        if (element instanceof StiTableElement) {
            this.model.currentTablePropertyHeader.next("Table");
        }
        this.render.checkOutputs(this.model.getElementPage(element));
    }
    startDrag(event, element, newElement = true, isClone, layerX, layerY, page) {
        this.showDragPreview(element);
        this.currentUsableElement = this.helper.clone(element);
        element.isAdded = false;
        element.position = "relative";
        element.geometry.x = 0;
        element.geometry.y = 0;
        this.model.draggingElement = element;
        this.newElement = newElement;
        if (newElement) {
            this.startX = 15 * this.model.zoom;
            this.startY = 5 * this.model.zoom;
            let cf = 0.4;
            if (element instanceof StiTableElement ||
                element instanceof StiLineElement ||
                element instanceof StiPanelElement) {
                cf = 1;
            }
            if (element instanceof StiButtonElement) {
                cf = 0.2;
            }
            if (element instanceof StiAddressElement) {
                cf = 0.6;
            }
            this.draggingElementWidthInColumns = Math.max(Math.round(this.model.form.settings.gridColumns * cf), 1);
            this.model.draggingElement.width =
                this.model.lastUsedPage.getColumnWidth(this.model.form.settings.gridColumns) *
                    this.draggingElementWidthInColumns;
        }
        else {
            this.draggingElementWidth = element.width;
            if (!isClone) {
                this.startX = layerX;
                this.startY = layerY;
            }
            else {
                this.startX = this.model.draggingElement.width / 2;
                this.startY = this.model.draggingElement.height / 2;
            }
        }
        this.drag(event);
    }
    showDragPreview(element) {
        let page = this.model.getElementPage(element);
        page?.elements.splice(page.elements.indexOf(element), 1);
        let panel = this.model.getElementPanel(element);
        panel?.elements.splice(panel.elements.indexOf(element), 1);
        this.dragPreview.geometry = element.geometry.clone();
        setTimeout(() => {
            this.dragPreview.height = element.height;
        });
        panel ? panel.elements?.push(this.dragPreview) : (page ?? this.model.lastUsedPage).elements?.push(this.dragPreview);
    }
    moveDragPreview(event) {
        let excludeId = this.model.draggingElement instanceof StiPanelElement ? this.model.draggingElement.guid : null;
        let mouseOnPanel = this.model.getPanelFromPoint(event.clientX, event.clientY, excludeId);
        let mouseOnPage = mouseOnPanel
            ? null
            : this.model.getPageFromPoint(event.clientX, event.clientY);
        this.model.pageWithGrid = mouseOnPage;
        let dragPreviewPage = this.model.getElementPage(this.dragPreview);
        let dragPreviewPanel = this.model.getElementPanel(this.dragPreview);
        let dragPreviewContainer = dragPreviewPage ?? dragPreviewPanel;
        if (!mouseOnPage && !mouseOnPanel && (dragPreviewPage || dragPreviewPanel)) {
            dragPreviewContainer.elements.splice(dragPreviewContainer.elements.indexOf(this.dragPreview), 1);
            this.render.removeElement(this.dragPreview, dragPreviewContainer.elements);
        }
        else if ((mouseOnPage || mouseOnPanel) && !dragPreviewPage && !dragPreviewPanel) {
            (mouseOnPage ?? mouseOnPanel).elements.push(this.dragPreview);
        }
        else if ((mouseOnPanel && dragPreviewPage) ||
            (mouseOnPage && dragPreviewPanel) ||
            (mouseOnPage && dragPreviewPage && mouseOnPage != dragPreviewPage) ||
            (mouseOnPanel && dragPreviewPanel && mouseOnPanel != dragPreviewPanel)) {
            dragPreviewContainer.elements.splice(dragPreviewContainer.elements.indexOf(this.dragPreview), 1);
            this.render.removeElement(this.dragPreview, dragPreviewContainer.elements);
            (mouseOnPage ?? mouseOnPanel).elements.push(this.dragPreview);
        }
        this.dragPreview.geometry.minWidth = this.model.draggingElement.geometry.minWidth;
        let container = mouseOnPage ?? mouseOnPanel;
        if (container) {
            let columnWidth = container?.getColumnWidth(this.model.form.settings.gridColumns) ?? 1;
            var mousePos = mouseOnPage
                ? this.model.getMouseOverPagePosition(event)
                : this.model.getMouseOverPanelPosition(event, excludeId);
            if (mousePos != null) {
                let cols = this.draggingElementWidthInColumns;
                if (this.newElement && mouseOnPanel && this.model.draggingElement instanceof StiPanelElement) {
                    cols = Math.max(1, Math.ceil(cols * 0.3));
                }
                else if (!this.newElement) {
                    cols = Math.min(Math.round(this.draggingElementWidth / columnWidth), this.model.form.settings.gridColumns);
                }
                let otherElements = Array.from(container.elements);
                otherElements.splice(otherElements.indexOf(this.dragPreview), 1);
                this.render.removeElement(this.dragPreview, otherElements);
                this.model.draggingElement.width = columnWidth * cols;
                this.dragPreview.width = this.model.draggingElement.width;
                if (mousePos.x - this.startX <= columnWidth * this.model.zoom) {
                    this.dragPreview.x = 0;
                }
                else if (mousePos.x - this.startX >=
                    (container.contentAreaWidth - this.dragPreview.geometry.minWidth) * this.model.zoom) {
                    this.dragPreview.x = container.contentAreaWidth - this.dragPreview.geometry.minWidth;
                }
                else if (Math.abs(mousePos.x - this.startX) >= columnWidth * this.model.zoom) {
                    let step = Math.floor(Math.abs(mousePos.x - this.startX) / (columnWidth * this.model.zoom));
                    this.dragPreview.x = step * columnWidth;
                }
                if ((mousePos.y - this.startY) / this.model.zoom <= 0) {
                    this.dragPreview.y = 0;
                }
                else {
                    this.dragPreview.y = (mousePos.y - this.startY) / this.model.zoom;
                }
                this.render.insertElement(this.dragPreview, container.contentAreaWidth);
            }
        }
    }
}
StiDraggableService.MOUSE_DELTA = 5;
StiDraggableService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDraggableService, deps: [{ token: i1.StiMouseService }, { token: i0.ComponentFactoryResolver }, { token: i2.StiModelService }, { token: i3.StiNameService }, { token: i4.StiHelperService }, { token: StiRectangleGeometryLayout }, { token: i5.StiChangesService }], target: i0.ɵɵFactoryTarget.Injectable });
StiDraggableService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDraggableService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiDraggableService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiMouseService }, { type: i0.ComponentFactoryResolver }, { type: i2.StiModelService }, { type: i3.StiNameService }, { type: i4.StiHelperService }, { type: StiRectangleGeometryLayout }, { type: i5.StiChangesService }]; } });
//# sourceMappingURL=data:application/json;base64,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