import { Injectable } from "@angular/core";
import { StiLocalizationService } from "./sti-localization.service";
import { StiObject } from "../system/StiObject";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./http-client.service";
import * as i3 from "./sti-helper.service";
import * as i4 from "./sti-user-service";
import * as i5 from "./sti-localization.service";
import * as i6 from "../stimulsoft-forms.service";
import * as i7 from "./sti-local-storage.service";
import * as i8 from "./sti-export.service";
import * as i9 from "./sti-draggable.service";
export class StiControllerService {
    constructor(model, httpClient, helper, userService, loc, formService, stiLocalStorage, exportService, draggableService) {
        this.model = model;
        this.httpClient = httpClient;
        this.helper = helper;
        this.userService = userService;
        this.loc = loc;
        this.formService = formService;
        this.stiLocalStorage = stiLocalStorage;
        this.exportService = exportService;
        this.draggableService = draggableService;
        this.USED_PROPERTIES = [
            "localization",
            "accountUserProperties",
            "localizationList",
            "licenseProducts",
            "creationDate",
            "version",
            "fontFamilies",
            "imagesArray",
        ];
        formService.serviceEvents.subscribe((data) => {
            switch (data.action) {
                case "postData":
                    this.httpClient.post(this.model.requestUrl, data.data, "json", data.options).subscribe((result) => {
                        this.model.showProgress = false;
                        if (data.func) {
                            data.func(result);
                        }
                    });
                    break;
                case "showFileMenu":
                    this.model.formEvents.next({ name: "ShowFileMenu" });
                    break;
                case "showSaveMenu":
                    this.model.formEvents.next({ name: "ShowSaveMenu" });
                    break;
                case "showTab":
                    this.model.formEvents.next({ name: "ShowTab", value: data.tabName });
                    break;
                case "exportToPdf":
                    this.exportService.useReadOnly = data.readOnly;
                    this.exportService.usePdfA = data.pdfACompliance;
                    this.exportService.exportToPdf();
                    break;
                case "getPdfBytes":
                    this.exportService.useReadOnly = data.readOnly;
                    this.exportService.usePdfA = data.pdfACompliance;
                    this.exportService.getPdfBytes().then((val) => {
                        this.formService.serviceEventsCallbacks.next({ action: "pdfBytesCallback", value: val });
                    });
                    break;
                case "setZoom":
                    this.model.setZoomFromString(data.zoom);
                    break;
                case "addElementToForm":
                    this.draggableService.addingByDoubleClick(data.element);
                    break;
            }
        });
    }
    initialize() {
        if (this.model.properties?.cloudLoginInfo) {
            this.model.login = this.model.properties.cloudLoginInfo;
            return;
        }
        let localization;
        if (this.stiLocalStorage.getItem("StiFormsLocalization") != null &&
            this.stiLocalStorage.getItem("StiFormsLocalization") != undefined &&
            this.stiLocalStorage.getItem("StiFormsLocalization") != "undefined") {
            localization = JSON.parse(this.stiLocalStorage.getItem("StiFormsLocalization"));
        }
        let currentLocalization;
        let browserLanguage = navigator["defaultLocalization"] || navigator.language || navigator["browserLanguage"];
        if (!localization) {
            currentLocalization = browserLanguage ? browserLanguage : "en";
        }
        else {
            currentLocalization = localization.cultureName;
        }
        let scale = window.devicePixelRatio;
        this.httpClient
            .post(this.model.requestUrl, { action: "Initialize", currentLocalization: currentLocalization, scaleFactor: scale }, "json", { showProgress: this.model.loadingFromCloud ? false : true })
            .subscribe((data) => {
            if (this.model.properties) {
                delete this.model.properties?.cloudLogin;
                delete this.model.properties?.cloudPassword;
            }
            if (data["cloudReload"]) {
                document.location.href = document.location.href;
                return;
            }
            let options = (this.model.options = data);
            StiLocalizationService.setLocalization(options.localization);
            this.model.assemblyInfo = options.assemblyInfo;
            this.userService.licenseProducts = options.licenseProducts;
            this.userService.currentUser = options.accountUserProperties;
            this.model.userName = options.userName;
            this.loc.localizationList = this.model.toCamelCase(options.localizationList);
            let localizationSetting = data["localizationSetting"];
            let defaultLocalization = navigator["defaultLocalization"] || navigator.language || navigator["browserLanguage"];
            if (!this.loc.localizationList?.find((item) => item.cultureName == defaultLocalization)) {
                defaultLocalization = defaultLocalization.substring(0, 2);
            }
            this.loc.defaultLocalization = this.loc.localizationList?.find((item) => item.cultureName == defaultLocalization);
            if (localizationSetting && localizationSetting.length > 0) {
                this.loc.currentLocalization = this.loc.localizationList?.find((item) => item.cultureName == localizationSetting);
            }
            else {
                if (!this.loc.currentLocalization) {
                    if (currentLocalization != this.loc.defaultLocalization?.cultureName) {
                        this.loc.currentLocalization = this.loc.localizationList?.find((item) => item.cultureName == currentLocalization);
                    }
                    else {
                        this.loc.currentLocalization = this.loc.localizationList?.find((item) => item.cultureName == defaultLocalization);
                    }
                }
            }
            if (options.creationDate) {
                this.userService.buildDate = new Date(options.creationDate);
                this.model.buildDate = options.creationDate;
            }
            else {
                this.userService.buildDate = new Date(options.assemblyInfo?.created);
                this.model.buildDate = options.assemblyInfo?.created;
            }
            if (this.model?.properties?.cloudPlanIdent) {
            }
            else {
                this.userService.checkLicense();
            }
            this.model.buildVersion = options.assemblyInfo.version;
            if (options.fontFamilies) {
                let fontFamilies = [];
                options.fontFamilies.forEach((f) => fontFamilies.push({ name: f }));
                this.model.fontFamilies = fontFamilies;
            }
            if (options.imagesArray) {
                this.model.imagesArray = options.imagesArray;
            }
            this.model.showProgress = false;
            this.model.needToRefresh.next(true);
            this.helper.updateHelper();
            setTimeout(() => {
                this.model.showTrialLog();
            });
            let eventData = {};
            this.model.isInitialized = true;
            setTimeout(() => {
                if (this.model.isWebView && this.model.showTrialBar) {
                    this.model.showTrialTimerWindow = true;
                }
            }, 3000);
            this.model.setZoomFromString(this.model?.settings?.zoom);
            StiObject.keys(options)
                .filter((p) => this.USED_PROPERTIES.indexOf(p) == -1)
                .forEach((prop) => (eventData[prop] = options[prop]));
            this.model.interfaceEvent.next({ name: "Loaded", data: eventData });
        }, (error) => {
            if (!this.model?.properties?.cloudPlanIdent) {
                this.userService.checkLicense();
            }
        });
    }
}
StiControllerService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiControllerService, deps: [{ token: i1.StiModelService }, { token: i2.StiHttpClientService }, { token: i3.StiHelperService }, { token: i4.StiUserService }, { token: i5.StiLocalizationService }, { token: i6.StimulsoftFormsService }, { token: i7.StiLocalStorageService }, { token: i8.StiExportService }, { token: i9.StiDraggableService }], target: i0.ɵɵFactoryTarget.Injectable });
StiControllerService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiControllerService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiControllerService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiHttpClientService }, { type: i3.StiHelperService }, { type: i4.StiUserService }, { type: i5.StiLocalizationService }, { type: i6.StimulsoftFormsService }, { type: i7.StiLocalStorageService }, { type: i8.StiExportService }, { type: i9.StiDraggableService }]; } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RpLWNvbnRyb2xsZXIuc2VydmljZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi9zZXJ2aWNlcy9zdGktY29udHJvbGxlci5zZXJ2aWNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxVQUFVLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFFM0MsT0FBTyxFQUFFLHNCQUFzQixFQUFFLE1BQU0sNEJBQTRCLENBQUM7QUFNcEUsT0FBTyxFQUFFLFNBQVMsRUFBRSxNQUFNLHFCQUFxQixDQUFDOzs7Ozs7Ozs7OztBQU9oRCxNQUFNLE9BQU8sb0JBQW9CO0lBWS9CLFlBQ1MsS0FBc0IsRUFDdEIsVUFBZ0MsRUFDaEMsTUFBd0IsRUFDeEIsV0FBMkIsRUFDM0IsR0FBMkIsRUFDM0IsV0FBbUMsRUFDbkMsZUFBdUMsRUFDdkMsYUFBK0IsRUFDL0IsZ0JBQXFDO1FBUnJDLFVBQUssR0FBTCxLQUFLLENBQWlCO1FBQ3RCLGVBQVUsR0FBVixVQUFVLENBQXNCO1FBQ2hDLFdBQU0sR0FBTixNQUFNLENBQWtCO1FBQ3hCLGdCQUFXLEdBQVgsV0FBVyxDQUFnQjtRQUMzQixRQUFHLEdBQUgsR0FBRyxDQUF3QjtRQUMzQixnQkFBVyxHQUFYLFdBQVcsQ0FBd0I7UUFDbkMsb0JBQWUsR0FBZixlQUFlLENBQXdCO1FBQ3ZDLGtCQUFhLEdBQWIsYUFBYSxDQUFrQjtRQUMvQixxQkFBZ0IsR0FBaEIsZ0JBQWdCLENBQXFCO1FBcEJ0QyxvQkFBZSxHQUFHO1lBQ3hCLGNBQWM7WUFDZCx1QkFBdUI7WUFDdkIsa0JBQWtCO1lBQ2xCLGlCQUFpQjtZQUNqQixjQUFjO1lBQ2QsU0FBUztZQUNULGNBQWM7WUFDZCxhQUFhO1NBQ2QsQ0FBQztRQWFBLFdBQVcsQ0FBQyxhQUFhLENBQUMsU0FBUyxDQUFDLENBQUMsSUFBSSxFQUFFLEVBQUU7WUFDM0MsUUFBUSxJQUFJLENBQUMsTUFBTSxFQUFFO2dCQUNuQixLQUFLLFVBQVU7b0JBQ2IsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLEVBQUUsSUFBSSxDQUFDLElBQUksRUFBRSxNQUFNLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDLFNBQVMsQ0FBQyxDQUFDLE1BQU0sRUFBRSxFQUFFO3dCQUNoRyxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7d0JBQ2hDLElBQUksSUFBSSxDQUFDLElBQUksRUFBRTs0QkFDYixJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO3lCQUNuQjtvQkFDSCxDQUFDLENBQUMsQ0FBQztvQkFDSCxNQUFNO2dCQUNSLEtBQUssY0FBYztvQkFDakIsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUUsSUFBSSxFQUFFLGNBQWMsRUFBRSxDQUFDLENBQUM7b0JBQ3JELE1BQU07Z0JBQ1IsS0FBSyxjQUFjO29CQUNqQixJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUMsRUFBRSxJQUFJLEVBQUUsY0FBYyxFQUFFLENBQUMsQ0FBQztvQkFDckQsTUFBTTtnQkFDUixLQUFLLFNBQVM7b0JBQ1osSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUUsSUFBSSxFQUFFLFNBQVMsRUFBRSxLQUFLLEVBQUUsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUM7b0JBQ3JFLE1BQU07Z0JBQ1IsS0FBSyxhQUFhO29CQUNoQixJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDO29CQUMvQyxJQUFJLENBQUMsYUFBYSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsY0FBYyxDQUFDO29CQUNqRCxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsRUFBRSxDQUFDO29CQUNqQyxNQUFNO2dCQUNSLEtBQUssYUFBYTtvQkFDaEIsSUFBSSxDQUFDLGFBQWEsQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQztvQkFDL0MsSUFBSSxDQUFDLGFBQWEsQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQztvQkFDakQsSUFBSSxDQUFDLGFBQWEsQ0FBQyxXQUFXLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxHQUFHLEVBQUUsRUFBRTt3QkFDNUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxzQkFBc0IsQ0FBQyxJQUFJLENBQUMsRUFBRSxNQUFNLEVBQUUsa0JBQWtCLEVBQUUsS0FBSyxFQUFFLEdBQUcsRUFBRSxDQUFDLENBQUM7b0JBQzNGLENBQUMsQ0FBQyxDQUFDO29CQUNILE1BQU07Z0JBQ1IsS0FBSyxTQUFTO29CQUNaLElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO29CQUN4QyxNQUFNO2dCQUNSLEtBQUssa0JBQWtCO29CQUNyQixJQUFJLENBQUMsZ0JBQWdCLENBQUMsbUJBQW1CLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO29CQUN4RCxNQUFNO2FBQ1Q7UUFDSCxDQUFDLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFTSxVQUFVO1FBQ2YsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsRUFBRSxjQUFjLEVBQUU7WUFDekMsSUFBSSxDQUFDLEtBQUssQ0FBQyxLQUFLLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO1lBQ3hELE9BQU87U0FDUjtRQUVELElBQUksWUFBWSxDQUFDO1FBQ2pCLElBQ0UsSUFBSSxDQUFDLGVBQWUsQ0FBQyxPQUFPLENBQUMsc0JBQXNCLENBQUMsSUFBSSxJQUFJO1lBQzVELElBQUksQ0FBQyxlQUFlLENBQUMsT0FBTyxDQUFDLHNCQUFzQixDQUFDLElBQUksU0FBUztZQUNqRSxJQUFJLENBQUMsZUFBZSxDQUFDLE9BQU8sQ0FBQyxzQkFBc0IsQ0FBQyxJQUFJLFdBQVcsRUFDbkU7WUFDQSxZQUFZLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLE9BQU8sQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDLENBQUM7U0FDakY7UUFDRCxJQUFJLG1CQUFtQixDQUFDO1FBQ3hCLElBQUksZUFBZSxHQUFHLFNBQVMsQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLFNBQVMsQ0FBQyxRQUFRLElBQUksU0FBUyxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFDN0csSUFBSSxDQUFDLFlBQVksRUFBRTtZQUNqQixtQkFBbUIsR0FBRyxlQUFlLENBQUMsQ0FBQyxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO1NBQ2hFO2FBQU07WUFDTCxtQkFBbUIsR0FBRyxZQUFZLENBQUMsV0FBVyxDQUFDO1NBQ2hEO1FBQ0QsSUFBSSxLQUFLLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDO1FBQ3BDLElBQUksQ0FBQyxVQUFVO2FBQ1osSUFBSSxDQUNILElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxFQUNyQixFQUFFLE1BQU0sRUFBRSxZQUFZLEVBQUUsbUJBQW1CLEVBQUUsbUJBQW1CLEVBQUUsV0FBVyxFQUFFLEtBQUssRUFBRSxFQUN0RixNQUFNLEVBQ04sRUFBRSxZQUFZLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FDN0Q7YUFDQSxTQUFTLENBQ1IsQ0FBQyxJQUFJLEVBQUUsRUFBRTtZQUNQLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLEVBQUU7Z0JBQ3pCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLEVBQUUsVUFBVSxDQUFDO2dCQUN6QyxPQUFPLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxFQUFFLGFBQWEsQ0FBQzthQUM3QztZQUVELElBQUksSUFBSSxDQUFDLGFBQWEsQ0FBQyxFQUFFO2dCQUN2QixRQUFRLENBQUMsUUFBUSxDQUFDLElBQUksR0FBRyxRQUFRLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQztnQkFDaEQsT0FBTzthQUNSO1lBRUQsSUFBSSxPQUFPLEdBQUcsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sR0FBRyxJQUF5QixDQUFDLENBQUM7WUFDL0Qsc0JBQXNCLENBQUMsZUFBZSxDQUFDLE9BQU8sQ0FBQyxZQUFZLENBQUMsQ0FBQztZQUM3RCxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksR0FBRyxPQUFPLENBQUMsWUFBWSxDQUFDO1lBQy9DLElBQUksQ0FBQyxXQUFXLENBQUMsZUFBZSxHQUFHLE9BQU8sQ0FBQyxlQUFlLENBQUM7WUFDM0QsSUFBSSxDQUFDLFdBQVcsQ0FBQyxXQUFXLEdBQUcsT0FBTyxDQUFDLHFCQUFxQixDQUFDO1lBQzdELElBQUksQ0FBQyxLQUFLLENBQUMsUUFBUSxHQUFHLE9BQU8sQ0FBQyxRQUFRLENBQUM7WUFDdkMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxnQkFBZ0IsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLENBQUMsQ0FBQztZQUM3RSxJQUFJLG1CQUFtQixHQUFHLElBQUksQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO1lBQ3RELElBQUksbUJBQW1CLEdBQ3JCLFNBQVMsQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLFNBQVMsQ0FBQyxRQUFRLElBQUksU0FBUyxDQUFDLGlCQUFpQixDQUFDLENBQUM7WUFDekYsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLENBQUMsSUFBSSxFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsV0FBVyxJQUFJLG1CQUFtQixDQUFDLEVBQUU7Z0JBQ3ZGLG1CQUFtQixHQUFHLG1CQUFtQixDQUFDLFNBQVMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7YUFDM0Q7WUFDRCxJQUFJLENBQUMsR0FBRyxDQUFDLG1CQUFtQixHQUFHLElBQUksQ0FBQyxHQUFHLENBQUMsZ0JBQWdCLEVBQUUsSUFBSSxDQUM1RCxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsSUFBSSxDQUFDLFdBQVcsSUFBSSxtQkFBbUIsQ0FDbEQsQ0FBQztZQUNGLElBQUksbUJBQW1CLElBQUksbUJBQW1CLENBQUMsTUFBTSxHQUFHLENBQUMsRUFBRTtnQkFDekQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxtQkFBbUIsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLGdCQUFnQixFQUFFLElBQUksQ0FDNUQsQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyxXQUFXLElBQUksbUJBQW1CLENBQ2xELENBQUM7YUFDSDtpQkFBTTtnQkFDTCxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxtQkFBbUIsRUFBRTtvQkFDakMsSUFBSSxtQkFBbUIsSUFBSSxJQUFJLENBQUMsR0FBRyxDQUFDLG1CQUFtQixFQUFFLFdBQVcsRUFBRTt3QkFDcEUsSUFBSSxDQUFDLEdBQUcsQ0FBQyxtQkFBbUIsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLGdCQUFnQixFQUFFLElBQUksQ0FDNUQsQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyxXQUFXLElBQUksbUJBQW1CLENBQ2xELENBQUM7cUJBQ0g7eUJBQU07d0JBQ0wsSUFBSSxDQUFDLEdBQUcsQ0FBQyxtQkFBbUIsR0FBRyxJQUFJLENBQUMsR0FBRyxDQUFDLGdCQUFnQixFQUFFLElBQUksQ0FDNUQsQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyxXQUFXLElBQUksbUJBQW1CLENBQ2xELENBQUM7cUJBQ0g7aUJBQ0Y7YUFDRjtZQUNELElBQUksT0FBTyxDQUFDLFlBQVksRUFBRTtnQkFDeEIsSUFBSSxDQUFDLFdBQVcsQ0FBQyxTQUFTLEdBQUcsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQyxDQUFDO2dCQUM1RCxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsR0FBRyxPQUFPLENBQUMsWUFBWSxDQUFDO2FBQzdDO2lCQUFNO2dCQUNMLElBQUksQ0FBQyxXQUFXLENBQUMsU0FBUyxHQUFHLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxZQUFZLEVBQUUsT0FBTyxDQUFDLENBQUM7Z0JBQ3JFLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxHQUFHLE9BQU8sQ0FBQyxZQUFZLEVBQUUsT0FBTyxDQUFDO2FBQ3REO1lBQ0QsSUFBSSxJQUFJLENBQUMsS0FBSyxFQUFFLFVBQVUsRUFBRSxjQUFjLEVBQUU7YUFDM0M7aUJBQU07Z0JBQ0wsSUFBSSxDQUFDLFdBQVcsQ0FBQyxZQUFZLEVBQUUsQ0FBQzthQUNqQztZQUNELElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxHQUFHLE9BQU8sQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDO1lBQ3ZELElBQUksT0FBTyxDQUFDLFlBQVksRUFBRTtnQkFDeEIsSUFBSSxZQUFZLEdBQUcsRUFBRSxDQUFDO2dCQUN0QixPQUFPLENBQUMsWUFBWSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsWUFBWSxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7Z0JBQ3BFLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxHQUFHLFlBQVksQ0FBQzthQUN4QztZQUNELElBQUksT0FBTyxDQUFDLFdBQVcsRUFBRTtnQkFDdkIsSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXLEdBQUcsT0FBTyxDQUFDLFdBQVcsQ0FBQzthQUM5QztZQUNELElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQztZQUNoQyxJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDcEMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxZQUFZLEVBQUUsQ0FBQztZQUMzQixVQUFVLENBQUMsR0FBRyxFQUFFO2dCQUNkLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDNUIsQ0FBQyxDQUFDLENBQUM7WUFDSCxJQUFJLFNBQVMsR0FBRyxFQUFFLENBQUM7WUFDbkIsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLEdBQUcsSUFBSSxDQUFDO1lBQ2hDLFVBQVUsQ0FBQyxHQUFHLEVBQUU7Z0JBQ2QsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVMsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksRUFBRTtvQkFDbkQsSUFBSSxDQUFDLEtBQUssQ0FBQyxvQkFBb0IsR0FBRyxJQUFJLENBQUM7aUJBQ3hDO1lBQ0gsQ0FBQyxFQUFFLElBQUksQ0FBQyxDQUFDO1lBQ1QsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLFFBQVEsRUFBRSxJQUFJLENBQUMsQ0FBQztZQUN6RCxTQUFTLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQztpQkFDcEIsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxJQUFJLENBQUMsZUFBZSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztpQkFDcEQsT0FBTyxDQUFDLENBQUMsSUFBSSxFQUFFLEVBQUUsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsR0FBRyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ3hELElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFLFNBQVMsRUFBRSxDQUFDLENBQUM7UUFDdEUsQ0FBQyxFQUNELENBQUMsS0FBVSxFQUFFLEVBQUU7WUFDYixJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUUsY0FBYyxFQUFFO2dCQUMzQyxJQUFJLENBQUMsV0FBVyxDQUFDLFlBQVksRUFBRSxDQUFDO2FBQ2pDO1FBQ0gsQ0FBQyxDQUNGLENBQUM7SUFDTixDQUFDOztpSEF2TFUsb0JBQW9CO3FIQUFwQixvQkFBb0I7MkZBQXBCLG9CQUFvQjtrQkFEaEMsVUFBVSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEluamVjdGFibGUgfSBmcm9tIFwiQGFuZ3VsYXIvY29yZVwiO1xyXG5pbXBvcnQgeyBTdGlIdHRwQ2xpZW50U2VydmljZSB9IGZyb20gXCIuL2h0dHAtY2xpZW50LnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpTG9jYWxpemF0aW9uU2VydmljZSB9IGZyb20gXCIuL3N0aS1sb2NhbGl6YXRpb24uc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlNb2RlbFNlcnZpY2UgfSBmcm9tIFwiLi9tb2RlbC5zZXJ2aWNlXCI7XHJcbmltcG9ydCB7IFN0aVdlYkZvcm1PcHRpb25zIH0gZnJvbSBcIi4vb2JqZWN0c1wiO1xyXG5pbXBvcnQgeyBTdGlGb3JtIH0gZnJvbSBcIi4uL2VsZW1lbnRzL1N0aUZvcm1cIjtcclxuaW1wb3J0IHsgU3RpSGVscGVyU2VydmljZSB9IGZyb20gXCIuL3N0aS1oZWxwZXIuc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlVc2VyU2VydmljZSB9IGZyb20gXCIuL3N0aS11c2VyLXNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpT2JqZWN0IH0gZnJvbSBcIi4uL3N5c3RlbS9TdGlPYmplY3RcIjtcclxuaW1wb3J0IHsgU3RpbXVsc29mdEZvcm1zU2VydmljZSB9IGZyb20gXCIuLi9zdGltdWxzb2Z0LWZvcm1zLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpTG9jYWxTdG9yYWdlU2VydmljZSB9IGZyb20gXCIuL3N0aS1sb2NhbC1zdG9yYWdlLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpRXhwb3J0U2VydmljZSB9IGZyb20gXCIuL3N0aS1leHBvcnQuc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlEcmFnZ2FibGVTZXJ2aWNlIH0gZnJvbSBcIi4vc3RpLWRyYWdnYWJsZS5zZXJ2aWNlXCI7XHJcblxyXG5ASW5qZWN0YWJsZSgpXHJcbmV4cG9ydCBjbGFzcyBTdGlDb250cm9sbGVyU2VydmljZSB7XHJcbiAgcHJpdmF0ZSBVU0VEX1BST1BFUlRJRVMgPSBbXHJcbiAgICBcImxvY2FsaXphdGlvblwiLFxyXG4gICAgXCJhY2NvdW50VXNlclByb3BlcnRpZXNcIixcclxuICAgIFwibG9jYWxpemF0aW9uTGlzdFwiLFxyXG4gICAgXCJsaWNlbnNlUHJvZHVjdHNcIixcclxuICAgIFwiY3JlYXRpb25EYXRlXCIsXHJcbiAgICBcInZlcnNpb25cIixcclxuICAgIFwiZm9udEZhbWlsaWVzXCIsXHJcbiAgICBcImltYWdlc0FycmF5XCIsXHJcbiAgXTtcclxuXHJcbiAgY29uc3RydWN0b3IoXHJcbiAgICBwdWJsaWMgbW9kZWw6IFN0aU1vZGVsU2VydmljZSxcclxuICAgIHB1YmxpYyBodHRwQ2xpZW50OiBTdGlIdHRwQ2xpZW50U2VydmljZSxcclxuICAgIHB1YmxpYyBoZWxwZXI6IFN0aUhlbHBlclNlcnZpY2UsXHJcbiAgICBwdWJsaWMgdXNlclNlcnZpY2U6IFN0aVVzZXJTZXJ2aWNlLFxyXG4gICAgcHVibGljIGxvYzogU3RpTG9jYWxpemF0aW9uU2VydmljZSxcclxuICAgIHB1YmxpYyBmb3JtU2VydmljZTogU3RpbXVsc29mdEZvcm1zU2VydmljZSxcclxuICAgIHB1YmxpYyBzdGlMb2NhbFN0b3JhZ2U6IFN0aUxvY2FsU3RvcmFnZVNlcnZpY2UsXHJcbiAgICBwdWJsaWMgZXhwb3J0U2VydmljZTogU3RpRXhwb3J0U2VydmljZSxcclxuICAgIHB1YmxpYyBkcmFnZ2FibGVTZXJ2aWNlOiBTdGlEcmFnZ2FibGVTZXJ2aWNlXHJcbiAgKSB7XHJcbiAgICBmb3JtU2VydmljZS5zZXJ2aWNlRXZlbnRzLnN1YnNjcmliZSgoZGF0YSkgPT4ge1xyXG4gICAgICBzd2l0Y2ggKGRhdGEuYWN0aW9uKSB7XHJcbiAgICAgICAgY2FzZSBcInBvc3REYXRhXCI6XHJcbiAgICAgICAgICB0aGlzLmh0dHBDbGllbnQucG9zdCh0aGlzLm1vZGVsLnJlcXVlc3RVcmwsIGRhdGEuZGF0YSwgXCJqc29uXCIsIGRhdGEub3B0aW9ucykuc3Vic2NyaWJlKChyZXN1bHQpID0+IHtcclxuICAgICAgICAgICAgdGhpcy5tb2RlbC5zaG93UHJvZ3Jlc3MgPSBmYWxzZTtcclxuICAgICAgICAgICAgaWYgKGRhdGEuZnVuYykge1xyXG4gICAgICAgICAgICAgIGRhdGEuZnVuYyhyZXN1bHQpO1xyXG4gICAgICAgICAgICB9XHJcbiAgICAgICAgICB9KTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJzaG93RmlsZU1lbnVcIjpcclxuICAgICAgICAgIHRoaXMubW9kZWwuZm9ybUV2ZW50cy5uZXh0KHsgbmFtZTogXCJTaG93RmlsZU1lbnVcIiB9KTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJzaG93U2F2ZU1lbnVcIjpcclxuICAgICAgICAgIHRoaXMubW9kZWwuZm9ybUV2ZW50cy5uZXh0KHsgbmFtZTogXCJTaG93U2F2ZU1lbnVcIiB9KTtcclxuICAgICAgICAgIGJyZWFrO1xyXG4gICAgICAgIGNhc2UgXCJzaG93VGFiXCI6XHJcbiAgICAgICAgICB0aGlzLm1vZGVsLmZvcm1FdmVudHMubmV4dCh7IG5hbWU6IFwiU2hvd1RhYlwiLCB2YWx1ZTogZGF0YS50YWJOYW1lIH0pO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcImV4cG9ydFRvUGRmXCI6XHJcbiAgICAgICAgICB0aGlzLmV4cG9ydFNlcnZpY2UudXNlUmVhZE9ubHkgPSBkYXRhLnJlYWRPbmx5O1xyXG4gICAgICAgICAgdGhpcy5leHBvcnRTZXJ2aWNlLnVzZVBkZkEgPSBkYXRhLnBkZkFDb21wbGlhbmNlO1xyXG4gICAgICAgICAgdGhpcy5leHBvcnRTZXJ2aWNlLmV4cG9ydFRvUGRmKCk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwiZ2V0UGRmQnl0ZXNcIjpcclxuICAgICAgICAgIHRoaXMuZXhwb3J0U2VydmljZS51c2VSZWFkT25seSA9IGRhdGEucmVhZE9ubHk7XHJcbiAgICAgICAgICB0aGlzLmV4cG9ydFNlcnZpY2UudXNlUGRmQSA9IGRhdGEucGRmQUNvbXBsaWFuY2U7XHJcbiAgICAgICAgICB0aGlzLmV4cG9ydFNlcnZpY2UuZ2V0UGRmQnl0ZXMoKS50aGVuKCh2YWwpID0+IHtcclxuICAgICAgICAgICAgdGhpcy5mb3JtU2VydmljZS5zZXJ2aWNlRXZlbnRzQ2FsbGJhY2tzLm5leHQoeyBhY3Rpb246IFwicGRmQnl0ZXNDYWxsYmFja1wiLCB2YWx1ZTogdmFsIH0pO1xyXG4gICAgICAgICAgfSk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgICBjYXNlIFwic2V0Wm9vbVwiOlxyXG4gICAgICAgICAgdGhpcy5tb2RlbC5zZXRab29tRnJvbVN0cmluZyhkYXRhLnpvb20pO1xyXG4gICAgICAgICAgYnJlYWs7XHJcbiAgICAgICAgY2FzZSBcImFkZEVsZW1lbnRUb0Zvcm1cIjpcclxuICAgICAgICAgIHRoaXMuZHJhZ2dhYmxlU2VydmljZS5hZGRpbmdCeURvdWJsZUNsaWNrKGRhdGEuZWxlbWVudCk7XHJcbiAgICAgICAgICBicmVhaztcclxuICAgICAgfVxyXG4gICAgfSk7XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgaW5pdGlhbGl6ZSgpIHtcclxuICAgIGlmICh0aGlzLm1vZGVsLnByb3BlcnRpZXM/LmNsb3VkTG9naW5JbmZvKSB7XHJcbiAgICAgIHRoaXMubW9kZWwubG9naW4gPSB0aGlzLm1vZGVsLnByb3BlcnRpZXMuY2xvdWRMb2dpbkluZm87XHJcbiAgICAgIHJldHVybjtcclxuICAgIH1cclxuXHJcbiAgICBsZXQgbG9jYWxpemF0aW9uO1xyXG4gICAgaWYgKFxyXG4gICAgICB0aGlzLnN0aUxvY2FsU3RvcmFnZS5nZXRJdGVtKFwiU3RpRm9ybXNMb2NhbGl6YXRpb25cIikgIT0gbnVsbCAmJlxyXG4gICAgICB0aGlzLnN0aUxvY2FsU3RvcmFnZS5nZXRJdGVtKFwiU3RpRm9ybXNMb2NhbGl6YXRpb25cIikgIT0gdW5kZWZpbmVkICYmXHJcbiAgICAgIHRoaXMuc3RpTG9jYWxTdG9yYWdlLmdldEl0ZW0oXCJTdGlGb3Jtc0xvY2FsaXphdGlvblwiKSAhPSBcInVuZGVmaW5lZFwiXHJcbiAgICApIHtcclxuICAgICAgbG9jYWxpemF0aW9uID0gSlNPTi5wYXJzZSh0aGlzLnN0aUxvY2FsU3RvcmFnZS5nZXRJdGVtKFwiU3RpRm9ybXNMb2NhbGl6YXRpb25cIikpO1xyXG4gICAgfVxyXG4gICAgbGV0IGN1cnJlbnRMb2NhbGl6YXRpb247XHJcbiAgICBsZXQgYnJvd3Nlckxhbmd1YWdlID0gbmF2aWdhdG9yW1wiZGVmYXVsdExvY2FsaXphdGlvblwiXSB8fCBuYXZpZ2F0b3IubGFuZ3VhZ2UgfHwgbmF2aWdhdG9yW1wiYnJvd3Nlckxhbmd1YWdlXCJdO1xyXG4gICAgaWYgKCFsb2NhbGl6YXRpb24pIHtcclxuICAgICAgY3VycmVudExvY2FsaXphdGlvbiA9IGJyb3dzZXJMYW5ndWFnZSA/IGJyb3dzZXJMYW5ndWFnZSA6IFwiZW5cIjtcclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIGN1cnJlbnRMb2NhbGl6YXRpb24gPSBsb2NhbGl6YXRpb24uY3VsdHVyZU5hbWU7XHJcbiAgICB9XHJcbiAgICBsZXQgc2NhbGUgPSB3aW5kb3cuZGV2aWNlUGl4ZWxSYXRpbztcclxuICAgIHRoaXMuaHR0cENsaWVudFxyXG4gICAgICAucG9zdChcclxuICAgICAgICB0aGlzLm1vZGVsLnJlcXVlc3RVcmwsXHJcbiAgICAgICAgeyBhY3Rpb246IFwiSW5pdGlhbGl6ZVwiLCBjdXJyZW50TG9jYWxpemF0aW9uOiBjdXJyZW50TG9jYWxpemF0aW9uLCBzY2FsZUZhY3Rvcjogc2NhbGUgfSxcclxuICAgICAgICBcImpzb25cIixcclxuICAgICAgICB7IHNob3dQcm9ncmVzczogdGhpcy5tb2RlbC5sb2FkaW5nRnJvbUNsb3VkID8gZmFsc2UgOiB0cnVlIH1cclxuICAgICAgKVxyXG4gICAgICAuc3Vic2NyaWJlKFxyXG4gICAgICAgIChkYXRhKSA9PiB7XHJcbiAgICAgICAgICBpZiAodGhpcy5tb2RlbC5wcm9wZXJ0aWVzKSB7XHJcbiAgICAgICAgICAgIGRlbGV0ZSB0aGlzLm1vZGVsLnByb3BlcnRpZXM/LmNsb3VkTG9naW47XHJcbiAgICAgICAgICAgIGRlbGV0ZSB0aGlzLm1vZGVsLnByb3BlcnRpZXM/LmNsb3VkUGFzc3dvcmQ7XHJcbiAgICAgICAgICB9XHJcblxyXG4gICAgICAgICAgaWYgKGRhdGFbXCJjbG91ZFJlbG9hZFwiXSkge1xyXG4gICAgICAgICAgICBkb2N1bWVudC5sb2NhdGlvbi5ocmVmID0gZG9jdW1lbnQubG9jYXRpb24uaHJlZjtcclxuICAgICAgICAgICAgcmV0dXJuO1xyXG4gICAgICAgICAgfVxyXG5cclxuICAgICAgICAgIGxldCBvcHRpb25zID0gKHRoaXMubW9kZWwub3B0aW9ucyA9IGRhdGEgYXMgU3RpV2ViRm9ybU9wdGlvbnMpO1xyXG4gICAgICAgICAgU3RpTG9jYWxpemF0aW9uU2VydmljZS5zZXRMb2NhbGl6YXRpb24ob3B0aW9ucy5sb2NhbGl6YXRpb24pO1xyXG4gICAgICAgICAgdGhpcy5tb2RlbC5hc3NlbWJseUluZm8gPSBvcHRpb25zLmFzc2VtYmx5SW5mbztcclxuICAgICAgICAgIHRoaXMudXNlclNlcnZpY2UubGljZW5zZVByb2R1Y3RzID0gb3B0aW9ucy5saWNlbnNlUHJvZHVjdHM7XHJcbiAgICAgICAgICB0aGlzLnVzZXJTZXJ2aWNlLmN1cnJlbnRVc2VyID0gb3B0aW9ucy5hY2NvdW50VXNlclByb3BlcnRpZXM7XHJcbiAgICAgICAgICB0aGlzLm1vZGVsLnVzZXJOYW1lID0gb3B0aW9ucy51c2VyTmFtZTtcclxuICAgICAgICAgIHRoaXMubG9jLmxvY2FsaXphdGlvbkxpc3QgPSB0aGlzLm1vZGVsLnRvQ2FtZWxDYXNlKG9wdGlvbnMubG9jYWxpemF0aW9uTGlzdCk7XHJcbiAgICAgICAgICBsZXQgbG9jYWxpemF0aW9uU2V0dGluZyA9IGRhdGFbXCJsb2NhbGl6YXRpb25TZXR0aW5nXCJdO1xyXG4gICAgICAgICAgbGV0IGRlZmF1bHRMb2NhbGl6YXRpb24gPVxyXG4gICAgICAgICAgICBuYXZpZ2F0b3JbXCJkZWZhdWx0TG9jYWxpemF0aW9uXCJdIHx8IG5hdmlnYXRvci5sYW5ndWFnZSB8fCBuYXZpZ2F0b3JbXCJicm93c2VyTGFuZ3VhZ2VcIl07XHJcbiAgICAgICAgICBpZiAoIXRoaXMubG9jLmxvY2FsaXphdGlvbkxpc3Q/LmZpbmQoKGl0ZW0pID0+IGl0ZW0uY3VsdHVyZU5hbWUgPT0gZGVmYXVsdExvY2FsaXphdGlvbikpIHtcclxuICAgICAgICAgICAgZGVmYXVsdExvY2FsaXphdGlvbiA9IGRlZmF1bHRMb2NhbGl6YXRpb24uc3Vic3RyaW5nKDAsIDIpO1xyXG4gICAgICAgICAgfVxyXG4gICAgICAgICAgdGhpcy5sb2MuZGVmYXVsdExvY2FsaXphdGlvbiA9IHRoaXMubG9jLmxvY2FsaXphdGlvbkxpc3Q/LmZpbmQoXHJcbiAgICAgICAgICAgIChpdGVtKSA9PiBpdGVtLmN1bHR1cmVOYW1lID09IGRlZmF1bHRMb2NhbGl6YXRpb25cclxuICAgICAgICAgICk7XHJcbiAgICAgICAgICBpZiAobG9jYWxpemF0aW9uU2V0dGluZyAmJiBsb2NhbGl6YXRpb25TZXR0aW5nLmxlbmd0aCA+IDApIHtcclxuICAgICAgICAgICAgdGhpcy5sb2MuY3VycmVudExvY2FsaXphdGlvbiA9IHRoaXMubG9jLmxvY2FsaXphdGlvbkxpc3Q/LmZpbmQoXHJcbiAgICAgICAgICAgICAgKGl0ZW0pID0+IGl0ZW0uY3VsdHVyZU5hbWUgPT0gbG9jYWxpemF0aW9uU2V0dGluZ1xyXG4gICAgICAgICAgICApO1xyXG4gICAgICAgICAgfSBlbHNlIHtcclxuICAgICAgICAgICAgaWYgKCF0aGlzLmxvYy5jdXJyZW50TG9jYWxpemF0aW9uKSB7XHJcbiAgICAgICAgICAgICAgaWYgKGN1cnJlbnRMb2NhbGl6YXRpb24gIT0gdGhpcy5sb2MuZGVmYXVsdExvY2FsaXphdGlvbj8uY3VsdHVyZU5hbWUpIHtcclxuICAgICAgICAgICAgICAgIHRoaXMubG9jLmN1cnJlbnRMb2NhbGl6YXRpb24gPSB0aGlzLmxvYy5sb2NhbGl6YXRpb25MaXN0Py5maW5kKFxyXG4gICAgICAgICAgICAgICAgICAoaXRlbSkgPT4gaXRlbS5jdWx0dXJlTmFtZSA9PSBjdXJyZW50TG9jYWxpemF0aW9uXHJcbiAgICAgICAgICAgICAgICApO1xyXG4gICAgICAgICAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgICAgICAgICB0aGlzLmxvYy5jdXJyZW50TG9jYWxpemF0aW9uID0gdGhpcy5sb2MubG9jYWxpemF0aW9uTGlzdD8uZmluZChcclxuICAgICAgICAgICAgICAgICAgKGl0ZW0pID0+IGl0ZW0uY3VsdHVyZU5hbWUgPT0gZGVmYXVsdExvY2FsaXphdGlvblxyXG4gICAgICAgICAgICAgICAgKTtcclxuICAgICAgICAgICAgICB9XHJcbiAgICAgICAgICAgIH1cclxuICAgICAgICAgIH1cclxuICAgICAgICAgIGlmIChvcHRpb25zLmNyZWF0aW9uRGF0ZSkge1xyXG4gICAgICAgICAgICB0aGlzLnVzZXJTZXJ2aWNlLmJ1aWxkRGF0ZSA9IG5ldyBEYXRlKG9wdGlvbnMuY3JlYXRpb25EYXRlKTtcclxuICAgICAgICAgICAgdGhpcy5tb2RlbC5idWlsZERhdGUgPSBvcHRpb25zLmNyZWF0aW9uRGF0ZTtcclxuICAgICAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgICAgIHRoaXMudXNlclNlcnZpY2UuYnVpbGREYXRlID0gbmV3IERhdGUob3B0aW9ucy5hc3NlbWJseUluZm8/LmNyZWF0ZWQpO1xyXG4gICAgICAgICAgICB0aGlzLm1vZGVsLmJ1aWxkRGF0ZSA9IG9wdGlvbnMuYXNzZW1ibHlJbmZvPy5jcmVhdGVkO1xyXG4gICAgICAgICAgfVxyXG4gICAgICAgICAgaWYgKHRoaXMubW9kZWw/LnByb3BlcnRpZXM/LmNsb3VkUGxhbklkZW50KSB7XHJcbiAgICAgICAgICB9IGVsc2Uge1xyXG4gICAgICAgICAgICB0aGlzLnVzZXJTZXJ2aWNlLmNoZWNrTGljZW5zZSgpO1xyXG4gICAgICAgICAgfVxyXG4gICAgICAgICAgdGhpcy5tb2RlbC5idWlsZFZlcnNpb24gPSBvcHRpb25zLmFzc2VtYmx5SW5mby52ZXJzaW9uO1xyXG4gICAgICAgICAgaWYgKG9wdGlvbnMuZm9udEZhbWlsaWVzKSB7XHJcbiAgICAgICAgICAgIGxldCBmb250RmFtaWxpZXMgPSBbXTtcclxuICAgICAgICAgICAgb3B0aW9ucy5mb250RmFtaWxpZXMuZm9yRWFjaCgoZikgPT4gZm9udEZhbWlsaWVzLnB1c2goeyBuYW1lOiBmIH0pKTtcclxuICAgICAgICAgICAgdGhpcy5tb2RlbC5mb250RmFtaWxpZXMgPSBmb250RmFtaWxpZXM7XHJcbiAgICAgICAgICB9XHJcbiAgICAgICAgICBpZiAob3B0aW9ucy5pbWFnZXNBcnJheSkge1xyXG4gICAgICAgICAgICB0aGlzLm1vZGVsLmltYWdlc0FycmF5ID0gb3B0aW9ucy5pbWFnZXNBcnJheTtcclxuICAgICAgICAgIH1cclxuICAgICAgICAgIHRoaXMubW9kZWwuc2hvd1Byb2dyZXNzID0gZmFsc2U7XHJcbiAgICAgICAgICB0aGlzLm1vZGVsLm5lZWRUb1JlZnJlc2gubmV4dCh0cnVlKTtcclxuICAgICAgICAgIHRoaXMuaGVscGVyLnVwZGF0ZUhlbHBlcigpO1xyXG4gICAgICAgICAgc2V0VGltZW91dCgoKSA9PiB7XHJcbiAgICAgICAgICAgIHRoaXMubW9kZWwuc2hvd1RyaWFsTG9nKCk7XHJcbiAgICAgICAgICB9KTtcclxuICAgICAgICAgIGxldCBldmVudERhdGEgPSB7fTtcclxuICAgICAgICAgIHRoaXMubW9kZWwuaXNJbml0aWFsaXplZCA9IHRydWU7XHJcbiAgICAgICAgICBzZXRUaW1lb3V0KCgpID0+IHtcclxuICAgICAgICAgICAgaWYgKHRoaXMubW9kZWwuaXNXZWJWaWV3ICYmIHRoaXMubW9kZWwuc2hvd1RyaWFsQmFyKSB7XHJcbiAgICAgICAgICAgICAgdGhpcy5tb2RlbC5zaG93VHJpYWxUaW1lcldpbmRvdyA9IHRydWU7XHJcbiAgICAgICAgICAgIH1cclxuICAgICAgICAgIH0sIDMwMDApO1xyXG4gICAgICAgICAgdGhpcy5tb2RlbC5zZXRab29tRnJvbVN0cmluZyh0aGlzLm1vZGVsPy5zZXR0aW5ncz8uem9vbSk7XHJcbiAgICAgICAgICBTdGlPYmplY3Qua2V5cyhvcHRpb25zKVxyXG4gICAgICAgICAgICAuZmlsdGVyKChwKSA9PiB0aGlzLlVTRURfUFJPUEVSVElFUy5pbmRleE9mKHApID09IC0xKVxyXG4gICAgICAgICAgICAuZm9yRWFjaCgocHJvcCkgPT4gKGV2ZW50RGF0YVtwcm9wXSA9IG9wdGlvbnNbcHJvcF0pKTtcclxuICAgICAgICAgIHRoaXMubW9kZWwuaW50ZXJmYWNlRXZlbnQubmV4dCh7IG5hbWU6IFwiTG9hZGVkXCIsIGRhdGE6IGV2ZW50RGF0YSB9KTtcclxuICAgICAgICB9LFxyXG4gICAgICAgIChlcnJvcjogYW55KSA9PiB7XHJcbiAgICAgICAgICBpZiAoIXRoaXMubW9kZWw/LnByb3BlcnRpZXM/LmNsb3VkUGxhbklkZW50KSB7XHJcbiAgICAgICAgICAgIHRoaXMudXNlclNlcnZpY2UuY2hlY2tMaWNlbnNlKCk7XHJcbiAgICAgICAgICB9XHJcbiAgICAgICAgfVxyXG4gICAgICApO1xyXG4gIH1cclxufVxyXG4iXX0=