import { Injectable } from "@angular/core";
import { Subject } from "rxjs";
import StiRectangleGeometryLayout from "../computed/StiRectangleGeometryLayout";
import { StiBarcodeElement } from "../elements/StiBarcodeElement";
import { StiImageElement } from "../elements/StiImageElement";
import { StiSignatureElement } from "../elements/StiSignatureElement";
import { StiLabelAlignment } from "../system/enums";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./mouse.service";
import * as i3 from "./sti-barcode.service";
export class StiComponentResizerService {
    constructor(model, mouseService, render, barcodeService) {
        this.model = model;
        this.mouseService = mouseService;
        this.render = render;
        this.barcodeService = barcodeService;
        this.isResizing = false;
        this.startFromRight = false;
        this.startFromLeft = false;
        this.startFromBottom = false;
        this.startFromBottomLeft = false;
        this.startFromBottomRight = false;
        this.maxWidth = 0;
        this.minWidth = 0;
        this.columnWidth = 64.326;
        this.StartResizeSubj = new Subject();
        this.EndResizeSubj = new Subject();
        mouseService.getDocumentMouseUp().subscribe((event) => {
            document.body.style.cursor = "";
            if (this.isResizing) {
                this.EndResizeSubj.next({ event: "End Resize" });
            }
            this.currentPage = null;
            this.currentPanel = null;
            this.isResizing = false;
            this.model.canDrag = true;
            this.startFromRight = false;
            this.startFromLeft = false;
            this.startFromBottom = false;
            this.startFromBottomLeft = false;
            this.startFromBottomRight = false;
            this.model.cursor = "default";
        });
        mouseService.getDocumentMouseMove().subscribe((event) => {
            this.resizeFromBottomRight(event);
            this.resizeFromBottomLeft(event);
            this.resizeFromLeft(event);
            this.resizeFromRight(event);
            this.resizeFromBottom(event);
        });
        model.formEvents.subscribe((e) => {
            if (e.name == "UpdateAllSizes") {
                this.elementsToUpdate = [];
                this.model.elementToUpdate = null;
                this.model.form.pages.forEach((p) => p.allElements.forEach((e) => this.elementsToUpdate.push(e)));
                this.updateElements();
            }
        });
    }
    updateElements() {
        if (this.elementsToUpdate.length > 0) {
            if (this.model.elementToUpdate == null) {
                this.model.elementToUpdate = this.elementsToUpdate.splice(0, 1)[0];
            }
            setTimeout(() => {
                this.updateElements();
            }, 0);
        }
        else {
        }
    }
    initResize(element, e, startPosition) {
        e.stopPropagation();
        document.body.style.cursor = "nwse-resize";
        this.freeAreaHeight = 0;
        this.startMouseX = e.clientX;
        this.startMouseY = e.clientY;
        this.startElementX = element.x;
        this.startHeight = element.height;
        this.model.lastFormState = this.model.form.saveToJsonObject().serialize();
        this.gridVerticalStep = this.model.form.settings.gridVerticalStep;
        element.width = this.startWidth = element.width;
        if (element instanceof StiSignatureElement || element instanceof StiImageElement) {
            this.startCanvasHeight = element.canvasHeight;
        }
        if (element instanceof StiBarcodeElement) {
            this.startCanvasHeight = element.Height;
        }
        this.element = element;
        this.maxWidth = 0;
        this.StartResizeSubj.next({ event: "Start Resize" });
        this.currentPage = this.model.getElementPage(element);
        this.currentPanel = this.model.getElementPanel(element);
        this.currentPage
            ? (this.maxWidth = this.currentPage?.contentAreaWidth)
            : (this.maxWidth = this.currentPanel.contentAreaWidth);
        this.minWidth = element.geometry.minWidth;
        let otherElements = Array.from(this.currentPage?.elements ?? this.currentPanel?.elements);
        otherElements.splice(otherElements.indexOf(this.element), 1);
        this.freeAreaHeight = this.render.getFreeToBottomResizeArea(this.element, otherElements);
        this.currentPage
            ? (this.columnWidth = Number((this.currentPage?.contentAreaWidth / this.model.form.settings.gridColumns).toFixed(2)))
            : (this.columnWidth = Number((this.currentPanel?.contentAreaWidth / this.model.form.settings.gridColumns).toFixed(2)));
        if (startPosition == "fromRight") {
            this.startFromRight = true;
            this.model.cursor = "ew-resize";
            element.width = Math.round((element.x + element.width) / this.columnWidth) * this.columnWidth - element.x;
            this.startWidth = element.width;
        }
        else if (startPosition == "fromLeft") {
            this.startFromLeft = true;
            this.model.cursor = "ew-resize";
            let startX = element.x;
            element.x = Math.round(element.x / this.columnWidth) * this.columnWidth;
            this.startElementX = element.x;
            element.width = startX > element.x ? element.width + (startX - element.x) : element.width - (element.x - startX);
            this.startWidth = element.width;
        }
        else if (startPosition == "fromBottom") {
            this.startFromBottom = true;
            this.model.cursor = "ns-resize";
            element.height =
                Math.round((element.height + element.y) / this.model.form.settings.gridVerticalStep) *
                    this.model.form.settings.gridVerticalStep -
                    element.y;
            this.startHeight = element.height;
        }
        else if (startPosition == "fromBottomLeft") {
            this.startFromBottomLeft = true;
            this.model.cursor = "nesw-resize";
            let startX = element.x;
            element.x = Math.round(element.x / this.columnWidth) * this.columnWidth;
            this.startElementX = element.x;
            element.width = startX > element.x ? element.width + (startX - element.x) : element.width - (element.x - startX);
            this.startWidth = element.width;
            element.height =
                Math.round((element.height + element.y) / this.model.form.settings.gridVerticalStep) *
                    this.model.form.settings.gridVerticalStep -
                    element.y;
            this.startHeight = element.height;
        }
        else if (startPosition == "fromBottomRight") {
            this.startFromBottomRight = true;
            this.model.cursor = "nwse-resize";
            element.width = Math.round((element.x + element.width) / this.columnWidth) * this.columnWidth - element.x;
            this.startWidth = element.width;
            element.height =
                Math.round((element.height + element.y) / this.model.form.settings.gridVerticalStep) *
                    this.model.form.settings.gridVerticalStep -
                    element.y;
            this.startHeight = element.height;
        }
        this.isResizing = true;
    }
    resizeFromBottomRight(event) {
        if (this.isResizing && this.startFromBottomRight) {
            let delta = this.startMouseX - event.clientX;
            let deltaTop = this.startMouseY - event.clientY;
            if (Math.abs(delta) >= (this.columnWidth * this.model.zoom) / 2) {
                let step = Math.round(Math.abs(delta) / (this.columnWidth * this.model.zoom));
                if (delta < 0) {
                    this.element.width = this.startWidth + this.columnWidth * step;
                }
                else {
                    this.element.width = this.startWidth - this.columnWidth * step;
                }
            }
            else {
                this.element.width = this.startWidth;
            }
            if (this.element.width + this.element.x > this.maxWidth) {
                this.element.width = this.maxWidth - this.element.x;
            }
            else if (this.element.width <= this.minWidth) {
                this.element.width = this.minWidth;
            }
            let step = Math.round(Math.abs(deltaTop) / (this.gridVerticalStep * this.model.zoom));
            if (deltaTop < 0) {
                this.element.height = this.startHeight + this.gridVerticalStep * step;
            }
            else {
                this.element.height = this.startHeight - this.gridVerticalStep * step;
            }
            if (this.element instanceof StiSignatureElement || this.element instanceof StiImageElement) {
                if (deltaTop < 0) {
                    this.element.canvasHeight = this.startCanvasHeight + this.gridVerticalStep * step;
                }
                else {
                    this.element.canvasHeight = this.startCanvasHeight - this.gridVerticalStep * step;
                }
                if (this.element.canvasHeight <= 34) {
                    this.element.canvasHeight = 34;
                }
            }
            if (this.element instanceof StiBarcodeElement) {
                if (deltaTop < 0) {
                    this.element.Height = this.startCanvasHeight + this.gridVerticalStep * step;
                }
                else {
                    this.element.Height = this.startCanvasHeight - this.gridVerticalStep * step;
                }
                if (this.element.Height <= 55) {
                    this.element.Height = 55;
                }
                this.element.Width =
                    this.element.width -
                        (this.element.label.alignment != StiLabelAlignment.Top ? this.element.label.width : 0) -
                        this.element.padding.right -
                        this.element.padding.left;
            }
            if (this.element.height <= this.element.geometry.minHeight) {
                this.element.height = this.element.geometry.minHeight;
            }
            if (this.element.height >= this.startHeight + this.freeAreaHeight) {
                this.element.height = this.startHeight + this.freeAreaHeight;
            }
            //
            let otherElements = Array.from(this.currentPage?.elements ?? this.currentPanel?.elements);
            otherElements.splice(otherElements.indexOf(this.element), 1);
            this.render.changeElementGeometry(this.element, otherElements);
        }
    }
    resizeFromBottomLeft(event) {
        if (this.isResizing && this.startFromBottomLeft) {
            let delta = this.startMouseX - event.clientX;
            let deltaTop = this.startMouseY - event.clientY;
            if (Math.abs(delta) >= (this.columnWidth * this.model.zoom) / 2) {
                let step = Math.round(Math.abs(delta) / (this.columnWidth * this.model.zoom));
                if (delta < 0) {
                    this.element.x = this.startElementX + this.columnWidth * step;
                    this.element.width = this.startWidth - this.columnWidth * step;
                }
                else {
                    this.element.x = this.startElementX - this.columnWidth * step;
                    this.element.width = this.startWidth + this.columnWidth * step;
                }
            }
            else {
                this.element.x = this.startElementX;
                this.element.width = this.startWidth;
            }
            if (this.element.x < 0) {
                this.element.x = 0;
                this.element.width = this.startWidth + this.startElementX;
            }
            else if (this.element.x + this.element.geometry.minWidth > this.startElementX + this.startWidth) {
                this.element.x = this.startWidth - this.element.geometry.minWidth + this.startElementX;
                this.element.width = this.element.geometry.minWidth;
            }
            let step = Math.round(Math.abs(deltaTop) / (this.gridVerticalStep * this.model.zoom));
            if (deltaTop < 0) {
                this.element.height = this.startHeight + this.gridVerticalStep * step;
            }
            else {
                this.element.height = this.startHeight - this.gridVerticalStep * step;
            }
            if (this.element instanceof StiSignatureElement || this.element instanceof StiImageElement) {
                if (deltaTop < 0) {
                    this.element.canvasHeight = this.startCanvasHeight + this.gridVerticalStep * step;
                }
                else {
                    this.element.canvasHeight = this.startCanvasHeight - this.gridVerticalStep * step;
                }
                if (this.element.canvasHeight <= 34) {
                    this.element.canvasHeight = 34;
                }
            }
            if (this.element instanceof StiBarcodeElement) {
                if (deltaTop < 0) {
                    this.element.Height = this.startCanvasHeight + this.gridVerticalStep * step;
                }
                else {
                    this.element.Height = this.startCanvasHeight - this.gridVerticalStep * step;
                }
                if (this.element.Height <= 55) {
                    this.element.Height = 55;
                }
                this.element.Width =
                    this.element.width -
                        (this.element.label.alignment != StiLabelAlignment.Top ? this.element.label.width : 0) -
                        this.element.padding.right -
                        this.element.padding.left;
            }
            if (this.element.height <= this.element.geometry.minHeight) {
                this.element.height = this.element.geometry.minHeight;
            }
            if (this.element.height >= this.startHeight + this.freeAreaHeight) {
                this.element.height = this.startHeight + this.freeAreaHeight;
            }
            //
            let otherElements = Array.from(this.currentPage?.elements ?? this.currentPanel?.elements);
            otherElements.splice(otherElements.indexOf(this.element), 1);
            this.render.changeElementGeometry(this.element, otherElements);
        }
    }
    resizeFromRight(event) {
        if (this.isResizing && this.startFromRight) {
            let delta = this.startMouseX - event.clientX;
            if (Math.abs(delta) >= (this.columnWidth * this.model.zoom) / 2) {
                let step = Math.round(Math.abs(delta) / (this.columnWidth * this.model.zoom));
                if (delta < 0) {
                    this.element.width = this.startWidth + this.columnWidth * step;
                }
                else {
                    this.element.width = this.startWidth - this.columnWidth * step;
                }
            }
            else {
                this.element.width = this.startWidth;
            }
            if (this.element.width + this.element.x > this.maxWidth) {
                this.element.width = this.maxWidth - this.element.x;
            }
            else if (this.element.width <= this.minWidth) {
                this.element.width = this.minWidth;
            }
            //
            let otherElements = Array.from(this.currentPage?.elements ?? this.currentPanel?.elements);
            otherElements.splice(otherElements.indexOf(this.element), 1);
            this.render.changeElementGeometry(this.element, otherElements);
        }
    }
    resizeFromLeft(event) {
        if (this.isResizing && this.startFromLeft) {
            let delta = this.startMouseX - event.clientX;
            if (Math.abs(delta) >= (this.columnWidth * this.model.zoom) / 2) {
                let step = Math.round(Math.abs(delta) / (this.columnWidth * this.model.zoom));
                if (delta < 0) {
                    this.element.x = this.startElementX + this.columnWidth * step;
                    this.element.width = this.startWidth - this.columnWidth * step;
                }
                else {
                    this.element.x = this.startElementX - this.columnWidth * step;
                    this.element.width = this.startWidth + this.columnWidth * step;
                }
            }
            else {
                this.element.x = this.startElementX;
                this.element.width = this.startWidth;
            }
            if (this.element.x < 0) {
                this.element.x = 0;
                this.element.width = this.startWidth + this.startElementX;
            }
            else if (this.element.x + this.element.geometry.minWidth > this.startElementX + this.startWidth) {
                this.element.x = this.startWidth - this.element.geometry.minWidth + this.startElementX;
                this.element.width = this.element.geometry.minWidth;
            }
            //
            let otherElements = Array.from(this.currentPage?.elements ?? this.currentPanel?.elements);
            otherElements.splice(otherElements.indexOf(this.element), 1);
            this.render.changeElementGeometry(this.element, otherElements);
        }
    }
    resizeFromBottom(event) {
        if (this.isResizing && this.startFromBottom) {
            let deltaTop = this.startMouseY - event.clientY;
            let step = Math.round(Math.abs(deltaTop) / (this.gridVerticalStep * this.model.zoom));
            if (deltaTop < 0) {
                this.element.height = this.startHeight + this.gridVerticalStep * step;
            }
            else {
                this.element.height = this.startHeight - this.gridVerticalStep * step;
            }
            if (this.element instanceof StiSignatureElement || this.element instanceof StiImageElement) {
                if (deltaTop < 0) {
                    this.element.canvasHeight = this.startCanvasHeight + this.gridVerticalStep * step;
                }
                else {
                    this.element.canvasHeight = this.startCanvasHeight - this.gridVerticalStep * step;
                }
                if (this.element.canvasHeight <= 34) {
                    this.element.canvasHeight = 34;
                }
            }
            if (this.element instanceof StiBarcodeElement) {
                if (deltaTop < 0) {
                    this.element.Height = this.startCanvasHeight + this.gridVerticalStep * step;
                }
                else {
                    this.element.Height = this.startCanvasHeight - this.gridVerticalStep * step;
                }
                if (this.element.Height <= 55) {
                    this.element.Height = 55;
                }
                this.element.Width = this.element.width - this.element.padding.right - this.element.padding.left;
            }
            if (this.element.height <= this.element.geometry.minHeight) {
                this.element.height = this.element.geometry.minHeight;
            }
            if (this.element.height >= this.startHeight + this.freeAreaHeight) {
                this.element.height = this.startHeight + this.freeAreaHeight;
            }
            //
            let otherElements = Array.from(this.currentPage?.elements ?? this.currentPanel?.elements);
            otherElements.splice(otherElements.indexOf(this.element), 1);
            this.render.changeElementGeometry(this.element, otherElements);
        }
    }
}
StiComponentResizerService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiComponentResizerService, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }, { token: StiRectangleGeometryLayout }, { token: i3.StiBarcodeService }], target: i0.ɵɵFactoryTarget.Injectable });
StiComponentResizerService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiComponentResizerService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiComponentResizerService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiMouseService }, { type: StiRectangleGeometryLayout }, { type: i3.StiBarcodeService }]; } });
//# sourceMappingURL=data:application/json;base64,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