import { Injectable } from "@angular/core";
import { StiDraggableService } from "./sti-draggable.service";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./mouse.service";
import * as i3 from "./http-client.service";
export class StiColumnDraggableService {
    constructor(model, mouseService, httpService) {
        this.model = model;
        this.mouseService = mouseService;
        this.httpService = httpService;
        this.isDragging = false;
        this.cursor = "";
        this.canDrop = false;
        this.fromTable = false;
        this._insertIndex = -1;
        this.headerClicked = false;
        mouseService.getDocumentMouseMove().subscribe((event) => {
            this.mouseMove(event);
        });
        mouseService.getDocumentMouseUp().subscribe((event) => {
            this.endDrag();
        });
    }
    mouseMove(event) {
        if (this.headerClicked) {
            if (!this.isDragging &&
                Math.max(Math.abs(this.mouseDownX - event.clientX), Math.abs(this.mouseDownY - event.clientY)) >
                    StiDraggableService.MOUSE_DELTA) {
                this.isDragging = true;
            }
            else if (this.isDragging) {
                this.left = event.clientX - this.startX + "px";
                this.top = event.clientY - this.startY + "px";
                this.getIndexOfBottomItem(event);
                this.canDrop ? (this.model.cursor = "copy") : (this.model.cursor = "not-allowed");
                //
            }
        }
    }
    endDrag() {
        if (this.isDragging) {
            if (this._insertIndex > this.items.indexOf(this.item)) {
                this._insertIndex--;
            }
            this.items["stopFit"] = true;
            this.items.splice(this.items.indexOf(this.item), 1);
            this.items.splice(this._insertIndex, 0, this.item);
            this.items["stopFit"] = false;
        }
        this.isDragging = false;
        this.fromTable = false;
        this.parentElement = null;
        this.canDrop = false;
        this.headerClicked = false;
        this.model.cursor = "default";
    }
    onHeaderClick(event, item, items, fromTable, parentElement) {
        this.mouseDownX = event.clientX;
        this.mouseDownY = event.clientY;
        this._item = item;
        this.items = items;
        this.itemLabel = item.label ?? item.header;
        this.headerClicked = true;
        if (fromTable) {
            this.startX = event.offsetX;
            this.startY = event.offsetY;
        }
        this._insertIndex = items.indexOf(item);
        this.headerRect = this.model.getPositionRelativeToForm(event.currentTarget);
        if (fromTable) {
            this.fromTable = true;
            this.parentElement = parentElement;
        }
    }
    getIndexOfBottomItem(event) {
        let index;
        let elements = document.elementsFromPoint(event.clientX, event.clientY);
        this.canDrop = false;
        if (this.fromTable) {
            elements.forEach((element) => {
                if (element?.classList.contains("column-drop-area")) {
                    this.canDrop = true;
                }
            });
        }
        else {
            elements.forEach((element) => {
                if (element?.classList.contains("drop-area")) {
                    this.canDrop = true;
                }
            });
        }
    }
    get insertIndex() {
        return this.isDragging ? this._insertIndex : -1;
    }
    set insertIndex(value) {
        this._insertIndex = value;
    }
    get item() {
        return this.isDragging ? this._item : null;
    }
}
StiColumnDraggableService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiColumnDraggableService, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }, { token: i3.StiHttpClientService }], target: i0.ɵɵFactoryTarget.Injectable });
StiColumnDraggableService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiColumnDraggableService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiColumnDraggableService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiMouseService }, { type: i3.StiHttpClientService }]; } });
//# sourceMappingURL=data:application/json;base64,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