import { Injectable } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
export class StiColorDialogService {
    constructor(model) {
        this.model = model;
        this.dialogWidth = 185;
        this.dialogHeight = 236;
        this.browserColors = [
            { name: "Transparent", color: "transparent" },
            { name: "Black", color: "0,0,0" },
            { name: "DimGray", color: "105,105,105" },
            { name: "Gray", color: "128,128,128" },
            { name: "DarkGray", color: "169,169,169" },
            { name: "Silver", color: "192,192,192" },
            { name: "LightGray", color: "211,211,211" },
            { name: "Gainsboro", color: "220,220,220" },
            { name: "WhiteSmoke", color: "245,245,245" },
            { name: "White", color: "255,255,255" },
            { name: "RosyBrown", color: "188,143,143" },
            { name: "IndianRed", color: "205,92,92" },
            { name: "Brown", color: "165,42,42" },
            { name: "Firebrick", color: "178,34,34" },
            { name: "LightCoral", color: "240,128,12" },
            { name: "Maroon", color: "128,0,0" },
            { name: "DarkRed", color: "139,0,0" },
            { name: "Red", color: "255,0,0" },
            { name: "Snow", color: "255,250,250" },
            { name: "MistyRose", color: "255,228,225" },
            { name: "Salmon", color: "250,128,114" },
            { name: "Tomato", color: "255,99,71" },
            { name: "DarkSalmon", color: "233,150,122" },
            { name: "Coral", color: "255,127,80" },
            { name: "OrangeRed", color: "255,69,0" },
            { name: "LightSalmon", color: "255,160,122" },
            { name: "Sienna", color: "160,82,45" },
            { name: "SeaShell", color: "255,245,23" },
            { name: "Chocolate", color: "210,105,30" },
            { name: "SaddleBrown", color: "139,69,19" },
            { name: "SandyBrown", color: "244,164,96" },
            { name: "PeachPuff", color: "255,218,185" },
            { name: "Peru", color: "205,133,63" },
            { name: "Linen", color: "250,240,230" },
            { name: "Bisque", color: "255,228,196" },
            { name: "DarkOrange", color: "255,140,0" },
            { name: "BurlyWood", color: "222,184,135" },
            { name: "Tan", color: "210,180,140" },
            { name: "AntiqueWhite", color: "250,235,215" },
            { name: "NavajoWhite", color: "255,222,173" },
            { name: "BlanchedAlmond", color: "255,235,205" },
            { name: "PapayaWhip", color: "255,239,213" },
            { name: "Moccasin", color: "255,228,181" },
            { name: "Orange", color: "255,165,0" },
            { name: "Wheat", color: "245,222,179" },
            { name: "OldLace", color: "253,245,230" },
            { name: "FloralWhite", color: "255,250,240" },
            { name: "DarkGoldenrod", color: "184,134,11" },
            { name: "Goldenrod", color: "218,165,32" },
            { name: "Cornsilk", color: "255,248,220" },
            { name: "Gold", color: "255,215,0" },
            { name: "Khaki", color: "240,230,140" },
            { name: "LemonChiffon", color: "255,250,205" },
            { name: "PaleGoldenrod", color: "238,232,170" },
            { name: "DarkKhaki", color: "189,183,107" },
            { name: "Beige", color: "245,245,220" },
            { name: "LightGoldenrodYellow", color: "250,250,210" },
            { name: "Olive", color: "128,128,0" },
            { name: "Yellow", color: "255,255,0" },
            { name: "LightYellow", color: "255,255,224" },
            { name: "Ivory", color: "255,255,240" },
            { name: "OliveDrab", color: "107,142,35" },
            { name: "YellowGreen", color: "154,205,50" },
            { name: "DarkOliveGreen", color: "85,107,47" },
            { name: "GreenYellow", color: "173,255,47" },
            { name: "Chartreuse", color: "127,255,0" },
            { name: "LawnGreen", color: "124,252,0" },
            { name: "DarkSeaGreen", color: "143,188,139" },
            { name: "ForestGreen", color: "34,139,34" },
            { name: "LimeGreen", color: "50,205,50" },
            { name: "LightGreen", color: "144,238,144" },
            { name: "PaleGreen", color: "152,251,152" },
            { name: "DarkGreen", color: "0,100,0" },
            { name: "Green", color: "0,128,0" },
            { name: "Lime", color: "0,255,0" },
            { name: "Honeydew", color: "240,255,240" },
            { name: "SeaGreen", color: "46,139,87" },
            { name: "MediumSeaGreen", color: "60,179,113" },
            { name: "SpringGreen", color: "0,255,127" },
            { name: "MintCream", color: "245,255,250" },
            { name: "MediumSpringGreen", color: "0,250,154" },
            { name: "MediumAquamarine", color: "102,205,170" },
            { name: "Aquamarine", color: "127,255,212" },
            { name: "Turquoise", color: "64,224,20" },
            { name: "LightSeaGreen", color: "32,178,170" },
            { name: "MediumTurquoise", color: "72,209,204" },
            { name: "DarkSlateGray", color: "47,79,79" },
            { name: "PaleTurquoise", color: "175,238,23" },
            { name: "Teal", color: "0,128,12" },
            { name: "DarkCyan", color: "0,139,139" },
            { name: "Aqua", color: "0,255,255" },
            { name: "Cyan", color: "0,255,255" },
            { name: "LightCyan", color: "224,255,255" },
            { name: "Azure", color: "240,255,255" },
            { name: "DarkTurquoise", color: "0,206,209" },
            { name: "CadetBlue", color: "95,158,160" },
            { name: "PowderBlue", color: "176,224,230" },
            { name: "LightBlue", color: "173,216,230" },
            { name: "DeepSkyBlue", color: "0,191,255" },
            { name: "SkyBlue", color: "135,206,235" },
            { name: "LightSkyBlue", color: "135,206,250" },
            { name: "SteelBlue", color: "70,130,180" },
            { name: "AliceBlue", color: "240,248,255" },
            { name: "DodgerBlue", color: "30,144,255" },
            { name: "SlateGray", color: "112,128,144" },
            { name: "LightSlateGray", color: "119,136,153" },
            { name: "LightSteelBlue", color: "176,196,222" },
            { name: "CornflowerBlue", color: "100,149,237" },
            { name: "RoyalBlue", color: "65,105,225" },
            { name: "MidnightBlue", color: "25,25,112" },
            { name: "Lavender", color: "230,230,250" },
            { name: "Navy", color: "0,0,12" },
            { name: "DarkBlue", color: "0,0,139" },
            { name: "MediumBlue", color: "0,0,205" },
            { name: "Blue", color: "0,0,255" },
            { name: "GhostWhite", color: "248,248,255" },
            { name: "SlateBlue", color: "106,90,205" },
            { name: "DarkSlateBlue", color: "72,61,139" },
            { name: "MediumSlateBlue", color: "123,104,23" },
            { name: "MediumPurple", color: "147,112,219" },
            { name: "BlueViolet", color: "138,43,226" },
            { name: "Indigo", color: "75,0,130" },
            { name: "DarkOrchid", color: "153,50,204" },
            { name: "DarkViolet", color: "148,0,211" },
            { name: "MediumOrchid", color: "186,85,211" },
            { name: "Thistle", color: "216,191,216" },
            { name: "Plum", color: "221,160,221" },
            { name: "Violet", color: "238,130,23" },
            { name: "Purple", color: "128,0,12" },
            { name: "DarkMagenta", color: "139,0,139" },
            { name: "Magenta", color: "255,0,255" },
            { name: "Fuchsia", color: "255,0,255" },
            { name: "Orchid", color: "218,112,214" },
            { name: "MediumVioletRed", color: "199,21,133" },
            { name: "DeepPink", color: "255,20,147" },
            { name: "HotPink", color: "255,105,180" },
            { name: "LavenderBlush", color: "255,240,245" },
            { name: "PaleVioletRed", color: "219,112,147" },
            { name: "Crimson", color: "220,20,60" },
            { name: "Pink", color: "255,192,203" },
            { name: "LightPink", color: "255,182,193" },
        ];
        this.themeColors = [
            { color: "255,255,255" },
            { color: "0,0,0" },
            { color: "231,230,230" },
            { color: "68,84,106" },
            { color: "91,155,213" },
            { color: "237,125,49" },
            { color: "165,165,165" },
            { color: "255,192,0" },
            { color: "68,114,196" },
            { color: "112,173,71" },
            { color: "242,242,242" },
            { color: "127,127,127" },
            { color: "208,206,206" },
            { color: "214,220,228" },
            { color: "222,235,246" },
            { color: "251,229,213" },
            { color: "237,237,237" },
            { color: "255,242,204" },
            { color: "217,226,243" },
            { color: "226,239,217" },
            { color: "216,216,216" },
            { color: "89,89,89" },
            { color: "174,171,171" },
            { color: "173,185,202" },
            { color: "189,215,238" },
            { color: "247,203,172" },
            { color: "219,219,219" },
            { color: "254,229,153" },
            { color: "180,198,231" },
            { color: "197,224,179" },
            { color: "191,191,191" },
            { color: "63,63,63" },
            { color: "117,112,112" },
            { color: "132,150,176" },
            { color: "156,195,229" },
            { color: "224,177,131" },
            { color: "201,201,201" },
            { color: "255,217,101" },
            { color: "142,170,219" },
            { color: "168,208,141" },
            { color: "165,165,165" },
            { color: "38,38,38" },
            { color: "58,56,56" },
            { color: "50,63,79" },
            { color: "46,117,181" },
            { color: "197,90,17" },
            { color: "123,123,123" },
            { color: "191,144,0" },
            { color: "47,84,150" },
            { color: "83,129,53" },
            { color: "127,127,127" },
            { color: "12,12,12" },
            { color: "23,22,22" },
            { color: "34,42,53" },
            { color: "30,78,121" },
            { color: "131,60,11" },
            { color: "82,82,82" },
            { color: "127,96,0" },
            { color: "31,56,100" },
            { color: "55,86,35" },
        ];
        this.standardColors = [
            { color: "192,0,0" },
            { color: "255,0,0" },
            { color: "255,192,0" },
            { color: "255,255,0" },
            { color: "146,208,80" },
            { color: "0,176,80" },
            { color: "0,176,240" },
            { color: "0,112,192" },
            { color: "0,32,96" },
            { color: "112,48,160" },
        ];
        this.isRichText = false;
    }
    rgbToHex(rgb) {
        let rgbArray = rgb.split(",");
        let hex = "#";
        rgbArray.forEach((item) => {
            hex += this.componentToHex(Number(item));
        });
        return hex;
    }
    componentToHex(c) {
        let hex = c.toString(16);
        return hex.length == 1 ? "0" + hex : hex;
    }
    openDialog(element, object, isRichText) {
        this.isRichText = isRichText;
        let elementRect = this.model.getPositionRelativeToForm(element);
        let windowHeight = window.innerHeight;
        let windowWidth = window.innerWidth;
        this.currentColorObject = object;
        this.cloneOfCurrentColorObject = object.clone();
        if (elementRect.bottom + this.dialogHeight > windowHeight - 32) {
            this.dialogY = elementRect.top - this.dialogHeight;
        }
        else {
            this.dialogY = elementRect.bottom;
        }
        if (elementRect.left + this.dialogWidth > windowWidth) {
            this.dialogX = windowWidth - this.dialogWidth;
        }
        else {
            this.dialogX = elementRect.left;
        }
        this.model.showColorDialog = true;
    }
}
StiColorDialogService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiColorDialogService, deps: [{ token: i1.StiModelService }], target: i0.ɵɵFactoryTarget.Injectable });
StiColorDialogService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiColorDialogService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiColorDialogService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }]; } });
//# sourceMappingURL=data:application/json;base64,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