import { Injectable } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./mouse.service";
export class StiChangesService {
    constructor(model, mouseService) {
        this.model = model;
        this.mouseService = mouseService;
        this.forceChanged = false;
        this.started = false;
        model.formEvents.subscribe((e) => {
            if (e.name == "SetForm" || e.name == "UpdateForm") {
                this.savedForm = this.model.form.saveToJsonObject({ notSerializeImages: true }).serialize();
            }
        });
    }
    start() {
        if (this.started) {
            return;
        }
        let this_ = this;
        setInterval(() => {
            if (this_.model.form &&
                this_.model.draggingElement == null &&
                !this_.mouseService.leftButtonDown &&
                this.model.elementToUpdate == null) {
                let s = this_.model.form.saveToJsonObject({ notSerializeImages: true }).serialize();
                let equals = this_.savedForm == s;
                if (!equals || this_.forceChanged) {
                    this_.savedForm = s;
                    this_.model.formEvents.next({ name: "FormChanged" });
                    this_.forceChanged = false;
                }
            }
        }, 1000);
    }
    forceChanges() {
        this.forceChanged = true;
    }
}
StiChangesService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiChangesService, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }], target: i0.ɵɵFactoryTarget.Injectable });
StiChangesService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiChangesService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiChangesService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiMouseService }]; } });
//# sourceMappingURL=data:application/json;base64,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