import { Injectable } from "@angular/core";
import { StiBarcodeElement } from "../elements/StiBarcodeElement";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./mouse.service";
import * as i3 from "./http-client.service";
import * as i4 from "./sti-undo-service";
export class StiBarcodeService {
    constructor(model, mouseService, httpService, undoService) {
        this.model = model;
        this.mouseService = mouseService;
        this.httpService = httpService;
        this.undoService = undoService;
        this.timerSarted = false;
        this.initialized = false;
        this.previewWidth = 192;
        this.showBarcodePreview = false;
        this.barcodeStyles = [
            {
                value: 1,
                innerHtml: `
        <rect
          x="0"
          y="0"
          width="165.3543"
          height="165.3543"
          fill="red"
          style="fill:rgba(255,255,255,0);"
          shape-rendering="crispEdges"
        />
        <polygon
          points="13.23,13.23 59.53,13.23 59.53,59.53 13.23,59.53 13.23,19.78 19.84,19.78 19.84,52.91 52.91,52.91 52.91,19.84 13.23,19.84 "
          style="fill:rgba(0,0,0,1);"
        />
        <polygon
          points="13.23,105.83 59.53,105.83 59.53,152.13 13.23,152.13 13.23,112.37 19.84,112.37 19.84,145.51 52.91,145.51 52.91,112.44 13.23,112.44 "
          style="fill:rgba(0,0,0,1);"
        />
        <polygon
          points="105.83,13.23 152.13,13.23 152.13,59.53 105.83,59.53 105.83,19.78 112.44,19.78 112.44,52.91 145.51,52.91 145.51,19.84 105.83,19.84 "
          style="fill:rgba(0,0,0,1);"
        />
        <polygon points="26.46,26.46 46.3,26.46 46.3,46.3 26.46,46.3 " style="fill:rgba(0,0,0,1);" />
        <polygon points="26.46,119.06 46.3,119.06 46.3,138.9 26.46,138.9 " style="fill:rgba(0,0,0,1);" />
        <polygon points="119.06,26.46 138.9,26.46 138.9,46.3 119.06,46.3 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.37,13.23 86.05,13.23 85.98,19.91 79.37,19.91 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.92,13.23 92.66,13.23 92.53,19.84 85.92,19.84 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.53,13.23 99.21,13.23 99.15,19.91 92.53,19.91 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,19.84 72.82,19.84 72.76,26.46 66.14,26.46 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.69,19.84 79.44,19.84 79.3,26.46 72.69,26.46 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.3,19.78 85.98,19.78 85.92,26.52 79.3,26.52 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,19.78 99.21,19.78 99.21,26.52 92.6,26.52 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.37,26.39 86.05,26.39 85.98,33.07 79.37,33.07 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.92,26.46 92.66,26.46 92.53,33.07 85.92,33.07 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.53,26.39 99.21,26.39 99.15,33.14 92.53,33.14 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,33.07 72.82,33.07 72.76,39.69 66.14,39.69 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.69,33.07 79.37,33.07 79.3,39.75 72.69,39.75 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,33 99.21,33 99.21,39.75 92.6,39.75 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.76,39.62 79.37,39.62 79.37,46.3 72.76,46.3 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,39.62 99.21,39.62 99.21,46.3 92.6,46.3 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,46.3 72.76,46.3 72.76,52.98 66.14,52.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.98,46.3 92.6,46.3 92.6,52.91 85.98,52.91 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,52.85 72.76,52.85 72.76,59.53 66.14,59.53 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.37,52.91 85.98,52.91 85.98,59.53 79.37,59.53 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,52.91 99.21,52.91 99.21,59.53 92.6,59.53 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.76,59.53 79.37,59.53 79.37,66.14 72.76,66.14 " style="fill:rgba(0,0,0,1);" />
        <polygon points="13.23,66.14 19.91,66.14 19.84,72.82 13.23,72.82 " style="fill:rgba(0,0,0,1);" />
        <polygon points="19.78,66.14 26.52,66.14 26.39,72.82 19.78,72.82 " style="fill:rgba(0,0,0,1);" />
        <polygon points="26.39,66.14 33.14,66.14 33,72.82 26.39,72.82 " style="fill:rgba(0,0,0,1);" />
        <polygon points="33,66.14 39.75,66.14 39.62,72.76 33,72.76 " style="fill:rgba(0,0,0,1);" />
        <polygon points="39.62,66.14 46.3,66.14 46.23,72.76 39.62,72.76 " style="fill:rgba(0,0,0,1);" />
        <polygon points="52.91,66.14 59.59,66.14 59.53,72.76 52.91,72.76 " style="fill:rgba(0,0,0,1);" />
        <polygon points="59.46,66.14 66.21,66.14 66.08,72.82 59.46,72.82 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.08,66.14 72.76,66.14 72.69,72.76 66.08,72.76 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.98,66.14 92.6,66.14 92.6,72.82 85.98,72.82 " style="fill:rgba(0,0,0,1);" />
        <polygon points="99.21,66.14 105.83,66.14 105.83,72.82 99.21,72.82 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.44,66.14 119.06,66.14 119.06,72.76 112.44,72.76 " style="fill:rgba(0,0,0,1);" />
        <polygon points="125.67,66.14 132.28,66.14 132.28,72.82 125.67,72.82 " style="fill:rgba(0,0,0,1);" />
        <polygon points="138.9,66.14 145.51,66.14 145.51,72.82 138.9,72.82 " style="fill:rgba(0,0,0,1);" />
        <polygon points="13.23,72.69 19.91,72.69 19.84,79.37 13.23,79.37 " style="fill:rgba(0,0,0,1);" />
        <polygon points="19.78,72.69 26.52,72.69 26.39,79.37 19.78,79.37 " style="fill:rgba(0,0,0,1);" />
        <polygon points="26.39,72.69 33.07,72.69 33,79.44 26.39,79.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="46.3,72.76 52.91,72.76 52.91,79.44 46.3,79.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="59.53,72.69 66.14,72.69 66.14,79.37 59.53,79.37 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.76,72.76 79.37,72.76 79.37,79.44 72.76,79.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.98,72.69 92.66,72.69 92.6,79.37 85.98,79.37 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.53,72.76 99.28,72.76 99.15,79.44 92.53,79.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="99.15,72.69 105.89,72.69 105.76,79.37 99.15,79.37 " style="fill:rgba(0,0,0,1);" />
        <polygon points="105.76,72.76 112.44,72.76 112.37,79.44 105.76,79.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="125.67,72.69 132.35,72.69 132.28,79.44 125.67,79.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.22,72.76 138.96,72.76 138.83,79.37 132.22,79.37 " style="fill:rgba(0,0,0,1);" />
        <polygon points="138.83,72.69 145.58,72.69 145.45,79.37 138.83,79.37 " style="fill:rgba(0,0,0,1);" />
        <polygon points="145.45,72.76 152.13,72.76 152.06,79.44 145.45,79.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="26.46,79.3 33.07,79.3 33.07,85.98 26.46,85.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="39.69,79.37 46.37,79.37 46.3,85.98 39.69,85.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="46.23,79.3 52.98,79.3 52.85,85.98 46.23,85.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="52.85,79.37 59.53,79.37 59.46,85.98 52.85,85.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,79.37 72.82,79.37 72.76,85.98 66.14,85.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.69,79.3 79.37,79.3 79.3,85.98 72.69,85.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,79.3 99.21,79.3 99.21,86.05 92.6,86.05 " style="fill:rgba(0,0,0,1);" />
        <polygon points="105.83,79.3 112.51,79.3 112.44,86.05 105.83,86.05 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.37,79.37 119.06,79.37 118.99,85.98 112.37,85.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="125.67,79.3 132.28,79.3 132.28,85.98 125.67,85.98 " style="fill:rgba(0,0,0,1);" />
        <polygon points="145.51,79.3 152.13,79.3 152.13,86.05 145.51,86.05 " style="fill:rgba(0,0,0,1);" />
        <polygon points="13.23,85.98 19.84,85.98 19.84,92.6 13.23,92.6 " style="fill:rgba(0,0,0,1);" />
        <polygon points="33.07,85.98 39.69,85.98 39.69,92.66 33.07,92.66 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.98,85.98 92.66,85.98 92.6,92.6 85.98,92.6 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.53,85.92 99.28,85.92 99.15,92.66 92.53,92.66 " style="fill:rgba(0,0,0,1);" />
        <polygon points="99.15,85.98 105.89,85.98 105.76,92.6 99.15,92.6 " style="fill:rgba(0,0,0,1);" />
        <polygon points="105.76,85.92 112.44,85.92 112.37,92.6 105.76,92.6 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.28,85.98 138.96,85.98 138.9,92.6 132.28,92.6 " style="fill:rgba(0,0,0,1);" />
        <polygon points="138.83,85.98 145.58,85.98 145.45,92.66 138.83,92.66 " style="fill:rgba(0,0,0,1);" />
        <polygon points="145.45,85.92 152.13,85.92 152.06,92.6 145.45,92.6 " style="fill:rgba(0,0,0,1);" />
        <polygon points="19.84,92.6 26.46,92.6 26.46,99.21 19.84,99.21 " style="fill:rgba(0,0,0,1);" />
        <polygon points="33.07,92.53 39.75,92.53 39.69,99.21 33.07,99.21 " style="fill:rgba(0,0,0,1);" />
        <polygon points="39.62,92.6 46.3,92.6 46.23,99.21 39.62,99.21 " style="fill:rgba(0,0,0,1);" />
        <polygon points="52.91,92.6 59.53,92.6 59.53,99.21 52.91,99.21 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,92.6 72.82,92.6 72.76,99.28 66.14,99.28 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.69,92.6 79.37,92.6 79.3,99.21 72.69,99.21 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,92.53 99.21,92.53 99.21,99.28 92.6,99.28 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.44,92.6 119.06,92.6 119.06,99.28 112.44,99.28 " style="fill:rgba(0,0,0,1);" />
        <polygon points="138.9,92.53 145.51,92.53 145.51,99.21 138.9,99.21 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,99.15 72.76,99.15 72.76,105.89 66.14,105.89 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.37,99.21 85.98,99.21 85.98,105.83 79.37,105.83 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,99.15 99.21,99.15 99.21,105.83 92.6,105.83 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.44,99.15 119.06,99.15 119.06,105.83 112.44,105.83 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.28,99.21 138.9,99.21 138.9,105.83 132.28,105.83 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,105.76 72.76,105.76 72.76,112.44 66.14,112.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.98,105.83 92.6,105.83 92.6,112.44 85.98,112.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="99.21,105.83 105.83,105.83 105.83,112.44 99.21,112.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="119.06,105.83 125.74,105.83 125.67,112.51 119.06,112.51 " style="fill:rgba(0,0,0,1);" />
        <polygon points="125.6,105.83 132.28,105.83 132.22,112.44 125.6,112.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="138.9,105.83 145.58,105.83 145.51,112.44 138.9,112.44 " style="fill:rgba(0,0,0,1);" />
        <polygon points="145.45,105.83 152.13,105.83 152.06,112.51 145.45,112.51 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.76,112.44 79.44,112.44 79.37,119.12 72.76,119.12 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.3,112.44 85.98,112.44 85.92,119.12 79.3,119.12 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.44,112.44 119.12,112.44 119.06,119.06 112.44,119.06 " style="fill:rgba(0,0,0,1);" />
        <polygon points="118.99,112.37 125.67,112.37 125.6,119.12 118.99,119.12 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.28,112.44 138.9,112.44 138.9,119.12 132.28,119.12 " style="fill:rgba(0,0,0,1);" />
        <polygon points="145.51,112.37 152.13,112.37 152.13,119.06 145.51,119.06 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,119.06 72.82,119.06 72.76,125.74 66.14,125.74 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.69,118.99 79.44,118.99 79.3,125.74 72.69,125.74 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.3,118.99 86.05,118.99 85.92,125.67 79.3,125.67 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.92,119.06 92.6,119.06 92.53,125.74 85.92,125.74 " style="fill:rgba(0,0,0,1);" />
        <polygon points="99.21,119.06 105.83,119.06 105.83,125.74 99.21,125.74 " style="fill:rgba(0,0,0,1);" />
        <polygon points="119.06,118.99 125.74,118.99 125.67,125.67 119.06,125.67 " style="fill:rgba(0,0,0,1);" />
        <polygon points="125.6,119.06 132.35,119.06 132.22,125.74 125.6,125.74 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.22,118.99 138.9,118.99 138.83,125.74 132.22,125.74 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,125.6 72.82,125.6 72.76,132.35 66.14,132.35 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.69,125.6 79.37,125.6 79.3,132.35 72.69,132.35 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.98,125.6 92.66,125.6 92.6,132.28 85.98,132.28 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.53,125.67 99.28,125.67 99.15,132.35 92.53,132.35 " style="fill:rgba(0,0,0,1);" />
        <polygon points="99.15,125.6 105.89,125.6 105.76,132.28 99.15,132.28 " style="fill:rgba(0,0,0,1);" />
        <polygon points="105.76,125.67 112.51,125.67 112.37,132.35 105.76,132.35 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.37,125.67 119.06,125.67 118.99,132.35 112.37,132.35 " style="fill:rgba(0,0,0,1);" />
        <polygon points="125.67,125.6 132.35,125.6 132.28,132.35 125.67,132.35 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.22,125.6 138.9,125.6 138.83,132.35 132.22,132.35 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,132.22 72.82,132.22 72.76,138.96 66.14,138.96 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.69,132.22 79.37,132.22 79.3,138.9 72.69,138.9 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,132.22 99.21,132.22 99.21,138.96 92.6,138.96 " style="fill:rgba(0,0,0,1);" />
        <polygon points="105.83,132.22 112.51,132.22 112.44,138.96 105.83,138.96 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.37,132.22 119.06,132.22 118.99,138.96 112.37,138.96 " style="fill:rgba(0,0,0,1);" />
        <polygon points="125.67,132.22 132.35,132.22 132.28,138.9 125.67,138.9 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.22,132.22 138.9,132.22 138.83,138.96 132.22,138.96 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,138.83 72.76,138.83 72.76,145.58 66.14,145.58 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.37,138.9 86.05,138.9 85.98,145.58 79.37,145.58 " style="fill:rgba(0,0,0,1);" />
        <polygon points="85.92,138.9 92.66,138.9 92.53,145.51 85.92,145.51 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.53,138.83 99.28,138.83 99.15,145.58 92.53,145.58 " style="fill:rgba(0,0,0,1);" />
        <polygon points="99.15,138.9 105.89,138.9 105.76,145.51 99.15,145.51 " style="fill:rgba(0,0,0,1);" />
        <polygon points="105.76,138.83 112.51,138.83 112.37,145.51 105.76,145.51 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.37,138.83 119.12,138.83 118.99,145.58 112.37,145.58 " style="fill:rgba(0,0,0,1);" />
        <polygon points="118.99,138.9 125.67,138.9 125.6,145.51 118.99,145.51 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.28,138.83 138.96,138.83 138.9,145.58 132.28,145.58 " style="fill:rgba(0,0,0,1);" />
        <polygon points="138.83,138.9 145.51,138.9 145.45,145.51 138.83,145.51 " style="fill:rgba(0,0,0,1);" />
        <polygon points="66.14,145.45 72.82,145.45 72.76,152.13 66.14,152.13 " style="fill:rgba(0,0,0,1);" />
        <polygon points="72.69,145.51 79.44,145.51 79.3,152.13 72.69,152.13 " style="fill:rgba(0,0,0,1);" />
        <polygon points="79.3,145.45 85.98,145.45 85.92,152.13 79.3,152.13 " style="fill:rgba(0,0,0,1);" />
        <polygon points="92.6,145.45 99.21,145.45 99.21,152.13 92.6,152.13 " style="fill:rgba(0,0,0,1);" />
        <polygon points="112.44,145.45 119.06,145.45 119.06,152.13 112.44,152.13 " style="fill:rgba(0,0,0,1);" />
        <polygon points="132.28,145.45 138.9,145.45 138.9,152.13 132.28,152.13 " style="fill:rgba(0,0,0,1);" />
        `,
            },
            {
                value: 2,
                innerHtml: `<rect
      x="0"
      y="0"
      width="165.3543"
      height="165.3543"
      fill="red"
      style="fill:rgba(255,255,255,0);"
      shape-rendering="crispEdges"
    />
    <pattern
      id="glassc90e5498faaa405c98d9f9ff330814e1"
      x="13.22835"
      y="13.22835"
      width="138.8976"
      height="138.8976"
      patternUnits="userSpaceOnUse"
    >
      <rect x="0" y="0" width="138.8976" height="138.8976" style="fill:rgb(68,152,176);fill-opacity:1;" />
      <rect x="0" y="0" width="138.8976" height="69.44881" style="fill:rgb(80,164,188);fill-opacity:1;" />
    </pattern>
    <polygon
      points="13.23,29.76 13.55,26.54 14.49,23.44 16.02,20.58 18.07,18.07 20.58,16.02 23.44,14.49 26.54,13.55 29.76,13.23 59.53,13.23 59.53,59.53 13.23,59.53 13.23,29.76 19.84,29.76 19.84,52.91 52.91,52.91 52.91,19.84 29.76,19.84 27.2,20.18 24.8,21.17 22.75,22.75 21.17,24.8 20.18,27.2 19.84,29.76 "
      style="fill:url(#glassc90e5498faaa405c98d9f9ff330814e1);"
    />
    <polygon
      points="13.23,122.36 13.23,105.83 59.53,105.83 59.53,152.13 29.76,152.13 26.54,151.81 23.44,150.87 20.58,149.34 18.07,147.28 16.02,144.78 14.49,141.92 13.55,138.82 13.23,135.59 13.23,122.36 19.84,122.36 19.84,135.59 20.18,138.16 21.17,140.55 22.75,142.61 24.8,144.18 27.2,145.17 29.76,145.51 52.91,145.51 52.91,112.44 19.84,112.44 19.84,122.36 "
      style="fill:url(#glassc90e5498faaa405c98d9f9ff330814e1);"
    />
    <polygon
      points="105.83,29.76 105.83,13.23 135.59,13.23 138.82,13.55 141.92,14.49 144.78,16.02 147.28,18.07 149.34,20.58 150.87,23.44 151.81,26.54 152.13,29.76 152.13,59.53 105.83,59.53 105.83,29.76 112.44,29.76 112.44,52.91 145.51,52.91 145.51,29.76 145.17,27.2 144.18,24.8 142.61,22.75 140.55,21.17 138.16,20.18 135.59,19.84 112.44,19.84 112.44,29.76 "
      style="fill:url(#glassc90e5498faaa405c98d9f9ff330814e1);"
    />
    <linearGradient
      id="gradient9942a6e9fa9d459eb5f1f9ab88391ebf"
      gradientUnits="userSpaceOnUse"
      x1="16.1676322453161"
      y1="44.2778655522009"
      x2="149.18668446611"
      y2="121.076451159225"
    >
      <stop offset="0%" stop-color="#039898" />
      <stop offset="100%" stop-color="#2C6E9A" />
    </linearGradient>
    <polygon
      points="26.46,31.09 26.61,29.89 27.08,28.77 27.81,27.81 28.77,27.08 29.89,26.61 31.09,26.46 46.3,26.46 46.3,46.3 26.46,46.3 "
      style="fill:url(#gradient9942a6e9fa9d459eb5f1f9ab88391ebf);"
    />
    <polygon
      points="26.46,119.06 46.3,119.06 46.3,138.9 31.09,138.9 29.89,138.74 28.77,138.28 27.81,137.54 27.08,136.58 26.61,135.47 26.46,134.27 "
      style="fill:url(#gradient9942a6e9fa9d459eb5f1f9ab88391ebf);"
    />
    <polygon
      points="119.06,26.46 134.27,26.46 135.47,26.61 136.58,27.08 137.54,27.81 138.28,28.77 138.74,29.89 138.9,31.09 138.9,46.3 119.06,46.3 "
      style="fill:url(#gradient9942a6e9fa9d459eb5f1f9ab88391ebf);"
    />
    <polygon points="79.37,16.54 82.68,13.23 85.98,16.54 82.68,19.84 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,16.54 89.29,13.23 92.6,16.54 89.29,19.84 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,16.54 95.91,13.23 99.21,16.54 95.91,19.84 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,23.15 69.45,19.84 72.76,23.15 69.45,26.46 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,23.15 76.06,19.84 79.37,23.15 76.06,26.46 " style="fill:rgba(96,75,117,1);" />
    <polygon points="79.37,23.15 82.68,19.84 85.98,23.15 82.68,26.46 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,23.15 95.91,19.84 99.21,23.15 95.91,26.46 " style="fill:rgba(96,75,117,1);" />
    <polygon points="79.37,29.76 82.68,26.46 85.98,29.76 82.68,33.07 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,29.76 89.29,26.46 92.6,29.76 89.29,33.07 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,29.76 95.91,26.46 99.21,29.76 95.91,33.07 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,36.38 69.45,33.07 72.76,36.38 69.45,39.69 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,36.38 76.06,33.07 79.37,36.38 76.06,39.69 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,36.38 95.91,33.07 99.21,36.38 95.91,39.69 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,42.99 76.06,39.69 79.37,42.99 76.06,46.3 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,42.99 95.91,39.69 99.21,42.99 95.91,46.3 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,49.61 69.45,46.3 72.76,49.61 69.45,52.91 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,49.61 89.29,46.3 92.6,49.61 89.29,52.91 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,56.22 69.45,52.91 72.76,56.22 69.45,59.53 " style="fill:rgba(96,75,117,1);" />
    <polygon points="79.37,56.22 82.68,52.91 85.98,56.22 82.68,59.53 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,56.22 95.91,52.91 99.21,56.22 95.91,59.53 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,62.83 76.06,59.53 79.37,62.83 76.06,66.14 " style="fill:rgba(96,75,117,1);" />
    <polygon points="13.23,69.45 16.54,66.14 19.84,69.45 16.54,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="19.84,69.45 23.15,66.14 26.46,69.45 23.15,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="26.46,69.45 29.76,66.14 33.07,69.45 29.76,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="33.07,69.45 36.38,66.14 39.69,69.45 36.38,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="39.69,69.45 42.99,66.14 46.3,69.45 42.99,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="52.91,69.45 56.22,66.14 59.53,69.45 56.22,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="59.53,69.45 62.83,66.14 66.14,69.45 62.83,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,69.45 69.45,66.14 72.76,69.45 69.45,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,69.45 89.29,66.14 92.6,69.45 89.29,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="99.21,69.45 102.52,66.14 105.83,69.45 102.52,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,69.45 115.75,66.14 119.06,69.45 115.75,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="125.67,69.45 128.98,66.14 132.28,69.45 128.98,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="138.9,69.45 142.2,66.14 145.51,69.45 142.2,72.76 " style="fill:rgba(96,75,117,1);" />
    <polygon points="13.23,76.06 16.54,72.76 19.84,76.06 16.54,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="19.84,76.06 23.15,72.76 26.46,76.06 23.15,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="26.46,76.06 29.76,72.76 33.07,76.06 29.76,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="46.3,76.06 49.61,72.76 52.91,76.06 49.61,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="59.53,76.06 62.83,72.76 66.14,76.06 62.83,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,76.06 76.06,72.76 79.37,76.06 76.06,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,76.06 89.29,72.76 92.6,76.06 89.29,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,76.06 95.91,72.76 99.21,76.06 95.91,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="99.21,76.06 102.52,72.76 105.83,76.06 102.52,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="105.83,76.06 109.13,72.76 112.44,76.06 109.13,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="125.67,76.06 128.98,72.76 132.28,76.06 128.98,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,76.06 135.59,72.76 138.9,76.06 135.59,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="138.9,76.06 142.2,72.76 145.51,76.06 142.2,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="145.51,76.06 148.82,72.76 152.13,76.06 148.82,79.37 " style="fill:rgba(96,75,117,1);" />
    <polygon points="26.46,82.68 29.76,79.37 33.07,82.68 29.76,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="39.69,82.68 42.99,79.37 46.3,82.68 42.99,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="46.3,82.68 49.61,79.37 52.91,82.68 49.61,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="52.91,82.68 56.22,79.37 59.53,82.68 56.22,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,82.68 69.45,79.37 72.76,82.68 69.45,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,82.68 76.06,79.37 79.37,82.68 76.06,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,82.68 95.91,79.37 99.21,82.68 95.91,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="105.83,82.68 109.13,79.37 112.44,82.68 109.13,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,82.68 115.75,79.37 119.06,82.68 115.75,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="125.67,82.68 128.98,79.37 132.28,82.68 128.98,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="145.51,82.68 148.82,79.37 152.13,82.68 148.82,85.98 " style="fill:rgba(96,75,117,1);" />
    <polygon points="13.23,89.29 16.54,85.98 19.84,89.29 16.54,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="33.07,89.29 36.38,85.98 39.69,89.29 36.38,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,89.29 89.29,85.98 92.6,89.29 89.29,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,89.29 95.91,85.98 99.21,89.29 95.91,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="99.21,89.29 102.52,85.98 105.83,89.29 102.52,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="105.83,89.29 109.13,85.98 112.44,89.29 109.13,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,89.29 135.59,85.98 138.9,89.29 135.59,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="138.9,89.29 142.2,85.98 145.51,89.29 142.2,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="145.51,89.29 148.82,85.98 152.13,89.29 148.82,92.6 " style="fill:rgba(96,75,117,1);" />
    <polygon points="19.84,95.91 23.15,92.6 26.46,95.91 23.15,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="33.07,95.91 36.38,92.6 39.69,95.91 36.38,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="39.69,95.91 42.99,92.6 46.3,95.91 42.99,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="52.91,95.91 56.22,92.6 59.53,95.91 56.22,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,95.91 69.45,92.6 72.76,95.91 69.45,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,95.91 76.06,92.6 79.37,95.91 76.06,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,95.91 95.91,92.6 99.21,95.91 95.91,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,95.91 115.75,92.6 119.06,95.91 115.75,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="138.9,95.91 142.2,92.6 145.51,95.91 142.2,99.21 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,102.52 69.45,99.21 72.76,102.52 69.45,105.83 " style="fill:rgba(96,75,117,1);" />
    <polygon points="79.37,102.52 82.68,99.21 85.98,102.52 82.68,105.83 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,102.52 95.91,99.21 99.21,102.52 95.91,105.83 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,102.52 115.75,99.21 119.06,102.52 115.75,105.83 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,102.52 135.59,99.21 138.9,102.52 135.59,105.83 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,109.13 69.45,105.83 72.76,109.13 69.45,112.44 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,109.13 89.29,105.83 92.6,109.13 89.29,112.44 " style="fill:rgba(96,75,117,1);" />
    <polygon points="99.21,109.13 102.52,105.83 105.83,109.13 102.52,112.44 " style="fill:rgba(96,75,117,1);" />
    <polygon points="119.06,109.13 122.36,105.83 125.67,109.13 122.36,112.44 " style="fill:rgba(96,75,117,1);" />
    <polygon points="125.67,109.13 128.98,105.83 132.28,109.13 128.98,112.44 " style="fill:rgba(96,75,117,1);" />
    <polygon points="138.9,109.13 142.2,105.83 145.51,109.13 142.2,112.44 " style="fill:rgba(96,75,117,1);" />
    <polygon points="145.51,109.13 148.82,105.83 152.13,109.13 148.82,112.44 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,115.75 76.06,112.44 79.37,115.75 76.06,119.06 " style="fill:rgba(96,75,117,1);" />
    <polygon points="79.37,115.75 82.68,112.44 85.98,115.75 82.68,119.06 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,115.75 115.75,112.44 119.06,115.75 115.75,119.06 " style="fill:rgba(96,75,117,1);" />
    <polygon points="119.06,115.75 122.36,112.44 125.67,115.75 122.36,119.06 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,115.75 135.59,112.44 138.9,115.75 135.59,119.06 " style="fill:rgba(96,75,117,1);" />
    <polygon points="145.51,115.75 148.82,112.44 152.13,115.75 148.82,119.06 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,122.36 69.45,119.06 72.76,122.36 69.45,125.67 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,122.36 76.06,119.06 79.37,122.36 76.06,125.67 " style="fill:rgba(96,75,117,1);" />
    <polygon points="79.37,122.36 82.68,119.06 85.98,122.36 82.68,125.67 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,122.36 89.29,119.06 92.6,122.36 89.29,125.67 " style="fill:rgba(96,75,117,1);" />
    <polygon points="99.21,122.36 102.52,119.06 105.83,122.36 102.52,125.67 " style="fill:rgba(96,75,117,1);" />
    <polygon points="119.06,122.36 122.36,119.06 125.67,122.36 122.36,125.67 " style="fill:rgba(96,75,117,1);" />
    <polygon points="125.67,122.36 128.98,119.06 132.28,122.36 128.98,125.67 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,122.36 135.59,119.06 138.9,122.36 135.59,125.67 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,128.98 69.45,125.67 72.76,128.98 69.45,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,128.98 76.06,125.67 79.37,128.98 76.06,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,128.98 89.29,125.67 92.6,128.98 89.29,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,128.98 95.91,125.67 99.21,128.98 95.91,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="99.21,128.98 102.52,125.67 105.83,128.98 102.52,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="105.83,128.98 109.13,125.67 112.44,128.98 109.13,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,128.98 115.75,125.67 119.06,128.98 115.75,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="125.67,128.98 128.98,125.67 132.28,128.98 128.98,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,128.98 135.59,125.67 138.9,128.98 135.59,132.28 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,135.59 69.45,132.28 72.76,135.59 69.45,138.9 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,135.59 76.06,132.28 79.37,135.59 76.06,138.9 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,135.59 95.91,132.28 99.21,135.59 95.91,138.9 " style="fill:rgba(96,75,117,1);" />
    <polygon points="105.83,135.59 109.13,132.28 112.44,135.59 109.13,138.9 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,135.59 115.75,132.28 119.06,135.59 115.75,138.9 " style="fill:rgba(96,75,117,1);" />
    <polygon points="125.67,135.59 128.98,132.28 132.28,135.59 128.98,138.9 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,135.59 135.59,132.28 138.9,135.59 135.59,138.9 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,142.2 69.45,138.9 72.76,142.2 69.45,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="79.37,142.2 82.68,138.9 85.98,142.2 82.68,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="85.98,142.2 89.29,138.9 92.6,142.2 89.29,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,142.2 95.91,138.9 99.21,142.2 95.91,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="99.21,142.2 102.52,138.9 105.83,142.2 102.52,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="105.83,142.2 109.13,138.9 112.44,142.2 109.13,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,142.2 115.75,138.9 119.06,142.2 115.75,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="119.06,142.2 122.36,138.9 125.67,142.2 122.36,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,142.2 135.59,138.9 138.9,142.2 135.59,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="138.9,142.2 142.2,138.9 145.51,142.2 142.2,145.51 " style="fill:rgba(96,75,117,1);" />
    <polygon points="66.14,148.82 69.45,145.51 72.76,148.82 69.45,152.13 " style="fill:rgba(96,75,117,1);" />
    <polygon points="72.76,148.82 76.06,145.51 79.37,148.82 76.06,152.13 " style="fill:rgba(96,75,117,1);" />
    <polygon points="79.37,148.82 82.68,145.51 85.98,148.82 82.68,152.13 " style="fill:rgba(96,75,117,1);" />
    <polygon points="92.6,148.82 95.91,145.51 99.21,148.82 95.91,152.13 " style="fill:rgba(96,75,117,1);" />
    <polygon points="112.44,148.82 115.75,145.51 119.06,148.82 115.75,152.13 " style="fill:rgba(96,75,117,1);" />
    <polygon points="132.28,148.82 135.59,145.51 138.9,148.82 135.59,152.13 " style="fill:rgba(96,75,117,1);" />
      `,
            },
            {
                value: 3,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(255,255,255,0);"
            shape-rendering="crispEdges"
          />
          <pattern
            id="glass24c3381e8d144e708cc01571cde7c032"
            x="13.22835"
            y="13.22835"
            width="138.8976"
            height="138.8976"
            patternUnits="userSpaceOnUse"
          >
            <rect x="0" y="0" width="138.8976" height="138.8976" style="fill:rgb(57,94,133);fill-opacity:1;" />
            <rect x="0" y="0" width="138.8976" height="69.44881" style="fill:rgb(69,106,145);fill-opacity:1;" />
          </pattern>
          <polygon
            points="59.53,36.38 59.08,40.89 57.77,45.24 55.63,49.24 52.75,52.75 49.24,55.63 45.24,57.77 40.89,59.08 36.38,59.53 31.86,59.08 27.52,57.77 23.52,55.63 20.01,52.75 17.13,49.24 14.99,45.24 13.67,40.89 13.23,36.38 13.67,31.86 14.99,27.52 17.13,23.52 20.01,20.01 23.52,17.13 27.52,14.99 31.86,13.67 36.38,13.23 40.89,13.67 45.24,14.99 49.24,17.13 52.75,20.01 55.63,23.52 57.77,27.52 59.08,31.86 59.53,36.38 52.91,36.38 52.6,33.15 51.65,30.05 50.13,27.19 48.07,24.69 45.56,22.63 42.71,21.1 39.6,20.16 36.38,19.84 33.15,20.16 30.05,21.1 27.19,22.63 24.69,24.69 22.63,27.19 21.1,30.05 20.16,33.15 19.84,36.38 20.16,39.6 21.1,42.71 22.63,45.56 24.69,48.07 27.19,50.13 30.05,51.65 33.15,52.6 36.38,52.91 39.6,52.6 42.71,51.65 45.56,50.13 48.07,48.07 50.13,45.56 51.65,42.71 52.6,39.6 52.91,36.38 "
            style="fill:url(#glass24c3381e8d144e708cc01571cde7c032);"
          />
          <polygon
            points="59.53,128.98 59.08,133.49 57.77,137.84 55.63,141.84 52.75,145.35 49.24,148.22 45.24,150.36 40.89,151.68 36.38,152.13 31.86,151.68 27.52,150.36 23.52,148.22 20.01,145.35 17.13,141.84 14.99,137.84 13.67,133.49 13.23,128.98 13.67,124.46 14.99,120.12 17.13,116.12 20.01,112.61 23.52,109.73 27.52,107.59 31.86,106.27 36.38,105.83 40.89,106.27 45.24,107.59 49.24,109.73 52.75,112.61 55.63,116.12 57.77,120.12 59.08,124.46 59.53,128.98 52.91,128.98 52.6,125.75 51.65,122.65 50.13,119.79 48.07,117.28 45.56,115.23 42.71,113.7 39.6,112.76 36.38,112.44 33.15,112.76 30.05,113.7 27.19,115.23 24.69,117.28 22.63,119.79 21.1,122.65 20.16,125.75 19.84,128.98 20.16,132.2 21.1,135.3 22.63,138.16 24.69,140.67 27.19,142.73 30.05,144.25 33.15,145.19 36.38,145.51 39.6,145.19 42.71,144.25 45.56,142.73 48.07,140.67 50.13,138.16 51.65,135.3 52.6,132.2 52.91,128.98 "
            style="fill:url(#glass24c3381e8d144e708cc01571cde7c032);"
          />
          <polygon
            points="152.13,36.38 151.68,40.89 150.36,45.24 148.22,49.24 145.35,52.75 141.84,55.63 137.84,57.77 133.49,59.08 128.98,59.53 124.46,59.08 120.12,57.77 116.12,55.63 112.61,52.75 109.73,49.24 107.59,45.24 106.27,40.89 105.83,36.38 106.27,31.86 107.59,27.52 109.73,23.52 112.61,20.01 116.12,17.13 120.12,14.99 124.46,13.67 128.98,13.23 133.49,13.67 137.84,14.99 141.84,17.13 145.35,20.01 148.22,23.52 150.36,27.52 151.68,31.86 152.13,36.38 145.51,36.38 145.19,33.15 144.25,30.05 142.73,27.19 140.67,24.69 138.16,22.63 135.3,21.1 132.2,20.16 128.98,19.84 125.75,20.16 122.65,21.1 119.79,22.63 117.28,24.69 115.23,27.19 113.7,30.05 112.76,33.15 112.44,36.38 112.76,39.6 113.7,42.71 115.23,45.56 117.28,48.07 119.79,50.13 122.65,51.65 125.75,52.6 128.98,52.91 132.2,52.6 135.3,51.65 138.16,50.13 140.67,48.07 142.73,45.56 144.25,42.71 145.19,39.6 145.51,36.38 "
            style="fill:url(#glass24c3381e8d144e708cc01571cde7c032);"
          />
          <linearGradient
            id="gradientace97d5e2e9b44daa7466b1acf42cbdc"
            gradientUnits="userSpaceOnUse"
            x1="22.0024585616932"
            y1="77.3688099608975"
            x2="143.351858149733"
            y2="87.9855067505283"
          >
            <stop offset="0%" stop-color="#647335" />
            <stop offset="50%" stop-color="#89496A" />
            <stop offset="100%" stop-color="#647335" />
          </linearGradient>
          <polygon
            points="46.3,36.38 46.11,38.31 45.54,40.17 44.63,41.89 43.39,43.39 41.89,44.63 40.17,45.54 38.31,46.11 36.38,46.3 34.44,46.11 32.58,45.54 30.87,44.63 29.36,43.39 28.13,41.89 27.21,40.17 26.65,38.31 26.46,36.38 26.65,34.44 27.21,32.58 28.13,30.87 29.36,29.36 30.87,28.13 32.58,27.21 34.44,26.65 36.38,26.46 38.31,26.65 40.17,27.21 41.89,28.13 43.39,29.36 44.63,30.87 45.54,32.58 46.11,34.44 46.3,36.38 "
            style="fill:url(#gradientace97d5e2e9b44daa7466b1acf42cbdc);"
          />
          <polygon
            points="46.3,128.98 46.11,130.91 45.54,132.77 44.63,134.49 43.39,135.99 41.89,137.23 40.17,138.14 38.31,138.71 36.38,138.9 34.44,138.71 32.58,138.14 30.87,137.23 29.36,135.99 28.13,134.49 27.21,132.77 26.65,130.91 26.46,128.98 26.65,127.04 27.21,125.18 28.13,123.46 29.36,121.96 30.87,120.73 32.58,119.81 34.44,119.25 36.38,119.06 38.31,119.25 40.17,119.81 41.89,120.73 43.39,121.96 44.63,123.46 45.54,125.18 46.11,127.04 46.3,128.98 "
            style="fill:url(#gradientace97d5e2e9b44daa7466b1acf42cbdc);"
          />
          <polygon
            points="138.9,36.38 138.71,38.31 138.14,40.17 137.23,41.89 135.99,43.39 134.49,44.63 132.77,45.54 130.91,46.11 128.98,46.3 127.04,46.11 125.18,45.54 123.46,44.63 121.96,43.39 120.73,41.89 119.81,40.17 119.25,38.31 119.06,36.38 119.25,34.44 119.81,32.58 120.73,30.87 121.96,29.36 123.46,28.13 125.18,27.21 127.04,26.65 128.98,26.46 130.91,26.65 132.77,27.21 134.49,28.13 135.99,29.36 137.23,30.87 138.14,32.58 138.71,34.44 138.9,36.38 "
            style="fill:url(#gradientace97d5e2e9b44daa7466b1acf42cbdc);"
          />
          <polygon
            points="85.98,16.54 85.73,17.8 85.02,18.87 83.94,19.59 82.68,19.84 81.41,19.59 80.34,18.87 79.62,17.8 79.37,16.54 79.62,15.27 80.34,14.2 81.41,13.48 82.68,13.23 83.94,13.48 85.02,14.2 85.73,15.27 85.98,16.54 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,16.54 92.35,17.8 91.63,18.87 90.56,19.59 89.29,19.84 88.03,19.59 86.95,18.87 86.24,17.8 85.98,16.54 86.24,15.27 86.95,14.2 88.03,13.48 89.29,13.23 90.56,13.48 91.63,14.2 92.35,15.27 92.6,16.54 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,16.54 98.96,17.8 98.24,18.87 97.17,19.59 95.91,19.84 94.64,19.59 93.57,18.87 92.85,17.8 92.6,16.54 92.85,15.27 93.57,14.2 94.64,13.48 95.91,13.23 97.17,13.48 98.24,14.2 98.96,15.27 99.21,16.54 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,23.15 72.5,24.42 71.79,25.49 70.71,26.2 69.45,26.46 68.18,26.2 67.11,25.49 66.39,24.42 66.14,23.15 66.39,21.88 67.11,20.81 68.18,20.09 69.45,19.84 70.71,20.09 71.79,20.81 72.5,21.88 72.76,23.15 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,23.15 79.12,24.42 78.4,25.49 77.33,26.2 76.06,26.46 74.8,26.2 73.72,25.49 73.01,24.42 72.76,23.15 73.01,21.88 73.72,20.81 74.8,20.09 76.06,19.84 77.33,20.09 78.4,20.81 79.12,21.88 79.37,23.15 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="85.98,23.15 85.73,24.42 85.02,25.49 83.94,26.2 82.68,26.46 81.41,26.2 80.34,25.49 79.62,24.42 79.37,23.15 79.62,21.88 80.34,20.81 81.41,20.09 82.68,19.84 83.94,20.09 85.02,20.81 85.73,21.88 85.98,23.15 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,23.15 98.96,24.42 98.24,25.49 97.17,26.2 95.91,26.46 94.64,26.2 93.57,25.49 92.85,24.42 92.6,23.15 92.85,21.88 93.57,20.81 94.64,20.09 95.91,19.84 97.17,20.09 98.24,20.81 98.96,21.88 99.21,23.15 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="85.98,29.76 85.73,31.03 85.02,32.1 83.94,32.82 82.68,33.07 81.41,32.82 80.34,32.1 79.62,31.03 79.37,29.76 79.62,28.5 80.34,27.43 81.41,26.71 82.68,26.46 83.94,26.71 85.02,27.43 85.73,28.5 85.98,29.76 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,29.76 92.35,31.03 91.63,32.1 90.56,32.82 89.29,33.07 88.03,32.82 86.95,32.1 86.24,31.03 85.98,29.76 86.24,28.5 86.95,27.43 88.03,26.71 89.29,26.46 90.56,26.71 91.63,27.43 92.35,28.5 92.6,29.76 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,29.76 98.96,31.03 98.24,32.1 97.17,32.82 95.91,33.07 94.64,32.82 93.57,32.1 92.85,31.03 92.6,29.76 92.85,28.5 93.57,27.43 94.64,26.71 95.91,26.46 97.17,26.71 98.24,27.43 98.96,28.5 99.21,29.76 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,36.38 72.5,37.64 71.79,38.72 70.71,39.43 69.45,39.69 68.18,39.43 67.11,38.72 66.39,37.64 66.14,36.38 66.39,35.11 67.11,34.04 68.18,33.32 69.45,33.07 70.71,33.32 71.79,34.04 72.5,35.11 72.76,36.38 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,36.38 79.12,37.64 78.4,38.72 77.33,39.43 76.06,39.69 74.8,39.43 73.72,38.72 73.01,37.64 72.76,36.38 73.01,35.11 73.72,34.04 74.8,33.32 76.06,33.07 77.33,33.32 78.4,34.04 79.12,35.11 79.37,36.38 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,36.38 98.96,37.64 98.24,38.72 97.17,39.43 95.91,39.69 94.64,39.43 93.57,38.72 92.85,37.64 92.6,36.38 92.85,35.11 93.57,34.04 94.64,33.32 95.91,33.07 97.17,33.32 98.24,34.04 98.96,35.11 99.21,36.38 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,42.99 79.12,44.26 78.4,45.33 77.33,46.05 76.06,46.3 74.8,46.05 73.72,45.33 73.01,44.26 72.76,42.99 73.01,41.73 73.72,40.65 74.8,39.94 76.06,39.69 77.33,39.94 78.4,40.65 79.12,41.73 79.37,42.99 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,42.99 98.96,44.26 98.24,45.33 97.17,46.05 95.91,46.3 94.64,46.05 93.57,45.33 92.85,44.26 92.6,42.99 92.85,41.73 93.57,40.65 94.64,39.94 95.91,39.69 97.17,39.94 98.24,40.65 98.96,41.73 99.21,42.99 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,49.61 72.5,50.87 71.79,51.94 70.71,52.66 69.45,52.91 68.18,52.66 67.11,51.94 66.39,50.87 66.14,49.61 66.39,48.34 67.11,47.27 68.18,46.55 69.45,46.3 70.71,46.55 71.79,47.27 72.5,48.34 72.76,49.61 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,49.61 92.35,50.87 91.63,51.94 90.56,52.66 89.29,52.91 88.03,52.66 86.95,51.94 86.24,50.87 85.98,49.61 86.24,48.34 86.95,47.27 88.03,46.55 89.29,46.3 90.56,46.55 91.63,47.27 92.35,48.34 92.6,49.61 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,56.22 72.5,57.49 71.79,58.56 70.71,59.28 69.45,59.53 68.18,59.28 67.11,58.56 66.39,57.49 66.14,56.22 66.39,54.95 67.11,53.88 68.18,53.17 69.45,52.91 70.71,53.17 71.79,53.88 72.5,54.95 72.76,56.22 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="85.98,56.22 85.73,57.49 85.02,58.56 83.94,59.28 82.68,59.53 81.41,59.28 80.34,58.56 79.62,57.49 79.37,56.22 79.62,54.95 80.34,53.88 81.41,53.17 82.68,52.91 83.94,53.17 85.02,53.88 85.73,54.95 85.98,56.22 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,56.22 98.96,57.49 98.24,58.56 97.17,59.28 95.91,59.53 94.64,59.28 93.57,58.56 92.85,57.49 92.6,56.22 92.85,54.95 93.57,53.88 94.64,53.17 95.91,52.91 97.17,53.17 98.24,53.88 98.96,54.95 99.21,56.22 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,62.83 79.12,64.1 78.4,65.17 77.33,65.89 76.06,66.14 74.8,65.89 73.72,65.17 73.01,64.1 72.76,62.83 73.01,61.57 73.72,60.5 74.8,59.78 76.06,59.53 77.33,59.78 78.4,60.5 79.12,61.57 79.37,62.83 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="19.84,69.45 19.59,70.71 18.87,71.79 17.8,72.5 16.54,72.76 15.27,72.5 14.2,71.79 13.48,70.71 13.23,69.45 13.48,68.18 14.2,67.11 15.27,66.39 16.54,66.14 17.8,66.39 18.87,67.11 19.59,68.18 19.84,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="26.46,69.45 26.2,70.71 25.49,71.79 24.42,72.5 23.15,72.76 21.88,72.5 20.81,71.79 20.09,70.71 19.84,69.45 20.09,68.18 20.81,67.11 21.88,66.39 23.15,66.14 24.42,66.39 25.49,67.11 26.2,68.18 26.46,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="33.07,69.45 32.82,70.71 32.1,71.79 31.03,72.5 29.76,72.76 28.5,72.5 27.43,71.79 26.71,70.71 26.46,69.45 26.71,68.18 27.43,67.11 28.5,66.39 29.76,66.14 31.03,66.39 32.1,67.11 32.82,68.18 33.07,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="39.69,69.45 39.43,70.71 38.72,71.79 37.64,72.5 36.38,72.76 35.11,72.5 34.04,71.79 33.32,70.71 33.07,69.45 33.32,68.18 34.04,67.11 35.11,66.39 36.38,66.14 37.64,66.39 38.72,67.11 39.43,68.18 39.69,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="46.3,69.45 46.05,70.71 45.33,71.79 44.26,72.5 42.99,72.76 41.73,72.5 40.65,71.79 39.94,70.71 39.69,69.45 39.94,68.18 40.65,67.11 41.73,66.39 42.99,66.14 44.26,66.39 45.33,67.11 46.05,68.18 46.3,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="59.53,69.45 59.28,70.71 58.56,71.79 57.49,72.5 56.22,72.76 54.95,72.5 53.88,71.79 53.17,70.71 52.91,69.45 53.17,68.18 53.88,67.11 54.95,66.39 56.22,66.14 57.49,66.39 58.56,67.11 59.28,68.18 59.53,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="66.14,69.45 65.89,70.71 65.17,71.79 64.1,72.5 62.83,72.76 61.57,72.5 60.5,71.79 59.78,70.71 59.53,69.45 59.78,68.18 60.5,67.11 61.57,66.39 62.83,66.14 64.1,66.39 65.17,67.11 65.89,68.18 66.14,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,69.45 72.5,70.71 71.79,71.79 70.71,72.5 69.45,72.76 68.18,72.5 67.11,71.79 66.39,70.71 66.14,69.45 66.39,68.18 67.11,67.11 68.18,66.39 69.45,66.14 70.71,66.39 71.79,67.11 72.5,68.18 72.76,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,69.45 92.35,70.71 91.63,71.79 90.56,72.5 89.29,72.76 88.03,72.5 86.95,71.79 86.24,70.71 85.98,69.45 86.24,68.18 86.95,67.11 88.03,66.39 89.29,66.14 90.56,66.39 91.63,67.11 92.35,68.18 92.6,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="105.83,69.45 105.58,70.71 104.86,71.79 103.79,72.5 102.52,72.76 101.25,72.5 100.18,71.79 99.46,70.71 99.21,69.45 99.46,68.18 100.18,67.11 101.25,66.39 102.52,66.14 103.79,66.39 104.86,67.11 105.58,68.18 105.83,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="119.06,69.45 118.8,70.71 118.09,71.79 117.01,72.5 115.75,72.76 114.48,72.5 113.41,71.79 112.69,70.71 112.44,69.45 112.69,68.18 113.41,67.11 114.48,66.39 115.75,66.14 117.01,66.39 118.09,67.11 118.8,68.18 119.06,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="132.28,69.45 132.03,70.71 131.31,71.79 130.24,72.5 128.98,72.76 127.71,72.5 126.64,71.79 125.92,70.71 125.67,69.45 125.92,68.18 126.64,67.11 127.71,66.39 128.98,66.14 130.24,66.39 131.31,67.11 132.03,68.18 132.28,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="145.51,69.45 145.26,70.71 144.54,71.79 143.47,72.5 142.2,72.76 140.94,72.5 139.87,71.79 139.15,70.71 138.9,69.45 139.15,68.18 139.87,67.11 140.94,66.39 142.2,66.14 143.47,66.39 144.54,67.11 145.26,68.18 145.51,69.45 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="19.84,76.06 19.59,77.33 18.87,78.4 17.8,79.12 16.54,79.37 15.27,79.12 14.2,78.4 13.48,77.33 13.23,76.06 13.48,74.8 14.2,73.72 15.27,73.01 16.54,72.76 17.8,73.01 18.87,73.72 19.59,74.8 19.84,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="26.46,76.06 26.2,77.33 25.49,78.4 24.42,79.12 23.15,79.37 21.88,79.12 20.81,78.4 20.09,77.33 19.84,76.06 20.09,74.8 20.81,73.72 21.88,73.01 23.15,72.76 24.42,73.01 25.49,73.72 26.2,74.8 26.46,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="33.07,76.06 32.82,77.33 32.1,78.4 31.03,79.12 29.76,79.37 28.5,79.12 27.43,78.4 26.71,77.33 26.46,76.06 26.71,74.8 27.43,73.72 28.5,73.01 29.76,72.76 31.03,73.01 32.1,73.72 32.82,74.8 33.07,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="52.91,76.06 52.66,77.33 51.94,78.4 50.87,79.12 49.61,79.37 48.34,79.12 47.27,78.4 46.55,77.33 46.3,76.06 46.55,74.8 47.27,73.72 48.34,73.01 49.61,72.76 50.87,73.01 51.94,73.72 52.66,74.8 52.91,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="66.14,76.06 65.89,77.33 65.17,78.4 64.1,79.12 62.83,79.37 61.57,79.12 60.5,78.4 59.78,77.33 59.53,76.06 59.78,74.8 60.5,73.72 61.57,73.01 62.83,72.76 64.1,73.01 65.17,73.72 65.89,74.8 66.14,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,76.06 79.12,77.33 78.4,78.4 77.33,79.12 76.06,79.37 74.8,79.12 73.72,78.4 73.01,77.33 72.76,76.06 73.01,74.8 73.72,73.72 74.8,73.01 76.06,72.76 77.33,73.01 78.4,73.72 79.12,74.8 79.37,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,76.06 92.35,77.33 91.63,78.4 90.56,79.12 89.29,79.37 88.03,79.12 86.95,78.4 86.24,77.33 85.98,76.06 86.24,74.8 86.95,73.72 88.03,73.01 89.29,72.76 90.56,73.01 91.63,73.72 92.35,74.8 92.6,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,76.06 98.96,77.33 98.24,78.4 97.17,79.12 95.91,79.37 94.64,79.12 93.57,78.4 92.85,77.33 92.6,76.06 92.85,74.8 93.57,73.72 94.64,73.01 95.91,72.76 97.17,73.01 98.24,73.72 98.96,74.8 99.21,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="105.83,76.06 105.58,77.33 104.86,78.4 103.79,79.12 102.52,79.37 101.25,79.12 100.18,78.4 99.46,77.33 99.21,76.06 99.46,74.8 100.18,73.72 101.25,73.01 102.52,72.76 103.79,73.01 104.86,73.72 105.58,74.8 105.83,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="112.44,76.06 112.19,77.33 111.47,78.4 110.4,79.12 109.13,79.37 107.87,79.12 106.8,78.4 106.08,77.33 105.83,76.06 106.08,74.8 106.8,73.72 107.87,73.01 109.13,72.76 110.4,73.01 111.47,73.72 112.19,74.8 112.44,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="132.28,76.06 132.03,77.33 131.31,78.4 130.24,79.12 128.98,79.37 127.71,79.12 126.64,78.4 125.92,77.33 125.67,76.06 125.92,74.8 126.64,73.72 127.71,73.01 128.98,72.76 130.24,73.01 131.31,73.72 132.03,74.8 132.28,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="138.9,76.06 138.65,77.33 137.93,78.4 136.86,79.12 135.59,79.37 134.32,79.12 133.25,78.4 132.54,77.33 132.28,76.06 132.54,74.8 133.25,73.72 134.32,73.01 135.59,72.76 136.86,73.01 137.93,73.72 138.65,74.8 138.9,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="145.51,76.06 145.26,77.33 144.54,78.4 143.47,79.12 142.2,79.37 140.94,79.12 139.87,78.4 139.15,77.33 138.9,76.06 139.15,74.8 139.87,73.72 140.94,73.01 142.2,72.76 143.47,73.01 144.54,73.72 145.26,74.8 145.51,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="152.13,76.06 151.87,77.33 151.16,78.4 150.08,79.12 148.82,79.37 147.55,79.12 146.48,78.4 145.76,77.33 145.51,76.06 145.76,74.8 146.48,73.72 147.55,73.01 148.82,72.76 150.08,73.01 151.16,73.72 151.87,74.8 152.13,76.06 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="33.07,82.68 32.82,83.94 32.1,85.02 31.03,85.73 29.76,85.98 28.5,85.73 27.43,85.02 26.71,83.94 26.46,82.68 26.71,81.41 27.43,80.34 28.5,79.62 29.76,79.37 31.03,79.62 32.1,80.34 32.82,81.41 33.07,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="46.3,82.68 46.05,83.94 45.33,85.02 44.26,85.73 42.99,85.98 41.73,85.73 40.65,85.02 39.94,83.94 39.69,82.68 39.94,81.41 40.65,80.34 41.73,79.62 42.99,79.37 44.26,79.62 45.33,80.34 46.05,81.41 46.3,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="52.91,82.68 52.66,83.94 51.94,85.02 50.87,85.73 49.61,85.98 48.34,85.73 47.27,85.02 46.55,83.94 46.3,82.68 46.55,81.41 47.27,80.34 48.34,79.62 49.61,79.37 50.87,79.62 51.94,80.34 52.66,81.41 52.91,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="59.53,82.68 59.28,83.94 58.56,85.02 57.49,85.73 56.22,85.98 54.95,85.73 53.88,85.02 53.17,83.94 52.91,82.68 53.17,81.41 53.88,80.34 54.95,79.62 56.22,79.37 57.49,79.62 58.56,80.34 59.28,81.41 59.53,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,82.68 72.5,83.94 71.79,85.02 70.71,85.73 69.45,85.98 68.18,85.73 67.11,85.02 66.39,83.94 66.14,82.68 66.39,81.41 67.11,80.34 68.18,79.62 69.45,79.37 70.71,79.62 71.79,80.34 72.5,81.41 72.76,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,82.68 79.12,83.94 78.4,85.02 77.33,85.73 76.06,85.98 74.8,85.73 73.72,85.02 73.01,83.94 72.76,82.68 73.01,81.41 73.72,80.34 74.8,79.62 76.06,79.37 77.33,79.62 78.4,80.34 79.12,81.41 79.37,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,82.68 98.96,83.94 98.24,85.02 97.17,85.73 95.91,85.98 94.64,85.73 93.57,85.02 92.85,83.94 92.6,82.68 92.85,81.41 93.57,80.34 94.64,79.62 95.91,79.37 97.17,79.62 98.24,80.34 98.96,81.41 99.21,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="112.44,82.68 112.19,83.94 111.47,85.02 110.4,85.73 109.13,85.98 107.87,85.73 106.8,85.02 106.08,83.94 105.83,82.68 106.08,81.41 106.8,80.34 107.87,79.62 109.13,79.37 110.4,79.62 111.47,80.34 112.19,81.41 112.44,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="119.06,82.68 118.8,83.94 118.09,85.02 117.01,85.73 115.75,85.98 114.48,85.73 113.41,85.02 112.69,83.94 112.44,82.68 112.69,81.41 113.41,80.34 114.48,79.62 115.75,79.37 117.01,79.62 118.09,80.34 118.8,81.41 119.06,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="132.28,82.68 132.03,83.94 131.31,85.02 130.24,85.73 128.98,85.98 127.71,85.73 126.64,85.02 125.92,83.94 125.67,82.68 125.92,81.41 126.64,80.34 127.71,79.62 128.98,79.37 130.24,79.62 131.31,80.34 132.03,81.41 132.28,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="152.13,82.68 151.87,83.94 151.16,85.02 150.08,85.73 148.82,85.98 147.55,85.73 146.48,85.02 145.76,83.94 145.51,82.68 145.76,81.41 146.48,80.34 147.55,79.62 148.82,79.37 150.08,79.62 151.16,80.34 151.87,81.41 152.13,82.68 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="19.84,89.29 19.59,90.56 18.87,91.63 17.8,92.35 16.54,92.6 15.27,92.35 14.2,91.63 13.48,90.56 13.23,89.29 13.48,88.03 14.2,86.95 15.27,86.24 16.54,85.98 17.8,86.24 18.87,86.95 19.59,88.03 19.84,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="39.69,89.29 39.43,90.56 38.72,91.63 37.64,92.35 36.38,92.6 35.11,92.35 34.04,91.63 33.32,90.56 33.07,89.29 33.32,88.03 34.04,86.95 35.11,86.24 36.38,85.98 37.64,86.24 38.72,86.95 39.43,88.03 39.69,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,89.29 92.35,90.56 91.63,91.63 90.56,92.35 89.29,92.6 88.03,92.35 86.95,91.63 86.24,90.56 85.98,89.29 86.24,88.03 86.95,86.95 88.03,86.24 89.29,85.98 90.56,86.24 91.63,86.95 92.35,88.03 92.6,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,89.29 98.96,90.56 98.24,91.63 97.17,92.35 95.91,92.6 94.64,92.35 93.57,91.63 92.85,90.56 92.6,89.29 92.85,88.03 93.57,86.95 94.64,86.24 95.91,85.98 97.17,86.24 98.24,86.95 98.96,88.03 99.21,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="105.83,89.29 105.58,90.56 104.86,91.63 103.79,92.35 102.52,92.6 101.25,92.35 100.18,91.63 99.46,90.56 99.21,89.29 99.46,88.03 100.18,86.95 101.25,86.24 102.52,85.98 103.79,86.24 104.86,86.95 105.58,88.03 105.83,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="112.44,89.29 112.19,90.56 111.47,91.63 110.4,92.35 109.13,92.6 107.87,92.35 106.8,91.63 106.08,90.56 105.83,89.29 106.08,88.03 106.8,86.95 107.87,86.24 109.13,85.98 110.4,86.24 111.47,86.95 112.19,88.03 112.44,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="138.9,89.29 138.65,90.56 137.93,91.63 136.86,92.35 135.59,92.6 134.32,92.35 133.25,91.63 132.54,90.56 132.28,89.29 132.54,88.03 133.25,86.95 134.32,86.24 135.59,85.98 136.86,86.24 137.93,86.95 138.65,88.03 138.9,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="145.51,89.29 145.26,90.56 144.54,91.63 143.47,92.35 142.2,92.6 140.94,92.35 139.87,91.63 139.15,90.56 138.9,89.29 139.15,88.03 139.87,86.95 140.94,86.24 142.2,85.98 143.47,86.24 144.54,86.95 145.26,88.03 145.51,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="152.13,89.29 151.87,90.56 151.16,91.63 150.08,92.35 148.82,92.6 147.55,92.35 146.48,91.63 145.76,90.56 145.51,89.29 145.76,88.03 146.48,86.95 147.55,86.24 148.82,85.98 150.08,86.24 151.16,86.95 151.87,88.03 152.13,89.29 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="26.46,95.91 26.2,97.17 25.49,98.24 24.42,98.96 23.15,99.21 21.88,98.96 20.81,98.24 20.09,97.17 19.84,95.91 20.09,94.64 20.81,93.57 21.88,92.85 23.15,92.6 24.42,92.85 25.49,93.57 26.2,94.64 26.46,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="39.69,95.91 39.43,97.17 38.72,98.24 37.64,98.96 36.38,99.21 35.11,98.96 34.04,98.24 33.32,97.17 33.07,95.91 33.32,94.64 34.04,93.57 35.11,92.85 36.38,92.6 37.64,92.85 38.72,93.57 39.43,94.64 39.69,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="46.3,95.91 46.05,97.17 45.33,98.24 44.26,98.96 42.99,99.21 41.73,98.96 40.65,98.24 39.94,97.17 39.69,95.91 39.94,94.64 40.65,93.57 41.73,92.85 42.99,92.6 44.26,92.85 45.33,93.57 46.05,94.64 46.3,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="59.53,95.91 59.28,97.17 58.56,98.24 57.49,98.96 56.22,99.21 54.95,98.96 53.88,98.24 53.17,97.17 52.91,95.91 53.17,94.64 53.88,93.57 54.95,92.85 56.22,92.6 57.49,92.85 58.56,93.57 59.28,94.64 59.53,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,95.91 72.5,97.17 71.79,98.24 70.71,98.96 69.45,99.21 68.18,98.96 67.11,98.24 66.39,97.17 66.14,95.91 66.39,94.64 67.11,93.57 68.18,92.85 69.45,92.6 70.71,92.85 71.79,93.57 72.5,94.64 72.76,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,95.91 79.12,97.17 78.4,98.24 77.33,98.96 76.06,99.21 74.8,98.96 73.72,98.24 73.01,97.17 72.76,95.91 73.01,94.64 73.72,93.57 74.8,92.85 76.06,92.6 77.33,92.85 78.4,93.57 79.12,94.64 79.37,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,95.91 98.96,97.17 98.24,98.24 97.17,98.96 95.91,99.21 94.64,98.96 93.57,98.24 92.85,97.17 92.6,95.91 92.85,94.64 93.57,93.57 94.64,92.85 95.91,92.6 97.17,92.85 98.24,93.57 98.96,94.64 99.21,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="119.06,95.91 118.8,97.17 118.09,98.24 117.01,98.96 115.75,99.21 114.48,98.96 113.41,98.24 112.69,97.17 112.44,95.91 112.69,94.64 113.41,93.57 114.48,92.85 115.75,92.6 117.01,92.85 118.09,93.57 118.8,94.64 119.06,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="145.51,95.91 145.26,97.17 144.54,98.24 143.47,98.96 142.2,99.21 140.94,98.96 139.87,98.24 139.15,97.17 138.9,95.91 139.15,94.64 139.87,93.57 140.94,92.85 142.2,92.6 143.47,92.85 144.54,93.57 145.26,94.64 145.51,95.91 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,102.52 72.5,103.79 71.79,104.86 70.71,105.58 69.45,105.83 68.18,105.58 67.11,104.86 66.39,103.79 66.14,102.52 66.39,101.25 67.11,100.18 68.18,99.46 69.45,99.21 70.71,99.46 71.79,100.18 72.5,101.25 72.76,102.52 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="85.98,102.52 85.73,103.79 85.02,104.86 83.94,105.58 82.68,105.83 81.41,105.58 80.34,104.86 79.62,103.79 79.37,102.52 79.62,101.25 80.34,100.18 81.41,99.46 82.68,99.21 83.94,99.46 85.02,100.18 85.73,101.25 85.98,102.52 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,102.52 98.96,103.79 98.24,104.86 97.17,105.58 95.91,105.83 94.64,105.58 93.57,104.86 92.85,103.79 92.6,102.52 92.85,101.25 93.57,100.18 94.64,99.46 95.91,99.21 97.17,99.46 98.24,100.18 98.96,101.25 99.21,102.52 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="119.06,102.52 118.8,103.79 118.09,104.86 117.01,105.58 115.75,105.83 114.48,105.58 113.41,104.86 112.69,103.79 112.44,102.52 112.69,101.25 113.41,100.18 114.48,99.46 115.75,99.21 117.01,99.46 118.09,100.18 118.8,101.25 119.06,102.52 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="138.9,102.52 138.65,103.79 137.93,104.86 136.86,105.58 135.59,105.83 134.32,105.58 133.25,104.86 132.54,103.79 132.28,102.52 132.54,101.25 133.25,100.18 134.32,99.46 135.59,99.21 136.86,99.46 137.93,100.18 138.65,101.25 138.9,102.52 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,109.13 72.5,110.4 71.79,111.47 70.71,112.19 69.45,112.44 68.18,112.19 67.11,111.47 66.39,110.4 66.14,109.13 66.39,107.87 67.11,106.8 68.18,106.08 69.45,105.83 70.71,106.08 71.79,106.8 72.5,107.87 72.76,109.13 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,109.13 92.35,110.4 91.63,111.47 90.56,112.19 89.29,112.44 88.03,112.19 86.95,111.47 86.24,110.4 85.98,109.13 86.24,107.87 86.95,106.8 88.03,106.08 89.29,105.83 90.56,106.08 91.63,106.8 92.35,107.87 92.6,109.13 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="105.83,109.13 105.58,110.4 104.86,111.47 103.79,112.19 102.52,112.44 101.25,112.19 100.18,111.47 99.46,110.4 99.21,109.13 99.46,107.87 100.18,106.8 101.25,106.08 102.52,105.83 103.79,106.08 104.86,106.8 105.58,107.87 105.83,109.13 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="125.67,109.13 125.42,110.4 124.7,111.47 123.63,112.19 122.36,112.44 121.1,112.19 120.02,111.47 119.31,110.4 119.06,109.13 119.31,107.87 120.02,106.8 121.1,106.08 122.36,105.83 123.63,106.08 124.7,106.8 125.42,107.87 125.67,109.13 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="132.28,109.13 132.03,110.4 131.31,111.47 130.24,112.19 128.98,112.44 127.71,112.19 126.64,111.47 125.92,110.4 125.67,109.13 125.92,107.87 126.64,106.8 127.71,106.08 128.98,105.83 130.24,106.08 131.31,106.8 132.03,107.87 132.28,109.13 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="145.51,109.13 145.26,110.4 144.54,111.47 143.47,112.19 142.2,112.44 140.94,112.19 139.87,111.47 139.15,110.4 138.9,109.13 139.15,107.87 139.87,106.8 140.94,106.08 142.2,105.83 143.47,106.08 144.54,106.8 145.26,107.87 145.51,109.13 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="152.13,109.13 151.87,110.4 151.16,111.47 150.08,112.19 148.82,112.44 147.55,112.19 146.48,111.47 145.76,110.4 145.51,109.13 145.76,107.87 146.48,106.8 147.55,106.08 148.82,105.83 150.08,106.08 151.16,106.8 151.87,107.87 152.13,109.13 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,115.75 79.12,117.01 78.4,118.09 77.33,118.8 76.06,119.06 74.8,118.8 73.72,118.09 73.01,117.01 72.76,115.75 73.01,114.48 73.72,113.41 74.8,112.69 76.06,112.44 77.33,112.69 78.4,113.41 79.12,114.48 79.37,115.75 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="85.98,115.75 85.73,117.01 85.02,118.09 83.94,118.8 82.68,119.06 81.41,118.8 80.34,118.09 79.62,117.01 79.37,115.75 79.62,114.48 80.34,113.41 81.41,112.69 82.68,112.44 83.94,112.69 85.02,113.41 85.73,114.48 85.98,115.75 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="119.06,115.75 118.8,117.01 118.09,118.09 117.01,118.8 115.75,119.06 114.48,118.8 113.41,118.09 112.69,117.01 112.44,115.75 112.69,114.48 113.41,113.41 114.48,112.69 115.75,112.44 117.01,112.69 118.09,113.41 118.8,114.48 119.06,115.75 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="125.67,115.75 125.42,117.01 124.7,118.09 123.63,118.8 122.36,119.06 121.1,118.8 120.02,118.09 119.31,117.01 119.06,115.75 119.31,114.48 120.02,113.41 121.1,112.69 122.36,112.44 123.63,112.69 124.7,113.41 125.42,114.48 125.67,115.75 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="138.9,115.75 138.65,117.01 137.93,118.09 136.86,118.8 135.59,119.06 134.32,118.8 133.25,118.09 132.54,117.01 132.28,115.75 132.54,114.48 133.25,113.41 134.32,112.69 135.59,112.44 136.86,112.69 137.93,113.41 138.65,114.48 138.9,115.75 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="152.13,115.75 151.87,117.01 151.16,118.09 150.08,118.8 148.82,119.06 147.55,118.8 146.48,118.09 145.76,117.01 145.51,115.75 145.76,114.48 146.48,113.41 147.55,112.69 148.82,112.44 150.08,112.69 151.16,113.41 151.87,114.48 152.13,115.75 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,122.36 72.5,123.63 71.79,124.7 70.71,125.42 69.45,125.67 68.18,125.42 67.11,124.7 66.39,123.63 66.14,122.36 66.39,121.1 67.11,120.02 68.18,119.31 69.45,119.06 70.71,119.31 71.79,120.02 72.5,121.1 72.76,122.36 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,122.36 79.12,123.63 78.4,124.7 77.33,125.42 76.06,125.67 74.8,125.42 73.72,124.7 73.01,123.63 72.76,122.36 73.01,121.1 73.72,120.02 74.8,119.31 76.06,119.06 77.33,119.31 78.4,120.02 79.12,121.1 79.37,122.36 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="85.98,122.36 85.73,123.63 85.02,124.7 83.94,125.42 82.68,125.67 81.41,125.42 80.34,124.7 79.62,123.63 79.37,122.36 79.62,121.1 80.34,120.02 81.41,119.31 82.68,119.06 83.94,119.31 85.02,120.02 85.73,121.1 85.98,122.36 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,122.36 92.35,123.63 91.63,124.7 90.56,125.42 89.29,125.67 88.03,125.42 86.95,124.7 86.24,123.63 85.98,122.36 86.24,121.1 86.95,120.02 88.03,119.31 89.29,119.06 90.56,119.31 91.63,120.02 92.35,121.1 92.6,122.36 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="105.83,122.36 105.58,123.63 104.86,124.7 103.79,125.42 102.52,125.67 101.25,125.42 100.18,124.7 99.46,123.63 99.21,122.36 99.46,121.1 100.18,120.02 101.25,119.31 102.52,119.06 103.79,119.31 104.86,120.02 105.58,121.1 105.83,122.36 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="125.67,122.36 125.42,123.63 124.7,124.7 123.63,125.42 122.36,125.67 121.1,125.42 120.02,124.7 119.31,123.63 119.06,122.36 119.31,121.1 120.02,120.02 121.1,119.31 122.36,119.06 123.63,119.31 124.7,120.02 125.42,121.1 125.67,122.36 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="132.28,122.36 132.03,123.63 131.31,124.7 130.24,125.42 128.98,125.67 127.71,125.42 126.64,124.7 125.92,123.63 125.67,122.36 125.92,121.1 126.64,120.02 127.71,119.31 128.98,119.06 130.24,119.31 131.31,120.02 132.03,121.1 132.28,122.36 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="138.9,122.36 138.65,123.63 137.93,124.7 136.86,125.42 135.59,125.67 134.32,125.42 133.25,124.7 132.54,123.63 132.28,122.36 132.54,121.1 133.25,120.02 134.32,119.31 135.59,119.06 136.86,119.31 137.93,120.02 138.65,121.1 138.9,122.36 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,128.98 72.5,130.24 71.79,131.31 70.71,132.03 69.45,132.28 68.18,132.03 67.11,131.31 66.39,130.24 66.14,128.98 66.39,127.71 67.11,126.64 68.18,125.92 69.45,125.67 70.71,125.92 71.79,126.64 72.5,127.71 72.76,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,128.98 79.12,130.24 78.4,131.31 77.33,132.03 76.06,132.28 74.8,132.03 73.72,131.31 73.01,130.24 72.76,128.98 73.01,127.71 73.72,126.64 74.8,125.92 76.06,125.67 77.33,125.92 78.4,126.64 79.12,127.71 79.37,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,128.98 92.35,130.24 91.63,131.31 90.56,132.03 89.29,132.28 88.03,132.03 86.95,131.31 86.24,130.24 85.98,128.98 86.24,127.71 86.95,126.64 88.03,125.92 89.29,125.67 90.56,125.92 91.63,126.64 92.35,127.71 92.6,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,128.98 98.96,130.24 98.24,131.31 97.17,132.03 95.91,132.28 94.64,132.03 93.57,131.31 92.85,130.24 92.6,128.98 92.85,127.71 93.57,126.64 94.64,125.92 95.91,125.67 97.17,125.92 98.24,126.64 98.96,127.71 99.21,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="105.83,128.98 105.58,130.24 104.86,131.31 103.79,132.03 102.52,132.28 101.25,132.03 100.18,131.31 99.46,130.24 99.21,128.98 99.46,127.71 100.18,126.64 101.25,125.92 102.52,125.67 103.79,125.92 104.86,126.64 105.58,127.71 105.83,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="112.44,128.98 112.19,130.24 111.47,131.31 110.4,132.03 109.13,132.28 107.87,132.03 106.8,131.31 106.08,130.24 105.83,128.98 106.08,127.71 106.8,126.64 107.87,125.92 109.13,125.67 110.4,125.92 111.47,126.64 112.19,127.71 112.44,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="119.06,128.98 118.8,130.24 118.09,131.31 117.01,132.03 115.75,132.28 114.48,132.03 113.41,131.31 112.69,130.24 112.44,128.98 112.69,127.71 113.41,126.64 114.48,125.92 115.75,125.67 117.01,125.92 118.09,126.64 118.8,127.71 119.06,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="132.28,128.98 132.03,130.24 131.31,131.31 130.24,132.03 128.98,132.28 127.71,132.03 126.64,131.31 125.92,130.24 125.67,128.98 125.92,127.71 126.64,126.64 127.71,125.92 128.98,125.67 130.24,125.92 131.31,126.64 132.03,127.71 132.28,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="138.9,128.98 138.65,130.24 137.93,131.31 136.86,132.03 135.59,132.28 134.32,132.03 133.25,131.31 132.54,130.24 132.28,128.98 132.54,127.71 133.25,126.64 134.32,125.92 135.59,125.67 136.86,125.92 137.93,126.64 138.65,127.71 138.9,128.98 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,135.59 72.5,136.86 71.79,137.93 70.71,138.65 69.45,138.9 68.18,138.65 67.11,137.93 66.39,136.86 66.14,135.59 66.39,134.32 67.11,133.25 68.18,132.54 69.45,132.28 70.71,132.54 71.79,133.25 72.5,134.32 72.76,135.59 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,135.59 79.12,136.86 78.4,137.93 77.33,138.65 76.06,138.9 74.8,138.65 73.72,137.93 73.01,136.86 72.76,135.59 73.01,134.32 73.72,133.25 74.8,132.54 76.06,132.28 77.33,132.54 78.4,133.25 79.12,134.32 79.37,135.59 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,135.59 98.96,136.86 98.24,137.93 97.17,138.65 95.91,138.9 94.64,138.65 93.57,137.93 92.85,136.86 92.6,135.59 92.85,134.32 93.57,133.25 94.64,132.54 95.91,132.28 97.17,132.54 98.24,133.25 98.96,134.32 99.21,135.59 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="112.44,135.59 112.19,136.86 111.47,137.93 110.4,138.65 109.13,138.9 107.87,138.65 106.8,137.93 106.08,136.86 105.83,135.59 106.08,134.32 106.8,133.25 107.87,132.54 109.13,132.28 110.4,132.54 111.47,133.25 112.19,134.32 112.44,135.59 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="119.06,135.59 118.8,136.86 118.09,137.93 117.01,138.65 115.75,138.9 114.48,138.65 113.41,137.93 112.69,136.86 112.44,135.59 112.69,134.32 113.41,133.25 114.48,132.54 115.75,132.28 117.01,132.54 118.09,133.25 118.8,134.32 119.06,135.59 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="132.28,135.59 132.03,136.86 131.31,137.93 130.24,138.65 128.98,138.9 127.71,138.65 126.64,137.93 125.92,136.86 125.67,135.59 125.92,134.32 126.64,133.25 127.71,132.54 128.98,132.28 130.24,132.54 131.31,133.25 132.03,134.32 132.28,135.59 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="138.9,135.59 138.65,136.86 137.93,137.93 136.86,138.65 135.59,138.9 134.32,138.65 133.25,137.93 132.54,136.86 132.28,135.59 132.54,134.32 133.25,133.25 134.32,132.54 135.59,132.28 136.86,132.54 137.93,133.25 138.65,134.32 138.9,135.59 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,142.2 72.5,143.47 71.79,144.54 70.71,145.26 69.45,145.51 68.18,145.26 67.11,144.54 66.39,143.47 66.14,142.2 66.39,140.94 67.11,139.87 68.18,139.15 69.45,138.9 70.71,139.15 71.79,139.87 72.5,140.94 72.76,142.2 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="85.98,142.2 85.73,143.47 85.02,144.54 83.94,145.26 82.68,145.51 81.41,145.26 80.34,144.54 79.62,143.47 79.37,142.2 79.62,140.94 80.34,139.87 81.41,139.15 82.68,138.9 83.94,139.15 85.02,139.87 85.73,140.94 85.98,142.2 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="92.6,142.2 92.35,143.47 91.63,144.54 90.56,145.26 89.29,145.51 88.03,145.26 86.95,144.54 86.24,143.47 85.98,142.2 86.24,140.94 86.95,139.87 88.03,139.15 89.29,138.9 90.56,139.15 91.63,139.87 92.35,140.94 92.6,142.2 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,142.2 98.96,143.47 98.24,144.54 97.17,145.26 95.91,145.51 94.64,145.26 93.57,144.54 92.85,143.47 92.6,142.2 92.85,140.94 93.57,139.87 94.64,139.15 95.91,138.9 97.17,139.15 98.24,139.87 98.96,140.94 99.21,142.2 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="105.83,142.2 105.58,143.47 104.86,144.54 103.79,145.26 102.52,145.51 101.25,145.26 100.18,144.54 99.46,143.47 99.21,142.2 99.46,140.94 100.18,139.87 101.25,139.15 102.52,138.9 103.79,139.15 104.86,139.87 105.58,140.94 105.83,142.2 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="112.44,142.2 112.19,143.47 111.47,144.54 110.4,145.26 109.13,145.51 107.87,145.26 106.8,144.54 106.08,143.47 105.83,142.2 106.08,140.94 106.8,139.87 107.87,139.15 109.13,138.9 110.4,139.15 111.47,139.87 112.19,140.94 112.44,142.2 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="119.06,142.2 118.8,143.47 118.09,144.54 117.01,145.26 115.75,145.51 114.48,145.26 113.41,144.54 112.69,143.47 112.44,142.2 112.69,140.94 113.41,139.87 114.48,139.15 115.75,138.9 117.01,139.15 118.09,139.87 118.8,140.94 119.06,142.2 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="125.67,142.2 125.42,143.47 124.7,144.54 123.63,145.26 122.36,145.51 121.1,145.26 120.02,144.54 119.31,143.47 119.06,142.2 119.31,140.94 120.02,139.87 121.1,139.15 122.36,138.9 123.63,139.15 124.7,139.87 125.42,140.94 125.67,142.2 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="138.9,142.2 138.65,143.47 137.93,144.54 136.86,145.26 135.59,145.51 134.32,145.26 133.25,144.54 132.54,143.47 132.28,142.2 132.54,140.94 133.25,139.87 134.32,139.15 135.59,138.9 136.86,139.15 137.93,139.87 138.65,140.94 138.9,142.2 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="145.51,142.2 145.26,143.47 144.54,144.54 143.47,145.26 142.2,145.51 140.94,145.26 139.87,144.54 139.15,143.47 138.9,142.2 139.15,140.94 139.87,139.87 140.94,139.15 142.2,138.9 143.47,139.15 144.54,139.87 145.26,140.94 145.51,142.2 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="72.76,148.82 72.5,150.08 71.79,151.16 70.71,151.87 69.45,152.13 68.18,151.87 67.11,151.16 66.39,150.08 66.14,148.82 66.39,147.55 67.11,146.48 68.18,145.76 69.45,145.51 70.71,145.76 71.79,146.48 72.5,147.55 72.76,148.82 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="79.37,148.82 79.12,150.08 78.4,151.16 77.33,151.87 76.06,152.13 74.8,151.87 73.72,151.16 73.01,150.08 72.76,148.82 73.01,147.55 73.72,146.48 74.8,145.76 76.06,145.51 77.33,145.76 78.4,146.48 79.12,147.55 79.37,148.82 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="85.98,148.82 85.73,150.08 85.02,151.16 83.94,151.87 82.68,152.13 81.41,151.87 80.34,151.16 79.62,150.08 79.37,148.82 79.62,147.55 80.34,146.48 81.41,145.76 82.68,145.51 83.94,145.76 85.02,146.48 85.73,147.55 85.98,148.82 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="99.21,148.82 98.96,150.08 98.24,151.16 97.17,151.87 95.91,152.13 94.64,151.87 93.57,151.16 92.85,150.08 92.6,148.82 92.85,147.55 93.57,146.48 94.64,145.76 95.91,145.51 97.17,145.76 98.24,146.48 98.96,147.55 99.21,148.82 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="119.06,148.82 118.8,150.08 118.09,151.16 117.01,151.87 115.75,152.13 114.48,151.87 113.41,151.16 112.69,150.08 112.44,148.82 112.69,147.55 113.41,146.48 114.48,145.76 115.75,145.51 117.01,145.76 118.09,146.48 118.8,147.55 119.06,148.82 "
            style="fill:rgba(85,85,85,1);"
          />
          <polygon
            points="138.9,148.82 138.65,150.08 137.93,151.16 136.86,151.87 135.59,152.13 134.32,151.87 133.25,151.16 132.54,150.08 132.28,148.82 132.54,147.55 133.25,146.48 134.32,145.76 135.59,145.51 136.86,145.76 137.93,146.48 138.65,147.55 138.9,148.82 "
            style="fill:rgba(85,85,85,1);"
          />
    `,
            },
            {
                value: 4,
                innerHtml: `
      <rect
          x="0"
          y="0"
          width="165.3543"
          height="165.3543"
          fill="red"
          style="fill:rgba(255,255,255,0);"
          shape-rendering="crispEdges"
        />
        <linearGradient
          id="gradientb8ccf5af139d4745a4e57cbdbf3495fb"
          gradientUnits="userSpaceOnUse"
          x1="0.518330705864074"
          y1="35.242737901909"
          x2="164.835989820259"
          y2="130.111582624214"
        >
          <stop offset="0%" stop-color="#5A01B3" />
          <stop offset="100%" stop-color="#3B4990" />
        </linearGradient>
        <polygon
          points="13.23,29.76 13.55,26.54 14.49,23.44 16.02,20.58 18.07,18.07 20.58,16.02 23.44,14.49 26.54,13.55 29.76,13.23 42.99,13.23 46.22,13.55 49.32,14.49 52.18,16.02 54.68,18.07 56.74,20.58 58.27,23.44 59.21,26.54 59.53,29.76 59.53,42.99 59.21,46.22 58.27,49.32 56.74,52.18 54.68,54.68 52.18,56.74 49.32,58.27 46.22,59.21 42.99,59.53 29.76,59.53 26.54,59.21 23.44,58.27 20.58,56.74 18.07,54.68 16.02,52.18 14.49,49.32 13.55,46.22 13.23,42.99 13.23,29.76 19.84,29.76 19.84,42.99 20.18,45.56 21.17,47.95 22.75,50.01 24.8,51.58 27.2,52.58 29.76,52.91 42.99,52.91 45.56,52.58 47.95,51.58 50.01,50.01 51.58,47.95 52.58,45.56 52.91,42.99 52.91,29.76 52.58,27.2 51.58,24.8 50.01,22.75 47.95,21.17 45.56,20.18 42.99,19.84 29.76,19.84 27.2,20.18 24.8,21.17 22.75,22.75 21.17,24.8 20.18,27.2 19.84,29.76 "
          style="fill:url(#gradientb8ccf5af139d4745a4e57cbdbf3495fb);"
        />
        <polygon
          points="13.23,122.36 13.55,119.14 14.49,116.03 16.02,113.18 18.07,110.67 20.58,108.61 23.44,107.09 26.54,106.14 29.76,105.83 42.99,105.83 46.22,106.14 49.32,107.09 52.18,108.61 54.68,110.67 56.74,113.18 58.27,116.03 59.21,119.14 59.53,122.36 59.53,135.59 59.21,138.82 58.27,141.92 56.74,144.78 54.68,147.28 52.18,149.34 49.32,150.87 46.22,151.81 42.99,152.13 29.76,152.13 26.54,151.81 23.44,150.87 20.58,149.34 18.07,147.28 16.02,144.78 14.49,141.92 13.55,138.82 13.23,135.59 13.23,122.36 19.84,122.36 19.84,135.59 20.18,138.16 21.17,140.55 22.75,142.61 24.8,144.18 27.2,145.17 29.76,145.51 42.99,145.51 45.56,145.17 47.95,144.18 50.01,142.61 51.58,140.55 52.58,138.16 52.91,135.59 52.91,122.36 52.58,119.79 51.58,117.4 50.01,115.35 47.95,113.77 45.56,112.78 42.99,112.44 29.76,112.44 27.2,112.78 24.8,113.77 22.75,115.35 21.17,117.4 20.18,119.79 19.84,122.36 "
          style="fill:url(#gradientb8ccf5af139d4745a4e57cbdbf3495fb);"
        />
        <polygon
          points="105.83,29.76 106.14,26.54 107.09,23.44 108.61,20.58 110.67,18.07 113.18,16.02 116.03,14.49 119.14,13.55 122.36,13.23 135.59,13.23 138.82,13.55 141.92,14.49 144.78,16.02 147.28,18.07 149.34,20.58 150.87,23.44 151.81,26.54 152.13,29.76 152.13,42.99 151.81,46.22 150.87,49.32 149.34,52.18 147.28,54.68 144.78,56.74 141.92,58.27 138.82,59.21 135.59,59.53 122.36,59.53 119.14,59.21 116.03,58.27 113.18,56.74 110.67,54.68 108.61,52.18 107.09,49.32 106.14,46.22 105.83,42.99 105.83,29.76 112.44,29.76 112.44,42.99 112.78,45.56 113.77,47.95 115.35,50.01 117.4,51.58 119.79,52.58 122.36,52.91 135.59,52.91 138.16,52.58 140.55,51.58 142.61,50.01 144.18,47.95 145.17,45.56 145.51,42.99 145.51,29.76 145.17,27.2 144.18,24.8 142.61,22.75 140.55,21.17 138.16,20.18 135.59,19.84 122.36,19.84 119.79,20.18 117.4,21.17 115.35,22.75 113.77,24.8 112.78,27.2 112.44,29.76 "
          style="fill:url(#gradientb8ccf5af139d4745a4e57cbdbf3495fb);"
        />
        <pattern
          id="hatchd1532579170549379ffa1843e72867ab"
          x="0"
          y="0"
          width="8"
          height="8"
          patternUnits="userSpaceOnUse"
        >
          <rect x="0" y="0" width="8" height="8" fill="#695289" />
          <rect x="4" y="0" width="1" height="1" fill="#783948" />
          <rect x="5" y="0" width="1" height="1" fill="#783948" />
          <rect x="6" y="0" width="1" height="1" fill="#783948" />
          <rect x="7" y="0" width="1" height="1" fill="#783948" />
          <rect x="4" y="1" width="1" height="1" fill="#783948" />
          <rect x="5" y="1" width="1" height="1" fill="#783948" />
          <rect x="6" y="1" width="1" height="1" fill="#783948" />
          <rect x="7" y="1" width="1" height="1" fill="#783948" />
          <rect x="4" y="2" width="1" height="1" fill="#783948" />
          <rect x="5" y="2" width="1" height="1" fill="#783948" />
          <rect x="6" y="2" width="1" height="1" fill="#783948" />
          <rect x="7" y="2" width="1" height="1" fill="#783948" />
          <rect x="4" y="3" width="1" height="1" fill="#783948" />
          <rect x="5" y="3" width="1" height="1" fill="#783948" />
          <rect x="6" y="3" width="1" height="1" fill="#783948" />
          <rect x="7" y="3" width="1" height="1" fill="#783948" />
          <rect x="0" y="4" width="1" height="1" fill="#783948" />
          <rect x="1" y="4" width="1" height="1" fill="#783948" />
          <rect x="2" y="4" width="1" height="1" fill="#783948" />
          <rect x="3" y="4" width="1" height="1" fill="#783948" />
          <rect x="0" y="5" width="1" height="1" fill="#783948" />
          <rect x="1" y="5" width="1" height="1" fill="#783948" />
          <rect x="2" y="5" width="1" height="1" fill="#783948" />
          <rect x="3" y="5" width="1" height="1" fill="#783948" />
          <rect x="0" y="6" width="1" height="1" fill="#783948" />
          <rect x="1" y="6" width="1" height="1" fill="#783948" />
          <rect x="2" y="6" width="1" height="1" fill="#783948" />
          <rect x="3" y="6" width="1" height="1" fill="#783948" />
          <rect x="0" y="7" width="1" height="1" fill="#783948" />
          <rect x="1" y="7" width="1" height="1" fill="#783948" />
          <rect x="2" y="7" width="1" height="1" fill="#783948" />
          <rect x="3" y="7" width="1" height="1" fill="#783948" />
        </pattern>
        <polygon
          points="26.46,31.09 26.61,29.89 27.08,28.77 27.81,27.81 28.77,27.08 29.89,26.61 31.09,26.46 41.67,26.46 42.87,26.61 43.98,27.08 44.94,27.81 45.68,28.77 46.14,29.89 46.3,31.09 46.3,41.67 46.14,42.87 45.68,43.98 44.94,44.94 43.98,45.68 42.87,46.14 41.67,46.3 31.09,46.3 29.89,46.14 28.77,45.68 27.81,44.94 27.08,43.98 26.61,42.87 26.46,41.67 "
          style="fill:url(#hatchd1532579170549379ffa1843e72867ab);"
        />
        <polygon
          points="26.46,123.69 26.61,122.49 27.08,121.37 27.81,120.41 28.77,119.68 29.89,119.21 31.09,119.06 41.67,119.06 42.87,119.21 43.98,119.68 44.94,120.41 45.68,121.37 46.14,122.49 46.3,123.69 46.3,134.27 46.14,135.47 45.68,136.58 44.94,137.54 43.98,138.28 42.87,138.74 41.67,138.9 31.09,138.9 29.89,138.74 28.77,138.28 27.81,137.54 27.08,136.58 26.61,135.47 26.46,134.27 "
          style="fill:url(#hatchd1532579170549379ffa1843e72867ab);"
        />
        <polygon
          points="119.06,31.09 119.21,29.89 119.68,28.77 120.41,27.81 121.37,27.08 122.49,26.61 123.69,26.46 134.27,26.46 135.47,26.61 136.58,27.08 137.54,27.81 138.28,28.77 138.74,29.89 138.9,31.09 138.9,41.67 138.74,42.87 138.28,43.98 137.54,44.94 136.58,45.68 135.47,46.14 134.27,46.3 123.69,46.3 122.49,46.14 121.37,45.68 120.41,44.94 119.68,43.98 119.21,42.87 119.06,41.67 "
          style="fill:url(#hatchd1532579170549379ffa1843e72867ab);"
        />
        <linearGradient
          id="gradient05b39589f89a4da0bb06028c8be76a2c"
          gradientUnits="userSpaceOnUse"
          x1="5.85921475478483"
          y1="73.2451025543645"
          x2="159.495105771338"
          y2="92.1092179717585"
        >
          <stop offset="0%" stop-color="#742E2C" />
          <stop offset="90%" stop-color="#214D84" />
          <stop offset="100%" stop-color="#742E2C" />
        </linearGradient>
        <polygon
          points="79.37,15.54 79.55,14.66 80.05,13.91 80.8,13.4 81.69,13.23 86.05,13.23 86.05,19.91 79.37,19.91 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="85.92,16.54 85.92,13.23 92.66,13.23 92.66,19.84 85.92,19.84 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="92.53,13.23 96.9,13.23 97.78,13.4 98.53,13.91 99.04,14.66 99.21,15.54 99.21,19.91 92.53,19.91 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="66.14,22.16 66.32,21.27 66.82,20.52 67.57,20.02 68.46,19.84 72.82,19.84 72.82,26.46 68.46,26.46 67.57,26.28 66.82,25.78 66.32,25.03 66.14,24.14 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="72.69,23.15 72.69,19.84 79.44,19.84 79.44,26.46 72.69,26.46 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="79.3,23.15 79.3,19.78 85.98,19.78 85.98,26.52 79.3,26.52 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="92.6,23.15 92.6,19.78 99.21,19.78 99.21,26.52 92.6,26.52 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="79.37,26.39 86.05,26.39 86.05,33.07 81.69,33.07 80.8,32.89 80.05,32.39 79.55,31.64 79.37,30.76 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="85.92,29.76 85.92,26.46 92.66,26.46 92.66,33.07 85.92,33.07 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="92.53,29.76 92.53,26.39 99.21,26.39 99.21,33.14 92.53,33.14 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="66.14,35.39 66.32,34.5 66.82,33.75 67.57,33.25 68.46,33.07 72.82,33.07 72.82,39.69 68.46,39.69 67.57,39.51 66.82,39.01 66.32,38.26 66.14,37.37 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="72.69,33.07 77.06,33.07 77.94,33.25 78.69,33.75 79.19,34.5 79.37,35.39 79.37,39.75 72.69,39.75 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="92.6,36.38 92.6,33 99.21,33 99.21,39.75 92.6,39.75 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="72.76,39.62 79.37,39.62 79.37,43.98 79.19,44.87 78.69,45.62 77.94,46.12 77.06,46.3 75.07,46.3 74.18,46.12 73.43,45.62 72.93,44.87 72.76,43.98 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="92.6,39.62 99.21,39.62 99.21,43.98 99.04,44.87 98.53,45.62 97.78,46.12 96.9,46.3 94.91,46.3 94.03,46.12 93.28,45.62 92.77,44.87 92.6,43.98 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="66.14,48.61 66.32,47.73 66.82,46.98 67.57,46.48 68.46,46.3 70.44,46.3 71.33,46.48 72.08,46.98 72.58,47.73 72.76,48.61 72.76,52.98 66.14,52.98 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="85.98,48.61 86.16,47.73 86.66,46.98 87.41,46.48 88.3,46.3 90.28,46.3 91.17,46.48 91.92,46.98 92.42,47.73 92.6,48.61 92.6,50.6 92.42,51.48 91.92,52.24 91.17,52.74 90.28,52.91 88.3,52.91 87.41,52.74 86.66,52.24 86.16,51.48 85.98,50.6 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="66.14,52.85 72.76,52.85 72.76,57.21 72.58,58.1 72.08,58.85 71.33,59.35 70.44,59.53 68.46,59.53 67.57,59.35 66.82,58.85 66.32,58.1 66.14,57.21 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="79.37,55.23 79.55,54.34 80.05,53.59 80.8,53.09 81.69,52.91 83.67,52.91 84.56,53.09 85.31,53.59 85.81,54.34 85.98,55.23 85.98,57.21 85.81,58.1 85.31,58.85 84.56,59.35 83.67,59.53 81.69,59.53 80.8,59.35 80.05,58.85 79.55,58.1 79.37,57.21 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="92.6,55.23 92.77,54.34 93.28,53.59 94.03,53.09 94.91,52.91 96.9,52.91 97.78,53.09 98.53,53.59 99.04,54.34 99.21,55.23 99.21,57.21 99.04,58.1 98.53,58.85 97.78,59.35 96.9,59.53 94.91,59.53 94.03,59.35 93.28,58.85 92.77,58.1 92.6,57.21 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="72.76,61.84 72.93,60.96 73.43,60.21 74.18,59.7 75.07,59.53 77.06,59.53 77.94,59.7 78.69,60.21 79.19,60.96 79.37,61.84 79.37,63.83 79.19,64.71 78.69,65.46 77.94,65.97 77.06,66.14 75.07,66.14 74.18,65.97 73.43,65.46 72.93,64.71 72.76,63.83 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="13.23,68.46 13.4,67.57 13.91,66.82 14.66,66.32 15.54,66.14 19.91,66.14 19.91,72.82 13.23,72.82 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="19.78,69.45 19.78,66.14 26.52,66.14 26.52,72.82 19.78,72.82 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="26.39,69.45 26.39,66.14 33.14,66.14 33.14,72.82 26.39,72.82 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="33,69.45 33,66.14 39.75,66.14 39.75,72.76 33,72.76 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="39.62,66.14 43.98,66.14 44.87,66.32 45.62,66.82 46.12,67.57 46.3,68.46 46.3,70.44 46.12,71.33 45.62,72.08 44.87,72.58 43.98,72.76 39.62,72.76 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="52.91,68.46 53.09,67.57 53.59,66.82 54.34,66.32 55.23,66.14 59.59,66.14 59.59,72.76 55.23,72.76 54.34,72.58 53.59,72.08 53.09,71.33 52.91,70.44 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="59.46,69.45 59.46,66.14 66.21,66.14 66.21,72.82 59.46,72.82 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="66.08,66.14 70.44,66.14 71.33,66.32 72.08,66.82 72.58,67.57 72.76,68.46 72.76,70.44 72.58,71.33 72.08,72.08 71.33,72.58 70.44,72.76 66.08,72.76 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="85.98,68.46 86.16,67.57 86.66,66.82 87.41,66.32 88.3,66.14 90.28,66.14 91.17,66.32 91.92,66.82 92.42,67.57 92.6,68.46 92.6,72.82 85.98,72.82 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="99.21,68.46 99.39,67.57 99.89,66.82 100.64,66.32 101.53,66.14 103.51,66.14 104.4,66.32 105.15,66.82 105.65,67.57 105.83,68.46 105.83,72.82 99.21,72.82 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="112.44,68.46 112.62,67.57 113.12,66.82 113.87,66.32 114.76,66.14 116.74,66.14 117.63,66.32 118.38,66.82 118.88,67.57 119.06,68.46 119.06,70.44 118.88,71.33 118.38,72.08 117.63,72.58 116.74,72.76 114.76,72.76 113.87,72.58 113.12,72.08 112.62,71.33 112.44,70.44 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="125.67,68.46 125.85,67.57 126.35,66.82 127.1,66.32 127.98,66.14 129.97,66.14 130.85,66.32 131.61,66.82 132.11,67.57 132.28,68.46 132.28,72.82 125.67,72.82 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="138.9,68.46 139.07,67.57 139.58,66.82 140.33,66.32 141.21,66.14 143.2,66.14 144.08,66.32 144.83,66.82 145.34,67.57 145.51,68.46 145.51,72.82 138.9,72.82 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="13.23,72.69 19.91,72.69 19.91,79.37 15.54,79.37 14.66,79.19 13.91,78.69 13.4,77.94 13.23,77.06 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="19.78,76.06 19.78,72.69 26.52,72.69 26.52,79.37 19.78,79.37 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="26.39,76.06 26.39,72.69 33.07,72.69 33.07,79.44 26.39,79.44 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="46.3,75.07 46.48,74.18 46.98,73.43 47.73,72.93 48.61,72.76 50.6,72.76 51.48,72.93 52.24,73.43 52.74,74.18 52.91,75.07 52.91,79.44 46.3,79.44 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="59.53,72.69 66.14,72.69 66.14,77.06 65.97,77.94 65.46,78.69 64.71,79.19 63.83,79.37 61.84,79.37 60.96,79.19 60.21,78.69 59.7,77.94 59.53,77.06 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="72.76,75.07 72.93,74.18 73.43,73.43 74.18,72.93 75.07,72.76 77.06,72.76 77.94,72.93 78.69,73.43 79.19,74.18 79.37,75.07 79.37,79.44 72.76,79.44 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="85.98,72.69 92.66,72.69 92.66,79.37 88.3,79.37 87.41,79.19 86.66,78.69 86.16,77.94 85.98,77.06 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="92.53,76.06 92.53,72.76 99.28,72.76 99.28,79.44 92.53,79.44 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="99.15,76.06 99.15,72.69 105.89,72.69 105.89,79.37 99.15,79.37 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="105.76,72.76 110.13,72.76 111.01,72.93 111.76,73.43 112.26,74.18 112.44,75.07 112.44,79.44 105.76,79.44 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="125.67,76.06 125.67,72.69 132.35,72.69 132.35,79.44 125.67,79.44 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="132.22,76.06 132.22,72.76 138.96,72.76 138.96,79.37 132.22,79.37 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="138.83,76.06 138.83,72.69 145.58,72.69 145.58,79.37 138.83,79.37 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="145.45,72.76 149.81,72.76 150.7,72.93 151.45,73.43 151.95,74.18 152.13,75.07 152.13,79.44 145.45,79.44 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="26.46,79.3 33.07,79.3 33.07,83.67 32.89,84.56 32.39,85.31 31.64,85.81 30.76,85.98 28.77,85.98 27.89,85.81 27.13,85.31 26.63,84.56 26.46,83.67 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="39.69,81.69 39.86,80.8 40.36,80.05 41.11,79.55 42,79.37 46.37,79.37 46.37,85.98 42,85.98 41.11,85.81 40.36,85.31 39.86,84.56 39.69,83.67 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="46.23,82.68 46.23,79.3 52.98,79.3 52.98,85.98 46.23,85.98 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="52.85,79.37 57.21,79.37 58.1,79.55 58.85,80.05 59.35,80.8 59.53,81.69 59.53,83.67 59.35,84.56 58.85,85.31 58.1,85.81 57.21,85.98 52.85,85.98 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="66.14,81.69 66.32,80.8 66.82,80.05 67.57,79.55 68.46,79.37 72.82,79.37 72.82,85.98 68.46,85.98 67.57,85.81 66.82,85.31 66.32,84.56 66.14,83.67 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="72.69,79.3 79.37,79.3 79.37,83.67 79.19,84.56 78.69,85.31 77.94,85.81 77.06,85.98 72.69,85.98 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="92.6,82.68 92.6,79.3 99.21,79.3 99.21,86.05 92.6,86.05 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="105.83,82.68 105.83,79.3 112.51,79.3 112.51,86.05 105.83,86.05 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="112.37,79.37 116.74,79.37 117.63,79.55 118.38,80.05 118.88,80.8 119.06,81.69 119.06,83.67 118.88,84.56 118.38,85.31 117.63,85.81 116.74,85.98 112.37,85.98 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="125.67,79.3 132.28,79.3 132.28,83.67 132.11,84.56 131.61,85.31 130.85,85.81 129.97,85.98 127.98,85.98 127.1,85.81 126.35,85.31 125.85,84.56 125.67,83.67 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="145.51,82.68 145.51,79.3 152.13,79.3 152.13,86.05 145.51,86.05 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="13.23,88.3 13.4,87.41 13.91,86.66 14.66,86.16 15.54,85.98 17.53,85.98 18.41,86.16 19.16,86.66 19.67,87.41 19.84,88.3 19.84,90.28 19.67,91.17 19.16,91.92 18.41,92.42 17.53,92.6 15.54,92.6 14.66,92.42 13.91,91.92 13.4,91.17 13.23,90.28 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="33.07,88.3 33.25,87.41 33.75,86.66 34.5,86.16 35.39,85.98 37.37,85.98 38.26,86.16 39.01,86.66 39.51,87.41 39.69,88.3 39.69,92.66 33.07,92.66 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="85.98,88.3 86.16,87.41 86.66,86.66 87.41,86.16 88.3,85.98 92.66,85.98 92.66,92.6 88.3,92.6 87.41,92.42 86.66,91.92 86.16,91.17 85.98,90.28 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="92.53,89.29 92.53,85.92 99.28,85.92 99.28,92.66 92.53,92.66 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="99.15,89.29 99.15,85.98 105.89,85.98 105.89,92.6 99.15,92.6 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="105.76,85.92 112.44,85.92 112.44,90.28 112.26,91.17 111.76,91.92 111.01,92.42 110.13,92.6 105.76,92.6 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="132.28,88.3 132.46,87.41 132.96,86.66 133.71,86.16 134.6,85.98 138.96,85.98 138.96,92.6 134.6,92.6 133.71,92.42 132.96,91.92 132.46,91.17 132.28,90.28 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="138.83,89.29 138.83,85.98 145.58,85.98 145.58,92.66 138.83,92.66 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="145.45,85.92 152.13,85.92 152.13,90.28 151.95,91.17 151.45,91.92 150.7,92.42 149.81,92.6 145.45,92.6 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="19.84,94.91 20.02,94.03 20.52,93.28 21.27,92.77 22.16,92.6 24.14,92.6 25.03,92.77 25.78,93.28 26.28,94.03 26.46,94.91 26.46,96.9 26.28,97.78 25.78,98.53 25.03,99.04 24.14,99.21 22.16,99.21 21.27,99.04 20.52,98.53 20.02,97.78 19.84,96.9 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="33.07,92.53 39.75,92.53 39.75,99.21 35.39,99.21 34.5,99.04 33.75,98.53 33.25,97.78 33.07,96.9 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="39.62,92.6 43.98,92.6 44.87,92.77 45.62,93.28 46.12,94.03 46.3,94.91 46.3,96.9 46.12,97.78 45.62,98.53 44.87,99.04 43.98,99.21 39.62,99.21 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="52.91,94.91 53.09,94.03 53.59,93.28 54.34,92.77 55.23,92.6 57.21,92.6 58.1,92.77 58.85,93.28 59.35,94.03 59.53,94.91 59.53,96.9 59.35,97.78 58.85,98.53 58.1,99.04 57.21,99.21 55.23,99.21 54.34,99.04 53.59,98.53 53.09,97.78 52.91,96.9 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="66.14,94.91 66.32,94.03 66.82,93.28 67.57,92.77 68.46,92.6 72.82,92.6 72.82,99.28 66.14,99.28 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="72.69,92.6 77.06,92.6 77.94,92.77 78.69,93.28 79.19,94.03 79.37,94.91 79.37,96.9 79.19,97.78 78.69,98.53 77.94,99.04 77.06,99.21 72.69,99.21 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="92.6,95.91 92.6,92.53 99.21,92.53 99.21,99.28 92.6,99.28 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="112.44,94.91 112.62,94.03 113.12,93.28 113.87,92.77 114.76,92.6 116.74,92.6 117.63,92.77 118.38,93.28 118.88,94.03 119.06,94.91 119.06,99.28 112.44,99.28 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="138.9,92.53 145.51,92.53 145.51,96.9 145.34,97.78 144.83,98.53 144.08,99.04 143.2,99.21 141.21,99.21 140.33,99.04 139.58,98.53 139.07,97.78 138.9,96.9 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="66.14,102.52 66.14,99.15 72.76,99.15 72.76,105.89 66.14,105.89 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="79.37,101.53 79.55,100.64 80.05,99.89 80.8,99.39 81.69,99.21 83.67,99.21 84.56,99.39 85.31,99.89 85.81,100.64 85.98,101.53 85.98,103.51 85.81,104.4 85.31,105.15 84.56,105.65 83.67,105.83 81.69,105.83 80.8,105.65 80.05,105.15 79.55,104.4 79.37,103.51 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="92.6,99.15 99.21,99.15 99.21,103.51 99.04,104.4 98.53,105.15 97.78,105.65 96.9,105.83 94.91,105.83 94.03,105.65 93.28,105.15 92.77,104.4 92.6,103.51 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="112.44,99.15 119.06,99.15 119.06,103.51 118.88,104.4 118.38,105.15 117.63,105.65 116.74,105.83 114.76,105.83 113.87,105.65 113.12,105.15 112.62,104.4 112.44,103.51 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="132.28,101.53 132.46,100.64 132.96,99.89 133.71,99.39 134.6,99.21 136.58,99.21 137.47,99.39 138.22,99.89 138.72,100.64 138.9,101.53 138.9,103.51 138.72,104.4 138.22,105.15 137.47,105.65 136.58,105.83 134.6,105.83 133.71,105.65 132.96,105.15 132.46,104.4 132.28,103.51 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="66.14,105.76 72.76,105.76 72.76,110.13 72.58,111.01 72.08,111.76 71.33,112.26 70.44,112.44 68.46,112.44 67.57,112.26 66.82,111.76 66.32,111.01 66.14,110.13 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="85.98,108.14 86.16,107.26 86.66,106.5 87.41,106 88.3,105.83 90.28,105.83 91.17,106 91.92,106.5 92.42,107.26 92.6,108.14 92.6,110.13 92.42,111.01 91.92,111.76 91.17,112.26 90.28,112.44 88.3,112.44 87.41,112.26 86.66,111.76 86.16,111.01 85.98,110.13 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="99.21,108.14 99.39,107.26 99.89,106.5 100.64,106 101.53,105.83 103.51,105.83 104.4,106 105.15,106.5 105.65,107.26 105.83,108.14 105.83,110.13 105.65,111.01 105.15,111.76 104.4,112.26 103.51,112.44 101.53,112.44 100.64,112.26 99.89,111.76 99.39,111.01 99.21,110.13 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="119.06,108.14 119.23,107.26 119.73,106.5 120.48,106 121.37,105.83 125.74,105.83 125.74,112.51 119.06,112.51 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="125.6,105.83 129.97,105.83 130.85,106 131.61,106.5 132.11,107.26 132.28,108.14 132.28,110.13 132.11,111.01 131.61,111.76 130.85,112.26 129.97,112.44 125.6,112.44 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="138.9,108.14 139.07,107.26 139.58,106.5 140.33,106 141.21,105.83 145.58,105.83 145.58,112.44 141.21,112.44 140.33,112.26 139.58,111.76 139.07,111.01 138.9,110.13 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="145.45,105.83 149.81,105.83 150.7,106 151.45,106.5 151.95,107.26 152.13,108.14 152.13,112.51 145.45,112.51 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="72.76,114.76 72.93,113.87 73.43,113.12 74.18,112.62 75.07,112.44 79.44,112.44 79.44,119.12 72.76,119.12 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="79.3,112.44 83.67,112.44 84.56,112.62 85.31,113.12 85.81,113.87 85.98,114.76 85.98,119.12 79.3,119.12 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="112.44,114.76 112.62,113.87 113.12,113.12 113.87,112.62 114.76,112.44 119.12,112.44 119.12,119.06 114.76,119.06 113.87,118.88 113.12,118.38 112.62,117.63 112.44,116.74 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="118.99,115.75 118.99,112.37 125.67,112.37 125.67,119.12 118.99,119.12 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="132.28,114.76 132.46,113.87 132.96,113.12 133.71,112.62 134.6,112.44 136.58,112.44 137.47,112.62 138.22,113.12 138.72,113.87 138.9,114.76 138.9,119.12 132.28,119.12 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="145.51,112.37 152.13,112.37 152.13,116.74 151.95,117.63 151.45,118.38 150.7,118.88 149.81,119.06 147.83,119.06 146.94,118.88 146.19,118.38 145.69,117.63 145.51,116.74 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="66.14,121.37 66.32,120.48 66.82,119.73 67.57,119.23 68.46,119.06 72.82,119.06 72.82,125.74 66.14,125.74 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="72.69,122.36 72.69,118.99 79.44,118.99 79.44,125.74 72.69,125.74 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="79.3,122.36 79.3,118.99 86.05,118.99 86.05,125.67 79.3,125.67 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="85.92,119.06 90.28,119.06 91.17,119.23 91.92,119.73 92.42,120.48 92.6,121.37 92.6,125.74 85.92,125.74 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="99.21,121.37 99.39,120.48 99.89,119.73 100.64,119.23 101.53,119.06 103.51,119.06 104.4,119.23 105.15,119.73 105.65,120.48 105.83,121.37 105.83,125.74 99.21,125.74 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="119.06,118.99 125.74,118.99 125.74,125.67 121.37,125.67 120.48,125.49 119.73,124.99 119.23,124.24 119.06,123.35 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="125.6,122.36 125.6,119.06 132.35,119.06 132.35,125.74 125.6,125.74 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="132.22,122.36 132.22,118.99 138.9,118.99 138.9,125.74 132.22,125.74 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="66.14,128.98 66.14,125.6 72.82,125.6 72.82,132.35 66.14,132.35 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="72.69,128.98 72.69,125.6 79.37,125.6 79.37,132.35 72.69,132.35 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="85.98,125.6 92.66,125.6 92.66,132.28 88.3,132.28 87.41,132.11 86.66,131.61 86.16,130.85 85.98,129.97 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="92.53,128.98 92.53,125.67 99.28,125.67 99.28,132.35 92.53,132.35 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="99.15,128.98 99.15,125.6 105.89,125.6 105.89,132.28 99.15,132.28 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="105.76,128.98 105.76,125.67 112.51,125.67 112.51,132.35 105.76,132.35 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="112.37,125.67 116.74,125.67 117.63,125.85 118.38,126.35 118.88,127.1 119.06,127.98 119.06,132.35 112.37,132.35 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="125.67,128.98 125.67,125.6 132.35,125.6 132.35,132.35 125.67,132.35 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="132.22,128.98 132.22,125.6 138.9,125.6 138.9,132.35 132.22,132.35 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="66.14,135.59 66.14,132.22 72.82,132.22 72.82,138.96 66.14,138.96 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="72.69,132.22 79.37,132.22 79.37,136.58 79.19,137.47 78.69,138.22 77.94,138.72 77.06,138.9 72.69,138.9 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="92.6,135.59 92.6,132.22 99.21,132.22 99.21,138.96 92.6,138.96 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="105.83,135.59 105.83,132.22 112.51,132.22 112.51,138.96 105.83,138.96 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="112.37,135.59 112.37,132.22 119.06,132.22 119.06,138.96 112.37,138.96 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="125.67,132.22 132.35,132.22 132.35,138.9 127.98,138.9 127.1,138.72 126.35,138.22 125.85,137.47 125.67,136.58 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="132.22,135.59 132.22,132.22 138.9,132.22 138.9,138.96 132.22,138.96 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="66.14,142.2 66.14,138.83 72.76,138.83 72.76,145.58 66.14,145.58 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="79.37,141.21 79.55,140.33 80.05,139.58 80.8,139.07 81.69,138.9 86.05,138.9 86.05,145.58 79.37,145.58 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="85.92,142.2 85.92,138.9 92.66,138.9 92.66,145.51 85.92,145.51 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="92.53,142.2 92.53,138.83 99.28,138.83 99.28,145.58 92.53,145.58 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="99.15,142.2 99.15,138.9 105.89,138.9 105.89,145.51 99.15,145.51 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="105.76,142.2 105.76,138.83 112.51,138.83 112.51,145.51 105.76,145.51 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="112.37,142.2 112.37,138.83 119.12,138.83 119.12,145.58 112.37,145.58 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="118.99,138.9 123.35,138.9 124.24,139.07 124.99,139.58 125.49,140.33 125.67,141.21 125.67,143.2 125.49,144.08 124.99,144.83 124.24,145.34 123.35,145.51 118.99,145.51 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="132.28,142.2 132.28,138.83 138.96,138.83 138.96,145.58 132.28,145.58 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="138.83,138.9 143.2,138.9 144.08,139.07 144.83,139.58 145.34,140.33 145.51,141.21 145.51,143.2 145.34,144.08 144.83,144.83 144.08,145.34 143.2,145.51 138.83,145.51 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="66.14,145.45 72.82,145.45 72.82,152.13 68.46,152.13 67.57,151.95 66.82,151.45 66.32,150.7 66.14,149.81 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="72.69,148.82 72.69,145.51 79.44,145.51 79.44,152.13 72.69,152.13 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="79.3,145.45 85.98,145.45 85.98,149.81 85.81,150.7 85.31,151.45 84.56,151.95 83.67,152.13 79.3,152.13 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="92.6,145.45 99.21,145.45 99.21,149.81 99.04,150.7 98.53,151.45 97.78,151.95 96.9,152.13 94.91,152.13 94.03,151.95 93.28,151.45 92.77,150.7 92.6,149.81 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="112.44,145.45 119.06,145.45 119.06,149.81 118.88,150.7 118.38,151.45 117.63,151.95 116.74,152.13 114.76,152.13 113.87,151.95 113.12,151.45 112.62,150.7 112.44,149.81 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
        <polygon
          points="132.28,145.45 138.9,145.45 138.9,149.81 138.72,150.7 138.22,151.45 137.47,151.95 136.58,152.13 134.6,152.13 133.71,151.95 132.96,151.45 132.46,150.7 132.28,149.81 "
          style="fill:url(#gradient05b39589f89a4da0bb06028c8be76a2c);"
        />
      `,
            },
            {
                value: 5,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(255,255,255,0);"
            shape-rendering="crispEdges"
          />
          <linearGradient
            id="gradientf0e64991fd9b47eea35449bc92624707"
            gradientUnits="userSpaceOnUse"
            x1="13.2283458709717"
            y1="82.6771602630615"
            x2="152.125974655151"
            y2="82.6771602630615"
          >
            <stop offset="0%" stop-color="#BF00B2" />
            <stop offset="100%" stop-color="#C10040" />
          </linearGradient>
          <polygon
            points="13.23,29.76 13.55,26.54 14.49,23.44 16.02,20.58 18.07,18.07 20.58,16.02 23.44,14.49 26.54,13.55 29.76,13.23 59.53,13.23 59.53,59.53 13.23,59.53 13.23,29.76 19.84,29.76 19.84,52.91 52.91,52.91 52.91,19.84 29.76,19.84 27.2,20.18 24.8,21.17 22.75,22.75 21.17,24.8 20.18,27.2 19.84,29.76 "
            style="fill:url(#gradientf0e64991fd9b47eea35449bc92624707);"
          />
          <polygon
            points="13.23,122.36 13.23,105.83 59.53,105.83 59.53,152.13 29.76,152.13 26.54,151.81 23.44,150.87 20.58,149.34 18.07,147.28 16.02,144.78 14.49,141.92 13.55,138.82 13.23,135.59 13.23,122.36 19.84,122.36 19.84,135.59 20.18,138.16 21.17,140.55 22.75,142.61 24.8,144.18 27.2,145.17 29.76,145.51 52.91,145.51 52.91,112.44 19.84,112.44 19.84,122.36 "
            style="fill:url(#gradientf0e64991fd9b47eea35449bc92624707);"
          />
          <polygon
            points="105.83,29.76 105.83,13.23 135.59,13.23 138.82,13.55 141.92,14.49 144.78,16.02 147.28,18.07 149.34,20.58 150.87,23.44 151.81,26.54 152.13,29.76 152.13,59.53 105.83,59.53 105.83,29.76 112.44,29.76 112.44,52.91 145.51,52.91 145.51,29.76 145.17,27.2 144.18,24.8 142.61,22.75 140.55,21.17 138.16,20.18 135.59,19.84 112.44,19.84 112.44,29.76 "
            style="fill:url(#gradientf0e64991fd9b47eea35449bc92624707);"
          />
          <polygon
            points="46.3,36.38 46.11,38.31 45.54,40.17 44.63,41.89 43.39,43.39 41.89,44.63 40.17,45.54 38.31,46.11 36.38,46.3 34.44,46.11 32.58,45.54 30.87,44.63 29.36,43.39 28.13,41.89 27.21,40.17 26.65,38.31 26.46,36.38 26.65,34.44 27.21,32.58 28.13,30.87 29.36,29.36 30.87,28.13 32.58,27.21 34.44,26.65 36.38,26.46 38.31,26.65 40.17,27.21 41.89,28.13 43.39,29.36 44.63,30.87 45.54,32.58 46.11,34.44 46.3,36.38 "
            style="fill:rgba(12,172,172,1);"
          />
          <polygon
            points="46.3,128.98 46.11,130.91 45.54,132.77 44.63,134.49 43.39,135.99 41.89,137.23 40.17,138.14 38.31,138.71 36.38,138.9 34.44,138.71 32.58,138.14 30.87,137.23 29.36,135.99 28.13,134.49 27.21,132.77 26.65,130.91 26.46,128.98 26.65,127.04 27.21,125.18 28.13,123.46 29.36,121.96 30.87,120.73 32.58,119.81 34.44,119.25 36.38,119.06 38.31,119.25 40.17,119.81 41.89,120.73 43.39,121.96 44.63,123.46 45.54,125.18 46.11,127.04 46.3,128.98 "
            style="fill:rgba(12,172,172,1);"
          />
          <polygon
            points="138.9,36.38 138.71,38.31 138.14,40.17 137.23,41.89 135.99,43.39 134.49,44.63 132.77,45.54 130.91,46.11 128.98,46.3 127.04,46.11 125.18,45.54 123.46,44.63 121.96,43.39 120.73,41.89 119.81,40.17 119.25,38.31 119.06,36.38 119.25,34.44 119.81,32.58 120.73,30.87 121.96,29.36 123.46,28.13 125.18,27.21 127.04,26.65 128.98,26.46 130.91,26.65 132.77,27.21 134.49,28.13 135.99,29.36 137.23,30.87 138.14,32.58 138.71,34.44 138.9,36.38 "
            style="fill:rgba(12,172,172,1);"
          />
          <linearGradient
            id="gradientb004c9109356453aa8a2d004f73d3db2"
            gradientUnits="userSpaceOnUse"
            x1="10.4830545936657"
            y1="78.893629314992"
            x2="154.871269747155"
            y2="86.4606950258283"
          >
            <stop offset="0%" stop-color="#B80508" />
            <stop offset="50%" stop-color="#307585" />
            <stop offset="100%" stop-color="#B80508" />
          </linearGradient>
          <polygon
            points="16.54,72.09 15.52,71.89 14.66,71.32 14.09,70.46 13.89,69.45 14.09,68.44 14.66,67.58 15.52,67 16.54,66.8 42.99,66.8 44,67 44.86,67.58 45.44,68.44 45.64,69.45 45.44,70.46 44.86,71.32 44,71.89 42.99,72.09 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="56.22,72.09 55.21,71.89 54.35,71.32 53.78,70.46 53.57,69.45 53.78,68.44 54.35,67.58 55.21,67 56.22,66.8 69.45,66.8 70.46,67 71.32,67.58 71.89,68.44 72.09,69.45 71.89,70.46 71.32,71.32 70.46,71.89 69.45,72.09 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="102.52,72.09 101.51,71.89 100.65,71.32 100.08,70.46 99.87,69.45 100.08,68.44 100.65,67.58 101.51,67 102.52,66.8 102.52,66.8 103.53,67 104.39,67.58 104.96,68.44 105.17,69.45 104.96,70.46 104.39,71.32 103.53,71.89 102.52,72.09 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="115.75,72.09 114.74,71.89 113.88,71.32 113.3,70.46 113.1,69.45 113.3,68.44 113.88,67.58 114.74,67 115.75,66.8 115.75,66.8 116.76,67 117.62,67.58 118.19,68.44 118.39,69.45 118.19,70.46 117.62,71.32 116.76,71.89 115.75,72.09 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="128.98,72.09 127.96,71.89 127.11,71.32 126.53,70.46 126.33,69.45 126.53,68.44 127.11,67.58 127.96,67 128.98,66.8 128.98,66.8 129.99,67 130.85,67.58 131.42,68.44 131.62,69.45 131.42,70.46 130.85,71.32 129.99,71.89 128.98,72.09 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="142.2,72.09 141.19,71.89 140.33,71.32 139.76,70.46 139.56,69.45 139.76,68.44 140.33,67.58 141.19,67 142.2,66.8 142.2,66.8 143.22,67 144.08,67.58 144.65,68.44 144.85,69.45 144.65,70.46 144.08,71.32 143.22,71.89 142.2,72.09 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="16.54,78.71 15.52,78.51 14.66,77.93 14.09,77.08 13.89,76.06 14.09,75.05 14.66,74.19 15.52,73.62 16.54,73.42 29.76,73.42 30.78,73.62 31.63,74.19 32.21,75.05 32.41,76.06 32.21,77.08 31.63,77.93 30.78,78.51 29.76,78.71 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="49.61,78.71 48.59,78.51 47.74,77.93 47.16,77.08 46.96,76.06 47.16,75.05 47.74,74.19 48.59,73.62 49.61,73.42 49.61,73.42 50.62,73.62 51.48,74.19 52.05,75.05 52.25,76.06 52.05,77.08 51.48,77.93 50.62,78.51 49.61,78.71 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="62.83,78.71 61.82,78.51 60.96,77.93 60.39,77.08 60.19,76.06 60.39,75.05 60.96,74.19 61.82,73.62 62.83,73.42 62.83,73.42 63.85,73.62 64.71,74.19 65.28,75.05 65.48,76.06 65.28,77.08 64.71,77.93 63.85,78.51 62.83,78.71 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="76.06,78.71 75.05,78.51 74.19,77.93 73.62,77.08 73.42,76.06 73.62,75.05 74.19,74.19 75.05,73.62 76.06,73.42 76.06,73.42 77.08,73.62 77.93,74.19 78.51,75.05 78.71,76.06 78.51,77.08 77.93,77.93 77.08,78.51 76.06,78.71 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="89.29,78.71 88.28,78.51 87.42,77.93 86.85,77.08 86.65,76.06 86.85,75.05 87.42,74.19 88.28,73.62 89.29,73.42 109.13,73.42 110.15,73.62 111,74.19 111.58,75.05 111.78,76.06 111.58,77.08 111,77.93 110.15,78.51 109.13,78.71 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="128.98,78.71 127.96,78.51 127.11,77.93 126.53,77.08 126.33,76.06 126.53,75.05 127.11,74.19 127.96,73.62 128.98,73.42 148.82,73.42 149.83,73.62 150.69,74.19 151.26,75.05 151.46,76.06 151.26,77.08 150.69,77.93 149.83,78.51 148.82,78.71 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="29.76,85.32 28.75,85.12 27.89,84.55 27.32,83.69 27.12,82.68 27.32,81.66 27.89,80.81 28.75,80.23 29.76,80.03 29.76,80.03 30.78,80.23 31.63,80.81 32.21,81.66 32.41,82.68 32.21,83.69 31.63,84.55 30.78,85.12 29.76,85.32 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="42.99,85.32 41.98,85.12 41.12,84.55 40.55,83.69 40.35,82.68 40.55,81.66 41.12,80.81 41.98,80.23 42.99,80.03 56.22,80.03 57.23,80.23 58.09,80.81 58.66,81.66 58.87,82.68 58.66,83.69 58.09,84.55 57.23,85.12 56.22,85.32 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="69.45,85.32 68.44,85.12 67.58,84.55 67,83.69 66.8,82.68 67,81.66 67.58,80.81 68.44,80.23 69.45,80.03 76.06,80.03 77.08,80.23 77.93,80.81 78.51,81.66 78.71,82.68 78.51,83.69 77.93,84.55 77.08,85.12 76.06,85.32 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="95.91,85.32 94.89,85.12 94.03,84.55 93.46,83.69 93.26,82.68 93.46,81.66 94.03,80.81 94.89,80.23 95.91,80.03 95.91,80.03 96.92,80.23 97.78,80.81 98.35,81.66 98.55,82.68 98.35,83.69 97.78,84.55 96.92,85.12 95.91,85.32 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="109.13,85.32 108.12,85.12 107.26,84.55 106.69,83.69 106.49,82.68 106.69,81.66 107.26,80.81 108.12,80.23 109.13,80.03 115.75,80.03 116.76,80.23 117.62,80.81 118.19,81.66 118.39,82.68 118.19,83.69 117.62,84.55 116.76,85.12 115.75,85.32 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="128.98,85.32 127.96,85.12 127.11,84.55 126.53,83.69 126.33,82.68 126.53,81.66 127.11,80.81 127.96,80.23 128.98,80.03 128.98,80.03 129.99,80.23 130.85,80.81 131.42,81.66 131.62,82.68 131.42,83.69 130.85,84.55 129.99,85.12 128.98,85.32 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="148.82,85.32 147.81,85.12 146.95,84.55 146.37,83.69 146.17,82.68 146.37,81.66 146.95,80.81 147.81,80.23 148.82,80.03 148.82,80.03 149.83,80.23 150.69,80.81 151.26,81.66 151.46,82.68 151.26,83.69 150.69,84.55 149.83,85.12 148.82,85.32 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="16.54,91.94 15.52,91.74 14.66,91.16 14.09,90.3 13.89,89.29 14.09,88.28 14.66,87.42 15.52,86.85 16.54,86.65 16.54,86.65 17.55,86.85 18.41,87.42 18.98,88.28 19.18,89.29 18.98,90.3 18.41,91.16 17.55,91.74 16.54,91.94 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="36.38,91.94 35.37,91.74 34.51,91.16 33.93,90.3 33.73,89.29 33.93,88.28 34.51,87.42 35.37,86.85 36.38,86.65 36.38,86.65 37.39,86.85 38.25,87.42 38.82,88.28 39.02,89.29 38.82,90.3 38.25,91.16 37.39,91.74 36.38,91.94 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="89.29,91.94 88.28,91.74 87.42,91.16 86.85,90.3 86.65,89.29 86.85,88.28 87.42,87.42 88.28,86.85 89.29,86.65 109.13,86.65 110.15,86.85 111,87.42 111.58,88.28 111.78,89.29 111.58,90.3 111,91.16 110.15,91.74 109.13,91.94 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="135.59,91.94 134.58,91.74 133.72,91.16 133.15,90.3 132.94,89.29 133.15,88.28 133.72,87.42 134.58,86.85 135.59,86.65 148.82,86.65 149.83,86.85 150.69,87.42 151.26,88.28 151.46,89.29 151.26,90.3 150.69,91.16 149.83,91.74 148.82,91.94 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="23.15,98.55 22.14,98.35 21.28,97.78 20.71,96.92 20.5,95.91 20.71,94.89 21.28,94.03 22.14,93.46 23.15,93.26 23.15,93.26 24.16,93.46 25.02,94.03 25.59,94.89 25.8,95.91 25.59,96.92 25.02,97.78 24.16,98.35 23.15,98.55 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="36.38,98.55 35.37,98.35 34.51,97.78 33.93,96.92 33.73,95.91 33.93,94.89 34.51,94.03 35.37,93.46 36.38,93.26 42.99,93.26 44,93.46 44.86,94.03 45.44,94.89 45.64,95.91 45.44,96.92 44.86,97.78 44,98.35 42.99,98.55 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="56.22,98.55 55.21,98.35 54.35,97.78 53.78,96.92 53.57,95.91 53.78,94.89 54.35,94.03 55.21,93.46 56.22,93.26 56.22,93.26 57.23,93.46 58.09,94.03 58.66,94.89 58.87,95.91 58.66,96.92 58.09,97.78 57.23,98.35 56.22,98.55 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="69.45,98.55 68.44,98.35 67.58,97.78 67,96.92 66.8,95.91 67,94.89 67.58,94.03 68.44,93.46 69.45,93.26 69.45,93.26 70.46,93.46 71.32,94.03 71.89,94.89 72.09,95.91 71.89,96.92 71.32,97.78 70.46,98.35 69.45,98.55 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="95.91,98.55 94.89,98.35 94.03,97.78 93.46,96.92 93.26,95.91 93.46,94.89 94.03,94.03 94.89,93.46 95.91,93.26 95.91,93.26 96.92,93.46 97.78,94.03 98.35,94.89 98.55,95.91 98.35,96.92 97.78,97.78 96.92,98.35 95.91,98.55 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="115.75,98.55 114.74,98.35 113.88,97.78 113.3,96.92 113.1,95.91 113.3,94.89 113.88,94.03 114.74,93.46 115.75,93.26 115.75,93.26 116.76,93.46 117.62,94.03 118.19,94.89 118.39,95.91 118.19,96.92 117.62,97.78 116.76,98.35 115.75,98.55 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="142.2,98.55 141.19,98.35 140.33,97.78 139.76,96.92 139.56,95.91 139.76,94.89 140.33,94.03 141.19,93.46 142.2,93.26 142.2,93.26 143.22,93.46 144.08,94.03 144.65,94.89 144.85,95.91 144.65,96.92 144.08,97.78 143.22,98.35 142.2,98.55 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="115.75,105.17 114.74,104.96 113.88,104.39 113.3,103.53 113.1,102.52 113.3,101.51 113.88,100.65 114.74,100.08 115.75,99.87 115.75,99.87 116.76,100.08 117.62,100.65 118.19,101.51 118.39,102.52 118.19,103.53 117.62,104.39 116.76,104.96 115.75,105.17 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="135.59,105.17 134.58,104.96 133.72,104.39 133.15,103.53 132.94,102.52 133.15,101.51 133.72,100.65 134.58,100.08 135.59,99.87 135.59,99.87 136.6,100.08 137.46,100.65 138.03,101.51 138.24,102.52 138.03,103.53 137.46,104.39 136.6,104.96 135.59,105.17 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="122.36,111.78 121.35,111.58 120.49,111 119.92,110.15 119.72,109.13 119.92,108.12 120.49,107.26 121.35,106.69 122.36,106.49 128.98,106.49 129.99,106.69 130.85,107.26 131.42,108.12 131.62,109.13 131.42,110.15 130.85,111 129.99,111.58 128.98,111.78 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="142.2,111.78 141.19,111.58 140.33,111 139.76,110.15 139.56,109.13 139.76,108.12 140.33,107.26 141.19,106.69 142.2,106.49 148.82,106.49 149.83,106.69 150.69,107.26 151.26,108.12 151.46,109.13 151.26,110.15 150.69,111 149.83,111.58 148.82,111.78 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="115.75,118.39 114.74,118.19 113.88,117.62 113.3,116.76 113.1,115.75 113.3,114.74 113.88,113.88 114.74,113.3 115.75,113.1 122.36,113.1 123.37,113.3 124.23,113.88 124.81,114.74 125.01,115.75 124.81,116.76 124.23,117.62 123.37,118.19 122.36,118.39 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="135.59,118.39 134.58,118.19 133.72,117.62 133.15,116.76 132.94,115.75 133.15,114.74 133.72,113.88 134.58,113.3 135.59,113.1 135.59,113.1 136.6,113.3 137.46,113.88 138.03,114.74 138.24,115.75 138.03,116.76 137.46,117.62 136.6,118.19 135.59,118.39 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="148.82,118.39 147.81,118.19 146.95,117.62 146.37,116.76 146.17,115.75 146.37,114.74 146.95,113.88 147.81,113.3 148.82,113.1 148.82,113.1 149.83,113.3 150.69,113.88 151.26,114.74 151.46,115.75 151.26,116.76 150.69,117.62 149.83,118.19 148.82,118.39 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="122.36,125.01 121.35,124.81 120.49,124.23 119.92,123.37 119.72,122.36 119.92,121.35 120.49,120.49 121.35,119.92 122.36,119.72 135.59,119.72 136.6,119.92 137.46,120.49 138.03,121.35 138.24,122.36 138.03,123.37 137.46,124.23 136.6,124.81 135.59,125.01 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="128.98,131.62 127.96,131.42 127.11,130.85 126.53,129.99 126.33,128.98 126.53,127.96 127.11,127.11 127.96,126.53 128.98,126.33 135.59,126.33 136.6,126.53 137.46,127.11 138.03,127.96 138.24,128.98 138.03,129.99 137.46,130.85 136.6,131.42 135.59,131.62 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="135.59,138.24 134.58,138.03 133.72,137.46 133.15,136.6 132.94,135.59 133.15,134.58 133.72,133.72 134.58,133.15 135.59,132.94 135.59,132.94 136.6,133.15 137.46,133.72 138.03,134.58 138.24,135.59 138.03,136.6 137.46,137.46 136.6,138.03 135.59,138.24 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="142.2,144.85 141.19,144.65 140.33,144.08 139.76,143.22 139.56,142.2 139.76,141.19 140.33,140.33 141.19,139.76 142.2,139.56 142.2,139.56 143.22,139.76 144.08,140.33 144.65,141.19 144.85,142.2 144.65,143.22 144.08,144.08 143.22,144.65 142.2,144.85 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="66.8,23.15 67,22.14 67.58,21.28 68.44,20.71 69.45,20.5 70.46,20.71 71.32,21.28 71.89,22.14 72.09,23.15 72.09,23.15 71.89,24.16 71.32,25.02 70.46,25.59 69.45,25.8 68.44,25.59 67.58,25.02 67,24.16 66.8,23.15 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="66.8,36.38 67,35.37 67.58,34.51 68.44,33.93 69.45,33.73 70.46,33.93 71.32,34.51 71.89,35.37 72.09,36.38 72.09,36.38 71.89,37.39 71.32,38.25 70.46,38.82 69.45,39.02 68.44,38.82 67.58,38.25 67,37.39 66.8,36.38 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="66.8,49.61 67,48.59 67.58,47.74 68.44,47.16 69.45,46.96 70.46,47.16 71.32,47.74 71.89,48.59 72.09,49.61 72.09,56.22 71.89,57.23 71.32,58.09 70.46,58.66 69.45,58.87 68.44,58.66 67.58,58.09 67,57.23 66.8,56.22 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="66.8,95.91 67,94.89 67.58,94.03 68.44,93.46 69.45,93.26 70.46,93.46 71.32,94.03 71.89,94.89 72.09,95.91 72.09,109.13 71.89,110.15 71.32,111 70.46,111.58 69.45,111.78 68.44,111.58 67.58,111 67,110.15 66.8,109.13 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="66.8,122.36 67,121.35 67.58,120.49 68.44,119.92 69.45,119.72 70.46,119.92 71.32,120.49 71.89,121.35 72.09,122.36 72.09,148.82 71.89,149.83 71.32,150.69 70.46,151.26 69.45,151.46 68.44,151.26 67.58,150.69 67,149.83 66.8,148.82 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="73.42,23.15 73.62,22.14 74.19,21.28 75.05,20.71 76.06,20.5 77.08,20.71 77.93,21.28 78.51,22.14 78.71,23.15 78.71,23.15 78.51,24.16 77.93,25.02 77.08,25.59 76.06,25.8 75.05,25.59 74.19,25.02 73.62,24.16 73.42,23.15 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="73.42,36.38 73.62,35.37 74.19,34.51 75.05,33.93 76.06,33.73 77.08,33.93 77.93,34.51 78.51,35.37 78.71,36.38 78.71,42.99 78.51,44 77.93,44.86 77.08,45.44 76.06,45.64 75.05,45.44 74.19,44.86 73.62,44 73.42,42.99 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="73.42,62.83 73.62,61.82 74.19,60.96 75.05,60.39 76.06,60.19 77.08,60.39 77.93,60.96 78.51,61.82 78.71,62.83 78.71,62.83 78.51,63.85 77.93,64.71 77.08,65.28 76.06,65.48 75.05,65.28 74.19,64.71 73.62,63.85 73.42,62.83 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="73.42,95.91 73.62,94.89 74.19,94.03 75.05,93.46 76.06,93.26 77.08,93.46 77.93,94.03 78.51,94.89 78.71,95.91 78.71,95.91 78.51,96.92 77.93,97.78 77.08,98.35 76.06,98.55 75.05,98.35 74.19,97.78 73.62,96.92 73.42,95.91 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="73.42,115.75 73.62,114.74 74.19,113.88 75.05,113.3 76.06,113.1 77.08,113.3 77.93,113.88 78.51,114.74 78.71,115.75 78.71,135.59 78.51,136.6 77.93,137.46 77.08,138.03 76.06,138.24 75.05,138.03 74.19,137.46 73.62,136.6 73.42,135.59 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="73.42,148.82 73.62,147.81 74.19,146.95 75.05,146.37 76.06,146.17 77.08,146.37 77.93,146.95 78.51,147.81 78.71,148.82 78.71,148.82 78.51,149.83 77.93,150.69 77.08,151.26 76.06,151.46 75.05,151.26 74.19,150.69 73.62,149.83 73.42,148.82 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="80.03,16.54 80.23,15.52 80.81,14.66 81.66,14.09 82.68,13.89 83.69,14.09 84.55,14.66 85.12,15.52 85.32,16.54 85.32,29.76 85.12,30.78 84.55,31.63 83.69,32.21 82.68,32.41 81.66,32.21 80.81,31.63 80.23,30.78 80.03,29.76 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="80.03,56.22 80.23,55.21 80.81,54.35 81.66,53.78 82.68,53.57 83.69,53.78 84.55,54.35 85.12,55.21 85.32,56.22 85.32,56.22 85.12,57.23 84.55,58.09 83.69,58.66 82.68,58.87 81.66,58.66 80.81,58.09 80.23,57.23 80.03,56.22 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="80.03,102.52 80.23,101.51 80.81,100.65 81.66,100.08 82.68,99.87 83.69,100.08 84.55,100.65 85.12,101.51 85.32,102.52 85.32,102.52 85.12,103.53 84.55,104.39 83.69,104.96 82.68,105.17 81.66,104.96 80.81,104.39 80.23,103.53 80.03,102.52 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="80.03,115.75 80.23,114.74 80.81,113.88 81.66,113.3 82.68,113.1 83.69,113.3 84.55,113.88 85.12,114.74 85.32,115.75 85.32,122.36 85.12,123.37 84.55,124.23 83.69,124.81 82.68,125.01 81.66,124.81 80.81,124.23 80.23,123.37 80.03,122.36 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="80.03,142.2 80.23,141.19 80.81,140.33 81.66,139.76 82.68,139.56 83.69,139.76 84.55,140.33 85.12,141.19 85.32,142.2 85.32,148.82 85.12,149.83 84.55,150.69 83.69,151.26 82.68,151.46 81.66,151.26 80.81,150.69 80.23,149.83 80.03,148.82 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="86.65,16.54 86.85,15.52 87.42,14.66 88.28,14.09 89.29,13.89 90.3,14.09 91.16,14.66 91.74,15.52 91.94,16.54 91.94,16.54 91.74,17.55 91.16,18.41 90.3,18.98 89.29,19.18 88.28,18.98 87.42,18.41 86.85,17.55 86.65,16.54 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="86.65,29.76 86.85,28.75 87.42,27.89 88.28,27.32 89.29,27.12 90.3,27.32 91.16,27.89 91.74,28.75 91.94,29.76 91.94,29.76 91.74,30.78 91.16,31.63 90.3,32.21 89.29,32.41 88.28,32.21 87.42,31.63 86.85,30.78 86.65,29.76 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="86.65,49.61 86.85,48.59 87.42,47.74 88.28,47.16 89.29,46.96 90.3,47.16 91.16,47.74 91.74,48.59 91.94,49.61 91.94,49.61 91.74,50.62 91.16,51.48 90.3,52.05 89.29,52.25 88.28,52.05 87.42,51.48 86.85,50.62 86.65,49.61 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="86.65,69.45 86.85,68.44 87.42,67.58 88.28,67 89.29,66.8 90.3,67 91.16,67.58 91.74,68.44 91.94,69.45 91.94,69.45 91.74,70.46 91.16,71.32 90.3,71.89 89.29,72.09 88.28,71.89 87.42,71.32 86.85,70.46 86.65,69.45 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="86.65,89.29 86.85,88.28 87.42,87.42 88.28,86.85 89.29,86.65 90.3,86.85 91.16,87.42 91.74,88.28 91.94,89.29 91.94,89.29 91.74,90.3 91.16,91.16 90.3,91.74 89.29,91.94 88.28,91.74 87.42,91.16 86.85,90.3 86.65,89.29 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="86.65,109.13 86.85,108.12 87.42,107.26 88.28,106.69 89.29,106.49 90.3,106.69 91.16,107.26 91.74,108.12 91.94,109.13 91.94,109.13 91.74,110.15 91.16,111 90.3,111.58 89.29,111.78 88.28,111.58 87.42,111 86.85,110.15 86.65,109.13 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="86.65,122.36 86.85,121.35 87.42,120.49 88.28,119.92 89.29,119.72 90.3,119.92 91.16,120.49 91.74,121.35 91.94,122.36 91.94,128.98 91.74,129.99 91.16,130.85 90.3,131.42 89.29,131.62 88.28,131.42 87.42,130.85 86.85,129.99 86.65,128.98 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="86.65,142.2 86.85,141.19 87.42,140.33 88.28,139.76 89.29,139.56 90.3,139.76 91.16,140.33 91.74,141.19 91.94,142.2 91.94,142.2 91.74,143.22 91.16,144.08 90.3,144.65 89.29,144.85 88.28,144.65 87.42,144.08 86.85,143.22 86.65,142.2 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="93.26,16.54 93.46,15.52 94.03,14.66 94.89,14.09 95.91,13.89 96.92,14.09 97.78,14.66 98.35,15.52 98.55,16.54 98.55,42.99 98.35,44 97.78,44.86 96.92,45.44 95.91,45.64 94.89,45.44 94.03,44.86 93.46,44 93.26,42.99 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="93.26,56.22 93.46,55.21 94.03,54.35 94.89,53.78 95.91,53.57 96.92,53.78 97.78,54.35 98.35,55.21 98.55,56.22 98.55,56.22 98.35,57.23 97.78,58.09 96.92,58.66 95.91,58.87 94.89,58.66 94.03,58.09 93.46,57.23 93.26,56.22 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="93.26,95.91 93.46,94.89 94.03,94.03 94.89,93.46 95.91,93.26 96.92,93.46 97.78,94.03 98.35,94.89 98.55,95.91 98.55,102.52 98.35,103.53 97.78,104.39 96.92,104.96 95.91,105.17 94.89,104.96 94.03,104.39 93.46,103.53 93.26,102.52 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="93.26,128.98 93.46,127.96 94.03,127.11 94.89,126.53 95.91,126.33 96.92,126.53 97.78,127.11 98.35,127.96 98.55,128.98 98.55,148.82 98.35,149.83 97.78,150.69 96.92,151.26 95.91,151.46 94.89,151.26 94.03,150.69 93.46,149.83 93.26,148.82 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="99.87,109.13 100.08,108.12 100.65,107.26 101.51,106.69 102.52,106.49 103.53,106.69 104.39,107.26 104.96,108.12 105.17,109.13 105.17,109.13 104.96,110.15 104.39,111 103.53,111.58 102.52,111.78 101.51,111.58 100.65,111 100.08,110.15 99.87,109.13 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="99.87,122.36 100.08,121.35 100.65,120.49 101.51,119.92 102.52,119.72 103.53,119.92 104.39,120.49 104.96,121.35 105.17,122.36 105.17,128.98 104.96,129.99 104.39,130.85 103.53,131.42 102.52,131.62 101.51,131.42 100.65,130.85 100.08,129.99 99.87,128.98 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="99.87,142.2 100.08,141.19 100.65,140.33 101.51,139.76 102.52,139.56 103.53,139.76 104.39,140.33 104.96,141.19 105.17,142.2 105.17,142.2 104.96,143.22 104.39,144.08 103.53,144.65 102.52,144.85 101.51,144.65 100.65,144.08 100.08,143.22 99.87,142.2 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="106.49,128.98 106.69,127.96 107.26,127.11 108.12,126.53 109.13,126.33 110.15,126.53 111,127.11 111.58,127.96 111.78,128.98 111.78,142.2 111.58,143.22 111,144.08 110.15,144.65 109.13,144.85 108.12,144.65 107.26,144.08 106.69,143.22 106.49,142.2 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="113.1,115.75 113.3,114.74 113.88,113.88 114.74,113.3 115.75,113.1 116.76,113.3 117.62,113.88 118.19,114.74 118.39,115.75 118.39,115.75 118.19,116.76 117.62,117.62 116.76,118.19 115.75,118.39 114.74,118.19 113.88,117.62 113.3,116.76 113.1,115.75 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="113.1,128.98 113.3,127.96 113.88,127.11 114.74,126.53 115.75,126.33 116.76,126.53 117.62,127.11 118.19,127.96 118.39,128.98 118.39,148.82 118.19,149.83 117.62,150.69 116.76,151.26 115.75,151.46 114.74,151.26 113.88,150.69 113.3,149.83 113.1,148.82 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="119.72,122.36 119.92,121.35 120.49,120.49 121.35,119.92 122.36,119.72 123.37,119.92 124.23,120.49 124.81,121.35 125.01,122.36 125.01,122.36 124.81,123.37 124.23,124.23 123.37,124.81 122.36,125.01 121.35,124.81 120.49,124.23 119.92,123.37 119.72,122.36 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="119.72,142.2 119.92,141.19 120.49,140.33 121.35,139.76 122.36,139.56 123.37,139.76 124.23,140.33 124.81,141.19 125.01,142.2 125.01,142.2 124.81,143.22 124.23,144.08 123.37,144.65 122.36,144.85 121.35,144.65 120.49,144.08 119.92,143.22 119.72,142.2 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="126.33,128.98 126.53,127.96 127.11,127.11 127.96,126.53 128.98,126.33 129.99,126.53 130.85,127.11 131.42,127.96 131.62,128.98 131.62,135.59 131.42,136.6 130.85,137.46 129.99,138.03 128.98,138.24 127.96,138.03 127.11,137.46 126.53,136.6 126.33,135.59 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="132.94,135.59 133.15,134.58 133.72,133.72 134.58,133.15 135.59,132.94 136.6,133.15 137.46,133.72 138.03,134.58 138.24,135.59 138.24,148.82 138.03,149.83 137.46,150.69 136.6,151.26 135.59,151.46 134.58,151.26 133.72,150.69 133.15,149.83 132.94,148.82 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
          <polygon
            points="139.56,142.2 139.76,141.19 140.33,140.33 141.19,139.76 142.2,139.56 143.22,139.76 144.08,140.33 144.65,141.19 144.85,142.2 144.85,142.2 144.65,143.22 144.08,144.08 143.22,144.65 142.2,144.85 141.19,144.65 140.33,144.08 139.76,143.22 139.56,142.2 "
            style="fill:url(#gradientb004c9109356453aa8a2d004f73d3db2);"
          />
      `,
            },
            {
                value: 6,
                innerHtml: `
      <rect
          x="0"
          y="0"
          width="165.3543"
          height="165.3543"
          fill="red"
          style="fill:rgba(255,255,255,0);"
          shape-rendering="crispEdges"
        />
        <linearGradient
          id="gradient0a63a848c18243f2af2c33edde29962a"
          gradientUnits="userSpaceOnUse"
          x1="4.19744738555816"
          y1="70.2471948621279"
          x2="161.156873140565"
          y2="95.1071256639952"
        >
          <stop offset="0%" stop-color="#B301A6" />
          <stop offset="80%" stop-color="#31351C" />
          <stop offset="100%" stop-color="#B301A6" />
        </linearGradient>
        <polygon
          points="19.84,16.54 19.59,17.8 18.87,18.87 17.8,19.59 16.54,19.84 15.27,19.59 14.2,18.87 13.48,17.8 13.23,16.54 13.48,15.27 14.2,14.2 15.27,13.48 16.54,13.23 17.8,13.48 18.87,14.2 19.59,15.27 19.84,16.54 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="19.84,56.22 19.59,57.49 18.87,58.56 17.8,59.28 16.54,59.53 15.27,59.28 14.2,58.56 13.48,57.49 13.23,56.22 13.48,54.95 14.2,53.88 15.27,53.17 16.54,52.91 17.8,53.17 18.87,53.88 19.59,54.95 19.84,56.22 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="26.46,16.54 26.2,17.8 25.49,18.87 24.42,19.59 23.15,19.84 21.88,19.59 20.81,18.87 20.09,17.8 19.84,16.54 20.09,15.27 20.81,14.2 21.88,13.48 23.15,13.23 24.42,13.48 25.49,14.2 26.2,15.27 26.46,16.54 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="26.46,56.22 26.2,57.49 25.49,58.56 24.42,59.28 23.15,59.53 21.88,59.28 20.81,58.56 20.09,57.49 19.84,56.22 20.09,54.95 20.81,53.88 21.88,53.17 23.15,52.91 24.42,53.17 25.49,53.88 26.2,54.95 26.46,56.22 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="33.07,16.54 32.82,17.8 32.1,18.87 31.03,19.59 29.76,19.84 28.5,19.59 27.43,18.87 26.71,17.8 26.46,16.54 26.71,15.27 27.43,14.2 28.5,13.48 29.76,13.23 31.03,13.48 32.1,14.2 32.82,15.27 33.07,16.54 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="33.07,56.22 32.82,57.49 32.1,58.56 31.03,59.28 29.76,59.53 28.5,59.28 27.43,58.56 26.71,57.49 26.46,56.22 26.71,54.95 27.43,53.88 28.5,53.17 29.76,52.91 31.03,53.17 32.1,53.88 32.82,54.95 33.07,56.22 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="39.69,16.54 39.43,17.8 38.72,18.87 37.64,19.59 36.38,19.84 35.11,19.59 34.04,18.87 33.32,17.8 33.07,16.54 33.32,15.27 34.04,14.2 35.11,13.48 36.38,13.23 37.64,13.48 38.72,14.2 39.43,15.27 39.69,16.54 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="39.69,56.22 39.43,57.49 38.72,58.56 37.64,59.28 36.38,59.53 35.11,59.28 34.04,58.56 33.32,57.49 33.07,56.22 33.32,54.95 34.04,53.88 35.11,53.17 36.38,52.91 37.64,53.17 38.72,53.88 39.43,54.95 39.69,56.22 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="46.3,16.54 46.05,17.8 45.33,18.87 44.26,19.59 42.99,19.84 41.73,19.59 40.65,18.87 39.94,17.8 39.69,16.54 39.94,15.27 40.65,14.2 41.73,13.48 42.99,13.23 44.26,13.48 45.33,14.2 46.05,15.27 46.3,16.54 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="46.3,56.22 46.05,57.49 45.33,58.56 44.26,59.28 42.99,59.53 41.73,59.28 40.65,58.56 39.94,57.49 39.69,56.22 39.94,54.95 40.65,53.88 41.73,53.17 42.99,52.91 44.26,53.17 45.33,53.88 46.05,54.95 46.3,56.22 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="52.91,16.54 52.66,17.8 51.94,18.87 50.87,19.59 49.61,19.84 48.34,19.59 47.27,18.87 46.55,17.8 46.3,16.54 46.55,15.27 47.27,14.2 48.34,13.48 49.61,13.23 50.87,13.48 51.94,14.2 52.66,15.27 52.91,16.54 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="52.91,56.22 52.66,57.49 51.94,58.56 50.87,59.28 49.61,59.53 48.34,59.28 47.27,58.56 46.55,57.49 46.3,56.22 46.55,54.95 47.27,53.88 48.34,53.17 49.61,52.91 50.87,53.17 51.94,53.88 52.66,54.95 52.91,56.22 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="59.53,16.54 59.28,17.8 58.56,18.87 57.49,19.59 56.22,19.84 54.95,19.59 53.88,18.87 53.17,17.8 52.91,16.54 53.17,15.27 53.88,14.2 54.95,13.48 56.22,13.23 57.49,13.48 58.56,14.2 59.28,15.27 59.53,16.54 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="59.53,56.22 59.28,57.49 58.56,58.56 57.49,59.28 56.22,59.53 54.95,59.28 53.88,58.56 53.17,57.49 52.91,56.22 53.17,54.95 53.88,53.88 54.95,53.17 56.22,52.91 57.49,53.17 58.56,53.88 59.28,54.95 59.53,56.22 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="19.84,23.15 19.59,24.42 18.87,25.49 17.8,26.2 16.54,26.46 15.27,26.2 14.2,25.49 13.48,24.42 13.23,23.15 13.48,21.88 14.2,20.81 15.27,20.09 16.54,19.84 17.8,20.09 18.87,20.81 19.59,21.88 19.84,23.15 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="59.53,23.15 59.28,24.42 58.56,25.49 57.49,26.2 56.22,26.46 54.95,26.2 53.88,25.49 53.17,24.42 52.91,23.15 53.17,21.88 53.88,20.81 54.95,20.09 56.22,19.84 57.49,20.09 58.56,20.81 59.28,21.88 59.53,23.15 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="19.84,29.76 19.59,31.03 18.87,32.1 17.8,32.82 16.54,33.07 15.27,32.82 14.2,32.1 13.48,31.03 13.23,29.76 13.48,28.5 14.2,27.43 15.27,26.71 16.54,26.46 17.8,26.71 18.87,27.43 19.59,28.5 19.84,29.76 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="59.53,29.76 59.28,31.03 58.56,32.1 57.49,32.82 56.22,33.07 54.95,32.82 53.88,32.1 53.17,31.03 52.91,29.76 53.17,28.5 53.88,27.43 54.95,26.71 56.22,26.46 57.49,26.71 58.56,27.43 59.28,28.5 59.53,29.76 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="19.84,36.38 19.59,37.64 18.87,38.72 17.8,39.43 16.54,39.69 15.27,39.43 14.2,38.72 13.48,37.64 13.23,36.38 13.48,35.11 14.2,34.04 15.27,33.32 16.54,33.07 17.8,33.32 18.87,34.04 19.59,35.11 19.84,36.38 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="59.53,36.38 59.28,37.64 58.56,38.72 57.49,39.43 56.22,39.69 54.95,39.43 53.88,38.72 53.17,37.64 52.91,36.38 53.17,35.11 53.88,34.04 54.95,33.32 56.22,33.07 57.49,33.32 58.56,34.04 59.28,35.11 59.53,36.38 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="19.84,42.99 19.59,44.26 18.87,45.33 17.8,46.05 16.54,46.3 15.27,46.05 14.2,45.33 13.48,44.26 13.23,42.99 13.48,41.73 14.2,40.65 15.27,39.94 16.54,39.69 17.8,39.94 18.87,40.65 19.59,41.73 19.84,42.99 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="59.53,42.99 59.28,44.26 58.56,45.33 57.49,46.05 56.22,46.3 54.95,46.05 53.88,45.33 53.17,44.26 52.91,42.99 53.17,41.73 53.88,40.65 54.95,39.94 56.22,39.69 57.49,39.94 58.56,40.65 59.28,41.73 59.53,42.99 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="19.84,49.61 19.59,50.87 18.87,51.94 17.8,52.66 16.54,52.91 15.27,52.66 14.2,51.94 13.48,50.87 13.23,49.61 13.48,48.34 14.2,47.27 15.27,46.55 16.54,46.3 17.8,46.55 18.87,47.27 19.59,48.34 19.84,49.61 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="59.53,49.61 59.28,50.87 58.56,51.94 57.49,52.66 56.22,52.91 54.95,52.66 53.88,51.94 53.17,50.87 52.91,49.61 53.17,48.34 53.88,47.27 54.95,46.55 56.22,46.3 57.49,46.55 58.56,47.27 59.28,48.34 59.53,49.61 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="19.84,109.13 19.59,110.4 18.87,111.47 17.8,112.19 16.54,112.44 15.27,112.19 14.2,111.47 13.48,110.4 13.23,109.13 13.48,107.87 14.2,106.8 15.27,106.08 16.54,105.83 17.8,106.08 18.87,106.8 19.59,107.87 19.84,109.13 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="19.84,148.82 19.59,150.08 18.87,151.16 17.8,151.87 16.54,152.13 15.27,151.87 14.2,151.16 13.48,150.08 13.23,148.82 13.48,147.55 14.2,146.48 15.27,145.76 16.54,145.51 17.8,145.76 18.87,146.48 19.59,147.55 19.84,148.82 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="26.46,109.13 26.2,110.4 25.49,111.47 24.42,112.19 23.15,112.44 21.88,112.19 20.81,111.47 20.09,110.4 19.84,109.13 20.09,107.87 20.81,106.8 21.88,106.08 23.15,105.83 24.42,106.08 25.49,106.8 26.2,107.87 26.46,109.13 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="26.46,148.82 26.2,150.08 25.49,151.16 24.42,151.87 23.15,152.13 21.88,151.87 20.81,151.16 20.09,150.08 19.84,148.82 20.09,147.55 20.81,146.48 21.88,145.76 23.15,145.51 24.42,145.76 25.49,146.48 26.2,147.55 26.46,148.82 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="33.07,109.13 32.82,110.4 32.1,111.47 31.03,112.19 29.76,112.44 28.5,112.19 27.43,111.47 26.71,110.4 26.46,109.13 26.71,107.87 27.43,106.8 28.5,106.08 29.76,105.83 31.03,106.08 32.1,106.8 32.82,107.87 33.07,109.13 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="33.07,148.82 32.82,150.08 32.1,151.16 31.03,151.87 29.76,152.13 28.5,151.87 27.43,151.16 26.71,150.08 26.46,148.82 26.71,147.55 27.43,146.48 28.5,145.76 29.76,145.51 31.03,145.76 32.1,146.48 32.82,147.55 33.07,148.82 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="39.69,109.13 39.43,110.4 38.72,111.47 37.64,112.19 36.38,112.44 35.11,112.19 34.04,111.47 33.32,110.4 33.07,109.13 33.32,107.87 34.04,106.8 35.11,106.08 36.38,105.83 37.64,106.08 38.72,106.8 39.43,107.87 39.69,109.13 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="39.69,148.82 39.43,150.08 38.72,151.16 37.64,151.87 36.38,152.13 35.11,151.87 34.04,151.16 33.32,150.08 33.07,148.82 33.32,147.55 34.04,146.48 35.11,145.76 36.38,145.51 37.64,145.76 38.72,146.48 39.43,147.55 39.69,148.82 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="46.3,109.13 46.05,110.4 45.33,111.47 44.26,112.19 42.99,112.44 41.73,112.19 40.65,111.47 39.94,110.4 39.69,109.13 39.94,107.87 40.65,106.8 41.73,106.08 42.99,105.83 44.26,106.08 45.33,106.8 46.05,107.87 46.3,109.13 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="46.3,148.82 46.05,150.08 45.33,151.16 44.26,151.87 42.99,152.13 41.73,151.87 40.65,151.16 39.94,150.08 39.69,148.82 39.94,147.55 40.65,146.48 41.73,145.76 42.99,145.51 44.26,145.76 45.33,146.48 46.05,147.55 46.3,148.82 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="52.91,109.13 52.66,110.4 51.94,111.47 50.87,112.19 49.61,112.44 48.34,112.19 47.27,111.47 46.55,110.4 46.3,109.13 46.55,107.87 47.27,106.8 48.34,106.08 49.61,105.83 50.87,106.08 51.94,106.8 52.66,107.87 52.91,109.13 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="52.91,148.82 52.66,150.08 51.94,151.16 50.87,151.87 49.61,152.13 48.34,151.87 47.27,151.16 46.55,150.08 46.3,148.82 46.55,147.55 47.27,146.48 48.34,145.76 49.61,145.51 50.87,145.76 51.94,146.48 52.66,147.55 52.91,148.82 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="59.53,109.13 59.28,110.4 58.56,111.47 57.49,112.19 56.22,112.44 54.95,112.19 53.88,111.47 53.17,110.4 52.91,109.13 53.17,107.87 53.88,106.8 54.95,106.08 56.22,105.83 57.49,106.08 58.56,106.8 59.28,107.87 59.53,109.13 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="59.53,148.82 59.28,150.08 58.56,151.16 57.49,151.87 56.22,152.13 54.95,151.87 53.88,151.16 53.17,150.08 52.91,148.82 53.17,147.55 53.88,146.48 54.95,145.76 56.22,145.51 57.49,145.76 58.56,146.48 59.28,147.55 59.53,148.82 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="19.84,115.75 19.59,117.01 18.87,118.09 17.8,118.8 16.54,119.06 15.27,118.8 14.2,118.09 13.48,117.01 13.23,115.75 13.48,114.48 14.2,113.41 15.27,112.69 16.54,112.44 17.8,112.69 18.87,113.41 19.59,114.48 19.84,115.75 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="59.53,115.75 59.28,117.01 58.56,118.09 57.49,118.8 56.22,119.06 54.95,118.8 53.88,118.09 53.17,117.01 52.91,115.75 53.17,114.48 53.88,113.41 54.95,112.69 56.22,112.44 57.49,112.69 58.56,113.41 59.28,114.48 59.53,115.75 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="19.84,122.36 19.59,123.63 18.87,124.7 17.8,125.42 16.54,125.67 15.27,125.42 14.2,124.7 13.48,123.63 13.23,122.36 13.48,121.1 14.2,120.02 15.27,119.31 16.54,119.06 17.8,119.31 18.87,120.02 19.59,121.1 19.84,122.36 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="59.53,122.36 59.28,123.63 58.56,124.7 57.49,125.42 56.22,125.67 54.95,125.42 53.88,124.7 53.17,123.63 52.91,122.36 53.17,121.1 53.88,120.02 54.95,119.31 56.22,119.06 57.49,119.31 58.56,120.02 59.28,121.1 59.53,122.36 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="19.84,128.98 19.59,130.24 18.87,131.31 17.8,132.03 16.54,132.28 15.27,132.03 14.2,131.31 13.48,130.24 13.23,128.98 13.48,127.71 14.2,126.64 15.27,125.92 16.54,125.67 17.8,125.92 18.87,126.64 19.59,127.71 19.84,128.98 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="59.53,128.98 59.28,130.24 58.56,131.31 57.49,132.03 56.22,132.28 54.95,132.03 53.88,131.31 53.17,130.24 52.91,128.98 53.17,127.71 53.88,126.64 54.95,125.92 56.22,125.67 57.49,125.92 58.56,126.64 59.28,127.71 59.53,128.98 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="19.84,135.59 19.59,136.86 18.87,137.93 17.8,138.65 16.54,138.9 15.27,138.65 14.2,137.93 13.48,136.86 13.23,135.59 13.48,134.32 14.2,133.25 15.27,132.54 16.54,132.28 17.8,132.54 18.87,133.25 19.59,134.32 19.84,135.59 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="59.53,135.59 59.28,136.86 58.56,137.93 57.49,138.65 56.22,138.9 54.95,138.65 53.88,137.93 53.17,136.86 52.91,135.59 53.17,134.32 53.88,133.25 54.95,132.54 56.22,132.28 57.49,132.54 58.56,133.25 59.28,134.32 59.53,135.59 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="19.84,142.2 19.59,143.47 18.87,144.54 17.8,145.26 16.54,145.51 15.27,145.26 14.2,144.54 13.48,143.47 13.23,142.2 13.48,140.94 14.2,139.87 15.27,139.15 16.54,138.9 17.8,139.15 18.87,139.87 19.59,140.94 19.84,142.2 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="59.53,142.2 59.28,143.47 58.56,144.54 57.49,145.26 56.22,145.51 54.95,145.26 53.88,144.54 53.17,143.47 52.91,142.2 53.17,140.94 53.88,139.87 54.95,139.15 56.22,138.9 57.49,139.15 58.56,139.87 59.28,140.94 59.53,142.2 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="112.44,16.54 112.19,17.8 111.47,18.87 110.4,19.59 109.13,19.84 107.87,19.59 106.8,18.87 106.08,17.8 105.83,16.54 106.08,15.27 106.8,14.2 107.87,13.48 109.13,13.23 110.4,13.48 111.47,14.2 112.19,15.27 112.44,16.54 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="112.44,56.22 112.19,57.49 111.47,58.56 110.4,59.28 109.13,59.53 107.87,59.28 106.8,58.56 106.08,57.49 105.83,56.22 106.08,54.95 106.8,53.88 107.87,53.17 109.13,52.91 110.4,53.17 111.47,53.88 112.19,54.95 112.44,56.22 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="119.06,16.54 118.8,17.8 118.09,18.87 117.01,19.59 115.75,19.84 114.48,19.59 113.41,18.87 112.69,17.8 112.44,16.54 112.69,15.27 113.41,14.2 114.48,13.48 115.75,13.23 117.01,13.48 118.09,14.2 118.8,15.27 119.06,16.54 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="119.06,56.22 118.8,57.49 118.09,58.56 117.01,59.28 115.75,59.53 114.48,59.28 113.41,58.56 112.69,57.49 112.44,56.22 112.69,54.95 113.41,53.88 114.48,53.17 115.75,52.91 117.01,53.17 118.09,53.88 118.8,54.95 119.06,56.22 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="125.67,16.54 125.42,17.8 124.7,18.87 123.63,19.59 122.36,19.84 121.1,19.59 120.02,18.87 119.31,17.8 119.06,16.54 119.31,15.27 120.02,14.2 121.1,13.48 122.36,13.23 123.63,13.48 124.7,14.2 125.42,15.27 125.67,16.54 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="125.67,56.22 125.42,57.49 124.7,58.56 123.63,59.28 122.36,59.53 121.1,59.28 120.02,58.56 119.31,57.49 119.06,56.22 119.31,54.95 120.02,53.88 121.1,53.17 122.36,52.91 123.63,53.17 124.7,53.88 125.42,54.95 125.67,56.22 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="132.28,16.54 132.03,17.8 131.31,18.87 130.24,19.59 128.98,19.84 127.71,19.59 126.64,18.87 125.92,17.8 125.67,16.54 125.92,15.27 126.64,14.2 127.71,13.48 128.98,13.23 130.24,13.48 131.31,14.2 132.03,15.27 132.28,16.54 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="132.28,56.22 132.03,57.49 131.31,58.56 130.24,59.28 128.98,59.53 127.71,59.28 126.64,58.56 125.92,57.49 125.67,56.22 125.92,54.95 126.64,53.88 127.71,53.17 128.98,52.91 130.24,53.17 131.31,53.88 132.03,54.95 132.28,56.22 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="138.9,16.54 138.65,17.8 137.93,18.87 136.86,19.59 135.59,19.84 134.32,19.59 133.25,18.87 132.54,17.8 132.28,16.54 132.54,15.27 133.25,14.2 134.32,13.48 135.59,13.23 136.86,13.48 137.93,14.2 138.65,15.27 138.9,16.54 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="138.9,56.22 138.65,57.49 137.93,58.56 136.86,59.28 135.59,59.53 134.32,59.28 133.25,58.56 132.54,57.49 132.28,56.22 132.54,54.95 133.25,53.88 134.32,53.17 135.59,52.91 136.86,53.17 137.93,53.88 138.65,54.95 138.9,56.22 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="145.51,16.54 145.26,17.8 144.54,18.87 143.47,19.59 142.2,19.84 140.94,19.59 139.87,18.87 139.15,17.8 138.9,16.54 139.15,15.27 139.87,14.2 140.94,13.48 142.2,13.23 143.47,13.48 144.54,14.2 145.26,15.27 145.51,16.54 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="145.51,56.22 145.26,57.49 144.54,58.56 143.47,59.28 142.2,59.53 140.94,59.28 139.87,58.56 139.15,57.49 138.9,56.22 139.15,54.95 139.87,53.88 140.94,53.17 142.2,52.91 143.47,53.17 144.54,53.88 145.26,54.95 145.51,56.22 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="152.13,16.54 151.87,17.8 151.16,18.87 150.08,19.59 148.82,19.84 147.55,19.59 146.48,18.87 145.76,17.8 145.51,16.54 145.76,15.27 146.48,14.2 147.55,13.48 148.82,13.23 150.08,13.48 151.16,14.2 151.87,15.27 152.13,16.54 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="152.13,56.22 151.87,57.49 151.16,58.56 150.08,59.28 148.82,59.53 147.55,59.28 146.48,58.56 145.76,57.49 145.51,56.22 145.76,54.95 146.48,53.88 147.55,53.17 148.82,52.91 150.08,53.17 151.16,53.88 151.87,54.95 152.13,56.22 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="112.44,23.15 112.19,24.42 111.47,25.49 110.4,26.2 109.13,26.46 107.87,26.2 106.8,25.49 106.08,24.42 105.83,23.15 106.08,21.88 106.8,20.81 107.87,20.09 109.13,19.84 110.4,20.09 111.47,20.81 112.19,21.88 112.44,23.15 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="152.13,23.15 151.87,24.42 151.16,25.49 150.08,26.2 148.82,26.46 147.55,26.2 146.48,25.49 145.76,24.42 145.51,23.15 145.76,21.88 146.48,20.81 147.55,20.09 148.82,19.84 150.08,20.09 151.16,20.81 151.87,21.88 152.13,23.15 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="112.44,29.76 112.19,31.03 111.47,32.1 110.4,32.82 109.13,33.07 107.87,32.82 106.8,32.1 106.08,31.03 105.83,29.76 106.08,28.5 106.8,27.43 107.87,26.71 109.13,26.46 110.4,26.71 111.47,27.43 112.19,28.5 112.44,29.76 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="152.13,29.76 151.87,31.03 151.16,32.1 150.08,32.82 148.82,33.07 147.55,32.82 146.48,32.1 145.76,31.03 145.51,29.76 145.76,28.5 146.48,27.43 147.55,26.71 148.82,26.46 150.08,26.71 151.16,27.43 151.87,28.5 152.13,29.76 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="112.44,36.38 112.19,37.64 111.47,38.72 110.4,39.43 109.13,39.69 107.87,39.43 106.8,38.72 106.08,37.64 105.83,36.38 106.08,35.11 106.8,34.04 107.87,33.32 109.13,33.07 110.4,33.32 111.47,34.04 112.19,35.11 112.44,36.38 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="152.13,36.38 151.87,37.64 151.16,38.72 150.08,39.43 148.82,39.69 147.55,39.43 146.48,38.72 145.76,37.64 145.51,36.38 145.76,35.11 146.48,34.04 147.55,33.32 148.82,33.07 150.08,33.32 151.16,34.04 151.87,35.11 152.13,36.38 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="112.44,42.99 112.19,44.26 111.47,45.33 110.4,46.05 109.13,46.3 107.87,46.05 106.8,45.33 106.08,44.26 105.83,42.99 106.08,41.73 106.8,40.65 107.87,39.94 109.13,39.69 110.4,39.94 111.47,40.65 112.19,41.73 112.44,42.99 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="152.13,42.99 151.87,44.26 151.16,45.33 150.08,46.05 148.82,46.3 147.55,46.05 146.48,45.33 145.76,44.26 145.51,42.99 145.76,41.73 146.48,40.65 147.55,39.94 148.82,39.69 150.08,39.94 151.16,40.65 151.87,41.73 152.13,42.99 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="112.44,49.61 112.19,50.87 111.47,51.94 110.4,52.66 109.13,52.91 107.87,52.66 106.8,51.94 106.08,50.87 105.83,49.61 106.08,48.34 106.8,47.27 107.87,46.55 109.13,46.3 110.4,46.55 111.47,47.27 112.19,48.34 112.44,49.61 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="152.13,49.61 151.87,50.87 151.16,51.94 150.08,52.66 148.82,52.91 147.55,52.66 146.48,51.94 145.76,50.87 145.51,49.61 145.76,48.34 146.48,47.27 147.55,46.55 148.82,46.3 150.08,46.55 151.16,47.27 151.87,48.34 152.13,49.61 "
          style="fill:url(#gradient0a63a848c18243f2af2c33edde29962a);"
        />
        <polygon
          points="33.07,29.76 32.82,31.03 32.1,32.1 31.03,32.82 29.76,33.07 28.5,32.82 27.43,32.1 26.71,31.03 26.46,29.76 26.71,28.5 27.43,27.43 28.5,26.71 29.76,26.46 31.03,26.71 32.1,27.43 32.82,28.5 33.07,29.76 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="39.69,29.76 39.43,31.03 38.72,32.1 37.64,32.82 36.38,33.07 35.11,32.82 34.04,32.1 33.32,31.03 33.07,29.76 33.32,28.5 34.04,27.43 35.11,26.71 36.38,26.46 37.64,26.71 38.72,27.43 39.43,28.5 39.69,29.76 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="46.3,29.76 46.05,31.03 45.33,32.1 44.26,32.82 42.99,33.07 41.73,32.82 40.65,32.1 39.94,31.03 39.69,29.76 39.94,28.5 40.65,27.43 41.73,26.71 42.99,26.46 44.26,26.71 45.33,27.43 46.05,28.5 46.3,29.76 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="33.07,36.38 32.82,37.64 32.1,38.72 31.03,39.43 29.76,39.69 28.5,39.43 27.43,38.72 26.71,37.64 26.46,36.38 26.71,35.11 27.43,34.04 28.5,33.32 29.76,33.07 31.03,33.32 32.1,34.04 32.82,35.11 33.07,36.38 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="39.69,36.38 39.43,37.64 38.72,38.72 37.64,39.43 36.38,39.69 35.11,39.43 34.04,38.72 33.32,37.64 33.07,36.38 33.32,35.11 34.04,34.04 35.11,33.32 36.38,33.07 37.64,33.32 38.72,34.04 39.43,35.11 39.69,36.38 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="46.3,36.38 46.05,37.64 45.33,38.72 44.26,39.43 42.99,39.69 41.73,39.43 40.65,38.72 39.94,37.64 39.69,36.38 39.94,35.11 40.65,34.04 41.73,33.32 42.99,33.07 44.26,33.32 45.33,34.04 46.05,35.11 46.3,36.38 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="33.07,42.99 32.82,44.26 32.1,45.33 31.03,46.05 29.76,46.3 28.5,46.05 27.43,45.33 26.71,44.26 26.46,42.99 26.71,41.73 27.43,40.65 28.5,39.94 29.76,39.69 31.03,39.94 32.1,40.65 32.82,41.73 33.07,42.99 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="39.69,42.99 39.43,44.26 38.72,45.33 37.64,46.05 36.38,46.3 35.11,46.05 34.04,45.33 33.32,44.26 33.07,42.99 33.32,41.73 34.04,40.65 35.11,39.94 36.38,39.69 37.64,39.94 38.72,40.65 39.43,41.73 39.69,42.99 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="46.3,42.99 46.05,44.26 45.33,45.33 44.26,46.05 42.99,46.3 41.73,46.05 40.65,45.33 39.94,44.26 39.69,42.99 39.94,41.73 40.65,40.65 41.73,39.94 42.99,39.69 44.26,39.94 45.33,40.65 46.05,41.73 46.3,42.99 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="33.07,122.36 32.82,123.63 32.1,124.7 31.03,125.42 29.76,125.67 28.5,125.42 27.43,124.7 26.71,123.63 26.46,122.36 26.71,121.1 27.43,120.02 28.5,119.31 29.76,119.06 31.03,119.31 32.1,120.02 32.82,121.1 33.07,122.36 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="39.69,122.36 39.43,123.63 38.72,124.7 37.64,125.42 36.38,125.67 35.11,125.42 34.04,124.7 33.32,123.63 33.07,122.36 33.32,121.1 34.04,120.02 35.11,119.31 36.38,119.06 37.64,119.31 38.72,120.02 39.43,121.1 39.69,122.36 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="46.3,122.36 46.05,123.63 45.33,124.7 44.26,125.42 42.99,125.67 41.73,125.42 40.65,124.7 39.94,123.63 39.69,122.36 39.94,121.1 40.65,120.02 41.73,119.31 42.99,119.06 44.26,119.31 45.33,120.02 46.05,121.1 46.3,122.36 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="33.07,128.98 32.82,130.24 32.1,131.31 31.03,132.03 29.76,132.28 28.5,132.03 27.43,131.31 26.71,130.24 26.46,128.98 26.71,127.71 27.43,126.64 28.5,125.92 29.76,125.67 31.03,125.92 32.1,126.64 32.82,127.71 33.07,128.98 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="39.69,128.98 39.43,130.24 38.72,131.31 37.64,132.03 36.38,132.28 35.11,132.03 34.04,131.31 33.32,130.24 33.07,128.98 33.32,127.71 34.04,126.64 35.11,125.92 36.38,125.67 37.64,125.92 38.72,126.64 39.43,127.71 39.69,128.98 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="46.3,128.98 46.05,130.24 45.33,131.31 44.26,132.03 42.99,132.28 41.73,132.03 40.65,131.31 39.94,130.24 39.69,128.98 39.94,127.71 40.65,126.64 41.73,125.92 42.99,125.67 44.26,125.92 45.33,126.64 46.05,127.71 46.3,128.98 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="33.07,135.59 32.82,136.86 32.1,137.93 31.03,138.65 29.76,138.9 28.5,138.65 27.43,137.93 26.71,136.86 26.46,135.59 26.71,134.32 27.43,133.25 28.5,132.54 29.76,132.28 31.03,132.54 32.1,133.25 32.82,134.32 33.07,135.59 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="39.69,135.59 39.43,136.86 38.72,137.93 37.64,138.65 36.38,138.9 35.11,138.65 34.04,137.93 33.32,136.86 33.07,135.59 33.32,134.32 34.04,133.25 35.11,132.54 36.38,132.28 37.64,132.54 38.72,133.25 39.43,134.32 39.69,135.59 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="46.3,135.59 46.05,136.86 45.33,137.93 44.26,138.65 42.99,138.9 41.73,138.65 40.65,137.93 39.94,136.86 39.69,135.59 39.94,134.32 40.65,133.25 41.73,132.54 42.99,132.28 44.26,132.54 45.33,133.25 46.05,134.32 46.3,135.59 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="125.67,29.76 125.42,31.03 124.7,32.1 123.63,32.82 122.36,33.07 121.1,32.82 120.02,32.1 119.31,31.03 119.06,29.76 119.31,28.5 120.02,27.43 121.1,26.71 122.36,26.46 123.63,26.71 124.7,27.43 125.42,28.5 125.67,29.76 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="132.28,29.76 132.03,31.03 131.31,32.1 130.24,32.82 128.98,33.07 127.71,32.82 126.64,32.1 125.92,31.03 125.67,29.76 125.92,28.5 126.64,27.43 127.71,26.71 128.98,26.46 130.24,26.71 131.31,27.43 132.03,28.5 132.28,29.76 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="138.9,29.76 138.65,31.03 137.93,32.1 136.86,32.82 135.59,33.07 134.32,32.82 133.25,32.1 132.54,31.03 132.28,29.76 132.54,28.5 133.25,27.43 134.32,26.71 135.59,26.46 136.86,26.71 137.93,27.43 138.65,28.5 138.9,29.76 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="125.67,36.38 125.42,37.64 124.7,38.72 123.63,39.43 122.36,39.69 121.1,39.43 120.02,38.72 119.31,37.64 119.06,36.38 119.31,35.11 120.02,34.04 121.1,33.32 122.36,33.07 123.63,33.32 124.7,34.04 125.42,35.11 125.67,36.38 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="132.28,36.38 132.03,37.64 131.31,38.72 130.24,39.43 128.98,39.69 127.71,39.43 126.64,38.72 125.92,37.64 125.67,36.38 125.92,35.11 126.64,34.04 127.71,33.32 128.98,33.07 130.24,33.32 131.31,34.04 132.03,35.11 132.28,36.38 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="138.9,36.38 138.65,37.64 137.93,38.72 136.86,39.43 135.59,39.69 134.32,39.43 133.25,38.72 132.54,37.64 132.28,36.38 132.54,35.11 133.25,34.04 134.32,33.32 135.59,33.07 136.86,33.32 137.93,34.04 138.65,35.11 138.9,36.38 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="125.67,42.99 125.42,44.26 124.7,45.33 123.63,46.05 122.36,46.3 121.1,46.05 120.02,45.33 119.31,44.26 119.06,42.99 119.31,41.73 120.02,40.65 121.1,39.94 122.36,39.69 123.63,39.94 124.7,40.65 125.42,41.73 125.67,42.99 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="132.28,42.99 132.03,44.26 131.31,45.33 130.24,46.05 128.98,46.3 127.71,46.05 126.64,45.33 125.92,44.26 125.67,42.99 125.92,41.73 126.64,40.65 127.71,39.94 128.98,39.69 130.24,39.94 131.31,40.65 132.03,41.73 132.28,42.99 "
          style="fill:rgba(36,82,143,1);"
        />
        <polygon
          points="138.9,42.99 138.65,44.26 137.93,45.33 136.86,46.05 135.59,46.3 134.32,46.05 133.25,45.33 132.54,44.26 132.28,42.99 132.54,41.73 133.25,40.65 134.32,39.94 135.59,39.69 136.86,39.94 137.93,40.65 138.65,41.73 138.9,42.99 "
          style="fill:rgba(36,82,143,1);"
        />
        <linearGradient
          id="gradient656a9574a16d49d783c4af7996609d4f"
          gradientUnits="userSpaceOnUse"
          x1="11.1772292562222"
          y1="78.9300121785742"
          x2="154.177100806644"
          y2="86.424317884292"
        >
          <stop offset="0%" stop-color="#493963" />
          <stop offset="50%" stop-color="#017B2E" />
          <stop offset="100%" stop-color="#493963" />
        </linearGradient>
        <polygon
          points="84.66,16.54 84.4,17.53 83.67,18.25 82.68,18.52 81.69,18.25 80.96,17.53 80.69,16.54 80.96,15.54 81.69,14.82 82.68,14.55 83.67,14.82 84.4,15.54 84.66,16.54 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="91.28,16.54 91.01,17.53 90.28,18.25 89.29,18.52 88.3,18.25 87.57,17.53 87.31,16.54 87.57,15.54 88.3,14.82 89.29,14.55 90.28,14.82 91.01,15.54 91.28,16.54 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="97.89,16.54 97.62,17.53 96.9,18.25 95.91,18.52 94.91,18.25 94.19,17.53 93.92,16.54 94.19,15.54 94.91,14.82 95.91,14.55 96.9,14.82 97.62,15.54 97.89,16.54 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="71.43,23.15 71.17,24.14 70.44,24.87 69.45,25.13 68.46,24.87 67.73,24.14 67.46,23.15 67.73,22.16 68.46,21.43 69.45,21.17 70.44,21.43 71.17,22.16 71.43,23.15 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="78.05,23.15 77.78,24.14 77.06,24.87 76.06,25.13 75.07,24.87 74.34,24.14 74.08,23.15 74.34,22.16 75.07,21.43 76.06,21.17 77.06,21.43 77.78,22.16 78.05,23.15 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="84.66,23.15 84.4,24.14 83.67,24.87 82.68,25.13 81.69,24.87 80.96,24.14 80.69,23.15 80.96,22.16 81.69,21.43 82.68,21.17 83.67,21.43 84.4,22.16 84.66,23.15 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="97.89,23.15 97.62,24.14 96.9,24.87 95.91,25.13 94.91,24.87 94.19,24.14 93.92,23.15 94.19,22.16 94.91,21.43 95.91,21.17 96.9,21.43 97.62,22.16 97.89,23.15 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="84.66,29.76 84.4,30.76 83.67,31.48 82.68,31.75 81.69,31.48 80.96,30.76 80.69,29.76 80.96,28.77 81.69,28.05 82.68,27.78 83.67,28.05 84.4,28.77 84.66,29.76 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="91.28,29.76 91.01,30.76 90.28,31.48 89.29,31.75 88.3,31.48 87.57,30.76 87.31,29.76 87.57,28.77 88.3,28.05 89.29,27.78 90.28,28.05 91.01,28.77 91.28,29.76 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="97.89,29.76 97.62,30.76 96.9,31.48 95.91,31.75 94.91,31.48 94.19,30.76 93.92,29.76 94.19,28.77 94.91,28.05 95.91,27.78 96.9,28.05 97.62,28.77 97.89,29.76 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="71.43,36.38 71.17,37.37 70.44,38.1 69.45,38.36 68.46,38.1 67.73,37.37 67.46,36.38 67.73,35.39 68.46,34.66 69.45,34.39 70.44,34.66 71.17,35.39 71.43,36.38 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="78.05,36.38 77.78,37.37 77.06,38.1 76.06,38.36 75.07,38.1 74.34,37.37 74.08,36.38 74.34,35.39 75.07,34.66 76.06,34.39 77.06,34.66 77.78,35.39 78.05,36.38 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="97.89,36.38 97.62,37.37 96.9,38.1 95.91,38.36 94.91,38.1 94.19,37.37 93.92,36.38 94.19,35.39 94.91,34.66 95.91,34.39 96.9,34.66 97.62,35.39 97.89,36.38 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="78.05,42.99 77.78,43.98 77.06,44.71 76.06,44.98 75.07,44.71 74.34,43.98 74.08,42.99 74.34,42 75.07,41.27 76.06,41.01 77.06,41.27 77.78,42 78.05,42.99 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="97.89,42.99 97.62,43.98 96.9,44.71 95.91,44.98 94.91,44.71 94.19,43.98 93.92,42.99 94.19,42 94.91,41.27 95.91,41.01 96.9,41.27 97.62,42 97.89,42.99 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="71.43,49.61 71.17,50.6 70.44,51.32 69.45,51.59 68.46,51.32 67.73,50.6 67.46,49.61 67.73,48.61 68.46,47.89 69.45,47.62 70.44,47.89 71.17,48.61 71.43,49.61 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="91.28,49.61 91.01,50.6 90.28,51.32 89.29,51.59 88.3,51.32 87.57,50.6 87.31,49.61 87.57,48.61 88.3,47.89 89.29,47.62 90.28,47.89 91.01,48.61 91.28,49.61 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="71.43,56.22 71.17,57.21 70.44,57.94 69.45,58.2 68.46,57.94 67.73,57.21 67.46,56.22 67.73,55.23 68.46,54.5 69.45,54.24 70.44,54.5 71.17,55.23 71.43,56.22 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="84.66,56.22 84.4,57.21 83.67,57.94 82.68,58.2 81.69,57.94 80.96,57.21 80.69,56.22 80.96,55.23 81.69,54.5 82.68,54.24 83.67,54.5 84.4,55.23 84.66,56.22 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="97.89,56.22 97.62,57.21 96.9,57.94 95.91,58.2 94.91,57.94 94.19,57.21 93.92,56.22 94.19,55.23 94.91,54.5 95.91,54.24 96.9,54.5 97.62,55.23 97.89,56.22 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="78.05,62.83 77.78,63.83 77.06,64.55 76.06,64.82 75.07,64.55 74.34,63.83 74.08,62.83 74.34,61.84 75.07,61.12 76.06,60.85 77.06,61.12 77.78,61.84 78.05,62.83 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="18.52,69.45 18.25,70.44 17.53,71.17 16.54,71.43 15.54,71.17 14.82,70.44 14.55,69.45 14.82,68.46 15.54,67.73 16.54,67.46 17.53,67.73 18.25,68.46 18.52,69.45 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="25.13,69.45 24.87,70.44 24.14,71.17 23.15,71.43 22.16,71.17 21.43,70.44 21.17,69.45 21.43,68.46 22.16,67.73 23.15,67.46 24.14,67.73 24.87,68.46 25.13,69.45 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="31.75,69.45 31.48,70.44 30.76,71.17 29.76,71.43 28.77,71.17 28.05,70.44 27.78,69.45 28.05,68.46 28.77,67.73 29.76,67.46 30.76,67.73 31.48,68.46 31.75,69.45 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="38.36,69.45 38.1,70.44 37.37,71.17 36.38,71.43 35.39,71.17 34.66,70.44 34.39,69.45 34.66,68.46 35.39,67.73 36.38,67.46 37.37,67.73 38.1,68.46 38.36,69.45 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="44.98,69.45 44.71,70.44 43.98,71.17 42.99,71.43 42,71.17 41.27,70.44 41.01,69.45 41.27,68.46 42,67.73 42.99,67.46 43.98,67.73 44.71,68.46 44.98,69.45 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="58.2,69.45 57.94,70.44 57.21,71.17 56.22,71.43 55.23,71.17 54.5,70.44 54.24,69.45 54.5,68.46 55.23,67.73 56.22,67.46 57.21,67.73 57.94,68.46 58.2,69.45 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="64.82,69.45 64.55,70.44 63.83,71.17 62.83,71.43 61.84,71.17 61.12,70.44 60.85,69.45 61.12,68.46 61.84,67.73 62.83,67.46 63.83,67.73 64.55,68.46 64.82,69.45 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="71.43,69.45 71.17,70.44 70.44,71.17 69.45,71.43 68.46,71.17 67.73,70.44 67.46,69.45 67.73,68.46 68.46,67.73 69.45,67.46 70.44,67.73 71.17,68.46 71.43,69.45 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="91.28,69.45 91.01,70.44 90.28,71.17 89.29,71.43 88.3,71.17 87.57,70.44 87.31,69.45 87.57,68.46 88.3,67.73 89.29,67.46 90.28,67.73 91.01,68.46 91.28,69.45 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="104.5,69.45 104.24,70.44 103.51,71.17 102.52,71.43 101.53,71.17 100.8,70.44 100.54,69.45 100.8,68.46 101.53,67.73 102.52,67.46 103.51,67.73 104.24,68.46 104.5,69.45 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="117.73,69.45 117.47,70.44 116.74,71.17 115.75,71.43 114.76,71.17 114.03,70.44 113.76,69.45 114.03,68.46 114.76,67.73 115.75,67.46 116.74,67.73 117.47,68.46 117.73,69.45 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="130.96,69.45 130.69,70.44 129.97,71.17 128.98,71.43 127.98,71.17 127.26,70.44 126.99,69.45 127.26,68.46 127.98,67.73 128.98,67.46 129.97,67.73 130.69,68.46 130.96,69.45 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="144.19,69.45 143.92,70.44 143.2,71.17 142.2,71.43 141.21,71.17 140.49,70.44 140.22,69.45 140.49,68.46 141.21,67.73 142.2,67.46 143.2,67.73 143.92,68.46 144.19,69.45 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="18.52,76.06 18.25,77.06 17.53,77.78 16.54,78.05 15.54,77.78 14.82,77.06 14.55,76.06 14.82,75.07 15.54,74.34 16.54,74.08 17.53,74.34 18.25,75.07 18.52,76.06 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="25.13,76.06 24.87,77.06 24.14,77.78 23.15,78.05 22.16,77.78 21.43,77.06 21.17,76.06 21.43,75.07 22.16,74.34 23.15,74.08 24.14,74.34 24.87,75.07 25.13,76.06 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="31.75,76.06 31.48,77.06 30.76,77.78 29.76,78.05 28.77,77.78 28.05,77.06 27.78,76.06 28.05,75.07 28.77,74.34 29.76,74.08 30.76,74.34 31.48,75.07 31.75,76.06 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="51.59,76.06 51.32,77.06 50.6,77.78 49.61,78.05 48.61,77.78 47.89,77.06 47.62,76.06 47.89,75.07 48.61,74.34 49.61,74.08 50.6,74.34 51.32,75.07 51.59,76.06 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="64.82,76.06 64.55,77.06 63.83,77.78 62.83,78.05 61.84,77.78 61.12,77.06 60.85,76.06 61.12,75.07 61.84,74.34 62.83,74.08 63.83,74.34 64.55,75.07 64.82,76.06 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="78.05,76.06 77.78,77.06 77.06,77.78 76.06,78.05 75.07,77.78 74.34,77.06 74.08,76.06 74.34,75.07 75.07,74.34 76.06,74.08 77.06,74.34 77.78,75.07 78.05,76.06 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="91.28,76.06 91.01,77.06 90.28,77.78 89.29,78.05 88.3,77.78 87.57,77.06 87.31,76.06 87.57,75.07 88.3,74.34 89.29,74.08 90.28,74.34 91.01,75.07 91.28,76.06 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="97.89,76.06 97.62,77.06 96.9,77.78 95.91,78.05 94.91,77.78 94.19,77.06 93.92,76.06 94.19,75.07 94.91,74.34 95.91,74.08 96.9,74.34 97.62,75.07 97.89,76.06 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="104.5,76.06 104.24,77.06 103.51,77.78 102.52,78.05 101.53,77.78 100.8,77.06 100.54,76.06 100.8,75.07 101.53,74.34 102.52,74.08 103.51,74.34 104.24,75.07 104.5,76.06 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="111.12,76.06 110.85,77.06 110.13,77.78 109.13,78.05 108.14,77.78 107.42,77.06 107.15,76.06 107.42,75.07 108.14,74.34 109.13,74.08 110.13,74.34 110.85,75.07 111.12,76.06 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="130.96,76.06 130.69,77.06 129.97,77.78 128.98,78.05 127.98,77.78 127.26,77.06 126.99,76.06 127.26,75.07 127.98,74.34 128.98,74.08 129.97,74.34 130.69,75.07 130.96,76.06 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="137.57,76.06 137.31,77.06 136.58,77.78 135.59,78.05 134.6,77.78 133.87,77.06 133.61,76.06 133.87,75.07 134.6,74.34 135.59,74.08 136.58,74.34 137.31,75.07 137.57,76.06 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="144.19,76.06 143.92,77.06 143.2,77.78 142.2,78.05 141.21,77.78 140.49,77.06 140.22,76.06 140.49,75.07 141.21,74.34 142.2,74.08 143.2,74.34 143.92,75.07 144.19,76.06 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="150.8,76.06 150.54,77.06 149.81,77.78 148.82,78.05 147.83,77.78 147.1,77.06 146.83,76.06 147.1,75.07 147.83,74.34 148.82,74.08 149.81,74.34 150.54,75.07 150.8,76.06 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="31.75,82.68 31.48,83.67 30.76,84.4 29.76,84.66 28.77,84.4 28.05,83.67 27.78,82.68 28.05,81.69 28.77,80.96 29.76,80.69 30.76,80.96 31.48,81.69 31.75,82.68 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="44.98,82.68 44.71,83.67 43.98,84.4 42.99,84.66 42,84.4 41.27,83.67 41.01,82.68 41.27,81.69 42,80.96 42.99,80.69 43.98,80.96 44.71,81.69 44.98,82.68 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="51.59,82.68 51.32,83.67 50.6,84.4 49.61,84.66 48.61,84.4 47.89,83.67 47.62,82.68 47.89,81.69 48.61,80.96 49.61,80.69 50.6,80.96 51.32,81.69 51.59,82.68 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="58.2,82.68 57.94,83.67 57.21,84.4 56.22,84.66 55.23,84.4 54.5,83.67 54.24,82.68 54.5,81.69 55.23,80.96 56.22,80.69 57.21,80.96 57.94,81.69 58.2,82.68 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="71.43,82.68 71.17,83.67 70.44,84.4 69.45,84.66 68.46,84.4 67.73,83.67 67.46,82.68 67.73,81.69 68.46,80.96 69.45,80.69 70.44,80.96 71.17,81.69 71.43,82.68 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="78.05,82.68 77.78,83.67 77.06,84.4 76.06,84.66 75.07,84.4 74.34,83.67 74.08,82.68 74.34,81.69 75.07,80.96 76.06,80.69 77.06,80.96 77.78,81.69 78.05,82.68 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="97.89,82.68 97.62,83.67 96.9,84.4 95.91,84.66 94.91,84.4 94.19,83.67 93.92,82.68 94.19,81.69 94.91,80.96 95.91,80.69 96.9,80.96 97.62,81.69 97.89,82.68 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="111.12,82.68 110.85,83.67 110.13,84.4 109.13,84.66 108.14,84.4 107.42,83.67 107.15,82.68 107.42,81.69 108.14,80.96 109.13,80.69 110.13,80.96 110.85,81.69 111.12,82.68 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="117.73,82.68 117.47,83.67 116.74,84.4 115.75,84.66 114.76,84.4 114.03,83.67 113.76,82.68 114.03,81.69 114.76,80.96 115.75,80.69 116.74,80.96 117.47,81.69 117.73,82.68 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="130.96,82.68 130.69,83.67 129.97,84.4 128.98,84.66 127.98,84.4 127.26,83.67 126.99,82.68 127.26,81.69 127.98,80.96 128.98,80.69 129.97,80.96 130.69,81.69 130.96,82.68 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="150.8,82.68 150.54,83.67 149.81,84.4 148.82,84.66 147.83,84.4 147.1,83.67 146.83,82.68 147.1,81.69 147.83,80.96 148.82,80.69 149.81,80.96 150.54,81.69 150.8,82.68 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="18.52,89.29 18.25,90.28 17.53,91.01 16.54,91.28 15.54,91.01 14.82,90.28 14.55,89.29 14.82,88.3 15.54,87.57 16.54,87.31 17.53,87.57 18.25,88.3 18.52,89.29 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="38.36,89.29 38.1,90.28 37.37,91.01 36.38,91.28 35.39,91.01 34.66,90.28 34.39,89.29 34.66,88.3 35.39,87.57 36.38,87.31 37.37,87.57 38.1,88.3 38.36,89.29 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="91.28,89.29 91.01,90.28 90.28,91.01 89.29,91.28 88.3,91.01 87.57,90.28 87.31,89.29 87.57,88.3 88.3,87.57 89.29,87.31 90.28,87.57 91.01,88.3 91.28,89.29 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="97.89,89.29 97.62,90.28 96.9,91.01 95.91,91.28 94.91,91.01 94.19,90.28 93.92,89.29 94.19,88.3 94.91,87.57 95.91,87.31 96.9,87.57 97.62,88.3 97.89,89.29 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="104.5,89.29 104.24,90.28 103.51,91.01 102.52,91.28 101.53,91.01 100.8,90.28 100.54,89.29 100.8,88.3 101.53,87.57 102.52,87.31 103.51,87.57 104.24,88.3 104.5,89.29 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="111.12,89.29 110.85,90.28 110.13,91.01 109.13,91.28 108.14,91.01 107.42,90.28 107.15,89.29 107.42,88.3 108.14,87.57 109.13,87.31 110.13,87.57 110.85,88.3 111.12,89.29 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="137.57,89.29 137.31,90.28 136.58,91.01 135.59,91.28 134.6,91.01 133.87,90.28 133.61,89.29 133.87,88.3 134.6,87.57 135.59,87.31 136.58,87.57 137.31,88.3 137.57,89.29 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="144.19,89.29 143.92,90.28 143.2,91.01 142.2,91.28 141.21,91.01 140.49,90.28 140.22,89.29 140.49,88.3 141.21,87.57 142.2,87.31 143.2,87.57 143.92,88.3 144.19,89.29 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="150.8,89.29 150.54,90.28 149.81,91.01 148.82,91.28 147.83,91.01 147.1,90.28 146.83,89.29 147.1,88.3 147.83,87.57 148.82,87.31 149.81,87.57 150.54,88.3 150.8,89.29 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="25.13,95.91 24.87,96.9 24.14,97.62 23.15,97.89 22.16,97.62 21.43,96.9 21.17,95.91 21.43,94.91 22.16,94.19 23.15,93.92 24.14,94.19 24.87,94.91 25.13,95.91 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="38.36,95.91 38.1,96.9 37.37,97.62 36.38,97.89 35.39,97.62 34.66,96.9 34.39,95.91 34.66,94.91 35.39,94.19 36.38,93.92 37.37,94.19 38.1,94.91 38.36,95.91 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="44.98,95.91 44.71,96.9 43.98,97.62 42.99,97.89 42,97.62 41.27,96.9 41.01,95.91 41.27,94.91 42,94.19 42.99,93.92 43.98,94.19 44.71,94.91 44.98,95.91 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="58.2,95.91 57.94,96.9 57.21,97.62 56.22,97.89 55.23,97.62 54.5,96.9 54.24,95.91 54.5,94.91 55.23,94.19 56.22,93.92 57.21,94.19 57.94,94.91 58.2,95.91 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="71.43,95.91 71.17,96.9 70.44,97.62 69.45,97.89 68.46,97.62 67.73,96.9 67.46,95.91 67.73,94.91 68.46,94.19 69.45,93.92 70.44,94.19 71.17,94.91 71.43,95.91 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="78.05,95.91 77.78,96.9 77.06,97.62 76.06,97.89 75.07,97.62 74.34,96.9 74.08,95.91 74.34,94.91 75.07,94.19 76.06,93.92 77.06,94.19 77.78,94.91 78.05,95.91 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="97.89,95.91 97.62,96.9 96.9,97.62 95.91,97.89 94.91,97.62 94.19,96.9 93.92,95.91 94.19,94.91 94.91,94.19 95.91,93.92 96.9,94.19 97.62,94.91 97.89,95.91 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="117.73,95.91 117.47,96.9 116.74,97.62 115.75,97.89 114.76,97.62 114.03,96.9 113.76,95.91 114.03,94.91 114.76,94.19 115.75,93.92 116.74,94.19 117.47,94.91 117.73,95.91 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="144.19,95.91 143.92,96.9 143.2,97.62 142.2,97.89 141.21,97.62 140.49,96.9 140.22,95.91 140.49,94.91 141.21,94.19 142.2,93.92 143.2,94.19 143.92,94.91 144.19,95.91 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="71.43,102.52 71.17,103.51 70.44,104.24 69.45,104.5 68.46,104.24 67.73,103.51 67.46,102.52 67.73,101.53 68.46,100.8 69.45,100.54 70.44,100.8 71.17,101.53 71.43,102.52 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="84.66,102.52 84.4,103.51 83.67,104.24 82.68,104.5 81.69,104.24 80.96,103.51 80.69,102.52 80.96,101.53 81.69,100.8 82.68,100.54 83.67,100.8 84.4,101.53 84.66,102.52 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="97.89,102.52 97.62,103.51 96.9,104.24 95.91,104.5 94.91,104.24 94.19,103.51 93.92,102.52 94.19,101.53 94.91,100.8 95.91,100.54 96.9,100.8 97.62,101.53 97.89,102.52 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="117.73,102.52 117.47,103.51 116.74,104.24 115.75,104.5 114.76,104.24 114.03,103.51 113.76,102.52 114.03,101.53 114.76,100.8 115.75,100.54 116.74,100.8 117.47,101.53 117.73,102.52 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="137.57,102.52 137.31,103.51 136.58,104.24 135.59,104.5 134.6,104.24 133.87,103.51 133.61,102.52 133.87,101.53 134.6,100.8 135.59,100.54 136.58,100.8 137.31,101.53 137.57,102.52 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="71.43,109.13 71.17,110.13 70.44,110.85 69.45,111.12 68.46,110.85 67.73,110.13 67.46,109.13 67.73,108.14 68.46,107.42 69.45,107.15 70.44,107.42 71.17,108.14 71.43,109.13 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="91.28,109.13 91.01,110.13 90.28,110.85 89.29,111.12 88.3,110.85 87.57,110.13 87.31,109.13 87.57,108.14 88.3,107.42 89.29,107.15 90.28,107.42 91.01,108.14 91.28,109.13 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="104.5,109.13 104.24,110.13 103.51,110.85 102.52,111.12 101.53,110.85 100.8,110.13 100.54,109.13 100.8,108.14 101.53,107.42 102.52,107.15 103.51,107.42 104.24,108.14 104.5,109.13 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="124.35,109.13 124.08,110.13 123.35,110.85 122.36,111.12 121.37,110.85 120.64,110.13 120.38,109.13 120.64,108.14 121.37,107.42 122.36,107.15 123.35,107.42 124.08,108.14 124.35,109.13 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="130.96,109.13 130.69,110.13 129.97,110.85 128.98,111.12 127.98,110.85 127.26,110.13 126.99,109.13 127.26,108.14 127.98,107.42 128.98,107.15 129.97,107.42 130.69,108.14 130.96,109.13 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="144.19,109.13 143.92,110.13 143.2,110.85 142.2,111.12 141.21,110.85 140.49,110.13 140.22,109.13 140.49,108.14 141.21,107.42 142.2,107.15 143.2,107.42 143.92,108.14 144.19,109.13 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="150.8,109.13 150.54,110.13 149.81,110.85 148.82,111.12 147.83,110.85 147.1,110.13 146.83,109.13 147.1,108.14 147.83,107.42 148.82,107.15 149.81,107.42 150.54,108.14 150.8,109.13 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="78.05,115.75 77.78,116.74 77.06,117.47 76.06,117.73 75.07,117.47 74.34,116.74 74.08,115.75 74.34,114.76 75.07,114.03 76.06,113.76 77.06,114.03 77.78,114.76 78.05,115.75 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="84.66,115.75 84.4,116.74 83.67,117.47 82.68,117.73 81.69,117.47 80.96,116.74 80.69,115.75 80.96,114.76 81.69,114.03 82.68,113.76 83.67,114.03 84.4,114.76 84.66,115.75 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="117.73,115.75 117.47,116.74 116.74,117.47 115.75,117.73 114.76,117.47 114.03,116.74 113.76,115.75 114.03,114.76 114.76,114.03 115.75,113.76 116.74,114.03 117.47,114.76 117.73,115.75 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="124.35,115.75 124.08,116.74 123.35,117.47 122.36,117.73 121.37,117.47 120.64,116.74 120.38,115.75 120.64,114.76 121.37,114.03 122.36,113.76 123.35,114.03 124.08,114.76 124.35,115.75 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="137.57,115.75 137.31,116.74 136.58,117.47 135.59,117.73 134.6,117.47 133.87,116.74 133.61,115.75 133.87,114.76 134.6,114.03 135.59,113.76 136.58,114.03 137.31,114.76 137.57,115.75 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="150.8,115.75 150.54,116.74 149.81,117.47 148.82,117.73 147.83,117.47 147.1,116.74 146.83,115.75 147.1,114.76 147.83,114.03 148.82,113.76 149.81,114.03 150.54,114.76 150.8,115.75 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="71.43,122.36 71.17,123.35 70.44,124.08 69.45,124.35 68.46,124.08 67.73,123.35 67.46,122.36 67.73,121.37 68.46,120.64 69.45,120.38 70.44,120.64 71.17,121.37 71.43,122.36 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="78.05,122.36 77.78,123.35 77.06,124.08 76.06,124.35 75.07,124.08 74.34,123.35 74.08,122.36 74.34,121.37 75.07,120.64 76.06,120.38 77.06,120.64 77.78,121.37 78.05,122.36 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="84.66,122.36 84.4,123.35 83.67,124.08 82.68,124.35 81.69,124.08 80.96,123.35 80.69,122.36 80.96,121.37 81.69,120.64 82.68,120.38 83.67,120.64 84.4,121.37 84.66,122.36 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="91.28,122.36 91.01,123.35 90.28,124.08 89.29,124.35 88.3,124.08 87.57,123.35 87.31,122.36 87.57,121.37 88.3,120.64 89.29,120.38 90.28,120.64 91.01,121.37 91.28,122.36 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="104.5,122.36 104.24,123.35 103.51,124.08 102.52,124.35 101.53,124.08 100.8,123.35 100.54,122.36 100.8,121.37 101.53,120.64 102.52,120.38 103.51,120.64 104.24,121.37 104.5,122.36 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="124.35,122.36 124.08,123.35 123.35,124.08 122.36,124.35 121.37,124.08 120.64,123.35 120.38,122.36 120.64,121.37 121.37,120.64 122.36,120.38 123.35,120.64 124.08,121.37 124.35,122.36 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="130.96,122.36 130.69,123.35 129.97,124.08 128.98,124.35 127.98,124.08 127.26,123.35 126.99,122.36 127.26,121.37 127.98,120.64 128.98,120.38 129.97,120.64 130.69,121.37 130.96,122.36 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="137.57,122.36 137.31,123.35 136.58,124.08 135.59,124.35 134.6,124.08 133.87,123.35 133.61,122.36 133.87,121.37 134.6,120.64 135.59,120.38 136.58,120.64 137.31,121.37 137.57,122.36 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="71.43,128.98 71.17,129.97 70.44,130.69 69.45,130.96 68.46,130.69 67.73,129.97 67.46,128.98 67.73,127.98 68.46,127.26 69.45,126.99 70.44,127.26 71.17,127.98 71.43,128.98 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="78.05,128.98 77.78,129.97 77.06,130.69 76.06,130.96 75.07,130.69 74.34,129.97 74.08,128.98 74.34,127.98 75.07,127.26 76.06,126.99 77.06,127.26 77.78,127.98 78.05,128.98 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="91.28,128.98 91.01,129.97 90.28,130.69 89.29,130.96 88.3,130.69 87.57,129.97 87.31,128.98 87.57,127.98 88.3,127.26 89.29,126.99 90.28,127.26 91.01,127.98 91.28,128.98 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="97.89,128.98 97.62,129.97 96.9,130.69 95.91,130.96 94.91,130.69 94.19,129.97 93.92,128.98 94.19,127.98 94.91,127.26 95.91,126.99 96.9,127.26 97.62,127.98 97.89,128.98 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="104.5,128.98 104.24,129.97 103.51,130.69 102.52,130.96 101.53,130.69 100.8,129.97 100.54,128.98 100.8,127.98 101.53,127.26 102.52,126.99 103.51,127.26 104.24,127.98 104.5,128.98 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="111.12,128.98 110.85,129.97 110.13,130.69 109.13,130.96 108.14,130.69 107.42,129.97 107.15,128.98 107.42,127.98 108.14,127.26 109.13,126.99 110.13,127.26 110.85,127.98 111.12,128.98 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="117.73,128.98 117.47,129.97 116.74,130.69 115.75,130.96 114.76,130.69 114.03,129.97 113.76,128.98 114.03,127.98 114.76,127.26 115.75,126.99 116.74,127.26 117.47,127.98 117.73,128.98 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="130.96,128.98 130.69,129.97 129.97,130.69 128.98,130.96 127.98,130.69 127.26,129.97 126.99,128.98 127.26,127.98 127.98,127.26 128.98,126.99 129.97,127.26 130.69,127.98 130.96,128.98 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="137.57,128.98 137.31,129.97 136.58,130.69 135.59,130.96 134.6,130.69 133.87,129.97 133.61,128.98 133.87,127.98 134.6,127.26 135.59,126.99 136.58,127.26 137.31,127.98 137.57,128.98 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="71.43,135.59 71.17,136.58 70.44,137.31 69.45,137.57 68.46,137.31 67.73,136.58 67.46,135.59 67.73,134.6 68.46,133.87 69.45,133.61 70.44,133.87 71.17,134.6 71.43,135.59 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="78.05,135.59 77.78,136.58 77.06,137.31 76.06,137.57 75.07,137.31 74.34,136.58 74.08,135.59 74.34,134.6 75.07,133.87 76.06,133.61 77.06,133.87 77.78,134.6 78.05,135.59 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="97.89,135.59 97.62,136.58 96.9,137.31 95.91,137.57 94.91,137.31 94.19,136.58 93.92,135.59 94.19,134.6 94.91,133.87 95.91,133.61 96.9,133.87 97.62,134.6 97.89,135.59 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="111.12,135.59 110.85,136.58 110.13,137.31 109.13,137.57 108.14,137.31 107.42,136.58 107.15,135.59 107.42,134.6 108.14,133.87 109.13,133.61 110.13,133.87 110.85,134.6 111.12,135.59 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="117.73,135.59 117.47,136.58 116.74,137.31 115.75,137.57 114.76,137.31 114.03,136.58 113.76,135.59 114.03,134.6 114.76,133.87 115.75,133.61 116.74,133.87 117.47,134.6 117.73,135.59 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="130.96,135.59 130.69,136.58 129.97,137.31 128.98,137.57 127.98,137.31 127.26,136.58 126.99,135.59 127.26,134.6 127.98,133.87 128.98,133.61 129.97,133.87 130.69,134.6 130.96,135.59 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="137.57,135.59 137.31,136.58 136.58,137.31 135.59,137.57 134.6,137.31 133.87,136.58 133.61,135.59 133.87,134.6 134.6,133.87 135.59,133.61 136.58,133.87 137.31,134.6 137.57,135.59 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="71.43,142.2 71.17,143.2 70.44,143.92 69.45,144.19 68.46,143.92 67.73,143.2 67.46,142.2 67.73,141.21 68.46,140.49 69.45,140.22 70.44,140.49 71.17,141.21 71.43,142.2 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="84.66,142.2 84.4,143.2 83.67,143.92 82.68,144.19 81.69,143.92 80.96,143.2 80.69,142.2 80.96,141.21 81.69,140.49 82.68,140.22 83.67,140.49 84.4,141.21 84.66,142.2 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="91.28,142.2 91.01,143.2 90.28,143.92 89.29,144.19 88.3,143.92 87.57,143.2 87.31,142.2 87.57,141.21 88.3,140.49 89.29,140.22 90.28,140.49 91.01,141.21 91.28,142.2 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="97.89,142.2 97.62,143.2 96.9,143.92 95.91,144.19 94.91,143.92 94.19,143.2 93.92,142.2 94.19,141.21 94.91,140.49 95.91,140.22 96.9,140.49 97.62,141.21 97.89,142.2 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="104.5,142.2 104.24,143.2 103.51,143.92 102.52,144.19 101.53,143.92 100.8,143.2 100.54,142.2 100.8,141.21 101.53,140.49 102.52,140.22 103.51,140.49 104.24,141.21 104.5,142.2 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="111.12,142.2 110.85,143.2 110.13,143.92 109.13,144.19 108.14,143.92 107.42,143.2 107.15,142.2 107.42,141.21 108.14,140.49 109.13,140.22 110.13,140.49 110.85,141.21 111.12,142.2 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="117.73,142.2 117.47,143.2 116.74,143.92 115.75,144.19 114.76,143.92 114.03,143.2 113.76,142.2 114.03,141.21 114.76,140.49 115.75,140.22 116.74,140.49 117.47,141.21 117.73,142.2 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="124.35,142.2 124.08,143.2 123.35,143.92 122.36,144.19 121.37,143.92 120.64,143.2 120.38,142.2 120.64,141.21 121.37,140.49 122.36,140.22 123.35,140.49 124.08,141.21 124.35,142.2 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="137.57,142.2 137.31,143.2 136.58,143.92 135.59,144.19 134.6,143.92 133.87,143.2 133.61,142.2 133.87,141.21 134.6,140.49 135.59,140.22 136.58,140.49 137.31,141.21 137.57,142.2 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="144.19,142.2 143.92,143.2 143.2,143.92 142.2,144.19 141.21,143.92 140.49,143.2 140.22,142.2 140.49,141.21 141.21,140.49 142.2,140.22 143.2,140.49 143.92,141.21 144.19,142.2 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="71.43,148.82 71.17,149.81 70.44,150.54 69.45,150.8 68.46,150.54 67.73,149.81 67.46,148.82 67.73,147.83 68.46,147.1 69.45,146.83 70.44,147.1 71.17,147.83 71.43,148.82 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="78.05,148.82 77.78,149.81 77.06,150.54 76.06,150.8 75.07,150.54 74.34,149.81 74.08,148.82 74.34,147.83 75.07,147.1 76.06,146.83 77.06,147.1 77.78,147.83 78.05,148.82 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="84.66,148.82 84.4,149.81 83.67,150.54 82.68,150.8 81.69,150.54 80.96,149.81 80.69,148.82 80.96,147.83 81.69,147.1 82.68,146.83 83.67,147.1 84.4,147.83 84.66,148.82 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="97.89,148.82 97.62,149.81 96.9,150.54 95.91,150.8 94.91,150.54 94.19,149.81 93.92,148.82 94.19,147.83 94.91,147.1 95.91,146.83 96.9,147.1 97.62,147.83 97.89,148.82 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="117.73,148.82 117.47,149.81 116.74,150.54 115.75,150.8 114.76,150.54 114.03,149.81 113.76,148.82 114.03,147.83 114.76,147.1 115.75,146.83 116.74,147.1 117.47,147.83 117.73,148.82 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
        <polygon
          points="137.57,148.82 137.31,149.81 136.58,150.54 135.59,150.8 134.6,150.54 133.87,149.81 133.61,148.82 133.87,147.83 134.6,147.1 135.59,146.83 136.58,147.1 137.31,147.83 137.57,148.82 "
          style="fill:url(#gradient656a9574a16d49d783c4af7996609d4f);"
        />
      `,
            },
            {
                value: 7,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(37,86,99,1);"
            shape-rendering="crispEdges"
          />
          <linearGradient
            id="gradienta8c6daa64ea24dda9c31f0ef25b23fe5"
            gradientUnits="userSpaceOnUse"
            x1="8.73357798631972"
            y1="77.5065212907663"
            x2="156.620742539803"
            y2="87.8477992353567"
          >
            <stop offset="0%" stop-color="#B2A1C7" />
            <stop offset="50%" stop-color="#FDEADA" />
            <stop offset="100%" stop-color="#B2A1C7" />
          </linearGradient>
          <polygon
            points="13.23,13.23 59.53,13.23 59.53,59.53 13.23,59.53 13.23,19.78 19.84,19.78 19.84,52.91 52.91,52.91 52.91,19.84 13.23,19.84 "
            style="fill:url(#gradienta8c6daa64ea24dda9c31f0ef25b23fe5);"
          />
          <polygon
            points="13.23,105.83 59.53,105.83 59.53,152.13 13.23,152.13 13.23,112.37 19.84,112.37 19.84,145.51 52.91,145.51 52.91,112.44 13.23,112.44 "
            style="fill:url(#gradienta8c6daa64ea24dda9c31f0ef25b23fe5);"
          />
          <polygon
            points="105.83,13.23 152.13,13.23 152.13,59.53 105.83,59.53 105.83,19.78 112.44,19.78 112.44,52.91 145.51,52.91 145.51,19.84 105.83,19.84 "
            style="fill:url(#gradienta8c6daa64ea24dda9c31f0ef25b23fe5);"
          />
          <linearGradient
            id="gradientd6ceeefdc3cb4485b1f267ba2bd1ca96"
            gradientUnits="userSpaceOnUse"
            x1="22.8180702621143"
            y1="78.4914031594818"
            x2="142.536246449311"
            y2="86.862913551944"
          >
            <stop offset="0%" stop-color="#F2F2F2" />
            <stop offset="100%" stop-color="#FF9393" />
          </linearGradient>
          <polygon
            points="26.46,26.46 46.3,26.46 46.3,46.3 26.46,46.3 "
            style="fill:url(#gradientd6ceeefdc3cb4485b1f267ba2bd1ca96);"
          />
          <polygon
            points="26.46,119.06 46.3,119.06 46.3,138.9 26.46,138.9 "
            style="fill:url(#gradientd6ceeefdc3cb4485b1f267ba2bd1ca96);"
          />
          <polygon
            points="119.06,26.46 138.9,26.46 138.9,46.3 119.06,46.3 "
            style="fill:url(#gradientd6ceeefdc3cb4485b1f267ba2bd1ca96);"
          />
          <pattern
            id="hatcha1e4da6171284e5aac40bec16ac41092"
            x="0"
            y="0"
            width="8"
            height="8"
            patternUnits="userSpaceOnUse"
          >
            <rect x="0" y="0" width="8" height="8" fill="#E5B9B7" />
            <rect x="0" y="0" width="1" height="1" fill="#DBEEF3" />
            <rect x="1" y="0" width="1" height="1" fill="#DBEEF3" />
            <rect x="2" y="0" width="1" height="1" fill="#DBEEF3" />
            <rect x="3" y="0" width="1" height="1" fill="#DBEEF3" />
            <rect x="4" y="4" width="1" height="1" fill="#DBEEF3" />
            <rect x="5" y="4" width="1" height="1" fill="#DBEEF3" />
            <rect x="6" y="4" width="1" height="1" fill="#DBEEF3" />
            <rect x="7" y="4" width="1" height="1" fill="#DBEEF3" />
          </pattern>
          <polygon
            points="79.37,13.23 86.05,13.23 85.98,19.91 79.37,19.91 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="85.92,13.23 92.66,13.23 92.53,19.84 85.92,19.84 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="92.53,13.23 99.21,13.23 99.15,19.91 92.53,19.91 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="66.14,19.84 72.82,19.84 72.76,26.46 66.14,26.46 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="72.69,19.84 79.44,19.84 79.3,26.46 72.69,26.46 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="79.3,19.78 85.98,19.78 85.92,26.52 79.3,26.52 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="92.6,19.78 99.21,19.78 99.21,26.52 92.6,26.52 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="79.37,26.39 86.05,26.39 85.98,33.07 79.37,33.07 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="85.92,26.46 92.66,26.46 92.53,33.07 85.92,33.07 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="92.53,26.39 99.21,26.39 99.15,33.14 92.53,33.14 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="66.14,33.07 72.82,33.07 72.76,39.69 66.14,39.69 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="72.69,33.07 79.37,33.07 79.3,39.75 72.69,39.75 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="92.6,33 99.21,33 99.21,39.75 92.6,39.75 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="72.76,39.62 79.37,39.62 79.37,46.3 72.76,46.3 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="92.6,39.62 99.21,39.62 99.21,46.3 92.6,46.3 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="66.14,46.3 72.76,46.3 72.76,52.98 66.14,52.98 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="85.98,46.3 92.6,46.3 92.6,52.91 85.98,52.91 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="66.14,52.85 72.76,52.85 72.76,59.53 66.14,59.53 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="79.37,52.91 85.98,52.91 85.98,59.53 79.37,59.53 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="92.6,52.91 99.21,52.91 99.21,59.53 92.6,59.53 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="72.76,59.53 79.37,59.53 79.37,66.14 72.76,66.14 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="13.23,66.14 19.91,66.14 19.84,72.82 13.23,72.82 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="19.78,66.14 26.52,66.14 26.39,72.82 19.78,72.82 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="26.39,66.14 33.14,66.14 33,72.82 26.39,72.82 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="33,66.14 39.75,66.14 39.62,72.76 33,72.76 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="39.62,66.14 46.3,66.14 46.23,72.76 39.62,72.76 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="52.91,66.14 59.59,66.14 59.53,72.76 52.91,72.76 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="59.46,66.14 66.21,66.14 66.08,72.82 59.46,72.82 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="66.08,66.14 72.76,66.14 72.69,72.76 66.08,72.76 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="85.98,66.14 92.6,66.14 92.6,72.82 85.98,72.82 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="99.21,66.14 105.83,66.14 105.83,72.82 99.21,72.82 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="112.44,66.14 119.06,66.14 119.06,72.76 112.44,72.76 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="125.67,66.14 132.28,66.14 132.28,72.82 125.67,72.82 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="138.9,66.14 145.51,66.14 145.51,72.82 138.9,72.82 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="13.23,72.69 19.91,72.69 19.84,79.37 13.23,79.37 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="19.78,72.69 26.52,72.69 26.39,79.37 19.78,79.37 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="26.39,72.69 33.07,72.69 33,79.44 26.39,79.44 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="46.3,72.76 52.91,72.76 52.91,79.44 46.3,79.44 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="59.53,72.69 66.14,72.69 66.14,79.37 59.53,79.37 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="72.76,72.76 79.37,72.76 79.37,79.44 72.76,79.44 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="85.98,72.69 92.66,72.69 92.6,79.37 85.98,79.37 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="92.53,72.76 99.28,72.76 99.15,79.44 92.53,79.44 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="99.15,72.69 105.89,72.69 105.76,79.37 99.15,79.37 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="105.76,72.76 112.44,72.76 112.37,79.44 105.76,79.44 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="125.67,72.69 132.35,72.69 132.28,79.44 125.67,79.44 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="132.22,72.76 138.96,72.76 138.83,79.37 132.22,79.37 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="138.83,72.69 145.58,72.69 145.45,79.37 138.83,79.37 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="145.45,72.76 152.13,72.76 152.06,79.44 145.45,79.44 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="26.46,79.3 33.07,79.3 33.07,85.98 26.46,85.98 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="39.69,79.37 46.37,79.37 46.3,85.98 39.69,85.98 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="46.23,79.3 52.98,79.3 52.85,85.98 46.23,85.98 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="52.85,79.37 59.53,79.37 59.46,85.98 52.85,85.98 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="66.14,79.37 72.82,79.37 72.76,85.98 66.14,85.98 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="72.69,79.3 79.37,79.3 79.3,85.98 72.69,85.98 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="92.6,79.3 99.21,79.3 99.21,86.05 92.6,86.05 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="105.83,79.3 112.51,79.3 112.44,86.05 105.83,86.05 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="112.37,79.37 119.06,79.37 118.99,85.98 112.37,85.98 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="125.67,79.3 132.28,79.3 132.28,85.98 125.67,85.98 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="145.51,79.3 152.13,79.3 152.13,86.05 145.51,86.05 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="13.23,85.98 19.84,85.98 19.84,92.6 13.23,92.6 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="33.07,85.98 39.69,85.98 39.69,92.66 33.07,92.66 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="85.98,85.98 92.66,85.98 92.6,92.6 85.98,92.6 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="92.53,85.92 99.28,85.92 99.15,92.66 92.53,92.66 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="99.15,85.98 105.89,85.98 105.76,92.6 99.15,92.6 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="105.76,85.92 112.44,85.92 112.37,92.6 105.76,92.6 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="132.28,85.98 138.96,85.98 138.9,92.6 132.28,92.6 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="138.83,85.98 145.58,85.98 145.45,92.66 138.83,92.66 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="145.45,85.92 152.13,85.92 152.06,92.6 145.45,92.6 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="19.84,92.6 26.46,92.6 26.46,99.21 19.84,99.21 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="33.07,92.53 39.75,92.53 39.69,99.21 33.07,99.21 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="39.62,92.6 46.3,92.6 46.23,99.21 39.62,99.21 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="52.91,92.6 59.53,92.6 59.53,99.21 52.91,99.21 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="66.14,92.6 72.82,92.6 72.76,99.28 66.14,99.28 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="72.69,92.6 79.37,92.6 79.3,99.21 72.69,99.21 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="92.6,92.53 99.21,92.53 99.21,99.28 92.6,99.28 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="112.44,92.6 119.06,92.6 119.06,99.28 112.44,99.28 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="138.9,92.53 145.51,92.53 145.51,99.21 138.9,99.21 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="66.14,99.15 72.76,99.15 72.76,105.89 66.14,105.89 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="79.37,99.21 85.98,99.21 85.98,105.83 79.37,105.83 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="92.6,99.15 99.21,99.15 99.21,105.83 92.6,105.83 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="112.44,99.15 119.06,99.15 119.06,105.83 112.44,105.83 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="132.28,99.21 138.9,99.21 138.9,105.83 132.28,105.83 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="66.14,105.76 72.76,105.76 72.76,112.44 66.14,112.44 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="85.98,105.83 92.6,105.83 92.6,112.44 85.98,112.44 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="99.21,105.83 105.83,105.83 105.83,112.44 99.21,112.44 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="119.06,105.83 125.74,105.83 125.67,112.51 119.06,112.51 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="125.6,105.83 132.28,105.83 132.22,112.44 125.6,112.44 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="138.9,105.83 145.58,105.83 145.51,112.44 138.9,112.44 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="145.45,105.83 152.13,105.83 152.06,112.51 145.45,112.51 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="72.76,112.44 79.44,112.44 79.37,119.12 72.76,119.12 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="79.3,112.44 85.98,112.44 85.92,119.12 79.3,119.12 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="112.44,112.44 119.12,112.44 119.06,119.06 112.44,119.06 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="118.99,112.37 125.67,112.37 125.6,119.12 118.99,119.12 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="132.28,112.44 138.9,112.44 138.9,119.12 132.28,119.12 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="145.51,112.37 152.13,112.37 152.13,119.06 145.51,119.06 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="66.14,119.06 72.82,119.06 72.76,125.74 66.14,125.74 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="72.69,118.99 79.44,118.99 79.3,125.74 72.69,125.74 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="79.3,118.99 86.05,118.99 85.92,125.67 79.3,125.67 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="85.92,119.06 92.6,119.06 92.53,125.74 85.92,125.74 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="99.21,119.06 105.83,119.06 105.83,125.74 99.21,125.74 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="119.06,118.99 125.74,118.99 125.67,125.67 119.06,125.67 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="125.6,119.06 132.35,119.06 132.22,125.74 125.6,125.74 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="132.22,118.99 138.9,118.99 138.83,125.74 132.22,125.74 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="66.14,125.6 72.82,125.6 72.76,132.35 66.14,132.35 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="72.69,125.6 79.37,125.6 79.3,132.35 72.69,132.35 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="85.98,125.6 92.66,125.6 92.6,132.28 85.98,132.28 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="92.53,125.67 99.28,125.67 99.15,132.35 92.53,132.35 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="99.15,125.6 105.89,125.6 105.76,132.28 99.15,132.28 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="105.76,125.67 112.51,125.67 112.37,132.35 105.76,132.35 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="112.37,125.67 119.06,125.67 118.99,132.35 112.37,132.35 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="125.67,125.6 132.35,125.6 132.28,132.35 125.67,132.35 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="132.22,125.6 138.9,125.6 138.83,132.35 132.22,132.35 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="66.14,132.22 72.82,132.22 72.76,138.96 66.14,138.96 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="72.69,132.22 79.37,132.22 79.3,138.9 72.69,138.9 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="92.6,132.22 99.21,132.22 99.21,138.96 92.6,138.96 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="105.83,132.22 112.51,132.22 112.44,138.96 105.83,138.96 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="112.37,132.22 119.06,132.22 118.99,138.96 112.37,138.96 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="125.67,132.22 132.35,132.22 132.28,138.9 125.67,138.9 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="132.22,132.22 138.9,132.22 138.83,138.96 132.22,138.96 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="66.14,138.83 72.76,138.83 72.76,145.58 66.14,145.58 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="79.37,138.9 86.05,138.9 85.98,145.58 79.37,145.58 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="85.92,138.9 92.66,138.9 92.53,145.51 85.92,145.51 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="92.53,138.83 99.28,138.83 99.15,145.58 92.53,145.58 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="99.15,138.9 105.89,138.9 105.76,145.51 99.15,145.51 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="105.76,138.83 112.51,138.83 112.37,145.51 105.76,145.51 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="112.37,138.83 119.12,138.83 118.99,145.58 112.37,145.58 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="118.99,138.9 125.67,138.9 125.6,145.51 118.99,145.51 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="132.28,138.83 138.96,138.83 138.9,145.58 132.28,145.58 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="138.83,138.9 145.51,138.9 145.45,145.51 138.83,145.51 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="66.14,145.45 72.82,145.45 72.76,152.13 66.14,152.13 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="72.69,145.51 79.44,145.51 79.3,152.13 72.69,152.13 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="79.3,145.45 85.98,145.45 85.92,152.13 79.3,152.13 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="92.6,145.45 99.21,145.45 99.21,152.13 92.6,152.13 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="112.44,145.45 119.06,145.45 119.06,152.13 112.44,152.13 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
          <polygon
            points="132.28,145.45 138.9,145.45 138.9,152.13 132.28,152.13 "
            style="fill:url(#hatcha1e4da6171284e5aac40bec16ac41092);"
          />
      `,
            },
            {
                value: 8,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(87,118,157,1);"
            shape-rendering="crispEdges"
          />
          <linearGradient
            id="gradient8de752c176384710a7bf6eb6127ff1b9"
            gradientUnits="userSpaceOnUse"
            x1="7.72605761144101"
            y1="76.1197884622769"
            x2="157.628262914682"
            y2="89.2345320638461"
          >
            <stop offset="0%" stop-color="#DBEEF3" />
            <stop offset="100%" stop-color="#CBB8A8" />
          </linearGradient>
          <polygon
            points="13.23,13.23 59.53,13.23 59.53,59.53 13.23,59.53 13.23,19.78 19.84,19.78 19.84,52.91 52.91,52.91 52.91,19.84 13.23,19.84 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="13.23,105.83 59.53,105.83 59.53,152.13 13.23,152.13 13.23,112.37 19.84,112.37 19.84,145.51 52.91,145.51 52.91,112.44 13.23,112.44 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="105.83,13.23 152.13,13.23 152.13,59.53 105.83,59.53 105.83,19.78 112.44,19.78 112.44,52.91 145.51,52.91 145.51,19.84 105.83,19.84 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="26.46,26.46 46.3,26.46 46.3,46.3 26.46,46.3 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="26.46,119.06 46.3,119.06 46.3,138.9 26.46,138.9 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="119.06,26.46 138.9,26.46 138.9,46.3 119.06,46.3 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="84.66,16.54 84.4,17.53 83.67,18.25 82.68,18.52 81.69,18.25 80.96,17.53 80.69,16.54 80.96,15.54 81.69,14.82 82.68,14.55 83.67,14.82 84.4,15.54 84.66,16.54 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="91.28,16.54 91.01,17.53 90.28,18.25 89.29,18.52 88.3,18.25 87.57,17.53 87.31,16.54 87.57,15.54 88.3,14.82 89.29,14.55 90.28,14.82 91.01,15.54 91.28,16.54 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="97.89,16.54 97.62,17.53 96.9,18.25 95.91,18.52 94.91,18.25 94.19,17.53 93.92,16.54 94.19,15.54 94.91,14.82 95.91,14.55 96.9,14.82 97.62,15.54 97.89,16.54 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="71.43,23.15 71.17,24.14 70.44,24.87 69.45,25.13 68.46,24.87 67.73,24.14 67.46,23.15 67.73,22.16 68.46,21.43 69.45,21.17 70.44,21.43 71.17,22.16 71.43,23.15 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="78.05,23.15 77.78,24.14 77.06,24.87 76.06,25.13 75.07,24.87 74.34,24.14 74.08,23.15 74.34,22.16 75.07,21.43 76.06,21.17 77.06,21.43 77.78,22.16 78.05,23.15 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="84.66,23.15 84.4,24.14 83.67,24.87 82.68,25.13 81.69,24.87 80.96,24.14 80.69,23.15 80.96,22.16 81.69,21.43 82.68,21.17 83.67,21.43 84.4,22.16 84.66,23.15 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="97.89,23.15 97.62,24.14 96.9,24.87 95.91,25.13 94.91,24.87 94.19,24.14 93.92,23.15 94.19,22.16 94.91,21.43 95.91,21.17 96.9,21.43 97.62,22.16 97.89,23.15 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="84.66,29.76 84.4,30.76 83.67,31.48 82.68,31.75 81.69,31.48 80.96,30.76 80.69,29.76 80.96,28.77 81.69,28.05 82.68,27.78 83.67,28.05 84.4,28.77 84.66,29.76 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="91.28,29.76 91.01,30.76 90.28,31.48 89.29,31.75 88.3,31.48 87.57,30.76 87.31,29.76 87.57,28.77 88.3,28.05 89.29,27.78 90.28,28.05 91.01,28.77 91.28,29.76 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="97.89,29.76 97.62,30.76 96.9,31.48 95.91,31.75 94.91,31.48 94.19,30.76 93.92,29.76 94.19,28.77 94.91,28.05 95.91,27.78 96.9,28.05 97.62,28.77 97.89,29.76 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="71.43,36.38 71.17,37.37 70.44,38.1 69.45,38.36 68.46,38.1 67.73,37.37 67.46,36.38 67.73,35.39 68.46,34.66 69.45,34.39 70.44,34.66 71.17,35.39 71.43,36.38 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="78.05,36.38 77.78,37.37 77.06,38.1 76.06,38.36 75.07,38.1 74.34,37.37 74.08,36.38 74.34,35.39 75.07,34.66 76.06,34.39 77.06,34.66 77.78,35.39 78.05,36.38 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="97.89,36.38 97.62,37.37 96.9,38.1 95.91,38.36 94.91,38.1 94.19,37.37 93.92,36.38 94.19,35.39 94.91,34.66 95.91,34.39 96.9,34.66 97.62,35.39 97.89,36.38 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="78.05,42.99 77.78,43.98 77.06,44.71 76.06,44.98 75.07,44.71 74.34,43.98 74.08,42.99 74.34,42 75.07,41.27 76.06,41.01 77.06,41.27 77.78,42 78.05,42.99 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="97.89,42.99 97.62,43.98 96.9,44.71 95.91,44.98 94.91,44.71 94.19,43.98 93.92,42.99 94.19,42 94.91,41.27 95.91,41.01 96.9,41.27 97.62,42 97.89,42.99 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="71.43,49.61 71.17,50.6 70.44,51.32 69.45,51.59 68.46,51.32 67.73,50.6 67.46,49.61 67.73,48.61 68.46,47.89 69.45,47.62 70.44,47.89 71.17,48.61 71.43,49.61 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="91.28,49.61 91.01,50.6 90.28,51.32 89.29,51.59 88.3,51.32 87.57,50.6 87.31,49.61 87.57,48.61 88.3,47.89 89.29,47.62 90.28,47.89 91.01,48.61 91.28,49.61 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="71.43,56.22 71.17,57.21 70.44,57.94 69.45,58.2 68.46,57.94 67.73,57.21 67.46,56.22 67.73,55.23 68.46,54.5 69.45,54.24 70.44,54.5 71.17,55.23 71.43,56.22 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="84.66,56.22 84.4,57.21 83.67,57.94 82.68,58.2 81.69,57.94 80.96,57.21 80.69,56.22 80.96,55.23 81.69,54.5 82.68,54.24 83.67,54.5 84.4,55.23 84.66,56.22 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="97.89,56.22 97.62,57.21 96.9,57.94 95.91,58.2 94.91,57.94 94.19,57.21 93.92,56.22 94.19,55.23 94.91,54.5 95.91,54.24 96.9,54.5 97.62,55.23 97.89,56.22 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="78.05,62.83 77.78,63.83 77.06,64.55 76.06,64.82 75.07,64.55 74.34,63.83 74.08,62.83 74.34,61.84 75.07,61.12 76.06,60.85 77.06,61.12 77.78,61.84 78.05,62.83 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="18.52,69.45 18.25,70.44 17.53,71.17 16.54,71.43 15.54,71.17 14.82,70.44 14.55,69.45 14.82,68.46 15.54,67.73 16.54,67.46 17.53,67.73 18.25,68.46 18.52,69.45 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="25.13,69.45 24.87,70.44 24.14,71.17 23.15,71.43 22.16,71.17 21.43,70.44 21.17,69.45 21.43,68.46 22.16,67.73 23.15,67.46 24.14,67.73 24.87,68.46 25.13,69.45 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="31.75,69.45 31.48,70.44 30.76,71.17 29.76,71.43 28.77,71.17 28.05,70.44 27.78,69.45 28.05,68.46 28.77,67.73 29.76,67.46 30.76,67.73 31.48,68.46 31.75,69.45 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="38.36,69.45 38.1,70.44 37.37,71.17 36.38,71.43 35.39,71.17 34.66,70.44 34.39,69.45 34.66,68.46 35.39,67.73 36.38,67.46 37.37,67.73 38.1,68.46 38.36,69.45 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="44.98,69.45 44.71,70.44 43.98,71.17 42.99,71.43 42,71.17 41.27,70.44 41.01,69.45 41.27,68.46 42,67.73 42.99,67.46 43.98,67.73 44.71,68.46 44.98,69.45 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="58.2,69.45 57.94,70.44 57.21,71.17 56.22,71.43 55.23,71.17 54.5,70.44 54.24,69.45 54.5,68.46 55.23,67.73 56.22,67.46 57.21,67.73 57.94,68.46 58.2,69.45 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="64.82,69.45 64.55,70.44 63.83,71.17 62.83,71.43 61.84,71.17 61.12,70.44 60.85,69.45 61.12,68.46 61.84,67.73 62.83,67.46 63.83,67.73 64.55,68.46 64.82,69.45 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="71.43,69.45 71.17,70.44 70.44,71.17 69.45,71.43 68.46,71.17 67.73,70.44 67.46,69.45 67.73,68.46 68.46,67.73 69.45,67.46 70.44,67.73 71.17,68.46 71.43,69.45 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="91.28,69.45 91.01,70.44 90.28,71.17 89.29,71.43 88.3,71.17 87.57,70.44 87.31,69.45 87.57,68.46 88.3,67.73 89.29,67.46 90.28,67.73 91.01,68.46 91.28,69.45 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="104.5,69.45 104.24,70.44 103.51,71.17 102.52,71.43 101.53,71.17 100.8,70.44 100.54,69.45 100.8,68.46 101.53,67.73 102.52,67.46 103.51,67.73 104.24,68.46 104.5,69.45 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="117.73,69.45 117.47,70.44 116.74,71.17 115.75,71.43 114.76,71.17 114.03,70.44 113.76,69.45 114.03,68.46 114.76,67.73 115.75,67.46 116.74,67.73 117.47,68.46 117.73,69.45 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="130.96,69.45 130.69,70.44 129.97,71.17 128.98,71.43 127.98,71.17 127.26,70.44 126.99,69.45 127.26,68.46 127.98,67.73 128.98,67.46 129.97,67.73 130.69,68.46 130.96,69.45 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="144.19,69.45 143.92,70.44 143.2,71.17 142.2,71.43 141.21,71.17 140.49,70.44 140.22,69.45 140.49,68.46 141.21,67.73 142.2,67.46 143.2,67.73 143.92,68.46 144.19,69.45 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="18.52,76.06 18.25,77.06 17.53,77.78 16.54,78.05 15.54,77.78 14.82,77.06 14.55,76.06 14.82,75.07 15.54,74.34 16.54,74.08 17.53,74.34 18.25,75.07 18.52,76.06 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="25.13,76.06 24.87,77.06 24.14,77.78 23.15,78.05 22.16,77.78 21.43,77.06 21.17,76.06 21.43,75.07 22.16,74.34 23.15,74.08 24.14,74.34 24.87,75.07 25.13,76.06 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="31.75,76.06 31.48,77.06 30.76,77.78 29.76,78.05 28.77,77.78 28.05,77.06 27.78,76.06 28.05,75.07 28.77,74.34 29.76,74.08 30.76,74.34 31.48,75.07 31.75,76.06 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="51.59,76.06 51.32,77.06 50.6,77.78 49.61,78.05 48.61,77.78 47.89,77.06 47.62,76.06 47.89,75.07 48.61,74.34 49.61,74.08 50.6,74.34 51.32,75.07 51.59,76.06 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="64.82,76.06 64.55,77.06 63.83,77.78 62.83,78.05 61.84,77.78 61.12,77.06 60.85,76.06 61.12,75.07 61.84,74.34 62.83,74.08 63.83,74.34 64.55,75.07 64.82,76.06 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="78.05,76.06 77.78,77.06 77.06,77.78 76.06,78.05 75.07,77.78 74.34,77.06 74.08,76.06 74.34,75.07 75.07,74.34 76.06,74.08 77.06,74.34 77.78,75.07 78.05,76.06 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="91.28,76.06 91.01,77.06 90.28,77.78 89.29,78.05 88.3,77.78 87.57,77.06 87.31,76.06 87.57,75.07 88.3,74.34 89.29,74.08 90.28,74.34 91.01,75.07 91.28,76.06 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="97.89,76.06 97.62,77.06 96.9,77.78 95.91,78.05 94.91,77.78 94.19,77.06 93.92,76.06 94.19,75.07 94.91,74.34 95.91,74.08 96.9,74.34 97.62,75.07 97.89,76.06 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="104.5,76.06 104.24,77.06 103.51,77.78 102.52,78.05 101.53,77.78 100.8,77.06 100.54,76.06 100.8,75.07 101.53,74.34 102.52,74.08 103.51,74.34 104.24,75.07 104.5,76.06 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="111.12,76.06 110.85,77.06 110.13,77.78 109.13,78.05 108.14,77.78 107.42,77.06 107.15,76.06 107.42,75.07 108.14,74.34 109.13,74.08 110.13,74.34 110.85,75.07 111.12,76.06 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="130.96,76.06 130.69,77.06 129.97,77.78 128.98,78.05 127.98,77.78 127.26,77.06 126.99,76.06 127.26,75.07 127.98,74.34 128.98,74.08 129.97,74.34 130.69,75.07 130.96,76.06 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="137.57,76.06 137.31,77.06 136.58,77.78 135.59,78.05 134.6,77.78 133.87,77.06 133.61,76.06 133.87,75.07 134.6,74.34 135.59,74.08 136.58,74.34 137.31,75.07 137.57,76.06 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="144.19,76.06 143.92,77.06 143.2,77.78 142.2,78.05 141.21,77.78 140.49,77.06 140.22,76.06 140.49,75.07 141.21,74.34 142.2,74.08 143.2,74.34 143.92,75.07 144.19,76.06 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="150.8,76.06 150.54,77.06 149.81,77.78 148.82,78.05 147.83,77.78 147.1,77.06 146.83,76.06 147.1,75.07 147.83,74.34 148.82,74.08 149.81,74.34 150.54,75.07 150.8,76.06 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="31.75,82.68 31.48,83.67 30.76,84.4 29.76,84.66 28.77,84.4 28.05,83.67 27.78,82.68 28.05,81.69 28.77,80.96 29.76,80.69 30.76,80.96 31.48,81.69 31.75,82.68 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="44.98,82.68 44.71,83.67 43.98,84.4 42.99,84.66 42,84.4 41.27,83.67 41.01,82.68 41.27,81.69 42,80.96 42.99,80.69 43.98,80.96 44.71,81.69 44.98,82.68 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="51.59,82.68 51.32,83.67 50.6,84.4 49.61,84.66 48.61,84.4 47.89,83.67 47.62,82.68 47.89,81.69 48.61,80.96 49.61,80.69 50.6,80.96 51.32,81.69 51.59,82.68 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="58.2,82.68 57.94,83.67 57.21,84.4 56.22,84.66 55.23,84.4 54.5,83.67 54.24,82.68 54.5,81.69 55.23,80.96 56.22,80.69 57.21,80.96 57.94,81.69 58.2,82.68 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="71.43,82.68 71.17,83.67 70.44,84.4 69.45,84.66 68.46,84.4 67.73,83.67 67.46,82.68 67.73,81.69 68.46,80.96 69.45,80.69 70.44,80.96 71.17,81.69 71.43,82.68 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="78.05,82.68 77.78,83.67 77.06,84.4 76.06,84.66 75.07,84.4 74.34,83.67 74.08,82.68 74.34,81.69 75.07,80.96 76.06,80.69 77.06,80.96 77.78,81.69 78.05,82.68 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="97.89,82.68 97.62,83.67 96.9,84.4 95.91,84.66 94.91,84.4 94.19,83.67 93.92,82.68 94.19,81.69 94.91,80.96 95.91,80.69 96.9,80.96 97.62,81.69 97.89,82.68 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="111.12,82.68 110.85,83.67 110.13,84.4 109.13,84.66 108.14,84.4 107.42,83.67 107.15,82.68 107.42,81.69 108.14,80.96 109.13,80.69 110.13,80.96 110.85,81.69 111.12,82.68 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="117.73,82.68 117.47,83.67 116.74,84.4 115.75,84.66 114.76,84.4 114.03,83.67 113.76,82.68 114.03,81.69 114.76,80.96 115.75,80.69 116.74,80.96 117.47,81.69 117.73,82.68 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="130.96,82.68 130.69,83.67 129.97,84.4 128.98,84.66 127.98,84.4 127.26,83.67 126.99,82.68 127.26,81.69 127.98,80.96 128.98,80.69 129.97,80.96 130.69,81.69 130.96,82.68 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="150.8,82.68 150.54,83.67 149.81,84.4 148.82,84.66 147.83,84.4 147.1,83.67 146.83,82.68 147.1,81.69 147.83,80.96 148.82,80.69 149.81,80.96 150.54,81.69 150.8,82.68 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="18.52,89.29 18.25,90.28 17.53,91.01 16.54,91.28 15.54,91.01 14.82,90.28 14.55,89.29 14.82,88.3 15.54,87.57 16.54,87.31 17.53,87.57 18.25,88.3 18.52,89.29 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="38.36,89.29 38.1,90.28 37.37,91.01 36.38,91.28 35.39,91.01 34.66,90.28 34.39,89.29 34.66,88.3 35.39,87.57 36.38,87.31 37.37,87.57 38.1,88.3 38.36,89.29 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="91.28,89.29 91.01,90.28 90.28,91.01 89.29,91.28 88.3,91.01 87.57,90.28 87.31,89.29 87.57,88.3 88.3,87.57 89.29,87.31 90.28,87.57 91.01,88.3 91.28,89.29 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="97.89,89.29 97.62,90.28 96.9,91.01 95.91,91.28 94.91,91.01 94.19,90.28 93.92,89.29 94.19,88.3 94.91,87.57 95.91,87.31 96.9,87.57 97.62,88.3 97.89,89.29 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="104.5,89.29 104.24,90.28 103.51,91.01 102.52,91.28 101.53,91.01 100.8,90.28 100.54,89.29 100.8,88.3 101.53,87.57 102.52,87.31 103.51,87.57 104.24,88.3 104.5,89.29 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="111.12,89.29 110.85,90.28 110.13,91.01 109.13,91.28 108.14,91.01 107.42,90.28 107.15,89.29 107.42,88.3 108.14,87.57 109.13,87.31 110.13,87.57 110.85,88.3 111.12,89.29 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="137.57,89.29 137.31,90.28 136.58,91.01 135.59,91.28 134.6,91.01 133.87,90.28 133.61,89.29 133.87,88.3 134.6,87.57 135.59,87.31 136.58,87.57 137.31,88.3 137.57,89.29 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="144.19,89.29 143.92,90.28 143.2,91.01 142.2,91.28 141.21,91.01 140.49,90.28 140.22,89.29 140.49,88.3 141.21,87.57 142.2,87.31 143.2,87.57 143.92,88.3 144.19,89.29 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="150.8,89.29 150.54,90.28 149.81,91.01 148.82,91.28 147.83,91.01 147.1,90.28 146.83,89.29 147.1,88.3 147.83,87.57 148.82,87.31 149.81,87.57 150.54,88.3 150.8,89.29 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="25.13,95.91 24.87,96.9 24.14,97.62 23.15,97.89 22.16,97.62 21.43,96.9 21.17,95.91 21.43,94.91 22.16,94.19 23.15,93.92 24.14,94.19 24.87,94.91 25.13,95.91 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="38.36,95.91 38.1,96.9 37.37,97.62 36.38,97.89 35.39,97.62 34.66,96.9 34.39,95.91 34.66,94.91 35.39,94.19 36.38,93.92 37.37,94.19 38.1,94.91 38.36,95.91 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="44.98,95.91 44.71,96.9 43.98,97.62 42.99,97.89 42,97.62 41.27,96.9 41.01,95.91 41.27,94.91 42,94.19 42.99,93.92 43.98,94.19 44.71,94.91 44.98,95.91 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="58.2,95.91 57.94,96.9 57.21,97.62 56.22,97.89 55.23,97.62 54.5,96.9 54.24,95.91 54.5,94.91 55.23,94.19 56.22,93.92 57.21,94.19 57.94,94.91 58.2,95.91 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="71.43,95.91 71.17,96.9 70.44,97.62 69.45,97.89 68.46,97.62 67.73,96.9 67.46,95.91 67.73,94.91 68.46,94.19 69.45,93.92 70.44,94.19 71.17,94.91 71.43,95.91 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="78.05,95.91 77.78,96.9 77.06,97.62 76.06,97.89 75.07,97.62 74.34,96.9 74.08,95.91 74.34,94.91 75.07,94.19 76.06,93.92 77.06,94.19 77.78,94.91 78.05,95.91 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="97.89,95.91 97.62,96.9 96.9,97.62 95.91,97.89 94.91,97.62 94.19,96.9 93.92,95.91 94.19,94.91 94.91,94.19 95.91,93.92 96.9,94.19 97.62,94.91 97.89,95.91 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="117.73,95.91 117.47,96.9 116.74,97.62 115.75,97.89 114.76,97.62 114.03,96.9 113.76,95.91 114.03,94.91 114.76,94.19 115.75,93.92 116.74,94.19 117.47,94.91 117.73,95.91 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="144.19,95.91 143.92,96.9 143.2,97.62 142.2,97.89 141.21,97.62 140.49,96.9 140.22,95.91 140.49,94.91 141.21,94.19 142.2,93.92 143.2,94.19 143.92,94.91 144.19,95.91 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="71.43,102.52 71.17,103.51 70.44,104.24 69.45,104.5 68.46,104.24 67.73,103.51 67.46,102.52 67.73,101.53 68.46,100.8 69.45,100.54 70.44,100.8 71.17,101.53 71.43,102.52 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="84.66,102.52 84.4,103.51 83.67,104.24 82.68,104.5 81.69,104.24 80.96,103.51 80.69,102.52 80.96,101.53 81.69,100.8 82.68,100.54 83.67,100.8 84.4,101.53 84.66,102.52 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="97.89,102.52 97.62,103.51 96.9,104.24 95.91,104.5 94.91,104.24 94.19,103.51 93.92,102.52 94.19,101.53 94.91,100.8 95.91,100.54 96.9,100.8 97.62,101.53 97.89,102.52 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="117.73,102.52 117.47,103.51 116.74,104.24 115.75,104.5 114.76,104.24 114.03,103.51 113.76,102.52 114.03,101.53 114.76,100.8 115.75,100.54 116.74,100.8 117.47,101.53 117.73,102.52 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="137.57,102.52 137.31,103.51 136.58,104.24 135.59,104.5 134.6,104.24 133.87,103.51 133.61,102.52 133.87,101.53 134.6,100.8 135.59,100.54 136.58,100.8 137.31,101.53 137.57,102.52 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="71.43,109.13 71.17,110.13 70.44,110.85 69.45,111.12 68.46,110.85 67.73,110.13 67.46,109.13 67.73,108.14 68.46,107.42 69.45,107.15 70.44,107.42 71.17,108.14 71.43,109.13 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="91.28,109.13 91.01,110.13 90.28,110.85 89.29,111.12 88.3,110.85 87.57,110.13 87.31,109.13 87.57,108.14 88.3,107.42 89.29,107.15 90.28,107.42 91.01,108.14 91.28,109.13 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="104.5,109.13 104.24,110.13 103.51,110.85 102.52,111.12 101.53,110.85 100.8,110.13 100.54,109.13 100.8,108.14 101.53,107.42 102.52,107.15 103.51,107.42 104.24,108.14 104.5,109.13 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="124.35,109.13 124.08,110.13 123.35,110.85 122.36,111.12 121.37,110.85 120.64,110.13 120.38,109.13 120.64,108.14 121.37,107.42 122.36,107.15 123.35,107.42 124.08,108.14 124.35,109.13 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="130.96,109.13 130.69,110.13 129.97,110.85 128.98,111.12 127.98,110.85 127.26,110.13 126.99,109.13 127.26,108.14 127.98,107.42 128.98,107.15 129.97,107.42 130.69,108.14 130.96,109.13 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="144.19,109.13 143.92,110.13 143.2,110.85 142.2,111.12 141.21,110.85 140.49,110.13 140.22,109.13 140.49,108.14 141.21,107.42 142.2,107.15 143.2,107.42 143.92,108.14 144.19,109.13 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="150.8,109.13 150.54,110.13 149.81,110.85 148.82,111.12 147.83,110.85 147.1,110.13 146.83,109.13 147.1,108.14 147.83,107.42 148.82,107.15 149.81,107.42 150.54,108.14 150.8,109.13 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="78.05,115.75 77.78,116.74 77.06,117.47 76.06,117.73 75.07,117.47 74.34,116.74 74.08,115.75 74.34,114.76 75.07,114.03 76.06,113.76 77.06,114.03 77.78,114.76 78.05,115.75 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="84.66,115.75 84.4,116.74 83.67,117.47 82.68,117.73 81.69,117.47 80.96,116.74 80.69,115.75 80.96,114.76 81.69,114.03 82.68,113.76 83.67,114.03 84.4,114.76 84.66,115.75 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="117.73,115.75 117.47,116.74 116.74,117.47 115.75,117.73 114.76,117.47 114.03,116.74 113.76,115.75 114.03,114.76 114.76,114.03 115.75,113.76 116.74,114.03 117.47,114.76 117.73,115.75 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="124.35,115.75 124.08,116.74 123.35,117.47 122.36,117.73 121.37,117.47 120.64,116.74 120.38,115.75 120.64,114.76 121.37,114.03 122.36,113.76 123.35,114.03 124.08,114.76 124.35,115.75 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="137.57,115.75 137.31,116.74 136.58,117.47 135.59,117.73 134.6,117.47 133.87,116.74 133.61,115.75 133.87,114.76 134.6,114.03 135.59,113.76 136.58,114.03 137.31,114.76 137.57,115.75 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="150.8,115.75 150.54,116.74 149.81,117.47 148.82,117.73 147.83,117.47 147.1,116.74 146.83,115.75 147.1,114.76 147.83,114.03 148.82,113.76 149.81,114.03 150.54,114.76 150.8,115.75 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="71.43,122.36 71.17,123.35 70.44,124.08 69.45,124.35 68.46,124.08 67.73,123.35 67.46,122.36 67.73,121.37 68.46,120.64 69.45,120.38 70.44,120.64 71.17,121.37 71.43,122.36 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="78.05,122.36 77.78,123.35 77.06,124.08 76.06,124.35 75.07,124.08 74.34,123.35 74.08,122.36 74.34,121.37 75.07,120.64 76.06,120.38 77.06,120.64 77.78,121.37 78.05,122.36 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="84.66,122.36 84.4,123.35 83.67,124.08 82.68,124.35 81.69,124.08 80.96,123.35 80.69,122.36 80.96,121.37 81.69,120.64 82.68,120.38 83.67,120.64 84.4,121.37 84.66,122.36 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="91.28,122.36 91.01,123.35 90.28,124.08 89.29,124.35 88.3,124.08 87.57,123.35 87.31,122.36 87.57,121.37 88.3,120.64 89.29,120.38 90.28,120.64 91.01,121.37 91.28,122.36 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="104.5,122.36 104.24,123.35 103.51,124.08 102.52,124.35 101.53,124.08 100.8,123.35 100.54,122.36 100.8,121.37 101.53,120.64 102.52,120.38 103.51,120.64 104.24,121.37 104.5,122.36 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="124.35,122.36 124.08,123.35 123.35,124.08 122.36,124.35 121.37,124.08 120.64,123.35 120.38,122.36 120.64,121.37 121.37,120.64 122.36,120.38 123.35,120.64 124.08,121.37 124.35,122.36 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="130.96,122.36 130.69,123.35 129.97,124.08 128.98,124.35 127.98,124.08 127.26,123.35 126.99,122.36 127.26,121.37 127.98,120.64 128.98,120.38 129.97,120.64 130.69,121.37 130.96,122.36 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="137.57,122.36 137.31,123.35 136.58,124.08 135.59,124.35 134.6,124.08 133.87,123.35 133.61,122.36 133.87,121.37 134.6,120.64 135.59,120.38 136.58,120.64 137.31,121.37 137.57,122.36 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="71.43,128.98 71.17,129.97 70.44,130.69 69.45,130.96 68.46,130.69 67.73,129.97 67.46,128.98 67.73,127.98 68.46,127.26 69.45,126.99 70.44,127.26 71.17,127.98 71.43,128.98 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="78.05,128.98 77.78,129.97 77.06,130.69 76.06,130.96 75.07,130.69 74.34,129.97 74.08,128.98 74.34,127.98 75.07,127.26 76.06,126.99 77.06,127.26 77.78,127.98 78.05,128.98 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="91.28,128.98 91.01,129.97 90.28,130.69 89.29,130.96 88.3,130.69 87.57,129.97 87.31,128.98 87.57,127.98 88.3,127.26 89.29,126.99 90.28,127.26 91.01,127.98 91.28,128.98 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="97.89,128.98 97.62,129.97 96.9,130.69 95.91,130.96 94.91,130.69 94.19,129.97 93.92,128.98 94.19,127.98 94.91,127.26 95.91,126.99 96.9,127.26 97.62,127.98 97.89,128.98 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="104.5,128.98 104.24,129.97 103.51,130.69 102.52,130.96 101.53,130.69 100.8,129.97 100.54,128.98 100.8,127.98 101.53,127.26 102.52,126.99 103.51,127.26 104.24,127.98 104.5,128.98 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="111.12,128.98 110.85,129.97 110.13,130.69 109.13,130.96 108.14,130.69 107.42,129.97 107.15,128.98 107.42,127.98 108.14,127.26 109.13,126.99 110.13,127.26 110.85,127.98 111.12,128.98 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="117.73,128.98 117.47,129.97 116.74,130.69 115.75,130.96 114.76,130.69 114.03,129.97 113.76,128.98 114.03,127.98 114.76,127.26 115.75,126.99 116.74,127.26 117.47,127.98 117.73,128.98 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="130.96,128.98 130.69,129.97 129.97,130.69 128.98,130.96 127.98,130.69 127.26,129.97 126.99,128.98 127.26,127.98 127.98,127.26 128.98,126.99 129.97,127.26 130.69,127.98 130.96,128.98 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="137.57,128.98 137.31,129.97 136.58,130.69 135.59,130.96 134.6,130.69 133.87,129.97 133.61,128.98 133.87,127.98 134.6,127.26 135.59,126.99 136.58,127.26 137.31,127.98 137.57,128.98 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="71.43,135.59 71.17,136.58 70.44,137.31 69.45,137.57 68.46,137.31 67.73,136.58 67.46,135.59 67.73,134.6 68.46,133.87 69.45,133.61 70.44,133.87 71.17,134.6 71.43,135.59 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="78.05,135.59 77.78,136.58 77.06,137.31 76.06,137.57 75.07,137.31 74.34,136.58 74.08,135.59 74.34,134.6 75.07,133.87 76.06,133.61 77.06,133.87 77.78,134.6 78.05,135.59 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="97.89,135.59 97.62,136.58 96.9,137.31 95.91,137.57 94.91,137.31 94.19,136.58 93.92,135.59 94.19,134.6 94.91,133.87 95.91,133.61 96.9,133.87 97.62,134.6 97.89,135.59 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="111.12,135.59 110.85,136.58 110.13,137.31 109.13,137.57 108.14,137.31 107.42,136.58 107.15,135.59 107.42,134.6 108.14,133.87 109.13,133.61 110.13,133.87 110.85,134.6 111.12,135.59 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="117.73,135.59 117.47,136.58 116.74,137.31 115.75,137.57 114.76,137.31 114.03,136.58 113.76,135.59 114.03,134.6 114.76,133.87 115.75,133.61 116.74,133.87 117.47,134.6 117.73,135.59 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="130.96,135.59 130.69,136.58 129.97,137.31 128.98,137.57 127.98,137.31 127.26,136.58 126.99,135.59 127.26,134.6 127.98,133.87 128.98,133.61 129.97,133.87 130.69,134.6 130.96,135.59 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="137.57,135.59 137.31,136.58 136.58,137.31 135.59,137.57 134.6,137.31 133.87,136.58 133.61,135.59 133.87,134.6 134.6,133.87 135.59,133.61 136.58,133.87 137.31,134.6 137.57,135.59 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="71.43,142.2 71.17,143.2 70.44,143.92 69.45,144.19 68.46,143.92 67.73,143.2 67.46,142.2 67.73,141.21 68.46,140.49 69.45,140.22 70.44,140.49 71.17,141.21 71.43,142.2 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="84.66,142.2 84.4,143.2 83.67,143.92 82.68,144.19 81.69,143.92 80.96,143.2 80.69,142.2 80.96,141.21 81.69,140.49 82.68,140.22 83.67,140.49 84.4,141.21 84.66,142.2 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="91.28,142.2 91.01,143.2 90.28,143.92 89.29,144.19 88.3,143.92 87.57,143.2 87.31,142.2 87.57,141.21 88.3,140.49 89.29,140.22 90.28,140.49 91.01,141.21 91.28,142.2 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="97.89,142.2 97.62,143.2 96.9,143.92 95.91,144.19 94.91,143.92 94.19,143.2 93.92,142.2 94.19,141.21 94.91,140.49 95.91,140.22 96.9,140.49 97.62,141.21 97.89,142.2 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="104.5,142.2 104.24,143.2 103.51,143.92 102.52,144.19 101.53,143.92 100.8,143.2 100.54,142.2 100.8,141.21 101.53,140.49 102.52,140.22 103.51,140.49 104.24,141.21 104.5,142.2 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="111.12,142.2 110.85,143.2 110.13,143.92 109.13,144.19 108.14,143.92 107.42,143.2 107.15,142.2 107.42,141.21 108.14,140.49 109.13,140.22 110.13,140.49 110.85,141.21 111.12,142.2 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="117.73,142.2 117.47,143.2 116.74,143.92 115.75,144.19 114.76,143.92 114.03,143.2 113.76,142.2 114.03,141.21 114.76,140.49 115.75,140.22 116.74,140.49 117.47,141.21 117.73,142.2 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="124.35,142.2 124.08,143.2 123.35,143.92 122.36,144.19 121.37,143.92 120.64,143.2 120.38,142.2 120.64,141.21 121.37,140.49 122.36,140.22 123.35,140.49 124.08,141.21 124.35,142.2 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="137.57,142.2 137.31,143.2 136.58,143.92 135.59,144.19 134.6,143.92 133.87,143.2 133.61,142.2 133.87,141.21 134.6,140.49 135.59,140.22 136.58,140.49 137.31,141.21 137.57,142.2 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="144.19,142.2 143.92,143.2 143.2,143.92 142.2,144.19 141.21,143.92 140.49,143.2 140.22,142.2 140.49,141.21 141.21,140.49 142.2,140.22 143.2,140.49 143.92,141.21 144.19,142.2 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="71.43,148.82 71.17,149.81 70.44,150.54 69.45,150.8 68.46,150.54 67.73,149.81 67.46,148.82 67.73,147.83 68.46,147.1 69.45,146.83 70.44,147.1 71.17,147.83 71.43,148.82 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="78.05,148.82 77.78,149.81 77.06,150.54 76.06,150.8 75.07,150.54 74.34,149.81 74.08,148.82 74.34,147.83 75.07,147.1 76.06,146.83 77.06,147.1 77.78,147.83 78.05,148.82 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="84.66,148.82 84.4,149.81 83.67,150.54 82.68,150.8 81.69,150.54 80.96,149.81 80.69,148.82 80.96,147.83 81.69,147.1 82.68,146.83 83.67,147.1 84.4,147.83 84.66,148.82 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="97.89,148.82 97.62,149.81 96.9,150.54 95.91,150.8 94.91,150.54 94.19,149.81 93.92,148.82 94.19,147.83 94.91,147.1 95.91,146.83 96.9,147.1 97.62,147.83 97.89,148.82 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="117.73,148.82 117.47,149.81 116.74,150.54 115.75,150.8 114.76,150.54 114.03,149.81 113.76,148.82 114.03,147.83 114.76,147.1 115.75,146.83 116.74,147.1 117.47,147.83 117.73,148.82 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
          <polygon
            points="137.57,148.82 137.31,149.81 136.58,150.54 135.59,150.8 134.6,150.54 133.87,149.81 133.61,148.82 133.87,147.83 134.6,147.1 135.59,146.83 136.58,147.1 137.31,147.83 137.57,148.82 "
            style="fill:url(#gradient8de752c176384710a7bf6eb6127ff1b9);"
          />
      `,
            },
            {
                value: 9,
                innerHtml: `
      <rect
          x="0"
          y="0"
          width="165.3543"
          height="165.3543"
          fill="red"
          style="fill:rgba(144,60,57,1);"
          shape-rendering="crispEdges"
        />
        <linearGradient
          id="gradiente61bf7b05498450e94216666bad1de37"
          gradientUnits="userSpaceOnUse"
          x1="9.78888088478347"
          y1="78.8572474050841"
          x2="155.56543964134"
          y2="86.497073121039"
        >
          <stop offset="0%" stop-color="#DBEEF3" />
          <stop offset="100%" stop-color="#FBD5B5" />
        </linearGradient>
        <polygon
          points="13.23,13.23 59.53,13.23 59.53,59.53 13.23,59.53 13.23,19.78 19.84,19.78 19.84,52.91 52.91,52.91 52.91,19.84 13.23,19.84 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="13.23,105.83 59.53,105.83 59.53,152.13 13.23,152.13 13.23,112.37 19.84,112.37 19.84,145.51 52.91,145.51 52.91,112.44 13.23,112.44 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="105.83,13.23 152.13,13.23 152.13,59.53 105.83,59.53 105.83,19.78 112.44,19.78 112.44,52.91 145.51,52.91 145.51,19.84 105.83,19.84 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="26.46,26.46 46.3,26.46 46.3,46.3 26.46,46.3 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="26.46,119.06 46.3,119.06 46.3,138.9 26.46,138.9 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="119.06,26.46 138.9,26.46 138.9,46.3 119.06,46.3 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="85.98,16.54 85.73,17.8 85.02,18.87 83.94,19.59 82.68,19.84 81.41,19.59 80.34,18.87 79.62,17.8 79.37,16.54 79.62,15.27 80.34,14.2 81.41,13.48 82.68,13.23 83.94,13.48 85.02,14.2 85.73,15.27 85.98,16.54 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="92.6,16.54 92.35,17.8 91.63,18.87 90.56,19.59 89.29,19.84 88.03,19.59 86.95,18.87 86.24,17.8 85.98,16.54 86.24,15.27 86.95,14.2 88.03,13.48 89.29,13.23 90.56,13.48 91.63,14.2 92.35,15.27 92.6,16.54 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="99.21,16.54 98.96,17.8 98.24,18.87 97.17,19.59 95.91,19.84 94.64,19.59 93.57,18.87 92.85,17.8 92.6,16.54 92.85,15.27 93.57,14.2 94.64,13.48 95.91,13.23 97.17,13.48 98.24,14.2 98.96,15.27 99.21,16.54 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="72.76,23.15 72.5,24.42 71.79,25.49 70.71,26.2 69.45,26.46 68.18,26.2 67.11,25.49 66.39,24.42 66.14,23.15 66.39,21.88 67.11,20.81 68.18,20.09 69.45,19.84 70.71,20.09 71.79,20.81 72.5,21.88 72.76,23.15 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="79.37,23.15 79.12,24.42 78.4,25.49 77.33,26.2 76.06,26.46 74.8,26.2 73.72,25.49 73.01,24.42 72.76,23.15 73.01,21.88 73.72,20.81 74.8,20.09 76.06,19.84 77.33,20.09 78.4,20.81 79.12,21.88 79.37,23.15 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="85.98,23.15 85.73,24.42 85.02,25.49 83.94,26.2 82.68,26.46 81.41,26.2 80.34,25.49 79.62,24.42 79.37,23.15 79.62,21.88 80.34,20.81 81.41,20.09 82.68,19.84 83.94,20.09 85.02,20.81 85.73,21.88 85.98,23.15 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="99.21,23.15 98.96,24.42 98.24,25.49 97.17,26.2 95.91,26.46 94.64,26.2 93.57,25.49 92.85,24.42 92.6,23.15 92.85,21.88 93.57,20.81 94.64,20.09 95.91,19.84 97.17,20.09 98.24,20.81 98.96,21.88 99.21,23.15 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="85.98,29.76 85.73,31.03 85.02,32.1 83.94,32.82 82.68,33.07 81.41,32.82 80.34,32.1 79.62,31.03 79.37,29.76 79.62,28.5 80.34,27.43 81.41,26.71 82.68,26.46 83.94,26.71 85.02,27.43 85.73,28.5 85.98,29.76 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="92.6,29.76 92.35,31.03 91.63,32.1 90.56,32.82 89.29,33.07 88.03,32.82 86.95,32.1 86.24,31.03 85.98,29.76 86.24,28.5 86.95,27.43 88.03,26.71 89.29,26.46 90.56,26.71 91.63,27.43 92.35,28.5 92.6,29.76 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="99.21,29.76 98.96,31.03 98.24,32.1 97.17,32.82 95.91,33.07 94.64,32.82 93.57,32.1 92.85,31.03 92.6,29.76 92.85,28.5 93.57,27.43 94.64,26.71 95.91,26.46 97.17,26.71 98.24,27.43 98.96,28.5 99.21,29.76 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="72.76,36.38 72.5,37.64 71.79,38.72 70.71,39.43 69.45,39.69 68.18,39.43 67.11,38.72 66.39,37.64 66.14,36.38 66.39,35.11 67.11,34.04 68.18,33.32 69.45,33.07 70.71,33.32 71.79,34.04 72.5,35.11 72.76,36.38 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="79.37,36.38 79.12,37.64 78.4,38.72 77.33,39.43 76.06,39.69 74.8,39.43 73.72,38.72 73.01,37.64 72.76,36.38 73.01,35.11 73.72,34.04 74.8,33.32 76.06,33.07 77.33,33.32 78.4,34.04 79.12,35.11 79.37,36.38 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="99.21,36.38 98.96,37.64 98.24,38.72 97.17,39.43 95.91,39.69 94.64,39.43 93.57,38.72 92.85,37.64 92.6,36.38 92.85,35.11 93.57,34.04 94.64,33.32 95.91,33.07 97.17,33.32 98.24,34.04 98.96,35.11 99.21,36.38 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="79.37,42.99 79.12,44.26 78.4,45.33 77.33,46.05 76.06,46.3 74.8,46.05 73.72,45.33 73.01,44.26 72.76,42.99 73.01,41.73 73.72,40.65 74.8,39.94 76.06,39.69 77.33,39.94 78.4,40.65 79.12,41.73 79.37,42.99 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="99.21,42.99 98.96,44.26 98.24,45.33 97.17,46.05 95.91,46.3 94.64,46.05 93.57,45.33 92.85,44.26 92.6,42.99 92.85,41.73 93.57,40.65 94.64,39.94 95.91,39.69 97.17,39.94 98.24,40.65 98.96,41.73 99.21,42.99 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="72.76,49.61 72.5,50.87 71.79,51.94 70.71,52.66 69.45,52.91 68.18,52.66 67.11,51.94 66.39,50.87 66.14,49.61 66.39,48.34 67.11,47.27 68.18,46.55 69.45,46.3 70.71,46.55 71.79,47.27 72.5,48.34 72.76,49.61 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="92.6,49.61 92.35,50.87 91.63,51.94 90.56,52.66 89.29,52.91 88.03,52.66 86.95,51.94 86.24,50.87 85.98,49.61 86.24,48.34 86.95,47.27 88.03,46.55 89.29,46.3 90.56,46.55 91.63,47.27 92.35,48.34 92.6,49.61 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="72.76,56.22 72.5,57.49 71.79,58.56 70.71,59.28 69.45,59.53 68.18,59.28 67.11,58.56 66.39,57.49 66.14,56.22 66.39,54.95 67.11,53.88 68.18,53.17 69.45,52.91 70.71,53.17 71.79,53.88 72.5,54.95 72.76,56.22 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="85.98,56.22 85.73,57.49 85.02,58.56 83.94,59.28 82.68,59.53 81.41,59.28 80.34,58.56 79.62,57.49 79.37,56.22 79.62,54.95 80.34,53.88 81.41,53.17 82.68,52.91 83.94,53.17 85.02,53.88 85.73,54.95 85.98,56.22 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="99.21,56.22 98.96,57.49 98.24,58.56 97.17,59.28 95.91,59.53 94.64,59.28 93.57,58.56 92.85,57.49 92.6,56.22 92.85,54.95 93.57,53.88 94.64,53.17 95.91,52.91 97.17,53.17 98.24,53.88 98.96,54.95 99.21,56.22 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="79.37,62.83 79.12,64.1 78.4,65.17 77.33,65.89 76.06,66.14 74.8,65.89 73.72,65.17 73.01,64.1 72.76,62.83 73.01,61.57 73.72,60.5 74.8,59.78 76.06,59.53 77.33,59.78 78.4,60.5 79.12,61.57 79.37,62.83 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="19.84,69.45 19.59,70.71 18.87,71.79 17.8,72.5 16.54,72.76 15.27,72.5 14.2,71.79 13.48,70.71 13.23,69.45 13.48,68.18 14.2,67.11 15.27,66.39 16.54,66.14 17.8,66.39 18.87,67.11 19.59,68.18 19.84,69.45 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="26.46,69.45 26.2,70.71 25.49,71.79 24.42,72.5 23.15,72.76 21.88,72.5 20.81,71.79 20.09,70.71 19.84,69.45 20.09,68.18 20.81,67.11 21.88,66.39 23.15,66.14 24.42,66.39 25.49,67.11 26.2,68.18 26.46,69.45 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="33.07,69.45 32.82,70.71 32.1,71.79 31.03,72.5 29.76,72.76 28.5,72.5 27.43,71.79 26.71,70.71 26.46,69.45 26.71,68.18 27.43,67.11 28.5,66.39 29.76,66.14 31.03,66.39 32.1,67.11 32.82,68.18 33.07,69.45 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="39.69,69.45 39.43,70.71 38.72,71.79 37.64,72.5 36.38,72.76 35.11,72.5 34.04,71.79 33.32,70.71 33.07,69.45 33.32,68.18 34.04,67.11 35.11,66.39 36.38,66.14 37.64,66.39 38.72,67.11 39.43,68.18 39.69,69.45 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="46.3,69.45 46.05,70.71 45.33,71.79 44.26,72.5 42.99,72.76 41.73,72.5 40.65,71.79 39.94,70.71 39.69,69.45 39.94,68.18 40.65,67.11 41.73,66.39 42.99,66.14 44.26,66.39 45.33,67.11 46.05,68.18 46.3,69.45 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="59.53,69.45 59.28,70.71 58.56,71.79 57.49,72.5 56.22,72.76 54.95,72.5 53.88,71.79 53.17,70.71 52.91,69.45 53.17,68.18 53.88,67.11 54.95,66.39 56.22,66.14 57.49,66.39 58.56,67.11 59.28,68.18 59.53,69.45 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="66.14,69.45 65.89,70.71 65.17,71.79 64.1,72.5 62.83,72.76 61.57,72.5 60.5,71.79 59.78,70.71 59.53,69.45 59.78,68.18 60.5,67.11 61.57,66.39 62.83,66.14 64.1,66.39 65.17,67.11 65.89,68.18 66.14,69.45 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="72.76,69.45 72.5,70.71 71.79,71.79 70.71,72.5 69.45,72.76 68.18,72.5 67.11,71.79 66.39,70.71 66.14,69.45 66.39,68.18 67.11,67.11 68.18,66.39 69.45,66.14 70.71,66.39 71.79,67.11 72.5,68.18 72.76,69.45 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="92.6,69.45 92.35,70.71 91.63,71.79 90.56,72.5 89.29,72.76 88.03,72.5 86.95,71.79 86.24,70.71 85.98,69.45 86.24,68.18 86.95,67.11 88.03,66.39 89.29,66.14 90.56,66.39 91.63,67.11 92.35,68.18 92.6,69.45 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="105.83,69.45 105.58,70.71 104.86,71.79 103.79,72.5 102.52,72.76 101.25,72.5 100.18,71.79 99.46,70.71 99.21,69.45 99.46,68.18 100.18,67.11 101.25,66.39 102.52,66.14 103.79,66.39 104.86,67.11 105.58,68.18 105.83,69.45 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="119.06,69.45 118.8,70.71 118.09,71.79 117.01,72.5 115.75,72.76 114.48,72.5 113.41,71.79 112.69,70.71 112.44,69.45 112.69,68.18 113.41,67.11 114.48,66.39 115.75,66.14 117.01,66.39 118.09,67.11 118.8,68.18 119.06,69.45 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="132.28,69.45 132.03,70.71 131.31,71.79 130.24,72.5 128.98,72.76 127.71,72.5 126.64,71.79 125.92,70.71 125.67,69.45 125.92,68.18 126.64,67.11 127.71,66.39 128.98,66.14 130.24,66.39 131.31,67.11 132.03,68.18 132.28,69.45 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="145.51,69.45 145.26,70.71 144.54,71.79 143.47,72.5 142.2,72.76 140.94,72.5 139.87,71.79 139.15,70.71 138.9,69.45 139.15,68.18 139.87,67.11 140.94,66.39 142.2,66.14 143.47,66.39 144.54,67.11 145.26,68.18 145.51,69.45 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="19.84,76.06 19.59,77.33 18.87,78.4 17.8,79.12 16.54,79.37 15.27,79.12 14.2,78.4 13.48,77.33 13.23,76.06 13.48,74.8 14.2,73.72 15.27,73.01 16.54,72.76 17.8,73.01 18.87,73.72 19.59,74.8 19.84,76.06 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="26.46,76.06 26.2,77.33 25.49,78.4 24.42,79.12 23.15,79.37 21.88,79.12 20.81,78.4 20.09,77.33 19.84,76.06 20.09,74.8 20.81,73.72 21.88,73.01 23.15,72.76 24.42,73.01 25.49,73.72 26.2,74.8 26.46,76.06 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="33.07,76.06 32.82,77.33 32.1,78.4 31.03,79.12 29.76,79.37 28.5,79.12 27.43,78.4 26.71,77.33 26.46,76.06 26.71,74.8 27.43,73.72 28.5,73.01 29.76,72.76 31.03,73.01 32.1,73.72 32.82,74.8 33.07,76.06 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="52.91,76.06 52.66,77.33 51.94,78.4 50.87,79.12 49.61,79.37 48.34,79.12 47.27,78.4 46.55,77.33 46.3,76.06 46.55,74.8 47.27,73.72 48.34,73.01 49.61,72.76 50.87,73.01 51.94,73.72 52.66,74.8 52.91,76.06 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="66.14,76.06 65.89,77.33 65.17,78.4 64.1,79.12 62.83,79.37 61.57,79.12 60.5,78.4 59.78,77.33 59.53,76.06 59.78,74.8 60.5,73.72 61.57,73.01 62.83,72.76 64.1,73.01 65.17,73.72 65.89,74.8 66.14,76.06 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="79.37,76.06 79.12,77.33 78.4,78.4 77.33,79.12 76.06,79.37 74.8,79.12 73.72,78.4 73.01,77.33 72.76,76.06 73.01,74.8 73.72,73.72 74.8,73.01 76.06,72.76 77.33,73.01 78.4,73.72 79.12,74.8 79.37,76.06 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="92.6,76.06 92.35,77.33 91.63,78.4 90.56,79.12 89.29,79.37 88.03,79.12 86.95,78.4 86.24,77.33 85.98,76.06 86.24,74.8 86.95,73.72 88.03,73.01 89.29,72.76 90.56,73.01 91.63,73.72 92.35,74.8 92.6,76.06 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="99.21,76.06 98.96,77.33 98.24,78.4 97.17,79.12 95.91,79.37 94.64,79.12 93.57,78.4 92.85,77.33 92.6,76.06 92.85,74.8 93.57,73.72 94.64,73.01 95.91,72.76 97.17,73.01 98.24,73.72 98.96,74.8 99.21,76.06 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="105.83,76.06 105.58,77.33 104.86,78.4 103.79,79.12 102.52,79.37 101.25,79.12 100.18,78.4 99.46,77.33 99.21,76.06 99.46,74.8 100.18,73.72 101.25,73.01 102.52,72.76 103.79,73.01 104.86,73.72 105.58,74.8 105.83,76.06 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="112.44,76.06 112.19,77.33 111.47,78.4 110.4,79.12 109.13,79.37 107.87,79.12 106.8,78.4 106.08,77.33 105.83,76.06 106.08,74.8 106.8,73.72 107.87,73.01 109.13,72.76 110.4,73.01 111.47,73.72 112.19,74.8 112.44,76.06 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="132.28,76.06 132.03,77.33 131.31,78.4 130.24,79.12 128.98,79.37 127.71,79.12 126.64,78.4 125.92,77.33 125.67,76.06 125.92,74.8 126.64,73.72 127.71,73.01 128.98,72.76 130.24,73.01 131.31,73.72 132.03,74.8 132.28,76.06 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="138.9,76.06 138.65,77.33 137.93,78.4 136.86,79.12 135.59,79.37 134.32,79.12 133.25,78.4 132.54,77.33 132.28,76.06 132.54,74.8 133.25,73.72 134.32,73.01 135.59,72.76 136.86,73.01 137.93,73.72 138.65,74.8 138.9,76.06 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="145.51,76.06 145.26,77.33 144.54,78.4 143.47,79.12 142.2,79.37 140.94,79.12 139.87,78.4 139.15,77.33 138.9,76.06 139.15,74.8 139.87,73.72 140.94,73.01 142.2,72.76 143.47,73.01 144.54,73.72 145.26,74.8 145.51,76.06 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="152.13,76.06 151.87,77.33 151.16,78.4 150.08,79.12 148.82,79.37 147.55,79.12 146.48,78.4 145.76,77.33 145.51,76.06 145.76,74.8 146.48,73.72 147.55,73.01 148.82,72.76 150.08,73.01 151.16,73.72 151.87,74.8 152.13,76.06 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="33.07,82.68 32.82,83.94 32.1,85.02 31.03,85.73 29.76,85.98 28.5,85.73 27.43,85.02 26.71,83.94 26.46,82.68 26.71,81.41 27.43,80.34 28.5,79.62 29.76,79.37 31.03,79.62 32.1,80.34 32.82,81.41 33.07,82.68 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="46.3,82.68 46.05,83.94 45.33,85.02 44.26,85.73 42.99,85.98 41.73,85.73 40.65,85.02 39.94,83.94 39.69,82.68 39.94,81.41 40.65,80.34 41.73,79.62 42.99,79.37 44.26,79.62 45.33,80.34 46.05,81.41 46.3,82.68 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="52.91,82.68 52.66,83.94 51.94,85.02 50.87,85.73 49.61,85.98 48.34,85.73 47.27,85.02 46.55,83.94 46.3,82.68 46.55,81.41 47.27,80.34 48.34,79.62 49.61,79.37 50.87,79.62 51.94,80.34 52.66,81.41 52.91,82.68 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="59.53,82.68 59.28,83.94 58.56,85.02 57.49,85.73 56.22,85.98 54.95,85.73 53.88,85.02 53.17,83.94 52.91,82.68 53.17,81.41 53.88,80.34 54.95,79.62 56.22,79.37 57.49,79.62 58.56,80.34 59.28,81.41 59.53,82.68 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="72.76,82.68 72.5,83.94 71.79,85.02 70.71,85.73 69.45,85.98 68.18,85.73 67.11,85.02 66.39,83.94 66.14,82.68 66.39,81.41 67.11,80.34 68.18,79.62 69.45,79.37 70.71,79.62 71.79,80.34 72.5,81.41 72.76,82.68 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="79.37,82.68 79.12,83.94 78.4,85.02 77.33,85.73 76.06,85.98 74.8,85.73 73.72,85.02 73.01,83.94 72.76,82.68 73.01,81.41 73.72,80.34 74.8,79.62 76.06,79.37 77.33,79.62 78.4,80.34 79.12,81.41 79.37,82.68 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="99.21,82.68 98.96,83.94 98.24,85.02 97.17,85.73 95.91,85.98 94.64,85.73 93.57,85.02 92.85,83.94 92.6,82.68 92.85,81.41 93.57,80.34 94.64,79.62 95.91,79.37 97.17,79.62 98.24,80.34 98.96,81.41 99.21,82.68 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="112.44,82.68 112.19,83.94 111.47,85.02 110.4,85.73 109.13,85.98 107.87,85.73 106.8,85.02 106.08,83.94 105.83,82.68 106.08,81.41 106.8,80.34 107.87,79.62 109.13,79.37 110.4,79.62 111.47,80.34 112.19,81.41 112.44,82.68 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="119.06,82.68 118.8,83.94 118.09,85.02 117.01,85.73 115.75,85.98 114.48,85.73 113.41,85.02 112.69,83.94 112.44,82.68 112.69,81.41 113.41,80.34 114.48,79.62 115.75,79.37 117.01,79.62 118.09,80.34 118.8,81.41 119.06,82.68 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="132.28,82.68 132.03,83.94 131.31,85.02 130.24,85.73 128.98,85.98 127.71,85.73 126.64,85.02 125.92,83.94 125.67,82.68 125.92,81.41 126.64,80.34 127.71,79.62 128.98,79.37 130.24,79.62 131.31,80.34 132.03,81.41 132.28,82.68 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="152.13,82.68 151.87,83.94 151.16,85.02 150.08,85.73 148.82,85.98 147.55,85.73 146.48,85.02 145.76,83.94 145.51,82.68 145.76,81.41 146.48,80.34 147.55,79.62 148.82,79.37 150.08,79.62 151.16,80.34 151.87,81.41 152.13,82.68 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="19.84,89.29 19.59,90.56 18.87,91.63 17.8,92.35 16.54,92.6 15.27,92.35 14.2,91.63 13.48,90.56 13.23,89.29 13.48,88.03 14.2,86.95 15.27,86.24 16.54,85.98 17.8,86.24 18.87,86.95 19.59,88.03 19.84,89.29 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="39.69,89.29 39.43,90.56 38.72,91.63 37.64,92.35 36.38,92.6 35.11,92.35 34.04,91.63 33.32,90.56 33.07,89.29 33.32,88.03 34.04,86.95 35.11,86.24 36.38,85.98 37.64,86.24 38.72,86.95 39.43,88.03 39.69,89.29 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="92.6,89.29 92.35,90.56 91.63,91.63 90.56,92.35 89.29,92.6 88.03,92.35 86.95,91.63 86.24,90.56 85.98,89.29 86.24,88.03 86.95,86.95 88.03,86.24 89.29,85.98 90.56,86.24 91.63,86.95 92.35,88.03 92.6,89.29 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="99.21,89.29 98.96,90.56 98.24,91.63 97.17,92.35 95.91,92.6 94.64,92.35 93.57,91.63 92.85,90.56 92.6,89.29 92.85,88.03 93.57,86.95 94.64,86.24 95.91,85.98 97.17,86.24 98.24,86.95 98.96,88.03 99.21,89.29 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="105.83,89.29 105.58,90.56 104.86,91.63 103.79,92.35 102.52,92.6 101.25,92.35 100.18,91.63 99.46,90.56 99.21,89.29 99.46,88.03 100.18,86.95 101.25,86.24 102.52,85.98 103.79,86.24 104.86,86.95 105.58,88.03 105.83,89.29 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="112.44,89.29 112.19,90.56 111.47,91.63 110.4,92.35 109.13,92.6 107.87,92.35 106.8,91.63 106.08,90.56 105.83,89.29 106.08,88.03 106.8,86.95 107.87,86.24 109.13,85.98 110.4,86.24 111.47,86.95 112.19,88.03 112.44,89.29 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="138.9,89.29 138.65,90.56 137.93,91.63 136.86,92.35 135.59,92.6 134.32,92.35 133.25,91.63 132.54,90.56 132.28,89.29 132.54,88.03 133.25,86.95 134.32,86.24 135.59,85.98 136.86,86.24 137.93,86.95 138.65,88.03 138.9,89.29 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="145.51,89.29 145.26,90.56 144.54,91.63 143.47,92.35 142.2,92.6 140.94,92.35 139.87,91.63 139.15,90.56 138.9,89.29 139.15,88.03 139.87,86.95 140.94,86.24 142.2,85.98 143.47,86.24 144.54,86.95 145.26,88.03 145.51,89.29 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="152.13,89.29 151.87,90.56 151.16,91.63 150.08,92.35 148.82,92.6 147.55,92.35 146.48,91.63 145.76,90.56 145.51,89.29 145.76,88.03 146.48,86.95 147.55,86.24 148.82,85.98 150.08,86.24 151.16,86.95 151.87,88.03 152.13,89.29 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="26.46,95.91 26.2,97.17 25.49,98.24 24.42,98.96 23.15,99.21 21.88,98.96 20.81,98.24 20.09,97.17 19.84,95.91 20.09,94.64 20.81,93.57 21.88,92.85 23.15,92.6 24.42,92.85 25.49,93.57 26.2,94.64 26.46,95.91 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="39.69,95.91 39.43,97.17 38.72,98.24 37.64,98.96 36.38,99.21 35.11,98.96 34.04,98.24 33.32,97.17 33.07,95.91 33.32,94.64 34.04,93.57 35.11,92.85 36.38,92.6 37.64,92.85 38.72,93.57 39.43,94.64 39.69,95.91 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="46.3,95.91 46.05,97.17 45.33,98.24 44.26,98.96 42.99,99.21 41.73,98.96 40.65,98.24 39.94,97.17 39.69,95.91 39.94,94.64 40.65,93.57 41.73,92.85 42.99,92.6 44.26,92.85 45.33,93.57 46.05,94.64 46.3,95.91 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="59.53,95.91 59.28,97.17 58.56,98.24 57.49,98.96 56.22,99.21 54.95,98.96 53.88,98.24 53.17,97.17 52.91,95.91 53.17,94.64 53.88,93.57 54.95,92.85 56.22,92.6 57.49,92.85 58.56,93.57 59.28,94.64 59.53,95.91 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="72.76,95.91 72.5,97.17 71.79,98.24 70.71,98.96 69.45,99.21 68.18,98.96 67.11,98.24 66.39,97.17 66.14,95.91 66.39,94.64 67.11,93.57 68.18,92.85 69.45,92.6 70.71,92.85 71.79,93.57 72.5,94.64 72.76,95.91 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="79.37,95.91 79.12,97.17 78.4,98.24 77.33,98.96 76.06,99.21 74.8,98.96 73.72,98.24 73.01,97.17 72.76,95.91 73.01,94.64 73.72,93.57 74.8,92.85 76.06,92.6 77.33,92.85 78.4,93.57 79.12,94.64 79.37,95.91 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="99.21,95.91 98.96,97.17 98.24,98.24 97.17,98.96 95.91,99.21 94.64,98.96 93.57,98.24 92.85,97.17 92.6,95.91 92.85,94.64 93.57,93.57 94.64,92.85 95.91,92.6 97.17,92.85 98.24,93.57 98.96,94.64 99.21,95.91 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="119.06,95.91 118.8,97.17 118.09,98.24 117.01,98.96 115.75,99.21 114.48,98.96 113.41,98.24 112.69,97.17 112.44,95.91 112.69,94.64 113.41,93.57 114.48,92.85 115.75,92.6 117.01,92.85 118.09,93.57 118.8,94.64 119.06,95.91 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="145.51,95.91 145.26,97.17 144.54,98.24 143.47,98.96 142.2,99.21 140.94,98.96 139.87,98.24 139.15,97.17 138.9,95.91 139.15,94.64 139.87,93.57 140.94,92.85 142.2,92.6 143.47,92.85 144.54,93.57 145.26,94.64 145.51,95.91 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="72.76,102.52 72.5,103.79 71.79,104.86 70.71,105.58 69.45,105.83 68.18,105.58 67.11,104.86 66.39,103.79 66.14,102.52 66.39,101.25 67.11,100.18 68.18,99.46 69.45,99.21 70.71,99.46 71.79,100.18 72.5,101.25 72.76,102.52 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="85.98,102.52 85.73,103.79 85.02,104.86 83.94,105.58 82.68,105.83 81.41,105.58 80.34,104.86 79.62,103.79 79.37,102.52 79.62,101.25 80.34,100.18 81.41,99.46 82.68,99.21 83.94,99.46 85.02,100.18 85.73,101.25 85.98,102.52 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="99.21,102.52 98.96,103.79 98.24,104.86 97.17,105.58 95.91,105.83 94.64,105.58 93.57,104.86 92.85,103.79 92.6,102.52 92.85,101.25 93.57,100.18 94.64,99.46 95.91,99.21 97.17,99.46 98.24,100.18 98.96,101.25 99.21,102.52 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="119.06,102.52 118.8,103.79 118.09,104.86 117.01,105.58 115.75,105.83 114.48,105.58 113.41,104.86 112.69,103.79 112.44,102.52 112.69,101.25 113.41,100.18 114.48,99.46 115.75,99.21 117.01,99.46 118.09,100.18 118.8,101.25 119.06,102.52 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="138.9,102.52 138.65,103.79 137.93,104.86 136.86,105.58 135.59,105.83 134.32,105.58 133.25,104.86 132.54,103.79 132.28,102.52 132.54,101.25 133.25,100.18 134.32,99.46 135.59,99.21 136.86,99.46 137.93,100.18 138.65,101.25 138.9,102.52 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="72.76,109.13 72.5,110.4 71.79,111.47 70.71,112.19 69.45,112.44 68.18,112.19 67.11,111.47 66.39,110.4 66.14,109.13 66.39,107.87 67.11,106.8 68.18,106.08 69.45,105.83 70.71,106.08 71.79,106.8 72.5,107.87 72.76,109.13 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="92.6,109.13 92.35,110.4 91.63,111.47 90.56,112.19 89.29,112.44 88.03,112.19 86.95,111.47 86.24,110.4 85.98,109.13 86.24,107.87 86.95,106.8 88.03,106.08 89.29,105.83 90.56,106.08 91.63,106.8 92.35,107.87 92.6,109.13 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="105.83,109.13 105.58,110.4 104.86,111.47 103.79,112.19 102.52,112.44 101.25,112.19 100.18,111.47 99.46,110.4 99.21,109.13 99.46,107.87 100.18,106.8 101.25,106.08 102.52,105.83 103.79,106.08 104.86,106.8 105.58,107.87 105.83,109.13 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="125.67,109.13 125.42,110.4 124.7,111.47 123.63,112.19 122.36,112.44 121.1,112.19 120.02,111.47 119.31,110.4 119.06,109.13 119.31,107.87 120.02,106.8 121.1,106.08 122.36,105.83 123.63,106.08 124.7,106.8 125.42,107.87 125.67,109.13 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="132.28,109.13 132.03,110.4 131.31,111.47 130.24,112.19 128.98,112.44 127.71,112.19 126.64,111.47 125.92,110.4 125.67,109.13 125.92,107.87 126.64,106.8 127.71,106.08 128.98,105.83 130.24,106.08 131.31,106.8 132.03,107.87 132.28,109.13 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="145.51,109.13 145.26,110.4 144.54,111.47 143.47,112.19 142.2,112.44 140.94,112.19 139.87,111.47 139.15,110.4 138.9,109.13 139.15,107.87 139.87,106.8 140.94,106.08 142.2,105.83 143.47,106.08 144.54,106.8 145.26,107.87 145.51,109.13 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="152.13,109.13 151.87,110.4 151.16,111.47 150.08,112.19 148.82,112.44 147.55,112.19 146.48,111.47 145.76,110.4 145.51,109.13 145.76,107.87 146.48,106.8 147.55,106.08 148.82,105.83 150.08,106.08 151.16,106.8 151.87,107.87 152.13,109.13 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="79.37,115.75 79.12,117.01 78.4,118.09 77.33,118.8 76.06,119.06 74.8,118.8 73.72,118.09 73.01,117.01 72.76,115.75 73.01,114.48 73.72,113.41 74.8,112.69 76.06,112.44 77.33,112.69 78.4,113.41 79.12,114.48 79.37,115.75 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="85.98,115.75 85.73,117.01 85.02,118.09 83.94,118.8 82.68,119.06 81.41,118.8 80.34,118.09 79.62,117.01 79.37,115.75 79.62,114.48 80.34,113.41 81.41,112.69 82.68,112.44 83.94,112.69 85.02,113.41 85.73,114.48 85.98,115.75 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="119.06,115.75 118.8,117.01 118.09,118.09 117.01,118.8 115.75,119.06 114.48,118.8 113.41,118.09 112.69,117.01 112.44,115.75 112.69,114.48 113.41,113.41 114.48,112.69 115.75,112.44 117.01,112.69 118.09,113.41 118.8,114.48 119.06,115.75 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="125.67,115.75 125.42,117.01 124.7,118.09 123.63,118.8 122.36,119.06 121.1,118.8 120.02,118.09 119.31,117.01 119.06,115.75 119.31,114.48 120.02,113.41 121.1,112.69 122.36,112.44 123.63,112.69 124.7,113.41 125.42,114.48 125.67,115.75 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="138.9,115.75 138.65,117.01 137.93,118.09 136.86,118.8 135.59,119.06 134.32,118.8 133.25,118.09 132.54,117.01 132.28,115.75 132.54,114.48 133.25,113.41 134.32,112.69 135.59,112.44 136.86,112.69 137.93,113.41 138.65,114.48 138.9,115.75 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="152.13,115.75 151.87,117.01 151.16,118.09 150.08,118.8 148.82,119.06 147.55,118.8 146.48,118.09 145.76,117.01 145.51,115.75 145.76,114.48 146.48,113.41 147.55,112.69 148.82,112.44 150.08,112.69 151.16,113.41 151.87,114.48 152.13,115.75 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="72.76,122.36 72.5,123.63 71.79,124.7 70.71,125.42 69.45,125.67 68.18,125.42 67.11,124.7 66.39,123.63 66.14,122.36 66.39,121.1 67.11,120.02 68.18,119.31 69.45,119.06 70.71,119.31 71.79,120.02 72.5,121.1 72.76,122.36 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="79.37,122.36 79.12,123.63 78.4,124.7 77.33,125.42 76.06,125.67 74.8,125.42 73.72,124.7 73.01,123.63 72.76,122.36 73.01,121.1 73.72,120.02 74.8,119.31 76.06,119.06 77.33,119.31 78.4,120.02 79.12,121.1 79.37,122.36 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="85.98,122.36 85.73,123.63 85.02,124.7 83.94,125.42 82.68,125.67 81.41,125.42 80.34,124.7 79.62,123.63 79.37,122.36 79.62,121.1 80.34,120.02 81.41,119.31 82.68,119.06 83.94,119.31 85.02,120.02 85.73,121.1 85.98,122.36 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="92.6,122.36 92.35,123.63 91.63,124.7 90.56,125.42 89.29,125.67 88.03,125.42 86.95,124.7 86.24,123.63 85.98,122.36 86.24,121.1 86.95,120.02 88.03,119.31 89.29,119.06 90.56,119.31 91.63,120.02 92.35,121.1 92.6,122.36 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="105.83,122.36 105.58,123.63 104.86,124.7 103.79,125.42 102.52,125.67 101.25,125.42 100.18,124.7 99.46,123.63 99.21,122.36 99.46,121.1 100.18,120.02 101.25,119.31 102.52,119.06 103.79,119.31 104.86,120.02 105.58,121.1 105.83,122.36 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="125.67,122.36 125.42,123.63 124.7,124.7 123.63,125.42 122.36,125.67 121.1,125.42 120.02,124.7 119.31,123.63 119.06,122.36 119.31,121.1 120.02,120.02 121.1,119.31 122.36,119.06 123.63,119.31 124.7,120.02 125.42,121.1 125.67,122.36 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="132.28,122.36 132.03,123.63 131.31,124.7 130.24,125.42 128.98,125.67 127.71,125.42 126.64,124.7 125.92,123.63 125.67,122.36 125.92,121.1 126.64,120.02 127.71,119.31 128.98,119.06 130.24,119.31 131.31,120.02 132.03,121.1 132.28,122.36 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="138.9,122.36 138.65,123.63 137.93,124.7 136.86,125.42 135.59,125.67 134.32,125.42 133.25,124.7 132.54,123.63 132.28,122.36 132.54,121.1 133.25,120.02 134.32,119.31 135.59,119.06 136.86,119.31 137.93,120.02 138.65,121.1 138.9,122.36 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="72.76,128.98 72.5,130.24 71.79,131.31 70.71,132.03 69.45,132.28 68.18,132.03 67.11,131.31 66.39,130.24 66.14,128.98 66.39,127.71 67.11,126.64 68.18,125.92 69.45,125.67 70.71,125.92 71.79,126.64 72.5,127.71 72.76,128.98 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="79.37,128.98 79.12,130.24 78.4,131.31 77.33,132.03 76.06,132.28 74.8,132.03 73.72,131.31 73.01,130.24 72.76,128.98 73.01,127.71 73.72,126.64 74.8,125.92 76.06,125.67 77.33,125.92 78.4,126.64 79.12,127.71 79.37,128.98 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="92.6,128.98 92.35,130.24 91.63,131.31 90.56,132.03 89.29,132.28 88.03,132.03 86.95,131.31 86.24,130.24 85.98,128.98 86.24,127.71 86.95,126.64 88.03,125.92 89.29,125.67 90.56,125.92 91.63,126.64 92.35,127.71 92.6,128.98 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="99.21,128.98 98.96,130.24 98.24,131.31 97.17,132.03 95.91,132.28 94.64,132.03 93.57,131.31 92.85,130.24 92.6,128.98 92.85,127.71 93.57,126.64 94.64,125.92 95.91,125.67 97.17,125.92 98.24,126.64 98.96,127.71 99.21,128.98 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="105.83,128.98 105.58,130.24 104.86,131.31 103.79,132.03 102.52,132.28 101.25,132.03 100.18,131.31 99.46,130.24 99.21,128.98 99.46,127.71 100.18,126.64 101.25,125.92 102.52,125.67 103.79,125.92 104.86,126.64 105.58,127.71 105.83,128.98 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="112.44,128.98 112.19,130.24 111.47,131.31 110.4,132.03 109.13,132.28 107.87,132.03 106.8,131.31 106.08,130.24 105.83,128.98 106.08,127.71 106.8,126.64 107.87,125.92 109.13,125.67 110.4,125.92 111.47,126.64 112.19,127.71 112.44,128.98 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="119.06,128.98 118.8,130.24 118.09,131.31 117.01,132.03 115.75,132.28 114.48,132.03 113.41,131.31 112.69,130.24 112.44,128.98 112.69,127.71 113.41,126.64 114.48,125.92 115.75,125.67 117.01,125.92 118.09,126.64 118.8,127.71 119.06,128.98 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="132.28,128.98 132.03,130.24 131.31,131.31 130.24,132.03 128.98,132.28 127.71,132.03 126.64,131.31 125.92,130.24 125.67,128.98 125.92,127.71 126.64,126.64 127.71,125.92 128.98,125.67 130.24,125.92 131.31,126.64 132.03,127.71 132.28,128.98 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="138.9,128.98 138.65,130.24 137.93,131.31 136.86,132.03 135.59,132.28 134.32,132.03 133.25,131.31 132.54,130.24 132.28,128.98 132.54,127.71 133.25,126.64 134.32,125.92 135.59,125.67 136.86,125.92 137.93,126.64 138.65,127.71 138.9,128.98 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="72.76,135.59 72.5,136.86 71.79,137.93 70.71,138.65 69.45,138.9 68.18,138.65 67.11,137.93 66.39,136.86 66.14,135.59 66.39,134.32 67.11,133.25 68.18,132.54 69.45,132.28 70.71,132.54 71.79,133.25 72.5,134.32 72.76,135.59 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="79.37,135.59 79.12,136.86 78.4,137.93 77.33,138.65 76.06,138.9 74.8,138.65 73.72,137.93 73.01,136.86 72.76,135.59 73.01,134.32 73.72,133.25 74.8,132.54 76.06,132.28 77.33,132.54 78.4,133.25 79.12,134.32 79.37,135.59 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="99.21,135.59 98.96,136.86 98.24,137.93 97.17,138.65 95.91,138.9 94.64,138.65 93.57,137.93 92.85,136.86 92.6,135.59 92.85,134.32 93.57,133.25 94.64,132.54 95.91,132.28 97.17,132.54 98.24,133.25 98.96,134.32 99.21,135.59 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="112.44,135.59 112.19,136.86 111.47,137.93 110.4,138.65 109.13,138.9 107.87,138.65 106.8,137.93 106.08,136.86 105.83,135.59 106.08,134.32 106.8,133.25 107.87,132.54 109.13,132.28 110.4,132.54 111.47,133.25 112.19,134.32 112.44,135.59 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="119.06,135.59 118.8,136.86 118.09,137.93 117.01,138.65 115.75,138.9 114.48,138.65 113.41,137.93 112.69,136.86 112.44,135.59 112.69,134.32 113.41,133.25 114.48,132.54 115.75,132.28 117.01,132.54 118.09,133.25 118.8,134.32 119.06,135.59 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="132.28,135.59 132.03,136.86 131.31,137.93 130.24,138.65 128.98,138.9 127.71,138.65 126.64,137.93 125.92,136.86 125.67,135.59 125.92,134.32 126.64,133.25 127.71,132.54 128.98,132.28 130.24,132.54 131.31,133.25 132.03,134.32 132.28,135.59 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="138.9,135.59 138.65,136.86 137.93,137.93 136.86,138.65 135.59,138.9 134.32,138.65 133.25,137.93 132.54,136.86 132.28,135.59 132.54,134.32 133.25,133.25 134.32,132.54 135.59,132.28 136.86,132.54 137.93,133.25 138.65,134.32 138.9,135.59 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="72.76,142.2 72.5,143.47 71.79,144.54 70.71,145.26 69.45,145.51 68.18,145.26 67.11,144.54 66.39,143.47 66.14,142.2 66.39,140.94 67.11,139.87 68.18,139.15 69.45,138.9 70.71,139.15 71.79,139.87 72.5,140.94 72.76,142.2 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="85.98,142.2 85.73,143.47 85.02,144.54 83.94,145.26 82.68,145.51 81.41,145.26 80.34,144.54 79.62,143.47 79.37,142.2 79.62,140.94 80.34,139.87 81.41,139.15 82.68,138.9 83.94,139.15 85.02,139.87 85.73,140.94 85.98,142.2 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="92.6,142.2 92.35,143.47 91.63,144.54 90.56,145.26 89.29,145.51 88.03,145.26 86.95,144.54 86.24,143.47 85.98,142.2 86.24,140.94 86.95,139.87 88.03,139.15 89.29,138.9 90.56,139.15 91.63,139.87 92.35,140.94 92.6,142.2 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="99.21,142.2 98.96,143.47 98.24,144.54 97.17,145.26 95.91,145.51 94.64,145.26 93.57,144.54 92.85,143.47 92.6,142.2 92.85,140.94 93.57,139.87 94.64,139.15 95.91,138.9 97.17,139.15 98.24,139.87 98.96,140.94 99.21,142.2 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="105.83,142.2 105.58,143.47 104.86,144.54 103.79,145.26 102.52,145.51 101.25,145.26 100.18,144.54 99.46,143.47 99.21,142.2 99.46,140.94 100.18,139.87 101.25,139.15 102.52,138.9 103.79,139.15 104.86,139.87 105.58,140.94 105.83,142.2 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="112.44,142.2 112.19,143.47 111.47,144.54 110.4,145.26 109.13,145.51 107.87,145.26 106.8,144.54 106.08,143.47 105.83,142.2 106.08,140.94 106.8,139.87 107.87,139.15 109.13,138.9 110.4,139.15 111.47,139.87 112.19,140.94 112.44,142.2 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="119.06,142.2 118.8,143.47 118.09,144.54 117.01,145.26 115.75,145.51 114.48,145.26 113.41,144.54 112.69,143.47 112.44,142.2 112.69,140.94 113.41,139.87 114.48,139.15 115.75,138.9 117.01,139.15 118.09,139.87 118.8,140.94 119.06,142.2 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="125.67,142.2 125.42,143.47 124.7,144.54 123.63,145.26 122.36,145.51 121.1,145.26 120.02,144.54 119.31,143.47 119.06,142.2 119.31,140.94 120.02,139.87 121.1,139.15 122.36,138.9 123.63,139.15 124.7,139.87 125.42,140.94 125.67,142.2 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="138.9,142.2 138.65,143.47 137.93,144.54 136.86,145.26 135.59,145.51 134.32,145.26 133.25,144.54 132.54,143.47 132.28,142.2 132.54,140.94 133.25,139.87 134.32,139.15 135.59,138.9 136.86,139.15 137.93,139.87 138.65,140.94 138.9,142.2 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="145.51,142.2 145.26,143.47 144.54,144.54 143.47,145.26 142.2,145.51 140.94,145.26 139.87,144.54 139.15,143.47 138.9,142.2 139.15,140.94 139.87,139.87 140.94,139.15 142.2,138.9 143.47,139.15 144.54,139.87 145.26,140.94 145.51,142.2 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="72.76,148.82 72.5,150.08 71.79,151.16 70.71,151.87 69.45,152.13 68.18,151.87 67.11,151.16 66.39,150.08 66.14,148.82 66.39,147.55 67.11,146.48 68.18,145.76 69.45,145.51 70.71,145.76 71.79,146.48 72.5,147.55 72.76,148.82 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="79.37,148.82 79.12,150.08 78.4,151.16 77.33,151.87 76.06,152.13 74.8,151.87 73.72,151.16 73.01,150.08 72.76,148.82 73.01,147.55 73.72,146.48 74.8,145.76 76.06,145.51 77.33,145.76 78.4,146.48 79.12,147.55 79.37,148.82 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="85.98,148.82 85.73,150.08 85.02,151.16 83.94,151.87 82.68,152.13 81.41,151.87 80.34,151.16 79.62,150.08 79.37,148.82 79.62,147.55 80.34,146.48 81.41,145.76 82.68,145.51 83.94,145.76 85.02,146.48 85.73,147.55 85.98,148.82 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="99.21,148.82 98.96,150.08 98.24,151.16 97.17,151.87 95.91,152.13 94.64,151.87 93.57,151.16 92.85,150.08 92.6,148.82 92.85,147.55 93.57,146.48 94.64,145.76 95.91,145.51 97.17,145.76 98.24,146.48 98.96,147.55 99.21,148.82 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="119.06,148.82 118.8,150.08 118.09,151.16 117.01,151.87 115.75,152.13 114.48,151.87 113.41,151.16 112.69,150.08 112.44,148.82 112.69,147.55 113.41,146.48 114.48,145.76 115.75,145.51 117.01,145.76 118.09,146.48 118.8,147.55 119.06,148.82 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
        <polygon
          points="138.9,148.82 138.65,150.08 137.93,151.16 136.86,151.87 135.59,152.13 134.32,151.87 133.25,151.16 132.54,150.08 132.28,148.82 132.54,147.55 133.25,146.48 134.32,145.76 135.59,145.51 136.86,145.76 137.93,146.48 138.65,147.55 138.9,148.82 "
          style="fill:url(#gradiente61bf7b05498450e94216666bad1de37);"
        />
      `,
            },
            {
                value: 10,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(37,86,99,1);"
            shape-rendering="crispEdges"
          />
          <pattern
            id="hatch66b57d3d484547528ac58fe19b915123"
            x="0"
            y="0"
            width="8"
            height="8"
            patternUnits="userSpaceOnUse"
          >
            <rect x="0" y="0" width="8" height="8" fill="#E5B9B7" />
            <rect x="0" y="0" width="1" height="1" fill="#DBEEF3" />
            <rect x="1" y="0" width="1" height="1" fill="#DBEEF3" />
            <rect x="2" y="0" width="1" height="1" fill="#DBEEF3" />
            <rect x="3" y="0" width="1" height="1" fill="#DBEEF3" />
            <rect x="4" y="4" width="1" height="1" fill="#DBEEF3" />
            <rect x="5" y="4" width="1" height="1" fill="#DBEEF3" />
            <rect x="6" y="4" width="1" height="1" fill="#DBEEF3" />
            <rect x="7" y="4" width="1" height="1" fill="#DBEEF3" />
          </pattern>
          <polygon
            points="13.23,13.23 59.53,13.23 59.53,59.53 13.23,59.53 13.23,19.78 19.84,19.78 19.84,52.91 52.91,52.91 52.91,19.84 13.23,19.84 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="13.23,105.83 59.53,105.83 59.53,152.13 13.23,152.13 13.23,112.37 19.84,112.37 19.84,145.51 52.91,145.51 52.91,112.44 13.23,112.44 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="105.83,13.23 152.13,13.23 152.13,59.53 105.83,59.53 105.83,19.78 112.44,19.78 112.44,52.91 145.51,52.91 145.51,19.84 105.83,19.84 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="26.46,26.46 46.3,26.46 46.3,46.3 26.46,46.3 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="26.46,119.06 46.3,119.06 46.3,138.9 26.46,138.9 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="119.06,26.46 138.9,26.46 138.9,46.3 119.06,46.3 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="79.37,13.23 86.05,13.23 85.98,19.91 79.37,19.91 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="85.92,13.23 92.66,13.23 92.53,19.84 85.92,19.84 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="92.53,13.23 99.21,13.23 99.15,19.91 92.53,19.91 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="66.14,19.84 72.82,19.84 72.76,26.46 66.14,26.46 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="72.69,19.84 79.44,19.84 79.3,26.46 72.69,26.46 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="79.3,19.78 85.98,19.78 85.92,26.52 79.3,26.52 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="92.6,19.78 99.21,19.78 99.21,26.52 92.6,26.52 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="79.37,26.39 86.05,26.39 85.98,33.07 79.37,33.07 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="85.92,26.46 92.66,26.46 92.53,33.07 85.92,33.07 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="92.53,26.39 99.21,26.39 99.15,33.14 92.53,33.14 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="66.14,33.07 72.82,33.07 72.76,39.69 66.14,39.69 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="72.69,33.07 79.37,33.07 79.3,39.75 72.69,39.75 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="92.6,33 99.21,33 99.21,39.75 92.6,39.75 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="72.76,39.62 79.37,39.62 79.37,46.3 72.76,46.3 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="92.6,39.62 99.21,39.62 99.21,46.3 92.6,46.3 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="66.14,46.3 72.76,46.3 72.76,52.98 66.14,52.98 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="85.98,46.3 92.6,46.3 92.6,52.91 85.98,52.91 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="66.14,52.85 72.76,52.85 72.76,59.53 66.14,59.53 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="79.37,52.91 85.98,52.91 85.98,59.53 79.37,59.53 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="92.6,52.91 99.21,52.91 99.21,59.53 92.6,59.53 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="72.76,59.53 79.37,59.53 79.37,66.14 72.76,66.14 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="13.23,66.14 19.91,66.14 19.84,72.82 13.23,72.82 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="19.78,66.14 26.52,66.14 26.39,72.82 19.78,72.82 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="26.39,66.14 33.14,66.14 33,72.82 26.39,72.82 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="33,66.14 39.75,66.14 39.62,72.76 33,72.76 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="39.62,66.14 46.3,66.14 46.23,72.76 39.62,72.76 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="52.91,66.14 59.59,66.14 59.53,72.76 52.91,72.76 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="59.46,66.14 66.21,66.14 66.08,72.82 59.46,72.82 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="66.08,66.14 72.76,66.14 72.69,72.76 66.08,72.76 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="85.98,66.14 92.6,66.14 92.6,72.82 85.98,72.82 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="99.21,66.14 105.83,66.14 105.83,72.82 99.21,72.82 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="112.44,66.14 119.06,66.14 119.06,72.76 112.44,72.76 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="125.67,66.14 132.28,66.14 132.28,72.82 125.67,72.82 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="138.9,66.14 145.51,66.14 145.51,72.82 138.9,72.82 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="13.23,72.69 19.91,72.69 19.84,79.37 13.23,79.37 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="19.78,72.69 26.52,72.69 26.39,79.37 19.78,79.37 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="26.39,72.69 33.07,72.69 33,79.44 26.39,79.44 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="46.3,72.76 52.91,72.76 52.91,79.44 46.3,79.44 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="59.53,72.69 66.14,72.69 66.14,79.37 59.53,79.37 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="72.76,72.76 79.37,72.76 79.37,79.44 72.76,79.44 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="85.98,72.69 92.66,72.69 92.6,79.37 85.98,79.37 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="92.53,72.76 99.28,72.76 99.15,79.44 92.53,79.44 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="99.15,72.69 105.89,72.69 105.76,79.37 99.15,79.37 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="105.76,72.76 112.44,72.76 112.37,79.44 105.76,79.44 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="125.67,72.69 132.35,72.69 132.28,79.44 125.67,79.44 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="132.22,72.76 138.96,72.76 138.83,79.37 132.22,79.37 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="138.83,72.69 145.58,72.69 145.45,79.37 138.83,79.37 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="145.45,72.76 152.13,72.76 152.06,79.44 145.45,79.44 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="26.46,79.3 33.07,79.3 33.07,85.98 26.46,85.98 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="39.69,79.37 46.37,79.37 46.3,85.98 39.69,85.98 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="46.23,79.3 52.98,79.3 52.85,85.98 46.23,85.98 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="52.85,79.37 59.53,79.37 59.46,85.98 52.85,85.98 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="66.14,79.37 72.82,79.37 72.76,85.98 66.14,85.98 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="72.69,79.3 79.37,79.3 79.3,85.98 72.69,85.98 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="92.6,79.3 99.21,79.3 99.21,86.05 92.6,86.05 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="105.83,79.3 112.51,79.3 112.44,86.05 105.83,86.05 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="112.37,79.37 119.06,79.37 118.99,85.98 112.37,85.98 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="125.67,79.3 132.28,79.3 132.28,85.98 125.67,85.98 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="145.51,79.3 152.13,79.3 152.13,86.05 145.51,86.05 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="13.23,85.98 19.84,85.98 19.84,92.6 13.23,92.6 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="33.07,85.98 39.69,85.98 39.69,92.66 33.07,92.66 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="85.98,85.98 92.66,85.98 92.6,92.6 85.98,92.6 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="92.53,85.92 99.28,85.92 99.15,92.66 92.53,92.66 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="99.15,85.98 105.89,85.98 105.76,92.6 99.15,92.6 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="105.76,85.92 112.44,85.92 112.37,92.6 105.76,92.6 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="132.28,85.98 138.96,85.98 138.9,92.6 132.28,92.6 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="138.83,85.98 145.58,85.98 145.45,92.66 138.83,92.66 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="145.45,85.92 152.13,85.92 152.06,92.6 145.45,92.6 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="19.84,92.6 26.46,92.6 26.46,99.21 19.84,99.21 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="33.07,92.53 39.75,92.53 39.69,99.21 33.07,99.21 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="39.62,92.6 46.3,92.6 46.23,99.21 39.62,99.21 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="52.91,92.6 59.53,92.6 59.53,99.21 52.91,99.21 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="66.14,92.6 72.82,92.6 72.76,99.28 66.14,99.28 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="72.69,92.6 79.37,92.6 79.3,99.21 72.69,99.21 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="92.6,92.53 99.21,92.53 99.21,99.28 92.6,99.28 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="112.44,92.6 119.06,92.6 119.06,99.28 112.44,99.28 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="138.9,92.53 145.51,92.53 145.51,99.21 138.9,99.21 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="66.14,99.15 72.76,99.15 72.76,105.89 66.14,105.89 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="79.37,99.21 85.98,99.21 85.98,105.83 79.37,105.83 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="92.6,99.15 99.21,99.15 99.21,105.83 92.6,105.83 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="112.44,99.15 119.06,99.15 119.06,105.83 112.44,105.83 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="132.28,99.21 138.9,99.21 138.9,105.83 132.28,105.83 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="66.14,105.76 72.76,105.76 72.76,112.44 66.14,112.44 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="85.98,105.83 92.6,105.83 92.6,112.44 85.98,112.44 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="99.21,105.83 105.83,105.83 105.83,112.44 99.21,112.44 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="119.06,105.83 125.74,105.83 125.67,112.51 119.06,112.51 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="125.6,105.83 132.28,105.83 132.22,112.44 125.6,112.44 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="138.9,105.83 145.58,105.83 145.51,112.44 138.9,112.44 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="145.45,105.83 152.13,105.83 152.06,112.51 145.45,112.51 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="72.76,112.44 79.44,112.44 79.37,119.12 72.76,119.12 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="79.3,112.44 85.98,112.44 85.92,119.12 79.3,119.12 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="112.44,112.44 119.12,112.44 119.06,119.06 112.44,119.06 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="118.99,112.37 125.67,112.37 125.6,119.12 118.99,119.12 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="132.28,112.44 138.9,112.44 138.9,119.12 132.28,119.12 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="145.51,112.37 152.13,112.37 152.13,119.06 145.51,119.06 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="66.14,119.06 72.82,119.06 72.76,125.74 66.14,125.74 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="72.69,118.99 79.44,118.99 79.3,125.74 72.69,125.74 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="79.3,118.99 86.05,118.99 85.92,125.67 79.3,125.67 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="85.92,119.06 92.6,119.06 92.53,125.74 85.92,125.74 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="99.21,119.06 105.83,119.06 105.83,125.74 99.21,125.74 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="119.06,118.99 125.74,118.99 125.67,125.67 119.06,125.67 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="125.6,119.06 132.35,119.06 132.22,125.74 125.6,125.74 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="132.22,118.99 138.9,118.99 138.83,125.74 132.22,125.74 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="66.14,125.6 72.82,125.6 72.76,132.35 66.14,132.35 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="72.69,125.6 79.37,125.6 79.3,132.35 72.69,132.35 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="85.98,125.6 92.66,125.6 92.6,132.28 85.98,132.28 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="92.53,125.67 99.28,125.67 99.15,132.35 92.53,132.35 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="99.15,125.6 105.89,125.6 105.76,132.28 99.15,132.28 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="105.76,125.67 112.51,125.67 112.37,132.35 105.76,132.35 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="112.37,125.67 119.06,125.67 118.99,132.35 112.37,132.35 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="125.67,125.6 132.35,125.6 132.28,132.35 125.67,132.35 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="132.22,125.6 138.9,125.6 138.83,132.35 132.22,132.35 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="66.14,132.22 72.82,132.22 72.76,138.96 66.14,138.96 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="72.69,132.22 79.37,132.22 79.3,138.9 72.69,138.9 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="92.6,132.22 99.21,132.22 99.21,138.96 92.6,138.96 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="105.83,132.22 112.51,132.22 112.44,138.96 105.83,138.96 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="112.37,132.22 119.06,132.22 118.99,138.96 112.37,138.96 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="125.67,132.22 132.35,132.22 132.28,138.9 125.67,138.9 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="132.22,132.22 138.9,132.22 138.83,138.96 132.22,138.96 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="66.14,138.83 72.76,138.83 72.76,145.58 66.14,145.58 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="79.37,138.9 86.05,138.9 85.98,145.58 79.37,145.58 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="85.92,138.9 92.66,138.9 92.53,145.51 85.92,145.51 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="92.53,138.83 99.28,138.83 99.15,145.58 92.53,145.58 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="99.15,138.9 105.89,138.9 105.76,145.51 99.15,145.51 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="105.76,138.83 112.51,138.83 112.37,145.51 105.76,145.51 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="112.37,138.83 119.12,138.83 118.99,145.58 112.37,145.58 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="118.99,138.9 125.67,138.9 125.6,145.51 118.99,145.51 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="132.28,138.83 138.96,138.83 138.9,145.58 132.28,145.58 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="138.83,138.9 145.51,138.9 145.45,145.51 138.83,145.51 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="66.14,145.45 72.82,145.45 72.76,152.13 66.14,152.13 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="72.69,145.51 79.44,145.51 79.3,152.13 72.69,152.13 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="79.3,145.45 85.98,145.45 85.92,152.13 79.3,152.13 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="92.6,145.45 99.21,145.45 99.21,152.13 92.6,152.13 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="112.44,145.45 119.06,145.45 119.06,152.13 112.44,152.13 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
          <polygon
            points="132.28,145.45 138.9,145.45 138.9,152.13 132.28,152.13 "
            style="fill:url(#hatch66b57d3d484547528ac58fe19b915123);"
          />
      `,
            },
            {
                value: 11,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(38,38,38,1);"
            shape-rendering="crispEdges"
          />
          <pattern
            id="glassecd873593fe44878b761241d367e9637"
            x="13.22835"
            y="13.22835"
            width="138.8976"
            height="138.8976"
            patternUnits="userSpaceOnUse"
          >
            <rect x="0" y="0" width="138.8976" height="138.8976" style="fill:rgb(204,193,217);fill-opacity:1;" />
            <rect x="0" y="0" width="138.8976" height="69.44881" style="fill:rgb(210,199,223);fill-opacity:1;" />
          </pattern>
          <polygon
            points="13.23,13.23 59.53,13.23 59.53,59.53 13.23,59.53 13.23,19.78 19.84,19.78 19.84,52.91 52.91,52.91 52.91,19.84 13.23,19.84 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="13.23,105.83 59.53,105.83 59.53,152.13 13.23,152.13 13.23,112.37 19.84,112.37 19.84,145.51 52.91,145.51 52.91,112.44 13.23,112.44 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="105.83,13.23 152.13,13.23 152.13,59.53 105.83,59.53 105.83,19.78 112.44,19.78 112.44,52.91 145.51,52.91 145.51,19.84 105.83,19.84 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="26.46,26.46 46.3,26.46 46.3,46.3 26.46,46.3 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="26.46,119.06 46.3,119.06 46.3,138.9 26.46,138.9 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="119.06,26.46 138.9,26.46 138.9,46.3 119.06,46.3 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="79.37,16.54 82.68,13.23 85.98,16.54 82.68,19.84 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="85.98,16.54 89.29,13.23 92.6,16.54 89.29,19.84 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="92.6,16.54 95.91,13.23 99.21,16.54 95.91,19.84 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="66.14,23.15 69.45,19.84 72.76,23.15 69.45,26.46 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="72.76,23.15 76.06,19.84 79.37,23.15 76.06,26.46 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="79.37,23.15 82.68,19.84 85.98,23.15 82.68,26.46 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="92.6,23.15 95.91,19.84 99.21,23.15 95.91,26.46 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="79.37,29.76 82.68,26.46 85.98,29.76 82.68,33.07 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="85.98,29.76 89.29,26.46 92.6,29.76 89.29,33.07 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="92.6,29.76 95.91,26.46 99.21,29.76 95.91,33.07 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="66.14,36.38 69.45,33.07 72.76,36.38 69.45,39.69 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="72.76,36.38 76.06,33.07 79.37,36.38 76.06,39.69 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="92.6,36.38 95.91,33.07 99.21,36.38 95.91,39.69 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="72.76,42.99 76.06,39.69 79.37,42.99 76.06,46.3 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="92.6,42.99 95.91,39.69 99.21,42.99 95.91,46.3 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="66.14,49.61 69.45,46.3 72.76,49.61 69.45,52.91 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="85.98,49.61 89.29,46.3 92.6,49.61 89.29,52.91 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="66.14,56.22 69.45,52.91 72.76,56.22 69.45,59.53 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="79.37,56.22 82.68,52.91 85.98,56.22 82.68,59.53 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="92.6,56.22 95.91,52.91 99.21,56.22 95.91,59.53 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="72.76,62.83 76.06,59.53 79.37,62.83 76.06,66.14 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="13.23,69.45 16.54,66.14 19.84,69.45 16.54,72.76 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="19.84,69.45 23.15,66.14 26.46,69.45 23.15,72.76 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="26.46,69.45 29.76,66.14 33.07,69.45 29.76,72.76 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="33.07,69.45 36.38,66.14 39.69,69.45 36.38,72.76 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="39.69,69.45 42.99,66.14 46.3,69.45 42.99,72.76 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="52.91,69.45 56.22,66.14 59.53,69.45 56.22,72.76 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="59.53,69.45 62.83,66.14 66.14,69.45 62.83,72.76 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="66.14,69.45 69.45,66.14 72.76,69.45 69.45,72.76 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="85.98,69.45 89.29,66.14 92.6,69.45 89.29,72.76 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="99.21,69.45 102.52,66.14 105.83,69.45 102.52,72.76 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="112.44,69.45 115.75,66.14 119.06,69.45 115.75,72.76 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="125.67,69.45 128.98,66.14 132.28,69.45 128.98,72.76 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="138.9,69.45 142.2,66.14 145.51,69.45 142.2,72.76 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="13.23,76.06 16.54,72.76 19.84,76.06 16.54,79.37 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="19.84,76.06 23.15,72.76 26.46,76.06 23.15,79.37 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="26.46,76.06 29.76,72.76 33.07,76.06 29.76,79.37 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="46.3,76.06 49.61,72.76 52.91,76.06 49.61,79.37 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="59.53,76.06 62.83,72.76 66.14,76.06 62.83,79.37 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="72.76,76.06 76.06,72.76 79.37,76.06 76.06,79.37 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="85.98,76.06 89.29,72.76 92.6,76.06 89.29,79.37 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="92.6,76.06 95.91,72.76 99.21,76.06 95.91,79.37 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="99.21,76.06 102.52,72.76 105.83,76.06 102.52,79.37 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="105.83,76.06 109.13,72.76 112.44,76.06 109.13,79.37 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="125.67,76.06 128.98,72.76 132.28,76.06 128.98,79.37 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="132.28,76.06 135.59,72.76 138.9,76.06 135.59,79.37 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="138.9,76.06 142.2,72.76 145.51,76.06 142.2,79.37 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="145.51,76.06 148.82,72.76 152.13,76.06 148.82,79.37 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="26.46,82.68 29.76,79.37 33.07,82.68 29.76,85.98 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="39.69,82.68 42.99,79.37 46.3,82.68 42.99,85.98 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="46.3,82.68 49.61,79.37 52.91,82.68 49.61,85.98 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="52.91,82.68 56.22,79.37 59.53,82.68 56.22,85.98 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="66.14,82.68 69.45,79.37 72.76,82.68 69.45,85.98 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="72.76,82.68 76.06,79.37 79.37,82.68 76.06,85.98 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="92.6,82.68 95.91,79.37 99.21,82.68 95.91,85.98 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="105.83,82.68 109.13,79.37 112.44,82.68 109.13,85.98 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="112.44,82.68 115.75,79.37 119.06,82.68 115.75,85.98 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="125.67,82.68 128.98,79.37 132.28,82.68 128.98,85.98 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="145.51,82.68 148.82,79.37 152.13,82.68 148.82,85.98 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="13.23,89.29 16.54,85.98 19.84,89.29 16.54,92.6 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="33.07,89.29 36.38,85.98 39.69,89.29 36.38,92.6 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="85.98,89.29 89.29,85.98 92.6,89.29 89.29,92.6 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="92.6,89.29 95.91,85.98 99.21,89.29 95.91,92.6 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="99.21,89.29 102.52,85.98 105.83,89.29 102.52,92.6 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="105.83,89.29 109.13,85.98 112.44,89.29 109.13,92.6 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="132.28,89.29 135.59,85.98 138.9,89.29 135.59,92.6 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="138.9,89.29 142.2,85.98 145.51,89.29 142.2,92.6 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="145.51,89.29 148.82,85.98 152.13,89.29 148.82,92.6 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="19.84,95.91 23.15,92.6 26.46,95.91 23.15,99.21 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="33.07,95.91 36.38,92.6 39.69,95.91 36.38,99.21 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="39.69,95.91 42.99,92.6 46.3,95.91 42.99,99.21 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="52.91,95.91 56.22,92.6 59.53,95.91 56.22,99.21 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="66.14,95.91 69.45,92.6 72.76,95.91 69.45,99.21 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="72.76,95.91 76.06,92.6 79.37,95.91 76.06,99.21 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="92.6,95.91 95.91,92.6 99.21,95.91 95.91,99.21 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="112.44,95.91 115.75,92.6 119.06,95.91 115.75,99.21 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="138.9,95.91 142.2,92.6 145.51,95.91 142.2,99.21 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="66.14,102.52 69.45,99.21 72.76,102.52 69.45,105.83 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="79.37,102.52 82.68,99.21 85.98,102.52 82.68,105.83 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="92.6,102.52 95.91,99.21 99.21,102.52 95.91,105.83 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="112.44,102.52 115.75,99.21 119.06,102.52 115.75,105.83 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="132.28,102.52 135.59,99.21 138.9,102.52 135.59,105.83 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="66.14,109.13 69.45,105.83 72.76,109.13 69.45,112.44 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="85.98,109.13 89.29,105.83 92.6,109.13 89.29,112.44 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="99.21,109.13 102.52,105.83 105.83,109.13 102.52,112.44 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="119.06,109.13 122.36,105.83 125.67,109.13 122.36,112.44 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="125.67,109.13 128.98,105.83 132.28,109.13 128.98,112.44 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="138.9,109.13 142.2,105.83 145.51,109.13 142.2,112.44 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="145.51,109.13 148.82,105.83 152.13,109.13 148.82,112.44 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="72.76,115.75 76.06,112.44 79.37,115.75 76.06,119.06 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="79.37,115.75 82.68,112.44 85.98,115.75 82.68,119.06 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="112.44,115.75 115.75,112.44 119.06,115.75 115.75,119.06 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="119.06,115.75 122.36,112.44 125.67,115.75 122.36,119.06 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="132.28,115.75 135.59,112.44 138.9,115.75 135.59,119.06 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="145.51,115.75 148.82,112.44 152.13,115.75 148.82,119.06 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="66.14,122.36 69.45,119.06 72.76,122.36 69.45,125.67 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="72.76,122.36 76.06,119.06 79.37,122.36 76.06,125.67 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="79.37,122.36 82.68,119.06 85.98,122.36 82.68,125.67 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="85.98,122.36 89.29,119.06 92.6,122.36 89.29,125.67 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="99.21,122.36 102.52,119.06 105.83,122.36 102.52,125.67 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="119.06,122.36 122.36,119.06 125.67,122.36 122.36,125.67 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="125.67,122.36 128.98,119.06 132.28,122.36 128.98,125.67 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="132.28,122.36 135.59,119.06 138.9,122.36 135.59,125.67 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="66.14,128.98 69.45,125.67 72.76,128.98 69.45,132.28 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="72.76,128.98 76.06,125.67 79.37,128.98 76.06,132.28 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="85.98,128.98 89.29,125.67 92.6,128.98 89.29,132.28 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="92.6,128.98 95.91,125.67 99.21,128.98 95.91,132.28 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="99.21,128.98 102.52,125.67 105.83,128.98 102.52,132.28 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="105.83,128.98 109.13,125.67 112.44,128.98 109.13,132.28 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="112.44,128.98 115.75,125.67 119.06,128.98 115.75,132.28 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="125.67,128.98 128.98,125.67 132.28,128.98 128.98,132.28 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="132.28,128.98 135.59,125.67 138.9,128.98 135.59,132.28 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="66.14,135.59 69.45,132.28 72.76,135.59 69.45,138.9 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="72.76,135.59 76.06,132.28 79.37,135.59 76.06,138.9 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="92.6,135.59 95.91,132.28 99.21,135.59 95.91,138.9 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="105.83,135.59 109.13,132.28 112.44,135.59 109.13,138.9 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="112.44,135.59 115.75,132.28 119.06,135.59 115.75,138.9 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="125.67,135.59 128.98,132.28 132.28,135.59 128.98,138.9 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="132.28,135.59 135.59,132.28 138.9,135.59 135.59,138.9 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="66.14,142.2 69.45,138.9 72.76,142.2 69.45,145.51 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="79.37,142.2 82.68,138.9 85.98,142.2 82.68,145.51 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="85.98,142.2 89.29,138.9 92.6,142.2 89.29,145.51 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="92.6,142.2 95.91,138.9 99.21,142.2 95.91,145.51 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="99.21,142.2 102.52,138.9 105.83,142.2 102.52,145.51 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="105.83,142.2 109.13,138.9 112.44,142.2 109.13,145.51 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="112.44,142.2 115.75,138.9 119.06,142.2 115.75,145.51 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="119.06,142.2 122.36,138.9 125.67,142.2 122.36,145.51 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="132.28,142.2 135.59,138.9 138.9,142.2 135.59,145.51 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="138.9,142.2 142.2,138.9 145.51,142.2 142.2,145.51 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="66.14,148.82 69.45,145.51 72.76,148.82 69.45,152.13 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="72.76,148.82 76.06,145.51 79.37,148.82 76.06,152.13 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="79.37,148.82 82.68,145.51 85.98,148.82 82.68,152.13 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="92.6,148.82 95.91,145.51 99.21,148.82 95.91,152.13 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="112.44,148.82 115.75,145.51 119.06,148.82 115.75,152.13 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
          <polygon
            points="132.28,148.82 135.59,145.51 138.9,148.82 135.59,152.13 "
            style="fill:url(#glassecd873593fe44878b761241d367e9637);"
          />
      `,
            },
            {
                value: 12,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(37,86,99,1);"
            shape-rendering="crispEdges"
          />
          <linearGradient
            id="gradient89acb651ebd041c6bd575d3854178b85"
            gradientUnits="userSpaceOnUse"
            x1="8.73357798631972"
            y1="77.5065212907663"
            x2="156.620742539803"
            y2="87.8477992353567"
          >
            <stop offset="0%" stop-color="#FF93FB" />
            <stop offset="100%" stop-color="#92D050" />
          </linearGradient>
          <polygon
            points="19.84,16.54 19.59,17.8 18.87,18.87 17.8,19.59 16.54,19.84 15.27,19.59 14.2,18.87 13.48,17.8 13.23,16.54 13.48,15.27 14.2,14.2 15.27,13.48 16.54,13.23 17.8,13.48 18.87,14.2 19.59,15.27 19.84,16.54 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="19.84,56.22 19.59,57.49 18.87,58.56 17.8,59.28 16.54,59.53 15.27,59.28 14.2,58.56 13.48,57.49 13.23,56.22 13.48,54.95 14.2,53.88 15.27,53.17 16.54,52.91 17.8,53.17 18.87,53.88 19.59,54.95 19.84,56.22 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="26.46,16.54 26.2,17.8 25.49,18.87 24.42,19.59 23.15,19.84 21.88,19.59 20.81,18.87 20.09,17.8 19.84,16.54 20.09,15.27 20.81,14.2 21.88,13.48 23.15,13.23 24.42,13.48 25.49,14.2 26.2,15.27 26.46,16.54 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="26.46,56.22 26.2,57.49 25.49,58.56 24.42,59.28 23.15,59.53 21.88,59.28 20.81,58.56 20.09,57.49 19.84,56.22 20.09,54.95 20.81,53.88 21.88,53.17 23.15,52.91 24.42,53.17 25.49,53.88 26.2,54.95 26.46,56.22 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="33.07,16.54 32.82,17.8 32.1,18.87 31.03,19.59 29.76,19.84 28.5,19.59 27.43,18.87 26.71,17.8 26.46,16.54 26.71,15.27 27.43,14.2 28.5,13.48 29.76,13.23 31.03,13.48 32.1,14.2 32.82,15.27 33.07,16.54 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="33.07,56.22 32.82,57.49 32.1,58.56 31.03,59.28 29.76,59.53 28.5,59.28 27.43,58.56 26.71,57.49 26.46,56.22 26.71,54.95 27.43,53.88 28.5,53.17 29.76,52.91 31.03,53.17 32.1,53.88 32.82,54.95 33.07,56.22 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="39.69,16.54 39.43,17.8 38.72,18.87 37.64,19.59 36.38,19.84 35.11,19.59 34.04,18.87 33.32,17.8 33.07,16.54 33.32,15.27 34.04,14.2 35.11,13.48 36.38,13.23 37.64,13.48 38.72,14.2 39.43,15.27 39.69,16.54 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="39.69,56.22 39.43,57.49 38.72,58.56 37.64,59.28 36.38,59.53 35.11,59.28 34.04,58.56 33.32,57.49 33.07,56.22 33.32,54.95 34.04,53.88 35.11,53.17 36.38,52.91 37.64,53.17 38.72,53.88 39.43,54.95 39.69,56.22 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="46.3,16.54 46.05,17.8 45.33,18.87 44.26,19.59 42.99,19.84 41.73,19.59 40.65,18.87 39.94,17.8 39.69,16.54 39.94,15.27 40.65,14.2 41.73,13.48 42.99,13.23 44.26,13.48 45.33,14.2 46.05,15.27 46.3,16.54 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="46.3,56.22 46.05,57.49 45.33,58.56 44.26,59.28 42.99,59.53 41.73,59.28 40.65,58.56 39.94,57.49 39.69,56.22 39.94,54.95 40.65,53.88 41.73,53.17 42.99,52.91 44.26,53.17 45.33,53.88 46.05,54.95 46.3,56.22 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="52.91,16.54 52.66,17.8 51.94,18.87 50.87,19.59 49.61,19.84 48.34,19.59 47.27,18.87 46.55,17.8 46.3,16.54 46.55,15.27 47.27,14.2 48.34,13.48 49.61,13.23 50.87,13.48 51.94,14.2 52.66,15.27 52.91,16.54 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="52.91,56.22 52.66,57.49 51.94,58.56 50.87,59.28 49.61,59.53 48.34,59.28 47.27,58.56 46.55,57.49 46.3,56.22 46.55,54.95 47.27,53.88 48.34,53.17 49.61,52.91 50.87,53.17 51.94,53.88 52.66,54.95 52.91,56.22 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="59.53,16.54 59.28,17.8 58.56,18.87 57.49,19.59 56.22,19.84 54.95,19.59 53.88,18.87 53.17,17.8 52.91,16.54 53.17,15.27 53.88,14.2 54.95,13.48 56.22,13.23 57.49,13.48 58.56,14.2 59.28,15.27 59.53,16.54 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="59.53,56.22 59.28,57.49 58.56,58.56 57.49,59.28 56.22,59.53 54.95,59.28 53.88,58.56 53.17,57.49 52.91,56.22 53.17,54.95 53.88,53.88 54.95,53.17 56.22,52.91 57.49,53.17 58.56,53.88 59.28,54.95 59.53,56.22 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="19.84,23.15 19.59,24.42 18.87,25.49 17.8,26.2 16.54,26.46 15.27,26.2 14.2,25.49 13.48,24.42 13.23,23.15 13.48,21.88 14.2,20.81 15.27,20.09 16.54,19.84 17.8,20.09 18.87,20.81 19.59,21.88 19.84,23.15 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="59.53,23.15 59.28,24.42 58.56,25.49 57.49,26.2 56.22,26.46 54.95,26.2 53.88,25.49 53.17,24.42 52.91,23.15 53.17,21.88 53.88,20.81 54.95,20.09 56.22,19.84 57.49,20.09 58.56,20.81 59.28,21.88 59.53,23.15 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="19.84,29.76 19.59,31.03 18.87,32.1 17.8,32.82 16.54,33.07 15.27,32.82 14.2,32.1 13.48,31.03 13.23,29.76 13.48,28.5 14.2,27.43 15.27,26.71 16.54,26.46 17.8,26.71 18.87,27.43 19.59,28.5 19.84,29.76 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="59.53,29.76 59.28,31.03 58.56,32.1 57.49,32.82 56.22,33.07 54.95,32.82 53.88,32.1 53.17,31.03 52.91,29.76 53.17,28.5 53.88,27.43 54.95,26.71 56.22,26.46 57.49,26.71 58.56,27.43 59.28,28.5 59.53,29.76 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="19.84,36.38 19.59,37.64 18.87,38.72 17.8,39.43 16.54,39.69 15.27,39.43 14.2,38.72 13.48,37.64 13.23,36.38 13.48,35.11 14.2,34.04 15.27,33.32 16.54,33.07 17.8,33.32 18.87,34.04 19.59,35.11 19.84,36.38 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="59.53,36.38 59.28,37.64 58.56,38.72 57.49,39.43 56.22,39.69 54.95,39.43 53.88,38.72 53.17,37.64 52.91,36.38 53.17,35.11 53.88,34.04 54.95,33.32 56.22,33.07 57.49,33.32 58.56,34.04 59.28,35.11 59.53,36.38 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="19.84,42.99 19.59,44.26 18.87,45.33 17.8,46.05 16.54,46.3 15.27,46.05 14.2,45.33 13.48,44.26 13.23,42.99 13.48,41.73 14.2,40.65 15.27,39.94 16.54,39.69 17.8,39.94 18.87,40.65 19.59,41.73 19.84,42.99 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="59.53,42.99 59.28,44.26 58.56,45.33 57.49,46.05 56.22,46.3 54.95,46.05 53.88,45.33 53.17,44.26 52.91,42.99 53.17,41.73 53.88,40.65 54.95,39.94 56.22,39.69 57.49,39.94 58.56,40.65 59.28,41.73 59.53,42.99 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="19.84,49.61 19.59,50.87 18.87,51.94 17.8,52.66 16.54,52.91 15.27,52.66 14.2,51.94 13.48,50.87 13.23,49.61 13.48,48.34 14.2,47.27 15.27,46.55 16.54,46.3 17.8,46.55 18.87,47.27 19.59,48.34 19.84,49.61 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="59.53,49.61 59.28,50.87 58.56,51.94 57.49,52.66 56.22,52.91 54.95,52.66 53.88,51.94 53.17,50.87 52.91,49.61 53.17,48.34 53.88,47.27 54.95,46.55 56.22,46.3 57.49,46.55 58.56,47.27 59.28,48.34 59.53,49.61 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="19.84,109.13 19.59,110.4 18.87,111.47 17.8,112.19 16.54,112.44 15.27,112.19 14.2,111.47 13.48,110.4 13.23,109.13 13.48,107.87 14.2,106.8 15.27,106.08 16.54,105.83 17.8,106.08 18.87,106.8 19.59,107.87 19.84,109.13 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="19.84,148.82 19.59,150.08 18.87,151.16 17.8,151.87 16.54,152.13 15.27,151.87 14.2,151.16 13.48,150.08 13.23,148.82 13.48,147.55 14.2,146.48 15.27,145.76 16.54,145.51 17.8,145.76 18.87,146.48 19.59,147.55 19.84,148.82 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="26.46,109.13 26.2,110.4 25.49,111.47 24.42,112.19 23.15,112.44 21.88,112.19 20.81,111.47 20.09,110.4 19.84,109.13 20.09,107.87 20.81,106.8 21.88,106.08 23.15,105.83 24.42,106.08 25.49,106.8 26.2,107.87 26.46,109.13 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="26.46,148.82 26.2,150.08 25.49,151.16 24.42,151.87 23.15,152.13 21.88,151.87 20.81,151.16 20.09,150.08 19.84,148.82 20.09,147.55 20.81,146.48 21.88,145.76 23.15,145.51 24.42,145.76 25.49,146.48 26.2,147.55 26.46,148.82 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="33.07,109.13 32.82,110.4 32.1,111.47 31.03,112.19 29.76,112.44 28.5,112.19 27.43,111.47 26.71,110.4 26.46,109.13 26.71,107.87 27.43,106.8 28.5,106.08 29.76,105.83 31.03,106.08 32.1,106.8 32.82,107.87 33.07,109.13 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="33.07,148.82 32.82,150.08 32.1,151.16 31.03,151.87 29.76,152.13 28.5,151.87 27.43,151.16 26.71,150.08 26.46,148.82 26.71,147.55 27.43,146.48 28.5,145.76 29.76,145.51 31.03,145.76 32.1,146.48 32.82,147.55 33.07,148.82 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="39.69,109.13 39.43,110.4 38.72,111.47 37.64,112.19 36.38,112.44 35.11,112.19 34.04,111.47 33.32,110.4 33.07,109.13 33.32,107.87 34.04,106.8 35.11,106.08 36.38,105.83 37.64,106.08 38.72,106.8 39.43,107.87 39.69,109.13 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="39.69,148.82 39.43,150.08 38.72,151.16 37.64,151.87 36.38,152.13 35.11,151.87 34.04,151.16 33.32,150.08 33.07,148.82 33.32,147.55 34.04,146.48 35.11,145.76 36.38,145.51 37.64,145.76 38.72,146.48 39.43,147.55 39.69,148.82 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="46.3,109.13 46.05,110.4 45.33,111.47 44.26,112.19 42.99,112.44 41.73,112.19 40.65,111.47 39.94,110.4 39.69,109.13 39.94,107.87 40.65,106.8 41.73,106.08 42.99,105.83 44.26,106.08 45.33,106.8 46.05,107.87 46.3,109.13 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="46.3,148.82 46.05,150.08 45.33,151.16 44.26,151.87 42.99,152.13 41.73,151.87 40.65,151.16 39.94,150.08 39.69,148.82 39.94,147.55 40.65,146.48 41.73,145.76 42.99,145.51 44.26,145.76 45.33,146.48 46.05,147.55 46.3,148.82 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="52.91,109.13 52.66,110.4 51.94,111.47 50.87,112.19 49.61,112.44 48.34,112.19 47.27,111.47 46.55,110.4 46.3,109.13 46.55,107.87 47.27,106.8 48.34,106.08 49.61,105.83 50.87,106.08 51.94,106.8 52.66,107.87 52.91,109.13 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="52.91,148.82 52.66,150.08 51.94,151.16 50.87,151.87 49.61,152.13 48.34,151.87 47.27,151.16 46.55,150.08 46.3,148.82 46.55,147.55 47.27,146.48 48.34,145.76 49.61,145.51 50.87,145.76 51.94,146.48 52.66,147.55 52.91,148.82 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="59.53,109.13 59.28,110.4 58.56,111.47 57.49,112.19 56.22,112.44 54.95,112.19 53.88,111.47 53.17,110.4 52.91,109.13 53.17,107.87 53.88,106.8 54.95,106.08 56.22,105.83 57.49,106.08 58.56,106.8 59.28,107.87 59.53,109.13 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="59.53,148.82 59.28,150.08 58.56,151.16 57.49,151.87 56.22,152.13 54.95,151.87 53.88,151.16 53.17,150.08 52.91,148.82 53.17,147.55 53.88,146.48 54.95,145.76 56.22,145.51 57.49,145.76 58.56,146.48 59.28,147.55 59.53,148.82 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="19.84,115.75 19.59,117.01 18.87,118.09 17.8,118.8 16.54,119.06 15.27,118.8 14.2,118.09 13.48,117.01 13.23,115.75 13.48,114.48 14.2,113.41 15.27,112.69 16.54,112.44 17.8,112.69 18.87,113.41 19.59,114.48 19.84,115.75 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="59.53,115.75 59.28,117.01 58.56,118.09 57.49,118.8 56.22,119.06 54.95,118.8 53.88,118.09 53.17,117.01 52.91,115.75 53.17,114.48 53.88,113.41 54.95,112.69 56.22,112.44 57.49,112.69 58.56,113.41 59.28,114.48 59.53,115.75 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="19.84,122.36 19.59,123.63 18.87,124.7 17.8,125.42 16.54,125.67 15.27,125.42 14.2,124.7 13.48,123.63 13.23,122.36 13.48,121.1 14.2,120.02 15.27,119.31 16.54,119.06 17.8,119.31 18.87,120.02 19.59,121.1 19.84,122.36 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="59.53,122.36 59.28,123.63 58.56,124.7 57.49,125.42 56.22,125.67 54.95,125.42 53.88,124.7 53.17,123.63 52.91,122.36 53.17,121.1 53.88,120.02 54.95,119.31 56.22,119.06 57.49,119.31 58.56,120.02 59.28,121.1 59.53,122.36 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="19.84,128.98 19.59,130.24 18.87,131.31 17.8,132.03 16.54,132.28 15.27,132.03 14.2,131.31 13.48,130.24 13.23,128.98 13.48,127.71 14.2,126.64 15.27,125.92 16.54,125.67 17.8,125.92 18.87,126.64 19.59,127.71 19.84,128.98 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="59.53,128.98 59.28,130.24 58.56,131.31 57.49,132.03 56.22,132.28 54.95,132.03 53.88,131.31 53.17,130.24 52.91,128.98 53.17,127.71 53.88,126.64 54.95,125.92 56.22,125.67 57.49,125.92 58.56,126.64 59.28,127.71 59.53,128.98 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="19.84,135.59 19.59,136.86 18.87,137.93 17.8,138.65 16.54,138.9 15.27,138.65 14.2,137.93 13.48,136.86 13.23,135.59 13.48,134.32 14.2,133.25 15.27,132.54 16.54,132.28 17.8,132.54 18.87,133.25 19.59,134.32 19.84,135.59 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="59.53,135.59 59.28,136.86 58.56,137.93 57.49,138.65 56.22,138.9 54.95,138.65 53.88,137.93 53.17,136.86 52.91,135.59 53.17,134.32 53.88,133.25 54.95,132.54 56.22,132.28 57.49,132.54 58.56,133.25 59.28,134.32 59.53,135.59 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="19.84,142.2 19.59,143.47 18.87,144.54 17.8,145.26 16.54,145.51 15.27,145.26 14.2,144.54 13.48,143.47 13.23,142.2 13.48,140.94 14.2,139.87 15.27,139.15 16.54,138.9 17.8,139.15 18.87,139.87 19.59,140.94 19.84,142.2 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="59.53,142.2 59.28,143.47 58.56,144.54 57.49,145.26 56.22,145.51 54.95,145.26 53.88,144.54 53.17,143.47 52.91,142.2 53.17,140.94 53.88,139.87 54.95,139.15 56.22,138.9 57.49,139.15 58.56,139.87 59.28,140.94 59.53,142.2 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="112.44,16.54 112.19,17.8 111.47,18.87 110.4,19.59 109.13,19.84 107.87,19.59 106.8,18.87 106.08,17.8 105.83,16.54 106.08,15.27 106.8,14.2 107.87,13.48 109.13,13.23 110.4,13.48 111.47,14.2 112.19,15.27 112.44,16.54 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="112.44,56.22 112.19,57.49 111.47,58.56 110.4,59.28 109.13,59.53 107.87,59.28 106.8,58.56 106.08,57.49 105.83,56.22 106.08,54.95 106.8,53.88 107.87,53.17 109.13,52.91 110.4,53.17 111.47,53.88 112.19,54.95 112.44,56.22 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="119.06,16.54 118.8,17.8 118.09,18.87 117.01,19.59 115.75,19.84 114.48,19.59 113.41,18.87 112.69,17.8 112.44,16.54 112.69,15.27 113.41,14.2 114.48,13.48 115.75,13.23 117.01,13.48 118.09,14.2 118.8,15.27 119.06,16.54 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="119.06,56.22 118.8,57.49 118.09,58.56 117.01,59.28 115.75,59.53 114.48,59.28 113.41,58.56 112.69,57.49 112.44,56.22 112.69,54.95 113.41,53.88 114.48,53.17 115.75,52.91 117.01,53.17 118.09,53.88 118.8,54.95 119.06,56.22 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="125.67,16.54 125.42,17.8 124.7,18.87 123.63,19.59 122.36,19.84 121.1,19.59 120.02,18.87 119.31,17.8 119.06,16.54 119.31,15.27 120.02,14.2 121.1,13.48 122.36,13.23 123.63,13.48 124.7,14.2 125.42,15.27 125.67,16.54 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="125.67,56.22 125.42,57.49 124.7,58.56 123.63,59.28 122.36,59.53 121.1,59.28 120.02,58.56 119.31,57.49 119.06,56.22 119.31,54.95 120.02,53.88 121.1,53.17 122.36,52.91 123.63,53.17 124.7,53.88 125.42,54.95 125.67,56.22 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="132.28,16.54 132.03,17.8 131.31,18.87 130.24,19.59 128.98,19.84 127.71,19.59 126.64,18.87 125.92,17.8 125.67,16.54 125.92,15.27 126.64,14.2 127.71,13.48 128.98,13.23 130.24,13.48 131.31,14.2 132.03,15.27 132.28,16.54 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="132.28,56.22 132.03,57.49 131.31,58.56 130.24,59.28 128.98,59.53 127.71,59.28 126.64,58.56 125.92,57.49 125.67,56.22 125.92,54.95 126.64,53.88 127.71,53.17 128.98,52.91 130.24,53.17 131.31,53.88 132.03,54.95 132.28,56.22 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="138.9,16.54 138.65,17.8 137.93,18.87 136.86,19.59 135.59,19.84 134.32,19.59 133.25,18.87 132.54,17.8 132.28,16.54 132.54,15.27 133.25,14.2 134.32,13.48 135.59,13.23 136.86,13.48 137.93,14.2 138.65,15.27 138.9,16.54 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="138.9,56.22 138.65,57.49 137.93,58.56 136.86,59.28 135.59,59.53 134.32,59.28 133.25,58.56 132.54,57.49 132.28,56.22 132.54,54.95 133.25,53.88 134.32,53.17 135.59,52.91 136.86,53.17 137.93,53.88 138.65,54.95 138.9,56.22 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="145.51,16.54 145.26,17.8 144.54,18.87 143.47,19.59 142.2,19.84 140.94,19.59 139.87,18.87 139.15,17.8 138.9,16.54 139.15,15.27 139.87,14.2 140.94,13.48 142.2,13.23 143.47,13.48 144.54,14.2 145.26,15.27 145.51,16.54 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="145.51,56.22 145.26,57.49 144.54,58.56 143.47,59.28 142.2,59.53 140.94,59.28 139.87,58.56 139.15,57.49 138.9,56.22 139.15,54.95 139.87,53.88 140.94,53.17 142.2,52.91 143.47,53.17 144.54,53.88 145.26,54.95 145.51,56.22 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="152.13,16.54 151.87,17.8 151.16,18.87 150.08,19.59 148.82,19.84 147.55,19.59 146.48,18.87 145.76,17.8 145.51,16.54 145.76,15.27 146.48,14.2 147.55,13.48 148.82,13.23 150.08,13.48 151.16,14.2 151.87,15.27 152.13,16.54 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="152.13,56.22 151.87,57.49 151.16,58.56 150.08,59.28 148.82,59.53 147.55,59.28 146.48,58.56 145.76,57.49 145.51,56.22 145.76,54.95 146.48,53.88 147.55,53.17 148.82,52.91 150.08,53.17 151.16,53.88 151.87,54.95 152.13,56.22 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="112.44,23.15 112.19,24.42 111.47,25.49 110.4,26.2 109.13,26.46 107.87,26.2 106.8,25.49 106.08,24.42 105.83,23.15 106.08,21.88 106.8,20.81 107.87,20.09 109.13,19.84 110.4,20.09 111.47,20.81 112.19,21.88 112.44,23.15 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="152.13,23.15 151.87,24.42 151.16,25.49 150.08,26.2 148.82,26.46 147.55,26.2 146.48,25.49 145.76,24.42 145.51,23.15 145.76,21.88 146.48,20.81 147.55,20.09 148.82,19.84 150.08,20.09 151.16,20.81 151.87,21.88 152.13,23.15 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="112.44,29.76 112.19,31.03 111.47,32.1 110.4,32.82 109.13,33.07 107.87,32.82 106.8,32.1 106.08,31.03 105.83,29.76 106.08,28.5 106.8,27.43 107.87,26.71 109.13,26.46 110.4,26.71 111.47,27.43 112.19,28.5 112.44,29.76 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="152.13,29.76 151.87,31.03 151.16,32.1 150.08,32.82 148.82,33.07 147.55,32.82 146.48,32.1 145.76,31.03 145.51,29.76 145.76,28.5 146.48,27.43 147.55,26.71 148.82,26.46 150.08,26.71 151.16,27.43 151.87,28.5 152.13,29.76 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="112.44,36.38 112.19,37.64 111.47,38.72 110.4,39.43 109.13,39.69 107.87,39.43 106.8,38.72 106.08,37.64 105.83,36.38 106.08,35.11 106.8,34.04 107.87,33.32 109.13,33.07 110.4,33.32 111.47,34.04 112.19,35.11 112.44,36.38 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="152.13,36.38 151.87,37.64 151.16,38.72 150.08,39.43 148.82,39.69 147.55,39.43 146.48,38.72 145.76,37.64 145.51,36.38 145.76,35.11 146.48,34.04 147.55,33.32 148.82,33.07 150.08,33.32 151.16,34.04 151.87,35.11 152.13,36.38 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="112.44,42.99 112.19,44.26 111.47,45.33 110.4,46.05 109.13,46.3 107.87,46.05 106.8,45.33 106.08,44.26 105.83,42.99 106.08,41.73 106.8,40.65 107.87,39.94 109.13,39.69 110.4,39.94 111.47,40.65 112.19,41.73 112.44,42.99 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="152.13,42.99 151.87,44.26 151.16,45.33 150.08,46.05 148.82,46.3 147.55,46.05 146.48,45.33 145.76,44.26 145.51,42.99 145.76,41.73 146.48,40.65 147.55,39.94 148.82,39.69 150.08,39.94 151.16,40.65 151.87,41.73 152.13,42.99 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="112.44,49.61 112.19,50.87 111.47,51.94 110.4,52.66 109.13,52.91 107.87,52.66 106.8,51.94 106.08,50.87 105.83,49.61 106.08,48.34 106.8,47.27 107.87,46.55 109.13,46.3 110.4,46.55 111.47,47.27 112.19,48.34 112.44,49.61 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="152.13,49.61 151.87,50.87 151.16,51.94 150.08,52.66 148.82,52.91 147.55,52.66 146.48,51.94 145.76,50.87 145.51,49.61 145.76,48.34 146.48,47.27 147.55,46.55 148.82,46.3 150.08,46.55 151.16,47.27 151.87,48.34 152.13,49.61 "
            style="fill:url(#gradient89acb651ebd041c6bd575d3854178b85);"
          />
          <polygon
            points="33.07,29.76 32.82,31.03 32.1,32.1 31.03,32.82 29.76,33.07 28.5,32.82 27.43,32.1 26.71,31.03 26.46,29.76 26.71,28.5 27.43,27.43 28.5,26.71 29.76,26.46 31.03,26.71 32.1,27.43 32.82,28.5 33.07,29.76 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="39.69,29.76 39.43,31.03 38.72,32.1 37.64,32.82 36.38,33.07 35.11,32.82 34.04,32.1 33.32,31.03 33.07,29.76 33.32,28.5 34.04,27.43 35.11,26.71 36.38,26.46 37.64,26.71 38.72,27.43 39.43,28.5 39.69,29.76 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="46.3,29.76 46.05,31.03 45.33,32.1 44.26,32.82 42.99,33.07 41.73,32.82 40.65,32.1 39.94,31.03 39.69,29.76 39.94,28.5 40.65,27.43 41.73,26.71 42.99,26.46 44.26,26.71 45.33,27.43 46.05,28.5 46.3,29.76 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="33.07,36.38 32.82,37.64 32.1,38.72 31.03,39.43 29.76,39.69 28.5,39.43 27.43,38.72 26.71,37.64 26.46,36.38 26.71,35.11 27.43,34.04 28.5,33.32 29.76,33.07 31.03,33.32 32.1,34.04 32.82,35.11 33.07,36.38 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="39.69,36.38 39.43,37.64 38.72,38.72 37.64,39.43 36.38,39.69 35.11,39.43 34.04,38.72 33.32,37.64 33.07,36.38 33.32,35.11 34.04,34.04 35.11,33.32 36.38,33.07 37.64,33.32 38.72,34.04 39.43,35.11 39.69,36.38 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="46.3,36.38 46.05,37.64 45.33,38.72 44.26,39.43 42.99,39.69 41.73,39.43 40.65,38.72 39.94,37.64 39.69,36.38 39.94,35.11 40.65,34.04 41.73,33.32 42.99,33.07 44.26,33.32 45.33,34.04 46.05,35.11 46.3,36.38 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="33.07,42.99 32.82,44.26 32.1,45.33 31.03,46.05 29.76,46.3 28.5,46.05 27.43,45.33 26.71,44.26 26.46,42.99 26.71,41.73 27.43,40.65 28.5,39.94 29.76,39.69 31.03,39.94 32.1,40.65 32.82,41.73 33.07,42.99 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="39.69,42.99 39.43,44.26 38.72,45.33 37.64,46.05 36.38,46.3 35.11,46.05 34.04,45.33 33.32,44.26 33.07,42.99 33.32,41.73 34.04,40.65 35.11,39.94 36.38,39.69 37.64,39.94 38.72,40.65 39.43,41.73 39.69,42.99 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="46.3,42.99 46.05,44.26 45.33,45.33 44.26,46.05 42.99,46.3 41.73,46.05 40.65,45.33 39.94,44.26 39.69,42.99 39.94,41.73 40.65,40.65 41.73,39.94 42.99,39.69 44.26,39.94 45.33,40.65 46.05,41.73 46.3,42.99 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="33.07,122.36 32.82,123.63 32.1,124.7 31.03,125.42 29.76,125.67 28.5,125.42 27.43,124.7 26.71,123.63 26.46,122.36 26.71,121.1 27.43,120.02 28.5,119.31 29.76,119.06 31.03,119.31 32.1,120.02 32.82,121.1 33.07,122.36 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="39.69,122.36 39.43,123.63 38.72,124.7 37.64,125.42 36.38,125.67 35.11,125.42 34.04,124.7 33.32,123.63 33.07,122.36 33.32,121.1 34.04,120.02 35.11,119.31 36.38,119.06 37.64,119.31 38.72,120.02 39.43,121.1 39.69,122.36 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="46.3,122.36 46.05,123.63 45.33,124.7 44.26,125.42 42.99,125.67 41.73,125.42 40.65,124.7 39.94,123.63 39.69,122.36 39.94,121.1 40.65,120.02 41.73,119.31 42.99,119.06 44.26,119.31 45.33,120.02 46.05,121.1 46.3,122.36 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="33.07,128.98 32.82,130.24 32.1,131.31 31.03,132.03 29.76,132.28 28.5,132.03 27.43,131.31 26.71,130.24 26.46,128.98 26.71,127.71 27.43,126.64 28.5,125.92 29.76,125.67 31.03,125.92 32.1,126.64 32.82,127.71 33.07,128.98 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="39.69,128.98 39.43,130.24 38.72,131.31 37.64,132.03 36.38,132.28 35.11,132.03 34.04,131.31 33.32,130.24 33.07,128.98 33.32,127.71 34.04,126.64 35.11,125.92 36.38,125.67 37.64,125.92 38.72,126.64 39.43,127.71 39.69,128.98 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="46.3,128.98 46.05,130.24 45.33,131.31 44.26,132.03 42.99,132.28 41.73,132.03 40.65,131.31 39.94,130.24 39.69,128.98 39.94,127.71 40.65,126.64 41.73,125.92 42.99,125.67 44.26,125.92 45.33,126.64 46.05,127.71 46.3,128.98 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="33.07,135.59 32.82,136.86 32.1,137.93 31.03,138.65 29.76,138.9 28.5,138.65 27.43,137.93 26.71,136.86 26.46,135.59 26.71,134.32 27.43,133.25 28.5,132.54 29.76,132.28 31.03,132.54 32.1,133.25 32.82,134.32 33.07,135.59 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="39.69,135.59 39.43,136.86 38.72,137.93 37.64,138.65 36.38,138.9 35.11,138.65 34.04,137.93 33.32,136.86 33.07,135.59 33.32,134.32 34.04,133.25 35.11,132.54 36.38,132.28 37.64,132.54 38.72,133.25 39.43,134.32 39.69,135.59 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="46.3,135.59 46.05,136.86 45.33,137.93 44.26,138.65 42.99,138.9 41.73,138.65 40.65,137.93 39.94,136.86 39.69,135.59 39.94,134.32 40.65,133.25 41.73,132.54 42.99,132.28 44.26,132.54 45.33,133.25 46.05,134.32 46.3,135.59 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="125.67,29.76 125.42,31.03 124.7,32.1 123.63,32.82 122.36,33.07 121.1,32.82 120.02,32.1 119.31,31.03 119.06,29.76 119.31,28.5 120.02,27.43 121.1,26.71 122.36,26.46 123.63,26.71 124.7,27.43 125.42,28.5 125.67,29.76 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="132.28,29.76 132.03,31.03 131.31,32.1 130.24,32.82 128.98,33.07 127.71,32.82 126.64,32.1 125.92,31.03 125.67,29.76 125.92,28.5 126.64,27.43 127.71,26.71 128.98,26.46 130.24,26.71 131.31,27.43 132.03,28.5 132.28,29.76 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="138.9,29.76 138.65,31.03 137.93,32.1 136.86,32.82 135.59,33.07 134.32,32.82 133.25,32.1 132.54,31.03 132.28,29.76 132.54,28.5 133.25,27.43 134.32,26.71 135.59,26.46 136.86,26.71 137.93,27.43 138.65,28.5 138.9,29.76 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="125.67,36.38 125.42,37.64 124.7,38.72 123.63,39.43 122.36,39.69 121.1,39.43 120.02,38.72 119.31,37.64 119.06,36.38 119.31,35.11 120.02,34.04 121.1,33.32 122.36,33.07 123.63,33.32 124.7,34.04 125.42,35.11 125.67,36.38 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="132.28,36.38 132.03,37.64 131.31,38.72 130.24,39.43 128.98,39.69 127.71,39.43 126.64,38.72 125.92,37.64 125.67,36.38 125.92,35.11 126.64,34.04 127.71,33.32 128.98,33.07 130.24,33.32 131.31,34.04 132.03,35.11 132.28,36.38 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="138.9,36.38 138.65,37.64 137.93,38.72 136.86,39.43 135.59,39.69 134.32,39.43 133.25,38.72 132.54,37.64 132.28,36.38 132.54,35.11 133.25,34.04 134.32,33.32 135.59,33.07 136.86,33.32 137.93,34.04 138.65,35.11 138.9,36.38 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="125.67,42.99 125.42,44.26 124.7,45.33 123.63,46.05 122.36,46.3 121.1,46.05 120.02,45.33 119.31,44.26 119.06,42.99 119.31,41.73 120.02,40.65 121.1,39.94 122.36,39.69 123.63,39.94 124.7,40.65 125.42,41.73 125.67,42.99 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="132.28,42.99 132.03,44.26 131.31,45.33 130.24,46.05 128.98,46.3 127.71,46.05 126.64,45.33 125.92,44.26 125.67,42.99 125.92,41.73 126.64,40.65 127.71,39.94 128.98,39.69 130.24,39.94 131.31,40.65 132.03,41.73 132.28,42.99 "
            style="fill:rgba(141,179,226,1);"
          />
          <polygon
            points="138.9,42.99 138.65,44.26 137.93,45.33 136.86,46.05 135.59,46.3 134.32,46.05 133.25,45.33 132.54,44.26 132.28,42.99 132.54,41.73 133.25,40.65 134.32,39.94 135.59,39.69 136.86,39.94 137.93,40.65 138.65,41.73 138.9,42.99 "
            style="fill:rgba(141,179,226,1);"
          />
          <linearGradient
            id="gradient9c2f877df85f404f8d09368927b6f99d"
            gradientUnits="userSpaceOnUse"
            x1="11.1772292562222"
            y1="78.9300121785742"
            x2="154.177100806644"
            y2="86.424317884292"
          >
            <stop offset="0%" stop-color="#B2A1C7" />
            <stop offset="50%" stop-color="#00FF78" />
            <stop offset="100%" stop-color="#B2A1C7" />
          </linearGradient>
          <polygon
            points="84.66,16.54 84.4,17.53 83.67,18.25 82.68,18.52 81.69,18.25 80.96,17.53 80.69,16.54 80.96,15.54 81.69,14.82 82.68,14.55 83.67,14.82 84.4,15.54 84.66,16.54 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="91.28,16.54 91.01,17.53 90.28,18.25 89.29,18.52 88.3,18.25 87.57,17.53 87.31,16.54 87.57,15.54 88.3,14.82 89.29,14.55 90.28,14.82 91.01,15.54 91.28,16.54 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="97.89,16.54 97.62,17.53 96.9,18.25 95.91,18.52 94.91,18.25 94.19,17.53 93.92,16.54 94.19,15.54 94.91,14.82 95.91,14.55 96.9,14.82 97.62,15.54 97.89,16.54 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="71.43,23.15 71.17,24.14 70.44,24.87 69.45,25.13 68.46,24.87 67.73,24.14 67.46,23.15 67.73,22.16 68.46,21.43 69.45,21.17 70.44,21.43 71.17,22.16 71.43,23.15 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="78.05,23.15 77.78,24.14 77.06,24.87 76.06,25.13 75.07,24.87 74.34,24.14 74.08,23.15 74.34,22.16 75.07,21.43 76.06,21.17 77.06,21.43 77.78,22.16 78.05,23.15 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="84.66,23.15 84.4,24.14 83.67,24.87 82.68,25.13 81.69,24.87 80.96,24.14 80.69,23.15 80.96,22.16 81.69,21.43 82.68,21.17 83.67,21.43 84.4,22.16 84.66,23.15 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="97.89,23.15 97.62,24.14 96.9,24.87 95.91,25.13 94.91,24.87 94.19,24.14 93.92,23.15 94.19,22.16 94.91,21.43 95.91,21.17 96.9,21.43 97.62,22.16 97.89,23.15 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="84.66,29.76 84.4,30.76 83.67,31.48 82.68,31.75 81.69,31.48 80.96,30.76 80.69,29.76 80.96,28.77 81.69,28.05 82.68,27.78 83.67,28.05 84.4,28.77 84.66,29.76 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="91.28,29.76 91.01,30.76 90.28,31.48 89.29,31.75 88.3,31.48 87.57,30.76 87.31,29.76 87.57,28.77 88.3,28.05 89.29,27.78 90.28,28.05 91.01,28.77 91.28,29.76 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="97.89,29.76 97.62,30.76 96.9,31.48 95.91,31.75 94.91,31.48 94.19,30.76 93.92,29.76 94.19,28.77 94.91,28.05 95.91,27.78 96.9,28.05 97.62,28.77 97.89,29.76 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="71.43,36.38 71.17,37.37 70.44,38.1 69.45,38.36 68.46,38.1 67.73,37.37 67.46,36.38 67.73,35.39 68.46,34.66 69.45,34.39 70.44,34.66 71.17,35.39 71.43,36.38 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="78.05,36.38 77.78,37.37 77.06,38.1 76.06,38.36 75.07,38.1 74.34,37.37 74.08,36.38 74.34,35.39 75.07,34.66 76.06,34.39 77.06,34.66 77.78,35.39 78.05,36.38 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="97.89,36.38 97.62,37.37 96.9,38.1 95.91,38.36 94.91,38.1 94.19,37.37 93.92,36.38 94.19,35.39 94.91,34.66 95.91,34.39 96.9,34.66 97.62,35.39 97.89,36.38 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="78.05,42.99 77.78,43.98 77.06,44.71 76.06,44.98 75.07,44.71 74.34,43.98 74.08,42.99 74.34,42 75.07,41.27 76.06,41.01 77.06,41.27 77.78,42 78.05,42.99 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="97.89,42.99 97.62,43.98 96.9,44.71 95.91,44.98 94.91,44.71 94.19,43.98 93.92,42.99 94.19,42 94.91,41.27 95.91,41.01 96.9,41.27 97.62,42 97.89,42.99 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="71.43,49.61 71.17,50.6 70.44,51.32 69.45,51.59 68.46,51.32 67.73,50.6 67.46,49.61 67.73,48.61 68.46,47.89 69.45,47.62 70.44,47.89 71.17,48.61 71.43,49.61 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="91.28,49.61 91.01,50.6 90.28,51.32 89.29,51.59 88.3,51.32 87.57,50.6 87.31,49.61 87.57,48.61 88.3,47.89 89.29,47.62 90.28,47.89 91.01,48.61 91.28,49.61 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="71.43,56.22 71.17,57.21 70.44,57.94 69.45,58.2 68.46,57.94 67.73,57.21 67.46,56.22 67.73,55.23 68.46,54.5 69.45,54.24 70.44,54.5 71.17,55.23 71.43,56.22 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="84.66,56.22 84.4,57.21 83.67,57.94 82.68,58.2 81.69,57.94 80.96,57.21 80.69,56.22 80.96,55.23 81.69,54.5 82.68,54.24 83.67,54.5 84.4,55.23 84.66,56.22 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="97.89,56.22 97.62,57.21 96.9,57.94 95.91,58.2 94.91,57.94 94.19,57.21 93.92,56.22 94.19,55.23 94.91,54.5 95.91,54.24 96.9,54.5 97.62,55.23 97.89,56.22 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="78.05,62.83 77.78,63.83 77.06,64.55 76.06,64.82 75.07,64.55 74.34,63.83 74.08,62.83 74.34,61.84 75.07,61.12 76.06,60.85 77.06,61.12 77.78,61.84 78.05,62.83 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="18.52,69.45 18.25,70.44 17.53,71.17 16.54,71.43 15.54,71.17 14.82,70.44 14.55,69.45 14.82,68.46 15.54,67.73 16.54,67.46 17.53,67.73 18.25,68.46 18.52,69.45 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="25.13,69.45 24.87,70.44 24.14,71.17 23.15,71.43 22.16,71.17 21.43,70.44 21.17,69.45 21.43,68.46 22.16,67.73 23.15,67.46 24.14,67.73 24.87,68.46 25.13,69.45 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="31.75,69.45 31.48,70.44 30.76,71.17 29.76,71.43 28.77,71.17 28.05,70.44 27.78,69.45 28.05,68.46 28.77,67.73 29.76,67.46 30.76,67.73 31.48,68.46 31.75,69.45 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="38.36,69.45 38.1,70.44 37.37,71.17 36.38,71.43 35.39,71.17 34.66,70.44 34.39,69.45 34.66,68.46 35.39,67.73 36.38,67.46 37.37,67.73 38.1,68.46 38.36,69.45 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="44.98,69.45 44.71,70.44 43.98,71.17 42.99,71.43 42,71.17 41.27,70.44 41.01,69.45 41.27,68.46 42,67.73 42.99,67.46 43.98,67.73 44.71,68.46 44.98,69.45 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="58.2,69.45 57.94,70.44 57.21,71.17 56.22,71.43 55.23,71.17 54.5,70.44 54.24,69.45 54.5,68.46 55.23,67.73 56.22,67.46 57.21,67.73 57.94,68.46 58.2,69.45 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="64.82,69.45 64.55,70.44 63.83,71.17 62.83,71.43 61.84,71.17 61.12,70.44 60.85,69.45 61.12,68.46 61.84,67.73 62.83,67.46 63.83,67.73 64.55,68.46 64.82,69.45 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="71.43,69.45 71.17,70.44 70.44,71.17 69.45,71.43 68.46,71.17 67.73,70.44 67.46,69.45 67.73,68.46 68.46,67.73 69.45,67.46 70.44,67.73 71.17,68.46 71.43,69.45 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="91.28,69.45 91.01,70.44 90.28,71.17 89.29,71.43 88.3,71.17 87.57,70.44 87.31,69.45 87.57,68.46 88.3,67.73 89.29,67.46 90.28,67.73 91.01,68.46 91.28,69.45 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="104.5,69.45 104.24,70.44 103.51,71.17 102.52,71.43 101.53,71.17 100.8,70.44 100.54,69.45 100.8,68.46 101.53,67.73 102.52,67.46 103.51,67.73 104.24,68.46 104.5,69.45 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="117.73,69.45 117.47,70.44 116.74,71.17 115.75,71.43 114.76,71.17 114.03,70.44 113.76,69.45 114.03,68.46 114.76,67.73 115.75,67.46 116.74,67.73 117.47,68.46 117.73,69.45 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="130.96,69.45 130.69,70.44 129.97,71.17 128.98,71.43 127.98,71.17 127.26,70.44 126.99,69.45 127.26,68.46 127.98,67.73 128.98,67.46 129.97,67.73 130.69,68.46 130.96,69.45 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="144.19,69.45 143.92,70.44 143.2,71.17 142.2,71.43 141.21,71.17 140.49,70.44 140.22,69.45 140.49,68.46 141.21,67.73 142.2,67.46 143.2,67.73 143.92,68.46 144.19,69.45 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="18.52,76.06 18.25,77.06 17.53,77.78 16.54,78.05 15.54,77.78 14.82,77.06 14.55,76.06 14.82,75.07 15.54,74.34 16.54,74.08 17.53,74.34 18.25,75.07 18.52,76.06 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="25.13,76.06 24.87,77.06 24.14,77.78 23.15,78.05 22.16,77.78 21.43,77.06 21.17,76.06 21.43,75.07 22.16,74.34 23.15,74.08 24.14,74.34 24.87,75.07 25.13,76.06 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="31.75,76.06 31.48,77.06 30.76,77.78 29.76,78.05 28.77,77.78 28.05,77.06 27.78,76.06 28.05,75.07 28.77,74.34 29.76,74.08 30.76,74.34 31.48,75.07 31.75,76.06 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="51.59,76.06 51.32,77.06 50.6,77.78 49.61,78.05 48.61,77.78 47.89,77.06 47.62,76.06 47.89,75.07 48.61,74.34 49.61,74.08 50.6,74.34 51.32,75.07 51.59,76.06 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="64.82,76.06 64.55,77.06 63.83,77.78 62.83,78.05 61.84,77.78 61.12,77.06 60.85,76.06 61.12,75.07 61.84,74.34 62.83,74.08 63.83,74.34 64.55,75.07 64.82,76.06 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="78.05,76.06 77.78,77.06 77.06,77.78 76.06,78.05 75.07,77.78 74.34,77.06 74.08,76.06 74.34,75.07 75.07,74.34 76.06,74.08 77.06,74.34 77.78,75.07 78.05,76.06 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="91.28,76.06 91.01,77.06 90.28,77.78 89.29,78.05 88.3,77.78 87.57,77.06 87.31,76.06 87.57,75.07 88.3,74.34 89.29,74.08 90.28,74.34 91.01,75.07 91.28,76.06 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="97.89,76.06 97.62,77.06 96.9,77.78 95.91,78.05 94.91,77.78 94.19,77.06 93.92,76.06 94.19,75.07 94.91,74.34 95.91,74.08 96.9,74.34 97.62,75.07 97.89,76.06 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="104.5,76.06 104.24,77.06 103.51,77.78 102.52,78.05 101.53,77.78 100.8,77.06 100.54,76.06 100.8,75.07 101.53,74.34 102.52,74.08 103.51,74.34 104.24,75.07 104.5,76.06 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="111.12,76.06 110.85,77.06 110.13,77.78 109.13,78.05 108.14,77.78 107.42,77.06 107.15,76.06 107.42,75.07 108.14,74.34 109.13,74.08 110.13,74.34 110.85,75.07 111.12,76.06 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="130.96,76.06 130.69,77.06 129.97,77.78 128.98,78.05 127.98,77.78 127.26,77.06 126.99,76.06 127.26,75.07 127.98,74.34 128.98,74.08 129.97,74.34 130.69,75.07 130.96,76.06 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="137.57,76.06 137.31,77.06 136.58,77.78 135.59,78.05 134.6,77.78 133.87,77.06 133.61,76.06 133.87,75.07 134.6,74.34 135.59,74.08 136.58,74.34 137.31,75.07 137.57,76.06 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="144.19,76.06 143.92,77.06 143.2,77.78 142.2,78.05 141.21,77.78 140.49,77.06 140.22,76.06 140.49,75.07 141.21,74.34 142.2,74.08 143.2,74.34 143.92,75.07 144.19,76.06 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="150.8,76.06 150.54,77.06 149.81,77.78 148.82,78.05 147.83,77.78 147.1,77.06 146.83,76.06 147.1,75.07 147.83,74.34 148.82,74.08 149.81,74.34 150.54,75.07 150.8,76.06 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="31.75,82.68 31.48,83.67 30.76,84.4 29.76,84.66 28.77,84.4 28.05,83.67 27.78,82.68 28.05,81.69 28.77,80.96 29.76,80.69 30.76,80.96 31.48,81.69 31.75,82.68 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="44.98,82.68 44.71,83.67 43.98,84.4 42.99,84.66 42,84.4 41.27,83.67 41.01,82.68 41.27,81.69 42,80.96 42.99,80.69 43.98,80.96 44.71,81.69 44.98,82.68 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="51.59,82.68 51.32,83.67 50.6,84.4 49.61,84.66 48.61,84.4 47.89,83.67 47.62,82.68 47.89,81.69 48.61,80.96 49.61,80.69 50.6,80.96 51.32,81.69 51.59,82.68 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="58.2,82.68 57.94,83.67 57.21,84.4 56.22,84.66 55.23,84.4 54.5,83.67 54.24,82.68 54.5,81.69 55.23,80.96 56.22,80.69 57.21,80.96 57.94,81.69 58.2,82.68 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="71.43,82.68 71.17,83.67 70.44,84.4 69.45,84.66 68.46,84.4 67.73,83.67 67.46,82.68 67.73,81.69 68.46,80.96 69.45,80.69 70.44,80.96 71.17,81.69 71.43,82.68 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="78.05,82.68 77.78,83.67 77.06,84.4 76.06,84.66 75.07,84.4 74.34,83.67 74.08,82.68 74.34,81.69 75.07,80.96 76.06,80.69 77.06,80.96 77.78,81.69 78.05,82.68 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="97.89,82.68 97.62,83.67 96.9,84.4 95.91,84.66 94.91,84.4 94.19,83.67 93.92,82.68 94.19,81.69 94.91,80.96 95.91,80.69 96.9,80.96 97.62,81.69 97.89,82.68 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="111.12,82.68 110.85,83.67 110.13,84.4 109.13,84.66 108.14,84.4 107.42,83.67 107.15,82.68 107.42,81.69 108.14,80.96 109.13,80.69 110.13,80.96 110.85,81.69 111.12,82.68 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="117.73,82.68 117.47,83.67 116.74,84.4 115.75,84.66 114.76,84.4 114.03,83.67 113.76,82.68 114.03,81.69 114.76,80.96 115.75,80.69 116.74,80.96 117.47,81.69 117.73,82.68 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="130.96,82.68 130.69,83.67 129.97,84.4 128.98,84.66 127.98,84.4 127.26,83.67 126.99,82.68 127.26,81.69 127.98,80.96 128.98,80.69 129.97,80.96 130.69,81.69 130.96,82.68 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="150.8,82.68 150.54,83.67 149.81,84.4 148.82,84.66 147.83,84.4 147.1,83.67 146.83,82.68 147.1,81.69 147.83,80.96 148.82,80.69 149.81,80.96 150.54,81.69 150.8,82.68 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="18.52,89.29 18.25,90.28 17.53,91.01 16.54,91.28 15.54,91.01 14.82,90.28 14.55,89.29 14.82,88.3 15.54,87.57 16.54,87.31 17.53,87.57 18.25,88.3 18.52,89.29 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="38.36,89.29 38.1,90.28 37.37,91.01 36.38,91.28 35.39,91.01 34.66,90.28 34.39,89.29 34.66,88.3 35.39,87.57 36.38,87.31 37.37,87.57 38.1,88.3 38.36,89.29 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="91.28,89.29 91.01,90.28 90.28,91.01 89.29,91.28 88.3,91.01 87.57,90.28 87.31,89.29 87.57,88.3 88.3,87.57 89.29,87.31 90.28,87.57 91.01,88.3 91.28,89.29 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="97.89,89.29 97.62,90.28 96.9,91.01 95.91,91.28 94.91,91.01 94.19,90.28 93.92,89.29 94.19,88.3 94.91,87.57 95.91,87.31 96.9,87.57 97.62,88.3 97.89,89.29 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="104.5,89.29 104.24,90.28 103.51,91.01 102.52,91.28 101.53,91.01 100.8,90.28 100.54,89.29 100.8,88.3 101.53,87.57 102.52,87.31 103.51,87.57 104.24,88.3 104.5,89.29 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="111.12,89.29 110.85,90.28 110.13,91.01 109.13,91.28 108.14,91.01 107.42,90.28 107.15,89.29 107.42,88.3 108.14,87.57 109.13,87.31 110.13,87.57 110.85,88.3 111.12,89.29 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="137.57,89.29 137.31,90.28 136.58,91.01 135.59,91.28 134.6,91.01 133.87,90.28 133.61,89.29 133.87,88.3 134.6,87.57 135.59,87.31 136.58,87.57 137.31,88.3 137.57,89.29 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="144.19,89.29 143.92,90.28 143.2,91.01 142.2,91.28 141.21,91.01 140.49,90.28 140.22,89.29 140.49,88.3 141.21,87.57 142.2,87.31 143.2,87.57 143.92,88.3 144.19,89.29 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="150.8,89.29 150.54,90.28 149.81,91.01 148.82,91.28 147.83,91.01 147.1,90.28 146.83,89.29 147.1,88.3 147.83,87.57 148.82,87.31 149.81,87.57 150.54,88.3 150.8,89.29 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="25.13,95.91 24.87,96.9 24.14,97.62 23.15,97.89 22.16,97.62 21.43,96.9 21.17,95.91 21.43,94.91 22.16,94.19 23.15,93.92 24.14,94.19 24.87,94.91 25.13,95.91 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="38.36,95.91 38.1,96.9 37.37,97.62 36.38,97.89 35.39,97.62 34.66,96.9 34.39,95.91 34.66,94.91 35.39,94.19 36.38,93.92 37.37,94.19 38.1,94.91 38.36,95.91 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="44.98,95.91 44.71,96.9 43.98,97.62 42.99,97.89 42,97.62 41.27,96.9 41.01,95.91 41.27,94.91 42,94.19 42.99,93.92 43.98,94.19 44.71,94.91 44.98,95.91 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="58.2,95.91 57.94,96.9 57.21,97.62 56.22,97.89 55.23,97.62 54.5,96.9 54.24,95.91 54.5,94.91 55.23,94.19 56.22,93.92 57.21,94.19 57.94,94.91 58.2,95.91 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="71.43,95.91 71.17,96.9 70.44,97.62 69.45,97.89 68.46,97.62 67.73,96.9 67.46,95.91 67.73,94.91 68.46,94.19 69.45,93.92 70.44,94.19 71.17,94.91 71.43,95.91 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="78.05,95.91 77.78,96.9 77.06,97.62 76.06,97.89 75.07,97.62 74.34,96.9 74.08,95.91 74.34,94.91 75.07,94.19 76.06,93.92 77.06,94.19 77.78,94.91 78.05,95.91 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="97.89,95.91 97.62,96.9 96.9,97.62 95.91,97.89 94.91,97.62 94.19,96.9 93.92,95.91 94.19,94.91 94.91,94.19 95.91,93.92 96.9,94.19 97.62,94.91 97.89,95.91 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="117.73,95.91 117.47,96.9 116.74,97.62 115.75,97.89 114.76,97.62 114.03,96.9 113.76,95.91 114.03,94.91 114.76,94.19 115.75,93.92 116.74,94.19 117.47,94.91 117.73,95.91 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="144.19,95.91 143.92,96.9 143.2,97.62 142.2,97.89 141.21,97.62 140.49,96.9 140.22,95.91 140.49,94.91 141.21,94.19 142.2,93.92 143.2,94.19 143.92,94.91 144.19,95.91 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="71.43,102.52 71.17,103.51 70.44,104.24 69.45,104.5 68.46,104.24 67.73,103.51 67.46,102.52 67.73,101.53 68.46,100.8 69.45,100.54 70.44,100.8 71.17,101.53 71.43,102.52 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="84.66,102.52 84.4,103.51 83.67,104.24 82.68,104.5 81.69,104.24 80.96,103.51 80.69,102.52 80.96,101.53 81.69,100.8 82.68,100.54 83.67,100.8 84.4,101.53 84.66,102.52 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="97.89,102.52 97.62,103.51 96.9,104.24 95.91,104.5 94.91,104.24 94.19,103.51 93.92,102.52 94.19,101.53 94.91,100.8 95.91,100.54 96.9,100.8 97.62,101.53 97.89,102.52 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="117.73,102.52 117.47,103.51 116.74,104.24 115.75,104.5 114.76,104.24 114.03,103.51 113.76,102.52 114.03,101.53 114.76,100.8 115.75,100.54 116.74,100.8 117.47,101.53 117.73,102.52 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="137.57,102.52 137.31,103.51 136.58,104.24 135.59,104.5 134.6,104.24 133.87,103.51 133.61,102.52 133.87,101.53 134.6,100.8 135.59,100.54 136.58,100.8 137.31,101.53 137.57,102.52 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="71.43,109.13 71.17,110.13 70.44,110.85 69.45,111.12 68.46,110.85 67.73,110.13 67.46,109.13 67.73,108.14 68.46,107.42 69.45,107.15 70.44,107.42 71.17,108.14 71.43,109.13 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="91.28,109.13 91.01,110.13 90.28,110.85 89.29,111.12 88.3,110.85 87.57,110.13 87.31,109.13 87.57,108.14 88.3,107.42 89.29,107.15 90.28,107.42 91.01,108.14 91.28,109.13 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="104.5,109.13 104.24,110.13 103.51,110.85 102.52,111.12 101.53,110.85 100.8,110.13 100.54,109.13 100.8,108.14 101.53,107.42 102.52,107.15 103.51,107.42 104.24,108.14 104.5,109.13 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="124.35,109.13 124.08,110.13 123.35,110.85 122.36,111.12 121.37,110.85 120.64,110.13 120.38,109.13 120.64,108.14 121.37,107.42 122.36,107.15 123.35,107.42 124.08,108.14 124.35,109.13 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="130.96,109.13 130.69,110.13 129.97,110.85 128.98,111.12 127.98,110.85 127.26,110.13 126.99,109.13 127.26,108.14 127.98,107.42 128.98,107.15 129.97,107.42 130.69,108.14 130.96,109.13 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="144.19,109.13 143.92,110.13 143.2,110.85 142.2,111.12 141.21,110.85 140.49,110.13 140.22,109.13 140.49,108.14 141.21,107.42 142.2,107.15 143.2,107.42 143.92,108.14 144.19,109.13 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="150.8,109.13 150.54,110.13 149.81,110.85 148.82,111.12 147.83,110.85 147.1,110.13 146.83,109.13 147.1,108.14 147.83,107.42 148.82,107.15 149.81,107.42 150.54,108.14 150.8,109.13 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="78.05,115.75 77.78,116.74 77.06,117.47 76.06,117.73 75.07,117.47 74.34,116.74 74.08,115.75 74.34,114.76 75.07,114.03 76.06,113.76 77.06,114.03 77.78,114.76 78.05,115.75 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="84.66,115.75 84.4,116.74 83.67,117.47 82.68,117.73 81.69,117.47 80.96,116.74 80.69,115.75 80.96,114.76 81.69,114.03 82.68,113.76 83.67,114.03 84.4,114.76 84.66,115.75 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="117.73,115.75 117.47,116.74 116.74,117.47 115.75,117.73 114.76,117.47 114.03,116.74 113.76,115.75 114.03,114.76 114.76,114.03 115.75,113.76 116.74,114.03 117.47,114.76 117.73,115.75 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="124.35,115.75 124.08,116.74 123.35,117.47 122.36,117.73 121.37,117.47 120.64,116.74 120.38,115.75 120.64,114.76 121.37,114.03 122.36,113.76 123.35,114.03 124.08,114.76 124.35,115.75 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="137.57,115.75 137.31,116.74 136.58,117.47 135.59,117.73 134.6,117.47 133.87,116.74 133.61,115.75 133.87,114.76 134.6,114.03 135.59,113.76 136.58,114.03 137.31,114.76 137.57,115.75 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="150.8,115.75 150.54,116.74 149.81,117.47 148.82,117.73 147.83,117.47 147.1,116.74 146.83,115.75 147.1,114.76 147.83,114.03 148.82,113.76 149.81,114.03 150.54,114.76 150.8,115.75 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="71.43,122.36 71.17,123.35 70.44,124.08 69.45,124.35 68.46,124.08 67.73,123.35 67.46,122.36 67.73,121.37 68.46,120.64 69.45,120.38 70.44,120.64 71.17,121.37 71.43,122.36 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="78.05,122.36 77.78,123.35 77.06,124.08 76.06,124.35 75.07,124.08 74.34,123.35 74.08,122.36 74.34,121.37 75.07,120.64 76.06,120.38 77.06,120.64 77.78,121.37 78.05,122.36 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="84.66,122.36 84.4,123.35 83.67,124.08 82.68,124.35 81.69,124.08 80.96,123.35 80.69,122.36 80.96,121.37 81.69,120.64 82.68,120.38 83.67,120.64 84.4,121.37 84.66,122.36 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="91.28,122.36 91.01,123.35 90.28,124.08 89.29,124.35 88.3,124.08 87.57,123.35 87.31,122.36 87.57,121.37 88.3,120.64 89.29,120.38 90.28,120.64 91.01,121.37 91.28,122.36 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="104.5,122.36 104.24,123.35 103.51,124.08 102.52,124.35 101.53,124.08 100.8,123.35 100.54,122.36 100.8,121.37 101.53,120.64 102.52,120.38 103.51,120.64 104.24,121.37 104.5,122.36 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="124.35,122.36 124.08,123.35 123.35,124.08 122.36,124.35 121.37,124.08 120.64,123.35 120.38,122.36 120.64,121.37 121.37,120.64 122.36,120.38 123.35,120.64 124.08,121.37 124.35,122.36 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="130.96,122.36 130.69,123.35 129.97,124.08 128.98,124.35 127.98,124.08 127.26,123.35 126.99,122.36 127.26,121.37 127.98,120.64 128.98,120.38 129.97,120.64 130.69,121.37 130.96,122.36 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="137.57,122.36 137.31,123.35 136.58,124.08 135.59,124.35 134.6,124.08 133.87,123.35 133.61,122.36 133.87,121.37 134.6,120.64 135.59,120.38 136.58,120.64 137.31,121.37 137.57,122.36 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="71.43,128.98 71.17,129.97 70.44,130.69 69.45,130.96 68.46,130.69 67.73,129.97 67.46,128.98 67.73,127.98 68.46,127.26 69.45,126.99 70.44,127.26 71.17,127.98 71.43,128.98 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="78.05,128.98 77.78,129.97 77.06,130.69 76.06,130.96 75.07,130.69 74.34,129.97 74.08,128.98 74.34,127.98 75.07,127.26 76.06,126.99 77.06,127.26 77.78,127.98 78.05,128.98 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="91.28,128.98 91.01,129.97 90.28,130.69 89.29,130.96 88.3,130.69 87.57,129.97 87.31,128.98 87.57,127.98 88.3,127.26 89.29,126.99 90.28,127.26 91.01,127.98 91.28,128.98 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="97.89,128.98 97.62,129.97 96.9,130.69 95.91,130.96 94.91,130.69 94.19,129.97 93.92,128.98 94.19,127.98 94.91,127.26 95.91,126.99 96.9,127.26 97.62,127.98 97.89,128.98 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="104.5,128.98 104.24,129.97 103.51,130.69 102.52,130.96 101.53,130.69 100.8,129.97 100.54,128.98 100.8,127.98 101.53,127.26 102.52,126.99 103.51,127.26 104.24,127.98 104.5,128.98 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="111.12,128.98 110.85,129.97 110.13,130.69 109.13,130.96 108.14,130.69 107.42,129.97 107.15,128.98 107.42,127.98 108.14,127.26 109.13,126.99 110.13,127.26 110.85,127.98 111.12,128.98 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="117.73,128.98 117.47,129.97 116.74,130.69 115.75,130.96 114.76,130.69 114.03,129.97 113.76,128.98 114.03,127.98 114.76,127.26 115.75,126.99 116.74,127.26 117.47,127.98 117.73,128.98 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="130.96,128.98 130.69,129.97 129.97,130.69 128.98,130.96 127.98,130.69 127.26,129.97 126.99,128.98 127.26,127.98 127.98,127.26 128.98,126.99 129.97,127.26 130.69,127.98 130.96,128.98 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="137.57,128.98 137.31,129.97 136.58,130.69 135.59,130.96 134.6,130.69 133.87,129.97 133.61,128.98 133.87,127.98 134.6,127.26 135.59,126.99 136.58,127.26 137.31,127.98 137.57,128.98 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="71.43,135.59 71.17,136.58 70.44,137.31 69.45,137.57 68.46,137.31 67.73,136.58 67.46,135.59 67.73,134.6 68.46,133.87 69.45,133.61 70.44,133.87 71.17,134.6 71.43,135.59 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="78.05,135.59 77.78,136.58 77.06,137.31 76.06,137.57 75.07,137.31 74.34,136.58 74.08,135.59 74.34,134.6 75.07,133.87 76.06,133.61 77.06,133.87 77.78,134.6 78.05,135.59 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="97.89,135.59 97.62,136.58 96.9,137.31 95.91,137.57 94.91,137.31 94.19,136.58 93.92,135.59 94.19,134.6 94.91,133.87 95.91,133.61 96.9,133.87 97.62,134.6 97.89,135.59 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="111.12,135.59 110.85,136.58 110.13,137.31 109.13,137.57 108.14,137.31 107.42,136.58 107.15,135.59 107.42,134.6 108.14,133.87 109.13,133.61 110.13,133.87 110.85,134.6 111.12,135.59 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="117.73,135.59 117.47,136.58 116.74,137.31 115.75,137.57 114.76,137.31 114.03,136.58 113.76,135.59 114.03,134.6 114.76,133.87 115.75,133.61 116.74,133.87 117.47,134.6 117.73,135.59 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="130.96,135.59 130.69,136.58 129.97,137.31 128.98,137.57 127.98,137.31 127.26,136.58 126.99,135.59 127.26,134.6 127.98,133.87 128.98,133.61 129.97,133.87 130.69,134.6 130.96,135.59 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="137.57,135.59 137.31,136.58 136.58,137.31 135.59,137.57 134.6,137.31 133.87,136.58 133.61,135.59 133.87,134.6 134.6,133.87 135.59,133.61 136.58,133.87 137.31,134.6 137.57,135.59 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="71.43,142.2 71.17,143.2 70.44,143.92 69.45,144.19 68.46,143.92 67.73,143.2 67.46,142.2 67.73,141.21 68.46,140.49 69.45,140.22 70.44,140.49 71.17,141.21 71.43,142.2 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="84.66,142.2 84.4,143.2 83.67,143.92 82.68,144.19 81.69,143.92 80.96,143.2 80.69,142.2 80.96,141.21 81.69,140.49 82.68,140.22 83.67,140.49 84.4,141.21 84.66,142.2 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="91.28,142.2 91.01,143.2 90.28,143.92 89.29,144.19 88.3,143.92 87.57,143.2 87.31,142.2 87.57,141.21 88.3,140.49 89.29,140.22 90.28,140.49 91.01,141.21 91.28,142.2 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="97.89,142.2 97.62,143.2 96.9,143.92 95.91,144.19 94.91,143.92 94.19,143.2 93.92,142.2 94.19,141.21 94.91,140.49 95.91,140.22 96.9,140.49 97.62,141.21 97.89,142.2 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="104.5,142.2 104.24,143.2 103.51,143.92 102.52,144.19 101.53,143.92 100.8,143.2 100.54,142.2 100.8,141.21 101.53,140.49 102.52,140.22 103.51,140.49 104.24,141.21 104.5,142.2 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="111.12,142.2 110.85,143.2 110.13,143.92 109.13,144.19 108.14,143.92 107.42,143.2 107.15,142.2 107.42,141.21 108.14,140.49 109.13,140.22 110.13,140.49 110.85,141.21 111.12,142.2 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="117.73,142.2 117.47,143.2 116.74,143.92 115.75,144.19 114.76,143.92 114.03,143.2 113.76,142.2 114.03,141.21 114.76,140.49 115.75,140.22 116.74,140.49 117.47,141.21 117.73,142.2 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="124.35,142.2 124.08,143.2 123.35,143.92 122.36,144.19 121.37,143.92 120.64,143.2 120.38,142.2 120.64,141.21 121.37,140.49 122.36,140.22 123.35,140.49 124.08,141.21 124.35,142.2 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="137.57,142.2 137.31,143.2 136.58,143.92 135.59,144.19 134.6,143.92 133.87,143.2 133.61,142.2 133.87,141.21 134.6,140.49 135.59,140.22 136.58,140.49 137.31,141.21 137.57,142.2 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="144.19,142.2 143.92,143.2 143.2,143.92 142.2,144.19 141.21,143.92 140.49,143.2 140.22,142.2 140.49,141.21 141.21,140.49 142.2,140.22 143.2,140.49 143.92,141.21 144.19,142.2 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="71.43,148.82 71.17,149.81 70.44,150.54 69.45,150.8 68.46,150.54 67.73,149.81 67.46,148.82 67.73,147.83 68.46,147.1 69.45,146.83 70.44,147.1 71.17,147.83 71.43,148.82 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="78.05,148.82 77.78,149.81 77.06,150.54 76.06,150.8 75.07,150.54 74.34,149.81 74.08,148.82 74.34,147.83 75.07,147.1 76.06,146.83 77.06,147.1 77.78,147.83 78.05,148.82 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="84.66,148.82 84.4,149.81 83.67,150.54 82.68,150.8 81.69,150.54 80.96,149.81 80.69,148.82 80.96,147.83 81.69,147.1 82.68,146.83 83.67,147.1 84.4,147.83 84.66,148.82 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="97.89,148.82 97.62,149.81 96.9,150.54 95.91,150.8 94.91,150.54 94.19,149.81 93.92,148.82 94.19,147.83 94.91,147.1 95.91,146.83 96.9,147.1 97.62,147.83 97.89,148.82 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="117.73,148.82 117.47,149.81 116.74,150.54 115.75,150.8 114.76,150.54 114.03,149.81 113.76,148.82 114.03,147.83 114.76,147.1 115.75,146.83 116.74,147.1 117.47,147.83 117.73,148.82 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
          <polygon
            points="137.57,148.82 137.31,149.81 136.58,150.54 135.59,150.8 134.6,150.54 133.87,149.81 133.61,148.82 133.87,147.83 134.6,147.1 135.59,146.83 136.58,147.1 137.31,147.83 137.57,148.82 "
            style="fill:url(#gradient9c2f877df85f404f8d09368927b6f99d);"
          />
      `,
            },
            {
                value: 13,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(255,255,255,0);"
            shape-rendering="crispEdges"
          />
          <polygon
            points="13.23,29.76 13.55,26.54 14.49,23.44 16.02,20.58 18.07,18.07 20.58,16.02 23.44,14.49 26.54,13.55 29.76,13.23 42.99,13.23 46.22,13.55 49.32,14.49 52.18,16.02 54.68,18.07 56.74,20.58 58.27,23.44 59.21,26.54 59.53,29.76 59.53,42.99 59.21,46.22 58.27,49.32 56.74,52.18 54.68,54.68 52.18,56.74 49.32,58.27 46.22,59.21 42.99,59.53 29.76,59.53 26.54,59.21 23.44,58.27 20.58,56.74 18.07,54.68 16.02,52.18 14.49,49.32 13.55,46.22 13.23,42.99 13.23,29.76 19.84,29.76 19.84,42.99 20.18,45.56 21.17,47.95 22.75,50.01 24.8,51.58 27.2,52.58 29.76,52.91 42.99,52.91 45.56,52.58 47.95,51.58 50.01,50.01 51.58,47.95 52.58,45.56 52.91,42.99 52.91,29.76 52.58,27.2 51.58,24.8 50.01,22.75 47.95,21.17 45.56,20.18 42.99,19.84 29.76,19.84 27.2,20.18 24.8,21.17 22.75,22.75 21.17,24.8 20.18,27.2 19.84,29.76 "
            style="fill:rgba(88,66,111,1);"
          />
          <polygon
            points="13.23,122.36 13.55,119.14 14.49,116.03 16.02,113.18 18.07,110.67 20.58,108.61 23.44,107.09 26.54,106.14 29.76,105.83 42.99,105.83 46.22,106.14 49.32,107.09 52.18,108.61 54.68,110.67 56.74,113.18 58.27,116.03 59.21,119.14 59.53,122.36 59.53,135.59 59.21,138.82 58.27,141.92 56.74,144.78 54.68,147.28 52.18,149.34 49.32,150.87 46.22,151.81 42.99,152.13 29.76,152.13 26.54,151.81 23.44,150.87 20.58,149.34 18.07,147.28 16.02,144.78 14.49,141.92 13.55,138.82 13.23,135.59 13.23,122.36 19.84,122.36 19.84,135.59 20.18,138.16 21.17,140.55 22.75,142.61 24.8,144.18 27.2,145.17 29.76,145.51 42.99,145.51 45.56,145.17 47.95,144.18 50.01,142.61 51.58,140.55 52.58,138.16 52.91,135.59 52.91,122.36 52.58,119.79 51.58,117.4 50.01,115.35 47.95,113.77 45.56,112.78 42.99,112.44 29.76,112.44 27.2,112.78 24.8,113.77 22.75,115.35 21.17,117.4 20.18,119.79 19.84,122.36 "
            style="fill:rgba(88,66,111,1);"
          />
          <polygon
            points="105.83,29.76 106.14,26.54 107.09,23.44 108.61,20.58 110.67,18.07 113.18,16.02 116.03,14.49 119.14,13.55 122.36,13.23 135.59,13.23 138.82,13.55 141.92,14.49 144.78,16.02 147.28,18.07 149.34,20.58 150.87,23.44 151.81,26.54 152.13,29.76 152.13,42.99 151.81,46.22 150.87,49.32 149.34,52.18 147.28,54.68 144.78,56.74 141.92,58.27 138.82,59.21 135.59,59.53 122.36,59.53 119.14,59.21 116.03,58.27 113.18,56.74 110.67,54.68 108.61,52.18 107.09,49.32 106.14,46.22 105.83,42.99 105.83,29.76 112.44,29.76 112.44,42.99 112.78,45.56 113.77,47.95 115.35,50.01 117.4,51.58 119.79,52.58 122.36,52.91 135.59,52.91 138.16,52.58 140.55,51.58 142.61,50.01 144.18,47.95 145.17,45.56 145.51,42.99 145.51,29.76 145.17,27.2 144.18,24.8 142.61,22.75 140.55,21.17 138.16,20.18 135.59,19.84 122.36,19.84 119.79,20.18 117.4,21.17 115.35,22.75 113.77,24.8 112.78,27.2 112.44,29.76 "
            style="fill:rgba(88,66,111,1);"
          />
          <polygon
            points="29.43,32.74 28.29,32.51 27.33,31.87 26.68,30.9 26.46,29.76 26.68,28.62 27.33,27.66 28.29,27.01 29.43,26.79 43.32,26.79 44.46,27.01 45.43,27.66 46.07,28.62 46.3,29.76 46.07,30.9 45.43,31.87 44.46,32.51 43.32,32.74 "
            style="fill:rgba(211,135,84,1);"
          />
          <polygon
            points="29.43,39.35 28.29,39.13 27.33,38.48 26.68,37.52 26.46,36.38 26.68,35.24 27.33,34.27 28.29,33.63 29.43,33.4 43.32,33.4 44.46,33.63 45.43,34.27 46.07,35.24 46.3,36.38 46.07,37.52 45.43,38.48 44.46,39.13 43.32,39.35 "
            style="fill:rgba(211,135,84,1);"
          />
          <polygon
            points="29.43,45.97 28.29,45.74 27.33,45.1 26.68,44.13 26.46,42.99 26.68,41.85 27.33,40.89 28.29,40.24 29.43,40.02 43.32,40.02 44.46,40.24 45.43,40.89 46.07,41.85 46.3,42.99 46.07,44.13 45.43,45.1 44.46,45.74 43.32,45.97 "
            style="fill:rgba(211,135,84,1);"
          />
          <polygon
            points="29.43,125.34 28.29,125.11 27.33,124.47 26.68,123.5 26.46,122.36 26.68,121.22 27.33,120.26 28.29,119.61 29.43,119.39 43.32,119.39 44.46,119.61 45.43,120.26 46.07,121.22 46.3,122.36 46.07,123.5 45.43,124.47 44.46,125.11 43.32,125.34 "
            style="fill:rgba(211,135,84,1);"
          />
          <polygon
            points="29.43,131.95 28.29,131.73 27.33,131.08 26.68,130.12 26.46,128.98 26.68,127.84 27.33,126.87 28.29,126.23 29.43,126 43.32,126 44.46,126.23 45.43,126.87 46.07,127.84 46.3,128.98 46.07,130.12 45.43,131.08 44.46,131.73 43.32,131.95 "
            style="fill:rgba(211,135,84,1);"
          />
          <polygon
            points="29.43,138.57 28.29,138.34 27.33,137.7 26.68,136.73 26.46,135.59 26.68,134.45 27.33,133.49 28.29,132.84 29.43,132.61 43.32,132.61 44.46,132.84 45.43,133.49 46.07,134.45 46.3,135.59 46.07,136.73 45.43,137.7 44.46,138.34 43.32,138.57 "
            style="fill:rgba(211,135,84,1);"
          />
          <polygon
            points="122.03,32.74 120.89,32.51 119.93,31.87 119.28,30.9 119.06,29.76 119.28,28.62 119.93,27.66 120.89,27.01 122.03,26.79 135.92,26.79 137.06,27.01 138.03,27.66 138.67,28.62 138.9,29.76 138.67,30.9 138.03,31.87 137.06,32.51 135.92,32.74 "
            style="fill:rgba(211,135,84,1);"
          />
          <polygon
            points="122.03,39.35 120.89,39.13 119.93,38.48 119.28,37.52 119.06,36.38 119.28,35.24 119.93,34.27 120.89,33.63 122.03,33.4 135.92,33.4 137.06,33.63 138.03,34.27 138.67,35.24 138.9,36.38 138.67,37.52 138.03,38.48 137.06,39.13 135.92,39.35 "
            style="fill:rgba(211,135,84,1);"
          />
          <polygon
            points="122.03,45.97 120.89,45.74 119.93,45.1 119.28,44.13 119.06,42.99 119.28,41.85 119.93,40.89 120.89,40.24 122.03,40.02 135.92,40.02 137.06,40.24 138.03,40.89 138.67,41.85 138.9,42.99 138.67,44.13 138.03,45.1 137.06,45.74 135.92,45.97 "
            style="fill:rgba(211,135,84,1);"
          />
          <polygon
            points="13.89,68.79 14.09,67.77 14.66,66.92 15.52,66.34 16.54,66.14 17.55,66.34 18.41,66.92 18.98,67.77 19.18,68.79 19.18,75.4 18.98,76.41 18.41,77.27 17.55,77.85 16.54,78.05 15.52,77.85 14.66,77.27 14.09,76.41 13.89,75.4 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="13.89,88.63 14.09,87.62 14.66,86.76 15.52,86.19 16.54,85.98 17.55,86.19 18.41,86.76 18.98,87.62 19.18,88.63 19.18,88.63 18.98,89.64 18.41,90.5 17.55,91.07 16.54,91.28 15.52,91.07 14.66,90.5 14.09,89.64 13.89,88.63 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="20.5,68.79 20.71,67.77 21.28,66.92 22.14,66.34 23.15,66.14 24.16,66.34 25.02,66.92 25.59,67.77 25.8,68.79 25.8,75.4 25.59,76.41 25.02,77.27 24.16,77.85 23.15,78.05 22.14,77.85 21.28,77.27 20.71,76.41 20.5,75.4 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="20.5,95.24 20.71,94.23 21.28,93.37 22.14,92.8 23.15,92.6 24.16,92.8 25.02,93.37 25.59,94.23 25.8,95.24 25.8,95.24 25.59,96.26 25.02,97.11 24.16,97.69 23.15,97.89 22.14,97.69 21.28,97.11 20.71,96.26 20.5,95.24 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="27.12,68.79 27.32,67.77 27.89,66.92 28.75,66.34 29.76,66.14 30.78,66.34 31.63,66.92 32.21,67.77 32.41,68.79 32.41,82.02 32.21,83.03 31.63,83.89 30.78,84.46 29.76,84.66 28.75,84.46 27.89,83.89 27.32,83.03 27.12,82.02 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="33.73,68.79 33.93,67.77 34.51,66.92 35.37,66.34 36.38,66.14 37.39,66.34 38.25,66.92 38.82,67.77 39.02,68.79 39.02,68.79 38.82,69.8 38.25,70.66 37.39,71.23 36.38,71.43 35.37,71.23 34.51,70.66 33.93,69.8 33.73,68.79 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="33.73,88.63 33.93,87.62 34.51,86.76 35.37,86.19 36.38,85.98 37.39,86.19 38.25,86.76 38.82,87.62 39.02,88.63 39.02,95.24 38.82,96.26 38.25,97.11 37.39,97.69 36.38,97.89 35.37,97.69 34.51,97.11 33.93,96.26 33.73,95.24 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="40.35,68.79 40.55,67.77 41.12,66.92 41.98,66.34 42.99,66.14 44,66.34 44.86,66.92 45.44,67.77 45.64,68.79 45.64,68.79 45.44,69.8 44.86,70.66 44,71.23 42.99,71.43 41.98,71.23 41.12,70.66 40.55,69.8 40.35,68.79 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="40.35,82.02 40.55,81 41.12,80.14 41.98,79.57 42.99,79.37 44,79.57 44.86,80.14 45.44,81 45.64,82.02 45.64,82.02 45.44,83.03 44.86,83.89 44,84.46 42.99,84.66 41.98,84.46 41.12,83.89 40.55,83.03 40.35,82.02 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="40.35,95.24 40.55,94.23 41.12,93.37 41.98,92.8 42.99,92.6 44,92.8 44.86,93.37 45.44,94.23 45.64,95.24 45.64,95.24 45.44,96.26 44.86,97.11 44,97.69 42.99,97.89 41.98,97.69 41.12,97.11 40.55,96.26 40.35,95.24 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="46.96,75.4 47.16,74.39 47.74,73.53 48.59,72.96 49.61,72.76 50.62,72.96 51.48,73.53 52.05,74.39 52.25,75.4 52.25,82.02 52.05,83.03 51.48,83.89 50.62,84.46 49.61,84.66 48.59,84.46 47.74,83.89 47.16,83.03 46.96,82.02 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="53.57,68.79 53.78,67.77 54.35,66.92 55.21,66.34 56.22,66.14 57.23,66.34 58.09,66.92 58.66,67.77 58.87,68.79 58.87,68.79 58.66,69.8 58.09,70.66 57.23,71.23 56.22,71.43 55.21,71.23 54.35,70.66 53.78,69.8 53.57,68.79 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="53.57,82.02 53.78,81 54.35,80.14 55.21,79.57 56.22,79.37 57.23,79.57 58.09,80.14 58.66,81 58.87,82.02 58.87,82.02 58.66,83.03 58.09,83.89 57.23,84.46 56.22,84.66 55.21,84.46 54.35,83.89 53.78,83.03 53.57,82.02 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="53.57,95.24 53.78,94.23 54.35,93.37 55.21,92.8 56.22,92.6 57.23,92.8 58.09,93.37 58.66,94.23 58.87,95.24 58.87,95.24 58.66,96.26 58.09,97.11 57.23,97.69 56.22,97.89 55.21,97.69 54.35,97.11 53.78,96.26 53.57,95.24 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="60.19,68.79 60.39,67.77 60.96,66.92 61.82,66.34 62.83,66.14 63.85,66.34 64.71,66.92 65.28,67.77 65.48,68.79 65.48,75.4 65.28,76.41 64.71,77.27 63.85,77.85 62.83,78.05 61.82,77.85 60.96,77.27 60.39,76.41 60.19,75.4 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="66.8,22.49 67,21.48 67.58,20.62 68.44,20.04 69.45,19.84 70.46,20.04 71.32,20.62 71.89,21.48 72.09,22.49 72.09,22.49 71.89,23.5 71.32,24.36 70.46,24.93 69.45,25.13 68.44,24.93 67.58,24.36 67,23.5 66.8,22.49 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="66.8,35.72 67,34.7 67.58,33.85 68.44,33.27 69.45,33.07 70.46,33.27 71.32,33.85 71.89,34.7 72.09,35.72 72.09,35.72 71.89,36.73 71.32,37.59 70.46,38.16 69.45,38.36 68.44,38.16 67.58,37.59 67,36.73 66.8,35.72 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="66.8,48.94 67,47.93 67.58,47.07 68.44,46.5 69.45,46.3 70.46,46.5 71.32,47.07 71.89,47.93 72.09,48.94 72.09,55.56 71.89,56.57 71.32,57.43 70.46,58 69.45,58.2 68.44,58 67.58,57.43 67,56.57 66.8,55.56 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="66.8,68.79 67,67.77 67.58,66.92 68.44,66.34 69.45,66.14 70.46,66.34 71.32,66.92 71.89,67.77 72.09,68.79 72.09,68.79 71.89,69.8 71.32,70.66 70.46,71.23 69.45,71.43 68.44,71.23 67.58,70.66 67,69.8 66.8,68.79 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="66.8,82.02 67,81 67.58,80.14 68.44,79.57 69.45,79.37 70.46,79.57 71.32,80.14 71.89,81 72.09,82.02 72.09,82.02 71.89,83.03 71.32,83.89 70.46,84.46 69.45,84.66 68.44,84.46 67.58,83.89 67,83.03 66.8,82.02 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="66.8,95.24 67,94.23 67.58,93.37 68.44,92.8 69.45,92.6 70.46,92.8 71.32,93.37 71.89,94.23 72.09,95.24 72.09,108.47 71.89,109.48 71.32,110.34 70.46,110.92 69.45,111.12 68.44,110.92 67.58,110.34 67,109.48 66.8,108.47 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="66.8,121.7 67,120.69 67.58,119.83 68.44,119.26 69.45,119.06 70.46,119.26 71.32,119.83 71.89,120.69 72.09,121.7 72.09,148.16 71.89,149.17 71.32,150.03 70.46,150.6 69.45,150.8 68.44,150.6 67.58,150.03 67,149.17 66.8,148.16 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="73.42,22.49 73.62,21.48 74.19,20.62 75.05,20.04 76.06,19.84 77.08,20.04 77.93,20.62 78.51,21.48 78.71,22.49 78.71,22.49 78.51,23.5 77.93,24.36 77.08,24.93 76.06,25.13 75.05,24.93 74.19,24.36 73.62,23.5 73.42,22.49 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="73.42,35.72 73.62,34.7 74.19,33.85 75.05,33.27 76.06,33.07 77.08,33.27 77.93,33.85 78.51,34.7 78.71,35.72 78.71,42.33 78.51,43.34 77.93,44.2 77.08,44.77 76.06,44.98 75.05,44.77 74.19,44.2 73.62,43.34 73.42,42.33 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="73.42,62.17 73.62,61.16 74.19,60.3 75.05,59.73 76.06,59.53 77.08,59.73 77.93,60.3 78.51,61.16 78.71,62.17 78.71,62.17 78.51,63.19 77.93,64.04 77.08,64.62 76.06,64.82 75.05,64.62 74.19,64.04 73.62,63.19 73.42,62.17 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="73.42,75.4 73.62,74.39 74.19,73.53 75.05,72.96 76.06,72.76 77.08,72.96 77.93,73.53 78.51,74.39 78.71,75.4 78.71,82.02 78.51,83.03 77.93,83.89 77.08,84.46 76.06,84.66 75.05,84.46 74.19,83.89 73.62,83.03 73.42,82.02 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="73.42,95.24 73.62,94.23 74.19,93.37 75.05,92.8 76.06,92.6 77.08,92.8 77.93,93.37 78.51,94.23 78.71,95.24 78.71,95.24 78.51,96.26 77.93,97.11 77.08,97.69 76.06,97.89 75.05,97.69 74.19,97.11 73.62,96.26 73.42,95.24 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="73.42,115.09 73.62,114.07 74.19,113.22 75.05,112.64 76.06,112.44 77.08,112.64 77.93,113.22 78.51,114.07 78.71,115.09 78.71,134.93 78.51,135.94 77.93,136.8 77.08,137.37 76.06,137.57 75.05,137.37 74.19,136.8 73.62,135.94 73.42,134.93 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="73.42,148.16 73.62,147.15 74.19,146.29 75.05,145.71 76.06,145.51 77.08,145.71 77.93,146.29 78.51,147.15 78.71,148.16 78.71,148.16 78.51,149.17 77.93,150.03 77.08,150.6 76.06,150.8 75.05,150.6 74.19,150.03 73.62,149.17 73.42,148.16 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="80.03,15.87 80.23,14.86 80.81,14 81.66,13.43 82.68,13.23 83.69,13.43 84.55,14 85.12,14.86 85.32,15.87 85.32,29.1 85.12,30.11 84.55,30.97 83.69,31.55 82.68,31.75 81.66,31.55 80.81,30.97 80.23,30.11 80.03,29.1 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="80.03,55.56 80.23,54.55 80.81,53.69 81.66,53.11 82.68,52.91 83.69,53.11 84.55,53.69 85.12,54.55 85.32,55.56 85.32,55.56 85.12,56.57 84.55,57.43 83.69,58 82.68,58.2 81.66,58 80.81,57.43 80.23,56.57 80.03,55.56 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="80.03,101.86 80.23,100.85 80.81,99.99 81.66,99.41 82.68,99.21 83.69,99.41 84.55,99.99 85.12,100.85 85.32,101.86 85.32,101.86 85.12,102.87 84.55,103.73 83.69,104.3 82.68,104.5 81.66,104.3 80.81,103.73 80.23,102.87 80.03,101.86 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="80.03,115.09 80.23,114.07 80.81,113.22 81.66,112.64 82.68,112.44 83.69,112.64 84.55,113.22 85.12,114.07 85.32,115.09 85.32,121.7 85.12,122.71 84.55,123.57 83.69,124.15 82.68,124.35 81.66,124.15 80.81,123.57 80.23,122.71 80.03,121.7 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="80.03,141.54 80.23,140.53 80.81,139.67 81.66,139.1 82.68,138.9 83.69,139.1 84.55,139.67 85.12,140.53 85.32,141.54 85.32,148.16 85.12,149.17 84.55,150.03 83.69,150.6 82.68,150.8 81.66,150.6 80.81,150.03 80.23,149.17 80.03,148.16 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="86.65,15.87 86.85,14.86 87.42,14 88.28,13.43 89.29,13.23 90.3,13.43 91.16,14 91.74,14.86 91.94,15.87 91.94,15.87 91.74,16.89 91.16,17.74 90.3,18.32 89.29,18.52 88.28,18.32 87.42,17.74 86.85,16.89 86.65,15.87 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="86.65,29.1 86.85,28.09 87.42,27.23 88.28,26.66 89.29,26.46 90.3,26.66 91.16,27.23 91.74,28.09 91.94,29.1 91.94,29.1 91.74,30.11 91.16,30.97 90.3,31.55 89.29,31.75 88.28,31.55 87.42,30.97 86.85,30.11 86.65,29.1 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="86.65,48.94 86.85,47.93 87.42,47.07 88.28,46.5 89.29,46.3 90.3,46.5 91.16,47.07 91.74,47.93 91.94,48.94 91.94,48.94 91.74,49.96 91.16,50.82 90.3,51.39 89.29,51.59 88.28,51.39 87.42,50.82 86.85,49.96 86.65,48.94 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="86.65,68.79 86.85,67.77 87.42,66.92 88.28,66.34 89.29,66.14 90.3,66.34 91.16,66.92 91.74,67.77 91.94,68.79 91.94,75.4 91.74,76.41 91.16,77.27 90.3,77.85 89.29,78.05 88.28,77.85 87.42,77.27 86.85,76.41 86.65,75.4 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="86.65,88.63 86.85,87.62 87.42,86.76 88.28,86.19 89.29,85.98 90.3,86.19 91.16,86.76 91.74,87.62 91.94,88.63 91.94,88.63 91.74,89.64 91.16,90.5 90.3,91.07 89.29,91.28 88.28,91.07 87.42,90.5 86.85,89.64 86.65,88.63 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="86.65,108.47 86.85,107.46 87.42,106.6 88.28,106.03 89.29,105.83 90.3,106.03 91.16,106.6 91.74,107.46 91.94,108.47 91.94,108.47 91.74,109.48 91.16,110.34 90.3,110.92 89.29,111.12 88.28,110.92 87.42,110.34 86.85,109.48 86.65,108.47 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="86.65,121.7 86.85,120.69 87.42,119.83 88.28,119.26 89.29,119.06 90.3,119.26 91.16,119.83 91.74,120.69 91.94,121.7 91.94,128.31 91.74,129.33 91.16,130.19 90.3,130.76 89.29,130.96 88.28,130.76 87.42,130.19 86.85,129.33 86.65,128.31 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="86.65,141.54 86.85,140.53 87.42,139.67 88.28,139.1 89.29,138.9 90.3,139.1 91.16,139.67 91.74,140.53 91.94,141.54 91.94,141.54 91.74,142.56 91.16,143.41 90.3,143.99 89.29,144.19 88.28,143.99 87.42,143.41 86.85,142.56 86.65,141.54 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="93.26,15.87 93.46,14.86 94.03,14 94.89,13.43 95.91,13.23 96.92,13.43 97.78,14 98.35,14.86 98.55,15.87 98.55,42.33 98.35,43.34 97.78,44.2 96.92,44.77 95.91,44.98 94.89,44.77 94.03,44.2 93.46,43.34 93.26,42.33 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="93.26,55.56 93.46,54.55 94.03,53.69 94.89,53.11 95.91,52.91 96.92,53.11 97.78,53.69 98.35,54.55 98.55,55.56 98.55,55.56 98.35,56.57 97.78,57.43 96.92,58 95.91,58.2 94.89,58 94.03,57.43 93.46,56.57 93.26,55.56 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="93.26,75.4 93.46,74.39 94.03,73.53 94.89,72.96 95.91,72.76 96.92,72.96 97.78,73.53 98.35,74.39 98.55,75.4 98.55,101.86 98.35,102.87 97.78,103.73 96.92,104.3 95.91,104.5 94.89,104.3 94.03,103.73 93.46,102.87 93.26,101.86 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="93.26,128.31 93.46,127.3 94.03,126.44 94.89,125.87 95.91,125.67 96.92,125.87 97.78,126.44 98.35,127.3 98.55,128.31 98.55,148.16 98.35,149.17 97.78,150.03 96.92,150.6 95.91,150.8 94.89,150.6 94.03,150.03 93.46,149.17 93.26,148.16 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="99.87,68.79 100.08,67.77 100.65,66.92 101.51,66.34 102.52,66.14 103.53,66.34 104.39,66.92 104.96,67.77 105.17,68.79 105.17,75.4 104.96,76.41 104.39,77.27 103.53,77.85 102.52,78.05 101.51,77.85 100.65,77.27 100.08,76.41 99.87,75.4 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="99.87,88.63 100.08,87.62 100.65,86.76 101.51,86.19 102.52,85.98 103.53,86.19 104.39,86.76 104.96,87.62 105.17,88.63 105.17,88.63 104.96,89.64 104.39,90.5 103.53,91.07 102.52,91.28 101.51,91.07 100.65,90.5 100.08,89.64 99.87,88.63 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="99.87,108.47 100.08,107.46 100.65,106.6 101.51,106.03 102.52,105.83 103.53,106.03 104.39,106.6 104.96,107.46 105.17,108.47 105.17,108.47 104.96,109.48 104.39,110.34 103.53,110.92 102.52,111.12 101.51,110.92 100.65,110.34 100.08,109.48 99.87,108.47 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="99.87,121.7 100.08,120.69 100.65,119.83 101.51,119.26 102.52,119.06 103.53,119.26 104.39,119.83 104.96,120.69 105.17,121.7 105.17,128.31 104.96,129.33 104.39,130.19 103.53,130.76 102.52,130.96 101.51,130.76 100.65,130.19 100.08,129.33 99.87,128.31 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="99.87,141.54 100.08,140.53 100.65,139.67 101.51,139.1 102.52,138.9 103.53,139.1 104.39,139.67 104.96,140.53 105.17,141.54 105.17,141.54 104.96,142.56 104.39,143.41 103.53,143.99 102.52,144.19 101.51,143.99 100.65,143.41 100.08,142.56 99.87,141.54 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="106.49,75.4 106.69,74.39 107.26,73.53 108.12,72.96 109.13,72.76 110.15,72.96 111,73.53 111.58,74.39 111.78,75.4 111.78,88.63 111.58,89.64 111,90.5 110.15,91.07 109.13,91.28 108.12,91.07 107.26,90.5 106.69,89.64 106.49,88.63 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="106.49,128.31 106.69,127.3 107.26,126.44 108.12,125.87 109.13,125.67 110.15,125.87 111,126.44 111.58,127.3 111.78,128.31 111.78,141.54 111.58,142.56 111,143.41 110.15,143.99 109.13,144.19 108.12,143.99 107.26,143.41 106.69,142.56 106.49,141.54 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="113.1,68.79 113.3,67.77 113.88,66.92 114.74,66.34 115.75,66.14 116.76,66.34 117.62,66.92 118.19,67.77 118.39,68.79 118.39,68.79 118.19,69.8 117.62,70.66 116.76,71.23 115.75,71.43 114.74,71.23 113.88,70.66 113.3,69.8 113.1,68.79 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="113.1,82.02 113.3,81 113.88,80.14 114.74,79.57 115.75,79.37 116.76,79.57 117.62,80.14 118.19,81 118.39,82.02 118.39,82.02 118.19,83.03 117.62,83.89 116.76,84.46 115.75,84.66 114.74,84.46 113.88,83.89 113.3,83.03 113.1,82.02 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="113.1,95.24 113.3,94.23 113.88,93.37 114.74,92.8 115.75,92.6 116.76,92.8 117.62,93.37 118.19,94.23 118.39,95.24 118.39,101.86 118.19,102.87 117.62,103.73 116.76,104.3 115.75,104.5 114.74,104.3 113.88,103.73 113.3,102.87 113.1,101.86 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="113.1,115.09 113.3,114.07 113.88,113.22 114.74,112.64 115.75,112.44 116.76,112.64 117.62,113.22 118.19,114.07 118.39,115.09 118.39,115.09 118.19,116.1 117.62,116.96 116.76,117.53 115.75,117.73 114.74,117.53 113.88,116.96 113.3,116.1 113.1,115.09 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="113.1,128.31 113.3,127.3 113.88,126.44 114.74,125.87 115.75,125.67 116.76,125.87 117.62,126.44 118.19,127.3 118.39,128.31 118.39,148.16 118.19,149.17 117.62,150.03 116.76,150.6 115.75,150.8 114.74,150.6 113.88,150.03 113.3,149.17 113.1,148.16 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="119.72,108.47 119.92,107.46 120.49,106.6 121.35,106.03 122.36,105.83 123.37,106.03 124.23,106.6 124.81,107.46 125.01,108.47 125.01,121.7 124.81,122.71 124.23,123.57 123.37,124.15 122.36,124.35 121.35,124.15 120.49,123.57 119.92,122.71 119.72,121.7 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="119.72,141.54 119.92,140.53 120.49,139.67 121.35,139.1 122.36,138.9 123.37,139.1 124.23,139.67 124.81,140.53 125.01,141.54 125.01,141.54 124.81,142.56 124.23,143.41 123.37,143.99 122.36,144.19 121.35,143.99 120.49,143.41 119.92,142.56 119.72,141.54 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="126.33,68.79 126.53,67.77 127.11,66.92 127.96,66.34 128.98,66.14 129.99,66.34 130.85,66.92 131.42,67.77 131.62,68.79 131.62,82.02 131.42,83.03 130.85,83.89 129.99,84.46 128.98,84.66 127.96,84.46 127.11,83.89 126.53,83.03 126.33,82.02 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="126.33,108.47 126.53,107.46 127.11,106.6 127.96,106.03 128.98,105.83 129.99,106.03 130.85,106.6 131.42,107.46 131.62,108.47 131.62,108.47 131.42,109.48 130.85,110.34 129.99,110.92 128.98,111.12 127.96,110.92 127.11,110.34 126.53,109.48 126.33,108.47 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="126.33,121.7 126.53,120.69 127.11,119.83 127.96,119.26 128.98,119.06 129.99,119.26 130.85,119.83 131.42,120.69 131.62,121.7 131.62,134.93 131.42,135.94 130.85,136.8 129.99,137.37 128.98,137.57 127.96,137.37 127.11,136.8 126.53,135.94 126.33,134.93 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="132.94,75.4 133.15,74.39 133.72,73.53 134.58,72.96 135.59,72.76 136.6,72.96 137.46,73.53 138.03,74.39 138.24,75.4 138.24,75.4 138.03,76.41 137.46,77.27 136.6,77.85 135.59,78.05 134.58,77.85 133.72,77.27 133.15,76.41 132.94,75.4 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="132.94,88.63 133.15,87.62 133.72,86.76 134.58,86.19 135.59,85.98 136.6,86.19 137.46,86.76 138.03,87.62 138.24,88.63 138.24,88.63 138.03,89.64 137.46,90.5 136.6,91.07 135.59,91.28 134.58,91.07 133.72,90.5 133.15,89.64 132.94,88.63 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="132.94,101.86 133.15,100.85 133.72,99.99 134.58,99.41 135.59,99.21 136.6,99.41 137.46,99.99 138.03,100.85 138.24,101.86 138.24,101.86 138.03,102.87 137.46,103.73 136.6,104.3 135.59,104.5 134.58,104.3 133.72,103.73 133.15,102.87 132.94,101.86 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="132.94,115.09 133.15,114.07 133.72,113.22 134.58,112.64 135.59,112.44 136.6,112.64 137.46,113.22 138.03,114.07 138.24,115.09 138.24,148.16 138.03,149.17 137.46,150.03 136.6,150.6 135.59,150.8 134.58,150.6 133.72,150.03 133.15,149.17 132.94,148.16 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="139.56,68.79 139.76,67.77 140.33,66.92 141.19,66.34 142.2,66.14 143.22,66.34 144.08,66.92 144.65,67.77 144.85,68.79 144.85,75.4 144.65,76.41 144.08,77.27 143.22,77.85 142.2,78.05 141.19,77.85 140.33,77.27 139.76,76.41 139.56,75.4 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="139.56,88.63 139.76,87.62 140.33,86.76 141.19,86.19 142.2,85.98 143.22,86.19 144.08,86.76 144.65,87.62 144.85,88.63 144.85,95.24 144.65,96.26 144.08,97.11 143.22,97.69 142.2,97.89 141.19,97.69 140.33,97.11 139.76,96.26 139.56,95.24 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="139.56,108.47 139.76,107.46 140.33,106.6 141.19,106.03 142.2,105.83 143.22,106.03 144.08,106.6 144.65,107.46 144.85,108.47 144.85,108.47 144.65,109.48 144.08,110.34 143.22,110.92 142.2,111.12 141.19,110.92 140.33,110.34 139.76,109.48 139.56,108.47 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="139.56,141.54 139.76,140.53 140.33,139.67 141.19,139.1 142.2,138.9 143.22,139.1 144.08,139.67 144.65,140.53 144.85,141.54 144.85,141.54 144.65,142.56 144.08,143.41 143.22,143.99 142.2,144.19 141.19,143.99 140.33,143.41 139.76,142.56 139.56,141.54 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="146.17,75.4 146.37,74.39 146.95,73.53 147.81,72.96 148.82,72.76 149.83,72.96 150.69,73.53 151.26,74.39 151.46,75.4 151.46,88.63 151.26,89.64 150.69,90.5 149.83,91.07 148.82,91.28 147.81,91.07 146.95,90.5 146.37,89.64 146.17,88.63 "
            style="fill:rgba(28,125,138,1);"
          />
          <polygon
            points="146.17,108.47 146.37,107.46 146.95,106.6 147.81,106.03 148.82,105.83 149.83,106.03 150.69,106.6 151.26,107.46 151.46,108.47 151.46,115.09 151.26,116.1 150.69,116.96 149.83,117.53 148.82,117.73 147.81,117.53 146.95,116.96 146.37,116.1 146.17,115.09 "
            style="fill:rgba(28,125,138,1);"
          />
      `,
            },
            {
                value: 14,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(255,255,255,0);"
            shape-rendering="crispEdges"
          />
          <polygon
            points="13.23,13.23 59.53,13.23 59.53,59.53 13.23,59.53 13.23,19.78 19.84,19.78 19.84,52.91 52.91,52.91 52.91,19.84 13.23,19.84 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="13.23,105.83 59.53,105.83 59.53,152.13 13.23,152.13 13.23,112.37 19.84,112.37 19.84,145.51 52.91,145.51 52.91,112.44 13.23,112.44 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="105.83,13.23 152.13,13.23 152.13,59.53 105.83,59.53 105.83,19.78 112.44,19.78 112.44,52.91 145.51,52.91 145.51,19.84 105.83,19.84 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon points="26.46,26.46 46.3,26.46 46.3,46.3 26.46,46.3 " style="fill:rgba(34,82,94,1);" />
          <polygon points="26.46,119.06 46.3,119.06 46.3,138.9 26.46,138.9 " style="fill:rgba(34,82,94,1);" />
          <polygon points="119.06,26.46 138.9,26.46 138.9,46.3 119.06,46.3 " style="fill:rgba(34,82,94,1);" />
          <polygon
            points="79.37,15.54 79.55,14.66 80.05,13.91 80.8,13.4 81.69,13.23 86.05,13.23 86.05,19.91 79.37,19.91 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="85.92,16.54 85.92,13.23 92.66,13.23 92.66,19.84 85.92,19.84 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="92.53,13.23 96.9,13.23 97.78,13.4 98.53,13.91 99.04,14.66 99.21,15.54 99.21,19.91 92.53,19.91 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="66.14,22.16 66.32,21.27 66.82,20.52 67.57,20.02 68.46,19.84 72.82,19.84 72.82,26.46 68.46,26.46 67.57,26.28 66.82,25.78 66.32,25.03 66.14,24.14 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="72.69,23.15 72.69,19.84 79.44,19.84 79.44,26.46 72.69,26.46 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon points="79.3,23.15 79.3,19.78 85.98,19.78 85.98,26.52 79.3,26.52 " style="fill:rgba(34,82,94,1);" />
          <polygon points="92.6,23.15 92.6,19.78 99.21,19.78 99.21,26.52 92.6,26.52 " style="fill:rgba(34,82,94,1);" />
          <polygon
            points="79.37,26.39 86.05,26.39 86.05,33.07 81.69,33.07 80.8,32.89 80.05,32.39 79.55,31.64 79.37,30.76 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="85.92,29.76 85.92,26.46 92.66,26.46 92.66,33.07 85.92,33.07 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="92.53,29.76 92.53,26.39 99.21,26.39 99.21,33.14 92.53,33.14 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="66.14,35.39 66.32,34.5 66.82,33.75 67.57,33.25 68.46,33.07 72.82,33.07 72.82,39.69 68.46,39.69 67.57,39.51 66.82,39.01 66.32,38.26 66.14,37.37 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="72.69,33.07 77.06,33.07 77.94,33.25 78.69,33.75 79.19,34.5 79.37,35.39 79.37,39.75 72.69,39.75 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon points="92.6,36.38 92.6,33 99.21,33 99.21,39.75 92.6,39.75 " style="fill:rgba(34,82,94,1);" />
          <polygon
            points="72.76,39.62 79.37,39.62 79.37,43.98 79.19,44.87 78.69,45.62 77.94,46.12 77.06,46.3 75.07,46.3 74.18,46.12 73.43,45.62 72.93,44.87 72.76,43.98 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="92.6,39.62 99.21,39.62 99.21,43.98 99.04,44.87 98.53,45.62 97.78,46.12 96.9,46.3 94.91,46.3 94.03,46.12 93.28,45.62 92.77,44.87 92.6,43.98 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="66.14,48.61 66.32,47.73 66.82,46.98 67.57,46.48 68.46,46.3 70.44,46.3 71.33,46.48 72.08,46.98 72.58,47.73 72.76,48.61 72.76,52.98 66.14,52.98 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="85.98,48.61 86.16,47.73 86.66,46.98 87.41,46.48 88.3,46.3 90.28,46.3 91.17,46.48 91.92,46.98 92.42,47.73 92.6,48.61 92.6,50.6 92.42,51.48 91.92,52.24 91.17,52.74 90.28,52.91 88.3,52.91 87.41,52.74 86.66,52.24 86.16,51.48 85.98,50.6 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="66.14,52.85 72.76,52.85 72.76,57.21 72.58,58.1 72.08,58.85 71.33,59.35 70.44,59.53 68.46,59.53 67.57,59.35 66.82,58.85 66.32,58.1 66.14,57.21 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="79.37,55.23 79.55,54.34 80.05,53.59 80.8,53.09 81.69,52.91 83.67,52.91 84.56,53.09 85.31,53.59 85.81,54.34 85.98,55.23 85.98,57.21 85.81,58.1 85.31,58.85 84.56,59.35 83.67,59.53 81.69,59.53 80.8,59.35 80.05,58.85 79.55,58.1 79.37,57.21 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="92.6,55.23 92.77,54.34 93.28,53.59 94.03,53.09 94.91,52.91 96.9,52.91 97.78,53.09 98.53,53.59 99.04,54.34 99.21,55.23 99.21,57.21 99.04,58.1 98.53,58.85 97.78,59.35 96.9,59.53 94.91,59.53 94.03,59.35 93.28,58.85 92.77,58.1 92.6,57.21 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="72.76,61.84 72.93,60.96 73.43,60.21 74.18,59.7 75.07,59.53 77.06,59.53 77.94,59.7 78.69,60.21 79.19,60.96 79.37,61.84 79.37,63.83 79.19,64.71 78.69,65.46 77.94,65.97 77.06,66.14 75.07,66.14 74.18,65.97 73.43,65.46 72.93,64.71 72.76,63.83 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="13.23,68.46 13.4,67.57 13.91,66.82 14.66,66.32 15.54,66.14 19.91,66.14 19.91,72.82 13.23,72.82 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="19.78,69.45 19.78,66.14 26.52,66.14 26.52,72.82 19.78,72.82 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="26.39,69.45 26.39,66.14 33.14,66.14 33.14,72.82 26.39,72.82 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon points="33,69.45 33,66.14 39.75,66.14 39.75,72.76 33,72.76 " style="fill:rgba(34,82,94,1);" />
          <polygon
            points="39.62,66.14 43.98,66.14 44.87,66.32 45.62,66.82 46.12,67.57 46.3,68.46 46.3,70.44 46.12,71.33 45.62,72.08 44.87,72.58 43.98,72.76 39.62,72.76 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="52.91,68.46 53.09,67.57 53.59,66.82 54.34,66.32 55.23,66.14 59.59,66.14 59.59,72.76 55.23,72.76 54.34,72.58 53.59,72.08 53.09,71.33 52.91,70.44 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="59.46,69.45 59.46,66.14 66.21,66.14 66.21,72.82 59.46,72.82 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="66.08,66.14 70.44,66.14 71.33,66.32 72.08,66.82 72.58,67.57 72.76,68.46 72.76,70.44 72.58,71.33 72.08,72.08 71.33,72.58 70.44,72.76 66.08,72.76 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="85.98,68.46 86.16,67.57 86.66,66.82 87.41,66.32 88.3,66.14 90.28,66.14 91.17,66.32 91.92,66.82 92.42,67.57 92.6,68.46 92.6,72.82 85.98,72.82 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="99.21,68.46 99.39,67.57 99.89,66.82 100.64,66.32 101.53,66.14 103.51,66.14 104.4,66.32 105.15,66.82 105.65,67.57 105.83,68.46 105.83,72.82 99.21,72.82 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="112.44,68.46 112.62,67.57 113.12,66.82 113.87,66.32 114.76,66.14 116.74,66.14 117.63,66.32 118.38,66.82 118.88,67.57 119.06,68.46 119.06,70.44 118.88,71.33 118.38,72.08 117.63,72.58 116.74,72.76 114.76,72.76 113.87,72.58 113.12,72.08 112.62,71.33 112.44,70.44 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="125.67,68.46 125.85,67.57 126.35,66.82 127.1,66.32 127.98,66.14 129.97,66.14 130.85,66.32 131.61,66.82 132.11,67.57 132.28,68.46 132.28,72.82 125.67,72.82 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="138.9,68.46 139.07,67.57 139.58,66.82 140.33,66.32 141.21,66.14 143.2,66.14 144.08,66.32 144.83,66.82 145.34,67.57 145.51,68.46 145.51,72.82 138.9,72.82 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="13.23,72.69 19.91,72.69 19.91,79.37 15.54,79.37 14.66,79.19 13.91,78.69 13.4,77.94 13.23,77.06 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="19.78,76.06 19.78,72.69 26.52,72.69 26.52,79.37 19.78,79.37 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="26.39,76.06 26.39,72.69 33.07,72.69 33.07,79.44 26.39,79.44 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="46.3,75.07 46.48,74.18 46.98,73.43 47.73,72.93 48.61,72.76 50.6,72.76 51.48,72.93 52.24,73.43 52.74,74.18 52.91,75.07 52.91,79.44 46.3,79.44 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="59.53,72.69 66.14,72.69 66.14,77.06 65.97,77.94 65.46,78.69 64.71,79.19 63.83,79.37 61.84,79.37 60.96,79.19 60.21,78.69 59.7,77.94 59.53,77.06 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="72.76,75.07 72.93,74.18 73.43,73.43 74.18,72.93 75.07,72.76 77.06,72.76 77.94,72.93 78.69,73.43 79.19,74.18 79.37,75.07 79.37,79.44 72.76,79.44 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="85.98,72.69 92.66,72.69 92.66,79.37 88.3,79.37 87.41,79.19 86.66,78.69 86.16,77.94 85.98,77.06 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="92.53,76.06 92.53,72.76 99.28,72.76 99.28,79.44 92.53,79.44 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="99.15,76.06 99.15,72.69 105.89,72.69 105.89,79.37 99.15,79.37 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="105.76,72.76 110.13,72.76 111.01,72.93 111.76,73.43 112.26,74.18 112.44,75.07 112.44,79.44 105.76,79.44 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="125.67,76.06 125.67,72.69 132.35,72.69 132.35,79.44 125.67,79.44 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="132.22,76.06 132.22,72.76 138.96,72.76 138.96,79.37 132.22,79.37 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="138.83,76.06 138.83,72.69 145.58,72.69 145.58,79.37 138.83,79.37 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="145.45,72.76 149.81,72.76 150.7,72.93 151.45,73.43 151.95,74.18 152.13,75.07 152.13,79.44 145.45,79.44 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="26.46,79.3 33.07,79.3 33.07,83.67 32.89,84.56 32.39,85.31 31.64,85.81 30.76,85.98 28.77,85.98 27.89,85.81 27.13,85.31 26.63,84.56 26.46,83.67 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="39.69,81.69 39.86,80.8 40.36,80.05 41.11,79.55 42,79.37 46.37,79.37 46.37,85.98 42,85.98 41.11,85.81 40.36,85.31 39.86,84.56 39.69,83.67 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon points="46.23,82.68 46.23,79.3 52.98,79.3 52.98,85.98 46.23,85.98 " style="fill:rgba(34,82,94,1);" />
          <polygon
            points="52.85,79.37 57.21,79.37 58.1,79.55 58.85,80.05 59.35,80.8 59.53,81.69 59.53,83.67 59.35,84.56 58.85,85.31 58.1,85.81 57.21,85.98 52.85,85.98 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="66.14,81.69 66.32,80.8 66.82,80.05 67.57,79.55 68.46,79.37 72.82,79.37 72.82,85.98 68.46,85.98 67.57,85.81 66.82,85.31 66.32,84.56 66.14,83.67 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="72.69,79.3 79.37,79.3 79.37,83.67 79.19,84.56 78.69,85.31 77.94,85.81 77.06,85.98 72.69,85.98 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon points="92.6,82.68 92.6,79.3 99.21,79.3 99.21,86.05 92.6,86.05 " style="fill:rgba(34,82,94,1);" />
          <polygon
            points="105.83,82.68 105.83,79.3 112.51,79.3 112.51,86.05 105.83,86.05 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="112.37,79.37 116.74,79.37 117.63,79.55 118.38,80.05 118.88,80.8 119.06,81.69 119.06,83.67 118.88,84.56 118.38,85.31 117.63,85.81 116.74,85.98 112.37,85.98 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="125.67,79.3 132.28,79.3 132.28,83.67 132.11,84.56 131.61,85.31 130.85,85.81 129.97,85.98 127.98,85.98 127.1,85.81 126.35,85.31 125.85,84.56 125.67,83.67 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="145.51,82.68 145.51,79.3 152.13,79.3 152.13,86.05 145.51,86.05 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="13.23,88.3 13.4,87.41 13.91,86.66 14.66,86.16 15.54,85.98 17.53,85.98 18.41,86.16 19.16,86.66 19.67,87.41 19.84,88.3 19.84,90.28 19.67,91.17 19.16,91.92 18.41,92.42 17.53,92.6 15.54,92.6 14.66,92.42 13.91,91.92 13.4,91.17 13.23,90.28 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="33.07,88.3 33.25,87.41 33.75,86.66 34.5,86.16 35.39,85.98 37.37,85.98 38.26,86.16 39.01,86.66 39.51,87.41 39.69,88.3 39.69,92.66 33.07,92.66 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="85.98,88.3 86.16,87.41 86.66,86.66 87.41,86.16 88.3,85.98 92.66,85.98 92.66,92.6 88.3,92.6 87.41,92.42 86.66,91.92 86.16,91.17 85.98,90.28 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="92.53,89.29 92.53,85.92 99.28,85.92 99.28,92.66 92.53,92.66 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="99.15,89.29 99.15,85.98 105.89,85.98 105.89,92.6 99.15,92.6 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="105.76,85.92 112.44,85.92 112.44,90.28 112.26,91.17 111.76,91.92 111.01,92.42 110.13,92.6 105.76,92.6 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="132.28,88.3 132.46,87.41 132.96,86.66 133.71,86.16 134.6,85.98 138.96,85.98 138.96,92.6 134.6,92.6 133.71,92.42 132.96,91.92 132.46,91.17 132.28,90.28 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="138.83,89.29 138.83,85.98 145.58,85.98 145.58,92.66 138.83,92.66 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="145.45,85.92 152.13,85.92 152.13,90.28 151.95,91.17 151.45,91.92 150.7,92.42 149.81,92.6 145.45,92.6 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="19.84,94.91 20.02,94.03 20.52,93.28 21.27,92.77 22.16,92.6 24.14,92.6 25.03,92.77 25.78,93.28 26.28,94.03 26.46,94.91 26.46,96.9 26.28,97.78 25.78,98.53 25.03,99.04 24.14,99.21 22.16,99.21 21.27,99.04 20.52,98.53 20.02,97.78 19.84,96.9 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="33.07,92.53 39.75,92.53 39.75,99.21 35.39,99.21 34.5,99.04 33.75,98.53 33.25,97.78 33.07,96.9 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="39.62,92.6 43.98,92.6 44.87,92.77 45.62,93.28 46.12,94.03 46.3,94.91 46.3,96.9 46.12,97.78 45.62,98.53 44.87,99.04 43.98,99.21 39.62,99.21 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="52.91,94.91 53.09,94.03 53.59,93.28 54.34,92.77 55.23,92.6 57.21,92.6 58.1,92.77 58.85,93.28 59.35,94.03 59.53,94.91 59.53,96.9 59.35,97.78 58.85,98.53 58.1,99.04 57.21,99.21 55.23,99.21 54.34,99.04 53.59,98.53 53.09,97.78 52.91,96.9 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="66.14,94.91 66.32,94.03 66.82,93.28 67.57,92.77 68.46,92.6 72.82,92.6 72.82,99.28 66.14,99.28 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="72.69,92.6 77.06,92.6 77.94,92.77 78.69,93.28 79.19,94.03 79.37,94.91 79.37,96.9 79.19,97.78 78.69,98.53 77.94,99.04 77.06,99.21 72.69,99.21 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon points="92.6,95.91 92.6,92.53 99.21,92.53 99.21,99.28 92.6,99.28 " style="fill:rgba(34,82,94,1);" />
          <polygon
            points="112.44,94.91 112.62,94.03 113.12,93.28 113.87,92.77 114.76,92.6 116.74,92.6 117.63,92.77 118.38,93.28 118.88,94.03 119.06,94.91 119.06,99.28 112.44,99.28 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="138.9,92.53 145.51,92.53 145.51,96.9 145.34,97.78 144.83,98.53 144.08,99.04 143.2,99.21 141.21,99.21 140.33,99.04 139.58,98.53 139.07,97.78 138.9,96.9 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="66.14,102.52 66.14,99.15 72.76,99.15 72.76,105.89 66.14,105.89 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="79.37,101.53 79.55,100.64 80.05,99.89 80.8,99.39 81.69,99.21 83.67,99.21 84.56,99.39 85.31,99.89 85.81,100.64 85.98,101.53 85.98,103.51 85.81,104.4 85.31,105.15 84.56,105.65 83.67,105.83 81.69,105.83 80.8,105.65 80.05,105.15 79.55,104.4 79.37,103.51 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="92.6,99.15 99.21,99.15 99.21,103.51 99.04,104.4 98.53,105.15 97.78,105.65 96.9,105.83 94.91,105.83 94.03,105.65 93.28,105.15 92.77,104.4 92.6,103.51 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="112.44,99.15 119.06,99.15 119.06,103.51 118.88,104.4 118.38,105.15 117.63,105.65 116.74,105.83 114.76,105.83 113.87,105.65 113.12,105.15 112.62,104.4 112.44,103.51 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="132.28,101.53 132.46,100.64 132.96,99.89 133.71,99.39 134.6,99.21 136.58,99.21 137.47,99.39 138.22,99.89 138.72,100.64 138.9,101.53 138.9,103.51 138.72,104.4 138.22,105.15 137.47,105.65 136.58,105.83 134.6,105.83 133.71,105.65 132.96,105.15 132.46,104.4 132.28,103.51 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="66.14,105.76 72.76,105.76 72.76,110.13 72.58,111.01 72.08,111.76 71.33,112.26 70.44,112.44 68.46,112.44 67.57,112.26 66.82,111.76 66.32,111.01 66.14,110.13 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="85.98,108.14 86.16,107.26 86.66,106.5 87.41,106 88.3,105.83 90.28,105.83 91.17,106 91.92,106.5 92.42,107.26 92.6,108.14 92.6,110.13 92.42,111.01 91.92,111.76 91.17,112.26 90.28,112.44 88.3,112.44 87.41,112.26 86.66,111.76 86.16,111.01 85.98,110.13 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="99.21,108.14 99.39,107.26 99.89,106.5 100.64,106 101.53,105.83 103.51,105.83 104.4,106 105.15,106.5 105.65,107.26 105.83,108.14 105.83,110.13 105.65,111.01 105.15,111.76 104.4,112.26 103.51,112.44 101.53,112.44 100.64,112.26 99.89,111.76 99.39,111.01 99.21,110.13 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="119.06,108.14 119.23,107.26 119.73,106.5 120.48,106 121.37,105.83 125.74,105.83 125.74,112.51 119.06,112.51 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="125.6,105.83 129.97,105.83 130.85,106 131.61,106.5 132.11,107.26 132.28,108.14 132.28,110.13 132.11,111.01 131.61,111.76 130.85,112.26 129.97,112.44 125.6,112.44 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="138.9,108.14 139.07,107.26 139.58,106.5 140.33,106 141.21,105.83 145.58,105.83 145.58,112.44 141.21,112.44 140.33,112.26 139.58,111.76 139.07,111.01 138.9,110.13 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="145.45,105.83 149.81,105.83 150.7,106 151.45,106.5 151.95,107.26 152.13,108.14 152.13,112.51 145.45,112.51 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="72.76,114.76 72.93,113.87 73.43,113.12 74.18,112.62 75.07,112.44 79.44,112.44 79.44,119.12 72.76,119.12 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="79.3,112.44 83.67,112.44 84.56,112.62 85.31,113.12 85.81,113.87 85.98,114.76 85.98,119.12 79.3,119.12 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="112.44,114.76 112.62,113.87 113.12,113.12 113.87,112.62 114.76,112.44 119.12,112.44 119.12,119.06 114.76,119.06 113.87,118.88 113.12,118.38 112.62,117.63 112.44,116.74 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="118.99,115.75 118.99,112.37 125.67,112.37 125.67,119.12 118.99,119.12 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="132.28,114.76 132.46,113.87 132.96,113.12 133.71,112.62 134.6,112.44 136.58,112.44 137.47,112.62 138.22,113.12 138.72,113.87 138.9,114.76 138.9,119.12 132.28,119.12 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="145.51,112.37 152.13,112.37 152.13,116.74 151.95,117.63 151.45,118.38 150.7,118.88 149.81,119.06 147.83,119.06 146.94,118.88 146.19,118.38 145.69,117.63 145.51,116.74 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="66.14,121.37 66.32,120.48 66.82,119.73 67.57,119.23 68.46,119.06 72.82,119.06 72.82,125.74 66.14,125.74 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="72.69,122.36 72.69,118.99 79.44,118.99 79.44,125.74 72.69,125.74 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="79.3,122.36 79.3,118.99 86.05,118.99 86.05,125.67 79.3,125.67 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="85.92,119.06 90.28,119.06 91.17,119.23 91.92,119.73 92.42,120.48 92.6,121.37 92.6,125.74 85.92,125.74 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="99.21,121.37 99.39,120.48 99.89,119.73 100.64,119.23 101.53,119.06 103.51,119.06 104.4,119.23 105.15,119.73 105.65,120.48 105.83,121.37 105.83,125.74 99.21,125.74 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="119.06,118.99 125.74,118.99 125.74,125.67 121.37,125.67 120.48,125.49 119.73,124.99 119.23,124.24 119.06,123.35 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="125.6,122.36 125.6,119.06 132.35,119.06 132.35,125.74 125.6,125.74 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="132.22,122.36 132.22,118.99 138.9,118.99 138.9,125.74 132.22,125.74 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="66.14,128.98 66.14,125.6 72.82,125.6 72.82,132.35 66.14,132.35 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="72.69,128.98 72.69,125.6 79.37,125.6 79.37,132.35 72.69,132.35 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="85.98,125.6 92.66,125.6 92.66,132.28 88.3,132.28 87.41,132.11 86.66,131.61 86.16,130.85 85.98,129.97 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="92.53,128.98 92.53,125.67 99.28,125.67 99.28,132.35 92.53,132.35 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="99.15,128.98 99.15,125.6 105.89,125.6 105.89,132.28 99.15,132.28 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="105.76,128.98 105.76,125.67 112.51,125.67 112.51,132.35 105.76,132.35 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="112.37,125.67 116.74,125.67 117.63,125.85 118.38,126.35 118.88,127.1 119.06,127.98 119.06,132.35 112.37,132.35 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="125.67,128.98 125.67,125.6 132.35,125.6 132.35,132.35 125.67,132.35 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="132.22,128.98 132.22,125.6 138.9,125.6 138.9,132.35 132.22,132.35 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="66.14,135.59 66.14,132.22 72.82,132.22 72.82,138.96 66.14,138.96 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="72.69,132.22 79.37,132.22 79.37,136.58 79.19,137.47 78.69,138.22 77.94,138.72 77.06,138.9 72.69,138.9 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="92.6,135.59 92.6,132.22 99.21,132.22 99.21,138.96 92.6,138.96 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="105.83,135.59 105.83,132.22 112.51,132.22 112.51,138.96 105.83,138.96 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="112.37,135.59 112.37,132.22 119.06,132.22 119.06,138.96 112.37,138.96 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="125.67,132.22 132.35,132.22 132.35,138.9 127.98,138.9 127.1,138.72 126.35,138.22 125.85,137.47 125.67,136.58 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="132.22,135.59 132.22,132.22 138.9,132.22 138.9,138.96 132.22,138.96 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="66.14,142.2 66.14,138.83 72.76,138.83 72.76,145.58 66.14,145.58 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="79.37,141.21 79.55,140.33 80.05,139.58 80.8,139.07 81.69,138.9 86.05,138.9 86.05,145.58 79.37,145.58 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="85.92,142.2 85.92,138.9 92.66,138.9 92.66,145.51 85.92,145.51 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="92.53,142.2 92.53,138.83 99.28,138.83 99.28,145.58 92.53,145.58 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="99.15,142.2 99.15,138.9 105.89,138.9 105.89,145.51 99.15,145.51 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="105.76,142.2 105.76,138.83 112.51,138.83 112.51,145.51 105.76,145.51 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="112.37,142.2 112.37,138.83 119.12,138.83 119.12,145.58 112.37,145.58 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="118.99,138.9 123.35,138.9 124.24,139.07 124.99,139.58 125.49,140.33 125.67,141.21 125.67,143.2 125.49,144.08 124.99,144.83 124.24,145.34 123.35,145.51 118.99,145.51 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="132.28,142.2 132.28,138.83 138.96,138.83 138.96,145.58 132.28,145.58 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="138.83,138.9 143.2,138.9 144.08,139.07 144.83,139.58 145.34,140.33 145.51,141.21 145.51,143.2 145.34,144.08 144.83,144.83 144.08,145.34 143.2,145.51 138.83,145.51 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="66.14,145.45 72.82,145.45 72.82,152.13 68.46,152.13 67.57,151.95 66.82,151.45 66.32,150.7 66.14,149.81 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="72.69,148.82 72.69,145.51 79.44,145.51 79.44,152.13 72.69,152.13 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="79.3,145.45 85.98,145.45 85.98,149.81 85.81,150.7 85.31,151.45 84.56,151.95 83.67,152.13 79.3,152.13 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="92.6,145.45 99.21,145.45 99.21,149.81 99.04,150.7 98.53,151.45 97.78,151.95 96.9,152.13 94.91,152.13 94.03,151.95 93.28,151.45 92.77,150.7 92.6,149.81 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="112.44,145.45 119.06,145.45 119.06,149.81 118.88,150.7 118.38,151.45 117.63,151.95 116.74,152.13 114.76,152.13 113.87,151.95 113.12,151.45 112.62,150.7 112.44,149.81 "
            style="fill:rgba(34,82,94,1);"
          />
          <polygon
            points="132.28,145.45 138.9,145.45 138.9,149.81 138.72,150.7 138.22,151.45 137.47,151.95 136.58,152.13 134.6,152.13 133.71,151.95 132.96,151.45 132.46,150.7 132.28,149.81 "
            style="fill:rgba(34,82,94,1);"
          />
      `,
            },
            {
                value: 15,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(255,255,255,0);"
            shape-rendering="crispEdges"
          />
          <linearGradient
            id="gradient8cf8a5340f764af99aaa126963e7fc60"
            gradientUnits="userSpaceOnUse"
            x1="13.2283458709717"
            y1="82.6771602630615"
            x2="152.125974655151"
            y2="82.6771602630615"
          >
            <stop offset="0%" stop-color="#664F80" />
            <stop offset="50%" stop-color="#BD5F20" />
            <stop offset="100%" stop-color="#664F80" />
          </linearGradient>
          <polygon
            points="13.23,13.23 59.53,13.23 59.53,59.53 13.23,59.53 13.23,19.78 19.84,19.78 19.84,52.91 52.91,52.91 52.91,19.84 13.23,19.84 "
            style="fill:url(#gradient8cf8a5340f764af99aaa126963e7fc60);"
          />
          <polygon
            points="13.23,105.83 59.53,105.83 59.53,152.13 13.23,152.13 13.23,112.37 19.84,112.37 19.84,145.51 52.91,145.51 52.91,112.44 13.23,112.44 "
            style="fill:url(#gradient8cf8a5340f764af99aaa126963e7fc60);"
          />
          <polygon
            points="105.83,13.23 152.13,13.23 152.13,59.53 105.83,59.53 105.83,19.78 112.44,19.78 112.44,52.91 145.51,52.91 145.51,19.84 105.83,19.84 "
            style="fill:url(#gradient8cf8a5340f764af99aaa126963e7fc60);"
          />
          <linearGradient
            id="gradienta6cf858c9d1545e2a4924e8cdc53b488"
            gradientUnits="userSpaceOnUse"
            x1="16.1676322453161"
            y1="44.2778655522009"
            x2="149.18668446611"
            y2="121.076451159225"
          >
            <stop offset="0%" stop-color="#BFB7B8" />
            <stop offset="50%" stop-color="#C71D1C" />
            <stop offset="100%" stop-color="#BFB7B8" />
          </linearGradient>
          <polygon
            points="26.46,26.46 46.3,26.46 46.3,46.3 26.46,46.3 "
            style="fill:url(#gradienta6cf858c9d1545e2a4924e8cdc53b488);"
          />
          <polygon
            points="26.46,119.06 46.3,119.06 46.3,138.9 26.46,138.9 "
            style="fill:url(#gradienta6cf858c9d1545e2a4924e8cdc53b488);"
          />
          <polygon
            points="119.06,26.46 138.9,26.46 138.9,46.3 119.06,46.3 "
            style="fill:url(#gradienta6cf858c9d1545e2a4924e8cdc53b488);"
          />
          <pattern
            id="hatchfbccd1d7ad5144ee8da67c1bcd81b9e1"
            x="0"
            y="0"
            width="8"
            height="8"
            patternUnits="userSpaceOnUse"
          >
            <rect x="0" y="0" width="8" height="8" fill="#5B8B96" />
            <rect x="0" y="0" width="1" height="1" fill="#B04743" />
            <rect x="1" y="0" width="1" height="1" fill="#B04743" />
            <rect x="2" y="0" width="1" height="1" fill="#B04743" />
            <rect x="3" y="0" width="1" height="1" fill="#B04743" />
            <rect x="4" y="0" width="1" height="1" fill="#B04743" />
            <rect x="5" y="0" width="1" height="1" fill="#B04743" />
            <rect x="6" y="0" width="1" height="1" fill="#B04743" />
            <rect x="7" y="0" width="1" height="1" fill="#B04743" />
            <rect x="0" y="1" width="1" height="1" fill="#B04743" />
            <rect x="1" y="1" width="1" height="1" fill="#B04743" />
            <rect x="2" y="1" width="1" height="1" fill="#B04743" />
            <rect x="3" y="1" width="1" height="1" fill="#B04743" />
            <rect x="4" y="1" width="1" height="1" fill="#B04743" />
            <rect x="5" y="1" width="1" height="1" fill="#B04743" />
            <rect x="6" y="1" width="1" height="1" fill="#B04743" />
            <rect x="7" y="1" width="1" height="1" fill="#B04743" />
            <rect x="0" y="4" width="1" height="1" fill="#B04743" />
            <rect x="1" y="4" width="1" height="1" fill="#B04743" />
            <rect x="2" y="4" width="1" height="1" fill="#B04743" />
            <rect x="3" y="4" width="1" height="1" fill="#B04743" />
            <rect x="4" y="4" width="1" height="1" fill="#B04743" />
            <rect x="5" y="4" width="1" height="1" fill="#B04743" />
            <rect x="6" y="4" width="1" height="1" fill="#B04743" />
            <rect x="7" y="4" width="1" height="1" fill="#B04743" />
            <rect x="0" y="5" width="1" height="1" fill="#B04743" />
            <rect x="1" y="5" width="1" height="1" fill="#B04743" />
            <rect x="2" y="5" width="1" height="1" fill="#B04743" />
            <rect x="3" y="5" width="1" height="1" fill="#B04743" />
            <rect x="4" y="5" width="1" height="1" fill="#B04743" />
            <rect x="5" y="5" width="1" height="1" fill="#B04743" />
            <rect x="6" y="5" width="1" height="1" fill="#B04743" />
            <rect x="7" y="5" width="1" height="1" fill="#B04743" />
          </pattern>
          <polygon
            points="79.37,13.23 86.05,13.23 85.98,19.91 79.37,19.91 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="85.92,13.23 92.66,13.23 92.53,19.84 85.92,19.84 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="92.53,13.23 99.21,13.23 99.15,19.91 92.53,19.91 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="66.14,19.84 72.82,19.84 72.76,26.46 66.14,26.46 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="72.69,19.84 79.44,19.84 79.3,26.46 72.69,26.46 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="79.3,19.78 85.98,19.78 85.92,26.52 79.3,26.52 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="92.6,19.78 99.21,19.78 99.21,26.52 92.6,26.52 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="79.37,26.39 86.05,26.39 85.98,33.07 79.37,33.07 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="85.92,26.46 92.66,26.46 92.53,33.07 85.92,33.07 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="92.53,26.39 99.21,26.39 99.15,33.14 92.53,33.14 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="66.14,33.07 72.82,33.07 72.76,39.69 66.14,39.69 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="72.69,33.07 79.37,33.07 79.3,39.75 72.69,39.75 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="92.6,33 99.21,33 99.21,39.75 92.6,39.75 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="72.76,39.62 79.37,39.62 79.37,46.3 72.76,46.3 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="92.6,39.62 99.21,39.62 99.21,46.3 92.6,46.3 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="66.14,46.3 72.76,46.3 72.76,52.98 66.14,52.98 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="85.98,46.3 92.6,46.3 92.6,52.91 85.98,52.91 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="66.14,52.85 72.76,52.85 72.76,59.53 66.14,59.53 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="79.37,52.91 85.98,52.91 85.98,59.53 79.37,59.53 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="92.6,52.91 99.21,52.91 99.21,59.53 92.6,59.53 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="72.76,59.53 79.37,59.53 79.37,66.14 72.76,66.14 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="13.23,66.14 19.91,66.14 19.84,72.82 13.23,72.82 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="19.78,66.14 26.52,66.14 26.39,72.82 19.78,72.82 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="26.39,66.14 33.14,66.14 33,72.82 26.39,72.82 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="33,66.14 39.75,66.14 39.62,72.76 33,72.76 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="39.62,66.14 46.3,66.14 46.23,72.76 39.62,72.76 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="52.91,66.14 59.59,66.14 59.53,72.76 52.91,72.76 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="59.46,66.14 66.21,66.14 66.08,72.82 59.46,72.82 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="66.08,66.14 72.76,66.14 72.69,72.76 66.08,72.76 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="85.98,66.14 92.6,66.14 92.6,72.82 85.98,72.82 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="99.21,66.14 105.83,66.14 105.83,72.82 99.21,72.82 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="112.44,66.14 119.06,66.14 119.06,72.76 112.44,72.76 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="125.67,66.14 132.28,66.14 132.28,72.82 125.67,72.82 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="138.9,66.14 145.51,66.14 145.51,72.82 138.9,72.82 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="13.23,72.69 19.91,72.69 19.84,79.37 13.23,79.37 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="19.78,72.69 26.52,72.69 26.39,79.37 19.78,79.37 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="26.39,72.69 33.07,72.69 33,79.44 26.39,79.44 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="46.3,72.76 52.91,72.76 52.91,79.44 46.3,79.44 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="59.53,72.69 66.14,72.69 66.14,79.37 59.53,79.37 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="72.76,72.76 79.37,72.76 79.37,79.44 72.76,79.44 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="85.98,72.69 92.66,72.69 92.6,79.37 85.98,79.37 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="92.53,72.76 99.28,72.76 99.15,79.44 92.53,79.44 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="99.15,72.69 105.89,72.69 105.76,79.37 99.15,79.37 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="105.76,72.76 112.44,72.76 112.37,79.44 105.76,79.44 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="125.67,72.69 132.35,72.69 132.28,79.44 125.67,79.44 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="132.22,72.76 138.96,72.76 138.83,79.37 132.22,79.37 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="138.83,72.69 145.58,72.69 145.45,79.37 138.83,79.37 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="145.45,72.76 152.13,72.76 152.06,79.44 145.45,79.44 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="26.46,79.3 33.07,79.3 33.07,85.98 26.46,85.98 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="39.69,79.37 46.37,79.37 46.3,85.98 39.69,85.98 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="46.23,79.3 52.98,79.3 52.85,85.98 46.23,85.98 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="52.85,79.37 59.53,79.37 59.46,85.98 52.85,85.98 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="66.14,79.37 72.82,79.37 72.76,85.98 66.14,85.98 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="72.69,79.3 79.37,79.3 79.3,85.98 72.69,85.98 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="92.6,79.3 99.21,79.3 99.21,86.05 92.6,86.05 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="105.83,79.3 112.51,79.3 112.44,86.05 105.83,86.05 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="112.37,79.37 119.06,79.37 118.99,85.98 112.37,85.98 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="125.67,79.3 132.28,79.3 132.28,85.98 125.67,85.98 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="145.51,79.3 152.13,79.3 152.13,86.05 145.51,86.05 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="13.23,85.98 19.84,85.98 19.84,92.6 13.23,92.6 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="33.07,85.98 39.69,85.98 39.69,92.66 33.07,92.66 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="85.98,85.98 92.66,85.98 92.6,92.6 85.98,92.6 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="92.53,85.92 99.28,85.92 99.15,92.66 92.53,92.66 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="99.15,85.98 105.89,85.98 105.76,92.6 99.15,92.6 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="105.76,85.92 112.44,85.92 112.37,92.6 105.76,92.6 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="132.28,85.98 138.96,85.98 138.9,92.6 132.28,92.6 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="138.83,85.98 145.58,85.98 145.45,92.66 138.83,92.66 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="145.45,85.92 152.13,85.92 152.06,92.6 145.45,92.6 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="19.84,92.6 26.46,92.6 26.46,99.21 19.84,99.21 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="33.07,92.53 39.75,92.53 39.69,99.21 33.07,99.21 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="39.62,92.6 46.3,92.6 46.23,99.21 39.62,99.21 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="52.91,92.6 59.53,92.6 59.53,99.21 52.91,99.21 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="66.14,92.6 72.82,92.6 72.76,99.28 66.14,99.28 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="72.69,92.6 79.37,92.6 79.3,99.21 72.69,99.21 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="92.6,92.53 99.21,92.53 99.21,99.28 92.6,99.28 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="112.44,92.6 119.06,92.6 119.06,99.28 112.44,99.28 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="138.9,92.53 145.51,92.53 145.51,99.21 138.9,99.21 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="66.14,99.15 72.76,99.15 72.76,105.89 66.14,105.89 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="79.37,99.21 85.98,99.21 85.98,105.83 79.37,105.83 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="92.6,99.15 99.21,99.15 99.21,105.83 92.6,105.83 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="112.44,99.15 119.06,99.15 119.06,105.83 112.44,105.83 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="132.28,99.21 138.9,99.21 138.9,105.83 132.28,105.83 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="66.14,105.76 72.76,105.76 72.76,112.44 66.14,112.44 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="85.98,105.83 92.6,105.83 92.6,112.44 85.98,112.44 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="99.21,105.83 105.83,105.83 105.83,112.44 99.21,112.44 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="119.06,105.83 125.74,105.83 125.67,112.51 119.06,112.51 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="125.6,105.83 132.28,105.83 132.22,112.44 125.6,112.44 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="138.9,105.83 145.58,105.83 145.51,112.44 138.9,112.44 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="145.45,105.83 152.13,105.83 152.06,112.51 145.45,112.51 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="72.76,112.44 79.44,112.44 79.37,119.12 72.76,119.12 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="79.3,112.44 85.98,112.44 85.92,119.12 79.3,119.12 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="112.44,112.44 119.12,112.44 119.06,119.06 112.44,119.06 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="118.99,112.37 125.67,112.37 125.6,119.12 118.99,119.12 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="132.28,112.44 138.9,112.44 138.9,119.12 132.28,119.12 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="145.51,112.37 152.13,112.37 152.13,119.06 145.51,119.06 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="66.14,119.06 72.82,119.06 72.76,125.74 66.14,125.74 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="72.69,118.99 79.44,118.99 79.3,125.74 72.69,125.74 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="79.3,118.99 86.05,118.99 85.92,125.67 79.3,125.67 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="85.92,119.06 92.6,119.06 92.53,125.74 85.92,125.74 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="99.21,119.06 105.83,119.06 105.83,125.74 99.21,125.74 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="119.06,118.99 125.74,118.99 125.67,125.67 119.06,125.67 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="125.6,119.06 132.35,119.06 132.22,125.74 125.6,125.74 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="132.22,118.99 138.9,118.99 138.83,125.74 132.22,125.74 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="66.14,125.6 72.82,125.6 72.76,132.35 66.14,132.35 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="72.69,125.6 79.37,125.6 79.3,132.35 72.69,132.35 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="85.98,125.6 92.66,125.6 92.6,132.28 85.98,132.28 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="92.53,125.67 99.28,125.67 99.15,132.35 92.53,132.35 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="99.15,125.6 105.89,125.6 105.76,132.28 99.15,132.28 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="105.76,125.67 112.51,125.67 112.37,132.35 105.76,132.35 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="112.37,125.67 119.06,125.67 118.99,132.35 112.37,132.35 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="125.67,125.6 132.35,125.6 132.28,132.35 125.67,132.35 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="132.22,125.6 138.9,125.6 138.83,132.35 132.22,132.35 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="66.14,132.22 72.82,132.22 72.76,138.96 66.14,138.96 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="72.69,132.22 79.37,132.22 79.3,138.9 72.69,138.9 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="92.6,132.22 99.21,132.22 99.21,138.96 92.6,138.96 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="105.83,132.22 112.51,132.22 112.44,138.96 105.83,138.96 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="112.37,132.22 119.06,132.22 118.99,138.96 112.37,138.96 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="125.67,132.22 132.35,132.22 132.28,138.9 125.67,138.9 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="132.22,132.22 138.9,132.22 138.83,138.96 132.22,138.96 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="66.14,138.83 72.76,138.83 72.76,145.58 66.14,145.58 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="79.37,138.9 86.05,138.9 85.98,145.58 79.37,145.58 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="85.92,138.9 92.66,138.9 92.53,145.51 85.92,145.51 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="92.53,138.83 99.28,138.83 99.15,145.58 92.53,145.58 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="99.15,138.9 105.89,138.9 105.76,145.51 99.15,145.51 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="105.76,138.83 112.51,138.83 112.37,145.51 105.76,145.51 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="112.37,138.83 119.12,138.83 118.99,145.58 112.37,145.58 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="118.99,138.9 125.67,138.9 125.6,145.51 118.99,145.51 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="132.28,138.83 138.96,138.83 138.9,145.58 132.28,145.58 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="138.83,138.9 145.51,138.9 145.45,145.51 138.83,145.51 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="66.14,145.45 72.82,145.45 72.76,152.13 66.14,152.13 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="72.69,145.51 79.44,145.51 79.3,152.13 72.69,152.13 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="79.3,145.45 85.98,145.45 85.92,152.13 79.3,152.13 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="92.6,145.45 99.21,145.45 99.21,152.13 92.6,152.13 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="112.44,145.45 119.06,145.45 119.06,152.13 112.44,152.13 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
          <polygon
            points="132.28,145.45 138.9,145.45 138.9,152.13 132.28,152.13 "
            style="fill:url(#hatchfbccd1d7ad5144ee8da67c1bcd81b9e1);"
          />
      `,
            },
            {
                value: 16,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(255,255,255,0);"
            shape-rendering="crispEdges"
          />
          <linearGradient
            id="gradient0cf66245bbc14c159cbe9c68d2239764"
            gradientUnits="userSpaceOnUse"
            x1="9.78888088478347"
            y1="78.8572474050841"
            x2="155.56543964134"
            y2="86.497073121039"
          >
            <stop offset="0%" stop-color="#933C35" />
            <stop offset="100%" stop-color="#7A6A42" />
          </linearGradient>
          <polygon
            points="13.23,13.23 59.53,13.23 59.53,59.53 13.23,59.53 13.23,19.78 19.84,19.78 19.84,52.91 52.91,52.91 52.91,19.84 13.23,19.84 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="13.23,105.83 59.53,105.83 59.53,152.13 13.23,152.13 13.23,112.37 19.84,112.37 19.84,145.51 52.91,145.51 52.91,112.44 13.23,112.44 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="105.83,13.23 152.13,13.23 152.13,59.53 105.83,59.53 105.83,19.78 112.44,19.78 112.44,52.91 145.51,52.91 145.51,19.84 105.83,19.84 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="26.46,26.46 46.3,26.46 46.3,46.3 26.46,46.3 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="26.46,119.06 46.3,119.06 46.3,138.9 26.46,138.9 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="119.06,26.46 138.9,26.46 138.9,46.3 119.06,46.3 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="82.68,19.18 81.66,18.98 80.81,18.41 80.23,17.55 80.03,16.54 80.23,15.52 80.81,14.66 81.66,14.09 82.68,13.89 95.91,13.89 96.92,14.09 97.78,14.66 98.35,15.52 98.55,16.54 98.35,17.55 97.78,18.41 96.92,18.98 95.91,19.18 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="69.45,25.8 68.44,25.59 67.58,25.02 67,24.16 66.8,23.15 67,22.14 67.58,21.28 68.44,20.71 69.45,20.5 82.68,20.5 83.69,20.71 84.55,21.28 85.12,22.14 85.32,23.15 85.12,24.16 84.55,25.02 83.69,25.59 82.68,25.8 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="95.91,25.8 94.89,25.59 94.03,25.02 93.46,24.16 93.26,23.15 93.46,22.14 94.03,21.28 94.89,20.71 95.91,20.5 95.91,20.5 96.92,20.71 97.78,21.28 98.35,22.14 98.55,23.15 98.35,24.16 97.78,25.02 96.92,25.59 95.91,25.8 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="82.68,32.41 81.66,32.21 80.81,31.63 80.23,30.78 80.03,29.76 80.23,28.75 80.81,27.89 81.66,27.32 82.68,27.12 95.91,27.12 96.92,27.32 97.78,27.89 98.35,28.75 98.55,29.76 98.35,30.78 97.78,31.63 96.92,32.21 95.91,32.41 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="69.45,39.02 68.44,38.82 67.58,38.25 67,37.39 66.8,36.38 67,35.37 67.58,34.51 68.44,33.93 69.45,33.73 76.06,33.73 77.08,33.93 77.93,34.51 78.51,35.37 78.71,36.38 78.51,37.39 77.93,38.25 77.08,38.82 76.06,39.02 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="95.91,39.02 94.89,38.82 94.03,38.25 93.46,37.39 93.26,36.38 93.46,35.37 94.03,34.51 94.89,33.93 95.91,33.73 95.91,33.73 96.92,33.93 97.78,34.51 98.35,35.37 98.55,36.38 98.35,37.39 97.78,38.25 96.92,38.82 95.91,39.02 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="76.06,45.64 75.05,45.44 74.19,44.86 73.62,44 73.42,42.99 73.62,41.98 74.19,41.12 75.05,40.55 76.06,40.35 76.06,40.35 77.08,40.55 77.93,41.12 78.51,41.98 78.71,42.99 78.51,44 77.93,44.86 77.08,45.44 76.06,45.64 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="95.91,45.64 94.89,45.44 94.03,44.86 93.46,44 93.26,42.99 93.46,41.98 94.03,41.12 94.89,40.55 95.91,40.35 95.91,40.35 96.92,40.55 97.78,41.12 98.35,41.98 98.55,42.99 98.35,44 97.78,44.86 96.92,45.44 95.91,45.64 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="69.45,52.25 68.44,52.05 67.58,51.48 67,50.62 66.8,49.61 67,48.59 67.58,47.74 68.44,47.16 69.45,46.96 69.45,46.96 70.46,47.16 71.32,47.74 71.89,48.59 72.09,49.61 71.89,50.62 71.32,51.48 70.46,52.05 69.45,52.25 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="89.29,52.25 88.28,52.05 87.42,51.48 86.85,50.62 86.65,49.61 86.85,48.59 87.42,47.74 88.28,47.16 89.29,46.96 89.29,46.96 90.3,47.16 91.16,47.74 91.74,48.59 91.94,49.61 91.74,50.62 91.16,51.48 90.3,52.05 89.29,52.25 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="69.45,58.87 68.44,58.66 67.58,58.09 67,57.23 66.8,56.22 67,55.21 67.58,54.35 68.44,53.78 69.45,53.57 69.45,53.57 70.46,53.78 71.32,54.35 71.89,55.21 72.09,56.22 71.89,57.23 71.32,58.09 70.46,58.66 69.45,58.87 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="82.68,58.87 81.66,58.66 80.81,58.09 80.23,57.23 80.03,56.22 80.23,55.21 80.81,54.35 81.66,53.78 82.68,53.57 82.68,53.57 83.69,53.78 84.55,54.35 85.12,55.21 85.32,56.22 85.12,57.23 84.55,58.09 83.69,58.66 82.68,58.87 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="95.91,58.87 94.89,58.66 94.03,58.09 93.46,57.23 93.26,56.22 93.46,55.21 94.03,54.35 94.89,53.78 95.91,53.57 95.91,53.57 96.92,53.78 97.78,54.35 98.35,55.21 98.55,56.22 98.35,57.23 97.78,58.09 96.92,58.66 95.91,58.87 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="76.06,65.48 75.05,65.28 74.19,64.71 73.62,63.85 73.42,62.83 73.62,61.82 74.19,60.96 75.05,60.39 76.06,60.19 76.06,60.19 77.08,60.39 77.93,60.96 78.51,61.82 78.71,62.83 78.51,63.85 77.93,64.71 77.08,65.28 76.06,65.48 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="69.45,72.09 68.44,71.89 67.58,71.32 67,70.46 66.8,69.45 67,68.44 67.58,67.58 68.44,67 69.45,66.8 69.45,66.8 70.46,67 71.32,67.58 71.89,68.44 72.09,69.45 71.89,70.46 71.32,71.32 70.46,71.89 69.45,72.09 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="89.29,72.09 88.28,71.89 87.42,71.32 86.85,70.46 86.65,69.45 86.85,68.44 87.42,67.58 88.28,67 89.29,66.8 89.29,66.8 90.3,67 91.16,67.58 91.74,68.44 91.94,69.45 91.74,70.46 91.16,71.32 90.3,71.89 89.29,72.09 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="76.06,78.71 75.05,78.51 74.19,77.93 73.62,77.08 73.42,76.06 73.62,75.05 74.19,74.19 75.05,73.62 76.06,73.42 76.06,73.42 77.08,73.62 77.93,74.19 78.51,75.05 78.71,76.06 78.51,77.08 77.93,77.93 77.08,78.51 76.06,78.71 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="89.29,78.71 88.28,78.51 87.42,77.93 86.85,77.08 86.65,76.06 86.85,75.05 87.42,74.19 88.28,73.62 89.29,73.42 89.29,73.42 90.3,73.62 91.16,74.19 91.74,75.05 91.94,76.06 91.74,77.08 91.16,77.93 90.3,78.51 89.29,78.71 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="89.29,91.94 88.28,91.74 87.42,91.16 86.85,90.3 86.65,89.29 86.85,88.28 87.42,87.42 88.28,86.85 89.29,86.65 89.29,86.65 90.3,86.85 91.16,87.42 91.74,88.28 91.94,89.29 91.74,90.3 91.16,91.16 90.3,91.74 89.29,91.94 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="69.45,98.55 68.44,98.35 67.58,97.78 67,96.92 66.8,95.91 67,94.89 67.58,94.03 68.44,93.46 69.45,93.26 76.06,93.26 77.08,93.46 77.93,94.03 78.51,94.89 78.71,95.91 78.51,96.92 77.93,97.78 77.08,98.35 76.06,98.55 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="95.91,98.55 94.89,98.35 94.03,97.78 93.46,96.92 93.26,95.91 93.46,94.89 94.03,94.03 94.89,93.46 95.91,93.26 95.91,93.26 96.92,93.46 97.78,94.03 98.35,94.89 98.55,95.91 98.35,96.92 97.78,97.78 96.92,98.35 95.91,98.55 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="69.45,105.17 68.44,104.96 67.58,104.39 67,103.53 66.8,102.52 67,101.51 67.58,100.65 68.44,100.08 69.45,99.87 69.45,99.87 70.46,100.08 71.32,100.65 71.89,101.51 72.09,102.52 71.89,103.53 71.32,104.39 70.46,104.96 69.45,105.17 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="82.68,105.17 81.66,104.96 80.81,104.39 80.23,103.53 80.03,102.52 80.23,101.51 80.81,100.65 81.66,100.08 82.68,99.87 82.68,99.87 83.69,100.08 84.55,100.65 85.12,101.51 85.32,102.52 85.12,103.53 84.55,104.39 83.69,104.96 82.68,105.17 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="95.91,105.17 94.89,104.96 94.03,104.39 93.46,103.53 93.26,102.52 93.46,101.51 94.03,100.65 94.89,100.08 95.91,99.87 95.91,99.87 96.92,100.08 97.78,100.65 98.35,101.51 98.55,102.52 98.35,103.53 97.78,104.39 96.92,104.96 95.91,105.17 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="69.45,111.78 68.44,111.58 67.58,111 67,110.15 66.8,109.13 67,108.12 67.58,107.26 68.44,106.69 69.45,106.49 69.45,106.49 70.46,106.69 71.32,107.26 71.89,108.12 72.09,109.13 71.89,110.15 71.32,111 70.46,111.58 69.45,111.78 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="89.29,111.78 88.28,111.58 87.42,111 86.85,110.15 86.65,109.13 86.85,108.12 87.42,107.26 88.28,106.69 89.29,106.49 89.29,106.49 90.3,106.69 91.16,107.26 91.74,108.12 91.94,109.13 91.74,110.15 91.16,111 90.3,111.58 89.29,111.78 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="102.52,111.78 101.51,111.58 100.65,111 100.08,110.15 99.87,109.13 100.08,108.12 100.65,107.26 101.51,106.69 102.52,106.49 102.52,106.49 103.53,106.69 104.39,107.26 104.96,108.12 105.17,109.13 104.96,110.15 104.39,111 103.53,111.58 102.52,111.78 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="76.06,118.39 75.05,118.19 74.19,117.62 73.62,116.76 73.42,115.75 73.62,114.74 74.19,113.88 75.05,113.3 76.06,113.1 82.68,113.1 83.69,113.3 84.55,113.88 85.12,114.74 85.32,115.75 85.12,116.76 84.55,117.62 83.69,118.19 82.68,118.39 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="115.75,118.39 114.74,118.19 113.88,117.62 113.3,116.76 113.1,115.75 113.3,114.74 113.88,113.88 114.74,113.3 115.75,113.1 115.75,113.1 116.76,113.3 117.62,113.88 118.19,114.74 118.39,115.75 118.19,116.76 117.62,117.62 116.76,118.19 115.75,118.39 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="69.45,125.01 68.44,124.81 67.58,124.23 67,123.37 66.8,122.36 67,121.35 67.58,120.49 68.44,119.92 69.45,119.72 89.29,119.72 90.3,119.92 91.16,120.49 91.74,121.35 91.94,122.36 91.74,123.37 91.16,124.23 90.3,124.81 89.29,125.01 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="102.52,125.01 101.51,124.81 100.65,124.23 100.08,123.37 99.87,122.36 100.08,121.35 100.65,120.49 101.51,119.92 102.52,119.72 102.52,119.72 103.53,119.92 104.39,120.49 104.96,121.35 105.17,122.36 104.96,123.37 104.39,124.23 103.53,124.81 102.52,125.01 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="122.36,125.01 121.35,124.81 120.49,124.23 119.92,123.37 119.72,122.36 119.92,121.35 120.49,120.49 121.35,119.92 122.36,119.72 122.36,119.72 123.37,119.92 124.23,120.49 124.81,121.35 125.01,122.36 124.81,123.37 124.23,124.23 123.37,124.81 122.36,125.01 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="69.45,131.62 68.44,131.42 67.58,130.85 67,129.99 66.8,128.98 67,127.96 67.58,127.11 68.44,126.53 69.45,126.33 76.06,126.33 77.08,126.53 77.93,127.11 78.51,127.96 78.71,128.98 78.51,129.99 77.93,130.85 77.08,131.42 76.06,131.62 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="89.29,131.62 88.28,131.42 87.42,130.85 86.85,129.99 86.65,128.98 86.85,127.96 87.42,127.11 88.28,126.53 89.29,126.33 115.75,126.33 116.76,126.53 117.62,127.11 118.19,127.96 118.39,128.98 118.19,129.99 117.62,130.85 116.76,131.42 115.75,131.62 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="128.98,131.62 127.96,131.42 127.11,130.85 126.53,129.99 126.33,128.98 126.53,127.96 127.11,127.11 127.96,126.53 128.98,126.33 128.98,126.33 129.99,126.53 130.85,127.11 131.42,127.96 131.62,128.98 131.42,129.99 130.85,130.85 129.99,131.42 128.98,131.62 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="69.45,138.24 68.44,138.03 67.58,137.46 67,136.6 66.8,135.59 67,134.58 67.58,133.72 68.44,133.15 69.45,132.94 76.06,132.94 77.08,133.15 77.93,133.72 78.51,134.58 78.71,135.59 78.51,136.6 77.93,137.46 77.08,138.03 76.06,138.24 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="95.91,138.24 94.89,138.03 94.03,137.46 93.46,136.6 93.26,135.59 93.46,134.58 94.03,133.72 94.89,133.15 95.91,132.94 95.91,132.94 96.92,133.15 97.78,133.72 98.35,134.58 98.55,135.59 98.35,136.6 97.78,137.46 96.92,138.03 95.91,138.24 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="109.13,138.24 108.12,138.03 107.26,137.46 106.69,136.6 106.49,135.59 106.69,134.58 107.26,133.72 108.12,133.15 109.13,132.94 115.75,132.94 116.76,133.15 117.62,133.72 118.19,134.58 118.39,135.59 118.19,136.6 117.62,137.46 116.76,138.03 115.75,138.24 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="128.98,138.24 127.96,138.03 127.11,137.46 126.53,136.6 126.33,135.59 126.53,134.58 127.11,133.72 127.96,133.15 128.98,132.94 135.59,132.94 136.6,133.15 137.46,133.72 138.03,134.58 138.24,135.59 138.03,136.6 137.46,137.46 136.6,138.03 135.59,138.24 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="69.45,144.85 68.44,144.65 67.58,144.08 67,143.22 66.8,142.2 67,141.19 67.58,140.33 68.44,139.76 69.45,139.56 69.45,139.56 70.46,139.76 71.32,140.33 71.89,141.19 72.09,142.2 71.89,143.22 71.32,144.08 70.46,144.65 69.45,144.85 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="82.68,144.85 81.66,144.65 80.81,144.08 80.23,143.22 80.03,142.2 80.23,141.19 80.81,140.33 81.66,139.76 82.68,139.56 122.36,139.56 123.37,139.76 124.23,140.33 124.81,141.19 125.01,142.2 124.81,143.22 124.23,144.08 123.37,144.65 122.36,144.85 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="135.59,144.85 134.58,144.65 133.72,144.08 133.15,143.22 132.94,142.2 133.15,141.19 133.72,140.33 134.58,139.76 135.59,139.56 142.2,139.56 143.22,139.76 144.08,140.33 144.65,141.19 144.85,142.2 144.65,143.22 144.08,144.08 143.22,144.65 142.2,144.85 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="69.45,151.46 68.44,151.26 67.58,150.69 67,149.83 66.8,148.82 67,147.81 67.58,146.95 68.44,146.37 69.45,146.17 82.68,146.17 83.69,146.37 84.55,146.95 85.12,147.81 85.32,148.82 85.12,149.83 84.55,150.69 83.69,151.26 82.68,151.46 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="95.91,151.46 94.89,151.26 94.03,150.69 93.46,149.83 93.26,148.82 93.46,147.81 94.03,146.95 94.89,146.37 95.91,146.17 95.91,146.17 96.92,146.37 97.78,146.95 98.35,147.81 98.55,148.82 98.35,149.83 97.78,150.69 96.92,151.26 95.91,151.46 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="115.75,151.46 114.74,151.26 113.88,150.69 113.3,149.83 113.1,148.82 113.3,147.81 113.88,146.95 114.74,146.37 115.75,146.17 115.75,146.17 116.76,146.37 117.62,146.95 118.19,147.81 118.39,148.82 118.19,149.83 117.62,150.69 116.76,151.26 115.75,151.46 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="135.59,151.46 134.58,151.26 133.72,150.69 133.15,149.83 132.94,148.82 133.15,147.81 133.72,146.95 134.58,146.37 135.59,146.17 135.59,146.17 136.6,146.37 137.46,146.95 138.03,147.81 138.24,148.82 138.03,149.83 137.46,150.69 136.6,151.26 135.59,151.46 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="13.89,69.45 14.09,68.44 14.66,67.58 15.52,67 16.54,66.8 17.55,67 18.41,67.58 18.98,68.44 19.18,69.45 19.18,76.06 18.98,77.08 18.41,77.93 17.55,78.51 16.54,78.71 15.52,78.51 14.66,77.93 14.09,77.08 13.89,76.06 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="13.89,89.29 14.09,88.28 14.66,87.42 15.52,86.85 16.54,86.65 17.55,86.85 18.41,87.42 18.98,88.28 19.18,89.29 19.18,89.29 18.98,90.3 18.41,91.16 17.55,91.74 16.54,91.94 15.52,91.74 14.66,91.16 14.09,90.3 13.89,89.29 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="20.5,69.45 20.71,68.44 21.28,67.58 22.14,67 23.15,66.8 24.16,67 25.02,67.58 25.59,68.44 25.8,69.45 25.8,76.06 25.59,77.08 25.02,77.93 24.16,78.51 23.15,78.71 22.14,78.51 21.28,77.93 20.71,77.08 20.5,76.06 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="20.5,95.91 20.71,94.89 21.28,94.03 22.14,93.46 23.15,93.26 24.16,93.46 25.02,94.03 25.59,94.89 25.8,95.91 25.8,95.91 25.59,96.92 25.02,97.78 24.16,98.35 23.15,98.55 22.14,98.35 21.28,97.78 20.71,96.92 20.5,95.91 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="27.12,69.45 27.32,68.44 27.89,67.58 28.75,67 29.76,66.8 30.78,67 31.63,67.58 32.21,68.44 32.41,69.45 32.41,82.68 32.21,83.69 31.63,84.55 30.78,85.12 29.76,85.32 28.75,85.12 27.89,84.55 27.32,83.69 27.12,82.68 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="33.73,69.45 33.93,68.44 34.51,67.58 35.37,67 36.38,66.8 37.39,67 38.25,67.58 38.82,68.44 39.02,69.45 39.02,69.45 38.82,70.46 38.25,71.32 37.39,71.89 36.38,72.09 35.37,71.89 34.51,71.32 33.93,70.46 33.73,69.45 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="33.73,89.29 33.93,88.28 34.51,87.42 35.37,86.85 36.38,86.65 37.39,86.85 38.25,87.42 38.82,88.28 39.02,89.29 39.02,95.91 38.82,96.92 38.25,97.78 37.39,98.35 36.38,98.55 35.37,98.35 34.51,97.78 33.93,96.92 33.73,95.91 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="40.35,69.45 40.55,68.44 41.12,67.58 41.98,67 42.99,66.8 44,67 44.86,67.58 45.44,68.44 45.64,69.45 45.64,69.45 45.44,70.46 44.86,71.32 44,71.89 42.99,72.09 41.98,71.89 41.12,71.32 40.55,70.46 40.35,69.45 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="40.35,82.68 40.55,81.66 41.12,80.81 41.98,80.23 42.99,80.03 44,80.23 44.86,80.81 45.44,81.66 45.64,82.68 45.64,82.68 45.44,83.69 44.86,84.55 44,85.12 42.99,85.32 41.98,85.12 41.12,84.55 40.55,83.69 40.35,82.68 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="40.35,95.91 40.55,94.89 41.12,94.03 41.98,93.46 42.99,93.26 44,93.46 44.86,94.03 45.44,94.89 45.64,95.91 45.64,95.91 45.44,96.92 44.86,97.78 44,98.35 42.99,98.55 41.98,98.35 41.12,97.78 40.55,96.92 40.35,95.91 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="46.96,76.06 47.16,75.05 47.74,74.19 48.59,73.62 49.61,73.42 50.62,73.62 51.48,74.19 52.05,75.05 52.25,76.06 52.25,82.68 52.05,83.69 51.48,84.55 50.62,85.12 49.61,85.32 48.59,85.12 47.74,84.55 47.16,83.69 46.96,82.68 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="53.57,69.45 53.78,68.44 54.35,67.58 55.21,67 56.22,66.8 57.23,67 58.09,67.58 58.66,68.44 58.87,69.45 58.87,69.45 58.66,70.46 58.09,71.32 57.23,71.89 56.22,72.09 55.21,71.89 54.35,71.32 53.78,70.46 53.57,69.45 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="53.57,82.68 53.78,81.66 54.35,80.81 55.21,80.23 56.22,80.03 57.23,80.23 58.09,80.81 58.66,81.66 58.87,82.68 58.87,82.68 58.66,83.69 58.09,84.55 57.23,85.12 56.22,85.32 55.21,85.12 54.35,84.55 53.78,83.69 53.57,82.68 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="53.57,95.91 53.78,94.89 54.35,94.03 55.21,93.46 56.22,93.26 57.23,93.46 58.09,94.03 58.66,94.89 58.87,95.91 58.87,95.91 58.66,96.92 58.09,97.78 57.23,98.35 56.22,98.55 55.21,98.35 54.35,97.78 53.78,96.92 53.57,95.91 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="60.19,69.45 60.39,68.44 60.96,67.58 61.82,67 62.83,66.8 63.85,67 64.71,67.58 65.28,68.44 65.48,69.45 65.48,76.06 65.28,77.08 64.71,77.93 63.85,78.51 62.83,78.71 61.82,78.51 60.96,77.93 60.39,77.08 60.19,76.06 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="66.8,69.45 67,68.44 67.58,67.58 68.44,67 69.45,66.8 70.46,67 71.32,67.58 71.89,68.44 72.09,69.45 72.09,69.45 71.89,70.46 71.32,71.32 70.46,71.89 69.45,72.09 68.44,71.89 67.58,71.32 67,70.46 66.8,69.45 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="66.8,82.68 67,81.66 67.58,80.81 68.44,80.23 69.45,80.03 70.46,80.23 71.32,80.81 71.89,81.66 72.09,82.68 72.09,82.68 71.89,83.69 71.32,84.55 70.46,85.12 69.45,85.32 68.44,85.12 67.58,84.55 67,83.69 66.8,82.68 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="73.42,76.06 73.62,75.05 74.19,74.19 75.05,73.62 76.06,73.42 77.08,73.62 77.93,74.19 78.51,75.05 78.71,76.06 78.71,82.68 78.51,83.69 77.93,84.55 77.08,85.12 76.06,85.32 75.05,85.12 74.19,84.55 73.62,83.69 73.42,82.68 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="86.65,76.06 86.85,75.05 87.42,74.19 88.28,73.62 89.29,73.42 90.3,73.62 91.16,74.19 91.74,75.05 91.94,76.06 91.94,76.06 91.74,77.08 91.16,77.93 90.3,78.51 89.29,78.71 88.28,78.51 87.42,77.93 86.85,77.08 86.65,76.06 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="93.26,76.06 93.46,75.05 94.03,74.19 94.89,73.62 95.91,73.42 96.92,73.62 97.78,74.19 98.35,75.05 98.55,76.06 98.55,89.29 98.35,90.3 97.78,91.16 96.92,91.74 95.91,91.94 94.89,91.74 94.03,91.16 93.46,90.3 93.26,89.29 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="99.87,69.45 100.08,68.44 100.65,67.58 101.51,67 102.52,66.8 103.53,67 104.39,67.58 104.96,68.44 105.17,69.45 105.17,76.06 104.96,77.08 104.39,77.93 103.53,78.51 102.52,78.71 101.51,78.51 100.65,77.93 100.08,77.08 99.87,76.06 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="99.87,89.29 100.08,88.28 100.65,87.42 101.51,86.85 102.52,86.65 103.53,86.85 104.39,87.42 104.96,88.28 105.17,89.29 105.17,89.29 104.96,90.3 104.39,91.16 103.53,91.74 102.52,91.94 101.51,91.74 100.65,91.16 100.08,90.3 99.87,89.29 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="106.49,76.06 106.69,75.05 107.26,74.19 108.12,73.62 109.13,73.42 110.15,73.62 111,74.19 111.58,75.05 111.78,76.06 111.78,89.29 111.58,90.3 111,91.16 110.15,91.74 109.13,91.94 108.12,91.74 107.26,91.16 106.69,90.3 106.49,89.29 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="113.1,69.45 113.3,68.44 113.88,67.58 114.74,67 115.75,66.8 116.76,67 117.62,67.58 118.19,68.44 118.39,69.45 118.39,69.45 118.19,70.46 117.62,71.32 116.76,71.89 115.75,72.09 114.74,71.89 113.88,71.32 113.3,70.46 113.1,69.45 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="113.1,82.68 113.3,81.66 113.88,80.81 114.74,80.23 115.75,80.03 116.76,80.23 117.62,80.81 118.19,81.66 118.39,82.68 118.39,82.68 118.19,83.69 117.62,84.55 116.76,85.12 115.75,85.32 114.74,85.12 113.88,84.55 113.3,83.69 113.1,82.68 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="113.1,95.91 113.3,94.89 113.88,94.03 114.74,93.46 115.75,93.26 116.76,93.46 117.62,94.03 118.19,94.89 118.39,95.91 118.39,102.52 118.19,103.53 117.62,104.39 116.76,104.96 115.75,105.17 114.74,104.96 113.88,104.39 113.3,103.53 113.1,102.52 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="119.72,109.13 119.92,108.12 120.49,107.26 121.35,106.69 122.36,106.49 123.37,106.69 124.23,107.26 124.81,108.12 125.01,109.13 125.01,115.75 124.81,116.76 124.23,117.62 123.37,118.19 122.36,118.39 121.35,118.19 120.49,117.62 119.92,116.76 119.72,115.75 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="126.33,69.45 126.53,68.44 127.11,67.58 127.96,67 128.98,66.8 129.99,67 130.85,67.58 131.42,68.44 131.62,69.45 131.62,82.68 131.42,83.69 130.85,84.55 129.99,85.12 128.98,85.32 127.96,85.12 127.11,84.55 126.53,83.69 126.33,82.68 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="126.33,109.13 126.53,108.12 127.11,107.26 127.96,106.69 128.98,106.49 129.99,106.69 130.85,107.26 131.42,108.12 131.62,109.13 131.62,109.13 131.42,110.15 130.85,111 129.99,111.58 128.98,111.78 127.96,111.58 127.11,111 126.53,110.15 126.33,109.13 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="126.33,122.36 126.53,121.35 127.11,120.49 127.96,119.92 128.98,119.72 129.99,119.92 130.85,120.49 131.42,121.35 131.62,122.36 131.62,122.36 131.42,123.37 130.85,124.23 129.99,124.81 128.98,125.01 127.96,124.81 127.11,124.23 126.53,123.37 126.33,122.36 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="132.94,76.06 133.15,75.05 133.72,74.19 134.58,73.62 135.59,73.42 136.6,73.62 137.46,74.19 138.03,75.05 138.24,76.06 138.24,76.06 138.03,77.08 137.46,77.93 136.6,78.51 135.59,78.71 134.58,78.51 133.72,77.93 133.15,77.08 132.94,76.06 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="132.94,89.29 133.15,88.28 133.72,87.42 134.58,86.85 135.59,86.65 136.6,86.85 137.46,87.42 138.03,88.28 138.24,89.29 138.24,89.29 138.03,90.3 137.46,91.16 136.6,91.74 135.59,91.94 134.58,91.74 133.72,91.16 133.15,90.3 132.94,89.29 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="132.94,102.52 133.15,101.51 133.72,100.65 134.58,100.08 135.59,99.87 136.6,100.08 137.46,100.65 138.03,101.51 138.24,102.52 138.24,102.52 138.03,103.53 137.46,104.39 136.6,104.96 135.59,105.17 134.58,104.96 133.72,104.39 133.15,103.53 132.94,102.52 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="132.94,115.75 133.15,114.74 133.72,113.88 134.58,113.3 135.59,113.1 136.6,113.3 137.46,113.88 138.03,114.74 138.24,115.75 138.24,128.98 138.03,129.99 137.46,130.85 136.6,131.42 135.59,131.62 134.58,131.42 133.72,130.85 133.15,129.99 132.94,128.98 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="139.56,69.45 139.76,68.44 140.33,67.58 141.19,67 142.2,66.8 143.22,67 144.08,67.58 144.65,68.44 144.85,69.45 144.85,76.06 144.65,77.08 144.08,77.93 143.22,78.51 142.2,78.71 141.19,78.51 140.33,77.93 139.76,77.08 139.56,76.06 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="139.56,89.29 139.76,88.28 140.33,87.42 141.19,86.85 142.2,86.65 143.22,86.85 144.08,87.42 144.65,88.28 144.85,89.29 144.85,95.91 144.65,96.92 144.08,97.78 143.22,98.35 142.2,98.55 141.19,98.35 140.33,97.78 139.76,96.92 139.56,95.91 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="139.56,109.13 139.76,108.12 140.33,107.26 141.19,106.69 142.2,106.49 143.22,106.69 144.08,107.26 144.65,108.12 144.85,109.13 144.85,109.13 144.65,110.15 144.08,111 143.22,111.58 142.2,111.78 141.19,111.58 140.33,111 139.76,110.15 139.56,109.13 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="146.17,76.06 146.37,75.05 146.95,74.19 147.81,73.62 148.82,73.42 149.83,73.62 150.69,74.19 151.26,75.05 151.46,76.06 151.46,89.29 151.26,90.3 150.69,91.16 149.83,91.74 148.82,91.94 147.81,91.74 146.95,91.16 146.37,90.3 146.17,89.29 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
          <polygon
            points="146.17,109.13 146.37,108.12 146.95,107.26 147.81,106.69 148.82,106.49 149.83,106.69 150.69,107.26 151.26,108.12 151.46,109.13 151.46,115.75 151.26,116.76 150.69,117.62 149.83,118.19 148.82,118.39 147.81,118.19 146.95,117.62 146.37,116.76 146.17,115.75 "
            style="fill:url(#gradient0cf66245bbc14c159cbe9c68d2239764);"
          />
      `,
            },
            {
                value: 17,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(255,255,255,0);"
            shape-rendering="crispEdges"
          />
          <linearGradient
            id="gradiente980077bb02c4ed680664ae32429818f"
            gradientUnits="userSpaceOnUse"
            x1="7.7260570069796"
            y1="76.1197953713024"
            x2="157.628278777933"
            y2="89.2345404136097"
          >
            <stop offset="0%" stop-color="#CB07CB" />
            <stop offset="100%" stop-color="#129EB1" />
          </linearGradient>
          <polygon
            points="13.23,13.23 59.53,13.23 59.53,59.53 13.23,59.53 13.23,19.78 19.84,19.78 19.84,52.91 52.91,52.91 52.91,19.84 13.23,19.84 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="13.23,105.83 59.53,105.83 59.53,152.13 13.23,152.13 13.23,112.37 19.84,112.37 19.84,145.51 52.91,145.51 52.91,112.44 13.23,112.44 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="105.83,13.23 152.13,13.23 152.13,59.53 105.83,59.53 105.83,19.78 112.44,19.78 112.44,52.91 145.51,52.91 145.51,19.84 105.83,19.84 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="26.46,26.46 46.3,26.46 46.3,46.3 26.46,46.3 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="26.46,119.06 46.3,119.06 46.3,138.9 26.46,138.9 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="119.06,26.46 138.9,26.46 138.9,46.3 119.06,46.3 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="79.37,19.91 79.37,19.84 79.5,18.55 79.87,17.31 80.48,16.17 81.31,15.17 82.31,14.34 83.45,13.73 84.69,13.36 85.98,13.23 86.05,13.23 86.05,19.91 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="85.92,16.54 85.92,13.23 92.66,13.23 92.66,19.84 85.92,19.84 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.53,13.23 92.6,13.23 93.89,13.36 95.13,13.73 96.27,14.34 97.28,15.17 98.1,16.17 98.71,17.31 99.09,18.55 99.21,19.84 99.21,19.91 92.53,19.91 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="72.76,19.84 72.76,26.46 69.45,26.46 68.18,26.2 67.11,25.49 66.39,24.42 66.14,23.15 66.39,21.88 67.11,20.81 68.18,20.09 69.45,19.84 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="72.69,23.15 72.69,19.84 79.44,19.84 79.44,26.46 72.69,26.46 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="79.3,23.15 79.3,19.78 85.98,19.78 85.98,26.52 79.3,26.52 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.6,23.15 92.6,19.78 99.21,19.78 99.21,26.52 92.6,26.52 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="79.37,26.39 86.05,26.39 86.05,33.07 85.98,33.07 84.69,32.94 83.45,32.57 82.31,31.96 81.31,31.13 80.48,30.13 79.87,28.99 79.5,27.75 79.37,26.46 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="85.92,29.76 85.92,26.46 92.66,26.46 92.66,33.07 85.92,33.07 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.53,29.76 92.53,26.39 99.21,26.39 99.21,33.14 92.53,33.14 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="72.76,33.07 72.76,39.69 69.45,39.69 68.18,39.43 67.11,38.72 66.39,37.64 66.14,36.38 66.39,35.11 67.11,34.04 68.18,33.32 69.45,33.07 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="72.69,33.07 72.76,33.07 74.05,33.2 75.29,33.57 76.43,34.19 77.43,35.01 78.26,36.01 78.87,37.15 79.24,38.39 79.37,39.69 79.37,39.75 72.69,39.75 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.6,36.38 92.6,33 99.21,33 99.21,39.75 92.6,39.75 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="72.76,39.62 79.37,39.62 79.37,42.99 79.12,44.26 78.4,45.33 77.33,46.05 76.06,46.3 74.8,46.05 73.72,45.33 73.01,44.26 72.76,42.99 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.6,39.62 99.21,39.62 99.21,42.99 98.96,44.26 98.24,45.33 97.17,46.05 95.91,46.3 94.64,46.05 93.57,45.33 92.85,44.26 92.6,42.99 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="72.76,52.98 66.14,52.98 66.14,49.61 66.39,48.34 67.11,47.27 68.18,46.55 69.45,46.3 70.71,46.55 71.79,47.27 72.5,48.34 72.76,49.61 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.6,49.61 92.35,50.87 91.63,51.94 90.56,52.66 89.29,52.91 88.03,52.66 86.95,51.94 86.24,50.87 85.98,49.61 86.24,48.34 86.95,47.27 88.03,46.55 89.29,46.3 90.56,46.55 91.63,47.27 92.35,48.34 92.6,49.61 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="66.14,52.85 72.76,52.85 72.76,56.22 72.5,57.49 71.79,58.56 70.71,59.28 69.45,59.53 68.18,59.28 67.11,58.56 66.39,57.49 66.14,56.22 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="85.98,56.22 85.73,57.49 85.02,58.56 83.94,59.28 82.68,59.53 81.41,59.28 80.34,58.56 79.62,57.49 79.37,56.22 79.62,54.95 80.34,53.88 81.41,53.17 82.68,52.91 83.94,53.17 85.02,53.88 85.73,54.95 85.98,56.22 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="99.21,56.22 98.96,57.49 98.24,58.56 97.17,59.28 95.91,59.53 94.64,59.28 93.57,58.56 92.85,57.49 92.6,56.22 92.85,54.95 93.57,53.88 94.64,53.17 95.91,52.91 97.17,53.17 98.24,53.88 98.96,54.95 99.21,56.22 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="79.37,62.83 79.12,64.1 78.4,65.17 77.33,65.89 76.06,66.14 74.8,65.89 73.72,65.17 73.01,64.1 72.76,62.83 73.01,61.57 73.72,60.5 74.8,59.78 76.06,59.53 77.33,59.78 78.4,60.5 79.12,61.57 79.37,62.83 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="13.23,72.82 13.23,72.76 13.36,71.47 13.73,70.22 14.34,69.08 15.17,68.08 16.17,67.26 17.31,66.65 18.55,66.27 19.84,66.14 19.91,66.14 19.91,72.82 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="19.78,69.45 19.78,66.14 26.52,66.14 26.52,72.82 19.78,72.82 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="26.39,69.45 26.39,66.14 33.14,66.14 33.14,72.82 26.39,72.82 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="33,69.45 33,66.14 39.75,66.14 39.75,72.76 33,72.76 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="39.62,72.76 39.62,66.14 42.99,66.14 44.26,66.39 45.33,67.11 46.05,68.18 46.3,69.45 46.05,70.71 45.33,71.79 44.26,72.5 42.99,72.76 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="59.53,66.14 59.53,72.76 56.22,72.76 54.95,72.5 53.88,71.79 53.17,70.71 52.91,69.45 53.17,68.18 53.88,67.11 54.95,66.39 56.22,66.14 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="59.46,69.45 59.46,66.14 66.21,66.14 66.21,72.82 59.46,72.82 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="66.08,72.76 66.08,66.14 69.45,66.14 70.71,66.39 71.79,67.11 72.5,68.18 72.76,69.45 72.5,70.71 71.79,71.79 70.71,72.5 69.45,72.76 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.6,72.82 85.98,72.82 85.98,69.45 86.24,68.18 86.95,67.11 88.03,66.39 89.29,66.14 90.56,66.39 91.63,67.11 92.35,68.18 92.6,69.45 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="105.83,72.82 99.21,72.82 99.21,69.45 99.46,68.18 100.18,67.11 101.25,66.39 102.52,66.14 103.79,66.39 104.86,67.11 105.58,68.18 105.83,69.45 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="119.06,69.45 118.8,70.71 118.09,71.79 117.01,72.5 115.75,72.76 114.48,72.5 113.41,71.79 112.69,70.71 112.44,69.45 112.69,68.18 113.41,67.11 114.48,66.39 115.75,66.14 117.01,66.39 118.09,67.11 118.8,68.18 119.06,69.45 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="132.28,72.82 125.67,72.82 125.67,69.45 125.92,68.18 126.64,67.11 127.71,66.39 128.98,66.14 130.24,66.39 131.31,67.11 132.03,68.18 132.28,69.45 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="145.51,72.82 138.9,72.82 138.9,69.45 139.15,68.18 139.87,67.11 140.94,66.39 142.2,66.14 143.47,66.39 144.54,67.11 145.26,68.18 145.51,69.45 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="13.23,72.69 19.91,72.69 19.91,79.37 19.84,79.37 18.55,79.24 17.31,78.87 16.17,78.26 15.17,77.43 14.34,76.43 13.73,75.29 13.36,74.05 13.23,72.76 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="19.78,76.06 19.78,72.69 26.52,72.69 26.52,79.37 19.78,79.37 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="26.39,76.06 26.39,72.69 33.07,72.69 33.07,79.44 26.39,79.44 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="52.91,79.44 46.3,79.44 46.3,76.06 46.55,74.8 47.27,73.72 48.34,73.01 49.61,72.76 50.87,73.01 51.94,73.72 52.66,74.8 52.91,76.06 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="59.53,72.69 66.14,72.69 66.14,76.06 65.89,77.33 65.17,78.4 64.1,79.12 62.83,79.37 61.57,79.12 60.5,78.4 59.78,77.33 59.53,76.06 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="79.37,79.44 72.76,79.44 72.76,76.06 73.01,74.8 73.72,73.72 74.8,73.01 76.06,72.76 77.33,73.01 78.4,73.72 79.12,74.8 79.37,76.06 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="85.98,72.69 92.66,72.69 92.66,79.37 92.6,79.37 91.31,79.24 90.07,78.87 88.92,78.26 87.92,77.43 87.1,76.43 86.49,75.29 86.11,74.05 85.98,72.76 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.53,76.06 92.53,72.76 99.28,72.76 99.28,79.44 92.53,79.44 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="99.15,76.06 99.15,72.69 105.89,72.69 105.89,79.37 99.15,79.37 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="105.76,72.76 105.83,72.76 107.12,72.88 108.36,73.26 109.5,73.87 110.5,74.69 111.33,75.7 111.94,76.84 112.31,78.08 112.44,79.37 112.44,79.44 105.76,79.44 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="125.67,76.06 125.67,72.69 132.35,72.69 132.35,79.44 125.67,79.44 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="132.22,76.06 132.22,72.76 138.96,72.76 138.96,79.37 132.22,79.37 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="138.83,76.06 138.83,72.69 145.58,72.69 145.58,79.37 138.83,79.37 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="145.45,72.76 145.51,72.76 146.8,72.88 148.04,73.26 149.19,73.87 150.19,74.69 151.01,75.7 151.62,76.84 152,78.08 152.13,79.37 152.13,79.44 145.45,79.44 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="26.46,79.3 33.07,79.3 33.07,82.68 32.82,83.94 32.1,85.02 31.03,85.73 29.76,85.98 28.5,85.73 27.43,85.02 26.71,83.94 26.46,82.68 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="46.3,79.37 46.3,85.98 42.99,85.98 41.73,85.73 40.65,85.02 39.94,83.94 39.69,82.68 39.94,81.41 40.65,80.34 41.73,79.62 42.99,79.37 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="46.23,82.68 46.23,79.3 52.98,79.3 52.98,85.98 46.23,85.98 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="52.85,85.98 52.85,79.37 56.22,79.37 57.49,79.62 58.56,80.34 59.28,81.41 59.53,82.68 59.28,83.94 58.56,85.02 57.49,85.73 56.22,85.98 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="72.76,79.37 72.76,85.98 69.45,85.98 68.18,85.73 67.11,85.02 66.39,83.94 66.14,82.68 66.39,81.41 67.11,80.34 68.18,79.62 69.45,79.37 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="72.69,79.3 79.37,79.3 79.37,79.37 79.24,80.66 78.87,81.9 78.26,83.04 77.43,84.05 76.43,84.87 75.29,85.48 74.05,85.86 72.76,85.98 72.69,85.98 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.6,82.68 92.6,79.3 99.21,79.3 99.21,86.05 92.6,86.05 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="105.83,82.68 105.83,79.3 112.51,79.3 112.51,86.05 105.83,86.05 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="112.37,85.98 112.37,79.37 115.75,79.37 117.01,79.62 118.09,80.34 118.8,81.41 119.06,82.68 118.8,83.94 118.09,85.02 117.01,85.73 115.75,85.98 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="125.67,79.3 132.28,79.3 132.28,82.68 132.03,83.94 131.31,85.02 130.24,85.73 128.98,85.98 127.71,85.73 126.64,85.02 125.92,83.94 125.67,82.68 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="145.51,82.68 145.51,79.3 152.13,79.3 152.13,86.05 145.51,86.05 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="19.84,89.29 19.59,90.56 18.87,91.63 17.8,92.35 16.54,92.6 15.27,92.35 14.2,91.63 13.48,90.56 13.23,89.29 13.48,88.03 14.2,86.95 15.27,86.24 16.54,85.98 17.8,86.24 18.87,86.95 19.59,88.03 19.84,89.29 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="39.69,92.66 33.07,92.66 33.07,89.29 33.32,88.03 34.04,86.95 35.11,86.24 36.38,85.98 37.64,86.24 38.72,86.95 39.43,88.03 39.69,89.29 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.6,85.98 92.6,92.6 89.29,92.6 88.03,92.35 86.95,91.63 86.24,90.56 85.98,89.29 86.24,88.03 86.95,86.95 88.03,86.24 89.29,85.98 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.53,89.29 92.53,85.92 99.28,85.92 99.28,92.66 92.53,92.66 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="99.15,89.29 99.15,85.98 105.89,85.98 105.89,92.6 99.15,92.6 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="105.76,85.92 112.44,85.92 112.44,85.98 112.31,87.27 111.94,88.52 111.33,89.66 110.5,90.66 109.5,91.48 108.36,92.09 107.12,92.47 105.83,92.6 105.76,92.6 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="138.9,85.98 138.9,92.6 135.59,92.6 134.32,92.35 133.25,91.63 132.54,90.56 132.28,89.29 132.54,88.03 133.25,86.95 134.32,86.24 135.59,85.98 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="138.83,89.29 138.83,85.98 145.58,85.98 145.58,92.66 138.83,92.66 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="145.45,85.92 152.13,85.92 152.13,85.98 152,87.27 151.62,88.52 151.01,89.66 150.19,90.66 149.19,91.48 148.04,92.09 146.8,92.47 145.51,92.6 145.45,92.6 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="26.46,95.91 26.2,97.17 25.49,98.24 24.42,98.96 23.15,99.21 21.88,98.96 20.81,98.24 20.09,97.17 19.84,95.91 20.09,94.64 20.81,93.57 21.88,92.85 23.15,92.6 24.42,92.85 25.49,93.57 26.2,94.64 26.46,95.91 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="33.07,92.53 39.75,92.53 39.75,99.21 39.69,99.21 38.39,99.09 37.15,98.71 36.01,98.1 35.01,97.28 34.19,96.27 33.57,95.13 33.2,93.89 33.07,92.6 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="39.62,99.21 39.62,92.6 42.99,92.6 44.26,92.85 45.33,93.57 46.05,94.64 46.3,95.91 46.05,97.17 45.33,98.24 44.26,98.96 42.99,99.21 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="59.53,95.91 59.28,97.17 58.56,98.24 57.49,98.96 56.22,99.21 54.95,98.96 53.88,98.24 53.17,97.17 52.91,95.91 53.17,94.64 53.88,93.57 54.95,92.85 56.22,92.6 57.49,92.85 58.56,93.57 59.28,94.64 59.53,95.91 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="66.14,99.28 66.14,99.21 66.27,97.92 66.65,96.68 67.26,95.54 68.08,94.54 69.08,93.71 70.22,93.1 71.47,92.73 72.76,92.6 72.82,92.6 72.82,99.28 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="72.69,99.21 72.69,92.6 76.06,92.6 77.33,92.85 78.4,93.57 79.12,94.64 79.37,95.91 79.12,97.17 78.4,98.24 77.33,98.96 76.06,99.21 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.6,95.91 92.6,92.53 99.21,92.53 99.21,99.28 92.6,99.28 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="119.06,99.28 112.44,99.28 112.44,95.91 112.69,94.64 113.41,93.57 114.48,92.85 115.75,92.6 117.01,92.85 118.09,93.57 118.8,94.64 119.06,95.91 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="138.9,92.53 145.51,92.53 145.51,95.91 145.26,97.17 144.54,98.24 143.47,98.96 142.2,99.21 140.94,98.96 139.87,98.24 139.15,97.17 138.9,95.91 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="66.14,102.52 66.14,99.15 72.76,99.15 72.76,105.89 66.14,105.89 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="85.98,102.52 85.73,103.79 85.02,104.86 83.94,105.58 82.68,105.83 81.41,105.58 80.34,104.86 79.62,103.79 79.37,102.52 79.62,101.25 80.34,100.18 81.41,99.46 82.68,99.21 83.94,99.46 85.02,100.18 85.73,101.25 85.98,102.52 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.6,99.15 99.21,99.15 99.21,102.52 98.96,103.79 98.24,104.86 97.17,105.58 95.91,105.83 94.64,105.58 93.57,104.86 92.85,103.79 92.6,102.52 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="112.44,99.15 119.06,99.15 119.06,102.52 118.8,103.79 118.09,104.86 117.01,105.58 115.75,105.83 114.48,105.58 113.41,104.86 112.69,103.79 112.44,102.52 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="138.9,102.52 138.65,103.79 137.93,104.86 136.86,105.58 135.59,105.83 134.32,105.58 133.25,104.86 132.54,103.79 132.28,102.52 132.54,101.25 133.25,100.18 134.32,99.46 135.59,99.21 136.86,99.46 137.93,100.18 138.65,101.25 138.9,102.52 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="66.14,105.76 72.76,105.76 72.76,109.13 72.5,110.4 71.79,111.47 70.71,112.19 69.45,112.44 68.18,112.19 67.11,111.47 66.39,110.4 66.14,109.13 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.6,109.13 92.35,110.4 91.63,111.47 90.56,112.19 89.29,112.44 88.03,112.19 86.95,111.47 86.24,110.4 85.98,109.13 86.24,107.87 86.95,106.8 88.03,106.08 89.29,105.83 90.56,106.08 91.63,106.8 92.35,107.87 92.6,109.13 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="105.83,109.13 105.58,110.4 104.86,111.47 103.79,112.19 102.52,112.44 101.25,112.19 100.18,111.47 99.46,110.4 99.21,109.13 99.46,107.87 100.18,106.8 101.25,106.08 102.52,105.83 103.79,106.08 104.86,106.8 105.58,107.87 105.83,109.13 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="119.06,112.51 119.06,112.44 119.18,111.15 119.56,109.91 120.17,108.77 120.99,107.76 121.99,106.94 123.14,106.33 124.38,105.95 125.67,105.83 125.74,105.83 125.74,112.51 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="125.6,112.44 125.6,105.83 128.98,105.83 130.24,106.08 131.31,106.8 132.03,107.87 132.28,109.13 132.03,110.4 131.31,111.47 130.24,112.19 128.98,112.44 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="145.51,105.83 145.51,112.44 142.2,112.44 140.94,112.19 139.87,111.47 139.15,110.4 138.9,109.13 139.15,107.87 139.87,106.8 140.94,106.08 142.2,105.83 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="145.45,105.83 145.51,105.83 146.8,105.95 148.04,106.33 149.19,106.94 150.19,107.76 151.01,108.77 151.62,109.91 152,111.15 152.13,112.44 152.13,112.51 145.45,112.51 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="72.76,119.12 72.76,119.06 72.88,117.76 73.26,116.52 73.87,115.38 74.69,114.38 75.7,113.56 76.84,112.94 78.08,112.57 79.37,112.44 79.44,112.44 79.44,119.12 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="79.3,112.44 79.37,112.44 80.66,112.57 81.9,112.94 83.04,113.56 84.05,114.38 84.87,115.38 85.48,116.52 85.86,117.76 85.98,119.06 85.98,119.12 79.3,119.12 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="119.06,112.44 119.06,119.06 115.75,119.06 114.48,118.8 113.41,118.09 112.69,117.01 112.44,115.75 112.69,114.48 113.41,113.41 114.48,112.69 115.75,112.44 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="118.99,115.75 118.99,112.37 125.67,112.37 125.67,119.12 118.99,119.12 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="138.9,119.12 132.28,119.12 132.28,115.75 132.54,114.48 133.25,113.41 134.32,112.69 135.59,112.44 136.86,112.69 137.93,113.41 138.65,114.48 138.9,115.75 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="145.51,112.37 152.13,112.37 152.13,115.75 151.87,117.01 151.16,118.09 150.08,118.8 148.82,119.06 147.55,118.8 146.48,118.09 145.76,117.01 145.51,115.75 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="66.14,125.74 66.14,125.67 66.27,124.38 66.65,123.14 67.26,121.99 68.08,120.99 69.08,120.17 70.22,119.56 71.47,119.18 72.76,119.06 72.82,119.06 72.82,125.74 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="72.69,122.36 72.69,118.99 79.44,118.99 79.44,125.74 72.69,125.74 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="79.3,122.36 79.3,118.99 86.05,118.99 86.05,125.67 79.3,125.67 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="85.92,119.06 85.98,119.06 87.27,119.18 88.52,119.56 89.66,120.17 90.66,120.99 91.48,121.99 92.09,123.14 92.47,124.38 92.6,125.67 92.6,125.74 85.92,125.74 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="105.83,125.74 99.21,125.74 99.21,122.36 99.46,121.1 100.18,120.02 101.25,119.31 102.52,119.06 103.79,119.31 104.86,120.02 105.58,121.1 105.83,122.36 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="119.06,118.99 125.74,118.99 125.74,125.67 125.67,125.67 124.38,125.54 123.14,125.17 121.99,124.55 120.99,123.73 120.17,122.73 119.56,121.59 119.18,120.35 119.06,119.06 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="125.6,122.36 125.6,119.06 132.35,119.06 132.35,125.74 125.6,125.74 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="132.22,122.36 132.22,118.99 138.9,118.99 138.9,125.74 132.22,125.74 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="66.14,128.98 66.14,125.6 72.82,125.6 72.82,132.35 66.14,132.35 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="72.69,128.98 72.69,125.6 79.37,125.6 79.37,132.35 72.69,132.35 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="85.98,125.6 92.66,125.6 92.66,132.28 92.6,132.28 91.31,132.16 90.07,131.78 88.92,131.17 87.92,130.35 87.1,129.34 86.49,128.2 86.11,126.96 85.98,125.67 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.53,128.98 92.53,125.67 99.28,125.67 99.28,132.35 92.53,132.35 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="99.15,128.98 99.15,125.6 105.89,125.6 105.89,132.28 99.15,132.28 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="105.76,128.98 105.76,125.67 112.51,125.67 112.51,132.35 105.76,132.35 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="112.37,125.67 112.44,125.67 113.73,125.8 114.97,126.17 116.12,126.78 117.12,127.61 117.94,128.61 118.55,129.75 118.93,130.99 119.06,132.28 119.06,132.35 112.37,132.35 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="125.67,128.98 125.67,125.6 132.35,125.6 132.35,132.35 125.67,132.35 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="132.22,128.98 132.22,125.6 138.9,125.6 138.9,132.35 132.22,132.35 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="66.14,135.59 66.14,132.22 72.82,132.22 72.82,138.96 66.14,138.96 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="72.69,132.22 79.37,132.22 79.37,132.28 79.24,133.57 78.87,134.81 78.26,135.96 77.43,136.96 76.43,137.78 75.29,138.39 74.05,138.77 72.76,138.9 72.69,138.9 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.6,135.59 92.6,132.22 99.21,132.22 99.21,138.96 92.6,138.96 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="105.83,135.59 105.83,132.22 112.51,132.22 112.51,138.96 105.83,138.96 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="112.37,135.59 112.37,132.22 119.06,132.22 119.06,138.96 112.37,138.96 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="125.67,132.22 132.35,132.22 132.35,138.9 132.28,138.9 130.99,138.77 129.75,138.39 128.61,137.78 127.61,136.96 126.78,135.96 126.17,134.81 125.8,133.57 125.67,132.28 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="132.22,135.59 132.22,132.22 138.9,132.22 138.9,138.96 132.22,138.96 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="66.14,142.2 66.14,138.83 72.76,138.83 72.76,145.58 66.14,145.58 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="79.37,145.58 79.37,145.51 79.5,144.22 79.87,142.98 80.48,141.84 81.31,140.83 82.31,140.01 83.45,139.4 84.69,139.02 85.98,138.9 86.05,138.9 86.05,145.58 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="85.92,142.2 85.92,138.9 92.66,138.9 92.66,145.51 85.92,145.51 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.53,142.2 92.53,138.83 99.28,138.83 99.28,145.58 92.53,145.58 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="99.15,142.2 99.15,138.9 105.89,138.9 105.89,145.51 99.15,145.51 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="105.76,142.2 105.76,138.83 112.51,138.83 112.51,145.51 105.76,145.51 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="112.37,142.2 112.37,138.83 119.12,138.83 119.12,145.58 112.37,145.58 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="118.99,145.51 118.99,138.9 122.36,138.9 123.63,139.15 124.7,139.87 125.42,140.94 125.67,142.2 125.42,143.47 124.7,144.54 123.63,145.26 122.36,145.51 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="132.28,142.2 132.28,138.83 138.96,138.83 138.96,145.58 132.28,145.58 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="138.83,145.51 138.83,138.9 142.2,138.9 143.47,139.15 144.54,139.87 145.26,140.94 145.51,142.2 145.26,143.47 144.54,144.54 143.47,145.26 142.2,145.51 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="66.14,145.45 72.82,145.45 72.82,152.13 72.76,152.13 71.47,152 70.22,151.62 69.08,151.01 68.08,150.19 67.26,149.19 66.65,148.04 66.27,146.8 66.14,145.51 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="72.69,148.82 72.69,145.51 79.44,145.51 79.44,152.13 72.69,152.13 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="79.3,145.45 85.98,145.45 85.98,145.51 85.86,146.8 85.48,148.04 84.87,149.19 84.05,150.19 83.04,151.01 81.9,151.62 80.66,152 79.37,152.13 79.3,152.13 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="92.6,145.45 99.21,145.45 99.21,148.82 98.96,150.08 98.24,151.16 97.17,151.87 95.91,152.13 94.64,151.87 93.57,151.16 92.85,150.08 92.6,148.82 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="112.44,145.45 119.06,145.45 119.06,148.82 118.8,150.08 118.09,151.16 117.01,151.87 115.75,152.13 114.48,151.87 113.41,151.16 112.69,150.08 112.44,148.82 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
          <polygon
            points="132.28,145.45 138.9,145.45 138.9,148.82 138.65,150.08 137.93,151.16 136.86,151.87 135.59,152.13 134.32,151.87 133.25,151.16 132.54,150.08 132.28,148.82 "
            style="fill:url(#gradiente980077bb02c4ed680664ae32429818f);"
          />
      `,
            },
            {
                value: 18,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(255,255,255,0);"
            shape-rendering="crispEdges"
          />
          <linearGradient
            id="gradient7c02ecf658b94d13a18cfb76a0b221ad"
            gradientUnits="userSpaceOnUse"
            x1="5.00216673346307"
            y1="71.7606518369089"
            x2="160.35215379266"
            y2="93.5936686892141"
          >
            <stop offset="0%" stop-color="#833231" />
            <stop offset="100%" stop-color="#2A525C" />
          </linearGradient>
          <polygon
            points="13.23,29.76 13.55,26.54 14.49,23.44 16.02,20.58 18.07,18.07 20.58,16.02 23.44,14.49 26.54,13.55 29.76,13.23 42.99,13.23 46.22,13.55 49.32,14.49 52.18,16.02 54.68,18.07 56.74,20.58 58.27,23.44 59.21,26.54 59.53,29.76 59.53,59.53 29.76,59.53 26.54,59.21 23.44,58.27 20.58,56.74 18.07,54.68 16.02,52.18 14.49,49.32 13.55,46.22 13.23,42.99 13.23,29.76 19.84,29.76 19.84,42.99 20.18,45.56 21.17,47.95 22.75,50.01 24.8,51.58 27.2,52.58 29.76,52.91 52.91,52.91 52.91,29.76 52.58,27.2 51.58,24.8 50.01,22.75 47.95,21.17 45.56,20.18 42.99,19.84 29.76,19.84 27.2,20.18 24.8,21.17 22.75,22.75 21.17,24.8 20.18,27.2 19.84,29.76 "
            style="fill:url(#gradient7c02ecf658b94d13a18cfb76a0b221ad);"
          />
          <polygon
            points="13.23,122.36 13.55,119.14 14.49,116.03 16.02,113.18 18.07,110.67 20.58,108.61 23.44,107.09 26.54,106.14 29.76,105.83 59.53,105.83 59.53,135.59 59.21,138.82 58.27,141.92 56.74,144.78 54.68,147.28 52.18,149.34 49.32,150.87 46.22,151.81 42.99,152.13 29.76,152.13 26.54,151.81 23.44,150.87 20.58,149.34 18.07,147.28 16.02,144.78 14.49,141.92 13.55,138.82 13.23,135.59 13.23,122.36 19.84,122.36 19.84,135.59 20.18,138.16 21.17,140.55 22.75,142.61 24.8,144.18 27.2,145.17 29.76,145.51 42.99,145.51 45.56,145.17 47.95,144.18 50.01,142.61 51.58,140.55 52.58,138.16 52.91,135.59 52.91,112.44 29.76,112.44 27.2,112.78 24.8,113.77 22.75,115.35 21.17,117.4 20.18,119.79 19.84,122.36 "
            style="fill:url(#gradient7c02ecf658b94d13a18cfb76a0b221ad);"
          />
          <polygon
            points="105.83,29.76 106.14,26.54 107.09,23.44 108.61,20.58 110.67,18.07 113.18,16.02 116.03,14.49 119.14,13.55 122.36,13.23 135.59,13.23 138.82,13.55 141.92,14.49 144.78,16.02 147.28,18.07 149.34,20.58 150.87,23.44 151.81,26.54 152.13,29.76 152.13,42.99 151.81,46.22 150.87,49.32 149.34,52.18 147.28,54.68 144.78,56.74 141.92,58.27 138.82,59.21 135.59,59.53 105.83,59.53 105.83,29.76 112.44,29.76 112.44,52.91 135.59,52.91 138.16,52.58 140.55,51.58 142.61,50.01 144.18,47.95 145.17,45.56 145.51,42.99 145.51,29.76 145.17,27.2 144.18,24.8 142.61,22.75 140.55,21.17 138.16,20.18 135.59,19.84 122.36,19.84 119.79,20.18 117.4,21.17 115.35,22.75 113.77,24.8 112.78,27.2 112.44,29.76 "
            style="fill:url(#gradient7c02ecf658b94d13a18cfb76a0b221ad);"
          />
          <pattern
            id="hatch8a2f2b565227486eb71f2fc5a259fae6"
            x="0"
            y="0"
            width="8"
            height="8"
            patternUnits="userSpaceOnUse"
          >
            <rect x="0" y="0" width="8" height="8" fill="#7D2A23" />
            <rect x="0" y="0" width="1" height="1" fill="#514473" />
            <rect x="1" y="0" width="1" height="1" fill="#514473" />
            <rect x="2" y="0" width="1" height="1" fill="#514473" />
            <rect x="3" y="0" width="1" height="1" fill="#514473" />
            <rect x="0" y="1" width="1" height="1" fill="#514473" />
            <rect x="1" y="1" width="1" height="1" fill="#514473" />
            <rect x="2" y="1" width="1" height="1" fill="#514473" />
            <rect x="3" y="1" width="1" height="1" fill="#514473" />
            <rect x="0" y="2" width="1" height="1" fill="#514473" />
            <rect x="1" y="2" width="1" height="1" fill="#514473" />
            <rect x="2" y="2" width="1" height="1" fill="#514473" />
            <rect x="3" y="2" width="1" height="1" fill="#514473" />
            <rect x="0" y="3" width="1" height="1" fill="#514473" />
            <rect x="1" y="3" width="1" height="1" fill="#514473" />
            <rect x="2" y="3" width="1" height="1" fill="#514473" />
            <rect x="3" y="3" width="1" height="1" fill="#514473" />
            <rect x="0" y="4" width="1" height="1" fill="#514473" />
            <rect x="2" y="4" width="1" height="1" fill="#514473" />
            <rect x="4" y="4" width="1" height="1" fill="#514473" />
            <rect x="6" y="4" width="1" height="1" fill="#514473" />
            <rect x="1" y="5" width="1" height="1" fill="#514473" />
            <rect x="3" y="5" width="1" height="1" fill="#514473" />
            <rect x="5" y="5" width="1" height="1" fill="#514473" />
            <rect x="7" y="5" width="1" height="1" fill="#514473" />
            <rect x="0" y="6" width="1" height="1" fill="#514473" />
            <rect x="2" y="6" width="1" height="1" fill="#514473" />
            <rect x="4" y="6" width="1" height="1" fill="#514473" />
            <rect x="6" y="6" width="1" height="1" fill="#514473" />
            <rect x="1" y="7" width="1" height="1" fill="#514473" />
            <rect x="3" y="7" width="1" height="1" fill="#514473" />
            <rect x="5" y="7" width="1" height="1" fill="#514473" />
            <rect x="7" y="7" width="1" height="1" fill="#514473" />
          </pattern>
          <polygon
            points="26.46,31.09 26.61,29.89 27.08,28.77 27.81,27.81 28.77,27.08 29.89,26.61 31.09,26.46 41.67,26.46 42.87,26.61 43.98,27.08 44.94,27.81 45.68,28.77 46.14,29.89 46.3,31.09 46.3,46.3 31.09,46.3 29.89,46.14 28.77,45.68 27.81,44.94 27.08,43.98 26.61,42.87 26.46,41.67 "
            style="fill:url(#hatch8a2f2b565227486eb71f2fc5a259fae6);"
          />
          <polygon
            points="26.46,123.69 26.61,122.49 27.08,121.37 27.81,120.41 28.77,119.68 29.89,119.21 31.09,119.06 46.3,119.06 46.3,134.27 46.14,135.47 45.68,136.58 44.94,137.54 43.98,138.28 42.87,138.74 41.67,138.9 31.09,138.9 29.89,138.74 28.77,138.28 27.81,137.54 27.08,136.58 26.61,135.47 26.46,134.27 "
            style="fill:url(#hatch8a2f2b565227486eb71f2fc5a259fae6);"
          />
          <polygon
            points="119.06,31.09 119.21,29.89 119.68,28.77 120.41,27.81 121.37,27.08 122.49,26.61 123.69,26.46 134.27,26.46 135.47,26.61 136.58,27.08 137.54,27.81 138.28,28.77 138.74,29.89 138.9,31.09 138.9,41.67 138.74,42.87 138.28,43.98 137.54,44.94 136.58,45.68 135.47,46.14 134.27,46.3 119.06,46.3 "
            style="fill:url(#hatch8a2f2b565227486eb71f2fc5a259fae6);"
          />
          <linearGradient
            id="gradient80618ad2d9ad494d91b68c40b4cb4fde"
            gradientUnits="userSpaceOnUse"
            x1="9.79838695230475"
            y1="78.6758608313476"
            x2="155.555933573818"
            y2="86.3146901635255"
          >
            <stop offset="0%" stop-color="#8A3900" />
            <stop offset="100%" stop-color="#89039C" />
          </linearGradient>
          <polygon
            points="79.37,15.84 79.67,15.48 81.42,15.08 82.21,13.29 82.58,13.23 82.88,13.39 83.74,14.98 85.46,15.34 85.98,15.77 85.79,16.2 84.36,17.13 84.86,18.78 84.79,19.35 84.43,19.48 82.58,18.29 81.22,19.45 80.83,19.48 80.56,19.15 80.89,17.16 79.54,16.2 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="85.98,15.84 86.28,15.48 88.03,15.08 88.83,13.29 89.19,13.23 89.49,13.39 90.35,14.98 92.07,15.34 92.6,15.77 92.4,16.2 90.98,17.13 91.47,18.78 91.41,19.35 91.04,19.48 89.19,18.29 87.84,19.45 87.44,19.48 87.17,19.15 87.51,17.16 86.15,16.2 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="92.6,15.84 92.9,15.48 94.65,15.08 95.44,13.29 95.81,13.23 96.1,13.39 96.96,14.98 98.68,15.34 99.21,15.77 99.01,16.2 97.59,17.13 98.09,18.78 98.02,19.35 97.66,19.48 95.81,18.29 94.45,19.45 94.05,19.48 93.79,19.15 94.12,17.16 92.76,16.2 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="66.14,22.46 66.44,22.09 68.19,21.69 68.99,19.91 69.35,19.84 69.65,20.01 70.51,21.6 72.23,21.96 72.76,22.39 72.56,22.82 71.14,23.74 71.63,25.4 71.57,25.96 71.2,26.09 69.35,24.9 67.99,26.06 67.6,26.09 67.33,25.76 67.66,23.78 66.31,22.82 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="72.76,22.46 73.05,22.09 74.81,21.69 75.6,19.91 75.96,19.84 76.26,20.01 77.12,21.6 78.84,21.96 79.37,22.39 79.17,22.82 77.75,23.74 78.25,25.4 78.18,25.96 77.82,26.09 75.96,24.9 74.61,26.06 74.21,26.09 73.95,25.76 74.28,23.78 72.92,22.82 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="79.37,22.46 79.67,22.09 81.42,21.69 82.21,19.91 82.58,19.84 82.88,20.01 83.74,21.6 85.46,21.96 85.98,22.39 85.79,22.82 84.36,23.74 84.86,25.4 84.79,25.96 84.43,26.09 82.58,24.9 81.22,26.06 80.83,26.09 80.56,25.76 80.89,23.78 79.54,22.82 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="92.6,22.46 92.9,22.09 94.65,21.69 95.44,19.91 95.81,19.84 96.1,20.01 96.96,21.6 98.68,21.96 99.21,22.39 99.01,22.82 97.59,23.74 98.09,25.4 98.02,25.96 97.66,26.09 95.81,24.9 94.45,26.06 94.05,26.09 93.79,25.76 94.12,23.78 92.76,22.82 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="79.37,29.07 79.67,28.71 81.42,28.31 82.21,26.52 82.58,26.46 82.88,26.62 83.74,28.21 85.46,28.57 85.98,29 85.79,29.43 84.36,30.36 84.86,32.01 84.79,32.57 84.43,32.71 82.58,31.52 81.22,32.67 80.83,32.71 80.56,32.38 80.89,30.39 79.54,29.43 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="85.98,29.07 86.28,28.71 88.03,28.31 88.83,26.52 89.19,26.46 89.49,26.62 90.35,28.21 92.07,28.57 92.6,29 92.4,29.43 90.98,30.36 91.47,32.01 91.41,32.57 91.04,32.71 89.19,31.52 87.84,32.67 87.44,32.71 87.17,32.38 87.51,30.39 86.15,29.43 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="92.6,29.07 92.9,28.71 94.65,28.31 95.44,26.52 95.81,26.46 96.1,26.62 96.96,28.21 98.68,28.57 99.21,29 99.01,29.43 97.59,30.36 98.09,32.01 98.02,32.57 97.66,32.71 95.81,31.52 94.45,32.67 94.05,32.71 93.79,32.38 94.12,30.39 92.76,29.43 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="66.14,35.68 66.44,35.32 68.19,34.92 68.99,33.14 69.35,33.07 69.65,33.24 70.51,34.82 72.23,35.19 72.76,35.62 72.56,36.05 71.14,36.97 71.63,38.63 71.57,39.19 71.2,39.32 69.35,38.13 67.99,39.29 67.6,39.32 67.33,38.99 67.66,37.01 66.31,36.05 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="72.76,35.68 73.05,35.32 74.81,34.92 75.6,33.14 75.96,33.07 76.26,33.24 77.12,34.82 78.84,35.19 79.37,35.62 79.17,36.05 77.75,36.97 78.25,38.63 78.18,39.19 77.82,39.32 75.96,38.13 74.61,39.29 74.21,39.32 73.95,38.99 74.28,37.01 72.92,36.05 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="92.6,35.68 92.9,35.32 94.65,34.92 95.44,33.14 95.81,33.07 96.1,33.24 96.96,34.82 98.68,35.19 99.21,35.62 99.01,36.05 97.59,36.97 98.09,38.63 98.02,39.19 97.66,39.32 95.81,38.13 94.45,39.29 94.05,39.32 93.79,38.99 94.12,37.01 92.76,36.05 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="72.76,42.3 73.05,41.93 74.81,41.54 75.6,39.75 75.96,39.69 76.26,39.85 77.12,41.44 78.84,41.8 79.37,42.23 79.17,42.66 77.75,43.59 78.25,45.24 78.18,45.8 77.82,45.94 75.96,44.74 74.61,45.9 74.21,45.94 73.95,45.6 74.28,43.62 72.92,42.66 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="92.6,42.3 92.9,41.93 94.65,41.54 95.44,39.75 95.81,39.69 96.1,39.85 96.96,41.44 98.68,41.8 99.21,42.23 99.01,42.66 97.59,43.59 98.09,45.24 98.02,45.8 97.66,45.94 95.81,44.74 94.45,45.9 94.05,45.94 93.79,45.6 94.12,43.62 92.76,42.66 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="66.14,48.91 66.44,48.55 68.19,48.15 68.99,46.37 69.35,46.3 69.65,46.46 70.51,48.05 72.23,48.42 72.76,48.85 72.56,49.28 71.14,50.2 71.63,51.86 71.57,52.42 71.2,52.55 69.35,51.36 67.99,52.52 67.6,52.55 67.33,52.22 67.66,50.23 66.31,49.28 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="85.98,48.91 86.28,48.55 88.03,48.15 88.83,46.37 89.19,46.3 89.49,46.46 90.35,48.05 92.07,48.42 92.6,48.85 92.4,49.28 90.98,50.2 91.47,51.86 91.41,52.42 91.04,52.55 89.19,51.36 87.84,52.52 87.44,52.55 87.17,52.22 87.51,50.23 86.15,49.28 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="66.14,55.53 66.44,55.16 68.19,54.77 68.99,52.98 69.35,52.91 69.65,53.08 70.51,54.67 72.23,55.03 72.76,55.46 72.56,55.89 71.14,56.82 71.63,58.47 71.57,59.03 71.2,59.16 69.35,57.97 67.99,59.13 67.6,59.16 67.33,58.83 67.66,56.85 66.31,55.89 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="79.37,55.53 79.67,55.16 81.42,54.77 82.21,52.98 82.58,52.91 82.88,53.08 83.74,54.67 85.46,55.03 85.98,55.46 85.79,55.89 84.36,56.82 84.86,58.47 84.79,59.03 84.43,59.16 82.58,57.97 81.22,59.13 80.83,59.16 80.56,58.83 80.89,56.85 79.54,55.89 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="92.6,55.53 92.9,55.16 94.65,54.77 95.44,52.98 95.81,52.91 96.1,53.08 96.96,54.67 98.68,55.03 99.21,55.46 99.01,55.89 97.59,56.82 98.09,58.47 98.02,59.03 97.66,59.16 95.81,57.97 94.45,59.13 94.05,59.16 93.79,58.83 94.12,56.85 92.76,55.89 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="72.76,62.14 73.05,61.78 74.81,61.38 75.6,59.59 75.96,59.53 76.26,59.69 77.12,61.28 78.84,61.64 79.37,62.07 79.17,62.5 77.75,63.43 78.25,65.08 78.18,65.65 77.82,65.78 75.96,64.59 74.61,65.74 74.21,65.78 73.95,65.45 74.28,63.46 72.92,62.5 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="13.23,68.75 13.53,68.39 15.28,67.99 16.07,66.21 16.44,66.14 16.73,66.31 17.59,67.89 19.31,68.26 19.84,68.69 19.64,69.12 18.22,70.04 18.72,71.7 18.65,72.26 18.29,72.39 16.44,71.2 15.08,72.36 14.68,72.39 14.42,72.06 14.75,70.08 13.39,69.12 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="19.84,68.75 20.14,68.39 21.89,67.99 22.69,66.21 23.05,66.14 23.35,66.31 24.21,67.89 25.93,68.26 26.46,68.69 26.26,69.12 24.84,70.04 25.33,71.7 25.27,72.26 24.9,72.39 23.05,71.2 21.69,72.36 21.3,72.39 21.03,72.06 21.36,70.08 20.01,69.12 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="26.46,68.75 26.75,68.39 28.51,67.99 29.3,66.21 29.66,66.14 29.96,66.31 30.82,67.89 32.54,68.26 33.07,68.69 32.87,69.12 31.45,70.04 31.95,71.7 31.88,72.26 31.52,72.39 29.66,71.2 28.31,72.36 27.91,72.39 27.65,72.06 27.98,70.08 26.62,69.12 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="33.07,68.75 33.37,68.39 35.12,67.99 35.91,66.21 36.28,66.14 36.58,66.31 37.44,67.89 39.16,68.26 39.69,68.69 39.49,69.12 38.06,70.04 38.56,71.7 38.49,72.26 38.13,72.39 36.28,71.2 34.92,72.36 34.53,72.39 34.26,72.06 34.59,70.08 33.24,69.12 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="39.69,68.75 39.98,68.39 41.74,67.99 42.53,66.21 42.89,66.14 43.19,66.31 44.05,67.89 45.77,68.26 46.3,68.69 46.1,69.12 44.68,70.04 45.17,71.7 45.11,72.26 44.74,72.39 42.89,71.2 41.54,72.36 41.14,72.39 40.88,72.06 41.21,70.08 39.85,69.12 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="52.91,68.75 53.21,68.39 54.96,67.99 55.76,66.21 56.12,66.14 56.42,66.31 57.28,67.89 59,68.26 59.53,68.69 59.33,69.12 57.91,70.04 58.4,71.7 58.34,72.26 57.97,72.39 56.12,71.2 54.77,72.36 54.37,72.39 54.1,72.06 54.43,70.08 53.08,69.12 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="59.53,68.75 59.83,68.39 61.58,67.99 62.37,66.21 62.74,66.14 63.03,66.31 63.89,67.89 65.61,68.26 66.14,68.69 65.94,69.12 64.52,70.04 65.02,71.7 64.95,72.26 64.59,72.39 62.74,71.2 61.38,72.36 60.98,72.39 60.72,72.06 61.05,70.08 59.69,69.12 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="66.14,68.75 66.44,68.39 68.19,67.99 68.99,66.21 69.35,66.14 69.65,66.31 70.51,67.89 72.23,68.26 72.76,68.69 72.56,69.12 71.14,70.04 71.63,71.7 71.57,72.26 71.2,72.39 69.35,71.2 67.99,72.36 67.6,72.39 67.33,72.06 67.66,70.08 66.31,69.12 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="85.98,68.75 86.28,68.39 88.03,67.99 88.83,66.21 89.19,66.14 89.49,66.31 90.35,67.89 92.07,68.26 92.6,68.69 92.4,69.12 90.98,70.04 91.47,71.7 91.41,72.26 91.04,72.39 89.19,71.2 87.84,72.36 87.44,72.39 87.17,72.06 87.51,70.08 86.15,69.12 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="99.21,68.75 99.51,68.39 101.26,67.99 102.06,66.21 102.42,66.14 102.72,66.31 103.58,67.89 105.3,68.26 105.83,68.69 105.63,69.12 104.21,70.04 104.7,71.7 104.64,72.26 104.27,72.39 102.42,71.2 101.06,72.36 100.67,72.39 100.4,72.06 100.73,70.08 99.38,69.12 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="112.44,68.75 112.74,68.39 114.49,67.99 115.29,66.21 115.65,66.14 115.95,66.31 116.81,67.89 118.53,68.26 119.06,68.69 118.86,69.12 117.43,70.04 117.93,71.7 117.86,72.26 117.5,72.39 115.65,71.2 114.29,72.36 113.9,72.39 113.63,72.06 113.96,70.08 112.61,69.12 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="125.67,68.75 125.97,68.39 127.72,67.99 128.51,66.21 128.88,66.14 129.17,66.31 130.03,67.89 131.75,68.26 132.28,68.69 132.09,69.12 130.66,70.04 131.16,71.7 131.09,72.26 130.73,72.39 128.88,71.2 127.52,72.36 127.12,72.39 126.86,72.06 127.19,70.08 125.83,69.12 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="138.9,68.75 139.2,68.39 140.95,67.99 141.74,66.21 142.11,66.14 142.4,66.31 143.26,67.89 144.98,68.26 145.51,68.69 145.31,69.12 143.89,70.04 144.39,71.7 144.32,72.26 143.96,72.39 142.11,71.2 140.75,72.36 140.35,72.39 140.09,72.06 140.42,70.08 139.06,69.12 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="13.23,75.37 13.53,75 15.28,74.61 16.07,72.82 16.44,72.76 16.73,72.92 17.59,74.51 19.31,74.87 19.84,75.3 19.64,75.73 18.22,76.66 18.72,78.31 18.65,78.87 18.29,79.01 16.44,77.82 15.08,78.97 14.68,79.01 14.42,78.68 14.75,76.69 13.39,75.73 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="19.84,75.37 20.14,75 21.89,74.61 22.69,72.82 23.05,72.76 23.35,72.92 24.21,74.51 25.93,74.87 26.46,75.3 26.26,75.73 24.84,76.66 25.33,78.31 25.27,78.87 24.9,79.01 23.05,77.82 21.69,78.97 21.3,79.01 21.03,78.68 21.36,76.69 20.01,75.73 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="26.46,75.37 26.75,75 28.51,74.61 29.3,72.82 29.66,72.76 29.96,72.92 30.82,74.51 32.54,74.87 33.07,75.3 32.87,75.73 31.45,76.66 31.95,78.31 31.88,78.87 31.52,79.01 29.66,77.82 28.31,78.97 27.91,79.01 27.65,78.68 27.98,76.69 26.62,75.73 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="46.3,75.37 46.6,75 48.35,74.61 49.14,72.82 49.51,72.76 49.8,72.92 50.66,74.51 52.38,74.87 52.91,75.3 52.71,75.73 51.29,76.66 51.79,78.31 51.72,78.87 51.36,79.01 49.51,77.82 48.15,78.97 47.75,79.01 47.49,78.68 47.82,76.69 46.46,75.73 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="59.53,75.37 59.83,75 61.58,74.61 62.37,72.82 62.74,72.76 63.03,72.92 63.89,74.51 65.61,74.87 66.14,75.3 65.94,75.73 64.52,76.66 65.02,78.31 64.95,78.87 64.59,79.01 62.74,77.82 61.38,78.97 60.98,79.01 60.72,78.68 61.05,76.69 59.69,75.73 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="72.76,75.37 73.05,75 74.81,74.61 75.6,72.82 75.96,72.76 76.26,72.92 77.12,74.51 78.84,74.87 79.37,75.3 79.17,75.73 77.75,76.66 78.25,78.31 78.18,78.87 77.82,79.01 75.96,77.82 74.61,78.97 74.21,79.01 73.95,78.68 74.28,76.69 72.92,75.73 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="85.98,75.37 86.28,75 88.03,74.61 88.83,72.82 89.19,72.76 89.49,72.92 90.35,74.51 92.07,74.87 92.6,75.3 92.4,75.73 90.98,76.66 91.47,78.31 91.41,78.87 91.04,79.01 89.19,77.82 87.84,78.97 87.44,79.01 87.17,78.68 87.51,76.69 86.15,75.73 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="92.6,75.37 92.9,75 94.65,74.61 95.44,72.82 95.81,72.76 96.1,72.92 96.96,74.51 98.68,74.87 99.21,75.3 99.01,75.73 97.59,76.66 98.09,78.31 98.02,78.87 97.66,79.01 95.81,77.82 94.45,78.97 94.05,79.01 93.79,78.68 94.12,76.69 92.76,75.73 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="99.21,75.37 99.51,75 101.26,74.61 102.06,72.82 102.42,72.76 102.72,72.92 103.58,74.51 105.3,74.87 105.83,75.3 105.63,75.73 104.21,76.66 104.7,78.31 104.64,78.87 104.27,79.01 102.42,77.82 101.06,78.97 100.67,79.01 100.4,78.68 100.73,76.69 99.38,75.73 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="105.83,75.37 106.12,75 107.88,74.61 108.67,72.82 109.03,72.76 109.33,72.92 110.19,74.51 111.91,74.87 112.44,75.3 112.24,75.73 110.82,76.66 111.32,78.31 111.25,78.87 110.89,79.01 109.03,77.82 107.68,78.97 107.28,79.01 107.02,78.68 107.35,76.69 105.99,75.73 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="125.67,75.37 125.97,75 127.72,74.61 128.51,72.82 128.88,72.76 129.17,72.92 130.03,74.51 131.75,74.87 132.28,75.3 132.09,75.73 130.66,76.66 131.16,78.31 131.09,78.87 130.73,79.01 128.88,77.82 127.52,78.97 127.12,79.01 126.86,78.68 127.19,76.69 125.83,75.73 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="132.28,75.37 132.58,75 134.33,74.61 135.13,72.82 135.49,72.76 135.79,72.92 136.65,74.51 138.37,74.87 138.9,75.3 138.7,75.73 137.28,76.66 137.77,78.31 137.71,78.87 137.34,79.01 135.49,77.82 134.14,78.97 133.74,79.01 133.47,78.68 133.8,76.69 132.45,75.73 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="138.9,75.37 139.2,75 140.95,74.61 141.74,72.82 142.11,72.76 142.4,72.92 143.26,74.51 144.98,74.87 145.51,75.3 145.31,75.73 143.89,76.66 144.39,78.31 144.32,78.87 143.96,79.01 142.11,77.82 140.75,78.97 140.35,79.01 140.09,78.68 140.42,76.69 139.06,75.73 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="145.51,75.37 145.81,75 147.56,74.61 148.36,72.82 148.72,72.76 149.02,72.92 149.88,74.51 151.6,74.87 152.13,75.3 151.93,75.73 150.51,76.66 151,78.31 150.94,78.87 150.57,79.01 148.72,77.82 147.36,78.97 146.97,79.01 146.7,78.68 147.03,76.69 145.68,75.73 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="26.46,81.98 26.75,81.62 28.51,81.22 29.3,79.44 29.66,79.37 29.96,79.54 30.82,81.12 32.54,81.49 33.07,81.92 32.87,82.35 31.45,83.27 31.95,84.93 31.88,85.49 31.52,85.62 29.66,84.43 28.31,85.59 27.91,85.62 27.65,85.29 27.98,83.31 26.62,82.35 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="39.69,81.98 39.98,81.62 41.74,81.22 42.53,79.44 42.89,79.37 43.19,79.54 44.05,81.12 45.77,81.49 46.3,81.92 46.1,82.35 44.68,83.27 45.17,84.93 45.11,85.49 44.74,85.62 42.89,84.43 41.54,85.59 41.14,85.62 40.88,85.29 41.21,83.31 39.85,82.35 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="46.3,81.98 46.6,81.62 48.35,81.22 49.14,79.44 49.51,79.37 49.8,79.54 50.66,81.12 52.38,81.49 52.91,81.92 52.71,82.35 51.29,83.27 51.79,84.93 51.72,85.49 51.36,85.62 49.51,84.43 48.15,85.59 47.75,85.62 47.49,85.29 47.82,83.31 46.46,82.35 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="52.91,81.98 53.21,81.62 54.96,81.22 55.76,79.44 56.12,79.37 56.42,79.54 57.28,81.12 59,81.49 59.53,81.92 59.33,82.35 57.91,83.27 58.4,84.93 58.34,85.49 57.97,85.62 56.12,84.43 54.77,85.59 54.37,85.62 54.1,85.29 54.43,83.31 53.08,82.35 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="66.14,81.98 66.44,81.62 68.19,81.22 68.99,79.44 69.35,79.37 69.65,79.54 70.51,81.12 72.23,81.49 72.76,81.92 72.56,82.35 71.14,83.27 71.63,84.93 71.57,85.49 71.2,85.62 69.35,84.43 67.99,85.59 67.6,85.62 67.33,85.29 67.66,83.31 66.31,82.35 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="72.76,81.98 73.05,81.62 74.81,81.22 75.6,79.44 75.96,79.37 76.26,79.54 77.12,81.12 78.84,81.49 79.37,81.92 79.17,82.35 77.75,83.27 78.25,84.93 78.18,85.49 77.82,85.62 75.96,84.43 74.61,85.59 74.21,85.62 73.95,85.29 74.28,83.31 72.92,82.35 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="92.6,81.98 92.9,81.62 94.65,81.22 95.44,79.44 95.81,79.37 96.1,79.54 96.96,81.12 98.68,81.49 99.21,81.92 99.01,82.35 97.59,83.27 98.09,84.93 98.02,85.49 97.66,85.62 95.81,84.43 94.45,85.59 94.05,85.62 93.79,85.29 94.12,83.31 92.76,82.35 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="105.83,81.98 106.12,81.62 107.88,81.22 108.67,79.44 109.03,79.37 109.33,79.54 110.19,81.12 111.91,81.49 112.44,81.92 112.24,82.35 110.82,83.27 111.32,84.93 111.25,85.49 110.89,85.62 109.03,84.43 107.68,85.59 107.28,85.62 107.02,85.29 107.35,83.31 105.99,82.35 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="112.44,81.98 112.74,81.62 114.49,81.22 115.29,79.44 115.65,79.37 115.95,79.54 116.81,81.12 118.53,81.49 119.06,81.92 118.86,82.35 117.43,83.27 117.93,84.93 117.86,85.49 117.5,85.62 115.65,84.43 114.29,85.59 113.9,85.62 113.63,85.29 113.96,83.31 112.61,82.35 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="125.67,81.98 125.97,81.62 127.72,81.22 128.51,79.44 128.88,79.37 129.17,79.54 130.03,81.12 131.75,81.49 132.28,81.92 132.09,82.35 130.66,83.27 131.16,84.93 131.09,85.49 130.73,85.62 128.88,84.43 127.52,85.59 127.12,85.62 126.86,85.29 127.19,83.31 125.83,82.35 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="145.51,81.98 145.81,81.62 147.56,81.22 148.36,79.44 148.72,79.37 149.02,79.54 149.88,81.12 151.6,81.49 152.13,81.92 151.93,82.35 150.51,83.27 151,84.93 150.94,85.49 150.57,85.62 148.72,84.43 147.36,85.59 146.97,85.62 146.7,85.29 147.03,83.31 145.68,82.35 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="13.23,88.6 13.53,88.23 15.28,87.84 16.07,86.05 16.44,85.98 16.73,86.15 17.59,87.74 19.31,88.1 19.84,88.53 19.64,88.96 18.22,89.89 18.72,91.54 18.65,92.1 18.29,92.23 16.44,91.04 15.08,92.2 14.68,92.23 14.42,91.9 14.75,89.92 13.39,88.96 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="33.07,88.6 33.37,88.23 35.12,87.84 35.91,86.05 36.28,85.98 36.58,86.15 37.44,87.74 39.16,88.1 39.69,88.53 39.49,88.96 38.06,89.89 38.56,91.54 38.49,92.1 38.13,92.23 36.28,91.04 34.92,92.2 34.53,92.23 34.26,91.9 34.59,89.92 33.24,88.96 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="85.98,88.6 86.28,88.23 88.03,87.84 88.83,86.05 89.19,85.98 89.49,86.15 90.35,87.74 92.07,88.1 92.6,88.53 92.4,88.96 90.98,89.89 91.47,91.54 91.41,92.1 91.04,92.23 89.19,91.04 87.84,92.2 87.44,92.23 87.17,91.9 87.51,89.92 86.15,88.96 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="92.6,88.6 92.9,88.23 94.65,87.84 95.44,86.05 95.81,85.98 96.1,86.15 96.96,87.74 98.68,88.1 99.21,88.53 99.01,88.96 97.59,89.89 98.09,91.54 98.02,92.1 97.66,92.23 95.81,91.04 94.45,92.2 94.05,92.23 93.79,91.9 94.12,89.92 92.76,88.96 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="99.21,88.6 99.51,88.23 101.26,87.84 102.06,86.05 102.42,85.98 102.72,86.15 103.58,87.74 105.3,88.1 105.83,88.53 105.63,88.96 104.21,89.89 104.7,91.54 104.64,92.1 104.27,92.23 102.42,91.04 101.06,92.2 100.67,92.23 100.4,91.9 100.73,89.92 99.38,88.96 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="105.83,88.6 106.12,88.23 107.88,87.84 108.67,86.05 109.03,85.98 109.33,86.15 110.19,87.74 111.91,88.1 112.44,88.53 112.24,88.96 110.82,89.89 111.32,91.54 111.25,92.1 110.89,92.23 109.03,91.04 107.68,92.2 107.28,92.23 107.02,91.9 107.35,89.92 105.99,88.96 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="132.28,88.6 132.58,88.23 134.33,87.84 135.13,86.05 135.49,85.98 135.79,86.15 136.65,87.74 138.37,88.1 138.9,88.53 138.7,88.96 137.28,89.89 137.77,91.54 137.71,92.1 137.34,92.23 135.49,91.04 134.14,92.2 133.74,92.23 133.47,91.9 133.8,89.92 132.45,88.96 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="138.9,88.6 139.2,88.23 140.95,87.84 141.74,86.05 142.11,85.98 142.4,86.15 143.26,87.74 144.98,88.1 145.51,88.53 145.31,88.96 143.89,89.89 144.39,91.54 144.32,92.1 143.96,92.23 142.11,91.04 140.75,92.2 140.35,92.23 140.09,91.9 140.42,89.92 139.06,88.96 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="145.51,88.6 145.81,88.23 147.56,87.84 148.36,86.05 148.72,85.98 149.02,86.15 149.88,87.74 151.6,88.1 152.13,88.53 151.93,88.96 150.51,89.89 151,91.54 150.94,92.1 150.57,92.23 148.72,91.04 147.36,92.2 146.97,92.23 146.7,91.9 147.03,89.92 145.68,88.96 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="19.84,95.21 20.14,94.85 21.89,94.45 22.69,92.66 23.05,92.6 23.35,92.76 24.21,94.35 25.93,94.71 26.46,95.14 26.26,95.57 24.84,96.5 25.33,98.15 25.27,98.72 24.9,98.85 23.05,97.66 21.69,98.82 21.3,98.85 21.03,98.52 21.36,96.53 20.01,95.57 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="33.07,95.21 33.37,94.85 35.12,94.45 35.91,92.66 36.28,92.6 36.58,92.76 37.44,94.35 39.16,94.71 39.69,95.14 39.49,95.57 38.06,96.5 38.56,98.15 38.49,98.72 38.13,98.85 36.28,97.66 34.92,98.82 34.53,98.85 34.26,98.52 34.59,96.53 33.24,95.57 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="39.69,95.21 39.98,94.85 41.74,94.45 42.53,92.66 42.89,92.6 43.19,92.76 44.05,94.35 45.77,94.71 46.3,95.14 46.1,95.57 44.68,96.5 45.17,98.15 45.11,98.72 44.74,98.85 42.89,97.66 41.54,98.82 41.14,98.85 40.88,98.52 41.21,96.53 39.85,95.57 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="52.91,95.21 53.21,94.85 54.96,94.45 55.76,92.66 56.12,92.6 56.42,92.76 57.28,94.35 59,94.71 59.53,95.14 59.33,95.57 57.91,96.5 58.4,98.15 58.34,98.72 57.97,98.85 56.12,97.66 54.77,98.82 54.37,98.85 54.1,98.52 54.43,96.53 53.08,95.57 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="66.14,95.21 66.44,94.85 68.19,94.45 68.99,92.66 69.35,92.6 69.65,92.76 70.51,94.35 72.23,94.71 72.76,95.14 72.56,95.57 71.14,96.5 71.63,98.15 71.57,98.72 71.2,98.85 69.35,97.66 67.99,98.82 67.6,98.85 67.33,98.52 67.66,96.53 66.31,95.57 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="72.76,95.21 73.05,94.85 74.81,94.45 75.6,92.66 75.96,92.6 76.26,92.76 77.12,94.35 78.84,94.71 79.37,95.14 79.17,95.57 77.75,96.5 78.25,98.15 78.18,98.72 77.82,98.85 75.96,97.66 74.61,98.82 74.21,98.85 73.95,98.52 74.28,96.53 72.92,95.57 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="92.6,95.21 92.9,94.85 94.65,94.45 95.44,92.66 95.81,92.6 96.1,92.76 96.96,94.35 98.68,94.71 99.21,95.14 99.01,95.57 97.59,96.5 98.09,98.15 98.02,98.72 97.66,98.85 95.81,97.66 94.45,98.82 94.05,98.85 93.79,98.52 94.12,96.53 92.76,95.57 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="112.44,95.21 112.74,94.85 114.49,94.45 115.29,92.66 115.65,92.6 115.95,92.76 116.81,94.35 118.53,94.71 119.06,95.14 118.86,95.57 117.43,96.5 117.93,98.15 117.86,98.72 117.5,98.85 115.65,97.66 114.29,98.82 113.9,98.85 113.63,98.52 113.96,96.53 112.61,95.57 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="138.9,95.21 139.2,94.85 140.95,94.45 141.74,92.66 142.11,92.6 142.4,92.76 143.26,94.35 144.98,94.71 145.51,95.14 145.31,95.57 143.89,96.5 144.39,98.15 144.32,98.72 143.96,98.85 142.11,97.66 140.75,98.82 140.35,98.85 140.09,98.52 140.42,96.53 139.06,95.57 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="66.14,101.83 66.44,101.46 68.19,101.06 68.99,99.28 69.35,99.21 69.65,99.38 70.51,100.97 72.23,101.33 72.76,101.76 72.56,102.19 71.14,103.11 71.63,104.77 71.57,105.33 71.2,105.46 69.35,104.27 67.99,105.43 67.6,105.46 67.33,105.13 67.66,103.15 66.31,102.19 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="79.37,101.83 79.67,101.46 81.42,101.06 82.21,99.28 82.58,99.21 82.88,99.38 83.74,100.97 85.46,101.33 85.98,101.76 85.79,102.19 84.36,103.11 84.86,104.77 84.79,105.33 84.43,105.46 82.58,104.27 81.22,105.43 80.83,105.46 80.56,105.13 80.89,103.15 79.54,102.19 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="92.6,101.83 92.9,101.46 94.65,101.06 95.44,99.28 95.81,99.21 96.1,99.38 96.96,100.97 98.68,101.33 99.21,101.76 99.01,102.19 97.59,103.11 98.09,104.77 98.02,105.33 97.66,105.46 95.81,104.27 94.45,105.43 94.05,105.46 93.79,105.13 94.12,103.15 92.76,102.19 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="112.44,101.83 112.74,101.46 114.49,101.06 115.29,99.28 115.65,99.21 115.95,99.38 116.81,100.97 118.53,101.33 119.06,101.76 118.86,102.19 117.43,103.11 117.93,104.77 117.86,105.33 117.5,105.46 115.65,104.27 114.29,105.43 113.9,105.46 113.63,105.13 113.96,103.15 112.61,102.19 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="132.28,101.83 132.58,101.46 134.33,101.06 135.13,99.28 135.49,99.21 135.79,99.38 136.65,100.97 138.37,101.33 138.9,101.76 138.7,102.19 137.28,103.11 137.77,104.77 137.71,105.33 137.34,105.46 135.49,104.27 134.14,105.43 133.74,105.46 133.47,105.13 133.8,103.15 132.45,102.19 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="66.14,108.44 66.44,108.08 68.19,107.68 68.99,105.89 69.35,105.83 69.65,105.99 70.51,107.58 72.23,107.94 72.76,108.37 72.56,108.8 71.14,109.73 71.63,111.38 71.57,111.94 71.2,112.08 69.35,110.89 67.99,112.04 67.6,112.08 67.33,111.75 67.66,109.76 66.31,108.8 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="85.98,108.44 86.28,108.08 88.03,107.68 88.83,105.89 89.19,105.83 89.49,105.99 90.35,107.58 92.07,107.94 92.6,108.37 92.4,108.8 90.98,109.73 91.47,111.38 91.41,111.94 91.04,112.08 89.19,110.89 87.84,112.04 87.44,112.08 87.17,111.75 87.51,109.76 86.15,108.8 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="99.21,108.44 99.51,108.08 101.26,107.68 102.06,105.89 102.42,105.83 102.72,105.99 103.58,107.58 105.3,107.94 105.83,108.37 105.63,108.8 104.21,109.73 104.7,111.38 104.64,111.94 104.27,112.08 102.42,110.89 101.06,112.04 100.67,112.08 100.4,111.75 100.73,109.76 99.38,108.8 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="119.06,108.44 119.35,108.08 121.11,107.68 121.9,105.89 122.26,105.83 122.56,105.99 123.42,107.58 125.14,107.94 125.67,108.37 125.47,108.8 124.05,109.73 124.54,111.38 124.48,111.94 124.11,112.08 122.26,110.89 120.91,112.04 120.51,112.08 120.25,111.75 120.58,109.76 119.22,108.8 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="125.67,108.44 125.97,108.08 127.72,107.68 128.51,105.89 128.88,105.83 129.17,105.99 130.03,107.58 131.75,107.94 132.28,108.37 132.09,108.8 130.66,109.73 131.16,111.38 131.09,111.94 130.73,112.08 128.88,110.89 127.52,112.04 127.12,112.08 126.86,111.75 127.19,109.76 125.83,108.8 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="138.9,108.44 139.2,108.08 140.95,107.68 141.74,105.89 142.11,105.83 142.4,105.99 143.26,107.58 144.98,107.94 145.51,108.37 145.31,108.8 143.89,109.73 144.39,111.38 144.32,111.94 143.96,112.08 142.11,110.89 140.75,112.04 140.35,112.08 140.09,111.75 140.42,109.76 139.06,108.8 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="145.51,108.44 145.81,108.08 147.56,107.68 148.36,105.89 148.72,105.83 149.02,105.99 149.88,107.58 151.6,107.94 152.13,108.37 151.93,108.8 150.51,109.73 151,111.38 150.94,111.94 150.57,112.08 148.72,110.89 147.36,112.04 146.97,112.08 146.7,111.75 147.03,109.76 145.68,108.8 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="72.76,115.05 73.05,114.69 74.81,114.29 75.6,112.51 75.96,112.44 76.26,112.61 77.12,114.19 78.84,114.56 79.37,114.99 79.17,115.42 77.75,116.34 78.25,118 78.18,118.56 77.82,118.69 75.96,117.5 74.61,118.66 74.21,118.69 73.95,118.36 74.28,116.38 72.92,115.42 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="79.37,115.05 79.67,114.69 81.42,114.29 82.21,112.51 82.58,112.44 82.88,112.61 83.74,114.19 85.46,114.56 85.98,114.99 85.79,115.42 84.36,116.34 84.86,118 84.79,118.56 84.43,118.69 82.58,117.5 81.22,118.66 80.83,118.69 80.56,118.36 80.89,116.38 79.54,115.42 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="112.44,115.05 112.74,114.69 114.49,114.29 115.29,112.51 115.65,112.44 115.95,112.61 116.81,114.19 118.53,114.56 119.06,114.99 118.86,115.42 117.43,116.34 117.93,118 117.86,118.56 117.5,118.69 115.65,117.5 114.29,118.66 113.9,118.69 113.63,118.36 113.96,116.38 112.61,115.42 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="119.06,115.05 119.35,114.69 121.11,114.29 121.9,112.51 122.26,112.44 122.56,112.61 123.42,114.19 125.14,114.56 125.67,114.99 125.47,115.42 124.05,116.34 124.54,118 124.48,118.56 124.11,118.69 122.26,117.5 120.91,118.66 120.51,118.69 120.25,118.36 120.58,116.38 119.22,115.42 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="132.28,115.05 132.58,114.69 134.33,114.29 135.13,112.51 135.49,112.44 135.79,112.61 136.65,114.19 138.37,114.56 138.9,114.99 138.7,115.42 137.28,116.34 137.77,118 137.71,118.56 137.34,118.69 135.49,117.5 134.14,118.66 133.74,118.69 133.47,118.36 133.8,116.38 132.45,115.42 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="145.51,115.05 145.81,114.69 147.56,114.29 148.36,112.51 148.72,112.44 149.02,112.61 149.88,114.19 151.6,114.56 152.13,114.99 151.93,115.42 150.51,116.34 151,118 150.94,118.56 150.57,118.69 148.72,117.5 147.36,118.66 146.97,118.69 146.7,118.36 147.03,116.38 145.68,115.42 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="66.14,121.67 66.44,121.3 68.19,120.91 68.99,119.12 69.35,119.06 69.65,119.22 70.51,120.81 72.23,121.17 72.76,121.6 72.56,122.03 71.14,122.96 71.63,124.61 71.57,125.17 71.2,125.31 69.35,124.11 67.99,125.27 67.6,125.31 67.33,124.97 67.66,122.99 66.31,122.03 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="72.76,121.67 73.05,121.3 74.81,120.91 75.6,119.12 75.96,119.06 76.26,119.22 77.12,120.81 78.84,121.17 79.37,121.6 79.17,122.03 77.75,122.96 78.25,124.61 78.18,125.17 77.82,125.31 75.96,124.11 74.61,125.27 74.21,125.31 73.95,124.97 74.28,122.99 72.92,122.03 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="79.37,121.67 79.67,121.3 81.42,120.91 82.21,119.12 82.58,119.06 82.88,119.22 83.74,120.81 85.46,121.17 85.98,121.6 85.79,122.03 84.36,122.96 84.86,124.61 84.79,125.17 84.43,125.31 82.58,124.11 81.22,125.27 80.83,125.31 80.56,124.97 80.89,122.99 79.54,122.03 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="85.98,121.67 86.28,121.3 88.03,120.91 88.83,119.12 89.19,119.06 89.49,119.22 90.35,120.81 92.07,121.17 92.6,121.6 92.4,122.03 90.98,122.96 91.47,124.61 91.41,125.17 91.04,125.31 89.19,124.11 87.84,125.27 87.44,125.31 87.17,124.97 87.51,122.99 86.15,122.03 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="99.21,121.67 99.51,121.3 101.26,120.91 102.06,119.12 102.42,119.06 102.72,119.22 103.58,120.81 105.3,121.17 105.83,121.6 105.63,122.03 104.21,122.96 104.7,124.61 104.64,125.17 104.27,125.31 102.42,124.11 101.06,125.27 100.67,125.31 100.4,124.97 100.73,122.99 99.38,122.03 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="119.06,121.67 119.35,121.3 121.11,120.91 121.9,119.12 122.26,119.06 122.56,119.22 123.42,120.81 125.14,121.17 125.67,121.6 125.47,122.03 124.05,122.96 124.54,124.61 124.48,125.17 124.11,125.31 122.26,124.11 120.91,125.27 120.51,125.31 120.25,124.97 120.58,122.99 119.22,122.03 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="125.67,121.67 125.97,121.3 127.72,120.91 128.51,119.12 128.88,119.06 129.17,119.22 130.03,120.81 131.75,121.17 132.28,121.6 132.09,122.03 130.66,122.96 131.16,124.61 131.09,125.17 130.73,125.31 128.88,124.11 127.52,125.27 127.12,125.31 126.86,124.97 127.19,122.99 125.83,122.03 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="132.28,121.67 132.58,121.3 134.33,120.91 135.13,119.12 135.49,119.06 135.79,119.22 136.65,120.81 138.37,121.17 138.9,121.6 138.7,122.03 137.28,122.96 137.77,124.61 137.71,125.17 137.34,125.31 135.49,124.11 134.14,125.27 133.74,125.31 133.47,124.97 133.8,122.99 132.45,122.03 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="66.14,128.28 66.44,127.92 68.19,127.52 68.99,125.74 69.35,125.67 69.65,125.83 70.51,127.42 72.23,127.79 72.76,128.22 72.56,128.65 71.14,129.57 71.63,131.23 71.57,131.79 71.2,131.92 69.35,130.73 67.99,131.89 67.6,131.92 67.33,131.59 67.66,129.6 66.31,128.65 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="72.76,128.28 73.05,127.92 74.81,127.52 75.6,125.74 75.96,125.67 76.26,125.83 77.12,127.42 78.84,127.79 79.37,128.22 79.17,128.65 77.75,129.57 78.25,131.23 78.18,131.79 77.82,131.92 75.96,130.73 74.61,131.89 74.21,131.92 73.95,131.59 74.28,129.6 72.92,128.65 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="85.98,128.28 86.28,127.92 88.03,127.52 88.83,125.74 89.19,125.67 89.49,125.83 90.35,127.42 92.07,127.79 92.6,128.22 92.4,128.65 90.98,129.57 91.47,131.23 91.41,131.79 91.04,131.92 89.19,130.73 87.84,131.89 87.44,131.92 87.17,131.59 87.51,129.6 86.15,128.65 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="92.6,128.28 92.9,127.92 94.65,127.52 95.44,125.74 95.81,125.67 96.1,125.83 96.96,127.42 98.68,127.79 99.21,128.22 99.01,128.65 97.59,129.57 98.09,131.23 98.02,131.79 97.66,131.92 95.81,130.73 94.45,131.89 94.05,131.92 93.79,131.59 94.12,129.6 92.76,128.65 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="99.21,128.28 99.51,127.92 101.26,127.52 102.06,125.74 102.42,125.67 102.72,125.83 103.58,127.42 105.3,127.79 105.83,128.22 105.63,128.65 104.21,129.57 104.7,131.23 104.64,131.79 104.27,131.92 102.42,130.73 101.06,131.89 100.67,131.92 100.4,131.59 100.73,129.6 99.38,128.65 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="105.83,128.28 106.12,127.92 107.88,127.52 108.67,125.74 109.03,125.67 109.33,125.83 110.19,127.42 111.91,127.79 112.44,128.22 112.24,128.65 110.82,129.57 111.32,131.23 111.25,131.79 110.89,131.92 109.03,130.73 107.68,131.89 107.28,131.92 107.02,131.59 107.35,129.6 105.99,128.65 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="112.44,128.28 112.74,127.92 114.49,127.52 115.29,125.74 115.65,125.67 115.95,125.83 116.81,127.42 118.53,127.79 119.06,128.22 118.86,128.65 117.43,129.57 117.93,131.23 117.86,131.79 117.5,131.92 115.65,130.73 114.29,131.89 113.9,131.92 113.63,131.59 113.96,129.6 112.61,128.65 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="125.67,128.28 125.97,127.92 127.72,127.52 128.51,125.74 128.88,125.67 129.17,125.83 130.03,127.42 131.75,127.79 132.28,128.22 132.09,128.65 130.66,129.57 131.16,131.23 131.09,131.79 130.73,131.92 128.88,130.73 127.52,131.89 127.12,131.92 126.86,131.59 127.19,129.6 125.83,128.65 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="132.28,128.28 132.58,127.92 134.33,127.52 135.13,125.74 135.49,125.67 135.79,125.83 136.65,127.42 138.37,127.79 138.9,128.22 138.7,128.65 137.28,129.57 137.77,131.23 137.71,131.79 137.34,131.92 135.49,130.73 134.14,131.89 133.74,131.92 133.47,131.59 133.8,129.6 132.45,128.65 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="66.14,134.9 66.44,134.53 68.19,134.14 68.99,132.35 69.35,132.28 69.65,132.45 70.51,134.04 72.23,134.4 72.76,134.83 72.56,135.26 71.14,136.19 71.63,137.84 71.57,138.4 71.2,138.53 69.35,137.34 67.99,138.5 67.6,138.53 67.33,138.2 67.66,136.22 66.31,135.26 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="72.76,134.9 73.05,134.53 74.81,134.14 75.6,132.35 75.96,132.28 76.26,132.45 77.12,134.04 78.84,134.4 79.37,134.83 79.17,135.26 77.75,136.19 78.25,137.84 78.18,138.4 77.82,138.53 75.96,137.34 74.61,138.5 74.21,138.53 73.95,138.2 74.28,136.22 72.92,135.26 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="92.6,134.9 92.9,134.53 94.65,134.14 95.44,132.35 95.81,132.28 96.1,132.45 96.96,134.04 98.68,134.4 99.21,134.83 99.01,135.26 97.59,136.19 98.09,137.84 98.02,138.4 97.66,138.53 95.81,137.34 94.45,138.5 94.05,138.53 93.79,138.2 94.12,136.22 92.76,135.26 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="105.83,134.9 106.12,134.53 107.88,134.14 108.67,132.35 109.03,132.28 109.33,132.45 110.19,134.04 111.91,134.4 112.44,134.83 112.24,135.26 110.82,136.19 111.32,137.84 111.25,138.4 110.89,138.53 109.03,137.34 107.68,138.5 107.28,138.53 107.02,138.2 107.35,136.22 105.99,135.26 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="112.44,134.9 112.74,134.53 114.49,134.14 115.29,132.35 115.65,132.28 115.95,132.45 116.81,134.04 118.53,134.4 119.06,134.83 118.86,135.26 117.43,136.19 117.93,137.84 117.86,138.4 117.5,138.53 115.65,137.34 114.29,138.5 113.9,138.53 113.63,138.2 113.96,136.22 112.61,135.26 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="125.67,134.9 125.97,134.53 127.72,134.14 128.51,132.35 128.88,132.28 129.17,132.45 130.03,134.04 131.75,134.4 132.28,134.83 132.09,135.26 130.66,136.19 131.16,137.84 131.09,138.4 130.73,138.53 128.88,137.34 127.52,138.5 127.12,138.53 126.86,138.2 127.19,136.22 125.83,135.26 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="132.28,134.9 132.58,134.53 134.33,134.14 135.13,132.35 135.49,132.28 135.79,132.45 136.65,134.04 138.37,134.4 138.9,134.83 138.7,135.26 137.28,136.19 137.77,137.84 137.71,138.4 137.34,138.53 135.49,137.34 134.14,138.5 133.74,138.53 133.47,138.2 133.8,136.22 132.45,135.26 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="66.14,141.51 66.44,141.15 68.19,140.75 68.99,138.96 69.35,138.9 69.65,139.06 70.51,140.65 72.23,141.01 72.76,141.44 72.56,141.87 71.14,142.8 71.63,144.45 71.57,145.02 71.2,145.15 69.35,143.96 67.99,145.11 67.6,145.15 67.33,144.82 67.66,142.83 66.31,141.87 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="79.37,141.51 79.67,141.15 81.42,140.75 82.21,138.96 82.58,138.9 82.88,139.06 83.74,140.65 85.46,141.01 85.98,141.44 85.79,141.87 84.36,142.8 84.86,144.45 84.79,145.02 84.43,145.15 82.58,143.96 81.22,145.11 80.83,145.15 80.56,144.82 80.89,142.83 79.54,141.87 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="85.98,141.51 86.28,141.15 88.03,140.75 88.83,138.96 89.19,138.9 89.49,139.06 90.35,140.65 92.07,141.01 92.6,141.44 92.4,141.87 90.98,142.8 91.47,144.45 91.41,145.02 91.04,145.15 89.19,143.96 87.84,145.11 87.44,145.15 87.17,144.82 87.51,142.83 86.15,141.87 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="92.6,141.51 92.9,141.15 94.65,140.75 95.44,138.96 95.81,138.9 96.1,139.06 96.96,140.65 98.68,141.01 99.21,141.44 99.01,141.87 97.59,142.8 98.09,144.45 98.02,145.02 97.66,145.15 95.81,143.96 94.45,145.11 94.05,145.15 93.79,144.82 94.12,142.83 92.76,141.87 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="99.21,141.51 99.51,141.15 101.26,140.75 102.06,138.96 102.42,138.9 102.72,139.06 103.58,140.65 105.3,141.01 105.83,141.44 105.63,141.87 104.21,142.8 104.7,144.45 104.64,145.02 104.27,145.15 102.42,143.96 101.06,145.11 100.67,145.15 100.4,144.82 100.73,142.83 99.38,141.87 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="105.83,141.51 106.12,141.15 107.88,140.75 108.67,138.96 109.03,138.9 109.33,139.06 110.19,140.65 111.91,141.01 112.44,141.44 112.24,141.87 110.82,142.8 111.32,144.45 111.25,145.02 110.89,145.15 109.03,143.96 107.68,145.11 107.28,145.15 107.02,144.82 107.35,142.83 105.99,141.87 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="112.44,141.51 112.74,141.15 114.49,140.75 115.29,138.96 115.65,138.9 115.95,139.06 116.81,140.65 118.53,141.01 119.06,141.44 118.86,141.87 117.43,142.8 117.93,144.45 117.86,145.02 117.5,145.15 115.65,143.96 114.29,145.11 113.9,145.15 113.63,144.82 113.96,142.83 112.61,141.87 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="119.06,141.51 119.35,141.15 121.11,140.75 121.9,138.96 122.26,138.9 122.56,139.06 123.42,140.65 125.14,141.01 125.67,141.44 125.47,141.87 124.05,142.8 124.54,144.45 124.48,145.02 124.11,145.15 122.26,143.96 120.91,145.11 120.51,145.15 120.25,144.82 120.58,142.83 119.22,141.87 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="132.28,141.51 132.58,141.15 134.33,140.75 135.13,138.96 135.49,138.9 135.79,139.06 136.65,140.65 138.37,141.01 138.9,141.44 138.7,141.87 137.28,142.8 137.77,144.45 137.71,145.02 137.34,145.15 135.49,143.96 134.14,145.11 133.74,145.15 133.47,144.82 133.8,142.83 132.45,141.87 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="138.9,141.51 139.2,141.15 140.95,140.75 141.74,138.96 142.11,138.9 142.4,139.06 143.26,140.65 144.98,141.01 145.51,141.44 145.31,141.87 143.89,142.8 144.39,144.45 144.32,145.02 143.96,145.15 142.11,143.96 140.75,145.11 140.35,145.15 140.09,144.82 140.42,142.83 139.06,141.87 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="66.14,148.12 66.44,147.76 68.19,147.36 68.99,145.58 69.35,145.51 69.65,145.68 70.51,147.26 72.23,147.63 72.76,148.06 72.56,148.49 71.14,149.41 71.63,151.07 71.57,151.63 71.2,151.76 69.35,150.57 67.99,151.73 67.6,151.76 67.33,151.43 67.66,149.45 66.31,148.49 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="72.76,148.12 73.05,147.76 74.81,147.36 75.6,145.58 75.96,145.51 76.26,145.68 77.12,147.26 78.84,147.63 79.37,148.06 79.17,148.49 77.75,149.41 78.25,151.07 78.18,151.63 77.82,151.76 75.96,150.57 74.61,151.73 74.21,151.76 73.95,151.43 74.28,149.45 72.92,148.49 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="79.37,148.12 79.67,147.76 81.42,147.36 82.21,145.58 82.58,145.51 82.88,145.68 83.74,147.26 85.46,147.63 85.98,148.06 85.79,148.49 84.36,149.41 84.86,151.07 84.79,151.63 84.43,151.76 82.58,150.57 81.22,151.73 80.83,151.76 80.56,151.43 80.89,149.45 79.54,148.49 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="92.6,148.12 92.9,147.76 94.65,147.36 95.44,145.58 95.81,145.51 96.1,145.68 96.96,147.26 98.68,147.63 99.21,148.06 99.01,148.49 97.59,149.41 98.09,151.07 98.02,151.63 97.66,151.76 95.81,150.57 94.45,151.73 94.05,151.76 93.79,151.43 94.12,149.45 92.76,148.49 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="112.44,148.12 112.74,147.76 114.49,147.36 115.29,145.58 115.65,145.51 115.95,145.68 116.81,147.26 118.53,147.63 119.06,148.06 118.86,148.49 117.43,149.41 117.93,151.07 117.86,151.63 117.5,151.76 115.65,150.57 114.29,151.73 113.9,151.76 113.63,151.43 113.96,149.45 112.61,148.49 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
          <polygon
            points="132.28,148.12 132.58,147.76 134.33,147.36 135.13,145.58 135.49,145.51 135.79,145.68 136.65,147.26 138.37,147.63 138.9,148.06 138.7,148.49 137.28,149.41 137.77,151.07 137.71,151.63 137.34,151.76 135.49,150.57 134.14,151.73 133.74,151.76 133.47,151.43 133.8,149.45 132.45,148.49 "
            style="fill:url(#gradient80618ad2d9ad494d91b68c40b4cb4fde);"
          />
      `,
            },
            {
                value: 19,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(37,86,99,1);"
            shape-rendering="crispEdges"
          />
          <pattern
            id="hatch83f34b8d7c854d8ca48088966a8ce8fa"
            x="0"
            y="0"
            width="8"
            height="8"
            patternUnits="userSpaceOnUse"
          >
            <rect x="0" y="0" width="8" height="8" fill="#C6D9F0" />
            <rect x="0" y="0" width="1" height="1" fill="#FDEADA" />
            <rect x="1" y="0" width="1" height="1" fill="#FDEADA" />
            <rect x="4" y="0" width="1" height="1" fill="#FDEADA" />
            <rect x="5" y="0" width="1" height="1" fill="#FDEADA" />
            <rect x="0" y="1" width="1" height="1" fill="#FDEADA" />
            <rect x="1" y="1" width="1" height="1" fill="#FDEADA" />
            <rect x="4" y="1" width="1" height="1" fill="#FDEADA" />
            <rect x="5" y="1" width="1" height="1" fill="#FDEADA" />
            <rect x="0" y="2" width="1" height="1" fill="#FDEADA" />
            <rect x="1" y="2" width="1" height="1" fill="#FDEADA" />
            <rect x="4" y="2" width="1" height="1" fill="#FDEADA" />
            <rect x="5" y="2" width="1" height="1" fill="#FDEADA" />
            <rect x="0" y="3" width="1" height="1" fill="#FDEADA" />
            <rect x="1" y="3" width="1" height="1" fill="#FDEADA" />
            <rect x="4" y="3" width="1" height="1" fill="#FDEADA" />
            <rect x="5" y="3" width="1" height="1" fill="#FDEADA" />
            <rect x="0" y="4" width="1" height="1" fill="#FDEADA" />
            <rect x="1" y="4" width="1" height="1" fill="#FDEADA" />
            <rect x="4" y="4" width="1" height="1" fill="#FDEADA" />
            <rect x="5" y="4" width="1" height="1" fill="#FDEADA" />
            <rect x="0" y="5" width="1" height="1" fill="#FDEADA" />
            <rect x="1" y="5" width="1" height="1" fill="#FDEADA" />
            <rect x="4" y="5" width="1" height="1" fill="#FDEADA" />
            <rect x="5" y="5" width="1" height="1" fill="#FDEADA" />
            <rect x="0" y="6" width="1" height="1" fill="#FDEADA" />
            <rect x="1" y="6" width="1" height="1" fill="#FDEADA" />
            <rect x="4" y="6" width="1" height="1" fill="#FDEADA" />
            <rect x="5" y="6" width="1" height="1" fill="#FDEADA" />
            <rect x="0" y="7" width="1" height="1" fill="#FDEADA" />
            <rect x="1" y="7" width="1" height="1" fill="#FDEADA" />
            <rect x="4" y="7" width="1" height="1" fill="#FDEADA" />
            <rect x="5" y="7" width="1" height="1" fill="#FDEADA" />
          </pattern>
          <polygon
            points="19.84,16.54 19.59,17.8 18.87,18.87 17.8,19.59 16.54,19.84 15.27,19.59 14.2,18.87 13.48,17.8 13.23,16.54 13.48,15.27 14.2,14.2 15.27,13.48 16.54,13.23 17.8,13.48 18.87,14.2 19.59,15.27 19.84,16.54 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="19.84,56.22 19.59,57.49 18.87,58.56 17.8,59.28 16.54,59.53 15.27,59.28 14.2,58.56 13.48,57.49 13.23,56.22 13.48,54.95 14.2,53.88 15.27,53.17 16.54,52.91 17.8,53.17 18.87,53.88 19.59,54.95 19.84,56.22 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="26.46,16.54 26.2,17.8 25.49,18.87 24.42,19.59 23.15,19.84 21.88,19.59 20.81,18.87 20.09,17.8 19.84,16.54 20.09,15.27 20.81,14.2 21.88,13.48 23.15,13.23 24.42,13.48 25.49,14.2 26.2,15.27 26.46,16.54 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="26.46,56.22 26.2,57.49 25.49,58.56 24.42,59.28 23.15,59.53 21.88,59.28 20.81,58.56 20.09,57.49 19.84,56.22 20.09,54.95 20.81,53.88 21.88,53.17 23.15,52.91 24.42,53.17 25.49,53.88 26.2,54.95 26.46,56.22 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="33.07,16.54 32.82,17.8 32.1,18.87 31.03,19.59 29.76,19.84 28.5,19.59 27.43,18.87 26.71,17.8 26.46,16.54 26.71,15.27 27.43,14.2 28.5,13.48 29.76,13.23 31.03,13.48 32.1,14.2 32.82,15.27 33.07,16.54 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="33.07,56.22 32.82,57.49 32.1,58.56 31.03,59.28 29.76,59.53 28.5,59.28 27.43,58.56 26.71,57.49 26.46,56.22 26.71,54.95 27.43,53.88 28.5,53.17 29.76,52.91 31.03,53.17 32.1,53.88 32.82,54.95 33.07,56.22 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="39.69,16.54 39.43,17.8 38.72,18.87 37.64,19.59 36.38,19.84 35.11,19.59 34.04,18.87 33.32,17.8 33.07,16.54 33.32,15.27 34.04,14.2 35.11,13.48 36.38,13.23 37.64,13.48 38.72,14.2 39.43,15.27 39.69,16.54 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="39.69,56.22 39.43,57.49 38.72,58.56 37.64,59.28 36.38,59.53 35.11,59.28 34.04,58.56 33.32,57.49 33.07,56.22 33.32,54.95 34.04,53.88 35.11,53.17 36.38,52.91 37.64,53.17 38.72,53.88 39.43,54.95 39.69,56.22 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="46.3,16.54 46.05,17.8 45.33,18.87 44.26,19.59 42.99,19.84 41.73,19.59 40.65,18.87 39.94,17.8 39.69,16.54 39.94,15.27 40.65,14.2 41.73,13.48 42.99,13.23 44.26,13.48 45.33,14.2 46.05,15.27 46.3,16.54 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="46.3,56.22 46.05,57.49 45.33,58.56 44.26,59.28 42.99,59.53 41.73,59.28 40.65,58.56 39.94,57.49 39.69,56.22 39.94,54.95 40.65,53.88 41.73,53.17 42.99,52.91 44.26,53.17 45.33,53.88 46.05,54.95 46.3,56.22 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="52.91,16.54 52.66,17.8 51.94,18.87 50.87,19.59 49.61,19.84 48.34,19.59 47.27,18.87 46.55,17.8 46.3,16.54 46.55,15.27 47.27,14.2 48.34,13.48 49.61,13.23 50.87,13.48 51.94,14.2 52.66,15.27 52.91,16.54 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="52.91,56.22 52.66,57.49 51.94,58.56 50.87,59.28 49.61,59.53 48.34,59.28 47.27,58.56 46.55,57.49 46.3,56.22 46.55,54.95 47.27,53.88 48.34,53.17 49.61,52.91 50.87,53.17 51.94,53.88 52.66,54.95 52.91,56.22 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="59.53,16.54 59.28,17.8 58.56,18.87 57.49,19.59 56.22,19.84 54.95,19.59 53.88,18.87 53.17,17.8 52.91,16.54 53.17,15.27 53.88,14.2 54.95,13.48 56.22,13.23 57.49,13.48 58.56,14.2 59.28,15.27 59.53,16.54 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="59.53,56.22 59.28,57.49 58.56,58.56 57.49,59.28 56.22,59.53 54.95,59.28 53.88,58.56 53.17,57.49 52.91,56.22 53.17,54.95 53.88,53.88 54.95,53.17 56.22,52.91 57.49,53.17 58.56,53.88 59.28,54.95 59.53,56.22 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="19.84,23.15 19.59,24.42 18.87,25.49 17.8,26.2 16.54,26.46 15.27,26.2 14.2,25.49 13.48,24.42 13.23,23.15 13.48,21.88 14.2,20.81 15.27,20.09 16.54,19.84 17.8,20.09 18.87,20.81 19.59,21.88 19.84,23.15 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="59.53,23.15 59.28,24.42 58.56,25.49 57.49,26.2 56.22,26.46 54.95,26.2 53.88,25.49 53.17,24.42 52.91,23.15 53.17,21.88 53.88,20.81 54.95,20.09 56.22,19.84 57.49,20.09 58.56,20.81 59.28,21.88 59.53,23.15 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="19.84,29.76 19.59,31.03 18.87,32.1 17.8,32.82 16.54,33.07 15.27,32.82 14.2,32.1 13.48,31.03 13.23,29.76 13.48,28.5 14.2,27.43 15.27,26.71 16.54,26.46 17.8,26.71 18.87,27.43 19.59,28.5 19.84,29.76 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="59.53,29.76 59.28,31.03 58.56,32.1 57.49,32.82 56.22,33.07 54.95,32.82 53.88,32.1 53.17,31.03 52.91,29.76 53.17,28.5 53.88,27.43 54.95,26.71 56.22,26.46 57.49,26.71 58.56,27.43 59.28,28.5 59.53,29.76 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="19.84,36.38 19.59,37.64 18.87,38.72 17.8,39.43 16.54,39.69 15.27,39.43 14.2,38.72 13.48,37.64 13.23,36.38 13.48,35.11 14.2,34.04 15.27,33.32 16.54,33.07 17.8,33.32 18.87,34.04 19.59,35.11 19.84,36.38 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="59.53,36.38 59.28,37.64 58.56,38.72 57.49,39.43 56.22,39.69 54.95,39.43 53.88,38.72 53.17,37.64 52.91,36.38 53.17,35.11 53.88,34.04 54.95,33.32 56.22,33.07 57.49,33.32 58.56,34.04 59.28,35.11 59.53,36.38 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="19.84,42.99 19.59,44.26 18.87,45.33 17.8,46.05 16.54,46.3 15.27,46.05 14.2,45.33 13.48,44.26 13.23,42.99 13.48,41.73 14.2,40.65 15.27,39.94 16.54,39.69 17.8,39.94 18.87,40.65 19.59,41.73 19.84,42.99 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="59.53,42.99 59.28,44.26 58.56,45.33 57.49,46.05 56.22,46.3 54.95,46.05 53.88,45.33 53.17,44.26 52.91,42.99 53.17,41.73 53.88,40.65 54.95,39.94 56.22,39.69 57.49,39.94 58.56,40.65 59.28,41.73 59.53,42.99 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="19.84,49.61 19.59,50.87 18.87,51.94 17.8,52.66 16.54,52.91 15.27,52.66 14.2,51.94 13.48,50.87 13.23,49.61 13.48,48.34 14.2,47.27 15.27,46.55 16.54,46.3 17.8,46.55 18.87,47.27 19.59,48.34 19.84,49.61 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="59.53,49.61 59.28,50.87 58.56,51.94 57.49,52.66 56.22,52.91 54.95,52.66 53.88,51.94 53.17,50.87 52.91,49.61 53.17,48.34 53.88,47.27 54.95,46.55 56.22,46.3 57.49,46.55 58.56,47.27 59.28,48.34 59.53,49.61 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="19.84,109.13 19.59,110.4 18.87,111.47 17.8,112.19 16.54,112.44 15.27,112.19 14.2,111.47 13.48,110.4 13.23,109.13 13.48,107.87 14.2,106.8 15.27,106.08 16.54,105.83 17.8,106.08 18.87,106.8 19.59,107.87 19.84,109.13 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="19.84,148.82 19.59,150.08 18.87,151.16 17.8,151.87 16.54,152.13 15.27,151.87 14.2,151.16 13.48,150.08 13.23,148.82 13.48,147.55 14.2,146.48 15.27,145.76 16.54,145.51 17.8,145.76 18.87,146.48 19.59,147.55 19.84,148.82 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="26.46,109.13 26.2,110.4 25.49,111.47 24.42,112.19 23.15,112.44 21.88,112.19 20.81,111.47 20.09,110.4 19.84,109.13 20.09,107.87 20.81,106.8 21.88,106.08 23.15,105.83 24.42,106.08 25.49,106.8 26.2,107.87 26.46,109.13 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="26.46,148.82 26.2,150.08 25.49,151.16 24.42,151.87 23.15,152.13 21.88,151.87 20.81,151.16 20.09,150.08 19.84,148.82 20.09,147.55 20.81,146.48 21.88,145.76 23.15,145.51 24.42,145.76 25.49,146.48 26.2,147.55 26.46,148.82 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="33.07,109.13 32.82,110.4 32.1,111.47 31.03,112.19 29.76,112.44 28.5,112.19 27.43,111.47 26.71,110.4 26.46,109.13 26.71,107.87 27.43,106.8 28.5,106.08 29.76,105.83 31.03,106.08 32.1,106.8 32.82,107.87 33.07,109.13 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="33.07,148.82 32.82,150.08 32.1,151.16 31.03,151.87 29.76,152.13 28.5,151.87 27.43,151.16 26.71,150.08 26.46,148.82 26.71,147.55 27.43,146.48 28.5,145.76 29.76,145.51 31.03,145.76 32.1,146.48 32.82,147.55 33.07,148.82 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="39.69,109.13 39.43,110.4 38.72,111.47 37.64,112.19 36.38,112.44 35.11,112.19 34.04,111.47 33.32,110.4 33.07,109.13 33.32,107.87 34.04,106.8 35.11,106.08 36.38,105.83 37.64,106.08 38.72,106.8 39.43,107.87 39.69,109.13 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="39.69,148.82 39.43,150.08 38.72,151.16 37.64,151.87 36.38,152.13 35.11,151.87 34.04,151.16 33.32,150.08 33.07,148.82 33.32,147.55 34.04,146.48 35.11,145.76 36.38,145.51 37.64,145.76 38.72,146.48 39.43,147.55 39.69,148.82 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="46.3,109.13 46.05,110.4 45.33,111.47 44.26,112.19 42.99,112.44 41.73,112.19 40.65,111.47 39.94,110.4 39.69,109.13 39.94,107.87 40.65,106.8 41.73,106.08 42.99,105.83 44.26,106.08 45.33,106.8 46.05,107.87 46.3,109.13 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="46.3,148.82 46.05,150.08 45.33,151.16 44.26,151.87 42.99,152.13 41.73,151.87 40.65,151.16 39.94,150.08 39.69,148.82 39.94,147.55 40.65,146.48 41.73,145.76 42.99,145.51 44.26,145.76 45.33,146.48 46.05,147.55 46.3,148.82 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="52.91,109.13 52.66,110.4 51.94,111.47 50.87,112.19 49.61,112.44 48.34,112.19 47.27,111.47 46.55,110.4 46.3,109.13 46.55,107.87 47.27,106.8 48.34,106.08 49.61,105.83 50.87,106.08 51.94,106.8 52.66,107.87 52.91,109.13 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="52.91,148.82 52.66,150.08 51.94,151.16 50.87,151.87 49.61,152.13 48.34,151.87 47.27,151.16 46.55,150.08 46.3,148.82 46.55,147.55 47.27,146.48 48.34,145.76 49.61,145.51 50.87,145.76 51.94,146.48 52.66,147.55 52.91,148.82 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="59.53,109.13 59.28,110.4 58.56,111.47 57.49,112.19 56.22,112.44 54.95,112.19 53.88,111.47 53.17,110.4 52.91,109.13 53.17,107.87 53.88,106.8 54.95,106.08 56.22,105.83 57.49,106.08 58.56,106.8 59.28,107.87 59.53,109.13 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="59.53,148.82 59.28,150.08 58.56,151.16 57.49,151.87 56.22,152.13 54.95,151.87 53.88,151.16 53.17,150.08 52.91,148.82 53.17,147.55 53.88,146.48 54.95,145.76 56.22,145.51 57.49,145.76 58.56,146.48 59.28,147.55 59.53,148.82 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="19.84,115.75 19.59,117.01 18.87,118.09 17.8,118.8 16.54,119.06 15.27,118.8 14.2,118.09 13.48,117.01 13.23,115.75 13.48,114.48 14.2,113.41 15.27,112.69 16.54,112.44 17.8,112.69 18.87,113.41 19.59,114.48 19.84,115.75 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="59.53,115.75 59.28,117.01 58.56,118.09 57.49,118.8 56.22,119.06 54.95,118.8 53.88,118.09 53.17,117.01 52.91,115.75 53.17,114.48 53.88,113.41 54.95,112.69 56.22,112.44 57.49,112.69 58.56,113.41 59.28,114.48 59.53,115.75 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="19.84,122.36 19.59,123.63 18.87,124.7 17.8,125.42 16.54,125.67 15.27,125.42 14.2,124.7 13.48,123.63 13.23,122.36 13.48,121.1 14.2,120.02 15.27,119.31 16.54,119.06 17.8,119.31 18.87,120.02 19.59,121.1 19.84,122.36 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="59.53,122.36 59.28,123.63 58.56,124.7 57.49,125.42 56.22,125.67 54.95,125.42 53.88,124.7 53.17,123.63 52.91,122.36 53.17,121.1 53.88,120.02 54.95,119.31 56.22,119.06 57.49,119.31 58.56,120.02 59.28,121.1 59.53,122.36 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="19.84,128.98 19.59,130.24 18.87,131.31 17.8,132.03 16.54,132.28 15.27,132.03 14.2,131.31 13.48,130.24 13.23,128.98 13.48,127.71 14.2,126.64 15.27,125.92 16.54,125.67 17.8,125.92 18.87,126.64 19.59,127.71 19.84,128.98 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="59.53,128.98 59.28,130.24 58.56,131.31 57.49,132.03 56.22,132.28 54.95,132.03 53.88,131.31 53.17,130.24 52.91,128.98 53.17,127.71 53.88,126.64 54.95,125.92 56.22,125.67 57.49,125.92 58.56,126.64 59.28,127.71 59.53,128.98 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="19.84,135.59 19.59,136.86 18.87,137.93 17.8,138.65 16.54,138.9 15.27,138.65 14.2,137.93 13.48,136.86 13.23,135.59 13.48,134.32 14.2,133.25 15.27,132.54 16.54,132.28 17.8,132.54 18.87,133.25 19.59,134.32 19.84,135.59 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="59.53,135.59 59.28,136.86 58.56,137.93 57.49,138.65 56.22,138.9 54.95,138.65 53.88,137.93 53.17,136.86 52.91,135.59 53.17,134.32 53.88,133.25 54.95,132.54 56.22,132.28 57.49,132.54 58.56,133.25 59.28,134.32 59.53,135.59 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="19.84,142.2 19.59,143.47 18.87,144.54 17.8,145.26 16.54,145.51 15.27,145.26 14.2,144.54 13.48,143.47 13.23,142.2 13.48,140.94 14.2,139.87 15.27,139.15 16.54,138.9 17.8,139.15 18.87,139.87 19.59,140.94 19.84,142.2 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="59.53,142.2 59.28,143.47 58.56,144.54 57.49,145.26 56.22,145.51 54.95,145.26 53.88,144.54 53.17,143.47 52.91,142.2 53.17,140.94 53.88,139.87 54.95,139.15 56.22,138.9 57.49,139.15 58.56,139.87 59.28,140.94 59.53,142.2 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="112.44,16.54 112.19,17.8 111.47,18.87 110.4,19.59 109.13,19.84 107.87,19.59 106.8,18.87 106.08,17.8 105.83,16.54 106.08,15.27 106.8,14.2 107.87,13.48 109.13,13.23 110.4,13.48 111.47,14.2 112.19,15.27 112.44,16.54 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="112.44,56.22 112.19,57.49 111.47,58.56 110.4,59.28 109.13,59.53 107.87,59.28 106.8,58.56 106.08,57.49 105.83,56.22 106.08,54.95 106.8,53.88 107.87,53.17 109.13,52.91 110.4,53.17 111.47,53.88 112.19,54.95 112.44,56.22 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="119.06,16.54 118.8,17.8 118.09,18.87 117.01,19.59 115.75,19.84 114.48,19.59 113.41,18.87 112.69,17.8 112.44,16.54 112.69,15.27 113.41,14.2 114.48,13.48 115.75,13.23 117.01,13.48 118.09,14.2 118.8,15.27 119.06,16.54 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="119.06,56.22 118.8,57.49 118.09,58.56 117.01,59.28 115.75,59.53 114.48,59.28 113.41,58.56 112.69,57.49 112.44,56.22 112.69,54.95 113.41,53.88 114.48,53.17 115.75,52.91 117.01,53.17 118.09,53.88 118.8,54.95 119.06,56.22 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="125.67,16.54 125.42,17.8 124.7,18.87 123.63,19.59 122.36,19.84 121.1,19.59 120.02,18.87 119.31,17.8 119.06,16.54 119.31,15.27 120.02,14.2 121.1,13.48 122.36,13.23 123.63,13.48 124.7,14.2 125.42,15.27 125.67,16.54 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="125.67,56.22 125.42,57.49 124.7,58.56 123.63,59.28 122.36,59.53 121.1,59.28 120.02,58.56 119.31,57.49 119.06,56.22 119.31,54.95 120.02,53.88 121.1,53.17 122.36,52.91 123.63,53.17 124.7,53.88 125.42,54.95 125.67,56.22 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="132.28,16.54 132.03,17.8 131.31,18.87 130.24,19.59 128.98,19.84 127.71,19.59 126.64,18.87 125.92,17.8 125.67,16.54 125.92,15.27 126.64,14.2 127.71,13.48 128.98,13.23 130.24,13.48 131.31,14.2 132.03,15.27 132.28,16.54 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="132.28,56.22 132.03,57.49 131.31,58.56 130.24,59.28 128.98,59.53 127.71,59.28 126.64,58.56 125.92,57.49 125.67,56.22 125.92,54.95 126.64,53.88 127.71,53.17 128.98,52.91 130.24,53.17 131.31,53.88 132.03,54.95 132.28,56.22 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="138.9,16.54 138.65,17.8 137.93,18.87 136.86,19.59 135.59,19.84 134.32,19.59 133.25,18.87 132.54,17.8 132.28,16.54 132.54,15.27 133.25,14.2 134.32,13.48 135.59,13.23 136.86,13.48 137.93,14.2 138.65,15.27 138.9,16.54 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="138.9,56.22 138.65,57.49 137.93,58.56 136.86,59.28 135.59,59.53 134.32,59.28 133.25,58.56 132.54,57.49 132.28,56.22 132.54,54.95 133.25,53.88 134.32,53.17 135.59,52.91 136.86,53.17 137.93,53.88 138.65,54.95 138.9,56.22 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="145.51,16.54 145.26,17.8 144.54,18.87 143.47,19.59 142.2,19.84 140.94,19.59 139.87,18.87 139.15,17.8 138.9,16.54 139.15,15.27 139.87,14.2 140.94,13.48 142.2,13.23 143.47,13.48 144.54,14.2 145.26,15.27 145.51,16.54 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="145.51,56.22 145.26,57.49 144.54,58.56 143.47,59.28 142.2,59.53 140.94,59.28 139.87,58.56 139.15,57.49 138.9,56.22 139.15,54.95 139.87,53.88 140.94,53.17 142.2,52.91 143.47,53.17 144.54,53.88 145.26,54.95 145.51,56.22 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="152.13,16.54 151.87,17.8 151.16,18.87 150.08,19.59 148.82,19.84 147.55,19.59 146.48,18.87 145.76,17.8 145.51,16.54 145.76,15.27 146.48,14.2 147.55,13.48 148.82,13.23 150.08,13.48 151.16,14.2 151.87,15.27 152.13,16.54 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="152.13,56.22 151.87,57.49 151.16,58.56 150.08,59.28 148.82,59.53 147.55,59.28 146.48,58.56 145.76,57.49 145.51,56.22 145.76,54.95 146.48,53.88 147.55,53.17 148.82,52.91 150.08,53.17 151.16,53.88 151.87,54.95 152.13,56.22 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="112.44,23.15 112.19,24.42 111.47,25.49 110.4,26.2 109.13,26.46 107.87,26.2 106.8,25.49 106.08,24.42 105.83,23.15 106.08,21.88 106.8,20.81 107.87,20.09 109.13,19.84 110.4,20.09 111.47,20.81 112.19,21.88 112.44,23.15 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="152.13,23.15 151.87,24.42 151.16,25.49 150.08,26.2 148.82,26.46 147.55,26.2 146.48,25.49 145.76,24.42 145.51,23.15 145.76,21.88 146.48,20.81 147.55,20.09 148.82,19.84 150.08,20.09 151.16,20.81 151.87,21.88 152.13,23.15 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="112.44,29.76 112.19,31.03 111.47,32.1 110.4,32.82 109.13,33.07 107.87,32.82 106.8,32.1 106.08,31.03 105.83,29.76 106.08,28.5 106.8,27.43 107.87,26.71 109.13,26.46 110.4,26.71 111.47,27.43 112.19,28.5 112.44,29.76 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="152.13,29.76 151.87,31.03 151.16,32.1 150.08,32.82 148.82,33.07 147.55,32.82 146.48,32.1 145.76,31.03 145.51,29.76 145.76,28.5 146.48,27.43 147.55,26.71 148.82,26.46 150.08,26.71 151.16,27.43 151.87,28.5 152.13,29.76 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="112.44,36.38 112.19,37.64 111.47,38.72 110.4,39.43 109.13,39.69 107.87,39.43 106.8,38.72 106.08,37.64 105.83,36.38 106.08,35.11 106.8,34.04 107.87,33.32 109.13,33.07 110.4,33.32 111.47,34.04 112.19,35.11 112.44,36.38 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="152.13,36.38 151.87,37.64 151.16,38.72 150.08,39.43 148.82,39.69 147.55,39.43 146.48,38.72 145.76,37.64 145.51,36.38 145.76,35.11 146.48,34.04 147.55,33.32 148.82,33.07 150.08,33.32 151.16,34.04 151.87,35.11 152.13,36.38 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="112.44,42.99 112.19,44.26 111.47,45.33 110.4,46.05 109.13,46.3 107.87,46.05 106.8,45.33 106.08,44.26 105.83,42.99 106.08,41.73 106.8,40.65 107.87,39.94 109.13,39.69 110.4,39.94 111.47,40.65 112.19,41.73 112.44,42.99 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="152.13,42.99 151.87,44.26 151.16,45.33 150.08,46.05 148.82,46.3 147.55,46.05 146.48,45.33 145.76,44.26 145.51,42.99 145.76,41.73 146.48,40.65 147.55,39.94 148.82,39.69 150.08,39.94 151.16,40.65 151.87,41.73 152.13,42.99 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="112.44,49.61 112.19,50.87 111.47,51.94 110.4,52.66 109.13,52.91 107.87,52.66 106.8,51.94 106.08,50.87 105.83,49.61 106.08,48.34 106.8,47.27 107.87,46.55 109.13,46.3 110.4,46.55 111.47,47.27 112.19,48.34 112.44,49.61 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <polygon
            points="152.13,49.61 151.87,50.87 151.16,51.94 150.08,52.66 148.82,52.91 147.55,52.66 146.48,51.94 145.76,50.87 145.51,49.61 145.76,48.34 146.48,47.27 147.55,46.55 148.82,46.3 150.08,46.55 151.16,47.27 151.87,48.34 152.13,49.61 "
            style="fill:url(#hatch83f34b8d7c854d8ca48088966a8ce8fa);"
          />
          <linearGradient
            id="gradient0fffa2ee11214e519944c5c7756592ab"
            gradientUnits="userSpaceOnUse"
            x1="23.1471699955989"
            y1="78.5144232839259"
            x2="142.207158159919"
            y2="86.8399086862889"
          >
            <stop offset="0%" stop-color="#B2A1C7" />
            <stop offset="100%" stop-color="#FFFFFF" />
          </linearGradient>
          <polygon
            points="26.79,29.43 27.01,28.29 27.66,27.33 28.62,26.68 29.76,26.46 30.9,26.68 31.87,27.33 32.51,28.29 32.74,29.43 32.74,43.32 32.51,44.46 31.87,45.43 30.9,46.07 29.76,46.3 28.62,46.07 27.66,45.43 27.01,44.46 26.79,43.32 "
            style="fill:url(#gradient0fffa2ee11214e519944c5c7756592ab);"
          />
          <polygon
            points="33.4,29.43 33.63,28.29 34.27,27.33 35.24,26.68 36.38,26.46 37.52,26.68 38.48,27.33 39.13,28.29 39.35,29.43 39.35,43.32 39.13,44.46 38.48,45.43 37.52,46.07 36.38,46.3 35.24,46.07 34.27,45.43 33.63,44.46 33.4,43.32 "
            style="fill:url(#gradient0fffa2ee11214e519944c5c7756592ab);"
          />
          <polygon
            points="40.02,29.43 40.24,28.29 40.89,27.33 41.85,26.68 42.99,26.46 44.13,26.68 45.1,27.33 45.74,28.29 45.97,29.43 45.97,43.32 45.74,44.46 45.1,45.43 44.13,46.07 42.99,46.3 41.85,46.07 40.89,45.43 40.24,44.46 40.02,43.32 "
            style="fill:url(#gradient0fffa2ee11214e519944c5c7756592ab);"
          />
          <polygon
            points="26.79,122.03 27.01,120.89 27.66,119.93 28.62,119.28 29.76,119.06 30.9,119.28 31.87,119.93 32.51,120.89 32.74,122.03 32.74,135.92 32.51,137.06 31.87,138.03 30.9,138.67 29.76,138.9 28.62,138.67 27.66,138.03 27.01,137.06 26.79,135.92 "
            style="fill:url(#gradient0fffa2ee11214e519944c5c7756592ab);"
          />
          <polygon
            points="33.4,122.03 33.63,120.89 34.27,119.93 35.24,119.28 36.38,119.06 37.52,119.28 38.48,119.93 39.13,120.89 39.35,122.03 39.35,135.92 39.13,137.06 38.48,138.03 37.52,138.67 36.38,138.9 35.24,138.67 34.27,138.03 33.63,137.06 33.4,135.92 "
            style="fill:url(#gradient0fffa2ee11214e519944c5c7756592ab);"
          />
          <polygon
            points="40.02,122.03 40.24,120.89 40.89,119.93 41.85,119.28 42.99,119.06 44.13,119.28 45.1,119.93 45.74,120.89 45.97,122.03 45.97,135.92 45.74,137.06 45.1,138.03 44.13,138.67 42.99,138.9 41.85,138.67 40.89,138.03 40.24,137.06 40.02,135.92 "
            style="fill:url(#gradient0fffa2ee11214e519944c5c7756592ab);"
          />
          <polygon
            points="119.39,29.43 119.61,28.29 120.26,27.33 121.22,26.68 122.36,26.46 123.5,26.68 124.47,27.33 125.11,28.29 125.34,29.43 125.34,43.32 125.11,44.46 124.47,45.43 123.5,46.07 122.36,46.3 121.22,46.07 120.26,45.43 119.61,44.46 119.39,43.32 "
            style="fill:url(#gradient0fffa2ee11214e519944c5c7756592ab);"
          />
          <polygon
            points="126,29.43 126.23,28.29 126.87,27.33 127.84,26.68 128.98,26.46 130.12,26.68 131.08,27.33 131.73,28.29 131.95,29.43 131.95,43.32 131.73,44.46 131.08,45.43 130.12,46.07 128.98,46.3 127.84,46.07 126.87,45.43 126.23,44.46 126,43.32 "
            style="fill:url(#gradient0fffa2ee11214e519944c5c7756592ab);"
          />
          <polygon
            points="132.61,29.43 132.84,28.29 133.49,27.33 134.45,26.68 135.59,26.46 136.73,26.68 137.7,27.33 138.34,28.29 138.57,29.43 138.57,43.32 138.34,44.46 137.7,45.43 136.73,46.07 135.59,46.3 134.45,46.07 133.49,45.43 132.84,44.46 132.61,43.32 "
            style="fill:url(#gradient0fffa2ee11214e519944c5c7756592ab);"
          />
          <linearGradient
            id="gradient6a46f7652d584c37a6ba75a90d08d89b"
            gradientUnits="userSpaceOnUse"
            x1="10.4830545936657"
            y1="78.893629314992"
            x2="154.871269747155"
            y2="86.4606950258283"
          >
            <stop offset="0%" stop-color="#00E278" />
            <stop offset="50%" stop-color="#FFFF00" />
            <stop offset="100%" stop-color="#00E278" />
          </linearGradient>
          <polygon
            points="16.54,72.09 15.52,71.89 14.66,71.32 14.09,70.46 13.89,69.45 14.09,68.44 14.66,67.58 15.52,67 16.54,66.8 42.99,66.8 44,67 44.86,67.58 45.44,68.44 45.64,69.45 45.44,70.46 44.86,71.32 44,71.89 42.99,72.09 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="56.22,72.09 55.21,71.89 54.35,71.32 53.78,70.46 53.57,69.45 53.78,68.44 54.35,67.58 55.21,67 56.22,66.8 69.45,66.8 70.46,67 71.32,67.58 71.89,68.44 72.09,69.45 71.89,70.46 71.32,71.32 70.46,71.89 69.45,72.09 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="102.52,72.09 101.51,71.89 100.65,71.32 100.08,70.46 99.87,69.45 100.08,68.44 100.65,67.58 101.51,67 102.52,66.8 102.52,66.8 103.53,67 104.39,67.58 104.96,68.44 105.17,69.45 104.96,70.46 104.39,71.32 103.53,71.89 102.52,72.09 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="115.75,72.09 114.74,71.89 113.88,71.32 113.3,70.46 113.1,69.45 113.3,68.44 113.88,67.58 114.74,67 115.75,66.8 115.75,66.8 116.76,67 117.62,67.58 118.19,68.44 118.39,69.45 118.19,70.46 117.62,71.32 116.76,71.89 115.75,72.09 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="128.98,72.09 127.96,71.89 127.11,71.32 126.53,70.46 126.33,69.45 126.53,68.44 127.11,67.58 127.96,67 128.98,66.8 128.98,66.8 129.99,67 130.85,67.58 131.42,68.44 131.62,69.45 131.42,70.46 130.85,71.32 129.99,71.89 128.98,72.09 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="142.2,72.09 141.19,71.89 140.33,71.32 139.76,70.46 139.56,69.45 139.76,68.44 140.33,67.58 141.19,67 142.2,66.8 142.2,66.8 143.22,67 144.08,67.58 144.65,68.44 144.85,69.45 144.65,70.46 144.08,71.32 143.22,71.89 142.2,72.09 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="16.54,78.71 15.52,78.51 14.66,77.93 14.09,77.08 13.89,76.06 14.09,75.05 14.66,74.19 15.52,73.62 16.54,73.42 29.76,73.42 30.78,73.62 31.63,74.19 32.21,75.05 32.41,76.06 32.21,77.08 31.63,77.93 30.78,78.51 29.76,78.71 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="49.61,78.71 48.59,78.51 47.74,77.93 47.16,77.08 46.96,76.06 47.16,75.05 47.74,74.19 48.59,73.62 49.61,73.42 49.61,73.42 50.62,73.62 51.48,74.19 52.05,75.05 52.25,76.06 52.05,77.08 51.48,77.93 50.62,78.51 49.61,78.71 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="62.83,78.71 61.82,78.51 60.96,77.93 60.39,77.08 60.19,76.06 60.39,75.05 60.96,74.19 61.82,73.62 62.83,73.42 62.83,73.42 63.85,73.62 64.71,74.19 65.28,75.05 65.48,76.06 65.28,77.08 64.71,77.93 63.85,78.51 62.83,78.71 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="76.06,78.71 75.05,78.51 74.19,77.93 73.62,77.08 73.42,76.06 73.62,75.05 74.19,74.19 75.05,73.62 76.06,73.42 76.06,73.42 77.08,73.62 77.93,74.19 78.51,75.05 78.71,76.06 78.51,77.08 77.93,77.93 77.08,78.51 76.06,78.71 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="89.29,78.71 88.28,78.51 87.42,77.93 86.85,77.08 86.65,76.06 86.85,75.05 87.42,74.19 88.28,73.62 89.29,73.42 109.13,73.42 110.15,73.62 111,74.19 111.58,75.05 111.78,76.06 111.58,77.08 111,77.93 110.15,78.51 109.13,78.71 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="128.98,78.71 127.96,78.51 127.11,77.93 126.53,77.08 126.33,76.06 126.53,75.05 127.11,74.19 127.96,73.62 128.98,73.42 148.82,73.42 149.83,73.62 150.69,74.19 151.26,75.05 151.46,76.06 151.26,77.08 150.69,77.93 149.83,78.51 148.82,78.71 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="29.76,85.32 28.75,85.12 27.89,84.55 27.32,83.69 27.12,82.68 27.32,81.66 27.89,80.81 28.75,80.23 29.76,80.03 29.76,80.03 30.78,80.23 31.63,80.81 32.21,81.66 32.41,82.68 32.21,83.69 31.63,84.55 30.78,85.12 29.76,85.32 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="42.99,85.32 41.98,85.12 41.12,84.55 40.55,83.69 40.35,82.68 40.55,81.66 41.12,80.81 41.98,80.23 42.99,80.03 56.22,80.03 57.23,80.23 58.09,80.81 58.66,81.66 58.87,82.68 58.66,83.69 58.09,84.55 57.23,85.12 56.22,85.32 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="69.45,85.32 68.44,85.12 67.58,84.55 67,83.69 66.8,82.68 67,81.66 67.58,80.81 68.44,80.23 69.45,80.03 76.06,80.03 77.08,80.23 77.93,80.81 78.51,81.66 78.71,82.68 78.51,83.69 77.93,84.55 77.08,85.12 76.06,85.32 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="95.91,85.32 94.89,85.12 94.03,84.55 93.46,83.69 93.26,82.68 93.46,81.66 94.03,80.81 94.89,80.23 95.91,80.03 95.91,80.03 96.92,80.23 97.78,80.81 98.35,81.66 98.55,82.68 98.35,83.69 97.78,84.55 96.92,85.12 95.91,85.32 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="109.13,85.32 108.12,85.12 107.26,84.55 106.69,83.69 106.49,82.68 106.69,81.66 107.26,80.81 108.12,80.23 109.13,80.03 115.75,80.03 116.76,80.23 117.62,80.81 118.19,81.66 118.39,82.68 118.19,83.69 117.62,84.55 116.76,85.12 115.75,85.32 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="128.98,85.32 127.96,85.12 127.11,84.55 126.53,83.69 126.33,82.68 126.53,81.66 127.11,80.81 127.96,80.23 128.98,80.03 128.98,80.03 129.99,80.23 130.85,80.81 131.42,81.66 131.62,82.68 131.42,83.69 130.85,84.55 129.99,85.12 128.98,85.32 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="148.82,85.32 147.81,85.12 146.95,84.55 146.37,83.69 146.17,82.68 146.37,81.66 146.95,80.81 147.81,80.23 148.82,80.03 148.82,80.03 149.83,80.23 150.69,80.81 151.26,81.66 151.46,82.68 151.26,83.69 150.69,84.55 149.83,85.12 148.82,85.32 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="16.54,91.94 15.52,91.74 14.66,91.16 14.09,90.3 13.89,89.29 14.09,88.28 14.66,87.42 15.52,86.85 16.54,86.65 16.54,86.65 17.55,86.85 18.41,87.42 18.98,88.28 19.18,89.29 18.98,90.3 18.41,91.16 17.55,91.74 16.54,91.94 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="36.38,91.94 35.37,91.74 34.51,91.16 33.93,90.3 33.73,89.29 33.93,88.28 34.51,87.42 35.37,86.85 36.38,86.65 36.38,86.65 37.39,86.85 38.25,87.42 38.82,88.28 39.02,89.29 38.82,90.3 38.25,91.16 37.39,91.74 36.38,91.94 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="89.29,91.94 88.28,91.74 87.42,91.16 86.85,90.3 86.65,89.29 86.85,88.28 87.42,87.42 88.28,86.85 89.29,86.65 109.13,86.65 110.15,86.85 111,87.42 111.58,88.28 111.78,89.29 111.58,90.3 111,91.16 110.15,91.74 109.13,91.94 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="135.59,91.94 134.58,91.74 133.72,91.16 133.15,90.3 132.94,89.29 133.15,88.28 133.72,87.42 134.58,86.85 135.59,86.65 148.82,86.65 149.83,86.85 150.69,87.42 151.26,88.28 151.46,89.29 151.26,90.3 150.69,91.16 149.83,91.74 148.82,91.94 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="23.15,98.55 22.14,98.35 21.28,97.78 20.71,96.92 20.5,95.91 20.71,94.89 21.28,94.03 22.14,93.46 23.15,93.26 23.15,93.26 24.16,93.46 25.02,94.03 25.59,94.89 25.8,95.91 25.59,96.92 25.02,97.78 24.16,98.35 23.15,98.55 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="36.38,98.55 35.37,98.35 34.51,97.78 33.93,96.92 33.73,95.91 33.93,94.89 34.51,94.03 35.37,93.46 36.38,93.26 42.99,93.26 44,93.46 44.86,94.03 45.44,94.89 45.64,95.91 45.44,96.92 44.86,97.78 44,98.35 42.99,98.55 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="56.22,98.55 55.21,98.35 54.35,97.78 53.78,96.92 53.57,95.91 53.78,94.89 54.35,94.03 55.21,93.46 56.22,93.26 56.22,93.26 57.23,93.46 58.09,94.03 58.66,94.89 58.87,95.91 58.66,96.92 58.09,97.78 57.23,98.35 56.22,98.55 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="69.45,98.55 68.44,98.35 67.58,97.78 67,96.92 66.8,95.91 67,94.89 67.58,94.03 68.44,93.46 69.45,93.26 69.45,93.26 70.46,93.46 71.32,94.03 71.89,94.89 72.09,95.91 71.89,96.92 71.32,97.78 70.46,98.35 69.45,98.55 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="95.91,98.55 94.89,98.35 94.03,97.78 93.46,96.92 93.26,95.91 93.46,94.89 94.03,94.03 94.89,93.46 95.91,93.26 95.91,93.26 96.92,93.46 97.78,94.03 98.35,94.89 98.55,95.91 98.35,96.92 97.78,97.78 96.92,98.35 95.91,98.55 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="115.75,98.55 114.74,98.35 113.88,97.78 113.3,96.92 113.1,95.91 113.3,94.89 113.88,94.03 114.74,93.46 115.75,93.26 115.75,93.26 116.76,93.46 117.62,94.03 118.19,94.89 118.39,95.91 118.19,96.92 117.62,97.78 116.76,98.35 115.75,98.55 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="142.2,98.55 141.19,98.35 140.33,97.78 139.76,96.92 139.56,95.91 139.76,94.89 140.33,94.03 141.19,93.46 142.2,93.26 142.2,93.26 143.22,93.46 144.08,94.03 144.65,94.89 144.85,95.91 144.65,96.92 144.08,97.78 143.22,98.35 142.2,98.55 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="115.75,105.17 114.74,104.96 113.88,104.39 113.3,103.53 113.1,102.52 113.3,101.51 113.88,100.65 114.74,100.08 115.75,99.87 115.75,99.87 116.76,100.08 117.62,100.65 118.19,101.51 118.39,102.52 118.19,103.53 117.62,104.39 116.76,104.96 115.75,105.17 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="135.59,105.17 134.58,104.96 133.72,104.39 133.15,103.53 132.94,102.52 133.15,101.51 133.72,100.65 134.58,100.08 135.59,99.87 135.59,99.87 136.6,100.08 137.46,100.65 138.03,101.51 138.24,102.52 138.03,103.53 137.46,104.39 136.6,104.96 135.59,105.17 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="122.36,111.78 121.35,111.58 120.49,111 119.92,110.15 119.72,109.13 119.92,108.12 120.49,107.26 121.35,106.69 122.36,106.49 128.98,106.49 129.99,106.69 130.85,107.26 131.42,108.12 131.62,109.13 131.42,110.15 130.85,111 129.99,111.58 128.98,111.78 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="142.2,111.78 141.19,111.58 140.33,111 139.76,110.15 139.56,109.13 139.76,108.12 140.33,107.26 141.19,106.69 142.2,106.49 148.82,106.49 149.83,106.69 150.69,107.26 151.26,108.12 151.46,109.13 151.26,110.15 150.69,111 149.83,111.58 148.82,111.78 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="115.75,118.39 114.74,118.19 113.88,117.62 113.3,116.76 113.1,115.75 113.3,114.74 113.88,113.88 114.74,113.3 115.75,113.1 122.36,113.1 123.37,113.3 124.23,113.88 124.81,114.74 125.01,115.75 124.81,116.76 124.23,117.62 123.37,118.19 122.36,118.39 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="135.59,118.39 134.58,118.19 133.72,117.62 133.15,116.76 132.94,115.75 133.15,114.74 133.72,113.88 134.58,113.3 135.59,113.1 135.59,113.1 136.6,113.3 137.46,113.88 138.03,114.74 138.24,115.75 138.03,116.76 137.46,117.62 136.6,118.19 135.59,118.39 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="148.82,118.39 147.81,118.19 146.95,117.62 146.37,116.76 146.17,115.75 146.37,114.74 146.95,113.88 147.81,113.3 148.82,113.1 148.82,113.1 149.83,113.3 150.69,113.88 151.26,114.74 151.46,115.75 151.26,116.76 150.69,117.62 149.83,118.19 148.82,118.39 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="122.36,125.01 121.35,124.81 120.49,124.23 119.92,123.37 119.72,122.36 119.92,121.35 120.49,120.49 121.35,119.92 122.36,119.72 135.59,119.72 136.6,119.92 137.46,120.49 138.03,121.35 138.24,122.36 138.03,123.37 137.46,124.23 136.6,124.81 135.59,125.01 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="128.98,131.62 127.96,131.42 127.11,130.85 126.53,129.99 126.33,128.98 126.53,127.96 127.11,127.11 127.96,126.53 128.98,126.33 135.59,126.33 136.6,126.53 137.46,127.11 138.03,127.96 138.24,128.98 138.03,129.99 137.46,130.85 136.6,131.42 135.59,131.62 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="135.59,138.24 134.58,138.03 133.72,137.46 133.15,136.6 132.94,135.59 133.15,134.58 133.72,133.72 134.58,133.15 135.59,132.94 135.59,132.94 136.6,133.15 137.46,133.72 138.03,134.58 138.24,135.59 138.03,136.6 137.46,137.46 136.6,138.03 135.59,138.24 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="142.2,144.85 141.19,144.65 140.33,144.08 139.76,143.22 139.56,142.2 139.76,141.19 140.33,140.33 141.19,139.76 142.2,139.56 142.2,139.56 143.22,139.76 144.08,140.33 144.65,141.19 144.85,142.2 144.65,143.22 144.08,144.08 143.22,144.65 142.2,144.85 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="66.8,23.15 67,22.14 67.58,21.28 68.44,20.71 69.45,20.5 70.46,20.71 71.32,21.28 71.89,22.14 72.09,23.15 72.09,23.15 71.89,24.16 71.32,25.02 70.46,25.59 69.45,25.8 68.44,25.59 67.58,25.02 67,24.16 66.8,23.15 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="66.8,36.38 67,35.37 67.58,34.51 68.44,33.93 69.45,33.73 70.46,33.93 71.32,34.51 71.89,35.37 72.09,36.38 72.09,36.38 71.89,37.39 71.32,38.25 70.46,38.82 69.45,39.02 68.44,38.82 67.58,38.25 67,37.39 66.8,36.38 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="66.8,49.61 67,48.59 67.58,47.74 68.44,47.16 69.45,46.96 70.46,47.16 71.32,47.74 71.89,48.59 72.09,49.61 72.09,56.22 71.89,57.23 71.32,58.09 70.46,58.66 69.45,58.87 68.44,58.66 67.58,58.09 67,57.23 66.8,56.22 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="66.8,95.91 67,94.89 67.58,94.03 68.44,93.46 69.45,93.26 70.46,93.46 71.32,94.03 71.89,94.89 72.09,95.91 72.09,109.13 71.89,110.15 71.32,111 70.46,111.58 69.45,111.78 68.44,111.58 67.58,111 67,110.15 66.8,109.13 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="66.8,122.36 67,121.35 67.58,120.49 68.44,119.92 69.45,119.72 70.46,119.92 71.32,120.49 71.89,121.35 72.09,122.36 72.09,148.82 71.89,149.83 71.32,150.69 70.46,151.26 69.45,151.46 68.44,151.26 67.58,150.69 67,149.83 66.8,148.82 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="73.42,23.15 73.62,22.14 74.19,21.28 75.05,20.71 76.06,20.5 77.08,20.71 77.93,21.28 78.51,22.14 78.71,23.15 78.71,23.15 78.51,24.16 77.93,25.02 77.08,25.59 76.06,25.8 75.05,25.59 74.19,25.02 73.62,24.16 73.42,23.15 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="73.42,36.38 73.62,35.37 74.19,34.51 75.05,33.93 76.06,33.73 77.08,33.93 77.93,34.51 78.51,35.37 78.71,36.38 78.71,42.99 78.51,44 77.93,44.86 77.08,45.44 76.06,45.64 75.05,45.44 74.19,44.86 73.62,44 73.42,42.99 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="73.42,62.83 73.62,61.82 74.19,60.96 75.05,60.39 76.06,60.19 77.08,60.39 77.93,60.96 78.51,61.82 78.71,62.83 78.71,62.83 78.51,63.85 77.93,64.71 77.08,65.28 76.06,65.48 75.05,65.28 74.19,64.71 73.62,63.85 73.42,62.83 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="73.42,95.91 73.62,94.89 74.19,94.03 75.05,93.46 76.06,93.26 77.08,93.46 77.93,94.03 78.51,94.89 78.71,95.91 78.71,95.91 78.51,96.92 77.93,97.78 77.08,98.35 76.06,98.55 75.05,98.35 74.19,97.78 73.62,96.92 73.42,95.91 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="73.42,115.75 73.62,114.74 74.19,113.88 75.05,113.3 76.06,113.1 77.08,113.3 77.93,113.88 78.51,114.74 78.71,115.75 78.71,135.59 78.51,136.6 77.93,137.46 77.08,138.03 76.06,138.24 75.05,138.03 74.19,137.46 73.62,136.6 73.42,135.59 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="73.42,148.82 73.62,147.81 74.19,146.95 75.05,146.37 76.06,146.17 77.08,146.37 77.93,146.95 78.51,147.81 78.71,148.82 78.71,148.82 78.51,149.83 77.93,150.69 77.08,151.26 76.06,151.46 75.05,151.26 74.19,150.69 73.62,149.83 73.42,148.82 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="80.03,16.54 80.23,15.52 80.81,14.66 81.66,14.09 82.68,13.89 83.69,14.09 84.55,14.66 85.12,15.52 85.32,16.54 85.32,29.76 85.12,30.78 84.55,31.63 83.69,32.21 82.68,32.41 81.66,32.21 80.81,31.63 80.23,30.78 80.03,29.76 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="80.03,56.22 80.23,55.21 80.81,54.35 81.66,53.78 82.68,53.57 83.69,53.78 84.55,54.35 85.12,55.21 85.32,56.22 85.32,56.22 85.12,57.23 84.55,58.09 83.69,58.66 82.68,58.87 81.66,58.66 80.81,58.09 80.23,57.23 80.03,56.22 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="80.03,102.52 80.23,101.51 80.81,100.65 81.66,100.08 82.68,99.87 83.69,100.08 84.55,100.65 85.12,101.51 85.32,102.52 85.32,102.52 85.12,103.53 84.55,104.39 83.69,104.96 82.68,105.17 81.66,104.96 80.81,104.39 80.23,103.53 80.03,102.52 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="80.03,115.75 80.23,114.74 80.81,113.88 81.66,113.3 82.68,113.1 83.69,113.3 84.55,113.88 85.12,114.74 85.32,115.75 85.32,122.36 85.12,123.37 84.55,124.23 83.69,124.81 82.68,125.01 81.66,124.81 80.81,124.23 80.23,123.37 80.03,122.36 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="80.03,142.2 80.23,141.19 80.81,140.33 81.66,139.76 82.68,139.56 83.69,139.76 84.55,140.33 85.12,141.19 85.32,142.2 85.32,148.82 85.12,149.83 84.55,150.69 83.69,151.26 82.68,151.46 81.66,151.26 80.81,150.69 80.23,149.83 80.03,148.82 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="86.65,16.54 86.85,15.52 87.42,14.66 88.28,14.09 89.29,13.89 90.3,14.09 91.16,14.66 91.74,15.52 91.94,16.54 91.94,16.54 91.74,17.55 91.16,18.41 90.3,18.98 89.29,19.18 88.28,18.98 87.42,18.41 86.85,17.55 86.65,16.54 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="86.65,29.76 86.85,28.75 87.42,27.89 88.28,27.32 89.29,27.12 90.3,27.32 91.16,27.89 91.74,28.75 91.94,29.76 91.94,29.76 91.74,30.78 91.16,31.63 90.3,32.21 89.29,32.41 88.28,32.21 87.42,31.63 86.85,30.78 86.65,29.76 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="86.65,49.61 86.85,48.59 87.42,47.74 88.28,47.16 89.29,46.96 90.3,47.16 91.16,47.74 91.74,48.59 91.94,49.61 91.94,49.61 91.74,50.62 91.16,51.48 90.3,52.05 89.29,52.25 88.28,52.05 87.42,51.48 86.85,50.62 86.65,49.61 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="86.65,69.45 86.85,68.44 87.42,67.58 88.28,67 89.29,66.8 90.3,67 91.16,67.58 91.74,68.44 91.94,69.45 91.94,69.45 91.74,70.46 91.16,71.32 90.3,71.89 89.29,72.09 88.28,71.89 87.42,71.32 86.85,70.46 86.65,69.45 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="86.65,89.29 86.85,88.28 87.42,87.42 88.28,86.85 89.29,86.65 90.3,86.85 91.16,87.42 91.74,88.28 91.94,89.29 91.94,89.29 91.74,90.3 91.16,91.16 90.3,91.74 89.29,91.94 88.28,91.74 87.42,91.16 86.85,90.3 86.65,89.29 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="86.65,109.13 86.85,108.12 87.42,107.26 88.28,106.69 89.29,106.49 90.3,106.69 91.16,107.26 91.74,108.12 91.94,109.13 91.94,109.13 91.74,110.15 91.16,111 90.3,111.58 89.29,111.78 88.28,111.58 87.42,111 86.85,110.15 86.65,109.13 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="86.65,122.36 86.85,121.35 87.42,120.49 88.28,119.92 89.29,119.72 90.3,119.92 91.16,120.49 91.74,121.35 91.94,122.36 91.94,128.98 91.74,129.99 91.16,130.85 90.3,131.42 89.29,131.62 88.28,131.42 87.42,130.85 86.85,129.99 86.65,128.98 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="86.65,142.2 86.85,141.19 87.42,140.33 88.28,139.76 89.29,139.56 90.3,139.76 91.16,140.33 91.74,141.19 91.94,142.2 91.94,142.2 91.74,143.22 91.16,144.08 90.3,144.65 89.29,144.85 88.28,144.65 87.42,144.08 86.85,143.22 86.65,142.2 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="93.26,16.54 93.46,15.52 94.03,14.66 94.89,14.09 95.91,13.89 96.92,14.09 97.78,14.66 98.35,15.52 98.55,16.54 98.55,42.99 98.35,44 97.78,44.86 96.92,45.44 95.91,45.64 94.89,45.44 94.03,44.86 93.46,44 93.26,42.99 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="93.26,56.22 93.46,55.21 94.03,54.35 94.89,53.78 95.91,53.57 96.92,53.78 97.78,54.35 98.35,55.21 98.55,56.22 98.55,56.22 98.35,57.23 97.78,58.09 96.92,58.66 95.91,58.87 94.89,58.66 94.03,58.09 93.46,57.23 93.26,56.22 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="93.26,95.91 93.46,94.89 94.03,94.03 94.89,93.46 95.91,93.26 96.92,93.46 97.78,94.03 98.35,94.89 98.55,95.91 98.55,102.52 98.35,103.53 97.78,104.39 96.92,104.96 95.91,105.17 94.89,104.96 94.03,104.39 93.46,103.53 93.26,102.52 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="93.26,128.98 93.46,127.96 94.03,127.11 94.89,126.53 95.91,126.33 96.92,126.53 97.78,127.11 98.35,127.96 98.55,128.98 98.55,148.82 98.35,149.83 97.78,150.69 96.92,151.26 95.91,151.46 94.89,151.26 94.03,150.69 93.46,149.83 93.26,148.82 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="99.87,109.13 100.08,108.12 100.65,107.26 101.51,106.69 102.52,106.49 103.53,106.69 104.39,107.26 104.96,108.12 105.17,109.13 105.17,109.13 104.96,110.15 104.39,111 103.53,111.58 102.52,111.78 101.51,111.58 100.65,111 100.08,110.15 99.87,109.13 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="99.87,122.36 100.08,121.35 100.65,120.49 101.51,119.92 102.52,119.72 103.53,119.92 104.39,120.49 104.96,121.35 105.17,122.36 105.17,128.98 104.96,129.99 104.39,130.85 103.53,131.42 102.52,131.62 101.51,131.42 100.65,130.85 100.08,129.99 99.87,128.98 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="99.87,142.2 100.08,141.19 100.65,140.33 101.51,139.76 102.52,139.56 103.53,139.76 104.39,140.33 104.96,141.19 105.17,142.2 105.17,142.2 104.96,143.22 104.39,144.08 103.53,144.65 102.52,144.85 101.51,144.65 100.65,144.08 100.08,143.22 99.87,142.2 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="106.49,128.98 106.69,127.96 107.26,127.11 108.12,126.53 109.13,126.33 110.15,126.53 111,127.11 111.58,127.96 111.78,128.98 111.78,142.2 111.58,143.22 111,144.08 110.15,144.65 109.13,144.85 108.12,144.65 107.26,144.08 106.69,143.22 106.49,142.2 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="113.1,115.75 113.3,114.74 113.88,113.88 114.74,113.3 115.75,113.1 116.76,113.3 117.62,113.88 118.19,114.74 118.39,115.75 118.39,115.75 118.19,116.76 117.62,117.62 116.76,118.19 115.75,118.39 114.74,118.19 113.88,117.62 113.3,116.76 113.1,115.75 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="113.1,128.98 113.3,127.96 113.88,127.11 114.74,126.53 115.75,126.33 116.76,126.53 117.62,127.11 118.19,127.96 118.39,128.98 118.39,148.82 118.19,149.83 117.62,150.69 116.76,151.26 115.75,151.46 114.74,151.26 113.88,150.69 113.3,149.83 113.1,148.82 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="119.72,122.36 119.92,121.35 120.49,120.49 121.35,119.92 122.36,119.72 123.37,119.92 124.23,120.49 124.81,121.35 125.01,122.36 125.01,122.36 124.81,123.37 124.23,124.23 123.37,124.81 122.36,125.01 121.35,124.81 120.49,124.23 119.92,123.37 119.72,122.36 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="119.72,142.2 119.92,141.19 120.49,140.33 121.35,139.76 122.36,139.56 123.37,139.76 124.23,140.33 124.81,141.19 125.01,142.2 125.01,142.2 124.81,143.22 124.23,144.08 123.37,144.65 122.36,144.85 121.35,144.65 120.49,144.08 119.92,143.22 119.72,142.2 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="126.33,128.98 126.53,127.96 127.11,127.11 127.96,126.53 128.98,126.33 129.99,126.53 130.85,127.11 131.42,127.96 131.62,128.98 131.62,135.59 131.42,136.6 130.85,137.46 129.99,138.03 128.98,138.24 127.96,138.03 127.11,137.46 126.53,136.6 126.33,135.59 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="132.94,135.59 133.15,134.58 133.72,133.72 134.58,133.15 135.59,132.94 136.6,133.15 137.46,133.72 138.03,134.58 138.24,135.59 138.24,148.82 138.03,149.83 137.46,150.69 136.6,151.26 135.59,151.46 134.58,151.26 133.72,150.69 133.15,149.83 132.94,148.82 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
          <polygon
            points="139.56,142.2 139.76,141.19 140.33,140.33 141.19,139.76 142.2,139.56 143.22,139.76 144.08,140.33 144.65,141.19 144.85,142.2 144.85,142.2 144.65,143.22 144.08,144.08 143.22,144.65 142.2,144.85 141.19,144.65 140.33,144.08 139.76,143.22 139.56,142.2 "
            style="fill:url(#gradient6a46f7652d584c37a6ba75a90d08d89b);"
          />
      `,
            },
            {
                value: 20,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(37,86,99,1);"
            shape-rendering="crispEdges"
          />
          <linearGradient
            id="gradient3449309bbfd94eed961adfc4a828ceb6"
            gradientUnits="userSpaceOnUse"
            x1="7.72605761144101"
            y1="76.1197884622769"
            x2="157.628262914682"
            y2="89.2345320638461"
          >
            <stop offset="0%" stop-color="#FF93FB" />
            <stop offset="100%" stop-color="#FF9393" />
          </linearGradient>
          <polygon
            points="13.23,29.76 13.55,26.54 14.49,23.44 16.02,20.58 18.07,18.07 20.58,16.02 23.44,14.49 26.54,13.55 29.76,13.23 59.53,13.23 59.53,59.53 13.23,59.53 13.23,29.76 19.84,29.76 19.84,52.91 52.91,52.91 52.91,19.84 29.76,19.84 27.2,20.18 24.8,21.17 22.75,22.75 21.17,24.8 20.18,27.2 19.84,29.76 "
            style="fill:url(#gradient3449309bbfd94eed961adfc4a828ceb6);"
          />
          <polygon
            points="13.23,122.36 13.23,105.83 59.53,105.83 59.53,152.13 29.76,152.13 26.54,151.81 23.44,150.87 20.58,149.34 18.07,147.28 16.02,144.78 14.49,141.92 13.55,138.82 13.23,135.59 13.23,122.36 19.84,122.36 19.84,135.59 20.18,138.16 21.17,140.55 22.75,142.61 24.8,144.18 27.2,145.17 29.76,145.51 52.91,145.51 52.91,112.44 19.84,112.44 19.84,122.36 "
            style="fill:url(#gradient3449309bbfd94eed961adfc4a828ceb6);"
          />
          <polygon
            points="105.83,29.76 105.83,13.23 135.59,13.23 138.82,13.55 141.92,14.49 144.78,16.02 147.28,18.07 149.34,20.58 150.87,23.44 151.81,26.54 152.13,29.76 152.13,59.53 105.83,59.53 105.83,29.76 112.44,29.76 112.44,52.91 145.51,52.91 145.51,29.76 145.17,27.2 144.18,24.8 142.61,22.75 140.55,21.17 138.16,20.18 135.59,19.84 112.44,19.84 112.44,29.76 "
            style="fill:url(#gradient3449309bbfd94eed961adfc4a828ceb6);"
          />
          <pattern
            id="glass707f0bfb55ce441694040af327da98a2"
            x="26.45669"
            y="26.45669"
            width="112.4409"
            height="112.4409"
            patternUnits="userSpaceOnUse"
          >
            <rect x="0" y="0" width="112.4409" height="112.4409" style="fill:rgb(147,255,255);fill-opacity:1;" />
            <rect x="0" y="0" width="112.4409" height="56.22047" style="fill:rgb(159,255,255);fill-opacity:1;" />
          </pattern>
          <polygon
            points="46.3,36.38 46.11,38.31 45.54,40.17 44.63,41.89 43.39,43.39 41.89,44.63 40.17,45.54 38.31,46.11 36.38,46.3 34.44,46.11 32.58,45.54 30.87,44.63 29.36,43.39 28.13,41.89 27.21,40.17 26.65,38.31 26.46,36.38 26.65,34.44 27.21,32.58 28.13,30.87 29.36,29.36 30.87,28.13 32.58,27.21 34.44,26.65 36.38,26.46 38.31,26.65 40.17,27.21 41.89,28.13 43.39,29.36 44.63,30.87 45.54,32.58 46.11,34.44 46.3,36.38 "
            style="fill:url(#glass707f0bfb55ce441694040af327da98a2);"
          />
          <polygon
            points="46.3,128.98 46.11,130.91 45.54,132.77 44.63,134.49 43.39,135.99 41.89,137.23 40.17,138.14 38.31,138.71 36.38,138.9 34.44,138.71 32.58,138.14 30.87,137.23 29.36,135.99 28.13,134.49 27.21,132.77 26.65,130.91 26.46,128.98 26.65,127.04 27.21,125.18 28.13,123.46 29.36,121.96 30.87,120.73 32.58,119.81 34.44,119.25 36.38,119.06 38.31,119.25 40.17,119.81 41.89,120.73 43.39,121.96 44.63,123.46 45.54,125.18 46.11,127.04 46.3,128.98 "
            style="fill:url(#glass707f0bfb55ce441694040af327da98a2);"
          />
          <polygon
            points="138.9,36.38 138.71,38.31 138.14,40.17 137.23,41.89 135.99,43.39 134.49,44.63 132.77,45.54 130.91,46.11 128.98,46.3 127.04,46.11 125.18,45.54 123.46,44.63 121.96,43.39 120.73,41.89 119.81,40.17 119.25,38.31 119.06,36.38 119.25,34.44 119.81,32.58 120.73,30.87 121.96,29.36 123.46,28.13 125.18,27.21 127.04,26.65 128.98,26.46 130.91,26.65 132.77,27.21 134.49,28.13 135.99,29.36 137.23,30.87 138.14,32.58 138.71,34.44 138.9,36.38 "
            style="fill:url(#glass707f0bfb55ce441694040af327da98a2);"
          />
          <linearGradient
            id="gradient230bd81be3cd4d5c8b2e8d6590a4404d"
            gradientUnits="userSpaceOnUse"
            x1="13.889762878418"
            y1="82.6771621704102"
            x2="151.464561462402"
            y2="82.6771621704102"
          >
            <stop offset="0%" stop-color="#FF9393" />
            <stop offset="50%" stop-color="#DBEEF3" />
            <stop offset="100%" stop-color="#FF9393" />
          </linearGradient>
          <polygon
            points="82.68,19.18 81.66,18.98 80.81,18.41 80.23,17.55 80.03,16.54 80.23,15.52 80.81,14.66 81.66,14.09 82.68,13.89 95.91,13.89 96.92,14.09 97.78,14.66 98.35,15.52 98.55,16.54 98.35,17.55 97.78,18.41 96.92,18.98 95.91,19.18 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="69.45,25.8 68.44,25.59 67.58,25.02 67,24.16 66.8,23.15 67,22.14 67.58,21.28 68.44,20.71 69.45,20.5 82.68,20.5 83.69,20.71 84.55,21.28 85.12,22.14 85.32,23.15 85.12,24.16 84.55,25.02 83.69,25.59 82.68,25.8 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="95.91,25.8 94.89,25.59 94.03,25.02 93.46,24.16 93.26,23.15 93.46,22.14 94.03,21.28 94.89,20.71 95.91,20.5 95.91,20.5 96.92,20.71 97.78,21.28 98.35,22.14 98.55,23.15 98.35,24.16 97.78,25.02 96.92,25.59 95.91,25.8 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="82.68,32.41 81.66,32.21 80.81,31.63 80.23,30.78 80.03,29.76 80.23,28.75 80.81,27.89 81.66,27.32 82.68,27.12 95.91,27.12 96.92,27.32 97.78,27.89 98.35,28.75 98.55,29.76 98.35,30.78 97.78,31.63 96.92,32.21 95.91,32.41 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="69.45,39.02 68.44,38.82 67.58,38.25 67,37.39 66.8,36.38 67,35.37 67.58,34.51 68.44,33.93 69.45,33.73 76.06,33.73 77.08,33.93 77.93,34.51 78.51,35.37 78.71,36.38 78.51,37.39 77.93,38.25 77.08,38.82 76.06,39.02 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="95.91,39.02 94.89,38.82 94.03,38.25 93.46,37.39 93.26,36.38 93.46,35.37 94.03,34.51 94.89,33.93 95.91,33.73 95.91,33.73 96.92,33.93 97.78,34.51 98.35,35.37 98.55,36.38 98.35,37.39 97.78,38.25 96.92,38.82 95.91,39.02 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="76.06,45.64 75.05,45.44 74.19,44.86 73.62,44 73.42,42.99 73.62,41.98 74.19,41.12 75.05,40.55 76.06,40.35 76.06,40.35 77.08,40.55 77.93,41.12 78.51,41.98 78.71,42.99 78.51,44 77.93,44.86 77.08,45.44 76.06,45.64 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="95.91,45.64 94.89,45.44 94.03,44.86 93.46,44 93.26,42.99 93.46,41.98 94.03,41.12 94.89,40.55 95.91,40.35 95.91,40.35 96.92,40.55 97.78,41.12 98.35,41.98 98.55,42.99 98.35,44 97.78,44.86 96.92,45.44 95.91,45.64 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="69.45,52.25 68.44,52.05 67.58,51.48 67,50.62 66.8,49.61 67,48.59 67.58,47.74 68.44,47.16 69.45,46.96 69.45,46.96 70.46,47.16 71.32,47.74 71.89,48.59 72.09,49.61 71.89,50.62 71.32,51.48 70.46,52.05 69.45,52.25 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="89.29,52.25 88.28,52.05 87.42,51.48 86.85,50.62 86.65,49.61 86.85,48.59 87.42,47.74 88.28,47.16 89.29,46.96 89.29,46.96 90.3,47.16 91.16,47.74 91.74,48.59 91.94,49.61 91.74,50.62 91.16,51.48 90.3,52.05 89.29,52.25 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="69.45,58.87 68.44,58.66 67.58,58.09 67,57.23 66.8,56.22 67,55.21 67.58,54.35 68.44,53.78 69.45,53.57 69.45,53.57 70.46,53.78 71.32,54.35 71.89,55.21 72.09,56.22 71.89,57.23 71.32,58.09 70.46,58.66 69.45,58.87 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="82.68,58.87 81.66,58.66 80.81,58.09 80.23,57.23 80.03,56.22 80.23,55.21 80.81,54.35 81.66,53.78 82.68,53.57 82.68,53.57 83.69,53.78 84.55,54.35 85.12,55.21 85.32,56.22 85.12,57.23 84.55,58.09 83.69,58.66 82.68,58.87 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="95.91,58.87 94.89,58.66 94.03,58.09 93.46,57.23 93.26,56.22 93.46,55.21 94.03,54.35 94.89,53.78 95.91,53.57 95.91,53.57 96.92,53.78 97.78,54.35 98.35,55.21 98.55,56.22 98.35,57.23 97.78,58.09 96.92,58.66 95.91,58.87 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="76.06,65.48 75.05,65.28 74.19,64.71 73.62,63.85 73.42,62.83 73.62,61.82 74.19,60.96 75.05,60.39 76.06,60.19 76.06,60.19 77.08,60.39 77.93,60.96 78.51,61.82 78.71,62.83 78.51,63.85 77.93,64.71 77.08,65.28 76.06,65.48 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="69.45,72.09 68.44,71.89 67.58,71.32 67,70.46 66.8,69.45 67,68.44 67.58,67.58 68.44,67 69.45,66.8 69.45,66.8 70.46,67 71.32,67.58 71.89,68.44 72.09,69.45 71.89,70.46 71.32,71.32 70.46,71.89 69.45,72.09 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="89.29,72.09 88.28,71.89 87.42,71.32 86.85,70.46 86.65,69.45 86.85,68.44 87.42,67.58 88.28,67 89.29,66.8 89.29,66.8 90.3,67 91.16,67.58 91.74,68.44 91.94,69.45 91.74,70.46 91.16,71.32 90.3,71.89 89.29,72.09 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="76.06,78.71 75.05,78.51 74.19,77.93 73.62,77.08 73.42,76.06 73.62,75.05 74.19,74.19 75.05,73.62 76.06,73.42 76.06,73.42 77.08,73.62 77.93,74.19 78.51,75.05 78.71,76.06 78.51,77.08 77.93,77.93 77.08,78.51 76.06,78.71 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="89.29,78.71 88.28,78.51 87.42,77.93 86.85,77.08 86.65,76.06 86.85,75.05 87.42,74.19 88.28,73.62 89.29,73.42 89.29,73.42 90.3,73.62 91.16,74.19 91.74,75.05 91.94,76.06 91.74,77.08 91.16,77.93 90.3,78.51 89.29,78.71 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="89.29,91.94 88.28,91.74 87.42,91.16 86.85,90.3 86.65,89.29 86.85,88.28 87.42,87.42 88.28,86.85 89.29,86.65 89.29,86.65 90.3,86.85 91.16,87.42 91.74,88.28 91.94,89.29 91.74,90.3 91.16,91.16 90.3,91.74 89.29,91.94 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="69.45,98.55 68.44,98.35 67.58,97.78 67,96.92 66.8,95.91 67,94.89 67.58,94.03 68.44,93.46 69.45,93.26 76.06,93.26 77.08,93.46 77.93,94.03 78.51,94.89 78.71,95.91 78.51,96.92 77.93,97.78 77.08,98.35 76.06,98.55 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="95.91,98.55 94.89,98.35 94.03,97.78 93.46,96.92 93.26,95.91 93.46,94.89 94.03,94.03 94.89,93.46 95.91,93.26 95.91,93.26 96.92,93.46 97.78,94.03 98.35,94.89 98.55,95.91 98.35,96.92 97.78,97.78 96.92,98.35 95.91,98.55 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="69.45,105.17 68.44,104.96 67.58,104.39 67,103.53 66.8,102.52 67,101.51 67.58,100.65 68.44,100.08 69.45,99.87 69.45,99.87 70.46,100.08 71.32,100.65 71.89,101.51 72.09,102.52 71.89,103.53 71.32,104.39 70.46,104.96 69.45,105.17 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="82.68,105.17 81.66,104.96 80.81,104.39 80.23,103.53 80.03,102.52 80.23,101.51 80.81,100.65 81.66,100.08 82.68,99.87 82.68,99.87 83.69,100.08 84.55,100.65 85.12,101.51 85.32,102.52 85.12,103.53 84.55,104.39 83.69,104.96 82.68,105.17 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="95.91,105.17 94.89,104.96 94.03,104.39 93.46,103.53 93.26,102.52 93.46,101.51 94.03,100.65 94.89,100.08 95.91,99.87 95.91,99.87 96.92,100.08 97.78,100.65 98.35,101.51 98.55,102.52 98.35,103.53 97.78,104.39 96.92,104.96 95.91,105.17 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="69.45,111.78 68.44,111.58 67.58,111 67,110.15 66.8,109.13 67,108.12 67.58,107.26 68.44,106.69 69.45,106.49 69.45,106.49 70.46,106.69 71.32,107.26 71.89,108.12 72.09,109.13 71.89,110.15 71.32,111 70.46,111.58 69.45,111.78 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="89.29,111.78 88.28,111.58 87.42,111 86.85,110.15 86.65,109.13 86.85,108.12 87.42,107.26 88.28,106.69 89.29,106.49 89.29,106.49 90.3,106.69 91.16,107.26 91.74,108.12 91.94,109.13 91.74,110.15 91.16,111 90.3,111.58 89.29,111.78 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="102.52,111.78 101.51,111.58 100.65,111 100.08,110.15 99.87,109.13 100.08,108.12 100.65,107.26 101.51,106.69 102.52,106.49 102.52,106.49 103.53,106.69 104.39,107.26 104.96,108.12 105.17,109.13 104.96,110.15 104.39,111 103.53,111.58 102.52,111.78 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="76.06,118.39 75.05,118.19 74.19,117.62 73.62,116.76 73.42,115.75 73.62,114.74 74.19,113.88 75.05,113.3 76.06,113.1 82.68,113.1 83.69,113.3 84.55,113.88 85.12,114.74 85.32,115.75 85.12,116.76 84.55,117.62 83.69,118.19 82.68,118.39 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="115.75,118.39 114.74,118.19 113.88,117.62 113.3,116.76 113.1,115.75 113.3,114.74 113.88,113.88 114.74,113.3 115.75,113.1 115.75,113.1 116.76,113.3 117.62,113.88 118.19,114.74 118.39,115.75 118.19,116.76 117.62,117.62 116.76,118.19 115.75,118.39 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="69.45,125.01 68.44,124.81 67.58,124.23 67,123.37 66.8,122.36 67,121.35 67.58,120.49 68.44,119.92 69.45,119.72 89.29,119.72 90.3,119.92 91.16,120.49 91.74,121.35 91.94,122.36 91.74,123.37 91.16,124.23 90.3,124.81 89.29,125.01 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="102.52,125.01 101.51,124.81 100.65,124.23 100.08,123.37 99.87,122.36 100.08,121.35 100.65,120.49 101.51,119.92 102.52,119.72 102.52,119.72 103.53,119.92 104.39,120.49 104.96,121.35 105.17,122.36 104.96,123.37 104.39,124.23 103.53,124.81 102.52,125.01 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="122.36,125.01 121.35,124.81 120.49,124.23 119.92,123.37 119.72,122.36 119.92,121.35 120.49,120.49 121.35,119.92 122.36,119.72 122.36,119.72 123.37,119.92 124.23,120.49 124.81,121.35 125.01,122.36 124.81,123.37 124.23,124.23 123.37,124.81 122.36,125.01 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="69.45,131.62 68.44,131.42 67.58,130.85 67,129.99 66.8,128.98 67,127.96 67.58,127.11 68.44,126.53 69.45,126.33 76.06,126.33 77.08,126.53 77.93,127.11 78.51,127.96 78.71,128.98 78.51,129.99 77.93,130.85 77.08,131.42 76.06,131.62 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="89.29,131.62 88.28,131.42 87.42,130.85 86.85,129.99 86.65,128.98 86.85,127.96 87.42,127.11 88.28,126.53 89.29,126.33 115.75,126.33 116.76,126.53 117.62,127.11 118.19,127.96 118.39,128.98 118.19,129.99 117.62,130.85 116.76,131.42 115.75,131.62 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="128.98,131.62 127.96,131.42 127.11,130.85 126.53,129.99 126.33,128.98 126.53,127.96 127.11,127.11 127.96,126.53 128.98,126.33 128.98,126.33 129.99,126.53 130.85,127.11 131.42,127.96 131.62,128.98 131.42,129.99 130.85,130.85 129.99,131.42 128.98,131.62 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="69.45,138.24 68.44,138.03 67.58,137.46 67,136.6 66.8,135.59 67,134.58 67.58,133.72 68.44,133.15 69.45,132.94 76.06,132.94 77.08,133.15 77.93,133.72 78.51,134.58 78.71,135.59 78.51,136.6 77.93,137.46 77.08,138.03 76.06,138.24 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="95.91,138.24 94.89,138.03 94.03,137.46 93.46,136.6 93.26,135.59 93.46,134.58 94.03,133.72 94.89,133.15 95.91,132.94 95.91,132.94 96.92,133.15 97.78,133.72 98.35,134.58 98.55,135.59 98.35,136.6 97.78,137.46 96.92,138.03 95.91,138.24 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="109.13,138.24 108.12,138.03 107.26,137.46 106.69,136.6 106.49,135.59 106.69,134.58 107.26,133.72 108.12,133.15 109.13,132.94 115.75,132.94 116.76,133.15 117.62,133.72 118.19,134.58 118.39,135.59 118.19,136.6 117.62,137.46 116.76,138.03 115.75,138.24 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="128.98,138.24 127.96,138.03 127.11,137.46 126.53,136.6 126.33,135.59 126.53,134.58 127.11,133.72 127.96,133.15 128.98,132.94 135.59,132.94 136.6,133.15 137.46,133.72 138.03,134.58 138.24,135.59 138.03,136.6 137.46,137.46 136.6,138.03 135.59,138.24 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="69.45,144.85 68.44,144.65 67.58,144.08 67,143.22 66.8,142.2 67,141.19 67.58,140.33 68.44,139.76 69.45,139.56 69.45,139.56 70.46,139.76 71.32,140.33 71.89,141.19 72.09,142.2 71.89,143.22 71.32,144.08 70.46,144.65 69.45,144.85 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="82.68,144.85 81.66,144.65 80.81,144.08 80.23,143.22 80.03,142.2 80.23,141.19 80.81,140.33 81.66,139.76 82.68,139.56 122.36,139.56 123.37,139.76 124.23,140.33 124.81,141.19 125.01,142.2 124.81,143.22 124.23,144.08 123.37,144.65 122.36,144.85 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="135.59,144.85 134.58,144.65 133.72,144.08 133.15,143.22 132.94,142.2 133.15,141.19 133.72,140.33 134.58,139.76 135.59,139.56 142.2,139.56 143.22,139.76 144.08,140.33 144.65,141.19 144.85,142.2 144.65,143.22 144.08,144.08 143.22,144.65 142.2,144.85 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="69.45,151.46 68.44,151.26 67.58,150.69 67,149.83 66.8,148.82 67,147.81 67.58,146.95 68.44,146.37 69.45,146.17 82.68,146.17 83.69,146.37 84.55,146.95 85.12,147.81 85.32,148.82 85.12,149.83 84.55,150.69 83.69,151.26 82.68,151.46 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="95.91,151.46 94.89,151.26 94.03,150.69 93.46,149.83 93.26,148.82 93.46,147.81 94.03,146.95 94.89,146.37 95.91,146.17 95.91,146.17 96.92,146.37 97.78,146.95 98.35,147.81 98.55,148.82 98.35,149.83 97.78,150.69 96.92,151.26 95.91,151.46 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="115.75,151.46 114.74,151.26 113.88,150.69 113.3,149.83 113.1,148.82 113.3,147.81 113.88,146.95 114.74,146.37 115.75,146.17 115.75,146.17 116.76,146.37 117.62,146.95 118.19,147.81 118.39,148.82 118.19,149.83 117.62,150.69 116.76,151.26 115.75,151.46 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="135.59,151.46 134.58,151.26 133.72,150.69 133.15,149.83 132.94,148.82 133.15,147.81 133.72,146.95 134.58,146.37 135.59,146.17 135.59,146.17 136.6,146.37 137.46,146.95 138.03,147.81 138.24,148.82 138.03,149.83 137.46,150.69 136.6,151.26 135.59,151.46 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="13.89,69.45 14.09,68.44 14.66,67.58 15.52,67 16.54,66.8 17.55,67 18.41,67.58 18.98,68.44 19.18,69.45 19.18,76.06 18.98,77.08 18.41,77.93 17.55,78.51 16.54,78.71 15.52,78.51 14.66,77.93 14.09,77.08 13.89,76.06 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="13.89,89.29 14.09,88.28 14.66,87.42 15.52,86.85 16.54,86.65 17.55,86.85 18.41,87.42 18.98,88.28 19.18,89.29 19.18,89.29 18.98,90.3 18.41,91.16 17.55,91.74 16.54,91.94 15.52,91.74 14.66,91.16 14.09,90.3 13.89,89.29 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="20.5,69.45 20.71,68.44 21.28,67.58 22.14,67 23.15,66.8 24.16,67 25.02,67.58 25.59,68.44 25.8,69.45 25.8,76.06 25.59,77.08 25.02,77.93 24.16,78.51 23.15,78.71 22.14,78.51 21.28,77.93 20.71,77.08 20.5,76.06 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="20.5,95.91 20.71,94.89 21.28,94.03 22.14,93.46 23.15,93.26 24.16,93.46 25.02,94.03 25.59,94.89 25.8,95.91 25.8,95.91 25.59,96.92 25.02,97.78 24.16,98.35 23.15,98.55 22.14,98.35 21.28,97.78 20.71,96.92 20.5,95.91 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="27.12,69.45 27.32,68.44 27.89,67.58 28.75,67 29.76,66.8 30.78,67 31.63,67.58 32.21,68.44 32.41,69.45 32.41,82.68 32.21,83.69 31.63,84.55 30.78,85.12 29.76,85.32 28.75,85.12 27.89,84.55 27.32,83.69 27.12,82.68 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="33.73,69.45 33.93,68.44 34.51,67.58 35.37,67 36.38,66.8 37.39,67 38.25,67.58 38.82,68.44 39.02,69.45 39.02,69.45 38.82,70.46 38.25,71.32 37.39,71.89 36.38,72.09 35.37,71.89 34.51,71.32 33.93,70.46 33.73,69.45 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="33.73,89.29 33.93,88.28 34.51,87.42 35.37,86.85 36.38,86.65 37.39,86.85 38.25,87.42 38.82,88.28 39.02,89.29 39.02,95.91 38.82,96.92 38.25,97.78 37.39,98.35 36.38,98.55 35.37,98.35 34.51,97.78 33.93,96.92 33.73,95.91 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="40.35,69.45 40.55,68.44 41.12,67.58 41.98,67 42.99,66.8 44,67 44.86,67.58 45.44,68.44 45.64,69.45 45.64,69.45 45.44,70.46 44.86,71.32 44,71.89 42.99,72.09 41.98,71.89 41.12,71.32 40.55,70.46 40.35,69.45 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="40.35,82.68 40.55,81.66 41.12,80.81 41.98,80.23 42.99,80.03 44,80.23 44.86,80.81 45.44,81.66 45.64,82.68 45.64,82.68 45.44,83.69 44.86,84.55 44,85.12 42.99,85.32 41.98,85.12 41.12,84.55 40.55,83.69 40.35,82.68 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="40.35,95.91 40.55,94.89 41.12,94.03 41.98,93.46 42.99,93.26 44,93.46 44.86,94.03 45.44,94.89 45.64,95.91 45.64,95.91 45.44,96.92 44.86,97.78 44,98.35 42.99,98.55 41.98,98.35 41.12,97.78 40.55,96.92 40.35,95.91 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="46.96,76.06 47.16,75.05 47.74,74.19 48.59,73.62 49.61,73.42 50.62,73.62 51.48,74.19 52.05,75.05 52.25,76.06 52.25,82.68 52.05,83.69 51.48,84.55 50.62,85.12 49.61,85.32 48.59,85.12 47.74,84.55 47.16,83.69 46.96,82.68 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="53.57,69.45 53.78,68.44 54.35,67.58 55.21,67 56.22,66.8 57.23,67 58.09,67.58 58.66,68.44 58.87,69.45 58.87,69.45 58.66,70.46 58.09,71.32 57.23,71.89 56.22,72.09 55.21,71.89 54.35,71.32 53.78,70.46 53.57,69.45 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="53.57,82.68 53.78,81.66 54.35,80.81 55.21,80.23 56.22,80.03 57.23,80.23 58.09,80.81 58.66,81.66 58.87,82.68 58.87,82.68 58.66,83.69 58.09,84.55 57.23,85.12 56.22,85.32 55.21,85.12 54.35,84.55 53.78,83.69 53.57,82.68 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="53.57,95.91 53.78,94.89 54.35,94.03 55.21,93.46 56.22,93.26 57.23,93.46 58.09,94.03 58.66,94.89 58.87,95.91 58.87,95.91 58.66,96.92 58.09,97.78 57.23,98.35 56.22,98.55 55.21,98.35 54.35,97.78 53.78,96.92 53.57,95.91 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="60.19,69.45 60.39,68.44 60.96,67.58 61.82,67 62.83,66.8 63.85,67 64.71,67.58 65.28,68.44 65.48,69.45 65.48,76.06 65.28,77.08 64.71,77.93 63.85,78.51 62.83,78.71 61.82,78.51 60.96,77.93 60.39,77.08 60.19,76.06 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="66.8,69.45 67,68.44 67.58,67.58 68.44,67 69.45,66.8 70.46,67 71.32,67.58 71.89,68.44 72.09,69.45 72.09,69.45 71.89,70.46 71.32,71.32 70.46,71.89 69.45,72.09 68.44,71.89 67.58,71.32 67,70.46 66.8,69.45 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="66.8,82.68 67,81.66 67.58,80.81 68.44,80.23 69.45,80.03 70.46,80.23 71.32,80.81 71.89,81.66 72.09,82.68 72.09,82.68 71.89,83.69 71.32,84.55 70.46,85.12 69.45,85.32 68.44,85.12 67.58,84.55 67,83.69 66.8,82.68 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="73.42,76.06 73.62,75.05 74.19,74.19 75.05,73.62 76.06,73.42 77.08,73.62 77.93,74.19 78.51,75.05 78.71,76.06 78.71,82.68 78.51,83.69 77.93,84.55 77.08,85.12 76.06,85.32 75.05,85.12 74.19,84.55 73.62,83.69 73.42,82.68 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="86.65,76.06 86.85,75.05 87.42,74.19 88.28,73.62 89.29,73.42 90.3,73.62 91.16,74.19 91.74,75.05 91.94,76.06 91.94,76.06 91.74,77.08 91.16,77.93 90.3,78.51 89.29,78.71 88.28,78.51 87.42,77.93 86.85,77.08 86.65,76.06 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="93.26,76.06 93.46,75.05 94.03,74.19 94.89,73.62 95.91,73.42 96.92,73.62 97.78,74.19 98.35,75.05 98.55,76.06 98.55,89.29 98.35,90.3 97.78,91.16 96.92,91.74 95.91,91.94 94.89,91.74 94.03,91.16 93.46,90.3 93.26,89.29 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="99.87,69.45 100.08,68.44 100.65,67.58 101.51,67 102.52,66.8 103.53,67 104.39,67.58 104.96,68.44 105.17,69.45 105.17,76.06 104.96,77.08 104.39,77.93 103.53,78.51 102.52,78.71 101.51,78.51 100.65,77.93 100.08,77.08 99.87,76.06 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="99.87,89.29 100.08,88.28 100.65,87.42 101.51,86.85 102.52,86.65 103.53,86.85 104.39,87.42 104.96,88.28 105.17,89.29 105.17,89.29 104.96,90.3 104.39,91.16 103.53,91.74 102.52,91.94 101.51,91.74 100.65,91.16 100.08,90.3 99.87,89.29 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="106.49,76.06 106.69,75.05 107.26,74.19 108.12,73.62 109.13,73.42 110.15,73.62 111,74.19 111.58,75.05 111.78,76.06 111.78,89.29 111.58,90.3 111,91.16 110.15,91.74 109.13,91.94 108.12,91.74 107.26,91.16 106.69,90.3 106.49,89.29 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="113.1,69.45 113.3,68.44 113.88,67.58 114.74,67 115.75,66.8 116.76,67 117.62,67.58 118.19,68.44 118.39,69.45 118.39,69.45 118.19,70.46 117.62,71.32 116.76,71.89 115.75,72.09 114.74,71.89 113.88,71.32 113.3,70.46 113.1,69.45 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="113.1,82.68 113.3,81.66 113.88,80.81 114.74,80.23 115.75,80.03 116.76,80.23 117.62,80.81 118.19,81.66 118.39,82.68 118.39,82.68 118.19,83.69 117.62,84.55 116.76,85.12 115.75,85.32 114.74,85.12 113.88,84.55 113.3,83.69 113.1,82.68 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="113.1,95.91 113.3,94.89 113.88,94.03 114.74,93.46 115.75,93.26 116.76,93.46 117.62,94.03 118.19,94.89 118.39,95.91 118.39,102.52 118.19,103.53 117.62,104.39 116.76,104.96 115.75,105.17 114.74,104.96 113.88,104.39 113.3,103.53 113.1,102.52 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="119.72,109.13 119.92,108.12 120.49,107.26 121.35,106.69 122.36,106.49 123.37,106.69 124.23,107.26 124.81,108.12 125.01,109.13 125.01,115.75 124.81,116.76 124.23,117.62 123.37,118.19 122.36,118.39 121.35,118.19 120.49,117.62 119.92,116.76 119.72,115.75 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="126.33,69.45 126.53,68.44 127.11,67.58 127.96,67 128.98,66.8 129.99,67 130.85,67.58 131.42,68.44 131.62,69.45 131.62,82.68 131.42,83.69 130.85,84.55 129.99,85.12 128.98,85.32 127.96,85.12 127.11,84.55 126.53,83.69 126.33,82.68 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="126.33,109.13 126.53,108.12 127.11,107.26 127.96,106.69 128.98,106.49 129.99,106.69 130.85,107.26 131.42,108.12 131.62,109.13 131.62,109.13 131.42,110.15 130.85,111 129.99,111.58 128.98,111.78 127.96,111.58 127.11,111 126.53,110.15 126.33,109.13 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="126.33,122.36 126.53,121.35 127.11,120.49 127.96,119.92 128.98,119.72 129.99,119.92 130.85,120.49 131.42,121.35 131.62,122.36 131.62,122.36 131.42,123.37 130.85,124.23 129.99,124.81 128.98,125.01 127.96,124.81 127.11,124.23 126.53,123.37 126.33,122.36 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="132.94,76.06 133.15,75.05 133.72,74.19 134.58,73.62 135.59,73.42 136.6,73.62 137.46,74.19 138.03,75.05 138.24,76.06 138.24,76.06 138.03,77.08 137.46,77.93 136.6,78.51 135.59,78.71 134.58,78.51 133.72,77.93 133.15,77.08 132.94,76.06 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="132.94,89.29 133.15,88.28 133.72,87.42 134.58,86.85 135.59,86.65 136.6,86.85 137.46,87.42 138.03,88.28 138.24,89.29 138.24,89.29 138.03,90.3 137.46,91.16 136.6,91.74 135.59,91.94 134.58,91.74 133.72,91.16 133.15,90.3 132.94,89.29 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="132.94,102.52 133.15,101.51 133.72,100.65 134.58,100.08 135.59,99.87 136.6,100.08 137.46,100.65 138.03,101.51 138.24,102.52 138.24,102.52 138.03,103.53 137.46,104.39 136.6,104.96 135.59,105.17 134.58,104.96 133.72,104.39 133.15,103.53 132.94,102.52 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="132.94,115.75 133.15,114.74 133.72,113.88 134.58,113.3 135.59,113.1 136.6,113.3 137.46,113.88 138.03,114.74 138.24,115.75 138.24,128.98 138.03,129.99 137.46,130.85 136.6,131.42 135.59,131.62 134.58,131.42 133.72,130.85 133.15,129.99 132.94,128.98 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="139.56,69.45 139.76,68.44 140.33,67.58 141.19,67 142.2,66.8 143.22,67 144.08,67.58 144.65,68.44 144.85,69.45 144.85,76.06 144.65,77.08 144.08,77.93 143.22,78.51 142.2,78.71 141.19,78.51 140.33,77.93 139.76,77.08 139.56,76.06 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="139.56,89.29 139.76,88.28 140.33,87.42 141.19,86.85 142.2,86.65 143.22,86.85 144.08,87.42 144.65,88.28 144.85,89.29 144.85,95.91 144.65,96.92 144.08,97.78 143.22,98.35 142.2,98.55 141.19,98.35 140.33,97.78 139.76,96.92 139.56,95.91 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="139.56,109.13 139.76,108.12 140.33,107.26 141.19,106.69 142.2,106.49 143.22,106.69 144.08,107.26 144.65,108.12 144.85,109.13 144.85,109.13 144.65,110.15 144.08,111 143.22,111.58 142.2,111.78 141.19,111.58 140.33,111 139.76,110.15 139.56,109.13 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="146.17,76.06 146.37,75.05 146.95,74.19 147.81,73.62 148.82,73.42 149.83,73.62 150.69,74.19 151.26,75.05 151.46,76.06 151.46,89.29 151.26,90.3 150.69,91.16 149.83,91.74 148.82,91.94 147.81,91.74 146.95,91.16 146.37,90.3 146.17,89.29 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
          <polygon
            points="146.17,109.13 146.37,108.12 146.95,107.26 147.81,106.69 148.82,106.49 149.83,106.69 150.69,107.26 151.26,108.12 151.46,109.13 151.46,115.75 151.26,116.76 150.69,117.62 149.83,118.19 148.82,118.39 147.81,118.19 146.95,117.62 146.37,116.76 146.17,115.75 "
            style="fill:url(#gradient230bd81be3cd4d5c8b2e8d6590a4404d);"
          />
      `,
            },
            {
                value: 21,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(37,86,99,1);"
            shape-rendering="crispEdges"
          />
          <pattern
            id="glass201707dc0d7345a1a213d10146189fee"
            x="13.22835"
            y="13.22835"
            width="138.8976"
            height="138.8976"
            patternUnits="userSpaceOnUse"
          >
            <rect x="0" y="0" width="138.8976" height="138.8976" style="fill:rgb(219,229,241);fill-opacity:1;" />
            <rect x="0" y="0" width="138.8976" height="69.44881" style="fill:rgb(231,241,253);fill-opacity:1;" />
          </pattern>
          <polygon
            points="59.53,36.38 59.08,40.89 57.77,45.24 55.63,49.24 52.75,52.75 49.24,55.63 45.24,57.77 40.89,59.08 36.38,59.53 31.86,59.08 27.52,57.77 23.52,55.63 20.01,52.75 17.13,49.24 14.99,45.24 13.67,40.89 13.23,36.38 13.67,31.86 14.99,27.52 17.13,23.52 20.01,20.01 23.52,17.13 27.52,14.99 31.86,13.67 36.38,13.23 40.89,13.67 45.24,14.99 49.24,17.13 52.75,20.01 55.63,23.52 57.77,27.52 59.08,31.86 59.53,36.38 52.91,36.38 52.6,33.15 51.65,30.05 50.13,27.19 48.07,24.69 45.56,22.63 42.71,21.1 39.6,20.16 36.38,19.84 33.15,20.16 30.05,21.1 27.19,22.63 24.69,24.69 22.63,27.19 21.1,30.05 20.16,33.15 19.84,36.38 20.16,39.6 21.1,42.71 22.63,45.56 24.69,48.07 27.19,50.13 30.05,51.65 33.15,52.6 36.38,52.91 39.6,52.6 42.71,51.65 45.56,50.13 48.07,48.07 50.13,45.56 51.65,42.71 52.6,39.6 52.91,36.38 "
            style="fill:url(#glass201707dc0d7345a1a213d10146189fee);"
          />
          <polygon
            points="59.53,128.98 59.08,133.49 57.77,137.84 55.63,141.84 52.75,145.35 49.24,148.22 45.24,150.36 40.89,151.68 36.38,152.13 31.86,151.68 27.52,150.36 23.52,148.22 20.01,145.35 17.13,141.84 14.99,137.84 13.67,133.49 13.23,128.98 13.67,124.46 14.99,120.12 17.13,116.12 20.01,112.61 23.52,109.73 27.52,107.59 31.86,106.27 36.38,105.83 40.89,106.27 45.24,107.59 49.24,109.73 52.75,112.61 55.63,116.12 57.77,120.12 59.08,124.46 59.53,128.98 52.91,128.98 52.6,125.75 51.65,122.65 50.13,119.79 48.07,117.28 45.56,115.23 42.71,113.7 39.6,112.76 36.38,112.44 33.15,112.76 30.05,113.7 27.19,115.23 24.69,117.28 22.63,119.79 21.1,122.65 20.16,125.75 19.84,128.98 20.16,132.2 21.1,135.3 22.63,138.16 24.69,140.67 27.19,142.73 30.05,144.25 33.15,145.19 36.38,145.51 39.6,145.19 42.71,144.25 45.56,142.73 48.07,140.67 50.13,138.16 51.65,135.3 52.6,132.2 52.91,128.98 "
            style="fill:url(#glass201707dc0d7345a1a213d10146189fee);"
          />
          <polygon
            points="152.13,36.38 151.68,40.89 150.36,45.24 148.22,49.24 145.35,52.75 141.84,55.63 137.84,57.77 133.49,59.08 128.98,59.53 124.46,59.08 120.12,57.77 116.12,55.63 112.61,52.75 109.73,49.24 107.59,45.24 106.27,40.89 105.83,36.38 106.27,31.86 107.59,27.52 109.73,23.52 112.61,20.01 116.12,17.13 120.12,14.99 124.46,13.67 128.98,13.23 133.49,13.67 137.84,14.99 141.84,17.13 145.35,20.01 148.22,23.52 150.36,27.52 151.68,31.86 152.13,36.38 145.51,36.38 145.19,33.15 144.25,30.05 142.73,27.19 140.67,24.69 138.16,22.63 135.3,21.1 132.2,20.16 128.98,19.84 125.75,20.16 122.65,21.1 119.79,22.63 117.28,24.69 115.23,27.19 113.7,30.05 112.76,33.15 112.44,36.38 112.76,39.6 113.7,42.71 115.23,45.56 117.28,48.07 119.79,50.13 122.65,51.65 125.75,52.6 128.98,52.91 132.2,52.6 135.3,51.65 138.16,50.13 140.67,48.07 142.73,45.56 144.25,42.71 145.19,39.6 145.51,36.38 "
            style="fill:url(#glass201707dc0d7345a1a213d10146189fee);"
          />
          <linearGradient
            id="gradientf338e33a7b584819b1c744d73e747428"
            gradientUnits="userSpaceOnUse"
            x1="22.0024585616932"
            y1="77.3688099608975"
            x2="143.351858149733"
            y2="87.9855067505283"
          >
            <stop offset="0%" stop-color="#D7E3BC" />
            <stop offset="50%" stop-color="#FF93FB" />
            <stop offset="100%" stop-color="#D7E3BC" />
          </linearGradient>
          <polygon
            points="46.3,36.38 46.11,38.31 45.54,40.17 44.63,41.89 43.39,43.39 41.89,44.63 40.17,45.54 38.31,46.11 36.38,46.3 34.44,46.11 32.58,45.54 30.87,44.63 29.36,43.39 28.13,41.89 27.21,40.17 26.65,38.31 26.46,36.38 26.65,34.44 27.21,32.58 28.13,30.87 29.36,29.36 30.87,28.13 32.58,27.21 34.44,26.65 36.38,26.46 38.31,26.65 40.17,27.21 41.89,28.13 43.39,29.36 44.63,30.87 45.54,32.58 46.11,34.44 46.3,36.38 "
            style="fill:url(#gradientf338e33a7b584819b1c744d73e747428);"
          />
          <polygon
            points="46.3,128.98 46.11,130.91 45.54,132.77 44.63,134.49 43.39,135.99 41.89,137.23 40.17,138.14 38.31,138.71 36.38,138.9 34.44,138.71 32.58,138.14 30.87,137.23 29.36,135.99 28.13,134.49 27.21,132.77 26.65,130.91 26.46,128.98 26.65,127.04 27.21,125.18 28.13,123.46 29.36,121.96 30.87,120.73 32.58,119.81 34.44,119.25 36.38,119.06 38.31,119.25 40.17,119.81 41.89,120.73 43.39,121.96 44.63,123.46 45.54,125.18 46.11,127.04 46.3,128.98 "
            style="fill:url(#gradientf338e33a7b584819b1c744d73e747428);"
          />
          <polygon
            points="138.9,36.38 138.71,38.31 138.14,40.17 137.23,41.89 135.99,43.39 134.49,44.63 132.77,45.54 130.91,46.11 128.98,46.3 127.04,46.11 125.18,45.54 123.46,44.63 121.96,43.39 120.73,41.89 119.81,40.17 119.25,38.31 119.06,36.38 119.25,34.44 119.81,32.58 120.73,30.87 121.96,29.36 123.46,28.13 125.18,27.21 127.04,26.65 128.98,26.46 130.91,26.65 132.77,27.21 134.49,28.13 135.99,29.36 137.23,30.87 138.14,32.58 138.71,34.44 138.9,36.38 "
            style="fill:url(#gradientf338e33a7b584819b1c744d73e747428);"
          />
          <linearGradient
            id="gradientf6ada64ee4ea4c3ab409c80131769b18"
            gradientUnits="userSpaceOnUse"
            x1="9.78888088478347"
            y1="78.8572474050841"
            x2="155.56543964134"
            y2="86.497073121039"
          >
            <stop offset="0%" stop-color="#FFFFFF" />
            <stop offset="100%" stop-color="#A5A5A5" />
          </linearGradient>
          <polygon
            points="85.98,16.54 85.73,17.8 85.02,18.87 83.94,19.59 82.68,19.84 81.41,19.59 80.34,18.87 79.62,17.8 79.37,16.54 79.62,15.27 80.34,14.2 81.41,13.48 82.68,13.23 83.94,13.48 85.02,14.2 85.73,15.27 85.98,16.54 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="92.6,16.54 92.35,17.8 91.63,18.87 90.56,19.59 89.29,19.84 88.03,19.59 86.95,18.87 86.24,17.8 85.98,16.54 86.24,15.27 86.95,14.2 88.03,13.48 89.29,13.23 90.56,13.48 91.63,14.2 92.35,15.27 92.6,16.54 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="99.21,16.54 98.96,17.8 98.24,18.87 97.17,19.59 95.91,19.84 94.64,19.59 93.57,18.87 92.85,17.8 92.6,16.54 92.85,15.27 93.57,14.2 94.64,13.48 95.91,13.23 97.17,13.48 98.24,14.2 98.96,15.27 99.21,16.54 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="72.76,23.15 72.5,24.42 71.79,25.49 70.71,26.2 69.45,26.46 68.18,26.2 67.11,25.49 66.39,24.42 66.14,23.15 66.39,21.88 67.11,20.81 68.18,20.09 69.45,19.84 70.71,20.09 71.79,20.81 72.5,21.88 72.76,23.15 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="79.37,23.15 79.12,24.42 78.4,25.49 77.33,26.2 76.06,26.46 74.8,26.2 73.72,25.49 73.01,24.42 72.76,23.15 73.01,21.88 73.72,20.81 74.8,20.09 76.06,19.84 77.33,20.09 78.4,20.81 79.12,21.88 79.37,23.15 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="85.98,23.15 85.73,24.42 85.02,25.49 83.94,26.2 82.68,26.46 81.41,26.2 80.34,25.49 79.62,24.42 79.37,23.15 79.62,21.88 80.34,20.81 81.41,20.09 82.68,19.84 83.94,20.09 85.02,20.81 85.73,21.88 85.98,23.15 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="99.21,23.15 98.96,24.42 98.24,25.49 97.17,26.2 95.91,26.46 94.64,26.2 93.57,25.49 92.85,24.42 92.6,23.15 92.85,21.88 93.57,20.81 94.64,20.09 95.91,19.84 97.17,20.09 98.24,20.81 98.96,21.88 99.21,23.15 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="85.98,29.76 85.73,31.03 85.02,32.1 83.94,32.82 82.68,33.07 81.41,32.82 80.34,32.1 79.62,31.03 79.37,29.76 79.62,28.5 80.34,27.43 81.41,26.71 82.68,26.46 83.94,26.71 85.02,27.43 85.73,28.5 85.98,29.76 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="92.6,29.76 92.35,31.03 91.63,32.1 90.56,32.82 89.29,33.07 88.03,32.82 86.95,32.1 86.24,31.03 85.98,29.76 86.24,28.5 86.95,27.43 88.03,26.71 89.29,26.46 90.56,26.71 91.63,27.43 92.35,28.5 92.6,29.76 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="99.21,29.76 98.96,31.03 98.24,32.1 97.17,32.82 95.91,33.07 94.64,32.82 93.57,32.1 92.85,31.03 92.6,29.76 92.85,28.5 93.57,27.43 94.64,26.71 95.91,26.46 97.17,26.71 98.24,27.43 98.96,28.5 99.21,29.76 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="72.76,36.38 72.5,37.64 71.79,38.72 70.71,39.43 69.45,39.69 68.18,39.43 67.11,38.72 66.39,37.64 66.14,36.38 66.39,35.11 67.11,34.04 68.18,33.32 69.45,33.07 70.71,33.32 71.79,34.04 72.5,35.11 72.76,36.38 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="79.37,36.38 79.12,37.64 78.4,38.72 77.33,39.43 76.06,39.69 74.8,39.43 73.72,38.72 73.01,37.64 72.76,36.38 73.01,35.11 73.72,34.04 74.8,33.32 76.06,33.07 77.33,33.32 78.4,34.04 79.12,35.11 79.37,36.38 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="99.21,36.38 98.96,37.64 98.24,38.72 97.17,39.43 95.91,39.69 94.64,39.43 93.57,38.72 92.85,37.64 92.6,36.38 92.85,35.11 93.57,34.04 94.64,33.32 95.91,33.07 97.17,33.32 98.24,34.04 98.96,35.11 99.21,36.38 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="79.37,42.99 79.12,44.26 78.4,45.33 77.33,46.05 76.06,46.3 74.8,46.05 73.72,45.33 73.01,44.26 72.76,42.99 73.01,41.73 73.72,40.65 74.8,39.94 76.06,39.69 77.33,39.94 78.4,40.65 79.12,41.73 79.37,42.99 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="99.21,42.99 98.96,44.26 98.24,45.33 97.17,46.05 95.91,46.3 94.64,46.05 93.57,45.33 92.85,44.26 92.6,42.99 92.85,41.73 93.57,40.65 94.64,39.94 95.91,39.69 97.17,39.94 98.24,40.65 98.96,41.73 99.21,42.99 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="72.76,49.61 72.5,50.87 71.79,51.94 70.71,52.66 69.45,52.91 68.18,52.66 67.11,51.94 66.39,50.87 66.14,49.61 66.39,48.34 67.11,47.27 68.18,46.55 69.45,46.3 70.71,46.55 71.79,47.27 72.5,48.34 72.76,49.61 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="92.6,49.61 92.35,50.87 91.63,51.94 90.56,52.66 89.29,52.91 88.03,52.66 86.95,51.94 86.24,50.87 85.98,49.61 86.24,48.34 86.95,47.27 88.03,46.55 89.29,46.3 90.56,46.55 91.63,47.27 92.35,48.34 92.6,49.61 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="72.76,56.22 72.5,57.49 71.79,58.56 70.71,59.28 69.45,59.53 68.18,59.28 67.11,58.56 66.39,57.49 66.14,56.22 66.39,54.95 67.11,53.88 68.18,53.17 69.45,52.91 70.71,53.17 71.79,53.88 72.5,54.95 72.76,56.22 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="85.98,56.22 85.73,57.49 85.02,58.56 83.94,59.28 82.68,59.53 81.41,59.28 80.34,58.56 79.62,57.49 79.37,56.22 79.62,54.95 80.34,53.88 81.41,53.17 82.68,52.91 83.94,53.17 85.02,53.88 85.73,54.95 85.98,56.22 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="99.21,56.22 98.96,57.49 98.24,58.56 97.17,59.28 95.91,59.53 94.64,59.28 93.57,58.56 92.85,57.49 92.6,56.22 92.85,54.95 93.57,53.88 94.64,53.17 95.91,52.91 97.17,53.17 98.24,53.88 98.96,54.95 99.21,56.22 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="79.37,62.83 79.12,64.1 78.4,65.17 77.33,65.89 76.06,66.14 74.8,65.89 73.72,65.17 73.01,64.1 72.76,62.83 73.01,61.57 73.72,60.5 74.8,59.78 76.06,59.53 77.33,59.78 78.4,60.5 79.12,61.57 79.37,62.83 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="19.84,69.45 19.59,70.71 18.87,71.79 17.8,72.5 16.54,72.76 15.27,72.5 14.2,71.79 13.48,70.71 13.23,69.45 13.48,68.18 14.2,67.11 15.27,66.39 16.54,66.14 17.8,66.39 18.87,67.11 19.59,68.18 19.84,69.45 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="26.46,69.45 26.2,70.71 25.49,71.79 24.42,72.5 23.15,72.76 21.88,72.5 20.81,71.79 20.09,70.71 19.84,69.45 20.09,68.18 20.81,67.11 21.88,66.39 23.15,66.14 24.42,66.39 25.49,67.11 26.2,68.18 26.46,69.45 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="33.07,69.45 32.82,70.71 32.1,71.79 31.03,72.5 29.76,72.76 28.5,72.5 27.43,71.79 26.71,70.71 26.46,69.45 26.71,68.18 27.43,67.11 28.5,66.39 29.76,66.14 31.03,66.39 32.1,67.11 32.82,68.18 33.07,69.45 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="39.69,69.45 39.43,70.71 38.72,71.79 37.64,72.5 36.38,72.76 35.11,72.5 34.04,71.79 33.32,70.71 33.07,69.45 33.32,68.18 34.04,67.11 35.11,66.39 36.38,66.14 37.64,66.39 38.72,67.11 39.43,68.18 39.69,69.45 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="46.3,69.45 46.05,70.71 45.33,71.79 44.26,72.5 42.99,72.76 41.73,72.5 40.65,71.79 39.94,70.71 39.69,69.45 39.94,68.18 40.65,67.11 41.73,66.39 42.99,66.14 44.26,66.39 45.33,67.11 46.05,68.18 46.3,69.45 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="59.53,69.45 59.28,70.71 58.56,71.79 57.49,72.5 56.22,72.76 54.95,72.5 53.88,71.79 53.17,70.71 52.91,69.45 53.17,68.18 53.88,67.11 54.95,66.39 56.22,66.14 57.49,66.39 58.56,67.11 59.28,68.18 59.53,69.45 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="66.14,69.45 65.89,70.71 65.17,71.79 64.1,72.5 62.83,72.76 61.57,72.5 60.5,71.79 59.78,70.71 59.53,69.45 59.78,68.18 60.5,67.11 61.57,66.39 62.83,66.14 64.1,66.39 65.17,67.11 65.89,68.18 66.14,69.45 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="72.76,69.45 72.5,70.71 71.79,71.79 70.71,72.5 69.45,72.76 68.18,72.5 67.11,71.79 66.39,70.71 66.14,69.45 66.39,68.18 67.11,67.11 68.18,66.39 69.45,66.14 70.71,66.39 71.79,67.11 72.5,68.18 72.76,69.45 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="92.6,69.45 92.35,70.71 91.63,71.79 90.56,72.5 89.29,72.76 88.03,72.5 86.95,71.79 86.24,70.71 85.98,69.45 86.24,68.18 86.95,67.11 88.03,66.39 89.29,66.14 90.56,66.39 91.63,67.11 92.35,68.18 92.6,69.45 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="105.83,69.45 105.58,70.71 104.86,71.79 103.79,72.5 102.52,72.76 101.25,72.5 100.18,71.79 99.46,70.71 99.21,69.45 99.46,68.18 100.18,67.11 101.25,66.39 102.52,66.14 103.79,66.39 104.86,67.11 105.58,68.18 105.83,69.45 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="119.06,69.45 118.8,70.71 118.09,71.79 117.01,72.5 115.75,72.76 114.48,72.5 113.41,71.79 112.69,70.71 112.44,69.45 112.69,68.18 113.41,67.11 114.48,66.39 115.75,66.14 117.01,66.39 118.09,67.11 118.8,68.18 119.06,69.45 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="132.28,69.45 132.03,70.71 131.31,71.79 130.24,72.5 128.98,72.76 127.71,72.5 126.64,71.79 125.92,70.71 125.67,69.45 125.92,68.18 126.64,67.11 127.71,66.39 128.98,66.14 130.24,66.39 131.31,67.11 132.03,68.18 132.28,69.45 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="145.51,69.45 145.26,70.71 144.54,71.79 143.47,72.5 142.2,72.76 140.94,72.5 139.87,71.79 139.15,70.71 138.9,69.45 139.15,68.18 139.87,67.11 140.94,66.39 142.2,66.14 143.47,66.39 144.54,67.11 145.26,68.18 145.51,69.45 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="19.84,76.06 19.59,77.33 18.87,78.4 17.8,79.12 16.54,79.37 15.27,79.12 14.2,78.4 13.48,77.33 13.23,76.06 13.48,74.8 14.2,73.72 15.27,73.01 16.54,72.76 17.8,73.01 18.87,73.72 19.59,74.8 19.84,76.06 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="26.46,76.06 26.2,77.33 25.49,78.4 24.42,79.12 23.15,79.37 21.88,79.12 20.81,78.4 20.09,77.33 19.84,76.06 20.09,74.8 20.81,73.72 21.88,73.01 23.15,72.76 24.42,73.01 25.49,73.72 26.2,74.8 26.46,76.06 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="33.07,76.06 32.82,77.33 32.1,78.4 31.03,79.12 29.76,79.37 28.5,79.12 27.43,78.4 26.71,77.33 26.46,76.06 26.71,74.8 27.43,73.72 28.5,73.01 29.76,72.76 31.03,73.01 32.1,73.72 32.82,74.8 33.07,76.06 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="52.91,76.06 52.66,77.33 51.94,78.4 50.87,79.12 49.61,79.37 48.34,79.12 47.27,78.4 46.55,77.33 46.3,76.06 46.55,74.8 47.27,73.72 48.34,73.01 49.61,72.76 50.87,73.01 51.94,73.72 52.66,74.8 52.91,76.06 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="66.14,76.06 65.89,77.33 65.17,78.4 64.1,79.12 62.83,79.37 61.57,79.12 60.5,78.4 59.78,77.33 59.53,76.06 59.78,74.8 60.5,73.72 61.57,73.01 62.83,72.76 64.1,73.01 65.17,73.72 65.89,74.8 66.14,76.06 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="79.37,76.06 79.12,77.33 78.4,78.4 77.33,79.12 76.06,79.37 74.8,79.12 73.72,78.4 73.01,77.33 72.76,76.06 73.01,74.8 73.72,73.72 74.8,73.01 76.06,72.76 77.33,73.01 78.4,73.72 79.12,74.8 79.37,76.06 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="92.6,76.06 92.35,77.33 91.63,78.4 90.56,79.12 89.29,79.37 88.03,79.12 86.95,78.4 86.24,77.33 85.98,76.06 86.24,74.8 86.95,73.72 88.03,73.01 89.29,72.76 90.56,73.01 91.63,73.72 92.35,74.8 92.6,76.06 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="99.21,76.06 98.96,77.33 98.24,78.4 97.17,79.12 95.91,79.37 94.64,79.12 93.57,78.4 92.85,77.33 92.6,76.06 92.85,74.8 93.57,73.72 94.64,73.01 95.91,72.76 97.17,73.01 98.24,73.72 98.96,74.8 99.21,76.06 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="105.83,76.06 105.58,77.33 104.86,78.4 103.79,79.12 102.52,79.37 101.25,79.12 100.18,78.4 99.46,77.33 99.21,76.06 99.46,74.8 100.18,73.72 101.25,73.01 102.52,72.76 103.79,73.01 104.86,73.72 105.58,74.8 105.83,76.06 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="112.44,76.06 112.19,77.33 111.47,78.4 110.4,79.12 109.13,79.37 107.87,79.12 106.8,78.4 106.08,77.33 105.83,76.06 106.08,74.8 106.8,73.72 107.87,73.01 109.13,72.76 110.4,73.01 111.47,73.72 112.19,74.8 112.44,76.06 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="132.28,76.06 132.03,77.33 131.31,78.4 130.24,79.12 128.98,79.37 127.71,79.12 126.64,78.4 125.92,77.33 125.67,76.06 125.92,74.8 126.64,73.72 127.71,73.01 128.98,72.76 130.24,73.01 131.31,73.72 132.03,74.8 132.28,76.06 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="138.9,76.06 138.65,77.33 137.93,78.4 136.86,79.12 135.59,79.37 134.32,79.12 133.25,78.4 132.54,77.33 132.28,76.06 132.54,74.8 133.25,73.72 134.32,73.01 135.59,72.76 136.86,73.01 137.93,73.72 138.65,74.8 138.9,76.06 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="145.51,76.06 145.26,77.33 144.54,78.4 143.47,79.12 142.2,79.37 140.94,79.12 139.87,78.4 139.15,77.33 138.9,76.06 139.15,74.8 139.87,73.72 140.94,73.01 142.2,72.76 143.47,73.01 144.54,73.72 145.26,74.8 145.51,76.06 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="152.13,76.06 151.87,77.33 151.16,78.4 150.08,79.12 148.82,79.37 147.55,79.12 146.48,78.4 145.76,77.33 145.51,76.06 145.76,74.8 146.48,73.72 147.55,73.01 148.82,72.76 150.08,73.01 151.16,73.72 151.87,74.8 152.13,76.06 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="33.07,82.68 32.82,83.94 32.1,85.02 31.03,85.73 29.76,85.98 28.5,85.73 27.43,85.02 26.71,83.94 26.46,82.68 26.71,81.41 27.43,80.34 28.5,79.62 29.76,79.37 31.03,79.62 32.1,80.34 32.82,81.41 33.07,82.68 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="46.3,82.68 46.05,83.94 45.33,85.02 44.26,85.73 42.99,85.98 41.73,85.73 40.65,85.02 39.94,83.94 39.69,82.68 39.94,81.41 40.65,80.34 41.73,79.62 42.99,79.37 44.26,79.62 45.33,80.34 46.05,81.41 46.3,82.68 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="52.91,82.68 52.66,83.94 51.94,85.02 50.87,85.73 49.61,85.98 48.34,85.73 47.27,85.02 46.55,83.94 46.3,82.68 46.55,81.41 47.27,80.34 48.34,79.62 49.61,79.37 50.87,79.62 51.94,80.34 52.66,81.41 52.91,82.68 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="59.53,82.68 59.28,83.94 58.56,85.02 57.49,85.73 56.22,85.98 54.95,85.73 53.88,85.02 53.17,83.94 52.91,82.68 53.17,81.41 53.88,80.34 54.95,79.62 56.22,79.37 57.49,79.62 58.56,80.34 59.28,81.41 59.53,82.68 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="72.76,82.68 72.5,83.94 71.79,85.02 70.71,85.73 69.45,85.98 68.18,85.73 67.11,85.02 66.39,83.94 66.14,82.68 66.39,81.41 67.11,80.34 68.18,79.62 69.45,79.37 70.71,79.62 71.79,80.34 72.5,81.41 72.76,82.68 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="79.37,82.68 79.12,83.94 78.4,85.02 77.33,85.73 76.06,85.98 74.8,85.73 73.72,85.02 73.01,83.94 72.76,82.68 73.01,81.41 73.72,80.34 74.8,79.62 76.06,79.37 77.33,79.62 78.4,80.34 79.12,81.41 79.37,82.68 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="99.21,82.68 98.96,83.94 98.24,85.02 97.17,85.73 95.91,85.98 94.64,85.73 93.57,85.02 92.85,83.94 92.6,82.68 92.85,81.41 93.57,80.34 94.64,79.62 95.91,79.37 97.17,79.62 98.24,80.34 98.96,81.41 99.21,82.68 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="112.44,82.68 112.19,83.94 111.47,85.02 110.4,85.73 109.13,85.98 107.87,85.73 106.8,85.02 106.08,83.94 105.83,82.68 106.08,81.41 106.8,80.34 107.87,79.62 109.13,79.37 110.4,79.62 111.47,80.34 112.19,81.41 112.44,82.68 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="119.06,82.68 118.8,83.94 118.09,85.02 117.01,85.73 115.75,85.98 114.48,85.73 113.41,85.02 112.69,83.94 112.44,82.68 112.69,81.41 113.41,80.34 114.48,79.62 115.75,79.37 117.01,79.62 118.09,80.34 118.8,81.41 119.06,82.68 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="132.28,82.68 132.03,83.94 131.31,85.02 130.24,85.73 128.98,85.98 127.71,85.73 126.64,85.02 125.92,83.94 125.67,82.68 125.92,81.41 126.64,80.34 127.71,79.62 128.98,79.37 130.24,79.62 131.31,80.34 132.03,81.41 132.28,82.68 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="152.13,82.68 151.87,83.94 151.16,85.02 150.08,85.73 148.82,85.98 147.55,85.73 146.48,85.02 145.76,83.94 145.51,82.68 145.76,81.41 146.48,80.34 147.55,79.62 148.82,79.37 150.08,79.62 151.16,80.34 151.87,81.41 152.13,82.68 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="19.84,89.29 19.59,90.56 18.87,91.63 17.8,92.35 16.54,92.6 15.27,92.35 14.2,91.63 13.48,90.56 13.23,89.29 13.48,88.03 14.2,86.95 15.27,86.24 16.54,85.98 17.8,86.24 18.87,86.95 19.59,88.03 19.84,89.29 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="39.69,89.29 39.43,90.56 38.72,91.63 37.64,92.35 36.38,92.6 35.11,92.35 34.04,91.63 33.32,90.56 33.07,89.29 33.32,88.03 34.04,86.95 35.11,86.24 36.38,85.98 37.64,86.24 38.72,86.95 39.43,88.03 39.69,89.29 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="92.6,89.29 92.35,90.56 91.63,91.63 90.56,92.35 89.29,92.6 88.03,92.35 86.95,91.63 86.24,90.56 85.98,89.29 86.24,88.03 86.95,86.95 88.03,86.24 89.29,85.98 90.56,86.24 91.63,86.95 92.35,88.03 92.6,89.29 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="99.21,89.29 98.96,90.56 98.24,91.63 97.17,92.35 95.91,92.6 94.64,92.35 93.57,91.63 92.85,90.56 92.6,89.29 92.85,88.03 93.57,86.95 94.64,86.24 95.91,85.98 97.17,86.24 98.24,86.95 98.96,88.03 99.21,89.29 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="105.83,89.29 105.58,90.56 104.86,91.63 103.79,92.35 102.52,92.6 101.25,92.35 100.18,91.63 99.46,90.56 99.21,89.29 99.46,88.03 100.18,86.95 101.25,86.24 102.52,85.98 103.79,86.24 104.86,86.95 105.58,88.03 105.83,89.29 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="112.44,89.29 112.19,90.56 111.47,91.63 110.4,92.35 109.13,92.6 107.87,92.35 106.8,91.63 106.08,90.56 105.83,89.29 106.08,88.03 106.8,86.95 107.87,86.24 109.13,85.98 110.4,86.24 111.47,86.95 112.19,88.03 112.44,89.29 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="138.9,89.29 138.65,90.56 137.93,91.63 136.86,92.35 135.59,92.6 134.32,92.35 133.25,91.63 132.54,90.56 132.28,89.29 132.54,88.03 133.25,86.95 134.32,86.24 135.59,85.98 136.86,86.24 137.93,86.95 138.65,88.03 138.9,89.29 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="145.51,89.29 145.26,90.56 144.54,91.63 143.47,92.35 142.2,92.6 140.94,92.35 139.87,91.63 139.15,90.56 138.9,89.29 139.15,88.03 139.87,86.95 140.94,86.24 142.2,85.98 143.47,86.24 144.54,86.95 145.26,88.03 145.51,89.29 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="152.13,89.29 151.87,90.56 151.16,91.63 150.08,92.35 148.82,92.6 147.55,92.35 146.48,91.63 145.76,90.56 145.51,89.29 145.76,88.03 146.48,86.95 147.55,86.24 148.82,85.98 150.08,86.24 151.16,86.95 151.87,88.03 152.13,89.29 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="26.46,95.91 26.2,97.17 25.49,98.24 24.42,98.96 23.15,99.21 21.88,98.96 20.81,98.24 20.09,97.17 19.84,95.91 20.09,94.64 20.81,93.57 21.88,92.85 23.15,92.6 24.42,92.85 25.49,93.57 26.2,94.64 26.46,95.91 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="39.69,95.91 39.43,97.17 38.72,98.24 37.64,98.96 36.38,99.21 35.11,98.96 34.04,98.24 33.32,97.17 33.07,95.91 33.32,94.64 34.04,93.57 35.11,92.85 36.38,92.6 37.64,92.85 38.72,93.57 39.43,94.64 39.69,95.91 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="46.3,95.91 46.05,97.17 45.33,98.24 44.26,98.96 42.99,99.21 41.73,98.96 40.65,98.24 39.94,97.17 39.69,95.91 39.94,94.64 40.65,93.57 41.73,92.85 42.99,92.6 44.26,92.85 45.33,93.57 46.05,94.64 46.3,95.91 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="59.53,95.91 59.28,97.17 58.56,98.24 57.49,98.96 56.22,99.21 54.95,98.96 53.88,98.24 53.17,97.17 52.91,95.91 53.17,94.64 53.88,93.57 54.95,92.85 56.22,92.6 57.49,92.85 58.56,93.57 59.28,94.64 59.53,95.91 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="72.76,95.91 72.5,97.17 71.79,98.24 70.71,98.96 69.45,99.21 68.18,98.96 67.11,98.24 66.39,97.17 66.14,95.91 66.39,94.64 67.11,93.57 68.18,92.85 69.45,92.6 70.71,92.85 71.79,93.57 72.5,94.64 72.76,95.91 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="79.37,95.91 79.12,97.17 78.4,98.24 77.33,98.96 76.06,99.21 74.8,98.96 73.72,98.24 73.01,97.17 72.76,95.91 73.01,94.64 73.72,93.57 74.8,92.85 76.06,92.6 77.33,92.85 78.4,93.57 79.12,94.64 79.37,95.91 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="99.21,95.91 98.96,97.17 98.24,98.24 97.17,98.96 95.91,99.21 94.64,98.96 93.57,98.24 92.85,97.17 92.6,95.91 92.85,94.64 93.57,93.57 94.64,92.85 95.91,92.6 97.17,92.85 98.24,93.57 98.96,94.64 99.21,95.91 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="119.06,95.91 118.8,97.17 118.09,98.24 117.01,98.96 115.75,99.21 114.48,98.96 113.41,98.24 112.69,97.17 112.44,95.91 112.69,94.64 113.41,93.57 114.48,92.85 115.75,92.6 117.01,92.85 118.09,93.57 118.8,94.64 119.06,95.91 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="145.51,95.91 145.26,97.17 144.54,98.24 143.47,98.96 142.2,99.21 140.94,98.96 139.87,98.24 139.15,97.17 138.9,95.91 139.15,94.64 139.87,93.57 140.94,92.85 142.2,92.6 143.47,92.85 144.54,93.57 145.26,94.64 145.51,95.91 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="72.76,102.52 72.5,103.79 71.79,104.86 70.71,105.58 69.45,105.83 68.18,105.58 67.11,104.86 66.39,103.79 66.14,102.52 66.39,101.25 67.11,100.18 68.18,99.46 69.45,99.21 70.71,99.46 71.79,100.18 72.5,101.25 72.76,102.52 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="85.98,102.52 85.73,103.79 85.02,104.86 83.94,105.58 82.68,105.83 81.41,105.58 80.34,104.86 79.62,103.79 79.37,102.52 79.62,101.25 80.34,100.18 81.41,99.46 82.68,99.21 83.94,99.46 85.02,100.18 85.73,101.25 85.98,102.52 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="99.21,102.52 98.96,103.79 98.24,104.86 97.17,105.58 95.91,105.83 94.64,105.58 93.57,104.86 92.85,103.79 92.6,102.52 92.85,101.25 93.57,100.18 94.64,99.46 95.91,99.21 97.17,99.46 98.24,100.18 98.96,101.25 99.21,102.52 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="119.06,102.52 118.8,103.79 118.09,104.86 117.01,105.58 115.75,105.83 114.48,105.58 113.41,104.86 112.69,103.79 112.44,102.52 112.69,101.25 113.41,100.18 114.48,99.46 115.75,99.21 117.01,99.46 118.09,100.18 118.8,101.25 119.06,102.52 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="138.9,102.52 138.65,103.79 137.93,104.86 136.86,105.58 135.59,105.83 134.32,105.58 133.25,104.86 132.54,103.79 132.28,102.52 132.54,101.25 133.25,100.18 134.32,99.46 135.59,99.21 136.86,99.46 137.93,100.18 138.65,101.25 138.9,102.52 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="72.76,109.13 72.5,110.4 71.79,111.47 70.71,112.19 69.45,112.44 68.18,112.19 67.11,111.47 66.39,110.4 66.14,109.13 66.39,107.87 67.11,106.8 68.18,106.08 69.45,105.83 70.71,106.08 71.79,106.8 72.5,107.87 72.76,109.13 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="92.6,109.13 92.35,110.4 91.63,111.47 90.56,112.19 89.29,112.44 88.03,112.19 86.95,111.47 86.24,110.4 85.98,109.13 86.24,107.87 86.95,106.8 88.03,106.08 89.29,105.83 90.56,106.08 91.63,106.8 92.35,107.87 92.6,109.13 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="105.83,109.13 105.58,110.4 104.86,111.47 103.79,112.19 102.52,112.44 101.25,112.19 100.18,111.47 99.46,110.4 99.21,109.13 99.46,107.87 100.18,106.8 101.25,106.08 102.52,105.83 103.79,106.08 104.86,106.8 105.58,107.87 105.83,109.13 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="125.67,109.13 125.42,110.4 124.7,111.47 123.63,112.19 122.36,112.44 121.1,112.19 120.02,111.47 119.31,110.4 119.06,109.13 119.31,107.87 120.02,106.8 121.1,106.08 122.36,105.83 123.63,106.08 124.7,106.8 125.42,107.87 125.67,109.13 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="132.28,109.13 132.03,110.4 131.31,111.47 130.24,112.19 128.98,112.44 127.71,112.19 126.64,111.47 125.92,110.4 125.67,109.13 125.92,107.87 126.64,106.8 127.71,106.08 128.98,105.83 130.24,106.08 131.31,106.8 132.03,107.87 132.28,109.13 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="145.51,109.13 145.26,110.4 144.54,111.47 143.47,112.19 142.2,112.44 140.94,112.19 139.87,111.47 139.15,110.4 138.9,109.13 139.15,107.87 139.87,106.8 140.94,106.08 142.2,105.83 143.47,106.08 144.54,106.8 145.26,107.87 145.51,109.13 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="152.13,109.13 151.87,110.4 151.16,111.47 150.08,112.19 148.82,112.44 147.55,112.19 146.48,111.47 145.76,110.4 145.51,109.13 145.76,107.87 146.48,106.8 147.55,106.08 148.82,105.83 150.08,106.08 151.16,106.8 151.87,107.87 152.13,109.13 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="79.37,115.75 79.12,117.01 78.4,118.09 77.33,118.8 76.06,119.06 74.8,118.8 73.72,118.09 73.01,117.01 72.76,115.75 73.01,114.48 73.72,113.41 74.8,112.69 76.06,112.44 77.33,112.69 78.4,113.41 79.12,114.48 79.37,115.75 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="85.98,115.75 85.73,117.01 85.02,118.09 83.94,118.8 82.68,119.06 81.41,118.8 80.34,118.09 79.62,117.01 79.37,115.75 79.62,114.48 80.34,113.41 81.41,112.69 82.68,112.44 83.94,112.69 85.02,113.41 85.73,114.48 85.98,115.75 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="119.06,115.75 118.8,117.01 118.09,118.09 117.01,118.8 115.75,119.06 114.48,118.8 113.41,118.09 112.69,117.01 112.44,115.75 112.69,114.48 113.41,113.41 114.48,112.69 115.75,112.44 117.01,112.69 118.09,113.41 118.8,114.48 119.06,115.75 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="125.67,115.75 125.42,117.01 124.7,118.09 123.63,118.8 122.36,119.06 121.1,118.8 120.02,118.09 119.31,117.01 119.06,115.75 119.31,114.48 120.02,113.41 121.1,112.69 122.36,112.44 123.63,112.69 124.7,113.41 125.42,114.48 125.67,115.75 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="138.9,115.75 138.65,117.01 137.93,118.09 136.86,118.8 135.59,119.06 134.32,118.8 133.25,118.09 132.54,117.01 132.28,115.75 132.54,114.48 133.25,113.41 134.32,112.69 135.59,112.44 136.86,112.69 137.93,113.41 138.65,114.48 138.9,115.75 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="152.13,115.75 151.87,117.01 151.16,118.09 150.08,118.8 148.82,119.06 147.55,118.8 146.48,118.09 145.76,117.01 145.51,115.75 145.76,114.48 146.48,113.41 147.55,112.69 148.82,112.44 150.08,112.69 151.16,113.41 151.87,114.48 152.13,115.75 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="72.76,122.36 72.5,123.63 71.79,124.7 70.71,125.42 69.45,125.67 68.18,125.42 67.11,124.7 66.39,123.63 66.14,122.36 66.39,121.1 67.11,120.02 68.18,119.31 69.45,119.06 70.71,119.31 71.79,120.02 72.5,121.1 72.76,122.36 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="79.37,122.36 79.12,123.63 78.4,124.7 77.33,125.42 76.06,125.67 74.8,125.42 73.72,124.7 73.01,123.63 72.76,122.36 73.01,121.1 73.72,120.02 74.8,119.31 76.06,119.06 77.33,119.31 78.4,120.02 79.12,121.1 79.37,122.36 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="85.98,122.36 85.73,123.63 85.02,124.7 83.94,125.42 82.68,125.67 81.41,125.42 80.34,124.7 79.62,123.63 79.37,122.36 79.62,121.1 80.34,120.02 81.41,119.31 82.68,119.06 83.94,119.31 85.02,120.02 85.73,121.1 85.98,122.36 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="92.6,122.36 92.35,123.63 91.63,124.7 90.56,125.42 89.29,125.67 88.03,125.42 86.95,124.7 86.24,123.63 85.98,122.36 86.24,121.1 86.95,120.02 88.03,119.31 89.29,119.06 90.56,119.31 91.63,120.02 92.35,121.1 92.6,122.36 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="105.83,122.36 105.58,123.63 104.86,124.7 103.79,125.42 102.52,125.67 101.25,125.42 100.18,124.7 99.46,123.63 99.21,122.36 99.46,121.1 100.18,120.02 101.25,119.31 102.52,119.06 103.79,119.31 104.86,120.02 105.58,121.1 105.83,122.36 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="125.67,122.36 125.42,123.63 124.7,124.7 123.63,125.42 122.36,125.67 121.1,125.42 120.02,124.7 119.31,123.63 119.06,122.36 119.31,121.1 120.02,120.02 121.1,119.31 122.36,119.06 123.63,119.31 124.7,120.02 125.42,121.1 125.67,122.36 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="132.28,122.36 132.03,123.63 131.31,124.7 130.24,125.42 128.98,125.67 127.71,125.42 126.64,124.7 125.92,123.63 125.67,122.36 125.92,121.1 126.64,120.02 127.71,119.31 128.98,119.06 130.24,119.31 131.31,120.02 132.03,121.1 132.28,122.36 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="138.9,122.36 138.65,123.63 137.93,124.7 136.86,125.42 135.59,125.67 134.32,125.42 133.25,124.7 132.54,123.63 132.28,122.36 132.54,121.1 133.25,120.02 134.32,119.31 135.59,119.06 136.86,119.31 137.93,120.02 138.65,121.1 138.9,122.36 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="72.76,128.98 72.5,130.24 71.79,131.31 70.71,132.03 69.45,132.28 68.18,132.03 67.11,131.31 66.39,130.24 66.14,128.98 66.39,127.71 67.11,126.64 68.18,125.92 69.45,125.67 70.71,125.92 71.79,126.64 72.5,127.71 72.76,128.98 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="79.37,128.98 79.12,130.24 78.4,131.31 77.33,132.03 76.06,132.28 74.8,132.03 73.72,131.31 73.01,130.24 72.76,128.98 73.01,127.71 73.72,126.64 74.8,125.92 76.06,125.67 77.33,125.92 78.4,126.64 79.12,127.71 79.37,128.98 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="92.6,128.98 92.35,130.24 91.63,131.31 90.56,132.03 89.29,132.28 88.03,132.03 86.95,131.31 86.24,130.24 85.98,128.98 86.24,127.71 86.95,126.64 88.03,125.92 89.29,125.67 90.56,125.92 91.63,126.64 92.35,127.71 92.6,128.98 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="99.21,128.98 98.96,130.24 98.24,131.31 97.17,132.03 95.91,132.28 94.64,132.03 93.57,131.31 92.85,130.24 92.6,128.98 92.85,127.71 93.57,126.64 94.64,125.92 95.91,125.67 97.17,125.92 98.24,126.64 98.96,127.71 99.21,128.98 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="105.83,128.98 105.58,130.24 104.86,131.31 103.79,132.03 102.52,132.28 101.25,132.03 100.18,131.31 99.46,130.24 99.21,128.98 99.46,127.71 100.18,126.64 101.25,125.92 102.52,125.67 103.79,125.92 104.86,126.64 105.58,127.71 105.83,128.98 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="112.44,128.98 112.19,130.24 111.47,131.31 110.4,132.03 109.13,132.28 107.87,132.03 106.8,131.31 106.08,130.24 105.83,128.98 106.08,127.71 106.8,126.64 107.87,125.92 109.13,125.67 110.4,125.92 111.47,126.64 112.19,127.71 112.44,128.98 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="119.06,128.98 118.8,130.24 118.09,131.31 117.01,132.03 115.75,132.28 114.48,132.03 113.41,131.31 112.69,130.24 112.44,128.98 112.69,127.71 113.41,126.64 114.48,125.92 115.75,125.67 117.01,125.92 118.09,126.64 118.8,127.71 119.06,128.98 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="132.28,128.98 132.03,130.24 131.31,131.31 130.24,132.03 128.98,132.28 127.71,132.03 126.64,131.31 125.92,130.24 125.67,128.98 125.92,127.71 126.64,126.64 127.71,125.92 128.98,125.67 130.24,125.92 131.31,126.64 132.03,127.71 132.28,128.98 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="138.9,128.98 138.65,130.24 137.93,131.31 136.86,132.03 135.59,132.28 134.32,132.03 133.25,131.31 132.54,130.24 132.28,128.98 132.54,127.71 133.25,126.64 134.32,125.92 135.59,125.67 136.86,125.92 137.93,126.64 138.65,127.71 138.9,128.98 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="72.76,135.59 72.5,136.86 71.79,137.93 70.71,138.65 69.45,138.9 68.18,138.65 67.11,137.93 66.39,136.86 66.14,135.59 66.39,134.32 67.11,133.25 68.18,132.54 69.45,132.28 70.71,132.54 71.79,133.25 72.5,134.32 72.76,135.59 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="79.37,135.59 79.12,136.86 78.4,137.93 77.33,138.65 76.06,138.9 74.8,138.65 73.72,137.93 73.01,136.86 72.76,135.59 73.01,134.32 73.72,133.25 74.8,132.54 76.06,132.28 77.33,132.54 78.4,133.25 79.12,134.32 79.37,135.59 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="99.21,135.59 98.96,136.86 98.24,137.93 97.17,138.65 95.91,138.9 94.64,138.65 93.57,137.93 92.85,136.86 92.6,135.59 92.85,134.32 93.57,133.25 94.64,132.54 95.91,132.28 97.17,132.54 98.24,133.25 98.96,134.32 99.21,135.59 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="112.44,135.59 112.19,136.86 111.47,137.93 110.4,138.65 109.13,138.9 107.87,138.65 106.8,137.93 106.08,136.86 105.83,135.59 106.08,134.32 106.8,133.25 107.87,132.54 109.13,132.28 110.4,132.54 111.47,133.25 112.19,134.32 112.44,135.59 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="119.06,135.59 118.8,136.86 118.09,137.93 117.01,138.65 115.75,138.9 114.48,138.65 113.41,137.93 112.69,136.86 112.44,135.59 112.69,134.32 113.41,133.25 114.48,132.54 115.75,132.28 117.01,132.54 118.09,133.25 118.8,134.32 119.06,135.59 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="132.28,135.59 132.03,136.86 131.31,137.93 130.24,138.65 128.98,138.9 127.71,138.65 126.64,137.93 125.92,136.86 125.67,135.59 125.92,134.32 126.64,133.25 127.71,132.54 128.98,132.28 130.24,132.54 131.31,133.25 132.03,134.32 132.28,135.59 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="138.9,135.59 138.65,136.86 137.93,137.93 136.86,138.65 135.59,138.9 134.32,138.65 133.25,137.93 132.54,136.86 132.28,135.59 132.54,134.32 133.25,133.25 134.32,132.54 135.59,132.28 136.86,132.54 137.93,133.25 138.65,134.32 138.9,135.59 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="72.76,142.2 72.5,143.47 71.79,144.54 70.71,145.26 69.45,145.51 68.18,145.26 67.11,144.54 66.39,143.47 66.14,142.2 66.39,140.94 67.11,139.87 68.18,139.15 69.45,138.9 70.71,139.15 71.79,139.87 72.5,140.94 72.76,142.2 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="85.98,142.2 85.73,143.47 85.02,144.54 83.94,145.26 82.68,145.51 81.41,145.26 80.34,144.54 79.62,143.47 79.37,142.2 79.62,140.94 80.34,139.87 81.41,139.15 82.68,138.9 83.94,139.15 85.02,139.87 85.73,140.94 85.98,142.2 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="92.6,142.2 92.35,143.47 91.63,144.54 90.56,145.26 89.29,145.51 88.03,145.26 86.95,144.54 86.24,143.47 85.98,142.2 86.24,140.94 86.95,139.87 88.03,139.15 89.29,138.9 90.56,139.15 91.63,139.87 92.35,140.94 92.6,142.2 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="99.21,142.2 98.96,143.47 98.24,144.54 97.17,145.26 95.91,145.51 94.64,145.26 93.57,144.54 92.85,143.47 92.6,142.2 92.85,140.94 93.57,139.87 94.64,139.15 95.91,138.9 97.17,139.15 98.24,139.87 98.96,140.94 99.21,142.2 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="105.83,142.2 105.58,143.47 104.86,144.54 103.79,145.26 102.52,145.51 101.25,145.26 100.18,144.54 99.46,143.47 99.21,142.2 99.46,140.94 100.18,139.87 101.25,139.15 102.52,138.9 103.79,139.15 104.86,139.87 105.58,140.94 105.83,142.2 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="112.44,142.2 112.19,143.47 111.47,144.54 110.4,145.26 109.13,145.51 107.87,145.26 106.8,144.54 106.08,143.47 105.83,142.2 106.08,140.94 106.8,139.87 107.87,139.15 109.13,138.9 110.4,139.15 111.47,139.87 112.19,140.94 112.44,142.2 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="119.06,142.2 118.8,143.47 118.09,144.54 117.01,145.26 115.75,145.51 114.48,145.26 113.41,144.54 112.69,143.47 112.44,142.2 112.69,140.94 113.41,139.87 114.48,139.15 115.75,138.9 117.01,139.15 118.09,139.87 118.8,140.94 119.06,142.2 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="125.67,142.2 125.42,143.47 124.7,144.54 123.63,145.26 122.36,145.51 121.1,145.26 120.02,144.54 119.31,143.47 119.06,142.2 119.31,140.94 120.02,139.87 121.1,139.15 122.36,138.9 123.63,139.15 124.7,139.87 125.42,140.94 125.67,142.2 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="138.9,142.2 138.65,143.47 137.93,144.54 136.86,145.26 135.59,145.51 134.32,145.26 133.25,144.54 132.54,143.47 132.28,142.2 132.54,140.94 133.25,139.87 134.32,139.15 135.59,138.9 136.86,139.15 137.93,139.87 138.65,140.94 138.9,142.2 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="145.51,142.2 145.26,143.47 144.54,144.54 143.47,145.26 142.2,145.51 140.94,145.26 139.87,144.54 139.15,143.47 138.9,142.2 139.15,140.94 139.87,139.87 140.94,139.15 142.2,138.9 143.47,139.15 144.54,139.87 145.26,140.94 145.51,142.2 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="72.76,148.82 72.5,150.08 71.79,151.16 70.71,151.87 69.45,152.13 68.18,151.87 67.11,151.16 66.39,150.08 66.14,148.82 66.39,147.55 67.11,146.48 68.18,145.76 69.45,145.51 70.71,145.76 71.79,146.48 72.5,147.55 72.76,148.82 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="79.37,148.82 79.12,150.08 78.4,151.16 77.33,151.87 76.06,152.13 74.8,151.87 73.72,151.16 73.01,150.08 72.76,148.82 73.01,147.55 73.72,146.48 74.8,145.76 76.06,145.51 77.33,145.76 78.4,146.48 79.12,147.55 79.37,148.82 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="85.98,148.82 85.73,150.08 85.02,151.16 83.94,151.87 82.68,152.13 81.41,151.87 80.34,151.16 79.62,150.08 79.37,148.82 79.62,147.55 80.34,146.48 81.41,145.76 82.68,145.51 83.94,145.76 85.02,146.48 85.73,147.55 85.98,148.82 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="99.21,148.82 98.96,150.08 98.24,151.16 97.17,151.87 95.91,152.13 94.64,151.87 93.57,151.16 92.85,150.08 92.6,148.82 92.85,147.55 93.57,146.48 94.64,145.76 95.91,145.51 97.17,145.76 98.24,146.48 98.96,147.55 99.21,148.82 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="119.06,148.82 118.8,150.08 118.09,151.16 117.01,151.87 115.75,152.13 114.48,151.87 113.41,151.16 112.69,150.08 112.44,148.82 112.69,147.55 113.41,146.48 114.48,145.76 115.75,145.51 117.01,145.76 118.09,146.48 118.8,147.55 119.06,148.82 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
          <polygon
            points="138.9,148.82 138.65,150.08 137.93,151.16 136.86,151.87 135.59,152.13 134.32,151.87 133.25,151.16 132.54,150.08 132.28,148.82 132.54,147.55 133.25,146.48 134.32,145.76 135.59,145.51 136.86,145.76 137.93,146.48 138.65,147.55 138.9,148.82 "
            style="fill:url(#gradientf6ada64ee4ea4c3ab409c80131769b18);"
          />
      `,
            },
            {
                value: 22,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(37,86,99,1);"
            shape-rendering="crispEdges"
          />
          <linearGradient
            id="gradientff154b24163e4fb69b5bbd4023a55584"
            gradientUnits="userSpaceOnUse"
            x1="7.72605761144101"
            y1="76.1197884622769"
            x2="157.628262914682"
            y2="89.2345320638461"
          >
            <stop offset="0%" stop-color="#C993FF" />
            <stop offset="50%" stop-color="#DBE5F1" />
            <stop offset="100%" stop-color="#C993FF" />
          </linearGradient>
          <polygon
            points="13.23,29.76 13.55,26.54 14.49,23.44 16.02,20.58 18.07,18.07 20.58,16.02 23.44,14.49 26.54,13.55 29.76,13.23 42.99,13.23 46.22,13.55 49.32,14.49 52.18,16.02 54.68,18.07 56.74,20.58 58.27,23.44 59.21,26.54 59.53,29.76 59.53,42.99 59.21,46.22 58.27,49.32 56.74,52.18 54.68,54.68 52.18,56.74 49.32,58.27 46.22,59.21 42.99,59.53 29.76,59.53 26.54,59.21 23.44,58.27 20.58,56.74 18.07,54.68 16.02,52.18 14.49,49.32 13.55,46.22 13.23,42.99 13.23,29.76 19.84,29.76 19.84,42.99 20.18,45.56 21.17,47.95 22.75,50.01 24.8,51.58 27.2,52.58 29.76,52.91 42.99,52.91 45.56,52.58 47.95,51.58 50.01,50.01 51.58,47.95 52.58,45.56 52.91,42.99 52.91,29.76 52.58,27.2 51.58,24.8 50.01,22.75 47.95,21.17 45.56,20.18 42.99,19.84 29.76,19.84 27.2,20.18 24.8,21.17 22.75,22.75 21.17,24.8 20.18,27.2 19.84,29.76 "
            style="fill:url(#gradientff154b24163e4fb69b5bbd4023a55584);"
          />
          <polygon
            points="13.23,122.36 13.55,119.14 14.49,116.03 16.02,113.18 18.07,110.67 20.58,108.61 23.44,107.09 26.54,106.14 29.76,105.83 42.99,105.83 46.22,106.14 49.32,107.09 52.18,108.61 54.68,110.67 56.74,113.18 58.27,116.03 59.21,119.14 59.53,122.36 59.53,135.59 59.21,138.82 58.27,141.92 56.74,144.78 54.68,147.28 52.18,149.34 49.32,150.87 46.22,151.81 42.99,152.13 29.76,152.13 26.54,151.81 23.44,150.87 20.58,149.34 18.07,147.28 16.02,144.78 14.49,141.92 13.55,138.82 13.23,135.59 13.23,122.36 19.84,122.36 19.84,135.59 20.18,138.16 21.17,140.55 22.75,142.61 24.8,144.18 27.2,145.17 29.76,145.51 42.99,145.51 45.56,145.17 47.95,144.18 50.01,142.61 51.58,140.55 52.58,138.16 52.91,135.59 52.91,122.36 52.58,119.79 51.58,117.4 50.01,115.35 47.95,113.77 45.56,112.78 42.99,112.44 29.76,112.44 27.2,112.78 24.8,113.77 22.75,115.35 21.17,117.4 20.18,119.79 19.84,122.36 "
            style="fill:url(#gradientff154b24163e4fb69b5bbd4023a55584);"
          />
          <polygon
            points="105.83,29.76 106.14,26.54 107.09,23.44 108.61,20.58 110.67,18.07 113.18,16.02 116.03,14.49 119.14,13.55 122.36,13.23 135.59,13.23 138.82,13.55 141.92,14.49 144.78,16.02 147.28,18.07 149.34,20.58 150.87,23.44 151.81,26.54 152.13,29.76 152.13,42.99 151.81,46.22 150.87,49.32 149.34,52.18 147.28,54.68 144.78,56.74 141.92,58.27 138.82,59.21 135.59,59.53 122.36,59.53 119.14,59.21 116.03,58.27 113.18,56.74 110.67,54.68 108.61,52.18 107.09,49.32 106.14,46.22 105.83,42.99 105.83,29.76 112.44,29.76 112.44,42.99 112.78,45.56 113.77,47.95 115.35,50.01 117.4,51.58 119.79,52.58 122.36,52.91 135.59,52.91 138.16,52.58 140.55,51.58 142.61,50.01 144.18,47.95 145.17,45.56 145.51,42.99 145.51,29.76 145.17,27.2 144.18,24.8 142.61,22.75 140.55,21.17 138.16,20.18 135.59,19.84 122.36,19.84 119.79,20.18 117.4,21.17 115.35,22.75 113.77,24.8 112.78,27.2 112.44,29.76 "
            style="fill:url(#gradientff154b24163e4fb69b5bbd4023a55584);"
          />
          <pattern
            id="hatch2db9197d1dd34ec6a96c1df3c769c1f3"
            x="0"
            y="0"
            width="8"
            height="8"
            patternUnits="userSpaceOnUse"
          >
            <rect x="0" y="0" width="8" height="8" fill="#F2DCDB" />
            <rect x="4" y="0" width="1" height="1" fill="#CCC1D9" />
            <rect x="5" y="0" width="1" height="1" fill="#CCC1D9" />
            <rect x="6" y="0" width="1" height="1" fill="#CCC1D9" />
            <rect x="7" y="0" width="1" height="1" fill="#CCC1D9" />
            <rect x="4" y="1" width="1" height="1" fill="#CCC1D9" />
            <rect x="5" y="1" width="1" height="1" fill="#CCC1D9" />
            <rect x="6" y="1" width="1" height="1" fill="#CCC1D9" />
            <rect x="7" y="1" width="1" height="1" fill="#CCC1D9" />
            <rect x="4" y="2" width="1" height="1" fill="#CCC1D9" />
            <rect x="5" y="2" width="1" height="1" fill="#CCC1D9" />
            <rect x="6" y="2" width="1" height="1" fill="#CCC1D9" />
            <rect x="7" y="2" width="1" height="1" fill="#CCC1D9" />
            <rect x="4" y="3" width="1" height="1" fill="#CCC1D9" />
            <rect x="5" y="3" width="1" height="1" fill="#CCC1D9" />
            <rect x="6" y="3" width="1" height="1" fill="#CCC1D9" />
            <rect x="7" y="3" width="1" height="1" fill="#CCC1D9" />
            <rect x="0" y="4" width="1" height="1" fill="#CCC1D9" />
            <rect x="1" y="4" width="1" height="1" fill="#CCC1D9" />
            <rect x="2" y="4" width="1" height="1" fill="#CCC1D9" />
            <rect x="3" y="4" width="1" height="1" fill="#CCC1D9" />
            <rect x="0" y="5" width="1" height="1" fill="#CCC1D9" />
            <rect x="1" y="5" width="1" height="1" fill="#CCC1D9" />
            <rect x="2" y="5" width="1" height="1" fill="#CCC1D9" />
            <rect x="3" y="5" width="1" height="1" fill="#CCC1D9" />
            <rect x="0" y="6" width="1" height="1" fill="#CCC1D9" />
            <rect x="1" y="6" width="1" height="1" fill="#CCC1D9" />
            <rect x="2" y="6" width="1" height="1" fill="#CCC1D9" />
            <rect x="3" y="6" width="1" height="1" fill="#CCC1D9" />
            <rect x="0" y="7" width="1" height="1" fill="#CCC1D9" />
            <rect x="1" y="7" width="1" height="1" fill="#CCC1D9" />
            <rect x="2" y="7" width="1" height="1" fill="#CCC1D9" />
            <rect x="3" y="7" width="1" height="1" fill="#CCC1D9" />
          </pattern>
          <polygon
            points="26.46,31.09 26.61,29.89 27.08,28.77 27.81,27.81 28.77,27.08 29.89,26.61 31.09,26.46 41.67,26.46 42.87,26.61 43.98,27.08 44.94,27.81 45.68,28.77 46.14,29.89 46.3,31.09 46.3,41.67 46.14,42.87 45.68,43.98 44.94,44.94 43.98,45.68 42.87,46.14 41.67,46.3 31.09,46.3 29.89,46.14 28.77,45.68 27.81,44.94 27.08,43.98 26.61,42.87 26.46,41.67 "
            style="fill:url(#hatch2db9197d1dd34ec6a96c1df3c769c1f3);"
          />
          <polygon
            points="26.46,123.69 26.61,122.49 27.08,121.37 27.81,120.41 28.77,119.68 29.89,119.21 31.09,119.06 41.67,119.06 42.87,119.21 43.98,119.68 44.94,120.41 45.68,121.37 46.14,122.49 46.3,123.69 46.3,134.27 46.14,135.47 45.68,136.58 44.94,137.54 43.98,138.28 42.87,138.74 41.67,138.9 31.09,138.9 29.89,138.74 28.77,138.28 27.81,137.54 27.08,136.58 26.61,135.47 26.46,134.27 "
            style="fill:url(#hatch2db9197d1dd34ec6a96c1df3c769c1f3);"
          />
          <polygon
            points="119.06,31.09 119.21,29.89 119.68,28.77 120.41,27.81 121.37,27.08 122.49,26.61 123.69,26.46 134.27,26.46 135.47,26.61 136.58,27.08 137.54,27.81 138.28,28.77 138.74,29.89 138.9,31.09 138.9,41.67 138.74,42.87 138.28,43.98 137.54,44.94 136.58,45.68 135.47,46.14 134.27,46.3 123.69,46.3 122.49,46.14 121.37,45.68 120.41,44.94 119.68,43.98 119.21,42.87 119.06,41.67 "
            style="fill:url(#hatch2db9197d1dd34ec6a96c1df3c769c1f3);"
          />
          <linearGradient
            id="gradiente627b093eb384267aa5f678537adf961"
            gradientUnits="userSpaceOnUse"
            x1="5.85921475478483"
            y1="73.2451025543645"
            x2="159.495105771338"
            y2="92.1092179717585"
          >
            <stop offset="0%" stop-color="#E5B9B7" />
            <stop offset="90%" stop-color="#8DB3E2" />
            <stop offset="100%" stop-color="#E5B9B7" />
          </linearGradient>
          <polygon
            points="79.37,15.54 79.55,14.66 80.05,13.91 80.8,13.4 81.69,13.23 86.05,13.23 86.05,19.91 79.37,19.91 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="85.92,16.54 85.92,13.23 92.66,13.23 92.66,19.84 85.92,19.84 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="92.53,13.23 96.9,13.23 97.78,13.4 98.53,13.91 99.04,14.66 99.21,15.54 99.21,19.91 92.53,19.91 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="66.14,22.16 66.32,21.27 66.82,20.52 67.57,20.02 68.46,19.84 72.82,19.84 72.82,26.46 68.46,26.46 67.57,26.28 66.82,25.78 66.32,25.03 66.14,24.14 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="72.69,23.15 72.69,19.84 79.44,19.84 79.44,26.46 72.69,26.46 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="79.3,23.15 79.3,19.78 85.98,19.78 85.98,26.52 79.3,26.52 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="92.6,23.15 92.6,19.78 99.21,19.78 99.21,26.52 92.6,26.52 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="79.37,26.39 86.05,26.39 86.05,33.07 81.69,33.07 80.8,32.89 80.05,32.39 79.55,31.64 79.37,30.76 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="85.92,29.76 85.92,26.46 92.66,26.46 92.66,33.07 85.92,33.07 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="92.53,29.76 92.53,26.39 99.21,26.39 99.21,33.14 92.53,33.14 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="66.14,35.39 66.32,34.5 66.82,33.75 67.57,33.25 68.46,33.07 72.82,33.07 72.82,39.69 68.46,39.69 67.57,39.51 66.82,39.01 66.32,38.26 66.14,37.37 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="72.69,33.07 77.06,33.07 77.94,33.25 78.69,33.75 79.19,34.5 79.37,35.39 79.37,39.75 72.69,39.75 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="92.6,36.38 92.6,33 99.21,33 99.21,39.75 92.6,39.75 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="72.76,39.62 79.37,39.62 79.37,43.98 79.19,44.87 78.69,45.62 77.94,46.12 77.06,46.3 75.07,46.3 74.18,46.12 73.43,45.62 72.93,44.87 72.76,43.98 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="92.6,39.62 99.21,39.62 99.21,43.98 99.04,44.87 98.53,45.62 97.78,46.12 96.9,46.3 94.91,46.3 94.03,46.12 93.28,45.62 92.77,44.87 92.6,43.98 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="66.14,48.61 66.32,47.73 66.82,46.98 67.57,46.48 68.46,46.3 70.44,46.3 71.33,46.48 72.08,46.98 72.58,47.73 72.76,48.61 72.76,52.98 66.14,52.98 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="85.98,48.61 86.16,47.73 86.66,46.98 87.41,46.48 88.3,46.3 90.28,46.3 91.17,46.48 91.92,46.98 92.42,47.73 92.6,48.61 92.6,50.6 92.42,51.48 91.92,52.24 91.17,52.74 90.28,52.91 88.3,52.91 87.41,52.74 86.66,52.24 86.16,51.48 85.98,50.6 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="66.14,52.85 72.76,52.85 72.76,57.21 72.58,58.1 72.08,58.85 71.33,59.35 70.44,59.53 68.46,59.53 67.57,59.35 66.82,58.85 66.32,58.1 66.14,57.21 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="79.37,55.23 79.55,54.34 80.05,53.59 80.8,53.09 81.69,52.91 83.67,52.91 84.56,53.09 85.31,53.59 85.81,54.34 85.98,55.23 85.98,57.21 85.81,58.1 85.31,58.85 84.56,59.35 83.67,59.53 81.69,59.53 80.8,59.35 80.05,58.85 79.55,58.1 79.37,57.21 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="92.6,55.23 92.77,54.34 93.28,53.59 94.03,53.09 94.91,52.91 96.9,52.91 97.78,53.09 98.53,53.59 99.04,54.34 99.21,55.23 99.21,57.21 99.04,58.1 98.53,58.85 97.78,59.35 96.9,59.53 94.91,59.53 94.03,59.35 93.28,58.85 92.77,58.1 92.6,57.21 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="72.76,61.84 72.93,60.96 73.43,60.21 74.18,59.7 75.07,59.53 77.06,59.53 77.94,59.7 78.69,60.21 79.19,60.96 79.37,61.84 79.37,63.83 79.19,64.71 78.69,65.46 77.94,65.97 77.06,66.14 75.07,66.14 74.18,65.97 73.43,65.46 72.93,64.71 72.76,63.83 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="13.23,68.46 13.4,67.57 13.91,66.82 14.66,66.32 15.54,66.14 19.91,66.14 19.91,72.82 13.23,72.82 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="19.78,69.45 19.78,66.14 26.52,66.14 26.52,72.82 19.78,72.82 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="26.39,69.45 26.39,66.14 33.14,66.14 33.14,72.82 26.39,72.82 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="33,69.45 33,66.14 39.75,66.14 39.75,72.76 33,72.76 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="39.62,66.14 43.98,66.14 44.87,66.32 45.62,66.82 46.12,67.57 46.3,68.46 46.3,70.44 46.12,71.33 45.62,72.08 44.87,72.58 43.98,72.76 39.62,72.76 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="52.91,68.46 53.09,67.57 53.59,66.82 54.34,66.32 55.23,66.14 59.59,66.14 59.59,72.76 55.23,72.76 54.34,72.58 53.59,72.08 53.09,71.33 52.91,70.44 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="59.46,69.45 59.46,66.14 66.21,66.14 66.21,72.82 59.46,72.82 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="66.08,66.14 70.44,66.14 71.33,66.32 72.08,66.82 72.58,67.57 72.76,68.46 72.76,70.44 72.58,71.33 72.08,72.08 71.33,72.58 70.44,72.76 66.08,72.76 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="85.98,68.46 86.16,67.57 86.66,66.82 87.41,66.32 88.3,66.14 90.28,66.14 91.17,66.32 91.92,66.82 92.42,67.57 92.6,68.46 92.6,72.82 85.98,72.82 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="99.21,68.46 99.39,67.57 99.89,66.82 100.64,66.32 101.53,66.14 103.51,66.14 104.4,66.32 105.15,66.82 105.65,67.57 105.83,68.46 105.83,72.82 99.21,72.82 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="112.44,68.46 112.62,67.57 113.12,66.82 113.87,66.32 114.76,66.14 116.74,66.14 117.63,66.32 118.38,66.82 118.88,67.57 119.06,68.46 119.06,70.44 118.88,71.33 118.38,72.08 117.63,72.58 116.74,72.76 114.76,72.76 113.87,72.58 113.12,72.08 112.62,71.33 112.44,70.44 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="125.67,68.46 125.85,67.57 126.35,66.82 127.1,66.32 127.98,66.14 129.97,66.14 130.85,66.32 131.61,66.82 132.11,67.57 132.28,68.46 132.28,72.82 125.67,72.82 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="138.9,68.46 139.07,67.57 139.58,66.82 140.33,66.32 141.21,66.14 143.2,66.14 144.08,66.32 144.83,66.82 145.34,67.57 145.51,68.46 145.51,72.82 138.9,72.82 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="13.23,72.69 19.91,72.69 19.91,79.37 15.54,79.37 14.66,79.19 13.91,78.69 13.4,77.94 13.23,77.06 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="19.78,76.06 19.78,72.69 26.52,72.69 26.52,79.37 19.78,79.37 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="26.39,76.06 26.39,72.69 33.07,72.69 33.07,79.44 26.39,79.44 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="46.3,75.07 46.48,74.18 46.98,73.43 47.73,72.93 48.61,72.76 50.6,72.76 51.48,72.93 52.24,73.43 52.74,74.18 52.91,75.07 52.91,79.44 46.3,79.44 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="59.53,72.69 66.14,72.69 66.14,77.06 65.97,77.94 65.46,78.69 64.71,79.19 63.83,79.37 61.84,79.37 60.96,79.19 60.21,78.69 59.7,77.94 59.53,77.06 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="72.76,75.07 72.93,74.18 73.43,73.43 74.18,72.93 75.07,72.76 77.06,72.76 77.94,72.93 78.69,73.43 79.19,74.18 79.37,75.07 79.37,79.44 72.76,79.44 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="85.98,72.69 92.66,72.69 92.66,79.37 88.3,79.37 87.41,79.19 86.66,78.69 86.16,77.94 85.98,77.06 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="92.53,76.06 92.53,72.76 99.28,72.76 99.28,79.44 92.53,79.44 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="99.15,76.06 99.15,72.69 105.89,72.69 105.89,79.37 99.15,79.37 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="105.76,72.76 110.13,72.76 111.01,72.93 111.76,73.43 112.26,74.18 112.44,75.07 112.44,79.44 105.76,79.44 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="125.67,76.06 125.67,72.69 132.35,72.69 132.35,79.44 125.67,79.44 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="132.22,76.06 132.22,72.76 138.96,72.76 138.96,79.37 132.22,79.37 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="138.83,76.06 138.83,72.69 145.58,72.69 145.58,79.37 138.83,79.37 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="145.45,72.76 149.81,72.76 150.7,72.93 151.45,73.43 151.95,74.18 152.13,75.07 152.13,79.44 145.45,79.44 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="26.46,79.3 33.07,79.3 33.07,83.67 32.89,84.56 32.39,85.31 31.64,85.81 30.76,85.98 28.77,85.98 27.89,85.81 27.13,85.31 26.63,84.56 26.46,83.67 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="39.69,81.69 39.86,80.8 40.36,80.05 41.11,79.55 42,79.37 46.37,79.37 46.37,85.98 42,85.98 41.11,85.81 40.36,85.31 39.86,84.56 39.69,83.67 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="46.23,82.68 46.23,79.3 52.98,79.3 52.98,85.98 46.23,85.98 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="52.85,79.37 57.21,79.37 58.1,79.55 58.85,80.05 59.35,80.8 59.53,81.69 59.53,83.67 59.35,84.56 58.85,85.31 58.1,85.81 57.21,85.98 52.85,85.98 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="66.14,81.69 66.32,80.8 66.82,80.05 67.57,79.55 68.46,79.37 72.82,79.37 72.82,85.98 68.46,85.98 67.57,85.81 66.82,85.31 66.32,84.56 66.14,83.67 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="72.69,79.3 79.37,79.3 79.37,83.67 79.19,84.56 78.69,85.31 77.94,85.81 77.06,85.98 72.69,85.98 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="92.6,82.68 92.6,79.3 99.21,79.3 99.21,86.05 92.6,86.05 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="105.83,82.68 105.83,79.3 112.51,79.3 112.51,86.05 105.83,86.05 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="112.37,79.37 116.74,79.37 117.63,79.55 118.38,80.05 118.88,80.8 119.06,81.69 119.06,83.67 118.88,84.56 118.38,85.31 117.63,85.81 116.74,85.98 112.37,85.98 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="125.67,79.3 132.28,79.3 132.28,83.67 132.11,84.56 131.61,85.31 130.85,85.81 129.97,85.98 127.98,85.98 127.1,85.81 126.35,85.31 125.85,84.56 125.67,83.67 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="145.51,82.68 145.51,79.3 152.13,79.3 152.13,86.05 145.51,86.05 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="13.23,88.3 13.4,87.41 13.91,86.66 14.66,86.16 15.54,85.98 17.53,85.98 18.41,86.16 19.16,86.66 19.67,87.41 19.84,88.3 19.84,90.28 19.67,91.17 19.16,91.92 18.41,92.42 17.53,92.6 15.54,92.6 14.66,92.42 13.91,91.92 13.4,91.17 13.23,90.28 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="33.07,88.3 33.25,87.41 33.75,86.66 34.5,86.16 35.39,85.98 37.37,85.98 38.26,86.16 39.01,86.66 39.51,87.41 39.69,88.3 39.69,92.66 33.07,92.66 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="85.98,88.3 86.16,87.41 86.66,86.66 87.41,86.16 88.3,85.98 92.66,85.98 92.66,92.6 88.3,92.6 87.41,92.42 86.66,91.92 86.16,91.17 85.98,90.28 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="92.53,89.29 92.53,85.92 99.28,85.92 99.28,92.66 92.53,92.66 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="99.15,89.29 99.15,85.98 105.89,85.98 105.89,92.6 99.15,92.6 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="105.76,85.92 112.44,85.92 112.44,90.28 112.26,91.17 111.76,91.92 111.01,92.42 110.13,92.6 105.76,92.6 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="132.28,88.3 132.46,87.41 132.96,86.66 133.71,86.16 134.6,85.98 138.96,85.98 138.96,92.6 134.6,92.6 133.71,92.42 132.96,91.92 132.46,91.17 132.28,90.28 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="138.83,89.29 138.83,85.98 145.58,85.98 145.58,92.66 138.83,92.66 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="145.45,85.92 152.13,85.92 152.13,90.28 151.95,91.17 151.45,91.92 150.7,92.42 149.81,92.6 145.45,92.6 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="19.84,94.91 20.02,94.03 20.52,93.28 21.27,92.77 22.16,92.6 24.14,92.6 25.03,92.77 25.78,93.28 26.28,94.03 26.46,94.91 26.46,96.9 26.28,97.78 25.78,98.53 25.03,99.04 24.14,99.21 22.16,99.21 21.27,99.04 20.52,98.53 20.02,97.78 19.84,96.9 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="33.07,92.53 39.75,92.53 39.75,99.21 35.39,99.21 34.5,99.04 33.75,98.53 33.25,97.78 33.07,96.9 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="39.62,92.6 43.98,92.6 44.87,92.77 45.62,93.28 46.12,94.03 46.3,94.91 46.3,96.9 46.12,97.78 45.62,98.53 44.87,99.04 43.98,99.21 39.62,99.21 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="52.91,94.91 53.09,94.03 53.59,93.28 54.34,92.77 55.23,92.6 57.21,92.6 58.1,92.77 58.85,93.28 59.35,94.03 59.53,94.91 59.53,96.9 59.35,97.78 58.85,98.53 58.1,99.04 57.21,99.21 55.23,99.21 54.34,99.04 53.59,98.53 53.09,97.78 52.91,96.9 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="66.14,94.91 66.32,94.03 66.82,93.28 67.57,92.77 68.46,92.6 72.82,92.6 72.82,99.28 66.14,99.28 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="72.69,92.6 77.06,92.6 77.94,92.77 78.69,93.28 79.19,94.03 79.37,94.91 79.37,96.9 79.19,97.78 78.69,98.53 77.94,99.04 77.06,99.21 72.69,99.21 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="92.6,95.91 92.6,92.53 99.21,92.53 99.21,99.28 92.6,99.28 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="112.44,94.91 112.62,94.03 113.12,93.28 113.87,92.77 114.76,92.6 116.74,92.6 117.63,92.77 118.38,93.28 118.88,94.03 119.06,94.91 119.06,99.28 112.44,99.28 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="138.9,92.53 145.51,92.53 145.51,96.9 145.34,97.78 144.83,98.53 144.08,99.04 143.2,99.21 141.21,99.21 140.33,99.04 139.58,98.53 139.07,97.78 138.9,96.9 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="66.14,102.52 66.14,99.15 72.76,99.15 72.76,105.89 66.14,105.89 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="79.37,101.53 79.55,100.64 80.05,99.89 80.8,99.39 81.69,99.21 83.67,99.21 84.56,99.39 85.31,99.89 85.81,100.64 85.98,101.53 85.98,103.51 85.81,104.4 85.31,105.15 84.56,105.65 83.67,105.83 81.69,105.83 80.8,105.65 80.05,105.15 79.55,104.4 79.37,103.51 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="92.6,99.15 99.21,99.15 99.21,103.51 99.04,104.4 98.53,105.15 97.78,105.65 96.9,105.83 94.91,105.83 94.03,105.65 93.28,105.15 92.77,104.4 92.6,103.51 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="112.44,99.15 119.06,99.15 119.06,103.51 118.88,104.4 118.38,105.15 117.63,105.65 116.74,105.83 114.76,105.83 113.87,105.65 113.12,105.15 112.62,104.4 112.44,103.51 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="132.28,101.53 132.46,100.64 132.96,99.89 133.71,99.39 134.6,99.21 136.58,99.21 137.47,99.39 138.22,99.89 138.72,100.64 138.9,101.53 138.9,103.51 138.72,104.4 138.22,105.15 137.47,105.65 136.58,105.83 134.6,105.83 133.71,105.65 132.96,105.15 132.46,104.4 132.28,103.51 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="66.14,105.76 72.76,105.76 72.76,110.13 72.58,111.01 72.08,111.76 71.33,112.26 70.44,112.44 68.46,112.44 67.57,112.26 66.82,111.76 66.32,111.01 66.14,110.13 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="85.98,108.14 86.16,107.26 86.66,106.5 87.41,106 88.3,105.83 90.28,105.83 91.17,106 91.92,106.5 92.42,107.26 92.6,108.14 92.6,110.13 92.42,111.01 91.92,111.76 91.17,112.26 90.28,112.44 88.3,112.44 87.41,112.26 86.66,111.76 86.16,111.01 85.98,110.13 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="99.21,108.14 99.39,107.26 99.89,106.5 100.64,106 101.53,105.83 103.51,105.83 104.4,106 105.15,106.5 105.65,107.26 105.83,108.14 105.83,110.13 105.65,111.01 105.15,111.76 104.4,112.26 103.51,112.44 101.53,112.44 100.64,112.26 99.89,111.76 99.39,111.01 99.21,110.13 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="119.06,108.14 119.23,107.26 119.73,106.5 120.48,106 121.37,105.83 125.74,105.83 125.74,112.51 119.06,112.51 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="125.6,105.83 129.97,105.83 130.85,106 131.61,106.5 132.11,107.26 132.28,108.14 132.28,110.13 132.11,111.01 131.61,111.76 130.85,112.26 129.97,112.44 125.6,112.44 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="138.9,108.14 139.07,107.26 139.58,106.5 140.33,106 141.21,105.83 145.58,105.83 145.58,112.44 141.21,112.44 140.33,112.26 139.58,111.76 139.07,111.01 138.9,110.13 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="145.45,105.83 149.81,105.83 150.7,106 151.45,106.5 151.95,107.26 152.13,108.14 152.13,112.51 145.45,112.51 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="72.76,114.76 72.93,113.87 73.43,113.12 74.18,112.62 75.07,112.44 79.44,112.44 79.44,119.12 72.76,119.12 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="79.3,112.44 83.67,112.44 84.56,112.62 85.31,113.12 85.81,113.87 85.98,114.76 85.98,119.12 79.3,119.12 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="112.44,114.76 112.62,113.87 113.12,113.12 113.87,112.62 114.76,112.44 119.12,112.44 119.12,119.06 114.76,119.06 113.87,118.88 113.12,118.38 112.62,117.63 112.44,116.74 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="118.99,115.75 118.99,112.37 125.67,112.37 125.67,119.12 118.99,119.12 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="132.28,114.76 132.46,113.87 132.96,113.12 133.71,112.62 134.6,112.44 136.58,112.44 137.47,112.62 138.22,113.12 138.72,113.87 138.9,114.76 138.9,119.12 132.28,119.12 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="145.51,112.37 152.13,112.37 152.13,116.74 151.95,117.63 151.45,118.38 150.7,118.88 149.81,119.06 147.83,119.06 146.94,118.88 146.19,118.38 145.69,117.63 145.51,116.74 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="66.14,121.37 66.32,120.48 66.82,119.73 67.57,119.23 68.46,119.06 72.82,119.06 72.82,125.74 66.14,125.74 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="72.69,122.36 72.69,118.99 79.44,118.99 79.44,125.74 72.69,125.74 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="79.3,122.36 79.3,118.99 86.05,118.99 86.05,125.67 79.3,125.67 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="85.92,119.06 90.28,119.06 91.17,119.23 91.92,119.73 92.42,120.48 92.6,121.37 92.6,125.74 85.92,125.74 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="99.21,121.37 99.39,120.48 99.89,119.73 100.64,119.23 101.53,119.06 103.51,119.06 104.4,119.23 105.15,119.73 105.65,120.48 105.83,121.37 105.83,125.74 99.21,125.74 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="119.06,118.99 125.74,118.99 125.74,125.67 121.37,125.67 120.48,125.49 119.73,124.99 119.23,124.24 119.06,123.35 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="125.6,122.36 125.6,119.06 132.35,119.06 132.35,125.74 125.6,125.74 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="132.22,122.36 132.22,118.99 138.9,118.99 138.9,125.74 132.22,125.74 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="66.14,128.98 66.14,125.6 72.82,125.6 72.82,132.35 66.14,132.35 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="72.69,128.98 72.69,125.6 79.37,125.6 79.37,132.35 72.69,132.35 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="85.98,125.6 92.66,125.6 92.66,132.28 88.3,132.28 87.41,132.11 86.66,131.61 86.16,130.85 85.98,129.97 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="92.53,128.98 92.53,125.67 99.28,125.67 99.28,132.35 92.53,132.35 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="99.15,128.98 99.15,125.6 105.89,125.6 105.89,132.28 99.15,132.28 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="105.76,128.98 105.76,125.67 112.51,125.67 112.51,132.35 105.76,132.35 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="112.37,125.67 116.74,125.67 117.63,125.85 118.38,126.35 118.88,127.1 119.06,127.98 119.06,132.35 112.37,132.35 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="125.67,128.98 125.67,125.6 132.35,125.6 132.35,132.35 125.67,132.35 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="132.22,128.98 132.22,125.6 138.9,125.6 138.9,132.35 132.22,132.35 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="66.14,135.59 66.14,132.22 72.82,132.22 72.82,138.96 66.14,138.96 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="72.69,132.22 79.37,132.22 79.37,136.58 79.19,137.47 78.69,138.22 77.94,138.72 77.06,138.9 72.69,138.9 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="92.6,135.59 92.6,132.22 99.21,132.22 99.21,138.96 92.6,138.96 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="105.83,135.59 105.83,132.22 112.51,132.22 112.51,138.96 105.83,138.96 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="112.37,135.59 112.37,132.22 119.06,132.22 119.06,138.96 112.37,138.96 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="125.67,132.22 132.35,132.22 132.35,138.9 127.98,138.9 127.1,138.72 126.35,138.22 125.85,137.47 125.67,136.58 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="132.22,135.59 132.22,132.22 138.9,132.22 138.9,138.96 132.22,138.96 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="66.14,142.2 66.14,138.83 72.76,138.83 72.76,145.58 66.14,145.58 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="79.37,141.21 79.55,140.33 80.05,139.58 80.8,139.07 81.69,138.9 86.05,138.9 86.05,145.58 79.37,145.58 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="85.92,142.2 85.92,138.9 92.66,138.9 92.66,145.51 85.92,145.51 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="92.53,142.2 92.53,138.83 99.28,138.83 99.28,145.58 92.53,145.58 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="99.15,142.2 99.15,138.9 105.89,138.9 105.89,145.51 99.15,145.51 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="105.76,142.2 105.76,138.83 112.51,138.83 112.51,145.51 105.76,145.51 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="112.37,142.2 112.37,138.83 119.12,138.83 119.12,145.58 112.37,145.58 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="118.99,138.9 123.35,138.9 124.24,139.07 124.99,139.58 125.49,140.33 125.67,141.21 125.67,143.2 125.49,144.08 124.99,144.83 124.24,145.34 123.35,145.51 118.99,145.51 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="132.28,142.2 132.28,138.83 138.96,138.83 138.96,145.58 132.28,145.58 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="138.83,138.9 143.2,138.9 144.08,139.07 144.83,139.58 145.34,140.33 145.51,141.21 145.51,143.2 145.34,144.08 144.83,144.83 144.08,145.34 143.2,145.51 138.83,145.51 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="66.14,145.45 72.82,145.45 72.82,152.13 68.46,152.13 67.57,151.95 66.82,151.45 66.32,150.7 66.14,149.81 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="72.69,148.82 72.69,145.51 79.44,145.51 79.44,152.13 72.69,152.13 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="79.3,145.45 85.98,145.45 85.98,149.81 85.81,150.7 85.31,151.45 84.56,151.95 83.67,152.13 79.3,152.13 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="92.6,145.45 99.21,145.45 99.21,149.81 99.04,150.7 98.53,151.45 97.78,151.95 96.9,152.13 94.91,152.13 94.03,151.95 93.28,151.45 92.77,150.7 92.6,149.81 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="112.44,145.45 119.06,145.45 119.06,149.81 118.88,150.7 118.38,151.45 117.63,151.95 116.74,152.13 114.76,152.13 113.87,151.95 113.12,151.45 112.62,150.7 112.44,149.81 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
          <polygon
            points="132.28,145.45 138.9,145.45 138.9,149.81 138.72,150.7 138.22,151.45 137.47,151.95 136.58,152.13 134.6,152.13 133.71,151.95 132.96,151.45 132.46,150.7 132.28,149.81 "
            style="fill:url(#gradiente627b093eb384267aa5f678537adf961);"
          />
      `,
            },
            {
                value: 23,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(37,86,99,1);"
            shape-rendering="crispEdges"
          />
          <pattern
            id="glassae3eb042472a405d96f6461eac120955"
            x="13.22835"
            y="13.22835"
            width="138.8976"
            height="138.8976"
            patternUnits="userSpaceOnUse"
          >
            <rect x="0" y="0" width="138.8976" height="138.8976" style="fill:rgb(219,238,243);fill-opacity:1;" />
            <rect x="0" y="0" width="138.8976" height="69.44881" style="fill:rgb(231,250,255);fill-opacity:1;" />
          </pattern>
          <polygon
            points="13.23,29.76 13.55,26.54 14.49,23.44 16.02,20.58 18.07,18.07 20.58,16.02 23.44,14.49 26.54,13.55 29.76,13.23 59.53,13.23 59.53,59.53 13.23,59.53 13.23,29.76 19.84,29.76 19.84,52.91 52.91,52.91 52.91,19.84 29.76,19.84 27.2,20.18 24.8,21.17 22.75,22.75 21.17,24.8 20.18,27.2 19.84,29.76 "
            style="fill:url(#glassae3eb042472a405d96f6461eac120955);"
          />
          <polygon
            points="13.23,122.36 13.23,105.83 59.53,105.83 59.53,152.13 29.76,152.13 26.54,151.81 23.44,150.87 20.58,149.34 18.07,147.28 16.02,144.78 14.49,141.92 13.55,138.82 13.23,135.59 13.23,122.36 19.84,122.36 19.84,135.59 20.18,138.16 21.17,140.55 22.75,142.61 24.8,144.18 27.2,145.17 29.76,145.51 52.91,145.51 52.91,112.44 19.84,112.44 19.84,122.36 "
            style="fill:url(#glassae3eb042472a405d96f6461eac120955);"
          />
          <polygon
            points="105.83,29.76 105.83,13.23 135.59,13.23 138.82,13.55 141.92,14.49 144.78,16.02 147.28,18.07 149.34,20.58 150.87,23.44 151.81,26.54 152.13,29.76 152.13,59.53 105.83,59.53 105.83,29.76 112.44,29.76 112.44,52.91 145.51,52.91 145.51,29.76 145.17,27.2 144.18,24.8 142.61,22.75 140.55,21.17 138.16,20.18 135.59,19.84 112.44,19.84 112.44,29.76 "
            style="fill:url(#glassae3eb042472a405d96f6461eac120955);"
          />
          <linearGradient
            id="gradienta7475673351c4aa69ee49c9489bed02a"
            gradientUnits="userSpaceOnUse"
            x1="22.0024585616932"
            y1="77.3688099608975"
            x2="143.351858149733"
            y2="87.9855067505283"
          >
            <stop offset="0%" stop-color="#93FFFF" />
            <stop offset="50%" stop-color="#7030A0" />
            <stop offset="100%" stop-color="#93FFFF" />
          </linearGradient>
          <polygon
            points="26.46,31.09 26.61,29.89 27.08,28.77 27.81,27.81 28.77,27.08 29.89,26.61 31.09,26.46 46.3,26.46 46.3,46.3 26.46,46.3 "
            style="fill:url(#gradienta7475673351c4aa69ee49c9489bed02a);"
          />
          <polygon
            points="26.46,119.06 46.3,119.06 46.3,138.9 31.09,138.9 29.89,138.74 28.77,138.28 27.81,137.54 27.08,136.58 26.61,135.47 26.46,134.27 "
            style="fill:url(#gradienta7475673351c4aa69ee49c9489bed02a);"
          />
          <polygon
            points="119.06,26.46 134.27,26.46 135.47,26.61 136.58,27.08 137.54,27.81 138.28,28.77 138.74,29.89 138.9,31.09 138.9,46.3 119.06,46.3 "
            style="fill:url(#gradienta7475673351c4aa69ee49c9489bed02a);"
          />
          <linearGradient
            id="gradient70fbdf3aa00f40a38c535d7a4bcd9a20"
            gradientUnits="userSpaceOnUse"
            x1="9.78888088478347"
            y1="78.8572474050841"
            x2="155.56543964134"
            y2="86.497073121039"
          >
            <stop offset="0%" stop-color="#B2A1C7" />
            <stop offset="100%" stop-color="#FFFFFF" />
          </linearGradient>
          <polygon
            points="79.37,16.54 82.68,13.23 85.98,16.54 82.68,19.84 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="85.98,16.54 89.29,13.23 92.6,16.54 89.29,19.84 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="92.6,16.54 95.91,13.23 99.21,16.54 95.91,19.84 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="66.14,23.15 69.45,19.84 72.76,23.15 69.45,26.46 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="72.76,23.15 76.06,19.84 79.37,23.15 76.06,26.46 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="79.37,23.15 82.68,19.84 85.98,23.15 82.68,26.46 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="92.6,23.15 95.91,19.84 99.21,23.15 95.91,26.46 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="79.37,29.76 82.68,26.46 85.98,29.76 82.68,33.07 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="85.98,29.76 89.29,26.46 92.6,29.76 89.29,33.07 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="92.6,29.76 95.91,26.46 99.21,29.76 95.91,33.07 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="66.14,36.38 69.45,33.07 72.76,36.38 69.45,39.69 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="72.76,36.38 76.06,33.07 79.37,36.38 76.06,39.69 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="92.6,36.38 95.91,33.07 99.21,36.38 95.91,39.69 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="72.76,42.99 76.06,39.69 79.37,42.99 76.06,46.3 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="92.6,42.99 95.91,39.69 99.21,42.99 95.91,46.3 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="66.14,49.61 69.45,46.3 72.76,49.61 69.45,52.91 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="85.98,49.61 89.29,46.3 92.6,49.61 89.29,52.91 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="66.14,56.22 69.45,52.91 72.76,56.22 69.45,59.53 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="79.37,56.22 82.68,52.91 85.98,56.22 82.68,59.53 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="92.6,56.22 95.91,52.91 99.21,56.22 95.91,59.53 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="72.76,62.83 76.06,59.53 79.37,62.83 76.06,66.14 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="13.23,69.45 16.54,66.14 19.84,69.45 16.54,72.76 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="19.84,69.45 23.15,66.14 26.46,69.45 23.15,72.76 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="26.46,69.45 29.76,66.14 33.07,69.45 29.76,72.76 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="33.07,69.45 36.38,66.14 39.69,69.45 36.38,72.76 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="39.69,69.45 42.99,66.14 46.3,69.45 42.99,72.76 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="52.91,69.45 56.22,66.14 59.53,69.45 56.22,72.76 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="59.53,69.45 62.83,66.14 66.14,69.45 62.83,72.76 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="66.14,69.45 69.45,66.14 72.76,69.45 69.45,72.76 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="85.98,69.45 89.29,66.14 92.6,69.45 89.29,72.76 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="99.21,69.45 102.52,66.14 105.83,69.45 102.52,72.76 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="112.44,69.45 115.75,66.14 119.06,69.45 115.75,72.76 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="125.67,69.45 128.98,66.14 132.28,69.45 128.98,72.76 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="138.9,69.45 142.2,66.14 145.51,69.45 142.2,72.76 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="13.23,76.06 16.54,72.76 19.84,76.06 16.54,79.37 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="19.84,76.06 23.15,72.76 26.46,76.06 23.15,79.37 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="26.46,76.06 29.76,72.76 33.07,76.06 29.76,79.37 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="46.3,76.06 49.61,72.76 52.91,76.06 49.61,79.37 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="59.53,76.06 62.83,72.76 66.14,76.06 62.83,79.37 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="72.76,76.06 76.06,72.76 79.37,76.06 76.06,79.37 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="85.98,76.06 89.29,72.76 92.6,76.06 89.29,79.37 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="92.6,76.06 95.91,72.76 99.21,76.06 95.91,79.37 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="99.21,76.06 102.52,72.76 105.83,76.06 102.52,79.37 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="105.83,76.06 109.13,72.76 112.44,76.06 109.13,79.37 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="125.67,76.06 128.98,72.76 132.28,76.06 128.98,79.37 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="132.28,76.06 135.59,72.76 138.9,76.06 135.59,79.37 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="138.9,76.06 142.2,72.76 145.51,76.06 142.2,79.37 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="145.51,76.06 148.82,72.76 152.13,76.06 148.82,79.37 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="26.46,82.68 29.76,79.37 33.07,82.68 29.76,85.98 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="39.69,82.68 42.99,79.37 46.3,82.68 42.99,85.98 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="46.3,82.68 49.61,79.37 52.91,82.68 49.61,85.98 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="52.91,82.68 56.22,79.37 59.53,82.68 56.22,85.98 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="66.14,82.68 69.45,79.37 72.76,82.68 69.45,85.98 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="72.76,82.68 76.06,79.37 79.37,82.68 76.06,85.98 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="92.6,82.68 95.91,79.37 99.21,82.68 95.91,85.98 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="105.83,82.68 109.13,79.37 112.44,82.68 109.13,85.98 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="112.44,82.68 115.75,79.37 119.06,82.68 115.75,85.98 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="125.67,82.68 128.98,79.37 132.28,82.68 128.98,85.98 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="145.51,82.68 148.82,79.37 152.13,82.68 148.82,85.98 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="13.23,89.29 16.54,85.98 19.84,89.29 16.54,92.6 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="33.07,89.29 36.38,85.98 39.69,89.29 36.38,92.6 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="85.98,89.29 89.29,85.98 92.6,89.29 89.29,92.6 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="92.6,89.29 95.91,85.98 99.21,89.29 95.91,92.6 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="99.21,89.29 102.52,85.98 105.83,89.29 102.52,92.6 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="105.83,89.29 109.13,85.98 112.44,89.29 109.13,92.6 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="132.28,89.29 135.59,85.98 138.9,89.29 135.59,92.6 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="138.9,89.29 142.2,85.98 145.51,89.29 142.2,92.6 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="145.51,89.29 148.82,85.98 152.13,89.29 148.82,92.6 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="19.84,95.91 23.15,92.6 26.46,95.91 23.15,99.21 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="33.07,95.91 36.38,92.6 39.69,95.91 36.38,99.21 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="39.69,95.91 42.99,92.6 46.3,95.91 42.99,99.21 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="52.91,95.91 56.22,92.6 59.53,95.91 56.22,99.21 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="66.14,95.91 69.45,92.6 72.76,95.91 69.45,99.21 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="72.76,95.91 76.06,92.6 79.37,95.91 76.06,99.21 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="92.6,95.91 95.91,92.6 99.21,95.91 95.91,99.21 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="112.44,95.91 115.75,92.6 119.06,95.91 115.75,99.21 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="138.9,95.91 142.2,92.6 145.51,95.91 142.2,99.21 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="66.14,102.52 69.45,99.21 72.76,102.52 69.45,105.83 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="79.37,102.52 82.68,99.21 85.98,102.52 82.68,105.83 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="92.6,102.52 95.91,99.21 99.21,102.52 95.91,105.83 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="112.44,102.52 115.75,99.21 119.06,102.52 115.75,105.83 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="132.28,102.52 135.59,99.21 138.9,102.52 135.59,105.83 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="66.14,109.13 69.45,105.83 72.76,109.13 69.45,112.44 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="85.98,109.13 89.29,105.83 92.6,109.13 89.29,112.44 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="99.21,109.13 102.52,105.83 105.83,109.13 102.52,112.44 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="119.06,109.13 122.36,105.83 125.67,109.13 122.36,112.44 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="125.67,109.13 128.98,105.83 132.28,109.13 128.98,112.44 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="138.9,109.13 142.2,105.83 145.51,109.13 142.2,112.44 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="145.51,109.13 148.82,105.83 152.13,109.13 148.82,112.44 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="72.76,115.75 76.06,112.44 79.37,115.75 76.06,119.06 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="79.37,115.75 82.68,112.44 85.98,115.75 82.68,119.06 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="112.44,115.75 115.75,112.44 119.06,115.75 115.75,119.06 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="119.06,115.75 122.36,112.44 125.67,115.75 122.36,119.06 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="132.28,115.75 135.59,112.44 138.9,115.75 135.59,119.06 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="145.51,115.75 148.82,112.44 152.13,115.75 148.82,119.06 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="66.14,122.36 69.45,119.06 72.76,122.36 69.45,125.67 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="72.76,122.36 76.06,119.06 79.37,122.36 76.06,125.67 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="79.37,122.36 82.68,119.06 85.98,122.36 82.68,125.67 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="85.98,122.36 89.29,119.06 92.6,122.36 89.29,125.67 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="99.21,122.36 102.52,119.06 105.83,122.36 102.52,125.67 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="119.06,122.36 122.36,119.06 125.67,122.36 122.36,125.67 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="125.67,122.36 128.98,119.06 132.28,122.36 128.98,125.67 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="132.28,122.36 135.59,119.06 138.9,122.36 135.59,125.67 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="66.14,128.98 69.45,125.67 72.76,128.98 69.45,132.28 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="72.76,128.98 76.06,125.67 79.37,128.98 76.06,132.28 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="85.98,128.98 89.29,125.67 92.6,128.98 89.29,132.28 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="92.6,128.98 95.91,125.67 99.21,128.98 95.91,132.28 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="99.21,128.98 102.52,125.67 105.83,128.98 102.52,132.28 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="105.83,128.98 109.13,125.67 112.44,128.98 109.13,132.28 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="112.44,128.98 115.75,125.67 119.06,128.98 115.75,132.28 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="125.67,128.98 128.98,125.67 132.28,128.98 128.98,132.28 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="132.28,128.98 135.59,125.67 138.9,128.98 135.59,132.28 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="66.14,135.59 69.45,132.28 72.76,135.59 69.45,138.9 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="72.76,135.59 76.06,132.28 79.37,135.59 76.06,138.9 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="92.6,135.59 95.91,132.28 99.21,135.59 95.91,138.9 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="105.83,135.59 109.13,132.28 112.44,135.59 109.13,138.9 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="112.44,135.59 115.75,132.28 119.06,135.59 115.75,138.9 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="125.67,135.59 128.98,132.28 132.28,135.59 128.98,138.9 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="132.28,135.59 135.59,132.28 138.9,135.59 135.59,138.9 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="66.14,142.2 69.45,138.9 72.76,142.2 69.45,145.51 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="79.37,142.2 82.68,138.9 85.98,142.2 82.68,145.51 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="85.98,142.2 89.29,138.9 92.6,142.2 89.29,145.51 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="92.6,142.2 95.91,138.9 99.21,142.2 95.91,145.51 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="99.21,142.2 102.52,138.9 105.83,142.2 102.52,145.51 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="105.83,142.2 109.13,138.9 112.44,142.2 109.13,145.51 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="112.44,142.2 115.75,138.9 119.06,142.2 115.75,145.51 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="119.06,142.2 122.36,138.9 125.67,142.2 122.36,145.51 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="132.28,142.2 135.59,138.9 138.9,142.2 135.59,145.51 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="138.9,142.2 142.2,138.9 145.51,142.2 142.2,145.51 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="66.14,148.82 69.45,145.51 72.76,148.82 69.45,152.13 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="72.76,148.82 76.06,145.51 79.37,148.82 76.06,152.13 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="79.37,148.82 82.68,145.51 85.98,148.82 82.68,152.13 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="92.6,148.82 95.91,145.51 99.21,148.82 95.91,152.13 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="112.44,148.82 115.75,145.51 119.06,148.82 115.75,152.13 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
          <polygon
            points="132.28,148.82 135.59,145.51 138.9,148.82 135.59,152.13 "
            style="fill:url(#gradient70fbdf3aa00f40a38c535d7a4bcd9a20);"
          />
      `,
            },
            {
                value: 24,
                innerHtml: `
      <rect
            x="0"
            y="0"
            width="165.3543"
            height="165.3543"
            fill="red"
            style="fill:rgba(37,86,99,1);"
            shape-rendering="crispEdges"
          />
          <pattern
            id="hatchad53d08ec2bb4d06b2513bb3a3c22ff9"
            x="0"
            y="0"
            width="8"
            height="8"
            patternUnits="userSpaceOnUse"
          >
            <rect x="0" y="0" width="8" height="8" fill="#B2A1C7" />
            <rect x="3" y="0" width="1" height="1" fill="#B8CCE4" />
            <rect x="7" y="0" width="1" height="1" fill="#B8CCE4" />
            <rect x="2" y="1" width="1" height="1" fill="#B8CCE4" />
            <rect x="6" y="1" width="1" height="1" fill="#B8CCE4" />
            <rect x="1" y="2" width="1" height="1" fill="#B8CCE4" />
            <rect x="5" y="2" width="1" height="1" fill="#B8CCE4" />
            <rect x="0" y="3" width="1" height="1" fill="#B8CCE4" />
            <rect x="4" y="3" width="1" height="1" fill="#B8CCE4" />
          </pattern>
          <polygon
            points="59.53,36.38 59.08,40.89 57.77,45.24 55.63,49.24 52.75,52.75 49.24,55.63 45.24,57.77 40.89,59.08 36.38,59.53 31.86,59.08 27.52,57.77 23.52,55.63 20.01,52.75 17.13,49.24 14.99,45.24 13.67,40.89 13.23,36.38 13.67,31.86 14.99,27.52 17.13,23.52 20.01,20.01 23.52,17.13 27.52,14.99 31.86,13.67 36.38,13.23 40.89,13.67 45.24,14.99 49.24,17.13 52.75,20.01 55.63,23.52 57.77,27.52 59.08,31.86 59.53,36.38 52.91,36.38 52.6,33.15 51.65,30.05 50.13,27.19 48.07,24.69 45.56,22.63 42.71,21.1 39.6,20.16 36.38,19.84 33.15,20.16 30.05,21.1 27.19,22.63 24.69,24.69 22.63,27.19 21.1,30.05 20.16,33.15 19.84,36.38 20.16,39.6 21.1,42.71 22.63,45.56 24.69,48.07 27.19,50.13 30.05,51.65 33.15,52.6 36.38,52.91 39.6,52.6 42.71,51.65 45.56,50.13 48.07,48.07 50.13,45.56 51.65,42.71 52.6,39.6 52.91,36.38 "
            style="fill:url(#hatchad53d08ec2bb4d06b2513bb3a3c22ff9);"
          />
          <polygon
            points="59.53,128.98 59.08,133.49 57.77,137.84 55.63,141.84 52.75,145.35 49.24,148.22 45.24,150.36 40.89,151.68 36.38,152.13 31.86,151.68 27.52,150.36 23.52,148.22 20.01,145.35 17.13,141.84 14.99,137.84 13.67,133.49 13.23,128.98 13.67,124.46 14.99,120.12 17.13,116.12 20.01,112.61 23.52,109.73 27.52,107.59 31.86,106.27 36.38,105.83 40.89,106.27 45.24,107.59 49.24,109.73 52.75,112.61 55.63,116.12 57.77,120.12 59.08,124.46 59.53,128.98 52.91,128.98 52.6,125.75 51.65,122.65 50.13,119.79 48.07,117.28 45.56,115.23 42.71,113.7 39.6,112.76 36.38,112.44 33.15,112.76 30.05,113.7 27.19,115.23 24.69,117.28 22.63,119.79 21.1,122.65 20.16,125.75 19.84,128.98 20.16,132.2 21.1,135.3 22.63,138.16 24.69,140.67 27.19,142.73 30.05,144.25 33.15,145.19 36.38,145.51 39.6,145.19 42.71,144.25 45.56,142.73 48.07,140.67 50.13,138.16 51.65,135.3 52.6,132.2 52.91,128.98 "
            style="fill:url(#hatchad53d08ec2bb4d06b2513bb3a3c22ff9);"
          />
          <polygon
            points="152.13,36.38 151.68,40.89 150.36,45.24 148.22,49.24 145.35,52.75 141.84,55.63 137.84,57.77 133.49,59.08 128.98,59.53 124.46,59.08 120.12,57.77 116.12,55.63 112.61,52.75 109.73,49.24 107.59,45.24 106.27,40.89 105.83,36.38 106.27,31.86 107.59,27.52 109.73,23.52 112.61,20.01 116.12,17.13 120.12,14.99 124.46,13.67 128.98,13.23 133.49,13.67 137.84,14.99 141.84,17.13 145.35,20.01 148.22,23.52 150.36,27.52 151.68,31.86 152.13,36.38 145.51,36.38 145.19,33.15 144.25,30.05 142.73,27.19 140.67,24.69 138.16,22.63 135.3,21.1 132.2,20.16 128.98,19.84 125.75,20.16 122.65,21.1 119.79,22.63 117.28,24.69 115.23,27.19 113.7,30.05 112.76,33.15 112.44,36.38 112.76,39.6 113.7,42.71 115.23,45.56 117.28,48.07 119.79,50.13 122.65,51.65 125.75,52.6 128.98,52.91 132.2,52.6 135.3,51.65 138.16,50.13 140.67,48.07 142.73,45.56 144.25,42.71 145.19,39.6 145.51,36.38 "
            style="fill:url(#hatchad53d08ec2bb4d06b2513bb3a3c22ff9);"
          />
          <linearGradient
            id="gradientfaf3a21afc704938bc9ffddae142b7dd"
            gradientUnits="userSpaceOnUse"
            x1="24.8031482696533"
            y1="82.0984210968018"
            x2="140.551179885864"
            y2="82.0984210968018"
          >
            <stop offset="0%" stop-color="#00B0F0" />
            <stop offset="100%" stop-color="#E5E0EC" />
          </linearGradient>
          <polygon
            points="24.8,33.95 25.15,33.14 26.54,32.33 31.98,31.29 34.41,25.96 35.1,25.15 36.03,24.8 36.73,25.03 37.54,25.84 40.08,30.94 45.29,31.75 47.14,32.56 47.95,33.72 47.72,34.76 46.8,35.8 42.28,38.46 44.02,43.67 44.13,45.17 43.79,46.22 42.98,46.68 42.05,46.56 36.03,42.51 31.86,46.33 30.82,46.8 29.9,46.68 29.2,45.99 28.97,44.94 30.13,38.58 25.73,35.57 25.03,34.87 "
            style="fill:url(#gradientfaf3a21afc704938bc9ffddae142b7dd);"
          />
          <polygon
            points="24.8,126.55 25.15,125.74 26.54,124.93 31.98,123.88 34.41,118.56 35.1,117.75 36.03,117.4 36.73,117.63 37.54,118.44 40.08,123.54 45.29,124.35 47.14,125.16 47.95,126.31 47.72,127.36 46.8,128.4 42.28,131.06 44.02,136.27 44.13,137.77 43.79,138.81 42.98,139.28 42.05,139.16 36.03,135.11 31.86,138.93 30.82,139.39 29.9,139.28 29.2,138.58 28.97,137.54 30.13,131.18 25.73,128.17 25.03,127.47 "
            style="fill:url(#gradientfaf3a21afc704938bc9ffddae142b7dd);"
          />
          <polygon
            points="117.4,33.95 117.75,33.14 119.14,32.33 124.58,31.29 127.01,25.96 127.7,25.15 128.63,24.8 129.32,25.03 130.13,25.84 132.68,30.94 137.89,31.75 139.74,32.56 140.55,33.72 140.32,34.76 139.39,35.8 134.88,38.46 136.62,43.67 136.73,45.17 136.38,46.22 135.57,46.68 134.65,46.56 128.63,42.51 124.46,46.33 123.42,46.8 122.49,46.68 121.8,45.99 121.57,44.94 122.73,38.58 118.33,35.57 117.63,34.87 "
            style="fill:url(#gradientfaf3a21afc704938bc9ffddae142b7dd);"
          />
          <linearGradient
            id="gradientffcbed388ab34855992a9fd38824ed9b"
            gradientUnits="userSpaceOnUse"
            x1="9.8216375862194"
            y1="78.893629314992"
            x2="154.209852739708"
            y2="86.4606950258283"
          >
            <stop offset="0%" stop-color="#FF2864" />
            <stop offset="50%" stop-color="#92D750" />
            <stop offset="100%" stop-color="#FF2864" />
          </linearGradient>
          <polygon
            points="82.02,19.18 81,18.98 80.14,18.41 79.57,17.55 79.37,16.54 79.57,15.52 80.14,14.66 81,14.09 82.02,13.89 95.24,13.89 96.26,14.09 97.11,14.66 97.69,15.52 97.89,16.54 97.69,17.55 97.11,18.41 96.26,18.98 95.24,19.18 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="68.79,25.8 67.77,25.59 66.92,25.02 66.34,24.16 66.14,23.15 66.34,22.14 66.92,21.28 67.77,20.71 68.79,20.5 82.02,20.5 83.03,20.71 83.89,21.28 84.46,22.14 84.66,23.15 84.46,24.16 83.89,25.02 83.03,25.59 82.02,25.8 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="95.24,25.8 94.23,25.59 93.37,25.02 92.8,24.16 92.6,23.15 92.8,22.14 93.37,21.28 94.23,20.71 95.24,20.5 95.24,20.5 96.26,20.71 97.11,21.28 97.69,22.14 97.89,23.15 97.69,24.16 97.11,25.02 96.26,25.59 95.24,25.8 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="82.02,32.41 81,32.21 80.14,31.63 79.57,30.78 79.37,29.76 79.57,28.75 80.14,27.89 81,27.32 82.02,27.12 95.24,27.12 96.26,27.32 97.11,27.89 97.69,28.75 97.89,29.76 97.69,30.78 97.11,31.63 96.26,32.21 95.24,32.41 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="68.79,39.02 67.77,38.82 66.92,38.25 66.34,37.39 66.14,36.38 66.34,35.37 66.92,34.51 67.77,33.93 68.79,33.73 75.4,33.73 76.41,33.93 77.27,34.51 77.85,35.37 78.05,36.38 77.85,37.39 77.27,38.25 76.41,38.82 75.4,39.02 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="95.24,39.02 94.23,38.82 93.37,38.25 92.8,37.39 92.6,36.38 92.8,35.37 93.37,34.51 94.23,33.93 95.24,33.73 95.24,33.73 96.26,33.93 97.11,34.51 97.69,35.37 97.89,36.38 97.69,37.39 97.11,38.25 96.26,38.82 95.24,39.02 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="75.4,45.64 74.39,45.44 73.53,44.86 72.96,44 72.76,42.99 72.96,41.98 73.53,41.12 74.39,40.55 75.4,40.35 75.4,40.35 76.41,40.55 77.27,41.12 77.85,41.98 78.05,42.99 77.85,44 77.27,44.86 76.41,45.44 75.4,45.64 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="95.24,45.64 94.23,45.44 93.37,44.86 92.8,44 92.6,42.99 92.8,41.98 93.37,41.12 94.23,40.55 95.24,40.35 95.24,40.35 96.26,40.55 97.11,41.12 97.69,41.98 97.89,42.99 97.69,44 97.11,44.86 96.26,45.44 95.24,45.64 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="68.79,52.25 67.77,52.05 66.92,51.48 66.34,50.62 66.14,49.61 66.34,48.59 66.92,47.74 67.77,47.16 68.79,46.96 68.79,46.96 69.8,47.16 70.66,47.74 71.23,48.59 71.43,49.61 71.23,50.62 70.66,51.48 69.8,52.05 68.79,52.25 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="88.63,52.25 87.62,52.05 86.76,51.48 86.19,50.62 85.98,49.61 86.19,48.59 86.76,47.74 87.62,47.16 88.63,46.96 88.63,46.96 89.64,47.16 90.5,47.74 91.07,48.59 91.28,49.61 91.07,50.62 90.5,51.48 89.64,52.05 88.63,52.25 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="68.79,58.87 67.77,58.66 66.92,58.09 66.34,57.23 66.14,56.22 66.34,55.21 66.92,54.35 67.77,53.78 68.79,53.57 68.79,53.57 69.8,53.78 70.66,54.35 71.23,55.21 71.43,56.22 71.23,57.23 70.66,58.09 69.8,58.66 68.79,58.87 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="82.02,58.87 81,58.66 80.14,58.09 79.57,57.23 79.37,56.22 79.57,55.21 80.14,54.35 81,53.78 82.02,53.57 82.02,53.57 83.03,53.78 83.89,54.35 84.46,55.21 84.66,56.22 84.46,57.23 83.89,58.09 83.03,58.66 82.02,58.87 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="95.24,58.87 94.23,58.66 93.37,58.09 92.8,57.23 92.6,56.22 92.8,55.21 93.37,54.35 94.23,53.78 95.24,53.57 95.24,53.57 96.26,53.78 97.11,54.35 97.69,55.21 97.89,56.22 97.69,57.23 97.11,58.09 96.26,58.66 95.24,58.87 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="75.4,65.48 74.39,65.28 73.53,64.71 72.96,63.85 72.76,62.83 72.96,61.82 73.53,60.96 74.39,60.39 75.4,60.19 75.4,60.19 76.41,60.39 77.27,60.96 77.85,61.82 78.05,62.83 77.85,63.85 77.27,64.71 76.41,65.28 75.4,65.48 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="15.87,72.09 14.86,71.89 14,71.32 13.43,70.46 13.23,69.45 13.43,68.44 14,67.58 14.86,67 15.87,66.8 42.33,66.8 43.34,67 44.2,67.58 44.77,68.44 44.98,69.45 44.77,70.46 44.2,71.32 43.34,71.89 42.33,72.09 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="55.56,72.09 54.55,71.89 53.69,71.32 53.11,70.46 52.91,69.45 53.11,68.44 53.69,67.58 54.55,67 55.56,66.8 68.79,66.8 69.8,67 70.66,67.58 71.23,68.44 71.43,69.45 71.23,70.46 70.66,71.32 69.8,71.89 68.79,72.09 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="88.63,72.09 87.62,71.89 86.76,71.32 86.19,70.46 85.98,69.45 86.19,68.44 86.76,67.58 87.62,67 88.63,66.8 88.63,66.8 89.64,67 90.5,67.58 91.07,68.44 91.28,69.45 91.07,70.46 90.5,71.32 89.64,71.89 88.63,72.09 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="101.86,72.09 100.85,71.89 99.99,71.32 99.41,70.46 99.21,69.45 99.41,68.44 99.99,67.58 100.85,67 101.86,66.8 101.86,66.8 102.87,67 103.73,67.58 104.3,68.44 104.5,69.45 104.3,70.46 103.73,71.32 102.87,71.89 101.86,72.09 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="115.09,72.09 114.07,71.89 113.22,71.32 112.64,70.46 112.44,69.45 112.64,68.44 113.22,67.58 114.07,67 115.09,66.8 115.09,66.8 116.1,67 116.96,67.58 117.53,68.44 117.73,69.45 117.53,70.46 116.96,71.32 116.1,71.89 115.09,72.09 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="128.31,72.09 127.3,71.89 126.44,71.32 125.87,70.46 125.67,69.45 125.87,68.44 126.44,67.58 127.3,67 128.31,66.8 128.31,66.8 129.33,67 130.19,67.58 130.76,68.44 130.96,69.45 130.76,70.46 130.19,71.32 129.33,71.89 128.31,72.09 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="141.54,72.09 140.53,71.89 139.67,71.32 139.1,70.46 138.9,69.45 139.1,68.44 139.67,67.58 140.53,67 141.54,66.8 141.54,66.8 142.56,67 143.41,67.58 143.99,68.44 144.19,69.45 143.99,70.46 143.41,71.32 142.56,71.89 141.54,72.09 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="15.87,78.71 14.86,78.51 14,77.93 13.43,77.08 13.23,76.06 13.43,75.05 14,74.19 14.86,73.62 15.87,73.42 29.1,73.42 30.11,73.62 30.97,74.19 31.55,75.05 31.75,76.06 31.55,77.08 30.97,77.93 30.11,78.51 29.1,78.71 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="48.94,78.71 47.93,78.51 47.07,77.93 46.5,77.08 46.3,76.06 46.5,75.05 47.07,74.19 47.93,73.62 48.94,73.42 48.94,73.42 49.96,73.62 50.82,74.19 51.39,75.05 51.59,76.06 51.39,77.08 50.82,77.93 49.96,78.51 48.94,78.71 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="62.17,78.71 61.16,78.51 60.3,77.93 59.73,77.08 59.53,76.06 59.73,75.05 60.3,74.19 61.16,73.62 62.17,73.42 62.17,73.42 63.19,73.62 64.04,74.19 64.62,75.05 64.82,76.06 64.62,77.08 64.04,77.93 63.19,78.51 62.17,78.71 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="75.4,78.71 74.39,78.51 73.53,77.93 72.96,77.08 72.76,76.06 72.96,75.05 73.53,74.19 74.39,73.62 75.4,73.42 75.4,73.42 76.41,73.62 77.27,74.19 77.85,75.05 78.05,76.06 77.85,77.08 77.27,77.93 76.41,78.51 75.4,78.71 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="88.63,78.71 87.62,78.51 86.76,77.93 86.19,77.08 85.98,76.06 86.19,75.05 86.76,74.19 87.62,73.62 88.63,73.42 108.47,73.42 109.48,73.62 110.34,74.19 110.92,75.05 111.12,76.06 110.92,77.08 110.34,77.93 109.48,78.51 108.47,78.71 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="128.31,78.71 127.3,78.51 126.44,77.93 125.87,77.08 125.67,76.06 125.87,75.05 126.44,74.19 127.3,73.62 128.31,73.42 148.16,73.42 149.17,73.62 150.03,74.19 150.6,75.05 150.8,76.06 150.6,77.08 150.03,77.93 149.17,78.51 148.16,78.71 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="29.1,85.32 28.09,85.12 27.23,84.55 26.66,83.69 26.46,82.68 26.66,81.66 27.23,80.81 28.09,80.23 29.1,80.03 29.1,80.03 30.11,80.23 30.97,80.81 31.55,81.66 31.75,82.68 31.55,83.69 30.97,84.55 30.11,85.12 29.1,85.32 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="42.33,85.32 41.32,85.12 40.46,84.55 39.89,83.69 39.69,82.68 39.89,81.66 40.46,80.81 41.32,80.23 42.33,80.03 55.56,80.03 56.57,80.23 57.43,80.81 58,81.66 58.2,82.68 58,83.69 57.43,84.55 56.57,85.12 55.56,85.32 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="68.79,85.32 67.77,85.12 66.92,84.55 66.34,83.69 66.14,82.68 66.34,81.66 66.92,80.81 67.77,80.23 68.79,80.03 75.4,80.03 76.41,80.23 77.27,80.81 77.85,81.66 78.05,82.68 77.85,83.69 77.27,84.55 76.41,85.12 75.4,85.32 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="95.24,85.32 94.23,85.12 93.37,84.55 92.8,83.69 92.6,82.68 92.8,81.66 93.37,80.81 94.23,80.23 95.24,80.03 95.24,80.03 96.26,80.23 97.11,80.81 97.69,81.66 97.89,82.68 97.69,83.69 97.11,84.55 96.26,85.12 95.24,85.32 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="108.47,85.32 107.46,85.12 106.6,84.55 106.03,83.69 105.83,82.68 106.03,81.66 106.6,80.81 107.46,80.23 108.47,80.03 115.09,80.03 116.1,80.23 116.96,80.81 117.53,81.66 117.73,82.68 117.53,83.69 116.96,84.55 116.1,85.12 115.09,85.32 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="128.31,85.32 127.3,85.12 126.44,84.55 125.87,83.69 125.67,82.68 125.87,81.66 126.44,80.81 127.3,80.23 128.31,80.03 128.31,80.03 129.33,80.23 130.19,80.81 130.76,81.66 130.96,82.68 130.76,83.69 130.19,84.55 129.33,85.12 128.31,85.32 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="148.16,85.32 147.15,85.12 146.29,84.55 145.71,83.69 145.51,82.68 145.71,81.66 146.29,80.81 147.15,80.23 148.16,80.03 148.16,80.03 149.17,80.23 150.03,80.81 150.6,81.66 150.8,82.68 150.6,83.69 150.03,84.55 149.17,85.12 148.16,85.32 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="15.87,91.94 14.86,91.74 14,91.16 13.43,90.3 13.23,89.29 13.43,88.28 14,87.42 14.86,86.85 15.87,86.65 15.87,86.65 16.89,86.85 17.74,87.42 18.32,88.28 18.52,89.29 18.32,90.3 17.74,91.16 16.89,91.74 15.87,91.94 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="35.72,91.94 34.7,91.74 33.85,91.16 33.27,90.3 33.07,89.29 33.27,88.28 33.85,87.42 34.7,86.85 35.72,86.65 35.72,86.65 36.73,86.85 37.59,87.42 38.16,88.28 38.36,89.29 38.16,90.3 37.59,91.16 36.73,91.74 35.72,91.94 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="88.63,91.94 87.62,91.74 86.76,91.16 86.19,90.3 85.98,89.29 86.19,88.28 86.76,87.42 87.62,86.85 88.63,86.65 108.47,86.65 109.48,86.85 110.34,87.42 110.92,88.28 111.12,89.29 110.92,90.3 110.34,91.16 109.48,91.74 108.47,91.94 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="134.93,91.94 133.92,91.74 133.06,91.16 132.48,90.3 132.28,89.29 132.48,88.28 133.06,87.42 133.92,86.85 134.93,86.65 148.16,86.65 149.17,86.85 150.03,87.42 150.6,88.28 150.8,89.29 150.6,90.3 150.03,91.16 149.17,91.74 148.16,91.94 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="22.49,98.55 21.48,98.35 20.62,97.78 20.04,96.92 19.84,95.91 20.04,94.89 20.62,94.03 21.48,93.46 22.49,93.26 22.49,93.26 23.5,93.46 24.36,94.03 24.93,94.89 25.13,95.91 24.93,96.92 24.36,97.78 23.5,98.35 22.49,98.55 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="35.72,98.55 34.7,98.35 33.85,97.78 33.27,96.92 33.07,95.91 33.27,94.89 33.85,94.03 34.7,93.46 35.72,93.26 42.33,93.26 43.34,93.46 44.2,94.03 44.77,94.89 44.98,95.91 44.77,96.92 44.2,97.78 43.34,98.35 42.33,98.55 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="55.56,98.55 54.55,98.35 53.69,97.78 53.11,96.92 52.91,95.91 53.11,94.89 53.69,94.03 54.55,93.46 55.56,93.26 55.56,93.26 56.57,93.46 57.43,94.03 58,94.89 58.2,95.91 58,96.92 57.43,97.78 56.57,98.35 55.56,98.55 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="68.79,98.55 67.77,98.35 66.92,97.78 66.34,96.92 66.14,95.91 66.34,94.89 66.92,94.03 67.77,93.46 68.79,93.26 75.4,93.26 76.41,93.46 77.27,94.03 77.85,94.89 78.05,95.91 77.85,96.92 77.27,97.78 76.41,98.35 75.4,98.55 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="95.24,98.55 94.23,98.35 93.37,97.78 92.8,96.92 92.6,95.91 92.8,94.89 93.37,94.03 94.23,93.46 95.24,93.26 95.24,93.26 96.26,93.46 97.11,94.03 97.69,94.89 97.89,95.91 97.69,96.92 97.11,97.78 96.26,98.35 95.24,98.55 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="115.09,98.55 114.07,98.35 113.22,97.78 112.64,96.92 112.44,95.91 112.64,94.89 113.22,94.03 114.07,93.46 115.09,93.26 115.09,93.26 116.1,93.46 116.96,94.03 117.53,94.89 117.73,95.91 117.53,96.92 116.96,97.78 116.1,98.35 115.09,98.55 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="141.54,98.55 140.53,98.35 139.67,97.78 139.1,96.92 138.9,95.91 139.1,94.89 139.67,94.03 140.53,93.46 141.54,93.26 141.54,93.26 142.56,93.46 143.41,94.03 143.99,94.89 144.19,95.91 143.99,96.92 143.41,97.78 142.56,98.35 141.54,98.55 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="68.79,105.17 67.77,104.96 66.92,104.39 66.34,103.53 66.14,102.52 66.34,101.51 66.92,100.65 67.77,100.08 68.79,99.87 68.79,99.87 69.8,100.08 70.66,100.65 71.23,101.51 71.43,102.52 71.23,103.53 70.66,104.39 69.8,104.96 68.79,105.17 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="82.02,105.17 81,104.96 80.14,104.39 79.57,103.53 79.37,102.52 79.57,101.51 80.14,100.65 81,100.08 82.02,99.87 82.02,99.87 83.03,100.08 83.89,100.65 84.46,101.51 84.66,102.52 84.46,103.53 83.89,104.39 83.03,104.96 82.02,105.17 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="95.24,105.17 94.23,104.96 93.37,104.39 92.8,103.53 92.6,102.52 92.8,101.51 93.37,100.65 94.23,100.08 95.24,99.87 95.24,99.87 96.26,100.08 97.11,100.65 97.69,101.51 97.89,102.52 97.69,103.53 97.11,104.39 96.26,104.96 95.24,105.17 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="115.09,105.17 114.07,104.96 113.22,104.39 112.64,103.53 112.44,102.52 112.64,101.51 113.22,100.65 114.07,100.08 115.09,99.87 115.09,99.87 116.1,100.08 116.96,100.65 117.53,101.51 117.73,102.52 117.53,103.53 116.96,104.39 116.1,104.96 115.09,105.17 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="134.93,105.17 133.92,104.96 133.06,104.39 132.48,103.53 132.28,102.52 132.48,101.51 133.06,100.65 133.92,100.08 134.93,99.87 134.93,99.87 135.94,100.08 136.8,100.65 137.37,101.51 137.57,102.52 137.37,103.53 136.8,104.39 135.94,104.96 134.93,105.17 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="68.79,111.78 67.77,111.58 66.92,111 66.34,110.15 66.14,109.13 66.34,108.12 66.92,107.26 67.77,106.69 68.79,106.49 68.79,106.49 69.8,106.69 70.66,107.26 71.23,108.12 71.43,109.13 71.23,110.15 70.66,111 69.8,111.58 68.79,111.78 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="88.63,111.78 87.62,111.58 86.76,111 86.19,110.15 85.98,109.13 86.19,108.12 86.76,107.26 87.62,106.69 88.63,106.49 88.63,106.49 89.64,106.69 90.5,107.26 91.07,108.12 91.28,109.13 91.07,110.15 90.5,111 89.64,111.58 88.63,111.78 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="101.86,111.78 100.85,111.58 99.99,111 99.41,110.15 99.21,109.13 99.41,108.12 99.99,107.26 100.85,106.69 101.86,106.49 101.86,106.49 102.87,106.69 103.73,107.26 104.3,108.12 104.5,109.13 104.3,110.15 103.73,111 102.87,111.58 101.86,111.78 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="121.7,111.78 120.69,111.58 119.83,111 119.26,110.15 119.06,109.13 119.26,108.12 119.83,107.26 120.69,106.69 121.7,106.49 128.31,106.49 129.33,106.69 130.19,107.26 130.76,108.12 130.96,109.13 130.76,110.15 130.19,111 129.33,111.58 128.31,111.78 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="141.54,111.78 140.53,111.58 139.67,111 139.1,110.15 138.9,109.13 139.1,108.12 139.67,107.26 140.53,106.69 141.54,106.49 148.16,106.49 149.17,106.69 150.03,107.26 150.6,108.12 150.8,109.13 150.6,110.15 150.03,111 149.17,111.58 148.16,111.78 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="75.4,118.39 74.39,118.19 73.53,117.62 72.96,116.76 72.76,115.75 72.96,114.74 73.53,113.88 74.39,113.3 75.4,113.1 82.02,113.1 83.03,113.3 83.89,113.88 84.46,114.74 84.66,115.75 84.46,116.76 83.89,117.62 83.03,118.19 82.02,118.39 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="115.09,118.39 114.07,118.19 113.22,117.62 112.64,116.76 112.44,115.75 112.64,114.74 113.22,113.88 114.07,113.3 115.09,113.1 121.7,113.1 122.71,113.3 123.57,113.88 124.15,114.74 124.35,115.75 124.15,116.76 123.57,117.62 122.71,118.19 121.7,118.39 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="134.93,118.39 133.92,118.19 133.06,117.62 132.48,116.76 132.28,115.75 132.48,114.74 133.06,113.88 133.92,113.3 134.93,113.1 134.93,113.1 135.94,113.3 136.8,113.88 137.37,114.74 137.57,115.75 137.37,116.76 136.8,117.62 135.94,118.19 134.93,118.39 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="148.16,118.39 147.15,118.19 146.29,117.62 145.71,116.76 145.51,115.75 145.71,114.74 146.29,113.88 147.15,113.3 148.16,113.1 148.16,113.1 149.17,113.3 150.03,113.88 150.6,114.74 150.8,115.75 150.6,116.76 150.03,117.62 149.17,118.19 148.16,118.39 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="68.79,125.01 67.77,124.81 66.92,124.23 66.34,123.37 66.14,122.36 66.34,121.35 66.92,120.49 67.77,119.92 68.79,119.72 88.63,119.72 89.64,119.92 90.5,120.49 91.07,121.35 91.28,122.36 91.07,123.37 90.5,124.23 89.64,124.81 88.63,125.01 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="101.86,125.01 100.85,124.81 99.99,124.23 99.41,123.37 99.21,122.36 99.41,121.35 99.99,120.49 100.85,119.92 101.86,119.72 101.86,119.72 102.87,119.92 103.73,120.49 104.3,121.35 104.5,122.36 104.3,123.37 103.73,124.23 102.87,124.81 101.86,125.01 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="121.7,125.01 120.69,124.81 119.83,124.23 119.26,123.37 119.06,122.36 119.26,121.35 119.83,120.49 120.69,119.92 121.7,119.72 134.93,119.72 135.94,119.92 136.8,120.49 137.37,121.35 137.57,122.36 137.37,123.37 136.8,124.23 135.94,124.81 134.93,125.01 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="68.79,131.62 67.77,131.42 66.92,130.85 66.34,129.99 66.14,128.98 66.34,127.96 66.92,127.11 67.77,126.53 68.79,126.33 75.4,126.33 76.41,126.53 77.27,127.11 77.85,127.96 78.05,128.98 77.85,129.99 77.27,130.85 76.41,131.42 75.4,131.62 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="88.63,131.62 87.62,131.42 86.76,130.85 86.19,129.99 85.98,128.98 86.19,127.96 86.76,127.11 87.62,126.53 88.63,126.33 115.09,126.33 116.1,126.53 116.96,127.11 117.53,127.96 117.73,128.98 117.53,129.99 116.96,130.85 116.1,131.42 115.09,131.62 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="128.31,131.62 127.3,131.42 126.44,130.85 125.87,129.99 125.67,128.98 125.87,127.96 126.44,127.11 127.3,126.53 128.31,126.33 134.93,126.33 135.94,126.53 136.8,127.11 137.37,127.96 137.57,128.98 137.37,129.99 136.8,130.85 135.94,131.42 134.93,131.62 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="68.79,138.24 67.77,138.03 66.92,137.46 66.34,136.6 66.14,135.59 66.34,134.58 66.92,133.72 67.77,133.15 68.79,132.94 75.4,132.94 76.41,133.15 77.27,133.72 77.85,134.58 78.05,135.59 77.85,136.6 77.27,137.46 76.41,138.03 75.4,138.24 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="95.24,138.24 94.23,138.03 93.37,137.46 92.8,136.6 92.6,135.59 92.8,134.58 93.37,133.72 94.23,133.15 95.24,132.94 95.24,132.94 96.26,133.15 97.11,133.72 97.69,134.58 97.89,135.59 97.69,136.6 97.11,137.46 96.26,138.03 95.24,138.24 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="108.47,138.24 107.46,138.03 106.6,137.46 106.03,136.6 105.83,135.59 106.03,134.58 106.6,133.72 107.46,133.15 108.47,132.94 115.09,132.94 116.1,133.15 116.96,133.72 117.53,134.58 117.73,135.59 117.53,136.6 116.96,137.46 116.1,138.03 115.09,138.24 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="128.31,138.24 127.3,138.03 126.44,137.46 125.87,136.6 125.67,135.59 125.87,134.58 126.44,133.72 127.3,133.15 128.31,132.94 134.93,132.94 135.94,133.15 136.8,133.72 137.37,134.58 137.57,135.59 137.37,136.6 136.8,137.46 135.94,138.03 134.93,138.24 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="68.79,144.85 67.77,144.65 66.92,144.08 66.34,143.22 66.14,142.2 66.34,141.19 66.92,140.33 67.77,139.76 68.79,139.56 68.79,139.56 69.8,139.76 70.66,140.33 71.23,141.19 71.43,142.2 71.23,143.22 70.66,144.08 69.8,144.65 68.79,144.85 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="82.02,144.85 81,144.65 80.14,144.08 79.57,143.22 79.37,142.2 79.57,141.19 80.14,140.33 81,139.76 82.02,139.56 121.7,139.56 122.71,139.76 123.57,140.33 124.15,141.19 124.35,142.2 124.15,143.22 123.57,144.08 122.71,144.65 121.7,144.85 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="134.93,144.85 133.92,144.65 133.06,144.08 132.48,143.22 132.28,142.2 132.48,141.19 133.06,140.33 133.92,139.76 134.93,139.56 141.54,139.56 142.56,139.76 143.41,140.33 143.99,141.19 144.19,142.2 143.99,143.22 143.41,144.08 142.56,144.65 141.54,144.85 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="68.79,151.46 67.77,151.26 66.92,150.69 66.34,149.83 66.14,148.82 66.34,147.81 66.92,146.95 67.77,146.37 68.79,146.17 82.02,146.17 83.03,146.37 83.89,146.95 84.46,147.81 84.66,148.82 84.46,149.83 83.89,150.69 83.03,151.26 82.02,151.46 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="95.24,151.46 94.23,151.26 93.37,150.69 92.8,149.83 92.6,148.82 92.8,147.81 93.37,146.95 94.23,146.37 95.24,146.17 95.24,146.17 96.26,146.37 97.11,146.95 97.69,147.81 97.89,148.82 97.69,149.83 97.11,150.69 96.26,151.26 95.24,151.46 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="115.09,151.46 114.07,151.26 113.22,150.69 112.64,149.83 112.44,148.82 112.64,147.81 113.22,146.95 114.07,146.37 115.09,146.17 115.09,146.17 116.1,146.37 116.96,146.95 117.53,147.81 117.73,148.82 117.53,149.83 116.96,150.69 116.1,151.26 115.09,151.46 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
          <polygon
            points="134.93,151.46 133.92,151.26 133.06,150.69 132.48,149.83 132.28,148.82 132.48,147.81 133.06,146.95 133.92,146.37 134.93,146.17 134.93,146.17 135.94,146.37 136.8,146.95 137.37,147.81 137.57,148.82 137.37,149.83 136.8,150.69 135.94,151.26 134.93,151.46 "
            style="fill:url(#gradientffcbed388ab34855992a9fd38824ed9b);"
          />
      `,
            },
        ];
    }
    init() {
        if (!this.initialized) {
            this.mouseService.getDocumentMouseMove().subscribe(() => {
                if (!this.model.draggingElement) {
                    this.startUpdate();
                }
            });
            this.mouseService.getDocumentMouseUp().subscribe(() => {
                this.startUpdate();
            });
            document.body.addEventListener("keyup", () => this.startUpdate(), true);
            this.model.formEvents.subscribe((e) => {
                if (e.name == "SetForm") {
                    this.startUpdate();
                }
            });
            document.body.addEventListener("keyup", () => this.startUpdate(), true);
        }
        this.initialized = true;
        this.startUpdate();
    }
    startUpdate() {
        let this_ = this;
        if (!this.timerSarted) {
            this.timerSarted = true;
            setTimeout(() => {
                this.timerSarted = false;
                let barcodes = [];
                this.findChangedBarcodes(this.model.form, barcodes);
                if (barcodes.length > 0) {
                    let jsonBarcodes = [];
                    barcodes.forEach((b) => {
                        let barcode = b;
                        barcode.resetChanged();
                        barcode.showProgress = true;
                        jsonBarcodes.push(barcode.saveToJsonObject({}).serialize());
                    });
                    let data = {
                        action: "GetBorcodeImages",
                        barcodes: jsonBarcodes,
                    };
                    this.httpService.post(this.model.requestUrl, data, "json", { showProgress: false }).subscribe((data) => {
                        this_.model.showProgress = false;
                        let barcodeImgs = data;
                        for (let i = 0; i < barcodes.length; i++) {
                            barcodes[i].img = barcodeImgs[i];
                            barcodes[i].showProgress = false;
                        }
                    });
                }
            }, 400);
        }
    }
    findChangedBarcodes(element, barcodes) {
        let iterable = element?.pages ? element.pages : element?.elements ? element.elements : [];
        iterable.forEach((p) => this.findChangedBarcodes(p, barcodes));
        let barcode = element instanceof StiBarcodeElement ? element : null;
        if (barcode?.isChanged()) {
            barcodes.push(barcode);
        }
    }
}
StiBarcodeService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiBarcodeService, deps: [{ token: i1.StiModelService }, { token: i2.StiMouseService }, { token: i3.StiHttpClientService }, { token: i4.StiUndoService }], target: i0.ɵɵFactoryTarget.Injectable });
StiBarcodeService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiBarcodeService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiBarcodeService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiMouseService }, { type: i3.StiHttpClientService }, { type: i4.StiUndoService }]; } });
//# sourceMappingURL=data:application/json;base64,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