import { StiFormSaveMode } from "../system/enums";
export class StiToolboxElement {
    constructor(caption, image, component, element) {
        this.caption = caption;
        this.image = image;
        this.component = component;
        this.element = element;
    }
}
export class StiEvent {
    constructor(name, value) {
        this.name = name;
        this.value = value;
    }
}
export class StiEditorProperty {
    constructor(type, property, label) {
        this.type = type;
        this.property = property;
        this.label = label;
    }
}
export class Item {
    constructor(name, caption, imageName, key, haveSubMenu, imageSizes, selected, type) {
        this.name = name;
        this.caption = caption;
        this.imageName = imageName;
        this.key = key;
        this.haveSubMenu = haveSubMenu;
        this.imageSizes = imageSizes;
        this.selected = selected;
        this.type = type;
    }
}
export class MenuItem {
    constructor(name, caption, img, type, selected, imageSize, value) {
        this.name = name;
        this.caption = caption;
        this.img = img;
        this.type = type;
        this.selected = selected;
        this.imageSize = imageSize;
        this.value = value;
    }
}
export class Menu {
    constructor(name, items, parent, type, state, menuEl, top, left, innerContent, width, height, menuStyleName, verticalItems, action, itemStyleName, value, sizeStyle) {
        this.name = name;
        this.items = items;
        this.parent = parent;
        this.type = type;
        this.state = state;
        this.menuEl = menuEl;
        this.top = top;
        this.left = left;
        this.innerContent = innerContent;
        this.width = width;
        this.height = height;
        this.menuStyleName = menuStyleName;
        this.verticalItems = verticalItems;
        this.action = action;
        this.itemStyleName = itemStyleName;
        this.value = value;
        this.sizeStyle = sizeStyle;
    }
}
export class StiWebFormOptions {
    constructor() {
        this.saveMode = StiFormSaveMode.Automatic;
    }
}
export class StiLocalizationObject {
}
export class FormEvent {
    constructor(name, value) {
        this.name = name;
        this.value = value;
    }
}
export class UsedFont {
    constructor(fontFamily, fontStyle, fontSize) {
        this.fontFamily = fontFamily;
        this.fontStyle = fontStyle;
        this.fontSize = fontSize;
    }
}
export class StiUsedFontsList {
    constructor() {
        this.fonts = [];
    }
    add(fontFamily, fontStyle, fontSize) {
        if (!this.fonts.find((u) => u.fontFamily == fontFamily &&
            u.fontStyle.length == fontStyle.length &&
            u.fontStyle == fontStyle &&
            u.fontSize == fontSize)) {
            this.fonts.push({ fontFamily: fontFamily, fontStyle: fontStyle, fontSize: fontSize });
        }
    }
}
export class StiInterfaceEvent {
    constructor(name, data) {
        this.name = name;
        this.data = data;
    }
}
//# sourceMappingURL=data:application/json;base64,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