import { Injectable } from "@angular/core";
import { Subject } from "rxjs";
import * as i0 from "@angular/core";
import * as i1 from "./model.service";
import * as i2 from "./sti-editable-content.service";
import * as i3 from "./sti-user-service";
import * as i4 from "./sti-signature.service";
import * as i5 from "../components/sti-dropdown-component/sti-dropdown-service";
export class StiMouseService {
    constructor(model, editableSevice, userService, signatureService, dropdownService) {
        this.model = model;
        this.editableSevice = editableSevice;
        this.userService = userService;
        this.signatureService = signatureService;
        this.dropdownService = dropdownService;
        this.documetMouseDown = new Subject();
        this.documetMouseMove = new Subject();
        this.documetMouseUp = new Subject();
        this.captureMouseUp = new Subject();
        this.captureMouseDown = new Subject();
        this.documentTouchStart = new Subject();
        this.documentTouchMove = new Subject();
        this.documentTouchEnd = new Subject();
        this.leftButtonDown = false;
        this.rightButtonDown = false;
        document.addEventListener("mouseup", (event) => {
            this.documetMouseUp.next(event);
        });
        document.addEventListener("touchstart", (event) => {
            this.documentTouchStart.next(event);
        }, { passive: false });
        document.addEventListener("touchmove", (event) => {
            this.documentTouchMove.next(event);
        }, { passive: false });
        document.addEventListener("touchend", (event) => {
            this.documentTouchEnd.next(event);
        }, { passive: false });
        document.addEventListener("mouseup", (event) => {
            let form = document.querySelector("stimulsoft-forms");
            if (form) {
                form?.classList.contains("unselectable") ? form?.classList.remove("unselectable") : "";
            }
            let elements = document.elementsFromPoint(event.clientX, event.clientY);
            if (!elements.find((elem) => elem?.classList.contains("parent-group-container"))) {
                this.model.showGroupPreview = false;
            }
            if (!elements.find((elem) => elem?.classList.contains("form-elements-list-item")) &&
                !elements.find((elem) => elem?.classList.contains("form-elements-dropdown"))) {
                this.model.showFormElementsList = false;
            }
            if (!elements.find((elem) => elem?.classList.contains("localization"))) {
                this.userService.showLocalizationPreview = false;
            }
            if (!elements.find((elem) => elem?.classList.contains("user-info"))) {
                this.userService.showUserInfo = false;
            }
            if (!elements.find((elem) => elem?.classList.contains("sti-dropdown-list"))) {
                this.dropdownService.showDropdownList = false;
            }
            if (!elements.find((elem) => elem?.classList.contains("tiered-menu-container"))) {
                this.model.showTieredMenu = false;
            }
            if (!elements.find((elem) => elem?.classList.contains("sti-dropdown-editor")) &&
                !elements.find((elem) => elem?.classList.contains("sti-dropdown-items"))) {
                this.model.hideActiveDropdown.next(true);
            }
            if (event.button == 0) {
                this.leftButtonDown = false;
            }
            if (!elements.find((elem) => elem?.classList.contains("autoComplete-list-container")) &&
                !elements.find((elem) => elem?.classList.contains("autoComplete-select-button"))) {
                this.model.hideActiveAutocompleteList.next(true);
            }
            if (!elements.find((elem) => elem?.classList.contains("home")) &&
                !elements.find((elem) => elem?.classList.contains("sti-dropdown-list"))) {
                let iframes = document.getElementsByTagName("iframe");
                if (iframes.length > 0) {
                    for (let index = 0; index < iframes.length; index++) {
                        const element = iframes[index].contentDocument || iframes[index].contentWindow.document;
                        if (element.getSelection().toString().length > 0) {
                            element.getSelection().removeAllRanges();
                        }
                    }
                }
            }
            this.model.lastFormState = null;
            this.captureMouseUp.next(event);
        }, true);
        /* document.addEventListener(
          "mousemove",
          (event) => {
            this.captureMouseUp.next(event);
          },
          true
        ); */
        document.addEventListener("mousemove", (event) => {
            this.documetMouseMove.next(event);
        });
        window.addEventListener("mousedown", (event) => {
            this.documetMouseDown.next(event);
        });
        window.addEventListener("mousedown", (event) => {
            if (this.editableSevice.usedElement &&
                this.model.selectedComponent &&
                this.model.selectedComponent.element != this.editableSevice.usedElement) {
                this.editableSevice.editableContent = null;
                this.editableSevice.usedElement = null;
            }
            if (event.button == 0) {
                this.leftButtonDown = true;
            }
            let elements = document.elementsFromPoint(event.clientX, event.clientY);
            if (this.model.showColorDialog && !this.model.showMoreColorDialog) {
                if (!elements.find((elem) => elem?.classList.contains("color-dialog"))) {
                    this.model.showColorDialog = false;
                }
            }
            if (this.model.showContextMenu) {
                let underContextMenu = false;
                for (let elem of document.elementsFromPoint(event.clientX, event.clientY)) {
                    if (elem?.classList.contains("context-menu")) {
                        underContextMenu = true;
                        break;
                    }
                }
                if (!underContextMenu) {
                    this.model.showContextMenu = false;
                }
            }
            if (this.signatureService.drawingMode) {
                let underCanvas = false;
                for (let elem of document.elementsFromPoint(event.clientX, event.clientY)) {
                    if (elem?.classList.contains("canvas")) {
                        underCanvas = true;
                        break;
                    }
                }
                if (!underCanvas) {
                    setTimeout(() => {
                        this.signatureService.drawingMode = false;
                    });
                }
            }
            if (this.signatureService.showFontsPreview) {
                if (!elements.find((elem) => elem?.classList.contains("fonts-preview-container"))) {
                    this.signatureService.showFontsPreview = false;
                }
            }
            if (this.signatureService.showSavedTemplates) {
                if (!elements.find((elem) => elem?.classList.contains("saved-templates-container")) &&
                    !elements.find((elem) => elem?.classList.contains("show-button"))) {
                    this.signatureService.showSavedTemplates = false;
                }
            }
            this.captureMouseDown.next(event);
        }, true);
    }
    getDocumentMouseUp() {
        return this.documetMouseUp.asObservable();
    }
    getDocumentMouseMove() {
        return this.documetMouseMove.asObservable();
    }
    getDocumentMouseDown() {
        return this.documetMouseDown.asObservable();
    }
    getCaptureMouseUp() {
        return this.captureMouseUp.asObservable();
    }
    getCaptureMouseDown() {
        return this.captureMouseDown.asObservable();
    }
    getDocumentTouchStart() {
        return this.documentTouchStart.asObservable();
    }
    getDocumentTouchMove() {
        return this.documentTouchMove.asObservable();
    }
    getDocumentTouchEnd() {
        return this.documentTouchEnd.asObservable();
    }
}
StiMouseService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiMouseService, deps: [{ token: i1.StiModelService }, { token: i2.StiEditableContentService }, { token: i3.StiUserService }, { token: i4.SignatureService }, { token: i5.StiDropdownService }], target: i0.ɵɵFactoryTarget.Injectable });
StiMouseService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiMouseService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiMouseService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.StiModelService }, { type: i2.StiEditableContentService }, { type: i3.StiUserService }, { type: i4.SignatureService }, { type: i5.StiDropdownService }]; } });
//# sourceMappingURL=data:application/json;base64,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