import { Injectable } from "@angular/core";
import { camelCase, indexOf } from "lodash";
import { Subject } from "rxjs";
import { StiForm } from "../elements/StiForm";
import { StiPanelElement } from "../elements/StiPanelElement";
import { StiTableElement } from "../elements/StiTableElement";
import { StiNumberRangeFormat, StiThousandSeparator, StiUnitAlignment } from "../system/enums";
import { StiStaticHelperService } from "./sti-static-helper.service";
import * as i0 from "@angular/core";
export class StiModelService {
    constructor() {
        this._showTrialBar = false;
        this._showTrialModalWindow = false;
        this._showTrialTitle = false;
        this._canCloseTrialWindow = true;
        this.fontFamilies = [];
        this.assemblyInfo = [];
        this.currentRibbonValue = "Home";
        this.userName = "";
        this.currentPropertyGridMode = "Properties";
        this.showFormElementsList = false;
        this.sortFormElementsList = false;
        this.showComponentsTab = true;
        this.hideActiveDropdown = new Subject();
        this.showSignatureEditor = false;
        this.showDraggableModalWindow = false;
        this.hideActiveAutocompleteList = new Subject();
        this.needToSelectedComponent = new Subject();
        this.showButtonMessageWindow = false;
        this.showTieredMenu = false;
        this.showTrialTimerWindow = false;
        this.isInitialized = false;
        this.showFileMenu = false;
        this.showFileMenuNavigation = false;
        this.showContextMenu = false;
        this.showHelpWindow = false;
        this.showSaveDialog = false;
        this.showErrorWindow = false;
        this.basePlanIsTrial = false;
        this.viewerMode = false;
        this.isCloudMode = false;
        this.disableCloseButton = false;
        this.pdfPreviewMode = false;
        this.showCornerRadius = true;
        this.showAboutWindow = false;
        this.showGroupPreview = false;
        this.showToolboxSetup = false;
        this.showModalWindow = false;
        this.showProgressAfterUpdatePage = false;
        this.canDrag = true;
        this.tieredMenuX = 0;
        this.tieredMenuY = 0;
        this.currentExpressionInfo = 0; //0-none,1-label column,2-totals,3-label component.
        this.buildVersion = "";
        this.buildDate = "";
        this.errorWindowMessage = "";
        this.propertyGridWidth = 395;
        this.needToRefresh = new Subject();
        this.needToUpdateHelper = new Subject();
        this.startPdfExportEvent = new Subject();
        this.needToRefreshInnerProperties = new Subject();
        this.currentContentEditableItem = new Subject();
        this.currentTablePropertyHeader = new Subject();
        this.retryButtonRequest = new Subject();
        this.currentTableHeader = "Main";
        this.formEvents = new Subject();
        this.interfaceEvent = new Subject();
        this.isMobileViewer = new Subject();
        this.saveDialogFromNew = false;
        this.saveDialogFromOpen = false;
        this.sendedFromButton = false;
        this.attachedFiles = [];
        this.loadingFromCloud = false;
        this.showColorDialog = false;
        this.showMoreColorDialog = false;
        this.userIsAuthorized = false;
        this.userWasChecked = false;
        this.showSaveDialogFromCloud = false;
        this.hasEmptyReuiredFields = false;
        this.showExpressionEditor = false;
        this.showProgress = false;
        this.isWebView = false;
        this.currentSelectedFileOption = "Open";
        this._embeddedMode = false;
        this.embeddedEvent = function (data) { };
        this.fileName = "Form.mrt";
        this.enteredUrls = [];
        this._zoom = 1;
        this._cursor = "default";
        this._isPreviewMode = false;
    }
    get showTrialBar() {
        return this._showTrialBar;
    }
    set showTrialBar(value) {
        let lastState = this._showTrialBar;
        if (value != lastState) {
            this._showTrialBar = value;
        }
    }
    get showTrialModalWindow() {
        return this._showTrialModalWindow;
    }
    set showTrialModalWindow(value) {
        let lastState = this._showTrialModalWindow;
        if (value != lastState) {
            this._showTrialModalWindow = value;
        }
    }
    get showTrialTitle() {
        return this._showTrialTitle;
    }
    set showTrialTitle(value) {
        let lastState = this._showTrialTitle;
        if (value != lastState) {
            this._showTrialTitle = value;
        }
    }
    get canCloseTrialWindow() {
        return this._canCloseTrialWindow;
    }
    set canCloseTrialWindow(value) {
        let lastState = this._canCloseTrialWindow;
        if (value != lastState) {
            this._canCloseTrialWindow = value;
        }
    }
    toggleTieredMenu(element) {
        let elementRect = this.getPositionRelativeToForm(element);
        let menuWidth = 104;
        let menuHeight = 165;
        this.tieredMenuY =
            window.innerHeight - elementRect.bottom >= menuHeight ? elementRect.bottom : elementRect.top - menuHeight;
        this.tieredMenuX =
            window.innerWidth - elementRect.left > menuWidth ? elementRect.left : elementRect.right - menuWidth;
        this.showTieredMenu = true;
    }
    set isPreviewMode(value) {
        this._isPreviewMode = value;
        if (value) {
            this.interfaceEvent.next({ name: "SetPreviewMode", data: true });
        }
        else {
            this.interfaceEvent.next({ name: "UnsetPreviewMode" });
        }
    }
    get isPreviewMode() {
        return this._isPreviewMode;
    }
    canDelete() {
        return (window.getSelection().toString().length == 0 &&
            document.activeElement.tagName.toLocaleLowerCase() == "body" &&
            !this.draggingElement &&
            !this.showSignatureEditor);
    }
    get showSaveToPdfButton() {
        return this.settings?.showSaveToPdfButton ?? true;
    }
    get showEditButton() {
        return this.settings?.showEditButton ?? false;
    }
    set embeddedMode(value) {
        this._embeddedMode = value;
    }
    get embeddedMode() {
        return this._embeddedMode || this.properties?.embeddedMode === true;
    }
    get cursor() {
        return this._cursor;
    }
    get zoom() {
        return this._zoom;
    }
    set requestUrl(value) {
        this._requestUrl = value;
        this.isWebView = value == "WebView";
    }
    get requestUrl() {
        return this._requestUrl;
    }
    set zoom(value) {
        if (value <= 0.1) {
            this._zoom = 0.1;
        }
        else if (value >= 4) {
            this._zoom = 4;
        }
        else {
            this._zoom = value;
        }
    }
    set cursor(value) {
        if (value == "default" && this.selectedComponent?.hover) {
            this._cursor = "move";
        }
        else {
            this._cursor = value;
        }
    }
    formattingDate(dateFormat) {
        let result = dateFormat
            .replace(/M/g, "k")
            .replace(/m/g, "r")
            .replace(/tt/g, "a")
            .replace(/k/g, "m")
            .replace(/r/g, "M");
        return result;
    }
    setZoomFromString(zoomString) {
        if (typeof zoomString != "string") {
            return;
        }
        if (zoomString.includes("%")) {
            let zoom = Number(zoomString.slice(0, zoomString.indexOf("%"))) / 100;
            if (zoom <= 0.1) {
                this.zoom = 0.1;
            }
            else if (zoom >= 4) {
                this.zoom = 4;
            }
            else {
                this.zoom = zoom;
            }
        }
        else {
            switch (zoomString.toLowerCase()) {
                case "pagewidth":
                    this.formEvents.next({ name: "SetZoomByPageWidth" });
                    break;
                case "onepage":
                    this.formEvents.next({ name: "SetZoomByOnePage" });
                    break;
                default:
                    this.formEvents.next({ name: "SetDefaultZoom" });
                    break;
            }
        }
    }
    getPositionRelativeToForm(element) {
        let elementRect = element?.getBoundingClientRect();
        let formRect = this.rootFormElement?.getBoundingClientRect();
        if (formRect) {
            return new DOMRect(elementRect?.x - formRect?.x, elementRect?.y - formRect?.y, elementRect?.width, elementRect?.height);
        }
        else {
            return elementRect;
        }
    }
    getBooleanSetting(settingName) {
        return this.settings && this.isNotEmpty(this.settings[settingName]) && this.isBoolean(this.settings[settingName])
            ? this.settings[settingName]
            : true;
    }
    isBoolean(value) {
        return typeof value === "boolean";
    }
    isNotEmpty(value) {
        return value?.toString()?.length > 0;
    }
    saveLastFormState() {
        this.form.reportVersion = this.buildVersion;
        this.form.reportChanged = StiStaticHelperService.dateToJsonDate(new Date());
        this.lastSavedFormState = this.form.saveToReportJsonObject().serialize();
    }
    toCamelCase(obj) {
        if (Array.isArray(obj)) {
            return obj.map((v) => this.toCamelCase(v));
        }
        else if (obj != null && obj.constructor === Object) {
            return Object.keys(obj).reduce((result, key) => ({
                ...result,
                [camelCase(key)]: this.toCamelCase(obj[key]),
            }), {});
        }
        return obj;
    }
    changeFileMenuState() {
        this.showFileMenuNavigation = !this.showFileMenuNavigation;
        setTimeout(() => {
            this.showFileMenu = !this.showFileMenu;
        }, 90);
    }
    showColumnPreview(index, type) {
        if (!type &&
            this.selectedComponent?.element instanceof StiTableElement &&
            !this.selectedComponent?.element.showColumnsEditor) {
            this.selectedComponent.element.showColumnsEditor = true;
            this.needToRefresh.next(true);
        }
        else if (type == "totals" &&
            this.selectedComponent?.element instanceof StiTableElement &&
            !this.selectedComponent?.element.showTotalsEditor) {
            this.selectedComponent.element.showTotalsEditor = true;
            this.needToRefresh.next(true);
        }
        setTimeout(() => {
            if (this.currentContentEditableItemIndex != index || this.previousSelectedComponent != this.selectedComponent)
                this.currentContentEditableItem.next(index);
            this.currentContentEditableItemIndex = index;
        });
    }
    showError(message, sendedFromButton = false, buttonElement) {
        if (message instanceof ArrayBuffer) {
            var enc = new TextDecoder("utf-8");
            message = enc.decode(message);
        }
        else if (message instanceof Event) {
            message = message.type;
        }
        else if (message?.text) {
            message = message.text;
        }
        if (buttonElement) {
            this.currentUsedButtonElement = buttonElement;
        }
        this.sendedFromButton = sendedFromButton;
        this.errorWindowMessage = message;
        if (this.errorWindowMessage != "abort") {
            this.showErrorWindow = true;
        }
    }
    getImage(fileName) {
        return this.imagesArray && this.imagesArray[fileName] ? this.imagesArray[fileName] : "";
    }
    removeUnusedCells(element) {
        element.columns.forEach((column) => {
            if (column["cells"].length != element.rowLabels.length) {
                column["cells"].splice(element.rowLabels.length, column["cells"].length - 1);
            }
        });
    }
    startPdfExport(form) {
        if (form) {
            this.setFormFromString(JSON.stringify(form));
        }
        this.startPdfExportEvent.next(true);
    }
    setFormFromString(str, loadSavedSetings = false) {
        let form = new StiForm();
        form.loadFormJsonString(str);
        if (loadSavedSetings) {
            this.loadSavedSettings();
        }
        this.form = form;
    }
    get form() {
        return this._form;
    }
    set form(form) {
        this.updateForm(form);
        this.checkOnUniqueNames();
        form.formEvents.next({ name: "SetForm" });
        this.firstFormState = this.form.saveToReportJsonObject().serialize();
        if (this.viewerMode && this.isMobile()) {
            setTimeout(() => {
                this.isMobileViewer.next(true);
            });
        }
    }
    arrayOfStylesToString(array) {
        if (!array)
            return;
        let styles = [];
        if (array.length > 0) {
            array.forEach((item) => {
                if (item != "Underline") {
                    styles.push(item);
                }
            });
        }
        return styles.length > 0 ? styles.join(" ").toLocaleLowerCase() : "";
    }
    checkOnUniqueNames() {
        this.form.allElements.forEach((element) => {
            let currentName = element.name;
            let uniqueElements = this.form.allElements.filter((elem) => elem.name == currentName);
            if (uniqueElements.length > 1) {
                this.setUniqueName(element);
            }
        });
    }
    setUniqueName(element) {
        let regex = /\d+$/;
        let currentName = element.name ?? element.type.replace("_", "").replace("Element", "");
        let index = 0;
        let currentPosition = element.name?.match(regex) ? element.name?.match(regex)[0] : null;
        if (currentPosition) {
            currentName = currentName.slice(0, currentName.length - currentPosition.length);
        }
        while (this.form.allElements.find((element) => element.name == `${currentName + (index != 0 ? index + 1 : "")}`)) {
            index++;
        }
        element.name = currentName + (index != 0 ? index + 1 : "");
    }
    checkNumberRange(element) {
        if (element.rangeFormat == StiNumberRangeFormat.Digits) {
            let maximumValueString = "";
            for (let index = element.maximum; index > 0; index--) {
                maximumValueString += "9";
            }
            let maximumValue = Number(maximumValueString);
            let minimumValue = -Number(maximumValueString);
            if (element.value > maximumValue) {
                element.value = maximumValue;
            }
            else if (element.value < minimumValue) {
                element.value = minimumValue;
            }
        }
        else {
            if (element.value > element.maximum) {
                element.value = Number(element.maximum);
            }
            else if (element.value < element.minimum) {
                element.value = Number(element.minimum);
            }
        }
    }
    showTrialLog() {
        if (this.showTrialBar || this.showTrialTitle || this.showTrialModalWindow) {
            console.warn("You are using a trial version of the Stimulsoft Forms!");
        }
    }
    loadSavedSettings() {
        if (localStorage.getItem("StiFormSettings") &&
            (this.isWebView || this.isCloudMode || this.properties?.cloudPlanIdent)) {
            this.form?.settings?.loadFormJsonString(localStorage.getItem("StiFormSettings"));
        }
    }
    saveSettings() {
        localStorage.removeItem("StiFormSettings");
        localStorage.setItem("StiFormSettings", this.form.settings.saveToJsonObject({}).serialize());
    }
    isMobile() {
        const toMatch = [/Android/i, /webOS/i, /iPhone/i, /iPad/i, /iPod/i, /BlackBerry/i, /Windows Phone/i];
        return toMatch.some((toMatchItem) => {
            return navigator.userAgent.match(toMatchItem);
        });
    }
    getBrowserType() {
        let userAgent = navigator.userAgent;
        let browserName;
        if (userAgent.match(/chrome|chromium|crios/i)) {
            browserName = "chrome";
        }
        else if (userAgent.match(/firefox|fxios/i)) {
            browserName = "firefox";
        }
        else if (userAgent.match(/safari/i)) {
            browserName = "safari";
        }
        else if (userAgent.match(/opr\//i)) {
            browserName = "opera";
        }
        else if (userAgent.match(/edg/i)) {
            browserName = "edge";
        }
        else {
            browserName = "No browser detection";
        }
        return browserName;
    }
    getScaleWithTranslate() {
        return `translate(${this.zoom <= 1 ? 0 : ((this.zoom - 1) / 2) * 100}%) scale(${this.zoom})`;
    }
    getScale() {
        return `scale(${this.zoom})`;
    }
    updateForm(form) {
        this._form = form;
        this.selectedComponent = null;
        this.lastUsedPage = null;
        form.formEvents.subscribe((e) => this.formEvents.next(e));
        if (form.pages?.length > 0) {
            this.previousPadding = form.pages[0].padding.clone();
            this.previousContentAreaWidth = form.pages[0].contentAreaWidth;
            setTimeout(() => {
                this.needToRefresh.next(true);
            }, 0);
        }
        form.formEvents.next({ name: "UpdateForm" });
    }
    set elementToUpdate(value) {
        let oldValue = this._elementToUpdate;
        this._elementToUpdate = value;
        if (oldValue != value) {
            this.formEvents.next({ name: "ElementToUpdateChanged", value: value });
        }
    }
    get elementToUpdate() {
        return this._elementToUpdate;
    }
    get selectedComponent() {
        return this._selectedComponent;
    }
    set selectedComponent(value) {
        let oldValue = this._selectedComponent;
        this._selectedPage = null;
        this._selectedComponent = value;
        this.needToRefresh.next(true);
        if (oldValue != value) {
            this.formEvents.next({ name: "SelectedComponentChanged", value: value });
        }
    }
    get selectedPage() {
        return this._selectedPage;
    }
    set selectedPage(value) {
        let oldValue = this._selectedPage;
        this._selectedComponent = null;
        this._selectedPage = value;
        this.needToRefresh.next(true);
        if (oldValue != value) {
            this.formEvents.next({ name: "SelectedPageChanged", value: value });
        }
    }
    get lastUsedPage() {
        return this._lastUsedPage ?? this.selectedPage ?? this.form?.pages[0];
    }
    set lastUsedPage(value) {
        this._lastUsedPage = value;
    }
    getSelectedComponentPage() {
        return this.getElementPage(this._selectedComponent?.element);
    }
    getElementPage(element) {
        return this.form?.pages.find((p) => p.elements.find((e) => e == element) != null);
    }
    getElementPageForScroll(element) {
        return this.form?.pages.find((p) => p.elements.find((e) => e == element) != null
            ? p.elements.find((e) => e == element)
            : this.getElementPanel(element));
    }
    overToolbar(x, y) {
        let elementsDiv = document.elementsFromPoint(x, y).find((elem) => elem?.classList.contains("elements"));
        return elementsDiv ? true : false;
    }
    getElementPanel(element) {
        let result;
        this.form.pages.forEach((page) => {
            page.allElements.forEach((panel) => {
                if (panel instanceof StiPanelElement && panel.elements.indexOf(element) >= 0) {
                    result = panel;
                }
            });
        });
        return result;
    }
    formatNumber(value, format, decimalDigits, unitAlignment, unit) {
        let formatedValue = this.formatNumberWithThousandSeparator(value, format, decimalDigits);
        switch (unitAlignment) {
            case StiUnitAlignment.PrefixInside:
                return `${unit}${formatedValue}`;
            case StiUnitAlignment.PrefixInsideSpace:
                return `${unit} ${formatedValue}`;
            case StiUnitAlignment.SuffixInside:
                return `${formatedValue}${unit}`;
            case StiUnitAlignment.SuffixInsideSpace:
                return `${formatedValue} ${unit}`;
        }
        return formatedValue;
    }
    getFormattedValue(element, inValue) {
        let value = inValue;
        try {
            if (typeof value === "number" && !isNaN(value)) {
                value = this.formatNumberWithThousandSeparator(parseFloat(value.toFixed(element.decimalDigits)), element.thousandSeparator, element.decimalDigits);
            }
        }
        catch {
            value = "";
        }
        return value;
    }
    formatNumberWithThousandSeparator(value, format, decimalDigits) {
        let isNegative = false;
        if (value == undefined) {
            return "";
        }
        let result;
        if (decimalDigits > 0) {
            result = value.toFixed(decimalDigits);
        }
        else {
            result = value.toString();
        }
        if (result.indexOf("-") != -1) {
            isNegative = true;
        }
        if (isNegative) {
            result = result.slice(1, result.length);
        }
        if (format == StiThousandSeparator.None) {
            return (isNegative ? "-" : "") + result;
        }
        else if (format == StiThousandSeparator.NoneComma) {
            return (isNegative ? "-" : "") + result.replace(".", ",");
        }
        else if (format == StiThousandSeparator.Comma) {
            var chars = (decimalDigits > 0 ? result.slice(0, indexOf(result, ".")) : result).split("").reverse();
            var withCommas = [];
            for (var i = 1; i <= chars.length; i++) {
                withCommas.push(chars[i - 1]);
                if (i % 3 == 0 && i != chars.length) {
                    withCommas.push(",");
                }
            }
            result =
                decimalDigits > 0
                    ? withCommas.reverse().join("") + result.slice(indexOf(result, "."), result.length)
                    : withCommas.reverse().join("");
            return (isNegative ? "-" : "") + result;
        }
        else if (format == StiThousandSeparator.Dot) {
            var chars = (decimalDigits > 0 ? result.slice(0, indexOf(result, ".")) : result).split("").reverse();
            var withDotts = [];
            for (var i = 1; i <= chars.length; i++) {
                withDotts.push(chars[i - 1]);
                if (i % 3 == 0 && i != chars.length) {
                    withDotts.push(".");
                }
            }
            result =
                decimalDigits > 0
                    ? withDotts.reverse().join("") + "," + result.slice(indexOf(result, ".") + 1, result.length)
                    : withDotts.reverse().join("");
            return (isNegative ? "-" : "") + result;
        }
        else if (format == StiThousandSeparator.Apostrophe) {
            var chars = (decimalDigits > 0 ? result.slice(0, indexOf(result, ".")) : result).split("").reverse();
            var withSpaces = [];
            for (var i = 1; i <= chars.length; i++) {
                withSpaces.push(chars[i - 1]);
                if (i % 3 == 0 && i != chars.length) {
                    withSpaces.push("`");
                }
            }
            result =
                decimalDigits > 0
                    ? withSpaces.reverse().join("") + "." + result.slice(indexOf(result, ".") + 1, result.length)
                    : withSpaces.reverse().join("");
            return (isNegative ? "-" : "") + result;
        }
    }
    getWindowScaling() {
        return window.devicePixelRatio * 100;
    }
    getScaling() {
        if (this.getWindowScaling() < 125) {
            return "";
        }
        else if (125 <= this.getWindowScaling() && this.getWindowScaling() < 150) {
            return "_x1_25";
        }
        else if (150 <= this.getWindowScaling() && this.getWindowScaling() < 175) {
            return "_x1_5";
        }
        else if (175 <= this.getWindowScaling() && this.getWindowScaling() < 200) {
            return "_x1_75";
        }
        else if (200 <= this.getWindowScaling() && this.getWindowScaling() < 300) {
            return "_x2";
        }
        else if (300 <= this.getWindowScaling() && this.getWindowScaling() < 400) {
            return "_x3";
        }
        else if (this.getWindowScaling() > 400) {
            return "_x4";
        }
    }
    getPageFromPoint(x, y) {
        let pageDiv;
        for (let elem of document.elementsFromPoint(x, y)) {
            if (elem?.classList.contains(StiModelService.PAGE_CLASS)) {
                pageDiv = elem;
                break;
            }
        }
        if (pageDiv) {
            for (let page of this.form.pages) {
                if (page.element?.nativeElement == pageDiv) {
                    pageDiv = page;
                    break;
                }
            }
        }
        // let pageDiv = document.elementsFromPoint(x, y).find((elem) => elem?.classList.contains(StiModelService.PAGE_CLASS));
        return pageDiv ? pageDiv : null;
    }
    getPanelFromPoint(x, y, excludeId) {
        let page = this.getPageFromPoint(x, y);
        let panelDivs = document
            .elementsFromPoint(x, y)
            .filter((elem) => elem?.classList.contains(StiModelService.PANEL_CLASS) && elem.id != excludeId);
        return panelDivs && page
            ? page.allElements.find((e) => panelDivs.find((p) => e.guid == p.id))
            : null;
    }
    getMouseOverPagePosition(event) {
        let page = this.getPageFromPoint(event.clientX, event.clientY);
        if (page) {
            let rect = this.getPositionRelativeToForm(page.element.nativeElement);
            return {
                x: event.clientX - (rect.left + page.padding.left * this.zoom),
                y: event.clientY - (rect.top + page.padding.top * this.zoom),
            };
        }
        return null;
    }
    getMouseOverPanelPosition(event, excludeId) {
        let panel = this.getPanelFromPoint(event.clientX, event.clientY, excludeId);
        if (panel) {
            let rect = this.getPositionRelativeToForm(panel.element.nativeElement);
            return { x: event.clientX - rect.left, y: event.clientY - rect.top };
        }
        return null;
    }
    loadAttachedFile() {
        let input = document.createElement("input");
        input.type = "file";
        let this_ = this;
        input.onchange = (_) => {
            let file = Array.from(input.files)[0];
            var reader = new FileReader();
            reader.readAsDataURL(file);
            reader.onload = function () {
                this_.attachedFiles.push(reader.result);
            };
        };
        input.click();
    }
    downloadFiles(data, file_name) {
        let file = new Blob([data]);
        let a = document.createElement("a"), url = URL.createObjectURL(file);
        a.href = url;
        a.download = file_name;
        document.body.appendChild(a);
        a.click();
        setTimeout(function () {
            document.body.removeChild(a);
            window.URL.revokeObjectURL(url);
        }, 0);
    }
}
StiModelService.PAGE_CLASS = "sti-page";
StiModelService.PANEL_CLASS = "sti-panel";
StiModelService.THEMES = ["Light", "Dark"];
StiModelService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiModelService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
StiModelService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiModelService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiModelService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });
//# sourceMappingURL=data:application/json;base64,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