import { Injectable } from "@angular/core";
import { Observable, throwError } from "rxjs";
import { catchError, timeout } from "rxjs/operators";
import { StiLocalizationService } from "./sti-localization.service";
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
import * as i2 from "./model.service";
import * as i3 from "./sti-helper.service";
import * as i4 from "./sti-localization.service";
export class StiHttpClientService {
    constructor(httpClient, model, helper, loc) {
        this.httpClient = httpClient;
        this.model = model;
        this.helper = helper;
        this.loc = loc;
    }
    post(url, data, responseType = "json", options) {
        if (this.model.isWebView) {
            return this.postWebView(data, options);
        }
        else if (this.model.embeddedMode && data?.action == "InterfaceEvent") {
            this.model.embeddedEvent(data);
            return new Observable((observer) => {
                observer.next({});
            });
        }
        else {
            return this.postHttp(url, data, responseType, options);
        }
    }
    loadLocalization(cultureName) {
        this.loc.currentLocalization = this.loc.localizationList.find((item) => item.cultureName == cultureName);
        this.post(this.model.requestUrl, { action: "GetLocalization", localization: cultureName }).subscribe((data) => {
            StiLocalizationService.setLocalization(data.localization);
            this.model.needToRefresh.next(true);
            this.helper.updateHelper();
        });
    }
    postWebView(data, options) {
        let webView = window.chrome.webview.hostObjects.sync.webView;
        let model = this.model;
        model.showProgress = options && options.showProgress === false ? false : true;
        let observer = new Observable((observer) => {
            setTimeout(() => {
                let result = webView.Action(this.getData(data));
                let jsonResult = JSON.parse(result);
                let jsonData = jsonResult.data;
                if (jsonResult.contentType == "application/pdf") {
                    jsonData = atob(jsonData);
                    var len = jsonData.length;
                    var bytes = new Uint8Array(len);
                    for (var i = 0; i < len; i++) {
                        bytes[i] = jsonData.charCodeAt(i);
                    }
                    jsonData = bytes.buffer;
                }
                model.showProgress = false;
                observer.next(jsonData);
            }, 0);
        });
        return observer;
    }
    postHttp(url, data, responseType = "json", options) {
        const reqTimeout = 1000 * 1000;
        const model = this.model;
        model.showProgress = options && options.showProgress === false ? false : true;
        if (responseType === "json") {
            return this.httpClient.post(url, this.getFormData(data)).pipe(
            // retry(3),
            timeout(reqTimeout), catchError((error) => {
                //model.httpError = error;
                model.showProgress = false;
                model.showError(error.error);
                return throwError("Something bad happened; please try again later.");
            }));
        }
        else {
            return this.httpClient.post(url, this.getFormData(data), { responseType: "arraybuffer" }).pipe(
            // retry(3),
            timeout(reqTimeout), catchError((error) => {
                //model.httpError = error;
                model.showProgress = false;
                model.showError(error.error);
                return throwError("Something bad happened; please try again later.");
            }));
        }
    }
    getData(data) {
        if (this.model.properties) {
            data["properties"] = this.model.properties;
        }
        return JSON.stringify(data);
    }
    getFormData(data) {
        const formData = new FormData();
        if (this.model.properties) {
            data["properties"] = this.model.properties;
        }
        formData.append("data", JSON.stringify(data));
        return formData;
    }
    postForm(url, data, doc, postOnlyData = false) {
        if (!doc) {
            doc = document;
        }
        const form = doc.createElement("FORM");
        form.setAttribute("method", "POST");
        form.setAttribute("action", url);
        const params = data;
        Object.keys(params).forEach((key) => {
            const paramsField = doc.createElement("INPUT");
            paramsField.setAttribute("type", "hidden");
            paramsField.setAttribute("name", key);
            paramsField.setAttribute("value", params[key]);
            form.appendChild(paramsField);
        });
        doc.body.appendChild(form);
        form.submit();
        doc.body.removeChild(form);
    }
}
StiHttpClientService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHttpClientService, deps: [{ token: i1.HttpClient }, { token: i2.StiModelService }, { token: i3.StiHelperService }, { token: i4.StiLocalizationService }], target: i0.ɵɵFactoryTarget.Injectable });
StiHttpClientService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHttpClientService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.3.0", ngImport: i0, type: StiHttpClientService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i1.HttpClient }, { type: i2.StiModelService }, { type: i3.StiHelperService }, { type: i4.StiLocalizationService }]; } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaHR0cC1jbGllbnQuc2VydmljZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL3N0aW11bHNvZnQtZm9ybXMvc3JjL2xpYi9zZXJ2aWNlcy9odHRwLWNsaWVudC5zZXJ2aWNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxVQUFVLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFFM0MsT0FBTyxFQUFFLFVBQVUsRUFBRSxVQUFVLEVBQUUsTUFBTSxNQUFNLENBQUM7QUFDOUMsT0FBTyxFQUFFLFVBQVUsRUFBRSxPQUFPLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUdyRCxPQUFPLEVBQUUsc0JBQXNCLEVBQUUsTUFBTSw0QkFBNEIsQ0FBQzs7Ozs7O0FBSXBFLE1BQU0sT0FBTyxvQkFBb0I7SUFDL0IsWUFDVSxVQUFzQixFQUN0QixLQUFzQixFQUN0QixNQUF3QixFQUN4QixHQUEyQjtRQUgzQixlQUFVLEdBQVYsVUFBVSxDQUFZO1FBQ3RCLFVBQUssR0FBTCxLQUFLLENBQWlCO1FBQ3RCLFdBQU0sR0FBTixNQUFNLENBQWtCO1FBQ3hCLFFBQUcsR0FBSCxHQUFHLENBQXdCO0lBQ2xDLENBQUM7SUFFRyxJQUFJLENBQUMsR0FBVyxFQUFFLElBQVMsRUFBRSxlQUF1QixNQUFNLEVBQUUsT0FBYTtRQUM5RSxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxFQUFFO1lBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDeEM7YUFBTSxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxJQUFJLElBQUksRUFBRSxNQUFNLElBQUksZ0JBQWdCLEVBQUU7WUFDdEUsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDL0IsT0FBTyxJQUFJLFVBQVUsQ0FBQyxDQUFDLFFBQVEsRUFBRSxFQUFFO2dCQUNqQyxRQUFRLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDO1lBQ3BCLENBQUMsQ0FBQyxDQUFDO1NBQ0o7YUFBTTtZQUNMLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLEVBQUUsSUFBSSxFQUFFLFlBQVksRUFBRSxPQUFPLENBQUMsQ0FBQztTQUN4RDtJQUNILENBQUM7SUFFTSxnQkFBZ0IsQ0FBQyxXQUFXO1FBQ2pDLElBQUksQ0FBQyxHQUFHLENBQUMsbUJBQW1CLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyxXQUFXLElBQUksV0FBVyxDQUFDLENBQUM7UUFDekcsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsRUFBRSxFQUFFLE1BQU0sRUFBRSxpQkFBaUIsRUFBRSxZQUFZLEVBQUUsV0FBVyxFQUFFLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRTtZQUM1RyxzQkFBc0IsQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFDO1lBQzFELElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUNwQyxJQUFJLENBQUMsTUFBTSxDQUFDLFlBQVksRUFBRSxDQUFDO1FBQzdCLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVNLFdBQVcsQ0FBQyxJQUFTLEVBQUUsT0FBYTtRQUN6QyxJQUFJLE9BQU8sR0FBSSxNQUFjLENBQUMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQztRQUN0RSxJQUFJLEtBQUssR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO1FBQ3ZCLEtBQUssQ0FBQyxZQUFZLEdBQUcsT0FBTyxJQUFJLE9BQU8sQ0FBQyxZQUFZLEtBQUssS0FBSyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQztRQUU5RSxJQUFJLFFBQVEsR0FBRyxJQUFJLFVBQVUsQ0FBQyxDQUFDLFFBQVEsRUFBRSxFQUFFO1lBQ3pDLFVBQVUsQ0FBQyxHQUFHLEVBQUU7Z0JBQ2QsSUFBSSxNQUFNLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7Z0JBQ2hELElBQUksVUFBVSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUM7Z0JBQ3BDLElBQUksUUFBUSxHQUFHLFVBQVUsQ0FBQyxJQUFJLENBQUM7Z0JBQy9CLElBQUksVUFBVSxDQUFDLFdBQVcsSUFBSSxpQkFBaUIsRUFBRTtvQkFDL0MsUUFBUSxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztvQkFDMUIsSUFBSSxHQUFHLEdBQUcsUUFBUSxDQUFDLE1BQU0sQ0FBQztvQkFDMUIsSUFBSSxLQUFLLEdBQUcsSUFBSSxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUM7b0JBQ2hDLEtBQUssSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxHQUFHLEVBQUUsQ0FBQyxFQUFFLEVBQUU7d0JBQzVCLEtBQUssQ0FBQyxDQUFDLENBQUMsR0FBRyxRQUFRLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO3FCQUNuQztvQkFDRCxRQUFRLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztpQkFDekI7Z0JBQ0QsS0FBSyxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7Z0JBQzNCLFFBQVEsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7WUFDMUIsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO1FBQ1IsQ0FBQyxDQUFDLENBQUM7UUFFSCxPQUFPLFFBQVEsQ0FBQztJQUNsQixDQUFDO0lBRU0sUUFBUSxDQUFDLEdBQVcsRUFBRSxJQUFTLEVBQUUsZUFBdUIsTUFBTSxFQUFFLE9BQWE7UUFDbEYsTUFBTSxVQUFVLEdBQUcsSUFBSSxHQUFHLElBQUksQ0FBQztRQUMvQixNQUFNLEtBQUssR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDO1FBQ3pCLEtBQUssQ0FBQyxZQUFZLEdBQUcsT0FBTyxJQUFJLE9BQU8sQ0FBQyxZQUFZLEtBQUssS0FBSyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQztRQUM5RSxJQUFJLFlBQVksS0FBSyxNQUFNLEVBQUU7WUFDM0IsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLElBQUk7WUFDM0QsWUFBWTtZQUNaLE9BQU8sQ0FBQyxVQUFVLENBQUMsRUFFbkIsVUFBVSxDQUFDLENBQUMsS0FBVSxFQUFFLEVBQUU7Z0JBQ3hCLDBCQUEwQjtnQkFDMUIsS0FBSyxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7Z0JBQzNCLEtBQUssQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO2dCQUM3QixPQUFPLFVBQVUsQ0FBQyxpREFBaUQsQ0FBQyxDQUFDO1lBQ3ZFLENBQUMsQ0FBQyxDQUNILENBQUM7U0FDSDthQUFNO1lBQ0wsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsRUFBRSxFQUFFLFlBQVksRUFBRSxhQUFhLEVBQUUsQ0FBQyxDQUFDLElBQUk7WUFDNUYsWUFBWTtZQUNaLE9BQU8sQ0FBQyxVQUFVLENBQUMsRUFDbkIsVUFBVSxDQUFDLENBQUMsS0FBVSxFQUFFLEVBQUU7Z0JBQ3hCLDBCQUEwQjtnQkFDMUIsS0FBSyxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7Z0JBQzNCLEtBQUssQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO2dCQUM3QixPQUFPLFVBQVUsQ0FBQyxpREFBaUQsQ0FBQyxDQUFDO1lBQ3ZFLENBQUMsQ0FBQyxDQUNILENBQUM7U0FDSDtJQUNILENBQUM7SUFFTyxPQUFPLENBQUMsSUFBUztRQUN2QixJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxFQUFFO1lBQ3pCLElBQUksQ0FBQyxZQUFZLENBQUMsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQztTQUM1QztRQUNELE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUM5QixDQUFDO0lBRU8sV0FBVyxDQUFDLElBQVM7UUFDM0IsTUFBTSxRQUFRLEdBQWEsSUFBSSxRQUFRLEVBQUUsQ0FBQztRQUMxQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxFQUFFO1lBQ3pCLElBQUksQ0FBQyxZQUFZLENBQUMsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQztTQUM1QztRQUNELFFBQVEsQ0FBQyxNQUFNLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztRQUM5QyxPQUFPLFFBQVEsQ0FBQztJQUNsQixDQUFDO0lBRU0sUUFBUSxDQUFDLEdBQVcsRUFBRSxJQUFTLEVBQUUsR0FBUSxFQUFFLGVBQXdCLEtBQUs7UUFDN0UsSUFBSSxDQUFDLEdBQUcsRUFBRTtZQUNSLEdBQUcsR0FBRyxRQUFRLENBQUM7U0FDaEI7UUFDRCxNQUFNLElBQUksR0FBRyxHQUFHLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxZQUFZLENBQUMsUUFBUSxFQUFFLE1BQU0sQ0FBQyxDQUFDO1FBQ3BDLElBQUksQ0FBQyxZQUFZLENBQUMsUUFBUSxFQUFFLEdBQUcsQ0FBQyxDQUFDO1FBRWpDLE1BQU0sTUFBTSxHQUFHLElBQUksQ0FBQztRQUVwQixNQUFNLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLE9BQU8sQ0FBQyxDQUFDLEdBQUcsRUFBRSxFQUFFO1lBQ2xDLE1BQU0sV0FBVyxHQUFHLEdBQUcsQ0FBQyxhQUFhLENBQUMsT0FBTyxDQUFDLENBQUM7WUFDL0MsV0FBVyxDQUFDLFlBQVksQ0FBQyxNQUFNLEVBQUUsUUFBUSxDQUFDLENBQUM7WUFDM0MsV0FBVyxDQUFDLFlBQVksQ0FBQyxNQUFNLEVBQUUsR0FBRyxDQUFDLENBQUM7WUFDdEMsV0FBVyxDQUFDLFlBQVksQ0FBQyxPQUFPLEVBQUUsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUM7WUFDL0MsSUFBSSxDQUFDLFdBQVcsQ0FBQyxXQUFXLENBQUMsQ0FBQztRQUNoQyxDQUFDLENBQUMsQ0FBQztRQUVILEdBQUcsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQzNCLElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQztRQUNkLEdBQUcsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQzdCLENBQUM7O2lIQTVIVSxvQkFBb0I7cUhBQXBCLG9CQUFvQjsyRkFBcEIsb0JBQW9CO2tCQURoQyxVQUFVIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSW5qZWN0YWJsZSB9IGZyb20gXCJAYW5ndWxhci9jb3JlXCI7XHJcbmltcG9ydCB7IEh0dHBDbGllbnQgfSBmcm9tIFwiQGFuZ3VsYXIvY29tbW9uL2h0dHBcIjtcclxuaW1wb3J0IHsgT2JzZXJ2YWJsZSwgdGhyb3dFcnJvciB9IGZyb20gXCJyeGpzXCI7XHJcbmltcG9ydCB7IGNhdGNoRXJyb3IsIHRpbWVvdXQgfSBmcm9tIFwicnhqcy9vcGVyYXRvcnNcIjtcclxuaW1wb3J0IHsgU3RpTW9kZWxTZXJ2aWNlIH0gZnJvbSBcIi4vbW9kZWwuc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlCYXJjb2RlU2VydmljZSB9IGZyb20gXCIuL3N0aS1iYXJjb2RlLnNlcnZpY2VcIjtcclxuaW1wb3J0IHsgU3RpTG9jYWxpemF0aW9uU2VydmljZSB9IGZyb20gXCIuL3N0aS1sb2NhbGl6YXRpb24uc2VydmljZVwiO1xyXG5pbXBvcnQgeyBTdGlIZWxwZXJTZXJ2aWNlIH0gZnJvbSBcIi4vc3RpLWhlbHBlci5zZXJ2aWNlXCI7XHJcblxyXG5ASW5qZWN0YWJsZSgpXHJcbmV4cG9ydCBjbGFzcyBTdGlIdHRwQ2xpZW50U2VydmljZSB7XHJcbiAgY29uc3RydWN0b3IoXHJcbiAgICBwcml2YXRlIGh0dHBDbGllbnQ6IEh0dHBDbGllbnQsXHJcbiAgICBwcml2YXRlIG1vZGVsOiBTdGlNb2RlbFNlcnZpY2UsXHJcbiAgICBwcml2YXRlIGhlbHBlcjogU3RpSGVscGVyU2VydmljZSxcclxuICAgIHByaXZhdGUgbG9jOiBTdGlMb2NhbGl6YXRpb25TZXJ2aWNlXHJcbiAgKSB7fVxyXG5cclxuICBwdWJsaWMgcG9zdCh1cmw6IHN0cmluZywgZGF0YTogYW55LCByZXNwb25zZVR5cGU6IHN0cmluZyA9IFwianNvblwiLCBvcHRpb25zPzogYW55KTogT2JzZXJ2YWJsZTxhbnk+IHtcclxuICAgIGlmICh0aGlzLm1vZGVsLmlzV2ViVmlldykge1xyXG4gICAgICByZXR1cm4gdGhpcy5wb3N0V2ViVmlldyhkYXRhLCBvcHRpb25zKTtcclxuICAgIH0gZWxzZSBpZiAodGhpcy5tb2RlbC5lbWJlZGRlZE1vZGUgJiYgZGF0YT8uYWN0aW9uID09IFwiSW50ZXJmYWNlRXZlbnRcIikge1xyXG4gICAgICB0aGlzLm1vZGVsLmVtYmVkZGVkRXZlbnQoZGF0YSk7XHJcbiAgICAgIHJldHVybiBuZXcgT2JzZXJ2YWJsZSgob2JzZXJ2ZXIpID0+IHtcclxuICAgICAgICBvYnNlcnZlci5uZXh0KHt9KTtcclxuICAgICAgfSk7XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICByZXR1cm4gdGhpcy5wb3N0SHR0cCh1cmwsIGRhdGEsIHJlc3BvbnNlVHlwZSwgb3B0aW9ucyk7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwdWJsaWMgbG9hZExvY2FsaXphdGlvbihjdWx0dXJlTmFtZSkge1xyXG4gICAgdGhpcy5sb2MuY3VycmVudExvY2FsaXphdGlvbiA9IHRoaXMubG9jLmxvY2FsaXphdGlvbkxpc3QuZmluZCgoaXRlbSkgPT4gaXRlbS5jdWx0dXJlTmFtZSA9PSBjdWx0dXJlTmFtZSk7XHJcbiAgICB0aGlzLnBvc3QodGhpcy5tb2RlbC5yZXF1ZXN0VXJsLCB7IGFjdGlvbjogXCJHZXRMb2NhbGl6YXRpb25cIiwgbG9jYWxpemF0aW9uOiBjdWx0dXJlTmFtZSB9KS5zdWJzY3JpYmUoKGRhdGEpID0+IHtcclxuICAgICAgU3RpTG9jYWxpemF0aW9uU2VydmljZS5zZXRMb2NhbGl6YXRpb24oZGF0YS5sb2NhbGl6YXRpb24pO1xyXG4gICAgICB0aGlzLm1vZGVsLm5lZWRUb1JlZnJlc2gubmV4dCh0cnVlKTtcclxuICAgICAgdGhpcy5oZWxwZXIudXBkYXRlSGVscGVyKCk7XHJcbiAgICB9KTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBwb3N0V2ViVmlldyhkYXRhOiBhbnksIG9wdGlvbnM/OiBhbnkpOiBPYnNlcnZhYmxlPGFueT4ge1xyXG4gICAgbGV0IHdlYlZpZXcgPSAod2luZG93IGFzIGFueSkuY2hyb21lLndlYnZpZXcuaG9zdE9iamVjdHMuc3luYy53ZWJWaWV3O1xyXG4gICAgbGV0IG1vZGVsID0gdGhpcy5tb2RlbDtcclxuICAgIG1vZGVsLnNob3dQcm9ncmVzcyA9IG9wdGlvbnMgJiYgb3B0aW9ucy5zaG93UHJvZ3Jlc3MgPT09IGZhbHNlID8gZmFsc2UgOiB0cnVlO1xyXG5cclxuICAgIGxldCBvYnNlcnZlciA9IG5ldyBPYnNlcnZhYmxlKChvYnNlcnZlcikgPT4ge1xyXG4gICAgICBzZXRUaW1lb3V0KCgpID0+IHtcclxuICAgICAgICBsZXQgcmVzdWx0ID0gd2ViVmlldy5BY3Rpb24odGhpcy5nZXREYXRhKGRhdGEpKTtcclxuICAgICAgICBsZXQganNvblJlc3VsdCA9IEpTT04ucGFyc2UocmVzdWx0KTtcclxuICAgICAgICBsZXQganNvbkRhdGEgPSBqc29uUmVzdWx0LmRhdGE7XHJcbiAgICAgICAgaWYgKGpzb25SZXN1bHQuY29udGVudFR5cGUgPT0gXCJhcHBsaWNhdGlvbi9wZGZcIikge1xyXG4gICAgICAgICAganNvbkRhdGEgPSBhdG9iKGpzb25EYXRhKTtcclxuICAgICAgICAgIHZhciBsZW4gPSBqc29uRGF0YS5sZW5ndGg7XHJcbiAgICAgICAgICB2YXIgYnl0ZXMgPSBuZXcgVWludDhBcnJheShsZW4pO1xyXG4gICAgICAgICAgZm9yICh2YXIgaSA9IDA7IGkgPCBsZW47IGkrKykge1xyXG4gICAgICAgICAgICBieXRlc1tpXSA9IGpzb25EYXRhLmNoYXJDb2RlQXQoaSk7XHJcbiAgICAgICAgICB9XHJcbiAgICAgICAgICBqc29uRGF0YSA9IGJ5dGVzLmJ1ZmZlcjtcclxuICAgICAgICB9XHJcbiAgICAgICAgbW9kZWwuc2hvd1Byb2dyZXNzID0gZmFsc2U7XHJcbiAgICAgICAgb2JzZXJ2ZXIubmV4dChqc29uRGF0YSk7XHJcbiAgICAgIH0sIDApO1xyXG4gICAgfSk7XHJcblxyXG4gICAgcmV0dXJuIG9ic2VydmVyO1xyXG4gIH1cclxuXHJcbiAgcHVibGljIHBvc3RIdHRwKHVybDogc3RyaW5nLCBkYXRhOiBhbnksIHJlc3BvbnNlVHlwZTogc3RyaW5nID0gXCJqc29uXCIsIG9wdGlvbnM/OiBhbnkpOiBPYnNlcnZhYmxlPGFueT4ge1xyXG4gICAgY29uc3QgcmVxVGltZW91dCA9IDEwMDAgKiAxMDAwO1xyXG4gICAgY29uc3QgbW9kZWwgPSB0aGlzLm1vZGVsO1xyXG4gICAgbW9kZWwuc2hvd1Byb2dyZXNzID0gb3B0aW9ucyAmJiBvcHRpb25zLnNob3dQcm9ncmVzcyA9PT0gZmFsc2UgPyBmYWxzZSA6IHRydWU7XHJcbiAgICBpZiAocmVzcG9uc2VUeXBlID09PSBcImpzb25cIikge1xyXG4gICAgICByZXR1cm4gdGhpcy5odHRwQ2xpZW50LnBvc3QodXJsLCB0aGlzLmdldEZvcm1EYXRhKGRhdGEpKS5waXBlKFxyXG4gICAgICAgIC8vIHJldHJ5KDMpLFxyXG4gICAgICAgIHRpbWVvdXQocmVxVGltZW91dCksXHJcblxyXG4gICAgICAgIGNhdGNoRXJyb3IoKGVycm9yOiBhbnkpID0+IHtcclxuICAgICAgICAgIC8vbW9kZWwuaHR0cEVycm9yID0gZXJyb3I7XHJcbiAgICAgICAgICBtb2RlbC5zaG93UHJvZ3Jlc3MgPSBmYWxzZTtcclxuICAgICAgICAgIG1vZGVsLnNob3dFcnJvcihlcnJvci5lcnJvcik7XHJcbiAgICAgICAgICByZXR1cm4gdGhyb3dFcnJvcihcIlNvbWV0aGluZyBiYWQgaGFwcGVuZWQ7IHBsZWFzZSB0cnkgYWdhaW4gbGF0ZXIuXCIpO1xyXG4gICAgICAgIH0pXHJcbiAgICAgICk7XHJcbiAgICB9IGVsc2Uge1xyXG4gICAgICByZXR1cm4gdGhpcy5odHRwQ2xpZW50LnBvc3QodXJsLCB0aGlzLmdldEZvcm1EYXRhKGRhdGEpLCB7IHJlc3BvbnNlVHlwZTogXCJhcnJheWJ1ZmZlclwiIH0pLnBpcGUoXHJcbiAgICAgICAgLy8gcmV0cnkoMyksXHJcbiAgICAgICAgdGltZW91dChyZXFUaW1lb3V0KSxcclxuICAgICAgICBjYXRjaEVycm9yKChlcnJvcjogYW55KSA9PiB7XHJcbiAgICAgICAgICAvL21vZGVsLmh0dHBFcnJvciA9IGVycm9yO1xyXG4gICAgICAgICAgbW9kZWwuc2hvd1Byb2dyZXNzID0gZmFsc2U7XHJcbiAgICAgICAgICBtb2RlbC5zaG93RXJyb3IoZXJyb3IuZXJyb3IpO1xyXG4gICAgICAgICAgcmV0dXJuIHRocm93RXJyb3IoXCJTb21ldGhpbmcgYmFkIGhhcHBlbmVkOyBwbGVhc2UgdHJ5IGFnYWluIGxhdGVyLlwiKTtcclxuICAgICAgICB9KVxyXG4gICAgICApO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcHJpdmF0ZSBnZXREYXRhKGRhdGE6IGFueSk6IHN0cmluZyB7XHJcbiAgICBpZiAodGhpcy5tb2RlbC5wcm9wZXJ0aWVzKSB7XHJcbiAgICAgIGRhdGFbXCJwcm9wZXJ0aWVzXCJdID0gdGhpcy5tb2RlbC5wcm9wZXJ0aWVzO1xyXG4gICAgfVxyXG4gICAgcmV0dXJuIEpTT04uc3RyaW5naWZ5KGRhdGEpO1xyXG4gIH1cclxuXHJcbiAgcHJpdmF0ZSBnZXRGb3JtRGF0YShkYXRhOiBhbnkpOiBGb3JtRGF0YSB7XHJcbiAgICBjb25zdCBmb3JtRGF0YTogRm9ybURhdGEgPSBuZXcgRm9ybURhdGEoKTtcclxuICAgIGlmICh0aGlzLm1vZGVsLnByb3BlcnRpZXMpIHtcclxuICAgICAgZGF0YVtcInByb3BlcnRpZXNcIl0gPSB0aGlzLm1vZGVsLnByb3BlcnRpZXM7XHJcbiAgICB9XHJcbiAgICBmb3JtRGF0YS5hcHBlbmQoXCJkYXRhXCIsIEpTT04uc3RyaW5naWZ5KGRhdGEpKTtcclxuICAgIHJldHVybiBmb3JtRGF0YTtcclxuICB9XHJcblxyXG4gIHB1YmxpYyBwb3N0Rm9ybSh1cmw6IHN0cmluZywgZGF0YTogYW55LCBkb2M6IGFueSwgcG9zdE9ubHlEYXRhOiBib29sZWFuID0gZmFsc2UpIHtcclxuICAgIGlmICghZG9jKSB7XHJcbiAgICAgIGRvYyA9IGRvY3VtZW50O1xyXG4gICAgfVxyXG4gICAgY29uc3QgZm9ybSA9IGRvYy5jcmVhdGVFbGVtZW50KFwiRk9STVwiKTtcclxuICAgIGZvcm0uc2V0QXR0cmlidXRlKFwibWV0aG9kXCIsIFwiUE9TVFwiKTtcclxuICAgIGZvcm0uc2V0QXR0cmlidXRlKFwiYWN0aW9uXCIsIHVybCk7XHJcblxyXG4gICAgY29uc3QgcGFyYW1zID0gZGF0YTtcclxuXHJcbiAgICBPYmplY3Qua2V5cyhwYXJhbXMpLmZvckVhY2goKGtleSkgPT4ge1xyXG4gICAgICBjb25zdCBwYXJhbXNGaWVsZCA9IGRvYy5jcmVhdGVFbGVtZW50KFwiSU5QVVRcIik7XHJcbiAgICAgIHBhcmFtc0ZpZWxkLnNldEF0dHJpYnV0ZShcInR5cGVcIiwgXCJoaWRkZW5cIik7XHJcbiAgICAgIHBhcmFtc0ZpZWxkLnNldEF0dHJpYnV0ZShcIm5hbWVcIiwga2V5KTtcclxuICAgICAgcGFyYW1zRmllbGQuc2V0QXR0cmlidXRlKFwidmFsdWVcIiwgcGFyYW1zW2tleV0pO1xyXG4gICAgICBmb3JtLmFwcGVuZENoaWxkKHBhcmFtc0ZpZWxkKTtcclxuICAgIH0pO1xyXG5cclxuICAgIGRvYy5ib2R5LmFwcGVuZENoaWxkKGZvcm0pO1xyXG4gICAgZm9ybS5zdWJtaXQoKTtcclxuICAgIGRvYy5ib2R5LnJlbW92ZUNoaWxkKGZvcm0pO1xyXG4gIH1cclxufVxyXG4iXX0=